//
//  MPNotification.h
//  MPServices
//
//  Created by Oleksii Dykan on 4/25/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSString *kMPNotificationTypeLink;

extern NSString *kMPNotificationUserInfoKeyType;
extern NSString *kMPNotificationUserInfoKeyValue;
extern NSString *kMPNotificationUserInfoKeyId;

typedef NS_ENUM(NSUInteger, MPNotificationStatus) {
    MPNotificationStatusUknkown = 0,
    MPNotificationStatusDelivered = 254,
    MPNotificationStatusRead = 255,
};

@interface MPNotification : NSObject

@property (readonly, nonatomic, assign) MPNotificationStatus status;
@property (readonly, nonatomic, copy) NSString *idStr;
@property (readonly, nonatomic, copy) NSString *type;
@property (readonly, nonatomic, copy) NSString *value;
@property (readonly, nonatomic, copy) NSString *message;
@property (readonly, nonatomic, copy) NSString *sound;

+ (id)notificationWithUserNotification:(NSUserNotification *)notification status:(MPNotificationStatus)status;
- (id)initWithUserNotification:(NSUserNotification *)notification status:(MPNotificationStatus)status;

@end
