//
//  MPFFPLaunchScreenController.h
//  FXPhotoStudioMac
//
//  Created by chemersky on 3/1/16.
//

#import <Cocoa/Cocoa.h>


extern NSString *kShowLaunchScreenKey;


@interface MPLaunchScreenController : NSWindowController

/*!
 * @brief text for "Get More..." textField
 */
@property (copy, nonatomic) NSString *textGetMore;

/*!
 * @brief text for description
 */
@property (copy, nonatomic) NSString *textDescription;

/*!
 * @brief text for "+ n more..." textField
 */
@property (copy, nonatomic) NSString *textPlusMore;

/*!
 * @brief error color for textFields
 */
@property (strong, nonatomic) NSColor *errorColor;

/*!
 * @brief text for sign up result's title
 */
@property (copy, nonatomic) NSString *signUpResultTitle;

/*!
 * @brief text for sign up result's description
 */
@property (copy, nonatomic) NSString *signUpResultDesc;

/*!
 * @brief flag that determines presence of email confirmation
 */
@property (assign, nonatomic) BOOL confirmationEnabled;

/*!
 * @brief application identifier for sign up handling
 */
@property (copy, nonatomic) NSString *paramAppId;

@end
