//
//  MPIAPHelper.h
//  In App Rage
//
//  Created by Dmitry Gaponenko on 9/5/12.
//  Copyright (c) 2015 Macphun LLC. All rights reserved.
//

#import <StoreKit/StoreKit.h>

extern NSString *const MPIAPHelperProductPurchasedNotification;
extern NSString *const MPIAPHelperProductFailPurchaseNotification;

typedef void (^RequestProductsCompletionHandler)(BOOL success, NSArray * products);

@interface MPIAPHelper : NSObject

+ (instancetype)sharedIAPHelper;
- (id)initWithProductIdentifiers:(NSSet *)productIdentifiers;
- (void)requestProductsWithCompletionHandler:(RequestProductsCompletionHandler)completionHandler;
- (void)buyProduct:(SKProduct *)product;
- (BOOL)productPurchased:(NSString *)productIdentifier;
- (void)restoreCompletedTransactions;

@end