//
//  MPBatchProcessingController.h
//  Phoenix
//
//  Created by Oleksii Dykan on 5/19/15.
//  Copyright (c) 2015 MacPhun LLC. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MPBatchProcessing.h"

@class MPBatchOptions;

typedef void(^MPBatchProcessingCompletionBlock)(BOOL success);
typedef void(^MPBatchProcessingStartBlock)(NSString *originalImagePath, NSString *destImagePath);
typedef void(^MPBatchProcessingEndBlock)(NSURL *imageUrl, NSInteger index, BOOL success, NSError *error, BOOL *stop);
typedef void(^MPBatchThumbnailCallback)(NSImage *thumbnail);

FOUNDATION_EXPORT NSString *const kMPBatchErrorDomain;

typedef NS_ENUM(NSUInteger, MPBatchErrorCode) {
    MPBatchErrorCodeInvalidExportPath = 1,
    MPBatchErrorCodeInvalidOriginalImagePath = 2,
};

@interface MPBatchProcessingController : NSObject

@property (nonatomic, strong) MPBatchOptions *batchOptions;
@property (nonatomic, copy) NSArray *imageUrls;
@property (nonatomic, copy) MPBatchImageProcessBlock imageProcessBlock;
@property (nonatomic, copy) void (^cancelProcessBlock) ();

- (void)cancelProcessing;
- (void)getThumbnailForImageWithUrl:(NSURL *)imageUrl imageSize:(NSSize)imageSize originalThumbnailHandler:(MPBatchThumbnailCallback)originalThumbnailHandler completionHandler:(MPBatchThumbnailCallback)completionHandler;
- (void)cancelThumbnailGenerationForUrl:(NSURL *)imageUrl;
- (void)cancelAllThumbnailsGeneration;
- (void)processImagesWithImageStartProcessBlock:(MPBatchProcessingStartBlock)startProcessBlock
                           imageEndProcessBlock:(MPBatchProcessingEndBlock)endProcessBlock
                              completionHandler:(MPBatchProcessingCompletionBlock)completionHandler;

- (NSSize)sizeForImageSource:(CGImageSourceRef)imageSource;

@end

#ifdef MPBatchProcessingController_Protected

@interface MPBatchProcessingController ()

@property (nonatomic, strong) NSMutableArray *thumbnailsInProgress;
@property (nonatomic, assign) BOOL canceled;

- (NSString *)exportPathForImageWithUrl:(NSURL *)sourceImageUrl imageIndex:(NSInteger)imageIndex overwriteBlock:(NSInteger(^)(NSString *imageName))overwriteBlock;
- (NSDictionary *)newImagePropertiesFromInfo:(NSDictionary *)properties;
- (NSSize)newSizeWithForImageSource:(CGImageSourceRef)imageSource;
- (BOOL)canWriteToFolderFile:(NSURL *)imageUrl error:(NSError **)error;
- (NSError *)savingError;
- (NSError *)imageReadingError;
+ (dispatch_queue_t)processQueue;

@end

#endif