//
//  MPBatchOptionsViewController.h
//  Phoenix
//
//  Created by Oleksii Dykan on 5/29/15.
//  Copyright (c) 2015 MacPhun LLC. All rights reserved.
//

#import "MPServices.h"


@class MPBatchOptions;

extern NSString *const MPBOLastUsedPresetName;
extern NSString *const kMPBatchOptionsPresetExtension;

@protocol MPSBatchOptionsViewDelegate <NSObject>

- (void)viewDidMoveToWindow;

@end


typedef void(^MPBatchOptionsCancelCallback)(void);
typedef void(^MPBatchOptionsStartCallback)(MPBatchOptions *options);


@interface MPBatchOptionsViewController : NSViewController <MPSBatchOptionsViewDelegate, MPBatchSettingsControllerDelegate>

@property (nonatomic, weak) IBOutlet MPAbstractButton *startButton;

@property (nonatomic, copy) MPBatchOptionsCancelCallback cancelCallback;
@property (nonatomic, copy) MPBatchOptionsStartCallback startCallback;
@property (nonatomic, assign) NSSize defaultImageSize;

@property (nonatomic, copy) NSString *originalFileName;
@property (nonatomic, copy) MPAbstractBatchSettingsController *settingsController;
@property (nonatomic, assign) BOOL needsColorSpace;

@property (assign, nonatomic) BOOL skipFormatterInitForDimensionFields;

@end


@interface MPBatchOptionsViewController (Protected) <NSTextFieldDelegate>

- (void)adjustUI;
- (void)loadBatchingOptionsPresets;
- (MPBatchOptions *)newBatchOptions;
- (NSString *)presetsFolderPath;
- (void)createPresetWithName:(NSString *)name;
- (void)saveBatchOptionsPreset:(MPBatchOptions *)bathOption;
- (MPBatchOptions *)lastUsedPreset;
- (void)updateLastUsedPreset;

- (IBAction)jpegCompressionChanged:(NSSlider *)sender;
- (IBAction)chooseFolderButtonPressed:(id)sender;
- (IBAction)sizeToFitChanged:(MPSPopUpButton *)sender;
- (IBAction)startButtonPressed:(id)sender;

- (NSArray *)saveTypes;
- (NSArray *)readableSaveTypes;

@end


@interface MPSBatchOptionsView : MPAbstractBackgroundView

@property (nonatomic, weak) IBOutlet id<MPSBatchOptionsViewDelegate> optionsDelegate;

@end
