//
//  MPAnalytics.h
//  MPServices
//
//  Created by Kirill Kovalenko on 22.12.15.
//  Copyright © 2015 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>


typedef NS_ENUM(NSUInteger, MPAppActivationStatus) {
    MPAppActivationStatusUndef,
    MPAppActivationStatusActivated,
    MPAppActivationStatusTrial,
};


@interface MPAnalytics : NSObject

@property (nonatomic, copy, readonly) NSArray *scope;
@property (class, nonatomic, strong) NSString *appVersion;

+ (void)logEvents:(BOOL)logEvents;
+ (void)setAppActivationStatus:(MPAppActivationStatus)appActivationStatus;
+ (void)analyticsScope:(NSArray *)scope;
+ (void)trackEventWithUserInfo:(NSDictionary *)userInfo;
+ (void)trackEventOnScreen:(NSString*)screen category:(NSString*)category action:(NSString*)action label:(NSString*)label value:(NSNumber*)value;

@end
