//
//  MPActivationWindowController.h
//  FXPhotoStudioMac
//
//  Created by Demon  on 5/19/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

extern NSString *const kActivationResult;

typedef enum MPSActivationStyle
{
    MPSActivationStyleWelcome,
    MPSActivationStyleExport,
    MPSActivationStyleActivate
} MPSActivationStyle;


@class MPAbstractButton, MPLocalizedTextField;

@protocol MPActivationWindowControllerDelegate;

@interface MPActivationWindowController : NSWindowController <NSTextFieldDelegate, NSTextViewDelegate>
{
	NSString *_currentActivationKey;
	NSUInteger _validationKeyCountErrors;
}

@property (nonatomic, weak) IBOutlet MPLocalizedTextField *activationCodeTextField;
@property (nonatomic, weak) IBOutlet MPLocalizedTextField *emailTextField;
@property (nonatomic, weak) IBOutlet MPAbstractButton *tryItButton;
@property (nonatomic, weak) IBOutlet MPAbstractButton *activateButton;

@property (nonatomic, weak) IBOutlet MPAbstractButton *activationPopUp;
@property (nonatomic, weak) IBOutlet NSImageView *aboutLogo;


@property (nonatomic, assign) id <MPActivationWindowControllerDelegate> delegate;
@property (nonatomic ,copy) NSString* currentActivationKey;

@property (nonatomic, assign) BOOL demoVersion;

@property (nonatomic, copy) NSString *demoWelcomeDescriptionStr1;
@property (nonatomic, copy) NSString *demoWelcomeDescriptionStr2;
@property (nonatomic, assign) NSUInteger trialDays;

- (instancetype)initWithStyle:(MPSActivationStyle)style;

- (IBAction)doneActivationButtonClick:(id)sender;
- (IBAction)tryTrialVersion:(id)sender;
- (IBAction)clickToBuyButtonClick:(id)sender;
- (IBAction)activateButtonClick:(MPAbstractButton *)sender;
- (IBAction)closeActivateWindow:(id)sender;
- (IBAction)closeWindow:(id)sender;
- (IBAction)openMacphunSite:(id)sender;

- (void)successfullyValidated;

@end

@protocol MPActivationWindowControllerDelegate

- (NSInteger)closeActivationWindowControllerForActivationKey:(NSString*)activationKey userName:(NSString*)name email:(NSString*)email;
- (BOOL)activationWindowControllerShouldShowWelcomeScreen;

@end
