/* Generated by re2c 0.13.5 */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) Zend Technologies Ltd. (http://www.zend.com)           |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@php.net>                                 |
   |          Zeev Suraski <zeev@php.net>                                 |
   +----------------------------------------------------------------------+
*/

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef ZEND_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16
#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#include <stdarg.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
ZEND_API size_t language_scanner_globals_offset;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x80)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(extra_fn_flags) = 0;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
	SCNG(on_event) = NULL;
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename();
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->on_event = SCNG(on_event);
	lex_state->on_event_context = SCNG(on_event_context);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	SCNG(on_event) = lex_state->on_event;
	SCNG(on_event_context) = lex_state->on_event_context;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

ZEND_API void zend_lex_tstring(zval *zv)
{
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_FEEDBACK, T_STRING, 0, SCNG(on_event_context));
	}

	ZVAL_STRINGL(zv, (char*)SCNG(yy_text), SCNG(yy_leng));
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while ((size_t)(pos1 - pos2) >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle)
{
	char *buf;
	size_t size, offset = 0;
	zend_string *compiled_filename;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == (size_t)-1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != (size_t)-1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, (unsigned int)size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		compiled_filename = zend_string_copy(file_handle->opened_path);
	} else {
		compiled_filename = zend_string_init(file_handle->filename, strlen(file_handle->filename), 0);
	}

	zend_set_compiled_filename(compiled_filename);
	zend_string_release_ex(compiled_filename, 0);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	RESET_DOC_COMMENT();
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()

static zend_op_array *zend_compile(int type)
{
	zend_op_array *op_array = NULL;
	zend_bool original_in_compilation = CG(in_compilation);

	CG(in_compilation) = 1;
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);

	if (!zendparse()) {
		int last_lineno = CG(zend_lineno);
		zend_file_context original_file_context;
		zend_oparray_context original_oparray_context;
		zend_op_array *original_active_op_array = CG(active_op_array);

		op_array = emalloc(sizeof(zend_op_array));
		init_op_array(op_array, type, INITIAL_OP_ARRAY_SIZE);
		CG(active_op_array) = op_array;

		/* Use heap to not waste arena memory */
		op_array->fn_flags |= ZEND_ACC_HEAP_RT_CACHE;

		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}

		zend_file_context_begin(&original_file_context);
		zend_oparray_context_begin(&original_oparray_context);
		zend_compile_top_stmt(CG(ast));
		CG(zend_lineno) = last_lineno;
		zend_emit_final_return(type == ZEND_USER_FUNCTION);
		op_array->line_start = 1;
		op_array->line_end = last_lineno;
		pass_two(op_array);
		zend_oparray_context_end(&original_oparray_context);
		zend_file_context_end(&original_file_context);

		CG(active_op_array) = original_active_op_array;
	}

	zend_ast_destroy(CG(ast));
	zend_arena_destroy(CG(ast_arena));

	CG(in_compilation) = original_in_compilation;

	return op_array;
}

ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename);
		}
	} else {
		op_array = zend_compile(ZEND_USER_FUNCTION);
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}


zend_op_array *compile_filename(int type, zval *filename)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	zend_string *opened_path = NULL;

	if (Z_TYPE_P(filename) != IS_STRING) {
		ZVAL_STR(&tmp, zval_get_string(filename));
		filename = &tmp;
	}
	file_handle.filename = Z_STRVAL_P(filename);
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = zend_string_copy(Z_STR_P(filename));
		}

		zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path);

		if (opened_path) {
			zend_string_release_ex(opened_path, 0);
		}
	}
	zend_destroy_file_handle(&file_handle);

	if (UNEXPECTED(filename == &tmp)) {
		zval_ptr_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename)
{
	char *buf;
	size_t size, old_len;
	zend_string *new_compiled_filename;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_extend(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, (unsigned int)size);

	new_compiled_filename = zend_string_init(filename, strlen(filename), 0);
	zend_set_compiled_filename(new_compiled_filename);
	zend_string_release_ex(new_compiled_filename, 0);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}

zend_op_array *compile_string(zval *source_string, char *filename)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;

	if (UNEXPECTED(Z_TYPE_P(source_string) != IS_STRING)) {
		ZVAL_STR(&tmp, zval_get_string_func(source_string));
	} else {
		ZVAL_COPY(&tmp, source_string);
	}

	if (Z_STRLEN(tmp)==0) {
		zval_ptr_dtor(&tmp);
		return NULL;
	}

	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(&tmp, filename) == SUCCESS) {
		BEGIN(ST_IN_SCRIPTING);
		op_array = zend_compile(ZEND_EVAL_CODE);
	}

	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&tmp);

	return op_array;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name)
{
	zend_lex_state original_lex_state;
	zval tmp;

	if (UNEXPECTED(Z_TYPE_P(str) != IS_STRING)) {
		ZVAL_STR(&tmp, zval_get_string_func(str));
		str = &tmp;
	}
	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(str, str_name)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state);
		if (UNEXPECTED(str == &tmp)) {
			zval_ptr_dtor(&tmp);
		}
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	if (UNEXPECTED(str == &tmp)) {
		zval_ptr_dtor(&tmp);
	}
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else if (yyleng == 1) { \
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext))); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static int zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	if (len <= 1) {
		if (len < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*str;
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					break;
				case 'r':
					*t++ = '\r';
					break;
				case 't':
					*t++ = '\t';
					break;
				case 'f':
					*t++ = '\f';
					break;
				case 'v':
					*t++ = '\v';
					break;
				case 'e':
#ifdef ZEND_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						hex_buf[0] = *(++s);
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						zend_bool valid = 1;
						unsigned long codepoint;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence: Codepoint too large", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
							}
						}
						if (octal_buf[2] &&
						    (octal_buf[0] > '3')) {
							/* 3 octit values must not overflow 0xFF (\377) */
							zend_error(E_COMPILE_WARNING, "Octal escape sequence overflow \\%s is greater than \\377", octal_buf);
						}

						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
	return SUCCESS;
}

#define HEREDOC_USING_SPACES 1
#define HEREDOC_USING_TABS 2

static const char *next_newline(const char *str, const char *end, size_t *newline_len) {
	for (; str < end; str++) {
		if (*str == '\r') {
			*newline_len = str + 1 < end && *(str + 1) == '\n' ? 2 : 1;
		} else if (*str == '\n') {
			*newline_len = 1;
			return str;
		}
	}
	*newline_len = 0;
	return NULL;
}

static zend_bool strip_multiline_string_indentation(
	zval *zendlval, int indentation, zend_bool using_spaces,
	zend_bool newline_at_start, zend_bool newline_at_end)
{
	const char *str = Z_STRVAL_P(zendlval), *end = str + Z_STRLEN_P(zendlval);
	char *copy = Z_STRVAL_P(zendlval);

	int newline_count = 0;
	size_t newline_len;
	const char *nl;

	if (!newline_at_start) {
		nl = next_newline(str, end, &newline_len);
		if (!nl) {
			return 1;
		}

		str = nl + newline_len;
		copy = (char *) nl + newline_len;
		newline_count++;
	} else {
		nl = str;
	}

	/* <= intentional */
	while (str <= end && nl) {
		size_t skip;
		nl = next_newline(str, end, &newline_len);
		if (!nl && newline_at_end) {
			nl = end;
		}

		/* Try to skip indentation */
		for (skip = 0; skip < indentation; skip++, str++) {
			if (str == nl) {
				/* Don't require full indentation on whitespace-only lines */
				break;
			}

			if (str == end || (*str != ' ' && *str != '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception_ex(zend_ce_parse_error, 0,
					"Invalid body indentation level (expecting an indentation level of at least %d)", indentation);
				goto error;
			}

			if ((!using_spaces && *str == ' ') || (using_spaces && *str == '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception(zend_ce_parse_error,
					"Invalid indentation - tabs and spaces cannot be mixed", 0);
				goto error;
			}
		}

		if (str == end) {
			break;
		}

		size_t len = nl ? (nl - str + newline_len) : (end - str);
		memmove(copy, str, len);
		str += len;
		copy += len;
		newline_count++;
	}

	*copy = '\0';
	Z_STRLEN_P(zendlval) = copy - Z_STRVAL_P(zendlval);
	return 1;

error:
	zval_ptr_dtor_str(zendlval);
	ZVAL_UNDEF(zendlval);

	return 0;
}

static void copy_heredoc_label_stack(void *void_heredoc_label)
{
	zend_heredoc_label *heredoc_label = void_heredoc_label;
	zend_heredoc_label *new_heredoc_label = emalloc(sizeof(zend_heredoc_label));

	*new_heredoc_label = *heredoc_label;
	new_heredoc_label->label = estrndup(heredoc_label->label, heredoc_label->length);

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) new_heredoc_label);
}

#define PARSER_MODE() \
	EXPECTED(elem != NULL)

#define RETURN_TOKEN(_token) do { \
		token = _token; \
		goto emit_token; \
	} while (0)

#define RETURN_TOKEN_WITH_VAL(_token) do { \
		token = _token; \
		goto emit_token_with_val; \
	} while (0)

#define RETURN_TOKEN_WITH_STR(_token, _offset) do { \
		token = _token; \
		offset = _offset; \
		goto emit_token_with_str; \
	} while (0)

#define SKIP_TOKEN(_token) do { \
		token = _token; \
		goto skip_token; \
	} while (0)

int ZEND_FASTCALL lex_scan(zval *zendlval, zend_parser_stack_elem *elem)
{
int token;
int offset;
int start_line = CG(zend_lineno);

	ZVAL_UNDEF(zendlval);
restart:
	SCNG(yy_text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 7) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				goto yyc_ST_VAR_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 8) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 9) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_INITIAL:

	YYDEBUG(0, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych != '<') goto yy4;
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '?') goto yy5;
yy3:
	YYDEBUG(3, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */

				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*yytext));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_VAL(T_INLINE_HTML);
}
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy5:
	YYDEBUG(5, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy7;
	} else {
		if (yych <= 'P') goto yy9;
		if (yych == 'p') goto yy9;
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		if (PARSER_MODE()) {
			SKIP_TOKEN(T_OPEN_TAG);
		}
		RETURN_TOKEN(T_OPEN_TAG);
	} else {
		goto inline_char_handler;
	}
}
yy7:
	YYDEBUG(7, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(8, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	if (PARSER_MODE()) {
		RETURN_TOKEN(T_ECHO);
	}
	RETURN_TOKEN(T_OPEN_TAG_WITH_ECHO);
}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy11;
	if (yych == 'h') goto yy11;
yy10:
	YYDEBUG(10, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy6;
yy11:
	YYDEBUG(11, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy12;
	if (yych != 'p') goto yy10;
yy12:
	YYDEBUG(12, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy10;
		if (yych >= '\v') goto yy10;
	} else {
		if (yych <= '\r') goto yy15;
		if (yych != ' ') goto yy10;
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	++YYCURSOR;
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	if (PARSER_MODE()) {
		SKIP_TOKEN(T_OPEN_TAG);
	}
	RETURN_TOKEN(T_OPEN_TAG);
}
yy15:
	YYDEBUG(15, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '\n') goto yy13;
	goto yy14;
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(16, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych != '$') goto yy23;
		} else {
			if (yych <= '`') goto yy21;
			if (yych == '{') goto yy20;
			goto yy23;
		}
		YYDEBUG(18, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy19;
			if (yych <= 'Z') goto yy26;
			if (yych >= '_') goto yy26;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy26;
			} else {
				if (yych <= '{') goto yy29;
				if (yych >= 0x80) goto yy26;
			}
		}
yy19:
		YYDEBUG(19, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '`') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy24;
		goto yy19;
yy21:
		YYDEBUG(21, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(22, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('`');
}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy19;
yy24:
		YYDEBUG(24, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(25, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy26:
		YYDEBUG(26, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(27, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy26;
		}
		if (yych == '-') goto yy31;
		if (yych == '[') goto yy33;
yy28:
		YYDEBUG(28, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy29:
		YYDEBUG(29, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(30, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy31:
		YYDEBUG(31, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy35;
yy32:
		YYDEBUG(32, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy28;
yy33:
		YYDEBUG(33, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(34, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy32;
			if (yych <= 'Z') goto yy36;
			if (yych <= '^') goto yy32;
		} else {
			if (yych <= '`') goto yy32;
			if (yych <= 'z') goto yy36;
			if (yych <= 0x7F) goto yy32;
		}
yy36:
		YYDEBUG(36, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(37, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(38, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy43;
			goto yy45;
		} else {
			if (yych <= '$') goto yy40;
			if (yych == '{') goto yy42;
			goto yy45;
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy41;
			if (yych <= 'Z') goto yy48;
			if (yych >= '_') goto yy48;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy48;
			} else {
				if (yych <= '{') goto yy51;
				if (yych >= 0x80) goto yy48;
			}
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '"') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy46;
		goto yy41;
yy43:
		YYDEBUG(43, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(44, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('"');
}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy41;
yy46:
		YYDEBUG(46, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(47, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(49, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy48;
		}
		if (yych == '-') goto yy53;
		if (yych == '[') goto yy55;
yy50:
		YYDEBUG(50, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy51:
		YYDEBUG(51, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(52, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy57;
yy54:
		YYDEBUG(54, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy50;
yy55:
		YYDEBUG(55, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(56, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy57:
		YYDEBUG(57, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy54;
			if (yych <= 'Z') goto yy58;
			if (yych <= '^') goto yy54;
		} else {
			if (yych <= '`') goto yy54;
			if (yych <= 'z') goto yy58;
			if (yych <= 0x7F) goto yy54;
		}
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(59, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(60, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(62, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(63, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	yyleng = heredoc_label->indentation + heredoc_label->length;
	YYCURSOR += yyleng - 1;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_END_HEREDOC);
}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(64, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy66;
		if (yych == '{') goto yy68;
		goto yy69;
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy67;
			if (yych <= 'Z') goto yy72;
			if (yych >= '_') goto yy72;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy72;
			} else {
				if (yych <= '{') goto yy75;
				if (yych >= 0x80) goto yy72;
			}
		}
yy67:
		YYDEBUG(67, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = 0;

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_START(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					if (SCNG(heredoc_scan_ahead)) {
						SCNG(heredoc_indentation) = indentation;
						SCNG(heredoc_indentation_uses_spaces) = (spacing == HEREDOC_USING_SPACES);
					} else {
						YYCURSOR -= indentation;
					}

					BEGIN(ST_END_HEREDOC);

					goto heredoc_scan_done;
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:

	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!SCNG(heredoc_scan_ahead) && !EG(exception) && PARSER_MODE()) {
		zend_bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		zend_string *copy = Z_STR_P(zendlval);

		if (!strip_multiline_string_indentation(
				zendlval, heredoc_label->indentation, heredoc_label->indentation_uses_spaces,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}

		if (UNEXPECTED(zend_scan_escape_string(zendlval, ZSTR_VAL(copy), ZSTR_LEN(copy), 0) != SUCCESS)) {
			zend_string_efree(copy);
			RETURN_TOKEN(T_ERROR);
		}

		zend_string_efree(copy);
	} else {
		HANDLE_NEWLINES(yytext, yyleng - newline);
	}

	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy68:
		YYDEBUG(68, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy70;
		goto yy67;
yy69:
		YYDEBUG(69, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy67;
yy70:
		YYDEBUG(70, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(71, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy72:
		YYDEBUG(72, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(73, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy72;
		}
		if (yych == '-') goto yy77;
		if (yych == '[') goto yy79;
yy74:
		YYDEBUG(74, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy75:
		YYDEBUG(75, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(76, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy77:
		YYDEBUG(77, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy81;
yy78:
		YYDEBUG(78, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy74;
yy79:
		YYDEBUG(79, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(80, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy81:
		YYDEBUG(81, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy78;
			if (yych <= 'Z') goto yy82;
			if (yych <= '^') goto yy78;
		} else {
			if (yych <= '`') goto yy78;
			if (yych <= 'z') goto yy82;
			if (yych <= 0x7F) goto yy78;
		}
yy82:
		YYDEBUG(82, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(83, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 192,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			192,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 60,  60,  44,  44,  44,  44,  44,  44, 
			 44,  44,   0,   0,   0,   0,   0,   0, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   4, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   0, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
		};
		YYDEBUG(84, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\v':
		case '\f':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:
		case 0x7F:	goto yy147;
		case '\t':
		case '\n':
		case '\r':
		case ' ':	goto yy103;
		case '!':	goto yy118;
		case '"':	goto yy143;
		case '#':	goto yy139;
		case '$':	goto yy129;
		case '%':	goto yy123;
		case '&':	goto yy124;
		case '\'':	goto yy141;
		case '(':	goto yy112;
		case ')':
		case ',':
		case ';':
		case '@':
		case '[':
		case ']':
		case '~':	goto yy130;
		case '*':	goto yy121;
		case '+':	goto yy117;
		case '-':	goto yy101;
		case '.':	goto yy108;
		case '/':	goto yy122;
		case '0':	goto yy135;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy137;
		case ':':	goto yy105;
		case '<':	goto yy119;
		case '=':	goto yy115;
		case '>':	goto yy120;
		case '?':	goto yy109;
		case 'A':
		case 'a':	goto yy96;
		case 'B':
		case 'b':	goto yy98;
		case 'C':
		case 'c':	goto yy90;
		case 'D':
		case 'd':	goto yy88;
		case 'E':
		case 'e':	goto yy86;
		case 'F':
		case 'f':	goto yy89;
		case 'G':
		case 'g':	goto yy99;
		case 'I':
		case 'i':	goto yy94;
		case 'L':
		case 'l':	goto yy116;
		case 'N':
		case 'n':	goto yy110;
		case 'O':
		case 'o':	goto yy127;
		case 'P':
		case 'p':	goto yy100;
		case 'R':
		case 'r':	goto yy91;
		case 'S':
		case 's':	goto yy97;
		case 'T':
		case 't':	goto yy93;
		case 'U':
		case 'u':	goto yy113;
		case 'V':
		case 'v':	goto yy111;
		case 'W':
		case 'w':	goto yy95;
		case 'X':
		case 'x':	goto yy128;
		case 'Y':
		case 'y':	goto yy92;
		case '\\':	goto yy106;
		case '^':	goto yy126;
		case '_':	goto yy114;
		case '`':	goto yy145;
		case '{':	goto yy131;
		case '|':	goto yy125;
		case '}':	goto yy133;
		default:	goto yy138;
		}
yy86:
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(-1, yych);
		switch ((yych = *YYCURSOR)) {
		case 'C':
		case 'c':	goto yy709;
		case 'L':
		case 'l':	goto yy710;
		case 'M':
		case 'm':	goto yy711;
		case 'N':
		case 'n':	goto yy712;
		case 'V':
		case 'v':	goto yy713;
		case 'X':
		case 'x':	goto yy714;
		default:	goto yy150;
		}
yy87:
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy88:
		YYDEBUG(88, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy691;
				goto yy150;
			} else {
				if (yych <= 'I') goto yy692;
				if (yych <= 'N') goto yy150;
				goto yy693;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy691;
				goto yy150;
			} else {
				if (yych <= 'i') goto yy692;
				if (yych == 'o') goto yy693;
				goto yy150;
			}
		}
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych <= 'M') {
				if (yych == 'I') goto yy665;
				goto yy150;
			} else {
				if (yych <= 'N') goto yy666;
				if (yych <= 'O') goto yy668;
				if (yych <= 'T') goto yy150;
				goto yy669;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy665;
				if (yych <= 'm') goto yy150;
				goto yy666;
			} else {
				if (yych <= 'o') goto yy668;
				if (yych == 'u') goto yy669;
				goto yy150;
			}
		}
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy630;
				goto yy150;
			} else {
				if (yych <= 'L') goto yy631;
				if (yych <= 'N') goto yy150;
				goto yy632;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy630;
				goto yy150;
			} else {
				if (yych <= 'l') goto yy631;
				if (yych == 'o') goto yy632;
				goto yy150;
			}
		}
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy612;
		if (yych == 'e') goto yy612;
		goto yy150;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy599;
		if (yych == 'i') goto yy599;
		goto yy150;
yy93:
		YYDEBUG(93, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'R') {
			if (yych == 'H') goto yy587;
			if (yych <= 'Q') goto yy150;
			goto yy588;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy150;
				goto yy587;
			} else {
				if (yych == 'r') goto yy588;
				goto yy150;
			}
		}
yy94:
		YYDEBUG(94, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy534;
				goto yy150;
			} else {
				if (yych <= 'M') goto yy536;
				if (yych <= 'N') goto yy537;
				if (yych <= 'R') goto yy150;
				goto yy538;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy534;
				if (yych <= 'l') goto yy150;
				goto yy536;
			} else {
				if (yych <= 'n') goto yy537;
				if (yych == 's') goto yy538;
				goto yy150;
			}
		}
yy95:
		YYDEBUG(95, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy529;
		if (yych == 'h') goto yy529;
		goto yy150;
yy96:
		YYDEBUG(96, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy511;
				goto yy150;
			} else {
				if (yych <= 'N') goto yy512;
				if (yych <= 'Q') goto yy150;
				if (yych <= 'R') goto yy513;
				goto yy514;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy511;
				if (yych <= 'm') goto yy150;
				goto yy512;
			} else {
				if (yych <= 'q') goto yy150;
				if (yych <= 'r') goto yy513;
				if (yych <= 's') goto yy514;
				goto yy150;
			}
		}
yy97:
		YYDEBUG(97, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'W') {
			if (yych == 'T') goto yy499;
			if (yych <= 'V') goto yy150;
			goto yy500;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy150;
				goto yy499;
			} else {
				if (yych == 'w') goto yy500;
				goto yy150;
			}
		}
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy150;
				goto yy491;
			} else {
				if (yych == '\'') goto yy492;
				goto yy150;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy490;
				if (yych <= 'Q') goto yy150;
				goto yy493;
			} else {
				if (yych == 'r') goto yy493;
				goto yy150;
			}
		}
yy99:
		YYDEBUG(99, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'L') goto yy480;
			if (yych <= 'N') goto yy150;
			goto yy481;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy150;
				goto yy480;
			} else {
				if (yych == 'o') goto yy481;
				goto yy150;
			}
		}
yy100:
		YYDEBUG(100, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'R') goto yy456;
			if (yych <= 'T') goto yy150;
			goto yy457;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy150;
				goto yy456;
			} else {
				if (yych == 'u') goto yy457;
				goto yy150;
			}
		}
yy101:
		YYDEBUG(101, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '<') {
			if (yych == '-') goto yy452;
		} else {
			if (yych <= '=') goto yy450;
			if (yych <= '>') goto yy454;
		}
yy102:
		YYDEBUG(102, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(yytext[0]);
}
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy449;
yy104:
		YYDEBUG(104, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy446;
		goto yy102;
yy106:
		YYDEBUG(106, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(107, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NS_SEPARATOR);
}
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy443;
			goto yy102;
		} else {
			if (yych <= '9') goto yy439;
			if (yych == '=') goto yy441;
			goto yy102;
		}
yy109:
		YYDEBUG(109, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '=') goto yy102;
		if (yych <= '>') goto yy431;
		if (yych <= '?') goto yy433;
		goto yy102;
yy110:
		YYDEBUG(110, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy419;
			if (yych <= 'D') goto yy150;
			goto yy420;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy150;
				goto yy419;
			} else {
				if (yych == 'e') goto yy420;
				goto yy150;
			}
		}
yy111:
		YYDEBUG(111, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy416;
		if (yych == 'a') goto yy416;
		goto yy150;
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy341;
					if (yych <= 0x1F) goto yy102;
					goto yy341;
				} else {
					if (yych <= '@') goto yy102;
					if (yych == 'C') goto yy102;
					goto yy341;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy341;
					if (yych <= 'H') goto yy102;
					goto yy341;
				} else {
					if (yych == 'O') goto yy341;
					if (yych <= 'Q') goto yy102;
					goto yy341;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy341;
					if (yych <= '`') goto yy102;
					goto yy341;
				} else {
					if (yych == 'd') goto yy341;
					if (yych <= 'e') goto yy102;
					goto yy341;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy341;
					if (yych <= 'n') goto yy102;
					goto yy341;
				} else {
					if (yych <= 's') {
						if (yych <= 'q') goto yy102;
						goto yy341;
					} else {
						if (yych == 'u') goto yy341;
						goto yy102;
					}
				}
			}
		}
yy113:
		YYDEBUG(113, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych == 'N') goto yy332;
			if (yych <= 'R') goto yy150;
			goto yy333;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy150;
				goto yy332;
			} else {
				if (yych == 's') goto yy333;
				goto yy150;
			}
		}
yy114:
		YYDEBUG(114, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy250;
		goto yy150;
yy115:
		YYDEBUG(115, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy102;
		if (yych <= '=') goto yy244;
		if (yych <= '>') goto yy246;
		goto yy102;
yy116:
		YYDEBUG(116, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy240;
		if (yych == 'i') goto yy240;
		goto yy150;
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy238;
		if (yych == '=') goto yy236;
		goto yy102;
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy233;
		goto yy102;
yy119:
		YYDEBUG(119, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy102;
		if (yych <= '<') goto yy209;
		if (yych <= '=') goto yy211;
		if (yych <= '>') goto yy213;
		goto yy102;
yy120:
		YYDEBUG(120, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy102;
		if (yych <= '=') goto yy205;
		if (yych <= '>') goto yy203;
		goto yy102;
yy121:
		YYDEBUG(121, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy197;
		if (yych == '=') goto yy199;
		goto yy102;
yy122:
		YYDEBUG(122, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy189;
			goto yy102;
		} else {
			if (yych <= '/') goto yy191;
			if (yych == '=') goto yy192;
			goto yy102;
		}
yy123:
		YYDEBUG(123, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy187;
		goto yy102;
yy124:
		YYDEBUG(124, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy183;
		if (yych == '=') goto yy185;
		goto yy102;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy181;
		if (yych == '|') goto yy179;
		goto yy102;
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy177;
		goto yy102;
yy127:
		YYDEBUG(127, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy175;
		if (yych == 'r') goto yy175;
		goto yy150;
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy172;
		if (yych == 'o') goto yy172;
		goto yy150;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy102;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy102;
			goto yy169;
		} else {
			if (yych <= '`') goto yy102;
			if (yych <= 'z') goto yy169;
			if (yych <= 0x7F) goto yy102;
			goto yy169;
		}
yy130:
		YYDEBUG(130, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy102;
yy131:
		YYDEBUG(131, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(132, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN('{');
}
yy133:
		YYDEBUG(133, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(134, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	RETURN_TOKEN('}');
}
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '9') {
				if (yych == '.') goto yy151;
				if (yych >= '0') goto yy154;
			} else {
				if (yych == 'B') goto yy162;
				if (yych >= 'E') goto yy156;
			}
		} else {
			if (yych <= 'b') {
				if (yych == 'X') goto yy161;
				if (yych >= 'b') goto yy162;
			} else {
				if (yych <= 'e') {
					if (yych >= 'e') goto yy156;
				} else {
					if (yych == 'x') goto yy161;
				}
			}
		}
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *end;
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		/* base must be passed explicitly for correct parse error on Windows */
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, yytext[0] == '0' ? 8 : 10));
		/* This isn't an assert, we need to ensure 019 isn't valid octal
		 * Because the lexing itself doesn't do that for us
		 */
		if (end != yytext + yyleng) {
			zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
			ZVAL_UNDEF(zendlval);
			if (PARSER_MODE()) {
				RETURN_TOKEN(T_ERROR);
			}
			RETURN_TOKEN_WITH_VAL(T_LNUMBER);
		}
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (yytext[0] == '0') { /* octal overflow */
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(yytext, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(yytext, (const char **)&end));
			}
			/* Also not an assert for the same reason */
			if (end != yytext + yyleng) {
				zend_throw_exception(zend_ce_parse_error,
					"Invalid numeric literal", 0);
				ZVAL_UNDEF(zendlval);
				if (PARSER_MODE()) {
					RETURN_TOKEN(T_ERROR);
				}
			}
			RETURN_TOKEN_WITH_VAL(T_DNUMBER);
		}
		/* Also not an assert for the same reason */
		if (end != yytext + yyleng) {
			zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
			ZVAL_UNDEF(zendlval);
			if (PARSER_MODE()) {
				RETURN_TOKEN(T_ERROR);
			}
			RETURN_TOKEN_WITH_VAL(T_DNUMBER);
		}
	}
	ZEND_ASSERT(!errno);
	RETURN_TOKEN_WITH_VAL(T_LNUMBER);
}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy151;
			if (yych <= '/') goto yy136;
			goto yy154;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy136;
				goto yy156;
			} else {
				if (yych == 'e') goto yy156;
				goto yy136;
			}
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy150;
yy139:
		YYDEBUG(139, *YYCURSOR);
		++YYCURSOR;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (PARSER_MODE()) {
		SKIP_TOKEN(T_COMMENT);
	}
	RETURN_TOKEN(T_COMMENT);
}
yy141:
		YYDEBUG(141, *YYCURSOR);
		++YYCURSOR;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
		}
	}

	if (yyleng-bprefix-2 <= 1) {
		if (yyleng-bprefix-2 < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*(yytext+bprefix+1);
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}
	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (*s == '\\' || *s == '\'') {
				*t++ = *s;
			} else {
				*t++ = '\\';
				*t++ = *s;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		zend_string *new_str;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		new_str = zend_string_init(str, sz, 0);
		if (str != s) {
			efree(str);
		}
		zend_string_release_ex(Z_STR_P(zendlval), 0);
		ZVAL_STR(zendlval, new_str);
	}
	RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
}
yy143:
		YYDEBUG(143, *YYCURSOR);
		++YYCURSOR;
yy144:
		YYDEBUG(144, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				if (EXPECTED(zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"') == SUCCESS)
				 || !PARSER_MODE()) {
					RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
				} else {
					RETURN_TOKEN(T_ERROR);
				}
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	RETURN_TOKEN('"');
}
yy145:
		YYDEBUG(145, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(146, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	RETURN_TOKEN('`');
}
yy147:
		YYDEBUG(147, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(148, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy149:
		YYDEBUG(149, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy150:
		YYDEBUG(150, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy149;
		}
		goto yy87;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(152, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy151;
		}
		if (yych == 'E') goto yy156;
		if (yych == 'e') goto yy156;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *end;

	ZVAL_DOUBLE(zendlval, zend_strtod(yytext, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == yytext + yyleng);
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(155, *YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy151;
			if (yych <= '/') goto yy136;
			goto yy154;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy136;
			} else {
				if (yych != 'e') goto yy136;
			}
		}
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy158;
		} else {
			if (yych <= '-') goto yy158;
			if (yych <= '/') goto yy157;
			if (yych <= '9') goto yy159;
		}
yy157:
		YYDEBUG(157, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept <= 0) {
					goto yy87;
				} else {
					goto yy102;
				}
			} else {
				if (yyaccept <= 2) {
					goto yy136;
				} else {
					goto yy153;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept <= 4) {
					goto yy190;
				} else {
					goto yy210;
				}
			} else {
				goto yy603;
			}
		}
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy157;
		if (yych >= ':') goto yy157;
yy159:
		YYDEBUG(159, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(160, *YYCURSOR);
		if (yych <= '/') goto yy153;
		if (yych <= '9') goto yy159;
		goto yy153;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy166;
		}
		goto yy157;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy163;
		}
		goto yy157;
yy163:
		YYDEBUG(163, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(164, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy163;
		}
		YYDEBUG(165, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == yytext + yyleng);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == yytext + yyleng);
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy166:
		YYDEBUG(166, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(167, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy166;
		}
		YYDEBUG(168, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy169:
		YYDEBUG(169, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(170, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy169;
			} else {
				if (yych <= '@') goto yy171;
				if (yych <= 'Z') goto yy169;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy169;
			} else {
				if (yych <= 'z') goto yy169;
				if (yych >= 0x80) goto yy169;
			}
		}
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy172:
		YYDEBUG(172, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy173;
		if (yych != 'r') goto yy150;
yy173:
		YYDEBUG(173, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(174, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_LOGICAL_XOR);
}
yy175:
		YYDEBUG(175, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(176, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_LOGICAL_OR);
}
yy177:
		YYDEBUG(177, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(178, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_XOR_EQUAL);
}
yy179:
		YYDEBUG(179, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(180, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_OR);
}
yy181:
		YYDEBUG(181, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(182, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OR_EQUAL);
}
yy183:
		YYDEBUG(183, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(184, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_AND);
}
yy185:
		YYDEBUG(185, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(186, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AND_EQUAL);
}
yy187:
		YYDEBUG(187, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(188, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MOD_EQUAL);
}
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy194;
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		if (PARSER_MODE()) {
			SKIP_TOKEN(T_DOC_COMMENT);
		}
		RETURN_TOKEN(T_DOC_COMMENT);
	}

	if (PARSER_MODE()) {
		SKIP_TOKEN(T_COMMENT);
	}
	RETURN_TOKEN(T_COMMENT);
}
yy191:
		YYDEBUG(191, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy140;
yy192:
		YYDEBUG(192, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(193, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DIV_EQUAL);
}
yy194:
		YYDEBUG(194, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy195;
		}
		goto yy157;
yy195:
		YYDEBUG(195, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(196, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy195;
		}
		goto yy190;
yy197:
		YYDEBUG(197, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy201;
		YYDEBUG(198, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW);
}
yy199:
		YYDEBUG(199, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(200, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MUL_EQUAL);
}
yy201:
		YYDEBUG(201, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(202, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW_EQUAL);
}
yy203:
		YYDEBUG(203, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy207;
		YYDEBUG(204, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR);
}
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(206, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_GREATER_OR_EQUAL);
}
yy207:
		YYDEBUG(207, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(208, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR_EQUAL);
}
yy209:
		YYDEBUG(209, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy210;
		if (yych <= '<') goto yy219;
		if (yych <= '=') goto yy217;
yy210:
		YYDEBUG(210, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL);
}
yy211:
		YYDEBUG(211, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy215;
		YYDEBUG(212, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_SMALLER_OR_EQUAL);
}
yy213:
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
yy214:
		YYDEBUG(214, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_EQUAL);
}
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(216, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SPACESHIP);
}
yy217:
		YYDEBUG(217, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(218, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL_EQUAL);
}
yy219:
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(220, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy219;
		}
		if (yych <= 'Z') {
			if (yych <= '&') {
				if (yych == '"') goto yy224;
				goto yy157;
			} else {
				if (yych <= '\'') goto yy223;
				if (yych <= '@') goto yy157;
			}
		} else {
			if (yych <= '`') {
				if (yych != '_') goto yy157;
			} else {
				if (yych <= 'z') goto yy221;
				if (yych <= 0x7F) goto yy157;
			}
		}
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(222, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy228;
				goto yy157;
			} else {
				if (yych <= '\r') goto yy230;
				if (yych <= '/') goto yy157;
				if (yych <= '9') goto yy221;
				goto yy157;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy221;
				if (yych <= '^') goto yy157;
				goto yy221;
			} else {
				if (yych <= '`') goto yy157;
				if (yych <= 'z') goto yy221;
				if (yych <= 0x7F) goto yy157;
				goto yy221;
			}
		}
yy223:
		YYDEBUG(223, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy157;
		if (yych <= '/') goto yy232;
		if (yych <= '9') goto yy157;
		goto yy232;
yy224:
		YYDEBUG(224, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy157;
		if (yych <= '/') goto yy226;
		if (yych <= '9') goto yy157;
		goto yy226;
yy225:
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy226:
		YYDEBUG(226, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych != '"') goto yy157;
			} else {
				if (yych <= '9') goto yy225;
				if (yych <= '@') goto yy157;
				goto yy225;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy225;
				goto yy157;
			} else {
				if (yych <= 'z') goto yy225;
				if (yych <= 0x7F) goto yy157;
				goto yy225;
			}
		}
yy227:
		YYDEBUG(227, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy228;
		if (yych == '\r') goto yy230;
		goto yy157;
yy228:
		YYDEBUG(228, *YYCURSOR);
		++YYCURSOR;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	unsigned char *saved_cursor;
	int bprefix = (yytext[0] != '<') ? 1 : 0, spacing = 0, indentation = 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));
	zend_bool is_heredoc = 1;

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;
		is_heredoc = 0;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);
	heredoc_label->indentation = 0;
	saved_cursor = YYCURSOR;

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
		if (*YYCURSOR == '\t') {
			spacing |= HEREDOC_USING_TABS;
		} else {
			spacing |= HEREDOC_USING_SPACES;
		}
		++YYCURSOR;
		++indentation;
	}

	if (YYCURSOR == YYLIMIT) {
		YYCURSOR = saved_cursor;
		RETURN_TOKEN(T_START_HEREDOC);
	}

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		if (!IS_LABEL_START(YYCURSOR[heredoc_label->length])) {
			if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
				zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
			}

			YYCURSOR = saved_cursor;
			heredoc_label->indentation = indentation;

			BEGIN(ST_END_HEREDOC);
			RETURN_TOKEN(T_START_HEREDOC);
		}
	}

	YYCURSOR = saved_cursor;

	if (is_heredoc && !SCNG(heredoc_scan_ahead)) {
		zend_lex_state current_state;
		int heredoc_nesting_level = 1;
		int first_token = 0;

		zend_save_lexical_state(&current_state);

		SCNG(heredoc_scan_ahead) = 1;
		SCNG(heredoc_indentation) = 0;
		SCNG(heredoc_indentation_uses_spaces) = 0;
		LANG_SCNG(on_event) = NULL;

		zend_ptr_stack_reverse_apply(&current_state.heredoc_label_stack, copy_heredoc_label_stack);

		zend_exception_save();
		while (heredoc_nesting_level) {
			zval zv;
			int retval;

			ZVAL_UNDEF(&zv);
			retval = lex_scan(&zv, NULL);
			zval_ptr_dtor_nogc(&zv);

			if (EG(exception)) {
				zend_clear_exception();
				break;
			}

			if (!first_token) {
				first_token = retval;
			}

			switch (retval) {
				case T_START_HEREDOC:
					++heredoc_nesting_level;
					break;
				case T_END_HEREDOC:
					--heredoc_nesting_level;
					break;
				case END:
					heredoc_nesting_level = 0;
			}
		}
		zend_exception_restore();

		if (
		    (first_token == T_VARIABLE
		     || first_token == T_DOLLAR_OPEN_CURLY_BRACES
		     || first_token == T_CURLY_OPEN
		    ) && SCNG(heredoc_indentation)) {
			zend_throw_exception_ex(zend_ce_parse_error, 0, "Invalid body indentation level (expecting an indentation level of at least %d)", SCNG(heredoc_indentation));
		}

		heredoc_label->indentation = SCNG(heredoc_indentation);
		heredoc_label->indentation_uses_spaces = SCNG(heredoc_indentation_uses_spaces);

		zend_restore_lexical_state(&current_state);
		SCNG(heredoc_scan_ahead) = 0;
		CG(increment_lineno) = 0;
	}

	RETURN_TOKEN(T_START_HEREDOC);
}
yy230:
		YYDEBUG(230, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy228;
		goto yy229;
yy231:
		YYDEBUG(231, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy232:
		YYDEBUG(232, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy227;
				goto yy157;
			} else {
				if (yych <= '9') goto yy231;
				if (yych <= '@') goto yy157;
				goto yy231;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy231;
				goto yy157;
			} else {
				if (yych <= 'z') goto yy231;
				if (yych <= 0x7F) goto yy157;
				goto yy231;
			}
		}
yy233:
		YYDEBUG(233, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '=') goto yy214;
		YYDEBUG(234, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(235, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_IDENTICAL);
}
yy236:
		YYDEBUG(236, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(237, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PLUS_EQUAL);
}
yy238:
		YYDEBUG(238, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(239, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INC);
}
yy240:
		YYDEBUG(240, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy241;
		if (yych != 's') goto yy150;
yy241:
		YYDEBUG(241, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy242;
		if (yych != 't') goto yy150;
yy242:
		YYDEBUG(242, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(243, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_LIST);
}
yy244:
		YYDEBUG(244, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy248;
		YYDEBUG(245, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_EQUAL);
}
yy246:
		YYDEBUG(246, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(247, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_ARROW);
}
yy248:
		YYDEBUG(248, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(249, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_IDENTICAL);
}
yy250:
		YYDEBUG(250, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'C':
		case 'c':	goto yy252;
		case 'D':
		case 'd':	goto yy257;
		case 'F':
		case 'f':	goto yy254;
		case 'H':
		case 'h':	goto yy251;
		case 'L':
		case 'l':	goto yy256;
		case 'M':
		case 'm':	goto yy255;
		case 'N':
		case 'n':	goto yy258;
		case 'T':
		case 't':	goto yy253;
		default:	goto yy150;
		}
yy251:
		YYDEBUG(251, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy319;
		if (yych == 'a') goto yy319;
		goto yy150;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy312;
		if (yych == 'l') goto yy312;
		goto yy150;
yy253:
		YYDEBUG(253, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy305;
		if (yych == 'r') goto yy305;
		goto yy150;
yy254:
		YYDEBUG(254, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'I') goto yy289;
			if (yych <= 'T') goto yy150;
			goto yy290;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy150;
				goto yy289;
			} else {
				if (yych == 'u') goto yy290;
				goto yy150;
			}
		}
yy255:
		YYDEBUG(255, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy281;
		if (yych == 'e') goto yy281;
		goto yy150;
yy256:
		YYDEBUG(256, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy275;
		if (yych == 'i') goto yy275;
		goto yy150;
yy257:
		YYDEBUG(257, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy270;
		if (yych == 'i') goto yy270;
		goto yy150;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy259;
		if (yych != 'a') goto yy150;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy260;
		if (yych != 'm') goto yy150;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy261;
		if (yych != 'e') goto yy150;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy262;
		if (yych != 's') goto yy150;
yy262:
		YYDEBUG(262, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy263;
		if (yych != 'p') goto yy150;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy264;
		if (yych != 'a') goto yy150;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy265;
		if (yych != 'c') goto yy150;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy266;
		if (yych != 'e') goto yy150;
yy266:
		YYDEBUG(266, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(267, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(268, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(269, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NS_C);
}
yy270:
		YYDEBUG(270, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy271;
		if (yych != 'r') goto yy150;
yy271:
		YYDEBUG(271, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(272, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(273, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(274, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DIR);
}
yy275:
		YYDEBUG(275, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy276;
		if (yych != 'n') goto yy150;
yy276:
		YYDEBUG(276, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy277;
		if (yych != 'e') goto yy150;
yy277:
		YYDEBUG(277, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(278, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(279, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(280, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_LINE);
}
yy281:
		YYDEBUG(281, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy282;
		if (yych != 't') goto yy150;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy283;
		if (yych != 'h') goto yy150;
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy284;
		if (yych != 'o') goto yy150;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy285;
		if (yych != 'd') goto yy150;
yy285:
		YYDEBUG(285, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(287, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(288, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_METHOD_C);
}
yy289:
		YYDEBUG(289, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy300;
		if (yych == 'l') goto yy300;
		goto yy150;
yy290:
		YYDEBUG(290, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy291;
		if (yych != 'n') goto yy150;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy292;
		if (yych != 'c') goto yy150;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy293;
		if (yych != 't') goto yy150;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy294;
		if (yych != 'i') goto yy150;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy295;
		if (yych != 'o') goto yy150;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy296;
		if (yych != 'n') goto yy150;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(297, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(298, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(299, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FUNC_C);
}
yy300:
		YYDEBUG(300, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy301;
		if (yych != 'e') goto yy150;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(302, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(303, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(304, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FILE);
}
yy305:
		YYDEBUG(305, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy306;
		if (yych != 'a') goto yy150;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy307;
		if (yych != 'i') goto yy150;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy308;
		if (yych != 't') goto yy150;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(309, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(310, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(311, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_TRAIT_C);
}
yy312:
		YYDEBUG(312, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy313;
		if (yych != 'a') goto yy150;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy314;
		if (yych != 's') goto yy150;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy315;
		if (yych != 's') goto yy150;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(317, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(318, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CLASS_C);
}
yy319:
		YYDEBUG(319, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy320;
		if (yych != 'l') goto yy150;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy321;
		if (yych != 't') goto yy150;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy323;
		if (yych != 'c') goto yy150;
yy323:
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy324;
		if (yych != 'o') goto yy150;
yy324:
		YYDEBUG(324, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy325;
		if (yych != 'm') goto yy150;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy326;
		if (yych != 'p') goto yy150;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy327;
		if (yych != 'i') goto yy150;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy328;
		if (yych != 'l') goto yy150;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy329;
		if (yych != 'e') goto yy150;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy330;
		if (yych != 'r') goto yy150;
yy330:
		YYDEBUG(330, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(331, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_HALT_COMPILER);
}
yy332:
		YYDEBUG(332, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy336;
		if (yych == 's') goto yy336;
		goto yy150;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy334;
		if (yych != 'e') goto yy150;
yy334:
		YYDEBUG(334, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(335, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_USE);
}
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy337;
		if (yych != 'e') goto yy150;
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy338;
		if (yych != 't') goto yy150;
yy338:
		YYDEBUG(338, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(339, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_UNSET);
}
yy340:
		YYDEBUG(340, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy341:
		YYDEBUG(341, *YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy340;
					if (yych <= 0x1F) goto yy157;
					goto yy340;
				} else {
					if (yych <= 'A') {
						if (yych <= '@') goto yy157;
						goto yy345;
					} else {
						if (yych <= 'B') goto yy343;
						if (yych <= 'C') goto yy157;
						goto yy348;
					}
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy349;
					if (yych <= 'H') goto yy157;
					goto yy350;
				} else {
					if (yych <= 'O') {
						if (yych <= 'N') goto yy157;
						goto yy344;
					} else {
						if (yych <= 'Q') goto yy157;
						if (yych <= 'R') goto yy347;
						goto yy346;
					}
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'a') {
					if (yych == 'U') goto yy342;
					if (yych <= '`') goto yy157;
					goto yy345;
				} else {
					if (yych <= 'c') {
						if (yych <= 'b') goto yy343;
						goto yy157;
					} else {
						if (yych <= 'd') goto yy348;
						if (yych <= 'e') goto yy157;
						goto yy349;
					}
				}
			} else {
				if (yych <= 'q') {
					if (yych <= 'i') {
						if (yych <= 'h') goto yy157;
						goto yy350;
					} else {
						if (yych == 'o') goto yy344;
						goto yy157;
					}
				} else {
					if (yych <= 's') {
						if (yych <= 'r') goto yy347;
						goto yy346;
					} else {
						if (yych != 'u') goto yy157;
					}
				}
			}
		}
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy409;
		if (yych == 'n') goto yy409;
		goto yy157;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy396;
			if (yych <= 'N') goto yy157;
			goto yy397;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy157;
				goto yy396;
			} else {
				if (yych == 'o') goto yy397;
				goto yy157;
			}
		}
yy344:
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy388;
		if (yych == 'b') goto yy388;
		goto yy157;
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy381;
		if (yych == 'r') goto yy381;
		goto yy157;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy373;
		if (yych == 't') goto yy373;
		goto yy157;
yy347:
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy371;
		if (yych == 'e') goto yy371;
		goto yy157;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy367;
		if (yych == 'o') goto yy367;
		goto yy157;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy360;
		if (yych == 'l') goto yy360;
		goto yy157;
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy351;
		if (yych != 'n') goto yy157;
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy352;
		if (yych != 't') goto yy157;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy353;
		if (yych != 'e') goto yy355;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy358;
		if (yych == 'g') goto yy358;
		goto yy157;
yy354:
		YYDEBUG(354, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy355:
		YYDEBUG(355, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy354;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy354;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(356, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(357, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INT_CAST);
}
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy359;
		if (yych != 'e') goto yy157;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy354;
		if (yych == 'r') goto yy354;
		goto yy157;
yy360:
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy361;
		if (yych != 'o') goto yy157;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy362;
		if (yych != 'a') goto yy157;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy363;
		if (yych != 't') goto yy157;
yy363:
		YYDEBUG(363, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(364, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy363;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy363;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(365, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(366, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy367:
		YYDEBUG(367, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy368;
		if (yych != 'u') goto yy157;
yy368:
		YYDEBUG(368, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy369;
		if (yych != 'b') goto yy157;
yy369:
		YYDEBUG(369, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy370;
		if (yych != 'l') goto yy157;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy363;
		if (yych == 'e') goto yy363;
		goto yy157;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy372;
		if (yych != 'a') goto yy157;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy363;
		if (yych == 'l') goto yy363;
		goto yy157;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy374;
		if (yych != 'r') goto yy157;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy375;
		if (yych != 'i') goto yy157;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy376;
		if (yych != 'n') goto yy157;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy377;
		if (yych != 'g') goto yy157;
yy377:
		YYDEBUG(377, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(378, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy377;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy377;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(379, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(380, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_STRING_CAST);
}
yy381:
		YYDEBUG(381, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy382;
		if (yych != 'r') goto yy157;
yy382:
		YYDEBUG(382, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy383;
		if (yych != 'a') goto yy157;
yy383:
		YYDEBUG(383, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy384;
		if (yych != 'y') goto yy157;
yy384:
		YYDEBUG(384, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(385, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy384;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy384;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(386, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(387, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ARRAY_CAST);
}
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy389;
		if (yych != 'j') goto yy157;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy390;
		if (yych != 'e') goto yy157;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy391;
		if (yych != 'c') goto yy157;
yy391:
		YYDEBUG(391, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy392;
		if (yych != 't') goto yy157;
yy392:
		YYDEBUG(392, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(393, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy392;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy392;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(394, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(395, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_CAST);
}
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy406;
		if (yych == 'n') goto yy406;
		goto yy157;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy398;
		if (yych != 'o') goto yy157;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy399;
		if (yych != 'l') goto yy157;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy404;
		if (yych == 'e') goto yy404;
		goto yy401;
yy400:
		YYDEBUG(400, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy401:
		YYDEBUG(401, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy400;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy400;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(402, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(403, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOL_CAST);
}
yy404:
		YYDEBUG(404, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy405;
		if (yych != 'a') goto yy157;
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy400;
		if (yych == 'n') goto yy400;
		goto yy157;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy407;
		if (yych != 'a') goto yy157;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy408;
		if (yych != 'r') goto yy157;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy377;
		if (yych == 'y') goto yy377;
		goto yy157;
yy409:
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy410;
		if (yych != 's') goto yy157;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy411;
		if (yych != 'e') goto yy157;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy412;
		if (yych != 't') goto yy157;
yy412:
		YYDEBUG(412, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(413, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy412;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy412;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(414, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(415, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_UNSET_CAST);
}
yy416:
		YYDEBUG(416, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy417;
		if (yych != 'r') goto yy150;
yy417:
		YYDEBUG(417, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(418, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_VAR);
}
yy419:
		YYDEBUG(419, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy423;
		if (yych == 'm') goto yy423;
		goto yy150;
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy421;
		if (yych != 'w') goto yy150;
yy421:
		YYDEBUG(421, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(422, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NEW);
}
yy423:
		YYDEBUG(423, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy424;
		if (yych != 'e') goto yy150;
yy424:
		YYDEBUG(424, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy425;
		if (yych != 's') goto yy150;
yy425:
		YYDEBUG(425, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy426;
		if (yych != 'p') goto yy150;
yy426:
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy427;
		if (yych != 'a') goto yy150;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy428;
		if (yych != 'c') goto yy150;
yy428:
		YYDEBUG(428, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy429;
		if (yych != 'e') goto yy150;
yy429:
		YYDEBUG(429, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(430, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NAMESPACE);
}
yy431:
		YYDEBUG(431, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy437;
		if (yych == '\r') goto yy438;
yy432:
		YYDEBUG(432, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(INITIAL);
	if (yytext[yyleng-1] != '>') {
		CG(increment_lineno) = 1;
	}
	if (PARSER_MODE()) {
		RETURN_TOKEN(';');  /* implicit ';' at php-end tag */
	}
	RETURN_TOKEN(T_CLOSE_TAG);
}
yy433:
		YYDEBUG(433, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy435;
		YYDEBUG(434, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE);
}
yy435:
		YYDEBUG(435, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(436, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE_EQUAL);
}
yy437:
		YYDEBUG(437, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy432;
yy438:
		YYDEBUG(438, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy437;
		goto yy432;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(440, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy153;
			if (yych <= '9') goto yy439;
			goto yy153;
		} else {
			if (yych <= 'E') goto yy156;
			if (yych == 'e') goto yy156;
			goto yy153;
		}
yy441:
		YYDEBUG(441, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(442, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CONCAT_EQUAL);
}
yy443:
		YYDEBUG(443, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '.') goto yy157;
		YYDEBUG(444, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(445, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ELLIPSIS);
}
yy446:
		YYDEBUG(446, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(447, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PAAMAYIM_NEKUDOTAYIM);
}
yy448:
		YYDEBUG(448, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy449:
		YYDEBUG(449, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy104;
			if (yych <= '\n') goto yy448;
			goto yy104;
		} else {
			if (yych <= '\r') goto yy448;
			if (yych == ' ') goto yy448;
			goto yy104;
		}
yy450:
		YYDEBUG(450, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(451, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MINUS_EQUAL);
}
yy452:
		YYDEBUG(452, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(453, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DEC);
}
yy454:
		YYDEBUG(454, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(455, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy456:
		YYDEBUG(456, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy463;
			if (yych <= 'N') goto yy150;
			goto yy464;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy150;
				goto yy463;
			} else {
				if (yych == 'o') goto yy464;
				goto yy150;
			}
		}
yy457:
		YYDEBUG(457, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy458;
		if (yych != 'b') goto yy150;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy459;
		if (yych != 'l') goto yy150;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy460;
		if (yych != 'i') goto yy150;
yy460:
		YYDEBUG(460, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy461;
		if (yych != 'c') goto yy150;
yy461:
		YYDEBUG(461, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(462, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PUBLIC);
}
yy463:
		YYDEBUG(463, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'V') {
			if (yych == 'N') goto yy472;
			if (yych <= 'U') goto yy150;
			goto yy473;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy150;
				goto yy472;
			} else {
				if (yych == 'v') goto yy473;
				goto yy150;
			}
		}
yy464:
		YYDEBUG(464, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy465;
		if (yych != 't') goto yy150;
yy465:
		YYDEBUG(465, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy466;
		if (yych != 'e') goto yy150;
yy466:
		YYDEBUG(466, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy467;
		if (yych != 'c') goto yy150;
yy467:
		YYDEBUG(467, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy468;
		if (yych != 't') goto yy150;
yy468:
		YYDEBUG(468, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy469;
		if (yych != 'e') goto yy150;
yy469:
		YYDEBUG(469, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy470;
		if (yych != 'd') goto yy150;
yy470:
		YYDEBUG(470, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(471, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PROTECTED);
}
yy472:
		YYDEBUG(472, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy478;
		if (yych == 't') goto yy478;
		goto yy150;
yy473:
		YYDEBUG(473, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy474;
		if (yych != 'a') goto yy150;
yy474:
		YYDEBUG(474, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy475;
		if (yych != 't') goto yy150;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy476;
		if (yych != 'e') goto yy150;
yy476:
		YYDEBUG(476, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(477, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PRIVATE);
}
yy478:
		YYDEBUG(478, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(479, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PRINT);
}
yy480:
		YYDEBUG(480, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy485;
		if (yych == 'o') goto yy485;
		goto yy150;
yy481:
		YYDEBUG(481, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy482;
		if (yych != 't') goto yy150;
yy482:
		YYDEBUG(482, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy483;
		if (yych != 'o') goto yy150;
yy483:
		YYDEBUG(483, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(484, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_GOTO);
}
yy485:
		YYDEBUG(485, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy486;
		if (yych != 'b') goto yy150;
yy486:
		YYDEBUG(486, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy487;
		if (yych != 'a') goto yy150;
yy487:
		YYDEBUG(487, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy488;
		if (yych != 'l') goto yy150;
yy488:
		YYDEBUG(488, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(489, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_GLOBAL);
}
yy490:
		YYDEBUG(490, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy498;
		goto yy157;
yy491:
		YYDEBUG(491, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy144;
yy492:
		YYDEBUG(492, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy142;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy494;
		if (yych != 'e') goto yy150;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy495;
		if (yych != 'a') goto yy150;
yy495:
		YYDEBUG(495, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'K') goto yy496;
		if (yych != 'k') goto yy150;
yy496:
		YYDEBUG(496, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(497, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BREAK);
}
yy498:
		YYDEBUG(498, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy219;
		goto yy157;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy506;
		if (yych == 'a') goto yy506;
		goto yy150;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy501;
		if (yych != 'i') goto yy150;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy502;
		if (yych != 't') goto yy150;
yy502:
		YYDEBUG(502, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy503;
		if (yych != 'c') goto yy150;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy504;
		if (yych != 'h') goto yy150;
yy504:
		YYDEBUG(504, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(505, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SWITCH);
}
yy506:
		YYDEBUG(506, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy507;
		if (yych != 't') goto yy150;
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy508;
		if (yych != 'i') goto yy150;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy509;
		if (yych != 'c') goto yy150;
yy509:
		YYDEBUG(509, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(510, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_STATIC);
}
yy511:
		YYDEBUG(511, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy522;
		if (yych == 's') goto yy522;
		goto yy150;
yy512:
		YYDEBUG(512, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy520;
		if (yych == 'd') goto yy520;
		goto yy150;
yy513:
		YYDEBUG(513, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy516;
		if (yych == 'r') goto yy516;
		goto yy150;
yy514:
		YYDEBUG(514, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(515, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AS);
}
yy516:
		YYDEBUG(516, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy517;
		if (yych != 'a') goto yy150;
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy518;
		if (yych != 'y') goto yy150;
yy518:
		YYDEBUG(518, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(519, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ARRAY);
}
yy520:
		YYDEBUG(520, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(521, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_LOGICAL_AND);
}
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy523;
		if (yych != 't') goto yy150;
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy524;
		if (yych != 'r') goto yy150;
yy524:
		YYDEBUG(524, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy525;
		if (yych != 'a') goto yy150;
yy525:
		YYDEBUG(525, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy526;
		if (yych != 'c') goto yy150;
yy526:
		YYDEBUG(526, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy527;
		if (yych != 't') goto yy150;
yy527:
		YYDEBUG(527, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(528, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ABSTRACT);
}
yy529:
		YYDEBUG(529, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy530;
		if (yych != 'i') goto yy150;
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy531;
		if (yych != 'l') goto yy150;
yy531:
		YYDEBUG(531, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy532;
		if (yych != 'e') goto yy150;
yy532:
		YYDEBUG(532, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(533, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_WHILE);
}
yy534:
		YYDEBUG(534, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(535, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IF);
}
yy536:
		YYDEBUG(536, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy578;
		if (yych == 'p') goto yy578;
		goto yy150;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy150;
				goto yy545;
			} else {
				if (yych <= 'R') goto yy150;
				if (yych <= 'S') goto yy543;
				goto yy544;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy545;
				goto yy150;
			} else {
				if (yych <= 's') goto yy543;
				if (yych <= 't') goto yy544;
				goto yy150;
			}
		}
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy539;
		if (yych != 's') goto yy150;
yy539:
		YYDEBUG(539, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy540;
		if (yych != 'e') goto yy150;
yy540:
		YYDEBUG(540, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy541;
		if (yych != 't') goto yy150;
yy541:
		YYDEBUG(541, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(542, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ISSET);
}
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy564;
		if (yych == 't') goto yy564;
		goto yy150;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy557;
		if (yych == 'e') goto yy557;
		goto yy150;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy546;
		if (yych != 'l') goto yy150;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy547;
		if (yych != 'u') goto yy150;
yy547:
		YYDEBUG(547, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy548;
		if (yych != 'd') goto yy150;
yy548:
		YYDEBUG(548, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy549;
		if (yych != 'e') goto yy150;
yy549:
		YYDEBUG(549, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy149;
			} else {
				if (yych <= '@') goto yy550;
				if (yych <= 'Z') goto yy149;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy551;
			} else {
				if (yych <= 'z') goto yy149;
				if (yych >= 0x80) goto yy149;
			}
		}
yy550:
		YYDEBUG(550, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INCLUDE);
}
yy551:
		YYDEBUG(551, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy552;
		if (yych != 'o') goto yy150;
yy552:
		YYDEBUG(552, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy553;
		if (yych != 'n') goto yy150;
yy553:
		YYDEBUG(553, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy554;
		if (yych != 'c') goto yy150;
yy554:
		YYDEBUG(554, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy555;
		if (yych != 'e') goto yy150;
yy555:
		YYDEBUG(555, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(556, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INCLUDE_ONCE);
}
yy557:
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy558;
		if (yych != 'r') goto yy150;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy559;
		if (yych != 'f') goto yy150;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy560;
		if (yych != 'a') goto yy150;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy561;
		if (yych != 'c') goto yy150;
yy561:
		YYDEBUG(561, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy562;
		if (yych != 'e') goto yy150;
yy562:
		YYDEBUG(562, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(563, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INTERFACE);
}
yy564:
		YYDEBUG(564, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy565;
			if (yych <= 'D') goto yy150;
			goto yy566;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy150;
			} else {
				if (yych == 'e') goto yy566;
				goto yy150;
			}
		}
yy565:
		YYDEBUG(565, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy572;
		if (yych == 'n') goto yy572;
		goto yy150;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy567;
		if (yych != 'a') goto yy150;
yy567:
		YYDEBUG(567, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy568;
		if (yych != 'd') goto yy150;
yy568:
		YYDEBUG(568, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy569;
		if (yych != 'o') goto yy150;
yy569:
		YYDEBUG(569, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy570;
		if (yych != 'f') goto yy150;
yy570:
		YYDEBUG(570, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(571, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
    RETURN_TOKEN(T_INSTEADOF);
}
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy573;
		if (yych != 'c') goto yy150;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy574;
		if (yych != 'e') goto yy150;
yy574:
		YYDEBUG(574, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy575;
		if (yych != 'o') goto yy150;
yy575:
		YYDEBUG(575, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy576;
		if (yych != 'f') goto yy150;
yy576:
		YYDEBUG(576, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(577, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INSTANCEOF);
}
yy578:
		YYDEBUG(578, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy579;
		if (yych != 'l') goto yy150;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy580;
		if (yych != 'e') goto yy150;
yy580:
		YYDEBUG(580, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy581;
		if (yych != 'm') goto yy150;
yy581:
		YYDEBUG(581, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy582;
		if (yych != 'e') goto yy150;
yy582:
		YYDEBUG(582, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy583;
		if (yych != 'n') goto yy150;
yy583:
		YYDEBUG(583, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy584;
		if (yych != 't') goto yy150;
yy584:
		YYDEBUG(584, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy585;
		if (yych != 's') goto yy150;
yy585:
		YYDEBUG(585, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(586, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IMPLEMENTS);
}
yy587:
		YYDEBUG(587, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy595;
		if (yych == 'r') goto yy595;
		goto yy150;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'Y') {
			if (yych == 'A') goto yy591;
			if (yych <= 'X') goto yy150;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy150;
				goto yy591;
			} else {
				if (yych != 'y') goto yy150;
			}
		}
		YYDEBUG(589, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(590, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_TRY);
}
yy591:
		YYDEBUG(591, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy592;
		if (yych != 'i') goto yy150;
yy592:
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy593;
		if (yych != 't') goto yy150;
yy593:
		YYDEBUG(593, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(594, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_TRAIT);
}
yy595:
		YYDEBUG(595, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy596;
		if (yych != 'o') goto yy150;
yy596:
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy597;
		if (yych != 'w') goto yy150;
yy597:
		YYDEBUG(597, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(598, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_THROW);
}
yy599:
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy600;
		if (yych != 'e') goto yy150;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy601;
		if (yych != 'l') goto yy150;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy602;
		if (yych != 'd') goto yy150;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy149;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy603;
			if (yych <= '\n') goto yy604;
		} else {
			if (yych <= '\r') goto yy604;
			if (yych == ' ') goto yy604;
		}
yy603:
		YYDEBUG(603, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_YIELD);
}
yy604:
		YYDEBUG(604, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(605, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy157;
				goto yy604;
			} else {
				if (yych == '\r') goto yy604;
				goto yy157;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= ' ') goto yy604;
				if (yych <= 'E') goto yy157;
			} else {
				if (yych != 'f') goto yy157;
			}
		}
		YYDEBUG(606, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy607;
		if (yych != 'r') goto yy157;
yy607:
		YYDEBUG(607, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy608;
		if (yych != 'o') goto yy157;
yy608:
		YYDEBUG(608, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy609;
		if (yych != 'm') goto yy157;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy157;
			} else {
				if (yych <= '@') goto yy610;
				if (yych <= 'Z') goto yy157;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy157;
			} else {
				if (yych <= 'z') goto yy157;
				if (yych >= 0x80) goto yy157;
			}
		}
yy610:
		YYDEBUG(610, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(611, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_YIELD_FROM);
}
yy612:
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'Q') goto yy614;
			if (yych <= 'S') goto yy150;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy150;
				goto yy614;
			} else {
				if (yych != 't') goto yy150;
			}
		}
		YYDEBUG(613, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy626;
		if (yych == 'u') goto yy626;
		goto yy150;
yy614:
		YYDEBUG(614, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy615;
		if (yych != 'u') goto yy150;
yy615:
		YYDEBUG(615, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy616;
		if (yych != 'i') goto yy150;
yy616:
		YYDEBUG(616, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy617;
		if (yych != 'r') goto yy150;
yy617:
		YYDEBUG(617, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy618;
		if (yych != 'e') goto yy150;
yy618:
		YYDEBUG(618, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy149;
			} else {
				if (yych <= '@') goto yy619;
				if (yych <= 'Z') goto yy149;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy620;
			} else {
				if (yych <= 'z') goto yy149;
				if (yych >= 0x80) goto yy149;
			}
		}
yy619:
		YYDEBUG(619, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_REQUIRE);
}
yy620:
		YYDEBUG(620, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy621;
		if (yych != 'o') goto yy150;
yy621:
		YYDEBUG(621, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy622;
		if (yych != 'n') goto yy150;
yy622:
		YYDEBUG(622, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy623;
		if (yych != 'c') goto yy150;
yy623:
		YYDEBUG(623, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy624;
		if (yych != 'e') goto yy150;
yy624:
		YYDEBUG(624, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(625, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_REQUIRE_ONCE);
}
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy627;
		if (yych != 'r') goto yy150;
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy628;
		if (yych != 'n') goto yy150;
yy628:
		YYDEBUG(628, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(629, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_RETURN);
}
yy630:
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy150;
				goto yy653;
			} else {
				if (yych <= 'R') goto yy150;
				if (yych <= 'S') goto yy652;
				goto yy651;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy653;
				goto yy150;
			} else {
				if (yych <= 's') goto yy652;
				if (yych <= 't') goto yy651;
				goto yy150;
			}
		}
yy631:
		YYDEBUG(631, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'A') goto yy643;
			if (yych <= 'N') goto yy150;
			goto yy644;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy150;
				goto yy643;
			} else {
				if (yych == 'o') goto yy644;
				goto yy150;
			}
		}
yy632:
		YYDEBUG(632, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy633;
		if (yych != 'n') goto yy150;
yy633:
		YYDEBUG(633, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy150;
			if (yych >= 'T') goto yy635;
		} else {
			if (yych <= 'r') goto yy150;
			if (yych <= 's') goto yy634;
			if (yych <= 't') goto yy635;
			goto yy150;
		}
yy634:
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy641;
		if (yych == 't') goto yy641;
		goto yy150;
yy635:
		YYDEBUG(635, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy636;
		if (yych != 'i') goto yy150;
yy636:
		YYDEBUG(636, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy637;
		if (yych != 'n') goto yy150;
yy637:
		YYDEBUG(637, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy638;
		if (yych != 'u') goto yy150;
yy638:
		YYDEBUG(638, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy639;
		if (yych != 'e') goto yy150;
yy639:
		YYDEBUG(639, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(640, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CONTINUE);
}
yy641:
		YYDEBUG(641, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(642, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CONST);
}
yy643:
		YYDEBUG(643, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy648;
		if (yych == 's') goto yy648;
		goto yy150;
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy645;
		if (yych != 'n') goto yy150;
yy645:
		YYDEBUG(645, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy646;
		if (yych != 'e') goto yy150;
yy646:
		YYDEBUG(646, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(647, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CLONE);
}
yy648:
		YYDEBUG(648, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy649;
		if (yych != 's') goto yy150;
yy649:
		YYDEBUG(649, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(650, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CLASS);
}
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy662;
		if (yych == 'c') goto yy662;
		goto yy150;
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy660;
		if (yych == 'e') goto yy660;
		goto yy150;
yy653:
		YYDEBUG(653, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy654;
		if (yych != 'l') goto yy150;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy655;
		if (yych != 'a') goto yy150;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy656;
		if (yych != 'b') goto yy150;
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy657;
		if (yych != 'l') goto yy150;
yy657:
		YYDEBUG(657, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy658;
		if (yych != 'e') goto yy150;
yy658:
		YYDEBUG(658, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(659, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CALLABLE);
}
yy660:
		YYDEBUG(660, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(661, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CASE);
}
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy663;
		if (yych != 'h') goto yy150;
yy663:
		YYDEBUG(663, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(664, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CATCH);
}
yy665:
		YYDEBUG(665, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy684;
		if (yych == 'n') goto yy684;
		goto yy150;
yy666:
		YYDEBUG(666, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(667, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FN);
}
yy668:
		YYDEBUG(668, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy677;
		if (yych == 'r') goto yy677;
		goto yy150;
yy669:
		YYDEBUG(669, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy670;
		if (yych != 'n') goto yy150;
yy670:
		YYDEBUG(670, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy671;
		if (yych != 'c') goto yy150;
yy671:
		YYDEBUG(671, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy672;
		if (yych != 't') goto yy150;
yy672:
		YYDEBUG(672, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy673;
		if (yych != 'i') goto yy150;
yy673:
		YYDEBUG(673, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy674;
		if (yych != 'o') goto yy150;
yy674:
		YYDEBUG(674, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy675;
		if (yych != 'n') goto yy150;
yy675:
		YYDEBUG(675, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(676, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FUNCTION);
}
yy677:
		YYDEBUG(677, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy678;
				if (yych <= '9') goto yy149;
			} else {
				if (yych == 'E') goto yy679;
				if (yych <= 'Z') goto yy149;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy149;
			} else {
				if (yych <= 'e') goto yy679;
				if (yych <= 'z') goto yy149;
				if (yych >= 0x80) goto yy149;
			}
		}
yy678:
		YYDEBUG(678, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FOR);
}
yy679:
		YYDEBUG(679, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy680;
		if (yych != 'a') goto yy150;
yy680:
		YYDEBUG(680, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy681;
		if (yych != 'c') goto yy150;
yy681:
		YYDEBUG(681, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy682;
		if (yych != 'h') goto yy150;
yy682:
		YYDEBUG(682, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(683, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FOREACH);
}
yy684:
		YYDEBUG(684, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy685;
		if (yych != 'a') goto yy150;
yy685:
		YYDEBUG(685, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy686;
		if (yych != 'l') goto yy150;
yy686:
		YYDEBUG(686, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy687;
				if (yych <= '9') goto yy149;
			} else {
				if (yych == 'L') goto yy688;
				if (yych <= 'Z') goto yy149;
			}
		} else {
			if (yych <= 'k') {
				if (yych != '`') goto yy149;
			} else {
				if (yych <= 'l') goto yy688;
				if (yych <= 'z') goto yy149;
				if (yych >= 0x80) goto yy149;
			}
		}
yy687:
		YYDEBUG(687, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FINAL);
}
yy688:
		YYDEBUG(688, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy689;
		if (yych != 'y') goto yy150;
yy689:
		YYDEBUG(689, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(690, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FINALLY);
}
yy691:
		YYDEBUG(691, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'F') {
			if (yych == 'C') goto yy697;
			if (yych <= 'E') goto yy150;
			goto yy698;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy150;
				goto yy697;
			} else {
				if (yych == 'f') goto yy698;
				goto yy150;
			}
		}
yy692:
		YYDEBUG(692, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy695;
		if (yych == 'e') goto yy695;
		goto yy150;
yy693:
		YYDEBUG(693, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(694, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DO);
}
yy695:
		YYDEBUG(695, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(696, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_EXIT);
}
yy697:
		YYDEBUG(697, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy704;
		if (yych == 'l') goto yy704;
		goto yy150;
yy698:
		YYDEBUG(698, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy699;
		if (yych != 'a') goto yy150;
yy699:
		YYDEBUG(699, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy700;
		if (yych != 'u') goto yy150;
yy700:
		YYDEBUG(700, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy701;
		if (yych != 'l') goto yy150;
yy701:
		YYDEBUG(701, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy702;
		if (yych != 't') goto yy150;
yy702:
		YYDEBUG(702, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(703, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DEFAULT);
}
yy704:
		YYDEBUG(704, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy705;
		if (yych != 'a') goto yy150;
yy705:
		YYDEBUG(705, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy706;
		if (yych != 'r') goto yy150;
yy706:
		YYDEBUG(706, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy707;
		if (yych != 'e') goto yy150;
yy707:
		YYDEBUG(707, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(708, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DECLARE);
}
yy709:
		YYDEBUG(709, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy771;
		if (yych == 'h') goto yy771;
		goto yy150;
yy710:
		YYDEBUG(710, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy765;
		if (yych == 's') goto yy765;
		goto yy150;
yy711:
		YYDEBUG(711, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy761;
		if (yych == 'p') goto yy761;
		goto yy150;
yy712:
		YYDEBUG(712, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy727;
		if (yych == 'd') goto yy727;
		goto yy150;
yy713:
		YYDEBUG(713, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy724;
		if (yych == 'a') goto yy724;
		goto yy150;
yy714:
		YYDEBUG(714, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'I') goto yy715;
			if (yych <= 'S') goto yy150;
			goto yy716;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy150;
			} else {
				if (yych == 't') goto yy716;
				goto yy150;
			}
		}
yy715:
		YYDEBUG(715, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy722;
		if (yych == 't') goto yy722;
		goto yy150;
yy716:
		YYDEBUG(716, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy717;
		if (yych != 'e') goto yy150;
yy717:
		YYDEBUG(717, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy718;
		if (yych != 'n') goto yy150;
yy718:
		YYDEBUG(718, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy719;
		if (yych != 'd') goto yy150;
yy719:
		YYDEBUG(719, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy720;
		if (yych != 's') goto yy150;
yy720:
		YYDEBUG(720, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(721, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_EXTENDS);
}
yy722:
		YYDEBUG(722, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(723, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_EXIT);
}
yy724:
		YYDEBUG(724, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy725;
		if (yych != 'l') goto yy150;
yy725:
		YYDEBUG(725, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(726, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_EVAL);
}
yy727:
		YYDEBUG(727, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'D':
		case 'd':	goto yy728;
		case 'F':
		case 'f':	goto yy729;
		case 'I':
		case 'i':	goto yy730;
		case 'S':
		case 's':	goto yy731;
		case 'W':
		case 'w':	goto yy732;
		default:	goto yy150;
		}
yy728:
		YYDEBUG(728, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy754;
		if (yych == 'e') goto yy754;
		goto yy150;
yy729:
		YYDEBUG(729, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy746;
		if (yych == 'o') goto yy746;
		goto yy150;
yy730:
		YYDEBUG(730, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy744;
		if (yych == 'f') goto yy744;
		goto yy150;
yy731:
		YYDEBUG(731, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy738;
		if (yych == 'w') goto yy738;
		goto yy150;
yy732:
		YYDEBUG(732, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy733;
		if (yych != 'h') goto yy150;
yy733:
		YYDEBUG(733, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy734;
		if (yych != 'i') goto yy150;
yy734:
		YYDEBUG(734, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy735;
		if (yych != 'l') goto yy150;
yy735:
		YYDEBUG(735, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy736;
		if (yych != 'e') goto yy150;
yy736:
		YYDEBUG(736, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(737, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ENDWHILE);
}
yy738:
		YYDEBUG(738, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy739;
		if (yych != 'i') goto yy150;
yy739:
		YYDEBUG(739, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy740;
		if (yych != 't') goto yy150;
yy740:
		YYDEBUG(740, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy741;
		if (yych != 'c') goto yy150;
yy741:
		YYDEBUG(741, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy742;
		if (yych != 'h') goto yy150;
yy742:
		YYDEBUG(742, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(743, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ENDSWITCH);
}
yy744:
		YYDEBUG(744, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(745, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ENDIF);
}
yy746:
		YYDEBUG(746, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy747;
		if (yych != 'r') goto yy150;
yy747:
		YYDEBUG(747, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy748;
				if (yych <= '9') goto yy149;
			} else {
				if (yych == 'E') goto yy749;
				if (yych <= 'Z') goto yy149;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy149;
			} else {
				if (yych <= 'e') goto yy749;
				if (yych <= 'z') goto yy149;
				if (yych >= 0x80) goto yy149;
			}
		}
yy748:
		YYDEBUG(748, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ENDFOR);
}
yy749:
		YYDEBUG(749, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy750;
		if (yych != 'a') goto yy150;
yy750:
		YYDEBUG(750, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy751;
		if (yych != 'c') goto yy150;
yy751:
		YYDEBUG(751, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy752;
		if (yych != 'h') goto yy150;
yy752:
		YYDEBUG(752, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(753, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ENDFOREACH);
}
yy754:
		YYDEBUG(754, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy755;
		if (yych != 'c') goto yy150;
yy755:
		YYDEBUG(755, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy756;
		if (yych != 'l') goto yy150;
yy756:
		YYDEBUG(756, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy757;
		if (yych != 'a') goto yy150;
yy757:
		YYDEBUG(757, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy758;
		if (yych != 'r') goto yy150;
yy758:
		YYDEBUG(758, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy759;
		if (yych != 'e') goto yy150;
yy759:
		YYDEBUG(759, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(760, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ENDDECLARE);
}
yy761:
		YYDEBUG(761, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy762;
		if (yych != 't') goto yy150;
yy762:
		YYDEBUG(762, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy763;
		if (yych != 'y') goto yy150;
yy763:
		YYDEBUG(763, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(764, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_EMPTY);
}
yy765:
		YYDEBUG(765, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy766;
		if (yych != 'e') goto yy150;
yy766:
		YYDEBUG(766, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy767;
				if (yych <= '9') goto yy149;
			} else {
				if (yych == 'I') goto yy768;
				if (yych <= 'Z') goto yy149;
			}
		} else {
			if (yych <= 'h') {
				if (yych != '`') goto yy149;
			} else {
				if (yych <= 'i') goto yy768;
				if (yych <= 'z') goto yy149;
				if (yych >= 0x80) goto yy149;
			}
		}
yy767:
		YYDEBUG(767, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ELSE);
}
yy768:
		YYDEBUG(768, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy769;
		if (yych != 'f') goto yy150;
yy769:
		YYDEBUG(769, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(770, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ELSEIF);
}
yy771:
		YYDEBUG(771, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy772;
		if (yych != 'o') goto yy150;
yy772:
		YYDEBUG(772, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(773, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ECHO);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(774, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy782;
				if (yych <= '\n') goto yy776;
				if (yych <= '\f') goto yy782;
			} else {
				if (yych == ' ') goto yy776;
				if (yych <= ',') goto yy782;
				goto yy778;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy782;
				if (yych <= 'Z') goto yy780;
				if (yych <= '^') goto yy782;
				goto yy780;
			} else {
				if (yych <= '`') goto yy782;
				if (yych <= 'z') goto yy780;
				if (yych <= 0x7F) goto yy782;
				goto yy780;
			}
		}
yy776:
		YYDEBUG(776, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy788;
yy777:
		YYDEBUG(777, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy778:
		YYDEBUG(778, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy785;
yy779:
		YYDEBUG(779, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
yy780:
		YYDEBUG(780, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy784;
yy781:
		YYDEBUG(781, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy782:
		YYDEBUG(782, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy779;
yy783:
		YYDEBUG(783, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy784:
		YYDEBUG(784, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy783;
		}
		goto yy781;
yy785:
		YYDEBUG(785, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(786, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy787:
		YYDEBUG(787, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy788:
		YYDEBUG(788, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy787;
		}
		goto yy777;
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(789, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy793;
			if (yych <= 'Z') goto yy791;
			if (yych <= '^') goto yy793;
		} else {
			if (yych <= '`') goto yy793;
			if (yych <= 'z') goto yy791;
			if (yych <= 0x7F) goto yy793;
		}
yy791:
		YYDEBUG(791, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy792;
				if (yych <= '9') goto yy795;
			} else {
				if (yych <= '[') goto yy795;
				if (yych >= '_') goto yy795;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy792;
				if (yych <= 'z') goto yy795;
			} else {
				if (yych <= '}') goto yy795;
				if (yych >= 0x80) goto yy795;
			}
		}
yy792:
		YYDEBUG(792, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
yy793:
		YYDEBUG(793, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy792;
yy794:
		YYDEBUG(794, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy795:
		YYDEBUG(795, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy794;
		}
		if (yych == '[') goto yy797;
		if (yych == '}') goto yy797;
		YYDEBUG(796, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy792;
yy797:
		YYDEBUG(797, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(798, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN_WITH_STR(T_STRING_VARNAME, 0);
}
	}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(799, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(801, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(802, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = -1;

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_START(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					YYCURSOR -= indentation;
					heredoc_label->indentation = indentation;

					BEGIN(ST_END_HEREDOC);

					goto nowdoc_scan_done;
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!EG(exception) && spacing != -1 && PARSER_MODE()) {
		zend_bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		if (!strip_multiline_string_indentation(
				zendlval, indentation, spacing == HEREDOC_USING_SPACES,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	HANDLE_NEWLINES(yytext, yyleng - newline);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 112, 112, 112, 112, 112, 112, 
			112, 112,   0,   0,   0,   0,   0,   0, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,   0, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(803, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '0') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy817;
					if (yych <= '\n') goto yy813;
					goto yy817;
				} else {
					if (yych <= '\r') goto yy813;
					if (yych <= 0x1F) goto yy817;
					goto yy813;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy812;
					if (yych <= '#') goto yy813;
					goto yy808;
				} else {
					if (yych == '\'') goto yy813;
					if (yych <= '/') goto yy812;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= 'Z') {
					if (yych <= '9') goto yy807;
					if (yych <= '@') goto yy812;
					goto yy815;
				} else {
					if (yych <= '[') goto yy812;
					if (yych <= '\\') goto yy813;
					goto yy810;
				}
			} else {
				if (yych <= '`') {
					if (yych == '_') goto yy815;
					goto yy812;
				} else {
					if (yych <= 'z') goto yy815;
					if (yych <= '~') goto yy812;
					if (yych <= 0x7F) goto yy817;
					goto yy815;
				}
			}
		}
		YYDEBUG(805, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych <= '9') {
				if (yych >= '0') goto yy829;
			} else {
				if (yych == 'B') goto yy826;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= 'X') goto yy828;
				if (yych >= 'b') goto yy826;
			} else {
				if (yych == 'x') goto yy828;
			}
		}
yy806:
		YYDEBUG(806, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy807:
		YYDEBUG(807, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy825;
yy808:
		YYDEBUG(808, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy809;
			if (yych <= 'Z') goto yy821;
			if (yych >= '_') goto yy821;
		} else {
			if (yych <= '`') goto yy809;
			if (yych <= 'z') goto yy821;
			if (yych >= 0x80) goto yy821;
		}
yy809:
		YYDEBUG(809, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' or '-' can be valid, but returning other tokens will allow a more explicit parse error */
	RETURN_TOKEN(yytext[0]);
}
yy810:
		YYDEBUG(810, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(811, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN(']');
}
yy812:
		YYDEBUG(812, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy809;
yy813:
		YYDEBUG(813, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(814, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy815:
		YYDEBUG(815, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy820;
yy816:
		YYDEBUG(816, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy817:
		YYDEBUG(817, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(818, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy819:
		YYDEBUG(819, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy820:
		YYDEBUG(820, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy819;
		}
		goto yy816;
yy821:
		YYDEBUG(821, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(822, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy821;
			} else {
				if (yych <= '@') goto yy823;
				if (yych <= 'Z') goto yy821;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy821;
			} else {
				if (yych <= 'z') goto yy821;
				if (yych >= 0x80) goto yy821;
			}
		}
yy823:
		YYDEBUG(823, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy824:
		YYDEBUG(824, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy825:
		YYDEBUG(825, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy824;
		}
		goto yy806;
yy826:
		YYDEBUG(826, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy834;
		}
yy827:
		YYDEBUG(827, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy806;
yy828:
		YYDEBUG(828, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy832;
		}
		goto yy827;
yy829:
		YYDEBUG(829, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(830, *YYCURSOR);
		if (yych <= '/') goto yy831;
		if (yych <= '9') goto yy829;
yy831:
		YYDEBUG(831, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext)));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy832:
		YYDEBUG(832, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(833, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy832;
		}
		goto yy831;
yy834:
		YYDEBUG(834, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(835, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy834;
		}
		goto yy831;
	}
}


emit_token_with_str:
	zend_copy_value(zendlval, (yytext + offset), (yyleng - offset));

emit_token_with_val:
	if (PARSER_MODE()) {
		ZEND_ASSERT(Z_TYPE_P(zendlval) != IS_UNDEF);
		elem->ast = zend_ast_create_zval_with_lineno(zendlval, start_line);
	}

emit_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, SCNG(on_event_context));
	}
	return token;

return_whitespace:
	HANDLE_NEWLINES(yytext, yyleng);
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, T_WHITESPACE, start_line, SCNG(on_event_context));
	}
	if (PARSER_MODE()) {
		start_line = CG(zend_lineno);
		goto restart;
	} else {
		return T_WHITESPACE;
	}

skip_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, SCNG(on_event_context));
	}
	start_line = CG(zend_lineno);
	goto restart;
}
