#ifndef _GUI_EVENT_H
#define _GUI_EVENT_H

typedef enum _TGuiEventID {
	GUIEVENT_NULL,
	//core events
	GUIEVENT_ENABLE,
	GUIEVENT_DISABLE,
	GUIEVENT_CREATE,
	GUIEVENT_DESTROY,
	GUIEVENT_PROCESS,
	GUIEVENT_RENDER,
	//touch events
	GUIEVENT_TOUCHDOWN,
	GUIEVENT_TOUCHUP,
	GUIEVENT_TAP,
	//key events
	GUIEVENT_KEYDOWN,
	GUIEVENT_KEYUP,
	GUIEVENT_KEYREPEAT,
	//object events
	GUIEVENT_SELECTED, //buttons, menus, etc.
} TGuiEventID;

typedef enum _TGuiEventReturn {
	GUIEVENTRET_HANDLED,
	GUIEVENTRET_NOTHANDLED,
} TGuiEventReturn;

#define GUIEVENT_ARGTYPE(id) T##id##Arg
#define GUIEVENT_DECLAREARG(id) \
	struct GUIEVENT_ARGTYPE(id); \
	typedef struct GUIEVENT_ARGTYPE(id) GUIEVENT_ARGTYPE(id); \
	struct GUIEVENT_ARGTYPE(id)
#define GUIEVENT_DECLAREARG_VOID(id) \
	typedef void* GUIEVENT_ARGTYPE(id)
#define GUIEVENT_DECLAREARG_ALIAS(id, alias) \
	typedef struct GUIEVENT_ARGTYPE(alias) GUIEVENT_ARGTYPE(id)

GUIEVENT_DECLAREARG_VOID(GUIEVENT_ENABLE);
GUIEVENT_DECLAREARG_VOID(GUIEVENT_DISABLE);
GUIEVENT_DECLAREARG_VOID(GUIEVENT_CREATE);
GUIEVENT_DECLAREARG_VOID(GUIEVENT_DESTROY);
GUIEVENT_DECLAREARG_VOID(GUIEVENT_PROCESS);
GUIEVENT_DECLAREARG_VOID(GUIEVENT_RENDER);
GUIEVENT_DECLAREARG_VOID(GUIEVENT_SELECTED);

GUIEVENT_DECLAREARG(GUIEVENT_TAP) {
	s32 xPos;
	s32 yPos;
};
GUIEVENT_DECLAREARG_ALIAS(GUIEVENT_TOUCHDOWN, GUIEVENT_TAP);
GUIEVENT_DECLAREARG_ALIAS(GUIEVENT_TOUCHUP, GUIEVENT_TAP);

GUIEVENT_DECLAREARG(GUIEVENT_KEYREPEAT) {
	u32 keys;
};
GUIEVENT_DECLAREARG_ALIAS(GUIEVENT_KEYDOWN, GUIEVENT_KEYREPEAT);
GUIEVENT_DECLAREARG_ALIAS(GUIEVENT_KEYUP, GUIEVENT_KEYREPEAT);

#endif
