# Teach Blocks

Overview of lesson instructions for the @boardname@.

## @short Teach

The [lessons](/lessons) promote computational thinking and computer science literacy from an early age and provide opportunities for learning these skills within the context of public and private education, where they will be available to Year 7 students. This page is a 'how to manual' for using the lessons in the classroom.

## @section full

##  Summary

The [lessons](/lessons) promote computational thinking and computer science literacy from an early age and provide opportunities for learning these skills within the context of public education, where they will be available to Year 7 students. You will find comprehensive teacher training and preparation (lesson plans, videos, guided tutorials, quiz, challenges, and quiz answers). The curriculum has been organized for students from Beginner to Advanced lessons in an effort to build student confidence with computational thinking and coding concepts. The lesson has been constructed with a teacher lesson plan, video(s), activity, quiz, challenges, and quiz answers to demonstrate mastery with the Progression Pathways and Computational Thinking Framework. The lesson should occur on-site during a single instructional block.

##  Lesson Resources

1) Lesson Plan

The lesson plan maps to the Progressions Pathways, Computing Curriculum, and QuickStart Computing Glossary. The lesson plan explains the concepts being taught for computational thinking while supporting your classroom instruction. A lesson plan also contains Quick Links to the lesson's tutorial, challenges, quiz, and quiz answers as shown in the [blink lesson plan](/lessons/blink).

2) Activity

Expand your knowledge of programming with lots of great step-by-step activities. All the lessons come with instructions that will drive the students to a complete, functional code. These activities are very directive to make sure that students keep progressing. When the activities are over, additional challenges are given to advance code through printed instructions. An activity contains supporting videos as shown with the [blink activity](/lessons/blink/activity).



3) Quiz

Expand your knowledge of computational thinking and computer science literacy with lots of great quizzes. All the tutorials come with quiz questions that will encourage the students to process and evaluate the concepts being introduced throughout the lesson. The quiz questions are mapped to the concepts being introduced in the lesson to make sure that students understand the computer science concepts. Quizzes apply the concepts taught in the tutorial as shown with the [blink quiz](/lessons/blink/quiz).

4) Quiz Answers

The quiz answers provide responses to the quiz. This will allow teachers to accurately review and grade student responses. Please review a sample of the quiz answers provided with the [blink quiz answers](/lessons/blink/quiz-answers).

5) Challenges

After the student completes the quiz, tutorial, and compiles the code onto the @boardname@, distribute the lesson’s challenges. Challenges are additional customizing and exercises for the students. Challenges reinforce the concepts followed in the tutorial and quiz responses as shown with the [blink challenges](/lessons/blink/challenges).

## Teacher Directions

1)  Teacher select a lesson from the [lessons](/lessons)

2) Print the quiz and the challenges for each student

3) Print the quiz answers from you

4) Distribute the printed quiz for every student

5) Complete quiz questions by following the the guided tutorials

6) Compile the code from the tutorial onto the @boardname@

7)  Distribute the challenges for additional coding through paper instructions

## Teacher Supplies

1) Print: Lesson Quiz (1 copy per student)

2) Print: Lesson Activity (1 copy per student)

3) Print: Lesson Challenge (1 copy per student)

## Lesson Timeline

``00:00`` Introduce Objectives of Lesson Plan

``05:00`` Distribute Lesson Quiz

``07:00`` Access @boardname@ website

``10:00`` Start Lesson Activity & Lesson Quiz

``30:00`` Finish Lesson Tutorial & Lesson Quiz

``35:00`` Start Lesson Challenges

``55:00`` Finish Lesson

``60:00`` Homework: Complete Challenges

