# Introduction

When we first started teaching computer science, we discovered two important things. We found that existing curriculum for beginners focused mostly on solving math problems or constructing geometric shapes and that there was a certain type of student that signed up for computer science classes and these students were almost always boys. We wondered whether a different approach to teaching the basics of computer programming would be more engaging and also attract a larger variety of different types of students, both boys and girls.
 
We decided to focus on what knowing how to program allowed you to do and create. Ultimately all programs are created to solve a problem or serve a purpose. The problem may be local or global, the purpose may be anything from helping doctors treat patients to pure entertainment. By starting with interesting problems the students wanted to solve, they were much more engaged in learning to code. They saw coding skills as an important part of building creative solutions.

With this approach, we found that not only did we get more girls taking the course, we also got a more diverse group of boys. Opportunities for collaboration increased, and all the students got to see where their talents and skills meshed with others' interests and experiences, to make a whole that was greater than the sum of its parts.

We are now at the point where a third of the students taking computer science are girls, and more importantly, students are coming out of the course not only with an understanding of code, but also knowing how to read through professionally written code, and take an idea from brainstorming through prototyping to build something that matters.

> _- Authors Mary Kiang and Douglas Kiang_

## Course Introduction
This is an introduction to coding and computer science by way of making and design, using the revolutionary new micro:bit microcontroller board, and Microsoft's easy and powerful MakeCode block-based coding environment. It is a project-based curriculum with a maker philosophy at its core; the idea is that by making physical objects, students create a context for learning the coding and computer science concepts. 

![micro:bit man](/static/courses/csintro/microbitman.jpg)

* micro:bits may be purchased from these resellers:

>   http://microbit.org/resellers (you will need 1 micro:bit per student for this course).  The "micro:bit Go Kit" includes a battery pack and USB cable as well.

* Other optional suggested micro:bit accessories include:

> * [ ] Alligator/Crocodile clip cables
  * [ ]	Headphone/earbuds (for audio)
  * [ ] Servo motor (for movement)
  * [ ] Croc clip to Male connector (for connecting to Servo motor)
  * [ ] Croc clip to Headphone jack adapter (http://microbit-accessories.co.uk/)
  * [ ] Copper tape

* MakeCode for the micro:bit is a free web app: https://makecode.microbit.org

Copper tape is inexpensive and super useful in all sorts of maker activities so it’s worth it to invest in a few rolls to keep on hand for micro:bit projects. We use it in [Lesson 9 (Binary Cash Register)](/courses/csintro/binary/project). You can purchase copper tape at https://www.adafruit.com/product/1128/ and https://www.sparkfun.com/products/10561.

When students complete this course they will have a good understanding of computer science concepts that can serve as the foundation for future study. They will develop powerful design skills that they can use in future projects of all types, whether they are designing 3D printed prototypes or creating apps that serve a real world purpose.

This course is targeted to middle school grades 6-8 (ages 11-14 years).  It is also written for teachers who may not have a Computer Science background, or may be teaching an "Intro to Computer Science" course for the first time.

This course takes approximately 14 weeks to complete, spending about 1 week on each of the first 11 lessons, and 3 weeks for students to complete the final project at the end.  Of course, teachers should feel free to customize the curriculum to meet individual school or district resources and timeframe.

## Overall Course Scope & Sequence:

1. [Making](/courses/csintro/making) 
2. [Algorithms](/courses/csintro/algorithms)
3. [Variables](/courses/csintro/variables)
4. [Conditionals](/courses/csintro/conditionals)
5. [Iteration](/courses/csintro/iteration)
6. [Review/Mini-Project](courses/csintro/miniproject)
7. [Coordinate grid system](/courses/csintro/coordinates)
8. [Booleans](/courses/csintro/booleans)
9. [Bits, bytes, and binary](/courses/csintro/binary) 
10. [Radio](/courses/csintro/radio)
11. [Arrays](/courses/csintro/arrays)
12. [Independent final project](/courses/csintro/finalproject)

Each of the 12 lessons is comprised of the following parts:

* Topic Introduction
* Unplugged Activity (30 min) ̶  An offline game or activity that demonstrates the concept/topic
* micro:bit Activity (45-60 min) ̶- An activity that everyone makes on their micro:bit that teaches the skills learned in this lesson.
* Project (60-120 min) ̶- A prompt for an original project that each student will create to demonstrate their understanding of the skills and concepts covered in this lesson.
* Project Mods ̶  Examples of additional things students can do to extend the project
* Assessment ̶- A project rubric and guidance for grading the project.
* Standards ̶ -A list of [CSTA K-12 Computer Science Standards](https://www.csteachers.org/?page=CSTA_Standards) and/or concepts covered by this lesson.

### Topic introduction

The introduction to each lesson will tell you what learning objectives are covered in the lesson, and presents an overview of that lesson's topic. Some lessons have a specific activity that can help introduce the topic to students in a fun way.

### Unplugged activity (30 min)
Each lesson starts with an unplugged activity, which doesn't require a computer or a micro:bit. It's a chance to get students up and moving around, and is designed to be a fun introduction to the computer science concept covered in that lesson. Unplugged activities are an important way to demonstrate new concepts in a tangible, often kinesthetic, way. Since so many computer-based topics are abstract, unplugged activities are very effective at fostering understanding that students will then demonstrate in later activities.

### micro:bit activity (45–60 min)
Each lesson also contains a micro:bit activity, which we informally refer to as a "birdhouse" activity, after the innumerable wooden birdhouses so many of us made in wood shop as a way to master basic skills. Each lesson's micro:bit activity is an example that walks students step-by-step through building a project that demonstrates that lesson's topic. By the time students finish the activity, they will have written code that they can use in a different project of their own design.

Some students will finish the activity more quickly than others. Those students can then be a helpful resource for their classmates, or they can challenge themselves by modifying, or "modding" the activity to do something different. We have provided examples and suggestions at the end of many of these activities, and feel free to suggest your own (or encourage your students to come up with their own ideas!)

### Project (60–120 min)
After presenting the concept in an unplugged fashion, then walking students through a demonstration activity, it is time to challenge students to use those skills to create something that is creative and original. Students will be working on their projects in a "collaboratively independent" way, which means each student is responsible for turning in his or her own project, but are encouraged to work together and help each other while doing so. Some form of reflection is an important part of documenting the learning that has taken place, and it's a great idea to share out the final projects and reflections, either at an event or on a blog.

There are also a series of Project Mods that students can do to extend the project they have created. These are useful for students who already have some experience with coding or who want an extra challenge.

### Assessment
A rubric is provided for each project that can be customized according to what students are being asked to demonstrate. For the Activities we just expect students to do them, so those are fairly simple to check off. For the Projects, however, there is often a range of grades based on how closely the project meets the specifications of the assignment.

### Standards
Where applicable, we have mapped each of the lessons to the [Computer Science Teachers Association (CSTA) K-12 Standards](https://www.csteachers.org/?page=CSTA_Standards), which are US nationally recognized standards for computer science education.
