# Coordinate grid and LEDs

![Sample Heart Simulator](/static/courses/csintro/coordinates/cover.png)

This lesson introduces the use of coordinates to store data or the results of mathematical operations. It gives students practice programming for the LEDs of the micro:bit screen using coordinates, and introduces the basic game blocks of MakeCode.

## Lesson objectives

Students will...
* Understand that the 5 x 5 grid of LEDs on the micro:bit represents a coordinate grid with the origin (0,0) in the top left corner.
* Understand that the values of the x coordinates range from 0 through four and increase from left to right.
* Understand that the values of the y coordinates range from 0 through four and increase from top to bottom.
* Learn how to refer to an individual LED by its **X** and **Y** coordinates.
* Learn how to plot (turn on) and unplot (turn off) individual LEDs and how to toggle between these two states.
* Learn how to check the current on or off status of an individual LED as well as check and set the brightness level.
* Apply the above knowledge and skills to create a unique program that uses coordinates as an integral part of the program.

## Lesson structure

* Introduction: Coordinate Grid
* Unplugged Activity: Battleship
* micro:bit Activities: Animation and Patterns
* Project: Screensaver or Game
* Assessment: Rubric 
* Standards: Listed

## Lesson plan

1. [**Overview**: Coordinate grid and LEDs](/courses/csintro/coordinates/overview)
2. [**Unplugged**: Battleship](/courses/csintro/coordinates/unplugged)
3. [**Activity**: Animation and patterns](/courses/csintro/coordinates/activity)
4. [**Project**: Screensaver or game](/courses/csintro/coordinates/project)

## Related standards

[Targeted CSTA standards](/courses/csintro/coordinates/standards)