var pxtTargetBundle = {
  "id": "microbit",
  "nickname": "microbit",
  "name": "makecode.microbit.org",
  "title": "Microsoft MakeCode for micro:bit",
  "description": "A Blocks / JavaScript code editor for the micro:bit powered by Microsoft MakeCode.",
  "corepkg": "core",
  "bundleddirs": [
    "libs/core",
    "libs/radio",
    "libs/devices",
    "libs/bluetooth"
  ],
  "cloud": {
    "workspace": false,
    "packages": true,
    "sharing": true,
    "publishing": true,
    "preferredPackages": [
      "Microsoft/pxt-neopixel"
    ],
    "githubPackages": true
  },
  "compile": {
    "isNative": false,
    "hasHex": true,
    "deployDrives": "(MICROBIT|MBED)",
    "driveName": "MICROBIT",
    "hexMimeType": "application/x-microbit-hex",
    "openocdScript": "source [find interface/cmsis-dap.cfg]; source [find target/nrf51.cfg]",
    "upgrades": [
      {
        "type": "package",
        "map": {
          "microbit": "core",
          "microbit-bluetooth": "bluetooth",
          "microbit-radio": "radio",
          "microbit-devices": "devices",
          "microbit-led": "",
          "microbit-music": "",
          "microbit-game": "",
          "microbit-pins": "",
          "microbit-serial": ""
        }
      },
      {
        "type": "missingPackage",
        "map": {
          "radio\\s*\\.": "radio",
          "bluetooth\\s*\\.": "bluetooth",
          "devices\\s*\\.": "devices"
        }
      },
      {
        "type": "api",
        "map": {
          "bluetooth\\s*\\.uartRead\\s*\\((.*?)\\)": "bluetooth.uartReadUntil($1)",
          "bluetooth\\s*\\.uartWrite\\s*\\((.*?)\\)": "bluetooth.uartWriteUntil($1)",
          "input\\s*\\.calibrate\\s*\\(": "input.calibrateCompass("
        }
      },
      {
        "type": "blockId",
        "map": {
          "device_get_acceleration": "device_acceleration"
        }
      },
      {
        "type": "blockValue",
        "map": {
          "device_print_message.message": "text"
        }
      }
    ],
    "jsRefCounting": true
  },
  "runtime": {
    "mathBlocks": true,
    "loopsBlocks": true,
    "logicBlocks": true,
    "variablesBlocks": true,
    "textBlocks": true,
    "listsBlocks": true,
    "functionBlocks": true,
    "onStartColor": "#0078D7",
    "onStartNamespace": "basic",
    "onStartWeight": 54
  },
  "simulator": {
    "autoRun": true,
    "enableTrace": true,
    "streams": false,
    "aspectRatio": 1.22,
    "parts": true,
    "partsAspectRatio": 0.69,
    "boardDefinition": {
      "visual": "microbit",
      "gpioPinBlocks": [
        [
          "P0"
        ],
        [
          "P1"
        ],
        [
          "P2"
        ],
        [
          "P3"
        ],
        [
          "P4",
          "P5",
          "P6",
          "P7"
        ],
        [
          "P8",
          "P9",
          "P10",
          "P11",
          "P12"
        ],
        [
          "P16"
        ]
      ],
      "gpioPinMap": {
        "P0": "P0",
        "P1": "P1",
        "P2": "P2",
        "P3": "P3",
        "P4": "P4",
        "P5": "P5",
        "P6": "P6",
        "P7": "P7",
        "P8": "P8",
        "P9": "P9",
        "P10": "P10",
        "P11": "P11",
        "P12": "P12",
        "P13": "P13",
        "P14": "P14",
        "P15": "P15",
        "P16": "P16",
        "P19": "P19",
        "P20": "P20"
      },
      "spiPins": {
        "MOSI": "P15",
        "MISO": "P14",
        "SCK": "P13"
      },
      "i2cPins": {
        "SDA": "P20",
        "SCL": "P19"
      },
      "analogInPins": [
        "P0",
        "P1",
        "P2",
        "P3",
        "P10"
      ],
      "groundPins": [
        "GND"
      ],
      "threeVoltPins": [
        "+3v3"
      ],
      "attachPowerOnRight": true,
      "onboardComponents": [
        "accelerometer",
        "buttonpair",
        "ledmatrix",
        "speaker",
        "bluetooth",
        "thermometer",
        "compass"
      ],
      "useCrocClips": true,
      "marginWhenBreadboarding": [
        0,
        0,
        80,
        0
      ]
    }
  },
  "compileService": {
    "yottaTarget": "bbc-microbit-classic-gcc",
    "yottaCorePackage": "microbit",
    "githubCorePackage": "lancaster-university/microbit",
    "gittag": "v2.0.0-rc11",
    "serviceId": "microbit",
    "yottaBinary": "pxt-microbit-app-combined.hex"
  },
  "serial": {
    "productFilter": "0x0204",
    "vendorFilter": "0x0d28",
    "nameFilter": "^mbed Serial Port",
    "log": true,
    "chromeExtension": "hjcflblhjoglmjjkecamiegdigfkgeni"
  },
  "appTheme": {
    "accentColor": "#5C005C",
    "logoUrl": "https://microbit.org/code/",
    "logo": "data:image/svg+xml;base64,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",
    "docsLogo": "data:image/svg+xml;base64,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",
    "portraitLogo": "data:image/svg+xml;base64,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",
    "footerLogo": "data:image/svg+xml;base64,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",
    "cardLogo": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAALQAAAC0CAAAAAAYplnuAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAAmJLR0QA/4ePzL8AAAAHdElNRQfgChQCADRta0mQAAAE/UlEQVR42u3bW0gUURgH8PGyVkimUttVMqXAypIwxAzDoB7Egl567kGlC2F0o3qoMAospDclk7ToQhAIGYaIWSakD+oiBUUlaNCNzCzJ2lpPjZY0850ze2bndk58/9f95pyfyzg756YQCaN4DUC0yEE0ohEtQBCNaEQLEEQjGtECBNGIRrQAQTSiES1AEI1oRAsQRCMa0QIE0YhGtABBtLjo0NueOzUnS4tyc6wmt6j0ZM2dnrchZ9FjjSWpsYrdiU0taRxzCP2hflu87eC/id9W/8F29FBlfoxj4snE5FcO2Ykeq0h0WDyZxAqu24QHHapLcYWsJqWO49+SA92U6RpZTWaTdXRvgatkNQW9FtFXprluVpRpl62gQ4c9IKs5GIoY/bnII7OiFI5EiO5f4ZlZUTKeR4S+P9tDs6IktUSAbvZ5av79StJoGv0s0WOzosx8YhI9vMxr8u+kD5lC/9zkNXgiG3+YQe8N215UwiyrSYgK28tuE+gLRg35i6saugaDxHqCg10NVcVzjTqr5ka3sx8caQcemh4dhUmo4+BSZn++B5zoEPNHZfVdm8F/07KG1eXyn3zoS4zrU6+OO2QmZPzaEkavtVzosUXUi2MrvjtGVvO9gj5kXviVB32Wem1yq6NkNa3J1J7PcKA/JtGuzHjhuJmQFxm0rhPAMB2iD9Eu3DzC1avVjGymdV4WFv1qOuWyrFFXzISMZlF6j+sPh95Huco/4JKZkAE/pf9d4dCLKX9ph2tmQjriIGC+7lGrR/dQ/tAaF82E1FAEncbo4/CKta6aCVkLCUeN0avhFW0uo9sgYYUhuh9eUOiymZBCiND+SujQ50F5dJ/r6L5ooKg0Qm8Q4IumfdX5BuhPcA76Ir3doea6wA9iIeNPr9/qZ3x2EShiPrHRAXh3vKM0GjyRrn42Y317pOSXRTPVFpK2v6Z9+g7eHwE2ugkU51Ha7J16xETvN7VWMpXqqXWQ5Bu0z/OAQzP/q0XXguJzsMX7/w7GciO5RzTD5tOUgnPAoRkKaNHloLgTNDiapik4Zd7cqhmF+wKwohM4ytnonaB4EDS4R1vg6zVr/pKqbSELDuwHgWMnG71VXxsFGhzV/5PsMIuu13cCR8tBMCOylY3O1tfOAe2160syzaLBRFA5rJmjr8lmoxfoa1eB5ir1JTFw4GmcdfoWtsCaVfqaBWw0eJctAM0Vg9vtsUk0mPZeCmvA6lScpW8ajNU9/6Y57ulW4e5pjqfHsL7E86cHz3Nad1N7/5zm+UX8rO3T+19ErnePNsHePfje8npWTt3yZWYfHZOx9S0vAIqp79PfjkzspYjLjnhS0s73af6Ry/u7l7otTf3aN3KRcowo52hcynkPKWeY5JzLk3LWVMr5aTlXAqRcc5FydUvOdUQpV2y9WhsPWlobZ+5CSLvh3C4EcjOd0SvfLgSD/R7Z9xwit+ewuuTd72G0sybjyCO7v+7xzmMrmf1x76wJs4dpXkn17e43dmwKCr3pvl1dMs+oM/49TDy7xXz+uVbjD7/H0sxuMTn35Um5A1LOvaZy7uqVc/+0nDvV5TwTIOfpCyLlORci54kiIuXZLSLnKTki5XlENRKe/JyIfGds/9wm0p1m/hPpzo0LEkQjGtECBNGIRrQAQTSiES1AEI1oRAsQRCMa0QIE0YhGtABBNKIRLUAQjWhECxBEI/p/Q/8CGHHKBbBSRXAAAAAldEVYdGRhdGU6Y3JlYXRlADIwMTYtMTAtMjBUMDI6MDA6NTIrMDI6MDCs+cxDAAAAJXRFWHRkYXRlOm1vZGlmeQAyMDE2LTEwLTIwVDAyOjAwOjUyKzAyOjAw3aR0/wAAAFd6VFh0UmF3IHByb2ZpbGUgdHlwZSBpcHRjAAB4nOPyDAhxVigoyk/LzEnlUgADIwsuYwsTIxNLkxQDEyBEgDTDZAMjs1Qgy9jUyMTMxBzEB8uASKBKLgDqFxF08kI1lQAAAABJRU5ErkJggg==",
    "appLogo": "data:image/png;base64,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",
    "organization": "Microsoft MakeCode",
    "organizationUrl": "https://makecode.com/",
    "organizationLogo": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAS0AAAEtCAMAAABqPcbcAAAABGdBTUEAALGPC/xhBQAAAwBQTFRFAAAAf7oAAKTvP7ryb8v18lAi9XtYnss/tthv/7kA/8o//9dv95yCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAApRt6LQAAAQB0Uk5T////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////AFP3ByUAAAAJcEhZcwAALiEAAC4hAQdb/P8AAAAZdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuMTJDBGvsAAACn0lEQVR4Xu3QsVUDMRQAQYHB5gz9tyuSX8BtpmCmgn27Nvet/X2U53SN18dR3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq1n4e5W82jZ/XUdZkcYdbhVuFW4VbhVuFW4VbhVuFW4VbhVuFW4VbxdqPo3xN1/h9H2Xtz6M8ZtN4X0dxq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcKtwq3CrcOu+6/oHGlSc5B6nYrEAAAAASUVORK5CYII=",
    "organizationWideLogo": "data:image/png;base64,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",
    "homeUrl": "https://makecode.microbit.org/",
    "embedUrl": "https://makecode.microbit.org/",
    "shareUrl": "https://makecode.microbit.org/",
    "privacyUrl": "https://makecode.com/privacy",
    "termsOfUseUrl": "https://makecode.com/termsofuse",
    "githubUrl": "https://github.com/Microsoft/pxt-microbit",
    "legacyDomain": "pxt.microbit.org",
    "galleries": {
      "Projects": "projects",
      "Examples": "examples"
    },
    "projectGallery": "projects",
    "exampleGallery": "examples",
    "crowdinProject": "kindscript",
    "boardName": "micro:bit",
    "driveDisplayName": "MICROBIT",
    "sideDoc": "tutorials/getting-started",
    "feedbackUrl": "https://www.research.net/r/MCmicro",
    "appStoreID": "1092687276",
    "mobileSafariDownloadProtocol": "microbithex://?data",
    "extendEditor": true,
    "docMenu": [
      {
        "name": "Support",
        "path": "https://support.microbit.org/"
      },
      {
        "name": "Getting started",
        "tutorial": true,
        "path": "/tutorials/getting-started"
      },
      {
        "name": "Projects",
        "path": "/projects"
      },
      {
        "name": "Reference",
        "path": "/reference"
      },
      {
        "name": "Blocks",
        "path": "/blocks"
      },
      {
        "name": "JavaScript",
        "path": "/javascript"
      },
      {
        "name": "Hardware",
        "path": "/device"
      },
      {
        "name": "Buy",
        "path": "https://microbit.org/resellers"
      }
    ],
    "hasReferenceDocs": true,
    "usbDocs": "/device/usb",
    "usbHelp": [
      {
        "name": "connection",
        "os": "*",
        "browser": "*",
        "path": "/static/mb/device/usb-generic.jpg"
      },
      {
        "name": "connection",
        "os": "mac",
        "browser": "*",
        "path": "/static/mb/device/usb-mac.jpg"
      },
      {
        "name": "save",
        "os": "windows",
        "browser": "firefox",
        "path": "/static/mb/device/usb-windows-firefox-1.png"
      },
      {
        "name": "save",
        "os": "mac",
        "browser": "firefox",
        "path": "/static/mb/device/usb-osx-firefox-1.jpg"
      },
      {
        "name": "save",
        "os": "mac",
        "browser": "chrome",
        "path": "/static/mb/device/usb-osx-chrome.png"
      },
      {
        "name": "save",
        "os": "windows",
        "browser": "edge",
        "path": "/static/mb/device/usb-windows-edge-1.png"
      },
      {
        "name": "save",
        "os": "windows",
        "browser": "ie",
        "path": "/static/mb/device/usb-windows-ie11-1.png"
      },
      {
        "name": "save",
        "os": "windows",
        "browser": "chrome",
        "path": "/static/mb/device/usb-windows-chrome.png"
      },
      {
        "name": "copy",
        "os": "mac",
        "browser": "*",
        "path": "/static/mb/device/usb-osx-dnd.png"
      },
      {
        "name": "copy",
        "os": "windows",
        "browser": "*",
        "path": "/static/mb/device/usb-windows-sendto.jpg"
      }
    ],
    "invertedMenu": true,
    "coloredToolbox": true,
    "monacoToolbox": true,
    "hasAudio": true,
    "blocklyOptions": {
      "grid": {
        "spacing": 45,
        "length": 7,
        "colour": "rgba(189, 195, 199, 0.30)",
        "snap": false
      }
    },
    "highContrast": true,
    "selectLanguage": true,
    "monacoColors": {
      "editor.background": "#ecf0f1"
    },
    "TOC": [
      {
        "name": "Support",
        "subitems": [],
        "path": "https://support.microbit.org/",
        "nextName": "Projects",
        "nextPath": "/projects"
      },
      {
        "name": "Projects",
        "subitems": [
          {
            "name": "Flashing heart",
            "subitems": [],
            "path": "/projects/flashing-heart",
            "prevName": "Projects",
            "prevPath": "/projects",
            "nextName": "Smiley buttons",
            "nextPath": "/projects/smiley-buttons"
          },
          {
            "name": "Smiley buttons",
            "subitems": [],
            "path": "/projects/smiley-buttons",
            "prevName": "Flashing heart",
            "prevPath": "/projects/flashing-heart",
            "nextName": "Love meter",
            "nextPath": "/projects/love-meter"
          },
          {
            "name": "Love meter",
            "subitems": [],
            "path": "/projects/love-meter",
            "prevName": "Smiley buttons",
            "prevPath": "/projects/smiley-buttons",
            "nextName": "Rock paper scissors",
            "nextPath": "/projects/rock-paper-scissors"
          },
          {
            "name": "Rock paper scissors",
            "subitems": [],
            "path": "/projects/rock-paper-scissors",
            "prevName": "Love meter",
            "prevPath": "/projects/love-meter",
            "nextName": "Magic button trick",
            "nextPath": "/projects/magic-button-trick"
          },
          {
            "name": "Magic button trick",
            "subitems": [],
            "path": "/projects/magic-button-trick",
            "prevName": "Rock paper scissors",
            "prevPath": "/projects/rock-paper-scissors",
            "nextName": "Coin Flipper",
            "nextPath": "/projects/coin-flipper"
          },
          {
            "name": "Coin Flipper",
            "subitems": [],
            "path": "/projects/coin-flipper",
            "prevName": "Magic button trick",
            "prevPath": "/projects/magic-button-trick",
            "nextName": "Hack your headphones",
            "nextPath": "/projects/hack-your-headphones"
          },
          {
            "name": "Hack your headphones",
            "subitems": [],
            "path": "/projects/hack-your-headphones",
            "prevName": "Coin Flipper",
            "prevPath": "/projects/coin-flipper",
            "nextName": "Banana keyboard",
            "nextPath": "/projects/banana-keyboard"
          },
          {
            "name": "Banana keyboard",
            "subitems": [],
            "path": "/projects/banana-keyboard",
            "prevName": "Hack your headphones",
            "prevPath": "/projects/hack-your-headphones",
            "nextName": "Guitar",
            "nextPath": "/projects/guitar"
          },
          {
            "name": "Guitar",
            "subitems": [],
            "path": "/projects/guitar",
            "prevName": "Banana keyboard",
            "prevPath": "/projects/banana-keyboard",
            "nextName": "Duct tape wallet",
            "nextPath": "/projects/wallet"
          },
          {
            "name": "Duct tape wallet",
            "subitems": [],
            "path": "/projects/wallet",
            "prevName": "Guitar",
            "prevPath": "/projects/guitar",
            "nextName": "Watch",
            "nextPath": "/projects/watch"
          },
          {
            "name": "Watch",
            "subitems": [],
            "path": "/projects/watch",
            "prevName": "Duct tape wallet",
            "prevPath": "/projects/wallet",
            "nextName": "Soil Moisture",
            "nextPath": "/projects/soil-moisture"
          },
          {
            "name": "Soil Moisture",
            "subitems": [],
            "path": "/projects/soil-moisture",
            "prevName": "Watch",
            "prevPath": "/projects/watch",
            "nextName": "Plant Watering",
            "nextPath": "/projects/plant-watering"
          },
          {
            "name": "Plant Watering",
            "subitems": [],
            "path": "/projects/plant-watering",
            "prevName": "Soil Moisture",
            "prevPath": "/projects/soil-moisture",
            "nextName": "Reaction Time",
            "nextPath": "/projects/reaction-time"
          },
          {
            "name": "Reaction Time",
            "subitems": [],
            "path": "/projects/reaction-time",
            "prevName": "Plant Watering",
            "prevPath": "/projects/plant-watering",
            "nextName": "States of Matter",
            "nextPath": "/projects/states-of-matter"
          },
          {
            "name": "States of Matter",
            "subitems": [],
            "path": "/projects/states-of-matter",
            "prevName": "Reaction Time",
            "prevPath": "/projects/reaction-time",
            "nextName": "Hot Or Cold",
            "nextPath": "/projects/hot-or-cold"
          },
          {
            "name": "Hot Or Cold",
            "subitems": [],
            "path": "/projects/hot-or-cold",
            "prevName": "States of Matter",
            "prevPath": "/projects/states-of-matter",
            "nextName": "Voting Machine",
            "nextPath": "/projects/voting-machine"
          },
          {
            "name": "Voting Machine",
            "subitems": [],
            "path": "/projects/voting-machine",
            "prevName": "Hot Or Cold",
            "prevPath": "/projects/hot-or-cold",
            "nextName": "Infection",
            "nextPath": "/projects/infection"
          },
          {
            "name": "Infection",
            "subitems": [],
            "path": "/projects/infection",
            "prevName": "Voting Machine",
            "prevPath": "/projects/voting-machine",
            "nextName": "Fireflies",
            "nextPath": "/projects/fireflies"
          },
          {
            "name": "Fireflies",
            "subitems": [],
            "path": "/projects/fireflies",
            "prevName": "Infection",
            "prevPath": "/projects/infection",
            "nextName": "Rock Paper Scissors Teams",
            "nextPath": "/projects/rps-teams"
          },
          {
            "name": "Rock Paper Scissors Teams",
            "subitems": [],
            "path": "/projects/rps-teams",
            "prevName": "Fireflies",
            "prevPath": "/projects/fireflies",
            "nextName": "Inchworm",
            "nextPath": "/projects/inchworm"
          },
          {
            "name": "Inchworm",
            "subitems": [],
            "path": "/projects/inchworm",
            "prevName": "Rock Paper Scissors Teams",
            "prevPath": "/projects/rps-teams",
            "nextName": "Milk Carton Robot",
            "nextPath": "/projects/milk-carton-robot"
          },
          {
            "name": "Milk Carton Robot",
            "subitems": [],
            "path": "/projects/milk-carton-robot",
            "prevName": "Inchworm",
            "prevPath": "/projects/inchworm",
            "nextName": "Milk monster",
            "nextPath": "/projects/milky-monster"
          },
          {
            "name": "Milk monster",
            "subitems": [],
            "path": "/projects/milky-monster",
            "prevName": "Milk Carton Robot",
            "prevPath": "/projects/milk-carton-robot",
            "nextName": "RC Car",
            "nextPath": "/projects/rc-car"
          },
          {
            "name": "RC Car",
            "subitems": [],
            "path": "/projects/rc-car",
            "prevName": "Milk monster",
            "prevPath": "/projects/milky-monster",
            "nextName": "Timing gates",
            "nextPath": "/projects/timing-gates"
          },
          {
            "name": "Timing gates",
            "subitems": [],
            "path": "/projects/timing-gates",
            "prevName": "RC Car",
            "prevPath": "/projects/rc-car",
            "nextName": "Compass",
            "nextPath": "/projects/compass"
          },
          {
            "name": "Compass",
            "subitems": [],
            "path": "/projects/compass",
            "prevName": "Timing gates",
            "prevPath": "/projects/timing-gates",
            "nextName": "Telegraph",
            "nextPath": "/projects/telegraph"
          },
          {
            "name": "Telegraph",
            "subitems": [],
            "path": "/projects/telegraph",
            "prevName": "Compass",
            "prevPath": "/projects/compass",
            "nextName": "Railway Crossing",
            "nextPath": "/projects/railway-crossing"
          },
          {
            "name": "Railway Crossing",
            "subitems": [],
            "path": "/projects/railway-crossing",
            "prevName": "Telegraph",
            "prevPath": "/projects/telegraph",
            "nextName": "Karel",
            "nextPath": "/projects/karel"
          },
          {
            "name": "Karel",
            "subitems": [],
            "path": "/projects/karel",
            "prevName": "Railway Crossing",
            "prevPath": "/projects/railway-crossing",
            "nextName": "Examples",
            "nextPath": "/examples"
          }
        ],
        "path": "/projects",
        "prevName": "Support",
        "prevPath": "https://support.microbit.org/",
        "nextName": "Flashing heart",
        "nextPath": "/projects/flashing-heart"
      },
      {
        "name": "Examples",
        "subitems": [
          {
            "name": "Blinky",
            "subitems": [],
            "path": "/examples/blinky",
            "prevName": "Examples",
            "prevPath": "/examples",
            "nextName": "Name tag",
            "nextPath": "/examples/name-tag"
          },
          {
            "name": "Name tag",
            "subitems": [],
            "path": "/examples/name-tag",
            "prevName": "Blinky",
            "prevPath": "/examples/blinky",
            "nextName": "Rando",
            "nextPath": "/examples/rando"
          },
          {
            "name": "Rando",
            "subitems": [],
            "path": "/examples/rando",
            "prevName": "Name tag",
            "prevPath": "/examples/name-tag",
            "nextName": "Plot acceleration",
            "nextPath": "/examples/plot-acceleration"
          },
          {
            "name": "Plot acceleration",
            "subitems": [],
            "path": "/examples/plot-acceleration",
            "prevName": "Rando",
            "prevPath": "/examples/rando",
            "nextName": "Plot light level",
            "nextPath": "/examples/plot-light-level"
          },
          {
            "name": "Plot light level",
            "subitems": [],
            "path": "/examples/plot-light-level",
            "prevName": "Plot acceleration",
            "prevPath": "/examples/plot-acceleration",
            "nextName": "Plot analog pin",
            "nextPath": "/examples/plot-analog-pin"
          },
          {
            "name": "Plot analog pin",
            "subitems": [],
            "path": "/examples/plot-analog-pin",
            "prevName": "Plot light level",
            "prevPath": "/examples/plot-light-level",
            "nextName": "Servo Calibrator",
            "nextPath": "/examples/servo-calibrator"
          },
          {
            "name": "Servo Calibrator",
            "subitems": [],
            "path": "/examples/servo-calibrator",
            "prevName": "Plot analog pin",
            "prevPath": "/examples/plot-analog-pin",
            "nextName": "Game of Life",
            "nextPath": "/examples/gameofLife"
          },
          {
            "name": "Game of Life",
            "subitems": [],
            "path": "/examples/gameofLife",
            "prevName": "Servo Calibrator",
            "prevPath": "/examples/servo-calibrator",
            "nextName": "Courses",
            "nextPath": "/courses"
          }
        ],
        "path": "/examples",
        "prevName": "Karel",
        "prevPath": "/projects/karel",
        "nextName": "Blinky",
        "nextPath": "/examples/blinky"
      },
      {
        "name": "Courses",
        "subitems": [
          {
            "name": "CS Intro",
            "subitems": [
              {
                "name": "About",
                "subitems": [],
                "path": "/courses/csintro/about",
                "prevName": "CS Intro",
                "prevPath": "/courses/csintro",
                "nextName": "Introduction",
                "nextPath": "/courses/csintro/introduction"
              },
              {
                "name": "Introduction",
                "subitems": [],
                "path": "/courses/csintro/introduction",
                "prevName": "About",
                "prevPath": "/courses/csintro/about",
                "nextName": "References",
                "nextPath": "/courses/csintro/references"
              },
              {
                "name": "References",
                "subitems": [],
                "path": "/courses/csintro/references",
                "prevName": "Introduction",
                "prevPath": "/courses/csintro/introduction",
                "nextName": "Acknowledgements",
                "nextPath": "/courses/csintro/acknowledgements"
              },
              {
                "name": "Acknowledgements",
                "subitems": [],
                "path": "/courses/csintro/acknowledgements",
                "prevName": "References",
                "prevPath": "/courses/csintro/references",
                "nextName": "Making",
                "nextPath": "/courses/csintro/making"
              },
              {
                "name": "Making",
                "subitems": [
                  {
                    "name": "Introduction",
                    "subitems": [],
                    "path": "/courses/csintro/making/introduction",
                    "prevName": "Making",
                    "prevPath": "/courses/csintro/making",
                    "nextName": "Unplugged",
                    "nextPath": "/courses/csintro/making/unplugged"
                  },
                  {
                    "name": "Unplugged",
                    "subitems": [],
                    "path": "/courses/csintro/making/unplugged",
                    "prevName": "Introduction",
                    "prevPath": "/courses/csintro/making/introduction",
                    "nextName": "Walkthrough",
                    "nextPath": "/courses/csintro/making/activity"
                  },
                  {
                    "name": "Walkthrough",
                    "subitems": [],
                    "path": "/courses/csintro/making/activity",
                    "prevName": "Unplugged",
                    "prevPath": "/courses/csintro/making/unplugged",
                    "nextName": "Project",
                    "nextPath": "/courses/csintro/making/project"
                  },
                  {
                    "name": "Project",
                    "subitems": [],
                    "path": "/courses/csintro/making/project",
                    "prevName": "Walkthrough",
                    "prevPath": "/courses/csintro/making/activity",
                    "nextName": "Standards",
                    "nextPath": "/courses/csintro/making/standards"
                  },
                  {
                    "name": "Standards",
                    "subitems": [],
                    "path": "/courses/csintro/making/standards",
                    "prevName": "Project",
                    "prevPath": "/courses/csintro/making/project",
                    "nextName": "Algorithms",
                    "nextPath": "/courses/csintro/algorithms"
                  }
                ],
                "path": "/courses/csintro/making",
                "prevName": "Acknowledgements",
                "prevPath": "/courses/csintro/acknowledgements",
                "nextName": "Introduction",
                "nextPath": "/courses/csintro/making/introduction"
              },
              {
                "name": "Algorithms",
                "subitems": [
                  {
                    "name": "Overview",
                    "subitems": [],
                    "path": "/courses/csintro/algorithms/overview",
                    "prevName": "Algorithms",
                    "prevPath": "/courses/csintro/algorithms",
                    "nextName": "Unplugged",
                    "nextPath": "/courses/csintro/algorithms/unplugged"
                  },
                  {
                    "name": "Unplugged",
                    "subitems": [],
                    "path": "/courses/csintro/algorithms/unplugged",
                    "prevName": "Overview",
                    "prevPath": "/courses/csintro/algorithms/overview",
                    "nextName": "Activity",
                    "nextPath": "/courses/csintro/algorithms/activity"
                  },
                  {
                    "name": "Activity",
                    "subitems": [],
                    "path": "/courses/csintro/algorithms/activity",
                    "prevName": "Unplugged",
                    "prevPath": "/courses/csintro/algorithms/unplugged",
                    "nextName": "Project",
                    "nextPath": "/courses/csintro/algorithms/project"
                  },
                  {
                    "name": "Project",
                    "subitems": [],
                    "path": "/courses/csintro/algorithms/project",
                    "prevName": "Activity",
                    "prevPath": "/courses/csintro/algorithms/activity",
                    "nextName": "Standards",
                    "nextPath": "/courses/csintro/algorithms/standards"
                  },
                  {
                    "name": "Standards",
                    "subitems": [],
                    "path": "/courses/csintro/algorithms/standards",
                    "prevName": "Project",
                    "prevPath": "/courses/csintro/algorithms/project",
                    "nextName": "Variables",
                    "nextPath": "/courses/csintro/variables"
                  }
                ],
                "path": "/courses/csintro/algorithms",
                "prevName": "Standards",
                "prevPath": "/courses/csintro/making/standards",
                "nextName": "Overview",
                "nextPath": "/courses/csintro/algorithms/overview"
              },
              {
                "name": "Variables",
                "subitems": [
                  {
                    "name": "Overview",
                    "subitems": [],
                    "path": "/courses/csintro/variables/overview",
                    "prevName": "Variables",
                    "prevPath": "/courses/csintro/variables",
                    "nextName": "Unplugged",
                    "nextPath": "/courses/csintro/variables/unplugged"
                  },
                  {
                    "name": "Unplugged",
                    "subitems": [],
                    "path": "/courses/csintro/variables/unplugged",
                    "prevName": "Overview",
                    "prevPath": "/courses/csintro/variables/overview",
                    "nextName": "Activity",
                    "nextPath": "/courses/csintro/variables/activity"
                  },
                  {
                    "name": "Activity",
                    "subitems": [],
                    "path": "/courses/csintro/variables/activity",
                    "prevName": "Unplugged",
                    "prevPath": "/courses/csintro/variables/unplugged",
                    "nextName": "Project",
                    "nextPath": "/courses/csintro/variables/project"
                  },
                  {
                    "name": "Project",
                    "subitems": [],
                    "path": "/courses/csintro/variables/project",
                    "prevName": "Activity",
                    "prevPath": "/courses/csintro/variables/activity",
                    "nextName": "Standards",
                    "nextPath": "/courses/csintro/variables/standards"
                  },
                  {
                    "name": "Standards",
                    "subitems": [],
                    "path": "/courses/csintro/variables/standards",
                    "prevName": "Project",
                    "prevPath": "/courses/csintro/variables/project",
                    "nextName": "Conditionals",
                    "nextPath": "/courses/csintro/conditionals"
                  }
                ],
                "path": "/courses/csintro/variables",
                "prevName": "Standards",
                "prevPath": "/courses/csintro/algorithms/standards",
                "nextName": "Overview",
                "nextPath": "/courses/csintro/variables/overview"
              },
              {
                "name": "Conditionals",
                "subitems": [
                  {
                    "name": "Overview",
                    "subitems": [],
                    "path": "/courses/csintro/conditionals/overview",
                    "prevName": "Conditionals",
                    "prevPath": "/courses/csintro/conditionals",
                    "nextName": "Unplugged",
                    "nextPath": "/courses/csintro/conditionals/unplugged"
                  },
                  {
                    "name": "Unplugged",
                    "subitems": [],
                    "path": "/courses/csintro/conditionals/unplugged",
                    "prevName": "Overview",
                    "prevPath": "/courses/csintro/conditionals/overview",
                    "nextName": "Activity",
                    "nextPath": "/courses/csintro/conditionals/activity"
                  },
                  {
                    "name": "Activity",
                    "subitems": [],
                    "path": "/courses/csintro/conditionals/activity",
                    "prevName": "Unplugged",
                    "prevPath": "/courses/csintro/conditionals/unplugged",
                    "nextName": "Project",
                    "nextPath": "/courses/csintro/conditionals/project"
                  },
                  {
                    "name": "Project",
                    "subitems": [],
                    "path": "/courses/csintro/conditionals/project",
                    "prevName": "Activity",
                    "prevPath": "/courses/csintro/conditionals/activity",
                    "nextName": "Standards",
                    "nextPath": "/courses/csintro/conditionals/standards"
                  },
                  {
                    "name": "Standards",
                    "subitems": [],
                    "path": "/courses/csintro/conditionals/standards",
                    "prevName": "Project",
                    "prevPath": "/courses/csintro/conditionals/project",
                    "nextName": "Iteration",
                    "nextPath": "/courses/csintro/iteration"
                  }
                ],
                "path": "/courses/csintro/conditionals",
                "prevName": "Standards",
                "prevPath": "/courses/csintro/variables/standards",
                "nextName": "Overview",
                "nextPath": "/courses/csintro/conditionals/overview"
              },
              {
                "name": "Iteration",
                "subitems": [
                  {
                    "name": "Overview",
                    "subitems": [],
                    "path": "/courses/csintro/iteration/overview",
                    "prevName": "Iteration",
                    "prevPath": "/courses/csintro/iteration",
                    "nextName": "Unplugged",
                    "nextPath": "/courses/csintro/iteration/unplugged"
                  },
                  {
                    "name": "Unplugged",
                    "subitems": [],
                    "path": "/courses/csintro/iteration/unplugged",
                    "prevName": "Overview",
                    "prevPath": "/courses/csintro/iteration/overview",
                    "nextName": "Activity",
                    "nextPath": "/courses/csintro/iteration/activity"
                  },
                  {
                    "name": "Activity",
                    "subitems": [],
                    "path": "/courses/csintro/iteration/activity",
                    "prevName": "Unplugged",
                    "prevPath": "/courses/csintro/iteration/unplugged",
                    "nextName": "Project",
                    "nextPath": "/courses/csintro/iteration/project"
                  },
                  {
                    "name": "Project",
                    "subitems": [],
                    "path": "/courses/csintro/iteration/project",
                    "prevName": "Activity",
                    "prevPath": "/courses/csintro/iteration/activity",
                    "nextName": "Standards",
                    "nextPath": "/courses/csintro/iteration/standards"
                  },
                  {
                    "name": "Standards",
                    "subitems": [],
                    "path": "/courses/csintro/iteration/standards",
                    "prevName": "Project",
                    "prevPath": "/courses/csintro/iteration/project",
                    "nextName": "Mini-project",
                    "nextPath": "/courses/csintro/miniproject"
                  }
                ],
                "path": "/courses/csintro/iteration",
                "prevName": "Standards",
                "prevPath": "/courses/csintro/conditionals/standards",
                "nextName": "Overview",
                "nextPath": "/courses/csintro/iteration/overview"
              },
              {
                "name": "Mini-project",
                "subitems": [
                  {
                    "name": "Review",
                    "subitems": [],
                    "path": "/courses/csintro/miniproject/review",
                    "prevName": "Mini-project",
                    "prevPath": "/courses/csintro/miniproject",
                    "nextName": "Activity",
                    "nextPath": "/courses/csintro/miniproject/activity"
                  },
                  {
                    "name": "Activity",
                    "subitems": [],
                    "path": "/courses/csintro/miniproject/activity",
                    "prevName": "Review",
                    "prevPath": "/courses/csintro/miniproject/review",
                    "nextName": "Project",
                    "nextPath": "/courses/csintro/miniproject/project"
                  },
                  {
                    "name": "Project",
                    "subitems": [],
                    "path": "/courses/csintro/miniproject/project",
                    "prevName": "Activity",
                    "prevPath": "/courses/csintro/miniproject/activity",
                    "nextName": "Standards",
                    "nextPath": "/courses/csintro/miniproject/standards"
                  },
                  {
                    "name": "Standards",
                    "subitems": [],
                    "path": "/courses/csintro/miniproject/standards",
                    "prevName": "Project",
                    "prevPath": "/courses/csintro/miniproject/project",
                    "nextName": "Coordinates",
                    "nextPath": "/courses/csintro/coordinates"
                  }
                ],
                "path": "/courses/csintro/miniproject",
                "prevName": "Standards",
                "prevPath": "/courses/csintro/iteration/standards",
                "nextName": "Review",
                "nextPath": "/courses/csintro/miniproject/review"
              },
              {
                "name": "Coordinates",
                "subitems": [
                  {
                    "name": "Overview",
                    "subitems": [],
                    "path": "/courses/csintro/coordinates/overview",
                    "prevName": "Coordinates",
                    "prevPath": "/courses/csintro/coordinates",
                    "nextName": "Unplugged",
                    "nextPath": "/courses/csintro/coordinates/unplugged"
                  },
                  {
                    "name": "Unplugged",
                    "subitems": [],
                    "path": "/courses/csintro/coordinates/unplugged",
                    "prevName": "Overview",
                    "prevPath": "/courses/csintro/coordinates/overview",
                    "nextName": "Activity",
                    "nextPath": "/courses/csintro/coordinates/activity"
                  },
                  {
                    "name": "Activity",
                    "subitems": [],
                    "path": "/courses/csintro/coordinates/activity",
                    "prevName": "Unplugged",
                    "prevPath": "/courses/csintro/coordinates/unplugged",
                    "nextName": "Project",
                    "nextPath": "/courses/csintro/coordinates/project"
                  },
                  {
                    "name": "Project",
                    "subitems": [],
                    "path": "/courses/csintro/coordinates/project",
                    "prevName": "Activity",
                    "prevPath": "/courses/csintro/coordinates/activity",
                    "nextName": "Standards",
                    "nextPath": "/courses/csintro/coordinates/standards"
                  },
                  {
                    "name": "Standards",
                    "subitems": [],
                    "path": "/courses/csintro/coordinates/standards",
                    "prevName": "Project",
                    "prevPath": "/courses/csintro/coordinates/project",
                    "nextName": "Booleans",
                    "nextPath": "/courses/csintro/booleans"
                  }
                ],
                "path": "/courses/csintro/coordinates",
                "prevName": "Standards",
                "prevPath": "/courses/csintro/miniproject/standards",
                "nextName": "Overview",
                "nextPath": "/courses/csintro/coordinates/overview"
              },
              {
                "name": "Booleans",
                "subitems": [
                  {
                    "name": "Overview",
                    "subitems": [],
                    "path": "/courses/csintro/booleans/overview",
                    "prevName": "Booleans",
                    "prevPath": "/courses/csintro/booleans",
                    "nextName": "Unplugged",
                    "nextPath": "/courses/csintro/booleans/unplugged"
                  },
                  {
                    "name": "Unplugged",
                    "subitems": [],
                    "path": "/courses/csintro/booleans/unplugged",
                    "prevName": "Overview",
                    "prevPath": "/courses/csintro/booleans/overview",
                    "nextName": "Activity",
                    "nextPath": "/courses/csintro/booleans/activity"
                  },
                  {
                    "name": "Activity",
                    "subitems": [],
                    "path": "/courses/csintro/booleans/activity",
                    "prevName": "Unplugged",
                    "prevPath": "/courses/csintro/booleans/unplugged",
                    "nextName": "Project",
                    "nextPath": "/courses/csintro/booleans/project"
                  },
                  {
                    "name": "Project",
                    "subitems": [],
                    "path": "/courses/csintro/booleans/project",
                    "prevName": "Activity",
                    "prevPath": "/courses/csintro/booleans/activity",
                    "nextName": "Standards",
                    "nextPath": "/courses/csintro/booleans/standards"
                  },
                  {
                    "name": "Standards",
                    "subitems": [],
                    "path": "/courses/csintro/booleans/standards",
                    "prevName": "Project",
                    "prevPath": "/courses/csintro/booleans/project",
                    "nextName": "Binary",
                    "nextPath": "/courses/csintro/binary"
                  }
                ],
                "path": "/courses/csintro/booleans",
                "prevName": "Standards",
                "prevPath": "/courses/csintro/coordinates/standards",
                "nextName": "Overview",
                "nextPath": "/courses/csintro/booleans/overview"
              },
              {
                "name": "Binary",
                "subitems": [
                  {
                    "name": "Overview",
                    "subitems": [],
                    "path": "/courses/csintro/binary/overview",
                    "prevName": "Binary",
                    "prevPath": "/courses/csintro/binary",
                    "nextName": "Unplugged",
                    "nextPath": "/courses/csintro/binary/unplugged"
                  },
                  {
                    "name": "Unplugged",
                    "subitems": [],
                    "path": "/courses/csintro/binary/unplugged",
                    "prevName": "Overview",
                    "prevPath": "/courses/csintro/binary/overview",
                    "nextName": "Activity",
                    "nextPath": "/courses/csintro/binary/activity"
                  },
                  {
                    "name": "Activity",
                    "subitems": [],
                    "path": "/courses/csintro/binary/activity",
                    "prevName": "Unplugged",
                    "prevPath": "/courses/csintro/binary/unplugged",
                    "nextName": "Project",
                    "nextPath": "/courses/csintro/binary/project"
                  },
                  {
                    "name": "Project",
                    "subitems": [],
                    "path": "/courses/csintro/binary/project",
                    "prevName": "Activity",
                    "prevPath": "/courses/csintro/binary/activity",
                    "nextName": "Standards",
                    "nextPath": "/courses/csintro/binary/standards"
                  },
                  {
                    "name": "Standards",
                    "subitems": [],
                    "path": "/courses/csintro/binary/standards",
                    "prevName": "Project",
                    "prevPath": "/courses/csintro/binary/project",
                    "nextName": "Radio",
                    "nextPath": "/courses/csintro/radio"
                  }
                ],
                "path": "/courses/csintro/binary",
                "prevName": "Standards",
                "prevPath": "/courses/csintro/booleans/standards",
                "nextName": "Overview",
                "nextPath": "/courses/csintro/binary/overview"
              },
              {
                "name": "Radio",
                "subitems": [
                  {
                    "name": "Overview",
                    "subitems": [],
                    "path": "/courses/csintro/radio/overview",
                    "prevName": "Radio",
                    "prevPath": "/courses/csintro/radio",
                    "nextName": "Unplugged",
                    "nextPath": "/courses/csintro/radio/unplugged"
                  },
                  {
                    "name": "Unplugged",
                    "subitems": [],
                    "path": "/courses/csintro/radio/unplugged",
                    "prevName": "Overview",
                    "prevPath": "/courses/csintro/radio/overview",
                    "nextName": "Activity",
                    "nextPath": "/courses/csintro/radio/activity"
                  },
                  {
                    "name": "Activity",
                    "subitems": [],
                    "path": "/courses/csintro/radio/activity",
                    "prevName": "Unplugged",
                    "prevPath": "/courses/csintro/radio/unplugged",
                    "nextName": "Project",
                    "nextPath": "/courses/csintro/radio/project"
                  },
                  {
                    "name": "Project",
                    "subitems": [],
                    "path": "/courses/csintro/radio/project",
                    "prevName": "Activity",
                    "prevPath": "/courses/csintro/radio/activity",
                    "nextName": "Standards",
                    "nextPath": "/courses/csintro/radio/standards"
                  },
                  {
                    "name": "Standards",
                    "subitems": [],
                    "path": "/courses/csintro/radio/standards",
                    "prevName": "Project",
                    "prevPath": "/courses/csintro/radio/project",
                    "nextName": "Arrays",
                    "nextPath": "/courses/csintro/arrays"
                  }
                ],
                "path": "/courses/csintro/radio",
                "prevName": "Standards",
                "prevPath": "/courses/csintro/binary/standards",
                "nextName": "Overview",
                "nextPath": "/courses/csintro/radio/overview"
              },
              {
                "name": "Arrays",
                "subitems": [
                  {
                    "name": "Overview",
                    "subitems": [],
                    "path": "/courses/csintro/arrays/overview",
                    "prevName": "Arrays",
                    "prevPath": "/courses/csintro/arrays",
                    "nextName": "Unplugged",
                    "nextPath": "/courses/csintro/arrays/unplugged"
                  },
                  {
                    "name": "Unplugged",
                    "subitems": [],
                    "path": "/courses/csintro/arrays/unplugged",
                    "prevName": "Overview",
                    "prevPath": "/courses/csintro/arrays/overview",
                    "nextName": "Activity",
                    "nextPath": "/courses/csintro/arrays/activity"
                  },
                  {
                    "name": "Activity",
                    "subitems": [],
                    "path": "/courses/csintro/arrays/activity",
                    "prevName": "Unplugged",
                    "prevPath": "/courses/csintro/arrays/unplugged",
                    "nextName": "Project",
                    "nextPath": "/courses/csintro/arrays/project"
                  },
                  {
                    "name": "Project",
                    "subitems": [],
                    "path": "/courses/csintro/arrays/project",
                    "prevName": "Activity",
                    "prevPath": "/courses/csintro/arrays/activity",
                    "nextName": "Standards",
                    "nextPath": "/courses/csintro/arrays/standards"
                  },
                  {
                    "name": "Standards",
                    "subitems": [],
                    "path": "/courses/csintro/arrays/standards",
                    "prevName": "Project",
                    "prevPath": "/courses/csintro/arrays/project",
                    "nextName": "Final Project",
                    "nextPath": "/courses/csintro/finalproject"
                  }
                ],
                "path": "/courses/csintro/arrays",
                "prevName": "Standards",
                "prevPath": "/courses/csintro/radio/standards",
                "nextName": "Overview",
                "nextPath": "/courses/csintro/arrays/overview"
              },
              {
                "name": "Final Project",
                "subitems": [
                  {
                    "name": "Review",
                    "subitems": [],
                    "path": "/courses/csintro/finalproject/review",
                    "prevName": "Final Project",
                    "prevPath": "/courses/csintro/finalproject",
                    "nextName": "Project",
                    "nextPath": "/courses/csintro/finalproject/project"
                  },
                  {
                    "name": "Project",
                    "subitems": [],
                    "path": "/courses/csintro/finalproject/project",
                    "prevName": "Review",
                    "prevPath": "/courses/csintro/finalproject/review",
                    "nextName": "Examples",
                    "nextPath": "/courses/csintro/finalproject/examples"
                  },
                  {
                    "name": "Examples",
                    "subitems": [],
                    "path": "/courses/csintro/finalproject/examples",
                    "prevName": "Project",
                    "prevPath": "/courses/csintro/finalproject/project",
                    "nextName": "Standards",
                    "nextPath": "/courses/csintro/finalproject/standards"
                  },
                  {
                    "name": "Standards",
                    "subitems": [],
                    "path": "/courses/csintro/finalproject/standards",
                    "prevName": "Examples",
                    "prevPath": "/courses/csintro/finalproject/examples",
                    "nextName": "Reference",
                    "nextPath": "/reference"
                  }
                ],
                "path": "/courses/csintro/finalproject",
                "prevName": "Standards",
                "prevPath": "/courses/csintro/arrays/standards",
                "nextName": "Review",
                "nextPath": "/courses/csintro/finalproject/review"
              }
            ],
            "path": "/courses/csintro",
            "prevName": "Courses",
            "prevPath": "/courses",
            "nextName": "About",
            "nextPath": "/courses/csintro/about"
          }
        ],
        "path": "/courses",
        "prevName": "Game of Life",
        "prevPath": "/examples/gameofLife",
        "nextName": "CS Intro",
        "nextPath": "/courses/csintro"
      },
      {
        "name": "Reference",
        "subitems": [
          {
            "name": "Basic",
            "subitems": [
              {
                "name": "show number",
                "subitems": [],
                "path": "/reference/basic/show-number",
                "prevName": "Basic",
                "prevPath": "/reference/basic",
                "nextName": "show icon",
                "nextPath": "/reference/basic/show-icon"
              },
              {
                "name": "show icon",
                "subitems": [],
                "path": "/reference/basic/show-icon",
                "prevName": "show number",
                "prevPath": "/reference/basic/show-number",
                "nextName": "show leds",
                "nextPath": "/reference/basic/show-leds"
              },
              {
                "name": "show leds",
                "subitems": [],
                "path": "/reference/basic/show-leds",
                "prevName": "show icon",
                "prevPath": "/reference/basic/show-icon",
                "nextName": "show string",
                "nextPath": "/reference/basic/show-string"
              },
              {
                "name": "show string",
                "subitems": [],
                "path": "/reference/basic/show-string",
                "prevName": "show leds",
                "prevPath": "/reference/basic/show-leds",
                "nextName": "clear screen",
                "nextPath": "/reference/basic/clear-screen"
              },
              {
                "name": "clear screen",
                "subitems": [],
                "path": "/reference/basic/clear-screen",
                "prevName": "show string",
                "prevPath": "/reference/basic/show-string",
                "nextName": "forever",
                "nextPath": "/reference/basic/forever"
              },
              {
                "name": "forever",
                "subitems": [],
                "path": "/reference/basic/forever",
                "prevName": "clear screen",
                "prevPath": "/reference/basic/clear-screen",
                "nextName": "pause",
                "nextPath": "/reference/basic/pause"
              },
              {
                "name": "pause",
                "subitems": [],
                "path": "/reference/basic/pause",
                "prevName": "forever",
                "prevPath": "/reference/basic/forever",
                "nextName": "show arrow",
                "nextPath": "/reference/basic/show-arrow"
              },
              {
                "name": "show arrow",
                "subitems": [],
                "path": "/reference/basic/show-arrow",
                "prevName": "pause",
                "prevPath": "/reference/basic/pause",
                "nextName": "show animation",
                "nextPath": "/reference/basic/show-animation"
              },
              {
                "name": "show animation",
                "subitems": [],
                "path": "/reference/basic/show-animation",
                "prevName": "show arrow",
                "prevPath": "/reference/basic/show-arrow",
                "nextName": "Input",
                "nextPath": "/reference/input"
              }
            ],
            "path": "/reference/basic",
            "prevName": "Reference",
            "prevPath": "/reference",
            "nextName": "show number",
            "nextPath": "/reference/basic/show-number"
          },
          {
            "name": "Input",
            "subitems": [
              {
                "name": "on button pressed",
                "subitems": [],
                "path": "/reference/input/on-button-pressed",
                "prevName": "Input",
                "prevPath": "/reference/input",
                "nextName": "on gesture",
                "nextPath": "/reference/input/on-gesture"
              },
              {
                "name": "on gesture",
                "subitems": [],
                "path": "/reference/input/on-gesture",
                "prevName": "on button pressed",
                "prevPath": "/reference/input/on-button-pressed",
                "nextName": "on pin pressed",
                "nextPath": "/reference/input/on-pin-pressed"
              },
              {
                "name": "on pin pressed",
                "subitems": [],
                "path": "/reference/input/on-pin-pressed",
                "prevName": "on gesture",
                "prevPath": "/reference/input/on-gesture",
                "nextName": "button is pressed",
                "nextPath": "/reference/input/button-is-pressed"
              },
              {
                "name": "button is pressed",
                "subitems": [],
                "path": "/reference/input/button-is-pressed",
                "prevName": "on pin pressed",
                "prevPath": "/reference/input/on-pin-pressed",
                "nextName": "compass heading",
                "nextPath": "/reference/input/compass-heading"
              },
              {
                "name": "compass heading",
                "subitems": [],
                "path": "/reference/input/compass-heading",
                "prevName": "button is pressed",
                "prevPath": "/reference/input/button-is-pressed",
                "nextName": "pin is pressed",
                "nextPath": "/reference/input/pin-is-pressed"
              },
              {
                "name": "pin is pressed",
                "subitems": [],
                "path": "/reference/input/pin-is-pressed",
                "prevName": "compass heading",
                "prevPath": "/reference/input/compass-heading",
                "nextName": "temperature",
                "nextPath": "/reference/input/temperature"
              },
              {
                "name": "temperature",
                "subitems": [],
                "path": "/reference/input/temperature",
                "prevName": "pin is pressed",
                "prevPath": "/reference/input/pin-is-pressed",
                "nextName": "acceleration",
                "nextPath": "/reference/input/acceleration"
              },
              {
                "name": "acceleration",
                "subitems": [],
                "path": "/reference/input/acceleration",
                "prevName": "temperature",
                "prevPath": "/reference/input/temperature",
                "nextName": "light level",
                "nextPath": "/reference/input/light-level"
              },
              {
                "name": "light level",
                "subitems": [],
                "path": "/reference/input/light-level",
                "prevName": "acceleration",
                "prevPath": "/reference/input/acceleration",
                "nextName": "rotation",
                "nextPath": "/reference/input/rotation"
              },
              {
                "name": "rotation",
                "subitems": [],
                "path": "/reference/input/rotation",
                "prevName": "light level",
                "prevPath": "/reference/input/light-level",
                "nextName": "magnetic force",
                "nextPath": "/reference/input/magnetic-force"
              },
              {
                "name": "magnetic force",
                "subitems": [],
                "path": "/reference/input/magnetic-force",
                "prevName": "rotation",
                "prevPath": "/reference/input/rotation",
                "nextName": "running time",
                "nextPath": "/reference/input/running-time"
              },
              {
                "name": "running time",
                "subitems": [],
                "path": "/reference/input/running-time",
                "prevName": "magnetic force",
                "prevPath": "/reference/input/magnetic-force",
                "nextName": "set accelerometer range",
                "nextPath": "/reference/input/set-accelerometer-range"
              },
              {
                "name": "set accelerometer range",
                "subitems": [],
                "path": "/reference/input/set-accelerometer-range",
                "prevName": "running time",
                "prevPath": "/reference/input/running-time",
                "nextName": "Music",
                "nextPath": "/reference/music"
              }
            ],
            "path": "/reference/input",
            "prevName": "show animation",
            "prevPath": "/reference/basic/show-animation",
            "nextName": "on button pressed",
            "nextPath": "/reference/input/on-button-pressed"
          },
          {
            "name": "Music",
            "subitems": [
              {
                "name": "play tone",
                "subitems": [],
                "path": "/reference/music/play-tone",
                "prevName": "Music",
                "prevPath": "/reference/music",
                "nextName": "ring tone",
                "nextPath": "/reference/music/ring-tone"
              },
              {
                "name": "ring tone",
                "subitems": [],
                "path": "/reference/music/ring-tone",
                "prevName": "play tone",
                "prevPath": "/reference/music/play-tone",
                "nextName": "rest",
                "nextPath": "/reference/music/rest"
              },
              {
                "name": "rest",
                "subitems": [],
                "path": "/reference/music/rest",
                "prevName": "ring tone",
                "prevPath": "/reference/music/ring-tone",
                "nextName": "beat",
                "nextPath": "/reference/music/beat"
              },
              {
                "name": "beat",
                "subitems": [],
                "path": "/reference/music/beat",
                "prevName": "rest",
                "prevPath": "/reference/music/rest",
                "nextName": "tempo",
                "nextPath": "/reference/music/tempo"
              },
              {
                "name": "tempo",
                "subitems": [],
                "path": "/reference/music/tempo",
                "prevName": "beat",
                "prevPath": "/reference/music/beat",
                "nextName": "change tempo by",
                "nextPath": "/reference/music/change-tempo-by"
              },
              {
                "name": "change tempo by",
                "subitems": [],
                "path": "/reference/music/change-tempo-by",
                "prevName": "tempo",
                "prevPath": "/reference/music/tempo",
                "nextName": "set tempo",
                "nextPath": "/reference/music/set-tempo"
              },
              {
                "name": "set tempo",
                "subitems": [],
                "path": "/reference/music/set-tempo",
                "prevName": "change tempo by",
                "prevPath": "/reference/music/change-tempo-by",
                "nextName": "Led",
                "nextPath": "/reference/led"
              }
            ],
            "path": "/reference/music",
            "prevName": "set accelerometer range",
            "prevPath": "/reference/input/set-accelerometer-range",
            "nextName": "play tone",
            "nextPath": "/reference/music/play-tone"
          },
          {
            "name": "Led",
            "subitems": [
              {
                "name": "plot",
                "subitems": [],
                "path": "/reference/led/plot",
                "prevName": "Led",
                "prevPath": "/reference/led",
                "nextName": "unplot",
                "nextPath": "/reference/led/unplot"
              },
              {
                "name": "unplot",
                "subitems": [],
                "path": "/reference/led/unplot",
                "prevName": "plot",
                "prevPath": "/reference/led/plot",
                "nextName": "point",
                "nextPath": "/reference/led/point"
              },
              {
                "name": "point",
                "subitems": [],
                "path": "/reference/led/point",
                "prevName": "unplot",
                "prevPath": "/reference/led/unplot",
                "nextName": "toggle",
                "nextPath": "/reference/led/toggle"
              },
              {
                "name": "toggle",
                "subitems": [],
                "path": "/reference/led/toggle",
                "prevName": "point",
                "prevPath": "/reference/led/point",
                "nextName": "brightness",
                "nextPath": "/reference/led/brightness"
              },
              {
                "name": "brightness",
                "subitems": [],
                "path": "/reference/led/brightness",
                "prevName": "toggle",
                "prevPath": "/reference/led/toggle",
                "nextName": "set brightness",
                "nextPath": "/reference/led/set-brightness"
              },
              {
                "name": "set brightness",
                "subitems": [],
                "path": "/reference/led/set-brightness",
                "prevName": "brightness",
                "prevPath": "/reference/led/brightness",
                "nextName": "stop animation",
                "nextPath": "/reference/led/stop-animation"
              },
              {
                "name": "stop animation",
                "subitems": [],
                "path": "/reference/led/stop-animation",
                "prevName": "set brightness",
                "prevPath": "/reference/led/set-brightness",
                "nextName": "plot bar graph",
                "nextPath": "/reference/led/plot-bar-graph"
              },
              {
                "name": "plot bar graph",
                "subitems": [],
                "path": "/reference/led/plot-bar-graph",
                "prevName": "stop animation",
                "prevPath": "/reference/led/stop-animation",
                "nextName": "enable",
                "nextPath": "/reference/led/enable"
              },
              {
                "name": "enable",
                "subitems": [],
                "path": "/reference/led/enable",
                "prevName": "plot bar graph",
                "prevPath": "/reference/led/plot-bar-graph",
                "nextName": "Radio",
                "nextPath": "/reference/radio"
              }
            ],
            "path": "/reference/led",
            "prevName": "set tempo",
            "prevPath": "/reference/music/set-tempo",
            "nextName": "plot",
            "nextPath": "/reference/led/plot"
          },
          {
            "name": "Radio",
            "subitems": [
              {
                "name": "send number",
                "subitems": [],
                "path": "/reference/radio/send-number",
                "prevName": "Radio",
                "prevPath": "/reference/radio",
                "nextName": "send value",
                "nextPath": "/reference/radio/send-value"
              },
              {
                "name": "send value",
                "subitems": [],
                "path": "/reference/radio/send-value",
                "prevName": "send number",
                "prevPath": "/reference/radio/send-number",
                "nextName": "send string",
                "nextPath": "/reference/radio/send-string"
              },
              {
                "name": "send string",
                "subitems": [],
                "path": "/reference/radio/send-string",
                "prevName": "send value",
                "prevPath": "/reference/radio/send-value",
                "nextName": "on data packet received",
                "nextPath": "/reference/radio/on-data-packet-received"
              },
              {
                "name": "on data packet received",
                "subitems": [],
                "path": "/reference/radio/on-data-packet-received",
                "prevName": "send string",
                "prevPath": "/reference/radio/send-string",
                "nextName": "set group",
                "nextPath": "/reference/radio/set-group"
              },
              {
                "name": "set group",
                "subitems": [],
                "path": "/reference/radio/set-group",
                "prevName": "on data packet received",
                "prevPath": "/reference/radio/on-data-packet-received",
                "nextName": "set transmit power",
                "nextPath": "/reference/radio/set-transmit-power"
              },
              {
                "name": "set transmit power",
                "subitems": [],
                "path": "/reference/radio/set-transmit-power",
                "prevName": "set group",
                "prevPath": "/reference/radio/set-group",
                "nextName": "set transmit serial number",
                "nextPath": "/reference/radio/set-transmit-serial-number"
              },
              {
                "name": "set transmit serial number",
                "subitems": [],
                "path": "/reference/radio/set-transmit-serial-number",
                "prevName": "set transmit power",
                "prevPath": "/reference/radio/set-transmit-power",
                "nextName": "write received packet to serial",
                "nextPath": "/reference/radio/write-received-packet-to-serial"
              },
              {
                "name": "write received packet to serial",
                "subitems": [],
                "path": "/reference/radio/write-received-packet-to-serial",
                "prevName": "set transmit serial number",
                "prevPath": "/reference/radio/set-transmit-serial-number",
                "nextName": "Game",
                "nextPath": "/reference/game"
              }
            ],
            "path": "/reference/radio",
            "prevName": "enable",
            "prevPath": "/reference/led/enable",
            "nextName": "send number",
            "nextPath": "/reference/radio/send-number"
          },
          {
            "name": "Game",
            "subitems": [
              {
                "name": "create sprite",
                "subitems": [],
                "path": "/reference/game/create-sprite",
                "prevName": "Game",
                "prevPath": "/reference/game",
                "nextName": "delete",
                "nextPath": "/reference/game/delete"
              },
              {
                "name": "delete",
                "subitems": [],
                "path": "/reference/game/delete",
                "prevName": "create sprite",
                "prevPath": "/reference/game/create-sprite",
                "nextName": "move",
                "nextPath": "/reference/game/move"
              },
              {
                "name": "move",
                "subitems": [],
                "path": "/reference/game/move",
                "prevName": "delete",
                "prevPath": "/reference/game/delete",
                "nextName": "turn",
                "nextPath": "/reference/game/turn"
              },
              {
                "name": "turn",
                "subitems": [],
                "path": "/reference/game/turn",
                "prevName": "move",
                "prevPath": "/reference/game/move",
                "nextName": "in on edge bounce",
                "nextPath": "/reference/game/if-on-edge-bounce"
              },
              {
                "name": "in on edge bounce",
                "subitems": [],
                "path": "/reference/game/if-on-edge-bounce",
                "prevName": "turn",
                "prevPath": "/reference/game/turn",
                "nextName": "get",
                "nextPath": "/reference/game/get"
              },
              {
                "name": "get",
                "subitems": [],
                "path": "/reference/game/get",
                "prevName": "in on edge bounce",
                "prevPath": "/reference/game/if-on-edge-bounce",
                "nextName": "set",
                "nextPath": "/reference/game/set"
              },
              {
                "name": "set",
                "subitems": [],
                "path": "/reference/game/set",
                "prevName": "get",
                "prevPath": "/reference/game/get",
                "nextName": "change",
                "nextPath": "/reference/game/change"
              },
              {
                "name": "change",
                "subitems": [],
                "path": "/reference/game/change",
                "prevName": "set",
                "prevPath": "/reference/game/set",
                "nextName": "is touching",
                "nextPath": "/reference/game/is-touching"
              },
              {
                "name": "is touching",
                "subitems": [],
                "path": "/reference/game/is-touching",
                "prevName": "change",
                "prevPath": "/reference/game/change",
                "nextName": "is touching edge",
                "nextPath": "/reference/game/is-touching-edge"
              },
              {
                "name": "is touching edge",
                "subitems": [],
                "path": "/reference/game/is-touching-edge",
                "prevName": "is touching",
                "prevPath": "/reference/game/is-touching",
                "nextName": "add score",
                "nextPath": "/reference/game/add-score"
              },
              {
                "name": "add score",
                "subitems": [],
                "path": "/reference/game/add-score",
                "prevName": "is touching edge",
                "prevPath": "/reference/game/is-touching-edge",
                "nextName": "score",
                "nextPath": "/reference/game/score"
              },
              {
                "name": "score",
                "subitems": [],
                "path": "/reference/game/score",
                "prevName": "add score",
                "prevPath": "/reference/game/add-score",
                "nextName": "set score",
                "nextPath": "/reference/game/set-score"
              },
              {
                "name": "set score",
                "subitems": [],
                "path": "/reference/game/set-score",
                "prevName": "score",
                "prevPath": "/reference/game/score",
                "nextName": "start countdown",
                "nextPath": "/reference/game/start-countdown"
              },
              {
                "name": "start countdown",
                "subitems": [],
                "path": "/reference/game/start-countdown",
                "prevName": "set score",
                "prevPath": "/reference/game/set-score",
                "nextName": "game over",
                "nextPath": "/reference/game/game-over"
              },
              {
                "name": "game over",
                "subitems": [],
                "path": "/reference/game/game-over",
                "prevName": "start countdown",
                "prevPath": "/reference/game/start-countdown",
                "nextName": "pause",
                "nextPath": "/reference/game/pause"
              },
              {
                "name": "pause",
                "subitems": [],
                "path": "/reference/game/pause",
                "prevName": "game over",
                "prevPath": "/reference/game/game-over",
                "nextName": "resume",
                "nextPath": "/reference/game/resume"
              },
              {
                "name": "resume",
                "subitems": [],
                "path": "/reference/game/resume",
                "prevName": "pause",
                "prevPath": "/reference/game/pause",
                "nextName": "Images",
                "nextPath": "/reference/images"
              }
            ],
            "path": "/reference/game",
            "prevName": "write received packet to serial",
            "prevPath": "/reference/radio/write-received-packet-to-serial",
            "nextName": "create sprite",
            "nextPath": "/reference/game/create-sprite"
          },
          {
            "name": "Images",
            "subitems": [
              {
                "name": "create image",
                "subitems": [],
                "path": "/reference/images/create-image",
                "prevName": "Images",
                "prevPath": "/reference/images",
                "nextName": "create big image",
                "nextPath": "/reference/images/create-big-image"
              },
              {
                "name": "create big image",
                "subitems": [],
                "path": "/reference/images/create-big-image",
                "prevName": "create image",
                "prevPath": "/reference/images/create-image",
                "nextName": "show image",
                "nextPath": "/reference/images/show-image"
              },
              {
                "name": "show image",
                "subitems": [],
                "path": "/reference/images/show-image",
                "prevName": "create big image",
                "prevPath": "/reference/images/create-big-image",
                "nextName": "scroll image",
                "nextPath": "/reference/images/scroll-image"
              },
              {
                "name": "scroll image",
                "subitems": [],
                "path": "/reference/images/scroll-image",
                "prevName": "show image",
                "prevPath": "/reference/images/show-image",
                "nextName": "arrow image",
                "nextPath": "/reference/images/arrow-image"
              },
              {
                "name": "arrow image",
                "subitems": [],
                "path": "/reference/images/arrow-image",
                "prevName": "scroll image",
                "prevPath": "/reference/images/scroll-image",
                "nextName": "icon image",
                "nextPath": "/reference/images/icon-image"
              },
              {
                "name": "icon image",
                "subitems": [],
                "path": "/reference/images/icon-image",
                "prevName": "arrow image",
                "prevPath": "/reference/images/arrow-image",
                "nextName": "arrow number",
                "nextPath": "/reference/images/arrow-number"
              },
              {
                "name": "arrow number",
                "subitems": [],
                "path": "/reference/images/arrow-number",
                "prevName": "icon image",
                "prevPath": "/reference/images/icon-image",
                "nextName": "Pins",
                "nextPath": "/reference/pins"
              }
            ],
            "path": "/reference/images",
            "prevName": "resume",
            "prevPath": "/reference/game/resume",
            "nextName": "create image",
            "nextPath": "/reference/images/create-image"
          },
          {
            "name": "Pins",
            "subitems": [
              {
                "name": "digital read pin",
                "subitems": [],
                "path": "/reference/pins/digital-read-pin",
                "prevName": "Pins",
                "prevPath": "/reference/pins",
                "nextName": "digital write pin",
                "nextPath": "/reference/pins/digital-write-pin"
              },
              {
                "name": "digital write pin",
                "subitems": [],
                "path": "/reference/pins/digital-write-pin",
                "prevName": "digital read pin",
                "prevPath": "/reference/pins/digital-read-pin",
                "nextName": "analog read pin",
                "nextPath": "/reference/pins/analog-read-pin"
              },
              {
                "name": "analog read pin",
                "subitems": [],
                "path": "/reference/pins/analog-read-pin",
                "prevName": "digital write pin",
                "prevPath": "/reference/pins/digital-write-pin",
                "nextName": "analog write pin",
                "nextPath": "/reference/pins/analog-write-pin"
              },
              {
                "name": "analog write pin",
                "subitems": [],
                "path": "/reference/pins/analog-write-pin",
                "prevName": "analog read pin",
                "prevPath": "/reference/pins/analog-read-pin",
                "nextName": "analog set period",
                "nextPath": "/reference/pins/analog-set-period"
              },
              {
                "name": "analog set period",
                "subitems": [],
                "path": "/reference/pins/analog-set-period",
                "prevName": "analog write pin",
                "prevPath": "/reference/pins/analog-write-pin",
                "nextName": "map",
                "nextPath": "/reference/pins/map"
              },
              {
                "name": "map",
                "subitems": [],
                "path": "/reference/pins/map",
                "prevName": "analog set period",
                "prevPath": "/reference/pins/analog-set-period",
                "nextName": "on pulsed",
                "nextPath": "/reference/pins/on-pulsed"
              },
              {
                "name": "on pulsed",
                "subitems": [],
                "path": "/reference/pins/on-pulsed",
                "prevName": "map",
                "prevPath": "/reference/pins/map",
                "nextName": "pulse duration",
                "nextPath": "/reference/pins/pulse-duration"
              },
              {
                "name": "pulse duration",
                "subitems": [],
                "path": "/reference/pins/pulse-duration",
                "prevName": "on pulsed",
                "prevPath": "/reference/pins/on-pulsed",
                "nextName": "pulse in",
                "nextPath": "/reference/pins/pulse-in"
              },
              {
                "name": "pulse in",
                "subitems": [],
                "path": "/reference/pins/pulse-in",
                "prevName": "pulse duration",
                "prevPath": "/reference/pins/pulse-duration",
                "nextName": "servo write pin",
                "nextPath": "/reference/pins/servo-write-pin"
              },
              {
                "name": "servo write pin",
                "subitems": [],
                "path": "/reference/pins/servo-write-pin",
                "prevName": "pulse in",
                "prevPath": "/reference/pins/pulse-in",
                "nextName": "servo set pulse",
                "nextPath": "/reference/pins/servo-set-pulse"
              },
              {
                "name": "servo set pulse",
                "subitems": [],
                "path": "/reference/pins/servo-set-pulse",
                "prevName": "servo write pin",
                "prevPath": "/reference/pins/servo-write-pin",
                "nextName": "i2c read number",
                "nextPath": "/reference/pins/i2c-read-number"
              },
              {
                "name": "i2c read number",
                "subitems": [],
                "path": "/reference/pins/i2c-read-number",
                "prevName": "servo set pulse",
                "prevPath": "/reference/pins/servo-set-pulse",
                "nextName": "i2c write number",
                "nextPath": "/reference/pins/i2c-write-number"
              },
              {
                "name": "i2c write number",
                "subitems": [],
                "path": "/reference/pins/i2c-write-number",
                "prevName": "i2c read number",
                "prevPath": "/reference/pins/i2c-read-number",
                "nextName": "set pull",
                "nextPath": "/reference/pins/set-pull"
              },
              {
                "name": "set pull",
                "subitems": [],
                "path": "/reference/pins/set-pull",
                "prevName": "i2c write number",
                "prevPath": "/reference/pins/i2c-write-number",
                "nextName": "analog pitch",
                "nextPath": "/reference/pins/analog-pitch"
              },
              {
                "name": "analog pitch",
                "subitems": [],
                "path": "/reference/pins/analog-pitch",
                "prevName": "set pull",
                "prevPath": "/reference/pins/set-pull",
                "nextName": "analog set pitch pin",
                "nextPath": "/reference/pins/analog-set-pitch-pin"
              },
              {
                "name": "analog set pitch pin",
                "subitems": [],
                "path": "/reference/pins/analog-set-pitch-pin",
                "prevName": "analog pitch",
                "prevPath": "/reference/pins/analog-pitch",
                "nextName": "spi write",
                "nextPath": "/reference/pins/spi-write"
              },
              {
                "name": "spi write",
                "subitems": [],
                "path": "/reference/pins/spi-write",
                "prevName": "analog set pitch pin",
                "prevPath": "/reference/pins/analog-set-pitch-pin",
                "nextName": "spi Pins",
                "nextPath": "/reference/pins/spi-pins"
              },
              {
                "name": "spi Pins",
                "subitems": [],
                "path": "/reference/pins/spi-pins",
                "prevName": "spi write",
                "prevPath": "/reference/pins/spi-write",
                "nextName": "spi format",
                "nextPath": "/reference/pins/spi-format"
              },
              {
                "name": "spi format",
                "subitems": [],
                "path": "/reference/pins/spi-format",
                "prevName": "spi Pins",
                "prevPath": "/reference/pins/spi-pins",
                "nextName": "spi frequency",
                "nextPath": "/reference/pins/spi-frequency"
              },
              {
                "name": "spi frequency",
                "subitems": [],
                "path": "/reference/pins/spi-frequency",
                "prevName": "spi format",
                "prevPath": "/reference/pins/spi-format",
                "nextName": "Serial",
                "nextPath": "/reference/serial"
              }
            ],
            "path": "/reference/pins",
            "prevName": "arrow number",
            "prevPath": "/reference/images/arrow-number",
            "nextName": "digital read pin",
            "nextPath": "/reference/pins/digital-read-pin"
          },
          {
            "name": "Serial",
            "subitems": [
              {
                "name": "write line",
                "subitems": [],
                "path": "/reference/serial/write-line",
                "prevName": "Serial",
                "prevPath": "/reference/serial",
                "nextName": "write number",
                "nextPath": "/reference/serial/write-number"
              },
              {
                "name": "write number",
                "subitems": [],
                "path": "/reference/serial/write-number",
                "prevName": "write line",
                "prevPath": "/reference/serial/write-line",
                "nextName": "write value",
                "nextPath": "/reference/serial/write-value"
              },
              {
                "name": "write value",
                "subitems": [],
                "path": "/reference/serial/write-value",
                "prevName": "write number",
                "prevPath": "/reference/serial/write-number",
                "nextName": "write string",
                "nextPath": "/reference/serial/write-string"
              },
              {
                "name": "write string",
                "subitems": [],
                "path": "/reference/serial/write-string",
                "prevName": "write value",
                "prevPath": "/reference/serial/write-value",
                "nextName": "read until",
                "nextPath": "/reference/serial/read-until"
              },
              {
                "name": "read until",
                "subitems": [],
                "path": "/reference/serial/read-until",
                "prevName": "write string",
                "prevPath": "/reference/serial/write-string",
                "nextName": "read line",
                "nextPath": "/reference/serial/read-line"
              },
              {
                "name": "read line",
                "subitems": [],
                "path": "/reference/serial/read-line",
                "prevName": "read until",
                "prevPath": "/reference/serial/read-until",
                "nextName": "read string",
                "nextPath": "/reference/serial/read-string"
              },
              {
                "name": "read string",
                "subitems": [],
                "path": "/reference/serial/read-string",
                "prevName": "read line",
                "prevPath": "/reference/serial/read-line",
                "nextName": "on data received",
                "nextPath": "/reference/serial/on-data-received"
              },
              {
                "name": "on data received",
                "subitems": [],
                "path": "/reference/serial/on-data-received",
                "prevName": "read string",
                "prevPath": "/reference/serial/read-string",
                "nextName": "redirect",
                "nextPath": "/reference/serial/redirect-to"
              },
              {
                "name": "redirect",
                "subitems": [],
                "path": "/reference/serial/redirect-to",
                "prevName": "on data received",
                "prevPath": "/reference/serial/on-data-received",
                "nextName": "write buffer",
                "nextPath": "/reference/serial/write-buffer"
              },
              {
                "name": "write buffer",
                "subitems": [],
                "path": "/reference/serial/write-buffer",
                "prevName": "redirect",
                "prevPath": "/reference/serial/redirect-to",
                "nextName": "read buffer",
                "nextPath": "/reference/serial/read-buffer"
              },
              {
                "name": "read buffer",
                "subitems": [],
                "path": "/reference/serial/read-buffer",
                "prevName": "write buffer",
                "prevPath": "/reference/serial/write-buffer",
                "nextName": "Control",
                "nextPath": "/reference/control"
              }
            ],
            "path": "/reference/serial",
            "prevName": "spi frequency",
            "prevPath": "/reference/pins/spi-frequency",
            "nextName": "write line",
            "nextPath": "/reference/serial/write-line"
          },
          {
            "name": "Control",
            "subitems": [
              {
                "name": "in background",
                "subitems": [],
                "path": "/reference/control/in-background",
                "prevName": "Control",
                "prevPath": "/reference/control",
                "nextName": "reset",
                "nextPath": "/reference/control/reset"
              },
              {
                "name": "reset",
                "subitems": [],
                "path": "/reference/control/reset",
                "prevName": "in background",
                "prevPath": "/reference/control/in-background",
                "nextName": "wait micros",
                "nextPath": "/reference/control/wait-micros"
              },
              {
                "name": "wait micros",
                "subitems": [],
                "path": "/reference/control/wait-micros",
                "prevName": "reset",
                "prevPath": "/reference/control/reset",
                "nextName": "on event",
                "nextPath": "/reference/control/on-event"
              },
              {
                "name": "on event",
                "subitems": [],
                "path": "/reference/control/on-event",
                "prevName": "wait micros",
                "prevPath": "/reference/control/wait-micros",
                "nextName": "raise event",
                "nextPath": "/reference/control/raise-event"
              },
              {
                "name": "raise event",
                "subitems": [],
                "path": "/reference/control/raise-event",
                "prevName": "on event",
                "prevPath": "/reference/control/on-event",
                "nextName": "event timestamp",
                "nextPath": "/reference/control/event-timestamp"
              },
              {
                "name": "event timestamp",
                "subitems": [],
                "path": "/reference/control/event-timestamp",
                "prevName": "raise event",
                "prevPath": "/reference/control/raise-event",
                "nextName": "event value",
                "nextPath": "/reference/control/event-value"
              },
              {
                "name": "event value",
                "subitems": [],
                "path": "/reference/control/event-value",
                "prevName": "event timestamp",
                "prevPath": "/reference/control/event-timestamp",
                "nextName": "Bluetooth",
                "nextPath": "/reference/bluetooth"
              }
            ],
            "path": "/reference/control",
            "prevName": "read buffer",
            "prevPath": "/reference/serial/read-buffer",
            "nextName": "in background",
            "nextPath": "/reference/control/in-background"
          },
          {
            "name": "Bluetooth",
            "subitems": [
              {
                "name": "",
                "subitems": [],
                "prevName": "Bluetooth",
                "prevPath": "/reference/bluetooth"
              },
              {
                "name": "Pairing",
                "subitems": [],
                "path": "/reference/bluetooth/bluetooth-pairing",
                "prevName": "Bluetooth",
                "prevPath": "/reference/bluetooth",
                "nextName": "on bluetooth connected",
                "nextPath": "/reference/bluetooth/on-bluetooth-connected"
              },
              {
                "name": "on bluetooth connected",
                "subitems": [],
                "path": "/reference/bluetooth/on-bluetooth-connected",
                "prevName": "Pairing",
                "prevPath": "/reference/bluetooth/bluetooth-pairing",
                "nextName": "on bluetooth disconnected",
                "nextPath": "/reference/bluetooth/on-bluetooth-disconnected"
              },
              {
                "name": "on bluetooth disconnected",
                "subitems": [],
                "path": "/reference/bluetooth/on-bluetooth-disconnected",
                "prevName": "on bluetooth connected",
                "prevPath": "/reference/bluetooth/on-bluetooth-connected",
                "nextName": "start accelerometer service",
                "nextPath": "/reference/bluetooth/start-accelerometer-service"
              },
              {
                "name": "start accelerometer service",
                "subitems": [],
                "path": "/reference/bluetooth/start-accelerometer-service",
                "prevName": "on bluetooth disconnected",
                "prevPath": "/reference/bluetooth/on-bluetooth-disconnected",
                "nextName": "start button service",
                "nextPath": "/reference/bluetooth/start-button-service"
              },
              {
                "name": "start button service",
                "subitems": [],
                "path": "/reference/bluetooth/start-button-service",
                "prevName": "start accelerometer service",
                "prevPath": "/reference/bluetooth/start-accelerometer-service",
                "nextName": "start io pin service",
                "nextPath": "/reference/bluetooth/start-io-pin-service"
              },
              {
                "name": "start io pin service",
                "subitems": [],
                "path": "/reference/bluetooth/start-io-pin-service",
                "prevName": "start button service",
                "prevPath": "/reference/bluetooth/start-button-service",
                "nextName": "start led service",
                "nextPath": "/reference/bluetooth/start-led-service"
              },
              {
                "name": "start led service",
                "subitems": [],
                "path": "/reference/bluetooth/start-led-service",
                "prevName": "start io pin service",
                "prevPath": "/reference/bluetooth/start-io-pin-service",
                "nextName": "start magnetometer service",
                "nextPath": "/reference/bluetooth/start-magnetometer-service"
              },
              {
                "name": "start magnetometer service",
                "subitems": [],
                "path": "/reference/bluetooth/start-magnetometer-service",
                "prevName": "start led service",
                "prevPath": "/reference/bluetooth/start-led-service",
                "nextName": "start temperature service",
                "nextPath": "/reference/bluetooth/start-temperature-service"
              },
              {
                "name": "start temperature service",
                "subitems": [],
                "path": "/reference/bluetooth/start-temperature-service",
                "prevName": "start magnetometer service",
                "prevPath": "/reference/bluetooth/start-magnetometer-service",
                "nextName": "start uart service",
                "nextPath": "/reference/bluetooth/start-uart-service"
              },
              {
                "name": "start uart service",
                "subitems": [],
                "path": "/reference/bluetooth/start-uart-service",
                "prevName": "start temperature service",
                "prevPath": "/reference/bluetooth/start-temperature-service",
                "nextName": "uart read until",
                "nextPath": "/reference/bluetooth/uart-read-until"
              },
              {
                "name": "uart read until",
                "subitems": [],
                "path": "/reference/bluetooth/uart-read-until",
                "prevName": "start uart service",
                "prevPath": "/reference/bluetooth/start-uart-service",
                "nextName": "uart write string",
                "nextPath": "/reference/bluetooth/uart-write-string"
              },
              {
                "name": "uart write string",
                "subitems": [],
                "path": "/reference/bluetooth/uart-write-string",
                "prevName": "uart read until",
                "prevPath": "/reference/bluetooth/uart-read-until",
                "nextName": "uart write number",
                "nextPath": "/reference/bluetooth/uart-write-number"
              },
              {
                "name": "uart write number",
                "subitems": [],
                "path": "/reference/bluetooth/uart-write-number",
                "prevName": "uart write string",
                "prevPath": "/reference/bluetooth/uart-write-string",
                "nextName": "uart write value",
                "nextPath": "/reference/bluetooth/uart-write-value"
              },
              {
                "name": "uart write value",
                "subitems": [],
                "path": "/reference/bluetooth/uart-write-value",
                "prevName": "uart write number",
                "prevPath": "/reference/bluetooth/uart-write-number",
                "nextName": "advertise url",
                "nextPath": "/reference/bluetooth/advertise-url"
              },
              {
                "name": "advertise url",
                "subitems": [],
                "path": "/reference/bluetooth/advertise-url",
                "prevName": "uart write value",
                "prevPath": "/reference/bluetooth/uart-write-value",
                "nextName": "stop advertising",
                "nextPath": "/reference/bluetooth/stop-advertising"
              },
              {
                "name": "stop advertising",
                "subitems": [],
                "path": "/reference/bluetooth/stop-advertising",
                "prevName": "advertise url",
                "prevPath": "/reference/bluetooth/advertise-url",
                "nextName": "advertise uid",
                "nextPath": "/reference/bluetooth/advertise-uid"
              },
              {
                "name": "advertise uid",
                "subitems": [],
                "path": "/reference/bluetooth/advertise-uid",
                "prevName": "stop advertising",
                "prevPath": "/reference/bluetooth/stop-advertising",
                "nextName": "advertise-uid-buffer",
                "nextPath": "/reference/bluetooth/advertise-uid-buffer"
              },
              {
                "name": "advertise-uid-buffer",
                "subitems": [],
                "path": "/reference/bluetooth/advertise-uid-buffer",
                "prevName": "advertise uid",
                "prevPath": "/reference/bluetooth/advertise-uid",
                "nextName": "Devices",
                "nextPath": "/reference/devices"
              }
            ],
            "path": "/reference/bluetooth",
            "prevName": "event value",
            "prevPath": "/reference/control/event-value",
            "nextName": "Pairing",
            "nextPath": "/reference/bluetooth/bluetooth-pairing"
          },
          {
            "name": "Devices",
            "subitems": [
              {
                "name": "tell camera to",
                "subitems": [],
                "path": "/reference/devices/tell-camera-to",
                "prevName": "Devices",
                "prevPath": "/reference/devices",
                "nextName": "tell remote control to",
                "nextPath": "/reference/devices/tell-remote-control-to"
              },
              {
                "name": "tell remote control to",
                "subitems": [],
                "path": "/reference/devices/tell-remote-control-to",
                "prevName": "tell camera to",
                "prevPath": "/reference/devices/tell-camera-to",
                "nextName": "raise alert to",
                "nextPath": "/reference/devices/raise-alert-to"
              },
              {
                "name": "raise alert to",
                "subitems": [],
                "path": "/reference/devices/raise-alert-to",
                "prevName": "tell remote control to",
                "prevPath": "/reference/devices/tell-remote-control-to",
                "nextName": "on notified",
                "nextPath": "/reference/devices/on-notified"
              },
              {
                "name": "on notified",
                "subitems": [],
                "path": "/reference/devices/on-notified",
                "prevName": "raise alert to",
                "prevPath": "/reference/devices/raise-alert-to",
                "nextName": "on gamepad button",
                "nextPath": "/reference/devices/on-gamepad-button"
              },
              {
                "name": "on gamepad button",
                "subitems": [],
                "path": "/reference/devices/on-gamepad-button",
                "prevName": "on notified",
                "prevPath": "/reference/devices/on-notified",
                "nextName": "signal strength",
                "nextPath": "/reference/devices/signal-strength"
              },
              {
                "name": "signal strength",
                "subitems": [],
                "path": "/reference/devices/signal-strength",
                "prevName": "on gamepad button",
                "prevPath": "/reference/devices/on-gamepad-button",
                "nextName": "on signal strength changed",
                "nextPath": "/reference/devices/on-signal-strength-changed"
              },
              {
                "name": "on signal strength changed",
                "subitems": [],
                "path": "/reference/devices/on-signal-strength-changed",
                "prevName": "signal strength",
                "prevPath": "/reference/devices/signal-strength",
                "nextName": "Packages",
                "nextPath": "/packages"
              }
            ],
            "path": "/reference/devices",
            "prevName": "advertise-uid-buffer",
            "prevPath": "/reference/bluetooth/advertise-uid-buffer",
            "nextName": "tell camera to",
            "nextPath": "/reference/devices/tell-camera-to"
          }
        ],
        "path": "/reference",
        "prevName": "Standards",
        "prevPath": "/courses/csintro/finalproject/standards",
        "nextName": "Basic",
        "nextPath": "/reference/basic"
      },
      {
        "name": "Packages",
        "subitems": [
          {
            "name": "NeoPixel",
            "subitems": [],
            "path": "/pkg/microsoft/pxt-neopixel",
            "prevName": "Packages",
            "prevPath": "/packages",
            "nextName": "File System",
            "nextPath": "/pkg/microsoft/pxt-filesystem"
          },
          {
            "name": "File System",
            "subitems": [],
            "path": "/pkg/microsoft/pxt-filesystem",
            "prevName": "NeoPixel",
            "prevPath": "/pkg/microsoft/pxt-neopixel",
            "nextName": "Sonar",
            "nextPath": "/pkg/microsoft/pxt-sonar"
          },
          {
            "name": "Sonar",
            "subitems": [],
            "path": "/pkg/microsoft/pxt-sonar",
            "prevName": "File System",
            "prevPath": "/pkg/microsoft/pxt-filesystem",
            "nextName": "Bluetooth Temperature Sensor",
            "nextPath": "/pkg/microsoft/pxt-bluetooth-temperature-sensor"
          },
          {
            "name": "Bluetooth Temperature Sensor",
            "subitems": [],
            "path": "/pkg/microsoft/pxt-bluetooth-temperature-sensor",
            "prevName": "Sonar",
            "prevPath": "/pkg/microsoft/pxt-sonar",
            "nextName": "MAX6675",
            "nextPath": "/pkg/microsoft/pxt-max6675"
          },
          {
            "name": "MAX6675",
            "subitems": [],
            "path": "/pkg/microsoft/pxt-max6675",
            "prevName": "Bluetooth Temperature Sensor",
            "prevPath": "/pkg/microsoft/pxt-bluetooth-temperature-sensor",
            "nextName": "Bluetooth MAX6675",
            "nextPath": "/pkg/microsoft/pxt-bluetooth-max6675"
          },
          {
            "name": "Bluetooth MAX6675",
            "subitems": [],
            "path": "/pkg/microsoft/pxt-bluetooth-max6675",
            "prevName": "MAX6675",
            "prevPath": "/pkg/microsoft/pxt-max6675",
            "nextName": "MIDI",
            "nextPath": "/pkg/microsoft/pxt-midi"
          },
          {
            "name": "MIDI",
            "subitems": [],
            "path": "/pkg/microsoft/pxt-midi",
            "prevName": "Bluetooth MAX6675",
            "prevPath": "/pkg/microsoft/pxt-bluetooth-max6675",
            "nextName": "Bluetooth MIDI",
            "nextPath": "/pkg/microsoft/pxt-bluetooth-midi"
          },
          {
            "name": "Bluetooth MIDI",
            "subitems": [],
            "path": "/pkg/microsoft/pxt-bluetooth-midi",
            "prevName": "MIDI",
            "prevPath": "/pkg/microsoft/pxt-midi",
            "nextName": "Code Dojo Olney",
            "nextPath": "/pkg/CoderDojoOlney/pxt-olney"
          },
          {
            "name": "Code Dojo Olney",
            "subitems": [],
            "path": "/pkg/CoderDojoOlney/pxt-olney",
            "prevName": "Bluetooth MIDI",
            "prevPath": "/pkg/microsoft/pxt-bluetooth-midi",
            "nextName": "UCL Junk Robot",
            "nextPath": "/pkg/chevyng/pxt-ucl-junkrobot"
          },
          {
            "name": "UCL Junk Robot",
            "subitems": [],
            "path": "/pkg/chevyng/pxt-ucl-junkrobot",
            "prevName": "Code Dojo Olney",
            "prevPath": "/pkg/CoderDojoOlney/pxt-olney",
            "nextName": "SRS BitBot",
            "nextPath": "/pkg/srs/pxt-bitbot"
          },
          {
            "name": "SRS BitBot",
            "subitems": [],
            "path": "/pkg/srs/pxt-bitbot",
            "prevName": "UCL Junk Robot",
            "prevPath": "/pkg/chevyng/pxt-ucl-junkrobot",
            "nextName": "Blocks",
            "nextPath": "/blocks"
          }
        ],
        "path": "/packages",
        "prevName": "on signal strength changed",
        "prevPath": "/reference/devices/on-signal-strength-changed",
        "nextName": "NeoPixel",
        "nextPath": "/pkg/microsoft/pxt-neopixel"
      },
      {
        "name": "Blocks",
        "subitems": [
          {
            "name": "On Start",
            "subitems": [],
            "path": "/blocks/on-start",
            "prevName": "Blocks",
            "prevPath": "/blocks",
            "nextName": "Loops",
            "nextPath": "/blocks/loops"
          },
          {
            "name": "Loops",
            "subitems": [
              {
                "name": "repeat",
                "subitems": [],
                "path": "/blocks/loops/repeat",
                "prevName": "Loops",
                "prevPath": "/blocks/loops",
                "nextName": "for",
                "nextPath": "/blocks/loops/for"
              },
              {
                "name": "for",
                "subitems": [],
                "path": "/blocks/loops/for",
                "prevName": "repeat",
                "prevPath": "/blocks/loops/repeat",
                "nextName": "while",
                "nextPath": "/blocks/loops/while"
              },
              {
                "name": "while",
                "subitems": [],
                "path": "/blocks/loops/while",
                "prevName": "for",
                "prevPath": "/blocks/loops/for",
                "nextName": "Logic",
                "nextPath": "/blocks/logic"
              }
            ],
            "path": "/blocks/loops",
            "prevName": "On Start",
            "prevPath": "/blocks/on-start",
            "nextName": "repeat",
            "nextPath": "/blocks/loops/repeat"
          },
          {
            "name": "Logic",
            "subitems": [
              {
                "name": "if",
                "subitems": [],
                "path": "/blocks/logic/if",
                "prevName": "Logic",
                "prevPath": "/blocks/logic",
                "nextName": "Boolean",
                "nextPath": "/blocks/logic/boolean"
              },
              {
                "name": "Boolean",
                "subitems": [],
                "path": "/blocks/logic/boolean",
                "prevName": "if",
                "prevPath": "/blocks/logic/if",
                "nextName": "Variables",
                "nextPath": "/blocks/variables"
              }
            ],
            "path": "/blocks/logic",
            "prevName": "while",
            "prevPath": "/blocks/loops/while",
            "nextName": "if",
            "nextPath": "/blocks/logic/if"
          },
          {
            "name": "Variables",
            "subitems": [
              {
                "name": "assign",
                "subitems": [],
                "path": "/blocks/variables/assign",
                "prevName": "Variables",
                "prevPath": "/blocks/variables",
                "nextName": "change var",
                "nextPath": "/blocks/variables/change"
              },
              {
                "name": "change var",
                "subitems": [],
                "path": "/blocks/variables/change",
                "prevName": "assign",
                "prevPath": "/blocks/variables/assign",
                "nextName": "var",
                "nextPath": "/blocks/variables/var"
              },
              {
                "name": "var",
                "subitems": [],
                "path": "/blocks/variables/var",
                "prevName": "change var",
                "prevPath": "/blocks/variables/change",
                "nextName": "Math",
                "nextPath": "/blocks/math"
              }
            ],
            "path": "/blocks/variables",
            "prevName": "Boolean",
            "prevPath": "/blocks/logic/boolean",
            "nextName": "assign",
            "nextPath": "/blocks/variables/assign"
          },
          {
            "name": "Math",
            "subitems": [],
            "path": "/blocks/math",
            "prevName": "var",
            "prevPath": "/blocks/variables/var",
            "nextName": "JavaScript blocks",
            "nextPath": "/blocks/javascript-blocks"
          },
          {
            "name": "JavaScript blocks",
            "subitems": [],
            "path": "/blocks/javascript-blocks",
            "prevName": "Math",
            "prevPath": "/blocks/math",
            "nextName": "Custom blocks",
            "nextPath": "/blocks/custom"
          },
          {
            "name": "Custom blocks",
            "subitems": [],
            "path": "/blocks/custom",
            "prevName": "JavaScript blocks",
            "prevPath": "/blocks/javascript-blocks",
            "nextName": "JavaScript",
            "nextPath": "/javascript"
          }
        ],
        "path": "/blocks",
        "prevName": "SRS BitBot",
        "prevPath": "/pkg/srs/pxt-bitbot",
        "nextName": "On Start",
        "nextPath": "/blocks/on-start"
      },
      {
        "name": "JavaScript",
        "subitems": [
          {
            "name": "Calling",
            "subitems": [],
            "path": "/javascript/call",
            "prevName": "JavaScript",
            "prevPath": "/javascript",
            "nextName": "Sequencing",
            "nextPath": "/javascript/sequence"
          },
          {
            "name": "Sequencing",
            "subitems": [],
            "path": "/javascript/sequence",
            "prevName": "Calling",
            "prevPath": "/javascript/call",
            "nextName": "Variables",
            "nextPath": "/javascript/variables"
          },
          {
            "name": "Variables",
            "subitems": [],
            "path": "/javascript/variables",
            "prevName": "Sequencing",
            "prevPath": "/javascript/sequence",
            "nextName": "Operators",
            "nextPath": "/javascript/operators"
          },
          {
            "name": "Operators",
            "subitems": [],
            "path": "/javascript/operators",
            "prevName": "Variables",
            "prevPath": "/javascript/variables",
            "nextName": "Statements",
            "nextPath": "/javascript/statements"
          },
          {
            "name": "Statements",
            "subitems": [],
            "path": "/javascript/statements",
            "prevName": "Operators",
            "prevPath": "/javascript/operators",
            "nextName": "Functions",
            "nextPath": "/javascript/functions"
          },
          {
            "name": "Functions",
            "subitems": [],
            "path": "/javascript/functions",
            "prevName": "Statements",
            "prevPath": "/javascript/statements",
            "nextName": "Types",
            "nextPath": "/javascript/types"
          },
          {
            "name": "Types",
            "subitems": [],
            "path": "/javascript/types",
            "prevName": "Functions",
            "prevPath": "/javascript/functions",
            "nextName": "Classes",
            "nextPath": "/javascript/classes"
          },
          {
            "name": "Classes",
            "subitems": [],
            "path": "/javascript/classes",
            "prevName": "Types",
            "prevPath": "/javascript/types",
            "nextName": "Interfaces",
            "nextPath": "/javascript/interfaces"
          },
          {
            "name": "Interfaces",
            "subitems": [],
            "path": "/javascript/interfaces",
            "prevName": "Classes",
            "prevPath": "/javascript/classes",
            "nextName": "Generics",
            "nextPath": "/javascript/generics"
          },
          {
            "name": "Generics",
            "subitems": [],
            "path": "/javascript/generics",
            "prevName": "Interfaces",
            "prevPath": "/javascript/interfaces",
            "nextName": "Types",
            "nextPath": "/types"
          }
        ],
        "path": "/javascript",
        "prevName": "Custom blocks",
        "prevPath": "/blocks/custom",
        "nextName": "Calling",
        "nextPath": "/javascript/call"
      },
      {
        "name": "Types",
        "subitems": [
          {
            "name": "Number",
            "subitems": [],
            "path": "/types/number",
            "prevName": "Types",
            "prevPath": "/types",
            "nextName": "String",
            "nextPath": "/types/string"
          },
          {
            "name": "String",
            "subitems": [],
            "path": "/types/string",
            "prevName": "Number",
            "prevPath": "/types/number",
            "nextName": "Boolean",
            "nextPath": "/types/boolean"
          },
          {
            "name": "Boolean",
            "subitems": [],
            "path": "/types/boolean",
            "prevName": "String",
            "prevPath": "/types/string",
            "nextName": "Array",
            "nextPath": "/types/array"
          },
          {
            "name": "Array",
            "subitems": [],
            "path": "/types/array",
            "prevName": "Boolean",
            "prevPath": "/types/boolean",
            "nextName": "Function",
            "nextPath": "/types/function"
          },
          {
            "name": "Function",
            "subitems": [],
            "path": "/types/function",
            "prevName": "Array",
            "prevPath": "/types/array",
            "nextName": "Hardware",
            "nextPath": "/device"
          }
        ],
        "path": "/types",
        "prevName": "Generics",
        "prevPath": "/javascript/generics",
        "nextName": "Number",
        "nextPath": "/types/number"
      },
      {
        "name": "Hardware",
        "subitems": [
          {
            "name": "Error codes",
            "subitems": [],
            "path": "/device/error-codes",
            "prevName": "Hardware",
            "prevPath": "/device",
            "nextName": "Foil circuits",
            "nextPath": "/device/foil-circuits"
          },
          {
            "name": "Foil circuits",
            "subitems": [],
            "path": "/device/foil-circuits",
            "prevName": "Error codes",
            "prevPath": "/device/error-codes",
            "nextName": "MES events",
            "nextPath": "/device/mes-events"
          },
          {
            "name": "MES events",
            "subitems": [],
            "path": "/device/mes-events",
            "prevName": "Foil circuits",
            "prevPath": "/device/foil-circuits",
            "nextName": "Pins",
            "nextPath": "/device/pins"
          },
          {
            "name": "Pins",
            "subitems": [],
            "path": "/device/pins",
            "prevName": "MES events",
            "prevPath": "/device/mes-events",
            "nextName": "Reactive",
            "nextPath": "/device/reactive"
          },
          {
            "name": "Reactive",
            "subitems": [],
            "path": "/device/reactive",
            "prevName": "Pins",
            "prevPath": "/device/pins",
            "nextName": "Screen",
            "nextPath": "/device/screen"
          },
          {
            "name": "Screen",
            "subitems": [],
            "path": "/device/screen",
            "prevName": "Reactive",
            "prevPath": "/device/reactive",
            "nextName": "Serial",
            "nextPath": "/device/serial"
          },
          {
            "name": "Serial",
            "subitems": [],
            "path": "/device/serial",
            "prevName": "Screen",
            "prevPath": "/device/screen",
            "nextName": "Servo",
            "nextPath": "/device/servo"
          },
          {
            "name": "Servo",
            "subitems": [],
            "path": "/device/servo",
            "prevName": "Serial",
            "prevPath": "/device/serial",
            "nextName": "Simulator",
            "nextPath": "/device/simulator"
          },
          {
            "name": "Simulator",
            "subitems": [],
            "path": "/device/simulator",
            "prevName": "Servo",
            "prevPath": "/device/servo",
            "nextName": "Usb",
            "nextPath": "/device/usb"
          },
          {
            "name": "Usb",
            "subitems": [],
            "path": "/device/usb",
            "prevName": "Simulator",
            "prevPath": "/device/simulator",
            "nextName": "Support",
            "nextPath": "/support"
          }
        ],
        "path": "/device",
        "prevName": "Function",
        "prevPath": "/types/function",
        "nextName": "Error codes",
        "nextPath": "/device/error-codes"
      },
      {
        "name": "",
        "subitems": [
          {
            "name": "Support",
            "subitems": [],
            "path": "/support",
            "prevName": "Usb",
            "prevPath": "/device/usb",
            "nextName": "FAQ",
            "nextPath": "/faq"
          },
          {
            "name": "FAQ",
            "subitems": [],
            "path": "/faq",
            "prevName": "Support",
            "prevPath": "/support",
            "nextName": "Translate",
            "nextPath": "/translate"
          },
          {
            "name": "Translate",
            "subitems": [],
            "path": "/translate",
            "prevName": "FAQ",
            "prevPath": "/faq",
            "nextName": "Sharing projects",
            "nextPath": "/share"
          },
          {
            "name": "Sharing projects",
            "subitems": [],
            "path": "/share",
            "prevName": "Translate",
            "prevPath": "/translate",
            "nextName": "Offline support",
            "nextPath": "/offline"
          },
          {
            "name": "Offline support",
            "subitems": [],
            "path": "/offline",
            "prevName": "Sharing projects",
            "prevPath": "/share",
            "nextName": "Streaming",
            "nextPath": "/streaming"
          },
          {
            "name": "Streaming",
            "subitems": [],
            "path": "/streaming",
            "prevName": "Offline support",
            "prevPath": "/offline",
            "nextName": "Command Line Interface",
            "nextPath": "/cli"
          }
        ],
        "prevName": "Usb",
        "prevPath": "/device/usb"
      },
      {
        "name": "",
        "subitems": [
          {
            "name": "Command Line Interface",
            "subitems": [],
            "path": "/cli",
            "prevName": "Streaming",
            "prevPath": "/streaming",
            "nextName": "Visual Studio Code support",
            "nextPath": "/code"
          },
          {
            "name": "Visual Studio Code support",
            "subitems": [],
            "path": "/code",
            "prevName": "Command Line Interface",
            "prevPath": "/cli",
            "nextName": "Coding on Raspberry Pi",
            "nextPath": "/raspberry-pi"
          },
          {
            "name": "Coding on Raspberry Pi",
            "subitems": [],
            "path": "/raspberry-pi",
            "prevName": "Visual Studio Code support",
            "prevPath": "/code"
          }
        ],
        "prevName": "Streaming",
        "prevPath": "/streaming"
      }
    ],
    "id": "microbit",
    "title": "Microsoft MakeCode for micro:bit",
    "name": "makecode.microbit.org",
    "description": "A Blocks / JavaScript code editor for the micro:bit powered by Microsoft MakeCode.",
    "logoCDN": "@cdnUrl@/blob/d955ce94fc3f7d2c6573300c71a56dc1d92c9bf0/static/logo.portrait.white.svg",
    "docsLogoCDN": "@cdnUrl@/blob/3403510141da69da71b1fbb1024619a3ba88ac29/static/logo.square.white.svg",
    "portraitLogoCDN": "@cdnUrl@/blob/3403510141da69da71b1fbb1024619a3ba88ac29/static/logo.square.white.svg",
    "footerLogoCDN": "@cdnUrl@/blob/642175ae61e6822c948990e15570e590d2e0ecf1/static/logo.portrait.black.svg",
    "cardLogoCDN": "@cdnUrl@/blob/4de54063603c8d16531078818a83f7c29a3588fa/static/icons/apple-touch-icon.png",
    "appLogoCDN": "@cdnUrl@/blob/4de54063603c8d16531078818a83f7c29a3588fa/static/icons/apple-touch-icon.png",
    "organizationLogoCDN": "@cdnUrl@/blob/f5f83b8c33d027642954f4f833432de810768249/static/Microsoft-logo_rgb_c-gray-square.png",
    "organizationWideLogoCDN": "@cdnUrl@/blob/e0a49fdb57be4b7e22d974e8e37171a47fa2fd0f/static/Microsoft-logo_rgb_c-white.png",
    "htmlDocIncludes": {}
  },
  "blocksprj": {
    "id": "blocksprj",
    "config": {
      "name": "{0} block",
      "dependencies": {
        "core": "*",
        "radio": "*"
      },
      "description": "",
      "files": [
        "main.blocks",
        "main.ts",
        "README.md"
      ]
    },
    "files": {
      "README.md": "",
      "main.blocks": "<xml xmlns=\"http://www.w3.org/1999/xhtml\">\n  <block type=\"pxt-on-start\"></block>\n  <block type=\"device_forever\"></block>\n</xml>",
      "main.ts": "\n"
    }
  },
  "tsprj": {
    "id": "tsprj",
    "config": {
      "name": "{0} bit",
      "dependencies": {
        "core": "*",
        "radio": "*"
      },
      "description": "",
      "files": [
        "main.ts",
        "README.md"
      ]
    },
    "files": {
      "README.md": "",
      "main.ts": "basic.showLeds(`\n    . . . . .\n    . # . # .\n    . . . . .\n    # . . . #\n    . # # # .\n    `);"
    }
  },
  "bundledpkgs": {
    "core": {
      "ManagedBuffer.cpp": "#include \"MicroBit.h\"\n#include \"ManagedBuffer.h\"\n#include <limits.h>\n\nstatic const char empty[] __attribute__ ((aligned (4))) = \"\\xff\\xff\\0\\0\\0\";\n\n/**\n  * Internal constructor helper.\n  * Configures this ManagedBuffer to refer to the static empty buffer.\n  */\nvoid ManagedBuffer::initEmpty()\n{\n    ptr = (BufferData*)(void*)empty;\n}\n\n/**\n * Default Constructor. \n * Creates an empty ManagedBuffer. \n *\n * Example:\n * @code\n * ManagedBuffer p(); \n * @endcode\n */\nManagedBuffer::ManagedBuffer()\n{\n    initEmpty();\n}\n\n/**\n * Constructor. \n * Creates an empty ManagedBuffer of the given size. \n *\n * @param length The length of the buffer to create.\n *\n * Example:\n * @code\n * ManagedBuffer p(16);         // Creates a ManagedBuffer 16 bytes long.\n * @endcode\n */\nManagedBuffer::ManagedBuffer(int length)\n{\n    this->init(NULL, length);\n}\n\n/**\n * Constructor. \n * Creates a new ManagedBuffer of the given size,\n * and fills it with the data provided.\n *\n * @param data The data with which to fill the buffer.\n * @param length The length of the buffer to create.\n * \n * Example:\n * @code\n * uint8_t buf = {13,5,2};\n * ManagedBuffer p(buf, 3);         // Creates a ManagedBuffer 3 bytes long.\n * @endcode\n */\nManagedBuffer::ManagedBuffer(uint8_t *data, int length)\n{\n    this->init(data, length);\n}\n\n/**\n * Copy Constructor. \n * Add ourselves as a reference to an existing ManagedBuffer.\n * \n * @param buffer The ManagedBuffer to reference.\n *\n * Example:\n * @code\n * ManagedBuffer p();\n * ManagedBuffer p2(i);        // Refers to the same buffer as p. \n * @endcode\n */\nManagedBuffer::ManagedBuffer(const ManagedBuffer &buffer)\n{\n    ptr = buffer.ptr;\n    ptr->incr();\n}\n\n/**\n  * Constructor. \n  * Create a buffer from a raw BufferData pointer. It will ptr->incr(). This is to be used by specialized runtimes.\n  *\n  * @param p The pointer to use.\n  */    \nManagedBuffer::ManagedBuffer(BufferData *p)\n{\n    ptr = p;\n    ptr->incr();\n}\n\n/**\n * Internal constructor-initialiser.\n *\n * @param data The data with which to fill the buffer.\n * @param length The length of the buffer to create.\n * \n */\nvoid ManagedBuffer::init(uint8_t *data, int length)\n{\n    if (length <= 0) {\n        initEmpty();\n        return;\n    }\n\n    ptr = (BufferData *) malloc(sizeof(BufferData) + length);\n    ptr->init();\n\n    ptr->length = length;\n\n    // Copy in the data buffer, if provided.\n    if (data)\n        memcpy(ptr->payload, data, length);\n    else\n        memset(ptr->payload, 0, length);\n}\n\n/**\n * Destructor. \n * Removes buffer resources held by the instance.\n */\nManagedBuffer::~ManagedBuffer()\n{\n    ptr->decr();\n}\n\n/**\n * Copy assign operation. \n *\n * Called when one ManagedBuffer is assigned the value of another using the '=' operator.\n * Decrements our reference count and free up the buffer as necessary.\n * Then, update our buffer to refer to that of the supplied ManagedBuffer,\n * and increase its reference count.\n *\n * @param p The ManagedBuffer to reference.\n * \n * Example:\n * @code\n * uint8_t buf = {13,5,2};\n * ManagedBuffer p1(16); \n * ManagedBuffer p2(buf, 3);        \n *\n * p1 = p2;  \n * @endcode\n */\nManagedBuffer& ManagedBuffer::operator = (const ManagedBuffer &p)\n{\n    if(ptr == p.ptr)\n        return *this;\n\n    ptr->decr();\n    ptr = p.ptr;\n    ptr->incr();\n\n    return *this;\n}\n\n/**\n * Equality operation.\n *\n * Called when one ManagedBuffer is tested to be equal to another using the '==' operator.\n *\n * @param p The ManagedBuffer to test ourselves against.\n * @return true if this ManagedBuffer is identical to the one supplied, false otherwise.\n * \n * Example:\n * @code\n *\n * uint8_t buf = {13,5,2};\n * ManagedBuffer p1(16); \n * ManagedBuffer p2(buf, 3);        \n *\n * if(p1 == p2)                    // will be true\n *     uBit.display.scroll(\"same!\");\n * @endcode\n */\nbool ManagedBuffer::operator== (const ManagedBuffer& p)\n{\n    if (ptr == p.ptr)\n        return true;\n    else\n        return (ptr->length == p.ptr->length && (memcmp(ptr->payload, p.ptr->payload, ptr->length)==0));    \n}\n\n/**\n * Sets the byte at the given index to value provided.\n * @param position The index of the byte to change.\n * @param value The new value of the byte (0-255).\n * @return MICROBIT_OK, or MICROBIT_INVALID_PARAMETER.\n *\n * Example:\n * @code\n * ManagedBuffer p1(16); \n * p1.setByte(0,255);              // Sets the firts byte in the buffer to the value 255.\n * @endcode\n */\nint ManagedBuffer::setByte(int position, uint8_t value)\n{\n    if (0 <= position && position < ptr->length)\n    {\n        ptr->payload[position] = value;\n        return MICROBIT_OK;\n    }\n    else\n    {\n        return MICROBIT_INVALID_PARAMETER;\n    }\n}\n\n/**\n * Determines the value of the given byte in the buffer.\n *\n * @param position The index of the byte to read.\n * @return The value of the byte at the given position, or MICROBIT_INVALID_PARAMETER.\n *\n * Example:\n * @code\n * ManagedBuffer p1(16); \n * p1.setByte(0,255);              // Sets the firts byte in the buffer to the value 255.\n * p1.getByte(0);                  // Returns 255.\n * @endcode\n */\nint ManagedBuffer::getByte(int position)\n{\n    if (0 <= position && position < ptr->length)\n        return ptr->payload[position];\n    else\n        return MICROBIT_INVALID_PARAMETER;\n} \n\n/**\n  * Get current ptr, do not decr() it, and set the current instance to an empty buffer.\n  * This is to be used by specialized runtimes which pass BufferData around.\n  */\nBufferData *ManagedBuffer::leakData()\n{\n    BufferData* res = ptr;\n    initEmpty();\n    return res;\n}\n\n\nint ManagedBuffer::fill(uint8_t value, int offset, int length)\n{\n    if (offset < 0 || offset > ptr->length)\n        return MICROBIT_INVALID_PARAMETER;\n    if (length < 0)\n        length = ptr->length;\n    length = min(length, ptr->length - offset);\n\n    memset(ptr->payload + offset, value, length);\n\n    return MICROBIT_OK;\n}\n\nManagedBuffer ManagedBuffer::slice(int offset, int length) const\n{\n    offset = min(ptr->length, offset);\n    if (length < 0)\n        length = ptr->length;\n    length = min(length, ptr->length - offset);\n    return ManagedBuffer(ptr->payload + offset, length);\n}\n\nvoid ManagedBuffer::shift(int offset, int start, int len)\n{\n    if (len < 0) len = ptr->length - start;    \n    if (start < 0 || start + len > ptr->length || start + len < start\n        || len == 0 || offset == 0 || offset == INT_MIN) return;\n    if (offset <= -len || offset >= len) {\n        fill(0);\n        return;\n    }\n        \n    uint8_t *data = ptr->payload + start;\n    if (offset < 0) {\n        offset = -offset;\n        memmove(data + offset, data, len - offset);\n        memset(data, 0, offset);\n    } else {\n        len = len - offset;\n        memmove(data, data + offset, len);\n        memset(data + len, 0, offset);\n    }\n}\n\nvoid ManagedBuffer::rotate(int offset, int start, int len)\n{\n    if (len < 0) len = ptr->length - start;\n    if (start < 0 || start + len > ptr-> length || start + len < start\n        || len == 0 || offset == 0 || offset == INT_MIN) return;\n\n    if (offset < 0)\n        offset += len << 8; // try to make it positive\n    offset %= len;\n    if (offset < 0)\n        offset += len;\n\n    uint8_t *data = ptr->payload + start;\n\n    uint8_t *n_first = data + offset;\n    uint8_t *first = data;\n    uint8_t *next = n_first;\n    uint8_t *last = data + len;\n\n    while (first != next) {\n        uint8_t tmp = *first;\n        *first++ = *next;\n        *next++ = tmp;\n        if (next == last) {\n            next = n_first;\n        } else if (first == n_first) {\n            n_first = next;\n        }\n    }\n}\n\nint ManagedBuffer::writeBuffer(int dstOffset, const ManagedBuffer &src, int srcOffset, int length)\n{\n    if (length < 0)\n        length = src.length();\n\n    if (srcOffset < 0 || dstOffset < 0 || dstOffset > ptr->length)\n        return MICROBIT_INVALID_PARAMETER;\n\n    length = min(src.length() - srcOffset, ptr->length - dstOffset);\n\n    if (length < 0)\n        return MICROBIT_INVALID_PARAMETER;\n\n    if (ptr == src.ptr) {\n        memmove(getBytes() + dstOffset, src.ptr->payload + srcOffset, length);\n    } else {\n        memcpy(getBytes() + dstOffset, src.ptr->payload + srcOffset, length);\n    }\n\n    return MICROBIT_OK;\n}\n\nint ManagedBuffer::writeBytes(int offset, uint8_t *src, int length, bool swapBytes)\n{\n    if (offset < 0 || length < 0 || offset + length > ptr->length)\n        return MICROBIT_INVALID_PARAMETER;\n\n    if (swapBytes) {\n        uint8_t *p = ptr->payload + offset + length;\n        for (int i = 0; i < length; ++i)\n            *--p = src[i];\n    } else {\n        memcpy(ptr->payload + offset, src, length);\n    }\n\n    return MICROBIT_OK;\n}\n\nint ManagedBuffer::readBytes(uint8_t *dst, int offset, int length, bool swapBytes) const\n{\n    if (offset < 0 || length < 0 || offset + length > ptr->length)\n        return MICROBIT_INVALID_PARAMETER;\n\n    if (swapBytes) {\n        uint8_t *p = ptr->payload + offset + length;\n        for (int i = 0; i < length; ++i)\n            dst[i] = *--p;\n    } else {\n        memcpy(dst, ptr->payload + offset, length);\n    }\n\n    return MICROBIT_OK;\n}\n",
      "ManagedBuffer.h": "#ifndef MICROBIT_MANAGED_BUFFER_H\n#define MICROBIT_MANAGED_BUFFER_H\n\n#include \"mbed.h\"\n#include \"RefCounted.h\"\n\nstruct BufferData : RefCounted\n{\n    uint16_t        length;             // The length of the payload in bytes\n    uint8_t         payload[0];         // ManagedBuffer data\n};\n\n/**\n  * Class definition for a ManagedBuffer.\n  * A ManagedBuffer holds a series of bytes, used with MicroBitRadio channels and in other places.\n  * n.b. This is a mutable, managed type.\n  */\nclass ManagedBuffer\n{\n    BufferData      *ptr;     // Pointer to payload data\n    \n    public:\n\n    /**\n      * Default Constructor. \n      * Creates an empty ManagedBuffer.  The 'ptr' field in all empty buffers is shared.\n      *\n      * Example:\n      * @code\n      * ManagedBuffer p(); \n      * @endcode\n      */\n    ManagedBuffer();\n\n    /**\n      * Constructor. \n      * Creates a new ManagedBuffer of the given size. \n      *\n      * @param length The length of the buffer to create.\n      *\n      * Example:\n      * @code\n      * ManagedBuffer p(16);         // Creates a ManagedBuffer 16 bytes long.\n      * @endcode\n      */\n    ManagedBuffer(int length);\n\n    /**\n      * Constructor. \n      * Creates an empty ManagedBuffer of the given size,\n      * and fills it with the data provided.\n      *\n      * @param data The data with which to fill the buffer.\n      * @param length The length of the buffer to create.\n      * \n      * Example:\n      * @code\n      * uint8_t buf[] = {13,5,2};\n      * ManagedBuffer p(buf, 3);         // Creates a ManagedBuffer 3 bytes long.\n      * @endcode\n      */\n    ManagedBuffer(uint8_t *data, int length);\n\n    /**\n      * Copy Constructor. \n      * Add ourselves as a reference to an existing ManagedBuffer.\n      * \n      * @param buffer The ManagedBuffer to reference.\n      *\n      * Example:\n      * @code\n      * ManagedBuffer p();\n      * ManagedBuffer p2(i);        // Refers to the same buffer as p. \n      * @endcode\n      */\n    ManagedBuffer(const ManagedBuffer &buffer);\n\n    /**\n      * Constructor. \n      * Create a buffer from a raw BufferData pointer. It will ptr->incr(). This is to be used by specialized runtimes.\n      *\n      * @param p The pointer to use.\n      */    \n    ManagedBuffer(BufferData *p);\n\n    /**\n      * Internal constructor helper.\n      * Configures this ManagedBuffer to refer to the static empty buffer.\n      */\n    void initEmpty();\n\n    /**\n     * Internal constructor-initialiser.\n     *\n     * @param data The data with which to fill the buffer.\n     * @param length The length of the buffer to create.\n     * \n     */\n    void init(uint8_t *data, int length);\n\n    /**\n      * Destructor. \n      * Removes buffer resources held by the instance.\n      */\n    ~ManagedBuffer();\n\n    /**\n      * Provide an array containing the buffer data.\n      * @return The contents of this buffer, as an array of bytes.\n      */\n    uint8_t *getBytes()\n    {\n        return ptr->payload;\n    }\n\n    /**\n      * Get current ptr, do not decr() it, and set the current instance to an empty buffer.\n      * This is to be used by specialized runtimes which pass BufferData around.\n      */\n    BufferData *leakData();\n\n    /**\n      * Copy assign operation. \n      *\n      * Called when one ManagedBuffer is assigned the value of another using the '=' operator.\n      * Decrements our reference count and free up the buffer as necessary.\n      * Then, update our buffer to refer to that of the supplied ManagedBuffer,\n      * and increase its reference count.\n      *\n      * @param p The ManagedBuffer to reference.\n      * \n      * Example:\n      * @code\n      * uint8_t buf = {13,5,2};\n      * ManagedBuffer p1(16); \n      * ManagedBuffer p2(buf, 3);        \n      *\n      * p1 = p2;  \n      * @endcode\n      */\n    ManagedBuffer& operator = (const ManagedBuffer& p);\n\n    /**\n     * Array access operation (read). \n     *\n     * Called when a ManagedBuffer is dereferenced with a [] operation.\n     * Transparently map this through to the underlying payload for elegance of programming.\n     *\n     * Example:\n     * @code\n     * ManagedBuffer p1(16); \n     * uint8_t data = p1[0];\n     * @endcode\n     */\n    uint8_t operator [] (int i) const\n    {\n        return ptr->payload[i];\n    }\n\n    /**\n     * Array access operation (modify). \n     *\n     * Called when a ManagedBuffer is dereferenced with a [] operation.\n     * Transparently map this through to the underlying payload for elegance of programming.\n     *\n     * Example:\n     * @code\n     * ManagedBuffer p1(16); \n     * p1[0] = 42;\n     * @endcode\n     */\n    uint8_t& operator [] (int i)\n    {\n        return ptr->payload[i];\n    }\n\n    /**\n      * Equality operation.\n      *\n      * Called when one ManagedBuffer is tested to be equal to another using the '==' operator.\n      *\n      * @param p The ManagedBuffer to test ourselves against.\n      * @return true if this ManagedBuffer is identical to the one supplied, false otherwise.\n      * \n      * Example:\n      * @code\n      *\n      * uint8_t buf = {13,5,2};\n      * ManagedBuffer p1(16); \n      * ManagedBuffer p2(buf, 3);        \n      *\n      * if(p1 == p2)                    // will be true\n      *     uBit.display.scroll(\"same!\");\n      * @endcode\n      */\n    bool operator== (const ManagedBuffer& p);\n    \n    /**\n      * Sets the byte at the given index to value provided.\n      * @param position The index of the byte to change.\n      * @param value The new value of the byte (0-255).\n      * @return MICROBIT_OK, or MICROBIT_INVALID_PARAMETER.\n      *\n      * Example:\n      * @code\n      * ManagedBuffer p1(16); \n      * p1.setByte(0,255);              // Sets the first byte in the buffer to the value 255.\n      * @endcode\n      */\n    int setByte(int position, uint8_t value);\n\n    /**\n      * Determines the value of the given byte in the buffer.\n      *\n      * @param position The index of the byte to read.\n      * @return The value of the byte at the given position, or MICROBIT_INVALID_PARAMETER.\n      *\n      * Example:\n      * @code\n      * ManagedBuffer p1(16); \n      * p1.setByte(0,255);              // Sets the first byte in the buffer to the value 255.\n      * p1.getByte(0);                  // Returns 255.\n      * @endcode\n      */\n    int getByte(int position);\n\n    /**\n      * Gets number of bytes in this buffer \n      * @return The size of the buffer in bytes.\n      * \n      * Example:\n      * @code\n      * ManagedBuffer p1(16); \n      * p1.length();                 // Returns 16.\n      * @endcode\n      */\n    int length() const { return ptr->length; }\n\n    int fill(uint8_t value, int offset = 0, int length = -1);\n\n    ManagedBuffer slice(int offset = 0, int length = -1) const;\n\n    void shift(int offset, int start = 0, int length = -1);\n\n    void rotate(int offset, int start = 0, int length = -1);\n\n    int readBytes(uint8_t *dst, int offset, int length, bool swapBytes = false) const;\n\n    int writeBytes(int dstOffset, uint8_t *src, int length, bool swapBytes = false);\n\n    int writeBuffer(int dstOffset, const ManagedBuffer &src, int srcOffset = 0, int length = -1);\n\n    bool isReadOnly() const { return ptr->isReadOnly(); }\n};\n\n#endif\n\n",
      "README.md": "# core\n\nThe core library.\n\n",
      "_locales/de/core-jsdoc-strings.json": "{\n  \"Math.abs\": \"Gibt den absoluten Wert einer Zahl aus (den Wert unabhängig davon, ob er positiv oder negativ ist).\\nDer absolute Wert von -5 ist zum Beispiel der gleiche wie der von 5.\",\n  \"Math.abs|param|x\": \"Ein numerischer Ausdruck, für den der absolute Wert benötigt wird.\",\n  \"Math.max\": \"Gibt den größeren von zwei vorhandenen numerischen Ausdrücken aus.\",\n  \"Math.min\": \"Gibt den niedrigeren von zwei vorhandenen numerischen Ausdrücken aus.\",\n  \"Math.pow\": \"Gibt den Wert eines grundlegenden Ausdrucks bis zu einer bestimmten Stärke aus.\",\n  \"Math.pow|param|x\": \"Der Basiswert des Ausdrucks.\",\n  \"Math.pow|param|y\": \"Der exponentielle Wert des Ausdrucks.\",\n  \"Math.random\": \"Gibt eine pseudozufüllige Zahl zwischen 0 und `max`aus.\",\n  \"Math.randomBoolean\": \"Erzeugt zufällig einen \\\"wahr\\\" oder \\\"falsch\\\"-Wert, wie bei einem Münzwurf.\",\n  \"Math.sign\": \"Gibt das Vorzeichen von x aus und zeigt an, ob dieses positiv, negativ oder null ist.\",\n  \"Math.sign|param|x\": \"Der numerische Ausdruck, der getestet werden soll\",\n  \"Math.sqrt\": \"Gibt die Quadratwurzel einer Zahl aus.\",\n  \"Math.sqrt|param|x\": \"Ein numerischer Ausdruck.\",\n  \"String.charAt\": \"Gibt den Buchstaben beim angegebenen Index aus.\",\n  \"String.charAt|param|index\": \"Der null-basierte index des gewünschten Zeichens.\",\n  \"String.charCodeAt\": \"Gibt den Unicode-Wert des Zeichens am vorgegebenen Ort aus.\",\n  \"String.charCodeAt|param|index\": \"Der null-basierte Index des gewünschten Zeichens. Wenn kein Zeichen am angegeben Index vorhanden ist, wird NaN ausgegeben.\",\n  \"String.compare\": \"Bestimmt die relative Reihenfolge zweier Strings (in ASCII).\",\n  \"String.compare|param|that\": \"Zeichenfolge, die mit der Zielzeichenfolge verglichen werden soll\",\n  \"String.concat\": \"Gibt eine Zeichenfolge aus, die die Verkettung von zwei oder mehr Zeichenfolgen ist.\",\n  \"String.concat|param|other\": \"Die Zeichenfolge, die an das Ende einer Zeichenfolge angehängt werden soll.\",\n  \"String.fromCharCode\": \"Erstelle Sie eine Zeichenfolge aus dem angegebenen ASCII-Zeichencode.\",\n  \"String.isEmpty\": \"Gibt einen Wert aus, der anzeigt, ob die Zeichenfolge leer ist\",\n  \"String.length\": \"Gibt die Länge einer Zeichenfolge aus.\",\n  \"String.substr\": \"Gibt eine Teilzeichenfolge der aktuellen Zeichenfolge aus.\",\n  \"String.substr|param|length\": \"Anzahl der zu extrahierenden Zeichen\",\n  \"String.substr|param|start\": \"Erster Zeichenindex, kann beim zählen vom Ende negativ sein, zum Beispiel: 0\",\n  \"basic\": \"Bietet Zugriff auf grundlegende mini-Funktionalität.\",\n  \"basic.clearScreen\": \"Schalte alle LEDs aus\",\n  \"basic.forever\": \"Wiederholt immer wieder den Code im Hintergrund. Bei jeder Iteration ist es möglich, anderen Code auszuführen.\",\n  \"basic.pause\": \"Pausiere für die angegebene Zeit in Millisekunden\",\n  \"basic.pause|param|ms\": \"wie lange pausieren, z.B.: 100, 200, 500, 1000, 2000\",\n  \"basic.plotLeds\": \"Zeichnet ein Bild auf dem LED-Bildschirm.\",\n  \"basic.plotLeds|param|leds\": \"Muster der LEDs, die ein-/ und ausgeschaltet werden\",\n  \"basic.showAnimation\": \"Zeigt eine Abfolge von LED-Anzeigen als Animation.\",\n  \"basic.showAnimation|param|interval\": \"Zeit in Millisekunden zwischen jedem Neuzeichnen\",\n  \"basic.showAnimation|param|leds\": \"Muster der LEDs, die ein-/ und ausgeschaltet werden\",\n  \"basic.showLeds\": \"Zeichnet ein Bild auf dem LED-Bildschirm.\",\n  \"basic.showLeds|param|interval\": \"Zeit in Millisekunden, die nach der Zeichnung gewartet wird\",\n  \"basic.showLeds|param|leds\": \"Muster der LEDs, die ein- und ausgeschaltet werden\",\n  \"basic.showNumber\": \"Zeige eine Nummer auf dem Display. Wenn die Nummer auf das Display passt (es sich also um eine einstellige Zahl handelt), scrolle nicht weiter.\",\n  \"basic.showNumber|param|interval\": \"Scroll-Geschwindigkeit; z.B. 150, 100, 200,-100\",\n  \"basic.showString\": \"Zeige Text auf dem Display an, Buchstabe für Buchstabe. Wenn die Zeichenfolge in das Display passt (also wenn es sich um einen einzelnen Buchstaben handelt), scrolle nicht weiter.\",\n  \"basic.showString|param|interval\": \"Wie schnell die Zeichen geändert werden; z.B. 150, 100, 200,-100\",\n  \"basic.showString|param|text\": \"Text auf dem Bildschirm dargestellt werden soll, z.B.: \\\"Hallo!\\\"\",\n  \"control\": \"Laufzeit- und Event-Dienstprogramme.\",\n  \"control.assert\": \"Wenn die Bedingung falsch ist, zeige eine Nachricht auf der seriellen Konsole und gebe Panic-Code 098 aus\",\n  \"control.deviceName\": \"Erzeugt einen Namen für das Gerät, basierend auf der Seriennummer\",\n  \"control.deviceSerialNumber\": \"Leite eine einzigartige, einheitliche Seriennummer dieses Gerätes aus den internen Daten ab.\",\n  \"control.eventSourceId\": \"Gibt den Wert einer C++-Laufzeitkonstanten aus\",\n  \"control.eventTimestamp\": \"Holt den Zeitstempel des letzten Events auf dem Bus\",\n  \"control.eventValue\": \"Holt den Wert des letzten ausgeführten Events auf dem Bus\",\n  \"control.eventValueId\": \"Gibt den Wert einer C++-Laufzeitkonstanten aus\",\n  \"control.inBackground\": \"Plant Code, der im Hintergrund wiedergegeben wird.\",\n  \"control.onEvent\": \"Startet ein Event auf dem Event-Bus.\",\n  \"control.panic\": \"Zeigt einen spezifizierten Fehlercode und hält das Programm an.\",\n  \"control.raiseEvent\": \"Startet ein Event auf dem Event-Bus.\",\n  \"control.raiseEvent|param|mode\": \"optionale Definition davon, wie ein Event nach dem Erstellen ausgeführt wird (Standard ist \\\"CREATE_AND_FIRE).\",\n  \"control.raiseEvent|param|src\": \"ID der Calliope mini-Komponente, die das Event generiert hat, zum Beispiel CALLIOPE_ID_BUTTON_A.\",\n  \"control.raiseEvent|param|value\": \"Komponentenspezifischer Code, der den Grund des Events angibt.\",\n  \"control.reset\": \"Seit den mini zurück.\",\n  \"control.runtimeWarning\": \"Zeige Warnmeldung im Simulator.\",\n  \"control.waitMicros\": \"Sperrt die aktuelle Leitung für die Dauer der angegebenen Mikrosekunden\",\n  \"control.waitMicros|param|micros\": \"Anzahl der Mikrosekunden, die gewartet werden soll, z.B.: 4\",\n  \"game\": \"Eine Einzel-LED-Sprite-Spielumgebung\",\n  \"game.addLife\": \"Fügt Leben zum aktuellen Spielstand hinzu\",\n  \"game.addScore\": \"Fügt zum aktuellen Spielstand Punkte hinzu\",\n  \"game.addScore|param|points\": \"Anzahl von zu verändernden Punkten, z.B.: 1\",\n  \"game.createSprite\": \"Erzeugt einen neuen LED-Sprite, der nach rechts zeigt.\",\n  \"game.createSprite|param|x\": \"horizontale Koordinate des Sprites, z.B. 2\",\n  \"game.createSprite|param|y\": \"vertikale Koordinate des Sprites, z.B. 2\",\n  \"game.currentTime\": \"Ruft die verbliebene Zeit (seit `starte Countdown`) oder die aktuelle Zeit (seit das Gerät gestartet wurde oder eine Stoppuhr aktiviert wurde) an.\",\n  \"game.gameOver\": \"Gibt über eine Animation ein Spiel wieder.\",\n  \"game.invalidSprite\": \"Ruft einen invaliden Sprite ab; wird genutzt, um Locale zu initialisieren.\",\n  \"game.isGameOver\": \"Zeigt an, ob das Spil die \\\"Game Over\\\"-Sequenz angezeigt hat.\",\n  \"game.isRunning\": \"Holt einen Wert, der anzeigt, ob das Spiel noch läuft. Gibt `falsch`aus, wenn das Spiel zu Ende ist.\",\n  \"game.level\": \"Ruft das aktuelle Level ab\",\n  \"game.levelUp\": \"Erhöht das Level und zeigt eine Nachricht an.\",\n  \"game.life\": \"Ruft das aktuelle Leben ab\",\n  \"game.removeLife\": \"Entfernt ein Leben\",\n  \"game.score\": \"Ruft den aktuellen Punktestand ab\",\n  \"game.setLife\": \"Setzt den aktuellen Wert der Leben\",\n  \"game.setScore\": \"Setzt den aktuellen Wert des Spielstands\",\n  \"game.showScore\": \"Zeigt den Spielstand auf dem Display.\",\n  \"game.startCountdown\": \"Startet einen Spiel-Countdown\",\n  \"game.startCountdown|param|ms\": \"Countdown-Dauer in Millisekunden, z.B.: 10000\",\n  \"game.startStopwatch\": \"Startet eine Stoppuhr.`aktuelle Zeit`gibt die vergangene Zeit an.\",\n  \"images\": \"Erstellung, Bearbeitung und Anzeige von LED-Bildern.\",\n  \"images.createBigImage\": \"Erstellt ein Bild mit zwei Einzelbildern.\",\n  \"images.createImage\": \"Erstellt ein Bild, das auf den LED-Bildschirm passt.\",\n  \"input\": \"Ereignisse und Daten der Sensoren\",\n  \"input.acceleration\": \"Holt den Beschleunigungswert in Milli-Erdanziehung (wenn das Board flach mit dem Display nach oben liegt, X = 0, y = 0 und Z =-1024)\",\n  \"input.buttonIsPressed\": \"Erhalte den Sie den Tastenstatus (gepresst oder nicht) für ``A`` und ``B``.\",\n  \"input.compassHeading\": \"Holt die aktuelle Kompassrichtung in Grad.\",\n  \"input.lightLevel\": \"Liest die Lichtintensität auf dem LED-Bildschirm im Bereich von ``0`` (dunkel) und `` 255`` (hell).\",\n  \"input.magneticForce\": \"Ruft den Wert der Magnetkraft in ``Mikro-Tesla`` (``µT``) ab. Diese Funktion wird im Simulator nicht unterstützt.\",\n  \"input.onButtonPressed\": \"Tue etwas, wenn eine Taste (``A``, ``B`` oder ``A + B``) gedrückt wird\",\n  \"input.onGesture\": \"Mache etwas, wenn eine Geste gemacht wird (wie den mini zu schütteln).\",\n  \"input.onLogoDown\": \"Fügt Code hinzu, der ausgeführt wird, wenn das Logo nach unten zeigt und das Board vertikal ausgerichtet ist.\",\n  \"input.onLogoUp\": \"Fügt Code hinzu, der ausgeführt wird, wenn das Logo nach oben zeigt und das Board vertikal ausgerichtet ist.\",\n  \"input.onPinPressed\": \"Mache etwas, wenn eine Pin gehalten wird.\",\n  \"input.onPinPressed|param|body\": \"Code, der ausführt wird, wenn ein Pin gehalten wird\",\n  \"input.onPinReleased\": \"Mache etwas, wenn der Pin losgelassen wird.\",\n  \"input.onPinReleased|param|body\": \"Code, der ausgeführt werden soll, wenn der Pin losgelassen wird\",\n  \"input.onScreenDown\": \"Hängt Code an, der ausgeführt wird, wenn der Bildschirm nach unten zeigt.\",\n  \"input.onScreenUp\": \"Hängt Code an, der ausgeführt wird, wenn der Bildschirm nach oben zeigt.\",\n  \"input.onShake\": \"Hängt Code an, der ausgeführt wird, wenn der mini geschüttelt wird.\",\n  \"input.pinIsPressed\": \"Ruft den Pin-Zustand (gehalten oder nicht) ab. Die Erdung muss gehalten werden, um den Stromkreis zu schließen.\",\n  \"input.rotation\": \"Die Neigung und Drehung des mini Drehung auf ``X-Achse``oder ``Y-Achse``, in Grad.\",\n  \"input.runningTime\": \"Ruft die Anzahl der Millisekunden auf, die seit dem Einschalten vergangen sind.\",\n  \"input.setAccelerometerRange\": \"Legt die Stichprobenbereich des Beschleunigungssensors in Schwerkraft fest.\",\n  \"input.setAccelerometerRange|param|range\": \"Ein Wert, der die maximale Stärke der gemessenen Beschleunigung beschreibt\",\n  \"input.temperature\": \"Ruft die aktuelle Temperatur in Grad Celsius (°C) ab.\",\n  \"led\": \"Steuerung des LED-Bildschirms.\",\n  \"led.brightness\": \"Ruft die Helligkeit des Bildschirms ab, von 0 (aus) bis 255 (volle Helligkeit).\",\n  \"led.enable\": \"Schaltet das Display an und aus\",\n  \"led.fadeIn\": \"Blendet die Bildschirmanzeige ein.\",\n  \"led.fadeOut\": \"Blendet die Bildschirmhelligkeit aus.\",\n  \"led.plot\": \"Schalte die angegebene LED mit Hilfe von X- und Y-Koordinaten ein (X ist horizontal, Y ist vertikal). (0,0) ist die obere linke Ecke.\",\n  \"led.plotAll\": \"Schaltet alle LEDs an\",\n  \"led.plotBarGraph\": \"Zeigt ein vertikales Balkendiagramm an, basierend auf dem `Wert`und dem `Hoch`-Wert. Wenn `Hoch`0 ist, wird das Diagramm automatisch angepasst.\",\n  \"led.plotBarGraph|param|high\": \"maximalen Wert. Wenn dieser 0 ist, wird der Maximalwert automatisch angepasst, z.B.: 0\",\n  \"led.plotBarGraph|param|value\": \"aktueller Wert zum Darstellen\",\n  \"led.point\": \"Ruft den An/Aus-Status einer vorgegebenen LED mittels X-/Y-Koordinaten ab. (0,0) ist oben links.\",\n  \"led.screenshot\": \"Macht einen Screenshot vom LED-Bildschirm und gibt ein Bild aus.\",\n  \"led.setBrightness\": \"Lege die Helligkeit des Bildschirms fest, von 0 (aus) bis 255 (volle Helligkeit).\",\n  \"led.setBrightness|param|value\": \"Helligkeitswert, z.B.: 255, 127, 0\",\n  \"led.setDisplayMode\": \"Legt den Anzeigemodus von Wiedergabe-LEDs zwischen Schwarz und Weiß und Graustufen fest.\",\n  \"led.setDisplayMode|param|mode\": \"TODO\",\n  \"led.stopAnimation\": \"Bricht die aktuelle Animation ab und löscht andere ausstehende Animationen.\",\n  \"led.toggle\": \"Schaltet ein bestimmtes Pixel ein\",\n  \"led.toggleAll\": \"Invertiert die aktuelle LED-Anzeige\",\n  \"led.unplot\": \"Schalte die angegebene LED mit x-und y-Koordinaten ab (X ist horizontal, y ist vertikal). (0,0) ist oben links.\",\n  \"music.beat\": \"Gibt die Dauer eines Taktes in Milli-Sekunden aus\",\n  \"music.changeTempoBy\": \"Ändere die Geschwindigkeit um den angegebenen Betrag\",\n  \"music.changeTempoBy|param|bpm\": \"Die Änderung in Schlägen pro Minute auf das Tempo, z.B.: 20\",\n  \"music.noteFrequency\": \"Ruft die Frequenz einer Note ab.\",\n  \"music.playTone\": \"Spielt einen Ton für den angegebenen Zeitraum über Pin ``P0`` ab.\",\n  \"music.playTone|param|frequency\": \"Tonhöhe des abzuspielenden Tones in Hertz (Hz)\",\n  \"music.playTone|param|ms\": \"Tondauer in Millisekunden (ms)\",\n  \"music.rest\": \"Ruht (spielt nichts) für eine bestimmte Zeit auf Pin ``P0``.\",\n  \"music.rest|param|ms\": \"Restdauer in Millisekunden (ms)\",\n  \"music.ringTone\": \"Spielt einen Ton über Pin ``P0``.\",\n  \"music.ringTone|param|frequency\": \"Tonhöhe des abzuspielenden Tones in Hertz (Hz)\",\n  \"music.setTempo\": \"Legt die Geschwindigkeit auf den angegebenen Wert fest.\",\n  \"music.setTempo|param|bpm\": \"Die neue Geschwindigkeit in Schlägen pro Minute, z.B.: 120\",\n  \"music.tempo\": \"Gibt die Geschwindigkeit in Schlägen pro Minute aus. Die Geschwindigkeit ist Schnelligkeit (Bpm = Beats pro Minute), in der Töne abgespielt werden. Je größer der Wert, desto schneller werden die Töne abgespielt.\",\n  \"pins\": \"Steuere die Stromstärke über die Pins für analoge/digitale Signale, Servos, I2C,...\",\n  \"pins.analogPitch\": \"Gibt ein Pulsweiten Modulation (PWM)-Signal über den aktuellen Pitch-Pin. Benutze `analog set pitch pin`, um den Pitch-Pin festzulegen.\",\n  \"pins.analogPitch|param|frequency\": \"TODO\",\n  \"pins.analogPitch|param|ms\": \"TODO\",\n  \"pins.analogReadPin\": \"Lese den Anschlusswert als Analog aus, d. h. als einen Wert zwischen 0 und 1023.\",\n  \"pins.analogSetPeriod\": \"Stellt die Pulsweite Modulation (PWM) des Analogausganges auf den angegebenen Wert in ** Mikrosekunden ** oder `1/1000` Millisekunden ein.\\nWenn dieser Pin nicht als einen Analogausgang (mit `analog write pin`) konfiguriert ist, hat der Vorgang keine Auswirkungen.\",\n  \"pins.analogSetPeriod|param|micros\": \"Zeit in Mikrosekunden. z.B.: 20000\",\n  \"pins.analogSetPitchPin|param|name\": \"TODO\",\n  \"pins.analogWritePin\": \"Legt den Wert des Verbinders auf analog fest. Der Wert muss zwischen 0 und 1023 liegen.\",\n  \"pins.analogWritePin|param|value\": \"Wert, der auf den Pin geschrieben werden soll, zwischen ``0`` und ``1023`` z.B.: 1023,0\",\n  \"pins.createBuffer\": \"Erstellt einen Null-initialisierten Zwischenspeicher.\",\n  \"pins.createBuffer|param|size\": \"Anzahl der Bytes im Zwischenspeicher\",\n  \"pins.digitalReadPin\": \"Lese den angegebene Pin oder Verbinder als 0 oder 1\",\n  \"pins.digitalWritePin\": \"Setzt einen Pin- oder Verbinder-Wert auf 0 oder 1.\",\n  \"pins.digitalWritePin|param|value\": \"Wert, der auf dem Pin 1 gesetzt werden soll, z.B. 0\",\n  \"pins.i2cReadBuffer\": \"Lese `Größe`bytes aus einer 7-bit I2C-Adresse.\",\n  \"pins.i2cReadNumber\": \"Lese eine Nummer aus einer 7-bit I2C-Adresse.\",\n  \"pins.i2cWriteBuffer\": \"Schreibt Bytes in eine 7-bit I2C-Adresse.\",\n  \"pins.i2cWriteNumber\": \"Schreibe eine Nummer in eine 7-bit I2C-Adresse.\",\n  \"pins.map\": \"Definiert eine Nummer von einer Auswahl zu einer anderen um. Ein Wert ``von niedrig``wird so auf ``zu niedrig``umgeändert, ein Wert ``von hoch`` zu ``zu hoch`` etc.\",\n  \"pins.map|param|fromHigh\": \"die obere Grenze des aktuellen Wertebereichs, z.B.: 1023\",\n  \"pins.map|param|fromLow\": \"die untere Grenze des aktuellen Wertebereichs\",\n  \"pins.map|param|toHigh\": \"die Obergrenze des Wertezielbereichs, z.B.: 4\",\n  \"pins.map|param|toLow\": \"die Untergrenze des Wertezielbereichs\",\n  \"pins.map|param|value\": \"Wert in Bereichen zuordnen\",\n  \"pins.onPulsed\": \"Stellt diesen Pin als einen Digitaleingang ein und generiert Ereignisse, deren Zeitstempel die Dauer darstellt, in der der Pin entweder ``hoch``oder ``niedrig``war.\",\n  \"pins.pulseDuration\": \"Ruft die Dauer des letzten Impulses in Mikrosendungen ab. Diese Funktion soll von einem `onPulsed`-Handler aufgerufen werden.\",\n  \"pins.pulseIn\": \"Gibt die Dauer eines Pulses in Mikrosekunden an\",\n  \"pins.servoSetPulse\": \"Konfiguriert diesen IO-Pin als einen analogen/PWM-Ausgang, stellt den Zeitraum auf 20 ms ein und setzt die Pulsweite fest, basieren auf dem angegeben Wert **Mikrosekunden** oder `1/1000`Millisekunden.\",\n  \"pins.servoSetPulse|param|micros\": \"Impulsdauer in Mikrosekunden, z.B.: 1500\",\n  \"pins.servoSetPulse|param|name\": \"PIN-Name\",\n  \"pins.servoWritePin\": \"Schreibt einen Wert in den Servo, der die Welle entsprechend kontroliert. Auf einem Standard-Servo wird so der Winkel der Welle (in Grad) eingestellt, sodass sich die Welle entsprechend anpasst. Auf einem kontinuierlich drehenden Servo wird dadurch die Geschwindigkeit des Servos festgelegt, wobei ``0``die volle Geschwindigkeit in eine Richtung darstellt, ``180``die volle Geschwindigkeit in die andere, und ein Wert von ``90`` einen Stillstand erzeugt.\",\n  \"pins.servoWritePin|param|value\": \"Winkel oder Rotationsbeschleunigung, z.B.: 180,90,0\",\n  \"pins.setPull\": \"Stellt die Anziehungskraft des Pins ein.\",\n  \"pins.sizeOf\": \"Ruft die Bytegröße im spezifierten Nummernformat ab.\",\n  \"pins.spiWrite\": \"Schreibe in den SPI-Slave und gebe die Antwort aus\",\n  \"pins.spiWrite|param|value\": \"Daten, die an den SPI-Slave geschickt werden sollen\",\n  \"serial\": \"Lesen und Schreiben von Daten über eine serielle Verbindung.\",\n  \"serial.delimiters\": \"Gibt die mit dem Begrenzer korrespondierende Zeichenfolge aus.\",\n  \"serial.readLine\": \"Liest eine Textzeile aus der seriellen Schnittstelle.\",\n  \"serial.readUntil\": \"Liest aus eine Textzeile aus dem seriellen Anschluss und gibt den Puffer aus, wenn die Begrenzung erreicht wurde.\",\n  \"serial.readUntil|param|delimiter\": \"Text-Begrenzung, die die Textblöcke voneinander trennt\",\n  \"serial.redirect\": \"Konfiguriert dynamisch die serielle Instanz, damit sie andere Pins als USBTX und USBRX benutzt.\",\n  \"serial.writeLine\": \"Gibt eine Zeile des Textes an die serielle\",\n  \"serial.writeNumber\": \"Gibt einen numerischen Wert an die serielle\",\n  \"serial.writeString\": \"Sendet ein Stück Text über serielle Verbindung.\",\n  \"serial.writeValue\": \"Schreibt ein ``Namen: Wert`` Wertepaar auf die serielle Schnittstelle.\",\n  \"serial.writeValue|param|name\": \"Name des Wertestreams, z.B.: x\",\n  \"serial.writeValue|param|value\": \"Schreiben\"\n}",
      "_locales/de/core-strings.json": "{\n  \"AcceleratorRange.EightG\": \"Der Bewegungssensor misst Kräfte bis 8g\",\n  \"AcceleratorRange.EightG|block\": \"8g\",\n  \"AcceleratorRange.FourG\": \"Der Bewegungssensor misst Kräfte bis 4g\",\n  \"AcceleratorRange.FourG|block\": \"4g\",\n  \"AcceleratorRange.OneG\": \"Der Bewegungssensor misst Kräfte bis 1g\",\n  \"AcceleratorRange.OneG|block\": \"1g\",\n  \"AcceleratorRange.TwoG\": \"Der Bewegungssensor misst Kräfte bis 2g\",\n  \"AcceleratorRange.TwoG|block\": \"2g\",\n  \"BaudRate.BaudRate115200|block\": \"115200\",\n  \"BaudRate.BaudRate9600|block\": \"9600\",\n  \"BeatFraction.Eighth|block\": \"1/8\",\n  \"BeatFraction.Half|block\": \"1/2\",\n  \"BeatFraction.Quarter|block\": \"1/4\",\n  \"BeatFraction.Sixteenth|block\": \"1/16\",\n  \"BeatFraction.Whole|block\": \"1\",\n  \"Button.AB|block\": \"A+B\",\n  \"Delimiters.Dollar|block\": \"$\",\n  \"Delimiters.Hash|block\": \"#\",\n  \"Delimiters.NewLine|block\": \"Neue Zeile\",\n  \"Dimension.Strength|block\": \"Stärke\",\n  \"Dimension.X|block\": \"x\",\n  \"Dimension.Y|block\": \"y\",\n  \"Dimension.Z|block\": \"z\",\n  \"Direction.Left|block\": \"links\",\n  \"Direction.Right|block\": \"rechts\",\n  \"DisplayMode.BackAndWhite|block\": \"Schwarz-Weiß\",\n  \"DisplayMode.Greyscale|block\": \"Graustufen\",\n  \"EventCreationMode.CreateAndFire\": \"Calliope mini-Event wurde initialisiert, seine Event-Handler werden unverzüglich ausgeführt (nicht geeignet für die Nutzung bei Unterbrechungen!).\",\n  \"EventCreationMode.CreateOnly\": \"Calliope mini-Event wurde initialisiert, es wird keine weitere Verarbeitung vorgenommen.\",\n  \"Gesture.EightG|block\": \"8g\",\n  \"Gesture.FreeFall\": \"Wird ausgeführt, wenn das Board fällt!\",\n  \"Gesture.FreeFall|block\": \"freier Fall\",\n  \"Gesture.LogoDown\": \"Wird ausgeführt, wenn das Logo nach unten zeigt und das Display vertikal ist.\",\n  \"Gesture.LogoDown|block\": \"Logo nach unten\",\n  \"Gesture.LogoUp\": \"Wird ausgeführt, wenn das Logo nach oben zeigt und das Display vertikal ist.\",\n  \"Gesture.LogoUp|block\": \"Logo oben\",\n  \"Gesture.ScreenDown\": \"Wird ausgeführt, wenn das Display nach oben zeigt und das Board horizontal ist.\",\n  \"Gesture.ScreenDown|block\": \"Display nach unten\",\n  \"Gesture.ScreenUp\": \"Wird ausgeführt, wenn das Display nach unten zeigt und das Board horizontal ist.\",\n  \"Gesture.ScreenUp|block\": \"Display nach oben\",\n  \"Gesture.Shake\": \"Wird erhöht, wenn geschüttelt\",\n  \"Gesture.Shake|block\": \"geschüttelt\",\n  \"Gesture.SixG\": \"Wird ausgeführt, ein 6g starker Stoß erkannt wird\",\n  \"Gesture.SixG|block\": \"6g\",\n  \"Gesture.ThreeG\": \"Wird ausgeführt, ein 3g starker Stoß erkannt wird\",\n  \"Gesture.ThreeG|block\": \"3g\",\n  \"Gesture.TiltLeft\": \"Wird ausgeführt, wenn das Display nach links zeigt\",\n  \"Gesture.TiltLeft|block\": \"nach links neigen\",\n  \"Gesture.TiltRight\": \"Wird ausgeführt, wenn das Display nach rechts zeigt\",\n  \"Gesture.TiltRight|block\": \"nach rechts neigen\",\n  \"LedSpriteProperty.Blink|block\": \"blinken\",\n  \"LedSpriteProperty.Brightness|block\": \"Helligkeit\",\n  \"LedSpriteProperty.Direction|block\": \"Richtung\",\n  \"LedSpriteProperty.X|block\": \"x\",\n  \"LedSpriteProperty.Y|block\": \"y\",\n  \"Math.randomBoolean|block\": \"wähle zufälligen Wahr- oder Falsch-Wert\",\n  \"Math|block\": \"Mathematik\",\n  \"MelodyOptions.Forever|block\": \"dauerhaft\",\n  \"Note.CSharp3|block\": \"C#3\",\n  \"Note.CSharp4|block\": \"C#4\",\n  \"Note.CSharp5|block\": \"C#5\",\n  \"Note.CSharp|block\": \"C#\",\n  \"Note.FSharp3|block\": \"F#3\",\n  \"Note.FSharp4|block\": \"F#4\",\n  \"Note.FSharp5|block\": \"F#5\",\n  \"Note.FSharp|block\": \"F#\",\n  \"Note.GSharp3|block\": \"G#3\",\n  \"Note.GSharp4|block\": \"G#4\",\n  \"Note.GSharp5|block\": \"G#5\",\n  \"Note.GSharp|block\": \"G#\",\n  \"PinPullMode.PullDown|block\": \"nach unten\",\n  \"PinPullMode.PullUp|block\": \"nach oben\",\n  \"Rotation.Pitch|block\": \"Winkel\",\n  \"Rotation.Roll|block\": \"rollen\",\n  \"String.fromCharCode|block\": \"Text aus char code %code\",\n  \"String.length|block\": \"Länge von %VALUE\",\n  \"String|block\": \"Zeichenfolge\",\n  \"basic.clearScreen|block\": \"Bildschirminhalt löschen\",\n  \"basic.forever|block\": \"dauerhaft\",\n  \"basic.pause|block\": \"pausiere (ms) %pause\",\n  \"basic.showLeds|block\": \"zeige LEDs\",\n  \"basic.showNumber|block\": \"zeige|Nummer %number\",\n  \"basic.showString|block\": \"zeige|Zeichenfolge %text\",\n  \"basic|block\": \"Grundlagen\",\n  \"control.deviceName|block\": \"Gerätename\",\n  \"control.deviceSerialNumber|block\": \"Seriennnummer\",\n  \"control.eventSourceId|block\": \"%id\",\n  \"control.eventTimestamp|block\": \"Ereigniszeitstempel\",\n  \"control.eventValueId|block\": \"%id\",\n  \"control.eventValue|block\": \"Ereigniswert\",\n  \"control.inBackground|block\": \"im Hintergrund ausführen\",\n  \"control.onEvent|block\": \"wenn Ereignis|von Quelle %src=control_event_source_id|mit Wert %value=control_event_value_id\",\n  \"control.raiseEvent|block\": \"Ereignis auslösen|von Quelle %src=control_event_source_id|mit Wert %value=control_event_value_id\",\n  \"control.reset|block\": \"zurücksetzen\",\n  \"control.waitMicros|block\": \"Warte (µs)%micros\",\n  \"control|block\": \"Steuerung\",\n  \"game.addScore|block\": \"Ändere Spielstand um|%points\",\n  \"game.createSprite|block\": \"erzeuge Sprite an Position|x: %x|y:%y\",\n  \"game.gameOver|block\": \"Spiel beendet\",\n  \"game.score|block\": \"Spielstand\",\n  \"game.startCountdown|block\": \"Countdown| starten (ms) %duration\",\n  \"game|block\": \"Spiel\",\n  \"images.createBigImage|block\": \"erstelle großes Bild\",\n  \"images.createImage|block\": \"Erstelle Bild\",\n  \"images|block\": \"Bilder\",\n  \"input.acceleration|block\": \"Beschleunigung (mg) |%NAME\",\n  \"input.buttonIsPressed|block\": \"Button|%NAME|ist gedrückt\",\n  \"input.compassHeading|block\": \"Kompassausrichtung (°)\",\n  \"input.lightLevel|block\": \"Lichtstärke\",\n  \"input.magneticForce|block\": \"Magnetkraft (µT) |%NAME\",\n  \"input.onButtonPressed|block\": \"wenn Knopf|%NAME|gedrückt\",\n  \"input.onGesture|block\": \"wenn |%NAME\",\n  \"input.onPinPressed|block\": \"wenn Pin|%NAME|gedrückt\",\n  \"input.onPinReleased|block\": \"wenn Pin %NAME|losgelassen\",\n  \"input.pinIsPressed|block\": \"Pin %NAME|ist gedrückt\",\n  \"input.rotation|block\": \"Rotation (°)|%NAME\",\n  \"input.runningTime|block\": \"Laufzeit (ms)\",\n  \"input.setAccelerometerRange|block\": \"setze Bewegungsmesser auf|%range\",\n  \"input.temperature|block\": \"Temperatur (°C)\",\n  \"input|block\": \"Eingabe\",\n  \"led.brightness|block\": \"Helligkeit\",\n  \"led.plotBarGraph|block\": \"zeichne Balkendiagramm von %value|bis %high\",\n  \"led.plot|block\": \"Zeichne|x %x|y %y\",\n  \"led.point|block\": \"Punkt|x %x|y %y\",\n  \"led.setBrightness|block\": \"Setze Helligkeit auf %value\",\n  \"led.stopAnimation|block\": \"Halte Animation an\",\n  \"led.toggle|block\": \"Schalte zwischen|x %x|y %y\",\n  \"led.unplot|block\": \"schalte Pixel|x %x|y %y aus\",\n  \"led|block\": \"LED\",\n  \"music.beat|block\": \"%fraction|Takt\",\n  \"music.changeTempoBy|block\": \"ändere die Geschwindigkeit (bpm)|%value\",\n  \"music.noteFrequency|block\": \"%note\",\n  \"music.playTone|block\": \"spiele|Note %note=device_note|für %duration=device_beat\",\n  \"music.rest|block\": \"pausiere (ms)|%duration=device_beat\",\n  \"music.ringTone|block\": \"Klingelton (Hz) |%note = Device_note\",\n  \"music.setTempo|block\": \"ändere Geschwindigkeit auf (bpm)|%value\",\n  \"music.tempo|block\": \"Geschwindkeit (bpm)\",\n  \"music|block\": \"Musik\",\n  \"pins.analogReadPin|block\": \"lese analoge Werte von|Pin %name\",\n  \"pins.analogSetPeriod|block\": \"setze Zeitraum für analogen|Pin %pin|auf (µs)%micros\",\n  \"pins.analogWritePin|block\": \"schreibe analogen|Pin %name|auf %value\",\n  \"pins.digitalReadPin|block\": \"lese digitale Werte von|Pin %name\",\n  \"pins.digitalWritePin|block\": \"schreibe digitalen Wert von|pin %name|auf %value\",\n  \"pins.map|block\": \"verteile %value|von niedrig %fromLow|von hoch %fromHigh| bis niedrig %toLow|bis hoch %toHigh\",\n  \"pins.onPulsed|block\": \"wenn|Pin %pin|gepulst %pulse\",\n  \"pins.pulseDuration|block\": \"Impulsdauer (µs)\",\n  \"pins.pulseIn|block\": \"Impuls in (µs)|Pin %name|mit %value\",\n  \"pins.servoSetPulse|block\": \"setze den Puls von Servo an|Pin %value|auf (µs) %micros\",\n  \"pins.servoWritePin|block\": \"schreibe Servo an|Pin %name|auf %value\",\n  \"pins.setPull|block\": \"setze Anziehungskraft von|Pin %pin|auf %pull\",\n  \"pins.spiWrite|block\": \"schreibe %value in SPI\",\n  \"pins|block\": \"Pins\",\n  \"serial.delimiters|block\": \"%del\",\n  \"serial.readLine|block\": \"seriell|Zeile lesen\",\n  \"serial.readUntil|block\": \"seriell|lesen bis %delimiter=serial_delimiter_conv\",\n  \"serial.redirect|block\": \"seriell|umleiten auf|TX %tx|RX %rx|mit Baudrate %rate\",\n  \"serial.writeLine|block\": \"seriell|Zeile ausgeben %text\",\n  \"serial.writeNumber|block\": \"seriell|Zahl ausgeben %value\",\n  \"serial.writeString|block\": \"seriell|Zeichenkette ausgeben %text\",\n  \"serial.writeValue|block\": \"serial|Wert ausgeben %name|= %value\",\n  \"serial|block\": \"seriell\",\n  \"{id:category}Basic\": \"Grundlagen\",\n  \"{id:category}Control\": \"Steuerung\",\n  \"{id:category}Game\": \"Spiel\",\n  \"{id:category}Images\": \"Bilder\",\n  \"{id:category}Input\": \"Eingabe\",\n  \"{id:category}Led\": \"LED\",\n  \"{id:category}Math\": \"Mathematik\",\n  \"{id:category}Music\": \"Musik\",\n  \"{id:category}Pins\": \"Pins\",\n  \"{id:category}Serial\": \"Serielle\",\n  \"{id:category}String\": \"Zeichenfolge\",\n  \"{id:category}Text\": \"Text\"\n}",
      "_locales/fr/core-jsdoc-strings.json": "{\n  \"Math.randomBoolean\": \"Génère une valeur « true » ou « false » au hasard, comme si vous lanciez une pièce de monnaie.\",\n  \"String.fromCharCode\": \"Construit une chaîne à partir du code ASCII d'un caractère donné.\",\n  \"basic\": \"Permet d’accéder aux fonctionnalités de base de la micro:bit.\",\n  \"basic.clearScreen\": \"Éteindre toutes les LEDs\",\n  \"basic.forever\": \"Répète le code indéfiniment en tâche de fond. A chaque itération, permet aux autres codes de s’exécuter.\",\n  \"basic.pause\": \"Pause pendant la durée indiquée en millisecondes\",\n  \"basic.pause|param|ms\": \"combien de temps dure une pause, par ex. : 100, 200, 500, 1000, 2000\",\n  \"basic.plotLeds\": \"Dessine une image sur l’écran de LEDs.\",\n  \"basic.plotLeds|param|leds\": \"motif de LEDs à allumer/éteindre\",\n  \"basic.showAnimation\": \"Montre une séquence de motifs LED comme une animation.\",\n  \"basic.showAnimation|param|interval\": \"temps en millisecondes entre chaque rafraîchissement\",\n  \"basic.showAnimation|param|leds\": \"motif de LEDs à allumer/éteindre\",\n  \"basic.showLeds\": \"Dessine une image sur l’écran de LEDs.\",\n  \"basic.showLeds|param|interval\": \"temps de pause en millisecondes après avoir dessiné\",\n  \"basic.showLeds|param|leds\": \"le motif de LED à allumer/éteindre\",\n  \"basic.showNumber\": \"Fait défiler un nombre à l'écran. Si le nombre rentre dans l'écran (i.e. un seul chiffre), ne défile pas.\",\n  \"basic.showNumber|param|interval\": \"vitesse de défilement ; par ex : 150, 100, 200, -100\",\n  \"basic.showString\": \"Afficher du texte à l’écran, un caractère à la fois. Si la chaîne rentre sur l’écran (c'est-à-dire une seule lettre), ne défile pas.\",\n  \"basic.showString|param|interval\": \"à quelle vitesse se déplacent les caractères ; par ex. : 150, 100, 200, -100\",\n  \"basic.showString|param|text\": \"le texte à faire défiler sur l’écran, par exemple : « Bonjour ! »\",\n  \"control.inBackground\": \"Planifie le code qui s’exécute en arrière-plan.\",\n  \"control.reset\": \"Réinitialise le micro:bit de BBC.\",\n  \"control.waitMicros\": \"Bloque la fibre courante pour le nombre de microsecondes donné\",\n  \"control.waitMicros|param|micros\": \"nombre de microsecondes à attendre. par ex. : 4\",\n  \"game\": \"Un moteur de jeu avec une unique LED\",\n  \"game.addScore\": \"Ajoute des points au score actuel\",\n  \"game.addScore|param|points\": \"nombre de points à changer, par ex. : 1\",\n  \"game.gameOver\": \"Affiche un animation de fin de jeu.\",\n  \"game.score\": \"Obtient le score actuel\",\n  \"game.setScore\": \"Définit la valeur du score actuel\",\n  \"game.startCountdown\": \"Démarre un compte à rebours de jeu\",\n  \"game.startCountdown|param|ms\": \"durée du compte à rebours en millisecondes, par ex. : 10000\",\n  \"images\": \"Création, manipulation et affichage d’images LED.\",\n  \"images.createBigImage\": \"Crée une image à partir de 2 images.\",\n  \"images.createImage\": \"Crée une image qui s’adapte aux dimensions de l’écran LED.\",\n  \"input\": \"Événements et des données provenant de capteurs\",\n  \"input.acceleration\": \"Donne la valeur de l'accélération en milli-g (quand la carte est à plat avec l'écran vers le haut, x=0, y=0 et z=-1024)\",\n  \"input.buttonIsPressed\": \"Donne l'état du bouton (appuyé ou non) pour ``A`` et ``B``.\",\n  \"input.compassHeading\": \"Obtient la direction actuelle du compas en degrés.\",\n  \"input.lightLevel\": \"Lit le niveau de lumière appliqué à l'écran LED de ``0`` (sombre) à ``255`` lumineux.\",\n  \"input.magneticForce\": \"Obtenir la valeur de la force magnétique en ``micro-Teslas`` (``µT``). Cette fonction n’est pas supportée par le simulateur.\",\n  \"input.onButtonPressed\": \"Faire quelque chose quand un bouton (``A``, ``B`` ou les deux ``A+B``) est appuyé\",\n  \"input.onGesture\": \"Faire quelque chose lorsque lorsqu’un geste est fait (par exemple secouer le micro:bit).\",\n  \"input.onPinPressed\": \"Faire quelque chose lorsque vous appuyez sur une broche.\",\n  \"input.onPinPressed|param|body\": \"code à exécuter lorsque la broche est enfoncée\",\n  \"input.onPinReleased\": \"Faire quelque chose quand une broche est relâchée.\",\n  \"input.onPinReleased|param|body\": \"le code à exécuter lorsque la broche est relâchée\",\n  \"input.pinIsPressed\": \"Donne l’état de la broche (pressée ou non). Nécessite de tenir la masse pour fermer le circuit.\",\n  \"input.runningTime\": \"Donne le nombre de millisecondes écoulées depuis la mise en route.\",\n  \"input.temperature\": \"Obtient la température en degrés Celsius (°C).\",\n  \"led\": \"Contrôle de l’écran LED.\",\n  \"led.enable\": \"Active ou désactive l’affichage\",\n  \"led.plotAll\": \"Allume toutes les LEDS\",\n  \"led.plotBarGraph|param|value\": \"valeur actuelle à tracer\",\n  \"led.setBrightness|param|value\": \"valeur de la luminosité, par ex. : 255, 127, 0\",\n  \"music.rest\": \"Repose (joue rien) pendant une durée spécifiée via broche '' P0''.\",\n  \"pins.analogPitch|param|frequency\": \"TODO\",\n  \"pins.analogPitch|param|ms\": \"TODO\",\n  \"pins.analogSetPitchPin|param|name\": \"TODO\",\n  \"serial.writeString\": \"Envoie du texte via la connexion série.\"\n}",
      "_locales/fr/core-strings.json": "{\n  \"Gesture.LogoDown\": \"Déclenché lorsque le logo est vers le bas et l’écran est vertical\",\n  \"Gesture.LogoDown|block\": \"logo vers le bas\",\n  \"Gesture.LogoUp|block\": \"logo vers le haut\",\n  \"Gesture.ScreenDown|block\": \"écran vers le bas\",\n  \"Gesture.ScreenUp|block\": \"écran vers le haut\",\n  \"Gesture.Shake|block\": \"secouer\",\n  \"Gesture.SixG|block\": \"6g\",\n  \"Gesture.TiltLeft|block\": \"incliner à gauche\",\n  \"Gesture.TiltRight|block\": \"incliner à droite\",\n  \"IconNames.Angry|block\": \"fâché\",\n  \"IconNames.Asleep|block\": \"endormi\",\n  \"IconNames.Butterfly|block\": \"papillon\",\n  \"IconNames.Chessboard|block\": \"échiquier\",\n  \"IconNames.Confused|block\": \"confus\",\n  \"IconNames.Cow|block\": \"vache\",\n  \"IconNames.Diamond|block\": \"diamant\",\n  \"IconNames.Duck|block\": \"canard\",\n  \"IconNames.Fabulous|block\": \"fabuleux\",\n  \"IconNames.Ghost|block\": \"fantôme\",\n  \"IconNames.Giraffe|block\": \"girafe\",\n  \"IconNames.Happy|block\": \"heureux\",\n  \"IconNames.Heart|block\": \"coeur\",\n  \"IconNames.House|block\": \"maison\",\n  \"IconNames.LeftTriangle|block\": \"triangle gauche\",\n  \"IconNames.Meh|block\": \"meh\",\n  \"IconNames.No|block\": \"non\",\n  \"IconNames.Pitchfork|block\": \"pitchfork\",\n  \"IconNames.QuarterNote|block\": \"note\",\n  \"IconNames.Rabbit|block\": \"lapin\",\n  \"IconNames.Rollerskate|block\": \"patins à roulette\",\n  \"IconNames.Sad|block\": \"triste\",\n  \"IconNames.Silly|block\": \"bête\",\n  \"IconNames.Skull|block\": \"crâne\",\n  \"IconNames.SmallDiamond|block\": \"petit diamant\",\n  \"IconNames.SmallHeart|block\": \"petit coeur\",\n  \"IconNames.SmallSquare|block\": \"petit carré\",\n  \"IconNames.Snake|block\": \"serpent\",\n  \"IconNames.Square|block\": \"carré\",\n  \"LedSpriteProperty.Blink|block\": \"clignotement\",\n  \"LedSpriteProperty.Brightness|block\": \"luminosité\",\n  \"Math.randomBoolean|block\": \"choisir au hasard vrai ou faux\",\n  \"Math|block\": \"Maths\",\n  \"MelodyOptions.Forever|block\": \"toujours\",\n  \"String.fromCharCode|block\": \"texte du code de charactère %code\",\n  \"String|block\": \"Texte\",\n  \"basic.clearScreen|block\": \"effacer l’écran\",\n  \"basic.forever|block\": \"toujours\",\n  \"basic.pause|block\": \"pause (ms) %pause\",\n  \"basic.showLeds|block\": \"montrer LEDs\",\n  \"basic.showNumber|block\": \"montrer|nombre %number\",\n  \"basic.showString|block\": \"afficher|texte %text\",\n  \"basic|block\": \"base\",\n  \"control.inBackground|block\": \"exécuter en arrière-plan\",\n  \"control.reset|block\": \"remise à zéro\",\n  \"control.waitMicros|block\": \"attendre (µs) %micros\",\n  \"control|block\": \"contrôle\",\n  \"game.addScore|block\": \"changer le score par|%points\",\n  \"game.gameOver|block\": \"fin du jeu\",\n  \"game.score|block\": \"score\",\n  \"game.startCountdown|block\": \"commencer compte à rebours|(ms) %duration\",\n  \"game|block\": \"jeu\",\n  \"images.createBigImage|block\": \"créer grande image\",\n  \"images.createImage|block\": \"créer image\",\n  \"images|block\": \"images\",\n  \"input.acceleration|block\": \"accélération (mg) |%NAME\",\n  \"input.buttonIsPressed|block\": \"button|%NAME|est pressé\",\n  \"input.compassHeading|block\": \"direction de la boussole (°)\",\n  \"input.lightLevel|block\": \"niveau d’intensité lumineuse\",\n  \"input.magneticForce|block\": \"force magnétique (µT) |%NAME\",\n  \"input.onButtonPressed|block\": \"lorsque le button|%NAME|est pressé\",\n  \"input.onGesture|block\": \"lorsque|%NAME\",\n  \"input.onPinPressed|block\": \"lorsque le pin %NAME|est pressé\",\n  \"input.onPinReleased|block\": \"lorsque la broche %NAME|est lachée\",\n  \"input.pinIsPressed|block\": \"broche %NAME| est pressée\",\n  \"input.rotation|block\": \"rotation (°)|%NAME\",\n  \"input.runningTime|block\": \"temps d’exécution (ms)\",\n  \"input.setAccelerometerRange|block\": \"spécifier|la gamme de l'acceleromètre %range\",\n  \"input.temperature|block\": \"température (° C)\",\n  \"input|block\": \"entrées\",\n  \"led.brightness|block\": \"luminosité\",\n  \"led.plotBarGraph|block\": \"tracer le graphe de %valeur|à %high\",\n  \"led.plot|block\": \"allumer|x %x|y %y\",\n  \"led.point|block\": \"allumée à|x %x|y %y\",\n  \"led.setBrightness|block\": \"spécifier la luminosité %value\",\n  \"led.stopAnimation|block\": \"arrêter l’animation\",\n  \"led.toggle|block\": \"activer/désactiver|x %x|y %y\",\n  \"led.unplot|block\": \"éteindre|x %x|y %y\",\n  \"led|block\": \"LED\",\n  \"music.beat|block\": \"%fraction|de mesure\",\n  \"music.changeTempoBy|block\": \"changer le tempo par (bpm) | %value\",\n  \"music.noteFrequency|block\": \"%note\",\n  \"music.playTone|block\": \"jouer|ton %note=device_note|pendant %duration=device_beat\",\n  \"music.rest|block\": \"repos (ms) |%duration=device_beat\",\n  \"music.ringTone|block\": \"buzz (Hz)|%note=device_note\",\n  \"music.setTempo|block\": \"régler le tempo à (bpm)|%valeur\",\n  \"music.tempo|block\": \"tempo (bpm)\",\n  \"music|block\": \"musique\",\n  \"pins.analogReadPin|block\": \"lire|la broche analogique %name\",\n  \"pins.digitalReadPin|block\": \"lire en numérique|broche %name\",\n  \"pins.digitalWritePin|block\": \"écrire en numérique|la broche %name|à %value\",\n  \"pins.onPulsed|block\": \"lorsque|la broche %pin|est pulsée %pulse\",\n  \"pins.pulseDuration|block\": \"durée de l’impulsion (µs)\",\n  \"pins.servoWritePin|block\": \"servo écrire|broche %name|à %value\",\n  \"pins.spiWrite|block\": \"spi écrire %value\",\n  \"pins|block\": \"broches\",\n  \"serial.readLine|block\": \"série|lire ligne\",\n  \"serial.readUntil|block\": \"série|lire jusque %delimiter=serial_delimiter_conv\",\n  \"serial.redirect|block\": \"série|rediriger vers|TX %tx|RX %rx|au débit en baudes %rate\",\n  \"serial.writeLine|block\": \"série|écrire ligne %text\",\n  \"serial.writeNumber|block\": \"série|écrire nombre %value\",\n  \"serial.writeString|block\": \"série|écrire texte %text\",\n  \"serial.writeValue|block\": \"série|écrire valeur %name|= %valeur\",\n  \"serial|block\": \"Communication Série\",\n  \"{id:category}Basic\": \"Basique\",\n  \"{id:category}Control\": \"Contrôle\",\n  \"{id:category}Game\": \"Jeu\",\n  \"{id:category}Images\": \"Images\",\n  \"{id:category}Input\": \"Entrées\",\n  \"{id:category}Led\": \"LED\",\n  \"{id:category}Math\": \"Maths\",\n  \"{id:category}Music\": \"Musique\",\n  \"{id:category}Pins\": \"Broches\",\n  \"{id:category}Serial\": \"Communication Série\",\n  \"{id:category}String\": \"Texte\"\n}",
      "_locales/ja/core-jsdoc-strings.json": "{\n  \"Math.randomBoolean\": \"「真」か「偽」をランダムに生成します。\",\n  \"basic.clearScreen\": \"すべてのLEDをオフにします。\",\n  \"basic.forever\": \"ずっとコードをバックグラウンドで繰り返し実行します。\",\n  \"basic.pause\": \"ミリ秒で指定された時間、一時停止します。\",\n  \"basic.plotLeds\": \"LED 画面にイメージを描画します。\",\n  \"basic.showIcon\": \"選択されたアイコンを、LED画面に表示します。\",\n  \"basic.showLeds\": \"LED 画面にイメージを描画します。\",\n  \"basic.showNumber\": \"画面上のに数字をスクロールさせます。数が1桁で、画面上に収まる場合、スクロールしません。\",\n  \"basic.showString\": \"一度に1文字ずつ、テキストを画面に表示します。1文字だけの場合は、スクロールしません。\",\n  \"input.acceleration\": \"加速度値を取得します。（スクリーンを上に向けて置いたとき、xは0、yも0、zは-1024です）\",\n  \"input.buttonIsPressed\": \"``A`` か ``B`` のボタンが押されているかを取得します。\",\n  \"input.compassHeading\": \"現在の、コンパスの値を取得します。\",\n  \"input.lightLevel\": \"LEDスクリーンに当たる光の明るさを 0 (暗い) から 255 (明るい)の範囲で取得します。\",\n  \"input.onButtonPressed\": \"ボタン (``A``, ``B`` or both ``A+B``) が押されたときに実行されます。\",\n  \"input.onGesture\": \"ジェスチャ（例えば、ゆさぶる）が行われたときに実行します。\",\n  \"input.onPinPressed\": \"ピンが押されたときに実行されます。\",\n  \"input.onPinReleased\": \"ピンがタッチされなくなったときに実行されます。\",\n  \"input.pinIsPressed\": \"ピンがタッチされているかの状態を取得します。状態を取得するためには、グラウンドにつながっている必要があります。\",\n  \"input.rotation\": \"デバイスの、ピッチかロールを度数で取得します。\",\n  \"input.runningTime\": \"電源が入ってから経過したミリ秒数を取得します。\",\n  \"input.temperature\": \"摂氏で、温度を取得します。\",\n  \"led.brightness\": \"画面の明るさを 0 (オフ) 255 (フルに明るい)の範囲で取得します。\",\n  \"led.enable\": \"画面を表示、または非表示にします。\",\n  \"led.plot\": \"X、Y座標で指定したLEDを点灯します。(0, 0)が左上です。\",\n  \"led.point\": \"X、Y座標で指定されたLEDの、ON/OFFの状態を取得します。(0,0)が左上です。\",\n  \"led.setBrightness\": \"画面の明るさを 0 (オフ) 255 (フルに明るい)の範囲で設定します。\",\n  \"led.stopAnimation\": \"現在のアニメーションをキャンセルし、保留中のアニメーションもクリアします。\",\n  \"led.toggle\": \"指定された場所のLEDの点滅を切り替えます。\",\n  \"led.unplot\": \"X、Y座標で指定された場所のLEDを消灯します。(0, 0) は左上です。\",\n  \"music.beat\": \"拍の長さをミリ秒で返します\",\n  \"music.changeTempoBy\": \"テンポを指定した数だけ増減します。\",\n  \"music.playTone\": \"指定された長さの間、``P0``から音を鳴らします。\",\n  \"music.rest\": \"``P0`` から、指定された時間だけ音を鳴らさない様にします。\",\n  \"music.rest|param|ms\": \"残り時間(ミリ秒)\",\n  \"music.ringTone\": \"ピン``P0`` から音をを再生します。\",\n  \"music.setTempo\": \"テンポを設定します\",\n  \"music.tempo\": \"現在のテンポを、bpm (1分間あたりの拍の数)で返します。テンポの値が大きくなると、より早く音楽が再生されます。\",\n  \"serial.readLine\": \"シリアルポートからテキストを読み取ります。\"\n}",
      "_locales/ja/core-strings.json": "{\n  \"AcceleratorRange.EightG\": \"8Gまでの加速度を測ります。\",\n  \"AcceleratorRange.EightG|block\": \"8G\",\n  \"AcceleratorRange.FourG\": \"4Gまでの加速度を測ります。\",\n  \"AcceleratorRange.FourG|block\": \"4G\",\n  \"AcceleratorRange.OneG\": \"1Gまでの加速度を測ります。\",\n  \"AcceleratorRange.OneG|block\": \"1G\",\n  \"AcceleratorRange.TwoG\": \"2Gまでの加速度を測ります。\",\n  \"AcceleratorRange.TwoG|block\": \"2G\",\n  \"AnalogPin.P11|block\": \"P11（書き込みのみ）\",\n  \"AnalogPin.P12|block\": \"P12（書き込みのみ）\",\n  \"AnalogPin.P13|block\": \"P13（書き込みのみ）\",\n  \"AnalogPin.P14|block\": \"P14（書き込みのみ）\",\n  \"AnalogPin.P15|block\": \"P15（書き込みのみ）\",\n  \"AnalogPin.P16|block\": \"P16（書き込みのみ）\",\n  \"AnalogPin.P19|block\": \"P19（書き込みのみ）\",\n  \"AnalogPin.P20|block\": \"P20（書き込みのみ）\",\n  \"AnalogPin.P5|block\": \"P5（書き込みのみ）\",\n  \"AnalogPin.P6|block\": \"P6（書き込みのみ）\",\n  \"AnalogPin.P7|block\": \"P7（書き込みのみ）\",\n  \"AnalogPin.P8|block\": \"P8（書き込みのみ）\",\n  \"AnalogPin.P9|block\": \"P9（書き込みのみ）\",\n  \"BaudRate.BaudRate115200|block\": \"115200\",\n  \"BaudRate.BaudRate9600|block\": \"9600\",\n  \"BeatFraction.Breve|block\": \"4\",\n  \"BeatFraction.Double|block\": \"2\",\n  \"BeatFraction.Eighth|block\": \"1/8\",\n  \"BeatFraction.Half|block\": \"1/2\",\n  \"BeatFraction.Quarter|block\": \"1/4\",\n  \"BeatFraction.Sixteenth|block\": \"1/16\",\n  \"BeatFraction.Whole|block\": \"1\",\n  \"Button.AB|block\": \"A+B\",\n  \"Delimiters.Dollar|block\": \"$\",\n  \"Delimiters.Hash|block\": \"#\",\n  \"Delimiters.NewLine|block\": \"改行\",\n  \"Dimension.Strength|block\": \"絶対値\",\n  \"Dimension.X|block\": \"X\",\n  \"Dimension.Y|block\": \"Y\",\n  \"Dimension.Z|block\": \"Z\",\n  \"Direction.Left|block\": \"左\",\n  \"Direction.Right|block\": \"右\",\n  \"DisplayMode.BackAndWhite|block\": \"白黒\",\n  \"DisplayMode.Greyscale|block\": \"グレースケール\",\n  \"Gesture.EightG\": \"8Gの衝撃があったときに発生します。\",\n  \"Gesture.EightG|block\": \"8G\",\n  \"Gesture.FreeFall\": \"ボードを落としたときに発生します。\",\n  \"Gesture.FreeFall|block\": \"落とした\",\n  \"Gesture.LogoDown\": \"画面が垂直で、ロゴの位置が下になったときに発生します。\",\n  \"Gesture.LogoDown|block\": \"ロゴが下になった\",\n  \"Gesture.LogoUp\": \"画面が垂直で、ロゴの位置が上になったときに発生します。\",\n  \"Gesture.LogoUp|block\": \"ロゴが上になった\",\n  \"Gesture.ScreenDown\": \"ボードが水平で、画面が下向きになったときに発生します。\",\n  \"Gesture.ScreenDown|block\": \"画面が下になった\",\n  \"Gesture.ScreenUp\": \"ボードが水平で、画面が上向きになったときに発生します。\",\n  \"Gesture.ScreenUp|block\": \"画面が上になった\",\n  \"Gesture.Shake\": \"ボードがゆさぶられたときに発生します。\",\n  \"Gesture.Shake|block\": \"ゆさぶられた\",\n  \"Gesture.SixG\": \"6Gの衝撃があったときに発生します。\",\n  \"Gesture.SixG|block\": \"6G\",\n  \"Gesture.ThreeG\": \"3Gの衝撃があったときに発生します。\",\n  \"Gesture.ThreeG|block\": \"3G\",\n  \"Gesture.TiltLeft\": \"画面を左に傾けたときに発生します。\",\n  \"Gesture.TiltLeft|block\": \"左に傾けた\",\n  \"Gesture.TiltRight\": \"画面を右に傾けたときに発生します。\",\n  \"Gesture.TiltRight|block\": \"右に傾けた\",\n  \"IconNames.Angry|block\": \"おこり顔\",\n  \"IconNames.Asleep|block\": \"ねてる顔\",\n  \"IconNames.Butterfly|block\": \"ちょうちょ\",\n  \"IconNames.Chessboard|block\": \"チェス盤\",\n  \"IconNames.Confused|block\": \"こまり顔\",\n  \"IconNames.Cow|block\": \"うし\",\n  \"IconNames.Diamond|block\": \"ダイアモンド\",\n  \"IconNames.Duck|block\": \"あひる\",\n  \"IconNames.EigthNote|block\": \"8分音符\",\n  \"IconNames.Ghost|block\": \"おばけ\",\n  \"IconNames.Giraffe|block\": \"きりん\",\n  \"IconNames.Happy|block\": \"うれしい顔\",\n  \"IconNames.Heart|block\": \"ハート\",\n  \"IconNames.House|block\": \"家\",\n  \"IconNames.Pitchfork|block\": \"くまで\",\n  \"IconNames.QuarterNote|block\": \"4分音符\",\n  \"IconNames.Rabbit|block\": \"うさぎ\",\n  \"IconNames.Rollerskate|block\": \"ローラースケート\",\n  \"IconNames.Sad|block\": \"かなしい顔\",\n  \"IconNames.Silly|block\": \"へん顔\",\n  \"IconNames.Skull|block\": \"がいこつ\",\n  \"IconNames.SmallDiamond|block\": \"小さいダイアモンド\",\n  \"IconNames.SmallHeart|block\": \"小さいハート\",\n  \"IconNames.SmallSquare|block\": \"小さいしかく\",\n  \"IconNames.Snake|block\": \"へび\",\n  \"IconNames.Square|block\": \"しかく\",\n  \"IconNames.Surprised|block\": \"びっくり顔\",\n  \"IconNames.TShirt|block\": \"Tシャツ\",\n  \"IconNames.Target|block\": \"まと\",\n  \"IconNames.Tortoise|block\": \"かめ\",\n  \"IconNames.Triangle|block\": \"さんかく\",\n  \"IconNames.Umbrella|block\": \"かさ\",\n  \"LedSpriteProperty.Blink|block\": \"点滅\",\n  \"LedSpriteProperty.Brightness|block\": \"明るさ\",\n  \"LedSpriteProperty.Direction|block\": \"方向\",\n  \"LedSpriteProperty.X|block\": \"X\",\n  \"LedSpriteProperty.Y|block\": \"Y\",\n  \"Math.randomBoolean|block\": \"真または偽をランダムに選ぶ\",\n  \"Math|block\": \"計算\",\n  \"MelodyOptions.Forever|block\": \"ずっと\",\n  \"Note.CSharp3|block\": \"C#3\",\n  \"Note.CSharp4|block\": \"C#4\",\n  \"Note.CSharp5|block\": \"C#5\",\n  \"Note.CSharp|block\": \"C#\",\n  \"Note.FSharp3|block\": \"F#3\",\n  \"Note.FSharp4|block\": \"F#4\",\n  \"Note.FSharp5|block\": \"F#5\",\n  \"Note.FSharp|block\": \"F#\",\n  \"Note.GSharp3|block\": \"G#3\",\n  \"Note.GSharp4|block\": \"G#4\",\n  \"Note.GSharp5|block\": \"G#5\",\n  \"Note.GSharp|block\": \"G#\",\n  \"PinPullMode.PullDown|block\": \"プルダウン\",\n  \"PinPullMode.PullUp|block\": \"プルアップ\",\n  \"PulseValue.High|block\": \"正パルス\",\n  \"PulseValue.Low|block\": \"負パルス\",\n  \"Rotation.Pitch|block\": \"ピッチ\",\n  \"Rotation.Roll|block\": \"ロール\",\n  \"String.fromCharCode|block\": \"文字コード %code|の文字\",\n  \"basic.clearScreen|block\": \"表示を消す\",\n  \"basic.forever|block\": \"ずっと\",\n  \"basic.pause|block\": \"一時停止（ミリ秒） %pause\",\n  \"basic.showIcon|block\": \"アイコン %i を表示\",\n  \"basic.showLeds|block\": \"LEDに表示\",\n  \"basic.showNumber|block\": \"数を表示|%number\",\n  \"basic.showString|block\": \"文字列を表示|%text\",\n  \"basic|block\": \"基本\",\n  \"control.inBackground|block\": \"バックグラウンドで実行する\",\n  \"control.reset|block\": \"リセット\",\n  \"control.waitMicros|block\": \"ひと休み（マイクロ秒） %micros\",\n  \"control|block\": \"制御\",\n  \"game.gameOver|block\": \"ゲームオーバー\",\n  \"game|block\": \"ゲーム\",\n  \"images.createBigImage|block\": \"大きな画像を作成\",\n  \"images.createImage|block\": \"画像を作成\",\n  \"images|block\": \"画像\",\n  \"input.acceleration|block\": \"加速度（ミリG）|%NAME\",\n  \"input.buttonIsPressed|block\": \"ボタン|%NAME|が押されている\",\n  \"input.compassHeading|block\": \"方角（°）\",\n  \"input.lightLevel|block\": \"明るさ\",\n  \"input.magneticForce|block\": \"磁力（µT）|%NAME\",\n  \"input.onButtonPressed|block\": \"ボタン|%NAME|が押されたとき\",\n  \"input.onGesture|block\": \"%NAME|とき\",\n  \"input.onPinPressed|block\": \"端子 %name|がタッチされたとき\",\n  \"input.onPinReleased|block\": \"端子 %NAME|がタッチされなくなったとき\",\n  \"input.pinIsPressed|block\": \"端子 %NAME|がタッチされている\",\n  \"input.rotation|block\": \"傾斜（°）|%NAME\",\n  \"input.runningTime|block\": \"稼働時間（ミリ秒）\",\n  \"input.setAccelerometerRange|block\": \"加速度センサの計測範囲を設定する %range\",\n  \"input.temperature|block\": \"温度（℃）\",\n  \"led.brightness|block\": \"明るさ\",\n  \"led.enable|block\": \"表示をオンまたはオフにする %on\",\n  \"led.plot|block\": \"点灯|x %x|y %y\",\n  \"led.point|block\": \"点灯しているか|x %x|y %y\",\n  \"led.setBrightness|block\": \"明るさを設定する %value\",\n  \"led.stopAnimation|block\": \"アニメーションを停止\",\n  \"led.toggle|block\": \"反転|x %x|y %y\",\n  \"led.unplot|block\": \"消灯|x %x|y %y\",\n  \"led|block\": \"LED\",\n  \"music.beat|block\": \"%fraction|拍\",\n  \"music.changeTempoBy|block\": \"テンポを増減する（bpm）|%value\",\n  \"music.playTone|block\": \"音 %note=device_note|を %duration=device_beat|拍の間鳴らす\",\n  \"music.rest|block\": \"休符（ミリ秒）|%duration=device_beat\",\n  \"music.ringTone|block\": \"音を鳴らす（Hz）|%note=device_note\",\n  \"music.setTempo|block\": \"テンポを設定する（bpm）|%value\",\n  \"music.tempo|block\": \"テンポ（bpm）\",\n  \"music|block\": \"音楽\",\n  \"{id:category}Basic\": \"基本\",\n  \"{id:category}Control\": \"制御\",\n  \"{id:category}Game\": \"ゲーム\",\n  \"{id:category}Images\": \"画像\",\n  \"{id:category}Input\": \"入力\",\n  \"{id:category}Led\": \"LED\",\n  \"{id:category}Math\": \"計算\",\n  \"{id:category}Music\": \"音楽\",\n  \"{id:category}Pins\": \"入出力端子\",\n  \"{id:category}Serial\": \"シリアル通信\"\n}",
      "_locales/nl/core-jsdoc-strings.json": "{\n  \"Math.randomBoolean\": \"Genereert willekeurig een 'waar' of 'onwaar' waarde, net zoals kop of munt.\",\n  \"String.fromCharCode\": \"Maak een tekst-string van de ASCII karaktercode.\",\n  \"basic\": \"Geeft toegang tot de micro:bit basisfunctionaliteit.\",\n  \"basic.clearScreen\": \"Schakel alle LED's uit\",\n  \"basic.forever\": \"Herhaalt de code voor altijd op de achtergrond.\",\n  \"basic.pause\": \"Wacht de opgegeven tijd in milliseconden\",\n  \"basic.pause|param|ms\": \"hoe lang te wachten, bijv: 100, 200, 500, 1000, 2000\",\n  \"basic.plotLeds\": \"Tekent een afbeelding op het LED-scherm.\",\n  \"basic.plotLeds|param|leds\": \"patroon van de LED's die moeten worden in/uitgeschakeld\",\n  \"basic.showAnimation\": \"Toont een reeks van LED-schermen als een animatie.\",\n  \"basic.showAnimation|param|interval\": \"tijd in milliseconden tussen tussen het maken van iedere afbeelding\",\n  \"basic.showAnimation|param|leds\": \"patroon van de LED's die moeten worden in/uitgeschakeld\",\n  \"basic.showIcon\": \"Tekent het geselecteerde icoon op het LED scherm\",\n  \"basic.showLeds\": \"Tekent een afbeelding op het LED-scherm.\",\n  \"basic.showLeds|param|interval\": \"tijd in milliseconden om te pauzeren na de afbeelding\",\n  \"basic.showLeds|param|leds\": \"het patroon van de LED's die moeten worden in- of uitgeschakeld\",\n  \"basic.showNumber\": \"Scroll een getal op het scherm. Als het getal op het scherm past (een enkel cijfer), niet scrollen.\",\n  \"basic.showNumber|param|interval\": \"snelheid van scrollen; bijvoorbeeld: 150, 100, 200, -100\",\n  \"basic.showString\": \"Toon tekst op het scherm, één karakter per keer. Als de tekst-string op het scherm past (één karakter), niet scrollen.\",\n  \"basic.showString|param|interval\": \"hoe snel karakters verschuiven; Bv: 150, 100, 200,-100\",\n  \"basic.showString|param|text\": \"de tekst die op het scherm moet scrollen, bijvoorbeeld: \\\"Hallo!\\\"\",\n  \"control\": \"Runtime en gebeurtenis utilities.\",\n  \"control.inBackground\": \"Plant code die op de achtergrond moet worden uitgevoerd.\",\n  \"control.reset\": \"Voert een reset uit van de BBC micro: bit.\",\n  \"control.waitMicros\": \"Blokkeert de huidige vezel voor het aantal aangegeven microseconden\",\n  \"control.waitMicros|param|micros\": \"het aantal micro-seconden te wachten. bv.: 4\",\n  \"game\": \"Een sprite game-engine met een enkele LED\",\n  \"game.addLife|param|lives\": \"TE DOEN\",\n  \"game.addScore\": \"Voegt punten toe aan de huidige score\",\n  \"game.addScore|param|points\": \"hoeveelheid punten te wijzigen, bijvoorbeeld: 1\",\n  \"game.gameOver\": \"Een spel weergegeven over animatie.\",\n  \"game.removeLife|param|life\": \"TE DOEN\",\n  \"game.score\": \"Leest de huidige score\",\n  \"game.setLife|param|value\": \"TE DOEN\",\n  \"game.setScore\": \"Hiermee stelt u de huidige waarde van de score in\",\n  \"game.setScore|param|value\": \"nieuwe score waarde.\",\n  \"game.startCountdown\": \"Start een spel countdown timer\",\n  \"game.startCountdown|param|ms\": \"aftel duur in milliseconden, bijv: 10000\",\n  \"images\": \"Creatie, manipulatie en LED afbeeldingen weer te geven.\",\n  \"images.createBigImage\": \"Hiermee maakt u een afbeelding met 2 beelden.\",\n  \"images.createImage\": \"Hiermee maakt u een afbeelding die past op het LED-scherm.\",\n  \"input\": \"Gebeurtenissen en gegevens van sensoren\",\n  \"input.acceleration\": \"Bepaal de versnelling in milli-Gs (als het bord plat ligt met het scherm omhoog, x=0, y=0 and z=-1024)\",\n  \"input.acceleration|param|dimension\": \"TE DOEN\",\n  \"input.buttonIsPressed\": \"Lees de status van de knop (ingedrukt of niet) voor '' A'' en '' B''.\",\n  \"input.buttonIsPressed|param|button\": \"de knop om uit te vragen, bijvoorbeeld Button.A\",\n  \"input.compassHeading\": \"Lees de huidige kompasrichting in graden.\",\n  \"input.lightLevel\": \"Leest het lichtniveau toegepast op het LED-scherm in een bereik van ``0`` (donker) tot ``255`` licht.\",\n  \"input.magneticForce\": \"Haal de magnetische kracht op in ``micro-Teslas`` (``µT``). Deze functie wordt niet ondersteund in de simulator.\",\n  \"input.magneticForce|param|dimension\": \"TE DOEN\",\n  \"input.onButtonPressed\": \"Doe iets wanneer een knop (``A``, ``B`` of beide ``A+B``) worden ingedrukt\",\n  \"input.onButtonPressed|param|body\": \"code om uit te voeren wanneer een gebeurtenis wordt opgeroepen\",\n  \"input.onButtonPressed|param|button\": \"de knop die ingedrukt moet worden\",\n  \"input.onGesture\": \"Doe iets wanneer een gebaar wordt uitgevoerd (zoals het schudden van de micro:bit).\",\n  \"input.onGesture|param|body\": \"code om uit te voeren wanneer de beweging is gemaakt\",\n  \"input.onGesture|param|gesture\": \"het soort gebaar om te volgen, bijv: Gesture.Shake\",\n  \"input.onLogoDown\": \"Voegt code toe die uitgevoerd wordt wanneer het logo naar beneden is gericht en het bord is verticaal.\",\n  \"input.onLogoDown|param|body\": \"TE DOEN\",\n  \"input.onLogoUp\": \"Voegt code toe die uitgevoerd wordt wanneer het logo naar omhoog is gericht en het bord is verticaal.\",\n  \"input.onLogoUp|param|body\": \"TE DOEN\",\n  \"input.onPinPressed\": \"Doe iets wanneer een pin wordt aangeraakt.\",\n  \"input.onPinPressed|param|body\": \"de code om uit te voeren wanneer een pin wordt aangeraakt\",\n  \"input.onPinPressed|param|name\": \"de code die moet worden aangeraakt, bijv: TouchPin.P0\",\n  \"input.onPinReleased\": \"Doe iets wanneer een pin wordt gedeactiveerd.\",\n  \"input.onPinReleased|param|body\": \"de code om uit te voeren wanneer de pin wordt vrijgegeven\",\n  \"input.onPinReleased|param|name\": \"de pin die moet worden vrijgegeven\",\n  \"input.onScreenDown\": \"Voegt code to om uit te voeren wanneer het scherm omlaag is gericht.\",\n  \"input.onScreenDown|param|body\": \"TE DOEN\",\n  \"input.onScreenUp\": \"Voegt code toe die uitgevoerd wordt wanneer het scherm omhoog is gericht.\",\n  \"input.onScreenUp|param|body\": \"TE DOEN\",\n  \"input.onShake\": \"Voegt code toe die uitgevoerd wordt wanneer het apparaat wordt geschud.\",\n  \"input.onShake|param|body\": \"TE DOEN\",\n  \"input.pinIsPressed\": \"Bepaal de pin status (aangeraakt of niet). Het is nodig om de grond aan te raken om het circuit te sluiten.\",\n  \"input.pinIsPressed|param|name\": \"pin die gebruikt wordt om de aanraking te bepalen, bijv: TouchPin.P0\",\n  \"input.rotation\": \"De kanteling of helling van het apparaat, draaiing om de x-as, y-as, in graden.\",\n  \"input.rotation|param|kind\": \"TE DOEN\",\n  \"input.runningTime\": \"Bepaalt het aantal milliseconden die verlopen zijn sinds opstarten.\",\n  \"input.setAccelerometerRange\": \"Stelt het versnellingsmeter bereik in in zwaartekracht-eenheden.\",\n  \"input.setAccelerometerRange|param|range\": \"de waarde die de maximale kracht van de versnelling instelt\",\n  \"input.temperature\": \"Bepaalt de temperatuur in graden celcius (°C).\",\n  \"led\": \"Controle van het LED-scherm.\",\n  \"led.brightness\": \"Bepaalt de scherm helderheid tussen 0 (uit) tot 255 (volledig licht).\",\n  \"led.enable\": \"Schakelt het display aan of uit\",\n  \"led.fadeIn\": \"Laat het scherm lichter worden.\",\n  \"led.fadeIn|param|ms\": \"TE DOEN\",\n  \"led.fadeOut\": \"Laat het scherm donkerder worden.\",\n  \"led.fadeOut|param|ms\": \"TE DOEN\",\n  \"led.plot\": \"Zet de opgegeven LED aan met behulp van x, y-coördinaten (x is horizontaal, y is verticaal). (0,0) is van de linker bovenhoek.\",\n  \"led.plotAll\": \"Zet alle LEDS aan\",\n  \"led.plotBarGraph\": \"Wordt een verticale balk grafiek op basis van de 'waarde' en de 'hoge' waarde weergegeven.\\nAls 'hoog' is 0, de grafiek wordt automatisch aangepast.\",\n  \"led.plotBarGraph|param|high\": \"maximumwaarde. Als dit 0 is wordt de maximale waarde automatisch aangepast, bijv: 0\",\n  \"led.plotBarGraph|param|value\": \"de waarde om te tekenen\",\n  \"led.plot|param|x\": \"TE DOEN\",\n  \"led.plot|param|y\": \"TE DOEN\",\n  \"led.point\": \"Bepaal of een bepaalde LED aan staat met behulp van x, y-coördinaten. (0,0) is van de linker bovenhoek.\",\n  \"led.point|param|x\": \"TE DOEN\",\n  \"led.point|param|y\": \"TE DOEN\",\n  \"led.screenshot\": \"Neemt van een screenshot van het LED-scherm en geeft een afbeelding.\",\n  \"led.setBrightness\": \"Stel de schermhelderheid in van 0 (uit) tot 255 (volledig licht).\",\n  \"led.setBrightness|param|value\": \"de helderheid waarde, bijv: 255, 127, 0\",\n  \"led.setDisplayMode\": \"Hiermee stelt u de weergavemodus tussen zwart-wit en grijstinten voor de weergave van LEDs.\",\n  \"led.stopAnimation\": \"Dit annuleert de huidige animatie en wist de andere animaties in de wachtrij.\",\n  \"led.toggle\": \"Schakelt een bepaalde pixel\",\n  \"led.toggle|param|x\": \"TE DOEN\",\n  \"led.toggle|param|y\": \"TE DOEN\",\n  \"led.unplot\": \"Uitschakelen van de opgegeven LED met behulp van x, y-coördinaten (x horizontaal is, is y verticale). (0,0) is van de linker bovenhoek.\",\n  \"led.unplot|param|x\": \"TE DOEN\",\n  \"led.unplot|param|y\": \"TE DOEN\",\n  \"music.beat\": \"Berekent de duur van een beat in milli-seconden\",\n  \"music.beginMelody|param|options\": \"melodie opties, eenmalig / voor altijd, in de voorgrond / achtergrond\",\n  \"music.builtInMelody\": \"Haalt de melodie rij op van een ingebouwde melodie.\",\n  \"music.changeTempoBy\": \"Verandert het tempo met het opgegeven aantal\",\n  \"music.changeTempoBy|param|bpm\": \"De verandering in beats per minuut van het tempo, bijv: 20\",\n  \"music.noteFrequency\": \"Bepaalt de frequentie van een noot.\",\n  \"music.noteFrequency|param|name\": \"de naam van de noot\",\n  \"music.playTone\": \"Speelt een toon via pin ''P0'' voor de opgegeven duur.\",\n  \"music.playTone|param|frequency\": \"toonhoogte van de toon om te spelen in Hertz (Hz)\",\n  \"music.playTone|param|ms\": \"Toon duur in milliseconden (ms)\",\n  \"music.rest\": \"Rust (speelt niets) gedurende een bepaalde tijd via pin ''P0''.\",\n  \"music.rest|param|ms\": \"duur van de rust in milliseconden (ms)\",\n  \"music.ringTone\": \"Speelt een toon via pin ''P0''.\",\n  \"music.ringTone|param|frequency\": \"toonhoogte van de toon om te spelen in Hertz (Hz)\",\n  \"music.setTempo\": \"Hiermee stelt u het tempo in op het opgegeven aantal\",\n  \"music.setTempo|param|bpm\": \"Het nieuwe tempo in beats per minuut, bijv: 120\",\n  \"music.tempo\": \"Geeft het tempo in beats per minuut. Tempo is de snelheid (bpm = beats per minuut) waarop noten worden afgespeeld. Hoe hoger de waarde in tempo, hoe sneller de noten.\",\n  \"pins.analogPitch|param|frequency\": \"modulatiefrequentie in Hertz.\",\n  \"pins.analogPitch|param|ms\": \"duur van de toonhoogte in milli-seconden.\",\n  \"pins.analogReadPin\": \"Lees de waarde analog uit als een getal tussen 0 en 1023.\",\n  \"pins.analogSetPeriod\": \"Hiermee configureert u de analoge uitgang voor het gebruik van pulsbreedte-modulatie (PWM) met een opgegeven waarde in ** microseconden ** oftewel ' 1/1000' milli-seconde.\\nAls deze pin niet is geconfigureerd als een analoge uitgang (met behulp van de 'analoge write pin'), heeft deze bewerking geen effect.\",\n  \"pins.analogSetPeriod|param|micros\": \"periode in micro seconden. BV: 20000\",\n  \"pins.digitalReadPin\": \"Lees de opgegeven pin of verbinding in als 0 of 1\",\n  \"pins.digitalWritePin\": \"Stel een pin of verbinding in op waarde 0 of 1.\",\n  \"pins.digitalWritePin|param|value\": \"waarde die wordt ingesteld op de pin, bijv: 0\",\n  \"pins.i2cWriteNumber\": \"Een nummer naar een 7-bits I2C adres schrijven.\",\n  \"pins.map|param|fromHigh\": \"de bovenste afhankelijk van de huidige waardebereik, bijv: 1023\",\n  \"pins.map|param|fromLow\": \"de ondergrens van het huidige bereik van de waarde\",\n  \"pins.map|param|toHigh\": \"de bovengrens van het huidige bereik van de waarde, bv: 4\",\n  \"pins.map|param|toLow\": \"de ondergrens van het huidige bereik van de waarde\",\n  \"pins.map|param|value\": \"waarde in bereiken toewijzen\",\n  \"pins.onPulsed|param|name\": \"digitale pin om bij te registreren, bijv: DigitalPin.P0\",\n  \"pins.onPulsed|param|pulse\": \"de waarde van de puls, bijv: PulseValue.High\",\n  \"pins.pulseDuration\": \"Deze eigenschap haalt de duur van de laatste puls in micro-seconden. Deze functie moet worden aangeroepen vanuit een '' onPulsed''-handler.\",\n  \"pins.pulseIn|param|name\": \"de pin die de puls meet, bijv: DigitalePin.P0\",\n  \"pins.pulseIn|param|value\": \"de waarde van de puls, bijv: PulseValue.High\",\n  \"pins.servoSetPulse|param|name\": \"PIN naam\",\n  \"pins.servoWritePin\": \"Schrijft een waarde naar de servo, dienovereenkomstig controleren van de schacht. Op een standaard servo, zal dit de hoek van de schacht (in graden), de schacht naar dat afdrukstand instellen. Op een continue rotatie servo, zal dit de snelheid van de servo (met '' 0'' wordt volledig-snelheid in één richting, '' 180'' wordt volledige snelheid in de andere, en een waarde in de buurt van '' 90'' wordt geen beweging) instellen.\",\n  \"pins.servoWritePin|param|value\": \"hoek of rotatie snelheid, bijv: 180, 90, 0\",\n  \"pins.setEvents\": \"Configureert de gebeurtenissen die deze pin stuurt. Er kan op gebeurtenissen geabonneerd worden via ``control.onEvent()``.\",\n  \"pins.setEvents|param|name\": \"pin om de gebeurtenis wijze op te zetten, bijv: DigitalPin.P0\",\n  \"pins.setEvents|param|type\": \"het type gebeurtenis wat deze pin oproept, bijv: PinEventType.Edge\",\n  \"pins.setPull\": \"Hiermee configureert u de aantrekkingskracht van deze pin.\",\n  \"pins.setPull|param|name\": \"pin om in te stellen in aantrekkings mode, bijv: DigitalPin.P0\",\n  \"pins.setPull|param|pull\": \"een van de mbed pull configuraties, bijv PinPullMode.PulllUp\",\n  \"pins.spiWrite\": \"Schrijf naar de SPI-slaaf en geef het antwoord terug\",\n  \"pins.spiWrite|param|value\": \"Gegevens om te verzenden naar de SPI slaaf\",\n  \"serial\": \"Lezen en schrijven van gegevens over een seriële verbinding.\",\n  \"serial.onDataReceived\": \"Registreert een gebeurtenis wat opgeroepen wordt wanneer een van de scheidingstekens wordt herkend.\",\n  \"serial.onDataReceived|param|delimiters\": \"de tekens om met de ontvangen tekens te vergelijken.\",\n  \"serial.readLine\": \"Leest een regel tekst van de seriële poort.\",\n  \"serial.readString\": \"Leest de gebufferde ontvangen gegevens als een reeks tekens\",\n  \"serial.readUntil\": \"Leest een regel tekst van de seriële poort tot de delimiter.\",\n  \"serial.readUntil|param|delimiter\": \"scheidingsteken die elk stuk tekst scheidt\",\n  \"serial.redirect\": \"Dynamisch configureren van de seriële communicatie om andere pinnen dan USBTX en USBRX te gebruiken.\",\n  \"serial.redirect|param|rate\": \"de nieuwe baud rate. bijv: 115200\",\n  \"serial.redirect|param|rx\": \"de nieuwe ontvangst-pin\",\n  \"serial.redirect|param|tx\": \"de nieuwe verzend pin, bijv: SerialPin.P0\",\n  \"serial.writeLine\": \"Schrijft een regel tekst naar serieel\",\n  \"serial.writeNumber\": \"Schrijft een numerieke waarde naar serieel\",\n  \"serial.writeString\": \"Hiermee verzendt u een stuk tekst via seriële verbinding.\",\n  \"serial.writeValue\": \"Verzend ''naam: waarde'' naar serieel.\",\n  \"serial.writeValue|param|name\": \"naam van de waarde stream, bv: x\",\n  \"serial.writeValue|param|value\": \"te schrijven\"\n}",
      "_locales/nl/core-strings.json": "{\n  \"AcceleratorRange.EightG\": \"De versneller meet krachten tot 8G (zwaartekracht)\",\n  \"AcceleratorRange.EightG|block\": \"8G\",\n  \"AcceleratorRange.FourG\": \"De versneller meet krachten tot 4G (zwaartekracht)\",\n  \"AcceleratorRange.FourG|block\": \"4g\",\n  \"AcceleratorRange.OneG\": \"De versneller meet krachten tot 1G (zwaartekracht)\",\n  \"AcceleratorRange.OneG|block\": \"1G\",\n  \"AcceleratorRange.TwoG\": \"De versneller meet krachten tot 2G (zwaartekracht)\",\n  \"AcceleratorRange.TwoG|block\": \"2g\",\n  \"AnalogPin.P11|block\": \"P11 (alleen schrijven)\",\n  \"AnalogPin.P12|block\": \"P12 (alleen schrijven)\",\n  \"AnalogPin.P13|block\": \"P13 (alleen schrijven)\",\n  \"AnalogPin.P14|block\": \"P14 (alleen schrijven)\",\n  \"AnalogPin.P15|block\": \"P15 (alleen schrijven)\",\n  \"AnalogPin.P16|block\": \"P16 (alleen schrijven)\",\n  \"AnalogPin.P19|block\": \"P19 (alleen schrijven)\",\n  \"AnalogPin.P20|block\": \"P20 (alleen schrijven)\",\n  \"AnalogPin.P5|block\": \"P5 (alleen schrijven)\",\n  \"AnalogPin.P6|block\": \"P6 (alleen schrijven)\",\n  \"AnalogPin.P7|block\": \"P7 (alleen schrijven)\",\n  \"AnalogPin.P8|block\": \"P8 (alleen schrijven)\",\n  \"AnalogPin.P9|block\": \"P9 (alleen schrijven)\",\n  \"BaudRate.BaudRate115200|block\": \"115200\",\n  \"BaudRate.BaudRate1200|block\": \"1200\",\n  \"BaudRate.BaudRate14400|block\": \"14400\",\n  \"BaudRate.BaudRate19200|block\": \"19200\",\n  \"BaudRate.BaudRate2400|block\": \"2400\",\n  \"BaudRate.BaudRate28800|block\": \"28800\",\n  \"BaudRate.BaudRate300|block\": \"300\",\n  \"BaudRate.BaudRate31250|block\": \"31250\",\n  \"BaudRate.BaudRate38400|block\": \"38400\",\n  \"BaudRate.BaudRate4800|block\": \"4800\",\n  \"BaudRate.BaudRate57600|block\": \"57600\",\n  \"BaudRate.BaudRate9600|block\": \"9600\",\n  \"BeatFraction.Breve|block\": \"4\",\n  \"BeatFraction.Double|block\": \"2\",\n  \"BeatFraction.Eighth|block\": \"1/8\",\n  \"BeatFraction.Half|block\": \"1/2\",\n  \"BeatFraction.Quarter|block\": \"1/4\",\n  \"BeatFraction.Sixteenth|block\": \"1/16\",\n  \"BeatFraction.Whole|block\": \"1\",\n  \"Button.AB|block\": \"A + B\",\n  \"Delimiters.Colon|block\": \":\",\n  \"Delimiters.Comma|block\": \",\",\n  \"Delimiters.Dollar|block\": \"$\",\n  \"Delimiters.Fullstop|block\": \".\",\n  \"Delimiters.Hash|block\": \"#\",\n  \"Delimiters.NewLine|block\": \"nieuwe regel\",\n  \"Dimension.Strength|block\": \"kracht\",\n  \"Dimension.X|block\": \"x\",\n  \"Dimension.Y|block\": \"y\",\n  \"Dimension.Z|block\": \"z\",\n  \"Direction.Left|block\": \"links\",\n  \"Direction.Right|block\": \"rechts\",\n  \"DisplayMode.BackAndWhite|block\": \"zwart-wit\",\n  \"DisplayMode.Greyscale|block\": \"grijswaarden\",\n  \"EventCreationMode.CreateAndFire\": \"MicroBitEvent is geïnitialiseerd, en zijn gebeurtenis-afhandelaars zijn onmiddellijk opgeroepen (niet geschikt om bij interrupts te gebruiken!).\",\n  \"EventCreationMode.CreateOnly\": \"MicroBitEvent is geïnitialiseerd en er vinden geen verdere verwerkingen plaats.\",\n  \"Gesture.EightG\": \"Opgeroepen wanneer een schok van 8G wordt gedetecteerd\",\n  \"Gesture.EightG|block\": \"8G\",\n  \"Gesture.FreeFall\": \"Opgeroepen als het bordje valt!\",\n  \"Gesture.FreeFall|block\": \"vrije val\",\n  \"Gesture.LogoDown\": \"Opgeroepen wanneer het logo naar beneden wijst en het scherm rechtop staat\",\n  \"Gesture.LogoDown|block\": \"logo naar beneden\",\n  \"Gesture.LogoUp\": \"Opgeroepen wanneer het logo boven is en het scherm rechtop staat\",\n  \"Gesture.LogoUp|block\": \"logo omhoog\",\n  \"Gesture.ScreenDown\": \"Opgeroepen wanneer het scherm naar boven wijst en het bord horizontaal is\",\n  \"Gesture.ScreenDown|block\": \"scherm naar beneden\",\n  \"Gesture.ScreenUp\": \"Opgeroepen wanneer het scherm naar beneden wijst en het bord horizontaal is\",\n  \"Gesture.ScreenUp|block\": \"scherm omhoog\",\n  \"Gesture.Shake\": \"Opgeroepen wanneer geschud\",\n  \"Gesture.Shake|block\": \"schudden\",\n  \"Gesture.SixG\": \"Opgeroepen wanneer een schik van 6G is gedetecteerd\",\n  \"Gesture.SixG|block\": \"6g\",\n  \"Gesture.ThreeG\": \"Opgeroepen wanneer een schik van 3G is gedetecteerd\",\n  \"Gesture.ThreeG|block\": \"3g\",\n  \"Gesture.TiltLeft\": \"Opgeroepen wanneer het scherm naar links wijst\",\n  \"Gesture.TiltLeft|block\": \"kantelt naar links\",\n  \"Gesture.TiltRight\": \"Opgeroepen wanneer het scherm naar rechts wijst\",\n  \"Gesture.TiltRight|block\": \"kantelt naar rechts\",\n  \"IconNames.Angry|block\": \"boos\",\n  \"IconNames.Asleep|block\": \"in slaap\",\n  \"IconNames.Butterfly|block\": \"vlinder\",\n  \"IconNames.Chessboard|block\": \"schaakbord\",\n  \"IconNames.Confused|block\": \"verward\",\n  \"IconNames.Cow|block\": \"koe\",\n  \"IconNames.Diamond|block\": \"diamant\",\n  \"IconNames.Duck|block\": \"eend\",\n  \"IconNames.EigthNote|block\": \"achtste noot\",\n  \"IconNames.Fabulous|block\": \"fantastisch\",\n  \"IconNames.Ghost|block\": \"spook\",\n  \"IconNames.Giraffe|block\": \"giraf\",\n  \"IconNames.Happy|block\": \"blij\",\n  \"IconNames.Heart|block\": \"hart\",\n  \"IconNames.House|block\": \"huis\",\n  \"IconNames.LeftTriangle|block\": \"driehoek links\",\n  \"IconNames.Meh|block\": \"meh\",\n  \"IconNames.No|block\": \"nee\",\n  \"IconNames.Pitchfork|block\": \"hooivork\",\n  \"IconNames.QuarterNote|block\": \"kwartnoot\",\n  \"IconNames.Rabbit|block\": \"konijn\",\n  \"IconNames.Rollerskate|block\": \"rolschaats\",\n  \"IconNames.Sad|block\": \"verdrietig\",\n  \"IconNames.Scissors|block\": \"schaar\",\n  \"IconNames.Silly|block\": \"gek\",\n  \"IconNames.Skull|block\": \"doodshoofd\",\n  \"IconNames.SmallDiamond|block\": \"kleine diamant\",\n  \"IconNames.SmallHeart|block\": \"klein hart\",\n  \"IconNames.SmallSquare|block\": \"klein vierkant\",\n  \"IconNames.Snake|block\": \"slang\",\n  \"IconNames.Square|block\": \"vierkant\",\n  \"IconNames.StickFigure|block\": \"stok figuur\",\n  \"IconNames.Surprised|block\": \"verrast\",\n  \"IconNames.Sword|block\": \"zwaard\",\n  \"IconNames.TShirt|block\": \"t-shirt\",\n  \"IconNames.Target|block\": \"doelwit\",\n  \"IconNames.Tortoise|block\": \"schildpad\",\n  \"IconNames.Triangle|block\": \"driehoek\",\n  \"IconNames.Umbrella|block\": \"paraplu\",\n  \"IconNames.Yes|block\": \"ja\",\n  \"LedSpriteProperty.Blink|block\": \"knipperen\",\n  \"LedSpriteProperty.Brightness|block\": \"helderheid\",\n  \"LedSpriteProperty.Direction|block\": \"richting\",\n  \"LedSpriteProperty.X|block\": \"x\",\n  \"LedSpriteProperty.Y|block\": \"y\",\n  \"Math.randomBoolean|block\": \"Kies willekeurige waar of onwaar\",\n  \"Math|block\": \"Wiskunde\",\n  \"Melodies.BaDing|block\": \"ba ding\",\n  \"Melodies.Baddy|block\": \"boef\",\n  \"Melodies.Birthday|block\": \"verjaardag\",\n  \"Melodies.Blues|block\": \"blues\",\n  \"Melodies.Chase|block\": \"achtervolgen\",\n  \"Melodies.Dadadadum|block\": \"dadadum\",\n  \"Melodies.Entertainer|block\": \"entertainer\",\n  \"Melodies.Funeral|block\": \"begrafenis\",\n  \"Melodies.Funk|block\": \"funk\",\n  \"Melodies.JumpDown|block\": \"spring omlaag\",\n  \"Melodies.JumpUp|block\": \"spring omhoog\",\n  \"Melodies.Nyan|block\": \"nyan\",\n  \"Melodies.Ode|block\": \"ode\",\n  \"Melodies.PowerDown|block\": \"afsluiten\",\n  \"Melodies.PowerUp|block\": \"opstarten\",\n  \"Melodies.Prelude|block\": \"inleiding\",\n  \"Melodies.Punchline|block\": \"clou\",\n  \"Melodies.Ringtone|block\": \"beltoon\",\n  \"Melodies.Wawawawaa|block\": \"wawawawaa\",\n  \"Melodies.Wedding|block\": \"bruiloft\",\n  \"MelodyOptions.ForeverInBackground|block\": \"altijd op de achtergrond\",\n  \"MelodyOptions.Forever|block\": \"de hele tijd\",\n  \"MelodyOptions.OnceInBackground|block\": \"eenmalig in de achtergrond\",\n  \"MelodyOptions.Once|block\": \"eenmalig\",\n  \"Note.CSharp3|block\": \"C# 3\",\n  \"Note.CSharp4|block\": \"C# 4\",\n  \"Note.CSharp5|block\": \"C# 5\",\n  \"Note.CSharp|block\": \"C#\",\n  \"Note.FSharp3|block\": \"F #3\",\n  \"Note.FSharp4|block\": \"F #4\",\n  \"Note.FSharp5|block\": \"F #5\",\n  \"Note.FSharp|block\": \"F #\",\n  \"Note.GSharp3|block\": \"G #3\",\n  \"Note.GSharp4|block\": \"G #4\",\n  \"Note.GSharp5|block\": \"G #5\",\n  \"Note.GSharp|block\": \"G #\",\n  \"PinEventType.Edge|block\": \"rand\",\n  \"PinEventType.None|block\": \"geen\",\n  \"PinEventType.Pulse|block\": \"puls\",\n  \"PinEventType.Touch|block\": \"aanraken\",\n  \"PinPullMode.PullDown|block\": \"naar beneden\",\n  \"PinPullMode.PullNone|block\": \"geen\",\n  \"PinPullMode.PullUp|block\": \"omhoog\",\n  \"PulseValue.High|block\": \"hoog\",\n  \"PulseValue.Low|block\": \"laag\",\n  \"Rotation.Pitch|block\": \"kantelen\",\n  \"Rotation.Roll|block\": \"draaien\",\n  \"String.charAt|block\": \"teken van %this=text|op %pos\",\n  \"String.compare|block\": \"vergelijk %this=text| met %that\",\n  \"String.fromCharCode|block\": \"tekst van karakter code %code\",\n  \"String.length|block\": \"lengte van %VALUE\",\n  \"String.substr|block\": \"tekens van %this=text|vanaf %start|met lengte %length\",\n  \"String|block\": \"Tekenreeks\",\n  \"basic.clearScreen|block\": \"scherm wissen\",\n  \"basic.forever|block\": \"de hele tijd\",\n  \"basic.pause|block\": \"pauzeer (ms) %pause\",\n  \"basic.showIcon|block\": \"toon icoon %i\",\n  \"basic.showLeds|block\": \"toon lichtjes\",\n  \"basic.showNumber|block\": \"toon | nummer %number\",\n  \"basic.showString|block\": \"toon tekens | %text\",\n  \"basic|block\": \"basis\",\n  \"control.deviceName|block\": \"apparaatnaam\",\n  \"control.deviceSerialNumber|block\": \"apparaat serienummer\",\n  \"control.eventSourceId|block\": \"%id\",\n  \"control.eventTimestamp|block\": \"gebeurtenis tijdstip\",\n  \"control.eventValueId|block\": \"%id\",\n  \"control.eventValue|block\": \"gebeurtenis waarde\",\n  \"control.inBackground|block\": \"uitvoeren in de achtergrond\",\n  \"control.onEvent|block\": \"bij gebeurtenis|van %src=control_event_source_id|met waarde %value=control_event_value_id\",\n  \"control.raiseEvent|block\": \"roep gebeurtenis op|van bron %src=control_event_source_id|met waarde %value=control_event_value_id\",\n  \"control.reset|block\": \"reset\",\n  \"control.waitMicros|block\": \"wacht (µs)%micros\",\n  \"control|block\": \"controle\",\n  \"game.addScore|block\": \"score met |%points wijzigen\",\n  \"game.createSprite|block\": \"maak figuurtje op|x: %x|y: %y\",\n  \"game.gameOver|block\": \"je bent af\",\n  \"game.score|block\": \"score\",\n  \"game.setScore|block\": \"zet score op %points\",\n  \"game.startCountdown|block\": \"begin met aftellen | (ms) %duration\",\n  \"game|block\": \"spel\",\n  \"images.createBigImage|block\": \"grote afbeelding maken\",\n  \"images.createImage|block\": \"afbeelding maken\",\n  \"images|block\": \"afbeeldingen\",\n  \"input.acceleration|block\": \"versnelling (mg) |%NAME\",\n  \"input.buttonIsPressed|block\": \"knop |%NAME | wordt ingedrukt\",\n  \"input.compassHeading|block\": \"richting kompas (°)\",\n  \"input.lightLevel|block\": \"lichtniveau\",\n  \"input.magneticForce|block\": \"magnetische kracht (µT) |%NAME\",\n  \"input.onButtonPressed|block\": \"wanneer knop |%NAME| wordt ingedrukt\",\n  \"input.onGesture|block\": \"op |%NAME\",\n  \"input.onPinPressed|block\": \"wanneer pin|%name| wordt aangeraakt\",\n  \"input.onPinReleased|block\": \"als pin %NAME | wordt losgelaten\",\n  \"input.pinIsPressed|block\": \"pin %NAME | wordt ingedrukt\",\n  \"input.rotation|block\": \"rotatie (°)|%NAME\",\n  \"input.runningTime|block\": \"looptijd (ms)\",\n  \"input.setAccelerometerRange|block\": \"zet accelerometer|bereik %range\",\n  \"input.temperature|block\": \"temperatuur (°C)\",\n  \"input|block\": \"invoer\",\n  \"led.brightness|block\": \"helderheid\",\n  \"led.enable|block\": \"led inschakelen %on\",\n  \"led.plotBarGraph|block\": \"plot staafdiagram van %value |tot en met %high\",\n  \"led.plot|block\": \"teken|x %x|y %y\",\n  \"led.point|block\": \"punt|x %x|y %y\",\n  \"led.setBrightness|block\": \"stel helderheid in op %value\",\n  \"led.stopAnimation|block\": \"Stop animatie\",\n  \"led.toggle|block\": \"wissel|x %x|y %y\",\n  \"led.unplot|block\": \"wis|x %x|y %y\",\n  \"led|block\": \"led\",\n  \"music.beat|block\": \"%fraction|beat\",\n  \"music.builtInMelody|block\": \"%melodie\",\n  \"music.changeTempoBy|block\": \"wijzigen tempo door (bpm) | %value\",\n  \"music.noteFrequency|block\": \"%note\",\n  \"music.playTone|block\": \"speel|toon %note=device_note|voor %duration=device_beat\",\n  \"music.rest|block\": \"rest (ms) |%duration = device_beat\",\n  \"music.ringTone|block\": \"speel toon (Hz) | %note=device_note\",\n  \"music.setTempo|block\": \"zet tempo op (bpm) | % waarde\",\n  \"music.tempo|block\": \"tempo (bpm)\",\n  \"music|block\": \"muziek\",\n  \"pins.analogPitch|block\": \"analoge toonhoogte %frequency|voor (ms) %ms\",\n  \"pins.analogReadPin|block\": \"lees analoog|pin %name\",\n  \"pins.analogSetPeriod|block\": \"zet analoge periode|pin %pin|op (µs) % micros\",\n  \"pins.analogSetPitchPin|block\": \"zet analoge toonhoogte pin %name\",\n  \"pins.analogWritePin|block\": \"schrijf analoog|pin %name|naar % waarde\",\n  \"pins.digitalReadPin|block\": \"digitaal lees|pin %name\",\n  \"pins.digitalWritePin|block\": \"digitaal schrijf|pin %name|naar % waarde\",\n  \"pins.i2cReadNumber|block\": \"i2C Lees number|op adres %address|van indeling %format = i2c_sizeof\",\n  \"pins.i2cWriteNumber|block\": \"i2c schrijf nummer|op adres %address|met waarde % value|van indeling %format = i2c_sizeof\",\n  \"pins.map|block\": \"vertaal %value|van %fromLow|tot %fromHigh|naar van %toLow|tot %toHigh\",\n  \"pins.onPulsed|block\": \"als|pin %pin|pulseerde %pulse\",\n  \"pins.pulseDuration|block\": \"pulsetijd (µs)\",\n  \"pins.pulseIn|block\": \"puls in (µs)|pin %name|pulseerde %value\",\n  \"pins.servoSetPulse|block\": \"servo instellen pulse|pin %value|tot (µs) % micros\",\n  \"pins.servoWritePin|block\": \"servo schrijf|pin %name|naar waarde %value\",\n  \"pins.setEvents|block\": \"zet pin %pin|om %type|gebeurtenissen op te roepen\",\n  \"pins.setPull|block\": \"zet pull|pin %pin|op %pull\",\n  \"pins.spiWrite|block\": \"spi schrijf %value\",\n  \"pins|block\": \"pinnen\",\n  \"serial.delimiters|block\": \"%del\",\n  \"serial.onDataReceived|block\": \"serieel|bij data ontvangen %delimiters=serial_delimiter_conv\",\n  \"serial.readLine|block\": \"serieel|lees regel\",\n  \"serial.readString|block\": \"serieel|lees tekens\",\n  \"serial.readUntil|block\": \"serieel|lees totdat %delimiter=serial_delimiter_conv\",\n  \"serial.redirect|block\": \"serieel|leid om naar|TX %tx|RX %rx|op baud rate %rate\",\n  \"serial.writeLine|block\": \"serieel|schrijf regel %text\",\n  \"serial.writeNumber|block\": \"serieel|schrijf nummer %value\",\n  \"serial.writeString|block\": \"serieel|schrijf tekenreeks %text\",\n  \"serial.writeValue|block\": \"serieel|schrijf waarde %name|= %value\",\n  \"serial|block\": \"serieel\",\n  \"{id:category}Basic\": \"Basis\",\n  \"{id:category}Control\": \"Besturen\",\n  \"{id:category}Game\": \"Spel\",\n  \"{id:category}Images\": \"Plaatjes\",\n  \"{id:category}Input\": \"Invoer\",\n  \"{id:category}Led\": \"Lichtjes\",\n  \"{id:category}Math\": \"Wiskunde\",\n  \"{id:category}Music\": \"Muziek\",\n  \"{id:category}Pins\": \"Pinnen\",\n  \"{id:category}Serial\": \"Serieel\",\n  \"{id:category}String\": \"Tekenreeks\",\n  \"{id:category}Text\": \"Tekst\"\n}",
      "_locales/no/core-jsdoc-strings.json": "{\n  \"Math.abs\": \"Gir absoluttverdien av et tall (størrelsen av tallet, uavhengig av om det er positivt eller negativt).\\nFor eksempel er absoluttverdien av -5 og absoluttverdien av 5 begge lik 5.\",\n  \"Math.abs|param|x\": \"Et tall eller matematisk uttrykk som vi ønsker absoluttverdien av.\",\n  \"Math.max\": \"Gir verdien til det største av to tall eller matematiske uttrykk.\",\n  \"Math.randomBoolean\": \"Gir en tilfeldig logisk verdi, \\\"sann\\\" eller \\\"usann\\\".\",\n  \"String.fromCharCode\": \"Lag en tekst som består av tegnet med den angitte ASCII-koden.\",\n  \"basic\": \"Blokker for grunnleggende mikro:bit-funksjonalitet.\",\n  \"basic.clearScreen\": \"Slå av alle lysene på skjermen\",\n  \"basic.forever\": \"Gjentar denne koden hele tiden, i bakgrunnen. Lar annen kode kjøre etter hver gjentakelse.\",\n  \"basic.pause\": \"Gjør at programmet venter en angitt tid, i millisekunder\",\n  \"basic.pause|param|ms\": \"hvor lenge pausen skal vare, f.eks: 100, 200, 500, 1000, 2000\",\n  \"basic.plotLeds\": \"Tegner et bilde på skjermen.\",\n  \"basic.plotLeds|param|leds\": \"mønster av lysdioder som er på\",\n  \"basic.showAnimation\": \"Viser en sekvens av bilder som en animasjon.\",\n  \"basic.showAnimation|param|interval\": \"tid i millisekunder mellom hver gang skjermbildet tegnes\",\n  \"basic.showAnimation|param|leds\": \"mønster av lysdioder som er på\",\n  \"basic.showLeds\": \"Tegner et bilde på skjermen.\",\n  \"basic.showLeds|param|interval\": \"pause i millisekunder etter visning\",\n  \"basic.showLeds|param|leds\": \"mønsteret som skal vises med lysdiodene\",\n  \"basic.showNumber\": \"Vis et tall, rullende over skjermen. Hvis tallet får plass på skjermen (dvs. er ett enkelt siffer), ruller det ikke.\",\n  \"basic.showNumber|param|interval\": \"farten til det som ruller over skjermen; f.eks: 150, 100, 200, -100\",\n  \"basic.showString\": \"Vis en tekst rullende over skjermen. Hvis strengen har bare ett tegn ruller den ikke.\",\n  \"basic.showString|param|interval\": \"hvor fort teksten skal rulle, f.eks: 150, 100, 200, -100\",\n  \"basic.showString|param|text\": \"teksten som ruller over skjermen, f.eks: \\\"Hallo!\\\"\",\n  \"control\": \"Styrer programkjøring og hendelser.\",\n  \"control.inBackground\": \"Setter opp kode som skal kjøre i bakgrunnen.\",\n  \"control.reset\": \"Tilbakestiller micro:bit.\",\n  \"game\": \"En spillmotor for brikker (bevegelige lyspunkter)\",\n  \"game.addScore\": \"Øker poengsum med et antall poeng\",\n  \"game.addScore|param|points\": \"endring i antall poeng, f.eks. 1\",\n  \"game.gameOver\": \"Animasjon som viser at spillet er slutt.\",\n  \"game.score\": \"Gir nåværende poengsum\",\n  \"game.setScore\": \"Setter poengsum til en verdi, f.eks. 0\",\n  \"game.startCountdown\": \"Starter en nedtellingsklokke\",\n  \"game.startCountdown|param|ms\": \"nedtellingens varighet i millisekunder, f.eks. 10000\",\n  \"images\": \"Oppretting, behandling og visning av bilder på skjermen.\",\n  \"images.createBigImage\": \"Lager et bredt bilde som kan rulles over skjermen.\",\n  \"images.createImage\": \"Lager et bilde.\",\n  \"input\": \"Hendelser og data fra sensorer\",\n  \"input.rotation\": \"Helningsvinkel til micro:bit: Rotasjon om x-aksen (høyre/venstre) og y-aksen (forover/bakover), i grader.\",\n  \"input.runningTime\": \"Gir antall millisekunder siden strømmen ble slått på.\",\n  \"input.setAccelerometerRange\": \"Angir måleområde og følsomhet for akselerometeret.\",\n  \"input.setAccelerometerRange|param|range\": \"tallet angir den største akselerasjonen som måles\",\n  \"input.temperature\": \"Gir temperaturen i grader celsius.\",\n  \"led\": \"Styring av skjermen.\",\n  \"led.brightness\": \"Gir skjermens lysstyrke fra 0 (av) til 255 (full styrke).\",\n  \"led.fadeIn\": \"Tenner skjermen gradvis.\",\n  \"led.fadeOut\": \"Slukker skjermen gradvis.\"\n}",
      "_locales/no/core-strings.json": "{\n  \"AcceleratorRange.EightG\": \"Akselerometerets måleområde er opp til 8 ganger tyngekraften\",\n  \"AcceleratorRange.EightG|block\": \"8 G\",\n  \"AcceleratorRange.FourG\": \"Akselerometerets måleområde er opp til 4 ganger tyngekraften\",\n  \"AcceleratorRange.FourG|block\": \"4 g\",\n  \"AcceleratorRange.OneG\": \"Akselerometerets måleområde er opp til 1 ganger tyngekraften\",\n  \"AcceleratorRange.OneG|block\": \"1 g\",\n  \"AcceleratorRange.TwoG\": \"Akselerometerets måleområde er opp til 2 ganger tyngekraften\",\n  \"AcceleratorRange.TwoG|block\": \"2 g\",\n  \"AnalogPin.P11|block\": \"P11 (bare utgang)\",\n  \"AnalogPin.P12|block\": \"P12 (bare utgang)\",\n  \"AnalogPin.P13|block\": \"P13 (bare utgang)\",\n  \"AnalogPin.P14|block\": \"P14 (bare utgang)\",\n  \"AnalogPin.P15|block\": \"P15 (bare utgang)\",\n  \"AnalogPin.P16|block\": \"P16 (bare utgang)\",\n  \"AnalogPin.P19|block\": \"P19 (bare utgang)\",\n  \"AnalogPin.P20|block\": \"P20 (bare utgang)\",\n  \"AnalogPin.P5|block\": \"P5 (bare utgang)\",\n  \"AnalogPin.P6|block\": \"P6 (bare utgang)\",\n  \"AnalogPin.P7|block\": \"P7 (bare utgang)\",\n  \"AnalogPin.P8|block\": \"P8 (bare utgang)\",\n  \"AnalogPin.P9|block\": \"P9 (bare utgang)\",\n  \"BaudRate.BaudRate115200|block\": \"115200\",\n  \"BaudRate.BaudRate9600|block\": \"9600\",\n  \"BeatFraction.Breve|block\": \"4\",\n  \"BeatFraction.Double|block\": \"2\",\n  \"BeatFraction.Eighth|block\": \"1/8\",\n  \"BeatFraction.Half|block\": \"1/2\",\n  \"BeatFraction.Quarter|block\": \"1/4\",\n  \"BeatFraction.Sixteenth|block\": \"1/16\",\n  \"BeatFraction.Whole|block\": \"1\",\n  \"Button.AB|block\": \"A+B\",\n  \"Delimiters.Colon|block\": \":\",\n  \"Delimiters.Comma|block\": \",\",\n  \"Delimiters.Dollar|block\": \"$\",\n  \"Delimiters.Fullstop|block\": \".\",\n  \"Delimiters.Hash|block\": \"#\",\n  \"Delimiters.NewLine|block\": \"linjeskift\",\n  \"Dimension.Strength|block\": \"styrke\",\n  \"Dimension.X|block\": \"x\",\n  \"Dimension.Y|block\": \"y\",\n  \"Dimension.Z|block\": \"z\",\n  \"Direction.Left|block\": \"venstre\",\n  \"Direction.Right|block\": \"høyre\",\n  \"DisplayMode.BackAndWhite|block\": \"svart og hvitt\",\n  \"DisplayMode.Greyscale|block\": \"gråtone\",\n  \"EventCreationMode.CreateAndFire\": \"En hendelse opprettes og den tilhørende hendelsesbehandleren startes. (Må ikke brukes inne i et interrupt.)\",\n  \"EventCreationMode.CreateOnly\": \"En hendelse opprettes, men behandling av hendelsen startes ikke.\",\n  \"Gesture.EightG\": \"Hendelse når et støt på over 8G detekteres\",\n  \"Gesture.EightG|block\": \"8 G\",\n  \"Gesture.FreeFall\": \"Hendelse når micro:bit faller!\",\n  \"Gesture.FreeFall|block\": \"fritt fall\",\n  \"Gesture.LogoDown\": \"Hendelse når logoen er ned og skjermen er vertikal\",\n  \"Gesture.LogoDown|block\": \"logo ned\",\n  \"Gesture.LogoUp\": \"Hendelse når logoen er opp og skjermen er vertikal\",\n  \"Gesture.LogoUp|block\": \"logo opp\",\n  \"Gesture.ScreenDown\": \"Hendelse når micro:bit ligger flatt med skjermen opp\",\n  \"Gesture.ScreenDown|block\": \"skjerm ned\",\n  \"Gesture.ScreenUp\": \"Hendelse når micro:bit ligger flatt med skjermen ned\",\n  \"Gesture.ScreenUp|block\": \"skjerm opp\",\n  \"Gesture.Shake\": \"Hendelse når micro:bit ristes\",\n  \"Gesture.Shake|block\": \"ristes\",\n  \"Gesture.SixG\": \"Hendelse når et støt sterkere enn 6G detekteres\",\n  \"Gesture.SixG|block\": \"6G\",\n  \"Gesture.ThreeG\": \"Hendelse når et støt sterkere enn 3G detekteres\",\n  \"Gesture.ThreeG|block\": \"3G\",\n  \"Gesture.TiltLeft\": \"Hendelse når skjermen vender mot venstre\",\n  \"Gesture.TiltLeft|block\": \"helning venstre\",\n  \"Gesture.TiltRight\": \"Hendelse når skjermen vender mot høyre\",\n  \"Gesture.TiltRight|block\": \"helning høyre\",\n  \"IconNames.Angry|block\": \"sint\",\n  \"IconNames.Asleep|block\": \"sover\",\n  \"IconNames.Butterfly|block\": \"sommerfugl\",\n  \"IconNames.Chessboard|block\": \"sjakkbrett\",\n  \"IconNames.Confused|block\": \"forvirret\",\n  \"IconNames.Cow|block\": \"ku\",\n  \"IconNames.Diamond|block\": \"diamant\",\n  \"IconNames.Duck|block\": \"and\",\n  \"IconNames.EigthNote|block\": \"8-dels note\",\n  \"IconNames.Fabulous|block\": \"fantastisk\",\n  \"IconNames.Ghost|block\": \"spøkelse\",\n  \"IconNames.Giraffe|block\": \"giraff\",\n  \"IconNames.Happy|block\": \"glad\",\n  \"IconNames.Heart|block\": \"hjerte\",\n  \"IconNames.House|block\": \"hus\",\n  \"IconNames.LeftTriangle|block\": \"triangel venstre\",\n  \"IconNames.Meh|block\": \"meh\",\n  \"IconNames.No|block\": \"nei\",\n  \"IconNames.Pitchfork|block\": \"gaffel\",\n  \"IconNames.QuarterNote|block\": \"4-dels note\",\n  \"IconNames.Rabbit|block\": \"kanin\",\n  \"IconNames.Rollerskate|block\": \"rulleskøyte\",\n  \"IconNames.Sad|block\": \"trist\",\n  \"IconNames.Scissors|block\": \"saks\",\n  \"IconNames.Silly|block\": \"tull\",\n  \"IconNames.Skull|block\": \"skalle\",\n  \"IconNames.SmallDiamond|block\": \"liten diamant\",\n  \"IconNames.SmallHeart|block\": \"lite hjerte\",\n  \"IconNames.SmallSquare|block\": \"liten firkant\",\n  \"IconNames.Snake|block\": \"slange\",\n  \"IconNames.Square|block\": \"firkant\",\n  \"IconNames.StickFigure|block\": \"strekmann\",\n  \"IconNames.Surprised|block\": \"overrasket\",\n  \"IconNames.Sword|block\": \"sverd\",\n  \"IconNames.TShirt|block\": \"t-skjorte\",\n  \"IconNames.Target|block\": \"blink\",\n  \"IconNames.Tortoise|block\": \"skilpadde\",\n  \"IconNames.Triangle|block\": \"trekant\",\n  \"IconNames.Umbrella|block\": \"paraply\",\n  \"IconNames.Yes|block\": \"ja\",\n  \"LedSpriteProperty.Blink|block\": \"blinke\",\n  \"LedSpriteProperty.Brightness|block\": \"lysstyrke\",\n  \"LedSpriteProperty.Direction|block\": \"retning\",\n  \"LedSpriteProperty.X|block\": \"x\",\n  \"LedSpriteProperty.Y|block\": \"y\",\n  \"Math.randomBoolean|block\": \"velg tilfeldig sann eller usann\",\n  \"Math|block\": \"Matematikk\",\n  \"Melodies.Birthday|block\": \"fødselsdag\",\n  \"Melodies.Blues|block\": \"blues\",\n  \"Melodies.Funeral|block\": \"begravelse\",\n  \"Melodies.Funk|block\": \"funk\",\n  \"Melodies.JumpDown|block\": \"hopp ned\",\n  \"Melodies.JumpUp|block\": \"hopp opp\",\n  \"Melodies.Ringtone|block\": \"ringetone\",\n  \"Melodies.Wedding|block\": \"bryllup\",\n  \"MelodyOptions.ForeverInBackground|block\": \"for alltid i bakgrunnen\",\n  \"MelodyOptions.Forever|block\": \"gjenta for alltid\",\n  \"MelodyOptions.OnceInBackground|block\": \"en gang i bakgrunnen\",\n  \"MelodyOptions.Once|block\": \"en gang\",\n  \"Note.CSharp3|block\": \"C#3\",\n  \"Note.CSharp4|block\": \"C#4\",\n  \"Note.CSharp5|block\": \"C#5\",\n  \"Note.CSharp|block\": \"C#\",\n  \"Note.FSharp3|block\": \"F#3\",\n  \"Note.FSharp4|block\": \"F#4\",\n  \"Note.FSharp5|block\": \"F#5\",\n  \"Note.FSharp|block\": \"F#\",\n  \"Note.GSharp3|block\": \"G#3\",\n  \"Note.GSharp4|block\": \"G#4\",\n  \"Note.GSharp5|block\": \"G#5\",\n  \"Note.GSharp|block\": \"G#\",\n  \"PinEventType.Edge|block\": \"kant\",\n  \"PinEventType.None|block\": \"ingen\",\n  \"PinEventType.Pulse|block\": \"puls\",\n  \"PinEventType.Touch|block\": \"berøring\",\n  \"PinPullMode.PullDown|block\": \"lav\",\n  \"PinPullMode.PullNone|block\": \"ingen\",\n  \"PinPullMode.PullUp|block\": \"høy\",\n  \"PulseValue.High|block\": \"høy\",\n  \"PulseValue.Low|block\": \"lav\",\n  \"Rotation.Pitch|block\": \"vinkel forover-bakover\",\n  \"Rotation.Roll|block\": \"vinkel høyre-venstre\",\n  \"String.charAt|block\": \"tegn fra %this=text|posisjon %pos\",\n  \"String.compare|block\": \"sammenlign %this=text| med %that\",\n  \"String.fromCharCode|block\": \"tekst fra tegnverdi %code\",\n  \"String.substr|block\": \"del av %this=text|fra posisjon %start|med lengde %length\",\n  \"String|block\": \"Tekst\",\n  \"basic.clearScreen|block\": \"tøm skjermen\",\n  \"basic.forever|block\": \"gjenta for alltid\",\n  \"basic.pause|block\": \"pause (ms) %pause\",\n  \"basic.showIcon|block\": \"vis ikon %i\",\n  \"basic.showLeds|block\": \"vis bilde\",\n  \"basic.showNumber|block\": \"vis|tall %number\",\n  \"basic.showString|block\": \"vis|tekst %text\",\n  \"basic|block\": \"grunnleggende\",\n  \"control.inBackground|block\": \"kjør i bakgrunnen\",\n  \"control.reset|block\": \"tilbakestill\",\n  \"control.waitMicros|block\": \"vent (µs) %micros\",\n  \"control|block\": \"kontroll\",\n  \"game.addScore|block\": \"endre poengsum med|%points\",\n  \"game.gameOver|block\": \"game over\",\n  \"game.score|block\": \"poengsum\",\n  \"game.setScore|block\": \"sett poengsum til %points\",\n  \"game.startCountdown|block\": \"start nedtelling|(ms) %duration\",\n  \"game|block\": \"spill\",\n  \"images.createBigImage|block\": \"lag stort bilde\",\n  \"images.createImage|block\": \"lag bilde\",\n  \"images|block\": \"bilder\",\n  \"input.acceleration|block\": \"akselerasjon (mG) |%NAME\",\n  \"input.buttonIsPressed|block\": \"knapp|%NAME|trykkes\",\n  \"input.compassHeading|block\": \"kompassretning (°)\",\n  \"input.lightLevel|block\": \"lysnivå\",\n  \"input.magneticForce|block\": \"magnetfelt (µT)|%NAME\",\n  \"input.onButtonPressed|block\": \"når knapp|%NAME|trykkes\",\n  \"input.onGesture|block\": \"når |%NAME\",\n  \"input.onPinPressed|block\": \"når kontakt %name|trykkes\",\n  \"input.onPinReleased|block\": \"når kontakt %NAME|slippes\",\n  \"input.pinIsPressed|block\": \"kontakt %NAME|trykkes\",\n  \"input.rotation|block\": \"helningsvinkel (°)|%NAME\",\n  \"input.runningTime|block\": \"kjøretid (ms)\",\n  \"input.setAccelerometerRange|block\": \"sett akselerometer|maks. %range\",\n  \"input.temperature|block\": \"temperatur (°C)\",\n  \"input|block\": \"inngang\",\n  \"led.brightness|block\": \"lysstyrke\",\n  \"led.enable|block\": \"skjerm på %on\",\n  \"led.plotBarGraph|block\": \"søylediagram av %value |opp til %high\",\n  \"led.plot|block\": \"tenn|x %x|y %y\",\n  \"led.point|block\": \"lyser i|x %x|y %y\",\n  \"led.setBrightness|block\": \"sett lysstyrke %value\",\n  \"led.stopAnimation|block\": \"stopp animasjon\",\n  \"led.toggle|block\": \"bytt|x %x|y %y\",\n  \"led.unplot|block\": \"slukk|x %x|y %y\",\n  \"led|block\": \"LED\",\n  \"music.beat|block\": \"%fraction|takt\",\n  \"music.builtInMelody|block\": \"%melody\",\n  \"music.changeTempoBy|block\": \"endre tempo med (bpm)|%value\",\n  \"music.noteFrequency|block\": \"%note\",\n  \"music.playTone|block\": \"spill|tone %note=device_note|i %duration=device_beat\",\n  \"music.rest|block\": \"pause (ms) |%duration = device_beat\",\n  \"music.ringTone|block\": \"ring tone (Hz)|%note=device_note\",\n  \"music.setTempo|block\": \"sett tempo til (bpm)|%value\",\n  \"music.tempo|block\": \"tempo (bpm)\",\n  \"music|block\": \"musikk\",\n  \"pins.analogPitch|block\": \"analog tone %frequency|i (ms) %ms\",\n  \"pins.analogReadPin|block\": \"les analogverdi|fra %name\",\n  \"pins.analogSetPeriod|block\": \"analog sett periodetid|på %pin|til (µs) %micros\",\n  \"pins.analogSetPitchPin|block\": \"analog tone kontakt %name\",\n  \"pins.analogWritePin|block\": \"skriv analog|til %name|verdi %value\",\n  \"pins.digitalReadPin|block\": \"les digitalverdi|fra %name\",\n  \"pins.digitalWritePin|block\": \"skriv digital|til %name|verdi %value\",\n  \"pins.map|block\": \"regn om %value|fra lav %fromLow|fra høy %fromHigh|til lav %toLow|til høy %toHigh\",\n  \"pins.onPulsed|block\": \"når|%pin|mottar puls %pulse\",\n  \"pins.pulseDuration|block\": \"pulslengde (µs)\",\n  \"pins.servoSetPulse|block\": \"servo skriv pulslengde|på %value|til (µs) %micros\",\n  \"pins.servoWritePin|block\": \"servo skriv|til %name|verdi %value\",\n  \"pins.setEvents|block\": \"la kontakt %pin|lage %type|-hendelser\",\n  \"pins.setPull|block\": \"sett utilkoblet verdi|for %pin|til %pull\",\n  \"pins.spiWrite|block\": \"SPI skriv %value\",\n  \"pins|block\": \"tilkoblinger\",\n  \"serial.onDataReceived|block\": \"når serieport|mottar %delimiters=serial_delimiter_conv\",\n  \"serial.readLine|block\": \"serieport|les linje\",\n  \"serial.readString|block\": \"serieport|les tekst\",\n  \"serial.readUntil|block\": \"serieport|les fram til %delimiter=serial_delimiter_conv\",\n  \"serial.redirect|block\": \"sett serieport|tilkobling|send %tx| motta %rx|med hastighet %rate\",\n  \"serial.writeLine|block\": \"serieport|skriv linje %text\",\n  \"serial.writeNumber|block\": \"serieport|skriv tall %value\",\n  \"serial.writeString|block\": \"serieport|skriv tekst %text\",\n  \"serial.writeValue|block\": \"serieport|skriv verdi %name|= %value\",\n  \"serial|block\": \"føljetong\",\n  \"{id:category}Basic\": \"Basis\",\n  \"{id:category}Control\": \"Styring\",\n  \"{id:category}Game\": \"Spill\",\n  \"{id:category}Images\": \"Bilder\",\n  \"{id:category}Input\": \"Inndata\",\n  \"{id:category}Led\": \"Skjerm\",\n  \"{id:category}Math\": \"Matematikk\",\n  \"{id:category}Music\": \"Musikk\",\n  \"{id:category}Pins\": \"Tilkobling\",\n  \"{id:category}Serial\": \"Serieport\",\n  \"{id:category}String\": \"Tekst\"\n}",
      "_locales/si-LK/core-jsdoc-strings.json": "{\n  \"Math.randomBoolean\": \"සත්‍යය හෝ අසත්‍යය අගයන් අහඹු ලෙස ලැබෙනවා. කාසියක් උඩ දාපුවම ලැබෙන අගයන් දෙක වගේ.\",\n  \"String.fromCharCode\": \"දෙන ලද ASCII අක්ෂර කේතයෙන් වචනයක් සකසන්න.\",\n  \"basic\": \"මුලික micro:bit අංග වලට ප්‍රවේශ වීමට ඉඩ කඩ ලබා දෙයි.\",\n  \"basic.clearScreen\": \"සියලුම LEDs නිවා දමන්න\"\n}",
      "_locales/si-LK/core-strings.json": "{\n  \"AcceleratorRange.EightG\": \"ත්වරකය ගුරුත්වය 8ක් වන තෙක් මිනුම් ලබා ගනියි\",\n  \"AcceleratorRange.EightG|block\": \"8g\",\n  \"AcceleratorRange.FourG\": \"ත්වරකය ගුරුත්වය 4ක් වන තෙක් මිනුම් ලබා ගනියි\",\n  \"AcceleratorRange.FourG|block\": \"4g\",\n  \"AcceleratorRange.OneG\": \"ත්වරකය ගුරුත්වය 1ක් වන තෙක් මිනුම් ලබා ගනියි\",\n  \"AcceleratorRange.OneG|block\": \"1g\",\n  \"AcceleratorRange.TwoG\": \"ත්වරකය ගුරුත්වය 2ක් වන තෙක් මිනුම් ලබා ගනියි\",\n  \"AcceleratorRange.TwoG|block\": \"2g\",\n  \"AnalogPin.P11|block\": \"P11 (write only)\",\n  \"AnalogPin.P12|block\": \"P12 (write only)\",\n  \"AnalogPin.P13|block\": \"P13 (write only)\",\n  \"AnalogPin.P14|block\": \"P14 (write only)\",\n  \"AnalogPin.P15|block\": \"P15 (write only)\",\n  \"AnalogPin.P16|block\": \"P16 (write only)\",\n  \"AnalogPin.P19|block\": \"P19 (write only)\",\n  \"AnalogPin.P20|block\": \"P20 (write only)\",\n  \"AnalogPin.P5|block\": \"P5 (write only)\",\n  \"AnalogPin.P6|block\": \"P6 (write only)\",\n  \"AnalogPin.P7|block\": \"P7 (write only)\",\n  \"AnalogPin.P8|block\": \"P8 (write only)\",\n  \"AnalogPin.P9|block\": \"P9 (write only)\",\n  \"BaudRate.BaudRate115200|block\": \"115200\",\n  \"BaudRate.BaudRate9600|block\": \"9600\",\n  \"BeatFraction.Breve|block\": \"4\",\n  \"BeatFraction.Double|block\": \"2\",\n  \"BeatFraction.Eighth|block\": \"1/8\",\n  \"BeatFraction.Half|block\": \"1/2\",\n  \"BeatFraction.Quarter|block\": \"1/4\",\n  \"BeatFraction.Sixteenth|block\": \"1/16\",\n  \"BeatFraction.Whole|block\": \"1\",\n  \"Button.AB|block\": \"A+B\",\n  \"Delimiters.Colon|block\": \":\",\n  \"Delimiters.Comma|block\": \",\",\n  \"Delimiters.Dollar|block\": \"$\",\n  \"Delimiters.Fullstop|block\": \".\",\n  \"Delimiters.Hash|block\": \"#\",\n  \"Delimiters.NewLine|block\": \"නව පෙළ\",\n  \"Dimension.Strength|block\": \"ප්‍රබලතාව\",\n  \"Dimension.X|block\": \"x\",\n  \"Dimension.Y|block\": \"y\",\n  \"Dimension.Z|block\": \"z\",\n  \"Direction.Left|block\": \"වම\",\n  \"Direction.Right|block\": \"දකුණ\",\n  \"DisplayMode.BackAndWhite|block\": \"කළු සහ සුදු\",\n  \"DisplayMode.Greyscale|block\": \"greyscale\",\n  \"EventCreationMode.CreateAndFire\": \"MicroBitEvent is initialised, and its event handlers are immediately fired (not suitable for use in interrupts!).\",\n  \"EventCreationMode.CreateOnly\": \"MicroBitEvent is initialised, and no further processing takes place.\",\n  \"Gesture.EightG\": \"Raised when a 8G shock is detected\",\n  \"Gesture.EightG|block\": \"8g\",\n  \"Gesture.FreeFall\": \"පුවරුව වැටෙන විට ඇති කරන්න!\",\n  \"Gesture.FreeFall|block\": \"නිදහස් වැටීම\",\n  \"Gesture.LogoDown\": \"සංකේතය යටි අතට ඇති විට සහ තිරය සිරස්ව පිහිටි විට ඇති කරන්න\",\n  \"Gesture.LogoDown|block\": \"ලාංඡනය පහළට\",\n  \"Gesture.LogoUp\": \"සංකේතය උඩු අතට ඇති විට සහ තිරය සිරස්ව පිහිටි විට ඇති කරන්න\",\n  \"Gesture.LogoUp|block\": \"ලාංඡනය ඉහලට\",\n  \"Gesture.ScreenDown\": \"තිරය ඉහලට යොමු වී ඇති විට සහ පුවරුව තිරස්ව ඇති විට ඇති කරන්න\",\n  \"Gesture.ScreenDown|block\": \"තිරය පහලට\",\n  \"Gesture.ScreenUp\": \"තිරය පහලට යොමු වී ඇති විට සහ පුවරුව තිරස්ව ඇති විට ඇති කරන්න\",\n  \"Gesture.ScreenUp|block\": \"තිරය ඉහලට\",\n  \"Gesture.Shake\": \"සෙලවුන විට ඇති කරන්න\",\n  \"Gesture.Shake|block\": \"සොලවන්න\",\n  \"Gesture.SixG\": \"6G කම්පනයක් අනාවරණය වූ විට ඇති කරන්න\",\n  \"Gesture.SixG|block\": \"6g\",\n  \"Gesture.ThreeG\": \"3G කම්පනයක් අනාවරණය වූ විට ඇති කරන්න\",\n  \"Gesture.ThreeG|block\": \"3g\",\n  \"Gesture.TiltLeft\": \"තිරය වමට යොමු වී ඇති විට ඇති කරන්න\",\n  \"Gesture.TiltLeft|block\": \"වමට ඇල කරන්න\",\n  \"Gesture.TiltRight\": \"තිරය දකුණට යොමු වී ඇති විට ඇති කරන්න\",\n  \"Gesture.TiltRight|block\": \"දකුණට ඇල කරන්න\",\n  \"IconNames.Angry|block\": \"angry\",\n  \"IconNames.Asleep|block\": \"asleep\",\n  \"IconNames.Butterfly|block\": \"butterfly\",\n  \"IconNames.Chessboard|block\": \"chess board\",\n  \"IconNames.Confused|block\": \"confused\",\n  \"IconNames.Cow|block\": \"cow\",\n  \"IconNames.Diamond|block\": \"diamond\",\n  \"IconNames.Duck|block\": \"duck\",\n  \"IconNames.EigthNote|block\": \"eigth note\",\n  \"IconNames.Fabulous|block\": \"fabulous\",\n  \"IconNames.Ghost|block\": \"ghost\",\n  \"IconNames.Giraffe|block\": \"giraffe\",\n  \"IconNames.Happy|block\": \"happy\",\n  \"IconNames.Heart|block\": \"heart\",\n  \"IconNames.House|block\": \"house\",\n  \"IconNames.LeftTriangle|block\": \"left triangle\",\n  \"IconNames.Meh|block\": \"meh\",\n  \"IconNames.No|block\": \"no\",\n  \"IconNames.Pitchfork|block\": \"pitchfork\",\n  \"IconNames.QuarterNote|block\": \"quarter note\",\n  \"IconNames.Rabbit|block\": \"rabbit\",\n  \"IconNames.Rollerskate|block\": \"roller skate\",\n  \"IconNames.Sad|block\": \"sad\",\n  \"IconNames.Scissors|block\": \"scissors\",\n  \"IconNames.Silly|block\": \"silly\",\n  \"IconNames.Skull|block\": \"skull\",\n  \"IconNames.SmallDiamond|block\": \"small diamond\",\n  \"IconNames.SmallHeart|block\": \"small heart\",\n  \"IconNames.SmallSquare|block\": \"small square\",\n  \"IconNames.Snake|block\": \"snake\",\n  \"IconNames.Square|block\": \"square\",\n  \"IconNames.StickFigure|block\": \"stick figure\",\n  \"IconNames.Surprised|block\": \"surprised\",\n  \"IconNames.Sword|block\": \"sword\",\n  \"IconNames.TShirt|block\": \"t-shirt\",\n  \"IconNames.Target|block\": \"target\",\n  \"IconNames.Tortoise|block\": \"tortoise\",\n  \"IconNames.Triangle|block\": \"triangle\",\n  \"IconNames.Umbrella|block\": \"umbrella\",\n  \"IconNames.Yes|block\": \"yes\",\n  \"LedSpriteProperty.Blink|block\": \"බබලනවා\",\n  \"LedSpriteProperty.Brightness|block\": \"දීප්තිමත් බව\",\n  \"LedSpriteProperty.Direction|block\": \"දිශාව\",\n  \"LedSpriteProperty.X|block\": \"x\",\n  \"LedSpriteProperty.Y|block\": \"y\",\n  \"Math.randomBoolean|block\": \"අහඹු ලෙස සත්‍යය හෝ අසත්‍යය තෝරන්න\",\n  \"Math|block\": \"ගණිත\",\n  \"Melodies.BaDing|block\": \"ba ding\",\n  \"Melodies.Baddy|block\": \"baddy\",\n  \"Melodies.Birthday|block\": \"birthday\",\n  \"Melodies.Blues|block\": \"blues\",\n  \"Melodies.Chase|block\": \"chase\",\n  \"Melodies.Dadadadum|block\": \"dadadum\",\n  \"Melodies.Entertainer|block\": \"entertainer\",\n  \"Melodies.Funeral|block\": \"funereal\",\n  \"Melodies.Funk|block\": \"funk\",\n  \"Melodies.JumpDown|block\": \"jump down\",\n  \"Melodies.JumpUp|block\": \"jump up\",\n  \"Melodies.Nyan|block\": \"nyan\",\n  \"Melodies.Ode|block\": \"ode\",\n  \"Melodies.PowerDown|block\": \"power down\",\n  \"Melodies.PowerUp|block\": \"power up\",\n  \"Melodies.Prelude|block\": \"prelude\",\n  \"Melodies.Punchline|block\": \"punchline\",\n  \"Melodies.Ringtone|block\": \"ringtone\",\n  \"Melodies.Wawawawaa|block\": \"wawawawaa\",\n  \"Melodies.Wedding|block\": \"wedding\",\n  \"MelodyOptions.ForeverInBackground|block\": \"forever in background\",\n  \"MelodyOptions.Forever|block\": \"සදහටම\",\n  \"MelodyOptions.OnceInBackground|block\": \"once in background\",\n  \"MelodyOptions.Once|block\": \"once\",\n  \"Note.CSharp3|block\": \"C#3\",\n  \"Note.CSharp4|block\": \"C#4\",\n  \"Note.CSharp5|block\": \"C#5\",\n  \"Note.CSharp|block\": \"C#\",\n  \"Note.FSharp3|block\": \"F#3\",\n  \"Note.FSharp4|block\": \"F#4\",\n  \"Note.FSharp5|block\": \"F#5\",\n  \"Note.FSharp|block\": \"F#\",\n  \"Note.GSharp3|block\": \"G#3\",\n  \"Note.GSharp4|block\": \"G#4\",\n  \"Note.GSharp5|block\": \"G#5\",\n  \"Note.GSharp|block\": \"G#\",\n  \"PinEventType.Edge|block\": \"අයින\",\n  \"PinEventType.None|block\": \"none\",\n  \"PinEventType.Pulse|block\": \"ස්පන්දන\",\n  \"PinEventType.Touch|block\": \"ස්පර්ශ\",\n  \"PinPullMode.PullDown|block\": \"පහළ\",\n  \"PinPullMode.PullNone|block\": \"none\",\n  \"PinPullMode.PullUp|block\": \"ඉහල\",\n  \"PulseValue.High|block\": \"උසස්\",\n  \"PulseValue.Low|block\": \"අඩු\",\n  \"Rotation.Pitch|block\": \"pitch\",\n  \"Rotation.Roll|block\": \"roll\",\n  \"String.charAt|block\": \"char from %this=text|at %pos\",\n  \"String.compare|block\": \"compare %this=text| to %that\",\n  \"String.fromCharCode|block\": \"text from char code %code\",\n  \"String.substr|block\": \"substring of %this=text|from %start|of length %length\",\n  \"String|block\": \"String\",\n  \"basic.clearScreen|block\": \"තිරය පැහැදිලි කරන්න\",\n  \"basic.forever|block\": \"සදහටම\",\n  \"basic.pause|block\": \"pause (ms) %pause\",\n  \"basic.showIcon|block\": \"show icon %i\",\n  \"basic.showLeds|block\": \"led පෙන්වන්න\",\n  \"basic.showNumber|block\": \"පෙන්වන්න|අංකය %number\",\n  \"basic.showString|block\": \"show|string %text\",\n  \"basic|block\": \"මූලික\",\n  \"control.inBackground|block\": \"පසුබිම තුල ධාවනය කරන්න\",\n  \"control.reset|block\": \"යලි පිහිටුවන්න\",\n  \"control.waitMicros|block\": \"wait (µs)%micros\",\n  \"control|block\": \"පාලනය\",\n  \"game.addScore|block\": \"change score by|%points\",\n  \"game.gameOver|block\": \"ක්‍රීඩාව අවසන්\",\n  \"game.score|block\": \"ලකුණු\",\n  \"game.setScore|block\": \"ලකුණු %points සකසන්න\",\n  \"game.startCountdown|block\": \"ගණනය ආරම්භ කරන්න |(ms) %duration\",\n  \"game|block\": \"ක්‍රීඩාව\",\n  \"images.createBigImage|block\": \"පින්තූර සකසන්න\",\n  \"images.createImage|block\": \"පින්තූර සකසන්න\",\n  \"images|block\": \"පින්තූර\",\n  \"input.acceleration|block\": \"ත්වරණය (mg)|%NAME\",\n  \"input.buttonIsPressed|block\": \"බොත්තම |%NAME| එබිලද\",\n  \"input.compassHeading|block\": \"මාලිමා ශීර්ෂය (°)\",\n  \"input.lightLevel|block\": \"ආලෝක තත්වය\",\n  \"input.magneticForce|block\": \"චුම්බක බලය (µT)|%NAME\",\n  \"input.onButtonPressed|block\": \"on button|%NAME|pressed\",\n  \"input.onGesture|block\": \"on |%NAME\",\n  \"input.onPinPressed|block\": \"on pin %name|pressed\",\n  \"input.onPinReleased|block\": \"on pin %NAME|released\",\n  \"input.pinIsPressed|block\": \"pin %NAME|is pressed\",\n  \"input.rotation|block\": \"භ්‍රමනය (°)|%NAME\",\n  \"input.runningTime|block\": \"දුවන කාලය (ms)\",\n  \"input.setAccelerometerRange|block\": \"ත්වරණමානය සකසන්න |range %range\",\n  \"input.temperature|block\": \"උෂ්ණත්වය (°C)\",\n  \"input|block\": \"ආදානය\",\n  \"led.brightness|block\": \"දීප්තිමත් බව\",\n  \"led.enable|block\": \"led enable %on\",\n  \"led.plotBarGraph|block\": \"plot bar graph of %value |up to %high\",\n  \"led.plot|block\": \"plot|x %x|y %y\",\n  \"led.point|block\": \"point|x %x|y %y\",\n  \"led.setBrightness|block\": \"බැබලීම සකසන්න %value\",\n  \"led.stopAnimation|block\": \"සජීවීකරණ නතර කරන්න\",\n  \"led.toggle|block\": \"toggle|x %x|y %y\",\n  \"led.unplot|block\": \"unplot|x %x|y %y\",\n  \"led|block\": \"led\",\n  \"music.beat|block\": \"%fraction|beat\",\n  \"music.builtInMelody|block\": \"%melody\",\n  \"music.changeTempoBy|block\": \"තාල වේගය (bpm)|%value කින් වෙනස් කරන්න\",\n  \"music.noteFrequency|block\": \"%note\",\n  \"music.playTone|block\": \"play|tone %note=device_note|for %duration=device_beat\",\n  \"music.rest|block\": \"rest(ms)|%duration=device_beat\",\n  \"music.ringTone|block\": \"ring tone (Hz)|%note=device_note\",\n  \"music.setTempo|block\": \"set tempo to (bpm)|%value\",\n  \"music.tempo|block\": \"තාල වේගය (bpm)\",\n  \"music|block\": \"සංගීතය\",\n  \"pins.analogPitch|block\": \"analog pitch %frequency|for (ms) %ms\",\n  \"pins.analogReadPin|block\": \"analog read|pin %name\",\n  \"pins.analogSetPeriod|block\": \"analog set period|pin %pin|to (µs)%micros\",\n  \"pins.analogSetPitchPin|block\": \"analog set pitch pin %name\",\n  \"pins.analogWritePin|block\": \"analog write|pin %name|to %value\",\n  \"pins.digitalReadPin|block\": \"digital read|pin %name\",\n  \"pins.digitalWritePin|block\": \"digital write|pin %name|to %value\",\n  \"pins.map|block\": \"map %value|from low %fromLow|from high %fromHigh|to low %toLow|to high %toHigh\",\n  \"pins.onPulsed|block\": \"on|pin %pin|pulsed %pulse\",\n  \"pins.pulseDuration|block\": \"ස්පන්දන පැවතුම් කාලය (µs)\",\n  \"pins.servoSetPulse|block\": \"servo set pulse|pin %value|to (µs) %micros\",\n  \"pins.servoWritePin|block\": \"servo write|pin %name|to %value\",\n  \"pins.setEvents|block\": \"set pin %pin|to emit %type|events\",\n  \"pins.setPull|block\": \"set pull|pin %pin|to %pull\",\n  \"pins.spiWrite|block\": \"spi write %value\",\n  \"pins|block\": \"කූරු\",\n  \"serial.onDataReceived|block\": \"serial|on data received %delimiters=serial_delimiter_conv\",\n  \"serial.readLine|block\": \"serial|read line\",\n  \"serial.readString|block\": \"serial|read string\",\n  \"serial.readUntil|block\": \"serial|read until %delimiter=serial_delimiter_conv\",\n  \"serial.redirect|block\": \"serial|redirect to|TX %tx|RX %rx|at baud rate %rate\",\n  \"serial.writeLine|block\": \"serial|write line %text\",\n  \"serial.writeNumber|block\": \"serial|write number %value\",\n  \"serial.writeString|block\": \"serial|write string %text\",\n  \"serial.writeValue|block\": \"serial|write value %name|= %value\",\n  \"serial|block\": \"අනුක්‍රමික\",\n  \"{id:category}Basic\": \"මූලික\",\n  \"{id:category}Control\": \"පාලනය\",\n  \"{id:category}Game\": \"ක්‍රීඩාව\",\n  \"{id:category}Images\": \"පින්තූර\",\n  \"{id:category}Input\": \"ආදානය\",\n  \"{id:category}Led\": \"Led\",\n  \"{id:category}Math\": \"ගණිත\",\n  \"{id:category}Music\": \"සංගීතය\",\n  \"{id:category}Pins\": \"කූරු\",\n  \"{id:category}Serial\": \"අනුක්‍රමික\",\n  \"{id:category}String\": \"String\"\n}",
      "_locales/sv-SE/core-jsdoc-strings.json": "{\n  \"Math.abs\": \"Returnerar absolutbeloppet av ett tal (värdet utan hänsyn till huruvida det är positivt eller negativt). \\nTill exempel är absolutbeloppet av -5 detsamma som absolutbeloppet av 5.\",\n  \"Math.max\": \"Returnerar det större av två givna numeriska uttryck.\",\n  \"Math.min\": \"Returnerar det mindre av två givna numeriska uttryck.\",\n  \"Math.randomBoolean\": \"Genererar ett värde \\\"sant\\\" eller \\\"falskt\\\" slumpmässigt, precis som när man singlar slant.\",\n  \"String.fromCharCode\": \"Gör en sträng från den givna ASCII-teckenkoden.\",\n  \"basic\": \"Ger tillgång till grundläggande micro:bit funktionalitet.\",\n  \"basic.clearScreen\": \"Stäng av alla lysdioder\",\n  \"basic.forever\": \"Repetera koden för alltid i bakgrunden. För varje iteration, kan annan kod köra.\",\n  \"basic.pause\": \"Pausa under angiven tid i millisekunder\",\n  \"basic.pause|param|ms\": \"hur lång pausen är, t. ex.: 100, 200, 500, 1000, 2000\",\n  \"basic.plotLeds\": \"Ritar en bild på LED-skärmen.\",\n  \"basic.plotLeds|param|leds\": \"mönster av lysdioder att slå på/av\",\n  \"basic.showAnimation\": \"Visar en sekvens av LED-skärmar som en animering.\",\n  \"basic.showAnimation|param|interval\": \"tid i millisekunder mellan varje omritning\",\n  \"basic.showAnimation|param|leds\": \"mönster av lysdioder att slå på/av\",\n  \"basic.showLeds\": \"Ritar en bild på LED-skärmen.\",\n  \"basic.showLeds|param|interval\": \"tid i millisekunder för att pausa efter ritning\",\n  \"basic.showLeds|param|leds\": \"mönstret av lysdioder att slå på/av\",\n  \"basic.showNumber\": \"Skrollar ett nummer på skärmen. Om numret passar på skärmen (dvs. är en enda siffra), skrolla inte.\",\n  \"basic.showNumber|param|interval\": \"hastigheten på rullningen; t. ex.: 150, 100, 200, -100\",\n  \"basic.showString\": \"Visa text på displayen, ett tecken i taget. Om strängen får plats på skärmen (dvs. är en enda bokstav), skrolla inte.\",\n  \"basic.showString|param|interval\": \"hastighet på teckenbyte; t. ex.: 150, 100, 200, -100\",\n  \"basic.showString|param|text\": \"texten att rullas på skärmen, t. ex.: \\\"Hej!\\\"\",\n  \"control\": \"Verktyg för runtime och händelser.\",\n  \"control.inBackground\": \"Schemalägger kod som körs i bakgrunden.\",\n  \"control.reset\": \"Återställer BBC micro:bit.\",\n  \"control.waitMicros\": \"Blockerar den aktuella fibern i antal angivna mikrosekunder\",\n  \"control.waitMicros|param|micros\": \"antal mikro-sekunder att vänta. t.ex.: 4\",\n  \"game\": \"En enstaka LED sprite spelmotor\",\n  \"game.startCountdown\": \"Startar en spel timer\",\n  \"game.startCountdown|param|ms\": \"nedräkningstid i millisekunder, t.ex.: 10000\",\n  \"images\": \"Skapandet, manipulation och visning av LED bilder.\",\n  \"images.createBigImage\": \"Skapar en bild med 2 ramar.\",\n  \"images.createImage\": \"Skapar en bild som passar på LED-skärmen.\",\n  \"input\": \"Händelser och data från sensorer\",\n  \"input.acceleration\": \"Få acceleration värdet i milli-gravitys (när brädet ligger platt med skärmen upp, x=0, y=0 och z=-1024)\",\n  \"input.buttonIsPressed\": \"Få knapp tillståndet (tryckt eller inte) för ``A`` och ``B``.\",\n  \"input.buttonIsPressed|param|button\": \"knappen att skicka begäran om, t.ex.: Button.A\",\n  \"input.compassHeading\": \"Få aktuell kompass riktning i grader.\",\n  \"input.lightLevel\": \"Läser in ljusnivån som träffar LED-skärmen i ett intervall från '' 0'' (mörkt) till '' 255'' ljust.\",\n  \"input.magneticForce\": \"Få magnetisk kraft värdet i ``mikro-Teslas`` (``µT``). Denna funktion stöds inte i simulatorn.\",\n  \"input.onButtonPressed\": \"Göra något när du trycker på en knapp (``A``, ``B`` eller båda ``A+B``)\",\n  \"input.onButtonPressed|param|body\": \"kod att köra när knappen trycks\",\n  \"input.onPinPressed\": \"Gör något när du trycker på en pin.\",\n  \"input.onPinPressed|param|body\": \"koden som körs när en pin är tryckt\",\n  \"input.onPinPressed|param|name\": \"den pin som måste tryckas, t.ex.: TouchPin.P0\",\n  \"input.onPinReleased\": \"Gör något när en pin är släppt.\",\n  \"input.onPinReleased|param|body\": \"koden som körs när en pin är släppt\",\n  \"input.onPinReleased|param|name\": \"den pin som behöver släppas, t.ex.: TouchPin.P0\",\n  \"input.onScreenDown\": \"Fäster kod att köras när skärmen är vänd nedåt.\",\n  \"input.onScreenUp\": \"Fäster kod att köras när skärmen är vänd uppåt.\",\n  \"input.onShake\": \"Fäster kod att köras när enheten skakas.\",\n  \"input.pinIsPressed\": \"Hämtar en pins tillstånd (tryckt eller inte). Krävs att man även håller på jord (\\\"GND\\\") för att sluta kretsen.\",\n  \"input.pinIsPressed|param|name\": \"den pin som används för att upptäcka vidrörning, t.ex: TouchPin.P0\",\n  \"led\": \"Kontroll av LED-skärmen.\",\n  \"led.enable\": \"Slår på eller av skärmen\",\n  \"led.plotAll\": \"Tänder alla lysdioder\",\n  \"led.plotBarGraph|param|value\": \"aktuella värdet att rita\",\n  \"led.screenshot\": \"Tar en skärmdump av LED-skärmen och returnerar en bild.\",\n  \"led.stopAnimation\": \"Avbryter den aktuella animationen och rensar andra väntande animationer.\",\n  \"led.toggleAll\": \"Inverterar den nuvarande LED-displayen\",\n  \"music.ringTone\": \"Spelar upp en ton genom pin ``P0``.\",\n  \"music.setTempo|param|bpm\": \"Det nya tempot i beats per minut, t.ex.: 120\"\n}",
      "_locales/sv-SE/core-strings.json": "{\n  \"AcceleratorRange.EightG\": \"Accelerometern mäter krafter upp till 8 g\",\n  \"AcceleratorRange.EightG|block\": \"8g\",\n  \"AcceleratorRange.FourG\": \"Accelerometern mäter krafter upp till 4 g\",\n  \"AcceleratorRange.FourG|block\": \"4g\",\n  \"AcceleratorRange.OneG\": \"Accelerometern mäter krafter upp till 1 g\",\n  \"AcceleratorRange.OneG|block\": \"1g\",\n  \"AcceleratorRange.TwoG\": \"Accelerometern mäter krafter upp till 2 g\",\n  \"AcceleratorRange.TwoG|block\": \"2g\",\n  \"BaudRate.BaudRate115200|block\": \"115200\",\n  \"BaudRate.BaudRate9600|block\": \"9600\",\n  \"BeatFraction.Breve|block\": \"4\",\n  \"BeatFraction.Double|block\": \"2\",\n  \"BeatFraction.Eighth|block\": \"1/8\",\n  \"BeatFraction.Half|block\": \"1/2\",\n  \"BeatFraction.Quarter|block\": \"1/4\",\n  \"BeatFraction.Sixteenth|block\": \"1/16\",\n  \"BeatFraction.Whole|block\": \"1\",\n  \"Button.AB|block\": \"A+B\",\n  \"Delimiters.Dollar|block\": \"$\",\n  \"Delimiters.Hash|block\": \"#\",\n  \"Delimiters.NewLine|block\": \"ny rad\",\n  \"Dimension.Strength|block\": \"styrka\",\n  \"Dimension.X|block\": \"x\",\n  \"Dimension.Y|block\": \"y\",\n  \"Dimension.Z|block\": \"z\",\n  \"Direction.Left|block\": \"vänster\",\n  \"Direction.Right|block\": \"höger\",\n  \"DisplayMode.BackAndWhite|block\": \"svartvitt\",\n  \"DisplayMode.Greyscale|block\": \"gråskala\",\n  \"EventCreationMode.CreateAndFire\": \"MicroBitEvent har initierats, och dess händelsehanterare exekveras omedelbart (ej lämpligt för användning inom avbrott!).\",\n  \"EventCreationMode.CreateOnly\": \"MicroBitEvent initierats, och ingen ytterligare bearbetning sker.\",\n  \"Gesture.EightG\": \"Aktiveras när en 8g stöt upptäcks\",\n  \"Gesture.EightG|block\": \"8g\",\n  \"Gesture.FreeFall\": \"Aktiveras när kortet faller!\",\n  \"Gesture.FreeFall|block\": \"fritt fall\",\n  \"Gesture.LogoDown\": \"Aktiveras när logotypen är nedåtvänd och skärmen är vertikal\",\n  \"Gesture.LogoDown|block\": \"logotyp ner\",\n  \"Gesture.LogoUp\": \"Aktiveras när logotypen är uppåtvänd och skärmen är vertikal\",\n  \"Gesture.LogoUp|block\": \"logotyp upp\",\n  \"Gesture.ScreenDown\": \"Aktiveras när skärmen pekar uppåt och kortet är horisontellt\",\n  \"Gesture.ScreenDown|block\": \"skärm ner\",\n  \"Gesture.ScreenUp\": \"Aktiveras när skärmen pekar nedåt och kortet är horisontellt\",\n  \"Gesture.ScreenUp|block\": \"skärm upp\",\n  \"Gesture.Shake\": \"Aktiveras när kortet skakas\",\n  \"Gesture.Shake|block\": \"skaka\",\n  \"Gesture.SixG\": \"Aktiveras när en 6g stöt upptäcks\",\n  \"Gesture.SixG|block\": \"6g\",\n  \"Gesture.ThreeG\": \"Aktiveras när en 3g stöt upptäcks\",\n  \"Gesture.ThreeG|block\": \"3g\",\n  \"Gesture.TiltLeft\": \"Aktiveras när skärmen pekar åt vänster\",\n  \"Gesture.TiltLeft|block\": \"luta vänster\",\n  \"Gesture.TiltRight\": \"Aktiveras när skärmen pekar åt höger\",\n  \"Gesture.TiltRight|block\": \"luta höger\",\n  \"LedSpriteProperty.Blink|block\": \"blinka\",\n  \"LedSpriteProperty.Brightness|block\": \"ljusstyrka\",\n  \"LedSpriteProperty.Direction|block\": \"riktning\",\n  \"LedSpriteProperty.X|block\": \"x\",\n  \"LedSpriteProperty.Y|block\": \"y\",\n  \"Math.randomBoolean|block\": \"välj slumpmässigt sant eller falskt\",\n  \"Math|block\": \"Matematik\",\n  \"MelodyOptions.Forever|block\": \"för alltid\",\n  \"Note.CSharp3|block\": \"C#3\",\n  \"Note.CSharp4|block\": \"C#4\",\n  \"Note.CSharp5|block\": \"C#5\",\n  \"Note.CSharp|block\": \"C#\",\n  \"Note.FSharp3|block\": \"F#3\",\n  \"Note.FSharp4|block\": \"F#4\",\n  \"Note.FSharp5|block\": \"F#5\",\n  \"Note.FSharp|block\": \"F#\",\n  \"Note.GSharp3|block\": \"G#3\",\n  \"Note.GSharp4|block\": \"G#4\",\n  \"Note.GSharp5|block\": \"G#5\",\n  \"Note.GSharp|block\": \"G#\",\n  \"PinPullMode.PullDown|block\": \"ner\",\n  \"PinPullMode.PullUp|block\": \"upp\",\n  \"PulseValue.High|block\": \"hög\",\n  \"PulseValue.Low|block\": \"låg\",\n  \"Rotation.Pitch|block\": \"lutningsgrad\",\n  \"Rotation.Roll|block\": \"roll\",\n  \"String.fromCharCode|block\": \"text från teckenkod %code\",\n  \"String|block\": \"Sträng\",\n  \"basic.clearScreen|block\": \"Rensa skärmen\",\n  \"basic.forever|block\": \"för alltid\",\n  \"basic.pause|block\": \"pausa (ms) %pause\",\n  \"basic.showLeds|block\": \"visa lysdioder\",\n  \"basic.showNumber|block\": \"visa|nummer %number\",\n  \"basic.showString|block\": \"visa|sträng %text\",\n  \"basic|block\": \"grundläggande\",\n  \"control.inBackground|block\": \"kör i bakgrunden\",\n  \"control.reset|block\": \"återställ\",\n  \"control.waitMicros|block\": \"vänta (µs)%micros\",\n  \"control|block\": \"kontroll\",\n  \"game.addScore|block\": \"ändra poäng med|%points\",\n  \"game.gameOver|block\": \"spelet är slut\",\n  \"game.score|block\": \"poäng\",\n  \"game.setScore|block\": \"ställa in poäng %points\",\n  \"game.startCountdown|block\": \"börja nedräkning|(ms) %duration\",\n  \"game|block\": \"spel\",\n  \"images.createBigImage|block\": \"skapa stor bild\",\n  \"images.createImage|block\": \"skapa bild\",\n  \"images|block\": \"bilder\",\n  \"input.acceleration|block\": \"acceleration (mg) |%NAME\",\n  \"input.buttonIsPressed|block\": \"knapp|%NAME|trycks\",\n  \"input.compassHeading|block\": \"kompassriktning (°)\",\n  \"input.lightLevel|block\": \"ljusnivå\",\n  \"input.magneticForce|block\": \"magnetisk kraft (µT) |%NAME\",\n  \"input.onButtonPressed|block\": \"när knapp|%NAME|trycks\",\n  \"input.onGesture|block\": \"när |%NAME\",\n  \"input.onPinPressed|block\": \"när pin %name|trycks\",\n  \"input.onPinReleased|block\": \"när pin %NAME|släpps\",\n  \"input.pinIsPressed|block\": \"pin %NAME|är tryckt\",\n  \"input.rotation|block\": \"rotation (°)|%NAME\",\n  \"input.runningTime|block\": \"körtid (ms)\",\n  \"input.setAccelerometerRange|block\": \"ange accelerometer|räckvidd %range\",\n  \"input.temperature|block\": \"temperatur (° C)\",\n  \"input|block\": \"input\",\n  \"led.brightness|block\": \"ljusstyrka\",\n  \"led.enable|block\": \"led aktivera %on\",\n  \"led.plotBarGraph|block\": \"rita diagram av %value|upp till %high\",\n  \"led.plot|block\": \"tänd|x %x|y %y\",\n  \"led.point|block\": \"punkt|x %x|y %y\",\n  \"led.setBrightness|block\": \"ställa in ljusstyrka %value\",\n  \"led.stopAnimation|block\": \"avbryt animering\",\n  \"led.toggle|block\": \"växla|x %x|y %y\",\n  \"led.unplot|block\": \"släck|x %x|y %y\",\n  \"led|block\": \"led\",\n  \"music.beat|block\": \"%fraction|taktslag\",\n  \"music.changeTempoBy|block\": \"ändra tempo med (bpm)|%value\",\n  \"music.noteFrequency|block\": \"%note\",\n  \"music.playTone|block\": \"spela|ton %note=device_note|i %duration=device_beat\",\n  \"music.rest|block\": \"vila(ms)|%duration=device_beat\",\n  \"music.ringTone|block\": \"spela ton (Hz)|%note=device_note\",\n  \"music.setTempo|block\": \"ställ in tempo till (bpm)|%value\",\n  \"music.tempo|block\": \"tempo (bpm)\",\n  \"music|block\": \"musik\",\n  \"pins.analogPitch|block\": \"analog tonhöjd %frequency|för (ms) %ms\",\n  \"pins.analogReadPin|block\": \"analog läsa in|pin %name\",\n  \"pins.analogSetPeriod|block\": \"analog ställ in perioden|pin %pin|till (µs)%micros\",\n  \"pins.analogSetPitchPin|block\": \"analog ställ in tonhöjd pin %name\",\n  \"pins.analogWritePin|block\": \"analog skriv|pin %name|till %value\",\n  \"pins.digitalReadPin|block\": \"digital läsa in|pin %name\",\n  \"pins.digitalWritePin|block\": \"digital skriv|pin %name|till %value\",\n  \"pins.map|block\": \"mappa %value|från låg %fromLow|från hög %fromHigh|till låg %toLow|till hög %toHigh\",\n  \"pins.onPulsed|block\": \"när|pin %pin|pulserade %pulse\",\n  \"pins.pulseDuration|block\": \"pulslängd (µs)\",\n  \"pins.servoSetPulse|block\": \"servo ställa in puls|pin %value|till (µs) %micros\",\n  \"pins.servoWritePin|block\": \"servo skriv|pin %name|till %value\",\n  \"pins.setPull|block\": \"ställ in dra upp|pin %pin|till %pull\",\n  \"pins.spiWrite|block\": \"spi skriv %value\",\n  \"pins|block\": \"pins\",\n  \"serial.onDataReceived|block\": \"seriell|när data tas emot %delimiters=serial_delimiter_conv\",\n  \"serial.readLine|block\": \"seriell|läsa rad\",\n  \"serial.readString|block\": \"seriell|läsa sträng\",\n  \"serial.readUntil|block\": \"seriell|läsa tills %delimiter=serial_delimiter_conv\",\n  \"serial.redirect|block\": \"seriella omdirigera till|TX %tx|RX %rx|med baud rate %rate\",\n  \"serial.writeLine|block\": \"seriell|skriv rad %text\",\n  \"serial.writeNumber|block\": \"seriell|skriv nummer %value\",\n  \"serial.writeString|block\": \"seriell|skriv sträng %text\",\n  \"serial.writeValue|block\": \"seriell|skriv värdet %name|= %värde\",\n  \"serial|block\": \"seriell\",\n  \"{id:category}Basic\": \"Grundläggande\",\n  \"{id:category}Control\": \"Kontroll\",\n  \"{id:category}Game\": \"Spel\",\n  \"{id:category}Images\": \"Bilder\",\n  \"{id:category}Input\": \"Input\",\n  \"{id:category}Led\": \"Led\",\n  \"{id:category}Math\": \"Matematik\",\n  \"{id:category}Music\": \"Musik\",\n  \"{id:category}Pins\": \"Pins\",\n  \"{id:category}Serial\": \"Seriell\",\n  \"{id:category}String\": \"Sträng\"\n}",
      "basic.cpp": "#include \"pxt.h\"\n\n\n/**\n * Provides access to basic micro:bit functionality.\n */\n//% color=#0078D7 weight=100 icon=\"\\uf00a\"\nnamespace basic {\n\n    /**\n     * Scroll a number on the screen. If the number fits on the screen (i.e. is a single digit), do not scroll.\n     * @param interval speed of scroll; eg: 150, 100, 200, -100\n     */\n    //% help=basic/show-number\n    //% weight=96\n    //% blockId=device_show_number block=\"show|number %number\" blockGap=8\n    //% async\n    //% parts=\"ledmatrix\"\n    void showNumber(int value, int interval = 150) { \n      if (interval <= 0)\n        interval = 1;\n      ManagedString t(value);\n      if (value < 0 || value >= 10) {\n        uBit.display.scroll(t, interval);\n      } else {\n        uBit.display.printChar(t.charAt(0), interval * 5);\n      }\n    }\n\n    /**\n     * Draws an image on the LED screen.\n     * @param leds the pattern of LED to turn on/off\n     * @param interval time in milliseconds to pause after drawing\n     */\n    //% help=basic/show-leds \n    //% weight=95 blockGap=8\n    //% imageLiteral=1 async\n    //% blockId=device_show_leds\n    //% block=\"show leds\" icon=\"\\uf00a\"\n    //% parts=\"ledmatrix\"\n    void showLeds(ImageLiteral leds, int interval = 400) {\n      uBit.display.print(MicroBitImage(imageBytes(leds)), 0, 0, 0, interval);\n    }\n\n    /**\n     * Display text on the display, one character at a time. If the string fits on the screen (i.e. is one letter), does not scroll.\n     * @param text the text to scroll on the screen, eg: \"Hello!\"\n     * @param interval how fast to shift characters; eg: 150, 100, 200, -100\n     */\n    //% help=basic/show-string \n    //% weight=87 blockGap=8\n    //% block=\"show|string %text\" \n    //% async\n    //% blockId=device_print_message\n    //% parts=\"ledmatrix\"\n    void showString(StringData *text, int interval = 150) {\n      if (interval <= 0)\n        interval = 1;\n      ManagedString s(text);\n      int l = s.length();\n      if (l == 0) {\n        uBit.display.clear();\n        fiber_sleep(interval * 5);\n      } else if (l > 1) {\n        uBit.display.scroll(s, interval);\n      } else {\n        uBit.display.print(s.charAt(0), interval * 5);\n      }\n    }\n\n    /**\n     * Turn off all LEDs\n     */\n    //% help=basic/clear-screen weight=79\n    //% blockId=device_clear_display block=\"clear screen\"\n    //% parts=\"ledmatrix\"\n    //% advanced=true\n    void clearScreen() {\n      uBit.display.image.clear();\n    }\n\n    /**\n     * Shows a sequence of LED screens as an animation.\n     * @param leds pattern of LEDs to turn on/off\n     * @param interval time in milliseconds between each redraw\n     */\n    //% help=basic/show-animation imageLiteral=1 async\n    //% parts=\"ledmatrix\"\n    void showAnimation(ImageLiteral leds, int interval = 400) {\n      uBit.display.animate(MicroBitImage(imageBytes(leds)), interval, 5, 0, 0);\n    }\n\n    /**\n     * Draws an image on the LED screen.\n     * @param leds pattern of LEDs to turn on/off\n     */\n    //% help=basic/plot-leds weight=80\n    //% parts=\"ledmatrix\"\n    void plotLeds(ImageLiteral leds) {\n      MicroBitImage i(imageBytes(leds));\n      uBit.display.print(i, 0, 0, 0, 0);\n    }\n\n    void forever_stub(void *a) {\n      while (true) {\n        runAction0((Action)a);\n        fiber_sleep(20);\n      }\n    }\n\n    /**\n     * Repeats the code forever in the background. On each iteration, allows other codes to run.\n     * @param body code to execute\n     */\n    //% help=basic/forever weight=55 blockGap=8 blockAllowMultiple=1\n    //% blockId=device_forever block=\"forever\" icon=\"\\uf01e\"\n    void forever(Action a) {\n      if (a != 0) {\n        incr(a);\n        create_fiber(forever_stub, (void*)a);\n      }\n    }\n\n    /**\n     * Pause for the specified time in milliseconds\n     * @param ms how long to pause for, eg: 100, 200, 500, 1000, 2000\n     */\n    //% help=basic/pause weight=54\n    //% async block=\"pause (ms) %pause\"\n    //% blockId=device_pause icon=\"\\uf110\"\n    void pause(int ms) {\n      fiber_sleep(ms);\n    }\n}\n",
      "buffer.cpp": "#include \"pxt.h\"\n\n// keep in sync with github/pxt/pxtsim/libgeneric.ts\nenum class NumberFormat {\n    Int8LE = 1,\n    UInt8LE,\n    Int16LE,\n    UInt16LE,\n    Int32LE,\n    Int8BE,\n    UInt8BE,\n    Int16BE,\n    UInt16BE,\n    Int32BE,\n    // UInt32,\n};\n\n//% indexerGet=BufferMethods::getByte indexerSet=BufferMethods::setByte\nnamespace BufferMethods {\n    //%\n    int getByte(Buffer buf, int off) {\n        return max(ManagedBuffer(buf).getByte(off), 0);\n    }\n\n    //%\n    void setByte(Buffer buf, int off, int v) {\n        ManagedBuffer(buf).setByte(off, v);\n    }\n\n    //%\n    uint8_t *getBytes(Buffer buf) {\n        return buf->payload;\n    }\n\n    /**\n     * Write a number in specified format in the buffer.\n     */\n    //%\n    void setNumber(Buffer buf, NumberFormat format, int offset, int value)\n    {\n        int8_t i8;\n        uint8_t u8;\n        int16_t i16;\n        uint16_t u16;\n        int32_t i32;\n\n        ManagedBuffer b(buf);\n\n        // Assume little endian\n        #define WRITEBYTES(isz, swap) isz = value; b.writeBytes(offset, (uint8_t*)&isz, sizeof(isz), swap); break\n\n        switch (format) {\n        case NumberFormat::Int8LE: WRITEBYTES(i8, false);\n        case NumberFormat::UInt8LE: WRITEBYTES(u8, false);\n        case NumberFormat::Int16LE: WRITEBYTES(i16, false);\n        case NumberFormat::UInt16LE: WRITEBYTES(u16, false);\n        case NumberFormat::Int32LE: WRITEBYTES(i32, false);\n        case NumberFormat::Int8BE: WRITEBYTES(i8, true);\n        case NumberFormat::UInt8BE: WRITEBYTES(u8, true);\n        case NumberFormat::Int16BE: WRITEBYTES(i16, true);\n        case NumberFormat::UInt16BE: WRITEBYTES(u16, true);\n        case NumberFormat::Int32BE: WRITEBYTES(i32, true);\n        }\n    }\n\n    /**\n     * Read a number in specified format from the buffer.\n     */\n    //%\n    int getNumber(Buffer buf, NumberFormat format, int offset)\n    {\n        int8_t i8;\n        uint8_t u8;\n        int16_t i16;\n        uint16_t u16;\n        int32_t i32;\n\n        ManagedBuffer b(buf);\n\n        // Assume little endian\n        #define READBYTES(isz, swap) b.readBytes((uint8_t*)&isz, offset, sizeof(isz), swap); return isz\n\n        switch (format) {\n        case NumberFormat::Int8LE: READBYTES(i8, false);\n        case NumberFormat::UInt8LE: READBYTES(u8, false);\n        case NumberFormat::Int16LE: READBYTES(i16, false);\n        case NumberFormat::UInt16LE: READBYTES(u16, false);\n        case NumberFormat::Int32LE: READBYTES(i32, false);\n        case NumberFormat::Int8BE: READBYTES(i8, true);\n        case NumberFormat::UInt8BE: READBYTES(u8, true);\n        case NumberFormat::Int16BE: READBYTES(i16, true);\n        case NumberFormat::UInt16BE: READBYTES(u16, true);\n        case NumberFormat::Int32BE: READBYTES(i32, true);\n        }\n\n        return 0;\n    }\n\n    /** Returns the length of a Buffer object. */\n    //% property\n    int length(Buffer s) {\n        return s->length;\n    }\n\n    /**\n     * Fill (a fragment) of the buffer with given value.\n     */\n    //%\n    void fill(Buffer buf, int value, int offset = 0, int length = -1)\n    {\n        ManagedBuffer(buf).fill(value, offset, length);\n    }\n\n    /**\n     * Return a copy of a fragment of a buffer.\n     */\n    //%\n    Buffer slice(Buffer buf, int offset = 0, int length = -1)\n    {\n        return ManagedBuffer(buf).slice(offset, length).leakData();\n    }\n\n    /**\n     * Shift buffer left in place, with zero padding.\n     * @param offset number of bytes to shift; use negative value to shift right\n     * @param start start offset in buffer. Default is 0.\n     * @param length number of elements in buffer. If negative, length is set as the buffer length minus start. eg: -1\n     */\n    //%\n    void shift(Buffer buf, int offset, int start = 0, int length = -1)\n    {\n        ManagedBuffer(buf).shift(offset, start, length);\n    }\n\n    /**\n     * Rotate buffer left in place.\n     * @param offset number of bytes to shift; use negative value to shift right\n     * @param start start offset in buffer. Default is 0.\n     * @param length number of elements in buffer. If negative, length is set as the buffer length minus start. eg: -1\n     */\n    //%\n    void rotate(Buffer buf, int offset, int start = 0, int length = -1)\n    {\n        ManagedBuffer(buf).rotate(offset, start, length);\n    }\n\n    // int readBytes(uint8_t *dst, int offset, int length, bool swapBytes = false) const;\n    // int writeBytes(int dstOffset, uint8_t *src, int length, bool swapBytes = false);\n\n    /**\n     * Write contents of `src` at `dstOffset` in current buffer.\n     */\n    //%\n    void write(Buffer buf, int dstOffset, Buffer src)\n    {\n        //Not supported, we only do up to 4 args :/\n        //void write(Buffer buf, int dstOffset, Buffer src, int srcOffset = 0, int length = -1)\n        ManagedBuffer(buf).writeBuffer(dstOffset, ManagedBuffer(src), 0, -1);\n    }\n}\n",
      "control.cpp": "#include \"pxt.h\"\n\n/**\n * How to create the event.\n */\nenum class EventCreationMode {\n    /**\n     * MicroBitEvent is initialised, and no further processing takes place.\n     */\n    CreateOnly = CREATE_ONLY,\n    /**\n     * MicroBitEvent is initialised, and its event handlers are immediately fired (not suitable for use in interrupts!).\n     */\n    CreateAndFire = CREATE_AND_FIRE,\n};\n\n// note the trailing '_' in names - otherwise we get conflict with the pre-processor\n// this trailing underscore is removed by enums.d.ts generation process\n\n// TODO shouldn't these be renamed to something more sensible anyways?\n\nenum EventBusSource {\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_BUTTON_A_ = MICROBIT_ID_BUTTON_A,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_BUTTON_B_ = MICROBIT_ID_BUTTON_B,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_BUTTON_AB_ = MICROBIT_ID_BUTTON_AB,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_RADIO_ = MICROBIT_ID_RADIO,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_GESTURE_ = MICROBIT_ID_GESTURE,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_ACCELEROMETER_ = MICROBIT_ID_ACCELEROMETER,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P0_ = MICROBIT_ID_IO_P0,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P1_ = MICROBIT_ID_IO_P1,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P2_ = MICROBIT_ID_IO_P2,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P3_ = MICROBIT_ID_IO_P3,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P4_ = MICROBIT_ID_IO_P4,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P5_ = MICROBIT_ID_IO_P5,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P6_ = MICROBIT_ID_IO_P6,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P7_ = MICROBIT_ID_IO_P7,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P8_ = MICROBIT_ID_IO_P8,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P9_ = MICROBIT_ID_IO_P9,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P10_ = MICROBIT_ID_IO_P10,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P11_ = MICROBIT_ID_IO_P11,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P12_ = MICROBIT_ID_IO_P12,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P13_ = MICROBIT_ID_IO_P13,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P14_ = MICROBIT_ID_IO_P14,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P15_ = MICROBIT_ID_IO_P15,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P16_ = MICROBIT_ID_IO_P16,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P19_ = MICROBIT_ID_IO_P19,\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P20_ = MICROBIT_ID_IO_P20,\n    //% blockIdentity=\"control.eventSourceId\"\n    MES_DEVICE_INFO_ID_ = MES_DEVICE_INFO_ID,\n    //% blockIdentity=\"control.eventSourceId\"\n    MES_SIGNAL_STRENGTH_ID_ = MES_SIGNAL_STRENGTH_ID,\n    //% blockIdentity=\"control.eventSourceId\"\n    MES_DPAD_CONTROLLER_ID_ = MES_DPAD_CONTROLLER_ID,\n    //% blockIdentity=\"control.eventSourceId\"\n    MES_BROADCAST_GENERAL_ID_ = MES_BROADCAST_GENERAL_ID,\n};\n\nenum EventBusValue {\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_EVT_ANY_ = MICROBIT_EVT_ANY,\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_BUTTON_EVT_DOWN_ = MICROBIT_BUTTON_EVT_DOWN,\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_BUTTON_EVT_UP_ = MICROBIT_BUTTON_EVT_UP,\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_BUTTON_EVT_CLICK_ = MICROBIT_BUTTON_EVT_CLICK,\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_RADIO_EVT_DATAGRAM_ = MICROBIT_RADIO_EVT_DATAGRAM,\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_ACCELEROMETER_EVT_DATA_UPDATE_ = MICROBIT_ACCELEROMETER_EVT_DATA_UPDATE,\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_PIN_EVT_RISE_ = MICROBIT_PIN_EVT_RISE,\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_PIN_EVT_FALL_ = MICROBIT_PIN_EVT_FALL,\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_PIN_EVT_PULSE_HI_ = MICROBIT_PIN_EVT_PULSE_HI,\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_PIN_EVT_PULSE_LO_ = MICROBIT_PIN_EVT_PULSE_LO,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_ALARM1_ = MES_ALERT_EVT_ALARM1,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_ALARM2_ = MES_ALERT_EVT_ALARM2,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_ALARM3_ = MES_ALERT_EVT_ALARM3,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_ALARM4_ = MES_ALERT_EVT_ALARM4,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_ALARM5_ = MES_ALERT_EVT_ALARM5,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_ALARM6_ = MES_ALERT_EVT_ALARM6,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_DISPLAY_TOAST_ = MES_ALERT_EVT_DISPLAY_TOAST,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_FIND_MY_PHONE_ = MES_ALERT_EVT_FIND_MY_PHONE,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_PLAY_RINGTONE_ = MES_ALERT_EVT_PLAY_RINGTONE,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_PLAY_SOUND_ = MES_ALERT_EVT_PLAY_SOUND,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_VIBRATE_ = MES_ALERT_EVT_VIBRATE,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_LAUNCH_PHOTO_MODE_ = MES_CAMERA_EVT_LAUNCH_PHOTO_MODE,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_LAUNCH_VIDEO_MODE_ = MES_CAMERA_EVT_LAUNCH_VIDEO_MODE,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_START_VIDEO_CAPTURE_ = MES_CAMERA_EVT_START_VIDEO_CAPTURE,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_STOP_PHOTO_MODE_ = MES_CAMERA_EVT_STOP_PHOTO_MODE,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_STOP_VIDEO_CAPTURE_ = MES_CAMERA_EVT_STOP_VIDEO_CAPTURE,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_STOP_VIDEO_MODE_ = MES_CAMERA_EVT_STOP_VIDEO_MODE,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_TAKE_PHOTO_ = MES_CAMERA_EVT_TAKE_PHOTO,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_TOGGLE_FRONT_REAR_ = MES_CAMERA_EVT_TOGGLE_FRONT_REAR,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_DISPLAY_OFF_ = MES_DEVICE_DISPLAY_OFF,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_DISPLAY_ON_ = MES_DEVICE_DISPLAY_ON,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_GESTURE_DEVICE_SHAKEN_ = MES_DEVICE_GESTURE_DEVICE_SHAKEN,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_INCOMING_CALL_ = MES_DEVICE_INCOMING_CALL,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_INCOMING_MESSAGE_ = MES_DEVICE_INCOMING_MESSAGE,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_ORIENTATION_LANDSCAPE_ = MES_DEVICE_ORIENTATION_LANDSCAPE,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_ORIENTATION_PORTRAIT_ = MES_DEVICE_ORIENTATION_PORTRAIT,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_1_DOWN_ = MES_DPAD_BUTTON_1_DOWN,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_1_UP_ = MES_DPAD_BUTTON_1_UP,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_2_DOWN_ = MES_DPAD_BUTTON_2_DOWN,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_2_UP_ = MES_DPAD_BUTTON_2_UP,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_3_DOWN_ = MES_DPAD_BUTTON_3_DOWN,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_3_UP_ = MES_DPAD_BUTTON_3_UP,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_4_DOWN_ = MES_DPAD_BUTTON_4_DOWN,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_4_UP_ = MES_DPAD_BUTTON_4_UP,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_A_DOWN_ = MES_DPAD_BUTTON_A_DOWN,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_A_UP_ = MES_DPAD_BUTTON_A_UP,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_B_DOWN_ = MES_DPAD_BUTTON_B_DOWN,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_B_UP_ = MES_DPAD_BUTTON_B_UP,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_C_DOWN_ = MES_DPAD_BUTTON_C_DOWN,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_C_UP_ = MES_DPAD_BUTTON_C_UP,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_D_DOWN_ = MES_DPAD_BUTTON_D_DOWN,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_D_UP_ = MES_DPAD_BUTTON_D_UP,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_FORWARD_ = MES_REMOTE_CONTROL_EVT_FORWARD,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_NEXTTRACK_ = MES_REMOTE_CONTROL_EVT_NEXTTRACK,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_PAUSE_ = MES_REMOTE_CONTROL_EVT_PAUSE,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_PLAY_ = MES_REMOTE_CONTROL_EVT_PLAY,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_PREVTRACK_ = MES_REMOTE_CONTROL_EVT_PREVTRACK,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_REWIND_ = MES_REMOTE_CONTROL_EVT_REWIND,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_STOP_ = MES_REMOTE_CONTROL_EVT_STOP,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_VOLUMEDOWN_ = MES_REMOTE_CONTROL_EVT_VOLUMEDOWN,\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_VOLUMEUP_ = MES_REMOTE_CONTROL_EVT_VOLUMEUP,\n};\n\n//% weight=1 color=\"#333333\"\n//% advanced=true\nnamespace control {\n    void fiberDone(void *a)\n    {\n      decr((Action)a);\n      release_fiber();\n    }\n\n    /**\n     * Schedules code that run in the background.\n     */\n    //% help=control/in-background blockAllowMultiple=1\n    //% blockId=\"control_in_background\" block=\"run in background\" blockGap=8\n    void inBackground(Action a) {\n      runInBackground(a);\n    }\n\n    /**\n     * Resets the BBC micro:bit.\n     */\n    //% weight=30 async help=control/reset blockGap=8\n    //% blockId=\"control_reset\" block=\"reset\"\n    void reset() {\n      microbit_reset();\n    }\n\n    /**\n    * Blocks the current fiber for the given microseconds\n    * @param micros number of micro-seconds to wait. eg: 4\n    */\n    //% help=control/wait-micros weight=29\n    //% blockId=\"control_wait_us\" block=\"wait (µs)%micros\"\n    void waitMicros(int micros) {\n        wait_us(micros);\n    }\n\n    /**\n     * Raises an event in the event bus.\n     * @param src ID of the MicroBit Component that generated the event e.g. MICROBIT_ID_BUTTON_A.\n     * @param value Component specific code indicating the cause of the event.\n     * @param mode optional definition of how the event should be processed after construction (default is CREATE_AND_FIRE).\n     */\n    //% weight=21 blockGap=12 blockId=\"control_raise_event\" block=\"raise event|from source %src=control_event_source_id|with value %value=control_event_value_id\" blockExternalInputs=1\n    //% help=control/raise-event\n    //% mode.defl=CREATE_AND_FIRE\n    void raiseEvent(int src, int value, EventCreationMode mode) {\n        MicroBitEvent evt(src, value, (MicroBitEventLaunchMode)mode);\n    }\n\n    /**\n     * Raises an event in the event bus.\n     */\n    //% weight=20 blockGap=8 blockId=\"control_on_event\" block=\"on event|from %src=control_event_source_id|with value %value=control_event_value_id\"\n    //% help=control/on-event\n    //% blockExternalInputs=1\n    void onEvent(int src, int value, Action handler) {\n        registerWithDal(src, value, handler);\n    }\n\n    /**\n    * Gets the value of the last event executed on the bus\n    */\n    //% blockId=control_event_value\" block=\"event value\"\n    //% help=control/event-value\n    //% weight=18\n    int eventValue() {\n        return pxt::lastEvent.value;\n    }\n\n    /**\n    * Gets the timestamp of the last event executed on the bus\n    */\n    //% blockId=control_event_timestamp\" block=\"event timestamp\"\n    //% help=control/event-timestamp\n    //% weight=19 blockGap=8\n    int eventTimestamp() {\n        return pxt::lastEvent.timestamp;\n    }\n\n    /**\n     * Gets a friendly name for the device derived from the its serial number\n     */\n    //% blockId=\"control_device_name\" block=\"device name\" weight=10 blockGap=8\n    //% advanced=true\n    StringData* deviceName() {\n        return ManagedString(microbit_friendly_name()).leakData();\n    }\n\n    /**\n    * Derive a unique, consistent serial number of this device from internal data.\n    */\n    //% blockId=\"control_device_serial_number\" block=\"device serial number\" weight=9\n    //% advanced=true\n    int deviceSerialNumber() {\n        return microbit_serial_number();\n    }\n}\n",
      "control.ts": "/**\n* Runtime and event utilities.\n*/\n//% weight=1 color=\"#333333\" icon=\"\\uf233\"\n//% advanced=true\nnamespace control {\n\n    /**\n     * Returns the value of a C++ runtime constant\n     */\n    //% weight=2 weight=19 blockId=\"control_event_source_id\" block=\"%id\" blockGap=8\n    //% shim=TD_ID advanced=true\n    export function eventSourceId(id: EventBusSource): number {\n        return id;\n    }\n    /**\n     * Returns the value of a C++ runtime constant\n     */\n    //% weight=1 weight=19 blockId=\"control_event_value_id\" block=\"%id\"\n    //% shim=TD_ID advanced=true\n    export function eventValueId(id: EventBusValue): number {\n        return id;\n    }\n\n    /**\n     * Display specified error code and stop the program.\n     */\n    //% shim=pxtrt::panic\n    export function panic(code: number) { }\n\n    /**\n     * If the condition is false, display msg on serial console, and panic with code 098.\n     */\n    export function assert(condition: boolean, msg?: string) {\n        if (!condition) {\n            console.log(\"ASSERTION FAILED\")\n            if (msg != null) {\n                console.log(msg)\n            }\n            panic(98)\n        }\n    }\n\n    /**\n     * Display warning in the simulator.\n     */\n    //% shim=pxtrt::runtimeWarning\n    export function runtimeWarning(message: string) { }\n}\n",
      "core.cpp": "#include \"pxt.h\"\n#include <limits.h>\n\n\nnamespace String_ {\n    //%\n    StringData *charAt(StringData *s, int pos) {\n      return ManagedString((char)ManagedString(s).charAt(pos)).leakData();\n    }\n\n    //%\n    int charCodeAt(StringData *s, int index) {\n        return ManagedString(s).charAt(index);\n    }\n\n    //%\n    StringData *concat(StringData *s, StringData *other) {\n      ManagedString a(s), b(other);\n      return (a + b).leakData();\n    }\n\n    //%\n    int compare(StringData *s, StringData *that) {\n      int compareResult = strcmp(s->data, that->data);\n      if (compareResult < 0)\n        return -1;\n      else if (compareResult > 0)\n        return 1;\n      return 0;\n    }\n\n    //%\n    int length(StringData *s) { return s->len; }\n\n    //%\n    StringData *fromCharCode(int code)\n    {\n      return ManagedString((char)code).leakData();\n    }\n\n    //%\n    int toNumber(StringData *s) {\n      return atoi(s->data);\n    }\n\n    //%\n    StringData *mkEmpty()\n    {\n        return ManagedString::EmptyString.leakData();\n    }\n\n    //%\n    StringData *substr(StringData *s, int start, int length)\n    {\n        if (length <= 0)\n            return mkEmpty();\n        if (start < 0)\n            start = max(s->len + start, 0);\n        length = min(length, s->len - start);\n        ManagedString x(s);\n        return x.substring(start, length).leakData();\n    }\n}\n\n\nnamespace Boolean_ {\n    // Cache the string literals \"true\" and \"false\" when used.\n    // Note that the representation of booleans stays the usual C-one.\n    \n    static const char sTrue[]  __attribute__ ((aligned (4))) = \"\\xff\\xff\\x04\\x00\" \"true\\0\";\n    static const char sFalse[] __attribute__ ((aligned (4))) = \"\\xff\\xff\\x05\\x00\" \"false\\0\";\n\n    //%\n    StringData* toString(bool v)\n    {\n      if (v) {\n        return (StringData*)(void*)sTrue;\n      } else {\n        return (StringData*)(void*)sFalse;\n      }            \n    }\n\n    //%\n    bool bang(int v) { return v == 0; }\n}\n\nnamespace Number_ {\n    //%\n    StringData* toString(int n)\n    {\n      return ManagedString(n).leakData();\n    }\n\n    // +, - and friends are handled directly by assembly instructions\n    // The comparisons are here as they are more code-size efficient\n    \n    //%\n    bool lt(int x, int y) { return x < y; }\n    //%\n    bool le(int x, int y) { return x <= y; }\n    //%\n    bool neq(int x, int y) { return x != y; }\n    //%\n    bool eq(int x, int y) { return x == y; }\n    //%\n    bool gt(int x, int y) { return x > y; }\n    //%\n    bool ge(int x, int y) { return x >= y; }\n\n    // These in fact call into C runtime on Cortex-M0 \n    //%\n    int div(int x, int y) { return x / y; }\n    //%\n    int mod(int x, int y) { return x % y; }\n}\n\nnamespace Math_ {\n    //%\n    int pow(int x, int y)\n    {\n      if (y < 0)\n        return 0;\n      int r = 1;\n      while (y) {\n        if (y & 1)\n          r *= x;\n        y >>= 1;\n        x *= x;\n      }\n      return r;\n    }\n    \n    //%\n    int random(int max) {\n      if (max == INT_MIN)\n        return -microbit_random(INT_MAX);\n      else if (max < 0)\n        return -microbit_random(-max);\n      else if (max == 0)\n        return 0;\n      else\n        return microbit_random(max);\n    }\n    \n    //%\n    int sqrt(int x)\n    {\n      return ::sqrt(x);\n    }\n}\n\nnamespace Array_ {\n    //%\n    RefCollection *mk(uint32_t flags)\n    {\n      return new RefCollection(flags);\n    }\n    //%\n    int length(RefCollection *c) { return c->length(); }\n    //%\n    void setLength(RefCollection *c, int newLength) { c->setLength(newLength); }    \n    //%\n    void push(RefCollection *c, uint32_t x) { c->push(x); }\n    //%\n    uint32_t pop(RefCollection *c) { return c->pop(); }    \n    //%\n    uint32_t getAt(RefCollection *c, int x) { return c->getAt(x); }\n    //%\n    void setAt(RefCollection *c, int x, uint32_t y) { c->setAt(x, y); }    \n    //%\n    uint32_t removeAt(RefCollection *c, int x) { return c->removeAt(x); }\n    //%\n    void insertAt(RefCollection *c, int x, uint32_t value) { c->insertAt(x, value); }    \n    //%\n    int indexOf(RefCollection *c, uint32_t x, int start) { return c->indexOf(x, start); }\n    //%\n    int removeElement(RefCollection *c, uint32_t x) { return c->removeElement(x); }\n}\n\n\n// Import some stuff directly\nnamespace pxt {\n  //%\n  void registerWithDal(int id, int event, Action a);\n  //%\n  uint32_t runAction3(Action a, int arg0, int arg1, int arg2);\n  //%\n  uint32_t runAction2(Action a, int arg0, int arg1);\n  //%\n  uint32_t runAction1(Action a, int arg0);\n  //%\n  uint32_t runAction0(Action a);\n  //%\n  Action mkAction(int reflen, int totallen, int startptr);\n  //%\n  RefRecord* mkClassInstance(int offset);\n  //%\n  void RefRecord_destroy(RefRecord *r);\n  //%\n  void RefRecord_print(RefRecord *r);\n  //%\n  void debugMemLeaks();\n  //%\n  int incr(uint32_t e);\n  //%\n  void decr(uint32_t e);\n  //%\n  uint32_t *allocate(uint16_t sz);\n  //%\n  int templateHash();\n  //%\n  int programHash();\n  //%\n  void *ptrOfLiteral(int offset);\n  //%\n  int getNumGlobals();\n\n  //%\n  uint32_t programSize() {\n    return bytecode[17] * 2;\n  }\n\n  //%\n  uint32_t afterProgramPage() {\n    uint32_t ptr = (uint32_t)&bytecode[0];\n    ptr += programSize();\n    if (ptr % PAGE_SIZE != 0)\n      ptr = (ptr & ~(PAGE_SIZE-1)) + PAGE_SIZE;\n    return ptr;\n  }\n}\n\nnamespace pxtrt {\n  //%\n  uint32_t ldloc(RefLocal *r) {\n    return r->v;\n  }\n\n  //%\n  uint32_t ldlocRef(RefRefLocal *r) {\n    uint32_t tmp = r->v;\n    incr(tmp);\n    return tmp;\n  }\n\n  //%\n  void stloc(RefLocal *r, uint32_t v) {\n    r->v = v;\n  }\n\n  //%\n  void stlocRef(RefRefLocal *r, uint32_t v) {\n    decr(r->v);\n    r->v = v;\n  }\n\n  //%\n  RefLocal *mkloc() {\n    return new RefLocal();\n  }\n\n  //%\n  RefRefLocal *mklocRef() {\n    return new RefRefLocal();\n  }\n\n  // All of the functions below unref() self. This is for performance reasons -\n  // the code emitter will not emit the unrefs for them.\n \n  //%\n  uint32_t ldfld(RefRecord *r, int idx) {\n    auto tmp = r->ld(idx);\n    r->unref();\n    return tmp;\n  }\n\n  //%\n  uint32_t ldfldRef(RefRecord *r, int idx) {\n    auto tmp = r->ldref(idx);\n    r->unref();\n    return tmp;\n  }\n\n  //%\n  void stfld(RefRecord *r, int idx, uint32_t val) {\n    r->st(idx, val);\n    r->unref();\n  }\n\n  //%\n  void stfldRef(RefRecord *r, int idx, uint32_t val) {\n    r->stref(idx, val);\n    r->unref();\n  }\n\n  // Store a captured local in a closure. It returns the action, so it can be chained.\n  //%\n  RefAction *stclo(RefAction *a, int idx, uint32_t v)\n  {\n    //DBG(\"STCLO \"); a->print(); DBG(\"@%d = %p\\n\", idx, (void*)v);\n    a->stCore(idx, v);\n    return a;\n  }\n\n  //%\n  void panic(int code)\n  {\n    microbit_panic(code);\n  }\n\n  //%\n  int stringToBool(StringData *s) {\n    if (s == NULL) return 0;\n    if (s->len == 0) {\n      s->decr();\n      return 0;\n    }\n    s->decr();\n    return 1;\n  }\n\n  //%\n  StringData* emptyToNull(StringData *s) {\n    if (!s || s->len == 0)\n      return NULL;\n    return s;\n  }\n\n  //%\n  int ptrToBool(uint32_t p) {\n    if (p) {\n      decr(p);\n      return 1;\n    } else {\n      return 0;\n    }\n  }\n\n  //%\n  RefMap *mkMap() {\n    return new RefMap();\n  }\n\n  //%\n  uint32_t mapGet(RefMap *map, uint32_t key) {\n    int i = map->findIdx(key);\n    if (i < 0) {\n      map->unref();\n      return 0;\n    }\n    uint32_t r = map->data[i].val;\n    map->unref();\n    return r;\n  }\n\n  //%\n  uint32_t mapGetRef(RefMap *map, uint32_t key) {\n    int i = map->findIdx(key);\n    if (i < 0) {\n      map->unref();\n      return 0;\n    }\n    uint32_t r = incr(map->data[i].val);\n    map->unref();\n    return r;\n  }\n\n  //%\n  void mapSet(RefMap *map, uint32_t key, uint32_t val) {\n    int i = map->findIdx(key);\n    if (i < 0) {\n      map->data.push_back({\n        key << 1,\n        val\n      });\n    } else {\n      if (map->data[i].key & 1) {\n        decr(map->data[i].val);\n        map->data[i].key = key << 1;\n      }\n      map->data[i].val = val;\n    }\n    map->unref();\n  }\n\n  //%\n  void mapSetRef(RefMap *map, uint32_t key, uint32_t val) {\n    int i = map->findIdx(key);\n    if (i < 0) {\n      map->data.push_back({\n        (key << 1) | 1,\n        val\n      });\n    } else {\n      if (map->data[i].key & 1) {\n        decr(map->data[i].val);\n      } else {\n        map->data[i].key = (key << 1) | 1;\n      }\n      map->data[i].val = val;\n    }\n    map->unref();      \n  }\n\n  //\n  // Debugger\n  //\n\n  //%\n  void* getGlobalsPtr() {\n    return globals;\n  }\n\n  //%\n  void runtimeWarning(StringData *s) {\n    // noop for now\n  }\n}\n",
      "dal.d.ts": "// Auto-generated. Do not edit.\ndeclare const enum DAL {\n    // built/yt/yotta_modules/microbit-dal/inc/bluetooth/ExternalEvents.h\n    MICROBIT_ID_BLE = 1000,\n    MICROBIT_ID_BLE_UART = 1200,\n    MICROBIT_BLE_EVT_CONNECTED = 1,\n    MICROBIT_BLE_EVT_DISCONNECTED = 2,\n    // built/yt/yotta_modules/microbit-dal/inc/bluetooth/MESEvents.h\n    MES_REMOTE_CONTROL_ID = 1001,\n    MES_REMOTE_CONTROL_EVT_PLAY = 1,\n    MES_REMOTE_CONTROL_EVT_PAUSE = 2,\n    MES_REMOTE_CONTROL_EVT_STOP = 3,\n    MES_REMOTE_CONTROL_EVT_NEXTTRACK = 4,\n    MES_REMOTE_CONTROL_EVT_PREVTRACK = 5,\n    MES_REMOTE_CONTROL_EVT_FORWARD = 6,\n    MES_REMOTE_CONTROL_EVT_REWIND = 7,\n    MES_REMOTE_CONTROL_EVT_VOLUMEUP = 8,\n    MES_REMOTE_CONTROL_EVT_VOLUMEDOWN = 9,\n    MES_CAMERA_ID = 1002,\n    MES_CAMERA_EVT_LAUNCH_PHOTO_MODE = 1,\n    MES_CAMERA_EVT_LAUNCH_VIDEO_MODE = 2,\n    MES_CAMERA_EVT_TAKE_PHOTO = 3,\n    MES_CAMERA_EVT_START_VIDEO_CAPTURE = 4,\n    MES_CAMERA_EVT_STOP_VIDEO_CAPTURE = 5,\n    MES_CAMERA_EVT_STOP_PHOTO_MODE = 6,\n    MES_CAMERA_EVT_STOP_VIDEO_MODE = 7,\n    MES_CAMERA_EVT_TOGGLE_FRONT_REAR = 8,\n    MES_ALERTS_ID = 1004,\n    MES_ALERT_EVT_DISPLAY_TOAST = 1,\n    MES_ALERT_EVT_VIBRATE = 2,\n    MES_ALERT_EVT_PLAY_SOUND = 3,\n    MES_ALERT_EVT_PLAY_RINGTONE = 4,\n    MES_ALERT_EVT_FIND_MY_PHONE = 5,\n    MES_ALERT_EVT_ALARM1 = 6,\n    MES_ALERT_EVT_ALARM2 = 7,\n    MES_ALERT_EVT_ALARM3 = 8,\n    MES_ALERT_EVT_ALARM4 = 9,\n    MES_ALERT_EVT_ALARM5 = 10,\n    MES_ALERT_EVT_ALARM6 = 11,\n    MES_SIGNAL_STRENGTH_ID = 1101,\n    MES_SIGNAL_STRENGTH_EVT_NO_BAR = 1,\n    MES_SIGNAL_STRENGTH_EVT_ONE_BAR = 2,\n    MES_SIGNAL_STRENGTH_EVT_TWO_BAR = 3,\n    MES_SIGNAL_STRENGTH_EVT_THREE_BAR = 4,\n    MES_SIGNAL_STRENGTH_EVT_FOUR_BAR = 5,\n    MES_DEVICE_INFO_ID = 1103,\n    MES_DEVICE_ORIENTATION_LANDSCAPE = 1,\n    MES_DEVICE_ORIENTATION_PORTRAIT = 2,\n    MES_DEVICE_GESTURE_NONE = 3,\n    MES_DEVICE_GESTURE_DEVICE_SHAKEN = 4,\n    MES_DEVICE_DISPLAY_OFF = 5,\n    MES_DEVICE_DISPLAY_ON = 6,\n    MES_DEVICE_INCOMING_CALL = 7,\n    MES_DEVICE_INCOMING_MESSAGE = 8,\n    MES_DPAD_CONTROLLER_ID = 1104,\n    MES_DPAD_BUTTON_A_DOWN = 1,\n    MES_DPAD_BUTTON_A_UP = 2,\n    MES_DPAD_BUTTON_B_DOWN = 3,\n    MES_DPAD_BUTTON_B_UP = 4,\n    MES_DPAD_BUTTON_C_DOWN = 5,\n    MES_DPAD_BUTTON_C_UP = 6,\n    MES_DPAD_BUTTON_D_DOWN = 7,\n    MES_DPAD_BUTTON_D_UP = 8,\n    MES_DPAD_BUTTON_1_DOWN = 9,\n    MES_DPAD_BUTTON_1_UP = 10,\n    MES_DPAD_BUTTON_2_DOWN = 11,\n    MES_DPAD_BUTTON_2_UP = 12,\n    MES_DPAD_BUTTON_3_DOWN = 13,\n    MES_DPAD_BUTTON_3_UP = 14,\n    MES_DPAD_BUTTON_4_DOWN = 15,\n    MES_DPAD_BUTTON_4_UP = 16,\n    MES_BROADCAST_GENERAL_ID = 2000,\n    // built/yt/yotta_modules/microbit-dal/inc/bluetooth/MicroBitAccelerometerService.h\n    // built/yt/yotta_modules/microbit-dal/inc/bluetooth/MicroBitBLEManager.h\n    MICROBIT_BLE_PAIR_REQUEST = 0x01,\n    MICROBIT_BLE_PAIR_COMPLETE = 0x02,\n    MICROBIT_BLE_PAIR_PASSCODE = 0x04,\n    MICROBIT_BLE_PAIR_SUCCESSFUL = 0x08,\n    MICROBIT_BLE_PAIRING_TIMEOUT = 90,\n    MICROBIT_BLE_POWER_LEVELS = 8,\n    MICROBIT_BLE_MAXIMUM_BONDS = 4,\n    MICROBIT_BLE_EDDYSTONE_ADV_INTERVAL = 400,\n    MICROBIT_BLE_EDDYSTONE_DEFAULT_POWER = 0xF0,\n    MICROBIT_BLE_STATUS_STORE_SYSATTR = 0x02,\n    MICROBIT_BLE_STATUS_DISCONNECT = 0x04,\n    MICROBIT_BLE_DISCONNECT_AFTER_PAIRING_DELAY = 500,\n    // built/yt/yotta_modules/microbit-dal/inc/bluetooth/MicroBitButtonService.h\n    // built/yt/yotta_modules/microbit-dal/inc/bluetooth/MicroBitDFUService.h\n    MICROBIT_DFU_OPCODE_START_DFU = 1,\n    MICROBIT_DFU_HISTOGRAM_WIDTH = 5,\n    MICROBIT_DFU_HISTOGRAM_HEIGHT = 5,\n    // built/yt/yotta_modules/microbit-dal/inc/bluetooth/MicroBitEddystone.h\n    // built/yt/yotta_modules/microbit-dal/inc/bluetooth/MicroBitEventService.h\n    // built/yt/yotta_modules/microbit-dal/inc/bluetooth/MicroBitIOPinService.h\n    MICROBIT_IO_PIN_SERVICE_PINCOUNT = 19,\n    MICROBIT_IO_PIN_SERVICE_DATA_SIZE = 10,\n    MICROBIT_PWM_PIN_SERVICE_DATA_SIZE = 2,\n    // built/yt/yotta_modules/microbit-dal/inc/bluetooth/MicroBitLEDService.h\n    MICROBIT_BLE_MAXIMUM_SCROLLTEXT = 20,\n    // built/yt/yotta_modules/microbit-dal/inc/bluetooth/MicroBitMagnetometerService.h\n    // built/yt/yotta_modules/microbit-dal/inc/bluetooth/MicroBitTemperatureService.h\n    // built/yt/yotta_modules/microbit-dal/inc/bluetooth/MicroBitUARTService.h\n    MICROBIT_UART_S_DEFAULT_BUF_SIZE = 20,\n    MICROBIT_UART_S_EVT_DELIM_MATCH = 1,\n    MICROBIT_UART_S_EVT_HEAD_MATCH = 2,\n    MICROBIT_UART_S_EVT_RX_FULL = 3,\n    // built/yt/yotta_modules/microbit-dal/inc/core/ErrorNo.h\n    MICROBIT_OK = 0,\n    MICROBIT_INVALID_PARAMETER = -1001,\n    MICROBIT_NOT_SUPPORTED = -1002,\n    MICROBIT_CALIBRATION_IN_PROGRESS = -1003,\n    MICROBIT_CALIBRATION_REQUIRED = -1004,\n    MICROBIT_NO_RESOURCES = -1005,\n    MICROBIT_BUSY = -1006,\n    MICROBIT_CANCELLED = -1007,\n    MICROBIT_I2C_ERROR = -1010,\n    MICROBIT_SERIAL_IN_USE = -1011,\n    MICROBIT_NO_DATA = -1012,\n    MICROBIT_OOM = 20,\n    MICROBIT_HEAP_ERROR = 30,\n    MICROBIT_NULL_DEREFERENCE = 40,\n    // built/yt/yotta_modules/microbit-dal/inc/core/EventModel.h\n    // built/yt/yotta_modules/microbit-dal/inc/core/MemberFunctionCallback.h\n    // built/yt/yotta_modules/microbit-dal/inc/core/MicroBitCompat.h\n    // built/yt/yotta_modules/microbit-dal/inc/core/MicroBitComponent.h\n    MICROBIT_ID_BUTTON_A = 1,\n    MICROBIT_ID_BUTTON_B = 2,\n    MICROBIT_ID_BUTTON_RESET = 3,\n    MICROBIT_ID_ACCELEROMETER = 4,\n    MICROBIT_ID_COMPASS = 5,\n    MICROBIT_ID_DISPLAY = 6,\n    MICROBIT_IO_PINS = 20,\n    MICROBIT_ID_IO_P0 = 7,\n    MICROBIT_ID_IO_P1 = 8,\n    MICROBIT_ID_IO_P2 = 9,\n    MICROBIT_ID_IO_P3 = 10,\n    MICROBIT_ID_IO_P4 = 11,\n    MICROBIT_ID_IO_P5 = 12,\n    MICROBIT_ID_IO_P6 = 13,\n    MICROBIT_ID_IO_P7 = 14,\n    MICROBIT_ID_IO_P8 = 15,\n    MICROBIT_ID_IO_P9 = 16,\n    MICROBIT_ID_IO_P10 = 17,\n    MICROBIT_ID_IO_P11 = 18,\n    MICROBIT_ID_IO_P12 = 19,\n    MICROBIT_ID_IO_P13 = 20,\n    MICROBIT_ID_IO_P14 = 21,\n    MICROBIT_ID_IO_P15 = 22,\n    MICROBIT_ID_IO_P16 = 23,\n    MICROBIT_ID_IO_P19 = 24,\n    MICROBIT_ID_IO_P20 = 25,\n    MICROBIT_ID_BUTTON_AB = 26,\n    MICROBIT_ID_GESTURE = 27,\n    MICROBIT_ID_THERMOMETER = 28,\n    MICROBIT_ID_RADIO = 29,\n    MICROBIT_ID_RADIO_DATA_READY = 30,\n    MICROBIT_ID_MULTIBUTTON_ATTACH = 31,\n    MICROBIT_ID_SERIAL = 32,\n    MICROBIT_ID_MESSAGE_BUS_LISTENER = 1021,\n    MICROBIT_ID_NOTIFY_ONE = 1022,\n    MICROBIT_ID_NOTIFY = 1023,\n    MICROBIT_COMPONENT_RUNNING = 0x01,\n    // built/yt/yotta_modules/microbit-dal/inc/core/MicroBitDevice.h\n    MICROBIT_NAME_LENGTH = 5,\n    MICROBIT_NAME_CODE_LETTERS = 5,\n    MICROBIT_PANIC_ERROR_CHARS = 4,\n    // built/yt/yotta_modules/microbit-dal/inc/core/MicroBitFiber.h\n    MICROBIT_SCHEDULER_RUNNING = 0x01,\n    MICROBIT_FIBER_FLAG_FOB = 0x01,\n    MICROBIT_FIBER_FLAG_PARENT = 0x02,\n    MICROBIT_FIBER_FLAG_CHILD = 0x04,\n    MICROBIT_FIBER_FLAG_DO_NOT_PAGE = 0x08,\n    // built/yt/yotta_modules/microbit-dal/inc/core/MicroBitFont.h\n    MICROBIT_FONT_WIDTH = 5,\n    MICROBIT_FONT_HEIGHT = 5,\n    MICROBIT_FONT_ASCII_START = 32,\n    MICROBIT_FONT_ASCII_END = 126,\n    // built/yt/yotta_modules/microbit-dal/inc/core/MicroBitHeapAllocator.h\n    MICROBIT_MAXIMUM_HEAPS = 2,\n    MICROBIT_HEAP_BLOCK_FREE = 0x80000000,\n    // built/yt/yotta_modules/microbit-dal/inc/core/MicroBitListener.h\n    MESSAGE_BUS_LISTENER_PARAMETERISED = 0x0001,\n    MESSAGE_BUS_LISTENER_METHOD = 0x0002,\n    MESSAGE_BUS_LISTENER_BUSY = 0x0004,\n    MESSAGE_BUS_LISTENER_REENTRANT = 0x0008,\n    MESSAGE_BUS_LISTENER_QUEUE_IF_BUSY = 0x0010,\n    MESSAGE_BUS_LISTENER_DROP_IF_BUSY = 0x0020,\n    MESSAGE_BUS_LISTENER_NONBLOCKING = 0x0040,\n    MESSAGE_BUS_LISTENER_URGENT = 0x0080,\n    MESSAGE_BUS_LISTENER_DELETING = 0x8000,\n    // built/yt/yotta_modules/microbit-dal/inc/core/MicroBitSystemTimer.h\n    // built/yt/yotta_modules/microbit-dal/inc/core/NotifyEvents.h\n    MICROBIT_DISPLAY_EVT_FREE = 1,\n    MICROBIT_SERIAL_EVT_TX_EMPTY = 2,\n    MICROBIT_UART_S_EVT_TX_EMPTY = 3,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/DynamicPwm.h\n    MICROBIT_DEFAULT_PWM_PERIOD = 20000,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitAccelerometer.h\n    MICROBIT_ACCEL_PITCH_ROLL_VALID = 0x02,\n    MICROBIT_ACCEL_ADDED_TO_IDLE = 0x04,\n    MMA8653_DEFAULT_ADDR = 0x3A,\n    MMA8653_STATUS = 0x00,\n    MMA8653_OUT_X_MSB = 0x01,\n    MMA8653_WHOAMI = 0x0D,\n    MMA8653_XYZ_DATA_CFG = 0x0E,\n    MMA8653_CTRL_REG1 = 0x2A,\n    MMA8653_CTRL_REG2 = 0x2B,\n    MMA8653_CTRL_REG3 = 0x2C,\n    MMA8653_CTRL_REG4 = 0x2D,\n    MMA8653_CTRL_REG5 = 0x2E,\n    MMA8653_WHOAMI_VAL = 0x5A,\n    MMA8653_SAMPLE_RANGES = 3,\n    MMA8653_SAMPLE_RATES = 8,\n    MICROBIT_ACCELEROMETER_EVT_DATA_UPDATE = 1,\n    MICROBIT_ACCELEROMETER_EVT_NONE = 0,\n    MICROBIT_ACCELEROMETER_EVT_TILT_UP = 1,\n    MICROBIT_ACCELEROMETER_EVT_TILT_DOWN = 2,\n    MICROBIT_ACCELEROMETER_EVT_TILT_LEFT = 3,\n    MICROBIT_ACCELEROMETER_EVT_TILT_RIGHT = 4,\n    MICROBIT_ACCELEROMETER_EVT_FACE_UP = 5,\n    MICROBIT_ACCELEROMETER_EVT_FACE_DOWN = 6,\n    MICROBIT_ACCELEROMETER_EVT_FREEFALL = 7,\n    MICROBIT_ACCELEROMETER_EVT_3G = 8,\n    MICROBIT_ACCELEROMETER_EVT_6G = 9,\n    MICROBIT_ACCELEROMETER_EVT_8G = 10,\n    MICROBIT_ACCELEROMETER_EVT_SHAKE = 11,\n    MICROBIT_ACCELEROMETER_REST_TOLERANCE = 200,\n    MICROBIT_ACCELEROMETER_TILT_TOLERANCE = 200,\n    MICROBIT_ACCELEROMETER_FREEFALL_TOLERANCE = 400,\n    MICROBIT_ACCELEROMETER_SHAKE_TOLERANCE = 400,\n    MICROBIT_ACCELEROMETER_3G_TOLERANCE = 3072,\n    MICROBIT_ACCELEROMETER_6G_TOLERANCE = 6144,\n    MICROBIT_ACCELEROMETER_8G_TOLERANCE = 8192,\n    MICROBIT_ACCELEROMETER_GESTURE_DAMPING = 5,\n    MICROBIT_ACCELEROMETER_SHAKE_DAMPING = 10,\n    MICROBIT_ACCELEROMETER_SHAKE_RTX = 30,\n    MICROBIT_ACCELEROMETER_SHAKE_COUNT_THRESHOLD = 4,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitButton.h\n    MICROBIT_BUTTON_EVT_DOWN = 1,\n    MICROBIT_BUTTON_EVT_UP = 2,\n    MICROBIT_BUTTON_EVT_CLICK = 3,\n    MICROBIT_BUTTON_EVT_LONG_CLICK = 4,\n    MICROBIT_BUTTON_EVT_HOLD = 5,\n    MICROBIT_BUTTON_EVT_DOUBLE_CLICK = 6,\n    MICROBIT_BUTTON_LONG_CLICK_TIME = 1000,\n    MICROBIT_BUTTON_HOLD_TIME = 1500,\n    MICROBIT_BUTTON_STATE = 1,\n    MICROBIT_BUTTON_STATE_HOLD_TRIGGERED = 2,\n    MICROBIT_BUTTON_STATE_CLICK = 4,\n    MICROBIT_BUTTON_STATE_LONG_CLICK = 8,\n    MICROBIT_BUTTON_SIGMA_MIN = 0,\n    MICROBIT_BUTTON_SIGMA_MAX = 12,\n    MICROBIT_BUTTON_SIGMA_THRESH_HI = 8,\n    MICROBIT_BUTTON_SIGMA_THRESH_LO = 2,\n    MICROBIT_BUTTON_DOUBLE_CLICK_THRESH = 50,\n    MICROBIT_BUTTON_SIMPLE_EVENTS = 0,\n    MICROBIT_BUTTON_ALL_EVENTS = 1,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitCompass.h\n    MAG3110_DEFAULT_ADDR = 0x1D,\n    MAG_DR_STATUS = 0x00,\n    MAG_OUT_X_MSB = 0x01,\n    MAG_OUT_X_LSB = 0x02,\n    MAG_OUT_Y_MSB = 0x03,\n    MAG_OUT_Y_LSB = 0x04,\n    MAG_OUT_Z_MSB = 0x05,\n    MAG_OUT_Z_LSB = 0x06,\n    MAG_WHOAMI = 0x07,\n    MAG_SYSMOD = 0x08,\n    MAG_OFF_X_MSB = 0x09,\n    MAG_OFF_X_LSB = 0x0A,\n    MAG_OFF_Y_MSB = 0x0B,\n    MAG_OFF_Y_LSB = 0x0C,\n    MAG_OFF_Z_MSB = 0x0D,\n    MAG_OFF_Z_LSB = 0x0E,\n    MAG_DIE_TEMP = 0x0F,\n    MAG_CTRL_REG1 = 0x10,\n    MAG_CTRL_REG2 = 0x11,\n    MAG3110_SAMPLE_RATES = 11,\n    MICROBIT_COMPASS_EVT_CAL_REQUIRED = 1,\n    MICROBIT_COMPASS_EVT_CAL_START = 2,\n    MICROBIT_COMPASS_EVT_CAL_END = 3,\n    MICROBIT_COMPASS_EVT_DATA_UPDATE = 4,\n    MICROBIT_COMPASS_EVT_CONFIG_NEEDED = 5,\n    MICROBIT_COMPASS_EVT_CALIBRATE = 6,\n    MICROBIT_COMPASS_STATUS_CALIBRATED = 2,\n    MICROBIT_COMPASS_STATUS_CALIBRATING = 4,\n    MICROBIT_COMPASS_STATUS_ADDED_TO_IDLE = 8,\n    MAG3110_WHOAMI_VAL = 0xC4,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitCompassCalibrator.h\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitDisplay.h\n    MICROBIT_DISPLAY_EVT_ANIMATION_COMPLETE = 1,\n    MICROBIT_DISPLAY_EVT_LIGHT_SENSE = 2,\n    MICROBIT_DISPLAY_DEFAULT_AUTOCLEAR = 1,\n    MICROBIT_DISPLAY_SPACING = 1,\n    MICROBIT_DISPLAY_GREYSCALE_BIT_DEPTH = 8,\n    MICROBIT_DISPLAY_ANIMATE_DEFAULT_POS = -255,\n    ANIMATION_MODE_NONE = 0,\n    ANIMATION_MODE_STOPPED = 1,\n    ANIMATION_MODE_SCROLL_TEXT = 2,\n    ANIMATION_MODE_PRINT_TEXT = 3,\n    ANIMATION_MODE_SCROLL_IMAGE = 4,\n    ANIMATION_MODE_ANIMATE_IMAGE = 5,\n    ANIMATION_MODE_ANIMATE_IMAGE_WITH_CLEAR = 6,\n    ANIMATION_MODE_PRINT_CHARACTER = 7,\n    DISPLAY_MODE_BLACK_AND_WHITE = 0,\n    DISPLAY_MODE_GREYSCALE = 1,\n    DISPLAY_MODE_BLACK_AND_WHITE_LIGHT_SENSE = 2,\n    MICROBIT_DISPLAY_ROTATION_0 = 0,\n    MICROBIT_DISPLAY_ROTATION_90 = 1,\n    MICROBIT_DISPLAY_ROTATION_180 = 2,\n    MICROBIT_DISPLAY_ROTATION_270 = 3,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitFile.h\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitFileSystem.h\n    MBFS_FILENAME_LENGTH = 16,\n    MB_READ = 0x01,\n    MB_WRITE = 0x02,\n    MB_CREAT = 0x04,\n    MB_APPEND = 0x08,\n    MB_SEEK_SET = 0x01,\n    MB_SEEK_END = 0x02,\n    MB_SEEK_CUR = 0x04,\n    MBFS_STATUS_INITIALISED = 0x01,\n    MBFS_UNUSED = 0xFFFF,\n    MBFS_EOF = 0xEFFF,\n    MBFS_DELETED = 0x0000,\n    MBFS_DIRECTORY_ENTRY_FREE = 0x8000,\n    MBFS_DIRECTORY_ENTRY_VALID = 0x4000,\n    MBFS_DIRECTORY_ENTRY_DIRECTORY = 0x2000,\n    MBFS_DIRECTORY_ENTRY_NEW = 0xffff,\n    MBFS_DIRECTORY_ENTRY_DELETED = 0x0000,\n    MBFS_BLOCK_TYPE_FILE = 1,\n    MBFS_BLOCK_TYPE_DIRECTORY = 2,\n    MBFS_BLOCK_TYPE_FILETABLE = 3,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitFlash.h\n    PAGE_SIZE = 1024,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitI2C.h\n    MICROBIT_I2C_MAX_RETRIES = 9,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitIO.h\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitLightSensor.h\n    MICROBIT_LIGHT_SENSOR_CHAN_NUM = 3,\n    MICROBIT_LIGHT_SENSOR_AN_SET_TIME = 4000,\n    MICROBIT_LIGHT_SENSOR_TICK_PERIOD = 5,\n    MICROBIT_LIGHT_SENSOR_MAX_VALUE = 338,\n    MICROBIT_LIGHT_SENSOR_MIN_VALUE = 75,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitMatrixMaps.h\n    NO_CONN = 0,\n    MICROBIT_DISPLAY_WIDTH = 5,\n    MICROBIT_DISPLAY_HEIGHT = 5,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitMessageBus.h\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitMultiButton.h\n    MICROBIT_MULTI_BUTTON_STATE_1 = 0x01,\n    MICROBIT_MULTI_BUTTON_STATE_2 = 0x02,\n    MICROBIT_MULTI_BUTTON_HOLD_TRIGGERED_1 = 0x04,\n    MICROBIT_MULTI_BUTTON_HOLD_TRIGGERED_2 = 0x08,\n    MICROBIT_MULTI_BUTTON_SUPRESSED_1 = 0X10,\n    MICROBIT_MULTI_BUTTON_SUPRESSED_2 = 0x20,\n    MICROBIT_MULTI_BUTTON_ATTACHED = 0x40,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitPin.h\n    IO_STATUS_DIGITAL_IN = 0x01,\n    IO_STATUS_DIGITAL_OUT = 0x02,\n    IO_STATUS_ANALOG_IN = 0x04,\n    IO_STATUS_ANALOG_OUT = 0x08,\n    IO_STATUS_TOUCH_IN = 0x10,\n    IO_STATUS_EVENT_ON_EDGE = 0x20,\n    IO_STATUS_EVENT_PULSE_ON_EDGE = 0x40,\n    MICROBIT_PIN_MAX_OUTPUT = 1023,\n    MICROBIT_PIN_MAX_SERVO_RANGE = 180,\n    MICROBIT_PIN_DEFAULT_SERVO_RANGE = 2000,\n    MICROBIT_PIN_DEFAULT_SERVO_CENTER = 1500,\n    MICROBIT_PIN_EVENT_NONE = 0,\n    MICROBIT_PIN_EVENT_ON_EDGE = 1,\n    MICROBIT_PIN_EVENT_ON_PULSE = 2,\n    MICROBIT_PIN_EVENT_ON_TOUCH = 3,\n    MICROBIT_PIN_EVT_RISE = 2,\n    MICROBIT_PIN_EVT_FALL = 3,\n    MICROBIT_PIN_EVT_PULSE_HI = 4,\n    MICROBIT_PIN_EVT_PULSE_LO = 5,\n    PIN_CAPABILITY_DIGITAL_IN = 0x01,\n    PIN_CAPABILITY_DIGITAL_OUT = 0x02,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitQuadratureDecoder.h\n    QDEC_USE_SYSTEM_TICK = 0x01,\n    QDEC_USE_DEBOUNCE = 0x02,\n    QDEC_LED_ACTIVE_LOW = 0x04,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitRadio.h\n    MICROBIT_RADIO_STATUS_INITIALISED = 0x0001,\n    MICROBIT_RADIO_BASE_ADDRESS = 0x75626974,\n    MICROBIT_RADIO_DEFAULT_GROUP = 0,\n    MICROBIT_RADIO_DEFAULT_TX_POWER = 6,\n    MICROBIT_RADIO_DEFAULT_FREQUENCY = 7,\n    MICROBIT_RADIO_MAX_PACKET_SIZE = 32,\n    MICROBIT_RADIO_HEADER_SIZE = 4,\n    MICROBIT_RADIO_MAXIMUM_RX_BUFFERS = 4,\n    MICROBIT_RADIO_PROTOCOL_DATAGRAM = 1,\n    MICROBIT_RADIO_PROTOCOL_EVENTBUS = 2,\n    MICROBIT_RADIO_EVT_DATAGRAM = 1,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitRadioDatagram.h\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitRadioEvent.h\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitSerial.h\n    MICROBIT_SERIAL_DEFAULT_BAUD_RATE = 115200,\n    MICROBIT_SERIAL_DEFAULT_BUFFER_SIZE = 20,\n    MICROBIT_SERIAL_EVT_DELIM_MATCH = 1,\n    MICROBIT_SERIAL_EVT_HEAD_MATCH = 2,\n    MICROBIT_SERIAL_EVT_RX_FULL = 3,\n    MICROBIT_SERIAL_RX_IN_USE = 1,\n    MICROBIT_SERIAL_TX_IN_USE = 2,\n    MICROBIT_SERIAL_RX_BUFF_INIT = 4,\n    MICROBIT_SERIAL_TX_BUFF_INIT = 8,\n    ASYNC = 0,\n    SYNC_SPINWAIT = 1,\n    SYNC_SLEEP = 2,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitStorage.h\n    MICROBIT_STORAGE_MAGIC = 0xCAFE,\n    MICROBIT_STORAGE_BLOCK_SIZE = 48,\n    MICROBIT_STORAGE_KEY_SIZE = 16,\n    MICROBIT_STORAGE_STORE_PAGE_OFFSET = 17,\n    MICROBIT_STORAGE_SCRATCH_PAGE_OFFSET = 19,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/MicroBitThermometer.h\n    MICROBIT_THERMOMETER_PERIOD = 1000,\n    MICROBIT_THERMOMETER_EVT_UPDATE = 1,\n    MICROBIT_THERMOMETER_ADDED_TO_IDLE = 2,\n    // built/yt/yotta_modules/microbit-dal/inc/drivers/TimedInterruptIn.h\n    // built/yt/yotta_modules/microbit-dal/inc/platform/yotta_cfg_mappings.h\n    // built/yt/yotta_modules/microbit-dal/inc/types/ManagedString.h\n    // built/yt/yotta_modules/microbit-dal/inc/types/ManagedType.h\n    // built/yt/yotta_modules/microbit-dal/inc/types/Matrix4.h\n    // built/yt/yotta_modules/microbit-dal/inc/types/MicroBitCoordinateSystem.h\n    RAW = 0,\n    SIMPLE_CARTESIAN = 1,\n    NORTH_EAST_DOWN = 2,\n    // built/yt/yotta_modules/microbit-dal/inc/types/MicroBitEvent.h\n    MICROBIT_ID_ANY = 0,\n    MICROBIT_EVT_ANY = 0,\n    CREATE_ONLY = 0,\n    CREATE_AND_FIRE = 1,\n    // built/yt/yotta_modules/microbit-dal/inc/types/MicroBitImage.h\n    // built/yt/yotta_modules/microbit-dal/inc/types/PacketBuffer.h\n    // built/yt/yotta_modules/microbit-dal/inc/types/RefCounted.h\n}\n",
      "enums.d.ts": "// Auto-generated. Do not edit.\ndeclare namespace images {\n}\ndeclare namespace basic {\n}\n\n\n    declare enum Button {\n    A = 1,  // MICROBIT_ID_BUTTON_A\n    B = 2,  // MICROBIT_ID_BUTTON_B\n    //% block=\"A+B\"\n    AB = 26,  // MICROBIT_ID_BUTTON_AB\n    }\n\n\n    declare enum Dimension {\n    //% block=x\n    X = 0,\n    //% block=y\n    Y = 1,\n    //% block=z\n    Z = 2,\n    //% block=strength\n    Strength = 3,\n    }\n\n\n    declare enum Rotation {\n    //% block=pitch\n    Pitch = 0,\n    //% block=roll\n    Roll = 1,\n    }\n\n\n    declare enum TouchPin {\n    P0 = 7,  // MICROBIT_ID_IO_P0\n    P1 = 8,  // MICROBIT_ID_IO_P1\n    P2 = 9,  // MICROBIT_ID_IO_P2\n    }\n\n\n    declare enum AcceleratorRange {\n    /**\n     * The accelerator measures forces up to 1 gravity\n     */\n    //%  block=\"1g\"\n    OneG = 1,\n    /**\n     * The accelerator measures forces up to 2 gravity\n     */\n    //%  block=\"2g\"\n    TwoG = 2,\n    /**\n     * The accelerator measures forces up to 4 gravity\n     */\n    //% block=\"4g\"\n    FourG = 4,\n    /**\n     * The accelerator measures forces up to 8 gravity\n     */\n    //% block=\"8g\"\n    EightG = 8,\n    }\n\n\n    declare enum Gesture {\n    /**\n     * Raised when shaken\n     */\n    //% block=shake\n    Shake = 11,  // MICROBIT_ACCELEROMETER_EVT_SHAKE\n    /**\n     * Raised when the logo is upward and the screen is vertical\n     */\n    //% block=\"logo up\"\n    LogoUp = 1,  // MICROBIT_ACCELEROMETER_EVT_TILT_UP\n    /**\n     * Raised when the logo is downward and the screen is vertical\n     */\n    //% block=\"logo down\"\n    LogoDown = 2,  // MICROBIT_ACCELEROMETER_EVT_TILT_DOWN\n    /**\n     * Raised when the screen is pointing down and the board is horizontal\n     */\n    //% block=\"screen up\"\n    ScreenUp = 5,  // MICROBIT_ACCELEROMETER_EVT_FACE_UP\n    /**\n     * Raised when the screen is pointing up and the board is horizontal\n     */\n    //% block=\"screen down\"\n    ScreenDown = 6,  // MICROBIT_ACCELEROMETER_EVT_FACE_DOWN\n    /**\n     * Raised when the screen is pointing left\n     */\n    //% block=\"tilt left\"\n    TiltLeft = 3,  // MICROBIT_ACCELEROMETER_EVT_TILT_LEFT\n    /**\n     * Raised when the screen is pointing right\n     */\n    //% block=\"tilt right\"\n    TiltRight = 4,  // MICROBIT_ACCELEROMETER_EVT_TILT_RIGHT\n    /**\n     * Raised when the board is falling!\n     */\n    //% block=\"free fall\"\n    FreeFall = 7,  // MICROBIT_ACCELEROMETER_EVT_FREEFALL\n    /**\n     * Raised when a 3G shock is detected\n     */\n    //% block=\"3g\"\n    ThreeG = 8,  // MICROBIT_ACCELEROMETER_EVT_3G\n    /**\n     * Raised when a 6G shock is detected\n     */\n    //% block=\"6g\"\n    SixG = 9,  // MICROBIT_ACCELEROMETER_EVT_6G\n    /**\n     * Raised when a 8G shock is detected\n     */\n    //% block=\"8g\"\n    EightG = 10,  // MICROBIT_ACCELEROMETER_EVT_8G\n    }\n\n\n    declare enum MesDpadButtonInfo {\n    //% block=\"A down\"\n    ADown = 1,  // MES_DPAD_BUTTON_A_DOWN\n    //% block=\"A up\"\n    AUp = 2,  // MES_DPAD_BUTTON_A_UP\n    //% block=\"B down\"\n    BDown = 3,  // MES_DPAD_BUTTON_B_DOWN\n    //% block=\"B up\"\n    BUp = 4,  // MES_DPAD_BUTTON_B_UP\n    //% block=\"C down\"\n    CDown = 5,  // MES_DPAD_BUTTON_C_DOWN\n    //% block=\"C up\"\n    CUp = 6,  // MES_DPAD_BUTTON_C_UP\n    //% block=\"D down\"\n    DDown = 7,  // MES_DPAD_BUTTON_D_DOWN\n    //% block=\"D up\"\n    DUp = 8,  // MES_DPAD_BUTTON_D_UP\n    //% block=\"1 down\"\n    _1Down = 9,  // MES_DPAD_BUTTON_1_DOWN\n    //% block=\"1 up\"\n    _1Up = 10,  // MES_DPAD_BUTTON_1_UP\n    //% block=\"2 down\"\n    _2Down = 11,  // MES_DPAD_BUTTON_2_DOWN\n    //% block=\"2 up\"\n    _2Up = 12,  // MES_DPAD_BUTTON_2_UP\n    //% block=\"3 down\"\n    _3Down = 13,  // MES_DPAD_BUTTON_3_DOWN\n    //% block=\"3 up\"\n    _3Up = 14,  // MES_DPAD_BUTTON_3_UP\n    //% block=\"4 down\"\n    _4Down = 15,  // MES_DPAD_BUTTON_4_DOWN\n    //% block=\"4 up\"\n    _4Up = 16,  // MES_DPAD_BUTTON_4_UP\n    }\ndeclare namespace input {\n}\n\n\n    /**\n     * How to create the event.\n     */\n\n    declare enum EventCreationMode {\n    /**\n     * MicroBitEvent is initialised, and no further processing takes place.\n     */\n    CreateOnly = 0,  // CREATE_ONLY\n    /**\n     * MicroBitEvent is initialised, and its event handlers are immediately fired (not suitable for use in interrupts!).\n     */\n    CreateAndFire = 1,  // CREATE_AND_FIRE\n    }\n\n\n    declare enum EventBusSource {\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_BUTTON_A = 1,  // MICROBIT_ID_BUTTON_A\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_BUTTON_B = 2,  // MICROBIT_ID_BUTTON_B\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_BUTTON_AB = 26,  // MICROBIT_ID_BUTTON_AB\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_RADIO = 29,  // MICROBIT_ID_RADIO\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_GESTURE = 27,  // MICROBIT_ID_GESTURE\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_ACCELEROMETER = 4,  // MICROBIT_ID_ACCELEROMETER\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P0 = 7,  // MICROBIT_ID_IO_P0\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P1 = 8,  // MICROBIT_ID_IO_P1\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P2 = 9,  // MICROBIT_ID_IO_P2\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P3 = 10,  // MICROBIT_ID_IO_P3\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P4 = 11,  // MICROBIT_ID_IO_P4\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P5 = 12,  // MICROBIT_ID_IO_P5\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P6 = 13,  // MICROBIT_ID_IO_P6\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P7 = 14,  // MICROBIT_ID_IO_P7\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P8 = 15,  // MICROBIT_ID_IO_P8\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P9 = 16,  // MICROBIT_ID_IO_P9\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P10 = 17,  // MICROBIT_ID_IO_P10\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P11 = 18,  // MICROBIT_ID_IO_P11\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P12 = 19,  // MICROBIT_ID_IO_P12\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P13 = 20,  // MICROBIT_ID_IO_P13\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P14 = 21,  // MICROBIT_ID_IO_P14\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P15 = 22,  // MICROBIT_ID_IO_P15\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P16 = 23,  // MICROBIT_ID_IO_P16\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P19 = 24,  // MICROBIT_ID_IO_P19\n    //% blockIdentity=\"control.eventSourceId\"\n    MICROBIT_ID_IO_P20 = 25,  // MICROBIT_ID_IO_P20\n    //% blockIdentity=\"control.eventSourceId\"\n    MES_DEVICE_INFO_ID = 1103,  // MES_DEVICE_INFO_ID\n    //% blockIdentity=\"control.eventSourceId\"\n    MES_SIGNAL_STRENGTH_ID = 1101,  // MES_SIGNAL_STRENGTH_ID\n    //% blockIdentity=\"control.eventSourceId\"\n    MES_DPAD_CONTROLLER_ID = 1104,  // MES_DPAD_CONTROLLER_ID\n    //% blockIdentity=\"control.eventSourceId\"\n    MES_BROADCAST_GENERAL_ID = 2000,  // MES_BROADCAST_GENERAL_ID\n    }\n\n\n    declare enum EventBusValue {\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_EVT_ANY = 0,  // MICROBIT_EVT_ANY\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_BUTTON_EVT_DOWN = 1,  // MICROBIT_BUTTON_EVT_DOWN\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_BUTTON_EVT_UP = 2,  // MICROBIT_BUTTON_EVT_UP\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_BUTTON_EVT_CLICK = 3,  // MICROBIT_BUTTON_EVT_CLICK\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_RADIO_EVT_DATAGRAM = 1,  // MICROBIT_RADIO_EVT_DATAGRAM\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_ACCELEROMETER_EVT_DATA_UPDATE = 1,  // MICROBIT_ACCELEROMETER_EVT_DATA_UPDATE\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_PIN_EVT_RISE = 2,  // MICROBIT_PIN_EVT_RISE\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_PIN_EVT_FALL = 3,  // MICROBIT_PIN_EVT_FALL\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_PIN_EVT_PULSE_HI = 4,  // MICROBIT_PIN_EVT_PULSE_HI\n    //% blockIdentity=\"control.eventValueId\"\n    MICROBIT_PIN_EVT_PULSE_LO = 5,  // MICROBIT_PIN_EVT_PULSE_LO\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_ALARM1 = 6,  // MES_ALERT_EVT_ALARM1\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_ALARM2 = 7,  // MES_ALERT_EVT_ALARM2\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_ALARM3 = 8,  // MES_ALERT_EVT_ALARM3\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_ALARM4 = 9,  // MES_ALERT_EVT_ALARM4\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_ALARM5 = 10,  // MES_ALERT_EVT_ALARM5\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_ALARM6 = 11,  // MES_ALERT_EVT_ALARM6\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_DISPLAY_TOAST = 1,  // MES_ALERT_EVT_DISPLAY_TOAST\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_FIND_MY_PHONE = 5,  // MES_ALERT_EVT_FIND_MY_PHONE\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_PLAY_RINGTONE = 4,  // MES_ALERT_EVT_PLAY_RINGTONE\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_PLAY_SOUND = 3,  // MES_ALERT_EVT_PLAY_SOUND\n    //% blockIdentity=\"control.eventValueId\"\n    MES_ALERT_EVT_VIBRATE = 2,  // MES_ALERT_EVT_VIBRATE\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_LAUNCH_PHOTO_MODE = 1,  // MES_CAMERA_EVT_LAUNCH_PHOTO_MODE\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_LAUNCH_VIDEO_MODE = 2,  // MES_CAMERA_EVT_LAUNCH_VIDEO_MODE\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_START_VIDEO_CAPTURE = 4,  // MES_CAMERA_EVT_START_VIDEO_CAPTURE\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_STOP_PHOTO_MODE = 6,  // MES_CAMERA_EVT_STOP_PHOTO_MODE\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_STOP_VIDEO_CAPTURE = 5,  // MES_CAMERA_EVT_STOP_VIDEO_CAPTURE\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_STOP_VIDEO_MODE = 7,  // MES_CAMERA_EVT_STOP_VIDEO_MODE\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_TAKE_PHOTO = 3,  // MES_CAMERA_EVT_TAKE_PHOTO\n    //% blockIdentity=\"control.eventValueId\"\n    MES_CAMERA_EVT_TOGGLE_FRONT_REAR = 8,  // MES_CAMERA_EVT_TOGGLE_FRONT_REAR\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_DISPLAY_OFF = 5,  // MES_DEVICE_DISPLAY_OFF\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_DISPLAY_ON = 6,  // MES_DEVICE_DISPLAY_ON\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_GESTURE_DEVICE_SHAKEN = 4,  // MES_DEVICE_GESTURE_DEVICE_SHAKEN\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_INCOMING_CALL = 7,  // MES_DEVICE_INCOMING_CALL\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_INCOMING_MESSAGE = 8,  // MES_DEVICE_INCOMING_MESSAGE\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_ORIENTATION_LANDSCAPE = 1,  // MES_DEVICE_ORIENTATION_LANDSCAPE\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DEVICE_ORIENTATION_PORTRAIT = 2,  // MES_DEVICE_ORIENTATION_PORTRAIT\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_1_DOWN = 9,  // MES_DPAD_BUTTON_1_DOWN\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_1_UP = 10,  // MES_DPAD_BUTTON_1_UP\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_2_DOWN = 11,  // MES_DPAD_BUTTON_2_DOWN\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_2_UP = 12,  // MES_DPAD_BUTTON_2_UP\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_3_DOWN = 13,  // MES_DPAD_BUTTON_3_DOWN\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_3_UP = 14,  // MES_DPAD_BUTTON_3_UP\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_4_DOWN = 15,  // MES_DPAD_BUTTON_4_DOWN\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_4_UP = 16,  // MES_DPAD_BUTTON_4_UP\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_A_DOWN = 1,  // MES_DPAD_BUTTON_A_DOWN\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_A_UP = 2,  // MES_DPAD_BUTTON_A_UP\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_B_DOWN = 3,  // MES_DPAD_BUTTON_B_DOWN\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_B_UP = 4,  // MES_DPAD_BUTTON_B_UP\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_C_DOWN = 5,  // MES_DPAD_BUTTON_C_DOWN\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_C_UP = 6,  // MES_DPAD_BUTTON_C_UP\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_D_DOWN = 7,  // MES_DPAD_BUTTON_D_DOWN\n    //% blockIdentity=\"control.eventValueId\"\n    MES_DPAD_BUTTON_D_UP = 8,  // MES_DPAD_BUTTON_D_UP\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_FORWARD = 6,  // MES_REMOTE_CONTROL_EVT_FORWARD\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_NEXTTRACK = 4,  // MES_REMOTE_CONTROL_EVT_NEXTTRACK\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_PAUSE = 2,  // MES_REMOTE_CONTROL_EVT_PAUSE\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_PLAY = 1,  // MES_REMOTE_CONTROL_EVT_PLAY\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_PREVTRACK = 5,  // MES_REMOTE_CONTROL_EVT_PREVTRACK\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_REWIND = 7,  // MES_REMOTE_CONTROL_EVT_REWIND\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_STOP = 3,  // MES_REMOTE_CONTROL_EVT_STOP\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_VOLUMEDOWN = 9,  // MES_REMOTE_CONTROL_EVT_VOLUMEDOWN\n    //% blockIdentity=\"control.eventValueId\"\n    MES_REMOTE_CONTROL_EVT_VOLUMEUP = 8,  // MES_REMOTE_CONTROL_EVT_VOLUMEUP\n    }\ndeclare namespace control {\n}\n\n\n    declare enum DisplayMode {\n    //% block=\"black and white\"\n    BackAndWhite = 0,  // DISPLAY_MODE_BLACK_AND_WHITE\n    //% block=\"greyscale\"\n    Greyscale = 1,  // DISPLAY_MODE_GREYSCALE\n    // TODO DISPLAY_MODE_BLACK_AND_WHITE_LIGHT_SENSE\n    }\ndeclare namespace led {\n}\n\n\n    declare enum DigitalPin {\n    P0 = 7,  // MICROBIT_ID_IO_P0\n    P1 = 8,  // MICROBIT_ID_IO_P1\n    P2 = 9,  // MICROBIT_ID_IO_P2\n    P3 = 10,  // MICROBIT_ID_IO_P3\n    P4 = 11,  // MICROBIT_ID_IO_P4\n    P5 = 12,  // MICROBIT_ID_IO_P5\n    P6 = 13,  // MICROBIT_ID_IO_P6\n    P7 = 14,  // MICROBIT_ID_IO_P7\n    P8 = 15,  // MICROBIT_ID_IO_P8\n    P9 = 16,  // MICROBIT_ID_IO_P9\n    P10 = 17,  // MICROBIT_ID_IO_P10\n    P11 = 18,  // MICROBIT_ID_IO_P11\n    P12 = 19,  // MICROBIT_ID_IO_P12\n    P13 = 20,  // MICROBIT_ID_IO_P13\n    P14 = 21,  // MICROBIT_ID_IO_P14\n    P15 = 22,  // MICROBIT_ID_IO_P15\n    P16 = 23,  // MICROBIT_ID_IO_P16\n    P19 = 24,  // MICROBIT_ID_IO_P19\n    P20 = 25,  // MICROBIT_ID_IO_P20\n    }\n\n\n    declare enum AnalogPin {\n    P0 = 7,  // MICROBIT_ID_IO_P0\n    P1 = 8,  // MICROBIT_ID_IO_P1\n    P2 = 9,  // MICROBIT_ID_IO_P2\n    P3 = 10,  // MICROBIT_ID_IO_P3\n    P4 = 11,  // MICROBIT_ID_IO_P4\n    P10 = 17,  // MICROBIT_ID_IO_P10\n    //% block=\"P5 (write only)\"\n    P5 = 12,  // MICROBIT_ID_IO_P5\n    //% block=\"P6 (write only)\"\n    P6 = 13,  // MICROBIT_ID_IO_P6\n    //% block=\"P7 (write only)\"\n    P7 = 14,  // MICROBIT_ID_IO_P7\n    //% block=\"P8 (write only)\"\n    P8 = 15,  // MICROBIT_ID_IO_P8\n    //% block=\"P9 (write only)\"\n    P9 = 16,  // MICROBIT_ID_IO_P9\n    //% block=\"P11 (write only)\"\n    P11 = 18,  // MICROBIT_ID_IO_P11\n    //% block=\"P12 (write only)\"\n    P12 = 19,  // MICROBIT_ID_IO_P12\n    //% block=\"P13 (write only)\"\n    P13 = 20,  // MICROBIT_ID_IO_P13\n    //% block=\"P14 (write only)\"\n    P14 = 21,  // MICROBIT_ID_IO_P14\n    //% block=\"P15 (write only)\"\n    P15 = 22,  // MICROBIT_ID_IO_P15\n    //% block=\"P16 (write only)\"\n    P16 = 23,  // MICROBIT_ID_IO_P16\n    //% block=\"P19 (write only)\"\n    P19 = 24,  // MICROBIT_ID_IO_P19\n    //% block=\"P20 (write only)\"\n    P20 = 25,  // MICROBIT_ID_IO_P20\n    }\n\n\n    declare enum PulseValue {\n    //% block=high\n    High = 4,  // MICROBIT_PIN_EVT_PULSE_HI\n    //% block=low\n    Low = 5,  // MICROBIT_PIN_EVT_PULSE_LO\n    }\n\n\n    declare enum PinPullMode {\n    //% block=\"down\"\n    PullDown = 0,\n    //% block=\"up\"\n    PullUp = 1,\n    //% block=\"none\"\n    PullNone = 2,\n    }\n\n\n    declare enum PinEventType {\n    //% block=\"edge\"\n    Edge = 1,  // MICROBIT_PIN_EVENT_ON_EDGE\n    //% block=\"pulse\"\n    Pulse = 2,  // MICROBIT_PIN_EVENT_ON_PULSE\n    //% block=\"touch\"\n    Touch = 3,  // MICROBIT_PIN_EVENT_ON_TOUCH\n    //% block=\"none\"\n    None = 0,  // MICROBIT_PIN_EVENT_NONE\n    }\n\n\n    declare enum SerialPin {\n    P0 = 7,  // MICROBIT_ID_IO_P0\n    P1 = 8,  // MICROBIT_ID_IO_P1\n    P2 = 9,  // MICROBIT_ID_IO_P2\n    P8 = 15,  // MICROBIT_ID_IO_P8\n    P12 = 19,  // MICROBIT_ID_IO_P12\n    P13 = 20,  // MICROBIT_ID_IO_P13\n    P14 = 21,  // MICROBIT_ID_IO_P14\n    P15 = 22,  // MICROBIT_ID_IO_P15\n    P16 = 23,  // MICROBIT_ID_IO_P16\n    }\n\n\n    declare enum BaudRate {\n    //% block=115200\n    BaudRate115200 = 115200,\n    //% block=57600\n    BaudRate57600 = 57600,\n    //% block=38400\n    BaudRate38400 = 38400,\n    //% block=31250\n    BaudRate31250 = 31250,\n    //% block=28800\n    BaudRate28800 = 28800,\n    //% block=19200\n    BaudRate19200 = 19200,\n    //% block=14400\n    BaudRate14400 = 14400,\n    //% block=9600\n    BaudRate9600 = 9600,\n    //% block=4800\n    BaudRate4800 = 4800,\n    //% block=2400\n    BaudRate2400 = 2400,\n    //% block=1200\n    BaudRate1200 = 1200,\n    //% block=300\n    BaudRate300 = 300,\n    }\n\n\n    declare enum Delimiters {\n    //% block=\"new line\"\n    NewLine = 1,\n    //% block=\",\"\n    Comma = 2,\n    //% block=\"$\"\n    Dollar = 3,\n    //% block=\":\"\n    Colon = 4,\n    //% block=\".\"\n    Fullstop = 5,\n    //% block=\"#\"\n    Hash = 6,\n    }\ndeclare namespace serial {\n}\n\n\n    declare enum NumberFormat {\n    Int8LE = 1,\n    UInt8LE = 2,\n    Int16LE = 3,\n    UInt16LE = 4,\n    Int32LE = 5,\n    Int8BE = 6,\n    UInt8BE = 7,\n    Int16BE = 8,\n    UInt16BE = 9,\n    Int32BE = 10,\n    // UInt32,\n    }\n\n// Auto-generated. Do not edit. Really.\n",
      "game.ts": "enum Direction {\n    //% block=right\n    Right,\n    //% block=left\n    Left\n}\n\nenum LedSpriteProperty {\n    //% block=x\n    X,\n    //% block=y\n    Y,\n    //% block=direction\n    Direction,\n    //% block=brightness\n    Brightness,\n    //% block=blink\n    Blink\n}\n\n/**\n * A single-LED sprite game engine\n */\n//% color=#008272 weight=32 icon=\"\\uf11b\"\n//% advanced=true\nnamespace game {\n    let _score: number = 0;\n    let _life: number = 3;\n    let _startTime: number = 0;\n    let _endTime: number = 0;\n    let _isGameOver: boolean = false;\n    let _countdownPause: number = 0;\n    let _level: number = 1;\n    let _gameId: number = 0;\n    let _img: Image;\n    let _sprites: LedSprite[];\n    let _paused: boolean = false;\n\n    /**\n     * Creates a new LED sprite pointing to the right.\n     * @param x sprite horizontal coordinate, eg: 2\n     * @param y sprite vertical coordinate, eg: 2\n     */\n    //% weight=60 blockGap=8 help=game/create-sprite\n    //% blockId=game_create_sprite block=\"create sprite at|x: %x|y: %y\"\n    //% parts=\"ledmatrix\"\n    export function createSprite(x: number, y: number): LedSprite {\n        init();\n        let p = new LedSprite(x, y);\n        return p;\n    }\n\n    /**\n     * Gets the current score\n     */\n    //% weight=9 help=game/score\n    //% blockId=game_score block=\"score\" blockGap=8\n    export function score(): number {\n        return _score;\n    }\n\n    /**\n     * Adds points to the current score and shows an animation\n     * @param points amount of points to change, eg: 1\n     */\n    //% weight=10 help=game/add-score\n    //% blockId=game_add_score block=\"change score by|%points\" blockGap=8\n    //% parts=\"ledmatrix\"\n    export function addScore(points: number): void {\n        setScore(_score + points);\n        if (!_paused)\n            control.inBackground(() => {\n                led.stopAnimation();\n                basic.showAnimation(`0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0\n    0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0\n    0 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n    0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0\n    0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0`, 20);\n            });\n    }\n\n    /**\n     * Shows an animation, then starts a game countdown timer, which causes Game Over when it reaches 0\n     * @param ms countdown duration in milliseconds, eg: 10000\n     */\n    //% weight=9 help=game/start-countdown\n    //% blockId=game_start_countdown block=\"start countdown|(ms) %duration\" blockGap=8\n    //% parts=\"ledmatrix\"\n    export function startCountdown(ms: number): void {\n        if (checkStart()) {\n            basic.showAnimation(`1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0\n0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0\n1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0\n0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0\n1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0`, 400);\n            _countdownPause = Math.max(500, ms);\n            _startTime = -1;\n            _endTime = input.runningTime() + _countdownPause;\n            _paused = false;\n            control.inBackground(() => {\n                basic.pause(_countdownPause);\n                gameOver();\n            });\n        }\n    }\n\n    /**\n     * Displays a game over animation and the score.\n     */\n    //% weight=8 help=game/game-over\n    //% blockId=game_game_over block=\"game over\"\n    //% parts=\"ledmatrix\"\n    export function gameOver(): void {\n        if (!_isGameOver) {\n            _isGameOver = true;\n            unplugEvents();\n            led.stopAnimation();\n            led.setBrightness(255);\n            led.setDisplayMode(DisplayMode.BackAndWhite);\n            while (true) {\n                for (let i = 0; i < 8; i++) {\n                    basic.clearScreen();\n                    basic.pause(100);\n                    basic.showLeds(`1 1 1 1 1\n1 1 1 1 1\n1 1 1 1 1\n1 1 1 1 1\n1 1 1 1 1`, 300);\n                }\n                basic.showAnimation(`1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0\n1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n1 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 0`, 100);\n                for (let j = 0; j < 3; j++) {\n                    basic.showString(\" GAMEOVER \", 100);\n                    showScore();\n                }\n            }\n        } else {\n            // already in game over mode in another fiber\n            while (true) {\n                basic.pause(10000);\n            }\n        }\n    }\n\n    /**\n     * Sets the current score value\n     * @param value new score value.\n     */\n    //% blockId=game_set_score block=\"set score %points\" blockGap=8\n    //% weight=10 help=game/set-score\n    export function setScore(value: number): void {\n        _score = Math.max(0, value);\n    }\n\n    /**\n     * Gets the current life\n     */\n    //% weight=10\n    export function life(): number {\n        return _life;\n    }\n\n    /**\n     * Sets the current life value\n     * @param value TODO\n     */\n    //% weight=10\n    export function setLife(value: number): void {\n        _life = Math.max(0, value);\n        if (_life <= 0) {\n            gameOver();\n        }\n    }\n\n    /**\n     * Adds life points to the current life\n     * @param lives TODO\n     */\n    //% weight=10\n    export function addLife(lives: number): void {\n        setLife(_life + lives);\n    }\n\n    /**\n     * Gets the remaining time (since `start countdown`) or current time (since the device started or `start stopwatch`) in milliseconds.\n     */\n    //% weight=10\n    export function currentTime(): number {\n        if (_endTime > 0) {\n            return Math.max(0, _endTime - input.runningTime());\n        } else {\n            return input.runningTime() - _startTime;\n        }\n    }\n\n    /**\n     * Removes some life\n     * @param life TODO\n     */\n    //% weight=10\n    //% parts=\"ledmatrix\"\n    export function removeLife(life: number): void {\n        setLife(_life - life);\n        if (!_paused)\n            control.inBackground(() => {\n                led.stopAnimation();\n                basic.showAnimation(`1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0\n0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0\n0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0\n0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0\n1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0`, 40);\n            });\n    }\n\n    /**\n     * Increments the level and display a message.\n     */\n    //% weight=10\n    //% parts=\"ledmatrix\"\n    export function levelUp(): void {\n        _level = _level + 1;\n        basic.showString(\"LEVEL:\", 150);\n        basic.showNumber(_level, 150);\n    }\n\n    /**\n     * Gets the current level\n     */\n    //% weight=10\n    export function level(): number {\n        return _level;\n    }\n\n    /**\n     * Starts a stopwatch timer. `current time` will return the elapsed time.\n     */\n    //% weight=10\n    export function startStopwatch(): void {\n        _startTime = input.runningTime();\n        _endTime = -1;\n    }\n\n    /**\n     * Gets a value indicating if the game is still running. Returns `false` if game over.\n     */\n    //% weight=10\n    export function isRunning(): boolean {\n        let running: boolean;\n        return !_isGameOver;\n    }\n\n    /**\n     * Displays the score on the screen.\n     */\n    //%  weight=60\n    //% parts=\"ledmatrix\"\n    export function showScore(): void {\n        basic.showString(\" SCORE \", 100);\n        basic.showNumber(_score, 150);\n        basic.showString(\" \", 150);\n    }\n\n    /**\n     * Indicates if the game is display the game over sequence.\n     */\n    export function isGameOver(): boolean {\n        return _isGameOver;\n    }\n\n    /**\n     * Indicates if the game rendering is paused to allow other animations\n     */\n    //%\n    export function isPaused(): boolean {\n        return _paused;\n    }\n\n    /**\n     * Pauses the game rendering engine to allow other animations\n     */\n    //% blockId=game_pause block=\"pause\"\n    //% advanced=true blockGap=8 help=game/pause\n    export function pause(): void {\n        plot()\n        _paused = true;\n    }\n\n\n    /**\n     * Resumes the game rendering engine\n     */\n    //% blockId=game_resume block=\"resume\"\n    //% advanced=true blockGap=8 help=game/resumeP\n    export function resume(): void {\n        _paused = false;\n        plot();\n    }\n\n    /**\n     * returns false if game can't start\n     */\n    function checkStart(): boolean {\n        if (_countdownPause > 0 || _startTime > 0) {\n            return false;\n        } else {\n            return true;\n        }\n    }\n\n    function unplugEvents(): void {\n        input.onButtonPressed(Button.A, () => { });\n        input.onButtonPressed(Button.B, () => { });\n        input.onButtonPressed(Button.AB, () => {\n            control.reset();\n        });\n    }\n\n    export class LedSprite {\n        private _x: number;\n        private _y: number;\n        private _dir: number;\n        private _brightness: number;\n        private _blink: number;\n        private _enabled: boolean;\n\n        constructor(x: number, y: number) {\n            this._x = Math.clamp(0, 4, x);\n            this._y = Math.clamp(0, 4, y);\n            this._dir = 90;\n            this._brightness = 255;\n            this._enabled = true;\n            init();\n            _sprites.push(this);\n            plot();\n        }\n\n        /**\n         * Move a certain number of LEDs in the current direction\n         * @param this the sprite to move\n         * @param leds number of leds to move, eg: 1, -1\n         */\n        //% weight=50 help=game/move\n        //% blockId=game_move_sprite block=\"%sprite|move by %leds\" blockGap=8\n        //% parts=\"ledmatrix\"\n        public move(leds: number): void {\n            if (this._dir == 0) {\n                this._y = this._y - leds;\n            } else if (this._dir == 45) {\n                this._x = this._x + leds;\n                this._y = this._y - leds;\n            } else if (this._dir == 90) {\n                this._x = this._x + leds;\n            } else if (this._dir == 135) {\n                this._x = this._x + leds;\n                this._y = this._y + leds;\n            } else if (this._dir == 180) {\n                this._y = this._y + leds;\n            } else if (this._dir == -45) {\n                this._x = this._x - leds;\n                this._y = this._y - leds;\n            } else if (this._dir == -90) {\n                this._x = this._x - leds;\n            } else {\n                this._x = this._x - leds;\n                this._y = this._y + leds;\n            }\n            this._x = Math.clamp(0, 4, this._x);\n            this._y = Math.clamp(0, 4, this._y);\n            plot();\n        }\n\n        /**\n         * Go to this position on the screen\n         * @param this TODO\n         * @param x TODO\n         * @param y TODO\n         */\n        //% parts=\"ledmatrix\"\n        public goTo(x: number, y: number): void {\n            this._x = x;\n            this._y = y;\n            this._x = Math.clamp(0, 4, this._x);\n            this._y = Math.clamp(0, 4, this._y);\n            plot();\n        }\n\n        /**\n         * If touching the edge of the stage and facing towards it, then turn away.\n         * @param this TODO\n         */\n        //% weight=18 help=game/if-on-edge-bounce\n        //% blockId=game_sprite_bounce block=\"%sprite|if on edge, bounce\"\n        //% parts=\"ledmatrix\"\n        public ifOnEdgeBounce(): void {\n            if (this._dir == 0 && this._y == 0) {\n                this._dir = 180;\n            } else if (this._dir == 45 && (this._x == 4 || this._y == 0)) {\n                if (this._x == 0 && this._y == 0) {\n                    this._dir = -135;\n                } else if (this._y == 0) {\n                    this._dir = 135;\n                } else {\n                    this._dir = -45;\n                }\n            } else if (this._dir == 90 && this._x == 4) {\n                this._dir = -90;\n            } else if (this._dir == 135 && (this._x == 4 || this._y == 4)) {\n                if (this.x() == 4 && this.y() == 4) {\n                    this._dir = -45;\n                } else if (this._y == 4) {\n                    this._dir = 45;\n                } else {\n                    this._dir = -135;\n                }\n            } else if (this._dir == 180 && this._y == 4) {\n                this._dir = 0;\n            } else if (this._dir == -45 && (this._x == 0 || this._y == 0)) {\n                if (this.x() == 0 && this.y() == 0) {\n                    this._dir = 135;\n                } else if (this._y == 0) {\n                    this._dir = -135;\n                } else {\n                    this._dir = 45;\n                }\n            } else if (this._dir == -90 && this._x == 0) {\n                this._dir = 90;\n            } else if (this._dir == -135 && (this._x == 0 || this._y == 4)) {\n                if (this._x == 0 && this._y == 4) {\n                    this._dir = 45;\n                } else if (this._y == 4) {\n                    this._dir = -45;\n                } else {\n                    this._dir = 135;\n                }\n            }\n            plot();\n        }\n\n        /**\n         * Turn the sprite\n         * @param this TODO\n         * @param direction left or right\n         * @param degrees angle in degrees to turn, eg: 45, 90, 180, 135\n         */\n        //% weight=49 help=game/turn\n        //% blockId=game_turn_sprite block=\"%sprite|turn %direction|by (°) %degrees\"\n        public turn(direction: Direction, degrees: number) {\n            if (direction == Direction.Right)\n                this.setDirection(this._dir + degrees);\n            else\n                this.setDirection(this._dir - degrees);\n        }\n\n        /**\n         * Turn to the right (clockwise)\n         * @param this TODO\n         * @param degrees TODO\n         */\n        public turnRight(degrees: number): void {\n            this.turn(Direction.Right, degrees);\n        }\n\n        /**\n         * Turn to the left (counter-clockwise)\n         * @param this TODO\n         * @param degrees TODO\n         */\n        public turnLeft(degrees: number): void {\n            this.turn(Direction.Left, degrees);\n        }\n\n        /**\n         * Sets a property of the sprite\n         * @param property the name of the property to change\n         * @param the updated value\n         */\n        //% weight=29 help=game/set\n        //% blockId=game_sprite_set_property block=\"%sprite|set %property|to %value\" blockGap=8\n        public set(property: LedSpriteProperty, value: number) {\n            switch (property) {\n                case LedSpriteProperty.X: this.setX(value); break;\n                case LedSpriteProperty.Y: this.setY(value); break;\n                case LedSpriteProperty.Direction: this.setDirection(value); break;\n                case LedSpriteProperty.Brightness: this.setBrightness(value); break;\n                case LedSpriteProperty.Blink: this.setBlink(value); break;\n            }\n        }\n\n        /**\n         * Changes a property of the sprite\n         * @param property the name of the property to change\n         * @param value amount of change, eg: 1\n         */\n        //% weight=30 help=game/change\n        //% blockId=game_sprite_change_xy block=\"%sprite|change %property|by %value\" blockGap=8\n        public change(property: LedSpriteProperty, value: number) {\n            switch (property) {\n                case LedSpriteProperty.X: this.changeXBy(value); break;\n                case LedSpriteProperty.Y: this.changeYBy(value); break;\n                case LedSpriteProperty.Direction: this.changeDirectionBy(value); break;\n                case LedSpriteProperty.Brightness: this.changeBrightnessBy(value); break;\n                case LedSpriteProperty.Blink: this.changeBlinkBy(value); break;\n            }\n        }\n\n        /**\n         * Gets a property of the sprite\n         * @param property the name of the property to change\n         */\n        //% weight=28 help=game/get\n        //% blockId=game_sprite_property block=\"%sprite|%property\"\n        public get(property: LedSpriteProperty) {\n            switch (property) {\n                case LedSpriteProperty.X: return this.x();\n                case LedSpriteProperty.Y: return this.y();\n                case LedSpriteProperty.Direction: return this.direction()\n                case LedSpriteProperty.Brightness: return this.brightness();\n                case LedSpriteProperty.Blink: return this.blink();\n                default: return 0;\n            }\n        }\n\n        /**\n         * Set the direction of the current sprite, rounded to the nearest multiple of 45\n         * @param this TODO\n         * @param degrees TODO\n         */\n        //% parts=\"ledmatrix\"\n        public setDirection(degrees: number): void {\n            this._dir = ((degrees / 45) % 8) * 45;\n            if (this._dir <= -180) {\n                this._dir = this._dir + 360;\n            } else if (this._dir > 180) {\n                this._dir = this._dir - 360;\n            }\n            plot();\n        }\n\n        /**\n         * Reports the ``x`` position of a sprite on the LED screen\n         * @param this TODO\n         */\n        public x(): number {\n            return this._x;\n        }\n\n        /**\n         * Reports the ``y`` position of a sprite on the LED screen\n         * @param this TODO\n         */\n        public y(): number {\n            return this._y;\n        }\n\n        /**\n         * Reports the current direction of a sprite\n         * @param this TODO\n         */\n        public direction(): number {\n            return this._dir;\n        }\n\n        /**\n         * Set the ``x`` position of a sprite\n         * @param this TODO\n         * @param x TODO\n         */\n        public setX(x: number): void {\n            this.goTo(x, this._y);\n        }\n\n        /**\n         * Set the ``y`` position of a sprite\n         * @param this TODO\n         * @param y TODO\n         */\n        public setY(y: number): void {\n            this.goTo(this._x, y);\n        }\n\n        /**\n         * Changes the ``y`` position by the given amount\n         * @param this TODO\n         * @param y TODO\n         */\n        public changeYBy(y: number): void {\n            this.goTo(this._x, this._y + y);\n        }\n\n        /**\n         * Changes the ``x`` position by the given amount\n         * @param this TODO\n         * @param x TODO\n         */\n        public changeXBy(x: number): void {\n            this.goTo(this._x + x, this._y);\n        }\n\n        /**\n         * Reports true if sprite has the same position as specified sprite\n         * @param this TODO\n         * @param other TODO\n         */\n        //% weight=20 help=game/is-touching\n        //% blockId=game_sprite_touching_sprite block=\"%sprite|touching %other|?\" blockGap=8\n        public isTouching(other: LedSprite): boolean {\n            return this._enabled && other._enabled && this._x == other._x && this._y == other._y;\n        }\n\n        /**\n         * Reports true if sprite is touching an edge\n         * @param this TODO\n         */\n        //% weight=19 help=game/is-touching-edge\n        //% blockId=game_sprite_touching_edge block=\"%sprite|touching edge?\" blockGap=8\n        public isTouchingEdge(): boolean {\n            return this._x == 0 || this._x == 4 || this._y == 0 || this._y == 4;\n        }\n\n        /**\n         * Turns on the sprite (on by default)\n         * @param this the sprite\n         */\n        public on(): void {\n            this.setBrightness(255);\n        }\n\n        /**\n         * Turns off the sprite (on by default)\n         * @param this the sprite\n         */\n        public off(): void {\n            this.setBrightness(0);\n        }\n\n        /**\n         * Set the ``brightness`` of a sprite\n         * @param this the sprite\n         * @param brightness the brightness from 0 (off) to 255 (on), eg: 255.\n         */\n        //% parts=\"ledmatrix\"\n        public setBrightness(brightness: number): void {\n            this._brightness = Math.clamp(0, 255, brightness);\n            plot();\n        }\n\n        /**\n         * Reports the ``brightness` of a sprite on the LED screen\n         * @param this the sprite\n         */\n        //% parts=\"ledmatrix\"\n        public brightness(): number {\n            let r: number;\n            return this._brightness;\n        }\n\n        /**\n         * Changes the ``y`` position by the given amount\n         * @param this the sprite\n         * @param value the value to change brightness\n         */\n        public changeBrightnessBy(value: number): void {\n            this.setBrightness(this._brightness + value);\n        }\n\n        /**\n         * Changes the ``direction`` position by the given amount by turning right\n         * @param this TODO\n         * @param angle TODO\n         */\n        public changeDirectionBy(angle: number): void {\n            this.turnRight(angle);\n        }\n\n        /**\n         * Deletes the sprite from the game engine. The sprite will no longer appear on the screen or interact with other sprites.\n         * @param this sprite to delete\n         */\n        //% weight=59 help=game/delete\n        //% blockId=\"game_delete_sprite\" block=\"delete %this\"\n        public delete(): void {\n            this._enabled = false;\n            if (_sprites.removeElement(this))\n                plot();\n        }\n\n        /**\n         * Sets the blink duration interval in millisecond.\n         * @param sprite TODO\n         * @param ms TODO\n         */\n        public setBlink(ms: number): void {\n            this._blink = Math.clamp(0, 10000, ms);\n        }\n\n        /**\n         * Changes the ``blink`` duration by the given amount of millisecons\n         * @param this TODO\n         * @param ms TODO\n         */\n        public changeBlinkBy(ms: number): void {\n            this.setBlink(this._blink + ms);\n        }\n\n        /**\n         * Reports the ``blink`` duration of a sprite\n         * @param this TODO\n         */\n        public blink(): number {\n            let r: number;\n            return this._blink;\n        }\n\n        //% weight=-1\n        //% parts=\"ledmatrix\"\n        public _plot(now: number) {\n            let ps = this\n            if (ps._brightness > 0) {\n                let r = 0;\n                if (ps._blink > 0) {\n                    r = (now / ps._blink) % 2;\n                }\n                if (r == 0) {\n                    _img.setPixelBrightness(ps._x, ps._y, _img.pixelBrightness(ps._x, ps._y) + ps._brightness);\n                }\n            }\n        }\n    }\n\n    function init(): void {\n        if (_img == null) {\n            _img = images.createImage(\n                `0 0 0 0 0\n0 0 0 0 0\n0 0 0 0 0\n0 0 0 0 0\n0 0 0 0 0`);\n            _sprites = (<LedSprite[]>[]);\n            basic.forever(() => {\n                basic.pause(30);\n                plot();\n                if (game.isGameOver()) {\n                    basic.pause(600);\n                }\n            });\n        }\n    }\n\n    /**\n     * Plots the current sprites on the screen\n     */\n    //% parts=\"ledmatrix\"\n    function plot(): void {\n        if (game.isGameOver() || game.isPaused() || !_img) {\n            return;\n        }\n        // ensure greyscale mode\n        if (led.displayMode() != DisplayMode.Greyscale)\n            led.setDisplayMode(DisplayMode.Greyscale);\n        // render sprites\n        let now = input.runningTime();\n        _img.clear();\n        for (let i = 0; i < _sprites.length; i++) {\n            _sprites[i]._plot(now);\n        }\n        _img.plotImage(0);\n    }\n\n    /**\n     * Gets an invalid sprite; used to initialize locals.\n     */\n    //% weight=0\n    export function invalidSprite(): LedSprite {\n        return null;\n    }\n\n}\n\n",
      "helpers.ts": "namespace console {\n    export function log(msg: string) {\n        serial.writeString(msg);\n        serial.writeString(\"\\r\\n\");\n    }\n}\n\nnamespace Math {\n    /**\n     * Generates a `true` or `false` value randomly, just like flipping a coin.\n     */\n    //% blockId=logic_random block=\"pick random true or false\"\n    //% help=math/random-boolean\n    export function randomBoolean(): boolean {\n        return Math.random(2) == 0;\n    }\n}",
      "icons.ts": "/*\nThe MIT License (MIT)\n\nCopyright (c) 2013-2016 The MicroPython-on-micro:bit Developers, as listed\nin the accompanying AUTHORS file\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the \"Software\"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in\nall copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\nTHE SOFTWARE.\n*/\n\n// Images from file microbitconstimage.cpp https://github.com/bbcmicrobit/micropython\n\nenum IconNames {\n    //% block=\"heart\"\n    //% blockImage=1\n    Heart = 0,\n    //% block=\"small heart\"\n    //% blockImage=1\n    SmallHeart,\n    //% block=\"yes\"\n    //% blockImage=1\n    Yes,\n    //% block=\"no\"\n    //% blockImage=1\n    No,\n    //% block=\"happy\"\n    //% blockImage=1\n    Happy,\n    //% block=\"sad\"\n    //% blockImage=1\n    Sad,\n    //% block=\"confused\"\n    //% blockImage=1\n    Confused,\n    //% block=\"angry\"\n    //% blockImage=1\n    Angry,\n    //% block=\"asleep\"\n    //% blockImage=1\n    Asleep,\n    //% block=\"surprised\"\n    //% blockImage=1\n    Surprised,\n    //% block=\"silly\"\n    //% blockImage=1\n    Silly,\n    //% block=\"fabulous\"\n    //% blockImage=1\n    Fabulous,\n    //% block=\"meh\"\n    //% blockImage=1\n    Meh,\n    //% block=\"t-shirt\"\n    //% blockImage=1\n    TShirt,\n    //% block=\"roller skate\"\n    //% blockImage=1\n    Rollerskate,\n    //% block=\"duck\"\n    //% blockImage=1\n    Duck,\n    //% block=\"house\"\n    //% blockImage=1\n    House,\n    //% block=\"tortoise\"\n    //% blockImage=1\n    Tortoise,\n    //% block=\"butterfly\"\n    //% blockImage=1\n    Butterfly,\n    //% block=\"stick figure\"\n    //% blockImage=1\n    StickFigure,\n    //% block=\"ghost\"\n    //% blockImage=1\n    Ghost,\n    //% block=\"sword\"\n    //% blockImage=1\n    Sword,\n    //% block=\"giraffe\"\n    //% blockImage=1\n    Giraffe,\n    //% block=\"skull\"\n    //% blockImage=1\n    Skull,\n    //% block=\"umbrella\"\n    //% blockImage=1\n    Umbrella,\n    //% block=\"snake\"\n    //% blockImage=1\n    Snake,\n    //% block=\"rabbit\"\n    //% blockImage=1\n    Rabbit,\n    //% block=\"cow\"\n    //% blockImage=1\n    Cow,\n    //% block=\"quarter note\"\n    //% blockImage=1\n    QuarterNote,\n    //% block=\"eigth note\"\n    //% blockImage=1\n    EigthNote,\n    //% block=\"pitchfork\"\n    //% blockImage=1\n    Pitchfork,\n    //% block=\"target\"\n    //% blockImage=1\n    Target,\n    //% block=\"triangle\"\n    //% blockImage=1\n    Triangle,\n    //% block=\"left triangle\"\n    //% blockImage=1\n    LeftTriangle,\n    //% block=\"chess board\"\n    //% blockImage=1\n    Chessboard,\n    //% block=\"diamond\"\n    //% blockImage=1\n    Diamond,\n    //% block=\"small diamond\"\n    //% blockImage=1\n    SmallDiamond,\n    //% block=\"square\"\n    //% blockImage=1\n    Square,\n    //% block=\"small square\"\n    //% blockImage=1\n    SmallSquare,\n    //% block=\"scissors\"\n    //% blockImage=1\n    Scissors\n}\n\nenum ArrowNames {\n    //% blockIdentity=images.arrowNumber block=\"North\"\n    North = 0,\n    //% blockIdentity=images.arrowNumber block=\"North East\"\n    NorthEast,\n    //% blockIdentity=images.arrowNumber block=\"East\"\n    East,\n    //% blockIdentity=images.arrowNumber block=\"South East\"\n    SouthEast,\n    //% blockIdentity=images.arrowNumber block=\"South\"\n    South,\n    //% blockIdentity=images.arrowNumber block=\"South West\"\n    SouthWest,\n    //% blockIdentity=images.arrowNumber block=\"West\"\n    West,\n    //% blockIdentity=images.arrowNumber block=\"North West\"\n    NorthWest,\n}\n\nnamespace basic {\n\n    /**\n     * Draws the selected icon on the LED screen\n     * @param icon the predifined icon id\n     * @param interval the amount of time (milliseconds) to show the icon. Default is 600.\n     */\n    //% weight=90 blockGap=8\n    //% blockId=basic_show_icon\n    //% block=\"show icon %i\" icon=\"\\uf00a\"\n    //% parts=\"ledmatrix\"\n    //% help=basic/show-icon\n    //% i.fieldEditor=\"gridpicker\"\n    //% i.fieldOptions.width=\"400\" i.fieldOptions.columns=\"5\"\n    //% i.fieldOptions.itemColour=\"black\" i.fieldOptions.tooltips=\"true\"\n    export function showIcon(icon: IconNames, interval = 600) {\n        let res = images.iconImage(icon)\n        res.showImage(0, interval)\n    }\n\n    /**\n     * Shows an arrow on screent\n     * @param direction the direction of the arrow\n     * @param interval the amount of time (milliseconds) to show the icon. Default is 600.\n     */\n    //% weight=50 blockGap=8\n    //% blockId=basic_show_arrow\n    //% block=\"show arrow %i=device_arrow\"\n    //% parts=\"ledmatrix\"\n    //% advanced=true\n    //% help=basic/show-arrow\n    export function showArrow(direction: number, interval = 600) {\n        let res = images.arrowImage(direction)\n        res.showImage(0, interval)\n    }\n}\n\n\nnamespace images {\n\n    //% weight=50 blockGap=8\n    //% help=images/arrow-image\n    //% blockId=builtin_arrow_image block=\"arrow image %i=device_arrow\"\n    export function arrowImage(i: ArrowNames): Image {\n        switch (i) {\n            // compass directions\n            case ArrowNames.North: return images.createImage(`    \n                                        . . # . .\n                                        . # # # .\n                                        # . # . #\n                                        . . # . .\n                                        . . # . .`);\n            case ArrowNames.NorthEast: return images.createImage(` \n                                        . . # # #\n                                        . . . # #\n                                        . . # . #\n                                        . # . . .\n                                        # . . . .`);\n            case ArrowNames.East: return images.createImage(` \n                                        . . # . .\n                                        . . . # .\n                                        # # # # #\n                                        . . . # .\n                                        . . # . .`);\n            case ArrowNames.SouthEast: return images.createImage(` \n                                        # . . . .\n                                        . # . . .\n                                        . . # . #\n                                        . . . # #\n                                        . . # # #`);\n            case ArrowNames.South: return images.createImage(` \n                                        . . # . .\n                                        . . # . .\n                                        # . # . #\n                                        . # # # .\n                                        . . # . .`);\n            case ArrowNames.SouthWest: return images.createImage(` \n                                        . . . . #\n                                        . . . # .\n                                        # . # . .\n                                        # # . . .\n                                        # # # . .`);\n            case ArrowNames.West: return images.createImage(` \n                                        . . # . .\n                                        . # . . .\n                                        # # # # #\n                                        . # . . .\n                                        . . # . .`);\n            case ArrowNames.NorthWest: return images.createImage(` \n                                        # # # . .\n                                        # # . . .\n                                        # . # . .\n                                        . . . # .\n                                        . . . . #`);\n            default: return images.createImage(`\n                                        . . . . .\n                                        . . . . .\n                                        . . . . .\n                                        . . . . .\n                                        . . . . .\n                                        `);\n        }\n    }\n\n    //% weight=50 blockGap=8\n    //% help=images/icon-image\n    //% blockId=builtin_image block=\"icon image %i\"\n    export function iconImage(i: IconNames): Image {\n        switch (i) {\n            case IconNames.Heart: return images.createImage(`\n                                        . # . # .\n                                        # # # # #\n                                        # # # # #\n                                        . # # # .\n                                        . . # . .`);\n\n            case IconNames.SmallHeart: return images.createImage(`\n                                        . . . . .\n                                        . # . # .\n                                        . # # # .\n                                        . . # . .\n                                        . . . . .`);\n            //faces\n            case IconNames.Happy: return images.createImage(`\n                                        . . . . .\n                                        . # . # .\n                                        . . . . .\n                                        # . . . #\n                                        . # # # .`);\n            case IconNames.Sad: return images.createImage(`\n                                        . . . . .\n                                        . # . # .\n                                        . . . . .\n                                        . # # # .\n                                        # . . . #`);\n            case IconNames.Confused: return images.createImage(`\n                                        . . . . .\n                                        . # . # .\n                                        . . . . .\n                                        . # . # .\n                                        # . # . #`);\n            case IconNames.Angry: return images.createImage(`\n                                        # . . . #\n                                        . # . # .\n                                        . . . . .\n                                        # # # # #\n                                        # . # . #`);\n            case IconNames.Asleep: return images.createImage(`\n                                        . . . . .\n                                        # # . # #\n                                        . . . . .\n                                        . # # # .\n                                        . . . . .`);\n            case IconNames.Surprised: return images.createImage(`\n                                        . # . # .\n                                        . . . . .\n                                        . . # . .\n                                        . # . # .\n                                        . . # . .`);\n            case IconNames.Silly: return images.createImage(`\n                                        # . . . #\n                                        . . . . .\n                                        # # # # #\n                                        . . . # #\n                                        . . . # #`);\n            case IconNames.Fabulous: return images.createImage(`\n                                        # # # # #\n                                        # # . # #\n                                        . . . . .\n                                        . # . # .\n                                        . # # # .`);\n            case IconNames.Meh: return images.createImage(`\n                                        # # . # #\n                                        . . . . .\n                                        . . . # .\n                                        . . # . .\n                                        . # . . .`);\n            case IconNames.Yes: return images.createImage(`\n                                        . . . . .\n                                        . . . . #\n                                        . . . # .\n                                        # . # . .\n                                        . # . . .`);\n            case IconNames.No: return images.createImage(`\n                                        # . . . #\n                                        . # . # .\n                                        . . # . .\n                                        . # . # .\n                                        # . . . #`);\n            case IconNames.Triangle: return images.createImage(`\n                                        . . . . .\n                                        . . # . .\n                                        . # . # .\n                                        # # # # #\n                                        . . . . .`);\n            case IconNames.LeftTriangle: return images.createImage(`\n                                        # . . . .\n                                        # # . . .\n                                        # . # . .\n                                        # . . # .\n                                        # # # # #`);\n            case IconNames.Chessboard: return images.createImage(`\n                                        . # . # .\n                                        # . # . #\n                                        . # . # .\n                                        # . # . #\n                                        . # . # .`);\n            case IconNames.Diamond: return images.createImage(`\n                                        . . # . .\n                                        . # . # .\n                                        # . . . #\n                                        . # . # .\n                                        . . # . .`);\n            case IconNames.SmallDiamond: return images.createImage(`\n                                        . . . . .\n                                        . . # . .\n                                        . # . # .\n                                        . . # . .\n                                        . . . . .`);\n            case IconNames.Square: return images.createImage(`\n                                        # # # # #\n                                        # . . . #\n                                        # . . . #\n                                        # . . . #\n                                        # # # # #`);\n            case IconNames.SmallSquare: return images.createImage(`\n                                        . . . . .\n                                        . # # # .\n                                        . # . # .\n                                        . # # # .\n                                        . . . . .`);\n\n            case IconNames.Scissors: return images.createImage(`\n                                        # # . . #\n                                        # # . # .\n                                        . . # . .\n                                        # # . # .\n                                        # # . . #`);\n            // The following images were designed by Abbie Brooks.\n            case IconNames.TShirt: return images.createImage(`\n                                        # # . # #\n                                        # # # # #\n                                        . # # # .\n                                        . # # # .\n                                        . # # # .`);\n            case IconNames.Rollerskate: return images.createImage(`\n                                        . . . # #\n                                        . . . # #\n                                        # # # # #\n                                        # # # # #\n                                        . # . # .`);\n            case IconNames.Duck: return images.createImage(`\n                                        . # # . .\n                                        # # # . .\n                                        . # # # #\n                                        . # # # .\n                                        . . . . .`);\n            case IconNames.House: return images.createImage(`\n                                        . . # . .\n                                        . # # # .\n                                        # # # # #\n                                        . # # # .\n                                        . # . # .`);\n            case IconNames.Tortoise: return images.createImage(`\n                                        . . . . .\n                                        . # # # .\n                                        # # # # #\n                                        . # . # .\n                                        . . . . .`);\n            case IconNames.Butterfly: return images.createImage(`\n                                        # # . # #\n                                        # # # # #\n                                        . . # . .\n                                        # # # # #\n                                        # # . # #`);\n            case IconNames.StickFigure: return images.createImage(`\n                                        . . # . .\n                                        # # # # #\n                                        . . # . .\n                                        . # . # .\n                                        # . . . #`);\n            case IconNames.Ghost: return images.createImage(`\n                                        . # # # .\n                                        # . # . #\n                                        # # # # #\n                                        # # # # #\n                                        # . # . #`);\n            case IconNames.Sword: return images.createImage(`\n                                        . . # . .\n                                        . . # . .\n                                        . . # . .\n                                        . # # # .\n                                        . . # . .`);\n            case IconNames.Giraffe: return images.createImage(`\n                                        # # . . .\n                                        . # . . .\n                                        . # . . .\n                                        . # # # .\n                                        . # . # .`);\n            case IconNames.Skull: return images.createImage(`\n                                        . # # # .\n                                        # . # . #\n                                        # # # # #\n                                        . # # # .\n                                        . # # # .`);\n            case IconNames.Umbrella: return images.createImage(`\n                                        . # # # .\n                                        # # # # #\n                                        . . # . .\n                                        # . # . .\n                                        # # # . .`);\n            case IconNames.Snake: return images.createImage(`\n                                        # # . . .\n                                        # # . # #\n                                        . # . # .\n                                        . # # # .\n                                        . . . . .`);\n            // animals\n            case IconNames.Rabbit: return images.createImage(`\n                                        # . # . .\n                                        # . # . .\n                                        # # # # .\n                                        # # . # .\n                                        # # # # .`);\n            case IconNames.Cow: return images.createImage(`\n                                        # . . . #\n                                        # . . . #\n                                        # # # # #\n                                        . # # # .\n                                        . . # . .`);\n            // musical notes\n            case IconNames.QuarterNote: return images.createImage(`\n                                        . . # . .\n                                        . . # . .\n                                        . . # . .\n                                        # # # . .\n                                        # # # . .`);\n            case IconNames.EigthNote: return images.createImage(`\n                                        . . # . .\n                                        . . # # .\n                                        . . # . #\n                                        # # # . .\n                                        # # # . .`);\n            // other icons\n            case IconNames.Pitchfork: return images.createImage(`\n                                        # . # . #\n                                        # . # . #\n                                        # # # # #\n                                        . . # . .\n                                        . . # . .`);\n            case IconNames.Target: return images.createImage(`\n                                        . . # . .\n                                        . # # # .\n                                        # # . # #\n                                        . # # # .\n                                        . . # . .`);\n            default: return images.createImage(`\n                                        . . . . .\n                                        . . . . .\n                                        . . . . .\n                                        . . . . .\n                                        . . . . .\n                                        `);\n        }\n    }\n\n    //% weight=50 blockGap=8\n    //% help=images/arrow-number\n    //% blockId=device_arrow block=\"%arrow\"\n    //% shim=TD_ID\n    export function arrowNumber(arrow: ArrowNames): number {\n        return arrow;\n    }\n}\n",
      "images.cpp": "#include \"pxt.h\"\n\n/**\n* Creation, manipulation and display of LED images.\n*/\n//% color=#5C2D91 weight=31 icon=\"\\uf03e\"\n//% advanced=true\nnamespace images {\n    /**\n     * Creates an image that fits on the LED screen.\n     */\n    //% weight=75 help=images/create-image\n    //% blockId=device_build_image block=\"create image\"\n    //% parts=\"ledmatrix\"\n    Image createImage(ImageLiteral leds) {\n        return MicroBitImage(imageBytes(leds)).clone().leakData();\n    }\n\n    /**\n     * Creates an image with 2 frames.\n     */\n    //% weight=74 help=images/create-big-image\n    //% blockId=device_build_big_image block=\"create big image\" imageLiteral=2\n    //% parts=\"ledmatrix\"\n    Image createBigImage(ImageLiteral leds) {\n        return createImage(leds);\n    }\n}\n\nnamespace ImageMethods {\n    /**\n     * Plots the image at a given column to the screen\n     */\n    //% help=images/plot-image\n    //% parts=\"ledmatrix\"\n    void plotImage(Image i, int xOffset = 0) {\n      uBit.display.print(MicroBitImage(i), -xOffset, 0, 0, 0);\n    }\n\n    /**\n     * Shows an frame from the image at offset ``x offset``.\n     * @param xOffset column index to start displaying the image\n     */\n    //% help=images/show-image weight=80 blockNamespace=images\n    //% blockId=device_show_image_offset block=\"show image %sprite|at offset %offset\" blockGap=8\n    //% parts=\"ledmatrix\" async\n    void showImage(Image sprite, int xOffset, int interval = 400) {\n      uBit.display.print(MicroBitImage(sprite), -xOffset, 0, 0, interval);\n    }\n\n    /**\n     * Draws the ``index``-th frame of the image on the screen.\n     * @param xOffset column index to start displaying the image\n     */\n    //% help=images/plot-frame weight=80\n    //% parts=\"ledmatrix\"\n    void plotFrame(Image i, int xOffset) {\n      // TODO showImage() used in original implementation\n      plotImage(i, xOffset * 5);\n    }\n\n    /**\n     * Scrolls an image .\n     * @param frameOffset x offset moved on each animation step, eg: 1, 2, 5\n     * @param interval time between each animation step in milli seconds, eg: 200\n     */\n    //% help=images/scroll-image weight=79 async blockNamespace=images\n    //% blockId=device_scroll_image block=\"scroll image %sprite|with offset %frameoffset|and interval (ms) %delay\" blockGap=8\n    //% parts=\"ledmatrix\"\n    void scrollImage(Image id, int frameOffset, int interval) {\n      MicroBitImage i(id);\n      uBit.display.animate(i, interval, frameOffset, MICROBIT_DISPLAY_ANIMATE_DEFAULT_POS, 0);\n    }\n\n\n    /**\n     * Sets all pixels off.\n     */\n    //% help=images/clear\n    //% parts=\"ledmatrix\"\n    void clear(Image i) {\n      MicroBitImage(i).clear();\n    }\n\n    /**\n     * Sets a specific pixel brightness at a given position\n     */\n    //%\n    //% parts=\"ledmatrix\"\n    void setPixelBrightness(Image i, int x, int y, int value) {\n      MicroBitImage(i).setPixelValue(x, y, value);\n    }\n\n\n    /**\n     * Gets the pixel brightness ([0..255]) at a given position\n     */\n    //%\n    //% parts=\"ledmatrix\"\n    int pixelBrightness(Image i, int x, int y) {\n      int pix = MicroBitImage(i).getPixelValue(x, y);\n      if (pix < 0) return 0;\n      return pix;\n    }\n\n\n    /**\n     * Gets the width in columns\n     */\n    //% help=functions/width\n    int width(Image i) {\n        return i->width;\n    }\n\n    /**\n     * Gets the height in rows (always 5)\n     */\n    //%\n    int height(Image i) {\n        return i->height;\n    }\n\n    /**\n     * Set a pixel state at position ``(x,y)``\n     * @param x TODO\n     * @param y TODO\n     * @param value TODO\n     */\n    //% help=images/set-pixel\n    //% parts=\"ledmatrix\"\n    void setPixel(Image i, int x, int y, bool value) {\n        setPixelBrightness(i, x, y, value ? 255 : 0);\n    }\n\n    /**\n     * Get the pixel state at position ``(x,y)``\n     * @param x TODO\n     * @param y TODO\n     */\n    //% help=images/pixel\n    //% parts=\"ledmatrix\"\n    bool pixel(Image i, int x, int y) {\n        return pixelBrightness(i, x, y) > 0;\n    }\n\n\n    /**\n     * Shows a particular frame of the image strip.\n     * @param frame TODO\n     */\n    //% weight=70 help=images/show-frame\n    //% parts=\"ledmatrix\"\n    void showFrame(Image i, int frame, int interval = 400) {\n        showImage(i, frame * 5, interval);\n    }\n}\n",
      "input.cpp": "#include \"pxt.h\"\n\nenum class Button {\n    A = MICROBIT_ID_BUTTON_A,\n    B = MICROBIT_ID_BUTTON_B,\n    //% block=\"A+B\"\n    AB = MICROBIT_ID_BUTTON_AB,\n};\n\nenum class Dimension {\n    //% block=x\n    X = 0,\n    //% block=y\n    Y = 1,\n    //% block=z\n    Z = 2,\n    //% block=strength\n    Strength = 3,\n};\n\nenum class Rotation {\n    //% block=pitch\n    Pitch = 0,\n    //% block=roll\n    Roll = 1,\n};\n\nenum class TouchPin {\n    P0 = MICROBIT_ID_IO_P0,\n    P1 = MICROBIT_ID_IO_P1,\n    P2 = MICROBIT_ID_IO_P2,\n};\n\nenum class AcceleratorRange {\n    /**\n     * The accelerator measures forces up to 1 gravity\n     */\n    //%  block=\"1g\"\n    OneG = 1,\n    /**\n     * The accelerator measures forces up to 2 gravity\n     */\n    //%  block=\"2g\"\n    TwoG = 2,\n    /**\n     * The accelerator measures forces up to 4 gravity\n     */\n    //% block=\"4g\"\n    FourG = 4,\n    /**\n     * The accelerator measures forces up to 8 gravity\n     */\n    //% block=\"8g\"\n    EightG = 8\n};\n\nenum class Gesture {\n    /**\n     * Raised when shaken\n     */\n    //% block=shake\n    Shake = MICROBIT_ACCELEROMETER_EVT_SHAKE,\n    /**\n     * Raised when the logo is upward and the screen is vertical\n     */\n    //% block=\"logo up\"\n    LogoUp = MICROBIT_ACCELEROMETER_EVT_TILT_UP,\n    /**\n     * Raised when the logo is downward and the screen is vertical\n     */\n    //% block=\"logo down\"\n    LogoDown = MICROBIT_ACCELEROMETER_EVT_TILT_DOWN,\n    /**\n     * Raised when the screen is pointing down and the board is horizontal\n     */\n    //% block=\"screen up\"\n    ScreenUp = MICROBIT_ACCELEROMETER_EVT_FACE_UP,\n    /**\n     * Raised when the screen is pointing up and the board is horizontal\n     */\n    //% block=\"screen down\"\n    ScreenDown = MICROBIT_ACCELEROMETER_EVT_FACE_DOWN,\n    /**\n     * Raised when the screen is pointing left\n     */\n    //% block=\"tilt left\"\n    TiltLeft = MICROBIT_ACCELEROMETER_EVT_TILT_LEFT,\n    /**\n     * Raised when the screen is pointing right\n     */\n    //% block=\"tilt right\"\n    TiltRight = MICROBIT_ACCELEROMETER_EVT_TILT_RIGHT,\n    /**\n     * Raised when the board is falling!\n     */\n    //% block=\"free fall\"\n    FreeFall = MICROBIT_ACCELEROMETER_EVT_FREEFALL,\n    /**\n    * Raised when a 3G shock is detected\n    */\n    //% block=\"3g\"\n    ThreeG = MICROBIT_ACCELEROMETER_EVT_3G,\n    /**\n    * Raised when a 6G shock is detected\n    */\n    //% block=\"6g\"\n    SixG = MICROBIT_ACCELEROMETER_EVT_6G,\n    /**\n    * Raised when a 8G shock is detected\n    */\n    //% block=\"8g\"\n    EightG = MICROBIT_ACCELEROMETER_EVT_8G\n};\n\nenum class MesDpadButtonInfo {\n    //% block=\"A down\"\n    ADown = MES_DPAD_BUTTON_A_DOWN,\n    //% block=\"A up\"\n    AUp = MES_DPAD_BUTTON_A_UP,\n    //% block=\"B down\"\n    BDown = MES_DPAD_BUTTON_B_DOWN,\n    //% block=\"B up\"\n    BUp = MES_DPAD_BUTTON_B_UP,\n    //% block=\"C down\"\n    CDown = MES_DPAD_BUTTON_C_DOWN,\n    //% block=\"C up\"\n    CUp = MES_DPAD_BUTTON_C_UP,\n    //% block=\"D down\"\n    DDown = MES_DPAD_BUTTON_D_DOWN,\n    //% block=\"D up\"\n    DUp = MES_DPAD_BUTTON_D_UP,\n    //% block=\"1 down\"\n    _1Down = MES_DPAD_BUTTON_1_DOWN,\n    //% block=\"1 up\"\n    _1Up = MES_DPAD_BUTTON_1_UP,\n    //% block=\"2 down\"\n    _2Down = MES_DPAD_BUTTON_2_DOWN,\n    //% block=\"2 up\"\n    _2Up = MES_DPAD_BUTTON_2_UP,\n    //% block=\"3 down\"\n    _3Down = MES_DPAD_BUTTON_3_DOWN,\n    //% block=\"3 up\"\n    _3Up = MES_DPAD_BUTTON_3_UP,\n    //% block=\"4 down\"\n    _4Down = MES_DPAD_BUTTON_4_DOWN,\n    //% block=\"4 up\"\n    _4Up = MES_DPAD_BUTTON_4_UP,\n};\n\n//% color=#B4009E weight=99 icon=\"\\uf192\"\nnamespace input {\n    /**\n     * Do something when a button (A, B or both A+B) is pushed down and released again.\n     * @param button the button that needs to be pressed\n     * @param body code to run when event is raised\n     */\n    //% help=input/on-button-pressed weight=85 blockGap=8\n    //% blockId=device_button_event block=\"on button|%NAME|pressed\"\n    //% parts=\"buttonpair\"\n    void onButtonPressed(Button button, Action body) {\n        registerWithDal((int)button, MICROBIT_BUTTON_EVT_CLICK, body);\n    }\n\n    /**\n     * Do something when when a gesture is done (like shaking the micro:bit).\n     * @param gesture the type of gesture to track, eg: Gesture.Shake\n     * @param body code to run when gesture is raised\n     */\n    //% help=input/on-gesture weight=84 blockGap=8\n    //% blockId=device_gesture_event block=\"on |%NAME\"\n    //% parts=\"accelerometer\"\n    //% NAME.fieldEditor=\"gridpicker\" NAME.fieldOptions.columns=4\n    void onGesture(Gesture gesture, Action body) {\n        int gi = (int)gesture;\n        if (gi == MICROBIT_ACCELEROMETER_EVT_3G && uBit.accelerometer.getRange() < 3)\n            uBit.accelerometer.setRange(4);\n        else if ((gi == MICROBIT_ACCELEROMETER_EVT_6G || gi == MICROBIT_ACCELEROMETER_EVT_8G) && uBit.accelerometer.getRange() < 6)\n            uBit.accelerometer.setRange(8);\n        registerWithDal(MICROBIT_ID_GESTURE, gi, body);\n    }\n\n     /**\n     * Do something when a pin is touched and released again (while also touching the GND pin).\n     * @param name the pin that needs to be pressed, eg: TouchPin.P0\n     * @param body the code to run when the pin is pressed\n     */\n    //% help=input/on-pin-pressed weight=83\n    //% blockId=device_pin_event block=\"on pin %name|pressed\"\n    void onPinPressed(TouchPin name, Action body) {\n        auto pin = getPin((int)name);\n        if (!pin) return;\n\n        // Forces the PIN to switch to makey-makey style detection.\n        pin->isTouched();\n        registerWithDal((int)name, MICROBIT_BUTTON_EVT_CLICK, body);\n    }\n\n    /**\n     * Do something when a pin is released.\n     * @param name the pin that needs to be released, eg: TouchPin.P0\n     * @param body the code to run when the pin is released\n     */\n    //% help=input/on-pin-released weight=6 blockGap=8\n    //% blockId=device_pin_released block=\"on pin %NAME|released\"\n    //% advanced=true\n    void onPinReleased(TouchPin name, Action body) {\n        auto pin = getPin((int)name);\n        if (!pin) return;\n\n        // Forces the PIN to switch to makey-makey style detection.\n        pin->isTouched();\n        registerWithDal((int)name, MICROBIT_BUTTON_EVT_UP, body);\n    }\n\n    /**\n     * Get the button state (pressed or not) for ``A`` and ``B``.\n     * @param button the button to query the request, eg: Button.A\n     */\n    //% help=input/button-is-pressed weight=60\n    //% block=\"button|%NAME|is pressed\"\n    //% blockId=device_get_button2\n    //% icon=\"\\uf192\" blockGap=8\n    //% parts=\"buttonpair\"\n    bool buttonIsPressed(Button button) {\n      if (button == Button::A)\n        return uBit.buttonA.isPressed();\n      else if (button == Button::B)\n        return uBit.buttonB.isPressed();\n      else if (button == Button::AB)\n        return uBit.buttonAB.isPressed();\n      return false;\n    }\n\n    /**\n     * Get the pin state (pressed or not). Requires to hold the ground to close the circuit.\n     * @param name pin used to detect the touch, eg: TouchPin.P0\n     */\n    //% help=input/pin-is-pressed weight=58\n    //% blockId=\"device_pin_is_pressed\" block=\"pin %NAME|is pressed\"\n    //% blockGap=8\n    bool pinIsPressed(TouchPin name) {\n        auto pin = getPin((int)name);\n        return pin && pin->isTouched();\n    }\n\n    int getAccelerationStrength() {\n        double x = uBit.accelerometer.getX();\n        double y = uBit.accelerometer.getY();\n        double z = uBit.accelerometer.getZ();\n        return (int)sqrt(x*x+y*y+z*z);\n    }\n\n    /**\n     * Get the acceleration value in milli-gravitys (when the board is laying flat with the screen up, x=0, y=0 and z=-1024)\n     * @param dimension TODO\n     */\n    //% help=input/acceleration weight=58\n    //% blockId=device_acceleration block=\"acceleration (mg)|%NAME\" blockGap=8\n    //% parts=\"accelerometer\"\n    int acceleration(Dimension dimension) {\n      switch (dimension) {\n      case Dimension::X: return uBit.accelerometer.getX();\n      case Dimension::Y: return uBit.accelerometer.getY();\n      case Dimension::Z: return uBit.accelerometer.getZ();\n      case Dimension::Strength: return getAccelerationStrength();\n      }\n      return 0;\n    }\n\n    /**\n     * Reads the light level applied to the LED screen in a range from ``0`` (dark) to ``255`` bright.\n     */\n    //% help=input/light-level weight=57\n    //% blockId=device_get_light_level block=\"light level\" blockGap=8\n    //% parts=\"ledmatrix\"\n    int lightLevel() {\n        return uBit.display.readLightLevel();\n    }\n\n    /**\n     * Get the current compass heading in degrees.\n     */\n    //% help=input/compass-heading\n    //% weight=56\n    //% blockId=device_heading block=\"compass heading (°)\" blockGap=8\n    //% parts=\"compass\"\n    int compassHeading() {\n        return uBit.compass.heading();\n    }\n\n\n    /**\n     * Gets the temperature in Celsius degrees (°C).\n     */\n    //% weight=55\n    //% help=input/temperature\n    //% blockId=device_temperature block=\"temperature (°C)\" blockGap=8\n    //% parts=\"thermometer\"\n    int temperature() {\n        return uBit.thermometer.getTemperature();\n    }\n\n    /**\n     * The pitch or roll of the device, rotation along the ``x-axis`` or ``y-axis``, in degrees.\n     * @param kind TODO\n     */\n    //% help=input/rotation weight=52\n    //% blockId=device_get_rotation block=\"rotation (°)|%NAME\" blockGap=8\n    //% parts=\"accelerometer\" advanced=true\n    int rotation(Rotation kind) {\n      switch (kind) {\n      case Rotation::Pitch: return uBit.accelerometer.getPitch();\n      case Rotation::Roll: return uBit.accelerometer.getRoll();\n      }\n      return 0;\n    }\n\n    /**\n     * Get the magnetic force value in ``micro-Teslas`` (``µT``). This function is not supported in the simulator.\n     * @param dimension TODO\n     */\n    //% help=input/magnetic-force weight=51\n    //% blockId=device_get_magnetic_force block=\"magnetic force (µT)|%NAME\" blockGap=8\n    //% parts=\"compass\"\n    //% advanced=true\n    int magneticForce(Dimension dimension) {\n      if (!uBit.compass.isCalibrated())\n        uBit.compass.calibrate();\n\n      switch (dimension) {\n      case Dimension::X: return uBit.compass.getX() / 1000;\n      case Dimension::Y: return uBit.compass.getY() / 1000;\n      case Dimension::Z: return uBit.compass.getZ() / 1000;\n      case Dimension::Strength: return uBit.compass.getFieldStrength() / 1000;\n      }\n      return 0;\n    }\n\n    /**\n     * Gets the number of milliseconds elapsed since power on.\n     */\n    //% help=input/running-time weight=50\n    //% blockId=device_get_running_time block=\"running time (ms)\"\n    //% advanced=true\n    int runningTime() {\n        return system_timer_current_time();\n    }\n\n    /**\n     * Obsolete, compass calibration is automatic.\n     */\n    //% help=input/calibrate-compass advanced=true\n    //% blockId=\"input_compass_calibrate\" block=\"calibrate compass\"\n    void calibrateCompass() { \n        uBit.compass.calibrate();        \n    }\n\n    /**\n     * Sets the accelerometer sample range in gravities.\n     * @param range a value describe the maximum strengh of acceleration measured\n     */\n    //% help=input/set-accelerometer-range\n    //% blockId=device_set_accelerometer_range block=\"set accelerometer|range %range\"\n    //% weight=5\n    //% parts=\"accelerometer\"\n    //% advanced=true\n    void setAccelerometerRange(AcceleratorRange range) {\n        uBit.accelerometer.setRange((int)range);\n    }\n}\n",
      "input.ts": "/**\n * Events and data from sensors\n */\n//% color=#B4009E weight=99 icon=\"\\uf192\"\nnamespace input {\n    /**\n     * Attaches code to run when the screen is facing up.\n     * @param body TODO\n     */\n    //% help=input/on-screen-up\n    export function onScreenUp(body: Action): void {\n        onGesture(Gesture.ScreenUp, body);\n    }\n\n    /**\n     * Attaches code to run when the screen is facing down.\n     * @param body TODO\n     */\n    //% help=input/on-screen-down\n    export function onScreenDown(body: Action): void {\n        onGesture(Gesture.ScreenDown, body);\n    }\n\n    /**\n     * Attaches code to run when the device is shaken.\n     * @param body TODO\n     */\n    //% help=input/on-shake\n    export function onShake(body: Action): void {\n        onGesture(Gesture.Shake, body);\n    }\n\n    /**\n     * Attaches code to run when the logo is oriented upwards and the board is vertical.\n     * @param body TODO\n     */\n    //% help=input/on-logo-up\n    export function onLogoUp(body: Action): void {\n        onGesture(Gesture.LogoUp, body);\n    }\n\n    /**\n     * Attaches code to run when the logo is oriented downwards and the board is vertical.\n     * @param body TODO\n     */\n    //% help=input/on-logo-down\n    export function onLogoDown(body: Action): void {\n        onGesture(Gesture.LogoDown, body);\n    }\n\n    /**\n     * Obsolete, use input.calibrateCompass instead.\n     */\n    //% weight=0 help=input/calibrate-compass\n    export function calibrate() {\n        input.calibrateCompass();\n    }\n}\n",
      "led.cpp": "#include \"pxt.h\"\n\nenum class DisplayMode_ {\n    //% block=\"black and white\"\n    BackAndWhite = DISPLAY_MODE_BLACK_AND_WHITE,\n    //% block=\"greyscale\"\n    Greyscale = DISPLAY_MODE_GREYSCALE,\n    // TODO DISPLAY_MODE_BLACK_AND_WHITE_LIGHT_SENSE\n};\n\n//% color=#5C2D91 weight=97 icon=\"\\uf205\"\nnamespace led {\n\n    /**\n     * Turn on the specified LED using x, y coordinates (x is horizontal, y is vertical). (0,0) is upper left.\n     * @param x the horizontal coordinate of the LED starting at 0\n     * @param y the vertical coordinate of the LED starting at 0\n     */\n    //% help=led/plot weight=78\n    //% blockId=device_plot block=\"plot|x %x|y %y\" blockGap=8\n    //% parts=\"ledmatrix\"\n    //% x.min=0 x.max=4 y.min=0 y.max=4\n    void plot(int x, int y) {\n      uBit.display.image.setPixelValue(x, y, 0xff);\n    }\n\n    /**\n     * Turn on the specified LED with specific brightness using x, y coordinates (x is horizontal, y is vertical). (0,0) is upper left.\n     * @param x the horizontal coordinate of the LED starting at 0\n     * @param y the vertical coordinate of the LED starting at 0\n     * @param brightness the brightness from 0 (off) to 255 (bright), eg:255\n     */\n    //% help=led/plot-brightness weight=78\n    //% blockId=device_plot_brightness block=\"plot|x %x|y %y|brightness %brightness\" blockGap=8\n    //% parts=\"ledmatrix\"\n    //% x.min=0 x.max=4 y.min=0 y.max=4 brightness.min=0 brightness.max=255\n    //% advanced=true\n    void plotBrightness(int x, int y, int brightness) {\n        brightness = max(0, min(0xff, brightness));\n        // enable greyscale as needed\n        if (brightness != 0 && brightness != 0xff && uBit.display.getDisplayMode() != DISPLAY_MODE_GREYSCALE)\n            uBit.display.setDisplayMode(DISPLAY_MODE_GREYSCALE);\n        uBit.display.image.setPixelValue(x, y, brightness);\n    }\n\n    /**\n     * Turn off the specified LED using x, y coordinates (x is horizontal, y is vertical). (0,0) is upper left.\n     * @param x TODO\n     * @param y TODO\n     */\n    //% help=led/unplot weight=77\n    //% blockId=device_unplot block=\"unplot|x %x|y %y\" blockGap=8\n    //% parts=\"ledmatrix\"\n    //% x.min=0 x.max=4 y.min=0 y.max=4\n    void unplot(int x, int y) {\n      uBit.display.image.setPixelValue(x, y, 0);\n    }\n\n    /**\n     * Get the on/off state of the specified LED using x, y coordinates. (0,0) is upper left.\n     * @param x TODO\n     * @param y TODO\n     */\n    //% help=led/point weight=76\n    //% blockId=device_point block=\"point|x %x|y %y\"\n    //% parts=\"ledmatrix\"\n    //% x.min=0 x.max=4 y.min=0 y.max=4\n    bool point(int x, int y) {\n      int pix = uBit.display.image.getPixelValue(x, y);\n      return pix > 0;\n    }\n\n    /**\n     * Get the screen brightness from 0 (off) to 255 (full bright).\n     */\n    //% help=led/brightness weight=60\n    //% blockId=device_get_brightness block=\"brightness\" blockGap=8\n    //% parts=\"ledmatrix\"\n    //% advanced=true\n    int brightness() {\n      return uBit.display.getBrightness();\n    }\n\n    /**\n     * Set the screen brightness from 0 (off) to 255 (full bright).\n     * @param value the brightness value, eg:255, 127, 0\n     */\n    //% help=led/set-brightness weight=59\n    //% blockId=device_set_brightness block=\"set brightness %value\"\n    //% parts=\"ledmatrix\"\n    //% advanced=true\n    //% value.min=0 value.max=255\n    void setBrightness(int value) {\n       uBit.display.setBrightness(value);\n    }\n\n    /**\n     * Cancels the current animation and clears other pending animations.\n     */\n    //% weight=50 help=led/stop-animation\n    //% blockId=device_stop_animation block=\"stop animation\"\n    //% parts=\"ledmatrix\"\n    //% advanced=true\n    void stopAnimation() {\n       uBit.display.stopAnimation();\n    }\n\n    /**\n     * Sets the display mode between black and white and greyscale for rendering LEDs.\n     * @param mode mode the display mode in which the screen operates\n     */\n    //% weight=1 help=led/set-display-mode\n    //% parts=\"ledmatrix\" advanced=true\n    void setDisplayMode(DisplayMode_ mode) {\n        uBit.display.setDisplayMode((DisplayMode)mode);\n    }\n\n    /**\n    * Gets the current display mode\n    */\n    //% weight=1 parts=\"ledmatrix\" advanced=true\n    DisplayMode_ displayMode() {\n        return (DisplayMode_)uBit.display.getDisplayMode();\n    }\n\n    /**\n    * Turns on or off the display\n    */\n    //% help=led/enable blockId=device_led_enable block=\"led enable %on\"\n    //% advanced=true parts=\"ledmatrix\"\n    void enable(bool on) {\n        if (on) uBit.display.enable();\n        else uBit.display.disable();\n    }\n\n    /**\n     * Takes a screenshot of the LED screen and returns an image.\n     */\n    //% help=led/screenshot\n    //% parts=\"ledmatrix\"\n    Image screenshot() {\n      return uBit.display.screenShot().leakData();\n        /*\n        let Image img;\n        img = image.createImage(\"\");\n        for (let i = 0; i < 5; i++) {\n            for (let j = 0; j < 5; j++) {\n                if (led.point(i, j)) {\n                    img.setPixel(i, j, true);\n                }\n            }\n        }\n        return img;\n        */\n    }\n}\n",
      "led.ts": "/**\n * Control of the LED screen.\n */\n//% color=#5C2D91 weight=97 icon=\"\\uf205\"\n    namespace led {\n\n    // what's the current high value\n    let barGraphHigh = 0;\n    // when was the current high value recorded\n    let barGraphHighLast = 0;\n\n    /**\n     * Displays a vertical bar graph based on the `value` and `high` value.\n     * If `high` is 0, the chart gets adjusted automatically.\n     * @param value current value to plot\n     * @param high maximum value. If 0, maximum value adjusted automatically, eg: 0\n     */\n    //% help=led/plot-bar-graph weight=20\n    //% blockId=device_plot_bar_graph block=\"plot bar graph of %value |up to %high\" icon=\"\\uf080\" blockExternalInputs=true\n    //% parts=\"ledmatrix\"\n    export function plotBarGraph(value: number, high: number): void {\n        let now = input.runningTime();\n        serial.writeString(value.toString() + \"\\r\\n\");\n        value = Math.abs(value);\n\n        if (high != 0) barGraphHigh = high;\n        else if (value > barGraphHigh || now - barGraphHighLast > 10000) {\n            barGraphHigh = value;\n            barGraphHighLast = now;\n        }\n\n        barGraphHigh = Math.max(barGraphHigh, 16);\n\n        let v = (value * 15) / barGraphHigh;\n        let k = 0;\n        for (let y = 4; y >= 0; --y) {\n            for (let x = 0; x < 3; ++x) {\n                if (k > v) {\n                    unplot(2 - x, y);\n                    unplot(2 + x, y);\n                } else {\n                    plot(2 - x, y);\n                    plot(2 + x, y);\n                }\n                ++k;\n            }\n        }\n    }\n\n    /**\n     * Toggles a particular pixel\n     * @param x TODO\n     * @param y TODO\n     */\n    //% help=led/toggle weight=77\n    //% blockId=device_led_toggle block=\"toggle|x %x|y %y\" icon=\"\\uf204\" blockGap=8\n    //% parts=\"ledmatrix\"\n    //% x.min=0 x.max=4 y.min=0 y.max=4\n    export function toggle(x: number, y: number): void {\n        if (led.point(x, y)) {\n            led.unplot(x, y);\n        } else {\n            led.plot(x, y);\n        }\n    }\n\n    /**\n     * Turns all LEDS on\n     */\n    //% help=led/plot-all\n    //% parts=\"ledmatrix\"\n    export function plotAll(): void {\n        for (let i = 0; i < 5; i++) {\n            for (let j = 0; j < 5; j++) {\n                led.plot(i, j);\n            }\n        }\n    }\n\n    /**\n     * Inverts the current LED display\n     */\n    //% help=led/toggle-all\n    //% parts=\"ledmatrix\"\n    export function toggleAll(): void {\n        for (let i = 0; i < 5; i++) {\n            for (let j = 0; j < 5; j++) {\n                led.toggle(i, j);\n            }\n        }\n    }\n\n    /**\n     * Fades in the screen display.\n     * @param ms TODO\n     */\n    //% help=led/fade-in\n    //% parts=\"ledmatrix\"\n    export function fadeIn(ms: number = 700): void {\n        if (ms < 20) {\n            led.setBrightness(255);\n            return;\n        }\n        let dt = 50;\n        let brightness = led.brightness();\n        let start = input.runningTime();\n        let elapsed = 0;\n        while (elapsed < ms) {\n            led.setBrightness(brightness + ((255 - brightness) * elapsed) / ms);\n            basic.pause(dt);\n            elapsed = input.runningTime() - start;\n        }\n        led.setBrightness(255);\n    }\n\n    /**\n     * Fades out the screen brightness.\n     * @param ms TODO\n     */\n    //% help=led/fade-out\n    //% parts=\"ledmatrix\"\n    export function fadeOut(ms: number = 700): void {\n        if (ms < 20) {\n            led.setBrightness(0);\n            return;\n        }\n        let brightness = led.brightness();\n        let dt = 50;\n        let start = input.runningTime();\n        let elapsed = 0;\n        while (elapsed < ms) {\n            led.setBrightness(brightness - (brightness * elapsed) / ms);\n            basic.pause(dt);\n            elapsed = input.runningTime() - start;\n        }\n        led.setBrightness(0);\n    }\n\n\n}\n",
      "melodies.ts": "/*\nThe MIT License (MIT)\n\nCopyright (c) 2013-2016 The MicroPython-on-micro:bit Developers, as listed\nin the accompanying AUTHORS file\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the \"Software\"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in\nall copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\nTHE SOFTWARE.\n*/\n\n// Melodies from file microbitmusictunes.c https://github.com/bbcmicrobit/MicroPython\n\nenum Melodies {\n    //% block=\"dadadum\" blockIdentity=music.builtInMelody\n    Dadadadum = 0,\n    //% block=\"entertainer\" blockIdentity=music.builtInMelody\n    Entertainer,\n    //% block=\"prelude\" blockIdentity=music.builtInMelody\n    Prelude,\n    //% block=\"ode\" blockIdentity=music.builtInMelody\n    Ode,\n    //% block=\"nyan\" blockIdentity=music.builtInMelody\n    Nyan,\n    //% block=\"ringtone\" blockIdentity=music.builtInMelody\n    Ringtone,\n    //% block=\"funk\" blockIdentity=music.builtInMelody\n    Funk,\n    //% block=\"blues\" blockIdentity=music.builtInMelody\n    Blues,\n    //% block=\"birthday\" blockIdentity=music.builtInMelody\n    Birthday,\n    //% block=\"wedding\" blockIdentity=music.builtInMelody\n    Wedding,\n    //% block=\"funereal\" blockIdentity=music.builtInMelody\n    Funeral,\n    //% block=\"punchline\" blockIdentity=music.builtInMelody\n    Punchline,\n    //% block=\"baddy\" blockIdentity=music.builtInMelody\n    Baddy,\n    //% block=\"chase\" blockIdentity=music.builtInMelody\n    Chase,\n    //% block=\"ba ding\" blockIdentity=music.builtInMelody\n    BaDing,\n    //% block=\"wawawawaa\" blockIdentity=music.builtInMelody\n    Wawawawaa,\n    //% block=\"jump up\" blockIdentity=music.builtInMelody\n    JumpUp,\n    //% block=\"jump down\" blockIdentity=music.builtInMelody\n    JumpDown,\n    //% block=\"power up\" blockIdentity=music.builtInMelody\n    PowerUp,\n    //% block=\"power down\" blockIdentity=music.builtInMelody\n    PowerDown,\n}\n\nnamespace music {\n\n    export function getMelody(melody: Melodies): string[] {\n        switch (melody) {\n            case Melodies.Dadadadum:\n                return ['r4:2', 'g', 'g', 'g', 'eb:8', 'r:2', 'f', 'f', 'f', 'd:8'];\n            case Melodies.Entertainer:\n                return ['d4:1', 'd#', 'e', 'c5:2', 'e4:1', 'c5:2', 'e4:1', 'c5:3', 'c:1', 'd', 'd#', 'e', 'c', 'd', 'e:2', 'b4:1', 'd5:2', 'c:4'];\n            case Melodies.Prelude:\n                return ['c4:1', 'e', 'g', 'c5', 'e', 'g4', 'c5', 'e', 'c4', 'e', 'g', 'c5', 'e', 'g4', 'c5', 'e', 'c4', 'd', 'g', 'd5', 'f', 'g4', 'd5', 'f', 'c4', 'd', 'g', 'd5', 'f', 'g4', 'd5', 'f', 'b3', 'd4', 'g', 'd5', 'f', 'g4', 'd5', 'f', 'b3', 'd4', 'g', 'd5', 'f', 'g4', 'd5', 'f', 'c4', 'e', 'g', 'c5', 'e', 'g4', 'c5', 'e', 'c4', 'e', 'g', 'c5', 'e', 'g4', 'c5', 'e'];\n            case Melodies.Ode:\n                return ['e4', 'e', 'f', 'g', 'g', 'f', 'e', 'd', 'c', 'c', 'd', 'e', 'e:6', 'd:2', 'd:8', 'e:4', 'e', 'f', 'g', 'g', 'f', 'e', 'd', 'c', 'c', 'd', 'e', 'd:6', 'c:2', 'c:8'];\n            case Melodies.Nyan:\n                return ['f#5:2', 'g#', 'c#:1', 'd#:2', 'b4:1', 'd5:1', 'c#', 'b4:2', 'b', 'c#5', 'd', 'd:1', 'c#', 'b4:1', 'c#5:1', 'd#', 'f#', 'g#', 'd#', 'f#', 'c#', 'd', 'b4', 'c#5', 'b4', 'd#5:2', 'f#', 'g#:1', 'd#', 'f#', 'c#', 'd#', 'b4', 'd5', 'd#', 'd', 'c#', 'b4', 'c#5', 'd:2', 'b4:1', 'c#5', 'd#', 'f#', 'c#', 'd', 'c#', 'b4', 'c#5:2', 'b4', 'c#5', 'b4', 'f#:1', 'g#', 'b:2', 'f#:1', 'g#', 'b', 'c#5', 'd#', 'b4', 'e5', 'd#', 'e', 'f#', 'b4:2', 'b', 'f#:1', 'g#', 'b', 'f#', 'e5', 'd#', 'c#', 'b4', 'f#', 'd#', 'e', 'f#', 'b:2', 'f#:1', 'g#', 'b:2', 'f#:1', 'g#', 'b', 'b', 'c#5', 'd#', 'b4', 'f#', 'g#', 'f#', 'b:2', 'b:1', 'a#', 'b', 'f#', 'g#', 'b', 'e5', 'd#', 'e', 'f#', 'b4:2', 'c#5'];\n            case Melodies.Ringtone:\n                return ['c4:1', 'd', 'e:2', 'g', 'd:1', 'e', 'f:2', 'a', 'e:1', 'f', 'g:2', 'b', 'c5:4'];\n            case Melodies.Funk:\n                return ['c2:2', 'c', 'd#', 'c:1', 'f:2', 'c:1', 'f:2', 'f#', 'g', 'c', 'c', 'g', 'c:1', 'f#:2', 'c:1', 'f#:2', 'f', 'd#'];\n            case Melodies.Blues:\n                return ['c2:2', 'e', 'g', 'a', 'a#', 'a', 'g', 'e', 'c2:2', 'e', 'g', 'a', 'a#', 'a', 'g', 'e', 'f', 'a', 'c3', 'd', 'd#', 'd', 'c', 'a2', 'c2:2', 'e', 'g', 'a', 'a#', 'a', 'g', 'e', 'g', 'b', 'd3', 'f', 'f2', 'a', 'c3', 'd#', 'c2:2', 'e', 'g', 'e', 'g', 'f', 'e', 'd'];\n            case Melodies.Birthday:\n                return ['c4:3', 'c:1', 'd:4', 'c:4', 'f', 'e:8', 'c:3', 'c:1', 'd:4', 'c:4', 'g', 'f:8', 'c:3', 'c:1', 'c5:4', 'a4', 'f', 'e', 'd', 'a#:3', 'a#:1', 'a:4', 'f', 'g', 'f:8'];\n            case Melodies.Wedding:\n                return ['c4:4', 'f:3', 'f:1', 'f:8', 'c:4', 'g:3', 'e:1', 'f:8', 'c:4', 'f:3', 'a:1', 'c5:4', 'a4:3', 'f:1', 'f:4', 'e:3', 'f:1', 'g:8'];\n            case Melodies.Funeral:\n                return ['c3:4', 'c:3', 'c:1', 'c:4', 'd#:3', 'd:1', 'd:3', 'c:1', 'c:3', 'b2:1', 'c3:4'];\n            case Melodies.Punchline:\n                return ['c4:3', 'g3:1', 'f#', 'g', 'g#:3', 'g', 'r', 'b', 'c4'];\n            case Melodies.Baddy:\n                return ['c3:3', 'r', 'd:2', 'd#', 'r', 'c', 'r', 'f#:8'];\n            case Melodies.Chase:\n                return ['a4:1', 'b', 'c5', 'b4', 'a:2', 'r', 'a:1', 'b', 'c5', 'b4', 'a:2', 'r', 'a:2', 'e5', 'd#', 'e', 'f', 'e', 'd#', 'e', 'b4:1', 'c5', 'd', 'c', 'b4:2', 'r', 'b:1', 'c5', 'd', 'c', 'b4:2', 'r', 'b:2', 'e5', 'd#', 'e', 'f', 'e', 'd#', 'e'];\n            case Melodies.BaDing:\n                return ['b5:1', 'e6:3'];\n            case Melodies.Wawawawaa:\n                return ['e3:3', 'r:1', 'd#:3', 'r:1', 'd:4', 'r:1', 'c#:8'];\n            case Melodies.JumpUp:\n                return ['c5:1', 'd', 'e', 'f', 'g'];\n            case Melodies.JumpDown:\n                return ['g5:1', 'f', 'e', 'd', 'c'];\n            case Melodies.PowerUp:\n                return ['g4:1', 'c5', 'e', 'g:2', 'e:1', 'g:3'];\n            case Melodies.PowerDown:\n                return ['g5:1', 'd#', 'c', 'g4:2', 'b:1', 'c5:3'];\n            default:\n                return [];\n        }\n    }\n}",
      "music.ts": "enum Note {\n    //% blockIdentity=music.noteFrequency enumval=262\n    C = 262,\n    //% block=C#\n    //% blockIdentity=music.noteFrequency enumval=277\n    CSharp = 277,\n    //% blockIdentity=music.noteFrequency enumval=294\n    D = 294,\n    //% blockIdentity=music.noteFrequency enumval=311\n    Eb = 311,\n    //% blockIdentity=music.noteFrequency enumval=330\n    E = 330,\n    //% blockIdentity=music.noteFrequency enumval=349\n    F = 349,\n    //% block=F#\n    //% blockIdentity=music.noteFrequency enumval=370\n    FSharp = 370,\n    //% blockIdentity=music.noteFrequency enumval=392\n    G = 392,\n    //% block=G#\n    //% blockIdentity=music.noteFrequency enumval=415\n    GSharp = 415,\n    //% blockIdentity=music.noteFrequency enumval=440\n    A = 440,\n    //% blockIdentity=music.noteFrequency enumval=466\n    Bb = 466,\n    //% blockIdentity=music.noteFrequency enumval=494\n    B = 494,\n    //% blockIdentity=music.noteFrequency enumval=131\n    C3 = 131,\n    //% block=C#3\n    //% blockIdentity=music.noteFrequency enumval=139\n    CSharp3 = 139,\n    //% blockIdentity=music.noteFrequency enumval=147\n    D3 = 147,\n    //% blockIdentity=music.noteFrequency enumval=156\n    Eb3 = 156,\n    //% blockIdentity=music.noteFrequency enumval=165\n    E3 = 165,\n    //% blockIdentity=music.noteFrequency enumval=175\n    F3 = 175,\n    //% block=F#3\n    //% blockIdentity=music.noteFrequency enumval=185\n    FSharp3 = 185,\n    //% blockIdentity=music.noteFrequency enumval=196\n    G3 = 196,\n    //% block=G#3\n    //% blockIdentity=music.noteFrequency enumval=208\n    GSharp3 = 208,\n    //% blockIdentity=music.noteFrequency enumval=220\n    A3 = 220,\n    //% blockIdentity=music.noteFrequency enumval=233\n    Bb3 = 233,\n    //% blockIdentity=music.noteFrequency enumval=247\n    B3 = 247,\n    //% blockIdentity=music.noteFrequency enumval=262\n    C4 = 262,\n    //% block=C#4\n    //% blockIdentity=music.noteFrequency enumval=277\n    CSharp4 = 277,\n    //% blockIdentity=music.noteFrequency enumval=294\n    D4 = 294,\n    //% blockIdentity=music.noteFrequency enumval=311\n    Eb4 = 311,\n    //% blockIdentity=music.noteFrequency enumval=330\n    E4 = 330,\n    //% blockIdentity=music.noteFrequency enumval=349\n    F4 = 349,\n    //% block=F#4\n    //% blockIdentity=music.noteFrequency enumval=370\n    FSharp4 = 370,\n    //% blockIdentity=music.noteFrequency enumval=392\n    G4 = 392,\n    //% block=G#4\n    //% blockIdentity=music.noteFrequency enumval=415\n    GSharp4 = 415,\n    //% blockIdentity=music.noteFrequency enumval=440\n    A4 = 440,\n    //% blockIdentity=music.noteFrequency enumval=466\n    Bb4 = 466,\n    //% blockIdentity=music.noteFrequency enumval=494\n    B4 = 494,\n    //% blockIdentity=music.noteFrequency enumval=523\n    C5 = 523,\n    //% block=C#5\n    //% blockIdentity=music.noteFrequency enumval=555\n    CSharp5 = 555,\n    //% blockIdentity=music.noteFrequency enumval=587\n    D5 = 587,\n    //% blockIdentity=music.noteFrequency enumval=622\n    Eb5 = 622,\n    //% blockIdentity=music.noteFrequency enumval=659\n    E5 = 659,\n    //% blockIdentity=music.noteFrequency enumval=698\n    F5 = 698,\n    //% block=F#5\n    //% blockIdentity=music.noteFrequency enumval=740\n    FSharp5 = 740,\n    //% blockIdentity=music.noteFrequency enumval=784\n    G5 = 784,\n    //% block=G#5\n    //% blockIdentity=music.noteFrequency enumval=831\n    GSharp5 = 831,\n    //% blockIdentity=music.noteFrequency enumval=880\n    A5 = 880,\n    //% blockIdentity=music.noteFrequency enumval=932\n    Bb5 = 932,\n    //% blockIdentity=music.noteFrequency enumval=988\n    B5 = 988,\n}\n\nenum BeatFraction {\n    //% block=1\n    Whole = 1,\n    //% block=\"1/2\"\n    Half = 2,\n    //% block=\"1/4\"\n    Quarter = 4,\n    //% block=\"1/8\"\n    Eighth = 8,\n    //% block=\"1/16\"\n    Sixteenth = 16,\n    //% block=\"2\"\n    Double = 32,\n    //% block=\"4\",\n    Breve = 64\n}\n\nenum MelodyOptions {\n    //% block=\"once\"\"\n    Once = 1,\n    //% block=\"forever\"\n    Forever = 2,\n    //% block=\"once in background\"\n    OnceInBackground = 4,\n    //% block=\"forever in background\"\n    ForeverInBackground = 8\n}\n\nenum MusicEvent {\n    //% block=\"melody note played\"\n    MelodyNotePlayed = 1,\n    //% block=\"melody started\"\n    MelodyStarted = 2,\n    //% block=\"melody ended\"\n    MelodyEnded = 3,\n    //% block=\"melody repeated\"\n    MelodyRepeated = 4,\n    //% block=\"background melody note played\"\n    BackgroundMelodyNotePlayed = MelodyNotePlayed | 0xf0,\n    //% block=\"background melody started\"\n    BackgroundMelodyStarted = MelodyStarted | 0xf0,\n    //% block=\"background melody ended\"\n    BackgroundMelodyEnded = MelodyEnded | 0xf0,\n    //% block=\"background melody repeated\"\n    BackgroundMelodyRepeated = MelodyRepeated | 0xf0,\n    //% block=\"background melody paused\"\n    BackgroundMelodyPaused = 5 | 0xf0,\n    //% block=\"background melody resumed\"\n    BackgroundMelodyResumed = 6 | 0xf0\n}\n\n/**\n * Generation of music tones.\n */\n//% color=#D83B01 weight=98 icon=\"\\uf025\"\nnamespace music {\n    let beatsPerMinute: number = 120;\n    let freqTable: number[] = [];\n    let _playTone: (frequency: number, duration: number) => void;\n    const MICROBIT_MELODY_ID = 2000;\n\n    /**\n     * Plays a tone through pin ``P0`` for the given duration.\n     * @param frequency pitch of the tone to play in Hertz (Hz)\n     * @param ms tone duration in milliseconds (ms)\n     */\n    //% help=music/play-tone weight=90\n    //% blockId=device_play_note block=\"play|tone %note=device_note|for %duration=device_beat\" blockGap=8\n    //% parts=\"headphone\"\n    //% useEnumVal=1\n    export function playTone(frequency: number, ms: number): void {\n        if (_playTone) _playTone(frequency, ms);\n        else pins.analogPitch(frequency, ms);\n    }\n\n    /**\n     * Plays a tone through pin ``P0``.\n     * @param frequency pitch of the tone to play in Hertz (Hz)\n     */\n    //% help=music/ring-tone weight=80\n    //% blockId=device_ring block=\"ring tone (Hz)|%note=device_note\" blockGap=8\n    //% parts=\"headphone\"\n    //% useEnumVal=1\n    export function ringTone(frequency: number): void {\n        playTone(frequency, 0);\n    }\n\n    /**\n     * Rests (plays nothing) for a specified time through pin ``P0``.\n     * @param ms rest duration in milliseconds (ms)\n     */\n    //% help=music/rest weight=79\n    //% blockId=device_rest block=\"rest(ms)|%duration=device_beat\"\n    //% parts=\"headphone\"\n    export function rest(ms: number): void {\n        playTone(0, ms);\n    }\n\n\n    /**\n     * Gets the frequency of a note.\n     * @param name the note name, eg: Note.C\n     */\n    //% weight=50 help=music/note-frequency\n    //% blockId=device_note block=\"%note\"\n    //% shim=TD_ID\n    //% note.fieldEditor=\"note\" note.defl=\"262\"\n    //% useEnumVal=1\n    export function noteFrequency(name: Note): number {\n        return name;\n    }\n\n    function init() {\n        if (beatsPerMinute <= 0) beatsPerMinute = 120;\n        if (freqTable.length == 0) freqTable = [31, 33, 35, 37, 39, 41, 44, 46, 49, 52, 55, 58, 62, 65, 69, 73, 78, 82, 87, 92, 98, 104, 110, 117, 123, 131, 139, 147, 156, 165, 175, 185, 196, 208, 220, 233, 247, 262, 277, 294, 311, 330, 349, 370, 392, 415, 440, 466, 494, 523, 554, 587, 622, 659, 698, 740, 784, 831, 880, 932, 988, 1047, 1109, 1175, 1245, 1319, 1397, 1480, 1568, 1661, 1760, 1865, 1976, 2093, 2217, 2349, 2489, 2637, 2794, 2960, 3136, 3322, 3520, 3729, 3951, 4186]\n    }\n\n    /**\n     * Returns the duration of a beat in milli-seconds\n     */\n    //% help=music/beat weight=49\n    //% blockId=device_beat block=\"%fraction|beat\"\n    export function beat(fraction?: BeatFraction): number {\n        init();\n        if (fraction == null) fraction = BeatFraction.Whole;\n        let beat = 60000 / beatsPerMinute;\n        switch (fraction) {\n            case BeatFraction.Half: return beat / 2;\n            case BeatFraction.Quarter: return beat / 4;\n            case BeatFraction.Eighth: return beat / 8;\n            case BeatFraction.Sixteenth: return beat / 16;\n            case BeatFraction.Double: return beat * 2;\n            case BeatFraction.Breve: return beat * 4;\n            default: return beat;\n        }\n    }\n\n    /**\n     * Returns the tempo in beats per minute. Tempo is the speed (bpm = beats per minute) at which notes play. The larger the tempo value, the faster the notes will play.\n     */\n    //% help=music/tempo weight=40\n    //% blockId=device_tempo block=\"tempo (bpm)\" blockGap=8\n    export function tempo(): number {\n        init();\n        return beatsPerMinute;\n    }\n\n    /**\n     * Change the tempo by the specified amount\n     * @param bpm The change in beats per minute to the tempo, eg: 20\n     */\n    //% help=music/change-tempo-by weight=39\n    //% blockId=device_change_tempo block=\"change tempo by (bpm)|%value\" blockGap=8\n    export function changeTempoBy(bpm: number): void {\n        init();\n        setTempo(beatsPerMinute + bpm);\n    }\n\n    /**\n     * Sets the tempo to the specified amount\n     * @param bpm The new tempo in beats per minute, eg: 120\n     */\n    //% help=music/set-tempo weight=38\n    //% blockId=device_set_tempo block=\"set tempo to (bpm)|%value\"\n    //% bpm.min=4 bpm.max=400\n    export function setTempo(bpm: number): void {\n        init();\n        if (bpm > 0) {\n            beatsPerMinute = Math.max(1, bpm);\n        }\n    }\n\n    let currentMelody: Melody;\n    let currentBackgroundMelody: Melody;\n\n    /**\n     * Gets the melody array of a built-in melody.\n     * @param name the note name, eg: Note.C\n     */\n    //% weight=50 help=music/builtin-melody\n    //% blockId=device_builtin_melody block=\"%melody\"\n    //% blockHidden=true\n    export function builtInMelody(melody: Melodies): string[] {\n        return getMelody(melody);\n    }\n\n    /**\n     * Registers code to run on various melody events\n     */\n    //% blockId=melody_on_event block=\"music on %value\"\n    //% help=music/on-event weight=59\n    export function onEvent(value: MusicEvent, handler: Action) {\n        control.onEvent(MICROBIT_MELODY_ID, value, handler);\n    }\n\n    /**\n     * Starts playing a melody.\n     * Notes are expressed as a string of characters with this format: NOTE[octave][:duration]\n     * @param melodyArray the melody array to play, eg: ['g5:1']\n     * @param options melody options, once / forever, in the foreground / background\n     */\n    //% help=music/begin-melody weight=60 blockGap=8\n    //% blockId=device_start_melody block=\"start melody %melody=device_builtin_melody| repeating %options\"\n    //% parts=\"headphone\"\n    export function beginMelody(melodyArray: string[], options: MelodyOptions = 1) {\n        init();\n        if (currentMelody != undefined) {\n            if (((options & MelodyOptions.OnceInBackground) == 0)\n                && ((options & MelodyOptions.ForeverInBackground) == 0)\n                && currentMelody.background) {\n                currentBackgroundMelody = currentMelody;\n                currentMelody = null;\n                control.raiseEvent(MICROBIT_MELODY_ID, MusicEvent.BackgroundMelodyPaused);\n            }\n            if (currentMelody)\n                control.raiseEvent(MICROBIT_MELODY_ID, currentMelody.background ? MusicEvent.BackgroundMelodyEnded : MusicEvent.MelodyEnded);\n            currentMelody = new Melody(melodyArray, options);\n            control.raiseEvent(MICROBIT_MELODY_ID, currentMelody.background ? MusicEvent.BackgroundMelodyStarted : MusicEvent.MelodyStarted);\n        } else {\n            currentMelody = new Melody(melodyArray, options);\n            control.raiseEvent(MICROBIT_MELODY_ID, currentMelody.background ? MusicEvent.BackgroundMelodyStarted : MusicEvent.MelodyStarted);\n            // Only start the fiber once\n            control.inBackground(() => {\n                while (currentMelody.hasNextNote()) {\n                    playNextNote(currentMelody);\n                    if (!currentMelody.hasNextNote() && currentBackgroundMelody) {\n                        // Swap the background melody back\n                        currentMelody = currentBackgroundMelody;\n                        currentBackgroundMelody = null;\n                        control.raiseEvent(MICROBIT_MELODY_ID, MusicEvent.MelodyEnded);\n                        control.raiseEvent(MICROBIT_MELODY_ID, MusicEvent.BackgroundMelodyResumed);\n                    }\n                }\n                control.raiseEvent(MICROBIT_MELODY_ID, currentMelody.background ? MusicEvent.BackgroundMelodyEnded : MusicEvent.MelodyEnded);\n                currentMelody = null;\n            })\n        }\n    }\n\n    /**\n     * Sets a custom playTone function for playing melodies\n     */\n    //% help=music/set-play-tone\n    //% advanced=true\n    export function setPlayTone(f: (frequency: number, duration: number) => void) {\n        _playTone = f;\n    }\n\n    function playNextNote(melody: Melody): void {\n        // cache elements\n        let currNote = melody.nextNote();\n        let currentPos = melody.currentPos;\n        let currentDuration = melody.currentDuration;\n        let currentOctave = melody.currentOctave;\n\n        let note: number;\n        let isrest: boolean = false;\n        let beatPos: number;\n        let parsingOctave: boolean = true;\n\n        for (let pos = 0; pos < currNote.length; pos++) {\n            let noteChar = currNote.charAt(pos);\n            switch (noteChar) {\n                case 'c': case 'C': note = 1; break;\n                case 'd': case 'D': note = 3; break;\n                case 'e': case 'E': note = 5; break;\n                case 'f': case 'F': note = 6; break;\n                case 'g': case 'G': note = 8; break;\n                case 'a': case 'A': note = 10; break;\n                case 'b': case 'B': note = 12; break;\n                case 'r': case 'R': isrest = true; break;\n                case '#': note++; break;\n                case 'b': note--; break;\n                case ':': parsingOctave = false; beatPos = pos; break;\n                default: if (parsingOctave) currentOctave = parseInt(noteChar);\n            }\n        }\n        if (!parsingOctave) {\n            currentDuration = parseInt(currNote.substr(beatPos + 1, currNote.length - beatPos));\n        }\n        let beat = (60000 / beatsPerMinute) / 4;\n        if (isrest) {\n            music.rest(currentDuration * beat)\n        } else {\n            let keyNumber = note + (12 * (currentOctave - 1));\n            let frequency = keyNumber >= 0 && keyNumber < freqTable.length ? freqTable[keyNumber] : 0;\n            music.playTone(frequency, currentDuration * beat);\n        }\n        melody.currentDuration = currentDuration;\n        melody.currentOctave = currentOctave;\n        const repeating = melody.repeating && currentPos == melody.melodyArray.length - 1;\n        melody.currentPos = repeating ? 0 : currentPos + 1;\n\n        control.raiseEvent(MICROBIT_MELODY_ID, melody.background ? MusicEvent.BackgroundMelodyNotePlayed : MusicEvent.MelodyNotePlayed);\n        if (repeating)\n            control.raiseEvent(MICROBIT_MELODY_ID, melody.background ? MusicEvent.BackgroundMelodyRepeated : MusicEvent.MelodyRepeated);\n    }\n\n    class Melody {\n        public melodyArray: string[];\n        public currentDuration: number;\n        public currentOctave: number;\n        public currentPos: number;\n        public repeating: boolean;\n        public background: boolean;\n\n        constructor(melodyArray: string[], options: MelodyOptions) {\n            this.melodyArray = melodyArray;\n            this.repeating = ((options & MelodyOptions.Forever) != 0);\n            this.repeating = this.repeating ? true : ((options & MelodyOptions.ForeverInBackground) != 0)\n            this.background = ((options & MelodyOptions.OnceInBackground) != 0);\n            this.background = this.background ? true : ((options & MelodyOptions.ForeverInBackground) != 0);\n            this.currentDuration = 4; //Default duration (Crotchet)\n            this.currentOctave = 4; //Middle octave\n            this.currentPos = 0;\n        }\n\n        hasNextNote() {\n            return this.repeating || this.currentPos < this.melodyArray.length;\n        }\n\n        nextNote(): string {\n            const currentNote = this.melodyArray[this.currentPos];\n            return currentNote;\n        }\n    }\n}\n",
      "parts/headphone.svg": "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"142\" height=\"180\" viewBox=\"0 0 142 180\"><rect ry=\".3\" rx=\"1\" y=\"58.615\" x=\"-8.878\" height=\"23.571\" width=\"17.143\" transform=\"rotate(-45)\" fill=\"#b3b3b3\"/><rect ry=\".3\" rx=\"1\" y=\"32.043\" x=\"-8.878\" height=\"23.571\" width=\"17.143\" transform=\"rotate(-45)\" fill=\"#b3b3b3\"/><path d=\"M.346 7.296c-.394.39-.31 4.797-.18 4.898l13.404 10.18c.117.12.337 4.76.73 4.368l5.506-5.56.01.01 6.51-6.444c.39-.392-4.25-.614-4.366-.73L11.777.612c-.1-.132-4.51-.215-4.898.18L4.087 3.636l-.01-.01-3.73 3.67z\" fill=\"#b3b3b3\"/><rect ry=\"6.85\" rx=\"4.571\" y=\"84.758\" x=\"-20.128\" height=\"75.571\" width=\"39.643\" transform=\"rotate(-45)\"/><rect ry=\".374\" rx=\"1.038\" y=\"29.442\" x=\"-8.925\" height=\"2.228\" width=\"17.238\" transform=\"rotate(-45)\" fill=\"#fff\"/><rect ry=\".374\" rx=\"1.038\" y=\"55.939\" x=\"-8.925\" height=\"2.228\" width=\"17.238\" transform=\"rotate(-45)\" fill=\"#fff\"/><rect ry=\".374\" rx=\"1.038\" y=\"82.392\" x=\"-8.925\" height=\"2.228\" width=\"17.238\" transform=\"rotate(-45)\" fill=\"#fff\"/><rect ry=\"2.317\" rx=\"2.183\" y=\"158.876\" x=\"-9.774\" height=\"25.568\" width=\"18.935\" transform=\"rotate(-45)\"/><path d=\"M128.588 128.82s14.97 11.165 7.547 26.35c-8.426 17.24-25.57 20.653-25.57 20.653\" fill=\"none\" stroke=\"#000\" stroke-width=\"6.6\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>",
      "parts/speaker.svg": "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<svg viewBox=\"0 0 500 500\" xmlns=\"http://www.w3.org/2000/svg\">\n  <g transform=\"matrix(1, 0, 0, 1, -0.00023, -58.230297)\">\n    <ellipse style=\"fill: rgb(70, 70, 70);\" cx=\"250.58\" cy=\"308.81\" rx=\"215\" ry=\"215\"/>\n    <ellipse style=\"fill: rgb(0, 0, 0);\" transform=\"matrix(1, 0, 0, 1.000001, -232.069031, 248.780606)\" cx=\"482.069\" cy=\"198.188\" rx=\"23.028\" ry=\"23.028\"/>\n    <ellipse style=\"fill: rgb(0, 0, 0);\" transform=\"matrix(1, 0, 0, 0.999999, -232.067871, 110.041956)\" cx=\"482.067\" cy=\"198.188\" rx=\"23.028\" ry=\"23.028\"/>\n    <ellipse style=\"fill: rgb(0, 0, 0);\" cx=\"389.12\" cy=\"308.23\" rx=\"23.028\" ry=\"23.028\"/>\n    <ellipse style=\"fill: rgb(0, 0, 0);\" cx=\"110.88\" cy=\"308.23\" rx=\"23.028\" ry=\"23.028\"/>\n    <ellipse style=\"fill: rgb(0, 0, 0);\" cx=\"250\" cy=\"169.393\" rx=\"23.028\" ry=\"23.028\"/>\n    <g transform=\"matrix(1, 0, 0, 1, -0.000009, 0.000015)\">\n      <ellipse style=\"fill: rgb(0, 0, 0);\" cx=\"250\" cy=\"238.513\" rx=\"23.028\" ry=\"23.028\" transform=\"matrix(1.000001, 0, 0, 0.999999, 69.996739, 69.71816)\"/>\n      <ellipse style=\"fill: rgb(0, 0, 0);\" transform=\"matrix(1, 0, 0, 0.999999, -302.064453, 110.043115)\" cx=\"482.064\" cy=\"198.188\" rx=\"23.028\" ry=\"23.028\"/>\n    </g>\n    <g transform=\"matrix(0.866026, 0.5, -0.5, 0.866026, 7.386552, -105.261086)\">\n      <ellipse style=\"fill: rgb(0, 0, 0);\" transform=\"matrix(0.999999, 0, 0, 0.999999, -65.212313, 177.387415)\" cx=\"482.068\" cy=\"198.188\" rx=\"23.028\" ry=\"23.028\"/>\n      <ellipse style=\"fill: rgb(0, 0, 0);\" cx=\"555.975\" cy=\"236.836\" rx=\"23.028\" ry=\"23.028\"/>\n      <ellipse style=\"fill: rgb(0, 0, 0);\" cx=\"277.735\" cy=\"236.836\" rx=\"23.028\" ry=\"23.028\"/>\n      <ellipse style=\"fill: rgb(0, 0, 0);\" cx=\"416.855\" cy=\"97.999\" rx=\"23.028\" ry=\"23.028\"/>\n    </g>\n    <g transform=\"matrix(0.5, 0.866026, -0.866026, 0.5, 246.635941, -171.170502)\">\n      <ellipse style=\"fill: rgb(0, 0, 0);\" transform=\"matrix(0.999999, 0, 0, 0.999999, -65.212313, 177.387415)\" cx=\"482.068\" cy=\"198.188\" rx=\"23.028\" ry=\"23.028\"/>\n      <ellipse style=\"fill: rgb(0, 0, 0);\" cx=\"555.975\" cy=\"236.836\" rx=\"23.028\" ry=\"23.028\"/>\n      <ellipse style=\"fill: rgb(0, 0, 0);\" cx=\"277.735\" cy=\"236.836\" rx=\"23.028\" ry=\"23.028\"/>\n      <ellipse style=\"fill: rgb(0, 0, 0);\" cx=\"416.855\" cy=\"97.999\" rx=\"23.028\" ry=\"23.028\"/>\n    </g>\n    <g transform=\"matrix(-0.5, 0.866026, -0.866026, -0.5, 641.934998, 245.84082)\">\n      <ellipse style=\"fill: rgb(0, 0, 0);\" cx=\"250\" cy=\"238.513\" rx=\"23.028\" ry=\"23.028\" transform=\"matrix(1.000001, 0, 0, 0.999999, 69.996739, 69.71816)\"/>\n      <ellipse style=\"fill: rgb(0, 0, 0);\" transform=\"matrix(1, 0, 0, 0.999999, -302.064453, 110.043115)\" cx=\"482.064\" cy=\"198.188\" rx=\"23.028\" ry=\"23.028\"/>\n    </g>\n    <g transform=\"matrix(-0.500001, -0.866026, 0.866026, -0.500001, 108.063393, 678.85083)\">\n      <ellipse style=\"fill: rgb(0, 0, 0);\" cx=\"250\" cy=\"238.513\" rx=\"23.028\" ry=\"23.028\" transform=\"matrix(1.000001, 0, 0, 0.999999, 69.996739, 69.71816)\"/>\n      <ellipse style=\"fill: rgb(0, 0, 0);\" transform=\"matrix(1, 0, 0, 0.999999, -302.064453, 110.043115)\" cx=\"482.064\" cy=\"198.188\" rx=\"23.028\" ry=\"23.028\"/>\n    </g>\n  </g>\n</svg>",
      "pins.cpp": "#include \"pxt.h\"\n\nenum class DigitalPin {\n    P0 = MICROBIT_ID_IO_P0,\n    P1 = MICROBIT_ID_IO_P1,\n    P2 = MICROBIT_ID_IO_P2,\n    P3 = MICROBIT_ID_IO_P3,\n    P4 = MICROBIT_ID_IO_P4,\n    P5 = MICROBIT_ID_IO_P5,\n    P6 = MICROBIT_ID_IO_P6,\n    P7 = MICROBIT_ID_IO_P7,\n    P8 = MICROBIT_ID_IO_P8,\n    P9 = MICROBIT_ID_IO_P9,\n    P10 = MICROBIT_ID_IO_P10,\n    P11 = MICROBIT_ID_IO_P11,\n    P12 = MICROBIT_ID_IO_P12,\n    P13 = MICROBIT_ID_IO_P13,\n    P14 = MICROBIT_ID_IO_P14,\n    P15 = MICROBIT_ID_IO_P15,\n    P16 = MICROBIT_ID_IO_P16,\n    P19 = MICROBIT_ID_IO_P19,\n    P20 = MICROBIT_ID_IO_P20,\n};\n\nenum class AnalogPin {\n    P0 = MICROBIT_ID_IO_P0,\n    P1 = MICROBIT_ID_IO_P1,\n    P2 = MICROBIT_ID_IO_P2,\n    P3 = MICROBIT_ID_IO_P3,\n    P4 = MICROBIT_ID_IO_P4,\n    P10 = MICROBIT_ID_IO_P10,\n    //% block=\"P5 (write only)\"\n    P5 = MICROBIT_ID_IO_P5,\n    //% block=\"P6 (write only)\"\n    P6 = MICROBIT_ID_IO_P6,\n    //% block=\"P7 (write only)\"\n    P7 = MICROBIT_ID_IO_P7,\n    //% block=\"P8 (write only)\"\n    P8 = MICROBIT_ID_IO_P8,\n    //% block=\"P9 (write only)\"\n    P9 = MICROBIT_ID_IO_P9,\n    //% block=\"P11 (write only)\"\n    P11 = MICROBIT_ID_IO_P11,\n    //% block=\"P12 (write only)\"\n    P12 = MICROBIT_ID_IO_P12,\n    //% block=\"P13 (write only)\"\n    P13 = MICROBIT_ID_IO_P13,\n    //% block=\"P14 (write only)\"\n    P14 = MICROBIT_ID_IO_P14,\n    //% block=\"P15 (write only)\"\n    P15 = MICROBIT_ID_IO_P15,\n    //% block=\"P16 (write only)\"\n    P16 = MICROBIT_ID_IO_P16,\n    //% block=\"P19 (write only)\"\n    P19 = MICROBIT_ID_IO_P19,\n    //% block=\"P20 (write only)\"\n    P20 = MICROBIT_ID_IO_P20\n};\n\nenum class PulseValue {\n    //% block=high\n    High = MICROBIT_PIN_EVT_PULSE_HI,\n    //% block=low\n    Low = MICROBIT_PIN_EVT_PULSE_LO\n};\n\nenum class PinPullMode {\n    //% block=\"down\"\n    PullDown = 0,\n    //% block=\"up\"\n    PullUp = 1,\n    //% block=\"none\"\n    PullNone = 2\n};\n\nenum class PinEventType {\n    //% block=\"edge\"\n    Edge = MICROBIT_PIN_EVENT_ON_EDGE,\n    //% block=\"pulse\"\n    Pulse = MICROBIT_PIN_EVENT_ON_PULSE,\n    //% block=\"touch\"\n    Touch = MICROBIT_PIN_EVENT_ON_TOUCH,\n    //% block=\"none\"\n    None = MICROBIT_PIN_EVENT_NONE\n};\n\nMicroBitPin *getPin(int id) {\n    switch (id) {\n        case MICROBIT_ID_IO_P0: return &uBit.io.P0;\n        case MICROBIT_ID_IO_P1: return &uBit.io.P1;\n        case MICROBIT_ID_IO_P2: return &uBit.io.P2;\n        case MICROBIT_ID_IO_P3: return &uBit.io.P3;\n        case MICROBIT_ID_IO_P4: return &uBit.io.P4;\n        case MICROBIT_ID_IO_P5: return &uBit.io.P5;\n        case MICROBIT_ID_IO_P6: return &uBit.io.P6;\n        case MICROBIT_ID_IO_P7: return &uBit.io.P7;\n        case MICROBIT_ID_IO_P8: return &uBit.io.P8;\n        case MICROBIT_ID_IO_P9: return &uBit.io.P9;\n        case MICROBIT_ID_IO_P10: return &uBit.io.P10;\n        case MICROBIT_ID_IO_P11: return &uBit.io.P11;\n        case MICROBIT_ID_IO_P12: return &uBit.io.P12;\n        case MICROBIT_ID_IO_P13: return &uBit.io.P13;\n        case MICROBIT_ID_IO_P14: return &uBit.io.P14;\n        case MICROBIT_ID_IO_P15: return &uBit.io.P15;\n        case MICROBIT_ID_IO_P16: return &uBit.io.P16;\n        case MICROBIT_ID_IO_P19: return &uBit.io.P19;\n        case MICROBIT_ID_IO_P20: return &uBit.io.P20;\n        default: return NULL;\n    }\n}\n\n\nnamespace pins {\n    #define PINOP(op) \\\n      MicroBitPin *pin = getPin((int)name); \\\n      if (!pin) return; \\\n      pin->op\n\n    #define PINREAD(op) \\\n      MicroBitPin *pin = getPin((int)name); \\\n      if (!pin) return 0; \\\n      return pin->op\n\n\n    //%\n    MicroBitPin *getPinAddress(int id) {\n        return getPin(id);\n    }\n\n    /**\n     * Read the specified pin or connector as either 0 or 1\n     * @param name pin to read from, eg: DigitalPin.P0\n     */\n    //% help=pins/digital-read-pin weight=30\n    //% blockId=device_get_digital_pin block=\"digital read|pin %name\" blockGap=8\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\" name.fieldOptions.width=\"300\"\n    int digitalReadPin(DigitalPin name) {\n        PINREAD(getDigitalValue());\n    }\n\n    /**\n      * Set a pin or connector value to either 0 or 1.\n      * @param name pin to write to, eg: DigitalPin.P0\n      * @param value value to set on the pin, 1 eg,0\n      */\n    //% help=pins/digital-write-pin weight=29\n    //% blockId=device_set_digital_pin block=\"digital write|pin %name|to %value\"\n    //% value.min=0 value.max=1\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\" name.fieldOptions.width=\"300\"\n    void digitalWritePin(DigitalPin name, int value) {\n        PINOP(setDigitalValue(value));\n    }\n\n    /**\n     * Read the connector value as analog, that is, as a value comprised between 0 and 1023.\n     * @param name pin to write to, eg: AnalogPin.P0\n     */\n    //% help=pins/analog-read-pin weight=25\n    //% blockId=device_get_analog_pin block=\"analog read|pin %name\" blockGap=\"8\"\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\"\n    int analogReadPin(AnalogPin name) {\n        PINREAD(getAnalogValue());\n    }\n\n    /**\n     * Set the connector value as analog. Value must be comprised between 0 and 1023.\n     * @param name pin name to write to, eg: AnalogPin.P0\n     * @param value value to write to the pin between ``0`` and ``1023``. eg:1023,0\n     */\n    //% help=pins/analog-write-pin weight=24\n    //% blockId=device_set_analog_pin block=\"analog write|pin %name|to %value\" blockGap=8\n    //% value.min=0 value.max=1023\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\"\n    void analogWritePin(AnalogPin name, int value) {\n        PINOP(setAnalogValue(value));\n    }\n\n    /**\n     * Configures the Pulse-width modulation (PWM) of the analog output to the given value in **microseconds** or `1/1000` milliseconds.\n     * If this pin is not configured as an analog output (using `analog write pin`), the operation has no effect.\n     * @param name analog pin to set period to, eg: AnalogPin.P0\n     * @param micros period in micro seconds. eg:20000\n     */\n    //% help=pins/analog-set-period weight=23 blockGap=8\n    //% blockId=device_set_analog_period block=\"analog set period|pin %pin|to (µs)%micros\"\n    //% pin.fieldEditor=\"gridpicker\" pin.fieldOptions.columns=4\n    //% pin.fieldOptions.tooltips=\"false\"\n    void analogSetPeriod(AnalogPin name, int micros) {\n        PINOP(setAnalogPeriodUs(micros));\n    }\n\n    /**\n    * Configures this pin to a digital input, and generates events where the timestamp is the duration that this pin was either ``high`` or ``low``.\n    * @param name digital pin to register to, eg: DigitalPin.P0\n    * @param pulse the value of the pulse, eg: PulseValue.High\n    */\n    //% help=pins/on-pulsed weight=22 blockGap=8 advanced=true\n    //% blockId=pins_on_pulsed block=\"on|pin %pin|pulsed %pulse\"\n    //% pin.fieldEditor=\"gridpicker\" pin.fieldOptions.columns=4\n    //% pin.fieldOptions.tooltips=\"false\" pin.fieldOptions.width=\"300\"\n    void onPulsed(DigitalPin name, PulseValue pulse, Action body) {\n        MicroBitPin* pin = getPin((int)name);\n        if (!pin) return;\n\n        pin->eventOn(MICROBIT_PIN_EVENT_ON_PULSE);\n        registerWithDal((int)name, (int)pulse, body);\n    }\n\n    /**\n    * Gets the duration of the last pulse in micro-seconds. This function should be called from a ``onPulsed`` handler.\n    */\n    //% help=pins/pulse-duration advanced=true\n    //% blockId=pins_pulse_duration block=\"pulse duration (µs)\"\n    //% weight=21 blockGap=8\n    int pulseDuration() {\n        return pxt::lastEvent.timestamp;\n    }\n\n    /**\n    * Returns the duration of a pulse in microseconds\n    * @param name the pin which measures the pulse, eg: DigitalPin.P0\n    * @param value the value of the pulse, eg: PulseValue.High\n    * @param maximum duration in micro-seconds\n    */\n    //% blockId=\"pins_pulse_in\" block=\"pulse in (µs)|pin %name|pulsed %value\"\n    //% weight=20 advanced=true\n    //% help=pins/pulse-in\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\" name.fieldOptions.width=\"300\"\n    int pulseIn(DigitalPin name, PulseValue value, int maxDuration = 2000000) {\n        MicroBitPin* pin = getPin((int)name);\n        if (!pin) return 0;\n\n        int pulse = value == PulseValue::High ? 1 : 0;\n        uint64_t tick =  system_timer_current_time_us();\n        uint64_t maxd = (uint64_t)maxDuration;\n        while(pin->getDigitalValue() != pulse) {\n            if(system_timer_current_time_us() - tick > maxd)\n                return 0;\n        }\n\n        uint64_t start =  system_timer_current_time_us();\n        while(pin->getDigitalValue() == pulse) {\n            if(system_timer_current_time_us() - tick > maxd)\n                return 0;\n        }\n        uint64_t end =  system_timer_current_time_us();\n        return end - start;\n    }\n\n    /**\n     * Writes a value to the servo, controlling the shaft accordingly. On a standard servo, this will set the angle of the shaft (in degrees), moving the shaft to that orientation. On a continuous rotation servo, this will set the speed of the servo (with ``0`` being full-speed in one direction, ``180`` being full speed in the other, and a value near ``90`` being no movement).\n     * @param name pin to write to, eg: AnalogPin.P0\n     * @param value angle or rotation speed, eg:180,90,0\n     */\n    //% help=pins/servo-write-pin weight=20\n    //% blockId=device_set_servo_pin block=\"servo write|pin %name|to %value\" blockGap=8\n    //% parts=microservo trackArgs=0\n    //% value.min=0 value.max=180\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\"\n    void servoWritePin(AnalogPin name, int value) {\n        PINOP(setServoValue(value));\n    }\n\n    /**\n     * Configures this IO pin as an analog/pwm output, configures the period to be 20 ms, and sets the pulse width, based on the value it is given **microseconds** or `1/1000` milliseconds.\n     * @param name pin name\n     * @param micros pulse duration in micro seconds, eg:1500\n     */\n    //% help=pins/servo-set-pulse weight=19\n    //% blockId=device_set_servo_pulse block=\"servo set pulse|pin %value|to (µs) %micros\"\n    //% value.fieldEditor=\"gridpicker\" value.fieldOptions.columns=4\n    //% value.fieldOptions.tooltips=\"false\"\n    void servoSetPulse(AnalogPin name, int micros) {\n        PINOP(setServoPulseUs(micros));\n    }\n\n\n    MicroBitPin* pitchPin = NULL;\n\n    /**\n     * Sets the pin used when using `analog pitch` or music.\n     * @param name pin to modulate pitch from\n     */\n    //% blockId=device_analog_set_pitch_pin block=\"analog set pitch pin %name\"\n    //% help=pins/analog-set-pitch-pin weight=3 advanced=true\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\"\n    void analogSetPitchPin(AnalogPin name) {\n      pitchPin = getPin((int)name);\n    }\n\n    /**\n     * Emits a Pulse-width modulation (PWM) signal to the current pitch pin. Use `analog set pitch pin` to define the pitch pin.\n     * @param frequency frequency to modulate in Hz.\n     * @param ms duration of the pitch in milli seconds.\n     */\n    //% blockId=device_analog_pitch block=\"analog pitch %frequency|for (ms) %ms\"\n    //% help=pins/analog-pitch weight=4 async advanced=true blockGap=8\n    void analogPitch(int frequency, int ms) {\n      if (pitchPin == NULL)\n        analogSetPitchPin(AnalogPin::P0);\n      if (frequency <= 0) {\n        pitchPin->setAnalogValue(0);\n      } else {\n        pitchPin->setAnalogValue(512);\n        pitchPin->setAnalogPeriodUs(1000000/frequency);\n      }\n\n      if (ms > 0) {\n          fiber_sleep(ms);\n          pitchPin->setAnalogValue(0);\n          // TODO why do we use wait_ms() here? it's a busy wait I think\n          wait_ms(5);\n      }\n    }\n\n\n    /**\n    * Configures the pull of this pin.\n    * @param name pin to set the pull mode on, eg: DigitalPin.P0\n    * @param pull one of the mbed pull configurations, eg: PinPullMode.PullUp\n    */\n    //% help=pins/set-pull weight=3 advanced=true\n    //% blockId=device_set_pull block=\"set pull|pin %pin|to %pull\"\n    //% pin.fieldEditor=\"gridpicker\" pin.fieldOptions.columns=4\n    //% pin.fieldOptions.tooltips=\"false\" pin.fieldOptions.width=\"300\"\n    void setPull(DigitalPin name, PinPullMode pull) {\n        PinMode m = pull == PinPullMode::PullDown\n            ? PinMode::PullDown\n            : pull == PinPullMode::PullUp ? PinMode::PullUp\n            : PinMode::PullNone;\n        PINOP(setPull(m));\n    }\n\n    /**\n    * Configures the events emitted by this pin. Events can be subscribed to\n    * using ``control.onEvent()``.\n    * @param name pin to set the event mode on, eg: DigitalPin.P0\n    * @param type the type of events for this pin to emit, eg: PinEventType.Edge\n    */\n    //% help=pins/set-events weight=4 advanced=true\n    //% blockId=device_set_pin_events block=\"set pin %pin|to emit %type|events\"\n    //% pin.fieldEditor=\"gridpicker\" pin.fieldOptions.columns=4\n    //% pin.fieldOptions.tooltips=\"false\" pin.fieldOptions.width=\"300\"\n    void setEvents(DigitalPin name, PinEventType type) {\n        getPin((int)name)->eventOn((int)type);\n    }\n\n    /**\n     * Create a new zero-initialized buffer.\n     * @param size number of bytes in the buffer\n     */\n    //%\n    Buffer createBuffer(int size)\n    {\n        return ManagedBuffer(size).leakData();\n    }\n\n    /**\n     * Read `size` bytes from a 7-bit I2C `address`.\n     */\n    //%\n    Buffer i2cReadBuffer(int address, int size, bool repeat = false)\n    {\n      Buffer buf = createBuffer(size);\n      uBit.i2c.read(address << 1, (char*)buf->payload, size, repeat);\n      return buf;\n    }\n\n    /**\n     * Write bytes to a 7-bit I2C `address`.\n     */\n    //%\n    void i2cWriteBuffer(int address, Buffer buf, bool repeat = false)\n    {\n      uBit.i2c.write(address << 1, (char*)buf->payload, buf->length, repeat);\n    }\n\n    SPI* spi = NULL;\n    SPI* allocSPI() {\n        if (NULL == spi)\n            spi = new SPI(MOSI, MISO, SCK);\n        return spi;\n    }\n\n    /**\n    * Write to the SPI slave and return the response\n    * @param value Data to be sent to the SPI slave\n    */\n    //% help=pins/spi-write weight=5 advanced=true\n    //% blockId=spi_write block=\"spi write %value\"\n    int spiWrite(int value) {\n        auto p = allocSPI();\n        return p->write(value);\n    }\n\n    /**\n    * Sets the SPI frequency\n    * @param frequency the clock frequency, eg: 1000000\n    */\n    //% help=pins/spi-frequency weight=4 advanced=true\n    //% blockId=spi_frequency block=\"spi frequency %frequency\"\n    void spiFrequency(int frequency) {\n        auto p = allocSPI();\n        p->frequency(frequency);\n    }\n\n    /**\n    * Sets the SPI bits and mode\n    * @param bits the number of bits, eg: 8\n    * @param mode the mode, eg: 3\n    */\n    //% help=pins/spi-format weight=3 advanced=true\n    //% blockId=spi_format block=\"spi format|bits %bits|mode %mode\"\n    void spiFormat(int bits, int mode) {\n        auto p = allocSPI();\n        p->format(bits, mode);        \n    }\n\n    /**\n    * Sets the MOSI, MISO, SCK pins used by the SPI instance\n    *\n    */\n    //% help=pins/spi-pins weight=2 advanced=true\n    //% blockId=spi_pins block=\"spi set pins|MOSI %mosi|MISO %miso|SCK %sck\"\n    void spiPins(DigitalPin mosi, DigitalPin miso, DigitalPin sck) {\n        if (NULL != spi) {\n            delete spi;\n            spi = NULL;\n        }\n\n        spi = new SPI(getPin((int)mosi)->name, getPin((int)miso)->name, getPin((int)sck)->name);\n    }\n}\n",
      "pins.ts": "/**\n * Control currents in Pins for analog/digital signals, servos, i2c, ...\n */\n//% color=#A80000 weight=30 icon=\"\\uf140\"\n//% advanced=true\nnamespace pins {\n    /**\n     * Re-maps a number from one range to another. That is, a value of ``from low`` would get mapped to ``to low``, a value of ``from high`` to ``to high``, values in-between to values in-between, etc.\n     * @param value value to map in ranges\n     * @param fromLow the lower bound of the value's current range\n     * @param fromHigh the upper bound of the value's current range, eg: 1023\n     * @param toLow the lower bound of the value's target range\n     * @param toHigh the upper bound of the value's target range, eg: 4\n     */\n    //% help=pins/map weight=23\n    //% blockId=math_map block=\"map %value|from low %fromLow|from high %fromHigh|to low %toLow|to high %toHigh\"\n    export function map(value: number, fromLow: number, fromHigh: number, toLow: number, toHigh: number): number {\n        return ((value - fromLow) * (toHigh - toLow)) / (fromHigh - fromLow) + toLow;\n    }\n\n    /**\n     * Read one number from 7-bit I2C address.\n     */\n    //% help=pins/i2c-read-number blockGap=8 advanced=true\n    //% blockId=pins_i2c_readnumber block=\"i2c read number|at address %address|of format %format=i2c_sizeof|repeated %repeat\" weight=7\n    export function i2cReadNumber(address: number, format: NumberFormat, repeated?: boolean): number {\n        let buf = pins.i2cReadBuffer(address, pins.sizeOf(format), repeated)\n        return buf.getNumber(format, 0)\n    }\n\n    /**\n     * Write one number to a 7-bit I2C address.\n     */\n    //% help=pins/i2c-write-number blockGap=8 advanced=true\n    //% blockId=i2c_writenumber block=\"i2c write number|at address %address|with value %value|of format %format=i2c_sizeof|repeated %repeat\" weight=6\n    export function i2cWriteNumber(address: number, value: number, format: NumberFormat, repeated?: boolean): void {\n        let buf = createBuffer(pins.sizeOf(format))\n        buf.setNumber(format, 0, value)\n        pins.i2cWriteBuffer(address, buf, repeated)\n    }\n\n    /**\n     * Get the size in bytes of specified number format.\n     */\n    //%\n    export function sizeOf(format: NumberFormat) {\n        switch (format) {\n            case NumberFormat.Int8LE:\n            case NumberFormat.UInt8LE:\n            case NumberFormat.Int8BE:\n            case NumberFormat.UInt8BE:\n                return 1;\n            case NumberFormat.Int16LE:\n            case NumberFormat.UInt16LE:\n            case NumberFormat.Int16BE:\n            case NumberFormat.UInt16BE:\n                return 2;\n            case NumberFormat.Int32LE:\n            case NumberFormat.Int32BE:\n                return 4;\n        }\n        return 0;\n    }\n}\n\n\ninterface Buffer {\n    [index: number]: number;\n    // rest defined in buffer.cpp\n}\n",
      "pxt-core.d.ts": "/// <reference no-default-lib=\"true\"/>\n\ninterface Array<T> {\n    /**\n      * Gets or sets the length of the array. This is a number one higher than the highest element defined in an array.\n      */\n    //% shim=Array_::length weight=84\n    //% blockId=\"lists_length\" block=\"length of %VALUE\" blockBuiltin=true blockNamespace=\"arrays\"\n    length: number;\n\n    /**\n      * Append a new elements to an array.\n      * @param item to append to the Array.\n      */\n    //% help=arrays/push\n    //% shim=Array_::push weight=75\n    //% blockId=\"array_push\" block=\"%list| add value %value| to end\" blockNamespace=\"arrays\"\n    push(item: T): void;\n\n    /**\n      * Remove the last element from an array and return it.\n      */\n    //% help=arrays/pop\n    //% shim=Array_::pop weight=74\n    //% blockId=\"array_pop\" block=\"get and remove last value from %list\" blockNamespace=\"arrays\"\n    pop(): T;\n\n    /**\n      * Reverse the elements in an array. The first array element becomes the last, and the last array element becomes the first.\n      */\n    //% help=arrays/reverse\n    //% helper=arrayReverse weight=10 advanced=true\n    //% blockId=\"array_reverse\" block=\"reverse %list\" blockNamespace=\"arrays\"\n    reverse(): void;\n\n    /**\n      * Remove the first element from an array and return it. This method changes the length of the array.\n      */\n    //% help=arrays/shift\n    //% helper=arrayShift weight=70 advanced=true\n    //% blockId=\"array_shift\" block=\"get and remove first value from %list\" blockNamespace=\"arrays\"\n    shift(): T;\n\n    /**\n      * Add one element to the beginning of an array and return the new length of the array.\n      * @param value to insert at the start of the Array.\n      */\n    //% help=arrays/unshift\n    //% helper=arrayUnshift weight=69 advanced=true\n    //% blockId=\"array_unshift\" block=\"%list| insert %value| at beginning\" blockNamespace=\"arrays\"\n    //unshift(...values:T[]): number; //rest is not supported in our compiler yet.\n    unshift(value:T): number;\n\n    /**\n      * Return a section of an array.\n      * @param start The beginning of the specified portion of the array. eg: 0\n      * @param end The end of the specified portion of the array. eg: 0\n      */\n    //% help=arrays/slice\n    //% helper=arraySlice weight=41 advanced=true blockNamespace=\"arrays\"\n    slice(start: number, end: number): T[];\n\n    /**\n      * Remove elements from an array.\n      * @param start The zero-based location in the array from which to start removing elements. eg: 0\n      * @param deleteCount The number of elements to remove. eg: 0\n      */\n    //% helper=arraySplice weight=40\n    splice(start: number, deleteCount: number): void;\n\n    /**\n      * Sort the elements of an array in place and returns the array. The sort is not necessarily stable.\n      * @param specifies a function that defines the sort order. If omitted, the array is sorted according to the prmitive type\n      */\n    //% helper=arraySort weight=40\n    sort(callbackfn?: (value1: T, value2: T) => number): T[];\n\n    /**\n      * Call a defined callback function on each element of an array, and return an array containing the results.\n      * @param callbackfn A function that accepts up to two arguments. The map method calls the callbackfn function one time for each element in the array.\n      */\n    //% helper=arrayMap weight=40\n    map<U>(callbackfn: (value: T, index: number) => U): U[];\n\n    /**\n      * Return the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to two arguments. The filter method calls the callbackfn function one time for each element in the array.\n      */\n    //% helper=arrayFilter weight=40\n    filter(callbackfn: (value: T, index: number) => boolean): T[];\n\n    /**\n      * Call the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to three arguments. The reduce method calls the callbackfn function one time for each element in the array.\n      * @param initialValue Initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    //% helper=arrayReduce weight=40\n    reduce<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number) => U, initialValue: U): U;\n\n\n    /**\n     * Remove the first occurence of an object. Return true if removed.\n     */\n    //% shim=Array_::removeElement weight=48\n    removeElement(element:T) : boolean;\n\n    /** \n     * Remove the element at a certain index.\n     * @param index the zero-based position in the list to remove the value from, eg: 0\n     */\n    //% help=arrays/remove-at\n    //% shim=Array_::removeAt weight=49 advanced=true\n    //% blockId=\"array_removeat\" block=\"%list| remove value at %index\" blockNamespace=\"arrays\"\n    removeAt(index:number) : T;\n\n    /**\n     * Insert the value at a particular index, increase the array length by 1.\n     * @param index the zero-based position in the list to insert the value, eg: 0\n     * @param value to insert, eg: 0\n     */\n    //% help=arrays/insert-at\n    //% shim=Array_::insertAt weight=84 advanced=true\n    //% blockId=\"array_insertAt\" block=\"%list| insert at %index| value %value\" blockNamespace=\"arrays\"\n    insertAt(index:number, value: T) : void;\n\n    /**\n      * Return the index of the first occurrence of a value in an array.\n      * @param item The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the search starts at index 0.\n      */\n    //% help=arrays/index-of\n    //% shim=Array_::indexOf weight=50 advanced=true\n    //% blockId=\"array_indexof\" block=\"%list| find index of %value\" blockNamespace=\"arrays\"\n    indexOf(item: T, fromIndex?: number): number;\n\n    /**\n     * Get the value at a particular index.\n     * @param index the zero-based position in the list of the item, eg: 0\n     */\n    //% help=arrays/get\n    //% shim=Array_::getAt weight=85\n    get(index: number): T;\n\n    /**\n     * Store a value at a particular index.\n     * @param index the zero-based position in the list to store the value, eg: 0\n     * @param the value to insert, eg: 0\n     */\n    //% help=arrays/set\n    //% shim=Array_::setAt weight=84\n    set(index: number, value : T) : void;\n\n    [n: number]: T;\n}\n\ndeclare interface String {\n    // This block is currently disabled in favor of the built-in Blockly \"Create text with\" block, which compiles to \"\" + \"\"\n    // Add % sign back to the block annotation to re-enable\n    /**\n     * Returns a string that contains the concatenation of two or more strings.\n     * @param other The string to append to the end of the string, eg: \"add me!\"\n     */\n    //% shim=String_::concat weight=80\n    //% blockId=\"string_concat\" blockNamespace=\"text\"\n    // block=\"join %list=text|%other\"\n    concat(other: string): string;\n\n    /**\n     * Return the character at the specified index.\n     * @param index The zero-based index of the desired character, eg: 0\n     */\n    //% shim=String_::charAt weight=77\n    //% help=text/char-at\n    //% blockId=\"string_get\" block=\"char from %this=text|at %pos\" blockNamespace=\"text\"\n    charAt(index: number): string;\n\n    /** Return the length of a String object. */\n    //% property shim=String_::length weight=75\n    //% blockId=\"text_length\" block=\"length of %VALUE\" blockBuiltin=true blockNamespace=\"text\"\n    length: number;\n\n    /**\n     * Return the Unicode value of the character at the specified location.\n     * @param index The zero-based index of the desired character. If there is no character at the specified index, NaN is returned.\n     */\n    //% shim=String_::charCodeAt\n    charCodeAt(index: number): number;\n\n    /**\n     * See how the order of characters in two strings is different (in ASCII encoding).\n     * @param that String to compare to target string\n     */\n    //% shim=String_::compare\n    //% help=text/compare\n    //% blockId=\"string_compare\" block=\"compare %this=text| to %that\" blockNamespace=\"text\"\n    compare(that: string): number;\n\n    /**\n     * Return a substring of the current string.\n     * @param start first character index; can be negative from counting from the end, eg: 0\n     * @param length number of characters to extract, eg: 3\n     */\n    //% shim=String_::substr length.defl=1000000\n    //% help=text/substr\n    //% blockId=\"string_substr\" block=\"substring of %this=text|from %start|of length %length\" blockNamespace=\"text\"\n    substr(start: number, length?: number): string;\n\n    // This block is currently disabled, as it does not compile in some targets\n    // Add % sign back to the block annotation to re-enable\n    /** Returns a value indicating if the string is empty */\n    //% shim=String_::isEmpty\n    //% blockId=\"string_isempty\" blockNamespace=\"text\"\n    // block=\"%this=text| is empty\"\n    isEmpty(): boolean;\n\n\n    [index: number]: string;\n}\n\n/**\n  * Convert A string to an integer.\n  * @param s A string to convert into a number.\n  */\n//% shim=String_::toNumber\n//% help=text/parse-int\n//% blockId=\"string_parseint\" block=\"parse to integer %text\" blockNamespace=\"text\"\ndeclare function parseInt(text: string): number;\n\ninterface Object {}\ninterface Function {}\ninterface IArguments {}\ninterface RegExp {}\n\ntype uint8 = number;\ntype uint16 = number;\n//type uint32 = number;\ntype int8 = number;\ntype int16 = number;\ntype int32 = number;\n\n\ndeclare interface Boolean {\n    /**\n     * Returns a string representation of an object.\n     */\n    //% shim=Boolean_::toString\n    toString(): string;\n}\n\n/**\n * Combine, split, and search text strings.\n */\n//% blockNamespace=\"Text\"\ndeclare namespace String {\n\n    /**\n     * Make a string from the given ASCII character code.\n     */\n    //% help=math/from-char-code\n    //% shim=String_::fromCharCode\n    //% advanced=true\n    //% blockNamespace=\"Math\" blockId=\"stringFromCharCode\" block=\"text from char code %code\" weight=1\n    function fromCharCode(code: number): string;\n}\n\n\ndeclare interface Number {\n    /**\n     * Return a string representation of a number.\n     */\n    //% shim=Number_::toString\n    toString(): string;\n}\n\n/**\n * Add, remove, and replace items in lists.\n */\n//% blockNamespace=\"Arrays\"\ndeclare namespace Array {\n}\n\n/**\n * More complex operations with numbers.\n */\ndeclare namespace Math {\n\n    /**\n     * Return the value of a base expression taken to a specified power.\n     * @param x The base value of the expression.\n     * @param y The exponent value of the expression.\n     */\n    //% shim=Math_::pow\n    function pow(x: number, y: number): number;\n\n    /**\n     * Return a pseudorandom number between 0 and `limit`.\n     * @param limit the upper bound of the number generated, eg: 4.\n     */\n    //% blockId=\"device_random\" block=\"pick random 0 to %limit\" blockGap=8\n    //% help=math/random\n    //% shim=Math_::random\n    function random(limit: number): number;\n\n    /**\n     * Return the square root of a number.\n     * @param x A numeric expression.\n     */\n    //% shim=Math_::sqrt\n    function sqrt(x: number): number;\n\n}\n",
      "pxt-helpers.ts": "type Action = () => void;\n\nnamespace helpers {\n    export function arraySplice<T>(arr: T[], start: number, len: number) {\n        if (start < 0) {\n            return;\n        }\n        for (let i = 0; i < len; ++i) {\n            arr.removeAt(start)\n        }\n    }\n\n    export function arrayReverse<T>(arr: T[]) : void {\n        let len = arr.length;\n        for (let i = 0; i < len/2; i++)\n        {\n            swap(arr, i, len - i - 1);\n        }\n    }\n\n    export function arrayShift<T>(arr: T[]) : T {\n        return arr.removeAt(0);\n    }\n\n/*TODO: Enable this multiple value unshift, after rest is enabled in our compiler.\n    export function arrayUnshift<T>(arr: T[], ...values: T[]) : number {\n        for(let i = values.length; i > 0; --i) {\n            arr.insertAt(0, values[i - 1]);\n        }\n        return arr.length;\n    }\n*/\n    export function arrayUnshift<T>(arr: T[], value: T) : number {\n        arr.insertAt(0, value);\n       return arr.length;\n    }\n\n    function swap<T>(arr: T[], i : number, j: number) : void {\n        let temp : T = arr[i];\n        arr[i] = arr[j];\n        arr[j] = temp;\n    }\n\n    function sortHelper<T>(arr: T[], callbackfn ?: (value1: T, value2: T) => number) : T[] {\n        if (arr.length <= 0 || !callbackfn) {\n            return arr;\n        }\n        let len = arr.length;\n        // simple selection sort.\n        for (let i = 0; i < len - 1; ++i) {\n            for (let j = i + 1; j < len; ++j)\n            {\n                if (callbackfn(arr[i], arr[j]) > 0) {\n                    swap(arr, i, j);\n                }\n            }\n        }\n        return arr;\n    }\n\n    export function arraySort<T>(arr: T[], callbackfn?: (value1: T, value2: T) => number): T[] {\n        if (!callbackfn) {\n            //TODO: support native strings and number sorting\n            /* callbackfn = function (value1: string, value2: string) : number {\n                return value1.compare(value2);\n                }*/\n        }\n        return sortHelper(arr, callbackfn);\n    }\n\n    export function arrayMap<T, U>(arr: T[], callbackfn: (value: T, index: number) => U): U[] {\n        let res: U[] = []\n        let len = arr.length // caching this seems to match V8\n        for (let i = 0; i < len; ++i) {\n            res.push(callbackfn(arr[i], i))\n        }\n        return res\n    }\n\n    export function arrayFilter<T>(arr: T[], callbackfn: (value: T, index: number) => boolean): T[] {\n        let res: T[] = []\n        let len = arr.length\n        for (let i = 0; i < len; ++i) {\n            let v = arr[i] // need to cache\n            if (callbackfn(v, i)) res.push(v)\n        }\n        return res\n    }\n\n    export function arrayReduce<T, U>(arr: T[], callbackfn: (previousValue: U, currentValue: T, currentIndex: number) => U, initialValue: U): U {\n        let len = arr.length\n        for (let i = 0; i < len; ++i) {\n            initialValue = callbackfn(initialValue, arr[i], i)\n        }\n        return initialValue\n    }\n\n    export function arraySlice<T>(arr: T[], start: number, end: number): T[] {\n        const res: T[] = [];\n        const len = arr.length;\n\n        if (start < 0) {\n            start = Math.max(len + start, 0);\n        }\n\n        if (end < 0) {\n            end = len + end;\n        }\n\n        const sliceLength = end - start;\n\n        for (let i = 0; i < sliceLength; ++i) {\n            const index = i + start;\n            if (index >= len) {\n                break;\n            }\n            res.push(arr[index]);\n        }\n        return res;\n    }\n}\n\nnamespace Math {\n    export function clamp(min: number, max: number, value: number): number {\n        return Math.min(max, Math.max(min, value));\n    }\n\n    /**\n      * Returns the absolute value of a number (the value without regard to whether it is positive or negative).\n      * For example, the absolute value of -5 is the same as the absolute value of 5.\n      * @param x A numeric expression for which the absolute value is needed.\n      */\n    export function abs(x: number): number {\n        return x < 0 ? -x : x;\n    }\n\n    /**\n      * Returns the sign of the x, indicating whether x is positive, negative or zero.\n      * @param x The numeric expression to test\n      */\n    export function sign(x: number): number {\n        if (x == 0) return 0;\n        if (x > 0) return 1;\n        return -1;\n    }\n\n    /**\n      * Returns the larger of two supplied numeric expressions.\n      */\n    export function max(a: number, b: number): number {\n        if (a >= b) return a;\n        return b;\n    }\n\n    /**\n      * Returns the smaller of two supplied numeric expressions.\n      */\n    export function min(a: number, b: number): number {\n        if (a <= b) return a;\n        return b;\n    }\n}\n",
      "pxt.cpp": "#include \"pxt.h\"\n#include <map>\n\nMicroBit uBit;\n\nnamespace pxt {\n    int incr(uint32_t e)\n    {\n      if (e) {\n        if (hasVTable(e))\n          ((RefObject*)e)->ref();\n        else\n          ((RefCounted*)e)->incr();\n      }\n      return e;\n    }\n\n    void decr(uint32_t e)\n    {\n      if (e) {\n        if (hasVTable(e))\n          ((RefObject*)e)->unref();\n        else\n          ((RefCounted*)e)->decr();\n      }\n    }\n\n    Action mkAction(int reflen, int totallen, int startptr)\n    {\n      check(0 <= reflen && reflen <= totallen, ERR_SIZE, 1);\n      check(reflen <= totallen && totallen <= 255, ERR_SIZE, 2);\n      check(bytecode[startptr] == 0xffff, ERR_INVALID_BINARY_HEADER, 3);\n      check(bytecode[startptr + 1] == 0, ERR_INVALID_BINARY_HEADER, 4);\n\n      uint32_t tmp = (uint32_t)&bytecode[startptr];\n\n      if (totallen == 0) {\n        return tmp; // no closure needed\n      }\n\n      void *ptr = ::operator new(sizeof(RefAction) + totallen * sizeof(uint32_t));\n      RefAction *r = new (ptr) RefAction();\n      r->len = totallen;\n      r->reflen = reflen;\n      r->func = (ActionCB)((tmp + 4) | 1);\n      memset(r->fields, 0, r->len * sizeof(uint32_t));\n\n      return (Action)r;\n    }\n\n    uint32_t runAction3(Action a, int arg0, int arg1, int arg2)\n    {\n      if (hasVTable(a))\n        return ((RefAction*)a)->runCore(arg0, arg1, arg2);\n      else {\n        check(*(uint16_t*)a == 0xffff, ERR_INVALID_BINARY_HEADER, 4);\n        return ((ActionCB)((a + 4) | 1))(NULL, arg0, arg1, arg2);\n      }\n    }\n\n    uint32_t runAction2(Action a, int arg0, int arg1)\n    {\n      return runAction3(a, arg0, arg1, 0);\n    }\n\n    uint32_t runAction1(Action a, int arg0)\n    {\n      return runAction3(a, arg0, 0, 0);\n    }\n\n    uint32_t runAction0(Action a)\n    {\n      return runAction3(a, 0, 0, 0);\n    }\n\n    RefRecord* mkClassInstance(int vtableOffset)\n    {\n      VTable *vtable = (VTable*)&bytecode[vtableOffset];\n\n      intcheck(vtable->methods[0] == &RefRecord_destroy, ERR_SIZE, 3);\n      intcheck(vtable->methods[1] == &RefRecord_print, ERR_SIZE, 4);\n\n      void *ptr = ::operator new(vtable->numbytes);\n      RefRecord *r = new (ptr) RefRecord(PXT_VTABLE_TO_INT(vtable));\n      memset(r->fields, 0, vtable->numbytes - sizeof(RefRecord));\n      return r;\n    }\n\n    uint32_t RefRecord::ld(int idx)\n    {\n      //intcheck((reflen == 255 ? 0 : reflen) <= idx && idx < len, ERR_OUT_OF_BOUNDS, 1);\n      return fields[idx];\n    }\n\n    uint32_t RefRecord::ldref(int idx)\n    {\n      //printf(\"LD %p len=%d reflen=%d idx=%d\\n\", this, len, reflen, idx);\n      //intcheck(0 <= idx && idx < reflen, ERR_OUT_OF_BOUNDS, 2);\n      uint32_t tmp = fields[idx];\n      incr(tmp);\n      return tmp;\n    }\n\n    void RefRecord::st(int idx, uint32_t v)\n    {\n      //intcheck((reflen == 255 ? 0 : reflen) <= idx && idx < len, ERR_OUT_OF_BOUNDS, 3);\n      fields[idx] = v;\n    }\n\n    void RefRecord::stref(int idx, uint32_t v)\n    {\n      //printf(\"ST %p len=%d reflen=%d idx=%d\\n\", this, len, reflen, idx);\n      //intcheck(0 <= idx && idx < reflen, ERR_OUT_OF_BOUNDS, 4);\n      decr(fields[idx]);\n      fields[idx] = v;\n    }\n\n    void RefObject::destroy() {\n      ((RefObjectMethod)getVTable()->methods[0])(this);\n    }\n\n    void RefObject::print() {\n      ((RefObjectMethod)getVTable()->methods[1])(this);\n    }\n\n    void RefRecord_destroy(RefRecord *r) {\n        auto tbl = r->getVTable();\n        uint8_t *refmask = (uint8_t*)&tbl->methods[tbl->userdata & 0xff];\n        int len = (tbl->numbytes >> 2) - 1;\n        for (int i = 0; i < len; ++i) {\n          if (refmask[i]) decr(r->fields[i]);\n          r->fields[i] = 0;\n        }\n        //RefRecord is allocated using placement new\n        r->~RefRecord();\n        ::operator delete(r);\n    }\n\n    void RefRecord_print(RefRecord *r)\n    {\n      printf(\"RefRecord %p r=%d size=%d bytes\\n\", r, r->refcnt, r->getVTable()->numbytes);\n    }\n\n    uint32_t Segment::get(uint32_t i)\n    {\n#ifdef DEBUG_BUILD\n      printf(\"In Segment::get index:%u\\n\", i);\n      this->print();\n#endif\n\n      if (i < length)\n      {\n          return data[i];\n      }\n      return Segment::DefaultValue;\n    }\n\n    void Segment::set(uint32_t i, uint32_t value)\n    {\n        if (i < size)\n        {\n          data[i] = value;\n        }\n        else if (i < Segment::MaxSize)\n        {\n          growByMin(i + 1);\n          data[i] = value;\n        }\n        if (length <= i)\n        {\n           length = i + 1;\n        }\n\n#ifdef DEBUG_BUILD\n        printf(\"In Segment::set\\n\");\n        this->print();\n#endif\n\n        return;\n    }\n\n    uint16_t Segment::growthFactor(uint16_t size)\n    {\n      if (size == 0)\n      {\n        return 4;\n      }\n      if (size < 64)\n      {\n        return size * 2; // Double\n      }\n      if (size < 512)\n      {\n        return size * 5/3; //Grow by 1.66 rate\n      }\n      return size + 256; //Grow by constant rate\n    }\n\n    void Segment::growByMin(uint16_t minSize)\n    {\n      growBy(max(minSize, growthFactor(size)));\n    }\n\n    void Segment::growBy(uint16_t newSize)\n    {\n#ifdef DEBUG_BUILD\n         printf(\"growBy: %d\\n\", newSize);\n         this->print();\n#endif\n      if (size < newSize)\n      {\n         //this will throw if unable to allocate\n         uint32_t *tmp = (uint32_t*)(::operator new(newSize * sizeof(uint32_t)));\n\n         //Copy existing data\n         if (size)\n         {\n           memcpy(tmp, data, size * sizeof(uint32_t));\n         }\n        //fill the rest with default value\n         memset(tmp + size, Segment::DefaultValue, (newSize - size) * sizeof(uint32_t));\n\n         //free older segment;\n         ::operator delete(data);\n\n         data = tmp;\n         size = newSize;\n\n#ifdef DEBUG_BUILD\n         printf(\"growBy - after reallocation\\n\");\n         this->print();\n#endif\n\n      }\n      //else { no shrinking yet; }\n      return;\n    }\n\n    void Segment::ensure(uint16_t newSize)\n    {\n      if (newSize < size)\n      {\n        return;\n      }\n      growByMin(newSize);\n    }\n\n    void Segment::setLength(uint32_t newLength)\n    {\n      if (newLength > size)\n      {\n        ensure(length);\n      }\n      length = newLength;\n      return;\n    }\n\n    void Segment::push(uint32_t value)\n    {\n      this->set(length, value);\n    }\n\n    uint32_t Segment::pop()\n    {\n#ifdef DEBUG_BUILD\n      printf(\"In Segment::pop\\n\");\n      this->print();\n#endif\n\n      if (length > 0)\n      {\n        --length;\n        uint32_t value = data[length];\n        data[length] = Segment::DefaultValue;\n        return value;\n      }\n      return Segment::DefaultValue;\n    }\n\n    //this function removes an element at index i and shifts the rest of the elements to\n    //left to fill the gap\n    uint32_t Segment::remove(uint32_t i)\n    {\n#ifdef DEBUG_BUILD\n      printf(\"In Segment::remove index:%u\\n\", i);\n      this->print();\n#endif\n      if (i < length)\n      {\n        //value to return\n        uint32_t ret = data[i];\n        if (i + 1 < length)\n        {\n          //Move the rest of the elements to fill in the gap.\n          memmove(data + i, data + i + 1, (length - i - 1) * sizeof(uint32_t));\n        }\n        length--;\n        data[length] = Segment::DefaultValue;\n#ifdef DEBUG_BUILD\n        printf(\"After Segment::remove index:%u\\n\", i);\n        this->print();\n#endif\n        return ret;\n      }\n      return Segment::DefaultValue;\n    }\n\n    //this function inserts element value at index i by shifting the rest of the elements right.\n    void Segment::insert(uint32_t i, uint32_t value)\n    {\n#ifdef DEBUG_BUILD\n      printf(\"In Segment::insert index:%u value:%u\\n\", i, value);\n      this->print();\n#endif\n\n      if (i < length)\n      {\n        ensure(length + 1);\n        if (i + 1 < length)\n        {\n          //Move the rest of the elements to fill in the gap.\n          memmove(data + i + 1, data + i, (length - i) * sizeof(uint32_t));\n        }\n\n        data[i] = value;\n        length++;\n      }\n      else\n      {\n        //This is insert beyond the length, just call set which will adjust the length\n        set(i, value);\n      }\n#ifdef DEBUG_BUILD\n      printf(\"After Segment::insert index:%u\\n\", i);\n      this->print();\n#endif\n    }\n\n    void Segment::print()\n    {\n      printf(\"Segment: %x, length: %u, size: %u\\n\", data, (uint32_t)length, (uint32_t)size);\n      for(uint32_t i = 0; i < size; i++)\n      {\n        printf(\"%d \",(uint32_t)data[i]);\n      }\n      printf(\"\\n\");\n    }\n\n    bool Segment::isValidIndex(uint32_t i)\n    {\n      if (i > length)\n      {\n        return false;\n      }\n      return true;\n    }\n\n    void Segment::destroy()\n    {\n#ifdef DEBUG_BUILD\n      printf(\"In Segment::destroy\\n\");\n      this->print();\n#endif\n      length = size = 0;\n      ::operator delete(data);\n      data = nullptr;\n    }\n\n    void RefCollection::push(uint32_t x)\n    {\n      if (isRef()) incr(x);\n      head.push(x);\n    }\n\n    uint32_t RefCollection::pop()\n    {\n      uint32_t ret = head.pop();\n      if (isRef())\n      {\n        incr(ret);\n      }\n      return ret;\n    }\n\n    uint32_t RefCollection::getAt(int i)\n    {\n      uint32_t tmp = head.get(i);\n      if (isRef())\n      {\n        incr(tmp);\n      }\n      return tmp;\n    }\n\n    uint32_t RefCollection::removeAt(int i)\n    {\n      if (isRef())\n      {\n        decr(head.get(i));\n      }\n      return head.remove(i);\n    }\n\n    void RefCollection::insertAt(int i, uint32_t value)\n    {\n      head.insert(i, value);\n      if (isRef())\n      {\n        incr(value);\n      }\n    }\n\n    void RefCollection::setAt(int i, uint32_t value)\n    {\n      if (isRef())\n      {\n        if (head.isValidIndex((uint32_t)i))\n        {\n          decr(head.get(i));\n        }\n        incr(value);\n      }\n      head.set(i, value);\n    }\n\n    int RefCollection::indexOf(uint32_t x, int start)\n    {\n      if (isString())\n      {\n        StringData *xx = (StringData*)x;\n        uint32_t i = start;\n        while(head.isValidIndex(i))\n        {\n          StringData *ee = (StringData*)head.get(i);\n          if (ee == xx)\n          {\n            //handles ee being null\n            return (int) i;\n          }\n          if (ee && xx->len == ee->len && memcmp(xx->data, ee->data, xx->len) == 0)\n          {\n            return (int)i;\n          }\n          i++;\n        }\n      }\n      else\n      {\n        uint32_t i = start;\n        while(head.isValidIndex(i))\n        {\n          if (head.get(i) == x)\n          {\n            return (int)i;\n          }\n          i++;\n        }\n      }\n\n      return -1;\n    }\n\n    int RefCollection::removeElement(uint32_t x)\n    {\n      int idx = indexOf(x, 0);\n      if (idx >= 0) {\n        removeAt(idx);\n        return 1;\n      }\n      return 0;\n    }\n\n    namespace Coll0 {\n      PXT_VTABLE_BEGIN(RefCollection, 0, 0)\n      PXT_VTABLE_END\n    }\n    namespace Coll1 {\n      PXT_VTABLE_BEGIN(RefCollection, 1, 0)\n      PXT_VTABLE_END\n    }\n    namespace Coll3 {\n      PXT_VTABLE_BEGIN(RefCollection, 3, 0)\n      PXT_VTABLE_END\n    }\n\n    RefCollection::RefCollection(uint16_t flags) : RefObject(0) {\n      switch (flags) {\n        case 0:\n          vtable = PXT_VTABLE_TO_INT(&Coll0::RefCollection_vtable);\n          break;\n        case 1:\n          vtable = PXT_VTABLE_TO_INT(&Coll1::RefCollection_vtable);\n          break;\n        case 3:\n          vtable = PXT_VTABLE_TO_INT(&Coll3::RefCollection_vtable);\n          break;\n        default:\n          error(ERR_SIZE);\n          break;\n      }\n    }\n\n    void RefCollection::destroy()\n    {\n      if (this->isRef())\n      {\n        for(uint32_t i = 0; i < this->head.getLength(); i++)\n        {\n          decr(this->head.get(i));\n        }\n      }\n      this->head.destroy();\n      delete this;\n    }\n\n    void RefCollection::print()\n    {\n      printf(\"RefCollection %p r=%d flags=%d size=%d\\n\", this, refcnt, getFlags(), head.getLength());\n      head.print();\n    }\n\n    PXT_VTABLE_CTOR(RefAction) {}\n\n    // fields[] contain captured locals\n    void RefAction::destroy()\n    {\n      for (int i = 0; i < this->reflen; ++i) {\n        decr(fields[i]);\n        fields[i] = 0;\n      }\n      //RefAction is allocated using placement new\n      this->~RefAction();\n      ::operator delete(this);\n    }\n\n    void RefAction::print()\n    {\n      printf(\"RefAction %p r=%d pc=0x%lx size=%d (%d refs)\\n\", this, refcnt, (const uint8_t*)func - (const uint8_t*)bytecode, len, reflen);\n    }\n\n    void RefLocal::print()\n    {\n      printf(\"RefLocal %p r=%d v=%d\\n\", this, refcnt, v);\n    }\n\n    void RefLocal::destroy()\n    {\n      delete this;\n    }\n\n    PXT_VTABLE_CTOR(RefLocal) {\n      v = 0;\n    }\n\n    PXT_VTABLE_CTOR(RefRefLocal) {\n      v = 0;\n    }\n\n    void RefRefLocal::print()\n    {\n      printf(\"RefRefLocal %p r=%d v=%p\\n\", this, refcnt, (void*)v);\n    }\n\n    void RefRefLocal::destroy()\n    {\n      decr(v);\n      delete this;\n    }\n\n    PXT_VTABLE_BEGIN(RefMap, 0, RefMapMarker)\n    PXT_VTABLE_END\n    RefMap::RefMap() : PXT_VTABLE_INIT(RefMap) {}\n\n    void RefMap::destroy() {\n      for (unsigned i = 0; i < data.size(); ++i) {\n        if (data[i].key & 1) {\n          decr(data[i].val);\n        }\n        data[i].val = 0;\n      }\n      data.resize(0);\n      delete this;\n    }\n\n    int RefMap::findIdx(uint32_t key) {\n      for (unsigned i = 0; i < data.size(); ++i) {\n        if (data[i].key >> 1 == key)\n          return i;\n      }\n      return -1;\n    }\n\n    void RefMap::print()\n    {\n      printf(\"RefMap %p r=%d size=%d\\n\", this, refcnt, data.size());\n    }\n\n\n#ifdef DEBUG_MEMLEAKS\n  std::set<RefObject*> allptrs;\n  void debugMemLeaks()\n  {\n    printf(\"LIVE POINTERS:\\n\");\n    for(std::set<RefObject*>::iterator itr = allptrs.begin();itr!=allptrs.end();itr++)\n    {\n      (*itr)->print();\n    }\n    printf(\"\\n\");\n  }\n#else\n  void debugMemLeaks() {}\n#endif\n\n\n    // ---------------------------------------------------------------------------\n    // An adapter for the API expected by the run-time.\n    // ---------------------------------------------------------------------------\n\n    map<pair<int, int>, Action> handlersMap;\n\n    MicroBitEvent lastEvent;\n\n    // We have the invariant that if [dispatchEvent] is registered against the DAL\n    // for a given event, then [handlersMap] contains a valid entry for that\n    // event.\n    void dispatchEvent(MicroBitEvent e) {\n\n      lastEvent = e;\n\n      Action curr = handlersMap[{ e.source, e.value }];\n      if (curr)\n        runAction1(curr, e.value);\n\n      curr = handlersMap[{ e.source, MICROBIT_EVT_ANY }];\n      if (curr)\n        runAction1(curr, e.value);\n    }\n\n    void registerWithDal(int id, int event, Action a) {\n      Action prev = handlersMap[{ id, event }];\n      if (prev)\n        decr(prev);\n      else\n        uBit.messageBus.listen(id, event, dispatchEvent);\n      incr(a);\n      handlersMap[{ id, event }] = a;\n    }\n\n    void fiberDone(void *a)\n    {\n      decr((Action)a);\n      release_fiber();\n    }\n\n\n    void runInBackground(Action a) {\n      if (a != 0) {\n        incr(a);\n        create_fiber((void(*)(void*))runAction0, (void*)a, fiberDone);\n      }\n    }\n\n\n  void error(ERROR code, int subcode)\n  {\n    printf(\"Error: %d [%d]\\n\", code, subcode);\n    uBit.panic(42);\n  }\n\n  uint16_t *bytecode;\n  uint32_t *globals;\n  int numGlobals;\n\n  uint32_t *allocate(uint16_t sz)\n  {\n    uint32_t *arr = new uint32_t[sz];\n    memset(arr, 0, sz * 4);\n    return arr;\n  }\n\n  void checkStr(bool cond, const char *msg)\n  {\n    if (!cond) {\n      while (true) {\n        uBit.display.scroll(msg, 100);\n        uBit.sleep(100);\n      }\n    }\n  }\n\n  int templateHash()\n  {\n    return ((int*)bytecode)[4];\n  }\n\n  int programHash()\n  {\n    return ((int*)bytecode)[6];\n  }\n\n  int getNumGlobals()\n  {\n    return bytecode[16];\n  }\n\n  void exec_binary(int32_t *pc)\n  {\n    // XXX re-enable once the calibration code is fixed and [editor/embedded.ts]\n    // properly prepends a call to [internal_main].\n    // ::touch_develop::internal_main();\n\n    // unique group for radio based on source hash\n    // ::touch_develop::micro_bit::radioDefaultGroup = programHash();\n\n    // repeat error 4 times and restart as needed\n    microbit_panic_timeout(4);\n\n    int32_t ver = *pc++;\n    checkStr(ver == 0x4209, \":( Bad runtime version\");\n\n    bytecode = *((uint16_t**)pc++);  // the actual bytecode is here\n    globals = allocate(getNumGlobals());\n\n    // just compare the first word\n    checkStr(((uint32_t*)bytecode)[0] == 0x923B8E70 &&\n             templateHash() == *pc,\n             \":( Failed partial flash\");\n\n    uint32_t startptr = (uint32_t)bytecode;\n    startptr += 48; // header\n    startptr |= 1; // Thumb state\n\n    ((uint32_t (*)())startptr)();\n\n#ifdef DEBUG_MEMLEAKS\n    pxt::debugMemLeaks();\n#endif\n\n    return;\n  }\n\n  void start()\n  {\n    exec_binary((int32_t*)functionsAndBytecode);\n  }\n}\n\n// vim: ts=2 sw=2 expandtab\n",
      "pxt.h": "#ifndef __PXT_H\n#define __PXT_H\n\n//#define DEBUG_MEMLEAKS 1\n\n#pragma GCC diagnostic ignored \"-Wunused-parameter\"\n\n#include \"MicroBit.h\"\n#include \"MicroBitImage.h\"\n#include \"ManagedString.h\"\n#include \"ManagedType.h\"\n#include \"ManagedBuffer.h\"\n\n#define printf(...) uBit.serial.printf(__VA_ARGS__)\n// #define printf(...)\n\n#define intcheck(...) check(__VA_ARGS__)\n//#define intcheck(...) do {} while (0)\n\n#include <stdio.h>\n#include <string.h>\n#include <vector>\n#include <stdint.h>\n\n#ifdef DEBUG_MEMLEAKS\n#include <set>\n#endif\n\nextern MicroBit uBit;\n\nnamespace pxt {\n  typedef uint32_t Action;\n  typedef uint32_t ImageLiteral;\n\n\n  typedef enum {\n    ERR_INVALID_BINARY_HEADER = 5,\n    ERR_OUT_OF_BOUNDS = 8,\n    ERR_REF_DELETED = 7,\n    ERR_SIZE = 9,\n  } ERROR;\n\n  extern const uint32_t functionsAndBytecode[];\n  extern uint32_t *globals;\n  extern uint16_t *bytecode;\n  class RefRecord;\n\n  // Utility functions\n  extern MicroBitEvent lastEvent;\n  void registerWithDal(int id, int event, Action a);\n  void runInBackground(Action a);\n  uint32_t runAction3(Action a, int arg0, int arg1, int arg2);\n  uint32_t runAction2(Action a, int arg0, int arg1);\n  uint32_t runAction1(Action a, int arg0);\n  uint32_t runAction0(Action a);\n  Action mkAction(int reflen, int totallen, int startptr);\n  void error(ERROR code, int subcode = 0);\n  void exec_binary(uint16_t *pc);\n  void start();\n  void debugMemLeaks();\n  // allocate [sz] words and clear them\n  uint32_t *allocate(uint16_t sz);\n  int templateHash();\n  int programHash();\n  uint32_t programSize();\n  uint32_t afterProgramPage();     \n  int getNumGlobals();\n  RefRecord* mkClassInstance(int vtableOffset);\n\n  // The standard calling convention is:\n  //   - when a pointer is loaded from a local/global/field etc, and incr()ed\n  //     (in other words, its presence on stack counts as a reference)\n  //   - after a function call, all pointers are popped off the stack and decr()ed\n  // This does not apply to the RefRecord and st/ld(ref) methods - they unref()\n  // the RefRecord* this.\n  int incr(uint32_t e);\n  void decr(uint32_t e);\n\n  inline void *ptrOfLiteral(int offset)\n  {\n    return &bytecode[offset];\n  }\n\n  inline ImageData* imageBytes(int offset)\n  {\n    return (ImageData*)(void*)&bytecode[offset];\n  }\n\n  // Checks if object has a VTable, or if its RefCounted* from the runtime.\n  inline bool hasVTable(uint32_t e)\n  {\n    return (*((uint32_t*)e) & 1) == 0;\n  }\n\n  inline void check(int cond, ERROR code, int subcode = 0)\n  {\n    if (!cond) error(code, subcode);\n  }\n\n\n  class RefObject;\n#ifdef DEBUG_MEMLEAKS\n  extern std::set<RefObject*> allptrs;\n#endif\n\n  typedef void (*RefObjectMethod)(RefObject *self);\n  typedef void *PVoid;\n  typedef void **PPVoid;\n\n  const PPVoid RefMapMarker = (PPVoid)(void*)43;\n\n  struct VTable {\n    uint16_t numbytes;  // in the entire object, including the vtable pointer\n    uint16_t userdata;\n    PVoid *ifaceTable;\n    PVoid methods[2]; // we only use up to two methods here; pxt will generate more\n    // refmask sits at &methods[nummethods]\n  };\n\n  const int vtableShift = 2;\n\n  // A base abstract class for ref-counted objects.\n  class RefObject\n  {\n  public:\n    uint16_t refcnt;\n    uint16_t vtable;\n\n    RefObject(uint16_t vt)\n    {\n      refcnt = 2;\n      vtable = vt;\n#ifdef DEBUG_MEMLEAKS\n      allptrs.insert(this);\n#endif\n    }\n\n    inline VTable *getVTable() {\n      return (VTable*)(vtable << vtableShift);\n    }\n\n    void destroy();\n    void print();\n\n    // Call to disable pointer tracking on the current instance (in destructor or some other hack)\n    inline void untrack() {\n#ifdef DEBUG_MEMLEAKS\n      allptrs.erase(this);\n#endif\n    }\n\n    // Increment/decrement the ref-count. Decrementing to zero deletes the current object.\n    inline void ref()\n    {\n      check(refcnt > 0, ERR_REF_DELETED);\n      //printf(\"INCR \"); this->print();\n      refcnt += 2;\n    }\n\n    inline void unref()\n    {\n      //printf(\"DECR \"); this->print();\n      refcnt -= 2;\n      if (refcnt == 0) {\n        destroy();\n      }\n    }\n  };\n\n  class Segment {\n  private:    \n      uint32_t* data;\n      uint16_t length;\n      uint16_t size;\n\n      static const uint16_t MaxSize = 0xFFFF;\n      static const uint32_t DefaultValue = 0x0;\n\n      static uint16_t growthFactor(uint16_t size);      \n      void growByMin(uint16_t minSize);\n      void growBy(uint16_t newSize);\n      void ensure(uint16_t newSize);\n\n  public:\n      Segment() : data (nullptr), length(0), size(0) {};\n\n      uint32_t get(uint32_t i);\n      void set(uint32_t i, uint32_t value);      \n\n      uint32_t getLength() { return length;};\n      void setLength(uint32_t newLength);\n\n      void push(uint32_t value);\n      uint32_t pop();\n\n      uint32_t remove(uint32_t i);\n      void insert(uint32_t i, uint32_t value);\n\n      bool isValidIndex(uint32_t i);\n\n      void destroy();\n\n      void print();\n  };\n\n  // A ref-counted collection of either primitive or ref-counted objects (String, Image,\n  // user-defined record, another collection)\n  class RefCollection\n    : public RefObject\n  {\n  private:\n    Segment head;\n  public:\n    // 1 - collection of refs (need decr)\n    // 2 - collection of strings (in fact we always have 3, never 2 alone)\n    inline uint32_t getFlags() { return getVTable()->userdata; }\n    inline bool isRef() { return getFlags() & 1; }\n    inline bool isString() { return getFlags() & 2; }\n\n    RefCollection(uint16_t f);\n\n    void destroy();\n    void print();\n\n    uint32_t length() { return head.getLength();}\n    void setLength(uint32_t newLength) { head.setLength(newLength); }\n\n    void push(uint32_t x);\n    uint32_t pop();\n    uint32_t getAt(int i);\n    void setAt(int i, uint32_t x);\n    //removes the element at index i and shifts the other elements left\n    uint32_t removeAt(int i);\n    //inserts the element at index i and moves the other elements right.\n    void insertAt(int i, uint32_t x); \n\n    int indexOf(uint32_t x, int start);\n    int removeElement(uint32_t x);\n  };\n\n  struct MapEntry {\n    uint32_t key;\n    uint32_t val;\n  };\n\n  class RefMap\n    : public RefObject\n  {\n  public:\n    std::vector<MapEntry> data;\n\n    RefMap();\n    void destroy();\n    void print();\n    int findIdx(uint32_t key);\n  };\n\n  // A ref-counted, user-defined JS object.\n  class RefRecord\n    : public RefObject\n  {\n  public:\n    // The object is allocated, so that there is space at the end for the fields.\n    uint32_t fields[];\n\n    RefRecord(uint16_t v) : RefObject(v) {}\n\n    uint32_t ld(int idx);\n    uint32_t ldref(int idx);\n    void st(int idx, uint32_t v);\n    void stref(int idx, uint32_t v);\n  };\n\n  // these are needed when constructing vtables for user-defined classes\n  void RefRecord_destroy(RefRecord *r);\n  void RefRecord_print(RefRecord *r);\n\n  class RefAction;\n  typedef uint32_t (*ActionCB)(uint32_t *captured, uint32_t arg0, uint32_t arg1, uint32_t arg2);\n\n  // Ref-counted function pointer. It's currently always a ()=>void procedure pointer.\n  class RefAction\n    : public RefObject\n  {\n  public:\n    // This is the same as for RefRecord.\n    uint8_t len;\n    uint8_t reflen;\n    ActionCB func; // The function pointer\n    // fields[] contain captured locals\n    uint32_t fields[];\n\n    void destroy();\n    void print();\n\n    RefAction();\n\n    inline void stCore(int idx, uint32_t v)\n    {\n      //printf(\"ST [%d] = %d \", idx, v); this->print();\n      intcheck(0 <= idx && idx < len, ERR_OUT_OF_BOUNDS, 10);\n      intcheck(fields[idx] == 0, ERR_OUT_OF_BOUNDS, 11); // only one assignment permitted\n      fields[idx] = v;\n    }\n\n    inline uint32_t runCore(int arg0, int arg1, int arg2) // internal; use runAction*() functions\n    {\n      this->ref();\n      uint32_t r = this->func(&this->fields[0], arg0, arg1, arg2);\n      this->unref();\n      return r;\n    }\n  };\n\n  // These two are used to represent locals written from inside inline functions\n  class RefLocal\n    : public RefObject\n  {\n  public:\n    uint32_t v;\n    void destroy();\n    void print();\n    RefLocal();\n  };\n\n  class RefRefLocal\n    : public RefObject\n  {\n  public:\n    uint32_t v;\n    void destroy();\n    void print();\n    RefRefLocal();\n  };\n}\n\nusing namespace pxt;\nMicroBitPin *getPin(int id);\ntypedef ImageData* Image;\ntypedef BufferData* Buffer;\n\n// The ARM Thumb generator in the JavaScript code is parsing\n// the hex file and looks for the magic numbers as present here.\n//\n// Then it fetches function pointer addresses from there.\n  \n#define PXT_SHIMS_BEGIN \\\nnamespace pxt { \\\n  const uint32_t functionsAndBytecode[] __attribute__((aligned(0x20))) = { \\\n    0x08010801, 0x42424242, 0x08010801, 0x8de9d83e,\n\n#define PXT_SHIMS_END }; }\n\n#pragma GCC diagnostic ignored \"-Wpmf-conversions\"\n\n#define PXT_VTABLE_TO_INT(vt)  ((uint32_t)(vt) >> vtableShift)\n#define PXT_VTABLE_BEGIN(classname, flags, iface) \\\nconst VTable classname ## _vtable \\\n  __attribute__((aligned(1 << vtableShift))) \\\n  = { \\\n  sizeof(classname), \\\n  flags, \\\n  iface, \\\n  { \\\n    (void*)&classname::destroy, \\\n    (void*)&classname::print,\n\n#define PXT_VTABLE_END } };\n\n#define PXT_VTABLE_INIT(classname) \\\n  RefObject(PXT_VTABLE_TO_INT(&classname ## _vtable))\n\n#define PXT_VTABLE_CTOR(classname) \\\n  PXT_VTABLE_BEGIN(classname, 0, 0) PXT_VTABLE_END \\\n  classname::classname() : PXT_VTABLE_INIT(classname)\n\n#endif\n\n// vim: ts=2 sw=2 expandtab\n",
      "pxt.json": "{\n    \"name\": \"core\",\n    \"description\": \"The microbit core library\",\n    \"files\": [\n        \"README.md\",\n        \"ManagedBuffer.cpp\",\n        \"ManagedBuffer.h\",\n        \"pxt.cpp\",\n        \"pxt.h\",\n        \"dal.d.ts\",\n        \"enums.d.ts\",\n        \"shims.d.ts\",\n        \"pxt-core.d.ts\",\n        \"core.cpp\",\n        \"pxt-helpers.ts\",\n        \"helpers.ts\",\n        \"images.cpp\",\n        \"basic.cpp\",\n        \"icons.ts\",\n        \"input.cpp\",\n        \"input.ts\",\n        \"control.ts\",\n        \"control.cpp\",\n        \"game.ts\",\n        \"led.cpp\",\n        \"led.ts\",\n        \"music.ts\",\n        \"melodies.ts\",\n        \"pins.cpp\",\n        \"pins.ts\",\n        \"serial.cpp\",\n        \"serial.ts\",\n        \"buffer.cpp\",\n        \"pxtparts.json\",\n        \"parts/speaker.svg\",\n        \"parts/headphone.svg\",\n        \"_locales/ja/core-jsdoc-strings.json\",\n        \"_locales/fr/core-jsdoc-strings.json\",\n        \"_locales/fr/core-strings.json\",\n        \"_locales/de/core-jsdoc-strings.json\",\n        \"_locales/de/core-strings.json\",\n        \"_locales/no/core-strings.json\",\n        \"_locales/ja/core-strings.json\",\n        \"_locales/sv-SE/core-jsdoc-strings.json\",\n        \"_locales/no/core-jsdoc-strings.json\",\n        \"_locales/si-LK/core-strings.json\",\n        \"_locales/sv-SE/core-strings.json\",\n        \"_locales/si-LK/core-jsdoc-strings.json\",\n        \"_locales/nl/core-strings.json\",\n        \"_locales/nl/core-jsdoc-strings.json\"\n    ],\n    \"public\": true,\n    \"dependencies\": {},\n    \"yotta\": {\n        \"optionalConfig\": {\n            \"microbit-dal\": {\n                \"bluetooth\": {\n                    \"private_addressing\": 0,\n                    \"advertising_timeout\": 0,\n                    \"tx_power\": 6,\n                    \"dfu_service\": 1,\n                    \"event_service\": 1,\n                    \"device_info_service\": 1,\n                    \"eddystone_url\": 1,\n                    \"eddystone_uid\": 1,\n                    \"open\": 0,\n                    \"pairing_mode\": 1,\n                    \"whitelist\": 1,\n                    \"security_level\": \"SECURITY_MODE_ENCRYPTION_NO_MITM\"\n                }\n            }\n        }\n    }\n}",
      "pxtparts.json": "{ \n     \"buttonpair\": {\n        \"simulationBehavior\": \"buttonpair\",\n        \"visual\": {\n            \"builtIn\": \"buttonpair\",\n            \"width\": 75,\n            \"height\": 45,\n            \"pinDistance\": 15,\n            \"pinLocations\": [\n                {\"x\": 0, \"y\": 0},\n                {\"x\": 30, \"y\": 45},\n                {\"x\": 45, \"y\": 0},\n                {\"x\": 75, \"y\": 45}\n            ]\n        },\n        \"numberOfPins\": 4,\n        \"pinDefinitions\": [\n            {\"target\": \"P14\", \"style\": \"male\", \"orientation\": \"-Z\"},\n            {\"target\": \"ground\", \"style\": \"male\", \"orientation\": \"-Z\"},\n            {\"target\": \"P15\", \"style\": \"male\", \"orientation\": \"-Z\"},\n            {\"target\": \"ground\", \"style\": \"male\", \"orientation\": \"-Z\"}\n        ],\n        \"instantiation\": {\n            \"kind\": \"singleton\"\n        },\n        \"assembly\": [\n            {\"part\": true},\n            {\"pinIndices\": [0, 1]},\n            {\"pinIndices\": [2, 3]}\n        ]\n    },\n    \"microservo\": {\n        \"simulationBehavior\": \"microservo\",\n        \"visual\": {\n            \"builtIn\": \"microservo\",\n            \"width\": 74.85,\n            \"height\": 200,\n            \"pinDistance\": 10,\n            \"pinLocations\": [\n                {\"x\": 30, \"y\": 5},\n                {\"x\": 37, \"y\": 5},\n                {\"x\": 45, \"y\": 5}\n            ]\n        },\n        \"numberOfPins\": 3,\n        \"pinDefinitions\": [\n            {\"target\": {\"pinInstantiationIdx\": 0}, \"style\": \"croc\", \"orientation\": \"+Z\"},\n            {\"target\": \"threeVolt\", \"style\": \"croc\", \"orientation\": \"+Z\"},\n            {\"target\": \"ground\", \"style\": \"croc\", \"orientation\": \"+Z\"}\n        ],\n        \"instantiation\": {\n            \"kind\": \"function\",\n            \"fullyQualifiedName\": \"pins.servoWritePin\",\n            \"argumentRoles\": [\n                {\"pinInstantiationIdx\": 0, \"partParameter\": \"name\"}\n            ]\n        },\n        \"assembly\": [\n            {\"part\": true, \"pinIndices\": [2]},\n            {\"pinIndices\": [0, 1]}\n        ]\n    },\n    \"neopixel\": {\n        \"simulationBehavior\": \"neopixel\",\n        \"visual\": {\n            \"builtIn\": \"neopixel\",\n            \"width\": 58,\n            \"height\": 113,\n            \"pinDistance\": 9,\n            \"pinLocations\": [\n                {\"x\": 10, \"y\": 0},\n                {\"x\": 19, \"y\": 0},\n                {\"x\": 28, \"y\": 0}\n            ]\n        },\n        \"numberOfPins\": 3,\n        \"pinDefinitions\": [\n            {\"target\": {\"pinInstantiationIdx\": 0}, \"style\": \"solder\", \"orientation\": \"+Z\"},\n            {\"target\": \"threeVolt\", \"style\": \"solder\", \"orientation\": \"+Z\"},\n            {\"target\": \"ground\", \"style\": \"solder\", \"orientation\": \"+Z\"}\n        ],\n        \"instantiation\": {\n            \"kind\": \"function\",\n            \"fullyQualifiedName\": \"neopixel.create\",\n            \"argumentRoles\": [\n                {\"pinInstantiationIdx\": 0, \"partParameter\": \"pin\"},\n                {\"partParameter\": \"mode\"}\n            ]\n        },\n        \"assembly\": [\n            {\"part\": true, \"pinIndices\": [2]},\n            {\"pinIndices\": [0, 1]}\n        ]\n    },\n    \"ledmatrix\": {\n        \"visual\": {\n            \"builtIn\": \"ledmatrix\",\n            \"width\": 105,\n            \"height\": 105,\n            \"pinDistance\": 15,\n            \"pinLocations\": [\n                {\"x\": 0, \"y\": 0},\n                {\"x\": 15, \"y\": 0},\n                {\"x\": 30, \"y\": 0},\n                {\"x\": 45, \"y\": 0},\n                {\"x\": 105, \"y\": 105},\n                {\"x\": 0, \"y\": 105},\n                {\"x\": 15, \"y\": 105},\n                {\"x\": 30, \"y\": 105},\n                {\"x\": 45, \"y\": 105},\n                {\"x\": 60, \"y\": 0}\n            ]\n        },\n        \"simulationBehavior\": \"ledmatrix\",\n        \"numberOfPins\": 10,\n        \"instantiation\": {\"kind\": \"singleton\"},\n        \"pinDefinitions\": [\n            {\"target\": \"P6\", \"style\": \"male\", \"orientation\": \"-Z\", \"colorGroup\": 0},\n            {\"target\": \"P7\", \"style\": \"male\", \"orientation\": \"-Z\", \"colorGroup\": 0},\n            {\"target\": \"P8\", \"style\": \"male\", \"orientation\": \"-Z\", \"colorGroup\": 0},\n            {\"target\": \"P9\", \"style\": \"male\", \"orientation\": \"-Z\", \"colorGroup\": 0},\n            {\"target\": \"P10\", \"style\": \"male\", \"orientation\": \"-Z\", \"colorGroup\": 0},\n            {\"target\": \"P12\", \"style\": \"male\", \"orientation\": \"-Z\", \"colorGroup\": 1},\n            {\"target\": \"P13\", \"style\": \"male\", \"orientation\": \"-Z\", \"colorGroup\": 1},\n            {\"target\": \"P16\", \"style\": \"male\", \"orientation\": \"-Z\", \"colorGroup\": 1},\n            {\"target\": \"P19\", \"style\": \"male\", \"orientation\": \"-Z\", \"colorGroup\": 1},\n            {\"target\": \"P20\", \"style\": \"male\", \"orientation\": \"-Z\", \"colorGroup\": 1}\n        ],\n        \"assembly\": [\n            {\"part\": true},\n            {\"pinIndices\": [0, 1, 2, 3, 4]},\n            {\"pinIndices\": [5, 6, 7, 8, 9]}\n        ]\n    },\n    \"headphone\": {\n        \"numberOfPins\": 2,\n        \"visual\": {\n            \"image\": \"parts/headphone.svg\",\n            \"width\": 142,\n            \"height\": 180,\n            \"pinDistance\": 20,\n            \"pinLocations\": [\n                {\"x\": 17, \"y\": 11},\n                {\"x\": 55, \"y\": 50}\n            ]\n        },\n        \"pinDefinitions\": [\n            {\"target\": \"P0\", \"style\": \"croc\", \"orientation\": \"Y\"},\n            {\"target\": \"ground\", \"style\": \"croc\", \"orientation\": \"Y\"}\n        ],\n        \"instantiation\": {\"kind\": \"singleton\"},\n        \"assembly\": [\n            {\"part\": true, \"pinIndices\": [0]},\n            {\"pinIndices\": [1]}\n        ]\n    },\n    \"speaker\": {\n        \"numberOfPins\": 2,\n        \"visual\": {\n            \"image\": \"parts/speaker.svg\",\n            \"width\": 500,\n            \"height\": 500,\n            \"pinDistance\": 70,\n            \"pinLocations\": [\n                {\"x\": 180, \"y\": 135},\n                {\"x\": 320, \"y\": 135}\n            ]\n        },\n        \"pinDefinitions\": [\n            {\"target\": \"P0\", \"style\": \"male\", \"orientation\": \"-Z\"},\n            {\"target\": \"ground\", \"style\": \"male\", \"orientation\": \"-Z\"}\n        ],\n        \"instantiation\": {\"kind\": \"singleton\"},\n        \"assembly\": [\n            {\"part\": true, \"pinIndices\": [0]},\n            {\"pinIndices\": [1]}\n        ]\n    }\n}",
      "serial.cpp": "#include \"pxt.h\"\n\n#define MICROBIT_SERIAL_READ_BUFFER_LENGTH 64\n\nenum SerialPin {\n    P0 = MICROBIT_ID_IO_P0,\n    P1 = MICROBIT_ID_IO_P1,\n    P2 = MICROBIT_ID_IO_P2,\n    P8 = MICROBIT_ID_IO_P8,\n    P12 = MICROBIT_ID_IO_P12,\n    P13 = MICROBIT_ID_IO_P13,\n    P14 = MICROBIT_ID_IO_P14,\n    P15 = MICROBIT_ID_IO_P15,\n    P16 = MICROBIT_ID_IO_P16\n};\n\nenum BaudRate {\n  //% block=115200\n  BaudRate115200 = 115200,\n  //% block=57600\n  BaudRate57600 = 57600,\n  //% block=38400\n  BaudRate38400 = 38400,\n  //% block=31250\n  BaudRate31250 = 31250,\n  //% block=28800\n  BaudRate28800 = 28800,\n  //% block=19200\n  BaudRate19200 = 19200,\n  //% block=14400\n  BaudRate14400 = 14400,\n  //% block=9600\n  BaudRate9600 = 9600,\n  //% block=4800\n  BaudRate4800 = 4800,\n  //% block=2400\n  BaudRate2400 = 2400,\n  //% block=1200\n  BaudRate1200 = 1200,\n  //% block=300\n  BaudRate300 = 300\n};\n\nenum Delimiters {\n    //% block=\"new line\"\n    NewLine = 1,\n    //% block=\",\"\n    Comma = 2,\n    //% block=\"$\"\n    Dollar = 3,\n    //% block=\":\"\n    Colon = 4,\n    //% block=\".\"\n    Fullstop = 5,\n    //% block=\"#\"\n    Hash = 6,\n};\n\n//% weight=2 color=#002050 icon=\"\\uf287\"\n//% advanced=true\nnamespace serial {\n    // note that at least one // followed by % is needed per declaration!\n\n    /**\n     * Reads a line of text from the serial port and returns the buffer when the delimiter is met.\n     * @param delimiter text delimiter that separates each text chunk\n     */\n    //% help=serial/read-until\n    //% blockId=serial_read_until block=\"serial|read until %delimiter=serial_delimiter_conv\"\n    //% weight=19\n    StringData* readUntil(StringData* delimiter) {\n      return uBit.serial.readUntil(ManagedString(delimiter)).leakData();\n    }\n\n    /**\n    * Reads the buffered received data as a string\n    */\n    //% blockId=serial_read_buffer block=\"serial|read string\"\n    //% weight=18\n    StringData* readString() {\n      int n = uBit.serial.getRxBufferSize();\n      if (n == 0) return ManagedString(\"\").leakData();\n      return ManagedString(uBit.serial.read(n, MicroBitSerialMode::ASYNC)).leakData();\n    }\n\n    /**\n    * Registers an event to be fired when one of the delimiter is matched.\n    * @param delimiters the characters to match received characters against.\n    */\n    //% help=serial/on-data-received\n    //% weight=18 blockId=serial_on_data_received block=\"serial|on data received %delimiters=serial_delimiter_conv\"\n    void onDataReceived(StringData* delimiters, Action body) {\n      uBit.serial.eventOn(ManagedString(delimiters));\n      registerWithDal(MICROBIT_ID_SERIAL, MICROBIT_SERIAL_EVT_DELIM_MATCH, body);\n      // lazy initialization of serial buffers\n      uBit.serial.read(MicroBitSerialMode::ASYNC);\n    }\n\n    /**\n     * Sends a piece of text through Serial connection.\n     */\n    //% help=serial/write-string\n    //% weight=87\n    //% blockId=serial_writestring block=\"serial|write string %text\"\n    void writeString(StringData *text) {\n      if (!text) return;\n\n      uBit.serial.send(ManagedString(text));\n    }\n\n    /**\n    * Sends a buffer through Serial connection\n    */\n    //% blockId=serial_writebuffer block=\"serial|write buffer %buffer\"\n    //% help=serial/write-buffer advanced=true weight=6\n    void writeBuffer(Buffer buffer) {\n      if (!buffer) return;\n\n      ManagedBuffer buf(buffer);\n      uBit.serial.send(buf.getBytes(), buf.length());\n    }\n\n    /**\n    * Reads multiple characters from the receive buffer and fills a user buffer.\n    * @param length default buffer length, eg: 64\n    */\n    //% blockId=serial_readbuffer block=\"serial|read buffer %length\"\n    //% help=serial/read-buffer advanced=true weight=5\n    Buffer readBuffer(int length) {\n      if (length <= 0)\n        length = MICROBIT_SERIAL_READ_BUFFER_LENGTH;\n        \n      ManagedBuffer buf(length);\n      int read = uBit.serial.read(buf.getBytes(), buf.length());\n      if (read != buf.length())\n        buf = buf.slice(read);\n\n      return buf.leakData();\n    }\n\n    /**\n    * Dynamically configuring the serial instance to use pins other than USBTX and USBRX.\n    * @param tx the new transmission pins, eg: SerialPin.P0\n    * @param rx the new reception pin, eg: SerialPin.P1\n    * @param rate the new baud rate. eg: 115200\n    */\n    //% weight=10\n    //% help=serial/redirect-to\n    //% blockId=serial_redirect block=\"serial|redirect to|TX %tx|RX %rx|at baud rate %rate\"\n    //% blockExternalInputs=1\n    void redirect(SerialPin tx, SerialPin rx, BaudRate rate) {\n      MicroBitPin* txp = getPin(tx); if (!tx) return;\n      MicroBitPin* rxp = getPin(rx); if (!rx) return;\n\n      uBit.serial.redirect(txp->name, rxp->name);\n      uBit.serial.baud((int)rate);\n    }\n}\n",
      "serial.ts": "/**\n * Reading and writing data over a serial connection.\n */\n//% weight=2 color=#002050 icon=\"\\uf287\"\n//% advanced=true\nnamespace serial {\n    /**\n     * Prints a line of text to the serial\n     * @param value to send over serial\n     */\n    //% weight=90\n    //% help=serial/write-line blockGap=8\n    //% blockId=serial_writeline block=\"serial|write line %text\"\n    export function writeLine(text: string): void {\n        writeString(text + \"\\r\\n\");\n    }\n\n    /**\n     * Prints a numeric value to the serial\n     */\n    //% help=serial/write-number\n    //% weight=89 blockGap=8\n    //% blockId=serial_writenumber block=\"serial|write number %value\"\n    export function writeNumber(value: number): void {\n        writeString(value.toString());\n    }\n\n    /**\n     * Writes a ``name: value`` pair line to the serial.\n     * @param name name of the value stream, eg: x\n     * @param value to write\n     */\n    //% weight=88 blockGap=8\n    //% help=serial/write-value\n    //% blockId=serial_writevalue block=\"serial|write value %name|= %value\"\n    export function writeValue(name: string, value: number): void {\n        writeString(name + \":\" + value + \"\\r\\n\");\n    }\n\n    /**\n     * Reads a line of text from the serial port.\n     */\n    //% help=serial/read-line\n    //% blockId=serial_read_line block=\"serial|read line\"\n    //% weight=20 blockGap=8\n    export function readLine(): string {\n        return serial.readUntil(delimiters(Delimiters.NewLine));\n    }\n\n    /**\n     * Returns the delimiter corresponding string\n     */\n    //% blockId=\"serial_delimiter_conv\" block=\"%del\"\n    //% weight=1 blockHidden=true\n    export function delimiters(del: Delimiters): string {\n        // even though it might not look like, this is more\n        // (memory) efficient than the C++ implementation, because the\n        // strings are statically allocated and take no RAM \n        switch (del) {\n            case Delimiters.NewLine: return \"\\n\"\n            case Delimiters.Comma: return \",\"\n            case Delimiters.Dollar: return \"$\"\n            case Delimiters.Colon: return \":\"\n            case Delimiters.Fullstop: return \".\"\n            case Delimiters.Hash: return \"#\"\n            default: return \"\\n\"\n        }\n    }\n}\n",
      "shims.d.ts": "// Auto-generated. Do not edit.\n\n\n    /**\n     * Creation, manipulation and display of LED images.\n     */\n    //% color=#5C2D91 weight=31 icon=\"\\uf03e\"\n    //% advanced=true\ndeclare namespace images {\n\n    /**\n     * Creates an image that fits on the LED screen.\n     */\n    //% weight=75 help=images/create-image\n    //% blockId=device_build_image block=\"create image\"\n    //% parts=\"ledmatrix\" imageLiteral=1 shim=images::createImage\n    function createImage(leds: string): Image;\n\n    /**\n     * Creates an image with 2 frames.\n     */\n    //% weight=74 help=images/create-big-image\n    //% blockId=device_build_big_image block=\"create big image\" imageLiteral=2\n    //% parts=\"ledmatrix\" shim=images::createBigImage\n    function createBigImage(leds: string): Image;\n}\n\n\ndeclare interface Image {\n    /**\n     * Plots the image at a given column to the screen\n     */\n    //% help=images/plot-image\n    //% parts=\"ledmatrix\" xOffset.defl=0 shim=ImageMethods::plotImage\n    plotImage(xOffset?: number): void;\n\n    /**\n     * Shows an frame from the image at offset ``x offset``.\n     * @param xOffset column index to start displaying the image\n     */\n    //% help=images/show-image weight=80 blockNamespace=images\n    //% blockId=device_show_image_offset block=\"show image %sprite|at offset %offset\" blockGap=8\n    //% parts=\"ledmatrix\" async interval.defl=400 shim=ImageMethods::showImage\n    showImage(xOffset: number, interval?: number): void;\n\n    /**\n     * Draws the ``index``-th frame of the image on the screen.\n     * @param xOffset column index to start displaying the image\n     */\n    //% help=images/plot-frame weight=80\n    //% parts=\"ledmatrix\" shim=ImageMethods::plotFrame\n    plotFrame(xOffset: number): void;\n\n    /**\n     * Scrolls an image .\n     * @param frameOffset x offset moved on each animation step, eg: 1, 2, 5\n     * @param interval time between each animation step in milli seconds, eg: 200\n     */\n    //% help=images/scroll-image weight=79 async blockNamespace=images\n    //% blockId=device_scroll_image block=\"scroll image %sprite|with offset %frameoffset|and interval (ms) %delay\" blockGap=8\n    //% parts=\"ledmatrix\" shim=ImageMethods::scrollImage\n    scrollImage(frameOffset: number, interval: number): void;\n\n    /**\n     * Sets all pixels off.\n     */\n    //% help=images/clear\n    //% parts=\"ledmatrix\" shim=ImageMethods::clear\n    clear(): void;\n\n    /**\n     * Sets a specific pixel brightness at a given position\n     */\n    //%\n    //% parts=\"ledmatrix\" shim=ImageMethods::setPixelBrightness\n    setPixelBrightness(x: number, y: number, value: number): void;\n\n    /**\n     * Gets the pixel brightness ([0..255]) at a given position\n     */\n    //%\n    //% parts=\"ledmatrix\" shim=ImageMethods::pixelBrightness\n    pixelBrightness(x: number, y: number): number;\n\n    /**\n     * Gets the width in columns\n     */\n    //% help=functions/width shim=ImageMethods::width\n    width(): number;\n\n    /**\n     * Gets the height in rows (always 5)\n     */\n    //% shim=ImageMethods::height\n    height(): number;\n\n    /**\n     * Set a pixel state at position ``(x,y)``\n     * @param x TODO\n     * @param y TODO\n     * @param value TODO\n     */\n    //% help=images/set-pixel\n    //% parts=\"ledmatrix\" shim=ImageMethods::setPixel\n    setPixel(x: number, y: number, value: boolean): void;\n\n    /**\n     * Get the pixel state at position ``(x,y)``\n     * @param x TODO\n     * @param y TODO\n     */\n    //% help=images/pixel\n    //% parts=\"ledmatrix\" shim=ImageMethods::pixel\n    pixel(x: number, y: number): boolean;\n\n    /**\n     * Shows a particular frame of the image strip.\n     * @param frame TODO\n     */\n    //% weight=70 help=images/show-frame\n    //% parts=\"ledmatrix\" interval.defl=400 shim=ImageMethods::showFrame\n    showFrame(frame: number, interval?: number): void;\n}\n\n\n    /**\n     * Provides access to basic micro:bit functionality.\n     */\n    //% color=#0078D7 weight=100 icon=\"\\uf00a\"\ndeclare namespace basic {\n\n    /**\n     * Scroll a number on the screen. If the number fits on the screen (i.e. is a single digit), do not scroll.\n     * @param interval speed of scroll; eg: 150, 100, 200, -100\n     */\n    //% help=basic/show-number\n    //% weight=96\n    //% blockId=device_show_number block=\"show|number %number\" blockGap=8\n    //% async\n    //% parts=\"ledmatrix\" interval.defl=150 shim=basic::showNumber\n    function showNumber(value: number, interval?: number): void;\n\n    /**\n     * Draws an image on the LED screen.\n     * @param leds the pattern of LED to turn on/off\n     * @param interval time in milliseconds to pause after drawing\n     */\n    //% help=basic/show-leds \n    //% weight=95 blockGap=8\n    //% imageLiteral=1 async\n    //% blockId=device_show_leds\n    //% block=\"show leds\" icon=\"\\uf00a\"\n    //% parts=\"ledmatrix\" interval.defl=400 shim=basic::showLeds\n    function showLeds(leds: string, interval?: number): void;\n\n    /**\n     * Display text on the display, one character at a time. If the string fits on the screen (i.e. is one letter), does not scroll.\n     * @param text the text to scroll on the screen, eg: \"Hello!\"\n     * @param interval how fast to shift characters; eg: 150, 100, 200, -100\n     */\n    //% help=basic/show-string \n    //% weight=87 blockGap=8\n    //% block=\"show|string %text\" \n    //% async\n    //% blockId=device_print_message\n    //% parts=\"ledmatrix\" interval.defl=150 shim=basic::showString\n    function showString(text: string, interval?: number): void;\n\n    /**\n     * Turn off all LEDs\n     */\n    //% help=basic/clear-screen weight=79\n    //% blockId=device_clear_display block=\"clear screen\"\n    //% parts=\"ledmatrix\"\n    //% advanced=true shim=basic::clearScreen\n    function clearScreen(): void;\n\n    /**\n     * Shows a sequence of LED screens as an animation.\n     * @param leds pattern of LEDs to turn on/off\n     * @param interval time in milliseconds between each redraw\n     */\n    //% help=basic/show-animation imageLiteral=1 async\n    //% parts=\"ledmatrix\" interval.defl=400 shim=basic::showAnimation\n    function showAnimation(leds: string, interval?: number): void;\n\n    /**\n     * Draws an image on the LED screen.\n     * @param leds pattern of LEDs to turn on/off\n     */\n    //% help=basic/plot-leds weight=80\n    //% parts=\"ledmatrix\" imageLiteral=1 shim=basic::plotLeds\n    function plotLeds(leds: string): void;\n\n    /**\n     * Repeats the code forever in the background. On each iteration, allows other codes to run.\n     * @param body code to execute\n     */\n    //% help=basic/forever weight=55 blockGap=8 blockAllowMultiple=1\n    //% blockId=device_forever block=\"forever\" icon=\"\\uf01e\" shim=basic::forever\n    function forever(a: () => void): void;\n\n    /**\n     * Pause for the specified time in milliseconds\n     * @param ms how long to pause for, eg: 100, 200, 500, 1000, 2000\n     */\n    //% help=basic/pause weight=54\n    //% async block=\"pause (ms) %pause\"\n    //% blockId=device_pause icon=\"\\uf110\" shim=basic::pause\n    function pause(ms: number): void;\n}\n\n\n\n    //% color=#B4009E weight=99 icon=\"\\uf192\"\ndeclare namespace input {\n\n    /**\n     * Do something when a button (A, B or both A+B) is pushed down and released again.\n     * @param button the button that needs to be pressed\n     * @param body code to run when event is raised\n     */\n    //% help=input/on-button-pressed weight=85 blockGap=8\n    //% blockId=device_button_event block=\"on button|%NAME|pressed\"\n    //% parts=\"buttonpair\" shim=input::onButtonPressed\n    function onButtonPressed(button: Button, body: () => void): void;\n\n    /**\n     * Do something when when a gesture is done (like shaking the micro:bit).\n     * @param gesture the type of gesture to track, eg: Gesture.Shake\n     * @param body code to run when gesture is raised\n     */\n    //% help=input/on-gesture weight=84 blockGap=8\n    //% blockId=device_gesture_event block=\"on |%NAME\"\n    //% parts=\"accelerometer\"\n    //% NAME.fieldEditor=\"gridpicker\" NAME.fieldOptions.columns=4 shim=input::onGesture\n    function onGesture(gesture: Gesture, body: () => void): void;\n\n    /**\n     * Do something when a pin is touched and released again (while also touching the GND pin).\n     * @param name the pin that needs to be pressed, eg: TouchPin.P0\n     * @param body the code to run when the pin is pressed\n     */\n    //% help=input/on-pin-pressed weight=83\n    //% blockId=device_pin_event block=\"on pin %name|pressed\" shim=input::onPinPressed\n    function onPinPressed(name: TouchPin, body: () => void): void;\n\n    /**\n     * Do something when a pin is released.\n     * @param name the pin that needs to be released, eg: TouchPin.P0\n     * @param body the code to run when the pin is released\n     */\n    //% help=input/on-pin-released weight=6 blockGap=8\n    //% blockId=device_pin_released block=\"on pin %NAME|released\"\n    //% advanced=true shim=input::onPinReleased\n    function onPinReleased(name: TouchPin, body: () => void): void;\n\n    /**\n     * Get the button state (pressed or not) for ``A`` and ``B``.\n     * @param button the button to query the request, eg: Button.A\n     */\n    //% help=input/button-is-pressed weight=60\n    //% block=\"button|%NAME|is pressed\"\n    //% blockId=device_get_button2\n    //% icon=\"\\uf192\" blockGap=8\n    //% parts=\"buttonpair\" shim=input::buttonIsPressed\n    function buttonIsPressed(button: Button): boolean;\n\n    /**\n     * Get the pin state (pressed or not). Requires to hold the ground to close the circuit.\n     * @param name pin used to detect the touch, eg: TouchPin.P0\n     */\n    //% help=input/pin-is-pressed weight=58\n    //% blockId=\"device_pin_is_pressed\" block=\"pin %NAME|is pressed\"\n    //% blockGap=8 shim=input::pinIsPressed\n    function pinIsPressed(name: TouchPin): boolean;\n\n    /**\n     * Get the acceleration value in milli-gravitys (when the board is laying flat with the screen up, x=0, y=0 and z=-1024)\n     * @param dimension TODO\n     */\n    //% help=input/acceleration weight=58\n    //% blockId=device_acceleration block=\"acceleration (mg)|%NAME\" blockGap=8\n    //% parts=\"accelerometer\" shim=input::acceleration\n    function acceleration(dimension: Dimension): number;\n\n    /**\n     * Reads the light level applied to the LED screen in a range from ``0`` (dark) to ``255`` bright.\n     */\n    //% help=input/light-level weight=57\n    //% blockId=device_get_light_level block=\"light level\" blockGap=8\n    //% parts=\"ledmatrix\" shim=input::lightLevel\n    function lightLevel(): number;\n\n    /**\n     * Get the current compass heading in degrees.\n     */\n    //% help=input/compass-heading\n    //% weight=56\n    //% blockId=device_heading block=\"compass heading (°)\" blockGap=8\n    //% parts=\"compass\" shim=input::compassHeading\n    function compassHeading(): number;\n\n    /**\n     * Gets the temperature in Celsius degrees (°C).\n     */\n    //% weight=55\n    //% help=input/temperature\n    //% blockId=device_temperature block=\"temperature (°C)\" blockGap=8\n    //% parts=\"thermometer\" shim=input::temperature\n    function temperature(): number;\n\n    /**\n     * The pitch or roll of the device, rotation along the ``x-axis`` or ``y-axis``, in degrees.\n     * @param kind TODO\n     */\n    //% help=input/rotation weight=52\n    //% blockId=device_get_rotation block=\"rotation (°)|%NAME\" blockGap=8\n    //% parts=\"accelerometer\" advanced=true shim=input::rotation\n    function rotation(kind: Rotation): number;\n\n    /**\n     * Get the magnetic force value in ``micro-Teslas`` (``µT``). This function is not supported in the simulator.\n     * @param dimension TODO\n     */\n    //% help=input/magnetic-force weight=51\n    //% blockId=device_get_magnetic_force block=\"magnetic force (µT)|%NAME\" blockGap=8\n    //% parts=\"compass\"\n    //% advanced=true shim=input::magneticForce\n    function magneticForce(dimension: Dimension): number;\n\n    /**\n     * Gets the number of milliseconds elapsed since power on.\n     */\n    //% help=input/running-time weight=50\n    //% blockId=device_get_running_time block=\"running time (ms)\"\n    //% advanced=true shim=input::runningTime\n    function runningTime(): number;\n\n    /**\n     * Obsolete, compass calibration is automatic.\n     */\n    //% help=input/calibrate-compass advanced=true\n    //% blockId=\"input_compass_calibrate\" block=\"calibrate compass\" shim=input::calibrateCompass\n    function calibrateCompass(): void;\n\n    /**\n     * Sets the accelerometer sample range in gravities.\n     * @param range a value describe the maximum strengh of acceleration measured\n     */\n    //% help=input/set-accelerometer-range\n    //% blockId=device_set_accelerometer_range block=\"set accelerometer|range %range\"\n    //% weight=5\n    //% parts=\"accelerometer\"\n    //% advanced=true shim=input::setAccelerometerRange\n    function setAccelerometerRange(range: AcceleratorRange): void;\n}\n\n\n\n    //% weight=1 color=\"#333333\"\n    //% advanced=true\ndeclare namespace control {\n\n    /**\n     * Schedules code that run in the background.\n     */\n    //% help=control/in-background blockAllowMultiple=1\n    //% blockId=\"control_in_background\" block=\"run in background\" blockGap=8 shim=control::inBackground\n    function inBackground(a: () => void): void;\n\n    /**\n     * Resets the BBC micro:bit.\n     */\n    //% weight=30 async help=control/reset blockGap=8\n    //% blockId=\"control_reset\" block=\"reset\" shim=control::reset\n    function reset(): void;\n\n    /**\n     * Blocks the current fiber for the given microseconds\n     * @param micros number of micro-seconds to wait. eg: 4\n     */\n    //% help=control/wait-micros weight=29\n    //% blockId=\"control_wait_us\" block=\"wait (µs)%micros\" shim=control::waitMicros\n    function waitMicros(micros: number): void;\n\n    /**\n     * Raises an event in the event bus.\n     * @param src ID of the MicroBit Component that generated the event e.g. MICROBIT_ID_BUTTON_A.\n     * @param value Component specific code indicating the cause of the event.\n     * @param mode optional definition of how the event should be processed after construction (default is CREATE_AND_FIRE).\n     */\n    //% weight=21 blockGap=12 blockId=\"control_raise_event\" block=\"raise event|from source %src=control_event_source_id|with value %value=control_event_value_id\" blockExternalInputs=1\n    //% help=control/raise-event\n    //% mode.defl=1 shim=control::raiseEvent\n    function raiseEvent(src: number, value: number, mode?: EventCreationMode): void;\n\n    /**\n     * Raises an event in the event bus.\n     */\n    //% weight=20 blockGap=8 blockId=\"control_on_event\" block=\"on event|from %src=control_event_source_id|with value %value=control_event_value_id\"\n    //% help=control/on-event\n    //% blockExternalInputs=1 shim=control::onEvent\n    function onEvent(src: number, value: number, handler: () => void): void;\n\n    /**\n     * Gets the value of the last event executed on the bus\n     */\n    //% blockId=control_event_value\" block=\"event value\"\n    //% help=control/event-value\n    //% weight=18 shim=control::eventValue\n    function eventValue(): number;\n\n    /**\n     * Gets the timestamp of the last event executed on the bus\n     */\n    //% blockId=control_event_timestamp\" block=\"event timestamp\"\n    //% help=control/event-timestamp\n    //% weight=19 blockGap=8 shim=control::eventTimestamp\n    function eventTimestamp(): number;\n\n    /**\n     * Gets a friendly name for the device derived from the its serial number\n     */\n    //% blockId=\"control_device_name\" block=\"device name\" weight=10 blockGap=8\n    //% advanced=true shim=control::deviceName\n    function deviceName(): string;\n\n    /**\n     * Derive a unique, consistent serial number of this device from internal data.\n     */\n    //% blockId=\"control_device_serial_number\" block=\"device serial number\" weight=9\n    //% advanced=true shim=control::deviceSerialNumber\n    function deviceSerialNumber(): number;\n}\n\n\n\n    //% color=#5C2D91 weight=97 icon=\"\\uf205\"\ndeclare namespace led {\n\n    /**\n     * Turn on the specified LED using x, y coordinates (x is horizontal, y is vertical). (0,0) is upper left.\n     * @param x the horizontal coordinate of the LED starting at 0\n     * @param y the vertical coordinate of the LED starting at 0\n     */\n    //% help=led/plot weight=78\n    //% blockId=device_plot block=\"plot|x %x|y %y\" blockGap=8\n    //% parts=\"ledmatrix\"\n    //% x.min=0 x.max=4 y.min=0 y.max=4 shim=led::plot\n    function plot(x: number, y: number): void;\n\n    /**\n     * Turn on the specified LED with specific brightness using x, y coordinates (x is horizontal, y is vertical). (0,0) is upper left.\n     * @param x the horizontal coordinate of the LED starting at 0\n     * @param y the vertical coordinate of the LED starting at 0\n     * @param brightness the brightness from 0 (off) to 255 (bright), eg:255\n     */\n    //% help=led/plot-brightness weight=78\n    //% blockId=device_plot_brightness block=\"plot|x %x|y %y|brightness %brightness\" blockGap=8\n    //% parts=\"ledmatrix\"\n    //% x.min=0 x.max=4 y.min=0 y.max=4 brightness.min=0 brightness.max=255\n    //% advanced=true shim=led::plotBrightness\n    function plotBrightness(x: number, y: number, brightness: number): void;\n\n    /**\n     * Turn off the specified LED using x, y coordinates (x is horizontal, y is vertical). (0,0) is upper left.\n     * @param x TODO\n     * @param y TODO\n     */\n    //% help=led/unplot weight=77\n    //% blockId=device_unplot block=\"unplot|x %x|y %y\" blockGap=8\n    //% parts=\"ledmatrix\"\n    //% x.min=0 x.max=4 y.min=0 y.max=4 shim=led::unplot\n    function unplot(x: number, y: number): void;\n\n    /**\n     * Get the on/off state of the specified LED using x, y coordinates. (0,0) is upper left.\n     * @param x TODO\n     * @param y TODO\n     */\n    //% help=led/point weight=76\n    //% blockId=device_point block=\"point|x %x|y %y\"\n    //% parts=\"ledmatrix\"\n    //% x.min=0 x.max=4 y.min=0 y.max=4 shim=led::point\n    function point(x: number, y: number): boolean;\n\n    /**\n     * Get the screen brightness from 0 (off) to 255 (full bright).\n     */\n    //% help=led/brightness weight=60\n    //% blockId=device_get_brightness block=\"brightness\" blockGap=8\n    //% parts=\"ledmatrix\"\n    //% advanced=true shim=led::brightness\n    function brightness(): number;\n\n    /**\n     * Set the screen brightness from 0 (off) to 255 (full bright).\n     * @param value the brightness value, eg:255, 127, 0\n     */\n    //% help=led/set-brightness weight=59\n    //% blockId=device_set_brightness block=\"set brightness %value\"\n    //% parts=\"ledmatrix\"\n    //% advanced=true\n    //% value.min=0 value.max=255 shim=led::setBrightness\n    function setBrightness(value: number): void;\n\n    /**\n     * Cancels the current animation and clears other pending animations.\n     */\n    //% weight=50 help=led/stop-animation\n    //% blockId=device_stop_animation block=\"stop animation\"\n    //% parts=\"ledmatrix\"\n    //% advanced=true shim=led::stopAnimation\n    function stopAnimation(): void;\n\n    /**\n     * Sets the display mode between black and white and greyscale for rendering LEDs.\n     * @param mode mode the display mode in which the screen operates\n     */\n    //% weight=1 help=led/set-display-mode\n    //% parts=\"ledmatrix\" advanced=true shim=led::setDisplayMode\n    function setDisplayMode(mode: DisplayMode): void;\n\n    /**\n     * Gets the current display mode\n     */\n    //% weight=1 parts=\"ledmatrix\" advanced=true shim=led::displayMode\n    function displayMode(): DisplayMode;\n\n    /**\n     * Turns on or off the display\n     */\n    //% help=led/enable blockId=device_led_enable block=\"led enable %on\"\n    //% advanced=true parts=\"ledmatrix\" shim=led::enable\n    function enable(on: boolean): void;\n\n    /**\n     * Takes a screenshot of the LED screen and returns an image.\n     */\n    //% help=led/screenshot\n    //% parts=\"ledmatrix\" shim=led::screenshot\n    function screenshot(): Image;\n}\ndeclare namespace pins {\n\n    /**\n     * Read the specified pin or connector as either 0 or 1\n     * @param name pin to read from, eg: DigitalPin.P0\n     */\n    //% help=pins/digital-read-pin weight=30\n    //% blockId=device_get_digital_pin block=\"digital read|pin %name\" blockGap=8\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\" name.fieldOptions.width=\"300\" shim=pins::digitalReadPin\n    function digitalReadPin(name: DigitalPin): number;\n\n    /**\n     * Set a pin or connector value to either 0 or 1.\n     * @param name pin to write to, eg: DigitalPin.P0\n     * @param value value to set on the pin, 1 eg,0\n     */\n    //% help=pins/digital-write-pin weight=29\n    //% blockId=device_set_digital_pin block=\"digital write|pin %name|to %value\"\n    //% value.min=0 value.max=1\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\" name.fieldOptions.width=\"300\" shim=pins::digitalWritePin\n    function digitalWritePin(name: DigitalPin, value: number): void;\n\n    /**\n     * Read the connector value as analog, that is, as a value comprised between 0 and 1023.\n     * @param name pin to write to, eg: AnalogPin.P0\n     */\n    //% help=pins/analog-read-pin weight=25\n    //% blockId=device_get_analog_pin block=\"analog read|pin %name\" blockGap=\"8\"\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\" shim=pins::analogReadPin\n    function analogReadPin(name: AnalogPin): number;\n\n    /**\n     * Set the connector value as analog. Value must be comprised between 0 and 1023.\n     * @param name pin name to write to, eg: AnalogPin.P0\n     * @param value value to write to the pin between ``0`` and ``1023``. eg:1023,0\n     */\n    //% help=pins/analog-write-pin weight=24\n    //% blockId=device_set_analog_pin block=\"analog write|pin %name|to %value\" blockGap=8\n    //% value.min=0 value.max=1023\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\" shim=pins::analogWritePin\n    function analogWritePin(name: AnalogPin, value: number): void;\n\n    /**\n     * Configures the Pulse-width modulation (PWM) of the analog output to the given value in **microseconds** or `1/1000` milliseconds.\n     * If this pin is not configured as an analog output (using `analog write pin`), the operation has no effect.\n     * @param name analog pin to set period to, eg: AnalogPin.P0\n     * @param micros period in micro seconds. eg:20000\n     */\n    //% help=pins/analog-set-period weight=23 blockGap=8\n    //% blockId=device_set_analog_period block=\"analog set period|pin %pin|to (µs)%micros\"\n    //% pin.fieldEditor=\"gridpicker\" pin.fieldOptions.columns=4\n    //% pin.fieldOptions.tooltips=\"false\" shim=pins::analogSetPeriod\n    function analogSetPeriod(name: AnalogPin, micros: number): void;\n\n    /**\n     * Configures this pin to a digital input, and generates events where the timestamp is the duration that this pin was either ``high`` or ``low``.\n     * @param name digital pin to register to, eg: DigitalPin.P0\n     * @param pulse the value of the pulse, eg: PulseValue.High\n     */\n    //% help=pins/on-pulsed weight=22 blockGap=8 advanced=true\n    //% blockId=pins_on_pulsed block=\"on|pin %pin|pulsed %pulse\"\n    //% pin.fieldEditor=\"gridpicker\" pin.fieldOptions.columns=4\n    //% pin.fieldOptions.tooltips=\"false\" pin.fieldOptions.width=\"300\" shim=pins::onPulsed\n    function onPulsed(name: DigitalPin, pulse: PulseValue, body: () => void): void;\n\n    /**\n     * Gets the duration of the last pulse in micro-seconds. This function should be called from a ``onPulsed`` handler.\n     */\n    //% help=pins/pulse-duration advanced=true\n    //% blockId=pins_pulse_duration block=\"pulse duration (µs)\"\n    //% weight=21 blockGap=8 shim=pins::pulseDuration\n    function pulseDuration(): number;\n\n    /**\n     * Returns the duration of a pulse in microseconds\n     * @param name the pin which measures the pulse, eg: DigitalPin.P0\n     * @param value the value of the pulse, eg: PulseValue.High\n     * @param maximum duration in micro-seconds\n     */\n    //% blockId=\"pins_pulse_in\" block=\"pulse in (µs)|pin %name|pulsed %value\"\n    //% weight=20 advanced=true\n    //% help=pins/pulse-in\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\" name.fieldOptions.width=\"300\" maxDuration.defl=2000000 shim=pins::pulseIn\n    function pulseIn(name: DigitalPin, value: PulseValue, maxDuration?: number): number;\n\n    /**\n     * Writes a value to the servo, controlling the shaft accordingly. On a standard servo, this will set the angle of the shaft (in degrees), moving the shaft to that orientation. On a continuous rotation servo, this will set the speed of the servo (with ``0`` being full-speed in one direction, ``180`` being full speed in the other, and a value near ``90`` being no movement).\n     * @param name pin to write to, eg: AnalogPin.P0\n     * @param value angle or rotation speed, eg:180,90,0\n     */\n    //% help=pins/servo-write-pin weight=20\n    //% blockId=device_set_servo_pin block=\"servo write|pin %name|to %value\" blockGap=8\n    //% parts=microservo trackArgs=0\n    //% value.min=0 value.max=180\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\" shim=pins::servoWritePin\n    function servoWritePin(name: AnalogPin, value: number): void;\n\n    /**\n     * Configures this IO pin as an analog/pwm output, configures the period to be 20 ms, and sets the pulse width, based on the value it is given **microseconds** or `1/1000` milliseconds.\n     * @param name pin name\n     * @param micros pulse duration in micro seconds, eg:1500\n     */\n    //% help=pins/servo-set-pulse weight=19\n    //% blockId=device_set_servo_pulse block=\"servo set pulse|pin %value|to (µs) %micros\"\n    //% value.fieldEditor=\"gridpicker\" value.fieldOptions.columns=4\n    //% value.fieldOptions.tooltips=\"false\" shim=pins::servoSetPulse\n    function servoSetPulse(name: AnalogPin, micros: number): void;\n\n    /**\n     * Sets the pin used when using `analog pitch` or music.\n     * @param name pin to modulate pitch from\n     */\n    //% blockId=device_analog_set_pitch_pin block=\"analog set pitch pin %name\"\n    //% help=pins/analog-set-pitch-pin weight=3 advanced=true\n    //% name.fieldEditor=\"gridpicker\" name.fieldOptions.columns=4\n    //% name.fieldOptions.tooltips=\"false\" shim=pins::analogSetPitchPin\n    function analogSetPitchPin(name: AnalogPin): void;\n\n    /**\n     * Emits a Pulse-width modulation (PWM) signal to the current pitch pin. Use `analog set pitch pin` to define the pitch pin.\n     * @param frequency frequency to modulate in Hz.\n     * @param ms duration of the pitch in milli seconds.\n     */\n    //% blockId=device_analog_pitch block=\"analog pitch %frequency|for (ms) %ms\"\n    //% help=pins/analog-pitch weight=4 async advanced=true blockGap=8 shim=pins::analogPitch\n    function analogPitch(frequency: number, ms: number): void;\n\n    /**\n     * Configures the pull of this pin.\n     * @param name pin to set the pull mode on, eg: DigitalPin.P0\n     * @param pull one of the mbed pull configurations, eg: PinPullMode.PullUp\n     */\n    //% help=pins/set-pull weight=3 advanced=true\n    //% blockId=device_set_pull block=\"set pull|pin %pin|to %pull\"\n    //% pin.fieldEditor=\"gridpicker\" pin.fieldOptions.columns=4\n    //% pin.fieldOptions.tooltips=\"false\" pin.fieldOptions.width=\"300\" shim=pins::setPull\n    function setPull(name: DigitalPin, pull: PinPullMode): void;\n\n    /**\n     * Configures the events emitted by this pin. Events can be subscribed to\n     * using ``control.onEvent()``.\n     * @param name pin to set the event mode on, eg: DigitalPin.P0\n     * @param type the type of events for this pin to emit, eg: PinEventType.Edge\n     */\n    //% help=pins/set-events weight=4 advanced=true\n    //% blockId=device_set_pin_events block=\"set pin %pin|to emit %type|events\"\n    //% pin.fieldEditor=\"gridpicker\" pin.fieldOptions.columns=4\n    //% pin.fieldOptions.tooltips=\"false\" pin.fieldOptions.width=\"300\" shim=pins::setEvents\n    function setEvents(name: DigitalPin, type: PinEventType): void;\n\n    /**\n     * Create a new zero-initialized buffer.\n     * @param size number of bytes in the buffer\n     */\n    //% shim=pins::createBuffer\n    function createBuffer(size: number): Buffer;\n\n    /**\n     * Read `size` bytes from a 7-bit I2C `address`.\n     */\n    //% repeat.defl=0 shim=pins::i2cReadBuffer\n    function i2cReadBuffer(address: number, size: number, repeat?: boolean): Buffer;\n\n    /**\n     * Write bytes to a 7-bit I2C `address`.\n     */\n    //% repeat.defl=0 shim=pins::i2cWriteBuffer\n    function i2cWriteBuffer(address: number, buf: Buffer, repeat?: boolean): void;\n\n    /**\n     * Write to the SPI slave and return the response\n     * @param value Data to be sent to the SPI slave\n     */\n    //% help=pins/spi-write weight=5 advanced=true\n    //% blockId=spi_write block=\"spi write %value\" shim=pins::spiWrite\n    function spiWrite(value: number): number;\n\n    /**\n     * Sets the SPI frequency\n     * @param frequency the clock frequency, eg: 1000000\n     */\n    //% help=pins/spi-frequency weight=4 advanced=true\n    //% blockId=spi_frequency block=\"spi frequency %frequency\" shim=pins::spiFrequency\n    function spiFrequency(frequency: number): void;\n\n    /**\n     * Sets the SPI bits and mode\n     * @param bits the number of bits, eg: 8\n     * @param mode the mode, eg: 3\n     */\n    //% help=pins/spi-format weight=3 advanced=true\n    //% blockId=spi_format block=\"spi format|bits %bits|mode %mode\" shim=pins::spiFormat\n    function spiFormat(bits: number, mode: number): void;\n\n    /**\n     * Sets the MOSI, MISO, SCK pins used by the SPI instance\n     *\n     */\n    //% help=pins/spi-pins weight=2 advanced=true\n    //% blockId=spi_pins block=\"spi set pins|MOSI %mosi|MISO %miso|SCK %sck\" shim=pins::spiPins\n    function spiPins(mosi: DigitalPin, miso: DigitalPin, sck: DigitalPin): void;\n}\n\n\n\n    //% weight=2 color=#002050 icon=\"\\uf287\"\n    //% advanced=true\ndeclare namespace serial {\n\n    /**\n     * Reads a line of text from the serial port and returns the buffer when the delimiter is met.\n     * @param delimiter text delimiter that separates each text chunk\n     */\n    //% help=serial/read-until\n    //% blockId=serial_read_until block=\"serial|read until %delimiter=serial_delimiter_conv\"\n    //% weight=19 shim=serial::readUntil\n    function readUntil(delimiter: string): string;\n\n    /**\n     * Reads the buffered received data as a string\n     */\n    //% blockId=serial_read_buffer block=\"serial|read string\"\n    //% weight=18 shim=serial::readString\n    function readString(): string;\n\n    /**\n     * Registers an event to be fired when one of the delimiter is matched.\n     * @param delimiters the characters to match received characters against.\n     */\n    //% help=serial/on-data-received\n    //% weight=18 blockId=serial_on_data_received block=\"serial|on data received %delimiters=serial_delimiter_conv\" shim=serial::onDataReceived\n    function onDataReceived(delimiters: string, body: () => void): void;\n\n    /**\n     * Sends a piece of text through Serial connection.\n     */\n    //% help=serial/write-string\n    //% weight=87\n    //% blockId=serial_writestring block=\"serial|write string %text\" shim=serial::writeString\n    function writeString(text: string): void;\n\n    /**\n     * Sends a buffer through Serial connection\n     */\n    //% blockId=serial_writebuffer block=\"serial|write buffer %buffer\"\n    //% help=serial/write-buffer advanced=true weight=6 shim=serial::writeBuffer\n    function writeBuffer(buffer: Buffer): void;\n\n    /**\n     * Reads multiple characters from the receive buffer and fills a user buffer.\n     * @param length default buffer length, eg: 64\n     */\n    //% blockId=serial_readbuffer block=\"serial|read buffer %length\"\n    //% help=serial/read-buffer advanced=true weight=5 shim=serial::readBuffer\n    function readBuffer(length: number): Buffer;\n\n    /**\n     * Dynamically configuring the serial instance to use pins other than USBTX and USBRX.\n     * @param tx the new transmission pins, eg: SerialPin.P0\n     * @param rx the new reception pin, eg: SerialPin.P1\n     * @param rate the new baud rate. eg: 115200\n     */\n    //% weight=10\n    //% help=serial/redirect-to\n    //% blockId=serial_redirect block=\"serial|redirect to|TX %tx|RX %rx|at baud rate %rate\"\n    //% blockExternalInputs=1 shim=serial::redirect\n    function redirect(tx: SerialPin, rx: SerialPin, rate: BaudRate): void;\n}\n\n\n\n    //% indexerGet=BufferMethods::getByte indexerSet=BufferMethods::setByte\ndeclare interface Buffer {\n    /**\n     * Write a number in specified format in the buffer.\n     */\n    //% shim=BufferMethods::setNumber\n    setNumber(format: NumberFormat, offset: number, value: number): void;\n\n    /**\n     * Read a number in specified format from the buffer.\n     */\n    //% shim=BufferMethods::getNumber\n    getNumber(format: NumberFormat, offset: number): number;\n\n    /** Returns the length of a Buffer object. */\n    //% property shim=BufferMethods::length\n    length: number;\n\n    /**\n     * Fill (a fragment) of the buffer with given value.\n     */\n    //% offset.defl=0 length.defl=-1 shim=BufferMethods::fill\n    fill(value: number, offset?: number, length?: number): void;\n\n    /**\n     * Return a copy of a fragment of a buffer.\n     */\n    //% offset.defl=0 length.defl=-1 shim=BufferMethods::slice\n    slice(offset?: number, length?: number): Buffer;\n\n    /**\n     * Shift buffer left in place, with zero padding.\n     * @param offset number of bytes to shift; use negative value to shift right\n     * @param start start offset in buffer. Default is 0.\n     * @param length number of elements in buffer. If negative, length is set as the buffer length minus start. eg: -1\n     */\n    //% start.defl=0 length.defl=-1 shim=BufferMethods::shift\n    shift(offset: number, start?: number, length?: number): void;\n\n    /**\n     * Rotate buffer left in place.\n     * @param offset number of bytes to shift; use negative value to shift right\n     * @param start start offset in buffer. Default is 0.\n     * @param length number of elements in buffer. If negative, length is set as the buffer length minus start. eg: -1\n     */\n    //% start.defl=0 length.defl=-1 shim=BufferMethods::rotate\n    rotate(offset: number, start?: number, length?: number): void;\n\n    /**\n     * Write contents of `src` at `dstOffset` in current buffer.\n     */\n    //% shim=BufferMethods::write\n    write(dstOffset: number, src: Buffer): void;\n}\n\n// Auto-generated. Do not edit. Really.\n"
    },
    "radio": {
      "README.md": "# radio\n\nThe radio library.\n\n",
      "_locales/de/radio-jsdoc-strings.json": "{\n  \"radio\": \"Daten mithilfe von Funk-Paketen übertragen\",\n  \"radio.onDataPacketReceived\": \"Registriert Funktionen, die ausgeführt werden, wenn das Radio ein Datenpaket empfängt. Entnimmt das empfangene Paket aus der Warteschlange des Radios.\",\n  \"radio.onDataReceived\": \"Registriert Code der ausgeführt wird, wenn ein Paket über Funk empfangen wird.\",\n  \"radio.receiveNumber\": \"Liest das nächste Paket aus der Funk-Warteschlange und gibt die Paketnummer oder 0 aus, wenn das Paket keine Nummer enthält.\",\n  \"radio.receiveString\": \"Liest das nächste Paket aus der Funk-Warteschlange und gibt die enthaltene Zeichenfolge oder die leere Zeichenfolge aus, wenn das Paket keine Zeichenfolge enthält.\",\n  \"radio.receivedNumber\": \"Extrahiert eine Zahl aus dem Inhalt des letzten Datenpakets, welches aus der Warteschlange des Radios (via ``Zahl empfangen``, ``Zeichenkette empfangen``, etc) entnommen wurde oder eine 0, wenn das Paket keine Zahl enthält.\",\n  \"radio.receivedSerial\": \"Extrahiert die Seriennummer des Calliope mini Senders aus dem Inhalt des letzten Datenpakets, welches aus der Warteschlange des Radios entnommen wurde oder eine 0, wenn der Absender keine Seriennummer gesendet hat.\",\n  \"radio.receivedSignalStrength\": \"Ruft den empfangenen Signalstärkeindikator (RSSI) aus dem letzten Paket aus der Funk-Warteschlange aus (via ``receiveNumber``, ``receiveString``, etc). Wird im Simulator nicht unterstützt.\\nnamespace=radio\",\n  \"radio.receivedString\": \"Extrahiert die Zeichenkette aus dem Inhalt des letzten Datenpakets, welches aus der Warteschlange des Radios (via ``Zahl empfangen``, ``Zeichenkette empfangen``, etc) entnommen wurde oder eine leere Zeichenkette, wenn das Paket keine Zeichenkette enthält.\",\n  \"radio.receivedTime\": \"Extrahiert die Systemzeit des Absenders aus dem Inhalt des letzten Datenpakets, welches aus der Warteschlange des Radios (via ``Zahl empfangen``, ``Zeichenkette empfangen``, etc) entnommen wurde.\",\n  \"radio.sendNumber\": \"Überträgt eine Nummer über Funk an jeden angeschlossenen mini in der Gruppe.\",\n  \"radio.sendString\": \"Überträgt eine Zeichenfolge über Funk mit Seriennummer des Geräts und Laufzeit an jeden angeschlossenen mini in der Gruppe.\",\n  \"radio.sendValue\": \"Sendet ein Name / Wert-Paar zusammen mit der Seriennummer des Geräts und die Laufzeit auf alle angeschlossenen minis in der Gruppe.\",\n  \"radio.sendValue|param|name\": \"die Feldnamen (max. 12 Zeichen), z.B.: \\\"Daten\\\"\",\n  \"radio.sendValue|param|value\": \"der numerische Wert\",\n  \"radio.setTransmitPower\": \"Ändere die Ausgabeleistung des Senders auf den angegebenen Wert.\",\n  \"radio.setTransmitPower|param|power\": \"ein Wert im Bereich 0.. 7, wo 0 die niedrigste Leistung und 7 ist ist die höchste. z.B. 7\",\n  \"radio.setTransmitSerialNumber\": \"Stelle den Dunk so ein, dass die Seriennummer in jeder Nachricht übertragen wird.\",\n  \"radio.setTransmitSerialNumber|param|transmit\": \"Wert, der anzeigt, ob die Seriennummer übertragen wird, z.B. wahr\",\n  \"radio.writeReceivedPacketToSerial\": \"Schreibt das letzte empfangene Paket als JSON auf Seriell. Sollte in einem ´´onDataPacketReceived``-Callback aufgerufen werden.\",\n  \"radio.writeValueToSerial\": \"Liest das nächste Paket aus der Funk-Warteschlange und schreibt dieses als JSON auf Seriell.\"\n}",
      "_locales/de/radio-strings.json": "{\n  \"radio.onDataPacketReceived|block\": \"wenn Datenpaket empfangen\",\n  \"radio.onDataReceived|block\": \"über Funk empfangene Daten\",\n  \"radio.receiveNumber|block\": \"über Funk empfangene Zahl\",\n  \"radio.receiveString|block\": \"über Funk empfangene Zeichenfolge\",\n  \"radio.receivedSignalStrength|block\": \"über Funk empfangene Signalstärke\",\n  \"radio.sendNumber|block\": \"sende Zahl %value über Funk\",\n  \"radio.sendString|block\": \"sende Zeichenfolge %msg über Funk\",\n  \"radio.sendValue|block\": \"schicke | Wert %name |=%value über Funk\",\n  \"radio.setGroup|block\": \"setze Gruppe %ID über Funk\",\n  \"radio.setTransmitPower|block\": \"lege Übertragungsstärke %power über Funk fest\",\n  \"radio.setTransmitSerialNumber|block\": \"übertrage Übertragungs-Seriennummer %transmit über Funk\",\n  \"radio.writeReceivedPacketToSerial|block\": \"schreibe das über Funk emfangene Paket auf Seriell\",\n  \"radio.writeValueToSerial|block\": \"schreibe Wert auf Seriell über Funk\",\n  \"radio|block\": \"Funk\",\n  \"{id:category}Radio\": \"Funk\"\n}",
      "_locales/fr/radio-strings.json": "{\n  \"radio.writeReceivedPacketToSerial|block\": \"radio écrire paquet reçu vers connection série\",\n  \"{id:category}Radio\": \"Radio\"\n}",
      "_locales/ja/radio-jsdoc-strings.json": "{\n  \"radio.onDataPacketReceived\": \"無線でパケットを受信したときにコードが実行されます。\",\n  \"radio.sendNumber\": \"無線を使って繋がっているデバイスに、数字をブロードキャストします。\",\n  \"radio.sendString\": \"無線で繋がっているデバイスに、文字列とあわせてデバイスのシリアル番号と実行時間をブロードキャストします。\",\n  \"radio.sendValue\": \"無線で繋がっているデバイスに、名前と値のペアとあわせてデバイスのシリアル番号と実行時間をブロードキャストします。\",\n  \"radio.setTransmitPower\": \"無線での送信に使うパワーを指定します。\",\n  \"radio.setTransmitSerialNumber\": \"無線で、デバイスのシリアル番号を送信するかどうかを指定できます。\"\n}",
      "_locales/ja/radio-strings.json": "{\n  \"radio.onDataPacketReceived|block\": \"無線で受信したとき\",\n  \"radio.sendNumber|block\": \"無線で数字を送信 %value\",\n  \"radio.sendString|block\": \"無線で文字列を送信 %msg\",\n  \"radio.sendValue|block\": \"無線で送信 | %name |= %value\",\n  \"radio.setGroup|block\": \"無線のグループを設定 %ID\",\n  \"radio.setTransmitPower|block\": \"無線の送信パワー %power\",\n  \"radio.setTransmitSerialNumber|block\": \"無線でシリアル番号を送信 %transmit\",\n  \"{id:category}Radio\": \"無線\"\n}",
      "_locales/nl/radio-jsdoc-strings.json": "{\n  \"radio\": \"Communiceren van gegevens met behulp van radio-pakketten\",\n  \"radio.onDataPacketReceived\": \"Registreert code om uit te voeren wanneer de radio een pakket ontvangt. Neemt het pakket ook uit de radio wachtrij.\",\n  \"radio.onDataReceived\": \"Hiermee registreert u code kan worden uitgevoerd als een pakket wordt ontvangen via radio.\",\n  \"radio.receiveNumber\": \"Het volgende pakket worden gelezen als een nummer uit de wachtrij van de radio.\",\n  \"radio.receiveString\": \"Leest het volgende pakket als een tekenreeks en retourneert het.\",\n  \"radio.receivedNumber\": \"Retourneert de getal lading van het laatste pakket uit de radio wachtrij (via ``receiveNumber``, ``receiveString``, etc) of een 0 als dat pakket geen nummer bevatte.\",\n  \"radio.receivedSerial\": \"Retourneert het serienummer van de afzender micro:bit van het laatste pakket wat uit de radio wachtrij gehaald is (via ``receiveNumber``, ``receiveString``, etc) of 0 als dat pakket geen serienummer bevatte.\",\n  \"radio.receivedString\": \"Retourneert de tekenreeks inhoud van het laatste pakket wat uit de radio wachtrij gehaald is (via ``receiveNumber``, ``receiveString``, etc) of een lege reeks als dat pakket geen tekenreeks bevatte.\",\n  \"radio.receivedTime\": \"Retourneert de systeemtijd van de afzender micro:bit op het moment dat het laatste pakket uit de radio wachtrij verstuurd werd (via ``receiveNumber``,\\n``receiveString``, etc).\",\n  \"radio.sendNumber\": \"Zend een nummer uit via radio naar alle aangesloten micro:bit in de groep.\",\n  \"radio.sendValue\": \"Zend een naam / waarde paar samen met het serienummer van het apparaat en de speelduur door naar alle aangesloten micro:bit in de groep.\",\n  \"radio.sendValue|param|name\": \"het veld naam (max 12 karakters), bijvoorbeeld: \\\"gegevens\\\"\",\n  \"radio.sendValue|param|value\": \"de numerieke waarde\",\n  \"radio.setGroup|param|id\": \"de groep id tussen ``0`` en ``255``, bijv: 1\",\n  \"radio.setTransmitPower|param|power\": \"een waarde in het bereik van de 0..7, waar 0 de laagste vermogen en 7 is is de hoogste. BV: 7\",\n  \"radio.setTransmitSerialNumber|param|transmit\": \"waarde die aangeeft dat het serienummer is uitgezonden (b.v. WAAR)\",\n  \"radio.writeReceivedPacketToSerial\": \"Vertaal het laatste ontvangen pakket in een JSON bericht. Deze functie dient te worden gebruikt in de ``onDataPacketReceived`` callback functie.\",\n  \"radio.writeValueToSerial\": \"Een waarde die wordt verzonden met 'stream waarde' leest en schrijft het naar de seriële stroom als JSON\"\n}",
      "_locales/nl/radio-strings.json": "{\n  \"radio.onDataPacketReceived|block\": \"wanneer de radio ontvangt\",\n  \"radio.onDataReceived|block\": \"Radio op gegevens ontvangen\",\n  \"radio.receiveNumber|block\": \"radio ontvang nummer\",\n  \"radio.receiveString|block\": \"Radio ontvang zin\",\n  \"radio.receivedSignalStrength|block\": \"de sterkte van het signaal van de radio ontvangen\",\n  \"radio.sendNumber|block\": \"Radio verzend nummer %value\",\n  \"radio.sendString|block\": \"Radio verzend zin %msg\",\n  \"radio.sendValue|block\": \"Radio verzend | waarde %name | = %value\",\n  \"radio.setGroup|block\": \"Radio instellen groep %ID\",\n  \"radio.setTransmitPower|block\": \"Radio zet verzend kracht %power\",\n  \"radio.setTransmitSerialNumber|block\": \"Radio verander serienummer naar %transmit\",\n  \"radio.writeReceivedPacketToSerial|block\": \"radio schrijf ontvangen pakket naar serieel\",\n  \"radio.writeValueToSerial|block\": \"Radio schrijf waarde naar seriële poort\",\n  \"radio|block\": \"Radio\",\n  \"{id:category}Radio\": \"Radio\"\n}",
      "_locales/no/radio-jsdoc-strings.json": "{\n  \"radio.onDataPacketReceived\": \"Setter opp kode som skal kjøres når radioen mottar data. Henter mottatte data inn i en variabel.\"\n}",
      "_locales/no/radio-strings.json": "{\n  \"radio.onDataPacketReceived|block\": \"når radio mottar\",\n  \"radio.onDataReceived|block\": \"radio når data mottatt\",\n  \"radio.receiveNumber|block\": \"radio motta tall\",\n  \"radio.receiveString|block\": \"radio motta tekst\",\n  \"radio.receivedSignalStrength|block\": \"radio signalstyrke\",\n  \"radio.sendNumber|block\": \"radio send tall %value\",\n  \"radio.sendString|block\": \"radio send tekst %msg\",\n  \"radio.sendValue|block\": \"radio send|verdi %name|= %value\",\n  \"radio.setGroup|block\": \"radio sett gruppe %ID\",\n  \"radio.setTransmitPower|block\": \"radio sett sendereffekt %power\",\n  \"radio.setTransmitSerialNumber|block\": \"radio send alltid serienummer %transmit\",\n  \"radio.writeReceivedPacketToSerial|block\": \"radio skriv mottatt pakke til serieport\",\n  \"radio.writeValueToSerial|block\": \"radio skriv verdi til serieport\",\n  \"radio|block\": \"radio\",\n  \"{id:category}Radio\": \"Radio\"\n}",
      "_locales/si-LK/radio-jsdoc-strings.json": "{\n  \"radio\": \"රේඩියෝ පැකට්ටු යොදා ගෙන දත්ත සන්නිවේදනය\",\n  \"radio.onDataReceived\": \"රේඩියෝව හරහා පැකට්ටුවක් ලැබුණු විට කේතය දිවීම හගවනවා.\",\n  \"radio.sendValue|param|value\": \"සංඛ්‍යාමය අගය\"\n}",
      "_locales/si-LK/radio-strings.json": "{\n  \"radio.onDataReceived|block\": \"radio on data received\",\n  \"radio.receiveNumber|block\": \"radio receive number\",\n  \"radio.receiveString|block\": \"radio receive string\",\n  \"radio.receivedSignalStrength|block\": \"radio received signal strength\",\n  \"radio.sendNumber|block\": \"radio send number %value\",\n  \"radio.sendString|block\": \"radio send string %msg\",\n  \"radio.sendValue|block\": \"radio send|value %name|= %value\",\n  \"radio.setGroup|block\": \"radio set group %ID\",\n  \"radio.setTransmitPower|block\": \"radio set transmit power %power\",\n  \"radio.setTransmitSerialNumber|block\": \"radio set transmit serial number %transmit\",\n  \"radio.writeReceivedPacketToSerial|block\": \"radio write received packet to serial\",\n  \"radio.writeValueToSerial|block\": \"radio write value to serial\",\n  \"radio|block\": \"radio\",\n  \"{id:category}Radio\": \"රේඩියෝව\"\n}",
      "_locales/sv-SE/radio-strings.json": "{\n  \"radio.onDataReceived|block\": \"när radion tar emot data\",\n  \"radio.receiveNumber|block\": \"när radion tar emot nummer\",\n  \"radio.receiveString|block\": \"när radio tar emot sträng\",\n  \"radio.receivedSignalStrength|block\": \"när radio tar emot signalstyrka\",\n  \"radio.sendNumber|block\": \"radio sänd nummer %value\",\n  \"radio.sendString|block\": \"radio sänd sträng %msg\",\n  \"radio.sendValue|block\": \"radio sända|värde %name|= %value\",\n  \"radio.setGroup|block\": \"radio ställ in grupp %ID\",\n  \"radio.setTransmitPower|block\": \"radio ställ in överföringsstyrke %power\",\n  \"radio.setTransmitSerialNumber|block\": \"radio ställ in om serienumret sändas %transmit\",\n  \"radio.writeReceivedPacketToSerial|block\": \"radio skriv mottagna paketet till seriell\",\n  \"radio.writeValueToSerial|block\": \"radio skriv värdet till seriell\",\n  \"radio|block\": \"radio\",\n  \"{id:category}Radio\": \"Radio\"\n}",
      "enums.d.ts": "// Auto-generated. Do not edit.\ndeclare namespace radio {\n}\n\n// Auto-generated. Do not edit. Really.\n",
      "pxt.json": "{\n    \"name\": \"radio\",\n    \"description\": \"The radio services\",\n    \"files\": [\n        \"README.md\",\n        \"shims.d.ts\",\n        \"enums.d.ts\",\n        \"radio.cpp\",\n        \"radio.ts\",\n        \"_locales/de/radio-strings.json\",\n        \"_locales/de/radio-jsdoc-strings.json\",\n        \"_locales/si-LK/radio-strings.json\",\n        \"_locales/sv-SE/radio-strings.json\",\n        \"_locales/no/radio-strings.json\",\n        \"_locales/si-LK/radio-jsdoc-strings.json\",\n        \"_locales/no/radio-jsdoc-strings.json\",\n        \"_locales/ja/radio-strings.json\",\n        \"_locales/ja/radio-jsdoc-strings.json\",\n        \"_locales/nl/radio-strings.json\",\n        \"_locales/fr/radio-strings.json\",\n        \"_locales/nl/radio-jsdoc-strings.json\"\n    ],\n    \"public\": true,\n    \"dependencies\": {\n        \"core\": \"*\"\n    },\n    \"yotta\": {\n        \"config\": {\n            \"microbit-dal\": {\n                \"bluetooth\": {\n                    \"enabled\": 0\n                }\n            }\n        }\n    }\n}",
      "radio.cpp": "#include \"pxt.h\"\n\nusing namespace pxt;\n\n#define MAX_FIELD_NAME_LENGTH 12\n#define MAX_PAYLOAD_LENGTH 20\n#define PACKET_PREFIX_LENGTH 9\n#define VALUE_PACKET_NAME_LEN_OFFSET 13\n\n\n// Packet Spec:\n// | 0              | 1 ... 4       | 5 ... 8           | 9 ... 28\n// ----------------------------------------------------------------\n// | packet type    | system time   | serial number     | payload\n//\n// Serial number defaults to 0 unless enabled by user\n\n// payload: number (9 ... 12)\n#define PACKET_TYPE_NUMBER 0\n\n// payload: number (9 ... 12), name length (13), name (14 ... 26)\n#define PACKET_TYPE_VALUE 1\n\n// payload: string length (9), string (10 ... 28)\n#define PACKET_TYPE_STRING 2\n\n//% color=270 weight=96 icon=\"\\uf012\"\nnamespace radio {\n\n    // -------------------------------------------------------------------------\n    // Radio\n    // -------------------------------------------------------------------------\n    bool radioEnabled = false;\n    bool transmitSerialNumber = false;\n\n    PacketBuffer packet;\n\n    uint8_t type;\n    uint32_t time;\n    uint32_t serial;\n    int value;\n    StringData* msg;\n\n    int radioEnable() {\n        int r = uBit.radio.enable();\n        if (r != MICROBIT_OK) {\n            uBit.panic(43);\n            return r;\n        }\n        if (!radioEnabled) {\n            uBit.radio.setGroup(pxt::programHash());\n            radioEnabled = true;\n        }\n        return r;\n    }\n\n    void broadcastMessage(int message) {\n        if (radioEnable() != MICROBIT_OK) return;\n        uBit.radio.event.eventReceived(MicroBitEvent(MES_BROADCAST_GENERAL_ID, message, CREATE_ONLY));\n    }\n\n    void onBroadcastMessageReceived(int message, Action f) {\n        if (radioEnable() != MICROBIT_OK) return;\n        registerWithDal(MES_BROADCAST_GENERAL_ID, message, f);\n    }\n\n    void setPacketPrefix(uint8_t* buf, int type) {\n        // prefix: type (0), time (1..4), serial (5..8)\n        uint32_t t = system_timer_current_time();\n        uint32_t sn = transmitSerialNumber ? microbit_serial_number() : 0;\n\n        buf[0] = (uint8_t) type;\n        memcpy(buf + 1, &t, 4);\n        memcpy(buf + 5, &sn, 4);\n    }\n\n    uint8_t copyStringValue(uint8_t* buf, StringData* data, uint8_t maxLength) {\n        ManagedString s(data);\n        uint8_t len = min(maxLength, s.length());\n\n        // One byte for length of the string\n        buf[0] = len;\n\n        if (len > 0) {\n            memcpy(buf + 1, s.toCharArray(), len);\n        }\n        return len + 1;\n    }\n\n    StringData* getStringValue(uint8_t* buf, uint8_t maxLength) {\n        // First byte is the string length\n        uint8_t len = min(maxLength, buf[0]);\n\n        if (len) {\n            char name[maxLength + 1];\n            memcpy(name, buf + 1, len);\n            name[len] = 0;\n            return ManagedString(name).leakData();\n        }\n        return ManagedString().leakData();\n    }\n\n    void writePacketAsJSON(uint8_t tp, int v, int s, int t, StringData* m) {\n        // Convert the packet to JSON and send over serial\n        uBit.serial.send(\"{\");\n        uBit.serial.send(\"\\\"t\\\":\");\n        uBit.serial.send(t);\n        uBit.serial.send(\",\\\"s\\\":\");\n        uBit.serial.send(s);\n        if (tp == PACKET_TYPE_STRING || tp == PACKET_TYPE_VALUE) {\n            uBit.serial.send(\",\\\"n\\\":\\\"\");\n            uBit.serial.send(m);\n            uBit.serial.send(\"\\\"\");\n        }\n        if (tp == PACKET_TYPE_NUMBER || tp == PACKET_TYPE_VALUE) {\n            uBit.serial.send(\",\\\"v\\\":\");\n            uBit.serial.send(v);\n        }\n        uBit.serial.send(\"}\\r\\n\");\n    }\n\n    /**\n     * Takes a packet from the micro:bit radio queue.\n     * @param writeToSerial if true, write the received packet to serial without updating the global packet;\n                            if false, update the global packet instead\n     */\n    void receivePacket(bool writeToSerial) {\n        PacketBuffer p = uBit.radio.datagram.recv();\n\n        uint8_t* buf = p.getBytes();\n        uint8_t tp;\n        int t;\n        int s;\n        int v;\n        StringData* m;\n\n\n        memcpy(&tp, buf, 1);\n        memcpy(&t, buf + 1, 4);\n        memcpy(&s, buf + 5, 4);\n\n        if (tp == PACKET_TYPE_STRING) {\n            v = 0;\n            m = getStringValue(buf + PACKET_PREFIX_LENGTH, MAX_PAYLOAD_LENGTH - 1);\n        }\n        else {\n            memcpy(&v, buf + 9, 4);\n            if (tp == PACKET_TYPE_VALUE) {\n                m = getStringValue(buf + VALUE_PACKET_NAME_LEN_OFFSET, MAX_FIELD_NAME_LENGTH);\n            }\n            else {\n                m = ManagedString().leakData();\n            }\n        }\n\n        if (!writeToSerial) {\n            // Refresh global packet\n            packet = p;\n            type = tp;\n            time = t;\n            serial = s;\n            value = v;\n            msg = m;\n        }\n        else {\n            writePacketAsJSON(tp, v, s, t, m);\n        }\n    }\n\n    /**\n     * Broadcasts a number over radio to any connected micro:bit in the group.\n     */\n    //% help=radio/send-number\n    //% weight=60\n    //% blockId=radio_datagram_send block=\"radio send number %value\" blockGap=8\n    void sendNumber(int value) {\n        if (radioEnable() != MICROBIT_OK) return;\n        uint8_t length = PACKET_PREFIX_LENGTH + sizeof(uint32_t);\n        uint8_t buf[length];\n        memset(buf, 0, length);\n\n        setPacketPrefix(buf, PACKET_TYPE_NUMBER);\n        memcpy(buf + PACKET_PREFIX_LENGTH, &value, 4);\n\n        uBit.radio.datagram.send(buf, length);\n    }\n\n    /**\n    * Broadcasts a name / value pair along with the device serial number\n    * and running time to any connected micro:bit in the group.\n    * @param name the field name (max 12 characters), eg: \"name\"\n    * @param value the numberic value\n    */\n    //% help=radio/send-value\n    //% weight=59\n    //% blockId=radio_datagram_send_value block=\"radio send|value %name|= %value\" blockGap=8\n    void sendValue(StringData* name, int value) {\n        if (radioEnable() != MICROBIT_OK) return;\n\n        ManagedString n(name);\n        uint8_t buf[32];\n        memset(buf, 0, 32);\n\n        setPacketPrefix(buf, PACKET_TYPE_VALUE);\n        memcpy(buf + PACKET_PREFIX_LENGTH, &value, 4);\n\n        int stringLen = copyStringValue(buf + VALUE_PACKET_NAME_LEN_OFFSET, name, MAX_FIELD_NAME_LENGTH);\n\n        uBit.radio.datagram.send(buf, VALUE_PACKET_NAME_LEN_OFFSET + stringLen);\n    }\n\n    /**\n     * Broadcasts a string along with the device serial number\n     * and running time to any connected micro:bit in the group.\n     */\n    //% help=radio/send-string\n    //% weight=58\n    //% blockId=radio_datagram_send_string block=\"radio send string %msg\"\n    void sendString(StringData* msg) {\n        if (radioEnable() != MICROBIT_OK) return;\n\n        uint8_t buf[32];\n        memset(buf, 0, 32);\n\n        setPacketPrefix(buf, PACKET_TYPE_STRING);\n        int stringLen = copyStringValue(buf + PACKET_PREFIX_LENGTH, msg, MAX_PAYLOAD_LENGTH - 1);\n\n        uBit.radio.datagram.send(buf, PACKET_PREFIX_LENGTH + stringLen);\n    }\n\n    /**\n    * Reads the next packet from the radio queue and and writes it to serial\n    * as JSON.\n    */\n    //% help=radio/write-value-to-serial\n    //% weight=3\n    //% blockId=radio_write_value_serial block=\"radio write value to serial\"\n    //% deprecated=true\n    void writeValueToSerial() {\n        if (radioEnable() != MICROBIT_OK) return;\n        receivePacket(true);\n    }\n\n    /**\n    * Writes the last received packet to serial as JSON. This should be called\n    * within an ``onDataPacketReceived`` callback.\n    */\n    //% help=radio/write-received-packet-to-serial\n    //% weight=3\n    //% blockId=radio_write_packet_serial block=\"radio write received packet to serial\"\n    //% advanced=true\n    void writeReceivedPacketToSerial() {\n        if (radioEnable() != MICROBIT_OK) return;\n        writePacketAsJSON(type, value, (int) serial, (int) time, msg);\n    }\n\n    /**\n     * Reads the next packet from the radio queue and returns the packet's number\n     * payload or 0 if the packet did not contain a number.\n     */\n    //% help=radio/receive-number\n    //% weight=46\n    //% blockId=radio_datagram_receive block=\"radio receive number\" blockGap=8\n    //% deprecated=true\n    int receiveNumber()\n    {\n        if (radioEnable() != MICROBIT_OK) return 0;\n        receivePacket(false);\n        return value;\n    }\n\n    /**\n     * Registers code to run when a packet is received over radio.\n     */\n    //% help=radio/on-data-received\n    //% weight=50\n    //% blockId=radio_datagram_received_event block=\"radio on data received\" blockGap=8\n    //% deprecated=true\n    void onDataReceived(Action body) {\n        if (radioEnable() != MICROBIT_OK) return;\n        registerWithDal(MICROBIT_ID_RADIO, MICROBIT_RADIO_EVT_DATAGRAM, body);\n        // make sure the receive buffer has a free spot\n        receiveNumber();\n    }\n\n\n    /**\n     * Reads the next packet from the radio queue and returns the packet's string\n     * payload or the empty string if the packet did not contain a string.\n     */\n    //% blockId=radio_datagram_receive_string block=\"radio receive string\" blockGap=8\n    //% weight=44\n    //% help=radio/receive-string\n    //% deprecated=true\n    StringData* receiveString() {\n        if (radioEnable() != MICROBIT_OK) return ManagedString().leakData();\n        receivePacket(false);\n        return msg;\n    }\n\n    /**\n     * Gets the received signal strength indicator (RSSI) from the last packet taken\n     * from the radio queue (via ``receiveNumber``, ``receiveString``, etc). Not supported in simulator.\n     * namespace=radio\n     */\n    //% help=radio/received-signal-strength\n    //% weight=40\n    //% blockId=radio_datagram_rssi block=\"radio received signal strength\"\n    //% deprecated=true\n    int receivedSignalStrength() {\n        if (radioEnable() != MICROBIT_OK) return 0;\n        return packet.getRSSI();\n    }\n\n    /**\n     * Sets the group id for radio communications. A micro:bit can only listen to one group ID at any time.\n     * @param id the group id between ``0`` and ``255``, eg: 1\n     */\n    //% help=radio/set-group\n    //% weight=10 blockGap=8\n    //% blockId=radio_set_group block=\"radio set group %ID\"\n    //% id.min=0 id.max=255\n    void setGroup(int id) {\n        if (radioEnable() != MICROBIT_OK) return;\n        uBit.radio.setGroup(id);\n    }\n\n    /**\n     * Change the output power level of the transmitter to the given value.\n    * @param power a value in the range 0..7, where 0 is the lowest power and 7 is the highest. eg: 7\n    */\n    //% help=radio/set-transmit-power\n    //% weight=9 blockGap=8\n    //% blockId=radio_set_transmit_power block=\"radio set transmit power %power\"\n    //% power.min=0 power.max=7\n    //% advanced=true\n    void setTransmitPower(int power) {\n        if (radioEnable() != MICROBIT_OK) return;\n        uBit.radio.setTransmitPower(power);\n    }\n\n    /**\n    * Set the radio to transmit the serial number in each message.\n    * @param transmit value indicating if the serial number is transmitted, eg: true\n    */\n    //% help=radio/set-transmit-serial-number\n    //% weight=8 blockGap=8\n    //% blockId=radio_set_transmit_serial_number block=\"radio set transmit serial number %transmit\"\n    //% advanced=true\n    void setTransmitSerialNumber(bool transmit) {\n        if (radioEnable() != MICROBIT_OK) return;\n        transmitSerialNumber = transmit;\n    }\n\n    /**\n     * Returns the number payload from the last packet taken from the radio queue\n     * (via ``receiveNumber``, ``receiveString``, etc) or 0 if that packet did not\n     * contain a number.\n     */\n    //% help=radio/received-number\n    int receivedNumber() {\n        if (radioEnable() != MICROBIT_OK) return 0;\n        return value;\n    }\n\n    /**\n     * Returns the serial number of the sender micro:bit from the last packet taken\n     * from the radio queue (via ``receiveNumber``, ``receiveString``, etc) or 0 if\n     * that packet did not send a serial number.\n     */\n    //% help=radio/received-serial\n    uint32_t receivedSerial() {\n        if (radioEnable() != MICROBIT_OK) return 0;\n        return serial;\n    }\n\n    /**\n     * Returns the string payload from the last packet taken from the radio queue\n     * (via ``receiveNumber``, ``receiveString``, etc) or the empty string if that\n     * packet did not contain a string.\n     */\n    //% help=radio/received-string\n    StringData* receivedString() {\n        if (radioEnable() != MICROBIT_OK) return ManagedString().leakData();\n        return msg;\n    }\n\n    /**\n     * Returns the system time of the sender micro:bit at the moment when it sent the\n     * last packet taken from the radio queue (via ``receiveNumber``,\n     * ``receiveString``, etc).\n     */\n    //% help=radio/received-time\n    uint32_t receivedTime() {\n        if (radioEnable() != MICROBIT_OK) return 0;\n        return time;\n    }\n}\n",
      "radio.ts": "/**\n * Communicate data using radio packets\n */\n//% color=#E3008C weight=96 icon=\"\\uf012\"\nnamespace radio {\n    export class Packet {\n        /**\n         * The number payload if a number was sent in this packet (via ``sendNumber()`` or ``sendValue()``)\n         * or 0 if this packet did not contain a number.\n         */\n        public receivedNumber: number;\n        /**\n         * The string payload if a string was sent in this packet (via ``sendString()`` or ``sendValue()``)\n         * or the empty string if this packet did not contain a string.\n         */\n        public receivedString: string;\n        /**\n         * The system time of the sender of the packet at the time the packet was sent.\n         */\n        public time: number;\n        /**\n         * The serial number of the sender of the packet or 0 if the sender did not sent their serial number.\n         */\n        public serial: number;\n        /**\n         * The received signal strength indicator (RSSI) of the packet.\n         */\n        public signal: number;\n    }\n\n    /**\n     * Registers code to run when the radio receives a packet. Also takes the\n     * received packet from the radio queue.\n     */\n    //% help=radio/on-data-packet-received\n    //% mutate=objectdestructuring\n    //% mutateText=Packet\n    //% mutateDefaults=\"receivedNumber;receivedString:name,receivedNumber:value;receivedString\"\n    //% blockId=radio_on_packet block=\"on radio received\" blockGap=8\n    export function onDataPacketReceived(cb: (packet: Packet) => void) {\n        onDataReceived(() => {\n            receiveNumber();\n            const packet = new Packet();\n            packet.receivedNumber = receivedNumber();\n            packet.time = receivedTime();\n            packet.serial = receivedSerial();\n            packet.receivedString = receivedString();\n            packet.signal = receivedSignalStrength();\n            cb(packet)\n        });\n    }\n}\n",
      "shims.d.ts": "// Auto-generated. Do not edit.\n\n\n\n    //% color=270 weight=96 icon=\"\\uf012\"\ndeclare namespace radio {\n\n    /**\n     * Broadcasts a number over radio to any connected micro:bit in the group.\n     */\n    //% help=radio/send-number\n    //% weight=60\n    //% blockId=radio_datagram_send block=\"radio send number %value\" blockGap=8 shim=radio::sendNumber\n    function sendNumber(value: number): void;\n\n    /**\n     * Broadcasts a name / value pair along with the device serial number\n     * and running time to any connected micro:bit in the group.\n     * @param name the field name (max 12 characters), eg: \"name\"\n     * @param value the numberic value\n     */\n    //% help=radio/send-value\n    //% weight=59\n    //% blockId=radio_datagram_send_value block=\"radio send|value %name|= %value\" blockGap=8 shim=radio::sendValue\n    function sendValue(name: string, value: number): void;\n\n    /**\n     * Broadcasts a string along with the device serial number\n     * and running time to any connected micro:bit in the group.\n     */\n    //% help=radio/send-string\n    //% weight=58\n    //% blockId=radio_datagram_send_string block=\"radio send string %msg\" shim=radio::sendString\n    function sendString(msg: string): void;\n\n    /**\n     * Reads the next packet from the radio queue and and writes it to serial\n     * as JSON.\n     */\n    //% help=radio/write-value-to-serial\n    //% weight=3\n    //% blockId=radio_write_value_serial block=\"radio write value to serial\"\n    //% deprecated=true shim=radio::writeValueToSerial\n    function writeValueToSerial(): void;\n\n    /**\n     * Writes the last received packet to serial as JSON. This should be called\n     * within an ``onDataPacketReceived`` callback.\n     */\n    //% help=radio/write-received-packet-to-serial\n    //% weight=3\n    //% blockId=radio_write_packet_serial block=\"radio write received packet to serial\"\n    //% advanced=true shim=radio::writeReceivedPacketToSerial\n    function writeReceivedPacketToSerial(): void;\n\n    /**\n     * Reads the next packet from the radio queue and returns the packet's number\n     * payload or 0 if the packet did not contain a number.\n     */\n    //% help=radio/receive-number\n    //% weight=46\n    //% blockId=radio_datagram_receive block=\"radio receive number\" blockGap=8\n    //% deprecated=true shim=radio::receiveNumber\n    function receiveNumber(): number;\n\n    /**\n     * Registers code to run when a packet is received over radio.\n     */\n    //% help=radio/on-data-received\n    //% weight=50\n    //% blockId=radio_datagram_received_event block=\"radio on data received\" blockGap=8\n    //% deprecated=true shim=radio::onDataReceived\n    function onDataReceived(body: () => void): void;\n\n    /**\n     * Reads the next packet from the radio queue and returns the packet's string\n     * payload or the empty string if the packet did not contain a string.\n     */\n    //% blockId=radio_datagram_receive_string block=\"radio receive string\" blockGap=8\n    //% weight=44\n    //% help=radio/receive-string\n    //% deprecated=true shim=radio::receiveString\n    function receiveString(): string;\n\n    /**\n     * Gets the received signal strength indicator (RSSI) from the last packet taken\n     * from the radio queue (via ``receiveNumber``, ``receiveString``, etc). Not supported in simulator.\n     * namespace=radio\n     */\n    //% help=radio/received-signal-strength\n    //% weight=40\n    //% blockId=radio_datagram_rssi block=\"radio received signal strength\"\n    //% deprecated=true shim=radio::receivedSignalStrength\n    function receivedSignalStrength(): number;\n\n    /**\n     * Sets the group id for radio communications. A micro:bit can only listen to one group ID at any time.\n     * @param id the group id between ``0`` and ``255``, eg: 1\n     */\n    //% help=radio/set-group\n    //% weight=10 blockGap=8\n    //% blockId=radio_set_group block=\"radio set group %ID\"\n    //% id.min=0 id.max=255 shim=radio::setGroup\n    function setGroup(id: number): void;\n\n    /**\n     * Change the output power level of the transmitter to the given value.\n     * @param power a value in the range 0..7, where 0 is the lowest power and 7 is the highest. eg: 7\n     */\n    //% help=radio/set-transmit-power\n    //% weight=9 blockGap=8\n    //% blockId=radio_set_transmit_power block=\"radio set transmit power %power\"\n    //% power.min=0 power.max=7\n    //% advanced=true shim=radio::setTransmitPower\n    function setTransmitPower(power: number): void;\n\n    /**\n     * Set the radio to transmit the serial number in each message.\n     * @param transmit value indicating if the serial number is transmitted, eg: true\n     */\n    //% help=radio/set-transmit-serial-number\n    //% weight=8 blockGap=8\n    //% blockId=radio_set_transmit_serial_number block=\"radio set transmit serial number %transmit\"\n    //% advanced=true shim=radio::setTransmitSerialNumber\n    function setTransmitSerialNumber(transmit: boolean): void;\n\n    /**\n     * Returns the number payload from the last packet taken from the radio queue\n     * (via ``receiveNumber``, ``receiveString``, etc) or 0 if that packet did not\n     * contain a number.\n     */\n    //% help=radio/received-number shim=radio::receivedNumber\n    function receivedNumber(): number;\n\n    /**\n     * Returns the serial number of the sender micro:bit from the last packet taken\n     * from the radio queue (via ``receiveNumber``, ``receiveString``, etc) or 0 if\n     * that packet did not send a serial number.\n     */\n    //% help=radio/received-serial shim=radio::receivedSerial\n    function receivedSerial(): number;\n\n    /**\n     * Returns the string payload from the last packet taken from the radio queue\n     * (via ``receiveNumber``, ``receiveString``, etc) or the empty string if that\n     * packet did not contain a string.\n     */\n    //% help=radio/received-string shim=radio::receivedString\n    function receivedString(): string;\n\n    /**\n     * Returns the system time of the sender micro:bit at the moment when it sent the\n     * last packet taken from the radio queue (via ``receiveNumber``,\n     * ``receiveString``, etc).\n     */\n    //% help=radio/received-time shim=radio::receivedTime\n    function receivedTime(): number;\n}\n\n// Auto-generated. Do not edit. Really.\n"
    },
    "devices": {
      "README.md": "# devices\n",
      "_locales/fr/devices-jsdoc-strings.json": "{\n  \"devices\": \"Contrôler un téléphone avec le BBC micro : bit via Bluetooth.\"\n}",
      "_locales/ja/devices-jsdoc-strings.json": "{\n  \"devices.onGamepadButton|param|body\": \"ボタンが押されたときに実行するコード\"\n}",
      "_locales/ja/devices-strings.json": "{\n  \"MesDeviceInfo.Shaken|block\": \"ゆさぶられる\"\n}",
      "_locales/nl/devices-jsdoc-strings.json": "{\n  \"devices\": \"Bedien een telefoon met de BBC micro:bit via Bluetooth.\",\n  \"devices.onGamepadButton|param|body\": \"code dat uitgevoerd moet worden wanneer de knop wordt ingedrukt\",\n  \"devices.onGamepadButton|param|name\": \"knopnaam\",\n  \"devices.onNotified\": \"Hiermee registreert u code die wordt uitgevoerd wanneer het apparaat een bepaalde gebeurtenis aangeeft.\",\n  \"devices.onNotified|param|event\": \"Beschrijving van gebeurtenis\",\n  \"devices.onSignalStrengthChanged|param|body\": \"Code om uit te voeren wanneer de signaalsterkte wijzigt.\",\n  \"devices.raiseAlertTo\": \"Stuurt een '' waarschuwing '' commando naar het bovenliggende apparaat.\",\n  \"devices.raiseAlertTo|param|event\": \"Beschrijving van gebeurtenis\",\n  \"devices.signalStrength\": \"Deze eigenschap geeft de laatste signaalsterkte gerapporteerd door het gekoppelde apparaat terug.\",\n  \"devices.tellCameraTo\": \"Stuurt een '' camera'' commando naar het bovenliggende apparaat.\",\n  \"devices.tellCameraTo|param|event\": \"Beschrijving van gebeurtenis\",\n  \"devices.tellRemoteControlTo\": \"Stuurt een '' afstandsbediening '' commando naar het bovenliggende apparaat.\",\n  \"devices.tellRemoteControlTo|param|event\": \"Beschrijving van gebeurtenis\"\n}",
      "_locales/nl/devices-strings.json": "{\n  \"MesAlertEvent.DisplayToast|block\": \"melding weergeven\",\n  \"MesAlertEvent.FindMyPhone|block\": \"mijn telefoon zoeken\",\n  \"MesAlertEvent.PlayRingtone|block\": \"beltoon afspelen\",\n  \"MesAlertEvent.PlaySound|block\": \"speel geluid af\",\n  \"MesAlertEvent.RingAlarm2|block\": \"speel alarm 2 af\",\n  \"MesAlertEvent.RingAlarm3|block\": \"speel alarm 3 af\",\n  \"MesAlertEvent.RingAlarm4|block\": \"speel alarm 4 af\",\n  \"MesAlertEvent.RingAlarm5|block\": \"speel alarm 5 af\",\n  \"MesAlertEvent.RingAlarm6|block\": \"speel alarm 6 af\",\n  \"MesAlertEvent.RingAlarm|block\": \"speel alarm af\",\n  \"MesAlertEvent.Vibrate|block\": \"trillen\",\n  \"MesCameraEvent.LaunchPhotoMode|block\": \"start foto modus\",\n  \"MesCameraEvent.LaunchVideoMode|block\": \"start video modus\",\n  \"MesCameraEvent.StartVideoCapture|block\": \"start video opnemen\",\n  \"MesCameraEvent.StopPhotoMode|block\": \"start foto modus\",\n  \"MesCameraEvent.StopVideoCapture|block\": \"start video opnemen\",\n  \"MesCameraEvent.StopVideoMode|block\": \"stop video opnemen\",\n  \"MesCameraEvent.TakePhoto|block\": \"neem een foto\",\n  \"MesCameraEvent.ToggleFrontRear|block\": \"wissel voor-achter\",\n  \"MesDeviceInfo.DisplayOff|block\": \"beeldscherm uit\",\n  \"MesDeviceInfo.DisplayOn|block\": \"beeldscherm aan\",\n  \"MesDeviceInfo.IncomingCall|block\": \"binnenkomende oproep\",\n  \"MesDeviceInfo.IncomingMessage|block\": \"binnenkomend bericht\",\n  \"MesDeviceInfo.OrientationLandscape|block\": \"liggend\",\n  \"MesDeviceInfo.OrientationPortrait|block\": \"staand\",\n  \"MesDeviceInfo.Shaken|block\": \"schudden\",\n  \"MesDpadButtonInfo.ADown|block\": \"A omlaag\",\n  \"MesDpadButtonInfo.AUp|block\": \"A omhoog\",\n  \"MesDpadButtonInfo.BDown|block\": \"B omlaag\",\n  \"MesDpadButtonInfo.BUp|block\": \"B omhoog\",\n  \"MesDpadButtonInfo.CDown|block\": \"C omlaag\",\n  \"MesDpadButtonInfo.CUp|block\": \"C omhoog\",\n  \"MesDpadButtonInfo.DDown|block\": \"D omlaag\",\n  \"MesDpadButtonInfo.DUp|block\": \"D omhoog\",\n  \"MesDpadButtonInfo._1Down|block\": \"1 omlaag\",\n  \"MesDpadButtonInfo._1Up|block\": \"1 omhoog\",\n  \"MesDpadButtonInfo._2Down|block\": \"2 omlaag\",\n  \"MesDpadButtonInfo._2Up|block\": \"2 omhoog\",\n  \"MesDpadButtonInfo._3Down|block\": \"3 omlaag\",\n  \"MesDpadButtonInfo._3Up|block\": \"3 omhoog\",\n  \"MesDpadButtonInfo._4Down|block\": \"4 omlaag\",\n  \"MesDpadButtonInfo._4Up|block\": \"4 omhoog\",\n  \"MesRemoteControlEvent.forward|block\": \"vooruit\",\n  \"MesRemoteControlEvent.nextTrack|block\": \"volgend nummer\",\n  \"MesRemoteControlEvent.pause|block\": \"pauze\",\n  \"MesRemoteControlEvent.play|block\": \"afspelen\",\n  \"MesRemoteControlEvent.previousTrack|block\": \"vorig nummer\",\n  \"MesRemoteControlEvent.rewind|block\": \"terugspoelen\",\n  \"MesRemoteControlEvent.stop|block\": \"stop\",\n  \"MesRemoteControlEvent.volumeDown|block\": \"volume omlaag\",\n  \"MesRemoteControlEvent.volumeUp|block\": \"volume omhoog\",\n  \"devices.onGamepadButton|block\": \"op de knop van het gamepad |%NAME\",\n  \"devices.onNotified|block\": \"op de hoogte gebracht |%event\",\n  \"devices.onSignalStrengthChanged|block\": \"als de sterkte van het signaal verandert\",\n  \"devices.signalStrength|block\": \"signaalsterkte\",\n  \"devices|block\": \"apparaten\",\n  \"{id:category}Devices\": \"Apparaten\"\n}",
      "_locales/no/devices-strings.json": "{\n  \"MesAlertEvent.DisplayToast|block\": \"meldingsvindu\",\n  \"MesAlertEvent.FindMyPhone|block\": \"finn telefonen\",\n  \"MesAlertEvent.PlayRingtone|block\": \"ringetone\",\n  \"MesAlertEvent.PlaySound|block\": \"spill lyd\",\n  \"MesAlertEvent.RingAlarm2|block\": \"ring alarm 2\",\n  \"MesAlertEvent.RingAlarm3|block\": \"ring alarm 3\",\n  \"MesAlertEvent.RingAlarm4|block\": \"ring alarm 4\",\n  \"MesAlertEvent.RingAlarm5|block\": \"ring alarm 5\",\n  \"MesAlertEvent.RingAlarm6|block\": \"ring alarm 6\",\n  \"MesAlertEvent.RingAlarm|block\": \"ring alarm\",\n  \"MesAlertEvent.Vibrate|block\": \"vibrasjon\",\n  \"MesCameraEvent.LaunchPhotoMode|block\": \"åpne fotomodus\",\n  \"MesCameraEvent.LaunchVideoMode|block\": \"åpne videomodus\",\n  \"MesCameraEvent.StartVideoCapture|block\": \"ta opp video\",\n  \"MesCameraEvent.StopPhotoMode|block\": \"stopp fotomodus\",\n  \"MesCameraEvent.StopVideoCapture|block\": \"stopp videoopptak\",\n  \"MesCameraEvent.StopVideoMode|block\": \"stopp videomodus\",\n  \"MesCameraEvent.TakePhoto|block\": \"ta bilde\",\n  \"MesCameraEvent.ToggleFrontRear|block\": \"bytt forside-bakside\",\n  \"MesDeviceInfo.DisplayOff|block\": \"skjerm av\",\n  \"MesDeviceInfo.DisplayOn|block\": \"skjerm på\",\n  \"MesDeviceInfo.IncomingCall|block\": \"anrop\",\n  \"MesDeviceInfo.IncomingMessage|block\": \"melding mottatt\",\n  \"MesDeviceInfo.OrientationLandscape|block\": \"liggende orientering\",\n  \"MesDeviceInfo.OrientationPortrait|block\": \"stående orientering\",\n  \"MesDeviceInfo.Shaken|block\": \"ristet\",\n  \"MesDpadButtonInfo.ADown|block\": \"A trykkes ned\",\n  \"MesDpadButtonInfo.AUp|block\": \"A slippes opp\",\n  \"MesDpadButtonInfo.BDown|block\": \"B trykkes ned\",\n  \"MesDpadButtonInfo.BUp|block\": \"B slippes opp\",\n  \"MesDpadButtonInfo.CDown|block\": \"C trykkes ned\",\n  \"MesDpadButtonInfo.CUp|block\": \"C slippes opp\",\n  \"MesDpadButtonInfo.DDown|block\": \"D trykkes ned\",\n  \"MesDpadButtonInfo.DUp|block\": \"D slippes opp\",\n  \"MesDpadButtonInfo._1Down|block\": \"1 trykkes ned\",\n  \"MesDpadButtonInfo._1Up|block\": \"1 slippes opp\",\n  \"MesDpadButtonInfo._2Down|block\": \"2 trykkes ned\",\n  \"MesDpadButtonInfo._2Up|block\": \"2 slippes opp\",\n  \"MesDpadButtonInfo._3Down|block\": \"3 trykkes ned\",\n  \"MesDpadButtonInfo._3Up|block\": \"3 slippes opp\",\n  \"MesDpadButtonInfo._4Down|block\": \"4 trykkes ned\",\n  \"MesDpadButtonInfo._4Up|block\": \"4 slippes opp\",\n  \"MesRemoteControlEvent.forward|block\": \"framover\",\n  \"MesRemoteControlEvent.nextTrack|block\": \"neste spor\",\n  \"MesRemoteControlEvent.pause|block\": \"pause\",\n  \"MesRemoteControlEvent.play|block\": \"spill av\",\n  \"MesRemoteControlEvent.previousTrack|block\": \"forrige spor\",\n  \"MesRemoteControlEvent.rewind|block\": \"tilbake\",\n  \"MesRemoteControlEvent.stop|block\": \"stopp\",\n  \"MesRemoteControlEvent.volumeDown|block\": \"volum ned\",\n  \"MesRemoteControlEvent.volumeUp|block\": \"volum opp\",\n  \"devices.onGamepadButton|block\": \"når spillkontroll-knapp |%NAME trykkes\",\n  \"devices.onNotified|block\": \"når varslet om|%event\",\n  \"devices.onSignalStrengthChanged|block\": \"når signalstyrken endrer seg\",\n  \"devices.raiseAlertTo|block\": \"varsle med|%property\",\n  \"devices.signalStrength|block\": \"signalstyrke\",\n  \"devices.tellCameraTo|block\": \"fjernstyring kamera|%property\",\n  \"devices.tellRemoteControlTo|block\": \"fjernstyring musikkspiller|%property\",\n  \"devices|block\": \"enheter\",\n  \"{id:category}Devices\": \"Fjernstyring\"\n}",
      "devices.cpp": "#include \"pxt.h\"\n#include \"MESEvents.h\"\n\nusing namespace pxt;\n\nenum class MesCameraEvent {\n    //% block=\"take photo\"\n    TakePhoto = MES_CAMERA_EVT_TAKE_PHOTO,\n    //% block=\"start video capture\"\n    StartVideoCapture = MES_CAMERA_EVT_START_VIDEO_CAPTURE,\n    //% block=\"stop video capture\"\n    StopVideoCapture = MES_CAMERA_EVT_STOP_VIDEO_CAPTURE,\n    //% block=\"toggle front-rear\"\n    ToggleFrontRear = MES_CAMERA_EVT_TOGGLE_FRONT_REAR,\n    //% block=\"launch photo mode\"\n    LaunchPhotoMode = MES_CAMERA_EVT_LAUNCH_PHOTO_MODE,\n    //% block=\"launch video mode\"\n    LaunchVideoMode = MES_CAMERA_EVT_LAUNCH_VIDEO_MODE,\n    //% block=\"stop photo mode\"\n    StopPhotoMode = MES_CAMERA_EVT_STOP_PHOTO_MODE,\n    //% block=\"stop video mode\"\n    StopVideoMode = MES_CAMERA_EVT_STOP_VIDEO_MODE,\n};\n\nenum class MesAlertEvent {\n    //% block=\"display toast\"\n    DisplayToast = MES_ALERT_EVT_DISPLAY_TOAST,\n    //% block=\"vibrate\"\n    Vibrate = MES_ALERT_EVT_VIBRATE,\n    //% block=\"play sound\"\n    PlaySound = MES_ALERT_EVT_PLAY_SOUND,\n    //% block=\"play ring tone\"\n    PlayRingtone = MES_ALERT_EVT_PLAY_RINGTONE,\n    //% block=\"find my phone\"\n    FindMyPhone = MES_ALERT_EVT_FIND_MY_PHONE,\n    //% block=\"ring alarm\"\n    RingAlarm = MES_ALERT_EVT_ALARM1,\n    //% block=\"ring alarm 2\"\n    RingAlarm2 = MES_ALERT_EVT_ALARM2,\n    //% block=\"ring alarm 3\"\n    RingAlarm3 = MES_ALERT_EVT_ALARM3,\n    //% block=\"ring alarm 4\"\n    RingAlarm4 = MES_ALERT_EVT_ALARM4,\n    //% block=\"ring alarm 5\"\n    RingAlarm5 = MES_ALERT_EVT_ALARM5,\n    //% block=\"ring alarm 6\"\n    RingAlarm6 = MES_ALERT_EVT_ALARM6,\n};\n\nenum class MesDeviceInfo {\n    //% block=\"incoming call\"\n    IncomingCall = MES_DEVICE_INCOMING_CALL,\n    //% block=\"incoming message\"\n    IncomingMessage = MES_DEVICE_INCOMING_MESSAGE,\n    //% block=\"orientation landscape\"\n    OrientationLandscape = MES_DEVICE_ORIENTATION_LANDSCAPE,\n    //% block=\"orientation portrait\"\n    OrientationPortrait = MES_DEVICE_ORIENTATION_PORTRAIT,\n    //% block=\"shaken\"\n    Shaken = MES_DEVICE_GESTURE_DEVICE_SHAKEN,\n    //% block=\"display off\"\n    DisplayOff = MES_DEVICE_DISPLAY_OFF,\n    //% block=\"display on\"\n    DisplayOn = MES_DEVICE_DISPLAY_ON,\n};\n\nenum class MesRemoteControlEvent {\n    //% block=\"play\"\n    play = MES_REMOTE_CONTROL_EVT_PLAY,\n    //% block=\"pause\"\n    pause = MES_REMOTE_CONTROL_EVT_PAUSE,\n    //% block=\"stop\"\n    stop = MES_REMOTE_CONTROL_EVT_STOP,\n    //% block=\"next track\"\n    nextTrack = MES_REMOTE_CONTROL_EVT_NEXTTRACK,\n    //% block=\"previous track\"\n    previousTrack = MES_REMOTE_CONTROL_EVT_PREVTRACK,\n    //% block=\"forward\"\n    forward = MES_REMOTE_CONTROL_EVT_FORWARD,\n    //% block=\"rewind\"\n    rewind = MES_REMOTE_CONTROL_EVT_REWIND,\n    //% block=\"volume up\"\n    volumeUp = MES_REMOTE_CONTROL_EVT_VOLUMEUP,\n    //% block=\"volume down\"\n    volumeDown = MES_REMOTE_CONTROL_EVT_VOLUMEDOWN,\n};\n\n/**\n * Control a phone with the BBC micro:bit via Bluetooth.\n */\n//% color=#008272 weight=80 icon=\"\\uf10b\"\nnamespace devices {\n\n    static int _signalStrength = -1;\n    static void signalStrengthHandler(MicroBitEvent ev) { \n        // keep in sync with MESEvents.h\n        _signalStrength = ev.value - 1; \n    }\n    static void initSignalStrength() {\n        if (_signalStrength < 0) {\n            _signalStrength = 0;\n            uBit.messageBus.listen(MES_SIGNAL_STRENGTH_ID, MICROBIT_EVT_ANY, signalStrengthHandler);\n        }        \n    }\n    \n    /**\n     * Returns the last signal strength reported by the paired device.\n     */\n    //% help=devices/signal-strength weight=24\n    //% blockId=devices_signal_strength block=\"signal strength\" blockGap=14 icon=\"\\uf012\" blockGap=14\n    int signalStrength() {\n        initSignalStrength();\n        return _signalStrength;\n    }\n\n    /**\n     * Registers code to run when the device notifies about a change of signal strength.\n     * @param body Code run when the signal strength changes.\n     */\n    //% weight=23 help=devices/on-signal-strength-changed\n    //% blockId=devices_signal_strength_changed_event block=\"on signal strength changed\" icon=\"\\uf012\"\n    void onSignalStrengthChanged(Action body) {\n        initSignalStrength();    \n        registerWithDal(MES_SIGNAL_STRENGTH_ID, MICROBIT_EVT_ANY, body);\n    }\n}\n",
      "devices.ts": "\nnamespace devices {\n    /**\n     * Sends a ``camera`` command to the parent device.\n     * @param event event description\n     */\n    //% weight=30 help=devices/tell-camera-to\n    //% blockId=devices_camera icon=\"\\uf030\" block=\"tell camera to|%property\" blockGap=8\n    export function tellCameraTo(event: MesCameraEvent) {\n        control.raiseEvent(DAL.MES_CAMERA_ID, event);\n    }\n\n    /**\n     * Sends a ``remote control`` command to the parent device.\n     * @param event event description\n     */\n    //% weight=29 help=devices/tell-remote-control-to\n    //% blockId=devices_remote_control block=\"tell remote control to|%property\" blockGap=14 icon=\"\\uf144\"\n    export function tellRemoteControlTo(event: MesRemoteControlEvent) {\n        control.raiseEvent(DAL.MES_REMOTE_CONTROL_ID, event);\n    }\n\n    /**\n     * Sends an ``alert`` command to the parent device.\n     * @param event event description\n     */\n    //% weight=27 help=devices/raise-alert-to\n    //% blockId=devices_alert block=\"raise alert to|%property\" icon=\"\\uf0f3\"\n    export function raiseAlertTo(event: MesAlertEvent) {\n        control.raiseEvent(DAL.MES_ALERTS_ID, event);\n    }\n\n    /**\n     * Registers code to run when the device notifies about a particular event.\n     * @param event event description\n     * @param body code handler when event is triggered\n     */\n    //% help=devices/on-notified weight=26\n    //% blockId=devices_device_info_event block=\"on notified|%event\" icon=\"\\uf10a\"\n    export function onNotified(event: MesDeviceInfo, body: Action) {\n        control.onEvent(DAL.MES_DEVICE_INFO_ID, event, body);\n    }\n\n    /**\n     * Register code to run when the micro:bit receives a command from the paired gamepad.\n     * @param name button name\n     * @param body code to run when button is pressed\n     */\n    //% help=devices/on-gamepad-button weight=40\n    //% weight=25\n    //% blockId=devices_gamepad_event block=\"on gamepad button|%NAME\" icon=\"\\uf11b\"\n    export function onGamepadButton(name: MesDpadButtonInfo, body: Action) {\n        control.onEvent(DAL.MES_DPAD_CONTROLLER_ID, name, body);\n    }\n}",
      "enums.d.ts": "// Auto-generated. Do not edit.\n\n\n    declare enum MesCameraEvent {\n    //% block=\"take photo\"\n    TakePhoto = 3,  // MES_CAMERA_EVT_TAKE_PHOTO\n    //% block=\"start video capture\"\n    StartVideoCapture = 4,  // MES_CAMERA_EVT_START_VIDEO_CAPTURE\n    //% block=\"stop video capture\"\n    StopVideoCapture = 5,  // MES_CAMERA_EVT_STOP_VIDEO_CAPTURE\n    //% block=\"toggle front-rear\"\n    ToggleFrontRear = 8,  // MES_CAMERA_EVT_TOGGLE_FRONT_REAR\n    //% block=\"launch photo mode\"\n    LaunchPhotoMode = 1,  // MES_CAMERA_EVT_LAUNCH_PHOTO_MODE\n    //% block=\"launch video mode\"\n    LaunchVideoMode = 2,  // MES_CAMERA_EVT_LAUNCH_VIDEO_MODE\n    //% block=\"stop photo mode\"\n    StopPhotoMode = 6,  // MES_CAMERA_EVT_STOP_PHOTO_MODE\n    //% block=\"stop video mode\"\n    StopVideoMode = 7,  // MES_CAMERA_EVT_STOP_VIDEO_MODE\n    }\n\n\n    declare enum MesAlertEvent {\n    //% block=\"display toast\"\n    DisplayToast = 1,  // MES_ALERT_EVT_DISPLAY_TOAST\n    //% block=\"vibrate\"\n    Vibrate = 2,  // MES_ALERT_EVT_VIBRATE\n    //% block=\"play sound\"\n    PlaySound = 3,  // MES_ALERT_EVT_PLAY_SOUND\n    //% block=\"play ring tone\"\n    PlayRingtone = 4,  // MES_ALERT_EVT_PLAY_RINGTONE\n    //% block=\"find my phone\"\n    FindMyPhone = 5,  // MES_ALERT_EVT_FIND_MY_PHONE\n    //% block=\"ring alarm\"\n    RingAlarm = 6,  // MES_ALERT_EVT_ALARM1\n    //% block=\"ring alarm 2\"\n    RingAlarm2 = 7,  // MES_ALERT_EVT_ALARM2\n    //% block=\"ring alarm 3\"\n    RingAlarm3 = 8,  // MES_ALERT_EVT_ALARM3\n    //% block=\"ring alarm 4\"\n    RingAlarm4 = 9,  // MES_ALERT_EVT_ALARM4\n    //% block=\"ring alarm 5\"\n    RingAlarm5 = 10,  // MES_ALERT_EVT_ALARM5\n    //% block=\"ring alarm 6\"\n    RingAlarm6 = 11,  // MES_ALERT_EVT_ALARM6\n    }\n\n\n    declare enum MesDeviceInfo {\n    //% block=\"incoming call\"\n    IncomingCall = 7,  // MES_DEVICE_INCOMING_CALL\n    //% block=\"incoming message\"\n    IncomingMessage = 8,  // MES_DEVICE_INCOMING_MESSAGE\n    //% block=\"orientation landscape\"\n    OrientationLandscape = 1,  // MES_DEVICE_ORIENTATION_LANDSCAPE\n    //% block=\"orientation portrait\"\n    OrientationPortrait = 2,  // MES_DEVICE_ORIENTATION_PORTRAIT\n    //% block=\"shaken\"\n    Shaken = 4,  // MES_DEVICE_GESTURE_DEVICE_SHAKEN\n    //% block=\"display off\"\n    DisplayOff = 5,  // MES_DEVICE_DISPLAY_OFF\n    //% block=\"display on\"\n    DisplayOn = 6,  // MES_DEVICE_DISPLAY_ON\n    }\n\n\n    declare enum MesRemoteControlEvent {\n    //% block=\"play\"\n    play = 1,  // MES_REMOTE_CONTROL_EVT_PLAY\n    //% block=\"pause\"\n    pause = 2,  // MES_REMOTE_CONTROL_EVT_PAUSE\n    //% block=\"stop\"\n    stop = 3,  // MES_REMOTE_CONTROL_EVT_STOP\n    //% block=\"next track\"\n    nextTrack = 4,  // MES_REMOTE_CONTROL_EVT_NEXTTRACK\n    //% block=\"previous track\"\n    previousTrack = 5,  // MES_REMOTE_CONTROL_EVT_PREVTRACK\n    //% block=\"forward\"\n    forward = 6,  // MES_REMOTE_CONTROL_EVT_FORWARD\n    //% block=\"rewind\"\n    rewind = 7,  // MES_REMOTE_CONTROL_EVT_REWIND\n    //% block=\"volume up\"\n    volumeUp = 8,  // MES_REMOTE_CONTROL_EVT_VOLUMEUP\n    //% block=\"volume down\"\n    volumeDown = 9,  // MES_REMOTE_CONTROL_EVT_VOLUMEDOWN\n    }\ndeclare namespace devices {\n}\n\n// Auto-generated. Do not edit. Really.\n",
      "pxt.json": "{\n    \"name\": \"devices\",\n    \"description\": \"Camera, remote control and other Bluetooth services\",\n    \"files\": [\n        \"README.md\",\n        \"enums.d.ts\",\n        \"shims.d.ts\",\n        \"devices.cpp\",\n        \"devices.ts\",\n        \"_locales/fr/devices-jsdoc-strings.json\",\n        \"_locales/no/devices-strings.json\",\n        \"_locales/ja/devices-strings.json\",\n        \"_locales/ja/devices-jsdoc-strings.json\",\n        \"_locales/nl/devices-strings.json\",\n        \"_locales/nl/devices-jsdoc-strings.json\"\n    ],\n    \"public\": true,\n    \"dependencies\": {\n        \"core\": \"*\",\n        \"bluetooth\": \"*\"\n    }\n}",
      "shims.d.ts": "// Auto-generated. Do not edit.\n\n\n    /**\n     * Control a phone with the BBC micro:bit via Bluetooth.\n     */\n    //% color=#008272 weight=80 icon=\"\\uf10b\"\ndeclare namespace devices {\n\n    /**\n     * Returns the last signal strength reported by the paired device.\n     */\n    //% help=devices/signal-strength weight=24\n    //% blockId=devices_signal_strength block=\"signal strength\" blockGap=14 icon=\"\\uf012\" blockGap=14 shim=devices::signalStrength\n    function signalStrength(): number;\n\n    /**\n     * Registers code to run when the device notifies about a change of signal strength.\n     * @param body Code run when the signal strength changes.\n     */\n    //% weight=23 help=devices/on-signal-strength-changed\n    //% blockId=devices_signal_strength_changed_event block=\"on signal strength changed\" icon=\"\\uf012\" shim=devices::onSignalStrengthChanged\n    function onSignalStrengthChanged(body: () => void): void;\n}\n\n// Auto-generated. Do not edit. Really.\n"
    },
    "bluetooth": {
      "README.md": "# Bluetooth services\n",
      "_locales/de/bluetooth-jsdoc-strings.json": "{\n  \"bluetooth.onBluetoothConnected|param|body\": \"Code, der ausgeführt wird, wenn eine Bluetooth-Verbindung aufgebaut wurde\",\n  \"bluetooth.uartWriteNumber\": \"Gibt einen numerischen Wert an die serielle\",\n  \"bluetooth.uartWriteValue\": \"Schreibt ein ``Namen: Wert`` Wertepaar auf die serielle Schnittstelle.\",\n  \"bluetooth.uartWriteValue|param|name\": \"Name des Wertestreams, z.B.: x\",\n  \"bluetooth.uartWriteValue|param|value\": \"Schreiben\"\n}",
      "_locales/fr/bluetooth-jsdoc-strings.json": "{\n  \"bluetooth.advertiseUidBuffer|param|power\": \"niveau de puissance enter 0 et 7, eg: 7\",\n  \"bluetooth.advertiseUid|param|power\": \"niveau de puissance enter 0 et 7, eg: 7\",\n  \"bluetooth.advertiseUrl|param|power\": \"niveau de puissance enter 0 et 7, eg: 7\"\n}",
      "_locales/fr/bluetooth-strings.json": "{\n  \"bluetooth.setTransmitPower|block\": \"bluetooth puissance de transmission %power\",\n  \"bluetooth.startUartService|block\": \"bluetooth service uart\",\n  \"{id:category}Bluetooth\": \"Bluetooth\"\n}",
      "_locales/nl/bluetooth-jsdoc-strings.json": "{\n  \"bluetooth\": \"Ondersteuning voor extra Bluetooth-services.\\n\\nOndersteuning voor extra Bluetooth-services.\",\n  \"bluetooth.advertiseUid\": \"Verkondig een Eddystone UID\",\n  \"bluetooth.advertiseUidBuffer\": \"Verkondig een Eddystone UID\",\n  \"bluetooth.advertiseUidBuffer|param|connectable\": \"waar om bluetooth verbindbaar te houden voor andere diensten, anders onwaar.\",\n  \"bluetooth.advertiseUidBuffer|param|nsAndInstance\": \"16 bytes buffer van namespace (bytes 0-9) en instantie (bytes 10-15)\",\n  \"bluetooth.advertiseUidBuffer|param|power\": \"power niveau tussen 0 en 7, bijv: 7\",\n  \"bluetooth.advertiseUid|param|connectable\": \"waar om bluetooth verbindbaar te houden voor andere diensten, anders onwaar.\",\n  \"bluetooth.advertiseUid|param|instance\": \"4 laatste bytes van de instantie uid\",\n  \"bluetooth.advertiseUid|param|ns\": \"4 laatste bytes van de namespace uid\",\n  \"bluetooth.advertiseUid|param|power\": \"power niveau tussen 0 en 7, bijv: 7\",\n  \"bluetooth.advertiseUrl\": \"Verkondig een Eddystone URL\",\n  \"bluetooth.advertiseUrl|param|connectable\": \"waar om bluetooth verbindbaar te houden voor andere diensten, anders onwaar.\",\n  \"bluetooth.advertiseUrl|param|power\": \"power niveau tussen 0 en 7, bijv: 7\",\n  \"bluetooth.advertiseUrl|param|url\": \"de url om te verkondigen. Mag niet langer zijn de de ondersteunde Eddystone URL lengte, bijv: \\\"https://pxt.io/\\\"\",\n  \"bluetooth.setTransmitPower\": \"Stel de bluetooth zend power in tussen 0 (minimum) en 7 (maximum).\",\n  \"bluetooth.setTransmitPower|param|power\": \"power niveau tussen 0 (minimum) en 7 (maximum), bijv: 7.\",\n  \"bluetooth.startAccelerometerService\": \"Hiermee start u de service van de versnellingsmeter Bluetooth\",\n  \"bluetooth.startButtonService\": \"Start de Bluetooth knop service\",\n  \"bluetooth.startIOPinService\": \"Start de Bluetooth IO-pin-service.\",\n  \"bluetooth.startLEDService\": \"Start de Bluetooth LED-service\",\n  \"bluetooth.startMagnetometerService\": \"Start de Bluetooth magnetometer service\",\n  \"bluetooth.startTemperatureService\": \"Start de Bluetooth temperatuur service\",\n  \"bluetooth.startUartService\": \"Start de Bluetooth UART-service\",\n  \"bluetooth.stopAdvertising\": \"Stopt met het verkondigen van Eddystone eindpunten\",\n  \"bluetooth.uartWriteNumber\": \"Schrijft een numerieke waarde naar serieel\",\n  \"bluetooth.uartWriteString\": \"Schrijft naar de Bluetooth UART dienst buffer. Vanaf daar wordt de gegevens verzonden via Bluetooth naar een aangesloten apparaat.\",\n  \"bluetooth.uartWriteValue\": \"Verzend ''naam: waarde'' naar serieel.\",\n  \"bluetooth.uartWriteValue|param|name\": \"naam van de waarde stream, bv: x\",\n  \"bluetooth.uartWriteValue|param|value\": \"te schrijven\"\n}",
      "_locales/nl/bluetooth-strings.json": "{\n  \"bluetooth.advertiseUid|block\": \"bluetooth verkondig UID | namespace (bytes 6-9)%ns|instantie (bytes 2-6)%instance|met power %power|aankoppelbaar %connectable\",\n  \"bluetooth.advertiseUrl|block\": \"bluetooth verkondig url %url|met power %power|aankoppelbaar %connectable\",\n  \"bluetooth.onBluetoothConnected|block\": \"wanneer bluetooth verbonden wordt\",\n  \"bluetooth.onBluetoothDisconnected|block\": \"wanneer bluetooth verbinding verbroken wordt\",\n  \"bluetooth.setTransmitPower|block\": \"bluetooth zet zendvermogen %power\",\n  \"bluetooth.startAccelerometerService|block\": \"Bluetooth versnellingsmeter service\",\n  \"bluetooth.startButtonService|block\": \"Bluetooth knop dienst\",\n  \"bluetooth.startIOPinService|block\": \"Bluetooth io-pin service\",\n  \"bluetooth.startMagnetometerService|block\": \"Bluetooth magnetometer service\",\n  \"bluetooth.startTemperatureService|block\": \"Bluetooth temperatuur-service\",\n  \"bluetooth.startUartService|block\": \"bluetooth uart-service\",\n  \"bluetooth.stopAdvertising|block\": \"bluetooth stop verkondigen\",\n  \"bluetooth.uartReadUntil|block\": \"bluetooth uart|lees tot %del=serial_delimiter_conv\",\n  \"bluetooth.uartWriteNumber|block\": \"bluetooth uart|schrijf nummer %value\",\n  \"bluetooth.uartWriteString|block\": \"bluetooth uart|schrijf tekenreeks %data\",\n  \"bluetooth.uartWriteValue|block\": \"bluetooth uart|schrijf waarde %name|= %value\",\n  \"bluetooth|block\": \"Bluetooth\",\n  \"{id:category}Bluetooth\": \"Bluetooth\"\n}",
      "_locales/no/bluetooth-strings.json": "{\n  \"bluetooth.advertiseUid|block\": \"bluetooth kringkast UID|namespace (bytes 6-9)%ns|instance (bytes 2-6)%instance|med sendereffekt %power|kan tilkobles %connectable\",\n  \"bluetooth.advertiseUrl|block\": \"bluetooth kringkast url %url|med sendereffekt %power|kan tilkobles %connectable\",\n  \"bluetooth.onBluetoothConnected|block\": \"når bluetooth tilkobles\",\n  \"bluetooth.onBluetoothDisconnected|block\": \"når bluetooth frakobles\",\n  \"bluetooth.setTransmitPower|block\": \"bluetooth sett sendereffekt %power\",\n  \"bluetooth.startAccelerometerService|block\": \"bluetooth akselerometer-tjeneste\",\n  \"bluetooth.startButtonService|block\": \"bluetooth trykknapp-tjeneste\",\n  \"bluetooth.startIOPinService|block\": \"bluetooth digital tilkobling-tjeneste\",\n  \"bluetooth.startLEDService|block\": \"bluetooth LED-tjeneste\",\n  \"bluetooth.startMagnetometerService|block\": \"bluetooth magnetometer-tjeneste\",\n  \"bluetooth.startTemperatureService|block\": \"bluetooth temperatur-tjeneste\",\n  \"bluetooth.startUartService|block\": \"bluetooth serieport-tjeneste (UART)\",\n  \"bluetooth.stopAdvertising|block\": \"bluetooth stopp kringkasting\",\n  \"bluetooth.uartReadUntil|block\": \"bluetooth serieport|les frem til %del=serial_delimiter_conv\",\n  \"bluetooth.uartWriteNumber|block\": \"bluetooth serieport|skriv tall %value\",\n  \"bluetooth.uartWriteString|block\": \"bluetooth serieport|skriv tekst %data\",\n  \"bluetooth.uartWriteValue|block\": \"bluetooth serieport|skriv verdi %name|= %value\",\n  \"bluetooth|block\": \"bluetooth\",\n  \"{id:category}Bluetooth\": \"Bluetooth\"\n}",
      "bluetooth.cpp": "#include \"pxt.h\"\n#include \"MESEvents.h\"\n#include \"MicroBitUARTService.h\"\n\nusing namespace pxt;\n\n/**\n * Support for additional Bluetooth services.\n */\n//% color=#0082FB weight=96 icon=\"\\uf294\"\nnamespace bluetooth {\n    MicroBitUARTService *uart = NULL;\n\n    /**\n    *  Starts the Bluetooth accelerometer service\n    */\n    //% help=bluetooth/start-accelerometer-service\n    //% blockId=bluetooth_start_accelerometer_service block=\"bluetooth accelerometer service\"\n    //% parts=\"bluetooth\" weight=90 blockGap=8\n    void startAccelerometerService() {\n        new MicroBitAccelerometerService(*uBit.ble, uBit.accelerometer);        \n    }   \n\n    /**\n    *  Starts the Bluetooth button service\n    */\n    //% help=bluetooth/start-button-service\n    //% blockId=bluetooth_start_button_service block=\"bluetooth button service\" blockGap=8\n    //% parts=\"bluetooth\" weight=89\n    void startButtonService() {\n        new MicroBitButtonService(*uBit.ble);      \n    }\n\n    /**\n    *  Starts the Bluetooth IO pin service.\n    */\n    //% help=bluetooth/start-io-pin-service\n    //% blockId=bluetooth_start_io_pin_service block=\"bluetooth io pin service\" blockGap=8\n    //% parts=\"bluetooth\" weight=88\n    void startIOPinService() {\n        new MicroBitIOPinService(*uBit.ble, uBit.io);\n    }\n\n    /**\n    *  Starts the Bluetooth LED service\n    */\n    //% help=bluetooth/start-led-service\n    //% blockId=bluetooth_start_led_service block=\"bluetooth led service\" blockGap=8\n    //% parts=\"bluetooth\" weight=87\n    void startLEDService() {\n        new MicroBitLEDService(*uBit.ble, uBit.display);\n    }\n\n    /**\n    *  Starts the Bluetooth temperature service\n    */\n    //% help=bluetooth/start-temperature-service\n    //% blockId=bluetooth_start_temperature_service block=\"bluetooth temperature service\" blockGap=8\n    //% parts=\"bluetooth\" weight=86\n    void startTemperatureService() {    \n        new MicroBitTemperatureService(*uBit.ble, uBit.thermometer);        \n    }\n\n    /**\n    *  Starts the Bluetooth magnetometer service\n    */\n    //% help=bluetooth/start-magnetometer-service\n    //% blockId=bluetooth_start_magnetometer_service block=\"bluetooth magnetometer service\"\n    //% parts=\"bluetooth\" weight=85\n    void startMagnetometerService() {    \n        new MicroBitMagnetometerService(*uBit.ble, uBit.compass); \n    }\n\n\n    /**\n    *  Starts the Bluetooth UART service\n    */\n    //% help=bluetooth/start-uart-service\n    //% blockId=bluetooth_start_uart_service block=\"bluetooth uart service\"\n    //% parts=\"bluetooth\" advanced=true\n    void startUartService() {\n        if (uart) return;\n        // 61 octet buffer size is 3 x (MTU - 3) + 1\n        // MTU on nRF51822 is 23 octets. 3 are used by Attribute Protocol header data leaving 20 octets for payload\n        // So we allow a RX buffer that can contain 3 x max length messages plus one octet for a terminator character\n        uart = new MicroBitUARTService(*uBit.ble, 61, 60);\n    }\n    \n    //%\n    void uartWriteString(StringData *data) {\n        startUartService();\n    \tuart->send(ManagedString(data));\n    }    \n\n    //%\n    StringData* uartReadUntil(StringData *del) {\n        startUartService();\n        return uart->readUntil(ManagedString(del)).leakData();\n    }    \n\n    /**\n    * Registers an event to be fired when one of the delimiter is matched.\n    * @param delimiters the characters to match received characters against.\n    */\n    //% help=bluetooth/on-uart-data-received\n    //% weight=18 blockId=bluetooth_on_data_received block=\"bluetooth|on data received %delimiters=serial_delimiter_conv\"\n    void onUartDataReceived(StringData* delimiters, Action body) {\n      startUartService();\n      uart->eventOn(ManagedString(delimiters));\n      registerWithDal(MICROBIT_ID_BLE_UART, MICROBIT_UART_S_EVT_DELIM_MATCH, body);\n    }\n\n    /**\n     * Register code to run when the micro:bit is connected to over Bluetooth\n     * @param body Code to run when a Bluetooth connection is established\n     */\n    //% help=bluetooth/on-bluetooth-connected weight=20\n    //% blockId=bluetooth_on_connected block=\"on bluetooth connected\" blockGap=8\n    //% parts=\"bluetooth\"\n    void onBluetoothConnected(Action body) {\n        registerWithDal(MICROBIT_ID_BLE, MICROBIT_BLE_EVT_CONNECTED, body);\n    }    \n\n     /**\n     * Register code to run when a bluetooth connection to the micro:bit is lost\n     * @param body Code to run when a Bluetooth connection is lost\n     */\n    //% help=bluetooth/on-bluetooth-disconnected weight=19\n    //% blockId=bluetooth_on_disconnected block=\"on bluetooth disconnected\"\n    //% parts=\"bluetooth\"\n    void onBluetoothDisconnected(Action body) {\n        registerWithDal(MICROBIT_ID_BLE, MICROBIT_BLE_EVT_DISCONNECTED, body);\n    } \n\n    const int8_t CALIBRATED_POWERS[] = {-49, -37, -33, -28, -25, -20, -15, -10};\n    /**\n    * Advertise an Eddystone URL\n\t* @param url the url to transmit. Must be no longer than the supported eddystone url length, eg: \"https://makecode.com\"\n\t* @param power power level between 0 and 7, eg: 7\n    * @param connectable true to keep bluetooth connectable for other services, false otherwise.\n    */\n    //% blockId=eddystone_advertise_url block=\"bluetooth advertise url %url|with power %power|connectable %connectable\"\n    //% parts=bluetooth weight=11 blockGap=8\n    //% help=bluetooth/advertise-url blockExternalInputs=1\n    void advertiseUrl(StringData* url, int power, bool connectable) {\n        power = min(MICROBIT_BLE_POWER_LEVELS-1, max(0, power));\n        int8_t level = CALIBRATED_POWERS[power];\n        uBit.bleManager.advertiseEddystoneUrl(ManagedString(url), level, connectable);\n        uBit.bleManager.setTransmitPower(power);\n    }\n\n    /**\n    * Advertise an Eddystone UID\n\t* @param nsAndInstance 16 bytes buffer of namespace (bytes 0-9) and instance (bytes 10-15)\n\t* @param power power level between 0 and 7, eg: 7\n    * @param connectable true to keep bluetooth connectable for other services, false otherwise.\n    */\n    //% parts=bluetooth weight=12 advanced=true\n    void advertiseUidBuffer(Buffer nsAndInstance, int power, bool connectable) {\n        ManagedBuffer buf(nsAndInstance);\n        if (buf.length() != 16) return;\n\n        power = min(MICROBIT_BLE_POWER_LEVELS-1, max(0, power));\n        int8_t level = CALIBRATED_POWERS[power];\n        uint8_t uidNs[10]; buf.readBytes(uidNs, 0, 10);\n        uint8_t uidInst[6]; buf.readBytes(uidInst, 10, 6);\n        uBit.bleManager.advertiseEddystoneUid((const char*)uidNs, (const char*)uidInst, level, connectable);\n    }\n\n    /**\n    * Sets the bluetooth transmit power between 0 (minimal) and 7 (maximum).\n    * @param power power level between 0 (minimal) and 7 (maximum), eg: 7.\n    */\n    //% parts=bluetooth weight=5 help=bluetooth/set-transmit-power advanced=true\n    //% blockId=bluetooth_settransmitpower block=\"bluetooth set transmit power %power\"\n    void setTransmitPower(int power) {\n        uBit.bleManager.setTransmitPower(min(MICROBIT_BLE_POWER_LEVELS-1, max(0, power)));\n    }\n\n    /**\n    * Stops advertising Eddystone end points\n    */\n    //% blockId=eddystone_stop_advertising block=\"bluetooth stop advertising\"\n    //% parts=bluetooth weight=10\n    //% help=bluetooth/stop-advertising advanced=true\n    void stopAdvertising() {\n        uBit.bleManager.stopAdvertising();\n    } \n}",
      "bluetooth.ts": "/**\n * Support for additional Bluetooth services.\n */\n//% color=#0082FB weight=96 icon=\"\\uf294\"\nnamespace bluetooth {\n    /**\n    *  Writes to the Bluetooth UART service buffer. From there the data is transmitted over Bluetooth to a connected device.\n    */\n    //% help=bluetooth/uart-write-string weight=80\n    //% blockId=bluetooth_uart_write block=\"bluetooth uart|write string %data\" blockGap=8\n    //% parts=\"bluetooth\" shim=bluetooth::uartWriteString advanced=true\n    export function uartWriteString(data: string): void {\n        // dummy implementation for simulator\n        console.log(\"UART Write: \" + data)\n    }\n\n    /**\n     * Prints a numeric value to the serial\n     */\n    //% help=bluetooth/uart-write-number weight=79\n    //% weight=89 blockGap=8 advanced=true\n    //% blockId=bluetooth_uart_writenumber block=\"bluetooth uart|write number %value\"\n    export function uartWriteNumber(value: number): void {\n        uartWriteString(value.toString());\n    }\n\n    /**\n     * Writes a ``name: value`` pair line to the serial.\n     * @param name name of the value stream, eg: x\n     * @param value to write\n     */\n    //% weight=88 weight=78\n    //% help=bluetooth/uart-write-value advanced=true\n    //% blockId=bluetooth_uart_writevalue block=\"bluetooth uart|write value %name|= %value\"\n    export function uartWriteValue(name: string, value: number): void {\n        uartWriteString(name + \":\" + value + \"\\r\\n\");\n    }\n\n    /**\n     *  Reads from the Bluetooth UART service buffer, returning its contents when the specified delimiter character is encountered.\n     */\n    //% help=bluetooth/uart-read-until weight=75\n    //% blockId=bluetooth_uart_read block=\"bluetooth uart|read until %del=serial_delimiter_conv\"\n    //% parts=\"bluetooth\" shim=bluetooth::uartReadUntil advanced=true\n    export function uartReadUntil(del: string): string {\n        // dummy implementation for simulator\n        return \"???\"\n    }\n\n    /**\n    * Advertise an Eddystone UID\n    * @param ns 4 last bytes of the namespace uid\n    * @param instance 4 last bytes of the instance uid\n    * @param power power level between 0 and 7, eg: 7\n    * @param connectable true to keep bluetooth connectable for other services, false otherwise.\n    */\n    //% blockId=eddystone_advertise_uid block=\"bluetooth advertise UID|namespace (bytes 6-9)%ns|instance (bytes 2-6)%instance|with power %power|connectable %connectable\"\n    //% parts=bluetooth weight=12 blockGap=8\n    //% help=bluetooth/advertise-uid blockExternalInputs=1\n    export function advertiseUid(ns: number, instance: number, power: number, connectable: boolean) {\n        const buf = pins.createBuffer(16);\n        buf.setNumber(NumberFormat.Int32BE, 6, ns);\n        buf.setNumber(NumberFormat.Int32BE, 12, instance);\n        bluetooth.advertiseUidBuffer(buf, power, connectable);\n    }\n}\n",
      "enums.d.ts": "// Auto-generated. Do not edit.\ndeclare namespace bluetooth {\n}\n\n// Auto-generated. Do not edit. Really.\n",
      "pxt.json": "{\n    \"name\": \"bluetooth\",\n    \"description\": \"Bluetooth services\",\n    \"files\": [\n        \"README.md\",\n        \"enums.d.ts\",\n        \"shims.d.ts\",\n        \"bluetooth.ts\",\n        \"bluetooth.cpp\",\n        \"_locales/de/bluetooth-jsdoc-strings.json\",\n        \"_locales/no/bluetooth-strings.json\",\n        \"_locales/nl/bluetooth-strings.json\",\n        \"_locales/fr/bluetooth-strings.json\",\n        \"_locales/nl/bluetooth-jsdoc-strings.json\",\n        \"_locales/fr/bluetooth-jsdoc-strings.json\"\n    ],\n    \"public\": true,\n    \"dependencies\": {\n        \"core\": \"*\"\n    },\n    \"yotta\": {\n        \"config\": {\n            \"microbit-dal\": {\n                \"bluetooth\": {\n                    \"enabled\": 1\n                }\n            }\n        },\n        \"optionalConfig\": {\n            \"microbit-dal\": {\n                \"gatt_table_size\": \"0x700\"\n            }\n        },\n        \"userConfigs\": [\n            {\n                \"description\": \"No Pairing Required: Anyone can connect via Bluetooth.\",\n                \"config\": {\n                    \"microbit-dal\": {\n                        \"bluetooth\": {\n                            \"open\": 1,\n                            \"pairing_mode\": 0,\n                            \"whitelist\": 0,\n                            \"security_level\": null\n                        }\n                    }\n                }\n            },\n            {\n                \"description\": \"JustWorks pairing (default): Pairing is automatic once the pairing is initiated.\",\n                \"config\": {\n                    \"microbit-dal\": {\n                        \"bluetooth\": {\n                            \"open\": null,\n                            \"pairing_mode\": null,\n                            \"whitelist\": null,\n                            \"security_level\": null\n                        }\n                    }\n                }\n            },\n            {\n                \"description\": \"Passkey pairing: Pairing requires 6 digit key to pair.\",\n                \"config\": {\n                    \"microbit-dal\": {\n                        \"bluetooth\": {\n                            \"open\": 0,\n                            \"pairing_mode\": 1,\n                            \"whitelist\": 1,\n                            \"security_level\": \"SECURITY_MODE_ENCRYPTION_WITH_MITM\"\n                        }\n                    }\n                }\n            }\n        ]\n    }\n}",
      "shims.d.ts": "// Auto-generated. Do not edit.\n\n\n    /**\n     * Support for additional Bluetooth services.\n     */\n    //% color=#0082FB weight=96 icon=\"\\uf294\"\ndeclare namespace bluetooth {\n\n    /**\n     *  Starts the Bluetooth accelerometer service\n     */\n    //% help=bluetooth/start-accelerometer-service\n    //% blockId=bluetooth_start_accelerometer_service block=\"bluetooth accelerometer service\"\n    //% parts=\"bluetooth\" weight=90 blockGap=8 shim=bluetooth::startAccelerometerService\n    function startAccelerometerService(): void;\n\n    /**\n     *  Starts the Bluetooth button service\n     */\n    //% help=bluetooth/start-button-service\n    //% blockId=bluetooth_start_button_service block=\"bluetooth button service\" blockGap=8\n    //% parts=\"bluetooth\" weight=89 shim=bluetooth::startButtonService\n    function startButtonService(): void;\n\n    /**\n     *  Starts the Bluetooth IO pin service.\n     */\n    //% help=bluetooth/start-io-pin-service\n    //% blockId=bluetooth_start_io_pin_service block=\"bluetooth io pin service\" blockGap=8\n    //% parts=\"bluetooth\" weight=88 shim=bluetooth::startIOPinService\n    function startIOPinService(): void;\n\n    /**\n     *  Starts the Bluetooth LED service\n     */\n    //% help=bluetooth/start-led-service\n    //% blockId=bluetooth_start_led_service block=\"bluetooth led service\" blockGap=8\n    //% parts=\"bluetooth\" weight=87 shim=bluetooth::startLEDService\n    function startLEDService(): void;\n\n    /**\n     *  Starts the Bluetooth temperature service\n     */\n    //% help=bluetooth/start-temperature-service\n    //% blockId=bluetooth_start_temperature_service block=\"bluetooth temperature service\" blockGap=8\n    //% parts=\"bluetooth\" weight=86 shim=bluetooth::startTemperatureService\n    function startTemperatureService(): void;\n\n    /**\n     *  Starts the Bluetooth magnetometer service\n     */\n    //% help=bluetooth/start-magnetometer-service\n    //% blockId=bluetooth_start_magnetometer_service block=\"bluetooth magnetometer service\"\n    //% parts=\"bluetooth\" weight=85 shim=bluetooth::startMagnetometerService\n    function startMagnetometerService(): void;\n\n    /**\n     *  Starts the Bluetooth UART service\n     */\n    //% help=bluetooth/start-uart-service\n    //% blockId=bluetooth_start_uart_service block=\"bluetooth uart service\"\n    //% parts=\"bluetooth\" advanced=true shim=bluetooth::startUartService\n    function startUartService(): void;\n\n    /**\n     * Registers an event to be fired when one of the delimiter is matched.\n     * @param delimiters the characters to match received characters against.\n     */\n    //% help=bluetooth/on-uart-data-received\n    //% weight=18 blockId=bluetooth_on_data_received block=\"bluetooth|on data received %delimiters=serial_delimiter_conv\" shim=bluetooth::onUartDataReceived\n    function onUartDataReceived(delimiters: string, body: () => void): void;\n\n    /**\n     * Register code to run when the micro:bit is connected to over Bluetooth\n     * @param body Code to run when a Bluetooth connection is established\n     */\n    //% help=bluetooth/on-bluetooth-connected weight=20\n    //% blockId=bluetooth_on_connected block=\"on bluetooth connected\" blockGap=8\n    //% parts=\"bluetooth\" shim=bluetooth::onBluetoothConnected\n    function onBluetoothConnected(body: () => void): void;\n\n    /**\n     * Register code to run when a bluetooth connection to the micro:bit is lost\n     * @param body Code to run when a Bluetooth connection is lost\n     */\n    //% help=bluetooth/on-bluetooth-disconnected weight=19\n    //% blockId=bluetooth_on_disconnected block=\"on bluetooth disconnected\"\n    //% parts=\"bluetooth\" shim=bluetooth::onBluetoothDisconnected\n    function onBluetoothDisconnected(body: () => void): void;\n\n    /**\n     * Advertise an Eddystone URL\n     * @param url the url to transmit. Must be no longer than the supported eddystone url length, eg: \"https://makecode.com\"\n     * @param power power level between 0 and 7, eg: 7\n     * @param connectable true to keep bluetooth connectable for other services, false otherwise.\n     */\n    //% blockId=eddystone_advertise_url block=\"bluetooth advertise url %url|with power %power|connectable %connectable\"\n    //% parts=bluetooth weight=11 blockGap=8\n    //% help=bluetooth/advertise-url blockExternalInputs=1 shim=bluetooth::advertiseUrl\n    function advertiseUrl(url: string, power: number, connectable: boolean): void;\n\n    /**\n     * Advertise an Eddystone UID\n     * @param nsAndInstance 16 bytes buffer of namespace (bytes 0-9) and instance (bytes 10-15)\n     * @param power power level between 0 and 7, eg: 7\n     * @param connectable true to keep bluetooth connectable for other services, false otherwise.\n     */\n    //% parts=bluetooth weight=12 advanced=true shim=bluetooth::advertiseUidBuffer\n    function advertiseUidBuffer(nsAndInstance: Buffer, power: number, connectable: boolean): void;\n\n    /**\n     * Sets the bluetooth transmit power between 0 (minimal) and 7 (maximum).\n     * @param power power level between 0 (minimal) and 7 (maximum), eg: 7.\n     */\n    //% parts=bluetooth weight=5 help=bluetooth/set-transmit-power advanced=true\n    //% blockId=bluetooth_settransmitpower block=\"bluetooth set transmit power %power\" shim=bluetooth::setTransmitPower\n    function setTransmitPower(power: number): void;\n\n    /**\n     * Stops advertising Eddystone end points\n     */\n    //% blockId=eddystone_stop_advertising block=\"bluetooth stop advertising\"\n    //% parts=bluetooth weight=10\n    //% help=bluetooth/stop-advertising advanced=true shim=bluetooth::stopAdvertising\n    function stopAdvertising(): void;\n}\n\n// Auto-generated. Do not edit. Really.\n"
    },
    "blocksprj": {
      "README.md": "",
      "main.blocks": "<xml xmlns=\"http://www.w3.org/1999/xhtml\">\n  <block type=\"pxt-on-start\"></block>\n  <block type=\"device_forever\"></block>\n</xml>",
      "main.ts": "\n",
      "pxt.json": "{\n    \"name\": \"{0} block\",\n    \"dependencies\": {\n        \"core\": \"*\",\n        \"radio\": \"*\"\n    },\n    \"description\": \"\",\n    \"files\": [\n        \"main.blocks\",\n        \"main.ts\",\n        \"README.md\"\n    ]\n}"
    },
    "bluetoothprj": {
      "README.md": "",
      "main.blocks": "<xml xmlns=\"http://www.w3.org/1999/xhtml\">\n  <block type=\"pxt-on-start\"></block>\n</xml>",
      "main.ts": "\n",
      "pxt.json": "{\n    \"name\": \"{0} block\",\n    \"dependencies\": {\n        \"core\": \"*\",\n        \"bluetooth\": \"*\"\n    },\n    \"description\": \"\",\n    \"files\": [\n        \"main.blocks\",\n        \"main.ts\",\n        \"README.md\"\n    ]\n}"
    },
    "tsprj": {
      "README.md": "",
      "main.ts": "basic.showLeds(`\n    . . . . .\n    . # . # .\n    . . . . .\n    # . . . #\n    . # # # .\n    `);",
      "pxt.json": "{\n    \"name\": \"{0} bit\",\n    \"dependencies\": {\n        \"core\": \"*\",\n        \"radio\": \"*\"\n    },\n    \"description\": \"\",\n    \"files\": [\n        \"main.ts\",\n        \"README.md\"\n    ]\n}"
    }
  },
  "versions": {
    "branch": "v0.13.22",
    "tag": "v0.13.22",
    "commits": "https://github.com/Microsoft/pxt-microbit/commits/77199f448b52dd5d248168b07d1da759d642ff80",
    "target": "0.13.22",
    "pxt": "0.13.30",
    "pxtCrowdinBranch": "v0"
  }
}