/// <reference path="../node_modules/pxt-core/built/pxteditor.d.ts" />
var pxt;
(function (pxt) {
    var editor;
    (function (editor) {
        editor.initExtensionsAsync = function (opts) {
            pxt.debug('loading microbit target extensions...');
            var res = {
                hexFileImporters: [{
                        id: "blockly",
                        canImport: function (data) { return data.meta.cloudId == "microbit.co.uk" && data.meta.editor == "blockly"; },
                        importAsync: function (project, data) { return project.createProjectAsync({
                            filesOverride: {
                                "main.blocks": data.source
                            }, name: data.meta.name
                        }); }
                    }, {
                        id: "td",
                        canImport: function (data) { return data.meta.cloudId == "microbit.co.uk" && data.meta.editor == "touchdevelop"; },
                        importAsync: function (project, data) {
                            return project.createProjectAsync({
                                filesOverride: { "main.blocks": "", "main.ts": "  " },
                                name: data.meta.name
                            })
                                .then(function () { return project.convertTouchDevelopToTypeScriptAsync(data.source); })
                                .then(function (text) { return project.overrideTypescriptFile(text); });
                        }
                    }]
            };
            return Promise.resolve(res);
        };
    })(editor = pxt.editor || (pxt.editor = {}));
})(pxt || (pxt = {}));
