# Variables

A variable is a place where you can store and retrieve data. Variables have a name, a [type](/types), and value:

* *name* is how you'll refer to the variable
* *type* refers to the kind of data a variable can store
* *value* refers to what's stored in the variable

### ~ hint

You can use the default variable names if you'd like, however, it's best to use descriptive variable names. To change a variable name in the editor, select the down arrow next to the variable and then click "new variable".

### ~

### ``let`` statement

Use the Block Editor variable statement to create a variable 
and the [assignment operator](/blocks/variables/assign) 
to store something in the variable.

For example, this code stores the number `2` in the `x` variable:

```block
let x = 2;
```
Here's how to define a variable in the Block Editor:

1. Click `variables`.

2. Change the default variable name if you like.

3. Drag a block type on the right-side of the [assignment operator](/blocks/variables/assign) and click the down arrow to change the variable name.

### #letexample

### Reading variable values

Once you've defined a variable, just use the variable's name whenever you need what's stored in the variable. 

#### #readvariableexample

### Updating variable values

To change the contents of a variable use the assignment operator. 

#### #updatevariableexample

### Why use variables?

If you want to remember and modify data, you'll need a variable. 

#### #whyusevariablesexample

### Local variables

Local variables exist only within the function or block of code where they're defined.

#### #localvariableexample
