/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * pxt-monaco-typescript version: 2.3.4-v0(c15c761c89cce64727646632f34f203119fa81d0)
 * Released under the MIT license
 * https://github.com/Microsoft/pxt-monaco-typescript/blob/master/LICENSE.md
 *-----------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

// This is a generated file from lib.d.ts

define('vs/language/typescript/lib/lib-ts',[], function() { return { contents: "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved. \nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0  \n \nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE, \nMERCHANTABLITY OR NON-INFRINGEMENT. \n \nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/////////////////////////////\n/// ECMAScript APIs\n/////////////////////////////\n\ndeclare const NaN: number;\ndeclare const Infinity: number;\n\n/**\n  * Evaluates JavaScript code and executes it.\n  * @param x A String value that contains valid JavaScript code.\n  */\ndeclare function eval(x: string): any;\n\n/**\n  * Converts A string to an integer.\n  * @param s A string to convert into a number.\n  * @param radix A value between 2 and 36 that specifies the base of the number in numString.\n  * If this argument is not supplied, strings with a prefix of '0x' are considered hexadecimal.\n  * All other strings are considered decimal.\n  */\ndeclare function parseInt(s: string, radix?: number): number;\n\n/**\n  * Converts a string to a floating-point number.\n  * @param string A string that contains a floating-point number.\n  */\ndeclare function parseFloat(string: string): number;\n\n/**\n  * Returns a Boolean value that indicates whether a value is the reserved value NaN (not a number).\n  * @param number A numeric value.\n  */\ndeclare function isNaN(number: number): boolean;\n\n/**\n  * Determines whether a supplied number is finite.\n  * @param number Any numeric value.\n  */\ndeclare function isFinite(number: number): boolean;\n\n/**\n  * Gets the unencoded version of an encoded Uniform Resource Identifier (URI).\n  * @param encodedURI A value representing an encoded URI.\n  */\ndeclare function decodeURI(encodedURI: string): string;\n\n/**\n  * Gets the unencoded version of an encoded component of a Uniform Resource Identifier (URI).\n  * @param encodedURIComponent A value representing an encoded URI component.\n  */\ndeclare function decodeURIComponent(encodedURIComponent: string): string;\n\n/**\n  * Encodes a text string as a valid Uniform Resource Identifier (URI)\n  * @param uri A value representing an encoded URI.\n  */\ndeclare function encodeURI(uri: string): string;\n\n/**\n  * Encodes a text string as a valid component of a Uniform Resource Identifier (URI).\n  * @param uriComponent A value representing an encoded URI component.\n  */\ndeclare function encodeURIComponent(uriComponent: string): string;\n\ninterface PropertyDescriptor {\n    configurable?: boolean;\n    enumerable?: boolean;\n    value?: any;\n    writable?: boolean;\n    get?(): any;\n    set?(v: any): void;\n}\n\ninterface PropertyDescriptorMap {\n    [s: string]: PropertyDescriptor;\n}\n\ninterface Object {\n    /** The initial value of Object.prototype.constructor is the standard built-in Object constructor. */\n    constructor: Function;\n\n    /** Returns a string representation of an object. */\n    toString(): string;\n\n    /** Returns a date converted to a string using the current locale. */\n    toLocaleString(): string;\n\n    /** Returns the primitive value of the specified object. */\n    valueOf(): Object;\n\n    /**\n      * Determines whether an object has a property with the specified name.\n      * @param v A property name.\n      */\n    hasOwnProperty(v: string): boolean;\n\n    /**\n      * Determines whether an object exists in another object's prototype chain.\n      * @param v Another object whose prototype chain is to be checked.\n      */\n    isPrototypeOf(v: Object): boolean;\n\n    /**\n      * Determines whether a specified property is enumerable.\n      * @param v A property name.\n      */\n    propertyIsEnumerable(v: string): boolean;\n}\n\ninterface ObjectConstructor {\n    new(value?: any): Object;\n    (): any;\n    (value: any): any;\n\n    /** A reference to the prototype for a class of objects. */\n    readonly prototype: Object;\n\n    /**\n      * Returns the prototype of an object.\n      * @param o The object that references the prototype.\n      */\n    getPrototypeOf(o: any): any;\n\n    /**\n      * Gets the own property descriptor of the specified object.\n      * An own property descriptor is one that is defined directly on the object and is not inherited from the object's prototype.\n      * @param o Object that contains the property.\n      * @param p Name of the property.\n    */\n    getOwnPropertyDescriptor(o: any, p: string): PropertyDescriptor;\n\n    /**\n      * Returns the names of the own properties of an object. The own properties of an object are those that are defined directly\n      * on that object, and are not inherited from the object's prototype. The properties of an object include both fields (objects) and functions.\n      * @param o Object that contains the own properties.\n      */\n    getOwnPropertyNames(o: any): string[];\n\n    /**\n      * Creates an object that has the specified prototype or that has null prototype.\n      * @param o Object to use as a prototype. May be null.\n      */\n    create(o: object | null): any;\n\n    /**\n      * Creates an object that has the specified prototype, and that optionally contains specified properties.\n      * @param o Object to use as a prototype. May be null\n      * @param properties JavaScript object that contains one or more property descriptors.\n      */\n    create(o: object | null, properties: PropertyDescriptorMap & ThisType<any>): any;\n\n    /**\n      * Adds a property to an object, or modifies attributes of an existing property.\n      * @param o Object on which to add or modify the property. This can be a native JavaScript object (that is, a user-defined object or a built in object) or a DOM object.\n      * @param p The property name.\n      * @param attributes Descriptor for the property. It can be for a data property or an accessor property.\n      */\n    defineProperty(o: any, p: string, attributes: PropertyDescriptor & ThisType<any>): any;\n\n    /**\n      * Adds one or more properties to an object, and/or modifies attributes of existing properties.\n      * @param o Object on which to add or modify the properties. This can be a native JavaScript object or a DOM object.\n      * @param properties JavaScript object that contains one or more descriptor objects. Each descriptor object describes a data property or an accessor property.\n      */\n    defineProperties(o: any, properties: PropertyDescriptorMap & ThisType<any>): any;\n\n    /**\n      * Prevents the modification of attributes of existing properties, and prevents the addition of new properties.\n      * @param o Object on which to lock the attributes.\n      */\n    seal<T>(o: T): T;\n\n    /**\n      * Prevents the modification of existing property attributes and values, and prevents the addition of new properties.\n      * @param o Object on which to lock the attributes.\n      */\n    freeze<T>(a: T[]): ReadonlyArray<T>;\n\n    /**\n      * Prevents the modification of existing property attributes and values, and prevents the addition of new properties.\n      * @param o Object on which to lock the attributes.\n      */\n    freeze<T extends Function>(f: T): T;\n\n    /**\n      * Prevents the modification of existing property attributes and values, and prevents the addition of new properties.\n      * @param o Object on which to lock the attributes.\n      */\n    freeze<T>(o: T): Readonly<T>;\n\n    /**\n      * Prevents the addition of new properties to an object.\n      * @param o Object to make non-extensible.\n      */\n    preventExtensions<T>(o: T): T;\n\n    /**\n      * Returns true if existing property attributes cannot be modified in an object and new properties cannot be added to the object.\n      * @param o Object to test.\n      */\n    isSealed(o: any): boolean;\n\n    /**\n      * Returns true if existing property attributes and values cannot be modified in an object, and new properties cannot be added to the object.\n      * @param o Object to test.\n      */\n    isFrozen(o: any): boolean;\n\n    /**\n      * Returns a value that indicates whether new properties can be added to an object.\n      * @param o Object to test.\n      */\n    isExtensible(o: any): boolean;\n\n    /**\n      * Returns the names of the enumerable properties and methods of an object.\n      * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n      */\n    keys(o: any): string[];\n}\n\n/**\n  * Provides functionality common to all JavaScript objects.\n  */\ndeclare const Object: ObjectConstructor;\n\n/**\n  * Creates a new function.\n  */\ninterface Function {\n    /**\n      * Calls the function, substituting the specified object for the this value of the function, and the specified array for the arguments of the function.\n      * @param thisArg The object to be used as the this object.\n      * @param argArray A set of arguments to be passed to the function.\n      */\n    apply(this: Function, thisArg: any, argArray?: any): any;\n\n    /**\n      * Calls a method of an object, substituting another object for the current object.\n      * @param thisArg The object to be used as the current object.\n      * @param argArray A list of arguments to be passed to the method.\n      */\n    call(this: Function, thisArg: any, ...argArray: any[]): any;\n\n    /**\n      * For a given function, creates a bound function that has the same body as the original function.\n      * The this object of the bound function is associated with the specified object, and has the specified initial parameters.\n      * @param thisArg An object to which the this keyword can refer inside the new function.\n      * @param argArray A list of arguments to be passed to the new function.\n      */\n    bind(this: Function, thisArg: any, ...argArray: any[]): any;\n\n    /** Returns a string representation of a function. */\n    toString(): string;\n\n    prototype: any;\n    readonly length: number;\n\n    // Non-standard extensions\n    arguments: any;\n    caller: Function;\n}\n\ninterface FunctionConstructor {\n    /**\n      * Creates a new function.\n      * @param args A list of arguments the function accepts.\n      */\n    new(...args: string[]): Function;\n    (...args: string[]): Function;\n    readonly prototype: Function;\n}\n\ndeclare const Function: FunctionConstructor;\n\ninterface IArguments {\n    [index: number]: any;\n    length: number;\n    callee: Function;\n}\n\ninterface String {\n    /** Returns a string representation of a string. */\n    toString(): string;\n\n    /**\n      * Returns the character at the specified index.\n      * @param pos The zero-based index of the desired character.\n      */\n    charAt(pos: number): string;\n\n    /**\n      * Returns the Unicode value of the character at the specified location.\n      * @param index The zero-based index of the desired character. If there is no character at the specified index, NaN is returned.\n      */\n    charCodeAt(index: number): number;\n\n    /**\n      * Returns a string that contains the concatenation of two or more strings.\n      * @param strings The strings to append to the end of the string.\n      */\n    concat(...strings: string[]): string;\n\n    /**\n      * Returns the position of the first occurrence of a substring.\n      * @param searchString The substring to search for in the string\n      * @param position The index at which to begin searching the String object. If omitted, search starts at the beginning of the string.\n      */\n    indexOf(searchString: string, position?: number): number;\n\n    /**\n      * Returns the last occurrence of a substring in the string.\n      * @param searchString The substring to search for.\n      * @param position The index at which to begin searching. If omitted, the search begins at the end of the string.\n      */\n    lastIndexOf(searchString: string, position?: number): number;\n\n    /**\n      * Determines whether two strings are equivalent in the current locale.\n      * @param that String to compare to target string\n      */\n    localeCompare(that: string): number;\n\n    /**\n      * Matches a string with a regular expression, and returns an array containing the results of that search.\n      * @param regexp A variable name or string literal containing the regular expression pattern and flags.\n      */\n    match(regexp: string | RegExp): RegExpMatchArray | null;\n\n    /**\n      * Replaces text in a string, using a regular expression or search string.\n      * @param searchValue A string to search for.\n      * @param replaceValue A string containing the text to replace for every successful match of searchValue in this string.\n      */\n    replace(searchValue: string | RegExp, replaceValue: string): string;\n\n    /**\n      * Replaces text in a string, using a regular expression or search string.\n      * @param searchValue A string to search for.\n      * @param replacer A function that returns the replacement text.\n      */\n    replace(searchValue: string | RegExp, replacer: (substring: string, ...args: any[]) => string): string;\n\n    /**\n      * Finds the first substring match in a regular expression search.\n      * @param regexp The regular expression pattern and applicable flags.\n      */\n    search(regexp: string | RegExp): number;\n\n    /**\n      * Returns a section of a string.\n      * @param start The index to the beginning of the specified portion of stringObj.\n      * @param end The index to the end of the specified portion of stringObj. The substring includes the characters up to, but not including, the character indicated by end.\n      * If this value is not specified, the substring continues to the end of stringObj.\n      */\n    slice(start?: number, end?: number): string;\n\n    /**\n      * Split a string into substrings using the specified separator and return them as an array.\n      * @param separator A string that identifies character or characters to use in separating the string. If omitted, a single-element array containing the entire string is returned.\n      * @param limit A value used to limit the number of elements returned in the array.\n      */\n    split(separator: string | RegExp, limit?: number): string[];\n\n    /**\n      * Returns the substring at the specified location within a String object.\n      * @param start The zero-based index number indicating the beginning of the substring.\n      * @param end Zero-based index number indicating the end of the substring. The substring includes the characters up to, but not including, the character indicated by end.\n      * If end is omitted, the characters from start through the end of the original string are returned.\n      */\n    substring(start: number, end?: number): string;\n\n    /** Converts all the alphabetic characters in a string to lowercase. */\n    toLowerCase(): string;\n\n    /** Converts all alphabetic characters to lowercase, taking into account the host environment's current locale. */\n    toLocaleLowerCase(): string;\n\n    /** Converts all the alphabetic characters in a string to uppercase. */\n    toUpperCase(): string;\n\n    /** Returns a string where all alphabetic characters have been converted to uppercase, taking into account the host environment's current locale. */\n    toLocaleUpperCase(): string;\n\n    /** Removes the leading and trailing white space and line terminator characters from a string. */\n    trim(): string;\n\n    /** Returns the length of a String object. */\n    readonly length: number;\n\n    // IE extensions\n    /**\n      * Gets a substring beginning at the specified location and having the specified length.\n      * @param from The starting position of the desired substring. The index of the first character in the string is zero.\n      * @param length The number of characters to include in the returned substring.\n      */\n    substr(from: number, length?: number): string;\n\n    /** Returns the primitive value of the specified object. */\n    valueOf(): string;\n\n    readonly [index: number]: string;\n}\n\ninterface StringConstructor {\n    new(value?: any): String;\n    (value?: any): string;\n    readonly prototype: String;\n    fromCharCode(...codes: number[]): string;\n}\n\n/**\n  * Allows manipulation and formatting of text strings and determination and location of substrings within strings.\n  */\ndeclare const String: StringConstructor;\n\ninterface Boolean {\n    /** Returns the primitive value of the specified object. */\n    valueOf(): boolean;\n}\n\ninterface BooleanConstructor {\n    new(value?: any): Boolean;\n    (value?: any): boolean;\n    readonly prototype: Boolean;\n}\n\ndeclare const Boolean: BooleanConstructor;\n\ninterface Number {\n    /**\n      * Returns a string representation of an object.\n      * @param radix Specifies a radix for converting numeric values to strings. This value is only used for numbers.\n      */\n    toString(radix?: number): string;\n\n    /**\n      * Returns a string representing a number in fixed-point notation.\n      * @param fractionDigits Number of digits after the decimal point. Must be in the range 0 - 20, inclusive.\n      */\n    toFixed(fractionDigits?: number): string;\n\n    /**\n      * Returns a string containing a number represented in exponential notation.\n      * @param fractionDigits Number of digits after the decimal point. Must be in the range 0 - 20, inclusive.\n      */\n    toExponential(fractionDigits?: number): string;\n\n    /**\n      * Returns a string containing a number represented either in exponential or fixed-point notation with a specified number of digits.\n      * @param precision Number of significant digits. Must be in the range 1 - 21, inclusive.\n      */\n    toPrecision(precision?: number): string;\n\n    /** Returns the primitive value of the specified object. */\n    valueOf(): number;\n}\n\ninterface NumberConstructor {\n    new(value?: any): Number;\n    (value?: any): number;\n    readonly prototype: Number;\n\n    /** The largest number that can be represented in JavaScript. Equal to approximately 1.79E+308. */\n    readonly MAX_VALUE: number;\n\n    /** The closest number to zero that can be represented in JavaScript. Equal to approximately 5.00E-324. */\n    readonly MIN_VALUE: number;\n\n    /**\n      * A value that is not a number.\n      * In equality comparisons, NaN does not equal any value, including itself. To test whether a value is equivalent to NaN, use the isNaN function.\n      */\n    readonly NaN: number;\n\n    /**\n      * A value that is less than the largest negative number that can be represented in JavaScript.\n      * JavaScript displays NEGATIVE_INFINITY values as -infinity.\n      */\n    readonly NEGATIVE_INFINITY: number;\n\n    /**\n      * A value greater than the largest number that can be represented in JavaScript.\n      * JavaScript displays POSITIVE_INFINITY values as infinity.\n      */\n    readonly POSITIVE_INFINITY: number;\n}\n\n/** An object that represents a number of any kind. All JavaScript numbers are 64-bit floating-point numbers. */\ndeclare const Number: NumberConstructor;\n\ninterface TemplateStringsArray extends ReadonlyArray<string> {\n    readonly raw: ReadonlyArray<string>;\n}\n\ninterface Math {\n    /** The mathematical constant e. This is Euler's number, the base of natural logarithms. */\n    readonly E: number;\n    /** The natural logarithm of 10. */\n    readonly LN10: number;\n    /** The natural logarithm of 2. */\n    readonly LN2: number;\n    /** The base-2 logarithm of e. */\n    readonly LOG2E: number;\n    /** The base-10 logarithm of e. */\n    readonly LOG10E: number;\n    /** Pi. This is the ratio of the circumference of a circle to its diameter. */\n    readonly PI: number;\n    /** The square root of 0.5, or, equivalently, one divided by the square root of 2. */\n    readonly SQRT1_2: number;\n    /** The square root of 2. */\n    readonly SQRT2: number;\n    /**\n      * Returns the absolute value of a number (the value without regard to whether it is positive or negative).\n      * For example, the absolute value of -5 is the same as the absolute value of 5.\n      * @param x A numeric expression for which the absolute value is needed.\n      */\n    abs(x: number): number;\n    /**\n      * Returns the arc cosine (or inverse cosine) of a number.\n      * @param x A numeric expression.\n      */\n    acos(x: number): number;\n    /**\n      * Returns the arcsine of a number.\n      * @param x A numeric expression.\n      */\n    asin(x: number): number;\n    /**\n      * Returns the arctangent of a number.\n      * @param x A numeric expression for which the arctangent is needed.\n      */\n    atan(x: number): number;\n    /**\n      * Returns the angle (in radians) from the X axis to a point.\n      * @param y A numeric expression representing the cartesian y-coordinate.\n      * @param x A numeric expression representing the cartesian x-coordinate.\n      */\n    atan2(y: number, x: number): number;\n    /**\n      * Returns the smallest number greater than or equal to its numeric argument.\n      * @param x A numeric expression.\n      */\n    ceil(x: number): number;\n    /**\n      * Returns the cosine of a number.\n      * @param x A numeric expression that contains an angle measured in radians.\n      */\n    cos(x: number): number;\n    /**\n      * Returns e (the base of natural logarithms) raised to a power.\n      * @param x A numeric expression representing the power of e.\n      */\n    exp(x: number): number;\n    /**\n      * Returns the greatest number less than or equal to its numeric argument.\n      * @param x A numeric expression.\n      */\n    floor(x: number): number;\n    /**\n      * Returns the natural logarithm (base e) of a number.\n      * @param x A numeric expression.\n      */\n    log(x: number): number;\n    /**\n      * Returns the larger of a set of supplied numeric expressions.\n      * @param values Numeric expressions to be evaluated.\n      */\n    max(...values: number[]): number;\n    /**\n      * Returns the smaller of a set of supplied numeric expressions.\n      * @param values Numeric expressions to be evaluated.\n      */\n    min(...values: number[]): number;\n    /**\n      * Returns the value of a base expression taken to a specified power.\n      * @param x The base value of the expression.\n      * @param y The exponent value of the expression.\n      */\n    pow(x: number, y: number): number;\n    /** Returns a pseudorandom number between 0 and 1. */\n    random(): number;\n    /**\n      * Returns a supplied numeric expression rounded to the nearest number.\n      * @param x The value to be rounded to the nearest number.\n      */\n    round(x: number): number;\n    /**\n      * Returns the sine of a number.\n      * @param x A numeric expression that contains an angle measured in radians.\n      */\n    sin(x: number): number;\n    /**\n      * Returns the square root of a number.\n      * @param x A numeric expression.\n      */\n    sqrt(x: number): number;\n    /**\n      * Returns the tangent of a number.\n      * @param x A numeric expression that contains an angle measured in radians.\n      */\n    tan(x: number): number;\n}\n/** An intrinsic object that provides basic mathematics functionality and constants. */\ndeclare const Math: Math;\n\n/** Enables basic storage and retrieval of dates and times. */\ninterface Date {\n    /** Returns a string representation of a date. The format of the string depends on the locale. */\n    toString(): string;\n    /** Returns a date as a string value. */\n    toDateString(): string;\n    /** Returns a time as a string value. */\n    toTimeString(): string;\n    /** Returns a value as a string value appropriate to the host environment's current locale. */\n    toLocaleString(): string;\n    /** Returns a date as a string value appropriate to the host environment's current locale. */\n    toLocaleDateString(): string;\n    /** Returns a time as a string value appropriate to the host environment's current locale. */\n    toLocaleTimeString(): string;\n    /** Returns the stored time value in milliseconds since midnight, January 1, 1970 UTC. */\n    valueOf(): number;\n    /** Gets the time value in milliseconds. */\n    getTime(): number;\n    /** Gets the year, using local time. */\n    getFullYear(): number;\n    /** Gets the year using Universal Coordinated Time (UTC). */\n    getUTCFullYear(): number;\n    /** Gets the month, using local time. */\n    getMonth(): number;\n    /** Gets the month of a Date object using Universal Coordinated Time (UTC). */\n    getUTCMonth(): number;\n    /** Gets the day-of-the-month, using local time. */\n    getDate(): number;\n    /** Gets the day-of-the-month, using Universal Coordinated Time (UTC). */\n    getUTCDate(): number;\n    /** Gets the day of the week, using local time. */\n    getDay(): number;\n    /** Gets the day of the week using Universal Coordinated Time (UTC). */\n    getUTCDay(): number;\n    /** Gets the hours in a date, using local time. */\n    getHours(): number;\n    /** Gets the hours value in a Date object using Universal Coordinated Time (UTC). */\n    getUTCHours(): number;\n    /** Gets the minutes of a Date object, using local time. */\n    getMinutes(): number;\n    /** Gets the minutes of a Date object using Universal Coordinated Time (UTC). */\n    getUTCMinutes(): number;\n    /** Gets the seconds of a Date object, using local time. */\n    getSeconds(): number;\n    /** Gets the seconds of a Date object using Universal Coordinated Time (UTC). */\n    getUTCSeconds(): number;\n    /** Gets the milliseconds of a Date, using local time. */\n    getMilliseconds(): number;\n    /** Gets the milliseconds of a Date object using Universal Coordinated Time (UTC). */\n    getUTCMilliseconds(): number;\n    /** Gets the difference in minutes between the time on the local computer and Universal Coordinated Time (UTC). */\n    getTimezoneOffset(): number;\n    /**\n      * Sets the date and time value in the Date object.\n      * @param time A numeric value representing the number of elapsed milliseconds since midnight, January 1, 1970 GMT.\n      */\n    setTime(time: number): number;\n    /**\n      * Sets the milliseconds value in the Date object using local time.\n      * @param ms A numeric value equal to the millisecond value.\n      */\n    setMilliseconds(ms: number): number;\n    /**\n      * Sets the milliseconds value in the Date object using Universal Coordinated Time (UTC).\n      * @param ms A numeric value equal to the millisecond value.\n      */\n    setUTCMilliseconds(ms: number): number;\n\n    /**\n      * Sets the seconds value in the Date object using local time.\n      * @param sec A numeric value equal to the seconds value.\n      * @param ms A numeric value equal to the milliseconds value.\n      */\n    setSeconds(sec: number, ms?: number): number;\n    /**\n      * Sets the seconds value in the Date object using Universal Coordinated Time (UTC).\n      * @param sec A numeric value equal to the seconds value.\n      * @param ms A numeric value equal to the milliseconds value.\n      */\n    setUTCSeconds(sec: number, ms?: number): number;\n    /**\n      * Sets the minutes value in the Date object using local time.\n      * @param min A numeric value equal to the minutes value.\n      * @param sec A numeric value equal to the seconds value.\n      * @param ms A numeric value equal to the milliseconds value.\n      */\n    setMinutes(min: number, sec?: number, ms?: number): number;\n    /**\n      * Sets the minutes value in the Date object using Universal Coordinated Time (UTC).\n      * @param min A numeric value equal to the minutes value.\n      * @param sec A numeric value equal to the seconds value.\n      * @param ms A numeric value equal to the milliseconds value.\n      */\n    setUTCMinutes(min: number, sec?: number, ms?: number): number;\n    /**\n      * Sets the hour value in the Date object using local time.\n      * @param hours A numeric value equal to the hours value.\n      * @param min A numeric value equal to the minutes value.\n      * @param sec A numeric value equal to the seconds value.\n      * @param ms A numeric value equal to the milliseconds value.\n      */\n    setHours(hours: number, min?: number, sec?: number, ms?: number): number;\n    /**\n      * Sets the hours value in the Date object using Universal Coordinated Time (UTC).\n      * @param hours A numeric value equal to the hours value.\n      * @param min A numeric value equal to the minutes value.\n      * @param sec A numeric value equal to the seconds value.\n      * @param ms A numeric value equal to the milliseconds value.\n      */\n    setUTCHours(hours: number, min?: number, sec?: number, ms?: number): number;\n    /**\n      * Sets the numeric day-of-the-month value of the Date object using local time.\n      * @param date A numeric value equal to the day of the month.\n      */\n    setDate(date: number): number;\n    /**\n      * Sets the numeric day of the month in the Date object using Universal Coordinated Time (UTC).\n      * @param date A numeric value equal to the day of the month.\n      */\n    setUTCDate(date: number): number;\n    /**\n      * Sets the month value in the Date object using local time.\n      * @param month A numeric value equal to the month. The value for January is 0, and other month values follow consecutively.\n      * @param date A numeric value representing the day of the month. If this value is not supplied, the value from a call to the getDate method is used.\n      */\n    setMonth(month: number, date?: number): number;\n    /**\n      * Sets the month value in the Date object using Universal Coordinated Time (UTC).\n      * @param month A numeric value equal to the month. The value for January is 0, and other month values follow consecutively.\n      * @param date A numeric value representing the day of the month. If it is not supplied, the value from a call to the getUTCDate method is used.\n      */\n    setUTCMonth(month: number, date?: number): number;\n    /**\n      * Sets the year of the Date object using local time.\n      * @param year A numeric value for the year.\n      * @param month A zero-based numeric value for the month (0 for January, 11 for December). Must be specified if numDate is specified.\n      * @param date A numeric value equal for the day of the month.\n      */\n    setFullYear(year: number, month?: number, date?: number): number;\n    /**\n      * Sets the year value in the Date object using Universal Coordinated Time (UTC).\n      * @param year A numeric value equal to the year.\n      * @param month A numeric value equal to the month. The value for January is 0, and other month values follow consecutively. Must be supplied if numDate is supplied.\n      * @param date A numeric value equal to the day of the month.\n      */\n    setUTCFullYear(year: number, month?: number, date?: number): number;\n    /** Returns a date converted to a string using Universal Coordinated Time (UTC). */\n    toUTCString(): string;\n    /** Returns a date as a string value in ISO format. */\n    toISOString(): string;\n    /** Used by the JSON.stringify method to enable the transformation of an object's data for JavaScript Object Notation (JSON) serialization. */\n    toJSON(key?: any): string;\n}\n\ninterface DateConstructor {\n    new(): Date;\n    new(value: number): Date;\n    new(value: string): Date;\n    new(year: number, month: number, date?: number, hours?: number, minutes?: number, seconds?: number, ms?: number): Date;\n    (): string;\n    readonly prototype: Date;\n    /**\n      * Parses a string containing a date, and returns the number of milliseconds between that date and midnight, January 1, 1970.\n      * @param s A date string\n      */\n    parse(s: string): number;\n    /**\n      * Returns the number of milliseconds between midnight, January 1, 1970 Universal Coordinated Time (UTC) (or GMT) and the specified date.\n      * @param year The full year designation is required for cross-century date accuracy. If year is between 0 and 99 is used, then year is assumed to be 1900 + year.\n      * @param month The month as an number between 0 and 11 (January to December).\n      * @param date The date as an number between 1 and 31.\n      * @param hours Must be supplied if minutes is supplied. An number from 0 to 23 (midnight to 11pm) that specifies the hour.\n      * @param minutes Must be supplied if seconds is supplied. An number from 0 to 59 that specifies the minutes.\n      * @param seconds Must be supplied if milliseconds is supplied. An number from 0 to 59 that specifies the seconds.\n      * @param ms An number from 0 to 999 that specifies the milliseconds.\n      */\n    UTC(year: number, month: number, date?: number, hours?: number, minutes?: number, seconds?: number, ms?: number): number;\n    now(): number;\n}\n\ndeclare const Date: DateConstructor;\n\ninterface RegExpMatchArray extends Array<string> {\n    index?: number;\n    input?: string;\n}\n\ninterface RegExpExecArray extends Array<string> {\n    index: number;\n    input: string;\n}\n\ninterface RegExp {\n    /**\n      * Executes a search on a string using a regular expression pattern, and returns an array containing the results of that search.\n      * @param string The String object or string literal on which to perform the search.\n      */\n    exec(string: string): RegExpExecArray | null;\n\n    /**\n      * Returns a Boolean value that indicates whether or not a pattern exists in a searched string.\n      * @param string String on which to perform the search.\n      */\n    test(string: string): boolean;\n\n    /** Returns a copy of the text of the regular expression pattern. Read-only. The regExp argument is a Regular expression object. It can be a variable name or a literal. */\n    readonly source: string;\n\n    /** Returns a Boolean value indicating the state of the global flag (g) used with a regular expression. Default is false. Read-only. */\n    readonly global: boolean;\n\n    /** Returns a Boolean value indicating the state of the ignoreCase flag (i) used with a regular expression. Default is false. Read-only. */\n    readonly ignoreCase: boolean;\n\n    /** Returns a Boolean value indicating the state of the multiline flag (m) used with a regular expression. Default is false. Read-only. */\n    readonly multiline: boolean;\n\n    lastIndex: number;\n\n    // Non-standard extensions\n    compile(): this;\n}\n\ninterface RegExpConstructor {\n    new(pattern: RegExp | string): RegExp;\n    new(pattern: string, flags?: string): RegExp;\n    (pattern: RegExp | string): RegExp;\n    (pattern: string, flags?: string): RegExp;\n    readonly prototype: RegExp;\n\n    // Non-standard extensions\n    $1: string;\n    $2: string;\n    $3: string;\n    $4: string;\n    $5: string;\n    $6: string;\n    $7: string;\n    $8: string;\n    $9: string;\n    lastMatch: string;\n}\n\ndeclare const RegExp: RegExpConstructor;\n\ninterface Error {\n    name: string;\n    message: string;\n    stack?: string;\n}\n\ninterface ErrorConstructor {\n    new(message?: string): Error;\n    (message?: string): Error;\n    readonly prototype: Error;\n}\n\ndeclare const Error: ErrorConstructor;\n\ninterface EvalError extends Error {\n}\n\ninterface EvalErrorConstructor {\n    new(message?: string): EvalError;\n    (message?: string): EvalError;\n    readonly prototype: EvalError;\n}\n\ndeclare const EvalError: EvalErrorConstructor;\n\ninterface RangeError extends Error {\n}\n\ninterface RangeErrorConstructor {\n    new(message?: string): RangeError;\n    (message?: string): RangeError;\n    readonly prototype: RangeError;\n}\n\ndeclare const RangeError: RangeErrorConstructor;\n\ninterface ReferenceError extends Error {\n}\n\ninterface ReferenceErrorConstructor {\n    new(message?: string): ReferenceError;\n    (message?: string): ReferenceError;\n    readonly prototype: ReferenceError;\n}\n\ndeclare const ReferenceError: ReferenceErrorConstructor;\n\ninterface SyntaxError extends Error {\n}\n\ninterface SyntaxErrorConstructor {\n    new(message?: string): SyntaxError;\n    (message?: string): SyntaxError;\n    readonly prototype: SyntaxError;\n}\n\ndeclare const SyntaxError: SyntaxErrorConstructor;\n\ninterface TypeError extends Error {\n}\n\ninterface TypeErrorConstructor {\n    new(message?: string): TypeError;\n    (message?: string): TypeError;\n    readonly prototype: TypeError;\n}\n\ndeclare const TypeError: TypeErrorConstructor;\n\ninterface URIError extends Error {\n}\n\ninterface URIErrorConstructor {\n    new(message?: string): URIError;\n    (message?: string): URIError;\n    readonly prototype: URIError;\n}\n\ndeclare const URIError: URIErrorConstructor;\n\ninterface JSON {\n    /**\n      * Converts a JavaScript Object Notation (JSON) string into an object.\n      * @param text A valid JSON string.\n      * @param reviver A function that transforms the results. This function is called for each member of the object.\n      * If a member contains nested objects, the nested objects are transformed before the parent object is.\n      */\n    parse(text: string, reviver?: (key: any, value: any) => any): any;\n    /**\n      * Converts a JavaScript value to a JavaScript Object Notation (JSON) string.\n      * @param value A JavaScript value, usually an object or array, to be converted.\n      * @param replacer A function that transforms the results.\n      * @param space Adds indentation, white space, and line break characters to the return-value JSON text to make it easier to read.\n      */\n    stringify(value: any, replacer?: (key: string, value: any) => any, space?: string | number): string;\n    /**\n      * Converts a JavaScript value to a JavaScript Object Notation (JSON) string.\n      * @param value A JavaScript value, usually an object or array, to be converted.\n      * @param replacer An array of strings and numbers that acts as a approved list for selecting the object properties that will be stringified.\n      * @param space Adds indentation, white space, and line break characters to the return-value JSON text to make it easier to read.\n      */\n    stringify(value: any, replacer?: (number | string)[] | null, space?: string | number): string;\n}\n\n/**\n  * An intrinsic object that provides functions to convert JavaScript values to and from the JavaScript Object Notation (JSON) format.\n  */\ndeclare const JSON: JSON;\n\n\n/////////////////////////////\n/// ECMAScript Array API (specially handled by compiler)\n/////////////////////////////\n\ninterface ReadonlyArray<T> {\n    /**\n      * Gets the length of the array. This is a number one higher than the highest element defined in an array.\n      */\n    readonly length: number;\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n    /**\n      * Returns a string representation of an array. The elements are converted to string using thier toLocalString methods.\n      */\n    toLocaleString(): string;\n    /**\n      * Combines two or more arrays.\n      * @param items Additional items to add to the end of array1.\n      */\n    concat(...items: T[][]): T[];\n    /**\n      * Combines two or more arrays.\n      * @param items Additional items to add to the end of array1.\n      */\n    concat(...items: (T | T[])[]): T[];\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): T[];\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the search starts at index 0.\n      */\n    indexOf(searchElement: T, fromIndex?: number): number;\n    /**\n      * Returns the index of the last occurrence of a specified value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the search starts at the last index in the array.\n      */\n    lastIndexOf(searchElement: T, fromIndex?: number): number;\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls the callbackfn function for each element in array1 until the callbackfn returns false, or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: T, index: number, array: ReadonlyArray<T>) => boolean, thisArg?: any): boolean;\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the callbackfn function for each element in array1 until the callbackfn returns true, or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: T, index: number, array: ReadonlyArray<T>) => boolean, thisArg?: any): boolean;\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: T, index: number, array: ReadonlyArray<T>) => void, thisArg?: any): void;\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    map<U>(callbackfn: (value: T, index: number, array: ReadonlyArray<T>) => U, thisArg?: any): U[];\n    /**\n     * Returns the elements of an array that meet the condition specified in a callback function.\n     * @param callbackfn A function that accepts up to three arguments. The filter method calls the callbackfn function one time for each element in the array.\n     * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n     */\n    filter<S extends T>(callbackfn: (value: T, index: number, array: ReadonlyArray<T>) => value is S, thisArg?: any): S[];\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: T, index: number, array: ReadonlyArray<T>) => any, thisArg?: any): T[];\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: ReadonlyArray<T>) => T, initialValue?: T): T;\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: ReadonlyArray<T>) => U, initialValue: U): U;\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: ReadonlyArray<T>) => T, initialValue?: T): T;\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: ReadonlyArray<T>) => U, initialValue: U): U;\n\n    readonly [n: number]: T;\n}\n\ninterface Array<T> {\n    /**\n      * Gets or sets the length of the array. This is a number one higher than the highest element defined in an array.\n      */\n    length: number;\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n    /**\n      * Returns a string representation of an array. The elements are converted to string using thier toLocalString methods.\n      */\n    toLocaleString(): string;\n    /**\n      * Appends new elements to an array, and returns the new length of the array.\n      * @param items New elements of the Array.\n      */\n    push(...items: T[]): number;\n    /**\n      * Removes the last element from an array and returns it.\n      */\n    pop(): T | undefined;\n    /**\n      * Combines two or more arrays.\n      * @param items Additional items to add to the end of array1.\n      */\n    concat(...items: T[][]): T[];\n    /**\n      * Combines two or more arrays.\n      * @param items Additional items to add to the end of array1.\n      */\n    concat(...items: (T | T[])[]): T[];\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): T[];\n    /**\n      * Removes the first element from an array and returns it.\n      */\n    shift(): T | undefined;\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): T[];\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: T, b: T) => number): this;\n    /**\n      * Removes elements from an array and, if necessary, inserts new elements in their place, returning the deleted elements.\n      * @param start The zero-based location in the array from which to start removing elements.\n      * @param deleteCount The number of elements to remove.\n      */\n    splice(start: number, deleteCount?: number): T[];\n    /**\n      * Removes elements from an array and, if necessary, inserts new elements in their place, returning the deleted elements.\n      * @param start The zero-based location in the array from which to start removing elements.\n      * @param deleteCount The number of elements to remove.\n      * @param items Elements to insert into the array in place of the deleted elements.\n      */\n    splice(start: number, deleteCount: number, ...items: T[]): T[];\n    /**\n      * Inserts new elements at the start of an array.\n      * @param items  Elements to insert at the start of the Array.\n      */\n    unshift(...items: T[]): number;\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the search starts at index 0.\n      */\n    indexOf(searchElement: T, fromIndex?: number): number;\n    /**\n      * Returns the index of the last occurrence of a specified value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the search starts at the last index in the array.\n      */\n    lastIndexOf(searchElement: T, fromIndex?: number): number;\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls the callbackfn function for each element in array1 until the callbackfn returns false, or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: T, index: number, array: T[]) => boolean, thisArg?: any): boolean;\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the callbackfn function for each element in array1 until the callbackfn returns true, or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: T, index: number, array: T[]) => boolean, thisArg?: any): boolean;\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: T, index: number, array: T[]) => void, thisArg?: any): void;\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    map<U>(callbackfn: (value: T, index: number, array: T[]) => U, thisArg?: any): U[];\n    /**\n     * Returns the elements of an array that meet the condition specified in a callback function.\n     * @param callbackfn A function that accepts up to three arguments. The filter method calls the callbackfn function one time for each element in the array.\n     * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n     */\n    filter<S extends T>(callbackfn: (value: T, index: number, array: T[]) => value is S, thisArg?: any): S[];\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: T, index: number, array: T[]) => any, thisArg?: any): T[];\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: T[]) => T, initialValue?: T): T;\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: T[]) => U, initialValue: U): U;\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: T[]) => T, initialValue?: T): T;\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: T[]) => U, initialValue: U): U;\n\n    [n: number]: T;\n}\n\ninterface ArrayConstructor {\n    new(arrayLength?: number): any[];\n    new <T>(arrayLength: number): T[];\n    new <T>(...items: T[]): T[];\n    (arrayLength?: number): any[];\n    <T>(arrayLength: number): T[];\n    <T>(...items: T[]): T[];\n    isArray(arg: any): arg is Array<any>;\n    readonly prototype: Array<any>;\n}\n\ndeclare const Array: ArrayConstructor;\n\ninterface TypedPropertyDescriptor<T> {\n    enumerable?: boolean;\n    configurable?: boolean;\n    writable?: boolean;\n    value?: T;\n    get?: () => T;\n    set?: (value: T) => void;\n}\n\ndeclare type ClassDecorator = <TFunction extends Function>(target: TFunction) => TFunction | void;\ndeclare type PropertyDecorator = (target: Object, propertyKey: string | symbol) => void;\ndeclare type MethodDecorator = <T>(target: Object, propertyKey: string | symbol, descriptor: TypedPropertyDescriptor<T>) => TypedPropertyDescriptor<T> | void;\ndeclare type ParameterDecorator = (target: Object, propertyKey: string | symbol, parameterIndex: number) => void;\n\ndeclare type PromiseConstructorLike = new <T>(executor: (resolve: (value?: T | PromiseLike<T>) => void, reject: (reason?: any) => void) => void) => PromiseLike<T>;\n\ninterface PromiseLike<T> {\n    /**\n     * Attaches callbacks for the resolution and/or rejection of the Promise.\n     * @param onfulfilled The callback to execute when the Promise is resolved.\n     * @param onrejected The callback to execute when the Promise is rejected.\n     * @returns A Promise for the completion of which ever callback is executed.\n     */\n    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): PromiseLike<TResult1 | TResult2>;\n}\n\n/**\n * Represents the completion of an asynchronous operation\n */\ninterface Promise<T> {\n    /**\n     * Attaches callbacks for the resolution and/or rejection of the Promise.\n     * @param onfulfilled The callback to execute when the Promise is resolved.\n     * @param onrejected The callback to execute when the Promise is rejected.\n     * @returns A Promise for the completion of which ever callback is executed.\n     */\n    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;\n\n    /**\n     * Attaches a callback for only the rejection of the Promise.\n     * @param onrejected The callback to execute when the Promise is rejected.\n     * @returns A Promise for the completion of the callback.\n     */\n    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;\n}\n\ninterface ArrayLike<T> {\n    readonly length: number;\n    readonly [n: number]: T;\n}\n\n/**\n * Make all properties in T optional\n */\ntype Partial<T> = {\n    [P in keyof T]?: T[P];\n};\n\n/**\n * Make all properties in T readonly\n */\ntype Readonly<T> = {\n    readonly [P in keyof T]: T[P];\n};\n\n/**\n * From T pick a set of properties K\n */\ntype Pick<T, K extends keyof T> = {\n    [P in K]: T[P];\n};\n\n/**\n * Construct a type with a set of properties K of type T\n */\ntype Record<K extends string, T> = {\n    [P in K]: T;\n};\n\n/**\n * Marker for contextual 'this' type\n */\ninterface ThisType<T> { }\n\n/**\n  * Represents a raw buffer of binary data, which is used to store data for the\n  * different typed arrays. ArrayBuffers cannot be read from or written to directly,\n  * but can be passed to a typed array or DataView Object to interpret the raw\n  * buffer as needed.\n  */\ninterface ArrayBuffer {\n    /**\n      * Read-only. The length of the ArrayBuffer (in bytes).\n      */\n    readonly byteLength: number;\n\n    /**\n      * Returns a section of an ArrayBuffer.\n      */\n    slice(begin: number, end?: number): ArrayBuffer;\n}\n\n/**\n * Allowed ArrayBuffer types for the buffer of an ArrayBufferView and related Typed Arrays.\n */\ninterface ArrayBufferTypes {\n    ArrayBuffer: ArrayBuffer;\n}\ntype ArrayBufferLike = ArrayBufferTypes[keyof ArrayBufferTypes];\n\ninterface ArrayBufferConstructor {\n    readonly prototype: ArrayBuffer;\n    new(byteLength: number): ArrayBuffer;\n    isView(arg: any): arg is ArrayBufferView;\n}\ndeclare const ArrayBuffer: ArrayBufferConstructor;\n\ninterface ArrayBufferView {\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    byteOffset: number;\n}\n\ninterface DataView {\n    readonly buffer: ArrayBuffer;\n    readonly byteLength: number;\n    readonly byteOffset: number;\n    /**\n      * Gets the Float32 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getFloat32(byteOffset: number, littleEndian?: boolean): number;\n\n    /**\n      * Gets the Float64 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getFloat64(byteOffset: number, littleEndian?: boolean): number;\n\n    /**\n      * Gets the Int8 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getInt8(byteOffset: number): number;\n\n    /**\n      * Gets the Int16 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getInt16(byteOffset: number, littleEndian?: boolean): number;\n    /**\n      * Gets the Int32 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getInt32(byteOffset: number, littleEndian?: boolean): number;\n\n    /**\n      * Gets the Uint8 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getUint8(byteOffset: number): number;\n\n    /**\n      * Gets the Uint16 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getUint16(byteOffset: number, littleEndian?: boolean): number;\n\n    /**\n      * Gets the Uint32 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getUint32(byteOffset: number, littleEndian?: boolean): number;\n\n    /**\n      * Stores an Float32 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      * @param littleEndian If false or undefined, a big-endian value should be written,\n      * otherwise a little-endian value should be written.\n      */\n    setFloat32(byteOffset: number, value: number, littleEndian?: boolean): void;\n\n    /**\n      * Stores an Float64 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      * @param littleEndian If false or undefined, a big-endian value should be written,\n      * otherwise a little-endian value should be written.\n      */\n    setFloat64(byteOffset: number, value: number, littleEndian?: boolean): void;\n\n    /**\n      * Stores an Int8 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      */\n    setInt8(byteOffset: number, value: number): void;\n\n    /**\n      * Stores an Int16 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      * @param littleEndian If false or undefined, a big-endian value should be written,\n      * otherwise a little-endian value should be written.\n      */\n    setInt16(byteOffset: number, value: number, littleEndian?: boolean): void;\n\n    /**\n      * Stores an Int32 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      * @param littleEndian If false or undefined, a big-endian value should be written,\n      * otherwise a little-endian value should be written.\n      */\n    setInt32(byteOffset: number, value: number, littleEndian?: boolean): void;\n\n    /**\n      * Stores an Uint8 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      */\n    setUint8(byteOffset: number, value: number): void;\n\n    /**\n      * Stores an Uint16 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      * @param littleEndian If false or undefined, a big-endian value should be written,\n      * otherwise a little-endian value should be written.\n      */\n    setUint16(byteOffset: number, value: number, littleEndian?: boolean): void;\n\n    /**\n      * Stores an Uint32 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      * @param littleEndian If false or undefined, a big-endian value should be written,\n      * otherwise a little-endian value should be written.\n      */\n    setUint32(byteOffset: number, value: number, littleEndian?: boolean): void;\n}\n\ninterface DataViewConstructor {\n    new(buffer: ArrayBufferLike, byteOffset?: number, byteLength?: number): DataView;\n}\ndeclare const DataView: DataViewConstructor;\n\n/**\n  * A typed array of 8-bit integer values. The contents are initialized to 0. If the requested\n  * number of bytes could not be allocated an exception is raised.\n  */\ninterface Int8Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Int8Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Int8Array) => any, thisArg?: any): Int8Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Int8Array) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Int8Array) => number, thisArg?: any): Int8Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Int8Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Int8Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Int8Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Int8Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Int8Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Int8Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Int8Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Int8Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Int8Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\ninterface Int8ArrayConstructor {\n    readonly prototype: Int8Array;\n    new(length: number): Int8Array;\n    new(array: ArrayLike<number>): Int8Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Int8Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Int8Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Int8Array;\n\n\n}\ndeclare const Int8Array: Int8ArrayConstructor;\n\n/**\n  * A typed array of 8-bit unsigned integer values. The contents are initialized to 0. If the\n  * requested number of bytes could not be allocated an exception is raised.\n  */\ninterface Uint8Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Uint8Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Uint8Array) => any, thisArg?: any): Uint8Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Uint8Array) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Uint8Array) => number, thisArg?: any): Uint8Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint8Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint8Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint8Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint8Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Uint8Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Uint8Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Uint8Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Uint8Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Uint8Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Uint8ArrayConstructor {\n    readonly prototype: Uint8Array;\n    new(length: number): Uint8Array;\n    new(array: ArrayLike<number>): Uint8Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Uint8Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Uint8Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint8Array;\n\n}\ndeclare const Uint8Array: Uint8ArrayConstructor;\n\n/**\n  * A typed array of 8-bit unsigned integer (clamped) values. The contents are initialized to 0.\n  * If the requested number of bytes could not be allocated an exception is raised.\n  */\ninterface Uint8ClampedArray {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Uint8ClampedArray) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Uint8ClampedArray) => any, thisArg?: any): Uint8ClampedArray;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Uint8ClampedArray) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Uint8ClampedArray) => number, thisArg?: any): Uint8ClampedArray;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint8ClampedArray) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint8ClampedArray) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint8ClampedArray) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint8ClampedArray) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Uint8ClampedArray;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Uint8ClampedArray;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Uint8ClampedArray) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Uint8ClampedArray view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Uint8ClampedArray;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Uint8ClampedArrayConstructor {\n    readonly prototype: Uint8ClampedArray;\n    new(length: number): Uint8ClampedArray;\n    new(array: ArrayLike<number>): Uint8ClampedArray;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Uint8ClampedArray;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Uint8ClampedArray;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint8ClampedArray;\n}\ndeclare const Uint8ClampedArray: Uint8ClampedArrayConstructor;\n\n/**\n  * A typed array of 16-bit signed integer values. The contents are initialized to 0. If the\n  * requested number of bytes could not be allocated an exception is raised.\n  */\ninterface Int16Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Int16Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (this: void, value: number, index: number, array: Int16Array) => any, thisArg?: any): Int16Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Int16Array) => void, thisArg?: any): void;\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Int16Array) => number, thisArg?: any): Int16Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Int16Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Int16Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Int16Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Int16Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Int16Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Int16Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Int16Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Int16Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Int16Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Int16ArrayConstructor {\n    readonly prototype: Int16Array;\n    new(length: number): Int16Array;\n    new(array: ArrayLike<number>): Int16Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Int16Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Int16Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Int16Array;\n\n\n}\ndeclare const Int16Array: Int16ArrayConstructor;\n\n/**\n  * A typed array of 16-bit unsigned integer values. The contents are initialized to 0. If the\n  * requested number of bytes could not be allocated an exception is raised.\n  */\ninterface Uint16Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Uint16Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Uint16Array) => any, thisArg?: any): Uint16Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Uint16Array) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Uint16Array) => number, thisArg?: any): Uint16Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint16Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint16Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint16Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint16Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Uint16Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Uint16Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Uint16Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Uint16Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Uint16Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Uint16ArrayConstructor {\n    readonly prototype: Uint16Array;\n    new(length: number): Uint16Array;\n    new(array: ArrayLike<number>): Uint16Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Uint16Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Uint16Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint16Array;\n\n\n}\ndeclare const Uint16Array: Uint16ArrayConstructor;\n/**\n  * A typed array of 32-bit signed integer values. The contents are initialized to 0. If the\n  * requested number of bytes could not be allocated an exception is raised.\n  */\ninterface Int32Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Int32Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Int32Array) => any, thisArg?: any): Int32Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Int32Array) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (value: number, index: number, array: Int32Array) => number, thisArg?: any): Int32Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Int32Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Int32Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Int32Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Int32Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Int32Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Int32Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Int32Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Int32Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Int32Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Int32ArrayConstructor {\n    readonly prototype: Int32Array;\n    new(length: number): Int32Array;\n    new(array: ArrayLike<number>): Int32Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Int32Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Int32Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Int32Array;\n\n}\ndeclare const Int32Array: Int32ArrayConstructor;\n\n/**\n  * A typed array of 32-bit unsigned integer values. The contents are initialized to 0. If the\n  * requested number of bytes could not be allocated an exception is raised.\n  */\ninterface Uint32Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Uint32Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Uint32Array) => any, thisArg?: any): Uint32Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Uint32Array) => void, thisArg?: any): void;\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Uint32Array) => number, thisArg?: any): Uint32Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint32Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint32Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint32Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint32Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Uint32Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Uint32Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Uint32Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Uint32Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Uint32Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Uint32ArrayConstructor {\n    readonly prototype: Uint32Array;\n    new(length: number): Uint32Array;\n    new(array: ArrayLike<number>): Uint32Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Uint32Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Uint32Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint32Array;\n\n}\ndeclare const Uint32Array: Uint32ArrayConstructor;\n\n/**\n  * A typed array of 32-bit float values. The contents are initialized to 0. If the requested number\n  * of bytes could not be allocated an exception is raised.\n  */\ninterface Float32Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Float32Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Float32Array) => any, thisArg?: any): Float32Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Float32Array) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Float32Array) => number, thisArg?: any): Float32Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Float32Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Float32Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Float32Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Float32Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Float32Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Float32Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Float32Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Float32Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Float32Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Float32ArrayConstructor {\n    readonly prototype: Float32Array;\n    new(length: number): Float32Array;\n    new(array: ArrayLike<number>): Float32Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Float32Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Float32Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Float32Array;\n\n\n}\ndeclare const Float32Array: Float32ArrayConstructor;\n\n/**\n  * A typed array of 64-bit float values. The contents are initialized to 0. If the requested\n  * number of bytes could not be allocated an exception is raised.\n  */\ninterface Float64Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Float64Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Float64Array) => any, thisArg?: any): Float64Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Float64Array) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Float64Array) => number, thisArg?: any): Float64Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Float64Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Float64Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Float64Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Float64Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Float64Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Float64Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Float64Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Float64Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Float64Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Float64ArrayConstructor {\n    readonly prototype: Float64Array;\n    new(length: number): Float64Array;\n    new(array: ArrayLike<number>): Float64Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Float64Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Float64Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Float64Array;\n\n}\ndeclare const Float64Array: Float64ArrayConstructor;\n\n/////////////////////////////\n/// ECMAScript Internationalization API\n/////////////////////////////\n\ndeclare namespace Intl {\n    interface CollatorOptions {\n        usage?: string;\n        localeMatcher?: string;\n        numeric?: boolean;\n        caseFirst?: string;\n        sensitivity?: string;\n        ignorePunctuation?: boolean;\n    }\n\n    interface ResolvedCollatorOptions {\n        locale: string;\n        usage: string;\n        sensitivity: string;\n        ignorePunctuation: boolean;\n        collation: string;\n        caseFirst: string;\n        numeric: boolean;\n    }\n\n    interface Collator {\n        compare(x: string, y: string): number;\n        resolvedOptions(): ResolvedCollatorOptions;\n    }\n    var Collator: {\n        new(locales?: string | string[], options?: CollatorOptions): Collator;\n        (locales?: string | string[], options?: CollatorOptions): Collator;\n        supportedLocalesOf(locales: string | string[], options?: CollatorOptions): string[];\n    };\n\n    interface NumberFormatOptions {\n        localeMatcher?: string;\n        style?: string;\n        currency?: string;\n        currencyDisplay?: string;\n        useGrouping?: boolean;\n        minimumIntegerDigits?: number;\n        minimumFractionDigits?: number;\n        maximumFractionDigits?: number;\n        minimumSignificantDigits?: number;\n        maximumSignificantDigits?: number;\n    }\n\n    interface ResolvedNumberFormatOptions {\n        locale: string;\n        numberingSystem: string;\n        style: string;\n        currency?: string;\n        currencyDisplay?: string;\n        minimumIntegerDigits: number;\n        minimumFractionDigits: number;\n        maximumFractionDigits: number;\n        minimumSignificantDigits?: number;\n        maximumSignificantDigits?: number;\n        useGrouping: boolean;\n    }\n\n    interface NumberFormat {\n        format(value: number): string;\n        resolvedOptions(): ResolvedNumberFormatOptions;\n    }\n    var NumberFormat: {\n        new(locales?: string | string[], options?: NumberFormatOptions): NumberFormat;\n        (locales?: string | string[], options?: NumberFormatOptions): NumberFormat;\n        supportedLocalesOf(locales: string | string[], options?: NumberFormatOptions): string[];\n    };\n\n    interface DateTimeFormatOptions {\n        localeMatcher?: string;\n        weekday?: string;\n        era?: string;\n        year?: string;\n        month?: string;\n        day?: string;\n        hour?: string;\n        minute?: string;\n        second?: string;\n        timeZoneName?: string;\n        formatMatcher?: string;\n        hour12?: boolean;\n        timeZone?: string;\n    }\n\n    interface ResolvedDateTimeFormatOptions {\n        locale: string;\n        calendar: string;\n        numberingSystem: string;\n        timeZone: string;\n        hour12?: boolean;\n        weekday?: string;\n        era?: string;\n        year?: string;\n        month?: string;\n        day?: string;\n        hour?: string;\n        minute?: string;\n        second?: string;\n        timeZoneName?: string;\n    }\n\n    interface DateTimeFormat {\n        format(date?: Date | number): string;\n        resolvedOptions(): ResolvedDateTimeFormatOptions;\n    }\n    var DateTimeFormat: {\n        new(locales?: string | string[], options?: DateTimeFormatOptions): DateTimeFormat;\n        (locales?: string | string[], options?: DateTimeFormatOptions): DateTimeFormat;\n        supportedLocalesOf(locales: string | string[], options?: DateTimeFormatOptions): string[];\n    };\n}\n\ninterface String {\n    /**\n      * Determines whether two strings are equivalent in the current or specified locale.\n      * @param that String to compare to target string\n      * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used. This parameter must conform to BCP 47 standards; see the Intl.Collator object for details.\n      * @param options An object that contains one or more properties that specify comparison options. see the Intl.Collator object for details.\n      */\n    localeCompare(that: string, locales?: string | string[], options?: Intl.CollatorOptions): number;\n}\n\ninterface Number {\n    /**\n      * Converts a number to a string by using the current or specified locale.\n      * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used.\n      * @param options An object that contains one or more properties that specify comparison options.\n      */\n    toLocaleString(locales?: string | string[], options?: Intl.NumberFormatOptions): string;\n}\n\ninterface Date {\n    /**\n      * Converts a date and time to a string by using the current or specified locale.\n      * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used.\n      * @param options An object that contains one or more properties that specify comparison options.\n      */\n    toLocaleString(locales?: string | string[], options?: Intl.DateTimeFormatOptions): string;\n    /**\n      * Converts a date to a string by using the current or specified locale.\n      * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used.\n      * @param options An object that contains one or more properties that specify comparison options.\n      */\n    toLocaleDateString(locales?: string | string[], options?: Intl.DateTimeFormatOptions): string;\n\n    /**\n      * Converts a time to a string by using the current or specified locale.\n      * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used.\n      * @param options An object that contains one or more properties that specify comparison options.\n      */\n    toLocaleTimeString(locales?: string | string[], options?: Intl.DateTimeFormatOptions): string;\n}\n\n\n\n/////////////////////////////\n/// DOM APIs\n/////////////////////////////\n\ninterface Account {\n    displayName?: string;\n    id?: string;\n    imageURL?: string;\n    name?: string;\n    rpDisplayName?: string;\n}\n\ninterface Algorithm {\n    name: string;\n}\n\ninterface AnimationEventInit extends EventInit {\n    animationName?: string;\n    elapsedTime?: number;\n}\n\ninterface AssertionOptions {\n    allowList?: ScopedCredentialDescriptor[];\n    extensions?: WebAuthnExtensions;\n    rpId?: USVString;\n    timeoutSeconds?: number;\n}\n\ninterface CacheQueryOptions {\n    cacheName?: string;\n    ignoreMethod?: boolean;\n    ignoreSearch?: boolean;\n    ignoreVary?: boolean;\n}\n\ninterface ClientData {\n    challenge?: string;\n    extensions?: WebAuthnExtensions;\n    hashAlg?: string | Algorithm;\n    origin?: string;\n    rpId?: string;\n    tokenBinding?: string;\n}\n\ninterface CloseEventInit extends EventInit {\n    code?: number;\n    reason?: string;\n    wasClean?: boolean;\n}\n\ninterface CompositionEventInit extends UIEventInit {\n    data?: string;\n}\n\ninterface ConfirmSiteSpecificExceptionsInformation extends ExceptionInformation {\n    arrayOfDomainStrings?: string[];\n}\n\ninterface ConstrainBooleanParameters {\n    exact?: boolean;\n    ideal?: boolean;\n}\n\ninterface ConstrainDOMStringParameters {\n    exact?: string | string[];\n    ideal?: string | string[];\n}\n\ninterface ConstrainDoubleRange extends DoubleRange {\n    exact?: number;\n    ideal?: number;\n}\n\ninterface ConstrainLongRange extends LongRange {\n    exact?: number;\n    ideal?: number;\n}\n\ninterface ConstrainVideoFacingModeParameters {\n    exact?: VideoFacingModeEnum | VideoFacingModeEnum[];\n    ideal?: VideoFacingModeEnum | VideoFacingModeEnum[];\n}\n\ninterface CustomEventInit extends EventInit {\n    detail?: any;\n}\n\ninterface DeviceAccelerationDict {\n    x?: number;\n    y?: number;\n    z?: number;\n}\n\ninterface DeviceLightEventInit extends EventInit {\n    value?: number;\n}\n\ninterface DeviceMotionEventInit extends EventInit {\n    acceleration?: DeviceAccelerationDict;\n    accelerationIncludingGravity?: DeviceAccelerationDict;\n    interval?: number;\n    rotationRate?: DeviceRotationRateDict;\n}\n\ninterface DeviceOrientationEventInit extends EventInit {\n    absolute?: boolean;\n    alpha?: number;\n    beta?: number;\n    gamma?: number;\n}\n\ninterface DeviceRotationRateDict {\n    alpha?: number;\n    beta?: number;\n    gamma?: number;\n}\n\ninterface DOMRectInit {\n    height?: any;\n    width?: any;\n    x?: any;\n    y?: any;\n}\n\ninterface DoubleRange {\n    max?: number;\n    min?: number;\n}\n\ninterface ErrorEventInit extends EventInit {\n    colno?: number;\n    error?: any;\n    filename?: string;\n    lineno?: number;\n    message?: string;\n}\n\ninterface EventInit {\n    scoped?: boolean;\n    bubbles?: boolean;\n    cancelable?: boolean;\n}\n\ninterface EventModifierInit extends UIEventInit {\n    altKey?: boolean;\n    ctrlKey?: boolean;\n    metaKey?: boolean;\n    modifierAltGraph?: boolean;\n    modifierCapsLock?: boolean;\n    modifierFn?: boolean;\n    modifierFnLock?: boolean;\n    modifierHyper?: boolean;\n    modifierNumLock?: boolean;\n    modifierOS?: boolean;\n    modifierScrollLock?: boolean;\n    modifierSuper?: boolean;\n    modifierSymbol?: boolean;\n    modifierSymbolLock?: boolean;\n    shiftKey?: boolean;\n}\n\ninterface ExceptionInformation {\n    domain?: string;\n}\n\ninterface FocusEventInit extends UIEventInit {\n    relatedTarget?: EventTarget;\n}\n\ninterface FocusNavigationEventInit extends EventInit {\n    navigationReason?: string;\n    originHeight?: number;\n    originLeft?: number;\n    originTop?: number;\n    originWidth?: number;\n}\n\ninterface FocusNavigationOrigin {\n    originHeight?: number;\n    originLeft?: number;\n    originTop?: number;\n    originWidth?: number;\n}\n\ninterface GamepadEventInit extends EventInit {\n    gamepad?: Gamepad;\n}\n\ninterface GetNotificationOptions {\n    tag?: string;\n}\n\ninterface HashChangeEventInit extends EventInit {\n    newURL?: string;\n    oldURL?: string;\n}\n\ninterface IDBIndexParameters {\n    multiEntry?: boolean;\n    unique?: boolean;\n}\n\ninterface IDBObjectStoreParameters {\n    autoIncrement?: boolean;\n    keyPath?: IDBKeyPath;\n}\n\ninterface IntersectionObserverEntryInit {\n    boundingClientRect?: DOMRectInit;\n    intersectionRect?: DOMRectInit;\n    rootBounds?: DOMRectInit;\n    target?: Element;\n    time?: number;\n}\n\ninterface IntersectionObserverInit {\n    root?: Element;\n    rootMargin?: string;\n    threshold?: number | number[];\n}\n\ninterface KeyAlgorithm {\n    name?: string;\n}\n\ninterface KeyboardEventInit extends EventModifierInit {\n    code?: string;\n    key?: string;\n    location?: number;\n    repeat?: boolean;\n}\n\ninterface LongRange {\n    max?: number;\n    min?: number;\n}\n\ninterface MediaEncryptedEventInit extends EventInit {\n    initData?: ArrayBuffer;\n    initDataType?: string;\n}\n\ninterface MediaKeyMessageEventInit extends EventInit {\n    message?: ArrayBuffer;\n    messageType?: MediaKeyMessageType;\n}\n\ninterface MediaKeySystemConfiguration {\n    audioCapabilities?: MediaKeySystemMediaCapability[];\n    distinctiveIdentifier?: MediaKeysRequirement;\n    initDataTypes?: string[];\n    persistentState?: MediaKeysRequirement;\n    videoCapabilities?: MediaKeySystemMediaCapability[];\n}\n\ninterface MediaKeySystemMediaCapability {\n    contentType?: string;\n    robustness?: string;\n}\n\ninterface MediaStreamConstraints {\n    audio?: boolean | MediaTrackConstraints;\n    video?: boolean | MediaTrackConstraints;\n}\n\ninterface MediaStreamErrorEventInit extends EventInit {\n    error?: MediaStreamError;\n}\n\ninterface MediaStreamEventInit extends EventInit {\n    stream?: MediaStream;\n}\n\ninterface MediaStreamTrackEventInit extends EventInit {\n    track?: MediaStreamTrack;\n}\n\ninterface MediaTrackCapabilities {\n    aspectRatio?: number | DoubleRange;\n    deviceId?: string;\n    echoCancellation?: boolean[];\n    facingMode?: string;\n    frameRate?: number | DoubleRange;\n    groupId?: string;\n    height?: number | LongRange;\n    sampleRate?: number | LongRange;\n    sampleSize?: number | LongRange;\n    volume?: number | DoubleRange;\n    width?: number | LongRange;\n}\n\ninterface MediaTrackConstraints extends MediaTrackConstraintSet {\n    advanced?: MediaTrackConstraintSet[];\n}\n\ninterface MediaTrackConstraintSet {\n    aspectRatio?: number | ConstrainDoubleRange;\n    deviceId?: string | string[] | ConstrainDOMStringParameters;\n    echoCancelation?: boolean | ConstrainBooleanParameters;\n    facingMode?: string | string[] | ConstrainDOMStringParameters;\n    frameRate?: number | ConstrainDoubleRange;\n    groupId?: string | string[] | ConstrainDOMStringParameters;\n    height?: number | ConstrainLongRange;\n    sampleRate?: number | ConstrainLongRange;\n    sampleSize?: number | ConstrainLongRange;\n    volume?: number | ConstrainDoubleRange;\n    width?: number | ConstrainLongRange;\n}\n\ninterface MediaTrackSettings {\n    aspectRatio?: number;\n    deviceId?: string;\n    echoCancellation?: boolean;\n    facingMode?: string;\n    frameRate?: number;\n    groupId?: string;\n    height?: number;\n    sampleRate?: number;\n    sampleSize?: number;\n    volume?: number;\n    width?: number;\n}\n\ninterface MediaTrackSupportedConstraints {\n    aspectRatio?: boolean;\n    deviceId?: boolean;\n    echoCancellation?: boolean;\n    facingMode?: boolean;\n    frameRate?: boolean;\n    groupId?: boolean;\n    height?: boolean;\n    sampleRate?: boolean;\n    sampleSize?: boolean;\n    volume?: boolean;\n    width?: boolean;\n}\n\ninterface MessageEventInit extends EventInit {\n    lastEventId?: string;\n    channel?: string;\n    data?: any;\n    origin?: string;\n    ports?: MessagePort[];\n    source?: Window;\n}\n\ninterface MouseEventInit extends EventModifierInit {\n    button?: number;\n    buttons?: number;\n    clientX?: number;\n    clientY?: number;\n    relatedTarget?: EventTarget;\n    screenX?: number;\n    screenY?: number;\n}\n\ninterface MSAccountInfo {\n    accountImageUri?: string;\n    accountName?: string;\n    rpDisplayName?: string;\n    userDisplayName?: string;\n    userId?: string;\n}\n\ninterface MSAudioLocalClientEvent extends MSLocalClientEventBase {\n    cpuInsufficientEventRatio?: number;\n    deviceCaptureNotFunctioningEventRatio?: number;\n    deviceClippingEventRatio?: number;\n    deviceEchoEventRatio?: number;\n    deviceGlitchesEventRatio?: number;\n    deviceHalfDuplexAECEventRatio?: number;\n    deviceHowlingEventCount?: number;\n    deviceLowSNREventRatio?: number;\n    deviceLowSpeechLevelEventRatio?: number;\n    deviceMultipleEndpointsEventCount?: number;\n    deviceNearEndToEchoRatioEventRatio?: number;\n    deviceRenderMuteEventRatio?: number;\n    deviceRenderNotFunctioningEventRatio?: number;\n    deviceRenderZeroVolumeEventRatio?: number;\n    networkDelayEventRatio?: number;\n    networkSendQualityEventRatio?: number;\n}\n\ninterface MSAudioRecvPayload extends MSPayloadBase {\n    burstLossLength1?: number;\n    burstLossLength2?: number;\n    burstLossLength3?: number;\n    burstLossLength4?: number;\n    burstLossLength5?: number;\n    burstLossLength6?: number;\n    burstLossLength7?: number;\n    burstLossLength8OrHigher?: number;\n    fecRecvDistance1?: number;\n    fecRecvDistance2?: number;\n    fecRecvDistance3?: number;\n    packetReorderDepthAvg?: number;\n    packetReorderDepthMax?: number;\n    packetReorderRatio?: number;\n    ratioCompressedSamplesAvg?: number;\n    ratioConcealedSamplesAvg?: number;\n    ratioStretchedSamplesAvg?: number;\n    samplingRate?: number;\n    signal?: MSAudioRecvSignal;\n}\n\ninterface MSAudioRecvSignal {\n    initialSignalLevelRMS?: number;\n    recvNoiseLevelCh1?: number;\n    recvSignalLevelCh1?: number;\n    renderLoopbackSignalLevel?: number;\n    renderNoiseLevel?: number;\n    renderSignalLevel?: number;\n}\n\ninterface MSAudioSendPayload extends MSPayloadBase {\n    audioFECUsed?: boolean;\n    samplingRate?: number;\n    sendMutePercent?: number;\n    signal?: MSAudioSendSignal;\n}\n\ninterface MSAudioSendSignal {\n    noiseLevel?: number;\n    sendNoiseLevelCh1?: number;\n    sendSignalLevelCh1?: number;\n}\n\ninterface MSConnectivity {\n    iceType?: MSIceType;\n    iceWarningFlags?: MSIceWarningFlags;\n    relayAddress?: MSRelayAddress;\n}\n\ninterface MSCredentialFilter {\n    accept?: MSCredentialSpec[];\n}\n\ninterface MSCredentialParameters {\n    type?: MSCredentialType;\n}\n\ninterface MSCredentialSpec {\n    id?: string;\n    type?: MSCredentialType;\n}\n\ninterface MSDelay {\n    roundTrip?: number;\n    roundTripMax?: number;\n}\n\ninterface MSDescription extends RTCStats {\n    connectivity?: MSConnectivity;\n    deviceDevName?: string;\n    localAddr?: MSIPAddressInfo;\n    networkconnectivity?: MSNetworkConnectivityInfo;\n    reflexiveLocalIPAddr?: MSIPAddressInfo;\n    remoteAddr?: MSIPAddressInfo;\n    transport?: RTCIceProtocol;\n}\n\ninterface MSFIDOCredentialParameters extends MSCredentialParameters {\n    algorithm?: string | Algorithm;\n    authenticators?: AAGUID[];\n}\n\ninterface MSIceWarningFlags {\n    allocationMessageIntegrityFailed?: boolean;\n    alternateServerReceived?: boolean;\n    connCheckMessageIntegrityFailed?: boolean;\n    connCheckOtherError?: boolean;\n    fipsAllocationFailure?: boolean;\n    multipleRelayServersAttempted?: boolean;\n    noRelayServersConfigured?: boolean;\n    portRangeExhausted?: boolean;\n    pseudoTLSFailure?: boolean;\n    tcpNatConnectivityFailed?: boolean;\n    tcpRelayConnectivityFailed?: boolean;\n    turnAuthUnknownUsernameError?: boolean;\n    turnTcpAllocateFailed?: boolean;\n    turnTcpSendFailed?: boolean;\n    turnTcpTimedOut?: boolean;\n    turnTurnTcpConnectivityFailed?: boolean;\n    turnUdpAllocateFailed?: boolean;\n    turnUdpSendFailed?: boolean;\n    udpLocalConnectivityFailed?: boolean;\n    udpNatConnectivityFailed?: boolean;\n    udpRelayConnectivityFailed?: boolean;\n    useCandidateChecksFailed?: boolean;\n}\n\ninterface MSIPAddressInfo {\n    ipAddr?: string;\n    manufacturerMacAddrMask?: string;\n    port?: number;\n}\n\ninterface MSJitter {\n    interArrival?: number;\n    interArrivalMax?: number;\n    interArrivalSD?: number;\n}\n\ninterface MSLocalClientEventBase extends RTCStats {\n    networkBandwidthLowEventRatio?: number;\n    networkReceiveQualityEventRatio?: number;\n}\n\ninterface MSNetwork extends RTCStats {\n    delay?: MSDelay;\n    jitter?: MSJitter;\n    packetLoss?: MSPacketLoss;\n    utilization?: MSUtilization;\n}\n\ninterface MSNetworkConnectivityInfo {\n    linkspeed?: number;\n    networkConnectionDetails?: string;\n    vpn?: boolean;\n}\n\ninterface MSNetworkInterfaceType {\n    interfaceTypeEthernet?: boolean;\n    interfaceTypePPP?: boolean;\n    interfaceTypeTunnel?: boolean;\n    interfaceTypeWireless?: boolean;\n    interfaceTypeWWAN?: boolean;\n}\n\ninterface MSOutboundNetwork extends MSNetwork {\n    appliedBandwidthLimit?: number;\n}\n\ninterface MSPacketLoss {\n    lossRate?: number;\n    lossRateMax?: number;\n}\n\ninterface MSPayloadBase extends RTCStats {\n    payloadDescription?: string;\n}\n\ninterface MSPortRange {\n    max?: number;\n    min?: number;\n}\n\ninterface MSRelayAddress {\n    port?: number;\n    relayAddress?: string;\n}\n\ninterface MSSignatureParameters {\n    userPrompt?: string;\n}\n\ninterface MSTransportDiagnosticsStats extends RTCStats {\n    allocationTimeInMs?: number;\n    baseAddress?: string;\n    baseInterface?: MSNetworkInterfaceType;\n    iceRole?: RTCIceRole;\n    iceWarningFlags?: MSIceWarningFlags;\n    interfaces?: MSNetworkInterfaceType;\n    localAddress?: string;\n    localAddrType?: MSIceAddrType;\n    localInterface?: MSNetworkInterfaceType;\n    localMR?: string;\n    localMRTCPPort?: number;\n    localSite?: string;\n    msRtcEngineVersion?: string;\n    networkName?: string;\n    numConsentReqReceived?: number;\n    numConsentReqSent?: number;\n    numConsentRespReceived?: number;\n    numConsentRespSent?: number;\n    portRangeMax?: number;\n    portRangeMin?: number;\n    protocol?: RTCIceProtocol;\n    remoteAddress?: string;\n    remoteAddrType?: MSIceAddrType;\n    remoteMR?: string;\n    remoteMRTCPPort?: number;\n    remoteSite?: string;\n    rtpRtcpMux?: boolean;\n    stunVer?: number;\n}\n\ninterface MSUtilization {\n    bandwidthEstimation?: number;\n    bandwidthEstimationAvg?: number;\n    bandwidthEstimationMax?: number;\n    bandwidthEstimationMin?: number;\n    bandwidthEstimationStdDev?: number;\n    packets?: number;\n}\n\ninterface MSVideoPayload extends MSPayloadBase {\n    durationSeconds?: number;\n    resolution?: string;\n    videoBitRateAvg?: number;\n    videoBitRateMax?: number;\n    videoFrameRateAvg?: number;\n    videoPacketLossRate?: number;\n}\n\ninterface MSVideoRecvPayload extends MSVideoPayload {\n    lowBitRateCallPercent?: number;\n    lowFrameRateCallPercent?: number;\n    recvBitRateAverage?: number;\n    recvBitRateMaximum?: number;\n    recvCodecType?: string;\n    recvFpsHarmonicAverage?: number;\n    recvFrameRateAverage?: number;\n    recvNumResSwitches?: number;\n    recvReorderBufferMaxSuccessfullyOrderedExtent?: number;\n    recvReorderBufferMaxSuccessfullyOrderedLateTime?: number;\n    recvReorderBufferPacketsDroppedDueToBufferExhaustion?: number;\n    recvReorderBufferPacketsDroppedDueToTimeout?: number;\n    recvReorderBufferReorderedPackets?: number;\n    recvResolutionHeight?: number;\n    recvResolutionWidth?: number;\n    recvVideoStreamsMax?: number;\n    recvVideoStreamsMin?: number;\n    recvVideoStreamsMode?: number;\n    reorderBufferTotalPackets?: number;\n    videoFrameLossRate?: number;\n    videoPostFECPLR?: number;\n    videoResolutions?: MSVideoResolutionDistribution;\n}\n\ninterface MSVideoResolutionDistribution {\n    cifQuality?: number;\n    h1080Quality?: number;\n    h1440Quality?: number;\n    h2160Quality?: number;\n    h720Quality?: number;\n    vgaQuality?: number;\n}\n\ninterface MSVideoSendPayload extends MSVideoPayload {\n    sendBitRateAverage?: number;\n    sendBitRateMaximum?: number;\n    sendFrameRateAverage?: number;\n    sendResolutionHeight?: number;\n    sendResolutionWidth?: number;\n    sendVideoStreamsMax?: number;\n}\n\ninterface MsZoomToOptions {\n    animate?: string;\n    contentX?: number;\n    contentY?: number;\n    scaleFactor?: number;\n    viewportX?: string;\n    viewportY?: string;\n}\n\ninterface MutationObserverInit {\n    attributeFilter?: string[];\n    attributeOldValue?: boolean;\n    attributes?: boolean;\n    characterData?: boolean;\n    characterDataOldValue?: boolean;\n    childList?: boolean;\n    subtree?: boolean;\n}\n\ninterface NotificationOptions {\n    body?: string;\n    dir?: NotificationDirection;\n    icon?: string;\n    lang?: string;\n    tag?: string;\n}\n\ninterface ObjectURLOptions {\n    oneTimeOnly?: boolean;\n}\n\ninterface PaymentCurrencyAmount {\n    currency?: string;\n    currencySystem?: string;\n    value?: string;\n}\n\ninterface PaymentDetails {\n    displayItems?: PaymentItem[];\n    error?: string;\n    modifiers?: PaymentDetailsModifier[];\n    shippingOptions?: PaymentShippingOption[];\n    total?: PaymentItem;\n}\n\ninterface PaymentDetailsModifier {\n    additionalDisplayItems?: PaymentItem[];\n    data?: any;\n    supportedMethods?: string[];\n    total?: PaymentItem;\n}\n\ninterface PaymentItem {\n    amount?: PaymentCurrencyAmount;\n    label?: string;\n    pending?: boolean;\n}\n\ninterface PaymentMethodData {\n    data?: any;\n    supportedMethods?: string[];\n}\n\ninterface PaymentOptions {\n    requestPayerEmail?: boolean;\n    requestPayerName?: boolean;\n    requestPayerPhone?: boolean;\n    requestShipping?: boolean;\n    shippingType?: string;\n}\n\ninterface PaymentRequestUpdateEventInit extends EventInit {\n}\n\ninterface PaymentShippingOption {\n    amount?: PaymentCurrencyAmount;\n    id?: string;\n    label?: string;\n    selected?: boolean;\n}\n\ninterface PeriodicWaveConstraints {\n    disableNormalization?: boolean;\n}\n\ninterface PointerEventInit extends MouseEventInit {\n    height?: number;\n    isPrimary?: boolean;\n    pointerId?: number;\n    pointerType?: string;\n    pressure?: number;\n    tiltX?: number;\n    tiltY?: number;\n    width?: number;\n}\n\ninterface PopStateEventInit extends EventInit {\n    state?: any;\n}\n\ninterface PositionOptions {\n    enableHighAccuracy?: boolean;\n    maximumAge?: number;\n    timeout?: number;\n}\n\ninterface ProgressEventInit extends EventInit {\n    lengthComputable?: boolean;\n    loaded?: number;\n    total?: number;\n}\n\ninterface PushSubscriptionOptionsInit {\n    applicationServerKey?: any;\n    userVisibleOnly?: boolean;\n}\n\ninterface RegistrationOptions {\n    scope?: string;\n}\n\ninterface RequestInit {\n    body?: any;\n    cache?: RequestCache;\n    credentials?: RequestCredentials;\n    headers?: any;\n    integrity?: string;\n    keepalive?: boolean;\n    method?: string;\n    mode?: RequestMode;\n    redirect?: RequestRedirect;\n    referrer?: string;\n    referrerPolicy?: ReferrerPolicy;\n    window?: any;\n}\n\ninterface ResponseInit {\n    headers?: any;\n    status?: number;\n    statusText?: string;\n}\n\ninterface RTCConfiguration {\n    bundlePolicy?: RTCBundlePolicy;\n    iceServers?: RTCIceServer[];\n    iceTransportPolicy?: RTCIceTransportPolicy;\n    peerIdentity?: string;\n}\n\ninterface RTCDtlsFingerprint {\n    algorithm?: string;\n    value?: string;\n}\n\ninterface RTCDtlsParameters {\n    fingerprints?: RTCDtlsFingerprint[];\n    role?: RTCDtlsRole;\n}\n\ninterface RTCDTMFToneChangeEventInit extends EventInit {\n    tone?: string;\n}\n\ninterface RTCIceCandidateAttributes extends RTCStats {\n    addressSourceUrl?: string;\n    candidateType?: RTCStatsIceCandidateType;\n    ipAddress?: string;\n    portNumber?: number;\n    priority?: number;\n    transport?: string;\n}\n\ninterface RTCIceCandidateComplete {\n}\n\ninterface RTCIceCandidateDictionary {\n    foundation?: string;\n    ip?: string;\n    msMTurnSessionId?: string;\n    port?: number;\n    priority?: number;\n    protocol?: RTCIceProtocol;\n    relatedAddress?: string;\n    relatedPort?: number;\n    tcpType?: RTCIceTcpCandidateType;\n    type?: RTCIceCandidateType;\n}\n\ninterface RTCIceCandidateInit {\n    candidate?: string;\n    sdpMid?: string;\n    sdpMLineIndex?: number;\n}\n\ninterface RTCIceCandidatePair {\n    local?: RTCIceCandidateDictionary;\n    remote?: RTCIceCandidateDictionary;\n}\n\ninterface RTCIceCandidatePairStats extends RTCStats {\n    availableIncomingBitrate?: number;\n    availableOutgoingBitrate?: number;\n    bytesReceived?: number;\n    bytesSent?: number;\n    localCandidateId?: string;\n    nominated?: boolean;\n    priority?: number;\n    readable?: boolean;\n    remoteCandidateId?: string;\n    roundTripTime?: number;\n    state?: RTCStatsIceCandidatePairState;\n    transportId?: string;\n    writable?: boolean;\n}\n\ninterface RTCIceGatherOptions {\n    gatherPolicy?: RTCIceGatherPolicy;\n    iceservers?: RTCIceServer[];\n    portRange?: MSPortRange;\n}\n\ninterface RTCIceParameters {\n    iceLite?: boolean;\n    password?: string;\n    usernameFragment?: string;\n}\n\ninterface RTCIceServer {\n    credential?: string;\n    urls?: any;\n    username?: string;\n}\n\ninterface RTCInboundRTPStreamStats extends RTCRTPStreamStats {\n    bytesReceived?: number;\n    fractionLost?: number;\n    jitter?: number;\n    packetsLost?: number;\n    packetsReceived?: number;\n}\n\ninterface RTCMediaStreamTrackStats extends RTCStats {\n    audioLevel?: number;\n    echoReturnLoss?: number;\n    echoReturnLossEnhancement?: number;\n    frameHeight?: number;\n    framesCorrupted?: number;\n    framesDecoded?: number;\n    framesDropped?: number;\n    framesPerSecond?: number;\n    framesReceived?: number;\n    framesSent?: number;\n    frameWidth?: number;\n    remoteSource?: boolean;\n    ssrcIds?: string[];\n    trackIdentifier?: string;\n}\n\ninterface RTCOfferOptions {\n    iceRestart?: boolean;\n    offerToReceiveAudio?: number;\n    offerToReceiveVideo?: number;\n    voiceActivityDetection?: boolean;\n}\n\ninterface RTCOutboundRTPStreamStats extends RTCRTPStreamStats {\n    bytesSent?: number;\n    packetsSent?: number;\n    roundTripTime?: number;\n    targetBitrate?: number;\n}\n\ninterface RTCPeerConnectionIceEventInit extends EventInit {\n    candidate?: RTCIceCandidate;\n}\n\ninterface RTCRtcpFeedback {\n    parameter?: string;\n    type?: string;\n}\n\ninterface RTCRtcpParameters {\n    cname?: string;\n    mux?: boolean;\n    reducedSize?: boolean;\n    ssrc?: number;\n}\n\ninterface RTCRtpCapabilities {\n    codecs?: RTCRtpCodecCapability[];\n    fecMechanisms?: string[];\n    headerExtensions?: RTCRtpHeaderExtension[];\n}\n\ninterface RTCRtpCodecCapability {\n    clockRate?: number;\n    kind?: string;\n    maxptime?: number;\n    maxSpatialLayers?: number;\n    maxTemporalLayers?: number;\n    name?: string;\n    numChannels?: number;\n    options?: any;\n    parameters?: any;\n    preferredPayloadType?: number;\n    ptime?: number;\n    rtcpFeedback?: RTCRtcpFeedback[];\n    svcMultiStreamSupport?: boolean;\n}\n\ninterface RTCRtpCodecParameters {\n    clockRate?: number;\n    maxptime?: number;\n    name?: string;\n    numChannels?: number;\n    parameters?: any;\n    payloadType?: any;\n    ptime?: number;\n    rtcpFeedback?: RTCRtcpFeedback[];\n}\n\ninterface RTCRtpContributingSource {\n    audioLevel?: number;\n    csrc?: number;\n    timestamp?: number;\n}\n\ninterface RTCRtpEncodingParameters {\n    active?: boolean;\n    codecPayloadType?: number;\n    dependencyEncodingIds?: string[];\n    encodingId?: string;\n    fec?: RTCRtpFecParameters;\n    framerateScale?: number;\n    maxBitrate?: number;\n    maxFramerate?: number;\n    minQuality?: number;\n    priority?: number;\n    resolutionScale?: number;\n    rtx?: RTCRtpRtxParameters;\n    ssrc?: number;\n    ssrcRange?: RTCSsrcRange;\n}\n\ninterface RTCRtpFecParameters {\n    mechanism?: string;\n    ssrc?: number;\n}\n\ninterface RTCRtpHeaderExtension {\n    kind?: string;\n    preferredEncrypt?: boolean;\n    preferredId?: number;\n    uri?: string;\n}\n\ninterface RTCRtpHeaderExtensionParameters {\n    encrypt?: boolean;\n    id?: number;\n    uri?: string;\n}\n\ninterface RTCRtpParameters {\n    codecs?: RTCRtpCodecParameters[];\n    degradationPreference?: RTCDegradationPreference;\n    encodings?: RTCRtpEncodingParameters[];\n    headerExtensions?: RTCRtpHeaderExtensionParameters[];\n    muxId?: string;\n    rtcp?: RTCRtcpParameters;\n}\n\ninterface RTCRtpRtxParameters {\n    ssrc?: number;\n}\n\ninterface RTCRTPStreamStats extends RTCStats {\n    associateStatsId?: string;\n    codecId?: string;\n    firCount?: number;\n    isRemote?: boolean;\n    mediaTrackId?: string;\n    nackCount?: number;\n    pliCount?: number;\n    sliCount?: number;\n    ssrc?: string;\n    transportId?: string;\n}\n\ninterface RTCRtpUnhandled {\n    muxId?: string;\n    payloadType?: number;\n    ssrc?: number;\n}\n\ninterface RTCSessionDescriptionInit {\n    sdp?: string;\n    type?: RTCSdpType;\n}\n\ninterface RTCSrtpKeyParam {\n    keyMethod?: string;\n    keySalt?: string;\n    lifetime?: string;\n    mkiLength?: number;\n    mkiValue?: number;\n}\n\ninterface RTCSrtpSdesParameters {\n    cryptoSuite?: string;\n    keyParams?: RTCSrtpKeyParam[];\n    sessionParams?: string[];\n    tag?: number;\n}\n\ninterface RTCSsrcRange {\n    max?: number;\n    min?: number;\n}\n\ninterface RTCStats {\n    id?: string;\n    msType?: MSStatsType;\n    timestamp?: number;\n    type?: RTCStatsType;\n}\n\ninterface RTCStatsReport {\n}\n\ninterface RTCTransportStats extends RTCStats {\n    activeConnection?: boolean;\n    bytesReceived?: number;\n    bytesSent?: number;\n    localCertificateId?: string;\n    remoteCertificateId?: string;\n    rtcpTransportStatsId?: string;\n    selectedCandidatePairId?: string;\n}\n\ninterface ScopedCredentialDescriptor {\n    id?: any;\n    transports?: Transport[];\n    type?: ScopedCredentialType;\n}\n\ninterface ScopedCredentialOptions {\n    excludeList?: ScopedCredentialDescriptor[];\n    extensions?: WebAuthnExtensions;\n    rpId?: USVString;\n    timeoutSeconds?: number;\n}\n\ninterface ScopedCredentialParameters {\n    algorithm?: string | Algorithm;\n    type?: ScopedCredentialType;\n}\n\ninterface ServiceWorkerMessageEventInit extends EventInit {\n    data?: any;\n    lastEventId?: string;\n    origin?: string;\n    ports?: MessagePort[];\n    source?: ServiceWorker | MessagePort;\n}\n\ninterface SpeechSynthesisEventInit extends EventInit {\n    charIndex?: number;\n    elapsedTime?: number;\n    name?: string;\n    utterance?: SpeechSynthesisUtterance;\n}\n\ninterface StoreExceptionsInformation extends ExceptionInformation {\n    detailURI?: string;\n    explanationString?: string;\n    siteName?: string;\n}\n\ninterface StoreSiteSpecificExceptionsInformation extends StoreExceptionsInformation {\n    arrayOfDomainStrings?: string[];\n}\n\ninterface TrackEventInit extends EventInit {\n    track?: VideoTrack | AudioTrack | TextTrack;\n}\n\ninterface TransitionEventInit extends EventInit {\n    elapsedTime?: number;\n    propertyName?: string;\n}\n\ninterface UIEventInit extends EventInit {\n    detail?: number;\n    view?: Window;\n}\n\ninterface WebAuthnExtensions {\n}\n\ninterface WebGLContextAttributes {\n    failIfMajorPerformanceCaveat?: boolean;\n    alpha?: boolean;\n    antialias?: boolean;\n    depth?: boolean;\n    premultipliedAlpha?: boolean;\n    preserveDrawingBuffer?: boolean;\n    stencil?: boolean;\n}\n\ninterface WebGLContextEventInit extends EventInit {\n    statusMessage?: string;\n}\n\ninterface WheelEventInit extends MouseEventInit {\n    deltaMode?: number;\n    deltaX?: number;\n    deltaY?: number;\n    deltaZ?: number;\n}\n\ninterface EventListener {\n    (evt: Event): void;\n}\n\ninterface WebKitEntriesCallback {\n    (evt: Event): void;\n}\n\ninterface WebKitErrorCallback {\n    (evt: Event): void;\n}\n\ninterface WebKitFileCallback {\n    (evt: Event): void;\n}\n\ninterface AnalyserNode extends AudioNode {\n    fftSize: number;\n    readonly frequencyBinCount: number;\n    maxDecibels: number;\n    minDecibels: number;\n    smoothingTimeConstant: number;\n    getByteFrequencyData(array: Uint8Array): void;\n    getByteTimeDomainData(array: Uint8Array): void;\n    getFloatFrequencyData(array: Float32Array): void;\n    getFloatTimeDomainData(array: Float32Array): void;\n}\n\ndeclare var AnalyserNode: {\n    prototype: AnalyserNode;\n    new(): AnalyserNode;\n};\n\ninterface ANGLE_instanced_arrays {\n    drawArraysInstancedANGLE(mode: number, first: number, count: number, primcount: number): void;\n    drawElementsInstancedANGLE(mode: number, count: number, type: number, offset: number, primcount: number): void;\n    vertexAttribDivisorANGLE(index: number, divisor: number): void;\n    readonly VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE: number;\n}\n\ndeclare var ANGLE_instanced_arrays: {\n    prototype: ANGLE_instanced_arrays;\n    new(): ANGLE_instanced_arrays;\n    readonly VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE: number;\n};\n\ninterface AnimationEvent extends Event {\n    readonly animationName: string;\n    readonly elapsedTime: number;\n    initAnimationEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, animationNameArg: string, elapsedTimeArg: number): void;\n}\n\ndeclare var AnimationEvent: {\n    prototype: AnimationEvent;\n    new(typeArg: string, eventInitDict?: AnimationEventInit): AnimationEvent;\n};\n\ninterface ApplicationCacheEventMap {\n    \"cached\": Event;\n    \"checking\": Event;\n    \"downloading\": Event;\n    \"error\": Event;\n    \"noupdate\": Event;\n    \"obsolete\": Event;\n    \"progress\": ProgressEvent;\n    \"updateready\": Event;\n}\n\ninterface ApplicationCache extends EventTarget {\n    oncached: (this: ApplicationCache, ev: Event) => any;\n    onchecking: (this: ApplicationCache, ev: Event) => any;\n    ondownloading: (this: ApplicationCache, ev: Event) => any;\n    onerror: (this: ApplicationCache, ev: Event) => any;\n    onnoupdate: (this: ApplicationCache, ev: Event) => any;\n    onobsolete: (this: ApplicationCache, ev: Event) => any;\n    onprogress: (this: ApplicationCache, ev: ProgressEvent) => any;\n    onupdateready: (this: ApplicationCache, ev: Event) => any;\n    readonly status: number;\n    abort(): void;\n    swapCache(): void;\n    update(): void;\n    readonly CHECKING: number;\n    readonly DOWNLOADING: number;\n    readonly IDLE: number;\n    readonly OBSOLETE: number;\n    readonly UNCACHED: number;\n    readonly UPDATEREADY: number;\n    addEventListener<K extends keyof ApplicationCacheEventMap>(type: K, listener: (this: ApplicationCache, ev: ApplicationCacheEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var ApplicationCache: {\n    prototype: ApplicationCache;\n    new(): ApplicationCache;\n    readonly CHECKING: number;\n    readonly DOWNLOADING: number;\n    readonly IDLE: number;\n    readonly OBSOLETE: number;\n    readonly UNCACHED: number;\n    readonly UPDATEREADY: number;\n};\n\ninterface Attr extends Node {\n    readonly name: string;\n    readonly ownerElement: Element;\n    readonly prefix: string | null;\n    readonly specified: boolean;\n    value: string;\n}\n\ndeclare var Attr: {\n    prototype: Attr;\n    new(): Attr;\n};\n\ninterface AudioBuffer {\n    readonly duration: number;\n    readonly length: number;\n    readonly numberOfChannels: number;\n    readonly sampleRate: number;\n    copyFromChannel(destination: Float32Array, channelNumber: number, startInChannel?: number): void;\n    copyToChannel(source: Float32Array, channelNumber: number, startInChannel?: number): void;\n    getChannelData(channel: number): Float32Array;\n}\n\ndeclare var AudioBuffer: {\n    prototype: AudioBuffer;\n    new(): AudioBuffer;\n};\n\ninterface AudioBufferSourceNodeEventMap {\n    \"ended\": MediaStreamErrorEvent;\n}\n\ninterface AudioBufferSourceNode extends AudioNode {\n    buffer: AudioBuffer | null;\n    readonly detune: AudioParam;\n    loop: boolean;\n    loopEnd: number;\n    loopStart: number;\n    onended: (this: AudioBufferSourceNode, ev: MediaStreamErrorEvent) => any;\n    readonly playbackRate: AudioParam;\n    start(when?: number, offset?: number, duration?: number): void;\n    stop(when?: number): void;\n    addEventListener<K extends keyof AudioBufferSourceNodeEventMap>(type: K, listener: (this: AudioBufferSourceNode, ev: AudioBufferSourceNodeEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var AudioBufferSourceNode: {\n    prototype: AudioBufferSourceNode;\n    new(): AudioBufferSourceNode;\n};\n\ninterface AudioContextEventMap {\n    \"statechange\": Event;\n}\n\ninterface AudioContextBase extends EventTarget {\n    readonly currentTime: number;\n    readonly destination: AudioDestinationNode;\n    readonly listener: AudioListener;\n    onstatechange: (this: AudioContext, ev: Event) => any;\n    readonly sampleRate: number;\n    readonly state: AudioContextState;\n    close(): Promise<void>;\n    createAnalyser(): AnalyserNode;\n    createBiquadFilter(): BiquadFilterNode;\n    createBuffer(numberOfChannels: number, length: number, sampleRate: number): AudioBuffer;\n    createBufferSource(): AudioBufferSourceNode;\n    createChannelMerger(numberOfInputs?: number): ChannelMergerNode;\n    createChannelSplitter(numberOfOutputs?: number): ChannelSplitterNode;\n    createConvolver(): ConvolverNode;\n    createDelay(maxDelayTime?: number): DelayNode;\n    createDynamicsCompressor(): DynamicsCompressorNode;\n    createGain(): GainNode;\n    createIIRFilter(feedforward: number[], feedback: number[]): IIRFilterNode;\n    createMediaElementSource(mediaElement: HTMLMediaElement): MediaElementAudioSourceNode;\n    createMediaStreamSource(mediaStream: MediaStream): MediaStreamAudioSourceNode;\n    createOscillator(): OscillatorNode;\n    createPanner(): PannerNode;\n    createPeriodicWave(real: Float32Array, imag: Float32Array, constraints?: PeriodicWaveConstraints): PeriodicWave;\n    createScriptProcessor(bufferSize?: number, numberOfInputChannels?: number, numberOfOutputChannels?: number): ScriptProcessorNode;\n    createStereoPanner(): StereoPannerNode;\n    createWaveShaper(): WaveShaperNode;\n    decodeAudioData(audioData: ArrayBuffer, successCallback?: DecodeSuccessCallback, errorCallback?: DecodeErrorCallback): Promise<AudioBuffer>;\n    resume(): Promise<void>;\n    addEventListener<K extends keyof AudioContextEventMap>(type: K, listener: (this: AudioContext, ev: AudioContextEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ninterface AudioContext extends AudioContextBase {\n    suspend(): Promise<void>;\n}\n\ndeclare var AudioContext: {\n    prototype: AudioContext;\n    new(): AudioContext;\n};\n\ninterface AudioDestinationNode extends AudioNode {\n    readonly maxChannelCount: number;\n}\n\ndeclare var AudioDestinationNode: {\n    prototype: AudioDestinationNode;\n    new(): AudioDestinationNode;\n};\n\ninterface AudioListener {\n    dopplerFactor: number;\n    speedOfSound: number;\n    setOrientation(x: number, y: number, z: number, xUp: number, yUp: number, zUp: number): void;\n    setPosition(x: number, y: number, z: number): void;\n    setVelocity(x: number, y: number, z: number): void;\n}\n\ndeclare var AudioListener: {\n    prototype: AudioListener;\n    new(): AudioListener;\n};\n\ninterface AudioNode extends EventTarget {\n    channelCount: number;\n    channelCountMode: ChannelCountMode;\n    channelInterpretation: ChannelInterpretation;\n    readonly context: AudioContext;\n    readonly numberOfInputs: number;\n    readonly numberOfOutputs: number;\n    connect(destination: AudioNode, output?: number, input?: number): AudioNode;\n    connect(destination: AudioParam, output?: number): void;\n    disconnect(output?: number): void;\n    disconnect(destination: AudioNode, output?: number, input?: number): void;\n    disconnect(destination: AudioParam, output?: number): void;\n}\n\ndeclare var AudioNode: {\n    prototype: AudioNode;\n    new(): AudioNode;\n};\n\ninterface AudioParam {\n    readonly defaultValue: number;\n    value: number;\n    cancelScheduledValues(startTime: number): AudioParam;\n    exponentialRampToValueAtTime(value: number, endTime: number): AudioParam;\n    linearRampToValueAtTime(value: number, endTime: number): AudioParam;\n    setTargetAtTime(target: number, startTime: number, timeConstant: number): AudioParam;\n    setValueAtTime(value: number, startTime: number): AudioParam;\n    setValueCurveAtTime(values: Float32Array, startTime: number, duration: number): AudioParam;\n}\n\ndeclare var AudioParam: {\n    prototype: AudioParam;\n    new(): AudioParam;\n};\n\ninterface AudioProcessingEvent extends Event {\n    readonly inputBuffer: AudioBuffer;\n    readonly outputBuffer: AudioBuffer;\n    readonly playbackTime: number;\n}\n\ndeclare var AudioProcessingEvent: {\n    prototype: AudioProcessingEvent;\n    new(): AudioProcessingEvent;\n};\n\ninterface AudioTrack {\n    enabled: boolean;\n    readonly id: string;\n    kind: string;\n    readonly label: string;\n    language: string;\n    readonly sourceBuffer: SourceBuffer;\n}\n\ndeclare var AudioTrack: {\n    prototype: AudioTrack;\n    new(): AudioTrack;\n};\n\ninterface AudioTrackListEventMap {\n    \"addtrack\": TrackEvent;\n    \"change\": Event;\n    \"removetrack\": TrackEvent;\n}\n\ninterface AudioTrackList extends EventTarget {\n    readonly length: number;\n    onaddtrack: (this: AudioTrackList, ev: TrackEvent) => any;\n    onchange: (this: AudioTrackList, ev: Event) => any;\n    onremovetrack: (this: AudioTrackList, ev: TrackEvent) => any;\n    getTrackById(id: string): AudioTrack | null;\n    item(index: number): AudioTrack;\n    addEventListener<K extends keyof AudioTrackListEventMap>(type: K, listener: (this: AudioTrackList, ev: AudioTrackListEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n    [index: number]: AudioTrack;\n}\n\ndeclare var AudioTrackList: {\n    prototype: AudioTrackList;\n    new(): AudioTrackList;\n};\n\ninterface BarProp {\n    readonly visible: boolean;\n}\n\ndeclare var BarProp: {\n    prototype: BarProp;\n    new(): BarProp;\n};\n\ninterface BeforeUnloadEvent extends Event {\n    returnValue: any;\n}\n\ndeclare var BeforeUnloadEvent: {\n    prototype: BeforeUnloadEvent;\n    new(): BeforeUnloadEvent;\n};\n\ninterface BiquadFilterNode extends AudioNode {\n    readonly detune: AudioParam;\n    readonly frequency: AudioParam;\n    readonly gain: AudioParam;\n    readonly Q: AudioParam;\n    type: BiquadFilterType;\n    getFrequencyResponse(frequencyHz: Float32Array, magResponse: Float32Array, phaseResponse: Float32Array): void;\n}\n\ndeclare var BiquadFilterNode: {\n    prototype: BiquadFilterNode;\n    new(): BiquadFilterNode;\n};\n\ninterface Blob {\n    readonly size: number;\n    readonly type: string;\n    msClose(): void;\n    msDetachStream(): any;\n    slice(start?: number, end?: number, contentType?: string): Blob;\n}\n\ndeclare var Blob: {\n    prototype: Blob;\n    new (blobParts?: any[], options?: BlobPropertyBag): Blob;\n};\n\ninterface Cache {\n    add(request: RequestInfo): Promise<void>;\n    addAll(requests: RequestInfo[]): Promise<void>;\n    delete(request: RequestInfo, options?: CacheQueryOptions): Promise<boolean>;\n    keys(request?: RequestInfo, options?: CacheQueryOptions): any;\n    match(request: RequestInfo, options?: CacheQueryOptions): Promise<Response>;\n    matchAll(request?: RequestInfo, options?: CacheQueryOptions): any;\n    put(request: RequestInfo, response: Response): Promise<void>;\n}\n\ndeclare var Cache: {\n    prototype: Cache;\n    new(): Cache;\n};\n\ninterface CacheStorage {\n    delete(cacheName: string): Promise<boolean>;\n    has(cacheName: string): Promise<boolean>;\n    keys(): any;\n    match(request: RequestInfo, options?: CacheQueryOptions): Promise<any>;\n    open(cacheName: string): Promise<Cache>;\n}\n\ndeclare var CacheStorage: {\n    prototype: CacheStorage;\n    new(): CacheStorage;\n};\n\ninterface CanvasGradient {\n    addColorStop(offset: number, color: string): void;\n}\n\ndeclare var CanvasGradient: {\n    prototype: CanvasGradient;\n    new(): CanvasGradient;\n};\n\ninterface CanvasPattern {\n    setTransform(matrix: SVGMatrix): void;\n}\n\ndeclare var CanvasPattern: {\n    prototype: CanvasPattern;\n    new(): CanvasPattern;\n};\n\ninterface CanvasRenderingContext2D extends Object, CanvasPathMethods {\n    readonly canvas: HTMLCanvasElement;\n    fillStyle: string | CanvasGradient | CanvasPattern;\n    font: string;\n    globalAlpha: number;\n    globalCompositeOperation: string;\n    imageSmoothingEnabled: boolean;\n    lineCap: string;\n    lineDashOffset: number;\n    lineJoin: string;\n    lineWidth: number;\n    miterLimit: number;\n    msFillRule: CanvasFillRule;\n    shadowBlur: number;\n    shadowColor: string;\n    shadowOffsetX: number;\n    shadowOffsetY: number;\n    strokeStyle: string | CanvasGradient | CanvasPattern;\n    textAlign: string;\n    textBaseline: string;\n    mozImageSmoothingEnabled: boolean;\n    webkitImageSmoothingEnabled: boolean;\n    oImageSmoothingEnabled: boolean;\n    beginPath(): void;\n    clearRect(x: number, y: number, w: number, h: number): void;\n    clip(fillRule?: CanvasFillRule): void;\n    createImageData(imageDataOrSw: number | ImageData, sh?: number): ImageData;\n    createLinearGradient(x0: number, y0: number, x1: number, y1: number): CanvasGradient;\n    createPattern(image: HTMLImageElement | HTMLCanvasElement | HTMLVideoElement, repetition: string): CanvasPattern;\n    createRadialGradient(x0: number, y0: number, r0: number, x1: number, y1: number, r1: number): CanvasGradient;\n    drawFocusIfNeeded(element: Element): void;\n    drawImage(image: HTMLImageElement | HTMLCanvasElement | HTMLVideoElement | ImageBitmap, dstX: number, dstY: number): void;\n    drawImage(image: HTMLImageElement | HTMLCanvasElement | HTMLVideoElement | ImageBitmap, dstX: number, dstY: number, dstW: number, dstH: number): void;\n    drawImage(image: HTMLImageElement | HTMLCanvasElement | HTMLVideoElement | ImageBitmap, srcX: number, srcY: number, srcW: number, srcH: number, dstX: number, dstY: number, dstW: number, dstH: number): void;\n    fill(fillRule?: CanvasFillRule): void;\n    fillRect(x: number, y: number, w: number, h: number): void;\n    fillText(text: string, x: number, y: number, maxWidth?: number): void;\n    getImageData(sx: number, sy: number, sw: number, sh: number): ImageData;\n    getLineDash(): number[];\n    isPointInPath(x: number, y: number, fillRule?: CanvasFillRule): boolean;\n    measureText(text: string): TextMetrics;\n    putImageData(imagedata: ImageData, dx: number, dy: number, dirtyX?: number, dirtyY?: number, dirtyWidth?: number, dirtyHeight?: number): void;\n    restore(): void;\n    rotate(angle: number): void;\n    save(): void;\n    scale(x: number, y: number): void;\n    setLineDash(segments: number[]): void;\n    setTransform(m11: number, m12: number, m21: number, m22: number, dx: number, dy: number): void;\n    stroke(path?: Path2D): void;\n    strokeRect(x: number, y: number, w: number, h: number): void;\n    strokeText(text: string, x: number, y: number, maxWidth?: number): void;\n    transform(m11: number, m12: number, m21: number, m22: number, dx: number, dy: number): void;\n    translate(x: number, y: number): void;\n}\n\ndeclare var CanvasRenderingContext2D: {\n    prototype: CanvasRenderingContext2D;\n    new(): CanvasRenderingContext2D;\n};\n\ninterface CDATASection extends Text {\n}\n\ndeclare var CDATASection: {\n    prototype: CDATASection;\n    new(): CDATASection;\n};\n\ninterface ChannelMergerNode extends AudioNode {\n}\n\ndeclare var ChannelMergerNode: {\n    prototype: ChannelMergerNode;\n    new(): ChannelMergerNode;\n};\n\ninterface ChannelSplitterNode extends AudioNode {\n}\n\ndeclare var ChannelSplitterNode: {\n    prototype: ChannelSplitterNode;\n    new(): ChannelSplitterNode;\n};\n\ninterface CharacterData extends Node, ChildNode {\n    data: string;\n    readonly length: number;\n    appendData(arg: string): void;\n    deleteData(offset: number, count: number): void;\n    insertData(offset: number, arg: string): void;\n    replaceData(offset: number, count: number, arg: string): void;\n    substringData(offset: number, count: number): string;\n}\n\ndeclare var CharacterData: {\n    prototype: CharacterData;\n    new(): CharacterData;\n};\n\ninterface ClientRect {\n    bottom: number;\n    readonly height: number;\n    left: number;\n    right: number;\n    top: number;\n    readonly width: number;\n}\n\ndeclare var ClientRect: {\n    prototype: ClientRect;\n    new(): ClientRect;\n};\n\ninterface ClientRectList {\n    readonly length: number;\n    item(index: number): ClientRect;\n    [index: number]: ClientRect;\n}\n\ndeclare var ClientRectList: {\n    prototype: ClientRectList;\n    new(): ClientRectList;\n};\n\ninterface ClipboardEvent extends Event {\n    readonly clipboardData: DataTransfer;\n}\n\ndeclare var ClipboardEvent: {\n    prototype: ClipboardEvent;\n    new(type: string, eventInitDict?: ClipboardEventInit): ClipboardEvent;\n};\n\ninterface CloseEvent extends Event {\n    readonly code: number;\n    readonly reason: string;\n    readonly wasClean: boolean;\n    initCloseEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, wasCleanArg: boolean, codeArg: number, reasonArg: string): void;\n}\n\ndeclare var CloseEvent: {\n    prototype: CloseEvent;\n    new(typeArg: string, eventInitDict?: CloseEventInit): CloseEvent;\n};\n\ninterface Comment extends CharacterData {\n    text: string;\n}\n\ndeclare var Comment: {\n    prototype: Comment;\n    new(): Comment;\n};\n\ninterface CompositionEvent extends UIEvent {\n    readonly data: string;\n    readonly locale: string;\n    initCompositionEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, dataArg: string, locale: string): void;\n}\n\ndeclare var CompositionEvent: {\n    prototype: CompositionEvent;\n    new(typeArg: string, eventInitDict?: CompositionEventInit): CompositionEvent;\n};\n\ninterface Console {\n    assert(test?: boolean, message?: string, ...optionalParams: any[]): void;\n    clear(): void;\n    count(countTitle?: string): void;\n    debug(message?: any, ...optionalParams: any[]): void;\n    dir(value?: any, ...optionalParams: any[]): void;\n    dirxml(value: any): void;\n    error(message?: any, ...optionalParams: any[]): void;\n    exception(message?: string, ...optionalParams: any[]): void;\n    group(groupTitle?: string, ...optionalParams: any[]): void;\n    groupCollapsed(groupTitle?: string, ...optionalParams: any[]): void;\n    groupEnd(): void;\n    info(message?: any, ...optionalParams: any[]): void;\n    log(message?: any, ...optionalParams: any[]): void;\n    msIsIndependentlyComposed(element: Element): boolean;\n    profile(reportName?: string): void;\n    profileEnd(): void;\n    select(element: Element): void;\n    table(...data: any[]): void;\n    time(timerName?: string): void;\n    timeEnd(timerName?: string): void;\n    trace(message?: any, ...optionalParams: any[]): void;\n    warn(message?: any, ...optionalParams: any[]): void;\n}\n\ndeclare var Console: {\n    prototype: Console;\n    new(): Console;\n};\n\ninterface ConvolverNode extends AudioNode {\n    buffer: AudioBuffer | null;\n    normalize: boolean;\n}\n\ndeclare var ConvolverNode: {\n    prototype: ConvolverNode;\n    new(): ConvolverNode;\n};\n\ninterface Coordinates {\n    readonly accuracy: number;\n    readonly altitude: number | null;\n    readonly altitudeAccuracy: number | null;\n    readonly heading: number | null;\n    readonly latitude: number;\n    readonly longitude: number;\n    readonly speed: number | null;\n}\n\ndeclare var Coordinates: {\n    prototype: Coordinates;\n    new(): Coordinates;\n};\n\ninterface Crypto extends Object, RandomSource {\n    readonly subtle: SubtleCrypto;\n}\n\ndeclare var Crypto: {\n    prototype: Crypto;\n    new(): Crypto;\n};\n\ninterface CryptoKey {\n    readonly algorithm: KeyAlgorithm;\n    readonly extractable: boolean;\n    readonly type: string;\n    readonly usages: string[];\n}\n\ndeclare var CryptoKey: {\n    prototype: CryptoKey;\n    new(): CryptoKey;\n};\n\ninterface CryptoKeyPair {\n    privateKey: CryptoKey;\n    publicKey: CryptoKey;\n}\n\ndeclare var CryptoKeyPair: {\n    prototype: CryptoKeyPair;\n    new(): CryptoKeyPair;\n};\n\ninterface CSS {\n    supports(property: string, value?: string): boolean;\n}\ndeclare var CSS: CSS;\n\ninterface CSSConditionRule extends CSSGroupingRule {\n    conditionText: string;\n}\n\ndeclare var CSSConditionRule: {\n    prototype: CSSConditionRule;\n    new(): CSSConditionRule;\n};\n\ninterface CSSFontFaceRule extends CSSRule {\n    readonly style: CSSStyleDeclaration;\n}\n\ndeclare var CSSFontFaceRule: {\n    prototype: CSSFontFaceRule;\n    new(): CSSFontFaceRule;\n};\n\ninterface CSSGroupingRule extends CSSRule {\n    readonly cssRules: CSSRuleList;\n    deleteRule(index: number): void;\n    insertRule(rule: string, index: number): number;\n}\n\ndeclare var CSSGroupingRule: {\n    prototype: CSSGroupingRule;\n    new(): CSSGroupingRule;\n};\n\ninterface CSSImportRule extends CSSRule {\n    readonly href: string;\n    readonly media: MediaList;\n    readonly styleSheet: CSSStyleSheet;\n}\n\ndeclare var CSSImportRule: {\n    prototype: CSSImportRule;\n    new(): CSSImportRule;\n};\n\ninterface CSSKeyframeRule extends CSSRule {\n    keyText: string;\n    readonly style: CSSStyleDeclaration;\n}\n\ndeclare var CSSKeyframeRule: {\n    prototype: CSSKeyframeRule;\n    new(): CSSKeyframeRule;\n};\n\ninterface CSSKeyframesRule extends CSSRule {\n    readonly cssRules: CSSRuleList;\n    name: string;\n    appendRule(rule: string): void;\n    deleteRule(rule: string): void;\n    findRule(rule: string): CSSKeyframeRule;\n}\n\ndeclare var CSSKeyframesRule: {\n    prototype: CSSKeyframesRule;\n    new(): CSSKeyframesRule;\n};\n\ninterface CSSMediaRule extends CSSConditionRule {\n    readonly media: MediaList;\n}\n\ndeclare var CSSMediaRule: {\n    prototype: CSSMediaRule;\n    new(): CSSMediaRule;\n};\n\ninterface CSSNamespaceRule extends CSSRule {\n    readonly namespaceURI: string;\n    readonly prefix: string;\n}\n\ndeclare var CSSNamespaceRule: {\n    prototype: CSSNamespaceRule;\n    new(): CSSNamespaceRule;\n};\n\ninterface CSSPageRule extends CSSRule {\n    readonly pseudoClass: string;\n    readonly selector: string;\n    selectorText: string;\n    readonly style: CSSStyleDeclaration;\n}\n\ndeclare var CSSPageRule: {\n    prototype: CSSPageRule;\n    new(): CSSPageRule;\n};\n\ninterface CSSRule {\n    cssText: string;\n    readonly parentRule: CSSRule;\n    readonly parentStyleSheet: CSSStyleSheet;\n    readonly type: number;\n    readonly CHARSET_RULE: number;\n    readonly FONT_FACE_RULE: number;\n    readonly IMPORT_RULE: number;\n    readonly KEYFRAME_RULE: number;\n    readonly KEYFRAMES_RULE: number;\n    readonly MEDIA_RULE: number;\n    readonly NAMESPACE_RULE: number;\n    readonly PAGE_RULE: number;\n    readonly STYLE_RULE: number;\n    readonly SUPPORTS_RULE: number;\n    readonly UNKNOWN_RULE: number;\n    readonly VIEWPORT_RULE: number;\n}\n\ndeclare var CSSRule: {\n    prototype: CSSRule;\n    new(): CSSRule;\n    readonly CHARSET_RULE: number;\n    readonly FONT_FACE_RULE: number;\n    readonly IMPORT_RULE: number;\n    readonly KEYFRAME_RULE: number;\n    readonly KEYFRAMES_RULE: number;\n    readonly MEDIA_RULE: number;\n    readonly NAMESPACE_RULE: number;\n    readonly PAGE_RULE: number;\n    readonly STYLE_RULE: number;\n    readonly SUPPORTS_RULE: number;\n    readonly UNKNOWN_RULE: number;\n    readonly VIEWPORT_RULE: number;\n};\n\ninterface CSSRuleList {\n    readonly length: number;\n    item(index: number): CSSRule;\n    [index: number]: CSSRule;\n}\n\ndeclare var CSSRuleList: {\n    prototype: CSSRuleList;\n    new(): CSSRuleList;\n};\n\ninterface CSSStyleDeclaration {\n    alignContent: string | null;\n    alignItems: string | null;\n    alignmentBaseline: string | null;\n    alignSelf: string | null;\n    animation: string | null;\n    animationDelay: string | null;\n    animationDirection: string | null;\n    animationDuration: string | null;\n    animationFillMode: string | null;\n    animationIterationCount: string | null;\n    animationName: string | null;\n    animationPlayState: string | null;\n    animationTimingFunction: string | null;\n    backfaceVisibility: string | null;\n    background: string | null;\n    backgroundAttachment: string | null;\n    backgroundClip: string | null;\n    backgroundColor: string | null;\n    backgroundImage: string | null;\n    backgroundOrigin: string | null;\n    backgroundPosition: string | null;\n    backgroundPositionX: string | null;\n    backgroundPositionY: string | null;\n    backgroundRepeat: string | null;\n    backgroundSize: string | null;\n    baselineShift: string | null;\n    border: string | null;\n    borderBottom: string | null;\n    borderBottomColor: string | null;\n    borderBottomLeftRadius: string | null;\n    borderBottomRightRadius: string | null;\n    borderBottomStyle: string | null;\n    borderBottomWidth: string | null;\n    borderCollapse: string | null;\n    borderColor: string | null;\n    borderImage: string | null;\n    borderImageOutset: string | null;\n    borderImageRepeat: string | null;\n    borderImageSlice: string | null;\n    borderImageSource: string | null;\n    borderImageWidth: string | null;\n    borderLeft: string | null;\n    borderLeftColor: string | null;\n    borderLeftStyle: string | null;\n    borderLeftWidth: string | null;\n    borderRadius: string | null;\n    borderRight: string | null;\n    borderRightColor: string | null;\n    borderRightStyle: string | null;\n    borderRightWidth: string | null;\n    borderSpacing: string | null;\n    borderStyle: string | null;\n    borderTop: string | null;\n    borderTopColor: string | null;\n    borderTopLeftRadius: string | null;\n    borderTopRightRadius: string | null;\n    borderTopStyle: string | null;\n    borderTopWidth: string | null;\n    borderWidth: string | null;\n    bottom: string | null;\n    boxShadow: string | null;\n    boxSizing: string | null;\n    breakAfter: string | null;\n    breakBefore: string | null;\n    breakInside: string | null;\n    captionSide: string | null;\n    clear: string | null;\n    clip: string | null;\n    clipPath: string | null;\n    clipRule: string | null;\n    color: string | null;\n    colorInterpolationFilters: string | null;\n    columnCount: any;\n    columnFill: string | null;\n    columnGap: any;\n    columnRule: string | null;\n    columnRuleColor: any;\n    columnRuleStyle: string | null;\n    columnRuleWidth: any;\n    columns: string | null;\n    columnSpan: string | null;\n    columnWidth: any;\n    content: string | null;\n    counterIncrement: string | null;\n    counterReset: string | null;\n    cssFloat: string | null;\n    cssText: string;\n    cursor: string | null;\n    direction: string | null;\n    display: string | null;\n    dominantBaseline: string | null;\n    emptyCells: string | null;\n    enableBackground: string | null;\n    fill: string | null;\n    fillOpacity: string | null;\n    fillRule: string | null;\n    filter: string | null;\n    flex: string | null;\n    flexBasis: string | null;\n    flexDirection: string | null;\n    flexFlow: string | null;\n    flexGrow: string | null;\n    flexShrink: string | null;\n    flexWrap: string | null;\n    floodColor: string | null;\n    floodOpacity: string | null;\n    font: string | null;\n    fontFamily: string | null;\n    fontFeatureSettings: string | null;\n    fontSize: string | null;\n    fontSizeAdjust: string | null;\n    fontStretch: string | null;\n    fontStyle: string | null;\n    fontVariant: string | null;\n    fontWeight: string | null;\n    glyphOrientationHorizontal: string | null;\n    glyphOrientationVertical: string | null;\n    height: string | null;\n    imeMode: string | null;\n    justifyContent: string | null;\n    kerning: string | null;\n    layoutGrid: string | null;\n    layoutGridChar: string | null;\n    layoutGridLine: string | null;\n    layoutGridMode: string | null;\n    layoutGridType: string | null;\n    left: string | null;\n    readonly length: number;\n    letterSpacing: string | null;\n    lightingColor: string | null;\n    lineBreak: string | null;\n    lineHeight: string | null;\n    listStyle: string | null;\n    listStyleImage: string | null;\n    listStylePosition: string | null;\n    listStyleType: string | null;\n    margin: string | null;\n    marginBottom: string | null;\n    marginLeft: string | null;\n    marginRight: string | null;\n    marginTop: string | null;\n    marker: string | null;\n    markerEnd: string | null;\n    markerMid: string | null;\n    markerStart: string | null;\n    mask: string | null;\n    maxHeight: string | null;\n    maxWidth: string | null;\n    minHeight: string | null;\n    minWidth: string | null;\n    msContentZoomChaining: string | null;\n    msContentZooming: string | null;\n    msContentZoomLimit: string | null;\n    msContentZoomLimitMax: any;\n    msContentZoomLimitMin: any;\n    msContentZoomSnap: string | null;\n    msContentZoomSnapPoints: string | null;\n    msContentZoomSnapType: string | null;\n    msFlowFrom: string | null;\n    msFlowInto: string | null;\n    msFontFeatureSettings: string | null;\n    msGridColumn: any;\n    msGridColumnAlign: string | null;\n    msGridColumns: string | null;\n    msGridColumnSpan: any;\n    msGridRow: any;\n    msGridRowAlign: string | null;\n    msGridRows: string | null;\n    msGridRowSpan: any;\n    msHighContrastAdjust: string | null;\n    msHyphenateLimitChars: string | null;\n    msHyphenateLimitLines: any;\n    msHyphenateLimitZone: any;\n    msHyphens: string | null;\n    msImeAlign: string | null;\n    msOverflowStyle: string | null;\n    msScrollChaining: string | null;\n    msScrollLimit: string | null;\n    msScrollLimitXMax: any;\n    msScrollLimitXMin: any;\n    msScrollLimitYMax: any;\n    msScrollLimitYMin: any;\n    msScrollRails: string | null;\n    msScrollSnapPointsX: string | null;\n    msScrollSnapPointsY: string | null;\n    msScrollSnapType: string | null;\n    msScrollSnapX: string | null;\n    msScrollSnapY: string | null;\n    msScrollTranslation: string | null;\n    msTextCombineHorizontal: string | null;\n    msTextSizeAdjust: any;\n    msTouchAction: string | null;\n    msTouchSelect: string | null;\n    msUserSelect: string | null;\n    msWrapFlow: string;\n    msWrapMargin: any;\n    msWrapThrough: string;\n    opacity: string | null;\n    order: string | null;\n    orphans: string | null;\n    outline: string | null;\n    outlineColor: string | null;\n    outlineOffset: string | null;\n    outlineStyle: string | null;\n    outlineWidth: string | null;\n    overflow: string | null;\n    overflowX: string | null;\n    overflowY: string | null;\n    padding: string | null;\n    paddingBottom: string | null;\n    paddingLeft: string | null;\n    paddingRight: string | null;\n    paddingTop: string | null;\n    pageBreakAfter: string | null;\n    pageBreakBefore: string | null;\n    pageBreakInside: string | null;\n    readonly parentRule: CSSRule;\n    perspective: string | null;\n    perspectiveOrigin: string | null;\n    pointerEvents: string | null;\n    position: string | null;\n    quotes: string | null;\n    right: string | null;\n    rotate: string | null;\n    rubyAlign: string | null;\n    rubyOverhang: string | null;\n    rubyPosition: string | null;\n    scale: string | null;\n    stopColor: string | null;\n    stopOpacity: string | null;\n    stroke: string | null;\n    strokeDasharray: string | null;\n    strokeDashoffset: string | null;\n    strokeLinecap: string | null;\n    strokeLinejoin: string | null;\n    strokeMiterlimit: string | null;\n    strokeOpacity: string | null;\n    strokeWidth: string | null;\n    tableLayout: string | null;\n    textAlign: string | null;\n    textAlignLast: string | null;\n    textAnchor: string | null;\n    textDecoration: string | null;\n    textIndent: string | null;\n    textJustify: string | null;\n    textKashida: string | null;\n    textKashidaSpace: string | null;\n    textOverflow: string | null;\n    textShadow: string | null;\n    textTransform: string | null;\n    textUnderlinePosition: string | null;\n    top: string | null;\n    touchAction: string | null;\n    transform: string | null;\n    transformOrigin: string | null;\n    transformStyle: string | null;\n    transition: string | null;\n    transitionDelay: string | null;\n    transitionDuration: string | null;\n    transitionProperty: string | null;\n    transitionTimingFunction: string | null;\n    translate: string | null;\n    unicodeBidi: string | null;\n    verticalAlign: string | null;\n    visibility: string | null;\n    webkitAlignContent: string | null;\n    webkitAlignItems: string | null;\n    webkitAlignSelf: string | null;\n    webkitAnimation: string | null;\n    webkitAnimationDelay: string | null;\n    webkitAnimationDirection: string | null;\n    webkitAnimationDuration: string | null;\n    webkitAnimationFillMode: string | null;\n    webkitAnimationIterationCount: string | null;\n    webkitAnimationName: string | null;\n    webkitAnimationPlayState: string | null;\n    webkitAnimationTimingFunction: string | null;\n    webkitAppearance: string | null;\n    webkitBackfaceVisibility: string | null;\n    webkitBackgroundClip: string | null;\n    webkitBackgroundOrigin: string | null;\n    webkitBackgroundSize: string | null;\n    webkitBorderBottomLeftRadius: string | null;\n    webkitBorderBottomRightRadius: string | null;\n    webkitBorderImage: string | null;\n    webkitBorderRadius: string | null;\n    webkitBorderTopLeftRadius: string | null;\n    webkitBorderTopRightRadius: string | null;\n    webkitBoxAlign: string | null;\n    webkitBoxDirection: string | null;\n    webkitBoxFlex: string | null;\n    webkitBoxOrdinalGroup: string | null;\n    webkitBoxOrient: string | null;\n    webkitBoxPack: string | null;\n    webkitBoxSizing: string | null;\n    webkitColumnBreakAfter: string | null;\n    webkitColumnBreakBefore: string | null;\n    webkitColumnBreakInside: string | null;\n    webkitColumnCount: any;\n    webkitColumnGap: any;\n    webkitColumnRule: string | null;\n    webkitColumnRuleColor: any;\n    webkitColumnRuleStyle: string | null;\n    webkitColumnRuleWidth: any;\n    webkitColumns: string | null;\n    webkitColumnSpan: string | null;\n    webkitColumnWidth: any;\n    webkitFilter: string | null;\n    webkitFlex: string | null;\n    webkitFlexBasis: string | null;\n    webkitFlexDirection: string | null;\n    webkitFlexFlow: string | null;\n    webkitFlexGrow: string | null;\n    webkitFlexShrink: string | null;\n    webkitFlexWrap: string | null;\n    webkitJustifyContent: string | null;\n    webkitOrder: string | null;\n    webkitPerspective: string | null;\n    webkitPerspectiveOrigin: string | null;\n    webkitTapHighlightColor: string | null;\n    webkitTextFillColor: string | null;\n    webkitTextSizeAdjust: any;\n    webkitTextStroke: string | null;\n    webkitTextStrokeColor: string | null;\n    webkitTextStrokeWidth: string | null;\n    webkitTransform: string | null;\n    webkitTransformOrigin: string | null;\n    webkitTransformStyle: string | null;\n    webkitTransition: string | null;\n    webkitTransitionDelay: string | null;\n    webkitTransitionDuration: string | null;\n    webkitTransitionProperty: string | null;\n    webkitTransitionTimingFunction: string | null;\n    webkitUserModify: string | null;\n    webkitUserSelect: string | null;\n    webkitWritingMode: string | null;\n    whiteSpace: string | null;\n    widows: string | null;\n    width: string | null;\n    wordBreak: string | null;\n    wordSpacing: string | null;\n    wordWrap: string | null;\n    writingMode: string | null;\n    zIndex: string | null;\n    zoom: string | null;\n    resize: string | null;\n    userSelect: string | null;\n    getPropertyPriority(propertyName: string): string;\n    getPropertyValue(propertyName: string): string;\n    item(index: number): string;\n    removeProperty(propertyName: string): string;\n    setProperty(propertyName: string, value: string | null, priority?: string): void;\n    [index: number]: string;\n}\n\ndeclare var CSSStyleDeclaration: {\n    prototype: CSSStyleDeclaration;\n    new(): CSSStyleDeclaration;\n};\n\ninterface CSSStyleRule extends CSSRule {\n    readonly readOnly: boolean;\n    selectorText: string;\n    readonly style: CSSStyleDeclaration;\n}\n\ndeclare var CSSStyleRule: {\n    prototype: CSSStyleRule;\n    new(): CSSStyleRule;\n};\n\ninterface CSSStyleSheet extends StyleSheet {\n    readonly cssRules: CSSRuleList;\n    cssText: string;\n    readonly id: string;\n    readonly imports: StyleSheetList;\n    readonly isAlternate: boolean;\n    readonly isPrefAlternate: boolean;\n    readonly ownerRule: CSSRule;\n    readonly owningElement: Element;\n    readonly pages: StyleSheetPageList;\n    readonly readOnly: boolean;\n    readonly rules: CSSRuleList;\n    addImport(bstrURL: string, lIndex?: number): number;\n    addPageRule(bstrSelector: string, bstrStyle: string, lIndex?: number): number;\n    addRule(bstrSelector: string, bstrStyle?: string, lIndex?: number): number;\n    deleteRule(index?: number): void;\n    insertRule(rule: string, index?: number): number;\n    removeImport(lIndex: number): void;\n    removeRule(lIndex: number): void;\n}\n\ndeclare var CSSStyleSheet: {\n    prototype: CSSStyleSheet;\n    new(): CSSStyleSheet;\n};\n\ninterface CSSSupportsRule extends CSSConditionRule {\n}\n\ndeclare var CSSSupportsRule: {\n    prototype: CSSSupportsRule;\n    new(): CSSSupportsRule;\n};\n\ninterface CustomEvent extends Event {\n    readonly detail: any;\n    initCustomEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, detailArg: any): void;\n}\n\ndeclare var CustomEvent: {\n    prototype: CustomEvent;\n    new(typeArg: string, eventInitDict?: CustomEventInit): CustomEvent;\n};\n\ninterface DataCue extends TextTrackCue {\n    data: ArrayBuffer;\n    addEventListener<K extends keyof TextTrackCueEventMap>(type: K, listener: (this: DataCue, ev: TextTrackCueEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var DataCue: {\n    prototype: DataCue;\n    new(): DataCue;\n};\n\ninterface DataTransfer {\n    dropEffect: string;\n    effectAllowed: string;\n    readonly files: FileList;\n    readonly items: DataTransferItemList;\n    readonly types: string[];\n    clearData(format?: string): boolean;\n    getData(format: string): string;\n    setData(format: string, data: string): boolean;\n    setDragImage(image: Element, x: number, y: number): void;\n}\n\ndeclare var DataTransfer: {\n    prototype: DataTransfer;\n    new(): DataTransfer;\n};\n\ninterface DataTransferItem {\n    readonly kind: string;\n    readonly type: string;\n    getAsFile(): File | null;\n    getAsString(_callback: FunctionStringCallback | null): void;\n    webkitGetAsEntry(): any;\n}\n\ndeclare var DataTransferItem: {\n    prototype: DataTransferItem;\n    new(): DataTransferItem;\n};\n\ninterface DataTransferItemList {\n    readonly length: number;\n    add(data: File): DataTransferItem | null;\n    clear(): void;\n    item(index: number): DataTransferItem;\n    remove(index: number): void;\n    [index: number]: DataTransferItem;\n}\n\ndeclare var DataTransferItemList: {\n    prototype: DataTransferItemList;\n    new(): DataTransferItemList;\n};\n\ninterface DeferredPermissionRequest {\n    readonly id: number;\n    readonly type: MSWebViewPermissionType;\n    readonly uri: string;\n    allow(): void;\n    deny(): void;\n}\n\ndeclare var DeferredPermissionRequest: {\n    prototype: DeferredPermissionRequest;\n    new(): DeferredPermissionRequest;\n};\n\ninterface DelayNode extends AudioNode {\n    readonly delayTime: AudioParam;\n}\n\ndeclare var DelayNode: {\n    prototype: DelayNode;\n    new(): DelayNode;\n};\n\ninterface DeviceAcceleration {\n    readonly x: number | null;\n    readonly y: number | null;\n    readonly z: number | null;\n}\n\ndeclare var DeviceAcceleration: {\n    prototype: DeviceAcceleration;\n    new(): DeviceAcceleration;\n};\n\ninterface DeviceLightEvent extends Event {\n    readonly value: number;\n}\n\ndeclare var DeviceLightEvent: {\n    prototype: DeviceLightEvent;\n    new(typeArg: string, eventInitDict?: DeviceLightEventInit): DeviceLightEvent;\n};\n\ninterface DeviceMotionEvent extends Event {\n    readonly acceleration: DeviceAcceleration | null;\n    readonly accelerationIncludingGravity: DeviceAcceleration | null;\n    readonly interval: number | null;\n    readonly rotationRate: DeviceRotationRate | null;\n    initDeviceMotionEvent(type: string, bubbles: boolean, cancelable: boolean, acceleration: DeviceAccelerationDict | null, accelerationIncludingGravity: DeviceAccelerationDict | null, rotationRate: DeviceRotationRateDict | null, interval: number | null): void;\n}\n\ndeclare var DeviceMotionEvent: {\n    prototype: DeviceMotionEvent;\n    new(typeArg: string, eventInitDict?: DeviceMotionEventInit): DeviceMotionEvent;\n};\n\ninterface DeviceOrientationEvent extends Event {\n    readonly absolute: boolean;\n    readonly alpha: number | null;\n    readonly beta: number | null;\n    readonly gamma: number | null;\n    initDeviceOrientationEvent(type: string, bubbles: boolean, cancelable: boolean, alpha: number | null, beta: number | null, gamma: number | null, absolute: boolean): void;\n}\n\ndeclare var DeviceOrientationEvent: {\n    prototype: DeviceOrientationEvent;\n    new(typeArg: string, eventInitDict?: DeviceOrientationEventInit): DeviceOrientationEvent;\n};\n\ninterface DeviceRotationRate {\n    readonly alpha: number | null;\n    readonly beta: number | null;\n    readonly gamma: number | null;\n}\n\ndeclare var DeviceRotationRate: {\n    prototype: DeviceRotationRate;\n    new(): DeviceRotationRate;\n};\n\ninterface DocumentEventMap extends GlobalEventHandlersEventMap {\n    \"abort\": UIEvent;\n    \"activate\": UIEvent;\n    \"beforeactivate\": UIEvent;\n    \"beforedeactivate\": UIEvent;\n    \"blur\": FocusEvent;\n    \"canplay\": Event;\n    \"canplaythrough\": Event;\n    \"change\": Event;\n    \"click\": MouseEvent;\n    \"contextmenu\": PointerEvent;\n    \"dblclick\": MouseEvent;\n    \"deactivate\": UIEvent;\n    \"drag\": DragEvent;\n    \"dragend\": DragEvent;\n    \"dragenter\": DragEvent;\n    \"dragleave\": DragEvent;\n    \"dragover\": DragEvent;\n    \"dragstart\": DragEvent;\n    \"drop\": DragEvent;\n    \"durationchange\": Event;\n    \"emptied\": Event;\n    \"ended\": MediaStreamErrorEvent;\n    \"error\": ErrorEvent;\n    \"focus\": FocusEvent;\n    \"fullscreenchange\": Event;\n    \"fullscreenerror\": Event;\n    \"input\": Event;\n    \"invalid\": Event;\n    \"keydown\": KeyboardEvent;\n    \"keypress\": KeyboardEvent;\n    \"keyup\": KeyboardEvent;\n    \"load\": Event;\n    \"loadeddata\": Event;\n    \"loadedmetadata\": Event;\n    \"loadstart\": Event;\n    \"mousedown\": MouseEvent;\n    \"mousemove\": MouseEvent;\n    \"mouseout\": MouseEvent;\n    \"mouseover\": MouseEvent;\n    \"mouseup\": MouseEvent;\n    \"mousewheel\": WheelEvent;\n    \"MSContentZoom\": UIEvent;\n    \"MSGestureChange\": MSGestureEvent;\n    \"MSGestureDoubleTap\": MSGestureEvent;\n    \"MSGestureEnd\": MSGestureEvent;\n    \"MSGestureHold\": MSGestureEvent;\n    \"MSGestureStart\": MSGestureEvent;\n    \"MSGestureTap\": MSGestureEvent;\n    \"MSInertiaStart\": MSGestureEvent;\n    \"MSManipulationStateChanged\": MSManipulationEvent;\n    \"MSPointerCancel\": MSPointerEvent;\n    \"MSPointerDown\": MSPointerEvent;\n    \"MSPointerEnter\": MSPointerEvent;\n    \"MSPointerLeave\": MSPointerEvent;\n    \"MSPointerMove\": MSPointerEvent;\n    \"MSPointerOut\": MSPointerEvent;\n    \"MSPointerOver\": MSPointerEvent;\n    \"MSPointerUp\": MSPointerEvent;\n    \"mssitemodejumplistitemremoved\": MSSiteModeEvent;\n    \"msthumbnailclick\": MSSiteModeEvent;\n    \"pause\": Event;\n    \"play\": Event;\n    \"playing\": Event;\n    \"pointerlockchange\": Event;\n    \"pointerlockerror\": Event;\n    \"progress\": ProgressEvent;\n    \"ratechange\": Event;\n    \"readystatechange\": Event;\n    \"reset\": Event;\n    \"scroll\": UIEvent;\n    \"seeked\": Event;\n    \"seeking\": Event;\n    \"select\": UIEvent;\n    \"selectionchange\": Event;\n    \"selectstart\": Event;\n    \"stalled\": Event;\n    \"stop\": Event;\n    \"submit\": Event;\n    \"suspend\": Event;\n    \"timeupdate\": Event;\n    \"touchcancel\": TouchEvent;\n    \"touchend\": TouchEvent;\n    \"touchmove\": TouchEvent;\n    \"touchstart\": TouchEvent;\n    \"volumechange\": Event;\n    \"waiting\": Event;\n    \"webkitfullscreenchange\": Event;\n    \"webkitfullscreenerror\": Event;\n}\n\ninterface Document extends Node, GlobalEventHandlers, NodeSelector, DocumentEvent, ParentNode, DocumentOrShadowRoot {\n    /**\n     * Gets the object that has the focus when the parent document has focus.\n     */\n    readonly activeElement: Element;\n    /**\n     * Sets or gets the color of all active links in the document.\n     */\n    alinkColor: string;\n    /**\n     * Returns a reference to the collection of elements contained by the object.\n     */\n    readonly all: HTMLAllCollection;\n    /**\n     * Retrieves a collection of all a objects that have a name and/or id property. Objects in this collection are in HTML source order.\n     */\n    anchors: HTMLCollectionOf<HTMLAnchorElement>;\n    /**\n     * Retrieves a collection of all applet objects in the document.\n     */\n    applets: HTMLCollectionOf<HTMLAppletElement>;\n    /**\n     * Deprecated. Sets or retrieves a value that indicates the background color behind the object.\n     */\n    bgColor: string;\n    /**\n     * Specifies the beginning and end of the document body.\n     */\n    body: HTMLElement;\n    readonly characterSet: string;\n    /**\n     * Gets or sets the character set used to encode the object.\n     */\n    charset: string;\n    /**\n     * Gets a value that indicates whether standards-compliant mode is switched on for the object.\n     */\n    readonly compatMode: string;\n    cookie: string;\n    readonly currentScript: HTMLScriptElement | SVGScriptElement;\n    readonly defaultView: Window;\n    /**\n     * Sets or gets a value that indicates whether the document can be edited.\n     */\n    designMode: string;\n    /**\n     * Sets or retrieves a value that indicates the reading order of the object.\n     */\n    dir: string;\n    /**\n     * Gets an object representing the document type declaration associated with the current document.\n     */\n    readonly doctype: DocumentType;\n    /**\n     * Gets a reference to the root node of the document.\n     */\n    documentElement: HTMLElement;\n    /**\n     * Sets or gets the security domain of the document.\n     */\n    domain: string;\n    /**\n     * Retrieves a collection of all embed objects in the document.\n     */\n    embeds: HTMLCollectionOf<HTMLEmbedElement>;\n    /**\n     * Sets or gets the foreground (text) color of the document.\n     */\n    fgColor: string;\n    /**\n     * Retrieves a collection, in source order, of all form objects in the document.\n     */\n    forms: HTMLCollectionOf<HTMLFormElement>;\n    readonly fullscreenElement: Element | null;\n    readonly fullscreenEnabled: boolean;\n    readonly head: HTMLHeadElement;\n    readonly hidden: boolean;\n    /**\n     * Retrieves a collection, in source order, of img objects in the document.\n     */\n    images: HTMLCollectionOf<HTMLImageElement>;\n    /**\n     * Gets the implementation object of the current document.\n     */\n    readonly implementation: DOMImplementation;\n    /**\n     * Returns the character encoding used to create the webpage that is loaded into the document object.\n     */\n    readonly inputEncoding: string | null;\n    /**\n     * Gets the date that the page was last modified, if the page supplies one.\n     */\n    readonly lastModified: string;\n    /**\n     * Sets or gets the color of the document links.\n     */\n    linkColor: string;\n    /**\n     * Retrieves a collection of all a objects that specify the href property and all area objects in the document.\n     */\n    links: HTMLCollectionOf<HTMLAnchorElement | HTMLAreaElement>;\n    /**\n     * Contains information about the current URL.\n     */\n    readonly location: Location;\n    msCapsLockWarningOff: boolean;\n    msCSSOMElementFloatMetrics: boolean;\n    /**\n     * Fires when the user aborts the download.\n     * @param ev The event.\n     */\n    onabort: (this: Document, ev: UIEvent) => any;\n    /**\n     * Fires when the object is set as the active element.\n     * @param ev The event.\n     */\n    onactivate: (this: Document, ev: UIEvent) => any;\n    /**\n     * Fires immediately before the object is set as the active element.\n     * @param ev The event.\n     */\n    onbeforeactivate: (this: Document, ev: UIEvent) => any;\n    /**\n     * Fires immediately before the activeElement is changed from the current object to another object in the parent document.\n     * @param ev The event.\n     */\n    onbeforedeactivate: (this: Document, ev: UIEvent) => any;\n    /**\n     * Fires when the object loses the input focus.\n     * @param ev The focus event.\n     */\n    onblur: (this: Document, ev: FocusEvent) => any;\n    /**\n     * Occurs when playback is possible, but would require further buffering.\n     * @param ev The event.\n     */\n    oncanplay: (this: Document, ev: Event) => any;\n    oncanplaythrough: (this: Document, ev: Event) => any;\n    /**\n     * Fires when the contents of the object or selection have changed.\n     * @param ev The event.\n     */\n    onchange: (this: Document, ev: Event) => any;\n    /**\n     * Fires when the user clicks the left mouse button on the object\n     * @param ev The mouse event.\n     */\n    onclick: (this: Document, ev: MouseEvent) => any;\n    /**\n     * Fires when the user clicks the right mouse button in the client area, opening the context menu.\n     * @param ev The mouse event.\n     */\n    oncontextmenu: (this: Document, ev: PointerEvent) => any;\n    /**\n     * Fires when the user double-clicks the object.\n     * @param ev The mouse event.\n     */\n    ondblclick: (this: Document, ev: MouseEvent) => any;\n    /**\n     * Fires when the activeElement is changed from the current object to another object in the parent document.\n     * @param ev The UI Event\n     */\n    ondeactivate: (this: Document, ev: UIEvent) => any;\n    /**\n     * Fires on the source object continuously during a drag operation.\n     * @param ev The event.\n     */\n    ondrag: (this: Document, ev: DragEvent) => any;\n    /**\n     * Fires on the source object when the user releases the mouse at the close of a drag operation.\n     * @param ev The event.\n     */\n    ondragend: (this: Document, ev: DragEvent) => any;\n    /**\n     * Fires on the target element when the user drags the object to a valid drop target.\n     * @param ev The drag event.\n     */\n    ondragenter: (this: Document, ev: DragEvent) => any;\n    /**\n     * Fires on the target object when the user moves the mouse out of a valid drop target during a drag operation.\n     * @param ev The drag event.\n     */\n    ondragleave: (this: Document, ev: DragEvent) => any;\n    /**\n     * Fires on the target element continuously while the user drags the object over a valid drop target.\n     * @param ev The event.\n     */\n    ondragover: (this: Document, ev: DragEvent) => any;\n    /**\n     * Fires on the source object when the user starts to drag a text selection or selected object.\n     * @param ev The event.\n     */\n    ondragstart: (this: Document, ev: DragEvent) => any;\n    ondrop: (this: Document, ev: DragEvent) => any;\n    /**\n     * Occurs when the duration attribute is updated.\n     * @param ev The event.\n     */\n    ondurationchange: (this: Document, ev: Event) => any;\n    /**\n     * Occurs when the media element is reset to its initial state.\n     * @param ev The event.\n     */\n    onemptied: (this: Document, ev: Event) => any;\n    /**\n     * Occurs when the end of playback is reached.\n     * @param ev The event\n     */\n    onended: (this: Document, ev: MediaStreamErrorEvent) => any;\n    /**\n     * Fires when an error occurs during object loading.\n     * @param ev The event.\n     */\n    onerror: (this: Document, ev: ErrorEvent) => any;\n    /**\n     * Fires when the object receives focus.\n     * @param ev The event.\n     */\n    onfocus: (this: Document, ev: FocusEvent) => any;\n    onfullscreenchange: (this: Document, ev: Event) => any;\n    onfullscreenerror: (this: Document, ev: Event) => any;\n    oninput: (this: Document, ev: Event) => any;\n    oninvalid: (this: Document, ev: Event) => any;\n    /**\n     * Fires when the user presses a key.\n     * @param ev The keyboard event\n     */\n    onkeydown: (this: Document, ev: KeyboardEvent) => any;\n    /**\n     * Fires when the user presses an alphanumeric key.\n     * @param ev The event.\n     */\n    onkeypress: (this: Document, ev: KeyboardEvent) => any;\n    /**\n     * Fires when the user releases a key.\n     * @param ev The keyboard event\n     */\n    onkeyup: (this: Document, ev: KeyboardEvent) => any;\n    /**\n     * Fires immediately after the browser loads the object.\n     * @param ev The event.\n     */\n    onload: (this: Document, ev: Event) => any;\n    /**\n     * Occurs when media data is loaded at the current playback position.\n     * @param ev The event.\n     */\n    onloadeddata: (this: Document, ev: Event) => any;\n    /**\n     * Occurs when the duration and dimensions of the media have been determined.\n     * @param ev The event.\n     */\n    onloadedmetadata: (this: Document, ev: Event) => any;\n    /**\n     * Occurs when Internet Explorer begins looking for media data.\n     * @param ev The event.\n     */\n    onloadstart: (this: Document, ev: Event) => any;\n    /**\n     * Fires when the user clicks the object with either mouse button.\n     * @param ev The mouse event.\n     */\n    onmousedown: (this: Document, ev: MouseEvent) => any;\n    /**\n     * Fires when the user moves the mouse over the object.\n     * @param ev The mouse event.\n     */\n    onmousemove: (this: Document, ev: MouseEvent) => any;\n    /**\n     * Fires when the user moves the mouse pointer outside the boundaries of the object.\n     * @param ev The mouse event.\n     */\n    onmouseout: (this: Document, ev: MouseEvent) => any;\n    /**\n     * Fires when the user moves the mouse pointer into the object.\n     * @param ev The mouse event.\n     */\n    onmouseover: (this: Document, ev: MouseEvent) => any;\n    /**\n     * Fires when the user releases a mouse button while the mouse is over the object.\n     * @param ev The mouse event.\n     */\n    onmouseup: (this: Document, ev: MouseEvent) => any;\n    /**\n     * Fires when the wheel button is rotated.\n     * @param ev The mouse event\n     */\n    onmousewheel: (this: Document, ev: WheelEvent) => any;\n    onmscontentzoom: (this: Document, ev: UIEvent) => any;\n    onmsgesturechange: (this: Document, ev: MSGestureEvent) => any;\n    onmsgesturedoubletap: (this: Document, ev: MSGestureEvent) => any;\n    onmsgestureend: (this: Document, ev: MSGestureEvent) => any;\n    onmsgesturehold: (this: Document, ev: MSGestureEvent) => any;\n    onmsgesturestart: (this: Document, ev: MSGestureEvent) => any;\n    onmsgesturetap: (this: Document, ev: MSGestureEvent) => any;\n    onmsinertiastart: (this: Document, ev: MSGestureEvent) => any;\n    onmsmanipulationstatechanged: (this: Document, ev: MSManipulationEvent) => any;\n    onmspointercancel: (this: Document, ev: MSPointerEvent) => any;\n    onmspointerdown: (this: Document, ev: MSPointerEvent) => any;\n    onmspointerenter: (this: Document, ev: MSPointerEvent) => any;\n    onmspointerleave: (this: Document, ev: MSPointerEvent) => any;\n    onmspointermove: (this: Document, ev: MSPointerEvent) => any;\n    onmspointerout: (this: Document, ev: MSPointerEvent) => any;\n    onmspointerover: (this: Document, ev: MSPointerEvent) => any;\n    onmspointerup: (this: Document, ev: MSPointerEvent) => any;\n    /**\n     * Occurs when an item is removed from a Jump List of a webpage running in Site Mode.\n     * @param ev The event.\n     */\n    onmssitemodejumplistitemremoved: (this: Document, ev: MSSiteModeEvent) => any;\n    /**\n     * Occurs when a user clicks a button in a Thumbnail Toolbar of a webpage running in Site Mode.\n     * @param ev The event.\n     */\n    onmsthumbnailclick: (this: Document, ev: MSSiteModeEvent) => any;\n    /**\n     * Occurs when playback is paused.\n     * @param ev The event.\n     */\n    onpause: (this: Document, ev: Event) => any;\n    /**\n     * Occurs when the play method is requested.\n     * @param ev The event.\n     */\n    onplay: (this: Document, ev: Event) => any;\n    /**\n     * Occurs when the audio or video has started playing.\n     * @param ev The event.\n     */\n    onplaying: (this: Document, ev: Event) => any;\n    onpointerlockchange: (this: Document, ev: Event) => any;\n    onpointerlockerror: (this: Document, ev: Event) => any;\n    /**\n     * Occurs to indicate progress while downloading media data.\n     * @param ev The event.\n     */\n    onprogress: (this: Document, ev: ProgressEvent) => any;\n    /**\n     * Occurs when the playback rate is increased or decreased.\n     * @param ev The event.\n     */\n    onratechange: (this: Document, ev: Event) => any;\n    /**\n     * Fires when the state of the object has changed.\n     * @param ev The event\n     */\n    onreadystatechange: (this: Document, ev: Event) => any;\n    /**\n     * Fires when the user resets a form.\n     * @param ev The event.\n     */\n    onreset: (this: Document, ev: Event) => any;\n    /**\n     * Fires when the user repositions the scroll box in the scroll bar on the object.\n     * @param ev The event.\n     */\n    onscroll: (this: Document, ev: UIEvent) => any;\n    /**\n     * Occurs when the seek operation ends.\n     * @param ev The event.\n     */\n    onseeked: (this: Document, ev: Event) => any;\n    /**\n     * Occurs when the current playback position is moved.\n     * @param ev The event.\n     */\n    onseeking: (this: Document, ev: Event) => any;\n    /**\n     * Fires when the current selection changes.\n     * @param ev The event.\n     */\n    onselect: (this: Document, ev: UIEvent) => any;\n    /**\n     * Fires when the selection state of a document changes.\n     * @param ev The event.\n     */\n    onselectionchange: (this: Document, ev: Event) => any;\n    onselectstart: (this: Document, ev: Event) => any;\n    /**\n     * Occurs when the download has stopped.\n     * @param ev The event.\n     */\n    onstalled: (this: Document, ev: Event) => any;\n    /**\n     * Fires when the user clicks the Stop button or leaves the Web page.\n     * @param ev The event.\n     */\n    onstop: (this: Document, ev: Event) => any;\n    onsubmit: (this: Document, ev: Event) => any;\n    /**\n     * Occurs if the load operation has been intentionally halted.\n     * @param ev The event.\n     */\n    onsuspend: (this: Document, ev: Event) => any;\n    /**\n     * Occurs to indicate the current playback position.\n     * @param ev The event.\n     */\n    ontimeupdate: (this: Document, ev: Event) => any;\n    ontouchcancel: (ev: TouchEvent) => any;\n    ontouchend: (ev: TouchEvent) => any;\n    ontouchmove: (ev: TouchEvent) => any;\n    ontouchstart: (ev: TouchEvent) => any;\n    /**\n     * Occurs when the volume is changed, or playback is muted or unmuted.\n     * @param ev The event.\n     */\n    onvolumechange: (this: Document, ev: Event) => any;\n    /**\n     * Occurs when playback stops because the next frame of a video resource is not available.\n     * @param ev The event.\n     */\n    onwaiting: (this: Document, ev: Event) => any;\n    onwebkitfullscreenchange: (this: Document, ev: Event) => any;\n    onwebkitfullscreenerror: (this: Document, ev: Event) => any;\n    plugins: HTMLCollectionOf<HTMLEmbedElement>;\n    readonly pointerLockElement: Element;\n    /**\n     * Retrieves a value that indicates the current state of the object.\n     */\n    readonly readyState: string;\n    /**\n     * Gets the URL of the location that referred the user to the current page.\n     */\n    readonly referrer: string;\n    /**\n     * Gets the root svg element in the document hierarchy.\n     */\n    readonly rootElement: SVGSVGElement;\n    /**\n     * Retrieves a collection of all script objects in the document.\n     */\n    scripts: HTMLCollectionOf<HTMLScriptElement>;\n    readonly scrollingElement: Element | null;\n    /**\n     * Retrieves a collection of styleSheet objects representing the style sheets that correspond to each instance of a link or style object in the document.\n     */\n    readonly styleSheets: StyleSheetList;\n    /**\n     * Contains the title of the document.\n     */\n    title: string;\n    /**\n     * Sets or gets the URL for the current document.\n     */\n    readonly URL: string;\n    /**\n     * Gets the URL for the document, stripped of any character encoding.\n     */\n    readonly URLUnencoded: string;\n    readonly visibilityState: VisibilityState;\n    /**\n     * Sets or gets the color of the links that the user has visited.\n     */\n    vlinkColor: string;\n    readonly webkitCurrentFullScreenElement: Element | null;\n    readonly webkitFullscreenElement: Element | null;\n    readonly webkitFullscreenEnabled: boolean;\n    readonly webkitIsFullScreen: boolean;\n    readonly xmlEncoding: string | null;\n    xmlStandalone: boolean;\n    /**\n     * Gets or sets the version attribute specified in the declaration of an XML document.\n     */\n    xmlVersion: string | null;\n    adoptNode<T extends Node>(source: T): T;\n    captureEvents(): void;\n    caretRangeFromPoint(x: number, y: number): Range;\n    clear(): void;\n    /**\n     * Closes an output stream and forces the sent data to display.\n     */\n    close(): void;\n    /**\n     * Creates an attribute object with a specified name.\n     * @param name String that sets the attribute object's name.\n     */\n    createAttribute(name: string): Attr;\n    createAttributeNS(namespaceURI: string | null, qualifiedName: string): Attr;\n    createCDATASection(data: string): CDATASection;\n    /**\n     * Creates a comment object with the specified data.\n     * @param data Sets the comment object's data.\n     */\n    createComment(data: string): Comment;\n    /**\n     * Creates a new document.\n     */\n    createDocumentFragment(): DocumentFragment;\n    /**\n     * Creates an instance of the element for the specified tag.\n     * @param tagName The name of an element.\n     */\n    createElement<K extends keyof HTMLElementTagNameMap>(tagName: K): HTMLElementTagNameMap[K];\n    createElement(tagName: string): HTMLElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/1999/xhtml\", qualifiedName: string): HTMLElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"a\"): SVGAElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"circle\"): SVGCircleElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"clipPath\"): SVGClipPathElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"componentTransferFunction\"): SVGComponentTransferFunctionElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"defs\"): SVGDefsElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"desc\"): SVGDescElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"ellipse\"): SVGEllipseElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feBlend\"): SVGFEBlendElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feColorMatrix\"): SVGFEColorMatrixElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feComponentTransfer\"): SVGFEComponentTransferElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feComposite\"): SVGFECompositeElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feConvolveMatrix\"): SVGFEConvolveMatrixElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feDiffuseLighting\"): SVGFEDiffuseLightingElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feDisplacementMap\"): SVGFEDisplacementMapElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feDistantLight\"): SVGFEDistantLightElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feFlood\"): SVGFEFloodElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feFuncA\"): SVGFEFuncAElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feFuncB\"): SVGFEFuncBElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feFuncG\"): SVGFEFuncGElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feFuncR\"): SVGFEFuncRElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feGaussianBlur\"): SVGFEGaussianBlurElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feImage\"): SVGFEImageElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feMerge\"): SVGFEMergeElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feMergeNode\"): SVGFEMergeNodeElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feMorphology\"): SVGFEMorphologyElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feOffset\"): SVGFEOffsetElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"fePointLight\"): SVGFEPointLightElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feSpecularLighting\"): SVGFESpecularLightingElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feSpotLight\"): SVGFESpotLightElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feTile\"): SVGFETileElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"feTurbulence\"): SVGFETurbulenceElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"filter\"): SVGFilterElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"foreignObject\"): SVGForeignObjectElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"g\"): SVGGElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"image\"): SVGImageElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"gradient\"): SVGGradientElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"line\"): SVGLineElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"linearGradient\"): SVGLinearGradientElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"marker\"): SVGMarkerElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"mask\"): SVGMaskElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"path\"): SVGPathElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"metadata\"): SVGMetadataElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"pattern\"): SVGPatternElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"polygon\"): SVGPolygonElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"polyline\"): SVGPolylineElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"radialGradient\"): SVGRadialGradientElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"rect\"): SVGRectElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"svg\"): SVGSVGElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"script\"): SVGScriptElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"stop\"): SVGStopElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"style\"): SVGStyleElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"switch\"): SVGSwitchElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"symbol\"): SVGSymbolElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"tspan\"): SVGTSpanElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"textContent\"): SVGTextContentElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"text\"): SVGTextElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"textPath\"): SVGTextPathElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"textPositioning\"): SVGTextPositioningElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"title\"): SVGTitleElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"use\"): SVGUseElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: \"view\"): SVGViewElement;\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: string): SVGElement;\n    createElementNS(namespaceURI: string | null, qualifiedName: string): Element;\n    createExpression(expression: string, resolver: XPathNSResolver): XPathExpression;\n    /**\n     * Creates a NodeIterator object that you can use to traverse filtered lists of nodes or elements in a document.\n     * @param root The root element or node to start traversing on.\n     * @param whatToShow The type of nodes or elements to appear in the node list\n     * @param filter A custom NodeFilter function to use. For more information, see filter. Use null for no filter.\n     * @param entityReferenceExpansion A flag that specifies whether entity reference nodes are expanded.\n     */\n    createNodeIterator(root: Node, whatToShow?: number, filter?: NodeFilter, entityReferenceExpansion?: boolean): NodeIterator;\n    createNSResolver(nodeResolver: Node): XPathNSResolver;\n    createProcessingInstruction(target: string, data: string): ProcessingInstruction;\n    /**\n     *  Returns an empty range object that has both of its boundary points positioned at the beginning of the document.\n     */\n    createRange(): Range;\n    /**\n     * Creates a text string from the specified value.\n     * @param data String that specifies the nodeValue property of the text node.\n     */\n    createTextNode(data: string): Text;\n    createTouch(view: Window, target: EventTarget, identifier: number, pageX: number, pageY: number, screenX: number, screenY: number): Touch;\n    createTouchList(...touches: Touch[]): TouchList;\n    /**\n     * Creates a TreeWalker object that you can use to traverse filtered lists of nodes or elements in a document.\n     * @param root The root element or node to start traversing on.\n     * @param whatToShow The type of nodes or elements to appear in the node list. For more information, see whatToShow.\n     * @param filter A custom NodeFilter function to use.\n     * @param entityReferenceExpansion A flag that specifies whether entity reference nodes are expanded.\n     */\n    createTreeWalker(root: Node, whatToShow?: number, filter?: NodeFilter, entityReferenceExpansion?: boolean): TreeWalker;\n    /**\n     * Returns the element for the specified x coordinate and the specified y coordinate.\n     * @param x The x-offset\n     * @param y The y-offset\n     */\n    elementFromPoint(x: number, y: number): Element;\n    evaluate(expression: string, contextNode: Node, resolver: XPathNSResolver | null, type: number, result: XPathResult | null): XPathResult;\n    /**\n     * Executes a command on the current document, current selection, or the given range.\n     * @param commandId String that specifies the command to execute. This command can be any of the command identifiers that can be executed in script.\n     * @param showUI Display the user interface, defaults to false.\n     * @param value Value to assign.\n     */\n    execCommand(commandId: string, showUI?: boolean, value?: any): boolean;\n    /**\n     * Displays help information for the given command identifier.\n     * @param commandId Displays help information for the given command identifier.\n     */\n    execCommandShowHelp(commandId: string): boolean;\n    exitFullscreen(): void;\n    exitPointerLock(): void;\n    /**\n     * Causes the element to receive the focus and executes the code specified by the onfocus event.\n     */\n    focus(): void;\n    /**\n     * Returns a reference to the first object with the specified value of the ID or NAME attribute.\n     * @param elementId String that specifies the ID value. Case-insensitive.\n     */\n    getElementById(elementId: string): HTMLElement | null;\n    getElementsByClassName(classNames: string): HTMLCollectionOf<Element>;\n    /**\n     * Gets a collection of objects based on the value of the NAME or ID attribute.\n     * @param elementName Gets a collection of objects based on the value of the NAME or ID attribute.\n     */\n    getElementsByName(elementName: string): NodeListOf<HTMLElement>;\n    /**\n     * Retrieves a collection of objects based on the specified element name.\n     * @param name Specifies the name of an element.\n     */\n    getElementsByTagName<K extends keyof ElementListTagNameMap>(tagname: K): ElementListTagNameMap[K];\n    getElementsByTagName(tagname: string): NodeListOf<Element>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/1999/xhtml\", localName: string): HTMLCollectionOf<HTMLElement>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/2000/svg\", localName: string): HTMLCollectionOf<SVGElement>;\n    getElementsByTagNameNS(namespaceURI: string, localName: string): HTMLCollectionOf<Element>;\n    /**\n     * Returns an object representing the current selection of the document that is loaded into the object displaying a webpage.\n     */\n    getSelection(): Selection;\n    /**\n     * Gets a value indicating whether the object currently has focus.\n     */\n    hasFocus(): boolean;\n    importNode<T extends Node>(importedNode: T, deep: boolean): T;\n    msElementsFromPoint(x: number, y: number): NodeListOf<Element>;\n    msElementsFromRect(left: number, top: number, width: number, height: number): NodeListOf<Element>;\n    /**\n     * Opens a new window and loads a document specified by a given URL. Also, opens a new window that uses the url parameter and the name parameter to collect the output of the write method and the writeln method.\n     * @param url Specifies a MIME type for the document.\n     * @param name Specifies the name of the window. This name is used as the value for the TARGET attribute on a form or an anchor element.\n     * @param features Contains a list of items separated by commas. Each item consists of an option and a value, separated by an equals sign (for example, \"fullscreen=yes, toolbar=yes\"). The following values are supported.\n     * @param replace Specifies whether the existing entry for the document is replaced in the history list.\n     */\n    open(url?: string, name?: string, features?: string, replace?: boolean): Document;\n    /**\n     * Returns a Boolean value that indicates whether a specified command can be successfully executed using execCommand, given the current state of the document.\n     * @param commandId Specifies a command identifier.\n     */\n    queryCommandEnabled(commandId: string): boolean;\n    /**\n     * Returns a Boolean value that indicates whether the specified command is in the indeterminate state.\n     * @param commandId String that specifies a command identifier.\n     */\n    queryCommandIndeterm(commandId: string): boolean;\n    /**\n     * Returns a Boolean value that indicates the current state of the command.\n     * @param commandId String that specifies a command identifier.\n     */\n    queryCommandState(commandId: string): boolean;\n    /**\n     * Returns a Boolean value that indicates whether the current command is supported on the current range.\n     * @param commandId Specifies a command identifier.\n     */\n    queryCommandSupported(commandId: string): boolean;\n    /**\n     * Retrieves the string associated with a command.\n     * @param commandId String that contains the identifier of a command. This can be any command identifier given in the list of Command Identifiers.\n     */\n    queryCommandText(commandId: string): string;\n    /**\n     * Returns the current value of the document, range, or current selection for the given command.\n     * @param commandId String that specifies a command identifier.\n     */\n    queryCommandValue(commandId: string): string;\n    releaseEvents(): void;\n    /**\n     * Allows updating the print settings for the page.\n     */\n    updateSettings(): void;\n    webkitCancelFullScreen(): void;\n    webkitExitFullscreen(): void;\n    /**\n     * Writes one or more HTML expressions to a document in the specified window.\n     * @param content Specifies the text and HTML tags to write.\n     */\n    write(...content: string[]): void;\n    /**\n     * Writes one or more HTML expressions, followed by a carriage return, to a document in the specified window.\n     * @param content The text and HTML tags to write.\n     */\n    writeln(...content: string[]): void;\n    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: Document, ev: DocumentEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var Document: {\n    prototype: Document;\n    new(): Document;\n};\n\ninterface DocumentFragment extends Node, NodeSelector, ParentNode {\n    getElementById(elementId: string): HTMLElement | null;\n}\n\ndeclare var DocumentFragment: {\n    prototype: DocumentFragment;\n    new(): DocumentFragment;\n};\n\ninterface DocumentType extends Node, ChildNode {\n    readonly entities: NamedNodeMap;\n    readonly internalSubset: string | null;\n    readonly name: string;\n    readonly notations: NamedNodeMap;\n    readonly publicId: string;\n    readonly systemId: string;\n}\n\ndeclare var DocumentType: {\n    prototype: DocumentType;\n    new(): DocumentType;\n};\n\ninterface DOMError {\n    readonly name: string;\n    toString(): string;\n}\n\ndeclare var DOMError: {\n    prototype: DOMError;\n    new(): DOMError;\n};\n\ninterface DOMException {\n    readonly code: number;\n    readonly message: string;\n    readonly name: string;\n    toString(): string;\n    readonly ABORT_ERR: number;\n    readonly DATA_CLONE_ERR: number;\n    readonly DOMSTRING_SIZE_ERR: number;\n    readonly HIERARCHY_REQUEST_ERR: number;\n    readonly INDEX_SIZE_ERR: number;\n    readonly INUSE_ATTRIBUTE_ERR: number;\n    readonly INVALID_ACCESS_ERR: number;\n    readonly INVALID_CHARACTER_ERR: number;\n    readonly INVALID_MODIFICATION_ERR: number;\n    readonly INVALID_NODE_TYPE_ERR: number;\n    readonly INVALID_STATE_ERR: number;\n    readonly NAMESPACE_ERR: number;\n    readonly NETWORK_ERR: number;\n    readonly NO_DATA_ALLOWED_ERR: number;\n    readonly NO_MODIFICATION_ALLOWED_ERR: number;\n    readonly NOT_FOUND_ERR: number;\n    readonly NOT_SUPPORTED_ERR: number;\n    readonly PARSE_ERR: number;\n    readonly QUOTA_EXCEEDED_ERR: number;\n    readonly SECURITY_ERR: number;\n    readonly SERIALIZE_ERR: number;\n    readonly SYNTAX_ERR: number;\n    readonly TIMEOUT_ERR: number;\n    readonly TYPE_MISMATCH_ERR: number;\n    readonly URL_MISMATCH_ERR: number;\n    readonly VALIDATION_ERR: number;\n    readonly WRONG_DOCUMENT_ERR: number;\n}\n\ndeclare var DOMException: {\n    prototype: DOMException;\n    new(): DOMException;\n    readonly ABORT_ERR: number;\n    readonly DATA_CLONE_ERR: number;\n    readonly DOMSTRING_SIZE_ERR: number;\n    readonly HIERARCHY_REQUEST_ERR: number;\n    readonly INDEX_SIZE_ERR: number;\n    readonly INUSE_ATTRIBUTE_ERR: number;\n    readonly INVALID_ACCESS_ERR: number;\n    readonly INVALID_CHARACTER_ERR: number;\n    readonly INVALID_MODIFICATION_ERR: number;\n    readonly INVALID_NODE_TYPE_ERR: number;\n    readonly INVALID_STATE_ERR: number;\n    readonly NAMESPACE_ERR: number;\n    readonly NETWORK_ERR: number;\n    readonly NO_DATA_ALLOWED_ERR: number;\n    readonly NO_MODIFICATION_ALLOWED_ERR: number;\n    readonly NOT_FOUND_ERR: number;\n    readonly NOT_SUPPORTED_ERR: number;\n    readonly PARSE_ERR: number;\n    readonly QUOTA_EXCEEDED_ERR: number;\n    readonly SECURITY_ERR: number;\n    readonly SERIALIZE_ERR: number;\n    readonly SYNTAX_ERR: number;\n    readonly TIMEOUT_ERR: number;\n    readonly TYPE_MISMATCH_ERR: number;\n    readonly URL_MISMATCH_ERR: number;\n    readonly VALIDATION_ERR: number;\n    readonly WRONG_DOCUMENT_ERR: number;\n};\n\ninterface DOMImplementation {\n    createDocument(namespaceURI: string | null, qualifiedName: string | null, doctype: DocumentType | null): Document;\n    createDocumentType(qualifiedName: string, publicId: string, systemId: string): DocumentType;\n    createHTMLDocument(title: string): Document;\n    hasFeature(feature: string | null, version: string | null): boolean;\n}\n\ndeclare var DOMImplementation: {\n    prototype: DOMImplementation;\n    new(): DOMImplementation;\n};\n\ninterface DOMParser {\n    parseFromString(source: string, mimeType: string): Document;\n}\n\ndeclare var DOMParser: {\n    prototype: DOMParser;\n    new(): DOMParser;\n};\n\ninterface DOMSettableTokenList extends DOMTokenList {\n    value: string;\n}\n\ndeclare var DOMSettableTokenList: {\n    prototype: DOMSettableTokenList;\n    new(): DOMSettableTokenList;\n};\n\ninterface DOMStringList {\n    readonly length: number;\n    contains(str: string): boolean;\n    item(index: number): string | null;\n    [index: number]: string;\n}\n\ndeclare var DOMStringList: {\n    prototype: DOMStringList;\n    new(): DOMStringList;\n};\n\ninterface DOMStringMap {\n    [name: string]: string | undefined;\n}\n\ndeclare var DOMStringMap: {\n    prototype: DOMStringMap;\n    new(): DOMStringMap;\n};\n\ninterface DOMTokenList {\n    readonly length: number;\n    add(...token: string[]): void;\n    contains(token: string): boolean;\n    item(index: number): string;\n    remove(...token: string[]): void;\n    toggle(token: string, force?: boolean): boolean;\n    toString(): string;\n    [index: number]: string;\n}\n\ndeclare var DOMTokenList: {\n    prototype: DOMTokenList;\n    new(): DOMTokenList;\n};\n\ninterface DragEvent extends MouseEvent {\n    readonly dataTransfer: DataTransfer;\n    initDragEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number, screenXArg: number, screenYArg: number, clientXArg: number, clientYArg: number, ctrlKeyArg: boolean, altKeyArg: boolean, shiftKeyArg: boolean, metaKeyArg: boolean, buttonArg: number, relatedTargetArg: EventTarget, dataTransferArg: DataTransfer): void;\n    msConvertURL(file: File, targetType: string, targetURL?: string): void;\n}\n\ndeclare var DragEvent: {\n    prototype: DragEvent;\n    new(type: \"drag\" | \"dragend\" | \"dragenter\" | \"dragexit\" | \"dragleave\" | \"dragover\" | \"dragstart\" | \"drop\", dragEventInit?: { dataTransfer?: DataTransfer }): DragEvent;\n};\n\ninterface DynamicsCompressorNode extends AudioNode {\n    readonly attack: AudioParam;\n    readonly knee: AudioParam;\n    readonly ratio: AudioParam;\n    readonly reduction: number;\n    readonly release: AudioParam;\n    readonly threshold: AudioParam;\n}\n\ndeclare var DynamicsCompressorNode: {\n    prototype: DynamicsCompressorNode;\n    new(): DynamicsCompressorNode;\n};\n\ninterface ElementEventMap extends GlobalEventHandlersEventMap {\n    \"ariarequest\": Event;\n    \"command\": Event;\n    \"gotpointercapture\": PointerEvent;\n    \"lostpointercapture\": PointerEvent;\n    \"MSGestureChange\": MSGestureEvent;\n    \"MSGestureDoubleTap\": MSGestureEvent;\n    \"MSGestureEnd\": MSGestureEvent;\n    \"MSGestureHold\": MSGestureEvent;\n    \"MSGestureStart\": MSGestureEvent;\n    \"MSGestureTap\": MSGestureEvent;\n    \"MSGotPointerCapture\": MSPointerEvent;\n    \"MSInertiaStart\": MSGestureEvent;\n    \"MSLostPointerCapture\": MSPointerEvent;\n    \"MSPointerCancel\": MSPointerEvent;\n    \"MSPointerDown\": MSPointerEvent;\n    \"MSPointerEnter\": MSPointerEvent;\n    \"MSPointerLeave\": MSPointerEvent;\n    \"MSPointerMove\": MSPointerEvent;\n    \"MSPointerOut\": MSPointerEvent;\n    \"MSPointerOver\": MSPointerEvent;\n    \"MSPointerUp\": MSPointerEvent;\n    \"touchcancel\": TouchEvent;\n    \"touchend\": TouchEvent;\n    \"touchmove\": TouchEvent;\n    \"touchstart\": TouchEvent;\n    \"webkitfullscreenchange\": Event;\n    \"webkitfullscreenerror\": Event;\n}\n\ninterface Element extends Node, GlobalEventHandlers, ElementTraversal, NodeSelector, ChildNode, ParentNode {\n    readonly classList: DOMTokenList;\n    className: string;\n    readonly clientHeight: number;\n    readonly clientLeft: number;\n    readonly clientTop: number;\n    readonly clientWidth: number;\n    id: string;\n    innerHTML: string;\n    msContentZoomFactor: number;\n    readonly msRegionOverflow: string;\n    onariarequest: (this: Element, ev: Event) => any;\n    oncommand: (this: Element, ev: Event) => any;\n    ongotpointercapture: (this: Element, ev: PointerEvent) => any;\n    onlostpointercapture: (this: Element, ev: PointerEvent) => any;\n    onmsgesturechange: (this: Element, ev: MSGestureEvent) => any;\n    onmsgesturedoubletap: (this: Element, ev: MSGestureEvent) => any;\n    onmsgestureend: (this: Element, ev: MSGestureEvent) => any;\n    onmsgesturehold: (this: Element, ev: MSGestureEvent) => any;\n    onmsgesturestart: (this: Element, ev: MSGestureEvent) => any;\n    onmsgesturetap: (this: Element, ev: MSGestureEvent) => any;\n    onmsgotpointercapture: (this: Element, ev: MSPointerEvent) => any;\n    onmsinertiastart: (this: Element, ev: MSGestureEvent) => any;\n    onmslostpointercapture: (this: Element, ev: MSPointerEvent) => any;\n    onmspointercancel: (this: Element, ev: MSPointerEvent) => any;\n    onmspointerdown: (this: Element, ev: MSPointerEvent) => any;\n    onmspointerenter: (this: Element, ev: MSPointerEvent) => any;\n    onmspointerleave: (this: Element, ev: MSPointerEvent) => any;\n    onmspointermove: (this: Element, ev: MSPointerEvent) => any;\n    onmspointerout: (this: Element, ev: MSPointerEvent) => any;\n    onmspointerover: (this: Element, ev: MSPointerEvent) => any;\n    onmspointerup: (this: Element, ev: MSPointerEvent) => any;\n    ontouchcancel: (ev: TouchEvent) => any;\n    ontouchend: (ev: TouchEvent) => any;\n    ontouchmove: (ev: TouchEvent) => any;\n    ontouchstart: (ev: TouchEvent) => any;\n    onwebkitfullscreenchange: (this: Element, ev: Event) => any;\n    onwebkitfullscreenerror: (this: Element, ev: Event) => any;\n    outerHTML: string;\n    readonly prefix: string | null;\n    readonly scrollHeight: number;\n    scrollLeft: number;\n    scrollTop: number;\n    readonly scrollWidth: number;\n    readonly tagName: string;\n    readonly assignedSlot: HTMLSlotElement | null;\n    slot: string;\n    readonly shadowRoot: ShadowRoot | null;\n    getAttribute(name: string): string | null;\n    getAttributeNode(name: string): Attr;\n    getAttributeNodeNS(namespaceURI: string, localName: string): Attr;\n    getAttributeNS(namespaceURI: string, localName: string): string;\n    getBoundingClientRect(): ClientRect;\n    getClientRects(): ClientRectList;\n    getElementsByTagName<K extends keyof ElementListTagNameMap>(name: K): ElementListTagNameMap[K];\n    getElementsByTagName(name: string): NodeListOf<Element>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/1999/xhtml\", localName: string): HTMLCollectionOf<HTMLElement>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/2000/svg\", localName: string): HTMLCollectionOf<SVGElement>;\n    getElementsByTagNameNS(namespaceURI: string, localName: string): HTMLCollectionOf<Element>;\n    hasAttribute(name: string): boolean;\n    hasAttributeNS(namespaceURI: string, localName: string): boolean;\n    msGetRegionContent(): MSRangeCollection;\n    msGetUntransformedBounds(): ClientRect;\n    msMatchesSelector(selectors: string): boolean;\n    msReleasePointerCapture(pointerId: number): void;\n    msSetPointerCapture(pointerId: number): void;\n    msZoomTo(args: MsZoomToOptions): void;\n    releasePointerCapture(pointerId: number): void;\n    removeAttribute(qualifiedName: string): void;\n    removeAttributeNode(oldAttr: Attr): Attr;\n    removeAttributeNS(namespaceURI: string, localName: string): void;\n    requestFullscreen(): void;\n    requestPointerLock(): void;\n    setAttribute(name: string, value: string): void;\n    setAttributeNode(newAttr: Attr): Attr;\n    setAttributeNodeNS(newAttr: Attr): Attr;\n    setAttributeNS(namespaceURI: string, qualifiedName: string, value: string): void;\n    setPointerCapture(pointerId: number): void;\n    webkitMatchesSelector(selectors: string): boolean;\n    webkitRequestFullscreen(): void;\n    webkitRequestFullScreen(): void;\n    getElementsByClassName(classNames: string): NodeListOf<Element>;\n    matches(selector: string): boolean;\n    closest(selector: string): Element | null;\n    scrollIntoView(arg?: boolean | ScrollIntoViewOptions): void;\n    scroll(options?: ScrollToOptions): void;\n    scroll(x: number, y: number): void;\n    scrollTo(options?: ScrollToOptions): void;\n    scrollTo(x: number, y: number): void;\n    scrollBy(options?: ScrollToOptions): void;\n    scrollBy(x: number, y: number): void;\n    insertAdjacentElement(position: InsertPosition, insertedElement: Element): Element | null;\n    insertAdjacentHTML(where: InsertPosition, html: string): void;\n    insertAdjacentText(where: InsertPosition, text: string): void;\n    attachShadow(shadowRootInitDict: ShadowRootInit): ShadowRoot;\n    addEventListener<K extends keyof ElementEventMap>(type: K, listener: (this: Element, ev: ElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var Element: {\n    prototype: Element;\n    new(): Element;\n};\n\ninterface ErrorEvent extends Event {\n    readonly colno: number;\n    readonly error: any;\n    readonly filename: string;\n    readonly lineno: number;\n    readonly message: string;\n    initErrorEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, messageArg: string, filenameArg: string, linenoArg: number): void;\n}\n\ndeclare var ErrorEvent: {\n    prototype: ErrorEvent;\n    new(type: string, errorEventInitDict?: ErrorEventInit): ErrorEvent;\n};\n\ninterface Event {\n    readonly bubbles: boolean;\n    readonly cancelable: boolean;\n    cancelBubble: boolean;\n    readonly currentTarget: EventTarget;\n    readonly defaultPrevented: boolean;\n    readonly eventPhase: number;\n    readonly isTrusted: boolean;\n    returnValue: boolean;\n    readonly srcElement: Element | null;\n    readonly target: EventTarget;\n    readonly timeStamp: number;\n    readonly type: string;\n    readonly scoped: boolean;\n    initEvent(eventTypeArg: string, canBubbleArg: boolean, cancelableArg: boolean): void;\n    preventDefault(): void;\n    stopImmediatePropagation(): void;\n    stopPropagation(): void;\n    deepPath(): EventTarget[];\n    readonly AT_TARGET: number;\n    readonly BUBBLING_PHASE: number;\n    readonly CAPTURING_PHASE: number;\n}\n\ndeclare var Event: {\n    prototype: Event;\n    new(typeArg: string, eventInitDict?: EventInit): Event;\n    readonly AT_TARGET: number;\n    readonly BUBBLING_PHASE: number;\n    readonly CAPTURING_PHASE: number;\n};\n\ninterface EventTarget {\n    addEventListener(type: string, listener?: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    dispatchEvent(evt: Event): boolean;\n    removeEventListener(type: string, listener?: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var EventTarget: {\n    prototype: EventTarget;\n    new(): EventTarget;\n};\n\ninterface EXT_frag_depth {\n}\n\ndeclare var EXT_frag_depth: {\n    prototype: EXT_frag_depth;\n    new(): EXT_frag_depth;\n};\n\ninterface EXT_texture_filter_anisotropic {\n    readonly MAX_TEXTURE_MAX_ANISOTROPY_EXT: number;\n    readonly TEXTURE_MAX_ANISOTROPY_EXT: number;\n}\n\ndeclare var EXT_texture_filter_anisotropic: {\n    prototype: EXT_texture_filter_anisotropic;\n    new(): EXT_texture_filter_anisotropic;\n    readonly MAX_TEXTURE_MAX_ANISOTROPY_EXT: number;\n    readonly TEXTURE_MAX_ANISOTROPY_EXT: number;\n};\n\ninterface ExtensionScriptApis {\n    extensionIdToShortId(extensionId: string): number;\n    fireExtensionApiTelemetry(functionName: string, isSucceeded: boolean, isSupported: boolean): void;\n    genericFunction(routerAddress: any, parameters?: string, callbackId?: number): void;\n    genericSynchronousFunction(functionId: number, parameters?: string): string;\n    getExtensionId(): string;\n    registerGenericFunctionCallbackHandler(callbackHandler: any): void;\n    registerGenericPersistentCallbackHandler(callbackHandler: any): void;\n}\n\ndeclare var ExtensionScriptApis: {\n    prototype: ExtensionScriptApis;\n    new(): ExtensionScriptApis;\n};\n\ninterface External {\n}\n\ndeclare var External: {\n    prototype: External;\n    new(): External;\n};\n\ninterface File extends Blob {\n    readonly lastModifiedDate: any;\n    readonly name: string;\n    readonly webkitRelativePath: string;\n}\n\ndeclare var File: {\n    prototype: File;\n    new (parts: (ArrayBuffer | ArrayBufferView | Blob | string)[], filename: string, properties?: FilePropertyBag): File;\n};\n\ninterface FileList {\n    readonly length: number;\n    item(index: number): File;\n    [index: number]: File;\n}\n\ndeclare var FileList: {\n    prototype: FileList;\n    new(): FileList;\n};\n\ninterface FileReader extends EventTarget, MSBaseReader {\n    readonly error: DOMError;\n    readAsArrayBuffer(blob: Blob): void;\n    readAsBinaryString(blob: Blob): void;\n    readAsDataURL(blob: Blob): void;\n    readAsText(blob: Blob, encoding?: string): void;\n    addEventListener<K extends keyof MSBaseReaderEventMap>(type: K, listener: (this: FileReader, ev: MSBaseReaderEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var FileReader: {\n    prototype: FileReader;\n    new(): FileReader;\n};\n\ninterface FocusEvent extends UIEvent {\n    readonly relatedTarget: EventTarget;\n    initFocusEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number, relatedTargetArg: EventTarget): void;\n}\n\ndeclare var FocusEvent: {\n    prototype: FocusEvent;\n    new(typeArg: string, eventInitDict?: FocusEventInit): FocusEvent;\n};\n\ninterface FocusNavigationEvent extends Event {\n    readonly navigationReason: NavigationReason;\n    readonly originHeight: number;\n    readonly originLeft: number;\n    readonly originTop: number;\n    readonly originWidth: number;\n    requestFocus(): void;\n}\n\ndeclare var FocusNavigationEvent: {\n    prototype: FocusNavigationEvent;\n    new(type: string, eventInitDict?: FocusNavigationEventInit): FocusNavigationEvent;\n};\n\ninterface FormData {\n    append(name: string, value: string | Blob, fileName?: string): void;\n    delete(name: string): void;\n    get(name: string): FormDataEntryValue | null;\n    getAll(name: string): FormDataEntryValue[];\n    has(name: string): boolean;\n    set(name: string, value: string | Blob, fileName?: string): void;\n}\n\ndeclare var FormData: {\n    prototype: FormData;\n    new (form?: HTMLFormElement): FormData;\n};\n\ninterface GainNode extends AudioNode {\n    readonly gain: AudioParam;\n}\n\ndeclare var GainNode: {\n    prototype: GainNode;\n    new(): GainNode;\n};\n\ninterface Gamepad {\n    readonly axes: number[];\n    readonly buttons: GamepadButton[];\n    readonly connected: boolean;\n    readonly id: string;\n    readonly index: number;\n    readonly mapping: string;\n    readonly timestamp: number;\n}\n\ndeclare var Gamepad: {\n    prototype: Gamepad;\n    new(): Gamepad;\n};\n\ninterface GamepadButton {\n    readonly pressed: boolean;\n    readonly value: number;\n}\n\ndeclare var GamepadButton: {\n    prototype: GamepadButton;\n    new(): GamepadButton;\n};\n\ninterface GamepadEvent extends Event {\n    readonly gamepad: Gamepad;\n}\n\ndeclare var GamepadEvent: {\n    prototype: GamepadEvent;\n    new(typeArg: string, eventInitDict?: GamepadEventInit): GamepadEvent;\n};\n\ninterface Geolocation {\n    clearWatch(watchId: number): void;\n    getCurrentPosition(successCallback: PositionCallback, errorCallback?: PositionErrorCallback, options?: PositionOptions): void;\n    watchPosition(successCallback: PositionCallback, errorCallback?: PositionErrorCallback, options?: PositionOptions): number;\n}\n\ndeclare var Geolocation: {\n    prototype: Geolocation;\n    new(): Geolocation;\n};\n\ninterface HashChangeEvent extends Event {\n    readonly newURL: string | null;\n    readonly oldURL: string | null;\n}\n\ndeclare var HashChangeEvent: {\n    prototype: HashChangeEvent;\n    new(typeArg: string, eventInitDict?: HashChangeEventInit): HashChangeEvent;\n};\n\ninterface Headers {\n    append(name: string, value: string): void;\n    delete(name: string): void;\n    forEach(callback: ForEachCallback): void;\n    get(name: string): string | null;\n    has(name: string): boolean;\n    set(name: string, value: string): void;\n}\n\ndeclare var Headers: {\n    prototype: Headers;\n    new(init?: any): Headers;\n};\n\ninterface History {\n    readonly length: number;\n    readonly state: any;\n    scrollRestoration: ScrollRestoration;\n    back(): void;\n    forward(): void;\n    go(delta?: number): void;\n    pushState(data: any, title: string, url?: string | null): void;\n    replaceState(data: any, title: string, url?: string | null): void;\n}\n\ndeclare var History: {\n    prototype: History;\n    new(): History;\n};\n\ninterface HTMLAllCollection {\n    readonly length: number;\n    item(nameOrIndex?: string): HTMLCollection | Element | null;\n    namedItem(name: string): HTMLCollection | Element | null;\n    [index: number]: Element;\n}\n\ndeclare var HTMLAllCollection: {\n    prototype: HTMLAllCollection;\n    new(): HTMLAllCollection;\n};\n\ninterface HTMLAnchorElement extends HTMLElement {\n    /**\n     * Sets or retrieves the character set used to encode the object.\n     */\n    charset: string;\n    /**\n     * Sets or retrieves the coordinates of the object.\n     */\n    coords: string;\n    download: string;\n    /**\n     * Contains the anchor portion of the URL including the hash sign (#).\n     */\n    hash: string;\n    /**\n     * Contains the hostname and port values of the URL.\n     */\n    host: string;\n    /**\n     * Contains the hostname of a URL.\n     */\n    hostname: string;\n    /**\n     * Sets or retrieves a destination URL or an anchor point.\n     */\n    href: string;\n    /**\n     * Sets or retrieves the language code of the object.\n     */\n    hreflang: string;\n    Methods: string;\n    readonly mimeType: string;\n    /**\n     * Sets or retrieves the shape of the object.\n     */\n    name: string;\n    readonly nameProp: string;\n    /**\n     * Contains the pathname of the URL.\n     */\n    pathname: string;\n    /**\n     * Sets or retrieves the port number associated with a URL.\n     */\n    port: string;\n    /**\n     * Contains the protocol of the URL.\n     */\n    protocol: string;\n    readonly protocolLong: string;\n    /**\n     * Sets or retrieves the relationship between the object and the destination of the link.\n     */\n    rel: string;\n    /**\n     * Sets or retrieves the relationship between the object and the destination of the link.\n     */\n    rev: string;\n    /**\n     * Sets or retrieves the substring of the href property that follows the question mark.\n     */\n    search: string;\n    /**\n     * Sets or retrieves the shape of the object.\n     */\n    shape: string;\n    /**\n     * Sets or retrieves the window or frame at which to target content.\n     */\n    target: string;\n    /**\n     * Retrieves or sets the text of the object as a string.\n     */\n    text: string;\n    type: string;\n    urn: string;\n    /**\n     * Returns a string representation of an object.\n     */\n    toString(): string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAnchorElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLAnchorElement: {\n    prototype: HTMLAnchorElement;\n    new(): HTMLAnchorElement;\n};\n\ninterface HTMLAppletElement extends HTMLElement {\n    align: string;\n    /**\n     * Sets or retrieves a text alternative to the graphic.\n     */\n    alt: string;\n    /**\n     * Gets or sets the optional alternative HTML script to execute if the object fails to load.\n     */\n    altHtml: string;\n    /**\n     * Sets or retrieves a character string that can be used to implement your own archive functionality for the object.\n     */\n    archive: string;\n    /**\n     * Retrieves a string of the URL where the object tag can be found. This is often the href of the document that the object is in, or the value set by a base element.\n     */\n    readonly BaseHref: string;\n    border: string;\n    code: string;\n    /**\n     * Sets or retrieves the URL of the component.\n     */\n    codeBase: string;\n    /**\n     * Sets or retrieves the Internet media type for the code associated with the object.\n     */\n    codeType: string;\n    /**\n     * Address of a pointer to the document this page or frame contains. If there is no document, then null will be returned.\n     */\n    readonly contentDocument: Document;\n    /**\n     * Sets or retrieves the URL that references the data of the object.\n     */\n    data: string;\n    /**\n     * Sets or retrieves a character string that can be used to implement your own declare functionality for the object.\n     */\n    declare: boolean;\n    readonly form: HTMLFormElement;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: string;\n    hspace: number;\n    /**\n     * Sets or retrieves the shape of the object.\n     */\n    name: string;\n    object: string | null;\n    /**\n     * Sets or retrieves a message to be displayed while an object is loading.\n     */\n    standby: string;\n    /**\n     * Returns the content type of the object.\n     */\n    type: string;\n    /**\n     * Sets or retrieves the URL, often with a bookmark extension (#name), to use as a client-side image map.\n     */\n    useMap: string;\n    vspace: number;\n    width: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAppletElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLAppletElement: {\n    prototype: HTMLAppletElement;\n    new(): HTMLAppletElement;\n};\n\ninterface HTMLAreaElement extends HTMLElement {\n    /**\n     * Sets or retrieves a text alternative to the graphic.\n     */\n    alt: string;\n    /**\n     * Sets or retrieves the coordinates of the object.\n     */\n    coords: string;\n    download: string;\n    /**\n     * Sets or retrieves the subsection of the href property that follows the number sign (#).\n     */\n    hash: string;\n    /**\n     * Sets or retrieves the hostname and port number of the location or URL.\n     */\n    host: string;\n    /**\n     * Sets or retrieves the host name part of the location or URL.\n     */\n    hostname: string;\n    /**\n     * Sets or retrieves a destination URL or an anchor point.\n     */\n    href: string;\n    /**\n     * Sets or gets whether clicks in this region cause action.\n     */\n    noHref: boolean;\n    /**\n     * Sets or retrieves the file name or path specified by the object.\n     */\n    pathname: string;\n    /**\n     * Sets or retrieves the port number associated with a URL.\n     */\n    port: string;\n    /**\n     * Sets or retrieves the protocol portion of a URL.\n     */\n    protocol: string;\n    rel: string;\n    /**\n     * Sets or retrieves the substring of the href property that follows the question mark.\n     */\n    search: string;\n    /**\n     * Sets or retrieves the shape of the object.\n     */\n    shape: string;\n    /**\n     * Sets or retrieves the window or frame at which to target content.\n     */\n    target: string;\n    /**\n     * Returns a string representation of an object.\n     */\n    toString(): string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAreaElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLAreaElement: {\n    prototype: HTMLAreaElement;\n    new(): HTMLAreaElement;\n};\n\ninterface HTMLAreasCollection extends HTMLCollectionBase {\n}\n\ndeclare var HTMLAreasCollection: {\n    prototype: HTMLAreasCollection;\n    new(): HTMLAreasCollection;\n};\n\ninterface HTMLAudioElement extends HTMLMediaElement {\n    addEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLAudioElement, ev: HTMLMediaElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLAudioElement: {\n    prototype: HTMLAudioElement;\n    new(): HTMLAudioElement;\n};\n\ninterface HTMLBaseElement extends HTMLElement {\n    /**\n     * Gets or sets the baseline URL on which relative links are based.\n     */\n    href: string;\n    /**\n     * Sets or retrieves the window or frame at which to target content.\n     */\n    target: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBaseElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLBaseElement: {\n    prototype: HTMLBaseElement;\n    new(): HTMLBaseElement;\n};\n\ninterface HTMLBaseFontElement extends HTMLElement, DOML2DeprecatedColorProperty {\n    /**\n     * Sets or retrieves the current typeface family.\n     */\n    face: string;\n    /**\n     * Sets or retrieves the font size of the object.\n     */\n    size: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBaseFontElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLBaseFontElement: {\n    prototype: HTMLBaseFontElement;\n    new(): HTMLBaseFontElement;\n};\n\ninterface HTMLBodyElementEventMap extends HTMLElementEventMap {\n    \"afterprint\": Event;\n    \"beforeprint\": Event;\n    \"beforeunload\": BeforeUnloadEvent;\n    \"blur\": FocusEvent;\n    \"error\": ErrorEvent;\n    \"focus\": FocusEvent;\n    \"hashchange\": HashChangeEvent;\n    \"load\": Event;\n    \"message\": MessageEvent;\n    \"offline\": Event;\n    \"online\": Event;\n    \"orientationchange\": Event;\n    \"pagehide\": PageTransitionEvent;\n    \"pageshow\": PageTransitionEvent;\n    \"popstate\": PopStateEvent;\n    \"resize\": UIEvent;\n    \"scroll\": UIEvent;\n    \"storage\": StorageEvent;\n    \"unload\": Event;\n}\n\ninterface HTMLBodyElement extends HTMLElement {\n    aLink: any;\n    background: string;\n    bgColor: any;\n    bgProperties: string;\n    link: any;\n    noWrap: boolean;\n    onafterprint: (this: HTMLBodyElement, ev: Event) => any;\n    onbeforeprint: (this: HTMLBodyElement, ev: Event) => any;\n    onbeforeunload: (this: HTMLBodyElement, ev: BeforeUnloadEvent) => any;\n    onblur: (this: HTMLBodyElement, ev: FocusEvent) => any;\n    onerror: (this: HTMLBodyElement, ev: ErrorEvent) => any;\n    onfocus: (this: HTMLBodyElement, ev: FocusEvent) => any;\n    onhashchange: (this: HTMLBodyElement, ev: HashChangeEvent) => any;\n    onload: (this: HTMLBodyElement, ev: Event) => any;\n    onmessage: (this: HTMLBodyElement, ev: MessageEvent) => any;\n    onoffline: (this: HTMLBodyElement, ev: Event) => any;\n    ononline: (this: HTMLBodyElement, ev: Event) => any;\n    onorientationchange: (this: HTMLBodyElement, ev: Event) => any;\n    onpagehide: (this: HTMLBodyElement, ev: PageTransitionEvent) => any;\n    onpageshow: (this: HTMLBodyElement, ev: PageTransitionEvent) => any;\n    onpopstate: (this: HTMLBodyElement, ev: PopStateEvent) => any;\n    onresize: (this: HTMLBodyElement, ev: UIEvent) => any;\n    onscroll: (this: HTMLBodyElement, ev: UIEvent) => any;\n    onstorage: (this: HTMLBodyElement, ev: StorageEvent) => any;\n    onunload: (this: HTMLBodyElement, ev: Event) => any;\n    text: any;\n    vLink: any;\n    addEventListener<K extends keyof HTMLBodyElementEventMap>(type: K, listener: (this: HTMLBodyElement, ev: HTMLBodyElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLBodyElement: {\n    prototype: HTMLBodyElement;\n    new(): HTMLBodyElement;\n};\n\ninterface HTMLBRElement extends HTMLElement {\n    /**\n     * Sets or retrieves the side on which floating objects are not to be positioned when any IHTMLBlockElement is inserted into the document.\n     */\n    clear: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBRElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLBRElement: {\n    prototype: HTMLBRElement;\n    new(): HTMLBRElement;\n};\n\ninterface HTMLButtonElement extends HTMLElement {\n    /**\n     * Provides a way to direct a user to a specific field when a document loads. This can provide both direction and convenience for a user, reducing the need to click or tab to a field when a page opens. This attribute is true when present on an element, and false when missing.\n     */\n    autofocus: boolean;\n    disabled: boolean;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement;\n    /**\n     * Overrides the action attribute (where the data on a form is sent) on the parent form element.\n     */\n    formAction: string;\n    /**\n     * Used to override the encoding (formEnctype attribute) specified on the form element.\n     */\n    formEnctype: string;\n    /**\n     * Overrides the submit method attribute previously specified on a form element.\n     */\n    formMethod: string;\n    /**\n     * Overrides any validation or required attributes on a form or form elements to allow it to be submitted without validation. This can be used to create a \"save draft\"-type submit option.\n     */\n    formNoValidate: string;\n    /**\n     * Overrides the target attribute on a form element.\n     */\n    formTarget: string;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    status: any;\n    /**\n     * Gets the classification and default behavior of the button.\n     */\n    type: string;\n    /**\n     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting.\n     */\n    readonly validationMessage: string;\n    /**\n     * Returns a  ValidityState object that represents the validity states of an element.\n     */\n    readonly validity: ValidityState;\n    /**\n     * Sets or retrieves the default or selected value of the control.\n     */\n    value: string;\n    /**\n     * Returns whether an element will successfully validate based on forms validation rules and constraints.\n     */\n    readonly willValidate: boolean;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLButtonElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLButtonElement: {\n    prototype: HTMLButtonElement;\n    new(): HTMLButtonElement;\n};\n\ninterface HTMLCanvasElement extends HTMLElement {\n    /**\n     * Gets or sets the height of a canvas element on a document.\n     */\n    height: number;\n    /**\n     * Gets or sets the width of a canvas element on a document.\n     */\n    width: number;\n    /**\n     * Returns an object that provides methods and properties for drawing and manipulating images and graphics on a canvas element in a document. A context object includes information about colors, line widths, fonts, and other graphic parameters that can be drawn on a canvas.\n     * @param contextId The identifier (ID) of the type of canvas to create. Internet Explorer 9 and Internet Explorer 10 support only a 2-D context using canvas.getContext(\"2d\"); IE11 Preview also supports 3-D or WebGL context using canvas.getContext(\"experimental-webgl\");\n     */\n    getContext(contextId: \"2d\", contextAttributes?: Canvas2DContextAttributes): CanvasRenderingContext2D | null;\n    getContext(contextId: \"webgl\" | \"experimental-webgl\", contextAttributes?: WebGLContextAttributes): WebGLRenderingContext | null;\n    getContext(contextId: string, contextAttributes?: {}): CanvasRenderingContext2D | WebGLRenderingContext | null;\n    /**\n     * Returns a blob object encoded as a Portable Network Graphics (PNG) format from a canvas image or drawing.\n     */\n    msToBlob(): Blob;\n    /**\n     * Returns the content of the current canvas as an image that you can use as a source for another canvas or an HTML element.\n     * @param type The standard MIME type for the image format to return. If you do not specify this parameter, the default value is a PNG format image.\n     */\n    toDataURL(type?: string, ...args: any[]): string;\n    toBlob(callback: (result: Blob | null) => void, type?: string, ...arguments: any[]): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLCanvasElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLCanvasElement: {\n    prototype: HTMLCanvasElement;\n    new(): HTMLCanvasElement;\n};\n\ninterface HTMLCollectionBase {\n    /**\n     * Sets or retrieves the number of objects in a collection.\n     */\n    readonly length: number;\n    /**\n     * Retrieves an object from various collections.\n     */\n    item(index: number): Element;\n    [index: number]: Element;\n}\n\ninterface HTMLCollection extends HTMLCollectionBase {\n    /**\n     * Retrieves a select object or an object from an options collection.\n     */\n    namedItem(name: string): Element | null;\n}\n\ndeclare var HTMLCollection: {\n    prototype: HTMLCollection;\n    new(): HTMLCollection;\n};\n\ninterface HTMLDataElement extends HTMLElement {\n    value: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLDataElement: {\n    prototype: HTMLDataElement;\n    new(): HTMLDataElement;\n};\n\ninterface HTMLDataListElement extends HTMLElement {\n    options: HTMLCollectionOf<HTMLOptionElement>;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataListElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLDataListElement: {\n    prototype: HTMLDataListElement;\n    new(): HTMLDataListElement;\n};\n\ninterface HTMLDirectoryElement extends HTMLElement {\n    compact: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDirectoryElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLDirectoryElement: {\n    prototype: HTMLDirectoryElement;\n    new(): HTMLDirectoryElement;\n};\n\ninterface HTMLDivElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    align: string;\n    /**\n     * Sets or retrieves whether the browser automatically performs wordwrap.\n     */\n    noWrap: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDivElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLDivElement: {\n    prototype: HTMLDivElement;\n    new(): HTMLDivElement;\n};\n\ninterface HTMLDListElement extends HTMLElement {\n    compact: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDListElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLDListElement: {\n    prototype: HTMLDListElement;\n    new(): HTMLDListElement;\n};\n\ninterface HTMLDocument extends Document {\n    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: HTMLDocument, ev: DocumentEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLDocument: {\n    prototype: HTMLDocument;\n    new(): HTMLDocument;\n};\n\ninterface HTMLElementEventMap extends ElementEventMap {\n    \"abort\": UIEvent;\n    \"activate\": UIEvent;\n    \"beforeactivate\": UIEvent;\n    \"beforecopy\": ClipboardEvent;\n    \"beforecut\": ClipboardEvent;\n    \"beforedeactivate\": UIEvent;\n    \"beforepaste\": ClipboardEvent;\n    \"blur\": FocusEvent;\n    \"canplay\": Event;\n    \"canplaythrough\": Event;\n    \"change\": Event;\n    \"click\": MouseEvent;\n    \"contextmenu\": PointerEvent;\n    \"copy\": ClipboardEvent;\n    \"cuechange\": Event;\n    \"cut\": ClipboardEvent;\n    \"dblclick\": MouseEvent;\n    \"deactivate\": UIEvent;\n    \"drag\": DragEvent;\n    \"dragend\": DragEvent;\n    \"dragenter\": DragEvent;\n    \"dragleave\": DragEvent;\n    \"dragover\": DragEvent;\n    \"dragstart\": DragEvent;\n    \"drop\": DragEvent;\n    \"durationchange\": Event;\n    \"emptied\": Event;\n    \"ended\": MediaStreamErrorEvent;\n    \"error\": ErrorEvent;\n    \"focus\": FocusEvent;\n    \"input\": Event;\n    \"invalid\": Event;\n    \"keydown\": KeyboardEvent;\n    \"keypress\": KeyboardEvent;\n    \"keyup\": KeyboardEvent;\n    \"load\": Event;\n    \"loadeddata\": Event;\n    \"loadedmetadata\": Event;\n    \"loadstart\": Event;\n    \"mousedown\": MouseEvent;\n    \"mouseenter\": MouseEvent;\n    \"mouseleave\": MouseEvent;\n    \"mousemove\": MouseEvent;\n    \"mouseout\": MouseEvent;\n    \"mouseover\": MouseEvent;\n    \"mouseup\": MouseEvent;\n    \"mousewheel\": WheelEvent;\n    \"MSContentZoom\": UIEvent;\n    \"MSManipulationStateChanged\": MSManipulationEvent;\n    \"paste\": ClipboardEvent;\n    \"pause\": Event;\n    \"play\": Event;\n    \"playing\": Event;\n    \"progress\": ProgressEvent;\n    \"ratechange\": Event;\n    \"reset\": Event;\n    \"scroll\": UIEvent;\n    \"seeked\": Event;\n    \"seeking\": Event;\n    \"select\": UIEvent;\n    \"selectstart\": Event;\n    \"stalled\": Event;\n    \"submit\": Event;\n    \"suspend\": Event;\n    \"timeupdate\": Event;\n    \"volumechange\": Event;\n    \"waiting\": Event;\n}\n\ninterface HTMLElement extends Element {\n    accessKey: string;\n    readonly children: HTMLCollection;\n    contentEditable: string;\n    readonly dataset: DOMStringMap;\n    dir: string;\n    draggable: boolean;\n    hidden: boolean;\n    hideFocus: boolean;\n    innerText: string;\n    readonly isContentEditable: boolean;\n    lang: string;\n    readonly offsetHeight: number;\n    readonly offsetLeft: number;\n    readonly offsetParent: Element;\n    readonly offsetTop: number;\n    readonly offsetWidth: number;\n    onabort: (this: HTMLElement, ev: UIEvent) => any;\n    onactivate: (this: HTMLElement, ev: UIEvent) => any;\n    onbeforeactivate: (this: HTMLElement, ev: UIEvent) => any;\n    onbeforecopy: (this: HTMLElement, ev: ClipboardEvent) => any;\n    onbeforecut: (this: HTMLElement, ev: ClipboardEvent) => any;\n    onbeforedeactivate: (this: HTMLElement, ev: UIEvent) => any;\n    onbeforepaste: (this: HTMLElement, ev: ClipboardEvent) => any;\n    onblur: (this: HTMLElement, ev: FocusEvent) => any;\n    oncanplay: (this: HTMLElement, ev: Event) => any;\n    oncanplaythrough: (this: HTMLElement, ev: Event) => any;\n    onchange: (this: HTMLElement, ev: Event) => any;\n    onclick: (this: HTMLElement, ev: MouseEvent) => any;\n    oncontextmenu: (this: HTMLElement, ev: PointerEvent) => any;\n    oncopy: (this: HTMLElement, ev: ClipboardEvent) => any;\n    oncuechange: (this: HTMLElement, ev: Event) => any;\n    oncut: (this: HTMLElement, ev: ClipboardEvent) => any;\n    ondblclick: (this: HTMLElement, ev: MouseEvent) => any;\n    ondeactivate: (this: HTMLElement, ev: UIEvent) => any;\n    ondrag: (this: HTMLElement, ev: DragEvent) => any;\n    ondragend: (this: HTMLElement, ev: DragEvent) => any;\n    ondragenter: (this: HTMLElement, ev: DragEvent) => any;\n    ondragleave: (this: HTMLElement, ev: DragEvent) => any;\n    ondragover: (this: HTMLElement, ev: DragEvent) => any;\n    ondragstart: (this: HTMLElement, ev: DragEvent) => any;\n    ondrop: (this: HTMLElement, ev: DragEvent) => any;\n    ondurationchange: (this: HTMLElement, ev: Event) => any;\n    onemptied: (this: HTMLElement, ev: Event) => any;\n    onended: (this: HTMLElement, ev: MediaStreamErrorEvent) => any;\n    onerror: (this: HTMLElement, ev: ErrorEvent) => any;\n    onfocus: (this: HTMLElement, ev: FocusEvent) => any;\n    oninput: (this: HTMLElement, ev: Event) => any;\n    oninvalid: (this: HTMLElement, ev: Event) => any;\n    onkeydown: (this: HTMLElement, ev: KeyboardEvent) => any;\n    onkeypress: (this: HTMLElement, ev: KeyboardEvent) => any;\n    onkeyup: (this: HTMLElement, ev: KeyboardEvent) => any;\n    onload: (this: HTMLElement, ev: Event) => any;\n    onloadeddata: (this: HTMLElement, ev: Event) => any;\n    onloadedmetadata: (this: HTMLElement, ev: Event) => any;\n    onloadstart: (this: HTMLElement, ev: Event) => any;\n    onmousedown: (this: HTMLElement, ev: MouseEvent) => any;\n    onmouseenter: (this: HTMLElement, ev: MouseEvent) => any;\n    onmouseleave: (this: HTMLElement, ev: MouseEvent) => any;\n    onmousemove: (this: HTMLElement, ev: MouseEvent) => any;\n    onmouseout: (this: HTMLElement, ev: MouseEvent) => any;\n    onmouseover: (this: HTMLElement, ev: MouseEvent) => any;\n    onmouseup: (this: HTMLElement, ev: MouseEvent) => any;\n    onmousewheel: (this: HTMLElement, ev: WheelEvent) => any;\n    onmscontentzoom: (this: HTMLElement, ev: UIEvent) => any;\n    onmsmanipulationstatechanged: (this: HTMLElement, ev: MSManipulationEvent) => any;\n    onpaste: (this: HTMLElement, ev: ClipboardEvent) => any;\n    onpause: (this: HTMLElement, ev: Event) => any;\n    onplay: (this: HTMLElement, ev: Event) => any;\n    onplaying: (this: HTMLElement, ev: Event) => any;\n    onprogress: (this: HTMLElement, ev: ProgressEvent) => any;\n    onratechange: (this: HTMLElement, ev: Event) => any;\n    onreset: (this: HTMLElement, ev: Event) => any;\n    onscroll: (this: HTMLElement, ev: UIEvent) => any;\n    onseeked: (this: HTMLElement, ev: Event) => any;\n    onseeking: (this: HTMLElement, ev: Event) => any;\n    onselect: (this: HTMLElement, ev: UIEvent) => any;\n    onselectstart: (this: HTMLElement, ev: Event) => any;\n    onstalled: (this: HTMLElement, ev: Event) => any;\n    onsubmit: (this: HTMLElement, ev: Event) => any;\n    onsuspend: (this: HTMLElement, ev: Event) => any;\n    ontimeupdate: (this: HTMLElement, ev: Event) => any;\n    onvolumechange: (this: HTMLElement, ev: Event) => any;\n    onwaiting: (this: HTMLElement, ev: Event) => any;\n    outerText: string;\n    spellcheck: boolean;\n    readonly style: CSSStyleDeclaration;\n    tabIndex: number;\n    title: string;\n    blur(): void;\n    click(): void;\n    dragDrop(): boolean;\n    focus(): void;\n    msGetInputContext(): MSInputMethodContext;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLElement: {\n    prototype: HTMLElement;\n    new(): HTMLElement;\n};\n\ninterface HTMLEmbedElement extends HTMLElement, GetSVGDocument {\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: string;\n    hidden: any;\n    /**\n     * Gets or sets whether the DLNA PlayTo device is available.\n     */\n    msPlayToDisabled: boolean;\n    /**\n     * Gets or sets the path to the preferred media source. This enables the Play To target device to stream the media content, which can be DRM protected, from a different location, such as a cloud media server.\n     */\n    msPlayToPreferredSourceUri: string;\n    /**\n     * Gets or sets the primary DLNA PlayTo device.\n     */\n    msPlayToPrimary: boolean;\n    /**\n     * Gets the source associated with the media element for use by the PlayToManager.\n     */\n    readonly msPlayToSource: any;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    /**\n     * Retrieves the palette used for the embedded document.\n     */\n    readonly palette: string;\n    /**\n     * Retrieves the URL of the plug-in used to view an embedded document.\n     */\n    readonly pluginspage: string;\n    readonly readyState: string;\n    /**\n     * Sets or retrieves a URL to be loaded by the object.\n     */\n    src: string;\n    /**\n     * Sets or retrieves the height and width units of the embed object.\n     */\n    units: string;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLEmbedElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLEmbedElement: {\n    prototype: HTMLEmbedElement;\n    new(): HTMLEmbedElement;\n};\n\ninterface HTMLFieldSetElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    align: string;\n    disabled: boolean;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement;\n    name: string;\n    /**\n     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting.\n     */\n    readonly validationMessage: string;\n    /**\n     * Returns a  ValidityState object that represents the validity states of an element.\n     */\n    readonly validity: ValidityState;\n    /**\n     * Returns whether an element will successfully validate based on forms validation rules and constraints.\n     */\n    readonly willValidate: boolean;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFieldSetElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLFieldSetElement: {\n    prototype: HTMLFieldSetElement;\n    new(): HTMLFieldSetElement;\n};\n\ninterface HTMLFontElement extends HTMLElement, DOML2DeprecatedColorProperty, DOML2DeprecatedSizeProperty {\n    /**\n     * Sets or retrieves the current typeface family.\n     */\n    face: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFontElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLFontElement: {\n    prototype: HTMLFontElement;\n    new(): HTMLFontElement;\n};\n\ninterface HTMLFormControlsCollection extends HTMLCollectionBase {\n    namedItem(name: string): HTMLCollection | Element | null;\n}\n\ndeclare var HTMLFormControlsCollection: {\n    prototype: HTMLFormControlsCollection;\n    new(): HTMLFormControlsCollection;\n};\n\ninterface HTMLFormElement extends HTMLElement {\n    /**\n     * Sets or retrieves a list of character encodings for input data that must be accepted by the server processing the form.\n     */\n    acceptCharset: string;\n    /**\n     * Sets or retrieves the URL to which the form content is sent for processing.\n     */\n    action: string;\n    /**\n     * Specifies whether autocomplete is applied to an editable text field.\n     */\n    autocomplete: string;\n    /**\n     * Retrieves a collection, in source order, of all controls in a given form.\n     */\n    readonly elements: HTMLFormControlsCollection;\n    /**\n     * Sets or retrieves the MIME encoding for the form.\n     */\n    encoding: string;\n    /**\n     * Sets or retrieves the encoding type for the form.\n     */\n    enctype: string;\n    /**\n     * Sets or retrieves the number of objects in a collection.\n     */\n    readonly length: number;\n    /**\n     * Sets or retrieves how to send the form data to the server.\n     */\n    method: string;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    /**\n     * Designates a form that is not validated when submitted.\n     */\n    noValidate: boolean;\n    /**\n     * Sets or retrieves the window or frame at which to target content.\n     */\n    target: string;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    /**\n     * Retrieves a form object or an object from an elements collection.\n     * @param name Variant of type Number or String that specifies the object or collection to retrieve. If this parameter is a Number, it is the zero-based index of the object. If this parameter is a string, all objects with matching name or id properties are retrieved, and a collection is returned if more than one match is made.\n     * @param index Variant of type Number that specifies the zero-based index of the object to retrieve when a collection is returned.\n     */\n    item(name?: any, index?: any): any;\n    /**\n     * Retrieves a form object or an object from an elements collection.\n     */\n    namedItem(name: string): any;\n    /**\n     * Fires when the user resets a form.\n     */\n    reset(): void;\n    /**\n     * Fires when a FORM is about to be submitted.\n     */\n    submit(): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFormElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n    [name: string]: any;\n}\n\ndeclare var HTMLFormElement: {\n    prototype: HTMLFormElement;\n    new(): HTMLFormElement;\n};\n\ninterface HTMLFrameElementEventMap extends HTMLElementEventMap {\n    \"load\": Event;\n}\n\ninterface HTMLFrameElement extends HTMLElement, GetSVGDocument {\n    /**\n     * Specifies the properties of a border drawn around an object.\n     */\n    border: string;\n    /**\n     * Sets or retrieves the border color of the object.\n     */\n    borderColor: any;\n    /**\n     * Retrieves the document object of the page or frame.\n     */\n    readonly contentDocument: Document;\n    /**\n     * Retrieves the object of the specified.\n     */\n    readonly contentWindow: Window;\n    /**\n     * Sets or retrieves whether to display a border for the frame.\n     */\n    frameBorder: string;\n    /**\n     * Sets or retrieves the amount of additional space between the frames.\n     */\n    frameSpacing: any;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: string | number;\n    /**\n     * Sets or retrieves a URI to a long description of the object.\n     */\n    longDesc: string;\n    /**\n     * Sets or retrieves the top and bottom margin heights before displaying the text in a frame.\n     */\n    marginHeight: string;\n    /**\n     * Sets or retrieves the left and right margin widths before displaying the text in a frame.\n     */\n    marginWidth: string;\n    /**\n     * Sets or retrieves the frame name.\n     */\n    name: string;\n    /**\n     * Sets or retrieves whether the user can resize the frame.\n     */\n    noResize: boolean;\n    /**\n     * Raised when the object has been completely received from the server.\n     */\n    onload: (this: HTMLFrameElement, ev: Event) => any;\n    /**\n     * Sets or retrieves whether the frame can be scrolled.\n     */\n    scrolling: string;\n    /**\n     * Sets or retrieves a URL to be loaded by the object.\n     */\n    src: string;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: string | number;\n    addEventListener<K extends keyof HTMLFrameElementEventMap>(type: K, listener: (this: HTMLFrameElement, ev: HTMLFrameElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLFrameElement: {\n    prototype: HTMLFrameElement;\n    new(): HTMLFrameElement;\n};\n\ninterface HTMLFrameSetElementEventMap extends HTMLElementEventMap {\n    \"afterprint\": Event;\n    \"beforeprint\": Event;\n    \"beforeunload\": BeforeUnloadEvent;\n    \"blur\": FocusEvent;\n    \"error\": ErrorEvent;\n    \"focus\": FocusEvent;\n    \"hashchange\": HashChangeEvent;\n    \"load\": Event;\n    \"message\": MessageEvent;\n    \"offline\": Event;\n    \"online\": Event;\n    \"orientationchange\": Event;\n    \"pagehide\": PageTransitionEvent;\n    \"pageshow\": PageTransitionEvent;\n    \"popstate\": PopStateEvent;\n    \"resize\": UIEvent;\n    \"scroll\": UIEvent;\n    \"storage\": StorageEvent;\n    \"unload\": Event;\n}\n\ninterface HTMLFrameSetElement extends HTMLElement {\n    border: string;\n    /**\n     * Sets or retrieves the border color of the object.\n     */\n    borderColor: any;\n    /**\n     * Sets or retrieves the frame widths of the object.\n     */\n    cols: string;\n    /**\n     * Sets or retrieves whether to display a border for the frame.\n     */\n    frameBorder: string;\n    /**\n     * Sets or retrieves the amount of additional space between the frames.\n     */\n    frameSpacing: any;\n    name: string;\n    onafterprint: (this: HTMLFrameSetElement, ev: Event) => any;\n    onbeforeprint: (this: HTMLFrameSetElement, ev: Event) => any;\n    onbeforeunload: (this: HTMLFrameSetElement, ev: BeforeUnloadEvent) => any;\n    /**\n     * Fires when the object loses the input focus.\n     */\n    onblur: (this: HTMLFrameSetElement, ev: FocusEvent) => any;\n    onerror: (this: HTMLFrameSetElement, ev: ErrorEvent) => any;\n    /**\n     * Fires when the object receives focus.\n     */\n    onfocus: (this: HTMLFrameSetElement, ev: FocusEvent) => any;\n    onhashchange: (this: HTMLFrameSetElement, ev: HashChangeEvent) => any;\n    onload: (this: HTMLFrameSetElement, ev: Event) => any;\n    onmessage: (this: HTMLFrameSetElement, ev: MessageEvent) => any;\n    onoffline: (this: HTMLFrameSetElement, ev: Event) => any;\n    ononline: (this: HTMLFrameSetElement, ev: Event) => any;\n    onorientationchange: (this: HTMLFrameSetElement, ev: Event) => any;\n    onpagehide: (this: HTMLFrameSetElement, ev: PageTransitionEvent) => any;\n    onpageshow: (this: HTMLFrameSetElement, ev: PageTransitionEvent) => any;\n    onpopstate: (this: HTMLFrameSetElement, ev: PopStateEvent) => any;\n    onresize: (this: HTMLFrameSetElement, ev: UIEvent) => any;\n    onscroll: (this: HTMLFrameSetElement, ev: UIEvent) => any;\n    onstorage: (this: HTMLFrameSetElement, ev: StorageEvent) => any;\n    onunload: (this: HTMLFrameSetElement, ev: Event) => any;\n    /**\n     * Sets or retrieves the frame heights of the object.\n     */\n    rows: string;\n    addEventListener<K extends keyof HTMLFrameSetElementEventMap>(type: K, listener: (this: HTMLFrameSetElement, ev: HTMLFrameSetElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLFrameSetElement: {\n    prototype: HTMLFrameSetElement;\n    new(): HTMLFrameSetElement;\n};\n\ninterface HTMLHeadElement extends HTMLElement {\n    profile: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLHeadElement: {\n    prototype: HTMLHeadElement;\n    new(): HTMLHeadElement;\n};\n\ninterface HTMLHeadingElement extends HTMLElement {\n    /**\n     * Sets or retrieves a value that indicates the table alignment.\n     */\n    align: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadingElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLHeadingElement: {\n    prototype: HTMLHeadingElement;\n    new(): HTMLHeadingElement;\n};\n\ninterface HTMLHRElement extends HTMLElement, DOML2DeprecatedColorProperty, DOML2DeprecatedSizeProperty {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    align: string;\n    /**\n     * Sets or retrieves whether the horizontal rule is drawn with 3-D shading.\n     */\n    noShade: boolean;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHRElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLHRElement: {\n    prototype: HTMLHRElement;\n    new(): HTMLHRElement;\n};\n\ninterface HTMLHtmlElement extends HTMLElement {\n    /**\n     * Sets or retrieves the DTD version that governs the current document.\n     */\n    version: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHtmlElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLHtmlElement: {\n    prototype: HTMLHtmlElement;\n    new(): HTMLHtmlElement;\n};\n\ninterface HTMLIFrameElementEventMap extends HTMLElementEventMap {\n    \"load\": Event;\n}\n\ninterface HTMLIFrameElement extends HTMLElement, GetSVGDocument {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    align: string;\n    allowFullscreen: boolean;\n    allowPaymentRequest: boolean;\n    /**\n     * Specifies the properties of a border drawn around an object.\n     */\n    border: string;\n    /**\n     * Retrieves the document object of the page or frame.\n     */\n    readonly contentDocument: Document;\n    /**\n     * Retrieves the object of the specified.\n     */\n    readonly contentWindow: Window;\n    /**\n     * Sets or retrieves whether to display a border for the frame.\n     */\n    frameBorder: string;\n    /**\n     * Sets or retrieves the amount of additional space between the frames.\n     */\n    frameSpacing: any;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: string;\n    /**\n     * Sets or retrieves the horizontal margin for the object.\n     */\n    hspace: number;\n    /**\n     * Sets or retrieves a URI to a long description of the object.\n     */\n    longDesc: string;\n    /**\n     * Sets or retrieves the top and bottom margin heights before displaying the text in a frame.\n     */\n    marginHeight: string;\n    /**\n     * Sets or retrieves the left and right margin widths before displaying the text in a frame.\n     */\n    marginWidth: string;\n    /**\n     * Sets or retrieves the frame name.\n     */\n    name: string;\n    /**\n     * Sets or retrieves whether the user can resize the frame.\n     */\n    noResize: boolean;\n    /**\n     * Raised when the object has been completely received from the server.\n     */\n    onload: (this: HTMLIFrameElement, ev: Event) => any;\n    readonly sandbox: DOMSettableTokenList;\n    /**\n     * Sets or retrieves whether the frame can be scrolled.\n     */\n    scrolling: string;\n    /**\n     * Sets or retrieves a URL to be loaded by the object.\n     */\n    src: string;\n    /**\n     * Sets or retrieves the vertical margin for the object.\n     */\n    vspace: number;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: string;\n    addEventListener<K extends keyof HTMLIFrameElementEventMap>(type: K, listener: (this: HTMLIFrameElement, ev: HTMLIFrameElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLIFrameElement: {\n    prototype: HTMLIFrameElement;\n    new(): HTMLIFrameElement;\n};\n\ninterface HTMLImageElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    align: string;\n    /**\n     * Sets or retrieves a text alternative to the graphic.\n     */\n    alt: string;\n    /**\n     * Specifies the properties of a border drawn around an object.\n     */\n    border: string;\n    /**\n     * Retrieves whether the object is fully loaded.\n     */\n    readonly complete: boolean;\n    crossOrigin: string | null;\n    readonly currentSrc: string;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: number;\n    /**\n     * Sets or retrieves the width of the border to draw around the object.\n     */\n    hspace: number;\n    /**\n     * Sets or retrieves whether the image is a server-side image map.\n     */\n    isMap: boolean;\n    /**\n     * Sets or retrieves a Uniform Resource Identifier (URI) to a long description of the object.\n     */\n    longDesc: string;\n    lowsrc: string;\n    /**\n     * Gets or sets whether the DLNA PlayTo device is available.\n     */\n    msPlayToDisabled: boolean;\n    msPlayToPreferredSourceUri: string;\n    /**\n     * Gets or sets the primary DLNA PlayTo device.\n     */\n    msPlayToPrimary: boolean;\n    /**\n     * Gets the source associated with the media element for use by the PlayToManager.\n     */\n    readonly msPlayToSource: any;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    /**\n     * The original height of the image resource before sizing.\n     */\n    readonly naturalHeight: number;\n    /**\n     * The original width of the image resource before sizing.\n     */\n    readonly naturalWidth: number;\n    sizes: string;\n    /**\n     * The address or URL of the a media resource that is to be considered.\n     */\n    src: string;\n    srcset: string;\n    /**\n     * Sets or retrieves the URL, often with a bookmark extension (#name), to use as a client-side image map.\n     */\n    useMap: string;\n    /**\n     * Sets or retrieves the vertical margin for the object.\n     */\n    vspace: number;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: number;\n    readonly x: number;\n    readonly y: number;\n    msGetAsCastingSource(): any;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLImageElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLImageElement: {\n    prototype: HTMLImageElement;\n    new(): HTMLImageElement;\n};\n\ninterface HTMLInputElement extends HTMLElement {\n    /**\n     * Sets or retrieves a comma-separated list of content types.\n     */\n    accept: string;\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    align: string;\n    /**\n     * Sets or retrieves a text alternative to the graphic.\n     */\n    alt: string;\n    /**\n     * Specifies whether autocomplete is applied to an editable text field.\n     */\n    autocomplete: string;\n    /**\n     * Provides a way to direct a user to a specific field when a document loads. This can provide both direction and convenience for a user, reducing the need to click or tab to a field when a page opens. This attribute is true when present on an element, and false when missing.\n     */\n    autofocus: boolean;\n    /**\n     * Sets or retrieves the width of the border to draw around the object.\n     */\n    border: string;\n    /**\n     * Sets or retrieves the state of the check box or radio button.\n     */\n    checked: boolean;\n    /**\n     * Retrieves whether the object is fully loaded.\n     */\n    readonly complete: boolean;\n    /**\n     * Sets or retrieves the state of the check box or radio button.\n     */\n    defaultChecked: boolean;\n    /**\n     * Sets or retrieves the initial contents of the object.\n     */\n    defaultValue: string;\n    disabled: boolean;\n    /**\n     * Returns a FileList object on a file type input object.\n     */\n    readonly files: FileList | null;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement;\n    /**\n     * Overrides the action attribute (where the data on a form is sent) on the parent form element.\n     */\n    formAction: string;\n    /**\n     * Used to override the encoding (formEnctype attribute) specified on the form element.\n     */\n    formEnctype: string;\n    /**\n     * Overrides the submit method attribute previously specified on a form element.\n     */\n    formMethod: string;\n    /**\n     * Overrides any validation or required attributes on a form or form elements to allow it to be submitted without validation. This can be used to create a \"save draft\"-type submit option.\n     */\n    formNoValidate: string;\n    /**\n     * Overrides the target attribute on a form element.\n     */\n    formTarget: string;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: string;\n    /**\n     * Sets or retrieves the width of the border to draw around the object.\n     */\n    hspace: number;\n    indeterminate: boolean;\n    /**\n     * Specifies the ID of a pre-defined datalist of options for an input element.\n     */\n    readonly list: HTMLElement;\n    /**\n     * Defines the maximum acceptable value for an input element with type=\"number\".When used with the min and step attributes, lets you control the range and increment (such as only even numbers) that the user can enter into an input field.\n     */\n    max: string;\n    /**\n     * Sets or retrieves the maximum number of characters that the user can enter in a text control.\n     */\n    maxLength: number;\n    /**\n     * Defines the minimum acceptable value for an input element with type=\"number\". When used with the max and step attributes, lets you control the range and increment (such as even numbers only) that the user can enter into an input field.\n     */\n    min: string;\n    /**\n     * Sets or retrieves the Boolean value indicating whether multiple items can be selected from a list.\n     */\n    multiple: boolean;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    /**\n     * Gets or sets a string containing a regular expression that the user's input must match.\n     */\n    pattern: string;\n    /**\n     * Gets or sets a text string that is displayed in an input field as a hint or prompt to users as the format or type of information they need to enter.The text appears in an input field until the user puts focus on the field.\n     */\n    placeholder: string;\n    readOnly: boolean;\n    /**\n     * When present, marks an element that can't be submitted without a value.\n     */\n    required: boolean;\n    selectionDirection: string;\n    /**\n     * Gets or sets the end position or offset of a text selection.\n     */\n    selectionEnd: number;\n    /**\n     * Gets or sets the starting position or offset of a text selection.\n     */\n    selectionStart: number;\n    size: number;\n    /**\n     * The address or URL of the a media resource that is to be considered.\n     */\n    src: string;\n    status: boolean;\n    /**\n     * Defines an increment or jump between values that you want to allow the user to enter. When used with the max and min attributes, lets you control the range and increment (for example, allow only even numbers) that the user can enter into an input field.\n     */\n    step: string;\n    /**\n     * Returns the content type of the object.\n     */\n    type: string;\n    /**\n     * Sets or retrieves the URL, often with a bookmark extension (#name), to use as a client-side image map.\n     */\n    useMap: string;\n    /**\n     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting.\n     */\n    readonly validationMessage: string;\n    /**\n     * Returns a  ValidityState object that represents the validity states of an element.\n     */\n    readonly validity: ValidityState;\n    /**\n     * Returns the value of the data at the cursor's current position.\n     */\n    value: string;\n    valueAsDate: Date;\n    /**\n     * Returns the input field value as a number.\n     */\n    valueAsNumber: number;\n    /**\n     * Sets or retrieves the vertical margin for the object.\n     */\n    vspace: number;\n    webkitdirectory: boolean;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: string;\n    /**\n     * Returns whether an element will successfully validate based on forms validation rules and constraints.\n     */\n    readonly willValidate: boolean;\n    minLength: number;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    /**\n     * Makes the selection equal to the current object.\n     */\n    select(): void;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    /**\n     * Sets the start and end positions of a selection in a text field.\n     * @param start The offset into the text field for the start of the selection.\n     * @param end The offset into the text field for the end of the selection.\n     */\n    setSelectionRange(start?: number, end?: number, direction?: string): void;\n    /**\n     * Decrements a range input control's value by the value given by the Step attribute. If the optional parameter is used, it will decrement the input control's step value multiplied by the parameter's value.\n     * @param n Value to decrement the value by.\n     */\n    stepDown(n?: number): void;\n    /**\n     * Increments a range input control's value by the value given by the Step attribute. If the optional parameter is used, will increment the input control's value by that value.\n     * @param n Value to increment the value by.\n     */\n    stepUp(n?: number): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLInputElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLInputElement: {\n    prototype: HTMLInputElement;\n    new(): HTMLInputElement;\n};\n\ninterface HTMLLabelElement extends HTMLElement {\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement;\n    /**\n     * Sets or retrieves the object to which the given label object is assigned.\n     */\n    htmlFor: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLabelElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLLabelElement: {\n    prototype: HTMLLabelElement;\n    new(): HTMLLabelElement;\n};\n\ninterface HTMLLegendElement extends HTMLElement {\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    align: string;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLegendElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLLegendElement: {\n    prototype: HTMLLegendElement;\n    new(): HTMLLegendElement;\n};\n\ninterface HTMLLIElement extends HTMLElement {\n    type: string;\n    /**\n     * Sets or retrieves the value of a list item.\n     */\n    value: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLIElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLLIElement: {\n    prototype: HTMLLIElement;\n    new(): HTMLLIElement;\n};\n\ninterface HTMLLinkElement extends HTMLElement, LinkStyle {\n    /**\n     * Sets or retrieves the character set used to encode the object.\n     */\n    charset: string;\n    disabled: boolean;\n    /**\n     * Sets or retrieves a destination URL or an anchor point.\n     */\n    href: string;\n    /**\n     * Sets or retrieves the language code of the object.\n     */\n    hreflang: string;\n    /**\n     * Sets or retrieves the media type.\n     */\n    media: string;\n    /**\n     * Sets or retrieves the relationship between the object and the destination of the link.\n     */\n    rel: string;\n    /**\n     * Sets or retrieves the relationship between the object and the destination of the link.\n     */\n    rev: string;\n    /**\n     * Sets or retrieves the window or frame at which to target content.\n     */\n    target: string;\n    /**\n     * Sets or retrieves the MIME type of the object.\n     */\n    type: string;\n    import?: Document;\n    integrity: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLinkElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLLinkElement: {\n    prototype: HTMLLinkElement;\n    new(): HTMLLinkElement;\n};\n\ninterface HTMLMapElement extends HTMLElement {\n    /**\n     * Retrieves a collection of the area objects defined for the given map object.\n     */\n    readonly areas: HTMLAreasCollection;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMapElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLMapElement: {\n    prototype: HTMLMapElement;\n    new(): HTMLMapElement;\n};\n\ninterface HTMLMarqueeElementEventMap extends HTMLElementEventMap {\n    \"bounce\": Event;\n    \"finish\": Event;\n    \"start\": Event;\n}\n\ninterface HTMLMarqueeElement extends HTMLElement {\n    behavior: string;\n    bgColor: any;\n    direction: string;\n    height: string;\n    hspace: number;\n    loop: number;\n    onbounce: (this: HTMLMarqueeElement, ev: Event) => any;\n    onfinish: (this: HTMLMarqueeElement, ev: Event) => any;\n    onstart: (this: HTMLMarqueeElement, ev: Event) => any;\n    scrollAmount: number;\n    scrollDelay: number;\n    trueSpeed: boolean;\n    vspace: number;\n    width: string;\n    start(): void;\n    stop(): void;\n    addEventListener<K extends keyof HTMLMarqueeElementEventMap>(type: K, listener: (this: HTMLMarqueeElement, ev: HTMLMarqueeElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLMarqueeElement: {\n    prototype: HTMLMarqueeElement;\n    new(): HTMLMarqueeElement;\n};\n\ninterface HTMLMediaElementEventMap extends HTMLElementEventMap {\n    \"encrypted\": MediaEncryptedEvent;\n    \"msneedkey\": MSMediaKeyNeededEvent;\n}\n\ninterface HTMLMediaElement extends HTMLElement {\n    /**\n     * Returns an AudioTrackList object with the audio tracks for a given video element.\n     */\n    readonly audioTracks: AudioTrackList;\n    /**\n     * Gets or sets a value that indicates whether to start playing the media automatically.\n     */\n    autoplay: boolean;\n    /**\n     * Gets a collection of buffered time ranges.\n     */\n    readonly buffered: TimeRanges;\n    /**\n     * Gets or sets a flag that indicates whether the client provides a set of controls for the media (in case the developer does not include controls for the player).\n     */\n    controls: boolean;\n    crossOrigin: string | null;\n    /**\n     * Gets the address or URL of the current media resource that is selected by IHTMLMediaElement.\n     */\n    readonly currentSrc: string;\n    /**\n     * Gets or sets the current playback position, in seconds.\n     */\n    currentTime: number;\n    defaultMuted: boolean;\n    /**\n     * Gets or sets the default playback rate when the user is not using fast forward or reverse for a video or audio resource.\n     */\n    defaultPlaybackRate: number;\n    /**\n     * Returns the duration in seconds of the current media resource. A NaN value is returned if duration is not available, or Infinity if the media resource is streaming.\n     */\n    readonly duration: number;\n    /**\n     * Gets information about whether the playback has ended or not.\n     */\n    readonly ended: boolean;\n    /**\n     * Returns an object representing the current error state of the audio or video element.\n     */\n    readonly error: MediaError;\n    /**\n     * Gets or sets a flag to specify whether playback should restart after it completes.\n     */\n    loop: boolean;\n    readonly mediaKeys: MediaKeys | null;\n    /**\n     * Specifies the purpose of the audio or video media, such as background audio or alerts.\n     */\n    msAudioCategory: string;\n    /**\n     * Specifies the output device id that the audio will be sent to.\n     */\n    msAudioDeviceType: string;\n    readonly msGraphicsTrustStatus: MSGraphicsTrust;\n    /**\n     * Gets the MSMediaKeys object, which is used for decrypting media data, that is associated with this media element.\n     */\n    readonly msKeys: MSMediaKeys;\n    /**\n     * Gets or sets whether the DLNA PlayTo device is available.\n     */\n    msPlayToDisabled: boolean;\n    /**\n     * Gets or sets the path to the preferred media source. This enables the Play To target device to stream the media content, which can be DRM protected, from a different location, such as a cloud media server.\n     */\n    msPlayToPreferredSourceUri: string;\n    /**\n     * Gets or sets the primary DLNA PlayTo device.\n     */\n    msPlayToPrimary: boolean;\n    /**\n     * Gets the source associated with the media element for use by the PlayToManager.\n     */\n    readonly msPlayToSource: any;\n    /**\n     * Specifies whether or not to enable low-latency playback on the media element.\n     */\n    msRealTime: boolean;\n    /**\n     * Gets or sets a flag that indicates whether the audio (either audio or the audio track on video media) is muted.\n     */\n    muted: boolean;\n    /**\n     * Gets the current network activity for the element.\n     */\n    readonly networkState: number;\n    onencrypted: (this: HTMLMediaElement, ev: MediaEncryptedEvent) => any;\n    onmsneedkey: (this: HTMLMediaElement, ev: MSMediaKeyNeededEvent) => any;\n    /**\n     * Gets a flag that specifies whether playback is paused.\n     */\n    readonly paused: boolean;\n    /**\n     * Gets or sets the current rate of speed for the media resource to play. This speed is expressed as a multiple of the normal speed of the media resource.\n     */\n    playbackRate: number;\n    /**\n     * Gets TimeRanges for the current media resource that has been played.\n     */\n    readonly played: TimeRanges;\n    /**\n     * Gets or sets the current playback position, in seconds.\n     */\n    preload: string;\n    readyState: number;\n    /**\n     * Returns a TimeRanges object that represents the ranges of the current media resource that can be seeked.\n     */\n    readonly seekable: TimeRanges;\n    /**\n     * Gets a flag that indicates whether the the client is currently moving to a new playback position in the media resource.\n     */\n    readonly seeking: boolean;\n    /**\n     * The address or URL of the a media resource that is to be considered.\n     */\n    src: string;\n    srcObject: MediaStream | null;\n    readonly textTracks: TextTrackList;\n    readonly videoTracks: VideoTrackList;\n    /**\n     * Gets or sets the volume level for audio portions of the media element.\n     */\n    volume: number;\n    addTextTrack(kind: string, label?: string, language?: string): TextTrack;\n    /**\n     * Returns a string that specifies whether the client can play a given media resource type.\n     */\n    canPlayType(type: string): string;\n    /**\n     * Resets the audio or video object and loads a new media resource.\n     */\n    load(): void;\n    /**\n     * Clears all effects from the media pipeline.\n     */\n    msClearEffects(): void;\n    msGetAsCastingSource(): any;\n    /**\n     * Inserts the specified audio effect into media pipeline.\n     */\n    msInsertAudioEffect(activatableClassId: string, effectRequired: boolean, config?: any): void;\n    msSetMediaKeys(mediaKeys: MSMediaKeys): void;\n    /**\n     * Specifies the media protection manager for a given media pipeline.\n     */\n    msSetMediaProtectionManager(mediaProtectionManager?: any): void;\n    /**\n     * Pauses the current playback and sets paused to TRUE. This can be used to test whether the media is playing or paused. You can also use the pause or play events to tell whether the media is playing or not.\n     */\n    pause(): void;\n    /**\n     * Loads and starts playback of a media resource.\n     */\n    play(): Promise<void>;\n    setMediaKeys(mediaKeys: MediaKeys | null): Promise<void>;\n    readonly HAVE_CURRENT_DATA: number;\n    readonly HAVE_ENOUGH_DATA: number;\n    readonly HAVE_FUTURE_DATA: number;\n    readonly HAVE_METADATA: number;\n    readonly HAVE_NOTHING: number;\n    readonly NETWORK_EMPTY: number;\n    readonly NETWORK_IDLE: number;\n    readonly NETWORK_LOADING: number;\n    readonly NETWORK_NO_SOURCE: number;\n    addEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLMediaElement, ev: HTMLMediaElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLMediaElement: {\n    prototype: HTMLMediaElement;\n    new(): HTMLMediaElement;\n    readonly HAVE_CURRENT_DATA: number;\n    readonly HAVE_ENOUGH_DATA: number;\n    readonly HAVE_FUTURE_DATA: number;\n    readonly HAVE_METADATA: number;\n    readonly HAVE_NOTHING: number;\n    readonly NETWORK_EMPTY: number;\n    readonly NETWORK_IDLE: number;\n    readonly NETWORK_LOADING: number;\n    readonly NETWORK_NO_SOURCE: number;\n};\n\ninterface HTMLMenuElement extends HTMLElement {\n    compact: boolean;\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMenuElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLMenuElement: {\n    prototype: HTMLMenuElement;\n    new(): HTMLMenuElement;\n};\n\ninterface HTMLMetaElement extends HTMLElement {\n    /**\n     * Sets or retrieves the character set used to encode the object.\n     */\n    charset: string;\n    /**\n     * Gets or sets meta-information to associate with httpEquiv or name.\n     */\n    content: string;\n    /**\n     * Gets or sets information used to bind the value of a content attribute of a meta element to an HTTP response header.\n     */\n    httpEquiv: string;\n    /**\n     * Sets or retrieves the value specified in the content attribute of the meta object.\n     */\n    name: string;\n    /**\n     * Sets or retrieves a scheme to be used in interpreting the value of a property specified for the object.\n     */\n    scheme: string;\n    /**\n     * Sets or retrieves the URL property that will be loaded after the specified time has elapsed.\n     */\n    url: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMetaElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLMetaElement: {\n    prototype: HTMLMetaElement;\n    new(): HTMLMetaElement;\n};\n\ninterface HTMLMeterElement extends HTMLElement {\n    high: number;\n    low: number;\n    max: number;\n    min: number;\n    optimum: number;\n    value: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMeterElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLMeterElement: {\n    prototype: HTMLMeterElement;\n    new(): HTMLMeterElement;\n};\n\ninterface HTMLModElement extends HTMLElement {\n    /**\n     * Sets or retrieves reference information about the object.\n     */\n    cite: string;\n    /**\n     * Sets or retrieves the date and time of a modification to the object.\n     */\n    dateTime: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLModElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLModElement: {\n    prototype: HTMLModElement;\n    new(): HTMLModElement;\n};\n\ninterface HTMLObjectElement extends HTMLElement, GetSVGDocument {\n    align: string;\n    /**\n     * Sets or retrieves a text alternative to the graphic.\n     */\n    alt: string;\n    /**\n     * Gets or sets the optional alternative HTML script to execute if the object fails to load.\n     */\n    altHtml: string;\n    /**\n     * Sets or retrieves a character string that can be used to implement your own archive functionality for the object.\n     */\n    archive: string;\n    /**\n     * Retrieves a string of the URL where the object tag can be found. This is often the href of the document that the object is in, or the value set by a base element.\n     */\n    readonly BaseHref: string;\n    border: string;\n    /**\n     * Sets or retrieves the URL of the file containing the compiled Java class.\n     */\n    code: string;\n    /**\n     * Sets or retrieves the URL of the component.\n     */\n    codeBase: string;\n    /**\n     * Sets or retrieves the Internet media type for the code associated with the object.\n     */\n    codeType: string;\n    /**\n     * Retrieves the document object of the page or frame.\n     */\n    readonly contentDocument: Document;\n    /**\n     * Sets or retrieves the URL that references the data of the object.\n     */\n    data: string;\n    declare: boolean;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: string;\n    hspace: number;\n    /**\n     * Gets or sets whether the DLNA PlayTo device is available.\n     */\n    msPlayToDisabled: boolean;\n    /**\n     * Gets or sets the path to the preferred media source. This enables the Play To target device to stream the media content, which can be DRM protected, from a different location, such as a cloud media server.\n     */\n    msPlayToPreferredSourceUri: string;\n    /**\n     * Gets or sets the primary DLNA PlayTo device.\n     */\n    msPlayToPrimary: boolean;\n    /**\n     * Gets the source associated with the media element for use by the PlayToManager.\n     */\n    readonly msPlayToSource: any;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    readonly readyState: number;\n    /**\n     * Sets or retrieves a message to be displayed while an object is loading.\n     */\n    standby: string;\n    /**\n     * Sets or retrieves the MIME type of the object.\n     */\n    type: string;\n    /**\n     * Sets or retrieves the URL, often with a bookmark extension (#name), to use as a client-side image map.\n     */\n    useMap: string;\n    /**\n     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting.\n     */\n    readonly validationMessage: string;\n    /**\n     * Returns a  ValidityState object that represents the validity states of an element.\n     */\n    readonly validity: ValidityState;\n    vspace: number;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: string;\n    /**\n     * Returns whether an element will successfully validate based on forms validation rules and constraints.\n     */\n    readonly willValidate: boolean;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLObjectElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLObjectElement: {\n    prototype: HTMLObjectElement;\n    new(): HTMLObjectElement;\n};\n\ninterface HTMLOListElement extends HTMLElement {\n    compact: boolean;\n    /**\n     * The starting number.\n     */\n    start: number;\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOListElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLOListElement: {\n    prototype: HTMLOListElement;\n    new(): HTMLOListElement;\n};\n\ninterface HTMLOptGroupElement extends HTMLElement {\n    /**\n     * Sets or retrieves the status of an option.\n     */\n    defaultSelected: boolean;\n    disabled: boolean;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement;\n    /**\n     * Sets or retrieves the ordinal position of an option in a list box.\n     */\n    readonly index: number;\n    /**\n     * Sets or retrieves a value that you can use to implement your own label functionality for the object.\n     */\n    label: string;\n    /**\n     * Sets or retrieves whether the option in the list box is the default item.\n     */\n    selected: boolean;\n    /**\n     * Sets or retrieves the text string specified by the option tag.\n     */\n    readonly text: string;\n    /**\n     * Sets or retrieves the value which is returned to the server when the form control is submitted.\n     */\n    value: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptGroupElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLOptGroupElement: {\n    prototype: HTMLOptGroupElement;\n    new(): HTMLOptGroupElement;\n};\n\ninterface HTMLOptionElement extends HTMLElement {\n    /**\n     * Sets or retrieves the status of an option.\n     */\n    defaultSelected: boolean;\n    disabled: boolean;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement;\n    /**\n     * Sets or retrieves the ordinal position of an option in a list box.\n     */\n    readonly index: number;\n    /**\n     * Sets or retrieves a value that you can use to implement your own label functionality for the object.\n     */\n    label: string;\n    /**\n     * Sets or retrieves whether the option in the list box is the default item.\n     */\n    selected: boolean;\n    /**\n     * Sets or retrieves the text string specified by the option tag.\n     */\n    text: string;\n    /**\n     * Sets or retrieves the value which is returned to the server when the form control is submitted.\n     */\n    value: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptionElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLOptionElement: {\n    prototype: HTMLOptionElement;\n    new(): HTMLOptionElement;\n};\n\ninterface HTMLOptionsCollection extends HTMLCollectionOf<HTMLOptionElement> {\n    length: number;\n    selectedIndex: number;\n    add(element: HTMLOptionElement | HTMLOptGroupElement, before?: HTMLElement | number): void;\n    remove(index: number): void;\n}\n\ndeclare var HTMLOptionsCollection: {\n    prototype: HTMLOptionsCollection;\n    new(): HTMLOptionsCollection;\n};\n\ninterface HTMLOutputElement extends HTMLElement {\n    defaultValue: string;\n    readonly form: HTMLFormElement;\n    readonly htmlFor: DOMSettableTokenList;\n    name: string;\n    readonly type: string;\n    readonly validationMessage: string;\n    readonly validity: ValidityState;\n    value: string;\n    readonly willValidate: boolean;\n    checkValidity(): boolean;\n    reportValidity(): boolean;\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOutputElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLOutputElement: {\n    prototype: HTMLOutputElement;\n    new(): HTMLOutputElement;\n};\n\ninterface HTMLParagraphElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    align: string;\n    clear: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParagraphElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLParagraphElement: {\n    prototype: HTMLParagraphElement;\n    new(): HTMLParagraphElement;\n};\n\ninterface HTMLParamElement extends HTMLElement {\n    /**\n     * Sets or retrieves the name of an input parameter for an element.\n     */\n    name: string;\n    /**\n     * Sets or retrieves the content type of the resource designated by the value attribute.\n     */\n    type: string;\n    /**\n     * Sets or retrieves the value of an input parameter for an element.\n     */\n    value: string;\n    /**\n     * Sets or retrieves the data type of the value attribute.\n     */\n    valueType: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParamElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLParamElement: {\n    prototype: HTMLParamElement;\n    new(): HTMLParamElement;\n};\n\ninterface HTMLPictureElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPictureElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLPictureElement: {\n    prototype: HTMLPictureElement;\n    new(): HTMLPictureElement;\n};\n\ninterface HTMLPreElement extends HTMLElement {\n    /**\n     * Sets or gets a value that you can use to implement your own width functionality for the object.\n     */\n    width: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPreElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLPreElement: {\n    prototype: HTMLPreElement;\n    new(): HTMLPreElement;\n};\n\ninterface HTMLProgressElement extends HTMLElement {\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement;\n    /**\n     * Defines the maximum, or \"done\" value for a progress element.\n     */\n    max: number;\n    /**\n     * Returns the quotient of value/max when the value attribute is set (determinate progress bar), or -1 when the value attribute is missing (indeterminate progress bar).\n     */\n    readonly position: number;\n    /**\n     * Sets or gets the current value of a progress element. The value must be a non-negative number between 0 and the max value.\n     */\n    value: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLProgressElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLProgressElement: {\n    prototype: HTMLProgressElement;\n    new(): HTMLProgressElement;\n};\n\ninterface HTMLQuoteElement extends HTMLElement {\n    /**\n     * Sets or retrieves reference information about the object.\n     */\n    cite: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLQuoteElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLQuoteElement: {\n    prototype: HTMLQuoteElement;\n    new(): HTMLQuoteElement;\n};\n\ninterface HTMLScriptElement extends HTMLElement {\n    async: boolean;\n    /**\n     * Sets or retrieves the character set used to encode the object.\n     */\n    charset: string;\n    crossOrigin: string | null;\n    /**\n     * Sets or retrieves the status of the script.\n     */\n    defer: boolean;\n    /**\n     * Sets or retrieves the event for which the script is written.\n     */\n    event: string;\n    /**\n     * Sets or retrieves the object that is bound to the event script.\n     */\n    htmlFor: string;\n    /**\n     * Retrieves the URL to an external file that contains the source code or data.\n     */\n    src: string;\n    /**\n     * Retrieves or sets the text of the object as a string.\n     */\n    text: string;\n    /**\n     * Sets or retrieves the MIME type for the associated scripting engine.\n     */\n    type: string;\n    integrity: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLScriptElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLScriptElement: {\n    prototype: HTMLScriptElement;\n    new(): HTMLScriptElement;\n};\n\ninterface HTMLSelectElement extends HTMLElement {\n    /**\n     * Provides a way to direct a user to a specific field when a document loads. This can provide both direction and convenience for a user, reducing the need to click or tab to a field when a page opens. This attribute is true when present on an element, and false when missing.\n     */\n    autofocus: boolean;\n    disabled: boolean;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement;\n    /**\n     * Sets or retrieves the number of objects in a collection.\n     */\n    length: number;\n    /**\n     * Sets or retrieves the Boolean value indicating whether multiple items can be selected from a list.\n     */\n    multiple: boolean;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    readonly options: HTMLOptionsCollection;\n    /**\n     * When present, marks an element that can't be submitted without a value.\n     */\n    required: boolean;\n    /**\n     * Sets or retrieves the index of the selected option in a select object.\n     */\n    selectedIndex: number;\n    selectedOptions: HTMLCollectionOf<HTMLOptionElement>;\n    /**\n     * Sets or retrieves the number of rows in the list box.\n     */\n    size: number;\n    /**\n     * Retrieves the type of select control based on the value of the MULTIPLE attribute.\n     */\n    readonly type: string;\n    /**\n     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting.\n     */\n    readonly validationMessage: string;\n    /**\n     * Returns a  ValidityState object that represents the validity states of an element.\n     */\n    readonly validity: ValidityState;\n    /**\n     * Sets or retrieves the value which is returned to the server when the form control is submitted.\n     */\n    value: string;\n    /**\n     * Returns whether an element will successfully validate based on forms validation rules and constraints.\n     */\n    readonly willValidate: boolean;\n    /**\n     * Adds an element to the areas, controlRange, or options collection.\n     * @param element Variant of type Number that specifies the index position in the collection where the element is placed. If no value is given, the method places the element at the end of the collection.\n     * @param before Variant of type Object that specifies an element to insert before, or null to append the object to the collection.\n     */\n    add(element: HTMLElement, before?: HTMLElement | number): void;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    /**\n     * Retrieves a select object or an object from an options collection.\n     * @param name Variant of type Number or String that specifies the object or collection to retrieve. If this parameter is an integer, it is the zero-based index of the object. If this parameter is a string, all objects with matching name or id properties are retrieved, and a collection is returned if more than one match is made.\n     * @param index Variant of type Number that specifies the zero-based index of the object to retrieve when a collection is returned.\n     */\n    item(name?: any, index?: any): any;\n    /**\n     * Retrieves a select object or an object from an options collection.\n     * @param namedItem A String that specifies the name or id property of the object to retrieve. A collection is returned if more than one match is made.\n     */\n    namedItem(name: string): any;\n    /**\n     * Removes an element from the collection.\n     * @param index Number that specifies the zero-based index of the element to remove from the collection.\n     */\n    remove(index?: number): void;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSelectElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n    [name: string]: any;\n}\n\ndeclare var HTMLSelectElement: {\n    prototype: HTMLSelectElement;\n    new(): HTMLSelectElement;\n};\n\ninterface HTMLSourceElement extends HTMLElement {\n    /**\n     * Gets or sets the intended media type of the media source.\n     */\n    media: string;\n    msKeySystem: string;\n    sizes: string;\n    /**\n     * The address or URL of the a media resource that is to be considered.\n     */\n    src: string;\n    srcset: string;\n    /**\n     * Gets or sets the MIME type of a media resource.\n     */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSourceElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLSourceElement: {\n    prototype: HTMLSourceElement;\n    new(): HTMLSourceElement;\n};\n\ninterface HTMLSpanElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSpanElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLSpanElement: {\n    prototype: HTMLSpanElement;\n    new(): HTMLSpanElement;\n};\n\ninterface HTMLStyleElement extends HTMLElement, LinkStyle {\n    disabled: boolean;\n    /**\n     * Sets or retrieves the media type.\n     */\n    media: string;\n    /**\n     * Retrieves the CSS language in which the style sheet is written.\n     */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLStyleElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLStyleElement: {\n    prototype: HTMLStyleElement;\n    new(): HTMLStyleElement;\n};\n\ninterface HTMLTableCaptionElement extends HTMLElement {\n    /**\n     * Sets or retrieves the alignment of the caption or legend.\n     */\n    align: string;\n    /**\n     * Sets or retrieves whether the caption appears at the top or bottom of the table.\n     */\n    vAlign: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCaptionElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLTableCaptionElement: {\n    prototype: HTMLTableCaptionElement;\n    new(): HTMLTableCaptionElement;\n};\n\ninterface HTMLTableCellElement extends HTMLElement, HTMLTableAlignment {\n    /**\n     * Sets or retrieves abbreviated text for the object.\n     */\n    abbr: string;\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    align: string;\n    /**\n     * Sets or retrieves a comma-delimited list of conceptual categories associated with the object.\n     */\n    axis: string;\n    bgColor: any;\n    /**\n     * Retrieves the position of the object in the cells collection of a row.\n     */\n    readonly cellIndex: number;\n    /**\n     * Sets or retrieves the number columns in the table that the object should span.\n     */\n    colSpan: number;\n    /**\n     * Sets or retrieves a list of header cells that provide information for the object.\n     */\n    headers: string;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: any;\n    /**\n     * Sets or retrieves whether the browser automatically performs wordwrap.\n     */\n    noWrap: boolean;\n    /**\n     * Sets or retrieves how many rows in a table the cell should span.\n     */\n    rowSpan: number;\n    /**\n     * Sets or retrieves the group of cells in a table to which the object's information applies.\n     */\n    scope: string;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCellElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLTableCellElement: {\n    prototype: HTMLTableCellElement;\n    new(): HTMLTableCellElement;\n};\n\ninterface HTMLTableColElement extends HTMLElement, HTMLTableAlignment {\n    /**\n     * Sets or retrieves the alignment of the object relative to the display or table.\n     */\n    align: string;\n    /**\n     * Sets or retrieves the number of columns in the group.\n     */\n    span: number;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: any;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableColElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLTableColElement: {\n    prototype: HTMLTableColElement;\n    new(): HTMLTableColElement;\n};\n\ninterface HTMLTableDataCellElement extends HTMLTableCellElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableDataCellElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLTableDataCellElement: {\n    prototype: HTMLTableDataCellElement;\n    new(): HTMLTableDataCellElement;\n};\n\ninterface HTMLTableElement extends HTMLElement {\n    /**\n     * Sets or retrieves a value that indicates the table alignment.\n     */\n    align: string;\n    bgColor: any;\n    /**\n     * Sets or retrieves the width of the border to draw around the object.\n     */\n    border: string;\n    /**\n     * Sets or retrieves the border color of the object.\n     */\n    borderColor: any;\n    /**\n     * Retrieves the caption object of a table.\n     */\n    caption: HTMLTableCaptionElement;\n    /**\n     * Sets or retrieves the amount of space between the border of the cell and the content of the cell.\n     */\n    cellPadding: string;\n    /**\n     * Sets or retrieves the amount of space between cells in a table.\n     */\n    cellSpacing: string;\n    /**\n     * Sets or retrieves the number of columns in the table.\n     */\n    cols: number;\n    /**\n     * Sets or retrieves the way the border frame around the table is displayed.\n     */\n    frame: string;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: any;\n    /**\n     * Sets or retrieves the number of horizontal rows contained in the object.\n     */\n    rows: HTMLCollectionOf<HTMLTableRowElement>;\n    /**\n     * Sets or retrieves which dividing lines (inner borders) are displayed.\n     */\n    rules: string;\n    /**\n     * Sets or retrieves a description and/or structure of the object.\n     */\n    summary: string;\n    /**\n     * Retrieves a collection of all tBody objects in the table. Objects in this collection are in source order.\n     */\n    tBodies: HTMLCollectionOf<HTMLTableSectionElement>;\n    /**\n     * Retrieves the tFoot object of the table.\n     */\n    tFoot: HTMLTableSectionElement;\n    /**\n     * Retrieves the tHead object of the table.\n     */\n    tHead: HTMLTableSectionElement;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: string;\n    /**\n     * Creates an empty caption element in the table.\n     */\n    createCaption(): HTMLTableCaptionElement;\n    /**\n     * Creates an empty tBody element in the table.\n     */\n    createTBody(): HTMLTableSectionElement;\n    /**\n     * Creates an empty tFoot element in the table.\n     */\n    createTFoot(): HTMLTableSectionElement;\n    /**\n     * Returns the tHead element object if successful, or null otherwise.\n     */\n    createTHead(): HTMLTableSectionElement;\n    /**\n     * Deletes the caption element and its contents from the table.\n     */\n    deleteCaption(): void;\n    /**\n     * Removes the specified row (tr) from the element and from the rows collection.\n     * @param index Number that specifies the zero-based position in the rows collection of the row to remove.\n     */\n    deleteRow(index?: number): void;\n    /**\n     * Deletes the tFoot element and its contents from the table.\n     */\n    deleteTFoot(): void;\n    /**\n     * Deletes the tHead element and its contents from the table.\n     */\n    deleteTHead(): void;\n    /**\n     * Creates a new row (tr) in the table, and adds the row to the rows collection.\n     * @param index Number that specifies where to insert the row in the rows collection. The default value is -1, which appends the new row to the end of the rows collection.\n     */\n    insertRow(index?: number): HTMLTableRowElement;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLTableElement: {\n    prototype: HTMLTableElement;\n    new(): HTMLTableElement;\n};\n\ninterface HTMLTableHeaderCellElement extends HTMLTableCellElement {\n    /**\n     * Sets or retrieves the group of cells in a table to which the object's information applies.\n     */\n    scope: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableHeaderCellElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLTableHeaderCellElement: {\n    prototype: HTMLTableHeaderCellElement;\n    new(): HTMLTableHeaderCellElement;\n};\n\ninterface HTMLTableRowElement extends HTMLElement, HTMLTableAlignment {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    align: string;\n    bgColor: any;\n    /**\n     * Retrieves a collection of all cells in the table row.\n     */\n    cells: HTMLCollectionOf<HTMLTableDataCellElement | HTMLTableHeaderCellElement>;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: any;\n    /**\n     * Retrieves the position of the object in the rows collection for the table.\n     */\n    readonly rowIndex: number;\n    /**\n     * Retrieves the position of the object in the collection.\n     */\n    readonly sectionRowIndex: number;\n    /**\n     * Removes the specified cell from the table row, as well as from the cells collection.\n     * @param index Number that specifies the zero-based position of the cell to remove from the table row. If no value is provided, the last cell in the cells collection is deleted.\n     */\n    deleteCell(index?: number): void;\n    /**\n     * Creates a new cell in the table row, and adds the cell to the cells collection.\n     * @param index Number that specifies where to insert the cell in the tr. The default value is -1, which appends the new cell to the end of the cells collection.\n     */\n    insertCell(index?: number): HTMLTableDataCellElement;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableRowElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLTableRowElement: {\n    prototype: HTMLTableRowElement;\n    new(): HTMLTableRowElement;\n};\n\ninterface HTMLTableSectionElement extends HTMLElement, HTMLTableAlignment {\n    /**\n     * Sets or retrieves a value that indicates the table alignment.\n     */\n    align: string;\n    /**\n     * Sets or retrieves the number of horizontal rows contained in the object.\n     */\n    rows: HTMLCollectionOf<HTMLTableRowElement>;\n    /**\n     * Removes the specified row (tr) from the element and from the rows collection.\n     * @param index Number that specifies the zero-based position in the rows collection of the row to remove.\n     */\n    deleteRow(index?: number): void;\n    /**\n     * Creates a new row (tr) in the table, and adds the row to the rows collection.\n     * @param index Number that specifies where to insert the row in the rows collection. The default value is -1, which appends the new row to the end of the rows collection.\n     */\n    insertRow(index?: number): HTMLTableRowElement;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableSectionElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLTableSectionElement: {\n    prototype: HTMLTableSectionElement;\n    new(): HTMLTableSectionElement;\n};\n\ninterface HTMLTemplateElement extends HTMLElement {\n    readonly content: DocumentFragment;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTemplateElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLTemplateElement: {\n    prototype: HTMLTemplateElement;\n    new(): HTMLTemplateElement;\n};\n\ninterface HTMLTextAreaElement extends HTMLElement {\n    /**\n     * Provides a way to direct a user to a specific field when a document loads. This can provide both direction and convenience for a user, reducing the need to click or tab to a field when a page opens. This attribute is true when present on an element, and false when missing.\n     */\n    autofocus: boolean;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    cols: number;\n    /**\n     * Sets or retrieves the initial contents of the object.\n     */\n    defaultValue: string;\n    disabled: boolean;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement;\n    /**\n     * Sets or retrieves the maximum number of characters that the user can enter in a text control.\n     */\n    maxLength: number;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    /**\n     * Gets or sets a text string that is displayed in an input field as a hint or prompt to users as the format or type of information they need to enter.The text appears in an input field until the user puts focus on the field.\n     */\n    placeholder: string;\n    /**\n     * Sets or retrieves the value indicated whether the content of the object is read-only.\n     */\n    readOnly: boolean;\n    /**\n     * When present, marks an element that can't be submitted without a value.\n     */\n    required: boolean;\n    /**\n     * Sets or retrieves the number of horizontal rows contained in the object.\n     */\n    rows: number;\n    /**\n     * Gets or sets the end position or offset of a text selection.\n     */\n    selectionEnd: number;\n    /**\n     * Gets or sets the starting position or offset of a text selection.\n     */\n    selectionStart: number;\n    /**\n     * Sets or retrieves the value indicating whether the control is selected.\n     */\n    status: any;\n    /**\n     * Retrieves the type of control.\n     */\n    readonly type: string;\n    /**\n     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting.\n     */\n    readonly validationMessage: string;\n    /**\n     * Returns a  ValidityState object that represents the validity states of an element.\n     */\n    readonly validity: ValidityState;\n    /**\n     * Retrieves or sets the text in the entry field of the textArea element.\n     */\n    value: string;\n    /**\n     * Returns whether an element will successfully validate based on forms validation rules and constraints.\n     */\n    readonly willValidate: boolean;\n    /**\n     * Sets or retrieves how to handle wordwrapping in the object.\n     */\n    wrap: string;\n    minLength: number;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    /**\n     * Highlights the input area of a form element.\n     */\n    select(): void;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    /**\n     * Sets the start and end positions of a selection in a text field.\n     * @param start The offset into the text field for the start of the selection.\n     * @param end The offset into the text field for the end of the selection.\n     */\n    setSelectionRange(start: number, end: number): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTextAreaElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLTextAreaElement: {\n    prototype: HTMLTextAreaElement;\n    new(): HTMLTextAreaElement;\n};\n\ninterface HTMLTimeElement extends HTMLElement {\n    dateTime: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTimeElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLTimeElement: {\n    prototype: HTMLTimeElement;\n    new(): HTMLTimeElement;\n};\n\ninterface HTMLTitleElement extends HTMLElement {\n    /**\n     * Retrieves or sets the text of the object as a string.\n     */\n    text: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTitleElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLTitleElement: {\n    prototype: HTMLTitleElement;\n    new(): HTMLTitleElement;\n};\n\ninterface HTMLTrackElement extends HTMLElement {\n    default: boolean;\n    kind: string;\n    label: string;\n    readonly readyState: number;\n    src: string;\n    srclang: string;\n    readonly track: TextTrack;\n    readonly ERROR: number;\n    readonly LOADED: number;\n    readonly LOADING: number;\n    readonly NONE: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTrackElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLTrackElement: {\n    prototype: HTMLTrackElement;\n    new(): HTMLTrackElement;\n    readonly ERROR: number;\n    readonly LOADED: number;\n    readonly LOADING: number;\n    readonly NONE: number;\n};\n\ninterface HTMLUListElement extends HTMLElement {\n    compact: boolean;\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUListElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLUListElement: {\n    prototype: HTMLUListElement;\n    new(): HTMLUListElement;\n};\n\ninterface HTMLUnknownElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUnknownElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLUnknownElement: {\n    prototype: HTMLUnknownElement;\n    new(): HTMLUnknownElement;\n};\n\ninterface HTMLVideoElementEventMap extends HTMLMediaElementEventMap {\n    \"MSVideoFormatChanged\": Event;\n    \"MSVideoFrameStepCompleted\": Event;\n    \"MSVideoOptimalLayoutChanged\": Event;\n}\n\ninterface HTMLVideoElement extends HTMLMediaElement {\n    /**\n     * Gets or sets the height of the video element.\n     */\n    height: number;\n    msHorizontalMirror: boolean;\n    readonly msIsLayoutOptimalForPlayback: boolean;\n    readonly msIsStereo3D: boolean;\n    msStereo3DPackingMode: string;\n    msStereo3DRenderMode: string;\n    msZoom: boolean;\n    onMSVideoFormatChanged: (this: HTMLVideoElement, ev: Event) => any;\n    onMSVideoFrameStepCompleted: (this: HTMLVideoElement, ev: Event) => any;\n    onMSVideoOptimalLayoutChanged: (this: HTMLVideoElement, ev: Event) => any;\n    /**\n     * Gets or sets a URL of an image to display, for example, like a movie poster. This can be a still frame from the video, or another image if no video data is available.\n     */\n    poster: string;\n    /**\n     * Gets the intrinsic height of a video in CSS pixels, or zero if the dimensions are not known.\n     */\n    readonly videoHeight: number;\n    /**\n     * Gets the intrinsic width of a video in CSS pixels, or zero if the dimensions are not known.\n     */\n    readonly videoWidth: number;\n    readonly webkitDisplayingFullscreen: boolean;\n    readonly webkitSupportsFullscreen: boolean;\n    /**\n     * Gets or sets the width of the video element.\n     */\n    width: number;\n    getVideoPlaybackQuality(): VideoPlaybackQuality;\n    msFrameStep(forward: boolean): void;\n    msInsertVideoEffect(activatableClassId: string, effectRequired: boolean, config?: any): void;\n    msSetVideoRectangle(left: number, top: number, right: number, bottom: number): void;\n    webkitEnterFullscreen(): void;\n    webkitEnterFullScreen(): void;\n    webkitExitFullscreen(): void;\n    webkitExitFullScreen(): void;\n    addEventListener<K extends keyof HTMLVideoElementEventMap>(type: K, listener: (this: HTMLVideoElement, ev: HTMLVideoElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var HTMLVideoElement: {\n    prototype: HTMLVideoElement;\n    new(): HTMLVideoElement;\n};\n\ninterface IDBCursor {\n    readonly direction: IDBCursorDirection;\n    key: IDBKeyRange | IDBValidKey;\n    readonly primaryKey: any;\n    source: IDBObjectStore | IDBIndex;\n    advance(count: number): void;\n    continue(key?: IDBKeyRange | IDBValidKey): void;\n    delete(): IDBRequest;\n    update(value: any): IDBRequest;\n    readonly NEXT: string;\n    readonly NEXT_NO_DUPLICATE: string;\n    readonly PREV: string;\n    readonly PREV_NO_DUPLICATE: string;\n}\n\ndeclare var IDBCursor: {\n    prototype: IDBCursor;\n    new(): IDBCursor;\n    readonly NEXT: string;\n    readonly NEXT_NO_DUPLICATE: string;\n    readonly PREV: string;\n    readonly PREV_NO_DUPLICATE: string;\n};\n\ninterface IDBCursorWithValue extends IDBCursor {\n    readonly value: any;\n}\n\ndeclare var IDBCursorWithValue: {\n    prototype: IDBCursorWithValue;\n    new(): IDBCursorWithValue;\n};\n\ninterface IDBDatabaseEventMap {\n    \"abort\": Event;\n    \"error\": Event;\n}\n\ninterface IDBDatabase extends EventTarget {\n    readonly name: string;\n    readonly objectStoreNames: DOMStringList;\n    onabort: (this: IDBDatabase, ev: Event) => any;\n    onerror: (this: IDBDatabase, ev: Event) => any;\n    version: number;\n    onversionchange: (ev: IDBVersionChangeEvent) => any;\n    close(): void;\n    createObjectStore(name: string, optionalParameters?: IDBObjectStoreParameters): IDBObjectStore;\n    deleteObjectStore(name: string): void;\n    transaction(storeNames: string | string[], mode?: IDBTransactionMode): IDBTransaction;\n    addEventListener(type: \"versionchange\", listener: (ev: IDBVersionChangeEvent) => any, useCapture?: boolean): void;\n    addEventListener<K extends keyof IDBDatabaseEventMap>(type: K, listener: (this: IDBDatabase, ev: IDBDatabaseEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var IDBDatabase: {\n    prototype: IDBDatabase;\n    new(): IDBDatabase;\n};\n\ninterface IDBFactory {\n    cmp(first: any, second: any): number;\n    deleteDatabase(name: string): IDBOpenDBRequest;\n    open(name: string, version?: number): IDBOpenDBRequest;\n}\n\ndeclare var IDBFactory: {\n    prototype: IDBFactory;\n    new(): IDBFactory;\n};\n\ninterface IDBIndex {\n    keyPath: string | string[];\n    readonly name: string;\n    readonly objectStore: IDBObjectStore;\n    readonly unique: boolean;\n    multiEntry: boolean;\n    count(key?: IDBKeyRange | IDBValidKey): IDBRequest;\n    get(key: IDBKeyRange | IDBValidKey): IDBRequest;\n    getKey(key: IDBKeyRange | IDBValidKey): IDBRequest;\n    openCursor(range?: IDBKeyRange | IDBValidKey, direction?: IDBCursorDirection): IDBRequest;\n    openKeyCursor(range?: IDBKeyRange | IDBValidKey, direction?: IDBCursorDirection): IDBRequest;\n}\n\ndeclare var IDBIndex: {\n    prototype: IDBIndex;\n    new(): IDBIndex;\n};\n\ninterface IDBKeyRange {\n    readonly lower: any;\n    readonly lowerOpen: boolean;\n    readonly upper: any;\n    readonly upperOpen: boolean;\n}\n\ndeclare var IDBKeyRange: {\n    prototype: IDBKeyRange;\n    new(): IDBKeyRange;\n    bound(lower: any, upper: any, lowerOpen?: boolean, upperOpen?: boolean): IDBKeyRange;\n    lowerBound(lower: any, open?: boolean): IDBKeyRange;\n    only(value: any): IDBKeyRange;\n    upperBound(upper: any, open?: boolean): IDBKeyRange;\n};\n\ninterface IDBObjectStore {\n    readonly indexNames: DOMStringList;\n    keyPath: string | string[];\n    readonly name: string;\n    readonly transaction: IDBTransaction;\n    autoIncrement: boolean;\n    add(value: any, key?: IDBKeyRange | IDBValidKey): IDBRequest;\n    clear(): IDBRequest;\n    count(key?: IDBKeyRange | IDBValidKey): IDBRequest;\n    createIndex(name: string, keyPath: string | string[], optionalParameters?: IDBIndexParameters): IDBIndex;\n    delete(key: IDBKeyRange | IDBValidKey): IDBRequest;\n    deleteIndex(indexName: string): void;\n    get(key: any): IDBRequest;\n    index(name: string): IDBIndex;\n    openCursor(range?: IDBKeyRange | IDBValidKey, direction?: IDBCursorDirection): IDBRequest;\n    put(value: any, key?: IDBKeyRange | IDBValidKey): IDBRequest;\n}\n\ndeclare var IDBObjectStore: {\n    prototype: IDBObjectStore;\n    new(): IDBObjectStore;\n};\n\ninterface IDBOpenDBRequestEventMap extends IDBRequestEventMap {\n    \"blocked\": Event;\n    \"upgradeneeded\": IDBVersionChangeEvent;\n}\n\ninterface IDBOpenDBRequest extends IDBRequest {\n    onblocked: (this: IDBOpenDBRequest, ev: Event) => any;\n    onupgradeneeded: (this: IDBOpenDBRequest, ev: IDBVersionChangeEvent) => any;\n    addEventListener<K extends keyof IDBOpenDBRequestEventMap>(type: K, listener: (this: IDBOpenDBRequest, ev: IDBOpenDBRequestEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var IDBOpenDBRequest: {\n    prototype: IDBOpenDBRequest;\n    new(): IDBOpenDBRequest;\n};\n\ninterface IDBRequestEventMap {\n    \"error\": Event;\n    \"success\": Event;\n}\n\ninterface IDBRequest extends EventTarget {\n    readonly error: DOMException;\n    onerror: (this: IDBRequest, ev: Event) => any;\n    onsuccess: (this: IDBRequest, ev: Event) => any;\n    readonly readyState: IDBRequestReadyState;\n    readonly result: any;\n    source: IDBObjectStore | IDBIndex | IDBCursor;\n    readonly transaction: IDBTransaction;\n    addEventListener<K extends keyof IDBRequestEventMap>(type: K, listener: (this: IDBRequest, ev: IDBRequestEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var IDBRequest: {\n    prototype: IDBRequest;\n    new(): IDBRequest;\n};\n\ninterface IDBTransactionEventMap {\n    \"abort\": Event;\n    \"complete\": Event;\n    \"error\": Event;\n}\n\ninterface IDBTransaction extends EventTarget {\n    readonly db: IDBDatabase;\n    readonly error: DOMException;\n    readonly mode: IDBTransactionMode;\n    onabort: (this: IDBTransaction, ev: Event) => any;\n    oncomplete: (this: IDBTransaction, ev: Event) => any;\n    onerror: (this: IDBTransaction, ev: Event) => any;\n    abort(): void;\n    objectStore(name: string): IDBObjectStore;\n    readonly READ_ONLY: string;\n    readonly READ_WRITE: string;\n    readonly VERSION_CHANGE: string;\n    addEventListener<K extends keyof IDBTransactionEventMap>(type: K, listener: (this: IDBTransaction, ev: IDBTransactionEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var IDBTransaction: {\n    prototype: IDBTransaction;\n    new(): IDBTransaction;\n    readonly READ_ONLY: string;\n    readonly READ_WRITE: string;\n    readonly VERSION_CHANGE: string;\n};\n\ninterface IDBVersionChangeEvent extends Event {\n    readonly newVersion: number | null;\n    readonly oldVersion: number;\n}\n\ndeclare var IDBVersionChangeEvent: {\n    prototype: IDBVersionChangeEvent;\n    new(): IDBVersionChangeEvent;\n};\n\ninterface IIRFilterNode extends AudioNode {\n    getFrequencyResponse(frequencyHz: Float32Array, magResponse: Float32Array, phaseResponse: Float32Array): void;\n}\n\ndeclare var IIRFilterNode: {\n    prototype: IIRFilterNode;\n    new(): IIRFilterNode;\n};\n\ninterface ImageData {\n    data: Uint8ClampedArray;\n    readonly height: number;\n    readonly width: number;\n}\n\ndeclare var ImageData: {\n    prototype: ImageData;\n    new(width: number, height: number): ImageData;\n    new(array: Uint8ClampedArray, width: number, height: number): ImageData;\n};\n\ninterface IntersectionObserver {\n    readonly root: Element | null;\n    readonly rootMargin: string;\n    readonly thresholds: number[];\n    disconnect(): void;\n    observe(target: Element): void;\n    takeRecords(): IntersectionObserverEntry[];\n    unobserve(target: Element): void;\n}\n\ndeclare var IntersectionObserver: {\n    prototype: IntersectionObserver;\n    new(callback: IntersectionObserverCallback, options?: IntersectionObserverInit): IntersectionObserver;\n};\n\ninterface IntersectionObserverEntry {\n    readonly boundingClientRect: ClientRect;\n    readonly intersectionRatio: number;\n    readonly intersectionRect: ClientRect;\n    readonly rootBounds: ClientRect;\n    readonly target: Element;\n    readonly time: number;\n}\n\ndeclare var IntersectionObserverEntry: {\n    prototype: IntersectionObserverEntry;\n    new(intersectionObserverEntryInit: IntersectionObserverEntryInit): IntersectionObserverEntry;\n};\n\ninterface KeyboardEvent extends UIEvent {\n    readonly altKey: boolean;\n    readonly char: string | null;\n    readonly charCode: number;\n    readonly ctrlKey: boolean;\n    readonly key: string;\n    readonly keyCode: number;\n    readonly locale: string;\n    readonly location: number;\n    readonly metaKey: boolean;\n    readonly repeat: boolean;\n    readonly shiftKey: boolean;\n    readonly which: number;\n    readonly code: string;\n    getModifierState(keyArg: string): boolean;\n    initKeyboardEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, keyArg: string, locationArg: number, modifiersListArg: string, repeat: boolean, locale: string): void;\n    readonly DOM_KEY_LOCATION_JOYSTICK: number;\n    readonly DOM_KEY_LOCATION_LEFT: number;\n    readonly DOM_KEY_LOCATION_MOBILE: number;\n    readonly DOM_KEY_LOCATION_NUMPAD: number;\n    readonly DOM_KEY_LOCATION_RIGHT: number;\n    readonly DOM_KEY_LOCATION_STANDARD: number;\n}\n\ndeclare var KeyboardEvent: {\n    prototype: KeyboardEvent;\n    new(typeArg: string, eventInitDict?: KeyboardEventInit): KeyboardEvent;\n    readonly DOM_KEY_LOCATION_JOYSTICK: number;\n    readonly DOM_KEY_LOCATION_LEFT: number;\n    readonly DOM_KEY_LOCATION_MOBILE: number;\n    readonly DOM_KEY_LOCATION_NUMPAD: number;\n    readonly DOM_KEY_LOCATION_RIGHT: number;\n    readonly DOM_KEY_LOCATION_STANDARD: number;\n};\n\ninterface ListeningStateChangedEvent extends Event {\n    readonly label: string;\n    readonly state: ListeningState;\n}\n\ndeclare var ListeningStateChangedEvent: {\n    prototype: ListeningStateChangedEvent;\n    new(): ListeningStateChangedEvent;\n};\n\ninterface Location {\n    hash: string;\n    host: string;\n    hostname: string;\n    href: string;\n    readonly origin: string;\n    pathname: string;\n    port: string;\n    protocol: string;\n    search: string;\n    assign(url: string): void;\n    reload(forcedReload?: boolean): void;\n    replace(url: string): void;\n    toString(): string;\n}\n\ndeclare var Location: {\n    prototype: Location;\n    new(): Location;\n};\n\ninterface LongRunningScriptDetectedEvent extends Event {\n    readonly executionTime: number;\n    stopPageScriptExecution: boolean;\n}\n\ndeclare var LongRunningScriptDetectedEvent: {\n    prototype: LongRunningScriptDetectedEvent;\n    new(): LongRunningScriptDetectedEvent;\n};\n\ninterface MediaDeviceInfo {\n    readonly deviceId: string;\n    readonly groupId: string;\n    readonly kind: MediaDeviceKind;\n    readonly label: string;\n}\n\ndeclare var MediaDeviceInfo: {\n    prototype: MediaDeviceInfo;\n    new(): MediaDeviceInfo;\n};\n\ninterface MediaDevicesEventMap {\n    \"devicechange\": Event;\n}\n\ninterface MediaDevices extends EventTarget {\n    ondevicechange: (this: MediaDevices, ev: Event) => any;\n    enumerateDevices(): any;\n    getSupportedConstraints(): MediaTrackSupportedConstraints;\n    getUserMedia(constraints: MediaStreamConstraints): Promise<MediaStream>;\n    addEventListener<K extends keyof MediaDevicesEventMap>(type: K, listener: (this: MediaDevices, ev: MediaDevicesEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var MediaDevices: {\n    prototype: MediaDevices;\n    new(): MediaDevices;\n};\n\ninterface MediaElementAudioSourceNode extends AudioNode {\n}\n\ndeclare var MediaElementAudioSourceNode: {\n    prototype: MediaElementAudioSourceNode;\n    new(): MediaElementAudioSourceNode;\n};\n\ninterface MediaEncryptedEvent extends Event {\n    readonly initData: ArrayBuffer | null;\n    readonly initDataType: string;\n}\n\ndeclare var MediaEncryptedEvent: {\n    prototype: MediaEncryptedEvent;\n    new(type: string, eventInitDict?: MediaEncryptedEventInit): MediaEncryptedEvent;\n};\n\ninterface MediaError {\n    readonly code: number;\n    readonly msExtendedCode: number;\n    readonly MEDIA_ERR_ABORTED: number;\n    readonly MEDIA_ERR_DECODE: number;\n    readonly MEDIA_ERR_NETWORK: number;\n    readonly MEDIA_ERR_SRC_NOT_SUPPORTED: number;\n    readonly MS_MEDIA_ERR_ENCRYPTED: number;\n}\n\ndeclare var MediaError: {\n    prototype: MediaError;\n    new(): MediaError;\n    readonly MEDIA_ERR_ABORTED: number;\n    readonly MEDIA_ERR_DECODE: number;\n    readonly MEDIA_ERR_NETWORK: number;\n    readonly MEDIA_ERR_SRC_NOT_SUPPORTED: number;\n    readonly MS_MEDIA_ERR_ENCRYPTED: number;\n};\n\ninterface MediaKeyMessageEvent extends Event {\n    readonly message: ArrayBuffer;\n    readonly messageType: MediaKeyMessageType;\n}\n\ndeclare var MediaKeyMessageEvent: {\n    prototype: MediaKeyMessageEvent;\n    new(type: string, eventInitDict?: MediaKeyMessageEventInit): MediaKeyMessageEvent;\n};\n\ninterface MediaKeys {\n    createSession(sessionType?: MediaKeySessionType): MediaKeySession;\n    setServerCertificate(serverCertificate: any): Promise<void>;\n}\n\ndeclare var MediaKeys: {\n    prototype: MediaKeys;\n    new(): MediaKeys;\n};\n\ninterface MediaKeySession extends EventTarget {\n    readonly closed: Promise<void>;\n    readonly expiration: number;\n    readonly keyStatuses: MediaKeyStatusMap;\n    readonly sessionId: string;\n    close(): Promise<void>;\n    generateRequest(initDataType: string, initData: any): Promise<void>;\n    load(sessionId: string): Promise<boolean>;\n    remove(): Promise<void>;\n    update(response: any): Promise<void>;\n}\n\ndeclare var MediaKeySession: {\n    prototype: MediaKeySession;\n    new(): MediaKeySession;\n};\n\ninterface MediaKeyStatusMap {\n    readonly size: number;\n    forEach(callback: ForEachCallback): void;\n    get(keyId: any): MediaKeyStatus;\n    has(keyId: any): boolean;\n}\n\ndeclare var MediaKeyStatusMap: {\n    prototype: MediaKeyStatusMap;\n    new(): MediaKeyStatusMap;\n};\n\ninterface MediaKeySystemAccess {\n    readonly keySystem: string;\n    createMediaKeys(): Promise<MediaKeys>;\n    getConfiguration(): MediaKeySystemConfiguration;\n}\n\ndeclare var MediaKeySystemAccess: {\n    prototype: MediaKeySystemAccess;\n    new(): MediaKeySystemAccess;\n};\n\ninterface MediaList {\n    readonly length: number;\n    mediaText: string;\n    appendMedium(newMedium: string): void;\n    deleteMedium(oldMedium: string): void;\n    item(index: number): string;\n    toString(): string;\n    [index: number]: string;\n}\n\ndeclare var MediaList: {\n    prototype: MediaList;\n    new(): MediaList;\n};\n\ninterface MediaQueryList {\n    readonly matches: boolean;\n    readonly media: string;\n    addListener(listener: MediaQueryListListener): void;\n    removeListener(listener: MediaQueryListListener): void;\n}\n\ndeclare var MediaQueryList: {\n    prototype: MediaQueryList;\n    new(): MediaQueryList;\n};\n\ninterface MediaSource extends EventTarget {\n    readonly activeSourceBuffers: SourceBufferList;\n    duration: number;\n    readonly readyState: string;\n    readonly sourceBuffers: SourceBufferList;\n    addSourceBuffer(type: string): SourceBuffer;\n    endOfStream(error?: number): void;\n    removeSourceBuffer(sourceBuffer: SourceBuffer): void;\n}\n\ndeclare var MediaSource: {\n    prototype: MediaSource;\n    new(): MediaSource;\n    isTypeSupported(type: string): boolean;\n};\n\ninterface MediaStreamEventMap {\n    \"active\": Event;\n    \"addtrack\": MediaStreamTrackEvent;\n    \"inactive\": Event;\n    \"removetrack\": MediaStreamTrackEvent;\n}\n\ninterface MediaStream extends EventTarget {\n    readonly active: boolean;\n    readonly id: string;\n    onactive: (this: MediaStream, ev: Event) => any;\n    onaddtrack: (this: MediaStream, ev: MediaStreamTrackEvent) => any;\n    oninactive: (this: MediaStream, ev: Event) => any;\n    onremovetrack: (this: MediaStream, ev: MediaStreamTrackEvent) => any;\n    addTrack(track: MediaStreamTrack): void;\n    clone(): MediaStream;\n    getAudioTracks(): MediaStreamTrack[];\n    getTrackById(trackId: string): MediaStreamTrack | null;\n    getTracks(): MediaStreamTrack[];\n    getVideoTracks(): MediaStreamTrack[];\n    removeTrack(track: MediaStreamTrack): void;\n    stop(): void;\n    addEventListener<K extends keyof MediaStreamEventMap>(type: K, listener: (this: MediaStream, ev: MediaStreamEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var MediaStream: {\n    prototype: MediaStream;\n    new(streamOrTracks?: MediaStream | MediaStreamTrack[]): MediaStream;\n};\n\ninterface MediaStreamAudioSourceNode extends AudioNode {\n}\n\ndeclare var MediaStreamAudioSourceNode: {\n    prototype: MediaStreamAudioSourceNode;\n    new(): MediaStreamAudioSourceNode;\n};\n\ninterface MediaStreamError {\n    readonly constraintName: string | null;\n    readonly message: string | null;\n    readonly name: string;\n}\n\ndeclare var MediaStreamError: {\n    prototype: MediaStreamError;\n    new(): MediaStreamError;\n};\n\ninterface MediaStreamErrorEvent extends Event {\n    readonly error: MediaStreamError | null;\n}\n\ndeclare var MediaStreamErrorEvent: {\n    prototype: MediaStreamErrorEvent;\n    new(typeArg: string, eventInitDict?: MediaStreamErrorEventInit): MediaStreamErrorEvent;\n};\n\ninterface MediaStreamEvent extends Event {\n    readonly stream: MediaStream | null;\n}\n\ndeclare var MediaStreamEvent: {\n    prototype: MediaStreamEvent;\n    new(type: string, eventInitDict: MediaStreamEventInit): MediaStreamEvent;\n};\n\ninterface MediaStreamTrackEventMap {\n    \"ended\": MediaStreamErrorEvent;\n    \"mute\": Event;\n    \"overconstrained\": MediaStreamErrorEvent;\n    \"unmute\": Event;\n}\n\ninterface MediaStreamTrack extends EventTarget {\n    enabled: boolean;\n    readonly id: string;\n    readonly kind: string;\n    readonly label: string;\n    readonly muted: boolean;\n    onended: (this: MediaStreamTrack, ev: MediaStreamErrorEvent) => any;\n    onmute: (this: MediaStreamTrack, ev: Event) => any;\n    onoverconstrained: (this: MediaStreamTrack, ev: MediaStreamErrorEvent) => any;\n    onunmute: (this: MediaStreamTrack, ev: Event) => any;\n    readonly readonly: boolean;\n    readonly readyState: MediaStreamTrackState;\n    readonly remote: boolean;\n    applyConstraints(constraints: MediaTrackConstraints): Promise<void>;\n    clone(): MediaStreamTrack;\n    getCapabilities(): MediaTrackCapabilities;\n    getConstraints(): MediaTrackConstraints;\n    getSettings(): MediaTrackSettings;\n    stop(): void;\n    addEventListener<K extends keyof MediaStreamTrackEventMap>(type: K, listener: (this: MediaStreamTrack, ev: MediaStreamTrackEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var MediaStreamTrack: {\n    prototype: MediaStreamTrack;\n    new(): MediaStreamTrack;\n};\n\ninterface MediaStreamTrackEvent extends Event {\n    readonly track: MediaStreamTrack;\n}\n\ndeclare var MediaStreamTrackEvent: {\n    prototype: MediaStreamTrackEvent;\n    new(typeArg: string, eventInitDict?: MediaStreamTrackEventInit): MediaStreamTrackEvent;\n};\n\ninterface MessageChannel {\n    readonly port1: MessagePort;\n    readonly port2: MessagePort;\n}\n\ndeclare var MessageChannel: {\n    prototype: MessageChannel;\n    new(): MessageChannel;\n};\n\ninterface MessageEvent extends Event {\n    readonly data: any;\n    readonly origin: string;\n    readonly ports: any;\n    readonly source: Window;\n    initMessageEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, dataArg: any, originArg: string, lastEventIdArg: string, sourceArg: Window): void;\n}\n\ndeclare var MessageEvent: {\n    prototype: MessageEvent;\n    new(type: string, eventInitDict?: MessageEventInit): MessageEvent;\n};\n\ninterface MessagePortEventMap {\n    \"message\": MessageEvent;\n}\n\ninterface MessagePort extends EventTarget {\n    onmessage: (this: MessagePort, ev: MessageEvent) => any;\n    close(): void;\n    postMessage(message?: any, transfer?: any[]): void;\n    start(): void;\n    addEventListener<K extends keyof MessagePortEventMap>(type: K, listener: (this: MessagePort, ev: MessagePortEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var MessagePort: {\n    prototype: MessagePort;\n    new(): MessagePort;\n};\n\ninterface MimeType {\n    readonly description: string;\n    readonly enabledPlugin: Plugin;\n    readonly suffixes: string;\n    readonly type: string;\n}\n\ndeclare var MimeType: {\n    prototype: MimeType;\n    new(): MimeType;\n};\n\ninterface MimeTypeArray {\n    readonly length: number;\n    item(index: number): Plugin;\n    namedItem(type: string): Plugin;\n    [index: number]: Plugin;\n}\n\ndeclare var MimeTypeArray: {\n    prototype: MimeTypeArray;\n    new(): MimeTypeArray;\n};\n\ninterface MouseEvent extends UIEvent {\n    readonly altKey: boolean;\n    readonly button: number;\n    readonly buttons: number;\n    readonly clientX: number;\n    readonly clientY: number;\n    readonly ctrlKey: boolean;\n    readonly fromElement: Element;\n    readonly layerX: number;\n    readonly layerY: number;\n    readonly metaKey: boolean;\n    readonly movementX: number;\n    readonly movementY: number;\n    readonly offsetX: number;\n    readonly offsetY: number;\n    readonly pageX: number;\n    readonly pageY: number;\n    readonly relatedTarget: EventTarget;\n    readonly screenX: number;\n    readonly screenY: number;\n    readonly shiftKey: boolean;\n    readonly toElement: Element;\n    readonly which: number;\n    readonly x: number;\n    readonly y: number;\n    getModifierState(keyArg: string): boolean;\n    initMouseEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number, screenXArg: number, screenYArg: number, clientXArg: number, clientYArg: number, ctrlKeyArg: boolean, altKeyArg: boolean, shiftKeyArg: boolean, metaKeyArg: boolean, buttonArg: number, relatedTargetArg: EventTarget | null): void;\n}\n\ndeclare var MouseEvent: {\n    prototype: MouseEvent;\n    new(typeArg: string, eventInitDict?: MouseEventInit): MouseEvent;\n};\n\ninterface MSApp {\n    clearTemporaryWebDataAsync(): MSAppAsyncOperation;\n    createBlobFromRandomAccessStream(type: string, seeker: any): Blob;\n    createDataPackage(object: any): any;\n    createDataPackageFromSelection(): any;\n    createFileFromStorageFile(storageFile: any): File;\n    createStreamFromInputStream(type: string, inputStream: any): MSStream;\n    execAsyncAtPriority(asynchronousCallback: MSExecAtPriorityFunctionCallback, priority: string, ...args: any[]): void;\n    execAtPriority(synchronousCallback: MSExecAtPriorityFunctionCallback, priority: string, ...args: any[]): any;\n    getCurrentPriority(): string;\n    getHtmlPrintDocumentSourceAsync(htmlDoc: any): Promise<any>;\n    getViewId(view: any): any;\n    isTaskScheduledAtPriorityOrHigher(priority: string): boolean;\n    pageHandlesAllApplicationActivations(enabled: boolean): void;\n    suppressSubdownloadCredentialPrompts(suppress: boolean): void;\n    terminateApp(exceptionObject: any): void;\n    readonly CURRENT: string;\n    readonly HIGH: string;\n    readonly IDLE: string;\n    readonly NORMAL: string;\n}\ndeclare var MSApp: MSApp;\n\ninterface MSAppAsyncOperationEventMap {\n    \"complete\": Event;\n    \"error\": Event;\n}\n\ninterface MSAppAsyncOperation extends EventTarget {\n    readonly error: DOMError;\n    oncomplete: (this: MSAppAsyncOperation, ev: Event) => any;\n    onerror: (this: MSAppAsyncOperation, ev: Event) => any;\n    readonly readyState: number;\n    readonly result: any;\n    start(): void;\n    readonly COMPLETED: number;\n    readonly ERROR: number;\n    readonly STARTED: number;\n    addEventListener<K extends keyof MSAppAsyncOperationEventMap>(type: K, listener: (this: MSAppAsyncOperation, ev: MSAppAsyncOperationEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var MSAppAsyncOperation: {\n    prototype: MSAppAsyncOperation;\n    new(): MSAppAsyncOperation;\n    readonly COMPLETED: number;\n    readonly ERROR: number;\n    readonly STARTED: number;\n};\n\ninterface MSAssertion {\n    readonly id: string;\n    readonly type: MSCredentialType;\n}\n\ndeclare var MSAssertion: {\n    prototype: MSAssertion;\n    new(): MSAssertion;\n};\n\ninterface MSBlobBuilder {\n    append(data: any, endings?: string): void;\n    getBlob(contentType?: string): Blob;\n}\n\ndeclare var MSBlobBuilder: {\n    prototype: MSBlobBuilder;\n    new(): MSBlobBuilder;\n};\n\ninterface MSCredentials {\n    getAssertion(challenge: string, filter?: MSCredentialFilter, params?: MSSignatureParameters): Promise<MSAssertion>;\n    makeCredential(accountInfo: MSAccountInfo, params: MSCredentialParameters[], challenge?: string): Promise<MSAssertion>;\n}\n\ndeclare var MSCredentials: {\n    prototype: MSCredentials;\n    new(): MSCredentials;\n};\n\ninterface MSFIDOCredentialAssertion extends MSAssertion {\n    readonly algorithm: string | Algorithm;\n    readonly attestation: any;\n    readonly publicKey: string;\n    readonly transportHints: MSTransportType[];\n}\n\ndeclare var MSFIDOCredentialAssertion: {\n    prototype: MSFIDOCredentialAssertion;\n    new(): MSFIDOCredentialAssertion;\n};\n\ninterface MSFIDOSignature {\n    readonly authnrData: string;\n    readonly clientData: string;\n    readonly signature: string;\n}\n\ndeclare var MSFIDOSignature: {\n    prototype: MSFIDOSignature;\n    new(): MSFIDOSignature;\n};\n\ninterface MSFIDOSignatureAssertion extends MSAssertion {\n    readonly signature: MSFIDOSignature;\n}\n\ndeclare var MSFIDOSignatureAssertion: {\n    prototype: MSFIDOSignatureAssertion;\n    new(): MSFIDOSignatureAssertion;\n};\n\ninterface MSGesture {\n    target: Element;\n    addPointer(pointerId: number): void;\n    stop(): void;\n}\n\ndeclare var MSGesture: {\n    prototype: MSGesture;\n    new(): MSGesture;\n};\n\ninterface MSGestureEvent extends UIEvent {\n    readonly clientX: number;\n    readonly clientY: number;\n    readonly expansion: number;\n    readonly gestureObject: any;\n    readonly hwTimestamp: number;\n    readonly offsetX: number;\n    readonly offsetY: number;\n    readonly rotation: number;\n    readonly scale: number;\n    readonly screenX: number;\n    readonly screenY: number;\n    readonly translationX: number;\n    readonly translationY: number;\n    readonly velocityAngular: number;\n    readonly velocityExpansion: number;\n    readonly velocityX: number;\n    readonly velocityY: number;\n    initGestureEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number, screenXArg: number, screenYArg: number, clientXArg: number, clientYArg: number, offsetXArg: number, offsetYArg: number, translationXArg: number, translationYArg: number, scaleArg: number, expansionArg: number, rotationArg: number, velocityXArg: number, velocityYArg: number, velocityExpansionArg: number, velocityAngularArg: number, hwTimestampArg: number): void;\n    readonly MSGESTURE_FLAG_BEGIN: number;\n    readonly MSGESTURE_FLAG_CANCEL: number;\n    readonly MSGESTURE_FLAG_END: number;\n    readonly MSGESTURE_FLAG_INERTIA: number;\n    readonly MSGESTURE_FLAG_NONE: number;\n}\n\ndeclare var MSGestureEvent: {\n    prototype: MSGestureEvent;\n    new(): MSGestureEvent;\n    readonly MSGESTURE_FLAG_BEGIN: number;\n    readonly MSGESTURE_FLAG_CANCEL: number;\n    readonly MSGESTURE_FLAG_END: number;\n    readonly MSGESTURE_FLAG_INERTIA: number;\n    readonly MSGESTURE_FLAG_NONE: number;\n};\n\ninterface MSGraphicsTrust {\n    readonly constrictionActive: boolean;\n    readonly status: string;\n}\n\ndeclare var MSGraphicsTrust: {\n    prototype: MSGraphicsTrust;\n    new(): MSGraphicsTrust;\n};\n\ninterface MSHTMLWebViewElement extends HTMLElement {\n    readonly canGoBack: boolean;\n    readonly canGoForward: boolean;\n    readonly containsFullScreenElement: boolean;\n    readonly documentTitle: string;\n    height: number;\n    readonly settings: MSWebViewSettings;\n    src: string;\n    width: number;\n    addWebAllowedObject(name: string, applicationObject: any): void;\n    buildLocalStreamUri(contentIdentifier: string, relativePath: string): string;\n    capturePreviewToBlobAsync(): MSWebViewAsyncOperation;\n    captureSelectedContentToDataPackageAsync(): MSWebViewAsyncOperation;\n    getDeferredPermissionRequestById(id: number): DeferredPermissionRequest;\n    getDeferredPermissionRequests(): DeferredPermissionRequest[];\n    goBack(): void;\n    goForward(): void;\n    invokeScriptAsync(scriptName: string, ...args: any[]): MSWebViewAsyncOperation;\n    navigate(uri: string): void;\n    navigateFocus(navigationReason: NavigationReason, origin: FocusNavigationOrigin): void;\n    navigateToLocalStreamUri(source: string, streamResolver: any): void;\n    navigateToString(contents: string): void;\n    navigateWithHttpRequestMessage(requestMessage: any): void;\n    refresh(): void;\n    stop(): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: MSHTMLWebViewElement, ev: HTMLElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var MSHTMLWebViewElement: {\n    prototype: MSHTMLWebViewElement;\n    new(): MSHTMLWebViewElement;\n};\n\ninterface MSInputMethodContextEventMap {\n    \"MSCandidateWindowHide\": Event;\n    \"MSCandidateWindowShow\": Event;\n    \"MSCandidateWindowUpdate\": Event;\n}\n\ninterface MSInputMethodContext extends EventTarget {\n    readonly compositionEndOffset: number;\n    readonly compositionStartOffset: number;\n    oncandidatewindowhide: (this: MSInputMethodContext, ev: Event) => any;\n    oncandidatewindowshow: (this: MSInputMethodContext, ev: Event) => any;\n    oncandidatewindowupdate: (this: MSInputMethodContext, ev: Event) => any;\n    readonly target: HTMLElement;\n    getCandidateWindowClientRect(): ClientRect;\n    getCompositionAlternatives(): string[];\n    hasComposition(): boolean;\n    isCandidateWindowVisible(): boolean;\n    addEventListener<K extends keyof MSInputMethodContextEventMap>(type: K, listener: (this: MSInputMethodContext, ev: MSInputMethodContextEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var MSInputMethodContext: {\n    prototype: MSInputMethodContext;\n    new(): MSInputMethodContext;\n};\n\ninterface MSManipulationEvent extends UIEvent {\n    readonly currentState: number;\n    readonly inertiaDestinationX: number;\n    readonly inertiaDestinationY: number;\n    readonly lastState: number;\n    initMSManipulationEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number, lastState: number, currentState: number): void;\n    readonly MS_MANIPULATION_STATE_ACTIVE: number;\n    readonly MS_MANIPULATION_STATE_CANCELLED: number;\n    readonly MS_MANIPULATION_STATE_COMMITTED: number;\n    readonly MS_MANIPULATION_STATE_DRAGGING: number;\n    readonly MS_MANIPULATION_STATE_INERTIA: number;\n    readonly MS_MANIPULATION_STATE_PRESELECT: number;\n    readonly MS_MANIPULATION_STATE_SELECTING: number;\n    readonly MS_MANIPULATION_STATE_STOPPED: number;\n}\n\ndeclare var MSManipulationEvent: {\n    prototype: MSManipulationEvent;\n    new(): MSManipulationEvent;\n    readonly MS_MANIPULATION_STATE_ACTIVE: number;\n    readonly MS_MANIPULATION_STATE_CANCELLED: number;\n    readonly MS_MANIPULATION_STATE_COMMITTED: number;\n    readonly MS_MANIPULATION_STATE_DRAGGING: number;\n    readonly MS_MANIPULATION_STATE_INERTIA: number;\n    readonly MS_MANIPULATION_STATE_PRESELECT: number;\n    readonly MS_MANIPULATION_STATE_SELECTING: number;\n    readonly MS_MANIPULATION_STATE_STOPPED: number;\n};\n\ninterface MSMediaKeyError {\n    readonly code: number;\n    readonly systemCode: number;\n    readonly MS_MEDIA_KEYERR_CLIENT: number;\n    readonly MS_MEDIA_KEYERR_DOMAIN: number;\n    readonly MS_MEDIA_KEYERR_HARDWARECHANGE: number;\n    readonly MS_MEDIA_KEYERR_OUTPUT: number;\n    readonly MS_MEDIA_KEYERR_SERVICE: number;\n    readonly MS_MEDIA_KEYERR_UNKNOWN: number;\n}\n\ndeclare var MSMediaKeyError: {\n    prototype: MSMediaKeyError;\n    new(): MSMediaKeyError;\n    readonly MS_MEDIA_KEYERR_CLIENT: number;\n    readonly MS_MEDIA_KEYERR_DOMAIN: number;\n    readonly MS_MEDIA_KEYERR_HARDWARECHANGE: number;\n    readonly MS_MEDIA_KEYERR_OUTPUT: number;\n    readonly MS_MEDIA_KEYERR_SERVICE: number;\n    readonly MS_MEDIA_KEYERR_UNKNOWN: number;\n};\n\ninterface MSMediaKeyMessageEvent extends Event {\n    readonly destinationURL: string | null;\n    readonly message: Uint8Array;\n}\n\ndeclare var MSMediaKeyMessageEvent: {\n    prototype: MSMediaKeyMessageEvent;\n    new(): MSMediaKeyMessageEvent;\n};\n\ninterface MSMediaKeyNeededEvent extends Event {\n    readonly initData: Uint8Array | null;\n}\n\ndeclare var MSMediaKeyNeededEvent: {\n    prototype: MSMediaKeyNeededEvent;\n    new(): MSMediaKeyNeededEvent;\n};\n\ninterface MSMediaKeys {\n    readonly keySystem: string;\n    createSession(type: string, initData: Uint8Array, cdmData?: Uint8Array): MSMediaKeySession;\n}\n\ndeclare var MSMediaKeys: {\n    prototype: MSMediaKeys;\n    new(keySystem: string): MSMediaKeys;\n    isTypeSupported(keySystem: string, type?: string): boolean;\n    isTypeSupportedWithFeatures(keySystem: string, type?: string): string;\n};\n\ninterface MSMediaKeySession extends EventTarget {\n    readonly error: MSMediaKeyError | null;\n    readonly keySystem: string;\n    readonly sessionId: string;\n    close(): void;\n    update(key: Uint8Array): void;\n}\n\ndeclare var MSMediaKeySession: {\n    prototype: MSMediaKeySession;\n    new(): MSMediaKeySession;\n};\n\ninterface MSPointerEvent extends MouseEvent {\n    readonly currentPoint: any;\n    readonly height: number;\n    readonly hwTimestamp: number;\n    readonly intermediatePoints: any;\n    readonly isPrimary: boolean;\n    readonly pointerId: number;\n    readonly pointerType: any;\n    readonly pressure: number;\n    readonly rotation: number;\n    readonly tiltX: number;\n    readonly tiltY: number;\n    readonly width: number;\n    getCurrentPoint(element: Element): void;\n    getIntermediatePoints(element: Element): void;\n    initPointerEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number, screenXArg: number, screenYArg: number, clientXArg: number, clientYArg: number, ctrlKeyArg: boolean, altKeyArg: boolean, shiftKeyArg: boolean, metaKeyArg: boolean, buttonArg: number, relatedTargetArg: EventTarget, offsetXArg: number, offsetYArg: number, widthArg: number, heightArg: number, pressure: number, rotation: number, tiltX: number, tiltY: number, pointerIdArg: number, pointerType: any, hwTimestampArg: number, isPrimary: boolean): void;\n}\n\ndeclare var MSPointerEvent: {\n    prototype: MSPointerEvent;\n    new(typeArg: string, eventInitDict?: PointerEventInit): MSPointerEvent;\n};\n\ninterface MSRangeCollection {\n    readonly length: number;\n    item(index: number): Range;\n    [index: number]: Range;\n}\n\ndeclare var MSRangeCollection: {\n    prototype: MSRangeCollection;\n    new(): MSRangeCollection;\n};\n\ninterface MSSiteModeEvent extends Event {\n    readonly actionURL: string;\n    readonly buttonID: number;\n}\n\ndeclare var MSSiteModeEvent: {\n    prototype: MSSiteModeEvent;\n    new(): MSSiteModeEvent;\n};\n\ninterface MSStream {\n    readonly type: string;\n    msClose(): void;\n    msDetachStream(): any;\n}\n\ndeclare var MSStream: {\n    prototype: MSStream;\n    new(): MSStream;\n};\n\ninterface MSStreamReader extends EventTarget, MSBaseReader {\n    readonly error: DOMError;\n    readAsArrayBuffer(stream: MSStream, size?: number): void;\n    readAsBinaryString(stream: MSStream, size?: number): void;\n    readAsBlob(stream: MSStream, size?: number): void;\n    readAsDataURL(stream: MSStream, size?: number): void;\n    readAsText(stream: MSStream, encoding?: string, size?: number): void;\n    addEventListener<K extends keyof MSBaseReaderEventMap>(type: K, listener: (this: MSStreamReader, ev: MSBaseReaderEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var MSStreamReader: {\n    prototype: MSStreamReader;\n    new(): MSStreamReader;\n};\n\ninterface MSWebViewAsyncOperationEventMap {\n    \"complete\": Event;\n    \"error\": Event;\n}\n\ninterface MSWebViewAsyncOperation extends EventTarget {\n    readonly error: DOMError;\n    oncomplete: (this: MSWebViewAsyncOperation, ev: Event) => any;\n    onerror: (this: MSWebViewAsyncOperation, ev: Event) => any;\n    readonly readyState: number;\n    readonly result: any;\n    readonly target: MSHTMLWebViewElement;\n    readonly type: number;\n    start(): void;\n    readonly COMPLETED: number;\n    readonly ERROR: number;\n    readonly STARTED: number;\n    readonly TYPE_CAPTURE_PREVIEW_TO_RANDOM_ACCESS_STREAM: number;\n    readonly TYPE_CREATE_DATA_PACKAGE_FROM_SELECTION: number;\n    readonly TYPE_INVOKE_SCRIPT: number;\n    addEventListener<K extends keyof MSWebViewAsyncOperationEventMap>(type: K, listener: (this: MSWebViewAsyncOperation, ev: MSWebViewAsyncOperationEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var MSWebViewAsyncOperation: {\n    prototype: MSWebViewAsyncOperation;\n    new(): MSWebViewAsyncOperation;\n    readonly COMPLETED: number;\n    readonly ERROR: number;\n    readonly STARTED: number;\n    readonly TYPE_CAPTURE_PREVIEW_TO_RANDOM_ACCESS_STREAM: number;\n    readonly TYPE_CREATE_DATA_PACKAGE_FROM_SELECTION: number;\n    readonly TYPE_INVOKE_SCRIPT: number;\n};\n\ninterface MSWebViewSettings {\n    isIndexedDBEnabled: boolean;\n    isJavaScriptEnabled: boolean;\n}\n\ndeclare var MSWebViewSettings: {\n    prototype: MSWebViewSettings;\n    new(): MSWebViewSettings;\n};\n\ninterface MutationEvent extends Event {\n    readonly attrChange: number;\n    readonly attrName: string;\n    readonly newValue: string;\n    readonly prevValue: string;\n    readonly relatedNode: Node;\n    initMutationEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, relatedNodeArg: Node, prevValueArg: string, newValueArg: string, attrNameArg: string, attrChangeArg: number): void;\n    readonly ADDITION: number;\n    readonly MODIFICATION: number;\n    readonly REMOVAL: number;\n}\n\ndeclare var MutationEvent: {\n    prototype: MutationEvent;\n    new(): MutationEvent;\n    readonly ADDITION: number;\n    readonly MODIFICATION: number;\n    readonly REMOVAL: number;\n};\n\ninterface MutationObserver {\n    disconnect(): void;\n    observe(target: Node, options: MutationObserverInit): void;\n    takeRecords(): MutationRecord[];\n}\n\ndeclare var MutationObserver: {\n    prototype: MutationObserver;\n    new(callback: MutationCallback): MutationObserver;\n};\n\ninterface MutationRecord {\n    readonly addedNodes: NodeList;\n    readonly attributeName: string | null;\n    readonly attributeNamespace: string | null;\n    readonly nextSibling: Node | null;\n    readonly oldValue: string | null;\n    readonly previousSibling: Node | null;\n    readonly removedNodes: NodeList;\n    readonly target: Node;\n    readonly type: string;\n}\n\ndeclare var MutationRecord: {\n    prototype: MutationRecord;\n    new(): MutationRecord;\n};\n\ninterface NamedNodeMap {\n    readonly length: number;\n    getNamedItem(name: string): Attr;\n    getNamedItemNS(namespaceURI: string | null, localName: string | null): Attr;\n    item(index: number): Attr;\n    removeNamedItem(name: string): Attr;\n    removeNamedItemNS(namespaceURI: string | null, localName: string | null): Attr;\n    setNamedItem(arg: Attr): Attr;\n    setNamedItemNS(arg: Attr): Attr;\n    [index: number]: Attr;\n}\n\ndeclare var NamedNodeMap: {\n    prototype: NamedNodeMap;\n    new(): NamedNodeMap;\n};\n\ninterface NavigationCompletedEvent extends NavigationEvent {\n    readonly isSuccess: boolean;\n    readonly webErrorStatus: number;\n}\n\ndeclare var NavigationCompletedEvent: {\n    prototype: NavigationCompletedEvent;\n    new(): NavigationCompletedEvent;\n};\n\ninterface NavigationEvent extends Event {\n    readonly uri: string;\n}\n\ndeclare var NavigationEvent: {\n    prototype: NavigationEvent;\n    new(): NavigationEvent;\n};\n\ninterface NavigationEventWithReferrer extends NavigationEvent {\n    readonly referer: string;\n}\n\ndeclare var NavigationEventWithReferrer: {\n    prototype: NavigationEventWithReferrer;\n    new(): NavigationEventWithReferrer;\n};\n\ninterface Navigator extends Object, NavigatorID, NavigatorOnLine, NavigatorContentUtils, NavigatorStorageUtils, NavigatorGeolocation, MSNavigatorDoNotTrack, MSFileSaver, NavigatorBeacon, NavigatorConcurrentHardware, NavigatorUserMedia {\n    readonly authentication: WebAuthentication;\n    readonly cookieEnabled: boolean;\n    gamepadInputEmulation: GamepadInputEmulationType;\n    readonly language: string;\n    readonly maxTouchPoints: number;\n    readonly mimeTypes: MimeTypeArray;\n    readonly msManipulationViewsEnabled: boolean;\n    readonly msMaxTouchPoints: number;\n    readonly msPointerEnabled: boolean;\n    readonly plugins: PluginArray;\n    readonly pointerEnabled: boolean;\n    readonly serviceWorker: ServiceWorkerContainer;\n    readonly webdriver: boolean;\n    readonly hardwareConcurrency: number;\n    readonly languages: string[];\n    getGamepads(): Gamepad[];\n    javaEnabled(): boolean;\n    msLaunchUri(uri: string, successCallback?: MSLaunchUriCallback, noHandlerCallback?: MSLaunchUriCallback): void;\n    requestMediaKeySystemAccess(keySystem: string, supportedConfigurations: MediaKeySystemConfiguration[]): Promise<MediaKeySystemAccess>;\n    vibrate(pattern: number | number[]): boolean;\n}\n\ndeclare var Navigator: {\n    prototype: Navigator;\n    new(): Navigator;\n};\n\ninterface Node extends EventTarget {\n    readonly attributes: NamedNodeMap;\n    readonly baseURI: string | null;\n    readonly childNodes: NodeList;\n    readonly firstChild: Node | null;\n    readonly lastChild: Node | null;\n    readonly localName: string | null;\n    readonly namespaceURI: string | null;\n    readonly nextSibling: Node | null;\n    readonly nodeName: string;\n    readonly nodeType: number;\n    nodeValue: string | null;\n    readonly ownerDocument: Document;\n    readonly parentElement: HTMLElement | null;\n    readonly parentNode: Node | null;\n    readonly previousSibling: Node | null;\n    textContent: string | null;\n    appendChild<T extends Node>(newChild: T): T;\n    cloneNode(deep?: boolean): Node;\n    compareDocumentPosition(other: Node): number;\n    contains(child: Node): boolean;\n    hasAttributes(): boolean;\n    hasChildNodes(): boolean;\n    insertBefore<T extends Node>(newChild: T, refChild: Node | null): T;\n    isDefaultNamespace(namespaceURI: string | null): boolean;\n    isEqualNode(arg: Node): boolean;\n    isSameNode(other: Node): boolean;\n    lookupNamespaceURI(prefix: string | null): string | null;\n    lookupPrefix(namespaceURI: string | null): string | null;\n    normalize(): void;\n    removeChild<T extends Node>(oldChild: T): T;\n    replaceChild<T extends Node>(newChild: Node, oldChild: T): T;\n    readonly ATTRIBUTE_NODE: number;\n    readonly CDATA_SECTION_NODE: number;\n    readonly COMMENT_NODE: number;\n    readonly DOCUMENT_FRAGMENT_NODE: number;\n    readonly DOCUMENT_NODE: number;\n    readonly DOCUMENT_POSITION_CONTAINED_BY: number;\n    readonly DOCUMENT_POSITION_CONTAINS: number;\n    readonly DOCUMENT_POSITION_DISCONNECTED: number;\n    readonly DOCUMENT_POSITION_FOLLOWING: number;\n    readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC: number;\n    readonly DOCUMENT_POSITION_PRECEDING: number;\n    readonly DOCUMENT_TYPE_NODE: number;\n    readonly ELEMENT_NODE: number;\n    readonly ENTITY_NODE: number;\n    readonly ENTITY_REFERENCE_NODE: number;\n    readonly NOTATION_NODE: number;\n    readonly PROCESSING_INSTRUCTION_NODE: number;\n    readonly TEXT_NODE: number;\n}\n\ndeclare var Node: {\n    prototype: Node;\n    new(): Node;\n    readonly ATTRIBUTE_NODE: number;\n    readonly CDATA_SECTION_NODE: number;\n    readonly COMMENT_NODE: number;\n    readonly DOCUMENT_FRAGMENT_NODE: number;\n    readonly DOCUMENT_NODE: number;\n    readonly DOCUMENT_POSITION_CONTAINED_BY: number;\n    readonly DOCUMENT_POSITION_CONTAINS: number;\n    readonly DOCUMENT_POSITION_DISCONNECTED: number;\n    readonly DOCUMENT_POSITION_FOLLOWING: number;\n    readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC: number;\n    readonly DOCUMENT_POSITION_PRECEDING: number;\n    readonly DOCUMENT_TYPE_NODE: number;\n    readonly ELEMENT_NODE: number;\n    readonly ENTITY_NODE: number;\n    readonly ENTITY_REFERENCE_NODE: number;\n    readonly NOTATION_NODE: number;\n    readonly PROCESSING_INSTRUCTION_NODE: number;\n    readonly TEXT_NODE: number;\n};\n\ninterface NodeFilter {\n    acceptNode(n: Node): number;\n}\n\ndeclare var NodeFilter: {\n    readonly FILTER_ACCEPT: number;\n    readonly FILTER_REJECT: number;\n    readonly FILTER_SKIP: number;\n    readonly SHOW_ALL: number;\n    readonly SHOW_ATTRIBUTE: number;\n    readonly SHOW_CDATA_SECTION: number;\n    readonly SHOW_COMMENT: number;\n    readonly SHOW_DOCUMENT: number;\n    readonly SHOW_DOCUMENT_FRAGMENT: number;\n    readonly SHOW_DOCUMENT_TYPE: number;\n    readonly SHOW_ELEMENT: number;\n    readonly SHOW_ENTITY: number;\n    readonly SHOW_ENTITY_REFERENCE: number;\n    readonly SHOW_NOTATION: number;\n    readonly SHOW_PROCESSING_INSTRUCTION: number;\n    readonly SHOW_TEXT: number;\n};\n\ninterface NodeIterator {\n    readonly expandEntityReferences: boolean;\n    readonly filter: NodeFilter;\n    readonly root: Node;\n    readonly whatToShow: number;\n    detach(): void;\n    nextNode(): Node;\n    previousNode(): Node;\n}\n\ndeclare var NodeIterator: {\n    prototype: NodeIterator;\n    new(): NodeIterator;\n};\n\ninterface NodeList {\n    readonly length: number;\n    item(index: number): Node;\n    [index: number]: Node;\n}\n\ndeclare var NodeList: {\n    prototype: NodeList;\n    new(): NodeList;\n};\n\ninterface NotificationEventMap {\n    \"click\": Event;\n    \"close\": Event;\n    \"error\": Event;\n    \"show\": Event;\n}\n\ninterface Notification extends EventTarget {\n    readonly body: string;\n    readonly dir: NotificationDirection;\n    readonly icon: string;\n    readonly lang: string;\n    onclick: (this: Notification, ev: Event) => any;\n    onclose: (this: Notification, ev: Event) => any;\n    onerror: (this: Notification, ev: Event) => any;\n    onshow: (this: Notification, ev: Event) => any;\n    readonly permission: NotificationPermission;\n    readonly tag: string;\n    readonly title: string;\n    close(): void;\n    addEventListener<K extends keyof NotificationEventMap>(type: K, listener: (this: Notification, ev: NotificationEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var Notification: {\n    prototype: Notification;\n    new(title: string, options?: NotificationOptions): Notification;\n    requestPermission(callback?: NotificationPermissionCallback): Promise<NotificationPermission>;\n};\n\ninterface OES_element_index_uint {\n}\n\ndeclare var OES_element_index_uint: {\n    prototype: OES_element_index_uint;\n    new(): OES_element_index_uint;\n};\n\ninterface OES_standard_derivatives {\n    readonly FRAGMENT_SHADER_DERIVATIVE_HINT_OES: number;\n}\n\ndeclare var OES_standard_derivatives: {\n    prototype: OES_standard_derivatives;\n    new(): OES_standard_derivatives;\n    readonly FRAGMENT_SHADER_DERIVATIVE_HINT_OES: number;\n};\n\ninterface OES_texture_float {\n}\n\ndeclare var OES_texture_float: {\n    prototype: OES_texture_float;\n    new(): OES_texture_float;\n};\n\ninterface OES_texture_float_linear {\n}\n\ndeclare var OES_texture_float_linear: {\n    prototype: OES_texture_float_linear;\n    new(): OES_texture_float_linear;\n};\n\ninterface OES_texture_half_float {\n    readonly HALF_FLOAT_OES: number;\n}\n\ndeclare var OES_texture_half_float: {\n    prototype: OES_texture_half_float;\n    new(): OES_texture_half_float;\n    readonly HALF_FLOAT_OES: number;\n};\n\ninterface OES_texture_half_float_linear {\n}\n\ndeclare var OES_texture_half_float_linear: {\n    prototype: OES_texture_half_float_linear;\n    new(): OES_texture_half_float_linear;\n};\n\ninterface OfflineAudioCompletionEvent extends Event {\n    readonly renderedBuffer: AudioBuffer;\n}\n\ndeclare var OfflineAudioCompletionEvent: {\n    prototype: OfflineAudioCompletionEvent;\n    new(): OfflineAudioCompletionEvent;\n};\n\ninterface OfflineAudioContextEventMap extends AudioContextEventMap {\n    \"complete\": OfflineAudioCompletionEvent;\n}\n\ninterface OfflineAudioContext extends AudioContextBase {\n    readonly length: number;\n    oncomplete: (this: OfflineAudioContext, ev: OfflineAudioCompletionEvent) => any;\n    startRendering(): Promise<AudioBuffer>;\n    suspend(suspendTime: number): Promise<void>;\n    addEventListener<K extends keyof OfflineAudioContextEventMap>(type: K, listener: (this: OfflineAudioContext, ev: OfflineAudioContextEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var OfflineAudioContext: {\n    prototype: OfflineAudioContext;\n    new(numberOfChannels: number, length: number, sampleRate: number): OfflineAudioContext;\n};\n\ninterface OscillatorNodeEventMap {\n    \"ended\": MediaStreamErrorEvent;\n}\n\ninterface OscillatorNode extends AudioNode {\n    readonly detune: AudioParam;\n    readonly frequency: AudioParam;\n    onended: (this: OscillatorNode, ev: MediaStreamErrorEvent) => any;\n    type: OscillatorType;\n    setPeriodicWave(periodicWave: PeriodicWave): void;\n    start(when?: number): void;\n    stop(when?: number): void;\n    addEventListener<K extends keyof OscillatorNodeEventMap>(type: K, listener: (this: OscillatorNode, ev: OscillatorNodeEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var OscillatorNode: {\n    prototype: OscillatorNode;\n    new(): OscillatorNode;\n};\n\ninterface OverflowEvent extends UIEvent {\n    readonly horizontalOverflow: boolean;\n    readonly orient: number;\n    readonly verticalOverflow: boolean;\n    readonly BOTH: number;\n    readonly HORIZONTAL: number;\n    readonly VERTICAL: number;\n}\n\ndeclare var OverflowEvent: {\n    prototype: OverflowEvent;\n    new(): OverflowEvent;\n    readonly BOTH: number;\n    readonly HORIZONTAL: number;\n    readonly VERTICAL: number;\n};\n\ninterface PageTransitionEvent extends Event {\n    readonly persisted: boolean;\n}\n\ndeclare var PageTransitionEvent: {\n    prototype: PageTransitionEvent;\n    new(): PageTransitionEvent;\n};\n\ninterface PannerNode extends AudioNode {\n    coneInnerAngle: number;\n    coneOuterAngle: number;\n    coneOuterGain: number;\n    distanceModel: DistanceModelType;\n    maxDistance: number;\n    panningModel: PanningModelType;\n    refDistance: number;\n    rolloffFactor: number;\n    setOrientation(x: number, y: number, z: number): void;\n    setPosition(x: number, y: number, z: number): void;\n    setVelocity(x: number, y: number, z: number): void;\n}\n\ndeclare var PannerNode: {\n    prototype: PannerNode;\n    new(): PannerNode;\n};\n\ninterface Path2D extends Object, CanvasPathMethods {\n}\n\ndeclare var Path2D: {\n    prototype: Path2D;\n    new(path?: Path2D): Path2D;\n};\n\ninterface PaymentAddress {\n    readonly addressLine: string[];\n    readonly city: string;\n    readonly country: string;\n    readonly dependentLocality: string;\n    readonly languageCode: string;\n    readonly organization: string;\n    readonly phone: string;\n    readonly postalCode: string;\n    readonly recipient: string;\n    readonly region: string;\n    readonly sortingCode: string;\n    toJSON(): any;\n}\n\ndeclare var PaymentAddress: {\n    prototype: PaymentAddress;\n    new(): PaymentAddress;\n};\n\ninterface PaymentRequestEventMap {\n    \"shippingaddresschange\": Event;\n    \"shippingoptionchange\": Event;\n}\n\ninterface PaymentRequest extends EventTarget {\n    onshippingaddresschange: (this: PaymentRequest, ev: Event) => any;\n    onshippingoptionchange: (this: PaymentRequest, ev: Event) => any;\n    readonly shippingAddress: PaymentAddress | null;\n    readonly shippingOption: string | null;\n    readonly shippingType: PaymentShippingType | null;\n    abort(): Promise<void>;\n    show(): Promise<PaymentResponse>;\n    addEventListener<K extends keyof PaymentRequestEventMap>(type: K, listener: (this: PaymentRequest, ev: PaymentRequestEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var PaymentRequest: {\n    prototype: PaymentRequest;\n    new(methodData: PaymentMethodData[], details: PaymentDetails, options?: PaymentOptions): PaymentRequest;\n};\n\ninterface PaymentRequestUpdateEvent extends Event {\n    updateWith(d: Promise<PaymentDetails>): void;\n}\n\ndeclare var PaymentRequestUpdateEvent: {\n    prototype: PaymentRequestUpdateEvent;\n    new(type: string, eventInitDict?: PaymentRequestUpdateEventInit): PaymentRequestUpdateEvent;\n};\n\ninterface PaymentResponse {\n    readonly details: any;\n    readonly methodName: string;\n    readonly payerEmail: string | null;\n    readonly payerName: string | null;\n    readonly payerPhone: string | null;\n    readonly shippingAddress: PaymentAddress | null;\n    readonly shippingOption: string | null;\n    complete(result?: PaymentComplete): Promise<void>;\n    toJSON(): any;\n}\n\ndeclare var PaymentResponse: {\n    prototype: PaymentResponse;\n    new(): PaymentResponse;\n};\n\ninterface Performance {\n    readonly navigation: PerformanceNavigation;\n    readonly timing: PerformanceTiming;\n    clearMarks(markName?: string): void;\n    clearMeasures(measureName?: string): void;\n    clearResourceTimings(): void;\n    getEntries(): any;\n    getEntriesByName(name: string, entryType?: string): any;\n    getEntriesByType(entryType: string): any;\n    getMarks(markName?: string): any;\n    getMeasures(measureName?: string): any;\n    mark(markName: string): void;\n    measure(measureName: string, startMarkName?: string, endMarkName?: string): void;\n    now(): number;\n    setResourceTimingBufferSize(maxSize: number): void;\n    toJSON(): any;\n}\n\ndeclare var Performance: {\n    prototype: Performance;\n    new(): Performance;\n};\n\ninterface PerformanceEntry {\n    readonly duration: number;\n    readonly entryType: string;\n    readonly name: string;\n    readonly startTime: number;\n}\n\ndeclare var PerformanceEntry: {\n    prototype: PerformanceEntry;\n    new(): PerformanceEntry;\n};\n\ninterface PerformanceMark extends PerformanceEntry {\n}\n\ndeclare var PerformanceMark: {\n    prototype: PerformanceMark;\n    new(): PerformanceMark;\n};\n\ninterface PerformanceMeasure extends PerformanceEntry {\n}\n\ndeclare var PerformanceMeasure: {\n    prototype: PerformanceMeasure;\n    new(): PerformanceMeasure;\n};\n\ninterface PerformanceNavigation {\n    readonly redirectCount: number;\n    readonly type: number;\n    toJSON(): any;\n    readonly TYPE_BACK_FORWARD: number;\n    readonly TYPE_NAVIGATE: number;\n    readonly TYPE_RELOAD: number;\n    readonly TYPE_RESERVED: number;\n}\n\ndeclare var PerformanceNavigation: {\n    prototype: PerformanceNavigation;\n    new(): PerformanceNavigation;\n    readonly TYPE_BACK_FORWARD: number;\n    readonly TYPE_NAVIGATE: number;\n    readonly TYPE_RELOAD: number;\n    readonly TYPE_RESERVED: number;\n};\n\ninterface PerformanceNavigationTiming extends PerformanceEntry {\n    readonly connectEnd: number;\n    readonly connectStart: number;\n    readonly domainLookupEnd: number;\n    readonly domainLookupStart: number;\n    readonly domComplete: number;\n    readonly domContentLoadedEventEnd: number;\n    readonly domContentLoadedEventStart: number;\n    readonly domInteractive: number;\n    readonly domLoading: number;\n    readonly fetchStart: number;\n    readonly loadEventEnd: number;\n    readonly loadEventStart: number;\n    readonly navigationStart: number;\n    readonly redirectCount: number;\n    readonly redirectEnd: number;\n    readonly redirectStart: number;\n    readonly requestStart: number;\n    readonly responseEnd: number;\n    readonly responseStart: number;\n    readonly type: NavigationType;\n    readonly unloadEventEnd: number;\n    readonly unloadEventStart: number;\n}\n\ndeclare var PerformanceNavigationTiming: {\n    prototype: PerformanceNavigationTiming;\n    new(): PerformanceNavigationTiming;\n};\n\ninterface PerformanceResourceTiming extends PerformanceEntry {\n    readonly connectEnd: number;\n    readonly connectStart: number;\n    readonly domainLookupEnd: number;\n    readonly domainLookupStart: number;\n    readonly fetchStart: number;\n    readonly initiatorType: string;\n    readonly redirectEnd: number;\n    readonly redirectStart: number;\n    readonly requestStart: number;\n    readonly responseEnd: number;\n    readonly responseStart: number;\n}\n\ndeclare var PerformanceResourceTiming: {\n    prototype: PerformanceResourceTiming;\n    new(): PerformanceResourceTiming;\n};\n\ninterface PerformanceTiming {\n    readonly connectEnd: number;\n    readonly connectStart: number;\n    readonly domainLookupEnd: number;\n    readonly domainLookupStart: number;\n    readonly domComplete: number;\n    readonly domContentLoadedEventEnd: number;\n    readonly domContentLoadedEventStart: number;\n    readonly domInteractive: number;\n    readonly domLoading: number;\n    readonly fetchStart: number;\n    readonly loadEventEnd: number;\n    readonly loadEventStart: number;\n    readonly msFirstPaint: number;\n    readonly navigationStart: number;\n    readonly redirectEnd: number;\n    readonly redirectStart: number;\n    readonly requestStart: number;\n    readonly responseEnd: number;\n    readonly responseStart: number;\n    readonly unloadEventEnd: number;\n    readonly unloadEventStart: number;\n    readonly secureConnectionStart: number;\n    toJSON(): any;\n}\n\ndeclare var PerformanceTiming: {\n    prototype: PerformanceTiming;\n    new(): PerformanceTiming;\n};\n\ninterface PerfWidgetExternal {\n    readonly activeNetworkRequestCount: number;\n    readonly averageFrameTime: number;\n    readonly averagePaintTime: number;\n    readonly extraInformationEnabled: boolean;\n    readonly independentRenderingEnabled: boolean;\n    readonly irDisablingContentString: string;\n    readonly irStatusAvailable: boolean;\n    readonly maxCpuSpeed: number;\n    readonly paintRequestsPerSecond: number;\n    readonly performanceCounter: number;\n    readonly performanceCounterFrequency: number;\n    addEventListener(eventType: string, callback: Function): void;\n    getMemoryUsage(): number;\n    getProcessCpuUsage(): number;\n    getRecentCpuUsage(last: number | null): any;\n    getRecentFrames(last: number | null): any;\n    getRecentMemoryUsage(last: number | null): any;\n    getRecentPaintRequests(last: number | null): any;\n    removeEventListener(eventType: string, callback: Function): void;\n    repositionWindow(x: number, y: number): void;\n    resizeWindow(width: number, height: number): void;\n}\n\ndeclare var PerfWidgetExternal: {\n    prototype: PerfWidgetExternal;\n    new(): PerfWidgetExternal;\n};\n\ninterface PeriodicWave {\n}\n\ndeclare var PeriodicWave: {\n    prototype: PeriodicWave;\n    new(): PeriodicWave;\n};\n\ninterface PermissionRequest extends DeferredPermissionRequest {\n    readonly state: MSWebViewPermissionState;\n    defer(): void;\n}\n\ndeclare var PermissionRequest: {\n    prototype: PermissionRequest;\n    new(): PermissionRequest;\n};\n\ninterface PermissionRequestedEvent extends Event {\n    readonly permissionRequest: PermissionRequest;\n}\n\ndeclare var PermissionRequestedEvent: {\n    prototype: PermissionRequestedEvent;\n    new(): PermissionRequestedEvent;\n};\n\ninterface Plugin {\n    readonly description: string;\n    readonly filename: string;\n    readonly length: number;\n    readonly name: string;\n    readonly version: string;\n    item(index: number): MimeType;\n    namedItem(type: string): MimeType;\n    [index: number]: MimeType;\n}\n\ndeclare var Plugin: {\n    prototype: Plugin;\n    new(): Plugin;\n};\n\ninterface PluginArray {\n    readonly length: number;\n    item(index: number): Plugin;\n    namedItem(name: string): Plugin;\n    refresh(reload?: boolean): void;\n    [index: number]: Plugin;\n}\n\ndeclare var PluginArray: {\n    prototype: PluginArray;\n    new(): PluginArray;\n};\n\ninterface PointerEvent extends MouseEvent {\n    readonly currentPoint: any;\n    readonly height: number;\n    readonly hwTimestamp: number;\n    readonly intermediatePoints: any;\n    readonly isPrimary: boolean;\n    readonly pointerId: number;\n    readonly pointerType: any;\n    readonly pressure: number;\n    readonly rotation: number;\n    readonly tiltX: number;\n    readonly tiltY: number;\n    readonly width: number;\n    getCurrentPoint(element: Element): void;\n    getIntermediatePoints(element: Element): void;\n    initPointerEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number, screenXArg: number, screenYArg: number, clientXArg: number, clientYArg: number, ctrlKeyArg: boolean, altKeyArg: boolean, shiftKeyArg: boolean, metaKeyArg: boolean, buttonArg: number, relatedTargetArg: EventTarget, offsetXArg: number, offsetYArg: number, widthArg: number, heightArg: number, pressure: number, rotation: number, tiltX: number, tiltY: number, pointerIdArg: number, pointerType: any, hwTimestampArg: number, isPrimary: boolean): void;\n}\n\ndeclare var PointerEvent: {\n    prototype: PointerEvent;\n    new(typeArg: string, eventInitDict?: PointerEventInit): PointerEvent;\n};\n\ninterface PopStateEvent extends Event {\n    readonly state: any;\n    initPopStateEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, stateArg: any): void;\n}\n\ndeclare var PopStateEvent: {\n    prototype: PopStateEvent;\n    new(typeArg: string, eventInitDict?: PopStateEventInit): PopStateEvent;\n};\n\ninterface Position {\n    readonly coords: Coordinates;\n    readonly timestamp: number;\n}\n\ndeclare var Position: {\n    prototype: Position;\n    new(): Position;\n};\n\ninterface PositionError {\n    readonly code: number;\n    readonly message: string;\n    toString(): string;\n    readonly PERMISSION_DENIED: number;\n    readonly POSITION_UNAVAILABLE: number;\n    readonly TIMEOUT: number;\n}\n\ndeclare var PositionError: {\n    prototype: PositionError;\n    new(): PositionError;\n    readonly PERMISSION_DENIED: number;\n    readonly POSITION_UNAVAILABLE: number;\n    readonly TIMEOUT: number;\n};\n\ninterface ProcessingInstruction extends CharacterData {\n    readonly target: string;\n}\n\ndeclare var ProcessingInstruction: {\n    prototype: ProcessingInstruction;\n    new(): ProcessingInstruction;\n};\n\ninterface ProgressEvent extends Event {\n    readonly lengthComputable: boolean;\n    readonly loaded: number;\n    readonly total: number;\n    initProgressEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, lengthComputableArg: boolean, loadedArg: number, totalArg: number): void;\n}\n\ndeclare var ProgressEvent: {\n    prototype: ProgressEvent;\n    new(type: string, eventInitDict?: ProgressEventInit): ProgressEvent;\n};\n\ninterface PushManager {\n    getSubscription(): Promise<PushSubscription>;\n    permissionState(options?: PushSubscriptionOptionsInit): Promise<PushPermissionState>;\n    subscribe(options?: PushSubscriptionOptionsInit): Promise<PushSubscription>;\n}\n\ndeclare var PushManager: {\n    prototype: PushManager;\n    new(): PushManager;\n};\n\ninterface PushSubscription {\n    readonly endpoint: USVString;\n    readonly options: PushSubscriptionOptions;\n    getKey(name: PushEncryptionKeyName): ArrayBuffer | null;\n    toJSON(): any;\n    unsubscribe(): Promise<boolean>;\n}\n\ndeclare var PushSubscription: {\n    prototype: PushSubscription;\n    new(): PushSubscription;\n};\n\ninterface PushSubscriptionOptions {\n    readonly applicationServerKey: ArrayBuffer | null;\n    readonly userVisibleOnly: boolean;\n}\n\ndeclare var PushSubscriptionOptions: {\n    prototype: PushSubscriptionOptions;\n    new(): PushSubscriptionOptions;\n};\n\ninterface Range {\n    readonly collapsed: boolean;\n    readonly commonAncestorContainer: Node;\n    readonly endContainer: Node;\n    readonly endOffset: number;\n    readonly startContainer: Node;\n    readonly startOffset: number;\n    cloneContents(): DocumentFragment;\n    cloneRange(): Range;\n    collapse(toStart: boolean): void;\n    compareBoundaryPoints(how: number, sourceRange: Range): number;\n    createContextualFragment(fragment: string): DocumentFragment;\n    deleteContents(): void;\n    detach(): void;\n    expand(Unit: ExpandGranularity): boolean;\n    extractContents(): DocumentFragment;\n    getBoundingClientRect(): ClientRect;\n    getClientRects(): ClientRectList;\n    insertNode(newNode: Node): void;\n    selectNode(refNode: Node): void;\n    selectNodeContents(refNode: Node): void;\n    setEnd(refNode: Node, offset: number): void;\n    setEndAfter(refNode: Node): void;\n    setEndBefore(refNode: Node): void;\n    setStart(refNode: Node, offset: number): void;\n    setStartAfter(refNode: Node): void;\n    setStartBefore(refNode: Node): void;\n    surroundContents(newParent: Node): void;\n    toString(): string;\n    readonly END_TO_END: number;\n    readonly END_TO_START: number;\n    readonly START_TO_END: number;\n    readonly START_TO_START: number;\n}\n\ndeclare var Range: {\n    prototype: Range;\n    new(): Range;\n    readonly END_TO_END: number;\n    readonly END_TO_START: number;\n    readonly START_TO_END: number;\n    readonly START_TO_START: number;\n};\n\ninterface ReadableStream {\n    readonly locked: boolean;\n    cancel(): Promise<void>;\n    getReader(): ReadableStreamReader;\n}\n\ndeclare var ReadableStream: {\n    prototype: ReadableStream;\n    new(): ReadableStream;\n};\n\ninterface ReadableStreamReader {\n    cancel(): Promise<void>;\n    read(): Promise<any>;\n    releaseLock(): void;\n}\n\ndeclare var ReadableStreamReader: {\n    prototype: ReadableStreamReader;\n    new(): ReadableStreamReader;\n};\n\ninterface Request extends Object, Body {\n    readonly cache: RequestCache;\n    readonly credentials: RequestCredentials;\n    readonly destination: RequestDestination;\n    readonly headers: Headers;\n    readonly integrity: string;\n    readonly keepalive: boolean;\n    readonly method: string;\n    readonly mode: RequestMode;\n    readonly redirect: RequestRedirect;\n    readonly referrer: string;\n    readonly referrerPolicy: ReferrerPolicy;\n    readonly type: RequestType;\n    readonly url: string;\n    clone(): Request;\n}\n\ndeclare var Request: {\n    prototype: Request;\n    new(input: Request | string, init?: RequestInit): Request;\n};\n\ninterface Response extends Object, Body {\n    readonly body: ReadableStream | null;\n    readonly headers: Headers;\n    readonly ok: boolean;\n    readonly status: number;\n    readonly statusText: string;\n    readonly type: ResponseType;\n    readonly url: string;\n    clone(): Response;\n}\n\ndeclare var Response: {\n    prototype: Response;\n    new(body?: any, init?: ResponseInit): Response;\n    error: () => Response;\n    redirect: (url: string, status?: number) => Response;\n};\n\ninterface RTCDtlsTransportEventMap {\n    \"dtlsstatechange\": RTCDtlsTransportStateChangedEvent;\n    \"error\": Event;\n}\n\ninterface RTCDtlsTransport extends RTCStatsProvider {\n    ondtlsstatechange: ((this: RTCDtlsTransport, ev: RTCDtlsTransportStateChangedEvent) => any) | null;\n    onerror: ((this: RTCDtlsTransport, ev: Event) => any) | null;\n    readonly state: RTCDtlsTransportState;\n    readonly transport: RTCIceTransport;\n    getLocalParameters(): RTCDtlsParameters;\n    getRemoteCertificates(): ArrayBuffer[];\n    getRemoteParameters(): RTCDtlsParameters | null;\n    start(remoteParameters: RTCDtlsParameters): void;\n    stop(): void;\n    addEventListener<K extends keyof RTCDtlsTransportEventMap>(type: K, listener: (this: RTCDtlsTransport, ev: RTCDtlsTransportEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var RTCDtlsTransport: {\n    prototype: RTCDtlsTransport;\n    new(transport: RTCIceTransport): RTCDtlsTransport;\n};\n\ninterface RTCDtlsTransportStateChangedEvent extends Event {\n    readonly state: RTCDtlsTransportState;\n}\n\ndeclare var RTCDtlsTransportStateChangedEvent: {\n    prototype: RTCDtlsTransportStateChangedEvent;\n    new(): RTCDtlsTransportStateChangedEvent;\n};\n\ninterface RTCDtmfSenderEventMap {\n    \"tonechange\": RTCDTMFToneChangeEvent;\n}\n\ninterface RTCDtmfSender extends EventTarget {\n    readonly canInsertDTMF: boolean;\n    readonly duration: number;\n    readonly interToneGap: number;\n    ontonechange: (this: RTCDtmfSender, ev: RTCDTMFToneChangeEvent) => any;\n    readonly sender: RTCRtpSender;\n    readonly toneBuffer: string;\n    insertDTMF(tones: string, duration?: number, interToneGap?: number): void;\n    addEventListener<K extends keyof RTCDtmfSenderEventMap>(type: K, listener: (this: RTCDtmfSender, ev: RTCDtmfSenderEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var RTCDtmfSender: {\n    prototype: RTCDtmfSender;\n    new(sender: RTCRtpSender): RTCDtmfSender;\n};\n\ninterface RTCDTMFToneChangeEvent extends Event {\n    readonly tone: string;\n}\n\ndeclare var RTCDTMFToneChangeEvent: {\n    prototype: RTCDTMFToneChangeEvent;\n    new(typeArg: string, eventInitDict: RTCDTMFToneChangeEventInit): RTCDTMFToneChangeEvent;\n};\n\ninterface RTCIceCandidate {\n    candidate: string | null;\n    sdpMid: string | null;\n    sdpMLineIndex: number | null;\n    toJSON(): any;\n}\n\ndeclare var RTCIceCandidate: {\n    prototype: RTCIceCandidate;\n    new(candidateInitDict?: RTCIceCandidateInit): RTCIceCandidate;\n};\n\ninterface RTCIceCandidatePairChangedEvent extends Event {\n    readonly pair: RTCIceCandidatePair;\n}\n\ndeclare var RTCIceCandidatePairChangedEvent: {\n    prototype: RTCIceCandidatePairChangedEvent;\n    new(): RTCIceCandidatePairChangedEvent;\n};\n\ninterface RTCIceGathererEventMap {\n    \"error\": Event;\n    \"localcandidate\": RTCIceGathererEvent;\n}\n\ninterface RTCIceGatherer extends RTCStatsProvider {\n    readonly component: RTCIceComponent;\n    onerror: ((this: RTCIceGatherer, ev: Event) => any) | null;\n    onlocalcandidate: ((this: RTCIceGatherer, ev: RTCIceGathererEvent) => any) | null;\n    createAssociatedGatherer(): RTCIceGatherer;\n    getLocalCandidates(): RTCIceCandidateDictionary[];\n    getLocalParameters(): RTCIceParameters;\n    addEventListener<K extends keyof RTCIceGathererEventMap>(type: K, listener: (this: RTCIceGatherer, ev: RTCIceGathererEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var RTCIceGatherer: {\n    prototype: RTCIceGatherer;\n    new(options: RTCIceGatherOptions): RTCIceGatherer;\n};\n\ninterface RTCIceGathererEvent extends Event {\n    readonly candidate: RTCIceCandidateDictionary | RTCIceCandidateComplete;\n}\n\ndeclare var RTCIceGathererEvent: {\n    prototype: RTCIceGathererEvent;\n    new(): RTCIceGathererEvent;\n};\n\ninterface RTCIceTransportEventMap {\n    \"candidatepairchange\": RTCIceCandidatePairChangedEvent;\n    \"icestatechange\": RTCIceTransportStateChangedEvent;\n}\n\ninterface RTCIceTransport extends RTCStatsProvider {\n    readonly component: RTCIceComponent;\n    readonly iceGatherer: RTCIceGatherer | null;\n    oncandidatepairchange: ((this: RTCIceTransport, ev: RTCIceCandidatePairChangedEvent) => any) | null;\n    onicestatechange: ((this: RTCIceTransport, ev: RTCIceTransportStateChangedEvent) => any) | null;\n    readonly role: RTCIceRole;\n    readonly state: RTCIceTransportState;\n    addRemoteCandidate(remoteCandidate: RTCIceCandidateDictionary | RTCIceCandidateComplete): void;\n    createAssociatedTransport(): RTCIceTransport;\n    getNominatedCandidatePair(): RTCIceCandidatePair | null;\n    getRemoteCandidates(): RTCIceCandidateDictionary[];\n    getRemoteParameters(): RTCIceParameters | null;\n    setRemoteCandidates(remoteCandidates: RTCIceCandidateDictionary[]): void;\n    start(gatherer: RTCIceGatherer, remoteParameters: RTCIceParameters, role?: RTCIceRole): void;\n    stop(): void;\n    addEventListener<K extends keyof RTCIceTransportEventMap>(type: K, listener: (this: RTCIceTransport, ev: RTCIceTransportEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var RTCIceTransport: {\n    prototype: RTCIceTransport;\n    new(): RTCIceTransport;\n};\n\ninterface RTCIceTransportStateChangedEvent extends Event {\n    readonly state: RTCIceTransportState;\n}\n\ndeclare var RTCIceTransportStateChangedEvent: {\n    prototype: RTCIceTransportStateChangedEvent;\n    new(): RTCIceTransportStateChangedEvent;\n};\n\ninterface RTCPeerConnectionEventMap {\n    \"addstream\": MediaStreamEvent;\n    \"icecandidate\": RTCPeerConnectionIceEvent;\n    \"iceconnectionstatechange\": Event;\n    \"icegatheringstatechange\": Event;\n    \"negotiationneeded\": Event;\n    \"removestream\": MediaStreamEvent;\n    \"signalingstatechange\": Event;\n}\n\ninterface RTCPeerConnection extends EventTarget {\n    readonly canTrickleIceCandidates: boolean | null;\n    readonly iceConnectionState: RTCIceConnectionState;\n    readonly iceGatheringState: RTCIceGatheringState;\n    readonly localDescription: RTCSessionDescription | null;\n    onaddstream: (this: RTCPeerConnection, ev: MediaStreamEvent) => any;\n    onicecandidate: (this: RTCPeerConnection, ev: RTCPeerConnectionIceEvent) => any;\n    oniceconnectionstatechange: (this: RTCPeerConnection, ev: Event) => any;\n    onicegatheringstatechange: (this: RTCPeerConnection, ev: Event) => any;\n    onnegotiationneeded: (this: RTCPeerConnection, ev: Event) => any;\n    onremovestream: (this: RTCPeerConnection, ev: MediaStreamEvent) => any;\n    onsignalingstatechange: (this: RTCPeerConnection, ev: Event) => any;\n    readonly remoteDescription: RTCSessionDescription | null;\n    readonly signalingState: RTCSignalingState;\n    addIceCandidate(candidate: RTCIceCandidate, successCallback?: VoidFunction, failureCallback?: RTCPeerConnectionErrorCallback): Promise<void>;\n    addStream(stream: MediaStream): void;\n    close(): void;\n    createAnswer(successCallback?: RTCSessionDescriptionCallback, failureCallback?: RTCPeerConnectionErrorCallback): Promise<RTCSessionDescription>;\n    createOffer(successCallback?: RTCSessionDescriptionCallback, failureCallback?: RTCPeerConnectionErrorCallback, options?: RTCOfferOptions): Promise<RTCSessionDescription>;\n    getConfiguration(): RTCConfiguration;\n    getLocalStreams(): MediaStream[];\n    getRemoteStreams(): MediaStream[];\n    getStats(selector: MediaStreamTrack | null, successCallback?: RTCStatsCallback, failureCallback?: RTCPeerConnectionErrorCallback): Promise<RTCStatsReport>;\n    getStreamById(streamId: string): MediaStream | null;\n    removeStream(stream: MediaStream): void;\n    setLocalDescription(description: RTCSessionDescription, successCallback?: VoidFunction, failureCallback?: RTCPeerConnectionErrorCallback): Promise<void>;\n    setRemoteDescription(description: RTCSessionDescription, successCallback?: VoidFunction, failureCallback?: RTCPeerConnectionErrorCallback): Promise<void>;\n    addEventListener<K extends keyof RTCPeerConnectionEventMap>(type: K, listener: (this: RTCPeerConnection, ev: RTCPeerConnectionEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var RTCPeerConnection: {\n    prototype: RTCPeerConnection;\n    new(configuration: RTCConfiguration): RTCPeerConnection;\n};\n\ninterface RTCPeerConnectionIceEvent extends Event {\n    readonly candidate: RTCIceCandidate;\n}\n\ndeclare var RTCPeerConnectionIceEvent: {\n    prototype: RTCPeerConnectionIceEvent;\n    new(type: string, eventInitDict: RTCPeerConnectionIceEventInit): RTCPeerConnectionIceEvent;\n};\n\ninterface RTCRtpReceiverEventMap {\n    \"error\": Event;\n}\n\ninterface RTCRtpReceiver extends RTCStatsProvider {\n    onerror: ((this: RTCRtpReceiver, ev: Event) => any) | null;\n    readonly rtcpTransport: RTCDtlsTransport;\n    readonly track: MediaStreamTrack | null;\n    readonly transport: RTCDtlsTransport | RTCSrtpSdesTransport;\n    getContributingSources(): RTCRtpContributingSource[];\n    receive(parameters: RTCRtpParameters): void;\n    requestSendCSRC(csrc: number): void;\n    setTransport(transport: RTCDtlsTransport | RTCSrtpSdesTransport, rtcpTransport?: RTCDtlsTransport): void;\n    stop(): void;\n    addEventListener<K extends keyof RTCRtpReceiverEventMap>(type: K, listener: (this: RTCRtpReceiver, ev: RTCRtpReceiverEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var RTCRtpReceiver: {\n    prototype: RTCRtpReceiver;\n    new(transport: RTCDtlsTransport | RTCSrtpSdesTransport, kind: string, rtcpTransport?: RTCDtlsTransport): RTCRtpReceiver;\n    getCapabilities(kind?: string): RTCRtpCapabilities;\n};\n\ninterface RTCRtpSenderEventMap {\n    \"error\": Event;\n    \"ssrcconflict\": RTCSsrcConflictEvent;\n}\n\ninterface RTCRtpSender extends RTCStatsProvider {\n    onerror: ((this: RTCRtpSender, ev: Event) => any) | null;\n    onssrcconflict: ((this: RTCRtpSender, ev: RTCSsrcConflictEvent) => any) | null;\n    readonly rtcpTransport: RTCDtlsTransport;\n    readonly track: MediaStreamTrack;\n    readonly transport: RTCDtlsTransport | RTCSrtpSdesTransport;\n    send(parameters: RTCRtpParameters): void;\n    setTrack(track: MediaStreamTrack): void;\n    setTransport(transport: RTCDtlsTransport | RTCSrtpSdesTransport, rtcpTransport?: RTCDtlsTransport): void;\n    stop(): void;\n    addEventListener<K extends keyof RTCRtpSenderEventMap>(type: K, listener: (this: RTCRtpSender, ev: RTCRtpSenderEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var RTCRtpSender: {\n    prototype: RTCRtpSender;\n    new(track: MediaStreamTrack, transport: RTCDtlsTransport | RTCSrtpSdesTransport, rtcpTransport?: RTCDtlsTransport): RTCRtpSender;\n    getCapabilities(kind?: string): RTCRtpCapabilities;\n};\n\ninterface RTCSessionDescription {\n    sdp: string | null;\n    type: RTCSdpType | null;\n    toJSON(): any;\n}\n\ndeclare var RTCSessionDescription: {\n    prototype: RTCSessionDescription;\n    new(descriptionInitDict?: RTCSessionDescriptionInit): RTCSessionDescription;\n};\n\ninterface RTCSrtpSdesTransportEventMap {\n    \"error\": Event;\n}\n\ninterface RTCSrtpSdesTransport extends EventTarget {\n    onerror: ((this: RTCSrtpSdesTransport, ev: Event) => any) | null;\n    readonly transport: RTCIceTransport;\n    addEventListener<K extends keyof RTCSrtpSdesTransportEventMap>(type: K, listener: (this: RTCSrtpSdesTransport, ev: RTCSrtpSdesTransportEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var RTCSrtpSdesTransport: {\n    prototype: RTCSrtpSdesTransport;\n    new(transport: RTCIceTransport, encryptParameters: RTCSrtpSdesParameters, decryptParameters: RTCSrtpSdesParameters): RTCSrtpSdesTransport;\n    getLocalParameters(): RTCSrtpSdesParameters[];\n};\n\ninterface RTCSsrcConflictEvent extends Event {\n    readonly ssrc: number;\n}\n\ndeclare var RTCSsrcConflictEvent: {\n    prototype: RTCSsrcConflictEvent;\n    new(): RTCSsrcConflictEvent;\n};\n\ninterface RTCStatsProvider extends EventTarget {\n    getStats(): Promise<RTCStatsReport>;\n    msGetStats(): Promise<RTCStatsReport>;\n}\n\ndeclare var RTCStatsProvider: {\n    prototype: RTCStatsProvider;\n    new(): RTCStatsProvider;\n};\n\ninterface ScopedCredential {\n    readonly id: ArrayBuffer;\n    readonly type: ScopedCredentialType;\n}\n\ndeclare var ScopedCredential: {\n    prototype: ScopedCredential;\n    new(): ScopedCredential;\n};\n\ninterface ScopedCredentialInfo {\n    readonly credential: ScopedCredential;\n    readonly publicKey: CryptoKey;\n}\n\ndeclare var ScopedCredentialInfo: {\n    prototype: ScopedCredentialInfo;\n    new(): ScopedCredentialInfo;\n};\n\ninterface ScreenEventMap {\n    \"MSOrientationChange\": Event;\n}\n\ninterface Screen extends EventTarget {\n    readonly availHeight: number;\n    readonly availWidth: number;\n    bufferDepth: number;\n    readonly colorDepth: number;\n    readonly deviceXDPI: number;\n    readonly deviceYDPI: number;\n    readonly fontSmoothingEnabled: boolean;\n    readonly height: number;\n    readonly logicalXDPI: number;\n    readonly logicalYDPI: number;\n    readonly msOrientation: string;\n    onmsorientationchange: (this: Screen, ev: Event) => any;\n    readonly pixelDepth: number;\n    readonly systemXDPI: number;\n    readonly systemYDPI: number;\n    readonly width: number;\n    msLockOrientation(orientations: string | string[]): boolean;\n    msUnlockOrientation(): void;\n    addEventListener<K extends keyof ScreenEventMap>(type: K, listener: (this: Screen, ev: ScreenEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var Screen: {\n    prototype: Screen;\n    new(): Screen;\n};\n\ninterface ScriptNotifyEvent extends Event {\n    readonly callingUri: string;\n    readonly value: string;\n}\n\ndeclare var ScriptNotifyEvent: {\n    prototype: ScriptNotifyEvent;\n    new(): ScriptNotifyEvent;\n};\n\ninterface ScriptProcessorNodeEventMap {\n    \"audioprocess\": AudioProcessingEvent;\n}\n\ninterface ScriptProcessorNode extends AudioNode {\n    readonly bufferSize: number;\n    onaudioprocess: (this: ScriptProcessorNode, ev: AudioProcessingEvent) => any;\n    addEventListener<K extends keyof ScriptProcessorNodeEventMap>(type: K, listener: (this: ScriptProcessorNode, ev: ScriptProcessorNodeEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var ScriptProcessorNode: {\n    prototype: ScriptProcessorNode;\n    new(): ScriptProcessorNode;\n};\n\ninterface Selection {\n    readonly anchorNode: Node;\n    readonly anchorOffset: number;\n    readonly baseNode: Node;\n    readonly baseOffset: number;\n    readonly extentNode: Node;\n    readonly extentOffset: number;\n    readonly focusNode: Node;\n    readonly focusOffset: number;\n    readonly isCollapsed: boolean;\n    readonly rangeCount: number;\n    readonly type: string;\n    addRange(range: Range): void;\n    collapse(parentNode: Node, offset: number): void;\n    collapseToEnd(): void;\n    collapseToStart(): void;\n    containsNode(node: Node, partlyContained: boolean): boolean;\n    deleteFromDocument(): void;\n    empty(): void;\n    extend(newNode: Node, offset: number): void;\n    getRangeAt(index: number): Range;\n    removeAllRanges(): void;\n    removeRange(range: Range): void;\n    selectAllChildren(parentNode: Node): void;\n    setBaseAndExtent(baseNode: Node, baseOffset: number, extentNode: Node, extentOffset: number): void;\n    setPosition(parentNode: Node, offset: number): void;\n    toString(): string;\n}\n\ndeclare var Selection: {\n    prototype: Selection;\n    new(): Selection;\n};\n\ninterface ServiceWorkerEventMap extends AbstractWorkerEventMap {\n    \"statechange\": Event;\n}\n\ninterface ServiceWorker extends EventTarget, AbstractWorker {\n    onstatechange: (this: ServiceWorker, ev: Event) => any;\n    readonly scriptURL: USVString;\n    readonly state: ServiceWorkerState;\n    postMessage(message: any, transfer?: any[]): void;\n    addEventListener<K extends keyof ServiceWorkerEventMap>(type: K, listener: (this: ServiceWorker, ev: ServiceWorkerEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var ServiceWorker: {\n    prototype: ServiceWorker;\n    new(): ServiceWorker;\n};\n\ninterface ServiceWorkerContainerEventMap {\n    \"controllerchange\": Event;\n    \"message\": ServiceWorkerMessageEvent;\n}\n\ninterface ServiceWorkerContainer extends EventTarget {\n    readonly controller: ServiceWorker | null;\n    oncontrollerchange: (this: ServiceWorkerContainer, ev: Event) => any;\n    onmessage: (this: ServiceWorkerContainer, ev: ServiceWorkerMessageEvent) => any;\n    readonly ready: Promise<ServiceWorkerRegistration>;\n    getRegistration(clientURL?: USVString): Promise<any>;\n    getRegistrations(): any;\n    register(scriptURL: USVString, options?: RegistrationOptions): Promise<ServiceWorkerRegistration>;\n    addEventListener<K extends keyof ServiceWorkerContainerEventMap>(type: K, listener: (this: ServiceWorkerContainer, ev: ServiceWorkerContainerEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var ServiceWorkerContainer: {\n    prototype: ServiceWorkerContainer;\n    new(): ServiceWorkerContainer;\n};\n\ninterface ServiceWorkerMessageEvent extends Event {\n    readonly data: any;\n    readonly lastEventId: string;\n    readonly origin: string;\n    readonly ports: MessagePort[] | null;\n    readonly source: ServiceWorker | MessagePort | null;\n}\n\ndeclare var ServiceWorkerMessageEvent: {\n    prototype: ServiceWorkerMessageEvent;\n    new(type: string, eventInitDict?: ServiceWorkerMessageEventInit): ServiceWorkerMessageEvent;\n};\n\ninterface ServiceWorkerRegistrationEventMap {\n    \"updatefound\": Event;\n}\n\ninterface ServiceWorkerRegistration extends EventTarget {\n    readonly active: ServiceWorker | null;\n    readonly installing: ServiceWorker | null;\n    onupdatefound: (this: ServiceWorkerRegistration, ev: Event) => any;\n    readonly pushManager: PushManager;\n    readonly scope: USVString;\n    readonly sync: SyncManager;\n    readonly waiting: ServiceWorker | null;\n    getNotifications(filter?: GetNotificationOptions): any;\n    showNotification(title: string, options?: NotificationOptions): Promise<void>;\n    unregister(): Promise<boolean>;\n    update(): Promise<void>;\n    addEventListener<K extends keyof ServiceWorkerRegistrationEventMap>(type: K, listener: (this: ServiceWorkerRegistration, ev: ServiceWorkerRegistrationEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var ServiceWorkerRegistration: {\n    prototype: ServiceWorkerRegistration;\n    new(): ServiceWorkerRegistration;\n};\n\ninterface SourceBuffer extends EventTarget {\n    appendWindowEnd: number;\n    appendWindowStart: number;\n    readonly audioTracks: AudioTrackList;\n    readonly buffered: TimeRanges;\n    mode: AppendMode;\n    timestampOffset: number;\n    readonly updating: boolean;\n    readonly videoTracks: VideoTrackList;\n    abort(): void;\n    appendBuffer(data: ArrayBuffer | ArrayBufferView): void;\n    appendStream(stream: MSStream, maxSize?: number): void;\n    remove(start: number, end: number): void;\n}\n\ndeclare var SourceBuffer: {\n    prototype: SourceBuffer;\n    new(): SourceBuffer;\n};\n\ninterface SourceBufferList extends EventTarget {\n    readonly length: number;\n    item(index: number): SourceBuffer;\n    [index: number]: SourceBuffer;\n}\n\ndeclare var SourceBufferList: {\n    prototype: SourceBufferList;\n    new(): SourceBufferList;\n};\n\ninterface SpeechSynthesisEventMap {\n    \"voiceschanged\": Event;\n}\n\ninterface SpeechSynthesis extends EventTarget {\n    onvoiceschanged: (this: SpeechSynthesis, ev: Event) => any;\n    readonly paused: boolean;\n    readonly pending: boolean;\n    readonly speaking: boolean;\n    cancel(): void;\n    getVoices(): SpeechSynthesisVoice[];\n    pause(): void;\n    resume(): void;\n    speak(utterance: SpeechSynthesisUtterance): void;\n    addEventListener<K extends keyof SpeechSynthesisEventMap>(type: K, listener: (this: SpeechSynthesis, ev: SpeechSynthesisEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SpeechSynthesis: {\n    prototype: SpeechSynthesis;\n    new(): SpeechSynthesis;\n};\n\ninterface SpeechSynthesisEvent extends Event {\n    readonly charIndex: number;\n    readonly elapsedTime: number;\n    readonly name: string;\n    readonly utterance: SpeechSynthesisUtterance | null;\n}\n\ndeclare var SpeechSynthesisEvent: {\n    prototype: SpeechSynthesisEvent;\n    new(type: string, eventInitDict?: SpeechSynthesisEventInit): SpeechSynthesisEvent;\n};\n\ninterface SpeechSynthesisUtteranceEventMap {\n    \"boundary\": Event;\n    \"end\": Event;\n    \"error\": Event;\n    \"mark\": Event;\n    \"pause\": Event;\n    \"resume\": Event;\n    \"start\": Event;\n}\n\ninterface SpeechSynthesisUtterance extends EventTarget {\n    lang: string;\n    onboundary: (this: SpeechSynthesisUtterance, ev: Event) => any;\n    onend: (this: SpeechSynthesisUtterance, ev: Event) => any;\n    onerror: (this: SpeechSynthesisUtterance, ev: Event) => any;\n    onmark: (this: SpeechSynthesisUtterance, ev: Event) => any;\n    onpause: (this: SpeechSynthesisUtterance, ev: Event) => any;\n    onresume: (this: SpeechSynthesisUtterance, ev: Event) => any;\n    onstart: (this: SpeechSynthesisUtterance, ev: Event) => any;\n    pitch: number;\n    rate: number;\n    text: string;\n    voice: SpeechSynthesisVoice;\n    volume: number;\n    addEventListener<K extends keyof SpeechSynthesisUtteranceEventMap>(type: K, listener: (this: SpeechSynthesisUtterance, ev: SpeechSynthesisUtteranceEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SpeechSynthesisUtterance: {\n    prototype: SpeechSynthesisUtterance;\n    new(text?: string): SpeechSynthesisUtterance;\n};\n\ninterface SpeechSynthesisVoice {\n    readonly default: boolean;\n    readonly lang: string;\n    readonly localService: boolean;\n    readonly name: string;\n    readonly voiceURI: string;\n}\n\ndeclare var SpeechSynthesisVoice: {\n    prototype: SpeechSynthesisVoice;\n    new(): SpeechSynthesisVoice;\n};\n\ninterface StereoPannerNode extends AudioNode {\n    readonly pan: AudioParam;\n}\n\ndeclare var StereoPannerNode: {\n    prototype: StereoPannerNode;\n    new(): StereoPannerNode;\n};\n\ninterface Storage {\n    readonly length: number;\n    clear(): void;\n    getItem(key: string): string | null;\n    key(index: number): string | null;\n    removeItem(key: string): void;\n    setItem(key: string, data: string): void;\n    [key: string]: any;\n    [index: number]: string;\n}\n\ndeclare var Storage: {\n    prototype: Storage;\n    new(): Storage;\n};\n\ninterface StorageEvent extends Event {\n    readonly url: string;\n    key?: string;\n    oldValue?: string;\n    newValue?: string;\n    storageArea?: Storage;\n}\n\ndeclare var StorageEvent: {\n    prototype: StorageEvent;\n    new (type: string, eventInitDict?: StorageEventInit): StorageEvent;\n};\n\ninterface StyleMedia {\n    readonly type: string;\n    matchMedium(mediaquery: string): boolean;\n}\n\ndeclare var StyleMedia: {\n    prototype: StyleMedia;\n    new(): StyleMedia;\n};\n\ninterface StyleSheet {\n    disabled: boolean;\n    readonly href: string;\n    readonly media: MediaList;\n    readonly ownerNode: Node;\n    readonly parentStyleSheet: StyleSheet;\n    readonly title: string;\n    readonly type: string;\n}\n\ndeclare var StyleSheet: {\n    prototype: StyleSheet;\n    new(): StyleSheet;\n};\n\ninterface StyleSheetList {\n    readonly length: number;\n    item(index?: number): StyleSheet;\n    [index: number]: StyleSheet;\n}\n\ndeclare var StyleSheetList: {\n    prototype: StyleSheetList;\n    new(): StyleSheetList;\n};\n\ninterface StyleSheetPageList {\n    readonly length: number;\n    item(index: number): CSSPageRule;\n    [index: number]: CSSPageRule;\n}\n\ndeclare var StyleSheetPageList: {\n    prototype: StyleSheetPageList;\n    new(): StyleSheetPageList;\n};\n\ninterface SubtleCrypto {\n    decrypt(algorithm: string | RsaOaepParams | AesCtrParams | AesCbcParams | AesCmacParams | AesGcmParams | AesCfbParams, key: CryptoKey, data: BufferSource): PromiseLike<ArrayBuffer>;\n    deriveBits(algorithm: string | EcdhKeyDeriveParams | DhKeyDeriveParams | ConcatParams | HkdfCtrParams | Pbkdf2Params, baseKey: CryptoKey, length: number): PromiseLike<ArrayBuffer>;\n    deriveKey(algorithm: string | EcdhKeyDeriveParams | DhKeyDeriveParams | ConcatParams | HkdfCtrParams | Pbkdf2Params, baseKey: CryptoKey, derivedKeyType: string | AesDerivedKeyParams | HmacImportParams | ConcatParams | HkdfCtrParams | Pbkdf2Params, extractable: boolean, keyUsages: string[]): PromiseLike<CryptoKey>;\n    digest(algorithm: AlgorithmIdentifier, data: BufferSource): PromiseLike<ArrayBuffer>;\n    encrypt(algorithm: string | RsaOaepParams | AesCtrParams | AesCbcParams | AesCmacParams | AesGcmParams | AesCfbParams, key: CryptoKey, data: BufferSource): PromiseLike<ArrayBuffer>;\n    exportKey(format: \"jwk\", key: CryptoKey): PromiseLike<JsonWebKey>;\n    exportKey(format: \"raw\" | \"pkcs8\" | \"spki\", key: CryptoKey): PromiseLike<ArrayBuffer>;\n    exportKey(format: string, key: CryptoKey): PromiseLike<JsonWebKey | ArrayBuffer>;\n    generateKey(algorithm: string, extractable: boolean, keyUsages: string[]): PromiseLike<CryptoKeyPair | CryptoKey>;\n    generateKey(algorithm: RsaHashedKeyGenParams | EcKeyGenParams | DhKeyGenParams, extractable: boolean, keyUsages: string[]): PromiseLike<CryptoKeyPair>;\n    generateKey(algorithm: AesKeyGenParams | HmacKeyGenParams | Pbkdf2Params, extractable: boolean, keyUsages: string[]): PromiseLike<CryptoKey>;\n    importKey(format: \"jwk\", keyData: JsonWebKey, algorithm: string | RsaHashedImportParams | EcKeyImportParams | HmacImportParams | DhImportKeyParams, extractable: boolean, keyUsages: string[]): PromiseLike<CryptoKey>;\n    importKey(format: \"raw\" | \"pkcs8\" | \"spki\", keyData: BufferSource, algorithm: string | RsaHashedImportParams | EcKeyImportParams | HmacImportParams | DhImportKeyParams, extractable: boolean, keyUsages: string[]): PromiseLike<CryptoKey>;\n    importKey(format: string, keyData: JsonWebKey | BufferSource, algorithm: string | RsaHashedImportParams | EcKeyImportParams | HmacImportParams | DhImportKeyParams, extractable: boolean, keyUsages: string[]): PromiseLike<CryptoKey>;\n    sign(algorithm: string | RsaPssParams | EcdsaParams | AesCmacParams, key: CryptoKey, data: BufferSource): PromiseLike<ArrayBuffer>;\n    unwrapKey(format: string, wrappedKey: BufferSource, unwrappingKey: CryptoKey, unwrapAlgorithm: AlgorithmIdentifier, unwrappedKeyAlgorithm: AlgorithmIdentifier, extractable: boolean, keyUsages: string[]): PromiseLike<CryptoKey>;\n    verify(algorithm: string | RsaPssParams | EcdsaParams | AesCmacParams, key: CryptoKey, signature: BufferSource, data: BufferSource): PromiseLike<boolean>;\n    wrapKey(format: string, key: CryptoKey, wrappingKey: CryptoKey, wrapAlgorithm: AlgorithmIdentifier): PromiseLike<ArrayBuffer>;\n}\n\ndeclare var SubtleCrypto: {\n    prototype: SubtleCrypto;\n    new(): SubtleCrypto;\n};\n\ninterface SVGAElement extends SVGGraphicsElement, SVGURIReference {\n    readonly target: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGAElement: {\n    prototype: SVGAElement;\n    new(): SVGAElement;\n};\n\ninterface SVGAngle {\n    readonly unitType: number;\n    value: number;\n    valueAsString: string;\n    valueInSpecifiedUnits: number;\n    convertToSpecifiedUnits(unitType: number): void;\n    newValueSpecifiedUnits(unitType: number, valueInSpecifiedUnits: number): void;\n    readonly SVG_ANGLETYPE_DEG: number;\n    readonly SVG_ANGLETYPE_GRAD: number;\n    readonly SVG_ANGLETYPE_RAD: number;\n    readonly SVG_ANGLETYPE_UNKNOWN: number;\n    readonly SVG_ANGLETYPE_UNSPECIFIED: number;\n}\n\ndeclare var SVGAngle: {\n    prototype: SVGAngle;\n    new(): SVGAngle;\n    readonly SVG_ANGLETYPE_DEG: number;\n    readonly SVG_ANGLETYPE_GRAD: number;\n    readonly SVG_ANGLETYPE_RAD: number;\n    readonly SVG_ANGLETYPE_UNKNOWN: number;\n    readonly SVG_ANGLETYPE_UNSPECIFIED: number;\n};\n\ninterface SVGAnimatedAngle {\n    readonly animVal: SVGAngle;\n    readonly baseVal: SVGAngle;\n}\n\ndeclare var SVGAnimatedAngle: {\n    prototype: SVGAnimatedAngle;\n    new(): SVGAnimatedAngle;\n};\n\ninterface SVGAnimatedBoolean {\n    readonly animVal: boolean;\n    baseVal: boolean;\n}\n\ndeclare var SVGAnimatedBoolean: {\n    prototype: SVGAnimatedBoolean;\n    new(): SVGAnimatedBoolean;\n};\n\ninterface SVGAnimatedEnumeration {\n    readonly animVal: number;\n    baseVal: number;\n}\n\ndeclare var SVGAnimatedEnumeration: {\n    prototype: SVGAnimatedEnumeration;\n    new(): SVGAnimatedEnumeration;\n};\n\ninterface SVGAnimatedInteger {\n    readonly animVal: number;\n    baseVal: number;\n}\n\ndeclare var SVGAnimatedInteger: {\n    prototype: SVGAnimatedInteger;\n    new(): SVGAnimatedInteger;\n};\n\ninterface SVGAnimatedLength {\n    readonly animVal: SVGLength;\n    readonly baseVal: SVGLength;\n}\n\ndeclare var SVGAnimatedLength: {\n    prototype: SVGAnimatedLength;\n    new(): SVGAnimatedLength;\n};\n\ninterface SVGAnimatedLengthList {\n    readonly animVal: SVGLengthList;\n    readonly baseVal: SVGLengthList;\n}\n\ndeclare var SVGAnimatedLengthList: {\n    prototype: SVGAnimatedLengthList;\n    new(): SVGAnimatedLengthList;\n};\n\ninterface SVGAnimatedNumber {\n    readonly animVal: number;\n    baseVal: number;\n}\n\ndeclare var SVGAnimatedNumber: {\n    prototype: SVGAnimatedNumber;\n    new(): SVGAnimatedNumber;\n};\n\ninterface SVGAnimatedNumberList {\n    readonly animVal: SVGNumberList;\n    readonly baseVal: SVGNumberList;\n}\n\ndeclare var SVGAnimatedNumberList: {\n    prototype: SVGAnimatedNumberList;\n    new(): SVGAnimatedNumberList;\n};\n\ninterface SVGAnimatedPreserveAspectRatio {\n    readonly animVal: SVGPreserveAspectRatio;\n    readonly baseVal: SVGPreserveAspectRatio;\n}\n\ndeclare var SVGAnimatedPreserveAspectRatio: {\n    prototype: SVGAnimatedPreserveAspectRatio;\n    new(): SVGAnimatedPreserveAspectRatio;\n};\n\ninterface SVGAnimatedRect {\n    readonly animVal: SVGRect;\n    readonly baseVal: SVGRect;\n}\n\ndeclare var SVGAnimatedRect: {\n    prototype: SVGAnimatedRect;\n    new(): SVGAnimatedRect;\n};\n\ninterface SVGAnimatedString {\n    readonly animVal: string;\n    baseVal: string;\n}\n\ndeclare var SVGAnimatedString: {\n    prototype: SVGAnimatedString;\n    new(): SVGAnimatedString;\n};\n\ninterface SVGAnimatedTransformList {\n    readonly animVal: SVGTransformList;\n    readonly baseVal: SVGTransformList;\n}\n\ndeclare var SVGAnimatedTransformList: {\n    prototype: SVGAnimatedTransformList;\n    new(): SVGAnimatedTransformList;\n};\n\ninterface SVGCircleElement extends SVGGraphicsElement {\n    readonly cx: SVGAnimatedLength;\n    readonly cy: SVGAnimatedLength;\n    readonly r: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGCircleElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGCircleElement: {\n    prototype: SVGCircleElement;\n    new(): SVGCircleElement;\n};\n\ninterface SVGClipPathElement extends SVGGraphicsElement, SVGUnitTypes {\n    readonly clipPathUnits: SVGAnimatedEnumeration;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGClipPathElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGClipPathElement: {\n    prototype: SVGClipPathElement;\n    new(): SVGClipPathElement;\n};\n\ninterface SVGComponentTransferFunctionElement extends SVGElement {\n    readonly amplitude: SVGAnimatedNumber;\n    readonly exponent: SVGAnimatedNumber;\n    readonly intercept: SVGAnimatedNumber;\n    readonly offset: SVGAnimatedNumber;\n    readonly slope: SVGAnimatedNumber;\n    readonly tableValues: SVGAnimatedNumberList;\n    readonly type: SVGAnimatedEnumeration;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_GAMMA: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_LINEAR: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_TABLE: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGComponentTransferFunctionElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGComponentTransferFunctionElement: {\n    prototype: SVGComponentTransferFunctionElement;\n    new(): SVGComponentTransferFunctionElement;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_GAMMA: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_LINEAR: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_TABLE: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN: number;\n};\n\ninterface SVGDefsElement extends SVGGraphicsElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGDefsElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGDefsElement: {\n    prototype: SVGDefsElement;\n    new(): SVGDefsElement;\n};\n\ninterface SVGDescElement extends SVGElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGDescElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGDescElement: {\n    prototype: SVGDescElement;\n    new(): SVGDescElement;\n};\n\ninterface SVGElementEventMap extends ElementEventMap {\n    \"click\": MouseEvent;\n    \"dblclick\": MouseEvent;\n    \"focusin\": FocusEvent;\n    \"focusout\": FocusEvent;\n    \"load\": Event;\n    \"mousedown\": MouseEvent;\n    \"mousemove\": MouseEvent;\n    \"mouseout\": MouseEvent;\n    \"mouseover\": MouseEvent;\n    \"mouseup\": MouseEvent;\n}\n\ninterface SVGElement extends Element {\n    className: any;\n    onclick: (this: SVGElement, ev: MouseEvent) => any;\n    ondblclick: (this: SVGElement, ev: MouseEvent) => any;\n    onfocusin: (this: SVGElement, ev: FocusEvent) => any;\n    onfocusout: (this: SVGElement, ev: FocusEvent) => any;\n    onload: (this: SVGElement, ev: Event) => any;\n    onmousedown: (this: SVGElement, ev: MouseEvent) => any;\n    onmousemove: (this: SVGElement, ev: MouseEvent) => any;\n    onmouseout: (this: SVGElement, ev: MouseEvent) => any;\n    onmouseover: (this: SVGElement, ev: MouseEvent) => any;\n    onmouseup: (this: SVGElement, ev: MouseEvent) => any;\n    readonly ownerSVGElement: SVGSVGElement;\n    readonly style: CSSStyleDeclaration;\n    readonly viewportElement: SVGElement;\n    xmlbase: string;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGElement: {\n    prototype: SVGElement;\n    new(): SVGElement;\n};\n\ninterface SVGElementInstance extends EventTarget {\n    readonly childNodes: SVGElementInstanceList;\n    readonly correspondingElement: SVGElement;\n    readonly correspondingUseElement: SVGUseElement;\n    readonly firstChild: SVGElementInstance;\n    readonly lastChild: SVGElementInstance;\n    readonly nextSibling: SVGElementInstance;\n    readonly parentNode: SVGElementInstance;\n    readonly previousSibling: SVGElementInstance;\n}\n\ndeclare var SVGElementInstance: {\n    prototype: SVGElementInstance;\n    new(): SVGElementInstance;\n};\n\ninterface SVGElementInstanceList {\n    readonly length: number;\n    item(index: number): SVGElementInstance;\n}\n\ndeclare var SVGElementInstanceList: {\n    prototype: SVGElementInstanceList;\n    new(): SVGElementInstanceList;\n};\n\ninterface SVGEllipseElement extends SVGGraphicsElement {\n    readonly cx: SVGAnimatedLength;\n    readonly cy: SVGAnimatedLength;\n    readonly rx: SVGAnimatedLength;\n    readonly ry: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGEllipseElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGEllipseElement: {\n    prototype: SVGEllipseElement;\n    new(): SVGEllipseElement;\n};\n\ninterface SVGFEBlendElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly in2: SVGAnimatedString;\n    readonly mode: SVGAnimatedEnumeration;\n    readonly SVG_FEBLEND_MODE_COLOR: number;\n    readonly SVG_FEBLEND_MODE_COLOR_BURN: number;\n    readonly SVG_FEBLEND_MODE_COLOR_DODGE: number;\n    readonly SVG_FEBLEND_MODE_DARKEN: number;\n    readonly SVG_FEBLEND_MODE_DIFFERENCE: number;\n    readonly SVG_FEBLEND_MODE_EXCLUSION: number;\n    readonly SVG_FEBLEND_MODE_HARD_LIGHT: number;\n    readonly SVG_FEBLEND_MODE_HUE: number;\n    readonly SVG_FEBLEND_MODE_LIGHTEN: number;\n    readonly SVG_FEBLEND_MODE_LUMINOSITY: number;\n    readonly SVG_FEBLEND_MODE_MULTIPLY: number;\n    readonly SVG_FEBLEND_MODE_NORMAL: number;\n    readonly SVG_FEBLEND_MODE_OVERLAY: number;\n    readonly SVG_FEBLEND_MODE_SATURATION: number;\n    readonly SVG_FEBLEND_MODE_SCREEN: number;\n    readonly SVG_FEBLEND_MODE_SOFT_LIGHT: number;\n    readonly SVG_FEBLEND_MODE_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEBlendElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEBlendElement: {\n    prototype: SVGFEBlendElement;\n    new(): SVGFEBlendElement;\n    readonly SVG_FEBLEND_MODE_COLOR: number;\n    readonly SVG_FEBLEND_MODE_COLOR_BURN: number;\n    readonly SVG_FEBLEND_MODE_COLOR_DODGE: number;\n    readonly SVG_FEBLEND_MODE_DARKEN: number;\n    readonly SVG_FEBLEND_MODE_DIFFERENCE: number;\n    readonly SVG_FEBLEND_MODE_EXCLUSION: number;\n    readonly SVG_FEBLEND_MODE_HARD_LIGHT: number;\n    readonly SVG_FEBLEND_MODE_HUE: number;\n    readonly SVG_FEBLEND_MODE_LIGHTEN: number;\n    readonly SVG_FEBLEND_MODE_LUMINOSITY: number;\n    readonly SVG_FEBLEND_MODE_MULTIPLY: number;\n    readonly SVG_FEBLEND_MODE_NORMAL: number;\n    readonly SVG_FEBLEND_MODE_OVERLAY: number;\n    readonly SVG_FEBLEND_MODE_SATURATION: number;\n    readonly SVG_FEBLEND_MODE_SCREEN: number;\n    readonly SVG_FEBLEND_MODE_SOFT_LIGHT: number;\n    readonly SVG_FEBLEND_MODE_UNKNOWN: number;\n};\n\ninterface SVGFEColorMatrixElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly type: SVGAnimatedEnumeration;\n    readonly values: SVGAnimatedNumberList;\n    readonly SVG_FECOLORMATRIX_TYPE_HUEROTATE: number;\n    readonly SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA: number;\n    readonly SVG_FECOLORMATRIX_TYPE_MATRIX: number;\n    readonly SVG_FECOLORMATRIX_TYPE_SATURATE: number;\n    readonly SVG_FECOLORMATRIX_TYPE_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEColorMatrixElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEColorMatrixElement: {\n    prototype: SVGFEColorMatrixElement;\n    new(): SVGFEColorMatrixElement;\n    readonly SVG_FECOLORMATRIX_TYPE_HUEROTATE: number;\n    readonly SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA: number;\n    readonly SVG_FECOLORMATRIX_TYPE_MATRIX: number;\n    readonly SVG_FECOLORMATRIX_TYPE_SATURATE: number;\n    readonly SVG_FECOLORMATRIX_TYPE_UNKNOWN: number;\n};\n\ninterface SVGFEComponentTransferElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEComponentTransferElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEComponentTransferElement: {\n    prototype: SVGFEComponentTransferElement;\n    new(): SVGFEComponentTransferElement;\n};\n\ninterface SVGFECompositeElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly in2: SVGAnimatedString;\n    readonly k1: SVGAnimatedNumber;\n    readonly k2: SVGAnimatedNumber;\n    readonly k3: SVGAnimatedNumber;\n    readonly k4: SVGAnimatedNumber;\n    readonly operator: SVGAnimatedEnumeration;\n    readonly SVG_FECOMPOSITE_OPERATOR_ARITHMETIC: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_ATOP: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_IN: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_OUT: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_OVER: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_UNKNOWN: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_XOR: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFECompositeElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFECompositeElement: {\n    prototype: SVGFECompositeElement;\n    new(): SVGFECompositeElement;\n    readonly SVG_FECOMPOSITE_OPERATOR_ARITHMETIC: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_ATOP: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_IN: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_OUT: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_OVER: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_UNKNOWN: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_XOR: number;\n};\n\ninterface SVGFEConvolveMatrixElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly bias: SVGAnimatedNumber;\n    readonly divisor: SVGAnimatedNumber;\n    readonly edgeMode: SVGAnimatedEnumeration;\n    readonly in1: SVGAnimatedString;\n    readonly kernelMatrix: SVGAnimatedNumberList;\n    readonly kernelUnitLengthX: SVGAnimatedNumber;\n    readonly kernelUnitLengthY: SVGAnimatedNumber;\n    readonly orderX: SVGAnimatedInteger;\n    readonly orderY: SVGAnimatedInteger;\n    readonly preserveAlpha: SVGAnimatedBoolean;\n    readonly targetX: SVGAnimatedInteger;\n    readonly targetY: SVGAnimatedInteger;\n    readonly SVG_EDGEMODE_DUPLICATE: number;\n    readonly SVG_EDGEMODE_NONE: number;\n    readonly SVG_EDGEMODE_UNKNOWN: number;\n    readonly SVG_EDGEMODE_WRAP: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEConvolveMatrixElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEConvolveMatrixElement: {\n    prototype: SVGFEConvolveMatrixElement;\n    new(): SVGFEConvolveMatrixElement;\n    readonly SVG_EDGEMODE_DUPLICATE: number;\n    readonly SVG_EDGEMODE_NONE: number;\n    readonly SVG_EDGEMODE_UNKNOWN: number;\n    readonly SVG_EDGEMODE_WRAP: number;\n};\n\ninterface SVGFEDiffuseLightingElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly diffuseConstant: SVGAnimatedNumber;\n    readonly in1: SVGAnimatedString;\n    readonly kernelUnitLengthX: SVGAnimatedNumber;\n    readonly kernelUnitLengthY: SVGAnimatedNumber;\n    readonly surfaceScale: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDiffuseLightingElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEDiffuseLightingElement: {\n    prototype: SVGFEDiffuseLightingElement;\n    new(): SVGFEDiffuseLightingElement;\n};\n\ninterface SVGFEDisplacementMapElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly in2: SVGAnimatedString;\n    readonly scale: SVGAnimatedNumber;\n    readonly xChannelSelector: SVGAnimatedEnumeration;\n    readonly yChannelSelector: SVGAnimatedEnumeration;\n    readonly SVG_CHANNEL_A: number;\n    readonly SVG_CHANNEL_B: number;\n    readonly SVG_CHANNEL_G: number;\n    readonly SVG_CHANNEL_R: number;\n    readonly SVG_CHANNEL_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDisplacementMapElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEDisplacementMapElement: {\n    prototype: SVGFEDisplacementMapElement;\n    new(): SVGFEDisplacementMapElement;\n    readonly SVG_CHANNEL_A: number;\n    readonly SVG_CHANNEL_B: number;\n    readonly SVG_CHANNEL_G: number;\n    readonly SVG_CHANNEL_R: number;\n    readonly SVG_CHANNEL_UNKNOWN: number;\n};\n\ninterface SVGFEDistantLightElement extends SVGElement {\n    readonly azimuth: SVGAnimatedNumber;\n    readonly elevation: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDistantLightElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEDistantLightElement: {\n    prototype: SVGFEDistantLightElement;\n    new(): SVGFEDistantLightElement;\n};\n\ninterface SVGFEFloodElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFloodElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEFloodElement: {\n    prototype: SVGFEFloodElement;\n    new(): SVGFEFloodElement;\n};\n\ninterface SVGFEFuncAElement extends SVGComponentTransferFunctionElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncAElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEFuncAElement: {\n    prototype: SVGFEFuncAElement;\n    new(): SVGFEFuncAElement;\n};\n\ninterface SVGFEFuncBElement extends SVGComponentTransferFunctionElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncBElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEFuncBElement: {\n    prototype: SVGFEFuncBElement;\n    new(): SVGFEFuncBElement;\n};\n\ninterface SVGFEFuncGElement extends SVGComponentTransferFunctionElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncGElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEFuncGElement: {\n    prototype: SVGFEFuncGElement;\n    new(): SVGFEFuncGElement;\n};\n\ninterface SVGFEFuncRElement extends SVGComponentTransferFunctionElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncRElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEFuncRElement: {\n    prototype: SVGFEFuncRElement;\n    new(): SVGFEFuncRElement;\n};\n\ninterface SVGFEGaussianBlurElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly stdDeviationX: SVGAnimatedNumber;\n    readonly stdDeviationY: SVGAnimatedNumber;\n    setStdDeviation(stdDeviationX: number, stdDeviationY: number): void;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEGaussianBlurElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEGaussianBlurElement: {\n    prototype: SVGFEGaussianBlurElement;\n    new(): SVGFEGaussianBlurElement;\n};\n\ninterface SVGFEImageElement extends SVGElement, SVGFilterPrimitiveStandardAttributes, SVGURIReference {\n    readonly preserveAspectRatio: SVGAnimatedPreserveAspectRatio;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEImageElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEImageElement: {\n    prototype: SVGFEImageElement;\n    new(): SVGFEImageElement;\n};\n\ninterface SVGFEMergeElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMergeElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEMergeElement: {\n    prototype: SVGFEMergeElement;\n    new(): SVGFEMergeElement;\n};\n\ninterface SVGFEMergeNodeElement extends SVGElement {\n    readonly in1: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMergeNodeElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEMergeNodeElement: {\n    prototype: SVGFEMergeNodeElement;\n    new(): SVGFEMergeNodeElement;\n};\n\ninterface SVGFEMorphologyElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly operator: SVGAnimatedEnumeration;\n    readonly radiusX: SVGAnimatedNumber;\n    readonly radiusY: SVGAnimatedNumber;\n    readonly SVG_MORPHOLOGY_OPERATOR_DILATE: number;\n    readonly SVG_MORPHOLOGY_OPERATOR_ERODE: number;\n    readonly SVG_MORPHOLOGY_OPERATOR_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMorphologyElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEMorphologyElement: {\n    prototype: SVGFEMorphologyElement;\n    new(): SVGFEMorphologyElement;\n    readonly SVG_MORPHOLOGY_OPERATOR_DILATE: number;\n    readonly SVG_MORPHOLOGY_OPERATOR_ERODE: number;\n    readonly SVG_MORPHOLOGY_OPERATOR_UNKNOWN: number;\n};\n\ninterface SVGFEOffsetElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly dx: SVGAnimatedNumber;\n    readonly dy: SVGAnimatedNumber;\n    readonly in1: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEOffsetElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEOffsetElement: {\n    prototype: SVGFEOffsetElement;\n    new(): SVGFEOffsetElement;\n};\n\ninterface SVGFEPointLightElement extends SVGElement {\n    readonly x: SVGAnimatedNumber;\n    readonly y: SVGAnimatedNumber;\n    readonly z: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEPointLightElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFEPointLightElement: {\n    prototype: SVGFEPointLightElement;\n    new(): SVGFEPointLightElement;\n};\n\ninterface SVGFESpecularLightingElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly kernelUnitLengthX: SVGAnimatedNumber;\n    readonly kernelUnitLengthY: SVGAnimatedNumber;\n    readonly specularConstant: SVGAnimatedNumber;\n    readonly specularExponent: SVGAnimatedNumber;\n    readonly surfaceScale: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFESpecularLightingElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFESpecularLightingElement: {\n    prototype: SVGFESpecularLightingElement;\n    new(): SVGFESpecularLightingElement;\n};\n\ninterface SVGFESpotLightElement extends SVGElement {\n    readonly limitingConeAngle: SVGAnimatedNumber;\n    readonly pointsAtX: SVGAnimatedNumber;\n    readonly pointsAtY: SVGAnimatedNumber;\n    readonly pointsAtZ: SVGAnimatedNumber;\n    readonly specularExponent: SVGAnimatedNumber;\n    readonly x: SVGAnimatedNumber;\n    readonly y: SVGAnimatedNumber;\n    readonly z: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFESpotLightElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFESpotLightElement: {\n    prototype: SVGFESpotLightElement;\n    new(): SVGFESpotLightElement;\n};\n\ninterface SVGFETileElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFETileElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFETileElement: {\n    prototype: SVGFETileElement;\n    new(): SVGFETileElement;\n};\n\ninterface SVGFETurbulenceElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly baseFrequencyX: SVGAnimatedNumber;\n    readonly baseFrequencyY: SVGAnimatedNumber;\n    readonly numOctaves: SVGAnimatedInteger;\n    readonly seed: SVGAnimatedNumber;\n    readonly stitchTiles: SVGAnimatedEnumeration;\n    readonly type: SVGAnimatedEnumeration;\n    readonly SVG_STITCHTYPE_NOSTITCH: number;\n    readonly SVG_STITCHTYPE_STITCH: number;\n    readonly SVG_STITCHTYPE_UNKNOWN: number;\n    readonly SVG_TURBULENCE_TYPE_FRACTALNOISE: number;\n    readonly SVG_TURBULENCE_TYPE_TURBULENCE: number;\n    readonly SVG_TURBULENCE_TYPE_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFETurbulenceElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFETurbulenceElement: {\n    prototype: SVGFETurbulenceElement;\n    new(): SVGFETurbulenceElement;\n    readonly SVG_STITCHTYPE_NOSTITCH: number;\n    readonly SVG_STITCHTYPE_STITCH: number;\n    readonly SVG_STITCHTYPE_UNKNOWN: number;\n    readonly SVG_TURBULENCE_TYPE_FRACTALNOISE: number;\n    readonly SVG_TURBULENCE_TYPE_TURBULENCE: number;\n    readonly SVG_TURBULENCE_TYPE_UNKNOWN: number;\n};\n\ninterface SVGFilterElement extends SVGElement, SVGUnitTypes, SVGURIReference {\n    readonly filterResX: SVGAnimatedInteger;\n    readonly filterResY: SVGAnimatedInteger;\n    readonly filterUnits: SVGAnimatedEnumeration;\n    readonly height: SVGAnimatedLength;\n    readonly primitiveUnits: SVGAnimatedEnumeration;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    setFilterRes(filterResX: number, filterResY: number): void;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFilterElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGFilterElement: {\n    prototype: SVGFilterElement;\n    new(): SVGFilterElement;\n};\n\ninterface SVGForeignObjectElement extends SVGGraphicsElement {\n    readonly height: SVGAnimatedLength;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGForeignObjectElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGForeignObjectElement: {\n    prototype: SVGForeignObjectElement;\n    new(): SVGForeignObjectElement;\n};\n\ninterface SVGGElement extends SVGGraphicsElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGGElement: {\n    prototype: SVGGElement;\n    new(): SVGGElement;\n};\n\ninterface SVGGradientElement extends SVGElement, SVGUnitTypes, SVGURIReference {\n    readonly gradientTransform: SVGAnimatedTransformList;\n    readonly gradientUnits: SVGAnimatedEnumeration;\n    readonly spreadMethod: SVGAnimatedEnumeration;\n    readonly SVG_SPREADMETHOD_PAD: number;\n    readonly SVG_SPREADMETHOD_REFLECT: number;\n    readonly SVG_SPREADMETHOD_REPEAT: number;\n    readonly SVG_SPREADMETHOD_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGradientElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGGradientElement: {\n    prototype: SVGGradientElement;\n    new(): SVGGradientElement;\n    readonly SVG_SPREADMETHOD_PAD: number;\n    readonly SVG_SPREADMETHOD_REFLECT: number;\n    readonly SVG_SPREADMETHOD_REPEAT: number;\n    readonly SVG_SPREADMETHOD_UNKNOWN: number;\n};\n\ninterface SVGGraphicsElement extends SVGElement, SVGTests {\n    readonly farthestViewportElement: SVGElement;\n    readonly nearestViewportElement: SVGElement;\n    readonly transform: SVGAnimatedTransformList;\n    getBBox(): SVGRect;\n    getCTM(): SVGMatrix;\n    getScreenCTM(): SVGMatrix;\n    getTransformToElement(element: SVGElement): SVGMatrix;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGraphicsElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGGraphicsElement: {\n    prototype: SVGGraphicsElement;\n    new(): SVGGraphicsElement;\n};\n\ninterface SVGImageElement extends SVGGraphicsElement, SVGURIReference {\n    readonly height: SVGAnimatedLength;\n    readonly preserveAspectRatio: SVGAnimatedPreserveAspectRatio;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGImageElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGImageElement: {\n    prototype: SVGImageElement;\n    new(): SVGImageElement;\n};\n\ninterface SVGLength {\n    readonly unitType: number;\n    value: number;\n    valueAsString: string;\n    valueInSpecifiedUnits: number;\n    convertToSpecifiedUnits(unitType: number): void;\n    newValueSpecifiedUnits(unitType: number, valueInSpecifiedUnits: number): void;\n    readonly SVG_LENGTHTYPE_CM: number;\n    readonly SVG_LENGTHTYPE_EMS: number;\n    readonly SVG_LENGTHTYPE_EXS: number;\n    readonly SVG_LENGTHTYPE_IN: number;\n    readonly SVG_LENGTHTYPE_MM: number;\n    readonly SVG_LENGTHTYPE_NUMBER: number;\n    readonly SVG_LENGTHTYPE_PC: number;\n    readonly SVG_LENGTHTYPE_PERCENTAGE: number;\n    readonly SVG_LENGTHTYPE_PT: number;\n    readonly SVG_LENGTHTYPE_PX: number;\n    readonly SVG_LENGTHTYPE_UNKNOWN: number;\n}\n\ndeclare var SVGLength: {\n    prototype: SVGLength;\n    new(): SVGLength;\n    readonly SVG_LENGTHTYPE_CM: number;\n    readonly SVG_LENGTHTYPE_EMS: number;\n    readonly SVG_LENGTHTYPE_EXS: number;\n    readonly SVG_LENGTHTYPE_IN: number;\n    readonly SVG_LENGTHTYPE_MM: number;\n    readonly SVG_LENGTHTYPE_NUMBER: number;\n    readonly SVG_LENGTHTYPE_PC: number;\n    readonly SVG_LENGTHTYPE_PERCENTAGE: number;\n    readonly SVG_LENGTHTYPE_PT: number;\n    readonly SVG_LENGTHTYPE_PX: number;\n    readonly SVG_LENGTHTYPE_UNKNOWN: number;\n};\n\ninterface SVGLengthList {\n    readonly numberOfItems: number;\n    appendItem(newItem: SVGLength): SVGLength;\n    clear(): void;\n    getItem(index: number): SVGLength;\n    initialize(newItem: SVGLength): SVGLength;\n    insertItemBefore(newItem: SVGLength, index: number): SVGLength;\n    removeItem(index: number): SVGLength;\n    replaceItem(newItem: SVGLength, index: number): SVGLength;\n}\n\ndeclare var SVGLengthList: {\n    prototype: SVGLengthList;\n    new(): SVGLengthList;\n};\n\ninterface SVGLinearGradientElement extends SVGGradientElement {\n    readonly x1: SVGAnimatedLength;\n    readonly x2: SVGAnimatedLength;\n    readonly y1: SVGAnimatedLength;\n    readonly y2: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGLinearGradientElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGLinearGradientElement: {\n    prototype: SVGLinearGradientElement;\n    new(): SVGLinearGradientElement;\n};\n\ninterface SVGLineElement extends SVGGraphicsElement {\n    readonly x1: SVGAnimatedLength;\n    readonly x2: SVGAnimatedLength;\n    readonly y1: SVGAnimatedLength;\n    readonly y2: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGLineElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGLineElement: {\n    prototype: SVGLineElement;\n    new(): SVGLineElement;\n};\n\ninterface SVGMarkerElement extends SVGElement, SVGFitToViewBox {\n    readonly markerHeight: SVGAnimatedLength;\n    readonly markerUnits: SVGAnimatedEnumeration;\n    readonly markerWidth: SVGAnimatedLength;\n    readonly orientAngle: SVGAnimatedAngle;\n    readonly orientType: SVGAnimatedEnumeration;\n    readonly refX: SVGAnimatedLength;\n    readonly refY: SVGAnimatedLength;\n    setOrientToAngle(angle: SVGAngle): void;\n    setOrientToAuto(): void;\n    readonly SVG_MARKER_ORIENT_ANGLE: number;\n    readonly SVG_MARKER_ORIENT_AUTO: number;\n    readonly SVG_MARKER_ORIENT_UNKNOWN: number;\n    readonly SVG_MARKERUNITS_STROKEWIDTH: number;\n    readonly SVG_MARKERUNITS_UNKNOWN: number;\n    readonly SVG_MARKERUNITS_USERSPACEONUSE: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMarkerElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGMarkerElement: {\n    prototype: SVGMarkerElement;\n    new(): SVGMarkerElement;\n    readonly SVG_MARKER_ORIENT_ANGLE: number;\n    readonly SVG_MARKER_ORIENT_AUTO: number;\n    readonly SVG_MARKER_ORIENT_UNKNOWN: number;\n    readonly SVG_MARKERUNITS_STROKEWIDTH: number;\n    readonly SVG_MARKERUNITS_UNKNOWN: number;\n    readonly SVG_MARKERUNITS_USERSPACEONUSE: number;\n};\n\ninterface SVGMaskElement extends SVGElement, SVGTests, SVGUnitTypes {\n    readonly height: SVGAnimatedLength;\n    readonly maskContentUnits: SVGAnimatedEnumeration;\n    readonly maskUnits: SVGAnimatedEnumeration;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMaskElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGMaskElement: {\n    prototype: SVGMaskElement;\n    new(): SVGMaskElement;\n};\n\ninterface SVGMatrix {\n    a: number;\n    b: number;\n    c: number;\n    d: number;\n    e: number;\n    f: number;\n    flipX(): SVGMatrix;\n    flipY(): SVGMatrix;\n    inverse(): SVGMatrix;\n    multiply(secondMatrix: SVGMatrix): SVGMatrix;\n    rotate(angle: number): SVGMatrix;\n    rotateFromVector(x: number, y: number): SVGMatrix;\n    scale(scaleFactor: number): SVGMatrix;\n    scaleNonUniform(scaleFactorX: number, scaleFactorY: number): SVGMatrix;\n    skewX(angle: number): SVGMatrix;\n    skewY(angle: number): SVGMatrix;\n    translate(x: number, y: number): SVGMatrix;\n}\n\ndeclare var SVGMatrix: {\n    prototype: SVGMatrix;\n    new(): SVGMatrix;\n};\n\ninterface SVGMetadataElement extends SVGElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMetadataElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGMetadataElement: {\n    prototype: SVGMetadataElement;\n    new(): SVGMetadataElement;\n};\n\ninterface SVGNumber {\n    value: number;\n}\n\ndeclare var SVGNumber: {\n    prototype: SVGNumber;\n    new(): SVGNumber;\n};\n\ninterface SVGNumberList {\n    readonly numberOfItems: number;\n    appendItem(newItem: SVGNumber): SVGNumber;\n    clear(): void;\n    getItem(index: number): SVGNumber;\n    initialize(newItem: SVGNumber): SVGNumber;\n    insertItemBefore(newItem: SVGNumber, index: number): SVGNumber;\n    removeItem(index: number): SVGNumber;\n    replaceItem(newItem: SVGNumber, index: number): SVGNumber;\n}\n\ndeclare var SVGNumberList: {\n    prototype: SVGNumberList;\n    new(): SVGNumberList;\n};\n\ninterface SVGPathElement extends SVGGraphicsElement {\n    readonly pathSegList: SVGPathSegList;\n    createSVGPathSegArcAbs(x: number, y: number, r1: number, r2: number, angle: number, largeArcFlag: boolean, sweepFlag: boolean): SVGPathSegArcAbs;\n    createSVGPathSegArcRel(x: number, y: number, r1: number, r2: number, angle: number, largeArcFlag: boolean, sweepFlag: boolean): SVGPathSegArcRel;\n    createSVGPathSegClosePath(): SVGPathSegClosePath;\n    createSVGPathSegCurvetoCubicAbs(x: number, y: number, x1: number, y1: number, x2: number, y2: number): SVGPathSegCurvetoCubicAbs;\n    createSVGPathSegCurvetoCubicRel(x: number, y: number, x1: number, y1: number, x2: number, y2: number): SVGPathSegCurvetoCubicRel;\n    createSVGPathSegCurvetoCubicSmoothAbs(x: number, y: number, x2: number, y2: number): SVGPathSegCurvetoCubicSmoothAbs;\n    createSVGPathSegCurvetoCubicSmoothRel(x: number, y: number, x2: number, y2: number): SVGPathSegCurvetoCubicSmoothRel;\n    createSVGPathSegCurvetoQuadraticAbs(x: number, y: number, x1: number, y1: number): SVGPathSegCurvetoQuadraticAbs;\n    createSVGPathSegCurvetoQuadraticRel(x: number, y: number, x1: number, y1: number): SVGPathSegCurvetoQuadraticRel;\n    createSVGPathSegCurvetoQuadraticSmoothAbs(x: number, y: number): SVGPathSegCurvetoQuadraticSmoothAbs;\n    createSVGPathSegCurvetoQuadraticSmoothRel(x: number, y: number): SVGPathSegCurvetoQuadraticSmoothRel;\n    createSVGPathSegLinetoAbs(x: number, y: number): SVGPathSegLinetoAbs;\n    createSVGPathSegLinetoHorizontalAbs(x: number): SVGPathSegLinetoHorizontalAbs;\n    createSVGPathSegLinetoHorizontalRel(x: number): SVGPathSegLinetoHorizontalRel;\n    createSVGPathSegLinetoRel(x: number, y: number): SVGPathSegLinetoRel;\n    createSVGPathSegLinetoVerticalAbs(y: number): SVGPathSegLinetoVerticalAbs;\n    createSVGPathSegLinetoVerticalRel(y: number): SVGPathSegLinetoVerticalRel;\n    createSVGPathSegMovetoAbs(x: number, y: number): SVGPathSegMovetoAbs;\n    createSVGPathSegMovetoRel(x: number, y: number): SVGPathSegMovetoRel;\n    getPathSegAtLength(distance: number): number;\n    getPointAtLength(distance: number): SVGPoint;\n    getTotalLength(): number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPathElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGPathElement: {\n    prototype: SVGPathElement;\n    new(): SVGPathElement;\n};\n\ninterface SVGPathSeg {\n    readonly pathSegType: number;\n    readonly pathSegTypeAsLetter: string;\n    readonly PATHSEG_ARC_ABS: number;\n    readonly PATHSEG_ARC_REL: number;\n    readonly PATHSEG_CLOSEPATH: number;\n    readonly PATHSEG_CURVETO_CUBIC_ABS: number;\n    readonly PATHSEG_CURVETO_CUBIC_REL: number;\n    readonly PATHSEG_CURVETO_CUBIC_SMOOTH_ABS: number;\n    readonly PATHSEG_CURVETO_CUBIC_SMOOTH_REL: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_ABS: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_REL: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL: number;\n    readonly PATHSEG_LINETO_ABS: number;\n    readonly PATHSEG_LINETO_HORIZONTAL_ABS: number;\n    readonly PATHSEG_LINETO_HORIZONTAL_REL: number;\n    readonly PATHSEG_LINETO_REL: number;\n    readonly PATHSEG_LINETO_VERTICAL_ABS: number;\n    readonly PATHSEG_LINETO_VERTICAL_REL: number;\n    readonly PATHSEG_MOVETO_ABS: number;\n    readonly PATHSEG_MOVETO_REL: number;\n    readonly PATHSEG_UNKNOWN: number;\n}\n\ndeclare var SVGPathSeg: {\n    prototype: SVGPathSeg;\n    new(): SVGPathSeg;\n    readonly PATHSEG_ARC_ABS: number;\n    readonly PATHSEG_ARC_REL: number;\n    readonly PATHSEG_CLOSEPATH: number;\n    readonly PATHSEG_CURVETO_CUBIC_ABS: number;\n    readonly PATHSEG_CURVETO_CUBIC_REL: number;\n    readonly PATHSEG_CURVETO_CUBIC_SMOOTH_ABS: number;\n    readonly PATHSEG_CURVETO_CUBIC_SMOOTH_REL: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_ABS: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_REL: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL: number;\n    readonly PATHSEG_LINETO_ABS: number;\n    readonly PATHSEG_LINETO_HORIZONTAL_ABS: number;\n    readonly PATHSEG_LINETO_HORIZONTAL_REL: number;\n    readonly PATHSEG_LINETO_REL: number;\n    readonly PATHSEG_LINETO_VERTICAL_ABS: number;\n    readonly PATHSEG_LINETO_VERTICAL_REL: number;\n    readonly PATHSEG_MOVETO_ABS: number;\n    readonly PATHSEG_MOVETO_REL: number;\n    readonly PATHSEG_UNKNOWN: number;\n};\n\ninterface SVGPathSegArcAbs extends SVGPathSeg {\n    angle: number;\n    largeArcFlag: boolean;\n    r1: number;\n    r2: number;\n    sweepFlag: boolean;\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegArcAbs: {\n    prototype: SVGPathSegArcAbs;\n    new(): SVGPathSegArcAbs;\n};\n\ninterface SVGPathSegArcRel extends SVGPathSeg {\n    angle: number;\n    largeArcFlag: boolean;\n    r1: number;\n    r2: number;\n    sweepFlag: boolean;\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegArcRel: {\n    prototype: SVGPathSegArcRel;\n    new(): SVGPathSegArcRel;\n};\n\ninterface SVGPathSegClosePath extends SVGPathSeg {\n}\n\ndeclare var SVGPathSegClosePath: {\n    prototype: SVGPathSegClosePath;\n    new(): SVGPathSegClosePath;\n};\n\ninterface SVGPathSegCurvetoCubicAbs extends SVGPathSeg {\n    x: number;\n    x1: number;\n    x2: number;\n    y: number;\n    y1: number;\n    y2: number;\n}\n\ndeclare var SVGPathSegCurvetoCubicAbs: {\n    prototype: SVGPathSegCurvetoCubicAbs;\n    new(): SVGPathSegCurvetoCubicAbs;\n};\n\ninterface SVGPathSegCurvetoCubicRel extends SVGPathSeg {\n    x: number;\n    x1: number;\n    x2: number;\n    y: number;\n    y1: number;\n    y2: number;\n}\n\ndeclare var SVGPathSegCurvetoCubicRel: {\n    prototype: SVGPathSegCurvetoCubicRel;\n    new(): SVGPathSegCurvetoCubicRel;\n};\n\ninterface SVGPathSegCurvetoCubicSmoothAbs extends SVGPathSeg {\n    x: number;\n    x2: number;\n    y: number;\n    y2: number;\n}\n\ndeclare var SVGPathSegCurvetoCubicSmoothAbs: {\n    prototype: SVGPathSegCurvetoCubicSmoothAbs;\n    new(): SVGPathSegCurvetoCubicSmoothAbs;\n};\n\ninterface SVGPathSegCurvetoCubicSmoothRel extends SVGPathSeg {\n    x: number;\n    x2: number;\n    y: number;\n    y2: number;\n}\n\ndeclare var SVGPathSegCurvetoCubicSmoothRel: {\n    prototype: SVGPathSegCurvetoCubicSmoothRel;\n    new(): SVGPathSegCurvetoCubicSmoothRel;\n};\n\ninterface SVGPathSegCurvetoQuadraticAbs extends SVGPathSeg {\n    x: number;\n    x1: number;\n    y: number;\n    y1: number;\n}\n\ndeclare var SVGPathSegCurvetoQuadraticAbs: {\n    prototype: SVGPathSegCurvetoQuadraticAbs;\n    new(): SVGPathSegCurvetoQuadraticAbs;\n};\n\ninterface SVGPathSegCurvetoQuadraticRel extends SVGPathSeg {\n    x: number;\n    x1: number;\n    y: number;\n    y1: number;\n}\n\ndeclare var SVGPathSegCurvetoQuadraticRel: {\n    prototype: SVGPathSegCurvetoQuadraticRel;\n    new(): SVGPathSegCurvetoQuadraticRel;\n};\n\ninterface SVGPathSegCurvetoQuadraticSmoothAbs extends SVGPathSeg {\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegCurvetoQuadraticSmoothAbs: {\n    prototype: SVGPathSegCurvetoQuadraticSmoothAbs;\n    new(): SVGPathSegCurvetoQuadraticSmoothAbs;\n};\n\ninterface SVGPathSegCurvetoQuadraticSmoothRel extends SVGPathSeg {\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegCurvetoQuadraticSmoothRel: {\n    prototype: SVGPathSegCurvetoQuadraticSmoothRel;\n    new(): SVGPathSegCurvetoQuadraticSmoothRel;\n};\n\ninterface SVGPathSegLinetoAbs extends SVGPathSeg {\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegLinetoAbs: {\n    prototype: SVGPathSegLinetoAbs;\n    new(): SVGPathSegLinetoAbs;\n};\n\ninterface SVGPathSegLinetoHorizontalAbs extends SVGPathSeg {\n    x: number;\n}\n\ndeclare var SVGPathSegLinetoHorizontalAbs: {\n    prototype: SVGPathSegLinetoHorizontalAbs;\n    new(): SVGPathSegLinetoHorizontalAbs;\n};\n\ninterface SVGPathSegLinetoHorizontalRel extends SVGPathSeg {\n    x: number;\n}\n\ndeclare var SVGPathSegLinetoHorizontalRel: {\n    prototype: SVGPathSegLinetoHorizontalRel;\n    new(): SVGPathSegLinetoHorizontalRel;\n};\n\ninterface SVGPathSegLinetoRel extends SVGPathSeg {\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegLinetoRel: {\n    prototype: SVGPathSegLinetoRel;\n    new(): SVGPathSegLinetoRel;\n};\n\ninterface SVGPathSegLinetoVerticalAbs extends SVGPathSeg {\n    y: number;\n}\n\ndeclare var SVGPathSegLinetoVerticalAbs: {\n    prototype: SVGPathSegLinetoVerticalAbs;\n    new(): SVGPathSegLinetoVerticalAbs;\n};\n\ninterface SVGPathSegLinetoVerticalRel extends SVGPathSeg {\n    y: number;\n}\n\ndeclare var SVGPathSegLinetoVerticalRel: {\n    prototype: SVGPathSegLinetoVerticalRel;\n    new(): SVGPathSegLinetoVerticalRel;\n};\n\ninterface SVGPathSegList {\n    readonly numberOfItems: number;\n    appendItem(newItem: SVGPathSeg): SVGPathSeg;\n    clear(): void;\n    getItem(index: number): SVGPathSeg;\n    initialize(newItem: SVGPathSeg): SVGPathSeg;\n    insertItemBefore(newItem: SVGPathSeg, index: number): SVGPathSeg;\n    removeItem(index: number): SVGPathSeg;\n    replaceItem(newItem: SVGPathSeg, index: number): SVGPathSeg;\n}\n\ndeclare var SVGPathSegList: {\n    prototype: SVGPathSegList;\n    new(): SVGPathSegList;\n};\n\ninterface SVGPathSegMovetoAbs extends SVGPathSeg {\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegMovetoAbs: {\n    prototype: SVGPathSegMovetoAbs;\n    new(): SVGPathSegMovetoAbs;\n};\n\ninterface SVGPathSegMovetoRel extends SVGPathSeg {\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegMovetoRel: {\n    prototype: SVGPathSegMovetoRel;\n    new(): SVGPathSegMovetoRel;\n};\n\ninterface SVGPatternElement extends SVGElement, SVGTests, SVGUnitTypes, SVGFitToViewBox, SVGURIReference {\n    readonly height: SVGAnimatedLength;\n    readonly patternContentUnits: SVGAnimatedEnumeration;\n    readonly patternTransform: SVGAnimatedTransformList;\n    readonly patternUnits: SVGAnimatedEnumeration;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPatternElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGPatternElement: {\n    prototype: SVGPatternElement;\n    new(): SVGPatternElement;\n};\n\ninterface SVGPoint {\n    x: number;\n    y: number;\n    matrixTransform(matrix: SVGMatrix): SVGPoint;\n}\n\ndeclare var SVGPoint: {\n    prototype: SVGPoint;\n    new(): SVGPoint;\n};\n\ninterface SVGPointList {\n    readonly numberOfItems: number;\n    appendItem(newItem: SVGPoint): SVGPoint;\n    clear(): void;\n    getItem(index: number): SVGPoint;\n    initialize(newItem: SVGPoint): SVGPoint;\n    insertItemBefore(newItem: SVGPoint, index: number): SVGPoint;\n    removeItem(index: number): SVGPoint;\n    replaceItem(newItem: SVGPoint, index: number): SVGPoint;\n}\n\ndeclare var SVGPointList: {\n    prototype: SVGPointList;\n    new(): SVGPointList;\n};\n\ninterface SVGPolygonElement extends SVGGraphicsElement, SVGAnimatedPoints {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPolygonElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGPolygonElement: {\n    prototype: SVGPolygonElement;\n    new(): SVGPolygonElement;\n};\n\ninterface SVGPolylineElement extends SVGGraphicsElement, SVGAnimatedPoints {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPolylineElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGPolylineElement: {\n    prototype: SVGPolylineElement;\n    new(): SVGPolylineElement;\n};\n\ninterface SVGPreserveAspectRatio {\n    align: number;\n    meetOrSlice: number;\n    readonly SVG_MEETORSLICE_MEET: number;\n    readonly SVG_MEETORSLICE_SLICE: number;\n    readonly SVG_MEETORSLICE_UNKNOWN: number;\n    readonly SVG_PRESERVEASPECTRATIO_NONE: number;\n    readonly SVG_PRESERVEASPECTRATIO_UNKNOWN: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMAX: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMID: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMIN: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMAX: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMID: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMIN: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMAX: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMID: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMIN: number;\n}\n\ndeclare var SVGPreserveAspectRatio: {\n    prototype: SVGPreserveAspectRatio;\n    new(): SVGPreserveAspectRatio;\n    readonly SVG_MEETORSLICE_MEET: number;\n    readonly SVG_MEETORSLICE_SLICE: number;\n    readonly SVG_MEETORSLICE_UNKNOWN: number;\n    readonly SVG_PRESERVEASPECTRATIO_NONE: number;\n    readonly SVG_PRESERVEASPECTRATIO_UNKNOWN: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMAX: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMID: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMIN: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMAX: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMID: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMIN: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMAX: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMID: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMIN: number;\n};\n\ninterface SVGRadialGradientElement extends SVGGradientElement {\n    readonly cx: SVGAnimatedLength;\n    readonly cy: SVGAnimatedLength;\n    readonly fx: SVGAnimatedLength;\n    readonly fy: SVGAnimatedLength;\n    readonly r: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGRadialGradientElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGRadialGradientElement: {\n    prototype: SVGRadialGradientElement;\n    new(): SVGRadialGradientElement;\n};\n\ninterface SVGRect {\n    height: number;\n    width: number;\n    x: number;\n    y: number;\n}\n\ndeclare var SVGRect: {\n    prototype: SVGRect;\n    new(): SVGRect;\n};\n\ninterface SVGRectElement extends SVGGraphicsElement {\n    readonly height: SVGAnimatedLength;\n    readonly rx: SVGAnimatedLength;\n    readonly ry: SVGAnimatedLength;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGRectElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGRectElement: {\n    prototype: SVGRectElement;\n    new(): SVGRectElement;\n};\n\ninterface SVGScriptElement extends SVGElement, SVGURIReference {\n    type: string;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGScriptElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGScriptElement: {\n    prototype: SVGScriptElement;\n    new(): SVGScriptElement;\n};\n\ninterface SVGStopElement extends SVGElement {\n    readonly offset: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGStopElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGStopElement: {\n    prototype: SVGStopElement;\n    new(): SVGStopElement;\n};\n\ninterface SVGStringList {\n    readonly numberOfItems: number;\n    appendItem(newItem: string): string;\n    clear(): void;\n    getItem(index: number): string;\n    initialize(newItem: string): string;\n    insertItemBefore(newItem: string, index: number): string;\n    removeItem(index: number): string;\n    replaceItem(newItem: string, index: number): string;\n}\n\ndeclare var SVGStringList: {\n    prototype: SVGStringList;\n    new(): SVGStringList;\n};\n\ninterface SVGStyleElement extends SVGElement {\n    disabled: boolean;\n    media: string;\n    title: string;\n    type: string;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGStyleElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGStyleElement: {\n    prototype: SVGStyleElement;\n    new(): SVGStyleElement;\n};\n\ninterface SVGSVGElementEventMap extends SVGElementEventMap {\n    \"SVGAbort\": Event;\n    \"SVGError\": Event;\n    \"resize\": UIEvent;\n    \"scroll\": UIEvent;\n    \"SVGUnload\": Event;\n    \"SVGZoom\": SVGZoomEvent;\n}\n\ninterface SVGSVGElement extends SVGGraphicsElement, DocumentEvent, SVGFitToViewBox, SVGZoomAndPan {\n    contentScriptType: string;\n    contentStyleType: string;\n    currentScale: number;\n    readonly currentTranslate: SVGPoint;\n    readonly height: SVGAnimatedLength;\n    onabort: (this: SVGSVGElement, ev: Event) => any;\n    onerror: (this: SVGSVGElement, ev: Event) => any;\n    onresize: (this: SVGSVGElement, ev: UIEvent) => any;\n    onscroll: (this: SVGSVGElement, ev: UIEvent) => any;\n    onunload: (this: SVGSVGElement, ev: Event) => any;\n    onzoom: (this: SVGSVGElement, ev: SVGZoomEvent) => any;\n    readonly pixelUnitToMillimeterX: number;\n    readonly pixelUnitToMillimeterY: number;\n    readonly screenPixelToMillimeterX: number;\n    readonly screenPixelToMillimeterY: number;\n    readonly viewport: SVGRect;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    checkEnclosure(element: SVGElement, rect: SVGRect): boolean;\n    checkIntersection(element: SVGElement, rect: SVGRect): boolean;\n    createSVGAngle(): SVGAngle;\n    createSVGLength(): SVGLength;\n    createSVGMatrix(): SVGMatrix;\n    createSVGNumber(): SVGNumber;\n    createSVGPoint(): SVGPoint;\n    createSVGRect(): SVGRect;\n    createSVGTransform(): SVGTransform;\n    createSVGTransformFromMatrix(matrix: SVGMatrix): SVGTransform;\n    deselectAll(): void;\n    forceRedraw(): void;\n    getComputedStyle(elt: Element, pseudoElt?: string): CSSStyleDeclaration;\n    getCurrentTime(): number;\n    getElementById(elementId: string): Element;\n    getEnclosureList(rect: SVGRect, referenceElement: SVGElement): NodeListOf<SVGCircleElement | SVGEllipseElement | SVGImageElement | SVGLineElement | SVGPathElement | SVGPolygonElement | SVGPolylineElement | SVGRectElement | SVGTextElement | SVGUseElement>;\n    getIntersectionList(rect: SVGRect, referenceElement: SVGElement): NodeListOf<SVGCircleElement | SVGEllipseElement | SVGImageElement | SVGLineElement | SVGPathElement | SVGPolygonElement | SVGPolylineElement | SVGRectElement | SVGTextElement | SVGUseElement>;\n    pauseAnimations(): void;\n    setCurrentTime(seconds: number): void;\n    suspendRedraw(maxWaitMilliseconds: number): number;\n    unpauseAnimations(): void;\n    unsuspendRedraw(suspendHandleID: number): void;\n    unsuspendRedrawAll(): void;\n    addEventListener<K extends keyof SVGSVGElementEventMap>(type: K, listener: (this: SVGSVGElement, ev: SVGSVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGSVGElement: {\n    prototype: SVGSVGElement;\n    new(): SVGSVGElement;\n};\n\ninterface SVGSwitchElement extends SVGGraphicsElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGSwitchElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGSwitchElement: {\n    prototype: SVGSwitchElement;\n    new(): SVGSwitchElement;\n};\n\ninterface SVGSymbolElement extends SVGElement, SVGFitToViewBox {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGSymbolElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGSymbolElement: {\n    prototype: SVGSymbolElement;\n    new(): SVGSymbolElement;\n};\n\ninterface SVGTextContentElement extends SVGGraphicsElement {\n    readonly lengthAdjust: SVGAnimatedEnumeration;\n    readonly textLength: SVGAnimatedLength;\n    getCharNumAtPosition(point: SVGPoint): number;\n    getComputedTextLength(): number;\n    getEndPositionOfChar(charnum: number): SVGPoint;\n    getExtentOfChar(charnum: number): SVGRect;\n    getNumberOfChars(): number;\n    getRotationOfChar(charnum: number): number;\n    getStartPositionOfChar(charnum: number): SVGPoint;\n    getSubStringLength(charnum: number, nchars: number): number;\n    selectSubString(charnum: number, nchars: number): void;\n    readonly LENGTHADJUST_SPACING: number;\n    readonly LENGTHADJUST_SPACINGANDGLYPHS: number;\n    readonly LENGTHADJUST_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextContentElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGTextContentElement: {\n    prototype: SVGTextContentElement;\n    new(): SVGTextContentElement;\n    readonly LENGTHADJUST_SPACING: number;\n    readonly LENGTHADJUST_SPACINGANDGLYPHS: number;\n    readonly LENGTHADJUST_UNKNOWN: number;\n};\n\ninterface SVGTextElement extends SVGTextPositioningElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGTextElement: {\n    prototype: SVGTextElement;\n    new(): SVGTextElement;\n};\n\ninterface SVGTextPathElement extends SVGTextContentElement, SVGURIReference {\n    readonly method: SVGAnimatedEnumeration;\n    readonly spacing: SVGAnimatedEnumeration;\n    readonly startOffset: SVGAnimatedLength;\n    readonly TEXTPATH_METHODTYPE_ALIGN: number;\n    readonly TEXTPATH_METHODTYPE_STRETCH: number;\n    readonly TEXTPATH_METHODTYPE_UNKNOWN: number;\n    readonly TEXTPATH_SPACINGTYPE_AUTO: number;\n    readonly TEXTPATH_SPACINGTYPE_EXACT: number;\n    readonly TEXTPATH_SPACINGTYPE_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextPathElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGTextPathElement: {\n    prototype: SVGTextPathElement;\n    new(): SVGTextPathElement;\n    readonly TEXTPATH_METHODTYPE_ALIGN: number;\n    readonly TEXTPATH_METHODTYPE_STRETCH: number;\n    readonly TEXTPATH_METHODTYPE_UNKNOWN: number;\n    readonly TEXTPATH_SPACINGTYPE_AUTO: number;\n    readonly TEXTPATH_SPACINGTYPE_EXACT: number;\n    readonly TEXTPATH_SPACINGTYPE_UNKNOWN: number;\n};\n\ninterface SVGTextPositioningElement extends SVGTextContentElement {\n    readonly dx: SVGAnimatedLengthList;\n    readonly dy: SVGAnimatedLengthList;\n    readonly rotate: SVGAnimatedNumberList;\n    readonly x: SVGAnimatedLengthList;\n    readonly y: SVGAnimatedLengthList;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextPositioningElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGTextPositioningElement: {\n    prototype: SVGTextPositioningElement;\n    new(): SVGTextPositioningElement;\n};\n\ninterface SVGTitleElement extends SVGElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTitleElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGTitleElement: {\n    prototype: SVGTitleElement;\n    new(): SVGTitleElement;\n};\n\ninterface SVGTransform {\n    readonly angle: number;\n    readonly matrix: SVGMatrix;\n    readonly type: number;\n    setMatrix(matrix: SVGMatrix): void;\n    setRotate(angle: number, cx: number, cy: number): void;\n    setScale(sx: number, sy: number): void;\n    setSkewX(angle: number): void;\n    setSkewY(angle: number): void;\n    setTranslate(tx: number, ty: number): void;\n    readonly SVG_TRANSFORM_MATRIX: number;\n    readonly SVG_TRANSFORM_ROTATE: number;\n    readonly SVG_TRANSFORM_SCALE: number;\n    readonly SVG_TRANSFORM_SKEWX: number;\n    readonly SVG_TRANSFORM_SKEWY: number;\n    readonly SVG_TRANSFORM_TRANSLATE: number;\n    readonly SVG_TRANSFORM_UNKNOWN: number;\n}\n\ndeclare var SVGTransform: {\n    prototype: SVGTransform;\n    new(): SVGTransform;\n    readonly SVG_TRANSFORM_MATRIX: number;\n    readonly SVG_TRANSFORM_ROTATE: number;\n    readonly SVG_TRANSFORM_SCALE: number;\n    readonly SVG_TRANSFORM_SKEWX: number;\n    readonly SVG_TRANSFORM_SKEWY: number;\n    readonly SVG_TRANSFORM_TRANSLATE: number;\n    readonly SVG_TRANSFORM_UNKNOWN: number;\n};\n\ninterface SVGTransformList {\n    readonly numberOfItems: number;\n    appendItem(newItem: SVGTransform): SVGTransform;\n    clear(): void;\n    consolidate(): SVGTransform;\n    createSVGTransformFromMatrix(matrix: SVGMatrix): SVGTransform;\n    getItem(index: number): SVGTransform;\n    initialize(newItem: SVGTransform): SVGTransform;\n    insertItemBefore(newItem: SVGTransform, index: number): SVGTransform;\n    removeItem(index: number): SVGTransform;\n    replaceItem(newItem: SVGTransform, index: number): SVGTransform;\n}\n\ndeclare var SVGTransformList: {\n    prototype: SVGTransformList;\n    new(): SVGTransformList;\n};\n\ninterface SVGTSpanElement extends SVGTextPositioningElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTSpanElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGTSpanElement: {\n    prototype: SVGTSpanElement;\n    new(): SVGTSpanElement;\n};\n\ninterface SVGUnitTypes {\n    readonly SVG_UNIT_TYPE_OBJECTBOUNDINGBOX: number;\n    readonly SVG_UNIT_TYPE_UNKNOWN: number;\n    readonly SVG_UNIT_TYPE_USERSPACEONUSE: number;\n}\ndeclare var SVGUnitTypes: SVGUnitTypes;\n\ninterface SVGUseElement extends SVGGraphicsElement, SVGURIReference {\n    readonly animatedInstanceRoot: SVGElementInstance;\n    readonly height: SVGAnimatedLength;\n    readonly instanceRoot: SVGElementInstance;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGUseElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGUseElement: {\n    prototype: SVGUseElement;\n    new(): SVGUseElement;\n};\n\ninterface SVGViewElement extends SVGElement, SVGZoomAndPan, SVGFitToViewBox {\n    readonly viewTarget: SVGStringList;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGViewElement, ev: SVGElementEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var SVGViewElement: {\n    prototype: SVGViewElement;\n    new(): SVGViewElement;\n};\n\ninterface SVGZoomAndPan {\n    readonly zoomAndPan: number;\n}\n\ndeclare var SVGZoomAndPan: {\n    readonly SVG_ZOOMANDPAN_DISABLE: number;\n    readonly SVG_ZOOMANDPAN_MAGNIFY: number;\n    readonly SVG_ZOOMANDPAN_UNKNOWN: number;\n};\n\ninterface SVGZoomEvent extends UIEvent {\n    readonly newScale: number;\n    readonly newTranslate: SVGPoint;\n    readonly previousScale: number;\n    readonly previousTranslate: SVGPoint;\n    readonly zoomRectScreen: SVGRect;\n}\n\ndeclare var SVGZoomEvent: {\n    prototype: SVGZoomEvent;\n    new(): SVGZoomEvent;\n};\n\ninterface SyncManager {\n    getTags(): any;\n    register(tag: string): Promise<void>;\n}\n\ndeclare var SyncManager: {\n    prototype: SyncManager;\n    new(): SyncManager;\n};\n\ninterface Text extends CharacterData {\n    readonly wholeText: string;\n    readonly assignedSlot: HTMLSlotElement | null;\n    splitText(offset: number): Text;\n}\n\ndeclare var Text: {\n    prototype: Text;\n    new(data?: string): Text;\n};\n\ninterface TextEvent extends UIEvent {\n    readonly data: string;\n    readonly inputMethod: number;\n    readonly locale: string;\n    initTextEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, dataArg: string, inputMethod: number, locale: string): void;\n    readonly DOM_INPUT_METHOD_DROP: number;\n    readonly DOM_INPUT_METHOD_HANDWRITING: number;\n    readonly DOM_INPUT_METHOD_IME: number;\n    readonly DOM_INPUT_METHOD_KEYBOARD: number;\n    readonly DOM_INPUT_METHOD_MULTIMODAL: number;\n    readonly DOM_INPUT_METHOD_OPTION: number;\n    readonly DOM_INPUT_METHOD_PASTE: number;\n    readonly DOM_INPUT_METHOD_SCRIPT: number;\n    readonly DOM_INPUT_METHOD_UNKNOWN: number;\n    readonly DOM_INPUT_METHOD_VOICE: number;\n}\n\ndeclare var TextEvent: {\n    prototype: TextEvent;\n    new(): TextEvent;\n    readonly DOM_INPUT_METHOD_DROP: number;\n    readonly DOM_INPUT_METHOD_HANDWRITING: number;\n    readonly DOM_INPUT_METHOD_IME: number;\n    readonly DOM_INPUT_METHOD_KEYBOARD: number;\n    readonly DOM_INPUT_METHOD_MULTIMODAL: number;\n    readonly DOM_INPUT_METHOD_OPTION: number;\n    readonly DOM_INPUT_METHOD_PASTE: number;\n    readonly DOM_INPUT_METHOD_SCRIPT: number;\n    readonly DOM_INPUT_METHOD_UNKNOWN: number;\n    readonly DOM_INPUT_METHOD_VOICE: number;\n};\n\ninterface TextMetrics {\n    readonly width: number;\n}\n\ndeclare var TextMetrics: {\n    prototype: TextMetrics;\n    new(): TextMetrics;\n};\n\ninterface TextTrackEventMap {\n    \"cuechange\": Event;\n    \"error\": Event;\n    \"load\": Event;\n}\n\ninterface TextTrack extends EventTarget {\n    readonly activeCues: TextTrackCueList;\n    readonly cues: TextTrackCueList;\n    readonly inBandMetadataTrackDispatchType: string;\n    readonly kind: string;\n    readonly label: string;\n    readonly language: string;\n    mode: any;\n    oncuechange: (this: TextTrack, ev: Event) => any;\n    onerror: (this: TextTrack, ev: Event) => any;\n    onload: (this: TextTrack, ev: Event) => any;\n    readonly readyState: number;\n    addCue(cue: TextTrackCue): void;\n    removeCue(cue: TextTrackCue): void;\n    readonly DISABLED: number;\n    readonly ERROR: number;\n    readonly HIDDEN: number;\n    readonly LOADED: number;\n    readonly LOADING: number;\n    readonly NONE: number;\n    readonly SHOWING: number;\n    addEventListener<K extends keyof TextTrackEventMap>(type: K, listener: (this: TextTrack, ev: TextTrackEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var TextTrack: {\n    prototype: TextTrack;\n    new(): TextTrack;\n    readonly DISABLED: number;\n    readonly ERROR: number;\n    readonly HIDDEN: number;\n    readonly LOADED: number;\n    readonly LOADING: number;\n    readonly NONE: number;\n    readonly SHOWING: number;\n};\n\ninterface TextTrackCueEventMap {\n    \"enter\": Event;\n    \"exit\": Event;\n}\n\ninterface TextTrackCue extends EventTarget {\n    endTime: number;\n    id: string;\n    onenter: (this: TextTrackCue, ev: Event) => any;\n    onexit: (this: TextTrackCue, ev: Event) => any;\n    pauseOnExit: boolean;\n    startTime: number;\n    text: string;\n    readonly track: TextTrack;\n    getCueAsHTML(): DocumentFragment;\n    addEventListener<K extends keyof TextTrackCueEventMap>(type: K, listener: (this: TextTrackCue, ev: TextTrackCueEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var TextTrackCue: {\n    prototype: TextTrackCue;\n    new(startTime: number, endTime: number, text: string): TextTrackCue;\n};\n\ninterface TextTrackCueList {\n    readonly length: number;\n    getCueById(id: string): TextTrackCue;\n    item(index: number): TextTrackCue;\n    [index: number]: TextTrackCue;\n}\n\ndeclare var TextTrackCueList: {\n    prototype: TextTrackCueList;\n    new(): TextTrackCueList;\n};\n\ninterface TextTrackListEventMap {\n    \"addtrack\": TrackEvent;\n}\n\ninterface TextTrackList extends EventTarget {\n    readonly length: number;\n    onaddtrack: ((this: TextTrackList, ev: TrackEvent) => any) | null;\n    item(index: number): TextTrack;\n    addEventListener<K extends keyof TextTrackListEventMap>(type: K, listener: (this: TextTrackList, ev: TextTrackListEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n    [index: number]: TextTrack;\n}\n\ndeclare var TextTrackList: {\n    prototype: TextTrackList;\n    new(): TextTrackList;\n};\n\ninterface TimeRanges {\n    readonly length: number;\n    end(index: number): number;\n    start(index: number): number;\n}\n\ndeclare var TimeRanges: {\n    prototype: TimeRanges;\n    new(): TimeRanges;\n};\n\ninterface Touch {\n    readonly clientX: number;\n    readonly clientY: number;\n    readonly identifier: number;\n    readonly pageX: number;\n    readonly pageY: number;\n    readonly screenX: number;\n    readonly screenY: number;\n    readonly target: EventTarget;\n}\n\ndeclare var Touch: {\n    prototype: Touch;\n    new(): Touch;\n};\n\ninterface TouchEvent extends UIEvent {\n    readonly altKey: boolean;\n    readonly changedTouches: TouchList;\n    readonly charCode: number;\n    readonly ctrlKey: boolean;\n    readonly keyCode: number;\n    readonly metaKey: boolean;\n    readonly shiftKey: boolean;\n    readonly targetTouches: TouchList;\n    readonly touches: TouchList;\n    readonly which: number;\n}\n\ndeclare var TouchEvent: {\n    prototype: TouchEvent;\n    new(type: string, touchEventInit?: TouchEventInit): TouchEvent;\n};\n\ninterface TouchList {\n    readonly length: number;\n    item(index: number): Touch | null;\n    [index: number]: Touch;\n}\n\ndeclare var TouchList: {\n    prototype: TouchList;\n    new(): TouchList;\n};\n\ninterface TrackEvent extends Event {\n    readonly track: VideoTrack | AudioTrack | TextTrack | null;\n}\n\ndeclare var TrackEvent: {\n    prototype: TrackEvent;\n    new(typeArg: string, eventInitDict?: TrackEventInit): TrackEvent;\n};\n\ninterface TransitionEvent extends Event {\n    readonly elapsedTime: number;\n    readonly propertyName: string;\n    initTransitionEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, propertyNameArg: string, elapsedTimeArg: number): void;\n}\n\ndeclare var TransitionEvent: {\n    prototype: TransitionEvent;\n    new(typeArg: string, eventInitDict?: TransitionEventInit): TransitionEvent;\n};\n\ninterface TreeWalker {\n    currentNode: Node;\n    readonly expandEntityReferences: boolean;\n    readonly filter: NodeFilter;\n    readonly root: Node;\n    readonly whatToShow: number;\n    firstChild(): Node;\n    lastChild(): Node;\n    nextNode(): Node;\n    nextSibling(): Node;\n    parentNode(): Node;\n    previousNode(): Node;\n    previousSibling(): Node;\n}\n\ndeclare var TreeWalker: {\n    prototype: TreeWalker;\n    new(): TreeWalker;\n};\n\ninterface UIEvent extends Event {\n    readonly detail: number;\n    readonly view: Window;\n    initUIEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number): void;\n}\n\ndeclare var UIEvent: {\n    prototype: UIEvent;\n    new(typeArg: string, eventInitDict?: UIEventInit): UIEvent;\n};\n\ninterface UnviewableContentIdentifiedEvent extends NavigationEventWithReferrer {\n    readonly mediaType: string;\n}\n\ndeclare var UnviewableContentIdentifiedEvent: {\n    prototype: UnviewableContentIdentifiedEvent;\n    new(): UnviewableContentIdentifiedEvent;\n};\n\ninterface URL {\n    hash: string;\n    host: string;\n    hostname: string;\n    href: string;\n    readonly origin: string;\n    password: string;\n    pathname: string;\n    port: string;\n    protocol: string;\n    search: string;\n    username: string;\n    readonly searchParams: URLSearchParams;\n    toString(): string;\n}\n\ndeclare var URL: {\n    prototype: URL;\n    new(url: string, base?: string): URL;\n    createObjectURL(object: any, options?: ObjectURLOptions): string;\n    revokeObjectURL(url: string): void;\n};\n\ninterface ValidityState {\n    readonly badInput: boolean;\n    readonly customError: boolean;\n    readonly patternMismatch: boolean;\n    readonly rangeOverflow: boolean;\n    readonly rangeUnderflow: boolean;\n    readonly stepMismatch: boolean;\n    readonly tooLong: boolean;\n    readonly typeMismatch: boolean;\n    readonly valid: boolean;\n    readonly valueMissing: boolean;\n}\n\ndeclare var ValidityState: {\n    prototype: ValidityState;\n    new(): ValidityState;\n};\n\ninterface VideoPlaybackQuality {\n    readonly corruptedVideoFrames: number;\n    readonly creationTime: number;\n    readonly droppedVideoFrames: number;\n    readonly totalFrameDelay: number;\n    readonly totalVideoFrames: number;\n}\n\ndeclare var VideoPlaybackQuality: {\n    prototype: VideoPlaybackQuality;\n    new(): VideoPlaybackQuality;\n};\n\ninterface VideoTrack {\n    readonly id: string;\n    kind: string;\n    readonly label: string;\n    language: string;\n    selected: boolean;\n    readonly sourceBuffer: SourceBuffer;\n}\n\ndeclare var VideoTrack: {\n    prototype: VideoTrack;\n    new(): VideoTrack;\n};\n\ninterface VideoTrackListEventMap {\n    \"addtrack\": TrackEvent;\n    \"change\": Event;\n    \"removetrack\": TrackEvent;\n}\n\ninterface VideoTrackList extends EventTarget {\n    readonly length: number;\n    onaddtrack: (this: VideoTrackList, ev: TrackEvent) => any;\n    onchange: (this: VideoTrackList, ev: Event) => any;\n    onremovetrack: (this: VideoTrackList, ev: TrackEvent) => any;\n    readonly selectedIndex: number;\n    getTrackById(id: string): VideoTrack | null;\n    item(index: number): VideoTrack;\n    addEventListener<K extends keyof VideoTrackListEventMap>(type: K, listener: (this: VideoTrackList, ev: VideoTrackListEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n    [index: number]: VideoTrack;\n}\n\ndeclare var VideoTrackList: {\n    prototype: VideoTrackList;\n    new(): VideoTrackList;\n};\n\ninterface WaveShaperNode extends AudioNode {\n    curve: Float32Array | null;\n    oversample: OverSampleType;\n}\n\ndeclare var WaveShaperNode: {\n    prototype: WaveShaperNode;\n    new(): WaveShaperNode;\n};\n\ninterface WebAuthentication {\n    getAssertion(assertionChallenge: any, options?: AssertionOptions): Promise<WebAuthnAssertion>;\n    makeCredential(accountInformation: Account, cryptoParameters: ScopedCredentialParameters[], attestationChallenge: any, options?: ScopedCredentialOptions): Promise<ScopedCredentialInfo>;\n}\n\ndeclare var WebAuthentication: {\n    prototype: WebAuthentication;\n    new(): WebAuthentication;\n};\n\ninterface WebAuthnAssertion {\n    readonly authenticatorData: ArrayBuffer;\n    readonly clientData: ArrayBuffer;\n    readonly credential: ScopedCredential;\n    readonly signature: ArrayBuffer;\n}\n\ndeclare var WebAuthnAssertion: {\n    prototype: WebAuthnAssertion;\n    new(): WebAuthnAssertion;\n};\n\ninterface WEBGL_compressed_texture_s3tc {\n    readonly COMPRESSED_RGB_S3TC_DXT1_EXT: number;\n    readonly COMPRESSED_RGBA_S3TC_DXT1_EXT: number;\n    readonly COMPRESSED_RGBA_S3TC_DXT3_EXT: number;\n    readonly COMPRESSED_RGBA_S3TC_DXT5_EXT: number;\n}\n\ndeclare var WEBGL_compressed_texture_s3tc: {\n    prototype: WEBGL_compressed_texture_s3tc;\n    new(): WEBGL_compressed_texture_s3tc;\n    readonly COMPRESSED_RGB_S3TC_DXT1_EXT: number;\n    readonly COMPRESSED_RGBA_S3TC_DXT1_EXT: number;\n    readonly COMPRESSED_RGBA_S3TC_DXT3_EXT: number;\n    readonly COMPRESSED_RGBA_S3TC_DXT5_EXT: number;\n};\n\ninterface WEBGL_debug_renderer_info {\n    readonly UNMASKED_RENDERER_WEBGL: number;\n    readonly UNMASKED_VENDOR_WEBGL: number;\n}\n\ndeclare var WEBGL_debug_renderer_info: {\n    prototype: WEBGL_debug_renderer_info;\n    new(): WEBGL_debug_renderer_info;\n    readonly UNMASKED_RENDERER_WEBGL: number;\n    readonly UNMASKED_VENDOR_WEBGL: number;\n};\n\ninterface WEBGL_depth_texture {\n    readonly UNSIGNED_INT_24_8_WEBGL: number;\n}\n\ndeclare var WEBGL_depth_texture: {\n    prototype: WEBGL_depth_texture;\n    new(): WEBGL_depth_texture;\n    readonly UNSIGNED_INT_24_8_WEBGL: number;\n};\n\ninterface WebGLActiveInfo {\n    readonly name: string;\n    readonly size: number;\n    readonly type: number;\n}\n\ndeclare var WebGLActiveInfo: {\n    prototype: WebGLActiveInfo;\n    new(): WebGLActiveInfo;\n};\n\ninterface WebGLBuffer extends WebGLObject {\n}\n\ndeclare var WebGLBuffer: {\n    prototype: WebGLBuffer;\n    new(): WebGLBuffer;\n};\n\ninterface WebGLContextEvent extends Event {\n    readonly statusMessage: string;\n}\n\ndeclare var WebGLContextEvent: {\n    prototype: WebGLContextEvent;\n    new(typeArg: string, eventInitDict?: WebGLContextEventInit): WebGLContextEvent;\n};\n\ninterface WebGLFramebuffer extends WebGLObject {\n}\n\ndeclare var WebGLFramebuffer: {\n    prototype: WebGLFramebuffer;\n    new(): WebGLFramebuffer;\n};\n\ninterface WebGLObject {\n}\n\ndeclare var WebGLObject: {\n    prototype: WebGLObject;\n    new(): WebGLObject;\n};\n\ninterface WebGLProgram extends WebGLObject {\n}\n\ndeclare var WebGLProgram: {\n    prototype: WebGLProgram;\n    new(): WebGLProgram;\n};\n\ninterface WebGLRenderbuffer extends WebGLObject {\n}\n\ndeclare var WebGLRenderbuffer: {\n    prototype: WebGLRenderbuffer;\n    new(): WebGLRenderbuffer;\n};\n\ninterface WebGLRenderingContext {\n    readonly canvas: HTMLCanvasElement;\n    readonly drawingBufferHeight: number;\n    readonly drawingBufferWidth: number;\n    activeTexture(texture: number): void;\n    attachShader(program: WebGLProgram | null, shader: WebGLShader | null): void;\n    bindAttribLocation(program: WebGLProgram | null, index: number, name: string): void;\n    bindBuffer(target: number, buffer: WebGLBuffer | null): void;\n    bindFramebuffer(target: number, framebuffer: WebGLFramebuffer | null): void;\n    bindRenderbuffer(target: number, renderbuffer: WebGLRenderbuffer | null): void;\n    bindTexture(target: number, texture: WebGLTexture | null): void;\n    blendColor(red: number, green: number, blue: number, alpha: number): void;\n    blendEquation(mode: number): void;\n    blendEquationSeparate(modeRGB: number, modeAlpha: number): void;\n    blendFunc(sfactor: number, dfactor: number): void;\n    blendFuncSeparate(srcRGB: number, dstRGB: number, srcAlpha: number, dstAlpha: number): void;\n    bufferData(target: number, size: number | ArrayBufferView | ArrayBuffer, usage: number): void;\n    bufferSubData(target: number, offset: number, data: ArrayBufferView | ArrayBuffer): void;\n    checkFramebufferStatus(target: number): number;\n    clear(mask: number): void;\n    clearColor(red: number, green: number, blue: number, alpha: number): void;\n    clearDepth(depth: number): void;\n    clearStencil(s: number): void;\n    colorMask(red: boolean, green: boolean, blue: boolean, alpha: boolean): void;\n    compileShader(shader: WebGLShader | null): void;\n    compressedTexImage2D(target: number, level: number, internalformat: number, width: number, height: number, border: number, data: ArrayBufferView): void;\n    compressedTexSubImage2D(target: number, level: number, xoffset: number, yoffset: number, width: number, height: number, format: number, data: ArrayBufferView): void;\n    copyTexImage2D(target: number, level: number, internalformat: number, x: number, y: number, width: number, height: number, border: number): void;\n    copyTexSubImage2D(target: number, level: number, xoffset: number, yoffset: number, x: number, y: number, width: number, height: number): void;\n    createBuffer(): WebGLBuffer | null;\n    createFramebuffer(): WebGLFramebuffer | null;\n    createProgram(): WebGLProgram | null;\n    createRenderbuffer(): WebGLRenderbuffer | null;\n    createShader(type: number): WebGLShader | null;\n    createTexture(): WebGLTexture | null;\n    cullFace(mode: number): void;\n    deleteBuffer(buffer: WebGLBuffer | null): void;\n    deleteFramebuffer(framebuffer: WebGLFramebuffer | null): void;\n    deleteProgram(program: WebGLProgram | null): void;\n    deleteRenderbuffer(renderbuffer: WebGLRenderbuffer | null): void;\n    deleteShader(shader: WebGLShader | null): void;\n    deleteTexture(texture: WebGLTexture | null): void;\n    depthFunc(func: number): void;\n    depthMask(flag: boolean): void;\n    depthRange(zNear: number, zFar: number): void;\n    detachShader(program: WebGLProgram | null, shader: WebGLShader | null): void;\n    disable(cap: number): void;\n    disableVertexAttribArray(index: number): void;\n    drawArrays(mode: number, first: number, count: number): void;\n    drawElements(mode: number, count: number, type: number, offset: number): void;\n    enable(cap: number): void;\n    enableVertexAttribArray(index: number): void;\n    finish(): void;\n    flush(): void;\n    framebufferRenderbuffer(target: number, attachment: number, renderbuffertarget: number, renderbuffer: WebGLRenderbuffer | null): void;\n    framebufferTexture2D(target: number, attachment: number, textarget: number, texture: WebGLTexture | null, level: number): void;\n    frontFace(mode: number): void;\n    generateMipmap(target: number): void;\n    getActiveAttrib(program: WebGLProgram | null, index: number): WebGLActiveInfo | null;\n    getActiveUniform(program: WebGLProgram | null, index: number): WebGLActiveInfo | null;\n    getAttachedShaders(program: WebGLProgram | null): WebGLShader[] | null;\n    getAttribLocation(program: WebGLProgram | null, name: string): number;\n    getBufferParameter(target: number, pname: number): any;\n    getContextAttributes(): WebGLContextAttributes;\n    getError(): number;\n    getExtension(name: string): any;\n    getFramebufferAttachmentParameter(target: number, attachment: number, pname: number): any;\n    getParameter(pname: number): any;\n    getProgramInfoLog(program: WebGLProgram | null): string | null;\n    getProgramParameter(program: WebGLProgram | null, pname: number): any;\n    getRenderbufferParameter(target: number, pname: number): any;\n    getShaderInfoLog(shader: WebGLShader | null): string | null;\n    getShaderParameter(shader: WebGLShader | null, pname: number): any;\n    getShaderPrecisionFormat(shadertype: number, precisiontype: number): WebGLShaderPrecisionFormat | null;\n    getShaderSource(shader: WebGLShader | null): string | null;\n    getSupportedExtensions(): string[] | null;\n    getTexParameter(target: number, pname: number): any;\n    getUniform(program: WebGLProgram | null, location: WebGLUniformLocation | null): any;\n    getUniformLocation(program: WebGLProgram | null, name: string): WebGLUniformLocation | null;\n    getVertexAttrib(index: number, pname: number): any;\n    getVertexAttribOffset(index: number, pname: number): number;\n    hint(target: number, mode: number): void;\n    isBuffer(buffer: WebGLBuffer | null): boolean;\n    isContextLost(): boolean;\n    isEnabled(cap: number): boolean;\n    isFramebuffer(framebuffer: WebGLFramebuffer | null): boolean;\n    isProgram(program: WebGLProgram | null): boolean;\n    isRenderbuffer(renderbuffer: WebGLRenderbuffer | null): boolean;\n    isShader(shader: WebGLShader | null): boolean;\n    isTexture(texture: WebGLTexture | null): boolean;\n    lineWidth(width: number): void;\n    linkProgram(program: WebGLProgram | null): void;\n    pixelStorei(pname: number, param: number | boolean): void;\n    polygonOffset(factor: number, units: number): void;\n    readPixels(x: number, y: number, width: number, height: number, format: number, type: number, pixels: ArrayBufferView | null): void;\n    renderbufferStorage(target: number, internalformat: number, width: number, height: number): void;\n    sampleCoverage(value: number, invert: boolean): void;\n    scissor(x: number, y: number, width: number, height: number): void;\n    shaderSource(shader: WebGLShader | null, source: string): void;\n    stencilFunc(func: number, ref: number, mask: number): void;\n    stencilFuncSeparate(face: number, func: number, ref: number, mask: number): void;\n    stencilMask(mask: number): void;\n    stencilMaskSeparate(face: number, mask: number): void;\n    stencilOp(fail: number, zfail: number, zpass: number): void;\n    stencilOpSeparate(face: number, fail: number, zfail: number, zpass: number): void;\n    texImage2D(target: number, level: number, internalformat: number, width: number, height: number, border: number, format: number, type: number, pixels: ArrayBufferView | null): void;\n    texImage2D(target: number, level: number, internalformat: number, format: number, type: number, pixels: ImageBitmap | ImageData | HTMLVideoElement | HTMLImageElement | HTMLCanvasElement): void;\n    texParameterf(target: number, pname: number, param: number): void;\n    texParameteri(target: number, pname: number, param: number): void;\n    texSubImage2D(target: number, level: number, xoffset: number, yoffset: number, width: number, height: number, format: number, type: number, pixels: ArrayBufferView | null): void;\n    texSubImage2D(target: number, level: number, xoffset: number, yoffset: number, format: number, type: number, pixels: ImageBitmap | ImageData | HTMLVideoElement | HTMLImageElement | HTMLCanvasElement): void;\n    uniform1f(location: WebGLUniformLocation | null, x: number): void;\n    uniform1fv(location: WebGLUniformLocation, v: Float32Array | number[]): void;\n    uniform1i(location: WebGLUniformLocation | null, x: number): void;\n    uniform1iv(location: WebGLUniformLocation, v: Int32Array | number[]): void;\n    uniform2f(location: WebGLUniformLocation | null, x: number, y: number): void;\n    uniform2fv(location: WebGLUniformLocation, v: Float32Array | number[]): void;\n    uniform2i(location: WebGLUniformLocation | null, x: number, y: number): void;\n    uniform2iv(location: WebGLUniformLocation, v: Int32Array | number[]): void;\n    uniform3f(location: WebGLUniformLocation | null, x: number, y: number, z: number): void;\n    uniform3fv(location: WebGLUniformLocation, v: Float32Array | number[]): void;\n    uniform3i(location: WebGLUniformLocation | null, x: number, y: number, z: number): void;\n    uniform3iv(location: WebGLUniformLocation, v: Int32Array | number[]): void;\n    uniform4f(location: WebGLUniformLocation | null, x: number, y: number, z: number, w: number): void;\n    uniform4fv(location: WebGLUniformLocation, v: Float32Array | number[]): void;\n    uniform4i(location: WebGLUniformLocation | null, x: number, y: number, z: number, w: number): void;\n    uniform4iv(location: WebGLUniformLocation, v: Int32Array | number[]): void;\n    uniformMatrix2fv(location: WebGLUniformLocation, transpose: boolean, value: Float32Array | number[]): void;\n    uniformMatrix3fv(location: WebGLUniformLocation, transpose: boolean, value: Float32Array | number[]): void;\n    uniformMatrix4fv(location: WebGLUniformLocation, transpose: boolean, value: Float32Array | number[]): void;\n    useProgram(program: WebGLProgram | null): void;\n    validateProgram(program: WebGLProgram | null): void;\n    vertexAttrib1f(indx: number, x: number): void;\n    vertexAttrib1fv(indx: number, values: Float32Array | number[]): void;\n    vertexAttrib2f(indx: number, x: number, y: number): void;\n    vertexAttrib2fv(indx: number, values: Float32Array | number[]): void;\n    vertexAttrib3f(indx: number, x: number, y: number, z: number): void;\n    vertexAttrib3fv(indx: number, values: Float32Array | number[]): void;\n    vertexAttrib4f(indx: number, x: number, y: number, z: number, w: number): void;\n    vertexAttrib4fv(indx: number, values: Float32Array | number[]): void;\n    vertexAttribPointer(indx: number, size: number, type: number, normalized: boolean, stride: number, offset: number): void;\n    viewport(x: number, y: number, width: number, height: number): void;\n    readonly ACTIVE_ATTRIBUTES: number;\n    readonly ACTIVE_TEXTURE: number;\n    readonly ACTIVE_UNIFORMS: number;\n    readonly ALIASED_LINE_WIDTH_RANGE: number;\n    readonly ALIASED_POINT_SIZE_RANGE: number;\n    readonly ALPHA: number;\n    readonly ALPHA_BITS: number;\n    readonly ALWAYS: number;\n    readonly ARRAY_BUFFER: number;\n    readonly ARRAY_BUFFER_BINDING: number;\n    readonly ATTACHED_SHADERS: number;\n    readonly BACK: number;\n    readonly BLEND: number;\n    readonly BLEND_COLOR: number;\n    readonly BLEND_DST_ALPHA: number;\n    readonly BLEND_DST_RGB: number;\n    readonly BLEND_EQUATION: number;\n    readonly BLEND_EQUATION_ALPHA: number;\n    readonly BLEND_EQUATION_RGB: number;\n    readonly BLEND_SRC_ALPHA: number;\n    readonly BLEND_SRC_RGB: number;\n    readonly BLUE_BITS: number;\n    readonly BOOL: number;\n    readonly BOOL_VEC2: number;\n    readonly BOOL_VEC3: number;\n    readonly BOOL_VEC4: number;\n    readonly BROWSER_DEFAULT_WEBGL: number;\n    readonly BUFFER_SIZE: number;\n    readonly BUFFER_USAGE: number;\n    readonly BYTE: number;\n    readonly CCW: number;\n    readonly CLAMP_TO_EDGE: number;\n    readonly COLOR_ATTACHMENT0: number;\n    readonly COLOR_BUFFER_BIT: number;\n    readonly COLOR_CLEAR_VALUE: number;\n    readonly COLOR_WRITEMASK: number;\n    readonly COMPILE_STATUS: number;\n    readonly COMPRESSED_TEXTURE_FORMATS: number;\n    readonly CONSTANT_ALPHA: number;\n    readonly CONSTANT_COLOR: number;\n    readonly CONTEXT_LOST_WEBGL: number;\n    readonly CULL_FACE: number;\n    readonly CULL_FACE_MODE: number;\n    readonly CURRENT_PROGRAM: number;\n    readonly CURRENT_VERTEX_ATTRIB: number;\n    readonly CW: number;\n    readonly DECR: number;\n    readonly DECR_WRAP: number;\n    readonly DELETE_STATUS: number;\n    readonly DEPTH_ATTACHMENT: number;\n    readonly DEPTH_BITS: number;\n    readonly DEPTH_BUFFER_BIT: number;\n    readonly DEPTH_CLEAR_VALUE: number;\n    readonly DEPTH_COMPONENT: number;\n    readonly DEPTH_COMPONENT16: number;\n    readonly DEPTH_FUNC: number;\n    readonly DEPTH_RANGE: number;\n    readonly DEPTH_STENCIL: number;\n    readonly DEPTH_STENCIL_ATTACHMENT: number;\n    readonly DEPTH_TEST: number;\n    readonly DEPTH_WRITEMASK: number;\n    readonly DITHER: number;\n    readonly DONT_CARE: number;\n    readonly DST_ALPHA: number;\n    readonly DST_COLOR: number;\n    readonly DYNAMIC_DRAW: number;\n    readonly ELEMENT_ARRAY_BUFFER: number;\n    readonly ELEMENT_ARRAY_BUFFER_BINDING: number;\n    readonly EQUAL: number;\n    readonly FASTEST: number;\n    readonly FLOAT: number;\n    readonly FLOAT_MAT2: number;\n    readonly FLOAT_MAT3: number;\n    readonly FLOAT_MAT4: number;\n    readonly FLOAT_VEC2: number;\n    readonly FLOAT_VEC3: number;\n    readonly FLOAT_VEC4: number;\n    readonly FRAGMENT_SHADER: number;\n    readonly FRAMEBUFFER: number;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: number;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: number;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: number;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: number;\n    readonly FRAMEBUFFER_BINDING: number;\n    readonly FRAMEBUFFER_COMPLETE: number;\n    readonly FRAMEBUFFER_INCOMPLETE_ATTACHMENT: number;\n    readonly FRAMEBUFFER_INCOMPLETE_DIMENSIONS: number;\n    readonly FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: number;\n    readonly FRAMEBUFFER_UNSUPPORTED: number;\n    readonly FRONT: number;\n    readonly FRONT_AND_BACK: number;\n    readonly FRONT_FACE: number;\n    readonly FUNC_ADD: number;\n    readonly FUNC_REVERSE_SUBTRACT: number;\n    readonly FUNC_SUBTRACT: number;\n    readonly GENERATE_MIPMAP_HINT: number;\n    readonly GEQUAL: number;\n    readonly GREATER: number;\n    readonly GREEN_BITS: number;\n    readonly HIGH_FLOAT: number;\n    readonly HIGH_INT: number;\n    readonly IMPLEMENTATION_COLOR_READ_FORMAT: number;\n    readonly IMPLEMENTATION_COLOR_READ_TYPE: number;\n    readonly INCR: number;\n    readonly INCR_WRAP: number;\n    readonly INT: number;\n    readonly INT_VEC2: number;\n    readonly INT_VEC3: number;\n    readonly INT_VEC4: number;\n    readonly INVALID_ENUM: number;\n    readonly INVALID_FRAMEBUFFER_OPERATION: number;\n    readonly INVALID_OPERATION: number;\n    readonly INVALID_VALUE: number;\n    readonly INVERT: number;\n    readonly KEEP: number;\n    readonly LEQUAL: number;\n    readonly LESS: number;\n    readonly LINE_LOOP: number;\n    readonly LINE_STRIP: number;\n    readonly LINE_WIDTH: number;\n    readonly LINEAR: number;\n    readonly LINEAR_MIPMAP_LINEAR: number;\n    readonly LINEAR_MIPMAP_NEAREST: number;\n    readonly LINES: number;\n    readonly LINK_STATUS: number;\n    readonly LOW_FLOAT: number;\n    readonly LOW_INT: number;\n    readonly LUMINANCE: number;\n    readonly LUMINANCE_ALPHA: number;\n    readonly MAX_COMBINED_TEXTURE_IMAGE_UNITS: number;\n    readonly MAX_CUBE_MAP_TEXTURE_SIZE: number;\n    readonly MAX_FRAGMENT_UNIFORM_VECTORS: number;\n    readonly MAX_RENDERBUFFER_SIZE: number;\n    readonly MAX_TEXTURE_IMAGE_UNITS: number;\n    readonly MAX_TEXTURE_SIZE: number;\n    readonly MAX_VARYING_VECTORS: number;\n    readonly MAX_VERTEX_ATTRIBS: number;\n    readonly MAX_VERTEX_TEXTURE_IMAGE_UNITS: number;\n    readonly MAX_VERTEX_UNIFORM_VECTORS: number;\n    readonly MAX_VIEWPORT_DIMS: number;\n    readonly MEDIUM_FLOAT: number;\n    readonly MEDIUM_INT: number;\n    readonly MIRRORED_REPEAT: number;\n    readonly NEAREST: number;\n    readonly NEAREST_MIPMAP_LINEAR: number;\n    readonly NEAREST_MIPMAP_NEAREST: number;\n    readonly NEVER: number;\n    readonly NICEST: number;\n    readonly NO_ERROR: number;\n    readonly NONE: number;\n    readonly NOTEQUAL: number;\n    readonly ONE: number;\n    readonly ONE_MINUS_CONSTANT_ALPHA: number;\n    readonly ONE_MINUS_CONSTANT_COLOR: number;\n    readonly ONE_MINUS_DST_ALPHA: number;\n    readonly ONE_MINUS_DST_COLOR: number;\n    readonly ONE_MINUS_SRC_ALPHA: number;\n    readonly ONE_MINUS_SRC_COLOR: number;\n    readonly OUT_OF_MEMORY: number;\n    readonly PACK_ALIGNMENT: number;\n    readonly POINTS: number;\n    readonly POLYGON_OFFSET_FACTOR: number;\n    readonly POLYGON_OFFSET_FILL: number;\n    readonly POLYGON_OFFSET_UNITS: number;\n    readonly RED_BITS: number;\n    readonly RENDERBUFFER: number;\n    readonly RENDERBUFFER_ALPHA_SIZE: number;\n    readonly RENDERBUFFER_BINDING: number;\n    readonly RENDERBUFFER_BLUE_SIZE: number;\n    readonly RENDERBUFFER_DEPTH_SIZE: number;\n    readonly RENDERBUFFER_GREEN_SIZE: number;\n    readonly RENDERBUFFER_HEIGHT: number;\n    readonly RENDERBUFFER_INTERNAL_FORMAT: number;\n    readonly RENDERBUFFER_RED_SIZE: number;\n    readonly RENDERBUFFER_STENCIL_SIZE: number;\n    readonly RENDERBUFFER_WIDTH: number;\n    readonly RENDERER: number;\n    readonly REPEAT: number;\n    readonly REPLACE: number;\n    readonly RGB: number;\n    readonly RGB5_A1: number;\n    readonly RGB565: number;\n    readonly RGBA: number;\n    readonly RGBA4: number;\n    readonly SAMPLE_ALPHA_TO_COVERAGE: number;\n    readonly SAMPLE_BUFFERS: number;\n    readonly SAMPLE_COVERAGE: number;\n    readonly SAMPLE_COVERAGE_INVERT: number;\n    readonly SAMPLE_COVERAGE_VALUE: number;\n    readonly SAMPLER_2D: number;\n    readonly SAMPLER_CUBE: number;\n    readonly SAMPLES: number;\n    readonly SCISSOR_BOX: number;\n    readonly SCISSOR_TEST: number;\n    readonly SHADER_TYPE: number;\n    readonly SHADING_LANGUAGE_VERSION: number;\n    readonly SHORT: number;\n    readonly SRC_ALPHA: number;\n    readonly SRC_ALPHA_SATURATE: number;\n    readonly SRC_COLOR: number;\n    readonly STATIC_DRAW: number;\n    readonly STENCIL_ATTACHMENT: number;\n    readonly STENCIL_BACK_FAIL: number;\n    readonly STENCIL_BACK_FUNC: number;\n    readonly STENCIL_BACK_PASS_DEPTH_FAIL: number;\n    readonly STENCIL_BACK_PASS_DEPTH_PASS: number;\n    readonly STENCIL_BACK_REF: number;\n    readonly STENCIL_BACK_VALUE_MASK: number;\n    readonly STENCIL_BACK_WRITEMASK: number;\n    readonly STENCIL_BITS: number;\n    readonly STENCIL_BUFFER_BIT: number;\n    readonly STENCIL_CLEAR_VALUE: number;\n    readonly STENCIL_FAIL: number;\n    readonly STENCIL_FUNC: number;\n    readonly STENCIL_INDEX: number;\n    readonly STENCIL_INDEX8: number;\n    readonly STENCIL_PASS_DEPTH_FAIL: number;\n    readonly STENCIL_PASS_DEPTH_PASS: number;\n    readonly STENCIL_REF: number;\n    readonly STENCIL_TEST: number;\n    readonly STENCIL_VALUE_MASK: number;\n    readonly STENCIL_WRITEMASK: number;\n    readonly STREAM_DRAW: number;\n    readonly SUBPIXEL_BITS: number;\n    readonly TEXTURE: number;\n    readonly TEXTURE_2D: number;\n    readonly TEXTURE_BINDING_2D: number;\n    readonly TEXTURE_BINDING_CUBE_MAP: number;\n    readonly TEXTURE_CUBE_MAP: number;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_X: number;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Y: number;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Z: number;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_X: number;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Y: number;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Z: number;\n    readonly TEXTURE_MAG_FILTER: number;\n    readonly TEXTURE_MIN_FILTER: number;\n    readonly TEXTURE_WRAP_S: number;\n    readonly TEXTURE_WRAP_T: number;\n    readonly TEXTURE0: number;\n    readonly TEXTURE1: number;\n    readonly TEXTURE10: number;\n    readonly TEXTURE11: number;\n    readonly TEXTURE12: number;\n    readonly TEXTURE13: number;\n    readonly TEXTURE14: number;\n    readonly TEXTURE15: number;\n    readonly TEXTURE16: number;\n    readonly TEXTURE17: number;\n    readonly TEXTURE18: number;\n    readonly TEXTURE19: number;\n    readonly TEXTURE2: number;\n    readonly TEXTURE20: number;\n    readonly TEXTURE21: number;\n    readonly TEXTURE22: number;\n    readonly TEXTURE23: number;\n    readonly TEXTURE24: number;\n    readonly TEXTURE25: number;\n    readonly TEXTURE26: number;\n    readonly TEXTURE27: number;\n    readonly TEXTURE28: number;\n    readonly TEXTURE29: number;\n    readonly TEXTURE3: number;\n    readonly TEXTURE30: number;\n    readonly TEXTURE31: number;\n    readonly TEXTURE4: number;\n    readonly TEXTURE5: number;\n    readonly TEXTURE6: number;\n    readonly TEXTURE7: number;\n    readonly TEXTURE8: number;\n    readonly TEXTURE9: number;\n    readonly TRIANGLE_FAN: number;\n    readonly TRIANGLE_STRIP: number;\n    readonly TRIANGLES: number;\n    readonly UNPACK_ALIGNMENT: number;\n    readonly UNPACK_COLORSPACE_CONVERSION_WEBGL: number;\n    readonly UNPACK_FLIP_Y_WEBGL: number;\n    readonly UNPACK_PREMULTIPLY_ALPHA_WEBGL: number;\n    readonly UNSIGNED_BYTE: number;\n    readonly UNSIGNED_INT: number;\n    readonly UNSIGNED_SHORT: number;\n    readonly UNSIGNED_SHORT_4_4_4_4: number;\n    readonly UNSIGNED_SHORT_5_5_5_1: number;\n    readonly UNSIGNED_SHORT_5_6_5: number;\n    readonly VALIDATE_STATUS: number;\n    readonly VENDOR: number;\n    readonly VERSION: number;\n    readonly VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: number;\n    readonly VERTEX_ATTRIB_ARRAY_ENABLED: number;\n    readonly VERTEX_ATTRIB_ARRAY_NORMALIZED: number;\n    readonly VERTEX_ATTRIB_ARRAY_POINTER: number;\n    readonly VERTEX_ATTRIB_ARRAY_SIZE: number;\n    readonly VERTEX_ATTRIB_ARRAY_STRIDE: number;\n    readonly VERTEX_ATTRIB_ARRAY_TYPE: number;\n    readonly VERTEX_SHADER: number;\n    readonly VIEWPORT: number;\n    readonly ZERO: number;\n}\n\ndeclare var WebGLRenderingContext: {\n    prototype: WebGLRenderingContext;\n    new(): WebGLRenderingContext;\n    readonly ACTIVE_ATTRIBUTES: number;\n    readonly ACTIVE_TEXTURE: number;\n    readonly ACTIVE_UNIFORMS: number;\n    readonly ALIASED_LINE_WIDTH_RANGE: number;\n    readonly ALIASED_POINT_SIZE_RANGE: number;\n    readonly ALPHA: number;\n    readonly ALPHA_BITS: number;\n    readonly ALWAYS: number;\n    readonly ARRAY_BUFFER: number;\n    readonly ARRAY_BUFFER_BINDING: number;\n    readonly ATTACHED_SHADERS: number;\n    readonly BACK: number;\n    readonly BLEND: number;\n    readonly BLEND_COLOR: number;\n    readonly BLEND_DST_ALPHA: number;\n    readonly BLEND_DST_RGB: number;\n    readonly BLEND_EQUATION: number;\n    readonly BLEND_EQUATION_ALPHA: number;\n    readonly BLEND_EQUATION_RGB: number;\n    readonly BLEND_SRC_ALPHA: number;\n    readonly BLEND_SRC_RGB: number;\n    readonly BLUE_BITS: number;\n    readonly BOOL: number;\n    readonly BOOL_VEC2: number;\n    readonly BOOL_VEC3: number;\n    readonly BOOL_VEC4: number;\n    readonly BROWSER_DEFAULT_WEBGL: number;\n    readonly BUFFER_SIZE: number;\n    readonly BUFFER_USAGE: number;\n    readonly BYTE: number;\n    readonly CCW: number;\n    readonly CLAMP_TO_EDGE: number;\n    readonly COLOR_ATTACHMENT0: number;\n    readonly COLOR_BUFFER_BIT: number;\n    readonly COLOR_CLEAR_VALUE: number;\n    readonly COLOR_WRITEMASK: number;\n    readonly COMPILE_STATUS: number;\n    readonly COMPRESSED_TEXTURE_FORMATS: number;\n    readonly CONSTANT_ALPHA: number;\n    readonly CONSTANT_COLOR: number;\n    readonly CONTEXT_LOST_WEBGL: number;\n    readonly CULL_FACE: number;\n    readonly CULL_FACE_MODE: number;\n    readonly CURRENT_PROGRAM: number;\n    readonly CURRENT_VERTEX_ATTRIB: number;\n    readonly CW: number;\n    readonly DECR: number;\n    readonly DECR_WRAP: number;\n    readonly DELETE_STATUS: number;\n    readonly DEPTH_ATTACHMENT: number;\n    readonly DEPTH_BITS: number;\n    readonly DEPTH_BUFFER_BIT: number;\n    readonly DEPTH_CLEAR_VALUE: number;\n    readonly DEPTH_COMPONENT: number;\n    readonly DEPTH_COMPONENT16: number;\n    readonly DEPTH_FUNC: number;\n    readonly DEPTH_RANGE: number;\n    readonly DEPTH_STENCIL: number;\n    readonly DEPTH_STENCIL_ATTACHMENT: number;\n    readonly DEPTH_TEST: number;\n    readonly DEPTH_WRITEMASK: number;\n    readonly DITHER: number;\n    readonly DONT_CARE: number;\n    readonly DST_ALPHA: number;\n    readonly DST_COLOR: number;\n    readonly DYNAMIC_DRAW: number;\n    readonly ELEMENT_ARRAY_BUFFER: number;\n    readonly ELEMENT_ARRAY_BUFFER_BINDING: number;\n    readonly EQUAL: number;\n    readonly FASTEST: number;\n    readonly FLOAT: number;\n    readonly FLOAT_MAT2: number;\n    readonly FLOAT_MAT3: number;\n    readonly FLOAT_MAT4: number;\n    readonly FLOAT_VEC2: number;\n    readonly FLOAT_VEC3: number;\n    readonly FLOAT_VEC4: number;\n    readonly FRAGMENT_SHADER: number;\n    readonly FRAMEBUFFER: number;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: number;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: number;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: number;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: number;\n    readonly FRAMEBUFFER_BINDING: number;\n    readonly FRAMEBUFFER_COMPLETE: number;\n    readonly FRAMEBUFFER_INCOMPLETE_ATTACHMENT: number;\n    readonly FRAMEBUFFER_INCOMPLETE_DIMENSIONS: number;\n    readonly FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: number;\n    readonly FRAMEBUFFER_UNSUPPORTED: number;\n    readonly FRONT: number;\n    readonly FRONT_AND_BACK: number;\n    readonly FRONT_FACE: number;\n    readonly FUNC_ADD: number;\n    readonly FUNC_REVERSE_SUBTRACT: number;\n    readonly FUNC_SUBTRACT: number;\n    readonly GENERATE_MIPMAP_HINT: number;\n    readonly GEQUAL: number;\n    readonly GREATER: number;\n    readonly GREEN_BITS: number;\n    readonly HIGH_FLOAT: number;\n    readonly HIGH_INT: number;\n    readonly IMPLEMENTATION_COLOR_READ_FORMAT: number;\n    readonly IMPLEMENTATION_COLOR_READ_TYPE: number;\n    readonly INCR: number;\n    readonly INCR_WRAP: number;\n    readonly INT: number;\n    readonly INT_VEC2: number;\n    readonly INT_VEC3: number;\n    readonly INT_VEC4: number;\n    readonly INVALID_ENUM: number;\n    readonly INVALID_FRAMEBUFFER_OPERATION: number;\n    readonly INVALID_OPERATION: number;\n    readonly INVALID_VALUE: number;\n    readonly INVERT: number;\n    readonly KEEP: number;\n    readonly LEQUAL: number;\n    readonly LESS: number;\n    readonly LINE_LOOP: number;\n    readonly LINE_STRIP: number;\n    readonly LINE_WIDTH: number;\n    readonly LINEAR: number;\n    readonly LINEAR_MIPMAP_LINEAR: number;\n    readonly LINEAR_MIPMAP_NEAREST: number;\n    readonly LINES: number;\n    readonly LINK_STATUS: number;\n    readonly LOW_FLOAT: number;\n    readonly LOW_INT: number;\n    readonly LUMINANCE: number;\n    readonly LUMINANCE_ALPHA: number;\n    readonly MAX_COMBINED_TEXTURE_IMAGE_UNITS: number;\n    readonly MAX_CUBE_MAP_TEXTURE_SIZE: number;\n    readonly MAX_FRAGMENT_UNIFORM_VECTORS: number;\n    readonly MAX_RENDERBUFFER_SIZE: number;\n    readonly MAX_TEXTURE_IMAGE_UNITS: number;\n    readonly MAX_TEXTURE_SIZE: number;\n    readonly MAX_VARYING_VECTORS: number;\n    readonly MAX_VERTEX_ATTRIBS: number;\n    readonly MAX_VERTEX_TEXTURE_IMAGE_UNITS: number;\n    readonly MAX_VERTEX_UNIFORM_VECTORS: number;\n    readonly MAX_VIEWPORT_DIMS: number;\n    readonly MEDIUM_FLOAT: number;\n    readonly MEDIUM_INT: number;\n    readonly MIRRORED_REPEAT: number;\n    readonly NEAREST: number;\n    readonly NEAREST_MIPMAP_LINEAR: number;\n    readonly NEAREST_MIPMAP_NEAREST: number;\n    readonly NEVER: number;\n    readonly NICEST: number;\n    readonly NO_ERROR: number;\n    readonly NONE: number;\n    readonly NOTEQUAL: number;\n    readonly ONE: number;\n    readonly ONE_MINUS_CONSTANT_ALPHA: number;\n    readonly ONE_MINUS_CONSTANT_COLOR: number;\n    readonly ONE_MINUS_DST_ALPHA: number;\n    readonly ONE_MINUS_DST_COLOR: number;\n    readonly ONE_MINUS_SRC_ALPHA: number;\n    readonly ONE_MINUS_SRC_COLOR: number;\n    readonly OUT_OF_MEMORY: number;\n    readonly PACK_ALIGNMENT: number;\n    readonly POINTS: number;\n    readonly POLYGON_OFFSET_FACTOR: number;\n    readonly POLYGON_OFFSET_FILL: number;\n    readonly POLYGON_OFFSET_UNITS: number;\n    readonly RED_BITS: number;\n    readonly RENDERBUFFER: number;\n    readonly RENDERBUFFER_ALPHA_SIZE: number;\n    readonly RENDERBUFFER_BINDING: number;\n    readonly RENDERBUFFER_BLUE_SIZE: number;\n    readonly RENDERBUFFER_DEPTH_SIZE: number;\n    readonly RENDERBUFFER_GREEN_SIZE: number;\n    readonly RENDERBUFFER_HEIGHT: number;\n    readonly RENDERBUFFER_INTERNAL_FORMAT: number;\n    readonly RENDERBUFFER_RED_SIZE: number;\n    readonly RENDERBUFFER_STENCIL_SIZE: number;\n    readonly RENDERBUFFER_WIDTH: number;\n    readonly RENDERER: number;\n    readonly REPEAT: number;\n    readonly REPLACE: number;\n    readonly RGB: number;\n    readonly RGB5_A1: number;\n    readonly RGB565: number;\n    readonly RGBA: number;\n    readonly RGBA4: number;\n    readonly SAMPLE_ALPHA_TO_COVERAGE: number;\n    readonly SAMPLE_BUFFERS: number;\n    readonly SAMPLE_COVERAGE: number;\n    readonly SAMPLE_COVERAGE_INVERT: number;\n    readonly SAMPLE_COVERAGE_VALUE: number;\n    readonly SAMPLER_2D: number;\n    readonly SAMPLER_CUBE: number;\n    readonly SAMPLES: number;\n    readonly SCISSOR_BOX: number;\n    readonly SCISSOR_TEST: number;\n    readonly SHADER_TYPE: number;\n    readonly SHADING_LANGUAGE_VERSION: number;\n    readonly SHORT: number;\n    readonly SRC_ALPHA: number;\n    readonly SRC_ALPHA_SATURATE: number;\n    readonly SRC_COLOR: number;\n    readonly STATIC_DRAW: number;\n    readonly STENCIL_ATTACHMENT: number;\n    readonly STENCIL_BACK_FAIL: number;\n    readonly STENCIL_BACK_FUNC: number;\n    readonly STENCIL_BACK_PASS_DEPTH_FAIL: number;\n    readonly STENCIL_BACK_PASS_DEPTH_PASS: number;\n    readonly STENCIL_BACK_REF: number;\n    readonly STENCIL_BACK_VALUE_MASK: number;\n    readonly STENCIL_BACK_WRITEMASK: number;\n    readonly STENCIL_BITS: number;\n    readonly STENCIL_BUFFER_BIT: number;\n    readonly STENCIL_CLEAR_VALUE: number;\n    readonly STENCIL_FAIL: number;\n    readonly STENCIL_FUNC: number;\n    readonly STENCIL_INDEX: number;\n    readonly STENCIL_INDEX8: number;\n    readonly STENCIL_PASS_DEPTH_FAIL: number;\n    readonly STENCIL_PASS_DEPTH_PASS: number;\n    readonly STENCIL_REF: number;\n    readonly STENCIL_TEST: number;\n    readonly STENCIL_VALUE_MASK: number;\n    readonly STENCIL_WRITEMASK: number;\n    readonly STREAM_DRAW: number;\n    readonly SUBPIXEL_BITS: number;\n    readonly TEXTURE: number;\n    readonly TEXTURE_2D: number;\n    readonly TEXTURE_BINDING_2D: number;\n    readonly TEXTURE_BINDING_CUBE_MAP: number;\n    readonly TEXTURE_CUBE_MAP: number;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_X: number;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Y: number;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Z: number;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_X: number;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Y: number;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Z: number;\n    readonly TEXTURE_MAG_FILTER: number;\n    readonly TEXTURE_MIN_FILTER: number;\n    readonly TEXTURE_WRAP_S: number;\n    readonly TEXTURE_WRAP_T: number;\n    readonly TEXTURE0: number;\n    readonly TEXTURE1: number;\n    readonly TEXTURE10: number;\n    readonly TEXTURE11: number;\n    readonly TEXTURE12: number;\n    readonly TEXTURE13: number;\n    readonly TEXTURE14: number;\n    readonly TEXTURE15: number;\n    readonly TEXTURE16: number;\n    readonly TEXTURE17: number;\n    readonly TEXTURE18: number;\n    readonly TEXTURE19: number;\n    readonly TEXTURE2: number;\n    readonly TEXTURE20: number;\n    readonly TEXTURE21: number;\n    readonly TEXTURE22: number;\n    readonly TEXTURE23: number;\n    readonly TEXTURE24: number;\n    readonly TEXTURE25: number;\n    readonly TEXTURE26: number;\n    readonly TEXTURE27: number;\n    readonly TEXTURE28: number;\n    readonly TEXTURE29: number;\n    readonly TEXTURE3: number;\n    readonly TEXTURE30: number;\n    readonly TEXTURE31: number;\n    readonly TEXTURE4: number;\n    readonly TEXTURE5: number;\n    readonly TEXTURE6: number;\n    readonly TEXTURE7: number;\n    readonly TEXTURE8: number;\n    readonly TEXTURE9: number;\n    readonly TRIANGLE_FAN: number;\n    readonly TRIANGLE_STRIP: number;\n    readonly TRIANGLES: number;\n    readonly UNPACK_ALIGNMENT: number;\n    readonly UNPACK_COLORSPACE_CONVERSION_WEBGL: number;\n    readonly UNPACK_FLIP_Y_WEBGL: number;\n    readonly UNPACK_PREMULTIPLY_ALPHA_WEBGL: number;\n    readonly UNSIGNED_BYTE: number;\n    readonly UNSIGNED_INT: number;\n    readonly UNSIGNED_SHORT: number;\n    readonly UNSIGNED_SHORT_4_4_4_4: number;\n    readonly UNSIGNED_SHORT_5_5_5_1: number;\n    readonly UNSIGNED_SHORT_5_6_5: number;\n    readonly VALIDATE_STATUS: number;\n    readonly VENDOR: number;\n    readonly VERSION: number;\n    readonly VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: number;\n    readonly VERTEX_ATTRIB_ARRAY_ENABLED: number;\n    readonly VERTEX_ATTRIB_ARRAY_NORMALIZED: number;\n    readonly VERTEX_ATTRIB_ARRAY_POINTER: number;\n    readonly VERTEX_ATTRIB_ARRAY_SIZE: number;\n    readonly VERTEX_ATTRIB_ARRAY_STRIDE: number;\n    readonly VERTEX_ATTRIB_ARRAY_TYPE: number;\n    readonly VERTEX_SHADER: number;\n    readonly VIEWPORT: number;\n    readonly ZERO: number;\n};\n\ninterface WebGLShader extends WebGLObject {\n}\n\ndeclare var WebGLShader: {\n    prototype: WebGLShader;\n    new(): WebGLShader;\n};\n\ninterface WebGLShaderPrecisionFormat {\n    readonly precision: number;\n    readonly rangeMax: number;\n    readonly rangeMin: number;\n}\n\ndeclare var WebGLShaderPrecisionFormat: {\n    prototype: WebGLShaderPrecisionFormat;\n    new(): WebGLShaderPrecisionFormat;\n};\n\ninterface WebGLTexture extends WebGLObject {\n}\n\ndeclare var WebGLTexture: {\n    prototype: WebGLTexture;\n    new(): WebGLTexture;\n};\n\ninterface WebGLUniformLocation {\n}\n\ndeclare var WebGLUniformLocation: {\n    prototype: WebGLUniformLocation;\n    new(): WebGLUniformLocation;\n};\n\ninterface WebKitCSSMatrix {\n    a: number;\n    b: number;\n    c: number;\n    d: number;\n    e: number;\n    f: number;\n    m11: number;\n    m12: number;\n    m13: number;\n    m14: number;\n    m21: number;\n    m22: number;\n    m23: number;\n    m24: number;\n    m31: number;\n    m32: number;\n    m33: number;\n    m34: number;\n    m41: number;\n    m42: number;\n    m43: number;\n    m44: number;\n    inverse(): WebKitCSSMatrix;\n    multiply(secondMatrix: WebKitCSSMatrix): WebKitCSSMatrix;\n    rotate(angleX: number, angleY?: number, angleZ?: number): WebKitCSSMatrix;\n    rotateAxisAngle(x: number, y: number, z: number, angle: number): WebKitCSSMatrix;\n    scale(scaleX: number, scaleY?: number, scaleZ?: number): WebKitCSSMatrix;\n    setMatrixValue(value: string): void;\n    skewX(angle: number): WebKitCSSMatrix;\n    skewY(angle: number): WebKitCSSMatrix;\n    toString(): string;\n    translate(x: number, y: number, z?: number): WebKitCSSMatrix;\n}\n\ndeclare var WebKitCSSMatrix: {\n    prototype: WebKitCSSMatrix;\n    new(text?: string): WebKitCSSMatrix;\n};\n\ninterface WebKitDirectoryEntry extends WebKitEntry {\n    createReader(): WebKitDirectoryReader;\n}\n\ndeclare var WebKitDirectoryEntry: {\n    prototype: WebKitDirectoryEntry;\n    new(): WebKitDirectoryEntry;\n};\n\ninterface WebKitDirectoryReader {\n    readEntries(successCallback: WebKitEntriesCallback, errorCallback?: WebKitErrorCallback): void;\n}\n\ndeclare var WebKitDirectoryReader: {\n    prototype: WebKitDirectoryReader;\n    new(): WebKitDirectoryReader;\n};\n\ninterface WebKitEntry {\n    readonly filesystem: WebKitFileSystem;\n    readonly fullPath: string;\n    readonly isDirectory: boolean;\n    readonly isFile: boolean;\n    readonly name: string;\n}\n\ndeclare var WebKitEntry: {\n    prototype: WebKitEntry;\n    new(): WebKitEntry;\n};\n\ninterface WebKitFileEntry extends WebKitEntry {\n    file(successCallback: WebKitFileCallback, errorCallback?: WebKitErrorCallback): void;\n}\n\ndeclare var WebKitFileEntry: {\n    prototype: WebKitFileEntry;\n    new(): WebKitFileEntry;\n};\n\ninterface WebKitFileSystem {\n    readonly name: string;\n    readonly root: WebKitDirectoryEntry;\n}\n\ndeclare var WebKitFileSystem: {\n    prototype: WebKitFileSystem;\n    new(): WebKitFileSystem;\n};\n\ninterface WebKitPoint {\n    x: number;\n    y: number;\n}\n\ndeclare var WebKitPoint: {\n    prototype: WebKitPoint;\n    new(x?: number, y?: number): WebKitPoint;\n};\n\ninterface webkitRTCPeerConnection extends RTCPeerConnection {\n    addEventListener<K extends keyof RTCPeerConnectionEventMap>(type: K, listener: (this: webkitRTCPeerConnection, ev: RTCPeerConnectionEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var webkitRTCPeerConnection: {\n    prototype: webkitRTCPeerConnection;\n    new(configuration: RTCConfiguration): webkitRTCPeerConnection;\n};\n\ninterface WebSocketEventMap {\n    \"close\": CloseEvent;\n    \"error\": Event;\n    \"message\": MessageEvent;\n    \"open\": Event;\n}\n\ninterface WebSocket extends EventTarget {\n    binaryType: string;\n    readonly bufferedAmount: number;\n    readonly extensions: string;\n    onclose: (this: WebSocket, ev: CloseEvent) => any;\n    onerror: (this: WebSocket, ev: Event) => any;\n    onmessage: (this: WebSocket, ev: MessageEvent) => any;\n    onopen: (this: WebSocket, ev: Event) => any;\n    readonly protocol: string;\n    readonly readyState: number;\n    readonly url: string;\n    close(code?: number, reason?: string): void;\n    send(data: any): void;\n    readonly CLOSED: number;\n    readonly CLOSING: number;\n    readonly CONNECTING: number;\n    readonly OPEN: number;\n    addEventListener<K extends keyof WebSocketEventMap>(type: K, listener: (this: WebSocket, ev: WebSocketEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var WebSocket: {\n    prototype: WebSocket;\n    new(url: string, protocols?: string | string[]): WebSocket;\n    readonly CLOSED: number;\n    readonly CLOSING: number;\n    readonly CONNECTING: number;\n    readonly OPEN: number;\n};\n\ninterface WheelEvent extends MouseEvent {\n    readonly deltaMode: number;\n    readonly deltaX: number;\n    readonly deltaY: number;\n    readonly deltaZ: number;\n    readonly wheelDelta: number;\n    readonly wheelDeltaX: number;\n    readonly wheelDeltaY: number;\n    getCurrentPoint(element: Element): void;\n    initWheelEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number, screenXArg: number, screenYArg: number, clientXArg: number, clientYArg: number, buttonArg: number, relatedTargetArg: EventTarget, modifiersListArg: string, deltaXArg: number, deltaYArg: number, deltaZArg: number, deltaMode: number): void;\n    readonly DOM_DELTA_LINE: number;\n    readonly DOM_DELTA_PAGE: number;\n    readonly DOM_DELTA_PIXEL: number;\n}\n\ndeclare var WheelEvent: {\n    prototype: WheelEvent;\n    new(typeArg: string, eventInitDict?: WheelEventInit): WheelEvent;\n    readonly DOM_DELTA_LINE: number;\n    readonly DOM_DELTA_PAGE: number;\n    readonly DOM_DELTA_PIXEL: number;\n};\n\ninterface WindowEventMap extends GlobalEventHandlersEventMap {\n    \"abort\": UIEvent;\n    \"afterprint\": Event;\n    \"beforeprint\": Event;\n    \"beforeunload\": BeforeUnloadEvent;\n    \"blur\": FocusEvent;\n    \"canplay\": Event;\n    \"canplaythrough\": Event;\n    \"change\": Event;\n    \"click\": MouseEvent;\n    \"compassneedscalibration\": Event;\n    \"contextmenu\": PointerEvent;\n    \"dblclick\": MouseEvent;\n    \"devicelight\": DeviceLightEvent;\n    \"devicemotion\": DeviceMotionEvent;\n    \"deviceorientation\": DeviceOrientationEvent;\n    \"drag\": DragEvent;\n    \"dragend\": DragEvent;\n    \"dragenter\": DragEvent;\n    \"dragleave\": DragEvent;\n    \"dragover\": DragEvent;\n    \"dragstart\": DragEvent;\n    \"drop\": DragEvent;\n    \"durationchange\": Event;\n    \"emptied\": Event;\n    \"ended\": MediaStreamErrorEvent;\n    \"error\": ErrorEvent;\n    \"focus\": FocusEvent;\n    \"hashchange\": HashChangeEvent;\n    \"input\": Event;\n    \"invalid\": Event;\n    \"keydown\": KeyboardEvent;\n    \"keypress\": KeyboardEvent;\n    \"keyup\": KeyboardEvent;\n    \"load\": Event;\n    \"loadeddata\": Event;\n    \"loadedmetadata\": Event;\n    \"loadstart\": Event;\n    \"message\": MessageEvent;\n    \"mousedown\": MouseEvent;\n    \"mouseenter\": MouseEvent;\n    \"mouseleave\": MouseEvent;\n    \"mousemove\": MouseEvent;\n    \"mouseout\": MouseEvent;\n    \"mouseover\": MouseEvent;\n    \"mouseup\": MouseEvent;\n    \"mousewheel\": WheelEvent;\n    \"MSGestureChange\": MSGestureEvent;\n    \"MSGestureDoubleTap\": MSGestureEvent;\n    \"MSGestureEnd\": MSGestureEvent;\n    \"MSGestureHold\": MSGestureEvent;\n    \"MSGestureStart\": MSGestureEvent;\n    \"MSGestureTap\": MSGestureEvent;\n    \"MSInertiaStart\": MSGestureEvent;\n    \"MSPointerCancel\": MSPointerEvent;\n    \"MSPointerDown\": MSPointerEvent;\n    \"MSPointerEnter\": MSPointerEvent;\n    \"MSPointerLeave\": MSPointerEvent;\n    \"MSPointerMove\": MSPointerEvent;\n    \"MSPointerOut\": MSPointerEvent;\n    \"MSPointerOver\": MSPointerEvent;\n    \"MSPointerUp\": MSPointerEvent;\n    \"offline\": Event;\n    \"online\": Event;\n    \"orientationchange\": Event;\n    \"pagehide\": PageTransitionEvent;\n    \"pageshow\": PageTransitionEvent;\n    \"pause\": Event;\n    \"play\": Event;\n    \"playing\": Event;\n    \"popstate\": PopStateEvent;\n    \"progress\": ProgressEvent;\n    \"ratechange\": Event;\n    \"readystatechange\": ProgressEvent;\n    \"reset\": Event;\n    \"resize\": UIEvent;\n    \"scroll\": UIEvent;\n    \"seeked\": Event;\n    \"seeking\": Event;\n    \"select\": UIEvent;\n    \"stalled\": Event;\n    \"storage\": StorageEvent;\n    \"submit\": Event;\n    \"suspend\": Event;\n    \"timeupdate\": Event;\n    \"touchcancel\": TouchEvent;\n    \"touchend\": TouchEvent;\n    \"touchmove\": TouchEvent;\n    \"touchstart\": TouchEvent;\n    \"unload\": Event;\n    \"volumechange\": Event;\n    \"waiting\": Event;\n}\n\ninterface Window extends EventTarget, WindowTimers, WindowSessionStorage, WindowLocalStorage, WindowConsole, GlobalEventHandlers, IDBEnvironment, WindowBase64, GlobalFetch {\n    readonly applicationCache: ApplicationCache;\n    readonly caches: CacheStorage;\n    readonly clientInformation: Navigator;\n    readonly closed: boolean;\n    readonly crypto: Crypto;\n    defaultStatus: string;\n    readonly devicePixelRatio: number;\n    readonly document: Document;\n    readonly doNotTrack: string;\n    event: Event | undefined;\n    readonly external: External;\n    readonly frameElement: Element;\n    readonly frames: Window;\n    readonly history: History;\n    readonly innerHeight: number;\n    readonly innerWidth: number;\n    readonly isSecureContext: boolean;\n    readonly length: number;\n    readonly location: Location;\n    readonly locationbar: BarProp;\n    readonly menubar: BarProp;\n    readonly msContentScript: ExtensionScriptApis;\n    readonly msCredentials: MSCredentials;\n    name: string;\n    readonly navigator: Navigator;\n    offscreenBuffering: string | boolean;\n    onabort: (this: Window, ev: UIEvent) => any;\n    onafterprint: (this: Window, ev: Event) => any;\n    onbeforeprint: (this: Window, ev: Event) => any;\n    onbeforeunload: (this: Window, ev: BeforeUnloadEvent) => any;\n    onblur: (this: Window, ev: FocusEvent) => any;\n    oncanplay: (this: Window, ev: Event) => any;\n    oncanplaythrough: (this: Window, ev: Event) => any;\n    onchange: (this: Window, ev: Event) => any;\n    onclick: (this: Window, ev: MouseEvent) => any;\n    oncompassneedscalibration: (this: Window, ev: Event) => any;\n    oncontextmenu: (this: Window, ev: PointerEvent) => any;\n    ondblclick: (this: Window, ev: MouseEvent) => any;\n    ondevicelight: (this: Window, ev: DeviceLightEvent) => any;\n    ondevicemotion: (this: Window, ev: DeviceMotionEvent) => any;\n    ondeviceorientation: (this: Window, ev: DeviceOrientationEvent) => any;\n    ondrag: (this: Window, ev: DragEvent) => any;\n    ondragend: (this: Window, ev: DragEvent) => any;\n    ondragenter: (this: Window, ev: DragEvent) => any;\n    ondragleave: (this: Window, ev: DragEvent) => any;\n    ondragover: (this: Window, ev: DragEvent) => any;\n    ondragstart: (this: Window, ev: DragEvent) => any;\n    ondrop: (this: Window, ev: DragEvent) => any;\n    ondurationchange: (this: Window, ev: Event) => any;\n    onemptied: (this: Window, ev: Event) => any;\n    onended: (this: Window, ev: MediaStreamErrorEvent) => any;\n    onerror: ErrorEventHandler;\n    onfocus: (this: Window, ev: FocusEvent) => any;\n    onhashchange: (this: Window, ev: HashChangeEvent) => any;\n    oninput: (this: Window, ev: Event) => any;\n    oninvalid: (this: Window, ev: Event) => any;\n    onkeydown: (this: Window, ev: KeyboardEvent) => any;\n    onkeypress: (this: Window, ev: KeyboardEvent) => any;\n    onkeyup: (this: Window, ev: KeyboardEvent) => any;\n    onload: (this: Window, ev: Event) => any;\n    onloadeddata: (this: Window, ev: Event) => any;\n    onloadedmetadata: (this: Window, ev: Event) => any;\n    onloadstart: (this: Window, ev: Event) => any;\n    onmessage: (this: Window, ev: MessageEvent) => any;\n    onmousedown: (this: Window, ev: MouseEvent) => any;\n    onmouseenter: (this: Window, ev: MouseEvent) => any;\n    onmouseleave: (this: Window, ev: MouseEvent) => any;\n    onmousemove: (this: Window, ev: MouseEvent) => any;\n    onmouseout: (this: Window, ev: MouseEvent) => any;\n    onmouseover: (this: Window, ev: MouseEvent) => any;\n    onmouseup: (this: Window, ev: MouseEvent) => any;\n    onmousewheel: (this: Window, ev: WheelEvent) => any;\n    onmsgesturechange: (this: Window, ev: MSGestureEvent) => any;\n    onmsgesturedoubletap: (this: Window, ev: MSGestureEvent) => any;\n    onmsgestureend: (this: Window, ev: MSGestureEvent) => any;\n    onmsgesturehold: (this: Window, ev: MSGestureEvent) => any;\n    onmsgesturestart: (this: Window, ev: MSGestureEvent) => any;\n    onmsgesturetap: (this: Window, ev: MSGestureEvent) => any;\n    onmsinertiastart: (this: Window, ev: MSGestureEvent) => any;\n    onmspointercancel: (this: Window, ev: MSPointerEvent) => any;\n    onmspointerdown: (this: Window, ev: MSPointerEvent) => any;\n    onmspointerenter: (this: Window, ev: MSPointerEvent) => any;\n    onmspointerleave: (this: Window, ev: MSPointerEvent) => any;\n    onmspointermove: (this: Window, ev: MSPointerEvent) => any;\n    onmspointerout: (this: Window, ev: MSPointerEvent) => any;\n    onmspointerover: (this: Window, ev: MSPointerEvent) => any;\n    onmspointerup: (this: Window, ev: MSPointerEvent) => any;\n    onoffline: (this: Window, ev: Event) => any;\n    ononline: (this: Window, ev: Event) => any;\n    onorientationchange: (this: Window, ev: Event) => any;\n    onpagehide: (this: Window, ev: PageTransitionEvent) => any;\n    onpageshow: (this: Window, ev: PageTransitionEvent) => any;\n    onpause: (this: Window, ev: Event) => any;\n    onplay: (this: Window, ev: Event) => any;\n    onplaying: (this: Window, ev: Event) => any;\n    onpopstate: (this: Window, ev: PopStateEvent) => any;\n    onprogress: (this: Window, ev: ProgressEvent) => any;\n    onratechange: (this: Window, ev: Event) => any;\n    onreadystatechange: (this: Window, ev: ProgressEvent) => any;\n    onreset: (this: Window, ev: Event) => any;\n    onresize: (this: Window, ev: UIEvent) => any;\n    onscroll: (this: Window, ev: UIEvent) => any;\n    onseeked: (this: Window, ev: Event) => any;\n    onseeking: (this: Window, ev: Event) => any;\n    onselect: (this: Window, ev: UIEvent) => any;\n    onstalled: (this: Window, ev: Event) => any;\n    onstorage: (this: Window, ev: StorageEvent) => any;\n    onsubmit: (this: Window, ev: Event) => any;\n    onsuspend: (this: Window, ev: Event) => any;\n    ontimeupdate: (this: Window, ev: Event) => any;\n    ontouchcancel: (ev: TouchEvent) => any;\n    ontouchend: (ev: TouchEvent) => any;\n    ontouchmove: (ev: TouchEvent) => any;\n    ontouchstart: (ev: TouchEvent) => any;\n    onunload: (this: Window, ev: Event) => any;\n    onvolumechange: (this: Window, ev: Event) => any;\n    onwaiting: (this: Window, ev: Event) => any;\n    opener: any;\n    orientation: string | number;\n    readonly outerHeight: number;\n    readonly outerWidth: number;\n    readonly pageXOffset: number;\n    readonly pageYOffset: number;\n    readonly parent: Window;\n    readonly performance: Performance;\n    readonly personalbar: BarProp;\n    readonly screen: Screen;\n    readonly screenLeft: number;\n    readonly screenTop: number;\n    readonly screenX: number;\n    readonly screenY: number;\n    readonly scrollbars: BarProp;\n    readonly scrollX: number;\n    readonly scrollY: number;\n    readonly self: Window;\n    readonly speechSynthesis: SpeechSynthesis;\n    status: string;\n    readonly statusbar: BarProp;\n    readonly styleMedia: StyleMedia;\n    readonly toolbar: BarProp;\n    readonly top: Window;\n    readonly window: Window;\n    URL: typeof URL;\n    URLSearchParams: typeof URLSearchParams;\n    Blob: typeof Blob;\n    customElements: CustomElementRegistry;\n    alert(message?: any): void;\n    blur(): void;\n    cancelAnimationFrame(handle: number): void;\n    captureEvents(): void;\n    close(): void;\n    confirm(message?: string): boolean;\n    departFocus(navigationReason: NavigationReason, origin: FocusNavigationOrigin): void;\n    focus(): void;\n    getComputedStyle(elt: Element, pseudoElt?: string): CSSStyleDeclaration;\n    getMatchedCSSRules(elt: Element, pseudoElt?: string): CSSRuleList;\n    getSelection(): Selection;\n    matchMedia(mediaQuery: string): MediaQueryList;\n    moveBy(x?: number, y?: number): void;\n    moveTo(x?: number, y?: number): void;\n    msWriteProfilerMark(profilerMarkName: string): void;\n    open(url?: string, target?: string, features?: string, replace?: boolean): Window;\n    postMessage(message: any, targetOrigin: string, transfer?: any[]): void;\n    print(): void;\n    prompt(message?: string, _default?: string): string | null;\n    releaseEvents(): void;\n    requestAnimationFrame(callback: FrameRequestCallback): number;\n    resizeBy(x?: number, y?: number): void;\n    resizeTo(x?: number, y?: number): void;\n    scroll(x?: number, y?: number): void;\n    scrollBy(x?: number, y?: number): void;\n    scrollTo(x?: number, y?: number): void;\n    stop(): void;\n    webkitCancelAnimationFrame(handle: number): void;\n    webkitConvertPointFromNodeToPage(node: Node, pt: WebKitPoint): WebKitPoint;\n    webkitConvertPointFromPageToNode(node: Node, pt: WebKitPoint): WebKitPoint;\n    webkitRequestAnimationFrame(callback: FrameRequestCallback): number;\n    createImageBitmap(image: HTMLImageElement | SVGImageElement | HTMLVideoElement | HTMLCanvasElement | ImageBitmap | ImageData | Blob, options?: ImageBitmapOptions): Promise<ImageBitmap>;\n    createImageBitmap(image: HTMLImageElement | SVGImageElement | HTMLVideoElement | HTMLCanvasElement | ImageBitmap | ImageData | Blob, sx: number, sy: number, sw: number, sh: number, options?: ImageBitmapOptions): Promise<ImageBitmap>;\n    scroll(options?: ScrollToOptions): void;\n    scrollTo(options?: ScrollToOptions): void;\n    scrollBy(options?: ScrollToOptions): void;\n    addEventListener<K extends keyof WindowEventMap>(type: K, listener: (this: Window, ev: WindowEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var Window: {\n    prototype: Window;\n    new(): Window;\n};\n\ninterface WorkerEventMap extends AbstractWorkerEventMap {\n    \"message\": MessageEvent;\n}\n\ninterface Worker extends EventTarget, AbstractWorker {\n    onmessage: (this: Worker, ev: MessageEvent) => any;\n    postMessage(message: any, transfer?: any[]): void;\n    terminate(): void;\n    addEventListener<K extends keyof WorkerEventMap>(type: K, listener: (this: Worker, ev: WorkerEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var Worker: {\n    prototype: Worker;\n    new(stringUrl: string): Worker;\n};\n\ninterface XMLDocument extends Document {\n    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: XMLDocument, ev: DocumentEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var XMLDocument: {\n    prototype: XMLDocument;\n    new(): XMLDocument;\n};\n\ninterface XMLHttpRequestEventMap extends XMLHttpRequestEventTargetEventMap {\n    \"readystatechange\": Event;\n}\n\ninterface XMLHttpRequest extends EventTarget, XMLHttpRequestEventTarget {\n    onreadystatechange: (this: XMLHttpRequest, ev: Event) => any;\n    readonly readyState: number;\n    readonly response: any;\n    readonly responseText: string;\n    responseType: XMLHttpRequestResponseType;\n    readonly responseURL: string;\n    readonly responseXML: Document | null;\n    readonly status: number;\n    readonly statusText: string;\n    timeout: number;\n    readonly upload: XMLHttpRequestUpload;\n    withCredentials: boolean;\n    msCaching?: string;\n    abort(): void;\n    getAllResponseHeaders(): string;\n    getResponseHeader(header: string): string | null;\n    msCachingEnabled(): boolean;\n    open(method: string, url: string, async?: boolean, user?: string, password?: string): void;\n    overrideMimeType(mime: string): void;\n    send(data?: Document): void;\n    send(data?: string): void;\n    send(data?: any): void;\n    setRequestHeader(header: string, value: string): void;\n    readonly DONE: number;\n    readonly HEADERS_RECEIVED: number;\n    readonly LOADING: number;\n    readonly OPENED: number;\n    readonly UNSENT: number;\n    addEventListener<K extends keyof XMLHttpRequestEventMap>(type: K, listener: (this: XMLHttpRequest, ev: XMLHttpRequestEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var XMLHttpRequest: {\n    prototype: XMLHttpRequest;\n    new(): XMLHttpRequest;\n    readonly DONE: number;\n    readonly HEADERS_RECEIVED: number;\n    readonly LOADING: number;\n    readonly OPENED: number;\n    readonly UNSENT: number;\n};\n\ninterface XMLHttpRequestUpload extends EventTarget, XMLHttpRequestEventTarget {\n    addEventListener<K extends keyof XMLHttpRequestEventTargetEventMap>(type: K, listener: (this: XMLHttpRequestUpload, ev: XMLHttpRequestEventTargetEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ndeclare var XMLHttpRequestUpload: {\n    prototype: XMLHttpRequestUpload;\n    new(): XMLHttpRequestUpload;\n};\n\ninterface XMLSerializer {\n    serializeToString(target: Node): string;\n}\n\ndeclare var XMLSerializer: {\n    prototype: XMLSerializer;\n    new(): XMLSerializer;\n};\n\ninterface XPathEvaluator {\n    createExpression(expression: string, resolver: XPathNSResolver): XPathExpression;\n    createNSResolver(nodeResolver?: Node): XPathNSResolver;\n    evaluate(expression: string, contextNode: Node, resolver: XPathNSResolver | null, type: number, result: XPathResult | null): XPathResult;\n}\n\ndeclare var XPathEvaluator: {\n    prototype: XPathEvaluator;\n    new(): XPathEvaluator;\n};\n\ninterface XPathExpression {\n    evaluate(contextNode: Node, type: number, result: XPathResult | null): XPathResult;\n}\n\ndeclare var XPathExpression: {\n    prototype: XPathExpression;\n    new(): XPathExpression;\n};\n\ninterface XPathNSResolver {\n    lookupNamespaceURI(prefix: string): string;\n}\n\ndeclare var XPathNSResolver: {\n    prototype: XPathNSResolver;\n    new(): XPathNSResolver;\n};\n\ninterface XPathResult {\n    readonly booleanValue: boolean;\n    readonly invalidIteratorState: boolean;\n    readonly numberValue: number;\n    readonly resultType: number;\n    readonly singleNodeValue: Node;\n    readonly snapshotLength: number;\n    readonly stringValue: string;\n    iterateNext(): Node;\n    snapshotItem(index: number): Node;\n    readonly ANY_TYPE: number;\n    readonly ANY_UNORDERED_NODE_TYPE: number;\n    readonly BOOLEAN_TYPE: number;\n    readonly FIRST_ORDERED_NODE_TYPE: number;\n    readonly NUMBER_TYPE: number;\n    readonly ORDERED_NODE_ITERATOR_TYPE: number;\n    readonly ORDERED_NODE_SNAPSHOT_TYPE: number;\n    readonly STRING_TYPE: number;\n    readonly UNORDERED_NODE_ITERATOR_TYPE: number;\n    readonly UNORDERED_NODE_SNAPSHOT_TYPE: number;\n}\n\ndeclare var XPathResult: {\n    prototype: XPathResult;\n    new(): XPathResult;\n    readonly ANY_TYPE: number;\n    readonly ANY_UNORDERED_NODE_TYPE: number;\n    readonly BOOLEAN_TYPE: number;\n    readonly FIRST_ORDERED_NODE_TYPE: number;\n    readonly NUMBER_TYPE: number;\n    readonly ORDERED_NODE_ITERATOR_TYPE: number;\n    readonly ORDERED_NODE_SNAPSHOT_TYPE: number;\n    readonly STRING_TYPE: number;\n    readonly UNORDERED_NODE_ITERATOR_TYPE: number;\n    readonly UNORDERED_NODE_SNAPSHOT_TYPE: number;\n};\n\ninterface XSLTProcessor {\n    clearParameters(): void;\n    getParameter(namespaceURI: string, localName: string): any;\n    importStylesheet(style: Node): void;\n    removeParameter(namespaceURI: string, localName: string): void;\n    reset(): void;\n    setParameter(namespaceURI: string, localName: string, value: any): void;\n    transformToDocument(source: Node): Document;\n    transformToFragment(source: Node, document: Document): DocumentFragment;\n}\n\ndeclare var XSLTProcessor: {\n    prototype: XSLTProcessor;\n    new(): XSLTProcessor;\n};\n\ninterface AbstractWorkerEventMap {\n    \"error\": ErrorEvent;\n}\n\ninterface AbstractWorker {\n    onerror: (this: AbstractWorker, ev: ErrorEvent) => any;\n    addEventListener<K extends keyof AbstractWorkerEventMap>(type: K, listener: (this: AbstractWorker, ev: AbstractWorkerEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ninterface Body {\n    readonly bodyUsed: boolean;\n    arrayBuffer(): Promise<ArrayBuffer>;\n    blob(): Promise<Blob>;\n    json(): Promise<any>;\n    text(): Promise<string>;\n    formData(): Promise<FormData>;\n}\n\ninterface CanvasPathMethods {\n    arc(x: number, y: number, radius: number, startAngle: number, endAngle: number, anticlockwise?: boolean): void;\n    arcTo(x1: number, y1: number, x2: number, y2: number, radius: number): void;\n    bezierCurveTo(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number): void;\n    closePath(): void;\n    ellipse(x: number, y: number, radiusX: number, radiusY: number, rotation: number, startAngle: number, endAngle: number, anticlockwise?: boolean): void;\n    lineTo(x: number, y: number): void;\n    moveTo(x: number, y: number): void;\n    quadraticCurveTo(cpx: number, cpy: number, x: number, y: number): void;\n    rect(x: number, y: number, w: number, h: number): void;\n}\n\ninterface ChildNode {\n    remove(): void;\n}\n\ninterface DocumentEvent {\n    createEvent(eventInterface: \"AnimationEvent\"): AnimationEvent;\n    createEvent(eventInterface: \"AudioProcessingEvent\"): AudioProcessingEvent;\n    createEvent(eventInterface: \"BeforeUnloadEvent\"): BeforeUnloadEvent;\n    createEvent(eventInterface: \"ClipboardEvent\"): ClipboardEvent;\n    createEvent(eventInterface: \"CloseEvent\"): CloseEvent;\n    createEvent(eventInterface: \"CompositionEvent\"): CompositionEvent;\n    createEvent(eventInterface: \"CustomEvent\"): CustomEvent;\n    createEvent(eventInterface: \"DeviceLightEvent\"): DeviceLightEvent;\n    createEvent(eventInterface: \"DeviceMotionEvent\"): DeviceMotionEvent;\n    createEvent(eventInterface: \"DeviceOrientationEvent\"): DeviceOrientationEvent;\n    createEvent(eventInterface: \"DragEvent\"): DragEvent;\n    createEvent(eventInterface: \"ErrorEvent\"): ErrorEvent;\n    createEvent(eventInterface: \"Event\"): Event;\n    createEvent(eventInterface: \"Events\"): Event;\n    createEvent(eventInterface: \"FocusEvent\"): FocusEvent;\n    createEvent(eventInterface: \"FocusNavigationEvent\"): FocusNavigationEvent;\n    createEvent(eventInterface: \"GamepadEvent\"): GamepadEvent;\n    createEvent(eventInterface: \"HashChangeEvent\"): HashChangeEvent;\n    createEvent(eventInterface: \"IDBVersionChangeEvent\"): IDBVersionChangeEvent;\n    createEvent(eventInterface: \"KeyboardEvent\"): KeyboardEvent;\n    createEvent(eventInterface: \"ListeningStateChangedEvent\"): ListeningStateChangedEvent;\n    createEvent(eventInterface: \"LongRunningScriptDetectedEvent\"): LongRunningScriptDetectedEvent;\n    createEvent(eventInterface: \"MSGestureEvent\"): MSGestureEvent;\n    createEvent(eventInterface: \"MSManipulationEvent\"): MSManipulationEvent;\n    createEvent(eventInterface: \"MSMediaKeyMessageEvent\"): MSMediaKeyMessageEvent;\n    createEvent(eventInterface: \"MSMediaKeyNeededEvent\"): MSMediaKeyNeededEvent;\n    createEvent(eventInterface: \"MSPointerEvent\"): MSPointerEvent;\n    createEvent(eventInterface: \"MSSiteModeEvent\"): MSSiteModeEvent;\n    createEvent(eventInterface: \"MediaEncryptedEvent\"): MediaEncryptedEvent;\n    createEvent(eventInterface: \"MediaKeyMessageEvent\"): MediaKeyMessageEvent;\n    createEvent(eventInterface: \"MediaStreamErrorEvent\"): MediaStreamErrorEvent;\n    createEvent(eventInterface: \"MediaStreamEvent\"): MediaStreamEvent;\n    createEvent(eventInterface: \"MediaStreamTrackEvent\"): MediaStreamTrackEvent;\n    createEvent(eventInterface: \"MessageEvent\"): MessageEvent;\n    createEvent(eventInterface: \"MouseEvent\"): MouseEvent;\n    createEvent(eventInterface: \"MouseEvents\"): MouseEvent;\n    createEvent(eventInterface: \"MutationEvent\"): MutationEvent;\n    createEvent(eventInterface: \"MutationEvents\"): MutationEvent;\n    createEvent(eventInterface: \"NavigationCompletedEvent\"): NavigationCompletedEvent;\n    createEvent(eventInterface: \"NavigationEvent\"): NavigationEvent;\n    createEvent(eventInterface: \"NavigationEventWithReferrer\"): NavigationEventWithReferrer;\n    createEvent(eventInterface: \"OfflineAudioCompletionEvent\"): OfflineAudioCompletionEvent;\n    createEvent(eventInterface: \"OverflowEvent\"): OverflowEvent;\n    createEvent(eventInterface: \"PageTransitionEvent\"): PageTransitionEvent;\n    createEvent(eventInterface: \"PaymentRequestUpdateEvent\"): PaymentRequestUpdateEvent;\n    createEvent(eventInterface: \"PermissionRequestedEvent\"): PermissionRequestedEvent;\n    createEvent(eventInterface: \"PointerEvent\"): PointerEvent;\n    createEvent(eventInterface: \"PopStateEvent\"): PopStateEvent;\n    createEvent(eventInterface: \"ProgressEvent\"): ProgressEvent;\n    createEvent(eventInterface: \"RTCDTMFToneChangeEvent\"): RTCDTMFToneChangeEvent;\n    createEvent(eventInterface: \"RTCDtlsTransportStateChangedEvent\"): RTCDtlsTransportStateChangedEvent;\n    createEvent(eventInterface: \"RTCIceCandidatePairChangedEvent\"): RTCIceCandidatePairChangedEvent;\n    createEvent(eventInterface: \"RTCIceGathererEvent\"): RTCIceGathererEvent;\n    createEvent(eventInterface: \"RTCIceTransportStateChangedEvent\"): RTCIceTransportStateChangedEvent;\n    createEvent(eventInterface: \"RTCPeerConnectionIceEvent\"): RTCPeerConnectionIceEvent;\n    createEvent(eventInterface: \"RTCSsrcConflictEvent\"): RTCSsrcConflictEvent;\n    createEvent(eventInterface: \"SVGZoomEvent\"): SVGZoomEvent;\n    createEvent(eventInterface: \"SVGZoomEvents\"): SVGZoomEvent;\n    createEvent(eventInterface: \"ScriptNotifyEvent\"): ScriptNotifyEvent;\n    createEvent(eventInterface: \"ServiceWorkerMessageEvent\"): ServiceWorkerMessageEvent;\n    createEvent(eventInterface: \"SpeechSynthesisEvent\"): SpeechSynthesisEvent;\n    createEvent(eventInterface: \"StorageEvent\"): StorageEvent;\n    createEvent(eventInterface: \"TextEvent\"): TextEvent;\n    createEvent(eventInterface: \"TouchEvent\"): TouchEvent;\n    createEvent(eventInterface: \"TrackEvent\"): TrackEvent;\n    createEvent(eventInterface: \"TransitionEvent\"): TransitionEvent;\n    createEvent(eventInterface: \"UIEvent\"): UIEvent;\n    createEvent(eventInterface: \"UIEvents\"): UIEvent;\n    createEvent(eventInterface: \"UnviewableContentIdentifiedEvent\"): UnviewableContentIdentifiedEvent;\n    createEvent(eventInterface: \"WebGLContextEvent\"): WebGLContextEvent;\n    createEvent(eventInterface: \"WheelEvent\"): WheelEvent;\n    createEvent(eventInterface: string): Event;\n}\n\ninterface DOML2DeprecatedColorProperty {\n    color: string;\n}\n\ninterface DOML2DeprecatedSizeProperty {\n    size: number;\n}\n\ninterface ElementTraversal {\n    readonly childElementCount: number;\n    readonly firstElementChild: Element | null;\n    readonly lastElementChild: Element | null;\n    readonly nextElementSibling: Element | null;\n    readonly previousElementSibling: Element | null;\n}\n\ninterface GetSVGDocument {\n    getSVGDocument(): Document;\n}\n\ninterface GlobalEventHandlersEventMap {\n    \"pointercancel\": PointerEvent;\n    \"pointerdown\": PointerEvent;\n    \"pointerenter\": PointerEvent;\n    \"pointerleave\": PointerEvent;\n    \"pointermove\": PointerEvent;\n    \"pointerout\": PointerEvent;\n    \"pointerover\": PointerEvent;\n    \"pointerup\": PointerEvent;\n    \"wheel\": WheelEvent;\n}\n\ninterface GlobalEventHandlers {\n    onpointercancel: (this: GlobalEventHandlers, ev: PointerEvent) => any;\n    onpointerdown: (this: GlobalEventHandlers, ev: PointerEvent) => any;\n    onpointerenter: (this: GlobalEventHandlers, ev: PointerEvent) => any;\n    onpointerleave: (this: GlobalEventHandlers, ev: PointerEvent) => any;\n    onpointermove: (this: GlobalEventHandlers, ev: PointerEvent) => any;\n    onpointerout: (this: GlobalEventHandlers, ev: PointerEvent) => any;\n    onpointerover: (this: GlobalEventHandlers, ev: PointerEvent) => any;\n    onpointerup: (this: GlobalEventHandlers, ev: PointerEvent) => any;\n    onwheel: (this: GlobalEventHandlers, ev: WheelEvent) => any;\n    addEventListener<K extends keyof GlobalEventHandlersEventMap>(type: K, listener: (this: GlobalEventHandlers, ev: GlobalEventHandlersEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ninterface GlobalFetch {\n    fetch(input: RequestInfo, init?: RequestInit): Promise<Response>;\n}\n\ninterface HTMLTableAlignment {\n    /**\n     * Sets or retrieves a value that you can use to implement your own ch functionality for the object.\n     */\n    ch: string;\n    /**\n     * Sets or retrieves a value that you can use to implement your own chOff functionality for the object.\n     */\n    chOff: string;\n    /**\n     * Sets or retrieves how text and other content are vertically aligned within the object that contains them.\n     */\n    vAlign: string;\n}\n\ninterface IDBEnvironment {\n    readonly indexedDB: IDBFactory;\n}\n\ninterface LinkStyle {\n    readonly sheet: StyleSheet;\n}\n\ninterface MSBaseReaderEventMap {\n    \"abort\": Event;\n    \"error\": ErrorEvent;\n    \"load\": Event;\n    \"loadend\": ProgressEvent;\n    \"loadstart\": Event;\n    \"progress\": ProgressEvent;\n}\n\ninterface MSBaseReader {\n    onabort: (this: MSBaseReader, ev: Event) => any;\n    onerror: (this: MSBaseReader, ev: ErrorEvent) => any;\n    onload: (this: MSBaseReader, ev: Event) => any;\n    onloadend: (this: MSBaseReader, ev: ProgressEvent) => any;\n    onloadstart: (this: MSBaseReader, ev: Event) => any;\n    onprogress: (this: MSBaseReader, ev: ProgressEvent) => any;\n    readonly readyState: number;\n    readonly result: any;\n    abort(): void;\n    readonly DONE: number;\n    readonly EMPTY: number;\n    readonly LOADING: number;\n    addEventListener<K extends keyof MSBaseReaderEventMap>(type: K, listener: (this: MSBaseReader, ev: MSBaseReaderEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ninterface MSFileSaver {\n    msSaveBlob(blob: any, defaultName?: string): boolean;\n    msSaveOrOpenBlob(blob: any, defaultName?: string): boolean;\n}\n\ninterface MSNavigatorDoNotTrack {\n    confirmSiteSpecificTrackingException(args: ConfirmSiteSpecificExceptionsInformation): boolean;\n    confirmWebWideTrackingException(args: ExceptionInformation): boolean;\n    removeSiteSpecificTrackingException(args: ExceptionInformation): void;\n    removeWebWideTrackingException(args: ExceptionInformation): void;\n    storeSiteSpecificTrackingException(args: StoreSiteSpecificExceptionsInformation): void;\n    storeWebWideTrackingException(args: StoreExceptionsInformation): void;\n}\n\ninterface NavigatorBeacon {\n    sendBeacon(url: USVString, data?: BodyInit): boolean;\n}\n\ninterface NavigatorConcurrentHardware {\n    readonly hardwareConcurrency: number;\n}\n\ninterface NavigatorContentUtils {\n}\n\ninterface NavigatorGeolocation {\n    readonly geolocation: Geolocation;\n}\n\ninterface NavigatorID {\n    readonly appCodeName: string;\n    readonly appName: string;\n    readonly appVersion: string;\n    readonly platform: string;\n    readonly product: string;\n    readonly productSub: string;\n    readonly userAgent: string;\n    readonly vendor: string;\n    readonly vendorSub: string;\n}\n\ninterface NavigatorOnLine {\n    readonly onLine: boolean;\n}\n\ninterface NavigatorStorageUtils {\n}\n\ninterface NavigatorUserMedia {\n    readonly mediaDevices: MediaDevices;\n    getUserMedia(constraints: MediaStreamConstraints, successCallback: NavigatorUserMediaSuccessCallback, errorCallback: NavigatorUserMediaErrorCallback): void;\n}\n\ninterface NodeSelector {\n    querySelector<K extends keyof ElementTagNameMap>(selectors: K): ElementTagNameMap[K] | null;\n    querySelector(selectors: string): Element | null;\n    querySelectorAll<K extends keyof ElementListTagNameMap>(selectors: K): ElementListTagNameMap[K];\n    querySelectorAll(selectors: string): NodeListOf<Element>;\n}\n\ninterface RandomSource {\n    getRandomValues(array: ArrayBufferView): ArrayBufferView;\n}\n\ninterface SVGAnimatedPoints {\n    readonly animatedPoints: SVGPointList;\n    readonly points: SVGPointList;\n}\n\ninterface SVGFilterPrimitiveStandardAttributes {\n    readonly height: SVGAnimatedLength;\n    readonly result: SVGAnimatedString;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n}\n\ninterface SVGFitToViewBox {\n    readonly preserveAspectRatio: SVGAnimatedPreserveAspectRatio;\n    readonly viewBox: SVGAnimatedRect;\n}\n\ninterface SVGTests {\n    readonly requiredExtensions: SVGStringList;\n    readonly requiredFeatures: SVGStringList;\n    readonly systemLanguage: SVGStringList;\n    hasExtension(extension: string): boolean;\n}\n\ninterface SVGURIReference {\n    readonly href: SVGAnimatedString;\n}\n\ninterface WindowBase64 {\n    atob(encodedString: string): string;\n    btoa(rawString: string): string;\n}\n\ninterface WindowConsole {\n    readonly console: Console;\n}\n\ninterface WindowLocalStorage {\n    readonly localStorage: Storage;\n}\n\ninterface WindowSessionStorage {\n    readonly sessionStorage: Storage;\n}\n\ninterface WindowTimers extends Object, WindowTimersExtension {\n    clearInterval(handle: number): void;\n    clearTimeout(handle: number): void;\n    setInterval(handler: (...args: any[]) => void, timeout: number): number;\n    setInterval(handler: any, timeout?: any, ...args: any[]): number;\n    setTimeout(handler: (...args: any[]) => void, timeout: number): number;\n    setTimeout(handler: any, timeout?: any, ...args: any[]): number;\n}\n\ninterface WindowTimersExtension {\n    clearImmediate(handle: number): void;\n    setImmediate(handler: (...args: any[]) => void): number;\n    setImmediate(handler: any, ...args: any[]): number;\n}\n\ninterface XMLHttpRequestEventTargetEventMap {\n    \"abort\": Event;\n    \"error\": ErrorEvent;\n    \"load\": Event;\n    \"loadend\": ProgressEvent;\n    \"loadstart\": Event;\n    \"progress\": ProgressEvent;\n    \"timeout\": ProgressEvent;\n}\n\ninterface XMLHttpRequestEventTarget {\n    onabort: (this: XMLHttpRequestEventTarget, ev: Event) => any;\n    onerror: (this: XMLHttpRequestEventTarget, ev: ErrorEvent) => any;\n    onload: (this: XMLHttpRequestEventTarget, ev: Event) => any;\n    onloadend: (this: XMLHttpRequestEventTarget, ev: ProgressEvent) => any;\n    onloadstart: (this: XMLHttpRequestEventTarget, ev: Event) => any;\n    onprogress: (this: XMLHttpRequestEventTarget, ev: ProgressEvent) => any;\n    ontimeout: (this: XMLHttpRequestEventTarget, ev: ProgressEvent) => any;\n    addEventListener<K extends keyof XMLHttpRequestEventTargetEventMap>(type: K, listener: (this: XMLHttpRequestEventTarget, ev: XMLHttpRequestEventTargetEventMap[K]) => any, useCapture?: boolean): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\n}\n\ninterface ErrorEventInit {\n    message?: string;\n    filename?: string;\n    lineno?: number;\n    conlno?: number;\n    error?: any;\n}\n\ninterface StorageEventInit extends EventInit {\n    key?: string;\n    oldValue?: string;\n    newValue?: string;\n    url: string;\n    storageArea?: Storage;\n}\n\ninterface Canvas2DContextAttributes {\n    alpha?: boolean;\n    willReadFrequently?: boolean;\n    storage?: boolean;\n    [attribute: string]: boolean | string | undefined;\n}\n\ninterface ImageBitmapOptions {\n    imageOrientation?: \"none\" | \"flipY\";\n    premultiplyAlpha?: \"none\" | \"premultiply\" | \"default\";\n    colorSpaceConversion?: \"none\" | \"default\";\n    resizeWidth?: number;\n    resizeHeight?: number;\n    resizeQuality?: \"pixelated\" | \"low\" | \"medium\" | \"high\";\n}\n\ninterface ImageBitmap {\n    readonly width: number;\n    readonly height: number;\n    close(): void;\n}\n\ninterface URLSearchParams {\n    /**\n     * Appends a specified key/value pair as a new search parameter.\n     */\n    append(name: string, value: string): void;\n    /**\n     * Deletes the given search parameter, and its associated value, from the list of all search parameters.\n     */\n    delete(name: string): void;\n    /**\n     * Returns the first value associated to the given search parameter.\n     */\n    get(name: string): string | null;\n    /**\n     * Returns all the values association with a given search parameter.\n     */\n    getAll(name: string): string[];\n    /**\n     * Returns a Boolean indicating if such a search parameter exists.\n     */\n    has(name: string): boolean;\n    /**\n     * Sets the value associated to a given search parameter to the given value. If there were several values, delete the others.\n     */\n    set(name: string, value: string): void;\n}\n\ndeclare var URLSearchParams: {\n    prototype: URLSearchParams;\n    /**\n     * Constructor returning a URLSearchParams object.\n     */\n    new (init?: string | URLSearchParams): URLSearchParams;\n};\n\ninterface NodeListOf<TNode extends Node> extends NodeList {\n    length: number;\n    item(index: number): TNode;\n    [index: number]: TNode;\n}\n\ninterface HTMLCollectionOf<T extends Element> extends HTMLCollection {\n    item(index: number): T;\n    namedItem(name: string): T;\n    [index: number]: T;\n}\n\ninterface BlobPropertyBag {\n    type?: string;\n    endings?: string;\n}\n\ninterface FilePropertyBag {\n    type?: string;\n    lastModified?: number;\n}\n\ninterface EventListenerObject {\n    handleEvent(evt: Event): void;\n}\n\ninterface ProgressEventInit extends EventInit {\n    lengthComputable?: boolean;\n    loaded?: number;\n    total?: number;\n}\n\ninterface ScrollOptions {\n    behavior?: ScrollBehavior;\n}\n\ninterface ScrollToOptions extends ScrollOptions {\n    left?: number;\n    top?: number;\n}\n\ninterface ScrollIntoViewOptions extends ScrollOptions {\n    block?: ScrollLogicalPosition;\n    inline?: ScrollLogicalPosition;\n}\n\ninterface ClipboardEventInit extends EventInit {\n    data?: string;\n    dataType?: string;\n}\n\ninterface IDBArrayKey extends Array<IDBValidKey> {\n}\n\ninterface RsaKeyGenParams extends Algorithm {\n    modulusLength: number;\n    publicExponent: Uint8Array;\n}\n\ninterface RsaHashedKeyGenParams extends RsaKeyGenParams {\n    hash: AlgorithmIdentifier;\n}\n\ninterface RsaKeyAlgorithm extends KeyAlgorithm {\n    modulusLength: number;\n    publicExponent: Uint8Array;\n}\n\ninterface RsaHashedKeyAlgorithm extends RsaKeyAlgorithm {\n    hash: AlgorithmIdentifier;\n}\n\ninterface RsaHashedImportParams {\n    hash: AlgorithmIdentifier;\n}\n\ninterface RsaPssParams {\n    saltLength: number;\n}\n\ninterface RsaOaepParams extends Algorithm {\n    label?: BufferSource;\n}\n\ninterface EcdsaParams extends Algorithm {\n    hash: AlgorithmIdentifier;\n}\n\ninterface EcKeyGenParams extends Algorithm {\n    namedCurve: string;\n}\n\ninterface EcKeyAlgorithm extends KeyAlgorithm {\n    typedCurve: string;\n}\n\ninterface EcKeyImportParams {\n    namedCurve: string;\n}\n\ninterface EcdhKeyDeriveParams extends Algorithm {\n    public: CryptoKey;\n}\n\ninterface AesCtrParams extends Algorithm {\n    counter: BufferSource;\n    length: number;\n}\n\ninterface AesKeyAlgorithm extends KeyAlgorithm {\n    length: number;\n}\n\ninterface AesKeyGenParams extends Algorithm {\n    length: number;\n}\n\ninterface AesDerivedKeyParams extends Algorithm {\n    length: number;\n}\n\ninterface AesCbcParams extends Algorithm {\n    iv: BufferSource;\n}\n\ninterface AesCmacParams extends Algorithm {\n    length: number;\n}\n\ninterface AesGcmParams extends Algorithm {\n    iv: BufferSource;\n    additionalData?: BufferSource;\n    tagLength?: number;\n}\n\ninterface AesCfbParams extends Algorithm {\n    iv: BufferSource;\n}\n\ninterface HmacImportParams extends Algorithm {\n    hash?: AlgorithmIdentifier;\n    length?: number;\n}\n\ninterface HmacKeyAlgorithm extends KeyAlgorithm {\n    hash: AlgorithmIdentifier;\n    length: number;\n}\n\ninterface HmacKeyGenParams extends Algorithm {\n    hash: AlgorithmIdentifier;\n    length?: number;\n}\n\ninterface DhKeyGenParams extends Algorithm {\n    prime: Uint8Array;\n    generator: Uint8Array;\n}\n\ninterface DhKeyAlgorithm extends KeyAlgorithm {\n    prime: Uint8Array;\n    generator: Uint8Array;\n}\n\ninterface DhKeyDeriveParams extends Algorithm {\n    public: CryptoKey;\n}\n\ninterface DhImportKeyParams extends Algorithm {\n    prime: Uint8Array;\n    generator: Uint8Array;\n}\n\ninterface ConcatParams extends Algorithm {\n    hash?: AlgorithmIdentifier;\n    algorithmId: Uint8Array;\n    partyUInfo: Uint8Array;\n    partyVInfo: Uint8Array;\n    publicInfo?: Uint8Array;\n    privateInfo?: Uint8Array;\n}\n\ninterface HkdfCtrParams extends Algorithm {\n    hash: AlgorithmIdentifier;\n    label: BufferSource;\n    context: BufferSource;\n}\n\ninterface Pbkdf2Params extends Algorithm {\n    salt: BufferSource;\n    iterations: number;\n    hash: AlgorithmIdentifier;\n}\n\ninterface RsaOtherPrimesInfo {\n    r: string;\n    d: string;\n    t: string;\n}\n\ninterface JsonWebKey {\n    kty: string;\n    use?: string;\n    key_ops?: string[];\n    alg?: string;\n    kid?: string;\n    x5u?: string;\n    x5c?: string;\n    x5t?: string;\n    ext?: boolean;\n    crv?: string;\n    x?: string;\n    y?: string;\n    d?: string;\n    n?: string;\n    e?: string;\n    p?: string;\n    q?: string;\n    dp?: string;\n    dq?: string;\n    qi?: string;\n    oth?: RsaOtherPrimesInfo[];\n    k?: string;\n}\n\ninterface ParentNode {\n    readonly children: HTMLCollection;\n    readonly firstElementChild: Element | null;\n    readonly lastElementChild: Element | null;\n    readonly childElementCount: number;\n}\n\ninterface DocumentOrShadowRoot {\n    readonly activeElement: Element | null;\n    readonly stylesheets: StyleSheetList;\n    getSelection(): Selection | null;\n    elementFromPoint(x: number, y: number): Element | null;\n    elementsFromPoint(x: number, y: number): Element[];\n}\n\ninterface ShadowRoot extends DocumentOrShadowRoot, DocumentFragment {\n    readonly host: Element;\n    innerHTML: string;\n}\n\ninterface ShadowRootInit {\n    mode: \"open\" | \"closed\";\n    delegatesFocus?: boolean;\n}\n\ninterface HTMLSlotElement extends HTMLElement {\n    name: string;\n    assignedNodes(options?: AssignedNodesOptions): Node[];\n}\n\ninterface AssignedNodesOptions {\n    flatten?: boolean;\n}\n\ninterface ElementDefinitionOptions {\n    extends: string;\n}\n\ninterface CustomElementRegistry {\n    define(name: string, constructor: Function, options?: ElementDefinitionOptions): void;\n    get(name: string): any;\n    whenDefined(name: string): PromiseLike<void>;\n}\n\ninterface PromiseRejectionEvent extends Event {\n    readonly promise: PromiseLike<any>;\n    readonly reason: any;\n}\n\ninterface PromiseRejectionEventInit extends EventInit {\n    promise: PromiseLike<any>;\n    reason?: any;\n}\n\ninterface EventListenerOptions {\n    capture?: boolean;\n}\n\ninterface AddEventListenerOptions extends EventListenerOptions {\n    passive?: boolean;\n    once?: boolean;\n}\n\ninterface TouchEventInit extends EventModifierInit {\n    touches?: Touch[];\n    targetTouches?: Touch[];\n    changedTouches?: Touch[];\n}\n\ndeclare type EventListenerOrEventListenerObject = EventListener | EventListenerObject;\n\ninterface DecodeErrorCallback {\n    (error: DOMException): void;\n}\ninterface DecodeSuccessCallback {\n    (decodedData: AudioBuffer): void;\n}\ninterface ErrorEventHandler {\n    (message: string, filename?: string, lineno?: number, colno?: number, error?: Error): void;\n}\ninterface ForEachCallback {\n    (keyId: any, status: MediaKeyStatus): void;\n}\ninterface FrameRequestCallback {\n    (time: number): void;\n}\ninterface FunctionStringCallback {\n    (data: string): void;\n}\ninterface IntersectionObserverCallback {\n    (entries: IntersectionObserverEntry[], observer: IntersectionObserver): void;\n}\ninterface MediaQueryListListener {\n    (mql: MediaQueryList): void;\n}\ninterface MSExecAtPriorityFunctionCallback {\n    (...args: any[]): any;\n}\ninterface MSLaunchUriCallback {\n    (): void;\n}\ninterface MSUnsafeFunctionCallback {\n    (): any;\n}\ninterface MutationCallback {\n    (mutations: MutationRecord[], observer: MutationObserver): void;\n}\ninterface NavigatorUserMediaErrorCallback {\n    (error: MediaStreamError): void;\n}\ninterface NavigatorUserMediaSuccessCallback {\n    (stream: MediaStream): void;\n}\ninterface NotificationPermissionCallback {\n    (permission: NotificationPermission): void;\n}\ninterface PositionCallback {\n    (position: Position): void;\n}\ninterface PositionErrorCallback {\n    (error: PositionError): void;\n}\ninterface RTCPeerConnectionErrorCallback {\n    (error: DOMError): void;\n}\ninterface RTCSessionDescriptionCallback {\n    (sdp: RTCSessionDescription): void;\n}\ninterface RTCStatsCallback {\n    (report: RTCStatsReport): void;\n}\ninterface VoidFunction {\n    (): void;\n}\ninterface HTMLElementTagNameMap {\n    \"a\": HTMLAnchorElement;\n    \"applet\": HTMLAppletElement;\n    \"area\": HTMLAreaElement;\n    \"audio\": HTMLAudioElement;\n    \"base\": HTMLBaseElement;\n    \"basefont\": HTMLBaseFontElement;\n    \"blockquote\": HTMLQuoteElement;\n    \"body\": HTMLBodyElement;\n    \"br\": HTMLBRElement;\n    \"button\": HTMLButtonElement;\n    \"canvas\": HTMLCanvasElement;\n    \"caption\": HTMLTableCaptionElement;\n    \"col\": HTMLTableColElement;\n    \"colgroup\": HTMLTableColElement;\n    \"data\": HTMLDataElement;\n    \"datalist\": HTMLDataListElement;\n    \"del\": HTMLModElement;\n    \"dir\": HTMLDirectoryElement;\n    \"div\": HTMLDivElement;\n    \"dl\": HTMLDListElement;\n    \"embed\": HTMLEmbedElement;\n    \"fieldset\": HTMLFieldSetElement;\n    \"font\": HTMLFontElement;\n    \"form\": HTMLFormElement;\n    \"frame\": HTMLFrameElement;\n    \"frameset\": HTMLFrameSetElement;\n    \"h1\": HTMLHeadingElement;\n    \"h2\": HTMLHeadingElement;\n    \"h3\": HTMLHeadingElement;\n    \"h4\": HTMLHeadingElement;\n    \"h5\": HTMLHeadingElement;\n    \"h6\": HTMLHeadingElement;\n    \"head\": HTMLHeadElement;\n    \"hr\": HTMLHRElement;\n    \"html\": HTMLHtmlElement;\n    \"iframe\": HTMLIFrameElement;\n    \"img\": HTMLImageElement;\n    \"input\": HTMLInputElement;\n    \"ins\": HTMLModElement;\n    \"isindex\": HTMLUnknownElement;\n    \"label\": HTMLLabelElement;\n    \"legend\": HTMLLegendElement;\n    \"li\": HTMLLIElement;\n    \"link\": HTMLLinkElement;\n    \"listing\": HTMLPreElement;\n    \"map\": HTMLMapElement;\n    \"marquee\": HTMLMarqueeElement;\n    \"menu\": HTMLMenuElement;\n    \"meta\": HTMLMetaElement;\n    \"meter\": HTMLMeterElement;\n    \"nextid\": HTMLUnknownElement;\n    \"object\": HTMLObjectElement;\n    \"ol\": HTMLOListElement;\n    \"optgroup\": HTMLOptGroupElement;\n    \"option\": HTMLOptionElement;\n    \"output\": HTMLOutputElement;\n    \"p\": HTMLParagraphElement;\n    \"param\": HTMLParamElement;\n    \"picture\": HTMLPictureElement;\n    \"pre\": HTMLPreElement;\n    \"progress\": HTMLProgressElement;\n    \"q\": HTMLQuoteElement;\n    \"script\": HTMLScriptElement;\n    \"select\": HTMLSelectElement;\n    \"source\": HTMLSourceElement;\n    \"span\": HTMLSpanElement;\n    \"style\": HTMLStyleElement;\n    \"table\": HTMLTableElement;\n    \"tbody\": HTMLTableSectionElement;\n    \"td\": HTMLTableDataCellElement;\n    \"template\": HTMLTemplateElement;\n    \"textarea\": HTMLTextAreaElement;\n    \"tfoot\": HTMLTableSectionElement;\n    \"th\": HTMLTableHeaderCellElement;\n    \"thead\": HTMLTableSectionElement;\n    \"time\": HTMLTimeElement;\n    \"title\": HTMLTitleElement;\n    \"tr\": HTMLTableRowElement;\n    \"track\": HTMLTrackElement;\n    \"ul\": HTMLUListElement;\n    \"video\": HTMLVideoElement;\n    \"x-ms-webview\": MSHTMLWebViewElement;\n    \"xmp\": HTMLPreElement;\n}\n\ninterface ElementTagNameMap extends HTMLElementTagNameMap {\n    \"abbr\": HTMLElement;\n    \"acronym\": HTMLElement;\n    \"address\": HTMLElement;\n    \"article\": HTMLElement;\n    \"aside\": HTMLElement;\n    \"b\": HTMLElement;\n    \"bdo\": HTMLElement;\n    \"big\": HTMLElement;\n    \"center\": HTMLElement;\n    \"circle\": SVGCircleElement;\n    \"cite\": HTMLElement;\n    \"clippath\": SVGClipPathElement;\n    \"code\": HTMLElement;\n    \"dd\": HTMLElement;\n    \"defs\": SVGDefsElement;\n    \"desc\": SVGDescElement;\n    \"dfn\": HTMLElement;\n    \"dt\": HTMLElement;\n    \"ellipse\": SVGEllipseElement;\n    \"em\": HTMLElement;\n    \"feblend\": SVGFEBlendElement;\n    \"fecolormatrix\": SVGFEColorMatrixElement;\n    \"fecomponenttransfer\": SVGFEComponentTransferElement;\n    \"fecomposite\": SVGFECompositeElement;\n    \"feconvolvematrix\": SVGFEConvolveMatrixElement;\n    \"fediffuselighting\": SVGFEDiffuseLightingElement;\n    \"fedisplacementmap\": SVGFEDisplacementMapElement;\n    \"fedistantlight\": SVGFEDistantLightElement;\n    \"feflood\": SVGFEFloodElement;\n    \"fefunca\": SVGFEFuncAElement;\n    \"fefuncb\": SVGFEFuncBElement;\n    \"fefuncg\": SVGFEFuncGElement;\n    \"fefuncr\": SVGFEFuncRElement;\n    \"fegaussianblur\": SVGFEGaussianBlurElement;\n    \"feimage\": SVGFEImageElement;\n    \"femerge\": SVGFEMergeElement;\n    \"femergenode\": SVGFEMergeNodeElement;\n    \"femorphology\": SVGFEMorphologyElement;\n    \"feoffset\": SVGFEOffsetElement;\n    \"fepointlight\": SVGFEPointLightElement;\n    \"fespecularlighting\": SVGFESpecularLightingElement;\n    \"fespotlight\": SVGFESpotLightElement;\n    \"fetile\": SVGFETileElement;\n    \"feturbulence\": SVGFETurbulenceElement;\n    \"figcaption\": HTMLElement;\n    \"figure\": HTMLElement;\n    \"filter\": SVGFilterElement;\n    \"footer\": HTMLElement;\n    \"foreignobject\": SVGForeignObjectElement;\n    \"g\": SVGGElement;\n    \"header\": HTMLElement;\n    \"hgroup\": HTMLElement;\n    \"i\": HTMLElement;\n    \"image\": SVGImageElement;\n    \"kbd\": HTMLElement;\n    \"keygen\": HTMLElement;\n    \"line\": SVGLineElement;\n    \"lineargradient\": SVGLinearGradientElement;\n    \"mark\": HTMLElement;\n    \"marker\": SVGMarkerElement;\n    \"mask\": SVGMaskElement;\n    \"metadata\": SVGMetadataElement;\n    \"nav\": HTMLElement;\n    \"nobr\": HTMLElement;\n    \"noframes\": HTMLElement;\n    \"noscript\": HTMLElement;\n    \"path\": SVGPathElement;\n    \"pattern\": SVGPatternElement;\n    \"plaintext\": HTMLElement;\n    \"polygon\": SVGPolygonElement;\n    \"polyline\": SVGPolylineElement;\n    \"radialgradient\": SVGRadialGradientElement;\n    \"rect\": SVGRectElement;\n    \"rt\": HTMLElement;\n    \"ruby\": HTMLElement;\n    \"s\": HTMLElement;\n    \"samp\": HTMLElement;\n    \"section\": HTMLElement;\n    \"small\": HTMLElement;\n    \"stop\": SVGStopElement;\n    \"strike\": HTMLElement;\n    \"strong\": HTMLElement;\n    \"sub\": HTMLElement;\n    \"sup\": HTMLElement;\n    \"svg\": SVGSVGElement;\n    \"switch\": SVGSwitchElement;\n    \"symbol\": SVGSymbolElement;\n    \"text\": SVGTextElement;\n    \"textpath\": SVGTextPathElement;\n    \"tspan\": SVGTSpanElement;\n    \"tt\": HTMLElement;\n    \"u\": HTMLElement;\n    \"use\": SVGUseElement;\n    \"var\": HTMLElement;\n    \"view\": SVGViewElement;\n    \"wbr\": HTMLElement;\n}\n\ntype ElementListTagNameMap = {\n    [key in keyof ElementTagNameMap]: NodeListOf<ElementTagNameMap[key]>\n};\n\ndeclare var Audio: { new(src?: string): HTMLAudioElement; };\ndeclare var Image: { new(width?: number, height?: number): HTMLImageElement; };\ndeclare var Option: { new(text?: string, value?: string, defaultSelected?: boolean, selected?: boolean): HTMLOptionElement; };\ndeclare var applicationCache: ApplicationCache;\ndeclare var caches: CacheStorage;\ndeclare var clientInformation: Navigator;\ndeclare var closed: boolean;\ndeclare var crypto: Crypto;\ndeclare var defaultStatus: string;\ndeclare var devicePixelRatio: number;\ndeclare var document: Document;\ndeclare var doNotTrack: string;\ndeclare var event: Event | undefined;\ndeclare var external: External;\ndeclare var frameElement: Element;\ndeclare var frames: Window;\ndeclare var history: History;\ndeclare var innerHeight: number;\ndeclare var innerWidth: number;\ndeclare var isSecureContext: boolean;\ndeclare var length: number;\ndeclare var location: Location;\ndeclare var locationbar: BarProp;\ndeclare var menubar: BarProp;\ndeclare var msContentScript: ExtensionScriptApis;\ndeclare var msCredentials: MSCredentials;\ndeclare const name: never;\ndeclare var navigator: Navigator;\ndeclare var offscreenBuffering: string | boolean;\ndeclare var onabort: (this: Window, ev: UIEvent) => any;\ndeclare var onafterprint: (this: Window, ev: Event) => any;\ndeclare var onbeforeprint: (this: Window, ev: Event) => any;\ndeclare var onbeforeunload: (this: Window, ev: BeforeUnloadEvent) => any;\ndeclare var onblur: (this: Window, ev: FocusEvent) => any;\ndeclare var oncanplay: (this: Window, ev: Event) => any;\ndeclare var oncanplaythrough: (this: Window, ev: Event) => any;\ndeclare var onchange: (this: Window, ev: Event) => any;\ndeclare var onclick: (this: Window, ev: MouseEvent) => any;\ndeclare var oncompassneedscalibration: (this: Window, ev: Event) => any;\ndeclare var oncontextmenu: (this: Window, ev: PointerEvent) => any;\ndeclare var ondblclick: (this: Window, ev: MouseEvent) => any;\ndeclare var ondevicelight: (this: Window, ev: DeviceLightEvent) => any;\ndeclare var ondevicemotion: (this: Window, ev: DeviceMotionEvent) => any;\ndeclare var ondeviceorientation: (this: Window, ev: DeviceOrientationEvent) => any;\ndeclare var ondrag: (this: Window, ev: DragEvent) => any;\ndeclare var ondragend: (this: Window, ev: DragEvent) => any;\ndeclare var ondragenter: (this: Window, ev: DragEvent) => any;\ndeclare var ondragleave: (this: Window, ev: DragEvent) => any;\ndeclare var ondragover: (this: Window, ev: DragEvent) => any;\ndeclare var ondragstart: (this: Window, ev: DragEvent) => any;\ndeclare var ondrop: (this: Window, ev: DragEvent) => any;\ndeclare var ondurationchange: (this: Window, ev: Event) => any;\ndeclare var onemptied: (this: Window, ev: Event) => any;\ndeclare var onended: (this: Window, ev: MediaStreamErrorEvent) => any;\ndeclare var onerror: ErrorEventHandler;\ndeclare var onfocus: (this: Window, ev: FocusEvent) => any;\ndeclare var onhashchange: (this: Window, ev: HashChangeEvent) => any;\ndeclare var oninput: (this: Window, ev: Event) => any;\ndeclare var oninvalid: (this: Window, ev: Event) => any;\ndeclare var onkeydown: (this: Window, ev: KeyboardEvent) => any;\ndeclare var onkeypress: (this: Window, ev: KeyboardEvent) => any;\ndeclare var onkeyup: (this: Window, ev: KeyboardEvent) => any;\ndeclare var onload: (this: Window, ev: Event) => any;\ndeclare var onloadeddata: (this: Window, ev: Event) => any;\ndeclare var onloadedmetadata: (this: Window, ev: Event) => any;\ndeclare var onloadstart: (this: Window, ev: Event) => any;\ndeclare var onmessage: (this: Window, ev: MessageEvent) => any;\ndeclare var onmousedown: (this: Window, ev: MouseEvent) => any;\ndeclare var onmouseenter: (this: Window, ev: MouseEvent) => any;\ndeclare var onmouseleave: (this: Window, ev: MouseEvent) => any;\ndeclare var onmousemove: (this: Window, ev: MouseEvent) => any;\ndeclare var onmouseout: (this: Window, ev: MouseEvent) => any;\ndeclare var onmouseover: (this: Window, ev: MouseEvent) => any;\ndeclare var onmouseup: (this: Window, ev: MouseEvent) => any;\ndeclare var onmousewheel: (this: Window, ev: WheelEvent) => any;\ndeclare var onmsgesturechange: (this: Window, ev: MSGestureEvent) => any;\ndeclare var onmsgesturedoubletap: (this: Window, ev: MSGestureEvent) => any;\ndeclare var onmsgestureend: (this: Window, ev: MSGestureEvent) => any;\ndeclare var onmsgesturehold: (this: Window, ev: MSGestureEvent) => any;\ndeclare var onmsgesturestart: (this: Window, ev: MSGestureEvent) => any;\ndeclare var onmsgesturetap: (this: Window, ev: MSGestureEvent) => any;\ndeclare var onmsinertiastart: (this: Window, ev: MSGestureEvent) => any;\ndeclare var onmspointercancel: (this: Window, ev: MSPointerEvent) => any;\ndeclare var onmspointerdown: (this: Window, ev: MSPointerEvent) => any;\ndeclare var onmspointerenter: (this: Window, ev: MSPointerEvent) => any;\ndeclare var onmspointerleave: (this: Window, ev: MSPointerEvent) => any;\ndeclare var onmspointermove: (this: Window, ev: MSPointerEvent) => any;\ndeclare var onmspointerout: (this: Window, ev: MSPointerEvent) => any;\ndeclare var onmspointerover: (this: Window, ev: MSPointerEvent) => any;\ndeclare var onmspointerup: (this: Window, ev: MSPointerEvent) => any;\ndeclare var onoffline: (this: Window, ev: Event) => any;\ndeclare var ononline: (this: Window, ev: Event) => any;\ndeclare var onorientationchange: (this: Window, ev: Event) => any;\ndeclare var onpagehide: (this: Window, ev: PageTransitionEvent) => any;\ndeclare var onpageshow: (this: Window, ev: PageTransitionEvent) => any;\ndeclare var onpause: (this: Window, ev: Event) => any;\ndeclare var onplay: (this: Window, ev: Event) => any;\ndeclare var onplaying: (this: Window, ev: Event) => any;\ndeclare var onpopstate: (this: Window, ev: PopStateEvent) => any;\ndeclare var onprogress: (this: Window, ev: ProgressEvent) => any;\ndeclare var onratechange: (this: Window, ev: Event) => any;\ndeclare var onreadystatechange: (this: Window, ev: ProgressEvent) => any;\ndeclare var onreset: (this: Window, ev: Event) => any;\ndeclare var onresize: (this: Window, ev: UIEvent) => any;\ndeclare var onscroll: (this: Window, ev: UIEvent) => any;\ndeclare var onseeked: (this: Window, ev: Event) => any;\ndeclare var onseeking: (this: Window, ev: Event) => any;\ndeclare var onselect: (this: Window, ev: UIEvent) => any;\ndeclare var onstalled: (this: Window, ev: Event) => any;\ndeclare var onstorage: (this: Window, ev: StorageEvent) => any;\ndeclare var onsubmit: (this: Window, ev: Event) => any;\ndeclare var onsuspend: (this: Window, ev: Event) => any;\ndeclare var ontimeupdate: (this: Window, ev: Event) => any;\ndeclare var ontouchcancel: (ev: TouchEvent) => any;\ndeclare var ontouchend: (ev: TouchEvent) => any;\ndeclare var ontouchmove: (ev: TouchEvent) => any;\ndeclare var ontouchstart: (ev: TouchEvent) => any;\ndeclare var onunload: (this: Window, ev: Event) => any;\ndeclare var onvolumechange: (this: Window, ev: Event) => any;\ndeclare var onwaiting: (this: Window, ev: Event) => any;\ndeclare var opener: any;\ndeclare var orientation: string | number;\ndeclare var outerHeight: number;\ndeclare var outerWidth: number;\ndeclare var pageXOffset: number;\ndeclare var pageYOffset: number;\ndeclare var parent: Window;\ndeclare var performance: Performance;\ndeclare var personalbar: BarProp;\ndeclare var screen: Screen;\ndeclare var screenLeft: number;\ndeclare var screenTop: number;\ndeclare var screenX: number;\ndeclare var screenY: number;\ndeclare var scrollbars: BarProp;\ndeclare var scrollX: number;\ndeclare var scrollY: number;\ndeclare var self: Window;\ndeclare var speechSynthesis: SpeechSynthesis;\ndeclare var status: string;\ndeclare var statusbar: BarProp;\ndeclare var styleMedia: StyleMedia;\ndeclare var toolbar: BarProp;\ndeclare var top: Window;\ndeclare var window: Window;\ndeclare var customElements: CustomElementRegistry;\ndeclare function alert(message?: any): void;\ndeclare function blur(): void;\ndeclare function cancelAnimationFrame(handle: number): void;\ndeclare function captureEvents(): void;\ndeclare function close(): void;\ndeclare function confirm(message?: string): boolean;\ndeclare function departFocus(navigationReason: NavigationReason, origin: FocusNavigationOrigin): void;\ndeclare function focus(): void;\ndeclare function getComputedStyle(elt: Element, pseudoElt?: string): CSSStyleDeclaration;\ndeclare function getMatchedCSSRules(elt: Element, pseudoElt?: string): CSSRuleList;\ndeclare function getSelection(): Selection;\ndeclare function matchMedia(mediaQuery: string): MediaQueryList;\ndeclare function moveBy(x?: number, y?: number): void;\ndeclare function moveTo(x?: number, y?: number): void;\ndeclare function msWriteProfilerMark(profilerMarkName: string): void;\ndeclare function open(url?: string, target?: string, features?: string, replace?: boolean): Window;\ndeclare function postMessage(message: any, targetOrigin: string, transfer?: any[]): void;\ndeclare function print(): void;\ndeclare function prompt(message?: string, _default?: string): string | null;\ndeclare function releaseEvents(): void;\ndeclare function requestAnimationFrame(callback: FrameRequestCallback): number;\ndeclare function resizeBy(x?: number, y?: number): void;\ndeclare function resizeTo(x?: number, y?: number): void;\ndeclare function scroll(x?: number, y?: number): void;\ndeclare function scrollBy(x?: number, y?: number): void;\ndeclare function scrollTo(x?: number, y?: number): void;\ndeclare function stop(): void;\ndeclare function webkitCancelAnimationFrame(handle: number): void;\ndeclare function webkitConvertPointFromNodeToPage(node: Node, pt: WebKitPoint): WebKitPoint;\ndeclare function webkitConvertPointFromPageToNode(node: Node, pt: WebKitPoint): WebKitPoint;\ndeclare function webkitRequestAnimationFrame(callback: FrameRequestCallback): number;\ndeclare function createImageBitmap(image: HTMLImageElement | SVGImageElement | HTMLVideoElement | HTMLCanvasElement | ImageBitmap | ImageData | Blob, options?: ImageBitmapOptions): Promise<ImageBitmap>;\ndeclare function createImageBitmap(image: HTMLImageElement | SVGImageElement | HTMLVideoElement | HTMLCanvasElement | ImageBitmap | ImageData | Blob, sx: number, sy: number, sw: number, sh: number, options?: ImageBitmapOptions): Promise<ImageBitmap>;\ndeclare function scroll(options?: ScrollToOptions): void;\ndeclare function scrollTo(options?: ScrollToOptions): void;\ndeclare function scrollBy(options?: ScrollToOptions): void;\ndeclare function toString(): string;\ndeclare function dispatchEvent(evt: Event): boolean;\ndeclare function removeEventListener(type: string, listener?: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\ndeclare function clearInterval(handle: number): void;\ndeclare function clearTimeout(handle: number): void;\ndeclare function setInterval(handler: (...args: any[]) => void, timeout: number): number;\ndeclare function setInterval(handler: any, timeout?: any, ...args: any[]): number;\ndeclare function setTimeout(handler: (...args: any[]) => void, timeout: number): number;\ndeclare function setTimeout(handler: any, timeout?: any, ...args: any[]): number;\ndeclare function clearImmediate(handle: number): void;\ndeclare function setImmediate(handler: (...args: any[]) => void): number;\ndeclare function setImmediate(handler: any, ...args: any[]): number;\ndeclare var sessionStorage: Storage;\ndeclare var localStorage: Storage;\ndeclare var console: Console;\ndeclare var onpointercancel: (this: Window, ev: PointerEvent) => any;\ndeclare var onpointerdown: (this: Window, ev: PointerEvent) => any;\ndeclare var onpointerenter: (this: Window, ev: PointerEvent) => any;\ndeclare var onpointerleave: (this: Window, ev: PointerEvent) => any;\ndeclare var onpointermove: (this: Window, ev: PointerEvent) => any;\ndeclare var onpointerout: (this: Window, ev: PointerEvent) => any;\ndeclare var onpointerover: (this: Window, ev: PointerEvent) => any;\ndeclare var onpointerup: (this: Window, ev: PointerEvent) => any;\ndeclare var onwheel: (this: Window, ev: WheelEvent) => any;\ndeclare var indexedDB: IDBFactory;\ndeclare function atob(encodedString: string): string;\ndeclare function btoa(rawString: string): string;\ndeclare function fetch(input: RequestInfo, init?: RequestInit): Promise<Response>;\ndeclare function addEventListener<K extends keyof WindowEventMap>(type: K, listener: (this: Window, ev: WindowEventMap[K]) => any, useCapture?: boolean): void;\ndeclare function addEventListener(type: string, listener: EventListenerOrEventListenerObject, useCapture?: boolean): void;\ntype AAGUID = string;\ntype AlgorithmIdentifier = string | Algorithm;\ntype BodyInit = any;\ntype ByteString = string;\ntype ConstrainBoolean = boolean | ConstrainBooleanParameters;\ntype ConstrainDOMString = string | string[] | ConstrainDOMStringParameters;\ntype ConstrainDouble = number | ConstrainDoubleRange;\ntype ConstrainLong = number | ConstrainLongRange;\ntype CryptoOperationData = ArrayBufferView;\ntype GLbitfield = number;\ntype GLboolean = boolean;\ntype GLbyte = number;\ntype GLclampf = number;\ntype GLenum = number;\ntype GLfloat = number;\ntype GLint = number;\ntype GLintptr = number;\ntype GLshort = number;\ntype GLsizei = number;\ntype GLsizeiptr = number;\ntype GLubyte = number;\ntype GLuint = number;\ntype GLushort = number;\ntype HeadersInit = any;\ntype IDBKeyPath = string;\ntype KeyFormat = string;\ntype KeyType = string;\ntype KeyUsage = string;\ntype MSInboundPayload = MSVideoRecvPayload | MSAudioRecvPayload;\ntype MSLocalClientEvent = MSLocalClientEventBase | MSAudioLocalClientEvent;\ntype MSOutboundPayload = MSVideoSendPayload | MSAudioSendPayload;\ntype RTCIceGatherCandidate = RTCIceCandidateDictionary | RTCIceCandidateComplete;\ntype RTCTransport = RTCDtlsTransport | RTCSrtpSdesTransport;\ntype RequestInfo = Request | string;\ntype USVString = string;\ntype payloadtype = number;\ntype ScrollBehavior = \"auto\" | \"instant\" | \"smooth\";\ntype ScrollLogicalPosition = \"start\" | \"center\" | \"end\" | \"nearest\";\ntype IDBValidKey = number | string | Date | IDBArrayKey;\ntype BufferSource = ArrayBuffer | ArrayBufferView;\ntype MouseWheelEvent = WheelEvent;\ntype ScrollRestoration = \"auto\" | \"manual\";\ntype FormDataEntryValue = string | File;\ntype InsertPosition = \"beforebegin\" | \"afterbegin\" | \"beforeend\" | \"afterend\";\ntype AppendMode = \"segments\" | \"sequence\";\ntype AudioContextState = \"suspended\" | \"running\" | \"closed\";\ntype BiquadFilterType = \"lowpass\" | \"highpass\" | \"bandpass\" | \"lowshelf\" | \"highshelf\" | \"peaking\" | \"notch\" | \"allpass\";\ntype CanvasFillRule = \"nonzero\" | \"evenodd\";\ntype ChannelCountMode = \"max\" | \"clamped-max\" | \"explicit\";\ntype ChannelInterpretation = \"speakers\" | \"discrete\";\ntype DistanceModelType = \"linear\" | \"inverse\" | \"exponential\";\ntype ExpandGranularity = \"character\" | \"word\" | \"sentence\" | \"textedit\";\ntype GamepadInputEmulationType = \"mouse\" | \"keyboard\" | \"gamepad\";\ntype IDBCursorDirection = \"next\" | \"nextunique\" | \"prev\" | \"prevunique\";\ntype IDBRequestReadyState = \"pending\" | \"done\";\ntype IDBTransactionMode = \"readonly\" | \"readwrite\" | \"versionchange\";\ntype ListeningState = \"inactive\" | \"active\" | \"disambiguation\";\ntype MediaDeviceKind = \"audioinput\" | \"audiooutput\" | \"videoinput\";\ntype MediaKeyMessageType = \"license-request\" | \"license-renewal\" | \"license-release\" | \"individualization-request\";\ntype MediaKeySessionType = \"temporary\" | \"persistent-license\" | \"persistent-release-message\";\ntype MediaKeysRequirement = \"required\" | \"optional\" | \"not-allowed\";\ntype MediaKeyStatus = \"usable\" | \"expired\" | \"output-downscaled\" | \"output-not-allowed\" | \"status-pending\" | \"internal-error\";\ntype MediaStreamTrackState = \"live\" | \"ended\";\ntype MSCredentialType = \"FIDO_2_0\";\ntype MSIceAddrType = \"os\" | \"stun\" | \"turn\" | \"peer-derived\";\ntype MSIceType = \"failed\" | \"direct\" | \"relay\";\ntype MSStatsType = \"description\" | \"localclientevent\" | \"inbound-network\" | \"outbound-network\" | \"inbound-payload\" | \"outbound-payload\" | \"transportdiagnostics\";\ntype MSTransportType = \"Embedded\" | \"USB\" | \"NFC\" | \"BT\";\ntype MSWebViewPermissionState = \"unknown\" | \"defer\" | \"allow\" | \"deny\";\ntype MSWebViewPermissionType = \"geolocation\" | \"unlimitedIndexedDBQuota\" | \"media\" | \"pointerlock\" | \"webnotifications\";\ntype NavigationReason = \"up\" | \"down\" | \"left\" | \"right\";\ntype NavigationType = \"navigate\" | \"reload\" | \"back_forward\" | \"prerender\";\ntype NotificationDirection = \"auto\" | \"ltr\" | \"rtl\";\ntype NotificationPermission = \"default\" | \"denied\" | \"granted\";\ntype OscillatorType = \"sine\" | \"square\" | \"sawtooth\" | \"triangle\" | \"custom\";\ntype OverSampleType = \"none\" | \"2x\" | \"4x\";\ntype PanningModelType = \"equalpower\";\ntype PaymentComplete = \"success\" | \"fail\" | \"\";\ntype PaymentShippingType = \"shipping\" | \"delivery\" | \"pickup\";\ntype PushEncryptionKeyName = \"p256dh\" | \"auth\";\ntype PushPermissionState = \"granted\" | \"denied\" | \"prompt\";\ntype ReferrerPolicy = \"\" | \"no-referrer\" | \"no-referrer-when-downgrade\" | \"origin-only\" | \"origin-when-cross-origin\" | \"unsafe-url\";\ntype RequestCache = \"default\" | \"no-store\" | \"reload\" | \"no-cache\" | \"force-cache\";\ntype RequestCredentials = \"omit\" | \"same-origin\" | \"include\";\ntype RequestDestination = \"\" | \"document\" | \"sharedworker\" | \"subresource\" | \"unknown\" | \"worker\";\ntype RequestMode = \"navigate\" | \"same-origin\" | \"no-cors\" | \"cors\";\ntype RequestRedirect = \"follow\" | \"error\" | \"manual\";\ntype RequestType = \"\" | \"audio\" | \"font\" | \"image\" | \"script\" | \"style\" | \"track\" | \"video\";\ntype ResponseType = \"basic\" | \"cors\" | \"default\" | \"error\" | \"opaque\" | \"opaqueredirect\";\ntype RTCBundlePolicy = \"balanced\" | \"max-compat\" | \"max-bundle\";\ntype RTCDegradationPreference = \"maintain-framerate\" | \"maintain-resolution\" | \"balanced\";\ntype RTCDtlsRole = \"auto\" | \"client\" | \"server\";\ntype RTCDtlsTransportState = \"new\" | \"connecting\" | \"connected\" | \"closed\";\ntype RTCIceCandidateType = \"host\" | \"srflx\" | \"prflx\" | \"relay\";\ntype RTCIceComponent = \"RTP\" | \"RTCP\";\ntype RTCIceConnectionState = \"new\" | \"checking\" | \"connected\" | \"completed\" | \"failed\" | \"disconnected\" | \"closed\";\ntype RTCIceGathererState = \"new\" | \"gathering\" | \"complete\";\ntype RTCIceGatheringState = \"new\" | \"gathering\" | \"complete\";\ntype RTCIceGatherPolicy = \"all\" | \"nohost\" | \"relay\";\ntype RTCIceProtocol = \"udp\" | \"tcp\";\ntype RTCIceRole = \"controlling\" | \"controlled\";\ntype RTCIceTcpCandidateType = \"active\" | \"passive\" | \"so\";\ntype RTCIceTransportPolicy = \"none\" | \"relay\" | \"all\";\ntype RTCIceTransportState = \"new\" | \"checking\" | \"connected\" | \"completed\" | \"disconnected\" | \"closed\";\ntype RTCSdpType = \"offer\" | \"pranswer\" | \"answer\";\ntype RTCSignalingState = \"stable\" | \"have-local-offer\" | \"have-remote-offer\" | \"have-local-pranswer\" | \"have-remote-pranswer\" | \"closed\";\ntype RTCStatsIceCandidatePairState = \"frozen\" | \"waiting\" | \"inprogress\" | \"failed\" | \"succeeded\" | \"cancelled\";\ntype RTCStatsIceCandidateType = \"host\" | \"serverreflexive\" | \"peerreflexive\" | \"relayed\";\ntype RTCStatsType = \"inboundrtp\" | \"outboundrtp\" | \"session\" | \"datachannel\" | \"track\" | \"transport\" | \"candidatepair\" | \"localcandidate\" | \"remotecandidate\";\ntype ScopedCredentialType = \"ScopedCred\";\ntype ServiceWorkerState = \"installing\" | \"installed\" | \"activating\" | \"activated\" | \"redundant\";\ntype Transport = \"usb\" | \"nfc\" | \"ble\";\ntype VideoFacingModeEnum = \"user\" | \"environment\" | \"left\" | \"right\";\ntype VisibilityState = \"hidden\" | \"visible\" | \"prerender\" | \"unloaded\";\ntype XMLHttpRequestResponseType = \"\" | \"arraybuffer\" | \"blob\" | \"document\" | \"json\" | \"text\";\n\n\n/////////////////////////////\n/// WorkerGlobalScope APIs\n/////////////////////////////\n// These are only available in a Web Worker\ndeclare function importScripts(...urls: string[]): void;\n\n\n\n\n/////////////////////////////\n/// Windows Script Host APIS\n/////////////////////////////\n\n\ninterface ActiveXObject {\n    new (s: string): any;\n}\ndeclare var ActiveXObject: ActiveXObject;\n\ninterface ITextWriter {\n    Write(s: string): void;\n    WriteLine(s: string): void;\n    Close(): void;\n}\n\ninterface TextStreamBase {\n    /**\n     * The column number of the current character position in an input stream.\n     */\n    Column: number;\n\n    /**\n     * The current line number in an input stream.\n     */\n    Line: number;\n\n    /**\n     * Closes a text stream.\n     * It is not necessary to close standard streams; they close automatically when the process ends. If\n     * you close a standard stream, be aware that any other pointers to that standard stream become invalid.\n     */\n    Close(): void;\n}\n\ninterface TextStreamWriter extends TextStreamBase {\n    /**\n     * Sends a string to an output stream.\n     */\n    Write(s: string): void;\n\n    /**\n     * Sends a specified number of blank lines (newline characters) to an output stream.\n     */\n    WriteBlankLines(intLines: number): void;\n\n    /**\n     * Sends a string followed by a newline character to an output stream.\n     */\n    WriteLine(s: string): void;\n}\n\ninterface TextStreamReader extends TextStreamBase {\n    /**\n     * Returns a specified number of characters from an input stream, starting at the current pointer position.\n     * Does not return until the ENTER key is pressed.\n     * Can only be used on a stream in reading mode; causes an error in writing or appending mode.\n     */\n    Read(characters: number): string;\n\n    /**\n     * Returns all characters from an input stream.\n     * Can only be used on a stream in reading mode; causes an error in writing or appending mode.\n     */\n    ReadAll(): string;\n\n    /**\n     * Returns an entire line from an input stream.\n     * Although this method extracts the newline character, it does not add it to the returned string.\n     * Can only be used on a stream in reading mode; causes an error in writing or appending mode.\n     */\n    ReadLine(): string;\n\n    /**\n     * Skips a specified number of characters when reading from an input text stream.\n     * Can only be used on a stream in reading mode; causes an error in writing or appending mode.\n     * @param characters Positive number of characters to skip forward. (Backward skipping is not supported.)\n     */\n    Skip(characters: number): void;\n\n    /**\n     * Skips the next line when reading from an input text stream.\n     * Can only be used on a stream in reading mode, not writing or appending mode.\n     */\n    SkipLine(): void;\n\n    /**\n     * Indicates whether the stream pointer position is at the end of a line.\n     */\n    AtEndOfLine: boolean;\n\n    /**\n     * Indicates whether the stream pointer position is at the end of a stream.\n     */\n    AtEndOfStream: boolean;\n}\n\ndeclare var WScript: {\n    /**\n     * Outputs text to either a message box (under WScript.exe) or the command console window followed by\n     * a newline (under CScript.exe).\n     */\n    Echo(s: any): void;\n\n    /**\n     * Exposes the write-only error output stream for the current script.\n     * Can be accessed only while using CScript.exe.\n     */\n    StdErr: TextStreamWriter;\n\n    /**\n     * Exposes the write-only output stream for the current script.\n     * Can be accessed only while using CScript.exe.\n     */\n    StdOut: TextStreamWriter;\n    Arguments: { length: number; Item(n: number): string; };\n\n    /**\n     *  The full path of the currently running script.\n     */\n    ScriptFullName: string;\n\n    /**\n     * Forces the script to stop immediately, with an optional exit code.\n     */\n    Quit(exitCode?: number): number;\n\n    /**\n     * The Windows Script Host build version number.\n     */\n    BuildVersion: number;\n\n    /**\n     * Fully qualified path of the host executable.\n     */\n    FullName: string;\n\n    /**\n     * Gets/sets the script mode - interactive(true) or batch(false).\n     */\n    Interactive: boolean;\n\n    /**\n     * The name of the host executable (WScript.exe or CScript.exe).\n     */\n    Name: string;\n\n    /**\n     * Path of the directory containing the host executable.\n     */\n    Path: string;\n\n    /**\n     * The filename of the currently running script.\n     */\n    ScriptName: string;\n\n    /**\n     * Exposes the read-only input stream for the current script.\n     * Can be accessed only while using CScript.exe.\n     */\n    StdIn: TextStreamReader;\n\n    /**\n     * Windows Script Host version\n     */\n    Version: string;\n\n    /**\n     * Connects a COM object's event sources to functions named with a given prefix, in the form prefix_event.\n     */\n    ConnectObject(objEventSource: any, strPrefix: string): void;\n\n    /**\n     * Creates a COM object.\n     * @param strProgiID\n     * @param strPrefix Function names in the form prefix_event will be bound to this object's COM events.\n     */\n    CreateObject(strProgID: string, strPrefix?: string): any;\n\n    /**\n     * Disconnects a COM object from its event sources.\n     */\n    DisconnectObject(obj: any): void;\n\n    /**\n     * Retrieves an existing object with the specified ProgID from memory, or creates a new one from a file.\n     * @param strPathname Fully qualified path to the file containing the object persisted to disk.\n     *                       For objects in memory, pass a zero-length string.\n     * @param strProgID\n     * @param strPrefix Function names in the form prefix_event will be bound to this object's COM events.\n     */\n    GetObject(strPathname: string, strProgID?: string, strPrefix?: string): any;\n\n    /**\n     * Suspends script execution for a specified length of time, then continues execution.\n     * @param intTime Interval (in milliseconds) to suspend script execution.\n     */\n    Sleep(intTime: number): void;\n};\n\n/**\n * Allows enumerating over a COM collection, which may not have indexed item access.\n */\ninterface Enumerator<T> {\n    /**\n     * Returns true if the current item is the last one in the collection, or the collection is empty,\n     * or the current item is undefined.\n     */\n    atEnd(): boolean;\n\n    /**\n     * Returns the current item in the collection\n     */\n    item(): T;\n\n    /**\n     * Resets the current item in the collection to the first item. If there are no items in the collection,\n     * the current item is set to undefined.\n     */\n    moveFirst(): void;\n\n    /**\n     * Moves the current item to the next item in the collection. If the enumerator is at the end of\n     * the collection or the collection is empty, the current item is set to undefined.\n     */\n    moveNext(): void;\n}\n\ninterface EnumeratorConstructor {\n    new <T>(collection: any): Enumerator<T>;\n    new (collection: any): Enumerator<any>;\n}\n\ndeclare var Enumerator: EnumeratorConstructor;\n\n/**\n * Enables reading from a COM safe array, which might have an alternate lower bound, or multiple dimensions.\n */\ninterface VBArray<T> {\n    /**\n     * Returns the number of dimensions (1-based).\n     */\n    dimensions(): number;\n\n    /**\n     * Takes an index for each dimension in the array, and returns the item at the corresponding location.\n     */\n    getItem(dimension1Index: number, ...dimensionNIndexes: number[]): T;\n\n    /**\n     * Returns the smallest available index for a given dimension.\n     * @param dimension 1-based dimension (defaults to 1)\n     */\n    lbound(dimension?: number): number;\n\n    /**\n     * Returns the largest available index for a given dimension.\n     * @param dimension 1-based dimension (defaults to 1)\n     */\n    ubound(dimension?: number): number;\n\n    /**\n     * Returns a Javascript array with all the elements in the VBArray. If there are multiple dimensions,\n     * each successive dimension is appended to the end of the array.\n     * Example: [[1,2,3],[4,5,6]] becomes [1,2,3,4,5,6]\n     */\n    toArray(): T[];\n}\n\ninterface VBArrayConstructor {\n    new <T>(safeArray: any): VBArray<T>;\n    new (safeArray: any): VBArray<any>;\n}\n\ndeclare var VBArray: VBArrayConstructor;\n\n/**\n * Automation date (VT_DATE)\n */\ninterface VarDate { }\n\ninterface DateConstructor {\n    new (vd: VarDate): Date;\n}\n\ninterface Date {\n    getVarDate: () => VarDate;\n}\n"}; });


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

// This is a generated file from lib.es6.d.ts

define('vs/language/typescript/lib/lib-es6-ts',[], function() { return { contents: "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved. \nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0  \n \nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE, \nMERCHANTABLITY OR NON-INFRINGEMENT. \n \nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/////////////////////////////\n/// ECMAScript APIs\n/////////////////////////////\n\ndeclare const NaN: number;\ndeclare const Infinity: number;\n\n/**\n  * Evaluates JavaScript code and executes it.\n  * @param x A String value that contains valid JavaScript code.\n  */\ndeclare function eval(x: string): any;\n\n/**\n  * Converts A string to an integer.\n  * @param s A string to convert into a number.\n  * @param radix A value between 2 and 36 that specifies the base of the number in numString.\n  * If this argument is not supplied, strings with a prefix of '0x' are considered hexadecimal.\n  * All other strings are considered decimal.\n  */\ndeclare function parseInt(s: string, radix?: number): number;\n\n/**\n  * Converts a string to a floating-point number.\n  * @param string A string that contains a floating-point number.\n  */\ndeclare function parseFloat(string: string): number;\n\n/**\n  * Returns a Boolean value that indicates whether a value is the reserved value NaN (not a number).\n  * @param number A numeric value.\n  */\ndeclare function isNaN(number: number): boolean;\n\n/**\n  * Determines whether a supplied number is finite.\n  * @param number Any numeric value.\n  */\ndeclare function isFinite(number: number): boolean;\n\n/**\n  * Gets the unencoded version of an encoded Uniform Resource Identifier (URI).\n  * @param encodedURI A value representing an encoded URI.\n  */\ndeclare function decodeURI(encodedURI: string): string;\n\n/**\n  * Gets the unencoded version of an encoded component of a Uniform Resource Identifier (URI).\n  * @param encodedURIComponent A value representing an encoded URI component.\n  */\ndeclare function decodeURIComponent(encodedURIComponent: string): string;\n\n/**\n  * Encodes a text string as a valid Uniform Resource Identifier (URI)\n  * @param uri A value representing an encoded URI.\n  */\ndeclare function encodeURI(uri: string): string;\n\n/**\n  * Encodes a text string as a valid component of a Uniform Resource Identifier (URI).\n  * @param uriComponent A value representing an encoded URI component.\n  */\ndeclare function encodeURIComponent(uriComponent: string): string;\n\ninterface PropertyDescriptor {\n    configurable?: boolean;\n    enumerable?: boolean;\n    value?: any;\n    writable?: boolean;\n    get?(): any;\n    set?(v: any): void;\n}\n\ninterface PropertyDescriptorMap {\n    [s: string]: PropertyDescriptor;\n}\n\ninterface Object {\n    /** The initial value of Object.prototype.constructor is the standard built-in Object constructor. */\n    constructor: Function;\n\n    /** Returns a string representation of an object. */\n    toString(): string;\n\n    /** Returns a date converted to a string using the current locale. */\n    toLocaleString(): string;\n\n    /** Returns the primitive value of the specified object. */\n    valueOf(): Object;\n\n    /**\n      * Determines whether an object has a property with the specified name.\n      * @param v A property name.\n      */\n    hasOwnProperty(v: string): boolean;\n\n    /**\n      * Determines whether an object exists in another object's prototype chain.\n      * @param v Another object whose prototype chain is to be checked.\n      */\n    isPrototypeOf(v: Object): boolean;\n\n    /**\n      * Determines whether a specified property is enumerable.\n      * @param v A property name.\n      */\n    propertyIsEnumerable(v: string): boolean;\n}\n\ninterface ObjectConstructor {\n    new(value?: any): Object;\n    (): any;\n    (value: any): any;\n\n    /** A reference to the prototype for a class of objects. */\n    readonly prototype: Object;\n\n    /**\n      * Returns the prototype of an object.\n      * @param o The object that references the prototype.\n      */\n    getPrototypeOf(o: any): any;\n\n    /**\n      * Gets the own property descriptor of the specified object.\n      * An own property descriptor is one that is defined directly on the object and is not inherited from the object's prototype.\n      * @param o Object that contains the property.\n      * @param p Name of the property.\n    */\n    getOwnPropertyDescriptor(o: any, p: string): PropertyDescriptor;\n\n    /**\n      * Returns the names of the own properties of an object. The own properties of an object are those that are defined directly\n      * on that object, and are not inherited from the object's prototype. The properties of an object include both fields (objects) and functions.\n      * @param o Object that contains the own properties.\n      */\n    getOwnPropertyNames(o: any): string[];\n\n    /**\n      * Creates an object that has the specified prototype or that has null prototype.\n      * @param o Object to use as a prototype. May be null.\n      */\n    create(o: object | null): any;\n\n    /**\n      * Creates an object that has the specified prototype, and that optionally contains specified properties.\n      * @param o Object to use as a prototype. May be null\n      * @param properties JavaScript object that contains one or more property descriptors.\n      */\n    create(o: object | null, properties: PropertyDescriptorMap & ThisType<any>): any;\n\n    /**\n      * Adds a property to an object, or modifies attributes of an existing property.\n      * @param o Object on which to add or modify the property. This can be a native JavaScript object (that is, a user-defined object or a built in object) or a DOM object.\n      * @param p The property name.\n      * @param attributes Descriptor for the property. It can be for a data property or an accessor property.\n      */\n    defineProperty(o: any, p: string, attributes: PropertyDescriptor & ThisType<any>): any;\n\n    /**\n      * Adds one or more properties to an object, and/or modifies attributes of existing properties.\n      * @param o Object on which to add or modify the properties. This can be a native JavaScript object or a DOM object.\n      * @param properties JavaScript object that contains one or more descriptor objects. Each descriptor object describes a data property or an accessor property.\n      */\n    defineProperties(o: any, properties: PropertyDescriptorMap & ThisType<any>): any;\n\n    /**\n      * Prevents the modification of attributes of existing properties, and prevents the addition of new properties.\n      * @param o Object on which to lock the attributes.\n      */\n    seal<T>(o: T): T;\n\n    /**\n      * Prevents the modification of existing property attributes and values, and prevents the addition of new properties.\n      * @param o Object on which to lock the attributes.\n      */\n    freeze<T>(a: T[]): ReadonlyArray<T>;\n\n    /**\n      * Prevents the modification of existing property attributes and values, and prevents the addition of new properties.\n      * @param o Object on which to lock the attributes.\n      */\n    freeze<T extends Function>(f: T): T;\n\n    /**\n      * Prevents the modification of existing property attributes and values, and prevents the addition of new properties.\n      * @param o Object on which to lock the attributes.\n      */\n    freeze<T>(o: T): Readonly<T>;\n\n    /**\n      * Prevents the addition of new properties to an object.\n      * @param o Object to make non-extensible.\n      */\n    preventExtensions<T>(o: T): T;\n\n    /**\n      * Returns true if existing property attributes cannot be modified in an object and new properties cannot be added to the object.\n      * @param o Object to test.\n      */\n    isSealed(o: any): boolean;\n\n    /**\n      * Returns true if existing property attributes and values cannot be modified in an object, and new properties cannot be added to the object.\n      * @param o Object to test.\n      */\n    isFrozen(o: any): boolean;\n\n    /**\n      * Returns a value that indicates whether new properties can be added to an object.\n      * @param o Object to test.\n      */\n    isExtensible(o: any): boolean;\n\n    /**\n      * Returns the names of the enumerable properties and methods of an object.\n      * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n      */\n    keys(o: any): string[];\n}\n\n/**\n  * Provides functionality common to all JavaScript objects.\n  */\ndeclare const Object: ObjectConstructor;\n\n/**\n  * Creates a new function.\n  */\ninterface Function {\n    /**\n      * Calls the function, substituting the specified object for the this value of the function, and the specified array for the arguments of the function.\n      * @param thisArg The object to be used as the this object.\n      * @param argArray A set of arguments to be passed to the function.\n      */\n    apply(this: Function, thisArg: any, argArray?: any): any;\n\n    /**\n      * Calls a method of an object, substituting another object for the current object.\n      * @param thisArg The object to be used as the current object.\n      * @param argArray A list of arguments to be passed to the method.\n      */\n    call(this: Function, thisArg: any, ...argArray: any[]): any;\n\n    /**\n      * For a given function, creates a bound function that has the same body as the original function.\n      * The this object of the bound function is associated with the specified object, and has the specified initial parameters.\n      * @param thisArg An object to which the this keyword can refer inside the new function.\n      * @param argArray A list of arguments to be passed to the new function.\n      */\n    bind(this: Function, thisArg: any, ...argArray: any[]): any;\n\n    /** Returns a string representation of a function. */\n    toString(): string;\n\n    prototype: any;\n    readonly length: number;\n\n    // Non-standard extensions\n    arguments: any;\n    caller: Function;\n}\n\ninterface FunctionConstructor {\n    /**\n      * Creates a new function.\n      * @param args A list of arguments the function accepts.\n      */\n    new(...args: string[]): Function;\n    (...args: string[]): Function;\n    readonly prototype: Function;\n}\n\ndeclare const Function: FunctionConstructor;\n\ninterface IArguments {\n    [index: number]: any;\n    length: number;\n    callee: Function;\n}\n\ninterface String {\n    /** Returns a string representation of a string. */\n    toString(): string;\n\n    /**\n      * Returns the character at the specified index.\n      * @param pos The zero-based index of the desired character.\n      */\n    charAt(pos: number): string;\n\n    /**\n      * Returns the Unicode value of the character at the specified location.\n      * @param index The zero-based index of the desired character. If there is no character at the specified index, NaN is returned.\n      */\n    charCodeAt(index: number): number;\n\n    /**\n      * Returns a string that contains the concatenation of two or more strings.\n      * @param strings The strings to append to the end of the string.\n      */\n    concat(...strings: string[]): string;\n\n    /**\n      * Returns the position of the first occurrence of a substring.\n      * @param searchString The substring to search for in the string\n      * @param position The index at which to begin searching the String object. If omitted, search starts at the beginning of the string.\n      */\n    indexOf(searchString: string, position?: number): number;\n\n    /**\n      * Returns the last occurrence of a substring in the string.\n      * @param searchString The substring to search for.\n      * @param position The index at which to begin searching. If omitted, the search begins at the end of the string.\n      */\n    lastIndexOf(searchString: string, position?: number): number;\n\n    /**\n      * Determines whether two strings are equivalent in the current locale.\n      * @param that String to compare to target string\n      */\n    localeCompare(that: string): number;\n\n    /**\n      * Matches a string with a regular expression, and returns an array containing the results of that search.\n      * @param regexp A variable name or string literal containing the regular expression pattern and flags.\n      */\n    match(regexp: string | RegExp): RegExpMatchArray | null;\n\n    /**\n      * Replaces text in a string, using a regular expression or search string.\n      * @param searchValue A string to search for.\n      * @param replaceValue A string containing the text to replace for every successful match of searchValue in this string.\n      */\n    replace(searchValue: string | RegExp, replaceValue: string): string;\n\n    /**\n      * Replaces text in a string, using a regular expression or search string.\n      * @param searchValue A string to search for.\n      * @param replacer A function that returns the replacement text.\n      */\n    replace(searchValue: string | RegExp, replacer: (substring: string, ...args: any[]) => string): string;\n\n    /**\n      * Finds the first substring match in a regular expression search.\n      * @param regexp The regular expression pattern and applicable flags.\n      */\n    search(regexp: string | RegExp): number;\n\n    /**\n      * Returns a section of a string.\n      * @param start The index to the beginning of the specified portion of stringObj.\n      * @param end The index to the end of the specified portion of stringObj. The substring includes the characters up to, but not including, the character indicated by end.\n      * If this value is not specified, the substring continues to the end of stringObj.\n      */\n    slice(start?: number, end?: number): string;\n\n    /**\n      * Split a string into substrings using the specified separator and return them as an array.\n      * @param separator A string that identifies character or characters to use in separating the string. If omitted, a single-element array containing the entire string is returned.\n      * @param limit A value used to limit the number of elements returned in the array.\n      */\n    split(separator: string | RegExp, limit?: number): string[];\n\n    /**\n      * Returns the substring at the specified location within a String object.\n      * @param start The zero-based index number indicating the beginning of the substring.\n      * @param end Zero-based index number indicating the end of the substring. The substring includes the characters up to, but not including, the character indicated by end.\n      * If end is omitted, the characters from start through the end of the original string are returned.\n      */\n    substring(start: number, end?: number): string;\n\n    /** Converts all the alphabetic characters in a string to lowercase. */\n    toLowerCase(): string;\n\n    /** Converts all alphabetic characters to lowercase, taking into account the host environment's current locale. */\n    toLocaleLowerCase(): string;\n\n    /** Converts all the alphabetic characters in a string to uppercase. */\n    toUpperCase(): string;\n\n    /** Returns a string where all alphabetic characters have been converted to uppercase, taking into account the host environment's current locale. */\n    toLocaleUpperCase(): string;\n\n    /** Removes the leading and trailing white space and line terminator characters from a string. */\n    trim(): string;\n\n    /** Returns the length of a String object. */\n    readonly length: number;\n\n    // IE extensions\n    /**\n      * Gets a substring beginning at the specified location and having the specified length.\n      * @param from The starting position of the desired substring. The index of the first character in the string is zero.\n      * @param length The number of characters to include in the returned substring.\n      */\n    substr(from: number, length?: number): string;\n\n    /** Returns the primitive value of the specified object. */\n    valueOf(): string;\n\n    readonly [index: number]: string;\n}\n\ninterface StringConstructor {\n    new(value?: any): String;\n    (value?: any): string;\n    readonly prototype: String;\n    fromCharCode(...codes: number[]): string;\n}\n\n/**\n  * Allows manipulation and formatting of text strings and determination and location of substrings within strings.\n  */\ndeclare const String: StringConstructor;\n\ninterface Boolean {\n    /** Returns the primitive value of the specified object. */\n    valueOf(): boolean;\n}\n\ninterface BooleanConstructor {\n    new(value?: any): Boolean;\n    (value?: any): boolean;\n    readonly prototype: Boolean;\n}\n\ndeclare const Boolean: BooleanConstructor;\n\ninterface Number {\n    /**\n      * Returns a string representation of an object.\n      * @param radix Specifies a radix for converting numeric values to strings. This value is only used for numbers.\n      */\n    toString(radix?: number): string;\n\n    /**\n      * Returns a string representing a number in fixed-point notation.\n      * @param fractionDigits Number of digits after the decimal point. Must be in the range 0 - 20, inclusive.\n      */\n    toFixed(fractionDigits?: number): string;\n\n    /**\n      * Returns a string containing a number represented in exponential notation.\n      * @param fractionDigits Number of digits after the decimal point. Must be in the range 0 - 20, inclusive.\n      */\n    toExponential(fractionDigits?: number): string;\n\n    /**\n      * Returns a string containing a number represented either in exponential or fixed-point notation with a specified number of digits.\n      * @param precision Number of significant digits. Must be in the range 1 - 21, inclusive.\n      */\n    toPrecision(precision?: number): string;\n\n    /** Returns the primitive value of the specified object. */\n    valueOf(): number;\n}\n\ninterface NumberConstructor {\n    new(value?: any): Number;\n    (value?: any): number;\n    readonly prototype: Number;\n\n    /** The largest number that can be represented in JavaScript. Equal to approximately 1.79E+308. */\n    readonly MAX_VALUE: number;\n\n    /** The closest number to zero that can be represented in JavaScript. Equal to approximately 5.00E-324. */\n    readonly MIN_VALUE: number;\n\n    /**\n      * A value that is not a number.\n      * In equality comparisons, NaN does not equal any value, including itself. To test whether a value is equivalent to NaN, use the isNaN function.\n      */\n    readonly NaN: number;\n\n    /**\n      * A value that is less than the largest negative number that can be represented in JavaScript.\n      * JavaScript displays NEGATIVE_INFINITY values as -infinity.\n      */\n    readonly NEGATIVE_INFINITY: number;\n\n    /**\n      * A value greater than the largest number that can be represented in JavaScript.\n      * JavaScript displays POSITIVE_INFINITY values as infinity.\n      */\n    readonly POSITIVE_INFINITY: number;\n}\n\n/** An object that represents a number of any kind. All JavaScript numbers are 64-bit floating-point numbers. */\ndeclare const Number: NumberConstructor;\n\ninterface TemplateStringsArray extends ReadonlyArray<string> {\n    readonly raw: ReadonlyArray<string>;\n}\n\ninterface Math {\n    /** The mathematical constant e. This is Euler's number, the base of natural logarithms. */\n    readonly E: number;\n    /** The natural logarithm of 10. */\n    readonly LN10: number;\n    /** The natural logarithm of 2. */\n    readonly LN2: number;\n    /** The base-2 logarithm of e. */\n    readonly LOG2E: number;\n    /** The base-10 logarithm of e. */\n    readonly LOG10E: number;\n    /** Pi. This is the ratio of the circumference of a circle to its diameter. */\n    readonly PI: number;\n    /** The square root of 0.5, or, equivalently, one divided by the square root of 2. */\n    readonly SQRT1_2: number;\n    /** The square root of 2. */\n    readonly SQRT2: number;\n    /**\n      * Returns the absolute value of a number (the value without regard to whether it is positive or negative).\n      * For example, the absolute value of -5 is the same as the absolute value of 5.\n      * @param x A numeric expression for which the absolute value is needed.\n      */\n    abs(x: number): number;\n    /**\n      * Returns the arc cosine (or inverse cosine) of a number.\n      * @param x A numeric expression.\n      */\n    acos(x: number): number;\n    /**\n      * Returns the arcsine of a number.\n      * @param x A numeric expression.\n      */\n    asin(x: number): number;\n    /**\n      * Returns the arctangent of a number.\n      * @param x A numeric expression for which the arctangent is needed.\n      */\n    atan(x: number): number;\n    /**\n      * Returns the angle (in radians) from the X axis to a point.\n      * @param y A numeric expression representing the cartesian y-coordinate.\n      * @param x A numeric expression representing the cartesian x-coordinate.\n      */\n    atan2(y: number, x: number): number;\n    /**\n      * Returns the smallest number greater than or equal to its numeric argument.\n      * @param x A numeric expression.\n      */\n    ceil(x: number): number;\n    /**\n      * Returns the cosine of a number.\n      * @param x A numeric expression that contains an angle measured in radians.\n      */\n    cos(x: number): number;\n    /**\n      * Returns e (the base of natural logarithms) raised to a power.\n      * @param x A numeric expression representing the power of e.\n      */\n    exp(x: number): number;\n    /**\n      * Returns the greatest number less than or equal to its numeric argument.\n      * @param x A numeric expression.\n      */\n    floor(x: number): number;\n    /**\n      * Returns the natural logarithm (base e) of a number.\n      * @param x A numeric expression.\n      */\n    log(x: number): number;\n    /**\n      * Returns the larger of a set of supplied numeric expressions.\n      * @param values Numeric expressions to be evaluated.\n      */\n    max(...values: number[]): number;\n    /**\n      * Returns the smaller of a set of supplied numeric expressions.\n      * @param values Numeric expressions to be evaluated.\n      */\n    min(...values: number[]): number;\n    /**\n      * Returns the value of a base expression taken to a specified power.\n      * @param x The base value of the expression.\n      * @param y The exponent value of the expression.\n      */\n    pow(x: number, y: number): number;\n    /** Returns a pseudorandom number between 0 and 1. */\n    random(): number;\n    /**\n      * Returns a supplied numeric expression rounded to the nearest number.\n      * @param x The value to be rounded to the nearest number.\n      */\n    round(x: number): number;\n    /**\n      * Returns the sine of a number.\n      * @param x A numeric expression that contains an angle measured in radians.\n      */\n    sin(x: number): number;\n    /**\n      * Returns the square root of a number.\n      * @param x A numeric expression.\n      */\n    sqrt(x: number): number;\n    /**\n      * Returns the tangent of a number.\n      * @param x A numeric expression that contains an angle measured in radians.\n      */\n    tan(x: number): number;\n}\n/** An intrinsic object that provides basic mathematics functionality and constants. */\ndeclare const Math: Math;\n\n/** Enables basic storage and retrieval of dates and times. */\ninterface Date {\n    /** Returns a string representation of a date. The format of the string depends on the locale. */\n    toString(): string;\n    /** Returns a date as a string value. */\n    toDateString(): string;\n    /** Returns a time as a string value. */\n    toTimeString(): string;\n    /** Returns a value as a string value appropriate to the host environment's current locale. */\n    toLocaleString(): string;\n    /** Returns a date as a string value appropriate to the host environment's current locale. */\n    toLocaleDateString(): string;\n    /** Returns a time as a string value appropriate to the host environment's current locale. */\n    toLocaleTimeString(): string;\n    /** Returns the stored time value in milliseconds since midnight, January 1, 1970 UTC. */\n    valueOf(): number;\n    /** Gets the time value in milliseconds. */\n    getTime(): number;\n    /** Gets the year, using local time. */\n    getFullYear(): number;\n    /** Gets the year using Universal Coordinated Time (UTC). */\n    getUTCFullYear(): number;\n    /** Gets the month, using local time. */\n    getMonth(): number;\n    /** Gets the month of a Date object using Universal Coordinated Time (UTC). */\n    getUTCMonth(): number;\n    /** Gets the day-of-the-month, using local time. */\n    getDate(): number;\n    /** Gets the day-of-the-month, using Universal Coordinated Time (UTC). */\n    getUTCDate(): number;\n    /** Gets the day of the week, using local time. */\n    getDay(): number;\n    /** Gets the day of the week using Universal Coordinated Time (UTC). */\n    getUTCDay(): number;\n    /** Gets the hours in a date, using local time. */\n    getHours(): number;\n    /** Gets the hours value in a Date object using Universal Coordinated Time (UTC). */\n    getUTCHours(): number;\n    /** Gets the minutes of a Date object, using local time. */\n    getMinutes(): number;\n    /** Gets the minutes of a Date object using Universal Coordinated Time (UTC). */\n    getUTCMinutes(): number;\n    /** Gets the seconds of a Date object, using local time. */\n    getSeconds(): number;\n    /** Gets the seconds of a Date object using Universal Coordinated Time (UTC). */\n    getUTCSeconds(): number;\n    /** Gets the milliseconds of a Date, using local time. */\n    getMilliseconds(): number;\n    /** Gets the milliseconds of a Date object using Universal Coordinated Time (UTC). */\n    getUTCMilliseconds(): number;\n    /** Gets the difference in minutes between the time on the local computer and Universal Coordinated Time (UTC). */\n    getTimezoneOffset(): number;\n    /**\n      * Sets the date and time value in the Date object.\n      * @param time A numeric value representing the number of elapsed milliseconds since midnight, January 1, 1970 GMT.\n      */\n    setTime(time: number): number;\n    /**\n      * Sets the milliseconds value in the Date object using local time.\n      * @param ms A numeric value equal to the millisecond value.\n      */\n    setMilliseconds(ms: number): number;\n    /**\n      * Sets the milliseconds value in the Date object using Universal Coordinated Time (UTC).\n      * @param ms A numeric value equal to the millisecond value.\n      */\n    setUTCMilliseconds(ms: number): number;\n\n    /**\n      * Sets the seconds value in the Date object using local time.\n      * @param sec A numeric value equal to the seconds value.\n      * @param ms A numeric value equal to the milliseconds value.\n      */\n    setSeconds(sec: number, ms?: number): number;\n    /**\n      * Sets the seconds value in the Date object using Universal Coordinated Time (UTC).\n      * @param sec A numeric value equal to the seconds value.\n      * @param ms A numeric value equal to the milliseconds value.\n      */\n    setUTCSeconds(sec: number, ms?: number): number;\n    /**\n      * Sets the minutes value in the Date object using local time.\n      * @param min A numeric value equal to the minutes value.\n      * @param sec A numeric value equal to the seconds value.\n      * @param ms A numeric value equal to the milliseconds value.\n      */\n    setMinutes(min: number, sec?: number, ms?: number): number;\n    /**\n      * Sets the minutes value in the Date object using Universal Coordinated Time (UTC).\n      * @param min A numeric value equal to the minutes value.\n      * @param sec A numeric value equal to the seconds value.\n      * @param ms A numeric value equal to the milliseconds value.\n      */\n    setUTCMinutes(min: number, sec?: number, ms?: number): number;\n    /**\n      * Sets the hour value in the Date object using local time.\n      * @param hours A numeric value equal to the hours value.\n      * @param min A numeric value equal to the minutes value.\n      * @param sec A numeric value equal to the seconds value.\n      * @param ms A numeric value equal to the milliseconds value.\n      */\n    setHours(hours: number, min?: number, sec?: number, ms?: number): number;\n    /**\n      * Sets the hours value in the Date object using Universal Coordinated Time (UTC).\n      * @param hours A numeric value equal to the hours value.\n      * @param min A numeric value equal to the minutes value.\n      * @param sec A numeric value equal to the seconds value.\n      * @param ms A numeric value equal to the milliseconds value.\n      */\n    setUTCHours(hours: number, min?: number, sec?: number, ms?: number): number;\n    /**\n      * Sets the numeric day-of-the-month value of the Date object using local time.\n      * @param date A numeric value equal to the day of the month.\n      */\n    setDate(date: number): number;\n    /**\n      * Sets the numeric day of the month in the Date object using Universal Coordinated Time (UTC).\n      * @param date A numeric value equal to the day of the month.\n      */\n    setUTCDate(date: number): number;\n    /**\n      * Sets the month value in the Date object using local time.\n      * @param month A numeric value equal to the month. The value for January is 0, and other month values follow consecutively.\n      * @param date A numeric value representing the day of the month. If this value is not supplied, the value from a call to the getDate method is used.\n      */\n    setMonth(month: number, date?: number): number;\n    /**\n      * Sets the month value in the Date object using Universal Coordinated Time (UTC).\n      * @param month A numeric value equal to the month. The value for January is 0, and other month values follow consecutively.\n      * @param date A numeric value representing the day of the month. If it is not supplied, the value from a call to the getUTCDate method is used.\n      */\n    setUTCMonth(month: number, date?: number): number;\n    /**\n      * Sets the year of the Date object using local time.\n      * @param year A numeric value for the year.\n      * @param month A zero-based numeric value for the month (0 for January, 11 for December). Must be specified if numDate is specified.\n      * @param date A numeric value equal for the day of the month.\n      */\n    setFullYear(year: number, month?: number, date?: number): number;\n    /**\n      * Sets the year value in the Date object using Universal Coordinated Time (UTC).\n      * @param year A numeric value equal to the year.\n      * @param month A numeric value equal to the month. The value for January is 0, and other month values follow consecutively. Must be supplied if numDate is supplied.\n      * @param date A numeric value equal to the day of the month.\n      */\n    setUTCFullYear(year: number, month?: number, date?: number): number;\n    /** Returns a date converted to a string using Universal Coordinated Time (UTC). */\n    toUTCString(): string;\n    /** Returns a date as a string value in ISO format. */\n    toISOString(): string;\n    /** Used by the JSON.stringify method to enable the transformation of an object's data for JavaScript Object Notation (JSON) serialization. */\n    toJSON(key?: any): string;\n}\n\ninterface DateConstructor {\n    new(): Date;\n    new(value: number): Date;\n    new(value: string): Date;\n    new(year: number, month: number, date?: number, hours?: number, minutes?: number, seconds?: number, ms?: number): Date;\n    (): string;\n    readonly prototype: Date;\n    /**\n      * Parses a string containing a date, and returns the number of milliseconds between that date and midnight, January 1, 1970.\n      * @param s A date string\n      */\n    parse(s: string): number;\n    /**\n      * Returns the number of milliseconds between midnight, January 1, 1970 Universal Coordinated Time (UTC) (or GMT) and the specified date.\n      * @param year The full year designation is required for cross-century date accuracy. If year is between 0 and 99 is used, then year is assumed to be 1900 + year.\n      * @param month The month as an number between 0 and 11 (January to December).\n      * @param date The date as an number between 1 and 31.\n      * @param hours Must be supplied if minutes is supplied. An number from 0 to 23 (midnight to 11pm) that specifies the hour.\n      * @param minutes Must be supplied if seconds is supplied. An number from 0 to 59 that specifies the minutes.\n      * @param seconds Must be supplied if milliseconds is supplied. An number from 0 to 59 that specifies the seconds.\n      * @param ms An number from 0 to 999 that specifies the milliseconds.\n      */\n    UTC(year: number, month: number, date?: number, hours?: number, minutes?: number, seconds?: number, ms?: number): number;\n    now(): number;\n}\n\ndeclare const Date: DateConstructor;\n\ninterface RegExpMatchArray extends Array<string> {\n    index?: number;\n    input?: string;\n}\n\ninterface RegExpExecArray extends Array<string> {\n    index: number;\n    input: string;\n}\n\ninterface RegExp {\n    /**\n      * Executes a search on a string using a regular expression pattern, and returns an array containing the results of that search.\n      * @param string The String object or string literal on which to perform the search.\n      */\n    exec(string: string): RegExpExecArray | null;\n\n    /**\n      * Returns a Boolean value that indicates whether or not a pattern exists in a searched string.\n      * @param string String on which to perform the search.\n      */\n    test(string: string): boolean;\n\n    /** Returns a copy of the text of the regular expression pattern. Read-only. The regExp argument is a Regular expression object. It can be a variable name or a literal. */\n    readonly source: string;\n\n    /** Returns a Boolean value indicating the state of the global flag (g) used with a regular expression. Default is false. Read-only. */\n    readonly global: boolean;\n\n    /** Returns a Boolean value indicating the state of the ignoreCase flag (i) used with a regular expression. Default is false. Read-only. */\n    readonly ignoreCase: boolean;\n\n    /** Returns a Boolean value indicating the state of the multiline flag (m) used with a regular expression. Default is false. Read-only. */\n    readonly multiline: boolean;\n\n    lastIndex: number;\n\n    // Non-standard extensions\n    compile(): this;\n}\n\ninterface RegExpConstructor {\n    new(pattern: RegExp | string): RegExp;\n    new(pattern: string, flags?: string): RegExp;\n    (pattern: RegExp | string): RegExp;\n    (pattern: string, flags?: string): RegExp;\n    readonly prototype: RegExp;\n\n    // Non-standard extensions\n    $1: string;\n    $2: string;\n    $3: string;\n    $4: string;\n    $5: string;\n    $6: string;\n    $7: string;\n    $8: string;\n    $9: string;\n    lastMatch: string;\n}\n\ndeclare const RegExp: RegExpConstructor;\n\ninterface Error {\n    name: string;\n    message: string;\n    stack?: string;\n}\n\ninterface ErrorConstructor {\n    new(message?: string): Error;\n    (message?: string): Error;\n    readonly prototype: Error;\n}\n\ndeclare const Error: ErrorConstructor;\n\ninterface EvalError extends Error {\n}\n\ninterface EvalErrorConstructor {\n    new(message?: string): EvalError;\n    (message?: string): EvalError;\n    readonly prototype: EvalError;\n}\n\ndeclare const EvalError: EvalErrorConstructor;\n\ninterface RangeError extends Error {\n}\n\ninterface RangeErrorConstructor {\n    new(message?: string): RangeError;\n    (message?: string): RangeError;\n    readonly prototype: RangeError;\n}\n\ndeclare const RangeError: RangeErrorConstructor;\n\ninterface ReferenceError extends Error {\n}\n\ninterface ReferenceErrorConstructor {\n    new(message?: string): ReferenceError;\n    (message?: string): ReferenceError;\n    readonly prototype: ReferenceError;\n}\n\ndeclare const ReferenceError: ReferenceErrorConstructor;\n\ninterface SyntaxError extends Error {\n}\n\ninterface SyntaxErrorConstructor {\n    new(message?: string): SyntaxError;\n    (message?: string): SyntaxError;\n    readonly prototype: SyntaxError;\n}\n\ndeclare const SyntaxError: SyntaxErrorConstructor;\n\ninterface TypeError extends Error {\n}\n\ninterface TypeErrorConstructor {\n    new(message?: string): TypeError;\n    (message?: string): TypeError;\n    readonly prototype: TypeError;\n}\n\ndeclare const TypeError: TypeErrorConstructor;\n\ninterface URIError extends Error {\n}\n\ninterface URIErrorConstructor {\n    new(message?: string): URIError;\n    (message?: string): URIError;\n    readonly prototype: URIError;\n}\n\ndeclare const URIError: URIErrorConstructor;\n\ninterface JSON {\n    /**\n      * Converts a JavaScript Object Notation (JSON) string into an object.\n      * @param text A valid JSON string.\n      * @param reviver A function that transforms the results. This function is called for each member of the object.\n      * If a member contains nested objects, the nested objects are transformed before the parent object is.\n      */\n    parse(text: string, reviver?: (key: any, value: any) => any): any;\n    /**\n      * Converts a JavaScript value to a JavaScript Object Notation (JSON) string.\n      * @param value A JavaScript value, usually an object or array, to be converted.\n      * @param replacer A function that transforms the results.\n      * @param space Adds indentation, white space, and line break characters to the return-value JSON text to make it easier to read.\n      */\n    stringify(value: any, replacer?: (key: string, value: any) => any, space?: string | number): string;\n    /**\n      * Converts a JavaScript value to a JavaScript Object Notation (JSON) string.\n      * @param value A JavaScript value, usually an object or array, to be converted.\n      * @param replacer An array of strings and numbers that acts as a approved list for selecting the object properties that will be stringified.\n      * @param space Adds indentation, white space, and line break characters to the return-value JSON text to make it easier to read.\n      */\n    stringify(value: any, replacer?: (number | string)[] | null, space?: string | number): string;\n}\n\n/**\n  * An intrinsic object that provides functions to convert JavaScript values to and from the JavaScript Object Notation (JSON) format.\n  */\ndeclare const JSON: JSON;\n\n\n/////////////////////////////\n/// ECMAScript Array API (specially handled by compiler)\n/////////////////////////////\n\ninterface ReadonlyArray<T> {\n    /**\n      * Gets the length of the array. This is a number one higher than the highest element defined in an array.\n      */\n    readonly length: number;\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n    /**\n      * Returns a string representation of an array. The elements are converted to string using thier toLocalString methods.\n      */\n    toLocaleString(): string;\n    /**\n      * Combines two or more arrays.\n      * @param items Additional items to add to the end of array1.\n      */\n    concat(...items: T[][]): T[];\n    /**\n      * Combines two or more arrays.\n      * @param items Additional items to add to the end of array1.\n      */\n    concat(...items: (T | T[])[]): T[];\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): T[];\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the search starts at index 0.\n      */\n    indexOf(searchElement: T, fromIndex?: number): number;\n    /**\n      * Returns the index of the last occurrence of a specified value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the search starts at the last index in the array.\n      */\n    lastIndexOf(searchElement: T, fromIndex?: number): number;\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls the callbackfn function for each element in array1 until the callbackfn returns false, or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: T, index: number, array: ReadonlyArray<T>) => boolean, thisArg?: any): boolean;\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the callbackfn function for each element in array1 until the callbackfn returns true, or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: T, index: number, array: ReadonlyArray<T>) => boolean, thisArg?: any): boolean;\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: T, index: number, array: ReadonlyArray<T>) => void, thisArg?: any): void;\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    map<U>(callbackfn: (value: T, index: number, array: ReadonlyArray<T>) => U, thisArg?: any): U[];\n    /**\n     * Returns the elements of an array that meet the condition specified in a callback function.\n     * @param callbackfn A function that accepts up to three arguments. The filter method calls the callbackfn function one time for each element in the array.\n     * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n     */\n    filter<S extends T>(callbackfn: (value: T, index: number, array: ReadonlyArray<T>) => value is S, thisArg?: any): S[];\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: T, index: number, array: ReadonlyArray<T>) => any, thisArg?: any): T[];\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: ReadonlyArray<T>) => T, initialValue?: T): T;\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: ReadonlyArray<T>) => U, initialValue: U): U;\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: ReadonlyArray<T>) => T, initialValue?: T): T;\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: ReadonlyArray<T>) => U, initialValue: U): U;\n\n    readonly [n: number]: T;\n}\n\ninterface Array<T> {\n    /**\n      * Gets or sets the length of the array. This is a number one higher than the highest element defined in an array.\n      */\n    length: number;\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n    /**\n      * Returns a string representation of an array. The elements are converted to string using thier toLocalString methods.\n      */\n    toLocaleString(): string;\n    /**\n      * Appends new elements to an array, and returns the new length of the array.\n      * @param items New elements of the Array.\n      */\n    push(...items: T[]): number;\n    /**\n      * Removes the last element from an array and returns it.\n      */\n    pop(): T | undefined;\n    /**\n      * Combines two or more arrays.\n      * @param items Additional items to add to the end of array1.\n      */\n    concat(...items: T[][]): T[];\n    /**\n      * Combines two or more arrays.\n      * @param items Additional items to add to the end of array1.\n      */\n    concat(...items: (T | T[])[]): T[];\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): T[];\n    /**\n      * Removes the first element from an array and returns it.\n      */\n    shift(): T | undefined;\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): T[];\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: T, b: T) => number): this;\n    /**\n      * Removes elements from an array and, if necessary, inserts new elements in their place, returning the deleted elements.\n      * @param start The zero-based location in the array from which to start removing elements.\n      * @param deleteCount The number of elements to remove.\n      */\n    splice(start: number, deleteCount?: number): T[];\n    /**\n      * Removes elements from an array and, if necessary, inserts new elements in their place, returning the deleted elements.\n      * @param start The zero-based location in the array from which to start removing elements.\n      * @param deleteCount The number of elements to remove.\n      * @param items Elements to insert into the array in place of the deleted elements.\n      */\n    splice(start: number, deleteCount: number, ...items: T[]): T[];\n    /**\n      * Inserts new elements at the start of an array.\n      * @param items  Elements to insert at the start of the Array.\n      */\n    unshift(...items: T[]): number;\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the search starts at index 0.\n      */\n    indexOf(searchElement: T, fromIndex?: number): number;\n    /**\n      * Returns the index of the last occurrence of a specified value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the search starts at the last index in the array.\n      */\n    lastIndexOf(searchElement: T, fromIndex?: number): number;\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls the callbackfn function for each element in array1 until the callbackfn returns false, or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: T, index: number, array: T[]) => boolean, thisArg?: any): boolean;\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the callbackfn function for each element in array1 until the callbackfn returns true, or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: T, index: number, array: T[]) => boolean, thisArg?: any): boolean;\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: T, index: number, array: T[]) => void, thisArg?: any): void;\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    map<U>(callbackfn: (value: T, index: number, array: T[]) => U, thisArg?: any): U[];\n    /**\n     * Returns the elements of an array that meet the condition specified in a callback function.\n     * @param callbackfn A function that accepts up to three arguments. The filter method calls the callbackfn function one time for each element in the array.\n     * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n     */\n    filter<S extends T>(callbackfn: (value: T, index: number, array: T[]) => value is S, thisArg?: any): S[];\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: T, index: number, array: T[]) => any, thisArg?: any): T[];\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: T[]) => T, initialValue?: T): T;\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: T[]) => U, initialValue: U): U;\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: T[]) => T, initialValue?: T): T;\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: T[]) => U, initialValue: U): U;\n\n    [n: number]: T;\n}\n\ninterface ArrayConstructor {\n    new(arrayLength?: number): any[];\n    new <T>(arrayLength: number): T[];\n    new <T>(...items: T[]): T[];\n    (arrayLength?: number): any[];\n    <T>(arrayLength: number): T[];\n    <T>(...items: T[]): T[];\n    isArray(arg: any): arg is Array<any>;\n    readonly prototype: Array<any>;\n}\n\ndeclare const Array: ArrayConstructor;\n\ninterface TypedPropertyDescriptor<T> {\n    enumerable?: boolean;\n    configurable?: boolean;\n    writable?: boolean;\n    value?: T;\n    get?: () => T;\n    set?: (value: T) => void;\n}\n\ndeclare type ClassDecorator = <TFunction extends Function>(target: TFunction) => TFunction | void;\ndeclare type PropertyDecorator = (target: Object, propertyKey: string | symbol) => void;\ndeclare type MethodDecorator = <T>(target: Object, propertyKey: string | symbol, descriptor: TypedPropertyDescriptor<T>) => TypedPropertyDescriptor<T> | void;\ndeclare type ParameterDecorator = (target: Object, propertyKey: string | symbol, parameterIndex: number) => void;\n\ndeclare type PromiseConstructorLike = new <T>(executor: (resolve: (value?: T | PromiseLike<T>) => void, reject: (reason?: any) => void) => void) => PromiseLike<T>;\n\ninterface PromiseLike<T> {\n    /**\n     * Attaches callbacks for the resolution and/or rejection of the Promise.\n     * @param onfulfilled The callback to execute when the Promise is resolved.\n     * @param onrejected The callback to execute when the Promise is rejected.\n     * @returns A Promise for the completion of which ever callback is executed.\n     */\n    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): PromiseLike<TResult1 | TResult2>;\n}\n\n/**\n * Represents the completion of an asynchronous operation\n */\ninterface Promise<T> {\n    /**\n     * Attaches callbacks for the resolution and/or rejection of the Promise.\n     * @param onfulfilled The callback to execute when the Promise is resolved.\n     * @param onrejected The callback to execute when the Promise is rejected.\n     * @returns A Promise for the completion of which ever callback is executed.\n     */\n    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;\n\n    /**\n     * Attaches a callback for only the rejection of the Promise.\n     * @param onrejected The callback to execute when the Promise is rejected.\n     * @returns A Promise for the completion of the callback.\n     */\n    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<T | TResult>;\n}\n\ninterface ArrayLike<T> {\n    readonly length: number;\n    readonly [n: number]: T;\n}\n\n/**\n * Make all properties in T optional\n */\ntype Partial<T> = {\n    [P in keyof T]?: T[P];\n};\n\n/**\n * Make all properties in T readonly\n */\ntype Readonly<T> = {\n    readonly [P in keyof T]: T[P];\n};\n\n/**\n * From T pick a set of properties K\n */\ntype Pick<T, K extends keyof T> = {\n    [P in K]: T[P];\n};\n\n/**\n * Construct a type with a set of properties K of type T\n */\ntype Record<K extends string, T> = {\n    [P in K]: T;\n};\n\n/**\n * Marker for contextual 'this' type\n */\ninterface ThisType<T> { }\n\n/**\n  * Represents a raw buffer of binary data, which is used to store data for the\n  * different typed arrays. ArrayBuffers cannot be read from or written to directly,\n  * but can be passed to a typed array or DataView Object to interpret the raw\n  * buffer as needed.\n  */\ninterface ArrayBuffer {\n    /**\n      * Read-only. The length of the ArrayBuffer (in bytes).\n      */\n    readonly byteLength: number;\n\n    /**\n      * Returns a section of an ArrayBuffer.\n      */\n    slice(begin: number, end?: number): ArrayBuffer;\n}\n\n/**\n * Allowed ArrayBuffer types for the buffer of an ArrayBufferView and related Typed Arrays.\n */\ninterface ArrayBufferTypes {\n    ArrayBuffer: ArrayBuffer;\n}\ntype ArrayBufferLike = ArrayBufferTypes[keyof ArrayBufferTypes];\n\ninterface ArrayBufferConstructor {\n    readonly prototype: ArrayBuffer;\n    new(byteLength: number): ArrayBuffer;\n    isView(arg: any): arg is ArrayBufferView;\n}\ndeclare const ArrayBuffer: ArrayBufferConstructor;\n\ninterface ArrayBufferView {\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    byteOffset: number;\n}\n\ninterface DataView {\n    readonly buffer: ArrayBuffer;\n    readonly byteLength: number;\n    readonly byteOffset: number;\n    /**\n      * Gets the Float32 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getFloat32(byteOffset: number, littleEndian?: boolean): number;\n\n    /**\n      * Gets the Float64 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getFloat64(byteOffset: number, littleEndian?: boolean): number;\n\n    /**\n      * Gets the Int8 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getInt8(byteOffset: number): number;\n\n    /**\n      * Gets the Int16 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getInt16(byteOffset: number, littleEndian?: boolean): number;\n    /**\n      * Gets the Int32 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getInt32(byteOffset: number, littleEndian?: boolean): number;\n\n    /**\n      * Gets the Uint8 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getUint8(byteOffset: number): number;\n\n    /**\n      * Gets the Uint16 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getUint16(byteOffset: number, littleEndian?: boolean): number;\n\n    /**\n      * Gets the Uint32 value at the specified byte offset from the start of the view. There is\n      * no alignment constraint; multi-byte values may be fetched from any offset.\n      * @param byteOffset The place in the buffer at which the value should be retrieved.\n      */\n    getUint32(byteOffset: number, littleEndian?: boolean): number;\n\n    /**\n      * Stores an Float32 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      * @param littleEndian If false or undefined, a big-endian value should be written,\n      * otherwise a little-endian value should be written.\n      */\n    setFloat32(byteOffset: number, value: number, littleEndian?: boolean): void;\n\n    /**\n      * Stores an Float64 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      * @param littleEndian If false or undefined, a big-endian value should be written,\n      * otherwise a little-endian value should be written.\n      */\n    setFloat64(byteOffset: number, value: number, littleEndian?: boolean): void;\n\n    /**\n      * Stores an Int8 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      */\n    setInt8(byteOffset: number, value: number): void;\n\n    /**\n      * Stores an Int16 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      * @param littleEndian If false or undefined, a big-endian value should be written,\n      * otherwise a little-endian value should be written.\n      */\n    setInt16(byteOffset: number, value: number, littleEndian?: boolean): void;\n\n    /**\n      * Stores an Int32 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      * @param littleEndian If false or undefined, a big-endian value should be written,\n      * otherwise a little-endian value should be written.\n      */\n    setInt32(byteOffset: number, value: number, littleEndian?: boolean): void;\n\n    /**\n      * Stores an Uint8 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      */\n    setUint8(byteOffset: number, value: number): void;\n\n    /**\n      * Stores an Uint16 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      * @param littleEndian If false or undefined, a big-endian value should be written,\n      * otherwise a little-endian value should be written.\n      */\n    setUint16(byteOffset: number, value: number, littleEndian?: boolean): void;\n\n    /**\n      * Stores an Uint32 value at the specified byte offset from the start of the view.\n      * @param byteOffset The place in the buffer at which the value should be set.\n      * @param value The value to set.\n      * @param littleEndian If false or undefined, a big-endian value should be written,\n      * otherwise a little-endian value should be written.\n      */\n    setUint32(byteOffset: number, value: number, littleEndian?: boolean): void;\n}\n\ninterface DataViewConstructor {\n    new(buffer: ArrayBufferLike, byteOffset?: number, byteLength?: number): DataView;\n}\ndeclare const DataView: DataViewConstructor;\n\n/**\n  * A typed array of 8-bit integer values. The contents are initialized to 0. If the requested\n  * number of bytes could not be allocated an exception is raised.\n  */\ninterface Int8Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Int8Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Int8Array) => any, thisArg?: any): Int8Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Int8Array) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Int8Array) => number, thisArg?: any): Int8Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Int8Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Int8Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Int8Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Int8Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Int8Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Int8Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Int8Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Int8Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Int8Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\ninterface Int8ArrayConstructor {\n    readonly prototype: Int8Array;\n    new(length: number): Int8Array;\n    new(array: ArrayLike<number>): Int8Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Int8Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Int8Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Int8Array;\n\n\n}\ndeclare const Int8Array: Int8ArrayConstructor;\n\n/**\n  * A typed array of 8-bit unsigned integer values. The contents are initialized to 0. If the\n  * requested number of bytes could not be allocated an exception is raised.\n  */\ninterface Uint8Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Uint8Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Uint8Array) => any, thisArg?: any): Uint8Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Uint8Array) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Uint8Array) => number, thisArg?: any): Uint8Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint8Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint8Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint8Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint8Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Uint8Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Uint8Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Uint8Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Uint8Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Uint8Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Uint8ArrayConstructor {\n    readonly prototype: Uint8Array;\n    new(length: number): Uint8Array;\n    new(array: ArrayLike<number>): Uint8Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Uint8Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Uint8Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint8Array;\n\n}\ndeclare const Uint8Array: Uint8ArrayConstructor;\n\n/**\n  * A typed array of 8-bit unsigned integer (clamped) values. The contents are initialized to 0.\n  * If the requested number of bytes could not be allocated an exception is raised.\n  */\ninterface Uint8ClampedArray {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Uint8ClampedArray) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Uint8ClampedArray) => any, thisArg?: any): Uint8ClampedArray;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Uint8ClampedArray) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Uint8ClampedArray) => number, thisArg?: any): Uint8ClampedArray;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint8ClampedArray) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint8ClampedArray) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint8ClampedArray) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint8ClampedArray) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Uint8ClampedArray;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Uint8ClampedArray;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Uint8ClampedArray) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Uint8ClampedArray view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Uint8ClampedArray;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Uint8ClampedArrayConstructor {\n    readonly prototype: Uint8ClampedArray;\n    new(length: number): Uint8ClampedArray;\n    new(array: ArrayLike<number>): Uint8ClampedArray;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Uint8ClampedArray;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Uint8ClampedArray;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint8ClampedArray;\n}\ndeclare const Uint8ClampedArray: Uint8ClampedArrayConstructor;\n\n/**\n  * A typed array of 16-bit signed integer values. The contents are initialized to 0. If the\n  * requested number of bytes could not be allocated an exception is raised.\n  */\ninterface Int16Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Int16Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (this: void, value: number, index: number, array: Int16Array) => any, thisArg?: any): Int16Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Int16Array) => void, thisArg?: any): void;\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Int16Array) => number, thisArg?: any): Int16Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Int16Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Int16Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Int16Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Int16Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Int16Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Int16Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Int16Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Int16Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Int16Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Int16ArrayConstructor {\n    readonly prototype: Int16Array;\n    new(length: number): Int16Array;\n    new(array: ArrayLike<number>): Int16Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Int16Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Int16Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Int16Array;\n\n\n}\ndeclare const Int16Array: Int16ArrayConstructor;\n\n/**\n  * A typed array of 16-bit unsigned integer values. The contents are initialized to 0. If the\n  * requested number of bytes could not be allocated an exception is raised.\n  */\ninterface Uint16Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Uint16Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Uint16Array) => any, thisArg?: any): Uint16Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Uint16Array) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Uint16Array) => number, thisArg?: any): Uint16Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint16Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint16Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint16Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint16Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Uint16Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Uint16Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Uint16Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Uint16Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Uint16Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Uint16ArrayConstructor {\n    readonly prototype: Uint16Array;\n    new(length: number): Uint16Array;\n    new(array: ArrayLike<number>): Uint16Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Uint16Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Uint16Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint16Array;\n\n\n}\ndeclare const Uint16Array: Uint16ArrayConstructor;\n/**\n  * A typed array of 32-bit signed integer values. The contents are initialized to 0. If the\n  * requested number of bytes could not be allocated an exception is raised.\n  */\ninterface Int32Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Int32Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Int32Array) => any, thisArg?: any): Int32Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Int32Array) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (value: number, index: number, array: Int32Array) => number, thisArg?: any): Int32Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Int32Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Int32Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Int32Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Int32Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Int32Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Int32Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Int32Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Int32Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Int32Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Int32ArrayConstructor {\n    readonly prototype: Int32Array;\n    new(length: number): Int32Array;\n    new(array: ArrayLike<number>): Int32Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Int32Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Int32Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Int32Array;\n\n}\ndeclare const Int32Array: Int32ArrayConstructor;\n\n/**\n  * A typed array of 32-bit unsigned integer values. The contents are initialized to 0. If the\n  * requested number of bytes could not be allocated an exception is raised.\n  */\ninterface Uint32Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Uint32Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Uint32Array) => any, thisArg?: any): Uint32Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Uint32Array) => void, thisArg?: any): void;\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Uint32Array) => number, thisArg?: any): Uint32Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint32Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint32Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Uint32Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Uint32Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Uint32Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Uint32Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Uint32Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Uint32Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Uint32Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Uint32ArrayConstructor {\n    readonly prototype: Uint32Array;\n    new(length: number): Uint32Array;\n    new(array: ArrayLike<number>): Uint32Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Uint32Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Uint32Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint32Array;\n\n}\ndeclare const Uint32Array: Uint32ArrayConstructor;\n\n/**\n  * A typed array of 32-bit float values. The contents are initialized to 0. If the requested number\n  * of bytes could not be allocated an exception is raised.\n  */\ninterface Float32Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Float32Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Float32Array) => any, thisArg?: any): Float32Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Float32Array) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Float32Array) => number, thisArg?: any): Float32Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Float32Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Float32Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Float32Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Float32Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Float32Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Float32Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Float32Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Float32Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Float32Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Float32ArrayConstructor {\n    readonly prototype: Float32Array;\n    new(length: number): Float32Array;\n    new(array: ArrayLike<number>): Float32Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Float32Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Float32Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Float32Array;\n\n\n}\ndeclare const Float32Array: Float32ArrayConstructor;\n\n/**\n  * A typed array of 64-bit float values. The contents are initialized to 0. If the requested\n  * number of bytes could not be allocated an exception is raised.\n  */\ninterface Float64Array {\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * The ArrayBuffer instance referenced by the array.\n      */\n    readonly buffer: ArrayBufferLike;\n\n    /**\n      * The length in bytes of the array.\n      */\n    readonly byteLength: number;\n\n    /**\n      * The offset in bytes of the array.\n      */\n    readonly byteOffset: number;\n\n    /**\n      * Returns the this object after copying a section of the array identified by start and end\n      * to the same array starting at position target\n      * @param target If target is negative, it is treated as length+target where length is the\n      * length of the array.\n      * @param start If start is negative, it is treated as length+start. If end is negative, it\n      * is treated as length+end.\n      * @param end If not specified, length of the this object is used as its default value.\n      */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /**\n      * Determines whether all the members of an array satisfy the specified test.\n      * @param callbackfn A function that accepts up to three arguments. The every method calls\n      * the callbackfn function for each element in array1 until the callbackfn returns false,\n      * or until the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    every(callbackfn: (value: number, index: number, array: Float64Array) => boolean, thisArg?: any): boolean;\n\n    /**\n        * Returns the this object after filling the section identified by start and end with value\n        * @param value value to fill array section with\n        * @param start index to start filling the array at. If start is negative, it is treated as\n        * length+start where length is the length of the array.\n        * @param end index to stop filling the array at. If end is negative, it is treated as\n        * length+end.\n        */\n    fill(value: number, start?: number, end?: number): this;\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to three arguments. The filter method calls\n      * the callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    filter(callbackfn: (value: number, index: number, array: Float64Array) => any, thisArg?: any): Float64Array;\n\n    /**\n      * Returns the value of the first element in the array where predicate is true, and undefined\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found, find\n      * immediately returns that element value. Otherwise, find returns undefined.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    find(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number | undefined;\n\n    /**\n      * Returns the index of the first element in the array where predicate is true, and -1\n      * otherwise.\n      * @param predicate find calls predicate once for each element of the array, in ascending\n      * order, until it finds one where predicate returns true. If such an element is found,\n      * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n      * @param thisArg If provided, it will be used as the this value for each invocation of\n      * predicate. If it is not provided, undefined is used instead.\n      */\n    findIndex(predicate: (value: number, index: number, obj: Array<number>) => boolean, thisArg?: any): number;\n\n    /**\n      * Performs the specified action for each element in an array.\n      * @param callbackfn  A function that accepts up to three arguments. forEach calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg  An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    forEach(callbackfn: (value: number, index: number, array: Float64Array) => void, thisArg?: any): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      *  search starts at index 0.\n      */\n    indexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * Adds all the elements of an array separated by the specified separator string.\n      * @param separator A string used to separate one element of an array from the next in the\n      * resulting String. If omitted, the array elements are separated with a comma.\n      */\n    join(separator?: string): string;\n\n    /**\n      * Returns the index of the last occurrence of a value in an array.\n      * @param searchElement The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the\n      * search starts at index 0.\n      */\n    lastIndexOf(searchElement: number, fromIndex?: number): number;\n\n    /**\n      * The length of the array.\n      */\n    readonly length: number;\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that\n      * contains the results.\n      * @param callbackfn A function that accepts up to three arguments. The map method calls the\n      * callbackfn function one time for each element in the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    map(callbackfn: (this: void, value: number, index: number, array: Float64Array) => number, thisArg?: any): Float64Array;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Float64Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of\n      * the callback function is the accumulated result, and is provided as an argument in the next\n      * call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduce method calls the\n      * callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduce<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Float64Array) => U, initialValue: U): U;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an\n      * argument instead of an array value.\n      */\n    reduceRight(callbackfn: (previousValue: number, currentValue: number, currentIndex: number, array: Float64Array) => number, initialValue?: number): number;\n\n    /**\n      * Calls the specified callback function for all the elements in an array, in descending order.\n      * The return value of the callback function is the accumulated result, and is provided as an\n      * argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls\n      * the callbackfn function one time for each element in the array.\n      * @param initialValue If initialValue is specified, it is used as the initial value to start\n      * the accumulation. The first call to the callbackfn function provides this value as an argument\n      * instead of an array value.\n      */\n    reduceRight<U>(callbackfn: (previousValue: U, currentValue: number, currentIndex: number, array: Float64Array) => U, initialValue: U): U;\n\n    /**\n      * Reverses the elements in an Array.\n      */\n    reverse(): Float64Array;\n\n    /**\n      * Sets a value or an array of values.\n      * @param array A typed or untyped array of values to set.\n      * @param offset The index in the current array at which the values are to be written.\n      */\n    set(array: ArrayLike<number>, offset?: number): void;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array.\n      * @param end The end of the specified portion of the array.\n      */\n    slice(start?: number, end?: number): Float64Array;\n\n    /**\n      * Determines whether the specified callback function returns true for any element of an array.\n      * @param callbackfn A function that accepts up to three arguments. The some method calls the\n      * callbackfn function for each element in array1 until the callbackfn returns true, or until\n      * the end of the array.\n      * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n      * If thisArg is omitted, undefined is used as the this value.\n      */\n    some(callbackfn: (value: number, index: number, array: Float64Array) => boolean, thisArg?: any): boolean;\n\n    /**\n      * Sorts an array.\n      * @param compareFn The name of the function used to determine the order of the elements. If\n      * omitted, the elements are sorted in ascending, ASCII character order.\n      */\n    sort(compareFn?: (a: number, b: number) => number): this;\n\n    /**\n      * Gets a new Float64Array view of the ArrayBuffer store for this array, referencing the elements\n      * at begin, inclusive, up to end, exclusive.\n      * @param begin The index of the beginning of the array.\n      * @param end The index of the end of the array.\n      */\n    subarray(begin: number, end?: number): Float64Array;\n\n    /**\n      * Converts a number to a string by using the current locale.\n      */\n    toLocaleString(): string;\n\n    /**\n      * Returns a string representation of an array.\n      */\n    toString(): string;\n\n    [index: number]: number;\n}\n\ninterface Float64ArrayConstructor {\n    readonly prototype: Float64Array;\n    new(length: number): Float64Array;\n    new(array: ArrayLike<number>): Float64Array;\n    new(buffer: ArrayBufferLike, byteOffset?: number, length?: number): Float64Array;\n\n    /**\n      * The size in bytes of each element in the array.\n      */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /**\n      * Returns a new array from a set of elements.\n      * @param items A set of elements to include in the new array object.\n      */\n    of(...items: number[]): Float64Array;\n\n    /**\n      * Creates an array from an array-like or iterable object.\n      * @param arrayLike An array-like or iterable object to convert to an array.\n      * @param mapfn A mapping function to call on every element of the array.\n      * @param thisArg Value of 'this' used to invoke the mapfn.\n      */\n    from(arrayLike: ArrayLike<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Float64Array;\n\n}\ndeclare const Float64Array: Float64ArrayConstructor;\n\n/////////////////////////////\n/// ECMAScript Internationalization API\n/////////////////////////////\n\ndeclare namespace Intl {\n    interface CollatorOptions {\n        usage?: string;\n        localeMatcher?: string;\n        numeric?: boolean;\n        caseFirst?: string;\n        sensitivity?: string;\n        ignorePunctuation?: boolean;\n    }\n\n    interface ResolvedCollatorOptions {\n        locale: string;\n        usage: string;\n        sensitivity: string;\n        ignorePunctuation: boolean;\n        collation: string;\n        caseFirst: string;\n        numeric: boolean;\n    }\n\n    interface Collator {\n        compare(x: string, y: string): number;\n        resolvedOptions(): ResolvedCollatorOptions;\n    }\n    var Collator: {\n        new(locales?: string | string[], options?: CollatorOptions): Collator;\n        (locales?: string | string[], options?: CollatorOptions): Collator;\n        supportedLocalesOf(locales: string | string[], options?: CollatorOptions): string[];\n    };\n\n    interface NumberFormatOptions {\n        localeMatcher?: string;\n        style?: string;\n        currency?: string;\n        currencyDisplay?: string;\n        useGrouping?: boolean;\n        minimumIntegerDigits?: number;\n        minimumFractionDigits?: number;\n        maximumFractionDigits?: number;\n        minimumSignificantDigits?: number;\n        maximumSignificantDigits?: number;\n    }\n\n    interface ResolvedNumberFormatOptions {\n        locale: string;\n        numberingSystem: string;\n        style: string;\n        currency?: string;\n        currencyDisplay?: string;\n        minimumIntegerDigits: number;\n        minimumFractionDigits: number;\n        maximumFractionDigits: number;\n        minimumSignificantDigits?: number;\n        maximumSignificantDigits?: number;\n        useGrouping: boolean;\n    }\n\n    interface NumberFormat {\n        format(value: number): string;\n        resolvedOptions(): ResolvedNumberFormatOptions;\n    }\n    var NumberFormat: {\n        new(locales?: string | string[], options?: NumberFormatOptions): NumberFormat;\n        (locales?: string | string[], options?: NumberFormatOptions): NumberFormat;\n        supportedLocalesOf(locales: string | string[], options?: NumberFormatOptions): string[];\n    };\n\n    interface DateTimeFormatOptions {\n        localeMatcher?: string;\n        weekday?: string;\n        era?: string;\n        year?: string;\n        month?: string;\n        day?: string;\n        hour?: string;\n        minute?: string;\n        second?: string;\n        timeZoneName?: string;\n        formatMatcher?: string;\n        hour12?: boolean;\n        timeZone?: string;\n    }\n\n    interface ResolvedDateTimeFormatOptions {\n        locale: string;\n        calendar: string;\n        numberingSystem: string;\n        timeZone: string;\n        hour12?: boolean;\n        weekday?: string;\n        era?: string;\n        year?: string;\n        month?: string;\n        day?: string;\n        hour?: string;\n        minute?: string;\n        second?: string;\n        timeZoneName?: string;\n    }\n\n    interface DateTimeFormat {\n        format(date?: Date | number): string;\n        resolvedOptions(): ResolvedDateTimeFormatOptions;\n    }\n    var DateTimeFormat: {\n        new(locales?: string | string[], options?: DateTimeFormatOptions): DateTimeFormat;\n        (locales?: string | string[], options?: DateTimeFormatOptions): DateTimeFormat;\n        supportedLocalesOf(locales: string | string[], options?: DateTimeFormatOptions): string[];\n    };\n}\n\ninterface String {\n    /**\n      * Determines whether two strings are equivalent in the current or specified locale.\n      * @param that String to compare to target string\n      * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used. This parameter must conform to BCP 47 standards; see the Intl.Collator object for details.\n      * @param options An object that contains one or more properties that specify comparison options. see the Intl.Collator object for details.\n      */\n    localeCompare(that: string, locales?: string | string[], options?: Intl.CollatorOptions): number;\n}\n\ninterface Number {\n    /**\n      * Converts a number to a string by using the current or specified locale.\n      * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used.\n      * @param options An object that contains one or more properties that specify comparison options.\n      */\n    toLocaleString(locales?: string | string[], options?: Intl.NumberFormatOptions): string;\n}\n\ninterface Date {\n    /**\n      * Converts a date and time to a string by using the current or specified locale.\n      * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used.\n      * @param options An object that contains one or more properties that specify comparison options.\n      */\n    toLocaleString(locales?: string | string[], options?: Intl.DateTimeFormatOptions): string;\n    /**\n      * Converts a date to a string by using the current or specified locale.\n      * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used.\n      * @param options An object that contains one or more properties that specify comparison options.\n      */\n    toLocaleDateString(locales?: string | string[], options?: Intl.DateTimeFormatOptions): string;\n\n    /**\n      * Converts a time to a string by using the current or specified locale.\n      * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used.\n      * @param options An object that contains one or more properties that specify comparison options.\n      */\n    toLocaleTimeString(locales?: string | string[], options?: Intl.DateTimeFormatOptions): string;\n}\n\n\ndeclare type PropertyKey = string | number | symbol;\n\ninterface Array<T> {\n    /**\n     * Returns the value of the first element in the array where predicate is true, and undefined\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found, find\n     * immediately returns that element value. Otherwise, find returns undefined.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    find(predicate: (this: void, value: T, index: number, obj: Array<T>) => boolean): T | undefined;\n    find(predicate: (this: void, value: T, index: number, obj: Array<T>) => boolean, thisArg: undefined): T | undefined;\n    find<Z>(predicate: (this: Z, value: T, index: number, obj: Array<T>) => boolean, thisArg: Z): T | undefined;\n\n    /**\n     * Returns the index of the first element in the array where predicate is true, and -1\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found,\n     * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    findIndex(predicate: (this: void, value: T, index: number, obj: Array<T>) => boolean): number;\n    findIndex(predicate: (this: void, value: T, index: number, obj: Array<T>) => boolean, thisArg: undefined): number;\n    findIndex<Z>(predicate: (this: Z, value: T, index: number, obj: Array<T>) => boolean, thisArg: Z): number;\n\n    /**\n     * Returns the this object after filling the section identified by start and end with value\n     * @param value value to fill array section with\n     * @param start index to start filling the array at. If start is negative, it is treated as\n     * length+start where length is the length of the array.\n     * @param end index to stop filling the array at. If end is negative, it is treated as\n     * length+end.\n     */\n    fill(value: T, start?: number, end?: number): this;\n\n    /**\n     * Returns the this object after copying a section of the array identified by start and end\n     * to the same array starting at position target\n     * @param target If target is negative, it is treated as length+target where length is the\n     * length of the array.\n     * @param start If start is negative, it is treated as length+start. If end is negative, it\n     * is treated as length+end.\n     * @param end If not specified, length of the this object is used as its default value.\n     */\n    copyWithin(target: number, start: number, end?: number): this;\n}\n\ninterface ArrayConstructor {\n    /**\n     * Creates an array from an array-like object.\n     * @param arrayLike An array-like object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from<T, U>(arrayLike: ArrayLike<T>, mapfn: (this: void, v: T, k: number) => U): Array<U>;\n    from<T, U>(arrayLike: ArrayLike<T>, mapfn: (this: void, v: T, k: number) => U, thisArg: undefined): Array<U>;\n    from<Z, T, U>(arrayLike: ArrayLike<T>, mapfn: (this: Z, v: T, k: number) => U, thisArg: Z): Array<U>;\n\n\n    /**\n     * Creates an array from an array-like object.\n     * @param arrayLike An array-like object to convert to an array.\n     */\n    from<T>(arrayLike: ArrayLike<T>): Array<T>;\n\n    /**\n     * Returns a new array from a set of elements.\n     * @param items A set of elements to include in the new array object.\n     */\n    of<T>(...items: T[]): Array<T>;\n}\n\ninterface DateConstructor {\n    new (value: Date): Date;\n}\n\ninterface Function {\n    /**\n     * Returns the name of the function. Function names are read-only and can not be changed.\n     */\n    readonly name: string;\n}\n\ninterface Math {\n    /**\n     * Returns the number of leading zero bits in the 32-bit binary representation of a number.\n     * @param x A numeric expression.\n     */\n    clz32(x: number): number;\n\n    /**\n     * Returns the result of 32-bit multiplication of two numbers.\n     * @param x First number\n     * @param y Second number\n     */\n    imul(x: number, y: number): number;\n\n    /**\n     * Returns the sign of the x, indicating whether x is positive, negative or zero.\n     * @param x The numeric expression to test\n     */\n    sign(x: number): number;\n\n    /**\n     * Returns the base 10 logarithm of a number.\n     * @param x A numeric expression.\n     */\n    log10(x: number): number;\n\n    /**\n     * Returns the base 2 logarithm of a number.\n     * @param x A numeric expression.\n     */\n    log2(x: number): number;\n\n    /**\n     * Returns the natural logarithm of 1 + x.\n     * @param x A numeric expression.\n     */\n    log1p(x: number): number;\n\n    /**\n     * Returns the result of (e^x - 1) of x (e raised to the power of x, where e is the base of\n     * the natural logarithms).\n     * @param x A numeric expression.\n     */\n    expm1(x: number): number;\n\n    /**\n     * Returns the hyperbolic cosine of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    cosh(x: number): number;\n\n    /**\n     * Returns the hyperbolic sine of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    sinh(x: number): number;\n\n    /**\n     * Returns the hyperbolic tangent of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    tanh(x: number): number;\n\n    /**\n     * Returns the inverse hyperbolic cosine of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    acosh(x: number): number;\n\n    /**\n     * Returns the inverse hyperbolic sine of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    asinh(x: number): number;\n\n    /**\n     * Returns the inverse hyperbolic tangent of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    atanh(x: number): number;\n\n    /**\n     * Returns the square root of the sum of squares of its arguments.\n     * @param values Values to compute the square root for.\n     *     If no arguments are passed, the result is +0.\n     *     If there is only one argument, the result is the absolute value.\n     *     If any argument is +Infinity or -Infinity, the result is +Infinity.\n     *     If any argument is NaN, the result is NaN.\n     *     If all arguments are either +0 or −0, the result is +0.\n     */\n    hypot(...values: number[] ): number;\n\n    /**\n     * Returns the integral part of the a numeric expression, x, removing any fractional digits.\n     * If x is already an integer, the result is x.\n     * @param x A numeric expression.\n     */\n    trunc(x: number): number;\n\n    /**\n     * Returns the nearest single precision float representation of a number.\n     * @param x A numeric expression.\n     */\n    fround(x: number): number;\n\n    /**\n     * Returns an implementation-dependent approximation to the cube root of number.\n     * @param x A numeric expression.\n     */\n    cbrt(x: number): number;\n}\n\ninterface NumberConstructor {\n    /**\n     * The value of Number.EPSILON is the difference between 1 and the smallest value greater than 1\n     * that is representable as a Number value, which is approximately:\n     * 2.2204460492503130808472633361816 x 10‍−‍16.\n     */\n    readonly EPSILON: number;\n\n    /**\n     * Returns true if passed value is finite.\n     * Unlike the global isFinite, Number.isFinite doesn't forcibly convert the parameter to a\n     * number. Only finite values of the type number, result in true.\n     * @param number A numeric value.\n     */\n    isFinite(number: number): boolean;\n\n    /**\n     * Returns true if the value passed is an integer, false otherwise.\n     * @param number A numeric value.\n     */\n    isInteger(number: number): boolean;\n\n    /**\n     * Returns a Boolean value that indicates whether a value is the reserved value NaN (not a\n     * number). Unlike the global isNaN(), Number.isNaN() doesn't forcefully convert the parameter\n     * to a number. Only values of the type number, that are also NaN, result in true.\n     * @param number A numeric value.\n     */\n    isNaN(number: number): boolean;\n\n    /**\n     * Returns true if the value passed is a safe integer.\n     * @param number A numeric value.\n     */\n    isSafeInteger(number: number): boolean;\n\n    /**\n     * The value of the largest integer n such that n and n + 1 are both exactly representable as\n     * a Number value.\n     * The value of Number.MAX_SAFE_INTEGER is 9007199254740991 2^53 − 1.\n     */\n    readonly MAX_SAFE_INTEGER: number;\n\n    /**\n     * The value of the smallest integer n such that n and n − 1 are both exactly representable as\n     * a Number value.\n     * The value of Number.MIN_SAFE_INTEGER is −9007199254740991 (−(2^53 − 1)).\n     */\n    readonly MIN_SAFE_INTEGER: number;\n\n    /**\n     * Converts a string to a floating-point number.\n     * @param string A string that contains a floating-point number.\n     */\n    parseFloat(string: string): number;\n\n    /**\n     * Converts A string to an integer.\n     * @param s A string to convert into a number.\n     * @param radix A value between 2 and 36 that specifies the base of the number in numString.\n     * If this argument is not supplied, strings with a prefix of '0x' are considered hexadecimal.\n     * All other strings are considered decimal.\n     */\n    parseInt(string: string, radix?: number): number;\n}\n\ninterface Object {\n    /**\n     * Determines whether an object has a property with the specified name.\n     * @param v A property name.\n     */\n    hasOwnProperty(v: PropertyKey): boolean;\n\n    /**\n     * Determines whether a specified property is enumerable.\n     * @param v A property name.\n     */\n    propertyIsEnumerable(v: PropertyKey): boolean;\n}\n\ninterface ObjectConstructor {\n    /**\n     * Copy the values of all of the enumerable own properties from one or more source objects to a\n     * target object. Returns the target object.\n     * @param target The target object to copy to.\n     * @param source The source object from which to copy properties.\n     */\n    assign<T, U>(target: T, source: U): T & U;\n\n    /**\n     * Copy the values of all of the enumerable own properties from one or more source objects to a\n     * target object. Returns the target object.\n     * @param target The target object to copy to.\n     * @param source1 The first source object from which to copy properties.\n     * @param source2 The second source object from which to copy properties.\n     */\n    assign<T, U, V>(target: T, source1: U, source2: V): T & U & V;\n\n    /**\n     * Copy the values of all of the enumerable own properties from one or more source objects to a\n     * target object. Returns the target object.\n     * @param target The target object to copy to.\n     * @param source1 The first source object from which to copy properties.\n     * @param source2 The second source object from which to copy properties.\n     * @param source3 The third source object from which to copy properties.\n     */\n    assign<T, U, V, W>(target: T, source1: U, source2: V, source3: W): T & U & V & W;\n\n    /**\n     * Copy the values of all of the enumerable own properties from one or more source objects to a\n     * target object. Returns the target object.\n     * @param target The target object to copy to.\n     * @param sources One or more source objects from which to copy properties\n     */\n    assign(target: object, ...sources: any[]): any;\n\n    /**\n     * Returns an array of all symbol properties found directly on object o.\n     * @param o Object to retrieve the symbols from.\n     */\n    getOwnPropertySymbols(o: any): symbol[];\n\n    /**\n     * Returns true if the values are the same value, false otherwise.\n     * @param value1 The first value.\n     * @param value2 The second value.\n     */\n    is(value1: any, value2: any): boolean;\n\n    /**\n     * Sets the prototype of a specified object o to  object proto or null. Returns the object o.\n     * @param o The object to change its prototype.\n     * @param proto The value of the new prototype or null.\n     */\n    setPrototypeOf(o: any, proto: object | null): any;\n\n    /**\n     * Gets the own property descriptor of the specified object.\n     * An own property descriptor is one that is defined directly on the object and is not\n     * inherited from the object's prototype.\n     * @param o Object that contains the property.\n     * @param p Name of the property.\n     */\n    getOwnPropertyDescriptor(o: any, propertyKey: PropertyKey): PropertyDescriptor;\n\n    /**\n     * Adds a property to an object, or modifies attributes of an existing property.\n     * @param o Object on which to add or modify the property. This can be a native JavaScript\n     * object (that is, a user-defined object or a built in object) or a DOM object.\n     * @param p The property name.\n     * @param attributes Descriptor for the property. It can be for a data property or an accessor\n     *  property.\n     */\n    defineProperty(o: any, propertyKey: PropertyKey, attributes: PropertyDescriptor): any;\n}\n\ninterface ReadonlyArray<T> {\n    /**\n     * Returns the value of the first element in the array where predicate is true, and undefined\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found, find\n     * immediately returns that element value. Otherwise, find returns undefined.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    find(predicate: (this: void, value: T, index: number, obj: ReadonlyArray<T>) => boolean): T | undefined;\n    find(predicate: (this: void, value: T, index: number, obj: ReadonlyArray<T>) => boolean, thisArg: undefined): T | undefined;\n    find<Z>(predicate: (this: Z, value: T, index: number, obj: ReadonlyArray<T>) => boolean, thisArg: Z): T | undefined;\n\n    /**\n     * Returns the index of the first element in the array where predicate is true, and -1\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found,\n     * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    findIndex(predicate: (this: void, value: T, index: number, obj: Array<T>) => boolean): number;\n    findIndex(predicate: (this: void, value: T, index: number, obj: Array<T>) => boolean, thisArg: undefined): number;\n    findIndex<Z>(predicate: (this: Z, value: T, index: number, obj: Array<T>) => boolean, thisArg: Z): number;\n}\n\ninterface RegExp {\n    /**\n     * Returns a string indicating the flags of the regular expression in question. This field is read-only.\n     * The characters in this string are sequenced and concatenated in the following order:\n     *\n     *    - \"g\" for global\n     *    - \"i\" for ignoreCase\n     *    - \"m\" for multiline\n     *    - \"u\" for unicode\n     *    - \"y\" for sticky\n     *\n     * If no flags are set, the value is the empty string.\n     */\n    readonly flags: string;\n\n    /**\n     * Returns a Boolean value indicating the state of the sticky flag (y) used with a regular\n     * expression. Default is false. Read-only.\n     */\n    readonly sticky: boolean;\n\n    /**\n     * Returns a Boolean value indicating the state of the Unicode flag (u) used with a regular\n     * expression. Default is false. Read-only.\n     */\n    readonly unicode: boolean;\n}\n\ninterface RegExpConstructor {\n    new (pattern: RegExp, flags?: string): RegExp;\n    (pattern: RegExp, flags?: string): RegExp;\n}\n\ninterface String {\n    /**\n     * Returns a nonnegative integer Number less than 1114112 (0x110000) that is the code point\n     * value of the UTF-16 encoded code point starting at the string element at position pos in\n     * the String resulting from converting this object to a String.\n     * If there is no element at that position, the result is undefined.\n     * If a valid UTF-16 surrogate pair does not begin at pos, the result is the code unit at pos.\n     */\n    codePointAt(pos: number): number | undefined;\n\n    /**\n     * Returns true if searchString appears as a substring of the result of converting this\n     * object to a String, at one or more positions that are\n     * greater than or equal to position; otherwise, returns false.\n     * @param searchString search string\n     * @param position If position is undefined, 0 is assumed, so as to search all of the String.\n     */\n    includes(searchString: string, position?: number): boolean;\n\n    /**\n     * Returns true if the sequence of elements of searchString converted to a String is the\n     * same as the corresponding elements of this object (converted to a String) starting at\n     * endPosition – length(this). Otherwise returns false.\n     */\n    endsWith(searchString: string, endPosition?: number): boolean;\n\n    /**\n     * Returns the String value result of normalizing the string into the normalization form\n     * named by form as specified in Unicode Standard Annex #15, Unicode Normalization Forms.\n     * @param form Applicable values: \"NFC\", \"NFD\", \"NFKC\", or \"NFKD\", If not specified default\n     * is \"NFC\"\n     */\n    normalize(form: \"NFC\" | \"NFD\" | \"NFKC\" | \"NFKD\"): string;\n\n    /**\n     * Returns the String value result of normalizing the string into the normalization form\n     * named by form as specified in Unicode Standard Annex #15, Unicode Normalization Forms.\n     * @param form Applicable values: \"NFC\", \"NFD\", \"NFKC\", or \"NFKD\", If not specified default\n     * is \"NFC\"\n     */\n    normalize(form?: string): string;\n\n    /**\n     * Returns a String value that is made from count copies appended together. If count is 0,\n     * T is the empty String is returned.\n     * @param count number of copies to append\n     */\n    repeat(count: number): string;\n\n    /**\n     * Returns true if the sequence of elements of searchString converted to a String is the\n     * same as the corresponding elements of this object (converted to a String) starting at\n     * position. Otherwise returns false.\n     */\n    startsWith(searchString: string, position?: number): boolean;\n\n    /**\n     * Returns an <a> HTML anchor element and sets the name attribute to the text value\n     * @param name\n     */\n    anchor(name: string): string;\n\n    /** Returns a <big> HTML element */\n    big(): string;\n\n    /** Returns a <blink> HTML element */\n    blink(): string;\n\n    /** Returns a <b> HTML element */\n    bold(): string;\n\n    /** Returns a <tt> HTML element */\n    fixed(): string;\n\n    /** Returns a <font> HTML element and sets the color attribute value */\n    fontcolor(color: string): string;\n\n    /** Returns a <font> HTML element and sets the size attribute value */\n    fontsize(size: number): string;\n\n    /** Returns a <font> HTML element and sets the size attribute value */\n    fontsize(size: string): string;\n\n    /** Returns an <i> HTML element */\n    italics(): string;\n\n    /** Returns an <a> HTML element and sets the href attribute value */\n    link(url: string): string;\n\n    /** Returns a <small> HTML element */\n    small(): string;\n\n    /** Returns a <strike> HTML element */\n    strike(): string;\n\n    /** Returns a <sub> HTML element */\n    sub(): string;\n\n    /** Returns a <sup> HTML element */\n    sup(): string;\n}\n\ninterface StringConstructor {\n    /**\n     * Return the String value whose elements are, in order, the elements in the List elements.\n     * If length is 0, the empty string is returned.\n     */\n    fromCodePoint(...codePoints: number[]): string;\n\n    /**\n     * String.raw is intended for use as a tag function of a Tagged Template String. When called\n     * as such the first argument will be a well formed template call site object and the rest\n     * parameter will contain the substitution values.\n     * @param template A well-formed template string call site representation.\n     * @param substitutions A set of substitution values.\n     */\n    raw(template: TemplateStringsArray, ...substitutions: any[]): string;\n}\n\n\ninterface Map<K, V> {\n    clear(): void;\n    delete(key: K): boolean;\n    forEach(callbackfn: (value: V, key: K, map: Map<K, V>) => void, thisArg?: any): void;\n    get(key: K): V | undefined;\n    has(key: K): boolean;\n    set(key: K, value: V): this;\n    readonly size: number;\n}\n\ninterface MapConstructor {\n    new (): Map<any, any>;\n    new <K, V>(entries?: [K, V][]): Map<K, V>;\n    readonly prototype: Map<any, any>;\n}\ndeclare var Map: MapConstructor;\n\ninterface ReadonlyMap<K, V> {\n    forEach(callbackfn: (value: V, key: K, map: ReadonlyMap<K, V>) => void, thisArg?: any): void;\n    get(key: K): V | undefined;\n    has(key: K): boolean;\n    readonly size: number;\n}\n\ninterface WeakMap<K extends object, V> {\n    delete(key: K): boolean;\n    get(key: K): V | undefined;\n    has(key: K): boolean;\n    set(key: K, value: V): this;\n}\n\ninterface WeakMapConstructor {\n    new (): WeakMap<object, any>;\n    new <K extends object, V>(entries?: [K, V][]): WeakMap<K, V>;\n    readonly prototype: WeakMap<object, any>;\n}\ndeclare var WeakMap: WeakMapConstructor;\n\ninterface Set<T> {\n    add(value: T): this;\n    clear(): void;\n    delete(value: T): boolean;\n    forEach(callbackfn: (value: T, value2: T, set: Set<T>) => void, thisArg?: any): void;\n    has(value: T): boolean;\n    readonly size: number;\n}\n\ninterface SetConstructor {\n    new (): Set<any>;\n    new <T>(values?: T[]): Set<T>;\n    readonly prototype: Set<any>;\n}\ndeclare var Set: SetConstructor;\n\ninterface ReadonlySet<T> {\n    forEach(callbackfn: (value: T, value2: T, set: ReadonlySet<T>) => void, thisArg?: any): void;\n    has(value: T): boolean;\n    readonly size: number;\n}\n\ninterface WeakSet<T> {\n    add(value: T): this;\n    delete(value: T): boolean;\n    has(value: T): boolean;\n}\n\ninterface WeakSetConstructor {\n    new (): WeakSet<object>;\n    new <T extends object>(values?: T[]): WeakSet<T>;\n    readonly prototype: WeakSet<object>;\n}\ndeclare var WeakSet: WeakSetConstructor;\n\n\ninterface Generator extends Iterator<any> { }\n\ninterface GeneratorFunction {\n    /**\n     * Creates a new Generator object.\n     * @param args A list of arguments the function accepts.\n     */\n    new (...args: any[]): Generator;\n    /**\n     * Creates a new Generator object.\n     * @param args A list of arguments the function accepts.\n     */\n    (...args: any[]): Generator;\n    /**\n     * The length of the arguments.\n     */\n    readonly length: number;\n    /**\n     * Returns the name of the function.\n     */\n    readonly name: string;\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: Generator;\n}\n\ninterface GeneratorFunctionConstructor {\n    /**\n     * Creates a new Generator function.\n     * @param args A list of arguments the function accepts.\n     */\n    new (...args: string[]): GeneratorFunction;\n    /**\n     * Creates a new Generator function.\n     * @param args A list of arguments the function accepts.\n     */\n    (...args: string[]): GeneratorFunction;\n    /**\n     * The length of the arguments.\n     */\n    readonly length: number;\n    /**\n     * Returns the name of the function.\n     */\n    readonly name: string;\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: GeneratorFunction;\n}\ndeclare var GeneratorFunction: GeneratorFunctionConstructor;\n\n\n/// <reference path=\"lib.es2015.symbol.d.ts\" />\n\ninterface SymbolConstructor {\n    /**\n     * A method that returns the default iterator for an object. Called by the semantics of the\n     * for-of statement.\n     */\n    readonly iterator: symbol;\n}\n\ninterface IteratorResult<T> {\n    done: boolean;\n    value: T;\n}\n\ninterface Iterator<T> {\n    next(value?: any): IteratorResult<T>;\n    return?(value?: any): IteratorResult<T>;\n    throw?(e?: any): IteratorResult<T>;\n}\n\ninterface Iterable<T> {\n    [Symbol.iterator](): Iterator<T>;\n}\n\ninterface IterableIterator<T> extends Iterator<T> {\n    [Symbol.iterator](): IterableIterator<T>;\n}\n\ninterface Array<T> {\n    /** Iterator */\n    [Symbol.iterator](): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, T]>;\n\n    /**\n     * Returns an iterable of keys in the array\n     */\n    keys(): IterableIterator<number>;\n\n    /**\n     * Returns an iterable of values in the array\n     */\n    values(): IterableIterator<T>;\n}\n\ninterface ArrayConstructor {\n    /**\n     * Creates an array from an iterable object.\n     * @param iterable An iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from<T, U>(iterable: Iterable<T>, mapfn: (this: void, v: T, k: number) => U): Array<U>;\n    from<T, U>(iterable: Iterable<T>, mapfn: (this: void, v: T, k: number) => U, thisArg: undefined): Array<U>;\n    from<Z, T, U>(iterable: Iterable<T>, mapfn: (this: Z, v: T, k: number) => U, thisArg: Z): Array<U>;\n\n    /**\n     * Creates an array from an iterable object.\n     * @param iterable An iterable object to convert to an array.\n     */\n    from<T>(iterable: Iterable<T>): Array<T>;\n}\n\ninterface ReadonlyArray<T> {\n    /** Iterator of values in the array. */\n    [Symbol.iterator](): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, T]>;\n\n    /**\n     * Returns an iterable of keys in the array\n     */\n    keys(): IterableIterator<number>;\n\n    /**\n     * Returns an iterable of values in the array\n     */\n    values(): IterableIterator<T>;\n}\n\ninterface IArguments {\n    /** Iterator */\n    [Symbol.iterator](): IterableIterator<any>;\n}\n\ninterface Map<K, V> {\n    /** Returns an iterable of entries in the map. */\n    [Symbol.iterator](): IterableIterator<[K, V]>;\n\n    /**\n     * Returns an iterable of key, value pairs for every entry in the map.\n     */\n    entries(): IterableIterator<[K, V]>;\n\n    /**\n     * Returns an iterable of keys in the map\n     */\n    keys(): IterableIterator<K>;\n\n    /**\n     * Returns an iterable of values in the map\n     */\n    values(): IterableIterator<V>;\n}\n\ninterface ReadonlyMap<K, V> {\n    /** Returns an iterable of entries in the map. */\n    [Symbol.iterator](): IterableIterator<[K, V]>;\n\n    /**\n     * Returns an iterable of key, value pairs for every entry in the map.\n     */\n    entries(): IterableIterator<[K, V]>;\n\n    /**\n     * Returns an iterable of keys in the map\n     */\n    keys(): IterableIterator<K>;\n\n    /**\n     * Returns an iterable of values in the map\n     */\n    values(): IterableIterator<V>;\n}\n\ninterface MapConstructor {\n    new <K, V>(iterable: Iterable<[K, V]>): Map<K, V>;\n}\n\ninterface WeakMap<K extends object, V> { }\n\ninterface WeakMapConstructor {\n    new <K extends object, V>(iterable: Iterable<[K, V]>): WeakMap<K, V>;\n}\n\ninterface Set<T> {\n    /** Iterates over values in the set. */\n    [Symbol.iterator](): IterableIterator<T>;\n    /**\n     * Returns an iterable of [v,v] pairs for every value `v` in the set.\n     */\n    entries(): IterableIterator<[T, T]>;\n    /**\n     * Despite its name, returns an iterable of the values in the set,\n     */\n    keys(): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of values in the set.\n     */\n    values(): IterableIterator<T>;\n}\n\ninterface ReadonlySet<T> {\n    /** Iterates over values in the set. */\n    [Symbol.iterator](): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of [v,v] pairs for every value `v` in the set.\n     */\n    entries(): IterableIterator<[T, T]>;\n\n    /**\n     * Despite its name, returns an iterable of the values in the set,\n     */\n    keys(): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of values in the set.\n     */\n    values(): IterableIterator<T>;\n}\n\ninterface SetConstructor {\n    new <T>(iterable: Iterable<T>): Set<T>;\n}\n\ninterface WeakSet<T> { }\n\ninterface WeakSetConstructor {\n    new <T extends object>(iterable: Iterable<T>): WeakSet<T>;\n}\n\ninterface Promise<T> { }\n\ninterface PromiseConstructor {\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<TAll>(values: Iterable<TAll | PromiseLike<TAll>>): Promise<TAll[]>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    race<T>(values: Iterable<T | PromiseLike<T>>): Promise<T>;\n}\n\ndeclare namespace Reflect {\n    function enumerate(target: object): IterableIterator<any>;\n}\n\ninterface String {\n    /** Iterator */\n    [Symbol.iterator](): IterableIterator<string>;\n}\n\n/**\n * A typed array of 8-bit integer values. The contents are initialized to 0. If the requested\n * number of bytes could not be allocated an exception is raised.\n */\ninterface Int8Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Int8ArrayConstructor {\n    new (elements: Iterable<number>): Int8Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number): Int8Array;\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number, thisArg: undefined): Int8Array;\n    from<Z>(arrayLike: Iterable<number>, mapfn: (this: Z, v: number, k: number) => number, thisArg: Z): Int8Array;\n\n    from(arrayLike: Iterable<number>): Int8Array;\n}\n\n/**\n * A typed array of 8-bit unsigned integer values. The contents are initialized to 0. If the\n * requested number of bytes could not be allocated an exception is raised.\n */\ninterface Uint8Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Uint8ArrayConstructor {\n    new (elements: Iterable<number>): Uint8Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number): Uint8Array;\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number, thisArg: undefined): Uint8Array;\n    from<Z>(arrayLike: Iterable<number>, mapfn: (this: Z, v: number, k: number) => number, thisArg: Z): Uint8Array;\n\n    from(arrayLike: Iterable<number>): Uint8Array;\n}\n\n/**\n * A typed array of 8-bit unsigned integer (clamped) values. The contents are initialized to 0.\n * If the requested number of bytes could not be allocated an exception is raised.\n */\ninterface Uint8ClampedArray {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Uint8ClampedArrayConstructor {\n    new (elements: Iterable<number>): Uint8ClampedArray;\n\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number): Uint8ClampedArray;\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number, thisArg: undefined): Uint8ClampedArray;\n    from<Z>(arrayLike: Iterable<number>, mapfn: (this: Z, v: number, k: number) => number, thisArg: Z): Uint8ClampedArray;\n\n    from(arrayLike: Iterable<number>): Uint8ClampedArray;\n}\n\n/**\n * A typed array of 16-bit signed integer values. The contents are initialized to 0. If the\n * requested number of bytes could not be allocated an exception is raised.\n */\ninterface Int16Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Int16ArrayConstructor {\n    new (elements: Iterable<number>): Int16Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number): Int16Array;\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number, thisArg: undefined): Int16Array;\n    from<Z>(arrayLike: Iterable<number>, mapfn: (this: Z, v: number, k: number) => number, thisArg: Z): Int16Array;\n\n    from(arrayLike: Iterable<number>): Int16Array;\n}\n\n/**\n * A typed array of 16-bit unsigned integer values. The contents are initialized to 0. If the\n * requested number of bytes could not be allocated an exception is raised.\n */\ninterface Uint16Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Uint16ArrayConstructor {\n    new (elements: Iterable<number>): Uint16Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number): Uint16Array;\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number, thisArg: undefined): Uint16Array;\n    from<Z>(arrayLike: Iterable<number>, mapfn: (this: Z, v: number, k: number) => number, thisArg: Z): Uint16Array;\n\n    from(arrayLike: Iterable<number>): Uint16Array;\n}\n\n/**\n * A typed array of 32-bit signed integer values. The contents are initialized to 0. If the\n * requested number of bytes could not be allocated an exception is raised.\n */\ninterface Int32Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Int32ArrayConstructor {\n    new (elements: Iterable<number>): Int32Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number): Int32Array;\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number, thisArg: undefined): Int32Array;\n    from<Z>(arrayLike: Iterable<number>, mapfn: (this: Z, v: number, k: number) => number, thisArg: Z): Int32Array;\n\n    from(arrayLike: Iterable<number>): Int32Array;\n}\n\n/**\n * A typed array of 32-bit unsigned integer values. The contents are initialized to 0. If the\n * requested number of bytes could not be allocated an exception is raised.\n */\ninterface Uint32Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Uint32ArrayConstructor {\n    new (elements: Iterable<number>): Uint32Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number): Uint32Array;\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number, thisArg: undefined): Uint32Array;\n    from<Z>(arrayLike: Iterable<number>, mapfn: (this: Z, v: number, k: number) => number, thisArg: Z): Uint32Array;\n\n    from(arrayLike: Iterable<number>): Uint32Array;\n}\n\n/**\n * A typed array of 32-bit float values. The contents are initialized to 0. If the requested number\n * of bytes could not be allocated an exception is raised.\n */\ninterface Float32Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Float32ArrayConstructor {\n    new (elements: Iterable<number>): Float32Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number): Float32Array;\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number, thisArg: undefined): Float32Array;\n    from<Z>(arrayLike: Iterable<number>, mapfn: (this: Z, v: number, k: number) => number, thisArg: Z): Float32Array;\n\n    from(arrayLike: Iterable<number>): Float32Array;\n}\n\n/**\n * A typed array of 64-bit float values. The contents are initialized to 0. If the requested\n * number of bytes could not be allocated an exception is raised.\n */\ninterface Float64Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Float64ArrayConstructor {\n    new (elements: Iterable<number>): Float64Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number): Float64Array;\n    from(arrayLike: Iterable<number>, mapfn: (this: void, v: number, k: number) => number, thisArg: undefined): Float64Array;\n    from<Z>(arrayLike: Iterable<number>, mapfn: (this: Z, v: number, k: number) => number, thisArg: Z): Float64Array;\n\n    from(arrayLike: Iterable<number>): Float64Array;\n}\n\n\ninterface PromiseConstructor {\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: Promise<any>;\n\n    /**\n     * Creates a new Promise.\n     * @param executor A callback used to initialize the promise. This callback is passed two arguments:\n     * a resolve callback used resolve the promise with a value or the result of another promise,\n     * and a reject callback used to reject the promise with a provided reason or error.\n     */\n    new <T>(executor: (resolve: (value?: T | PromiseLike<T>) => void, reject: (reason?: any) => void) => void): Promise<T>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike <T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>, T7 | PromiseLike<T7>, T8 | PromiseLike<T8>, T9 | PromiseLike<T9>, T10 | PromiseLike<T10>]): Promise<[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4, T5, T6, T7, T8, T9>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike <T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>, T7 | PromiseLike<T7>, T8 | PromiseLike<T8>, T9 | PromiseLike<T9>]): Promise<[T1, T2, T3, T4, T5, T6, T7, T8, T9]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4, T5, T6, T7, T8>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike <T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>, T7 | PromiseLike<T7>, T8 | PromiseLike<T8>]): Promise<[T1, T2, T3, T4, T5, T6, T7, T8]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4, T5, T6, T7>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike <T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>, T7 | PromiseLike<T7>]): Promise<[T1, T2, T3, T4, T5, T6, T7]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4, T5, T6>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike <T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>]): Promise<[T1, T2, T3, T4, T5, T6]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4, T5>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike <T4>, T5 | PromiseLike<T5>]): Promise<[T1, T2, T3, T4, T5]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike <T4>]): Promise<[T1, T2, T3, T4]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>]): Promise<[T1, T2, T3]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>]): Promise<[T1, T2]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T>(values: (T | PromiseLike<T>)[]): Promise<T[]>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    race<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>, T7 | PromiseLike<T7>, T8 | PromiseLike<T8>, T9 | PromiseLike<T9>, T10 | PromiseLike<T10>]): Promise<T1 | T2 | T3 | T4 | T5 | T6 | T7 | T8 | T9 | T10>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    race<T1, T2, T3, T4, T5, T6, T7, T8, T9>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>, T7 | PromiseLike<T7>, T8 | PromiseLike<T8>, T9 | PromiseLike<T9>]): Promise<T1 | T2 | T3 | T4 | T5 | T6 | T7 | T8 | T9>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    race<T1, T2, T3, T4, T5, T6, T7, T8>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>, T7 | PromiseLike<T7>, T8 | PromiseLike<T8>]): Promise<T1 | T2 | T3 | T4 | T5 | T6 | T7 | T8>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    race<T1, T2, T3, T4, T5, T6, T7>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>, T7 | PromiseLike<T7>]): Promise<T1 | T2 | T3 | T4 | T5 | T6 | T7>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    race<T1, T2, T3, T4, T5, T6>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>]): Promise<T1 | T2 | T3 | T4 | T5 | T6>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    race<T1, T2, T3, T4, T5>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>, T5 | PromiseLike<T5>]): Promise<T1 | T2 | T3 | T4 | T5>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    race<T1, T2, T3, T4>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>]): Promise<T1 | T2 | T3 | T4>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    race<T1, T2, T3>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>]): Promise<T1 | T2 | T3>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    race<T1, T2>(values: [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>]): Promise<T1 | T2>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    race<T>(values: (T | PromiseLike<T>)[]): Promise<T>;\n\n    /**\n     * Creates a new rejected promise for the provided reason.\n     * @param reason The reason the promise was rejected.\n     * @returns A new rejected Promise.\n     */\n    reject(reason: any): Promise<never>;\n\n    /**\n     * Creates a new rejected promise for the provided reason.\n     * @param reason The reason the promise was rejected.\n     * @returns A new rejected Promise.\n     */\n    reject<T>(reason: any): Promise<T>;\n\n    /**\n     * Creates a new resolved promise for the provided value.\n     * @param value A promise.\n     * @returns A promise whose internal state matches the provided promise.\n     */\n    resolve<T>(value: T | PromiseLike<T>): Promise<T>;\n\n    /**\n     * Creates a new resolved promise .\n     * @returns A resolved promise.\n     */\n    resolve(): Promise<void>;\n}\n\ndeclare var Promise: PromiseConstructor;\n\ninterface ProxyHandler<T extends object> {\n    getPrototypeOf? (target: T): object | null;\n    setPrototypeOf? (target: T, v: any): boolean;\n    isExtensible? (target: T): boolean;\n    preventExtensions? (target: T): boolean;\n    getOwnPropertyDescriptor? (target: T, p: PropertyKey): PropertyDescriptor | undefined;\n    has? (target: T, p: PropertyKey): boolean;\n    get? (target: T, p: PropertyKey, receiver: any): any;\n    set? (target: T, p: PropertyKey, value: any, receiver: any): boolean;\n    deleteProperty? (target: T, p: PropertyKey): boolean;\n    defineProperty? (target: T, p: PropertyKey, attributes: PropertyDescriptor): boolean;\n    enumerate? (target: T): PropertyKey[];\n    ownKeys? (target: T): PropertyKey[];\n    apply? (target: T, thisArg: any, argArray?: any): any;\n    construct? (target: T, argArray: any, newTarget?: any): object;\n}\n\ninterface ProxyConstructor {\n    revocable<T extends object>(target: T, handler: ProxyHandler<T>): { proxy: T; revoke: () => void; };\n    new <T extends object>(target: T, handler: ProxyHandler<T>): T;\n}\ndeclare var Proxy: ProxyConstructor;\n\n\ndeclare namespace Reflect {\n    function apply(target: Function, thisArgument: any, argumentsList: ArrayLike<any>): any;\n    function construct(target: Function, argumentsList: ArrayLike<any>, newTarget?: any): any;\n    function defineProperty(target: object, propertyKey: PropertyKey, attributes: PropertyDescriptor): boolean;\n    function deleteProperty(target: object, propertyKey: PropertyKey): boolean;\n    function get(target: object, propertyKey: PropertyKey, receiver?: any): any;\n    function getOwnPropertyDescriptor(target: object, propertyKey: PropertyKey): PropertyDescriptor;\n    function getPrototypeOf(target: object): object;\n    function has(target: object, propertyKey: PropertyKey): boolean;\n    function isExtensible(target: object): boolean;\n    function ownKeys(target: object): Array<PropertyKey>;\n    function preventExtensions(target: object): boolean;\n    function set(target: object, propertyKey: PropertyKey, value: any, receiver?: any): boolean;\n    function setPrototypeOf(target: object, proto: any): boolean;\n}\n\n\ninterface Symbol {\n    /** Returns a string representation of an object. */\n    toString(): string;\n\n    /** Returns the primitive value of the specified object. */\n    valueOf(): symbol;\n}\n\ninterface SymbolConstructor {\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: Symbol;\n\n    /**\n     * Returns a new unique Symbol value.\n     * @param  description Description of the new Symbol object.\n     */\n    (description?: string | number): symbol;\n\n    /**\n     * Returns a Symbol object from the global symbol registry matching the given key if found.\n     * Otherwise, returns a new symbol with this key.\n     * @param key key to search for.\n     */\n    for(key: string): symbol;\n\n    /**\n     * Returns a key from the global symbol registry matching the given Symbol if found.\n     * Otherwise, returns a undefined.\n     * @param sym Symbol to find the key for.\n     */\n    keyFor(sym: symbol): string | undefined;\n}\n\ndeclare var Symbol: SymbolConstructor;\n\n/// <reference path=\"lib.es2015.symbol.d.ts\" />\n\ninterface SymbolConstructor {\n    /**\n     * A method that determines if a constructor object recognizes an object as one of the\n     * constructor’s instances. Called by the semantics of the instanceof operator.\n     */\n    readonly hasInstance: symbol;\n\n    /**\n     * A Boolean value that if true indicates that an object should flatten to its array elements\n     * by Array.prototype.concat.\n     */\n    readonly isConcatSpreadable: symbol;\n\n    /**\n     * A regular expression method that matches the regular expression against a string. Called\n     * by the String.prototype.match method.\n     */\n    readonly match: symbol;\n\n    /**\n     * A regular expression method that replaces matched substrings of a string. Called by the\n     * String.prototype.replace method.\n     */\n    readonly replace: symbol;\n\n    /**\n     * A regular expression method that returns the index within a string that matches the\n     * regular expression. Called by the String.prototype.search method.\n     */\n    readonly search: symbol;\n\n    /**\n     * A function valued property that is the constructor function that is used to create\n     * derived objects.\n     */\n    readonly species: symbol;\n\n    /**\n     * A regular expression method that splits a string at the indices that match the regular\n     * expression. Called by the String.prototype.split method.\n     */\n    readonly split: symbol;\n\n    /**\n     * A method that converts an object to a corresponding primitive value.\n     * Called by the ToPrimitive abstract operation.\n     */\n    readonly toPrimitive: symbol;\n\n    /**\n     * A String value that is used in the creation of the default string description of an object.\n     * Called by the built-in method Object.prototype.toString.\n     */\n    readonly toStringTag: symbol;\n\n    /**\n     * An Object whose own property names are property names that are excluded from the 'with'\n     * environment bindings of the associated objects.\n     */\n    readonly unscopables: symbol;\n}\n\ninterface Symbol {\n    readonly [Symbol.toStringTag]: \"Symbol\";\n}\n\ninterface Array<T> {\n    /**\n     * Returns an object whose properties have the value 'true'\n     * when they will be absent when used in a 'with' statement.\n     */\n    [Symbol.unscopables](): {\n        copyWithin: boolean;\n        entries: boolean;\n        fill: boolean;\n        find: boolean;\n        findIndex: boolean;\n        keys: boolean;\n        values: boolean;\n    };\n}\n\ninterface Date {\n    /**\n     * Converts a Date object to a string.\n     */\n    [Symbol.toPrimitive](hint: \"default\"): string;\n    /**\n     * Converts a Date object to a string.\n     */\n    [Symbol.toPrimitive](hint: \"string\"): string;\n    /**\n     * Converts a Date object to a number.\n     */\n    [Symbol.toPrimitive](hint: \"number\"): number;\n    /**\n     * Converts a Date object to a string or number.\n     *\n     * @param hint The strings \"number\", \"string\", or \"default\" to specify what primitive to return.\n     *\n     * @throws {TypeError} If 'hint' was given something other than \"number\", \"string\", or \"default\".\n     * @returns A number if 'hint' was \"number\", a string if 'hint' was \"string\" or \"default\".\n     */\n    [Symbol.toPrimitive](hint: string): string | number;\n}\n\ninterface Map<K, V> {\n    readonly [Symbol.toStringTag]: \"Map\";\n}\n\ninterface WeakMap<K extends object, V>{\n    readonly [Symbol.toStringTag]: \"WeakMap\";\n}\n\ninterface Set<T> {\n    readonly [Symbol.toStringTag]: \"Set\";\n}\n\ninterface WeakSet<T> {\n    readonly [Symbol.toStringTag]: \"WeakSet\";\n}\n\ninterface JSON {\n    readonly [Symbol.toStringTag]: \"JSON\";\n}\n\ninterface Function {\n    /**\n     * Determines whether the given value inherits from this function if this function was used\n     * as a constructor function.\n     *\n     * A constructor function can control which objects are recognized as its instances by\n     * 'instanceof' by overriding this method.\n     */\n    [Symbol.hasInstance](value: any): boolean;\n}\n\ninterface GeneratorFunction {\n    readonly [Symbol.toStringTag]: \"GeneratorFunction\";\n}\n\ninterface Math {\n    readonly [Symbol.toStringTag]: \"Math\";\n}\n\ninterface Promise<T> {\n    readonly [Symbol.toStringTag]: \"Promise\";\n}\n\ninterface PromiseConstructor {\n    readonly [Symbol.species]: Function;\n}\n\ninterface RegExp {\n    /**\n     * Matches a string with this regular expression, and returns an array containing the results of\n     * that search.\n     * @param string A string to search within.\n     */\n    [Symbol.match](string: string): RegExpMatchArray | null;\n\n    /**\n     * Replaces text in a string, using this regular expression.\n     * @param string A String object or string literal whose contents matching against\n     *               this regular expression will be replaced\n     * @param replaceValue A String object or string literal containing the text to replace for every\n     *                     successful match of this regular expression.\n     */\n    [Symbol.replace](string: string, replaceValue: string): string;\n\n    /**\n     * Replaces text in a string, using this regular expression.\n     * @param string A String object or string literal whose contents matching against\n     *               this regular expression will be replaced\n     * @param replacer A function that returns the replacement text.\n     */\n    [Symbol.replace](string: string, replacer: (substring: string, ...args: any[]) => string): string;\n\n    /**\n     * Finds the position beginning first substring match in a regular expression search\n     * using this regular expression.\n     *\n     * @param string The string to search within.\n     */\n    [Symbol.search](string: string): number;\n\n    /**\n     * Returns an array of substrings that were delimited by strings in the original input that\n     * match against this regular expression.\n     *\n     * If the regular expression contains capturing parentheses, then each time this\n     * regular expression matches, the results (including any undefined results) of the\n     * capturing parentheses are spliced.\n     *\n     * @param string string value to split\n     * @param limit if not undefined, the output array is truncated s