if (typeof global != "undefined" && typeof document == "undefined") {
  if (!global.TDev)
    global.TDev = { 
      window: { 
        document: { URL: "http://localhost/" },
        isNodeJS: true
      } 
    };
  var TDev      = global.TDev;
  var window    = global.TDev.window;
  var document  = global.TDev.window.document;
}
var TDev;
(function (TDev) {
    TDev.dbg = false;
    TDev.isBeta = false;
    (function (BrowserSoftware) {
        BrowserSoftware[BrowserSoftware["unknown"] = 0] = "unknown";
        BrowserSoftware[BrowserSoftware["ie10"] = 1] = "ie10";
        BrowserSoftware[BrowserSoftware["ie11"] = 2] = "ie11";
        BrowserSoftware[BrowserSoftware["ieOld"] = 3] = "ieOld";
        BrowserSoftware[BrowserSoftware["android2"] = 4] = "android2";
        BrowserSoftware[BrowserSoftware["android4"] = 5] = "android4";
        BrowserSoftware[BrowserSoftware["chrome"] = 6] = "chrome";
        BrowserSoftware[BrowserSoftware["chromeiOS"] = 7] = "chromeiOS";
        BrowserSoftware[BrowserSoftware["firefox"] = 8] = "firefox";
        BrowserSoftware[BrowserSoftware["safari"] = 9] = "safari";
        BrowserSoftware[BrowserSoftware["silkOld"] = 10] = "silkOld";
        BrowserSoftware[BrowserSoftware["silk"] = 11] = "silk";
        BrowserSoftware[BrowserSoftware["opera"] = 12] = "opera";
        BrowserSoftware[BrowserSoftware["nodeJS"] = 13] = "nodeJS";
        BrowserSoftware[BrowserSoftware["maxthon"] = 14] = "maxthon";
        BrowserSoftware[BrowserSoftware["bb10"] = 15] = "bb10";
    })(TDev.BrowserSoftware || (TDev.BrowserSoftware = {}));
    var BrowserSoftware = TDev.BrowserSoftware;
    var Browser;
    (function (Browser) {
        Browser.isNodeJS = false;
        Browser.isHeadless = false;
        Browser.isTouchDevice = false;
        Browser.isMobile = undefined;
        Browser.isCellphone = false;
        Browser.isTablet = false;
        Browser.isDesktop = false;
        Browser.isMobileSafari = false;
        Browser.isMobileSafariOld = false;
        Browser.isGecko = false;
        Browser.isTrident = false;
        Browser.isWebkit = false;
        Browser.isAndroid = false;
        Browser.isMacOSX = false;
        Browser.isWindows = false;
        Browser.isWindows8plus = false;
        Browser.isRaspberryPiDebian = false;
        Browser.isCompiledApp = false;
        Browser.isHosted = false;
        Browser.browser = 0 /* unknown */;
        Browser.browserVersion = 0;
        Browser.browserVersion2 = 0;
        Browser.webkitVersion = 0;
        Browser.isEmbedded = false;
        Browser.canIndexedDB = false;
        Browser.canWebSql = false;
        Browser.canMemoryTable = true;
        Browser.hasHardwareBack = false;
        Browser.localProxy = false;
        Browser.noAnimations = false;
        Browser.noStorage = false;
        Browser.isGenStubs = false;
        Browser.mobileWebkit = false;
        Browser.touchStart = false;
        Browser.webRunner = false;
        Browser.webAppImplicit = false;
        Browser.inCordova = false;
        Browser.inEditor = false;
        Browser.builtinTouchToPan = false;
        Browser.canLogin = true;
        Browser.canWriteLocalStorage;
        Browser.cscript = false;
        Browser.useConsoleLog = false;
        Browser.brokenColumns = false;
        Browser.assumeMouse = false;
        Browser.brokenGradient = false;
        Browser.deviceMotion = false;
        Browser.deviceOrientation = false;
        Browser.deviceHeading = false;
        Browser.audioDataUrls = true;
        Browser.audioWav = false;
        Browser.compilerInlining = false;
        Browser.compilerOkElimination = true;
        Browser.compilerBlockChaining = false;
        Browser.brokenBackButton = false;
        Browser.brokenResize = false;
        Browser.screenshots = false;
        Browser.setInnerHTML = function (el, html) {
            el.innerHTML = html;
        };
        Browser.dragAndDrop = false;
        Browser.videoTracks = true;
        Browser.directionAuto = true;
        Browser.notifyBackToHost = false;
        Browser.logToHost = false;
        Browser.noNetwork = false;
        Browser.lowMemory = false;
        Browser.serialLog = false;
        Browser.loadingDone = false;
        Browser.platformCaps = [];
        Browser.browserShortName = "unknown";
        Browser.startTimestamp = 0;
        function browserName(s) {
            var n = BrowserSoftware[s];
            return !n || s == 0 /* unknown */ ? "unknownBrowser" : n;
        }
        function setBrowserVersion(name) {
            var userAgent = window.navigator.userAgent;
            var idx = userAgent.indexOf(name + "/");
            if (idx >= 0) {
                var verNo = userAgent.slice(idx + name.length + 1);
                Browser.browserVersion = parseInt(verNo);
            }
            var m = userAgent.match(/Version\/(\d+)\./);
            if (m)
                Browser.browserVersion2 = parseInt(m[1]);
        }
        function detect() {
            var url = document ? document.URL : "";
            if (/dbg=[1t]/.test(url) || (window && window.localStorage && window.localStorage["dbg"]))
                TDev.dbg = true;
            if (/nodbg/.test(url))
                TDev.dbg = false;
            if (window.betaFriendlyId || TDev.dbg || /localhost/.test(url) || /consolelog/.test(url))
                TDev.isBeta = true;
            if (/nobeta/.test(url))
                TDev.isBeta = false;
            Browser.useConsoleLog = TDev.isBeta && !!console && !!console.log;
            Browser.startTimestamp = new Date().getTime();
            if (window.touchDevelopExec || window.mcefQuery || window.cordova) {
                Browser.isHosted = true;
                Browser.screenshots = true;
            }
            if (window.isNodeJS) {
                Browser.isNodeJS = true;
                Browser.isHeadless = true;
            }
            if (window.localProxy || Browser.isNodeJS) {
                Browser.localProxy = true;
            }
            if (window.cordova)
                Browser.inCordova = true;
            var userAgent = Browser.isNodeJS ? "NodeJS" : window.navigator.userAgent;
            var addCap = function (c) {
                Browser.platformCaps.push(c);
            };
            if (!Browser.isNodeJS) {
                Browser.webRunner = !!window.webRunner;
                Browser.webAppImplicit = !!window.webAppImplicit;
                Browser.deviceMotion = !!window.DeviceMotionEvent;
                Browser.deviceOrientation = !!window.DeviceOrientationEvent;
                Browser.deviceHeading = Browser.deviceOrientation;
            }
            var flags = (window.runtimeFlags || "").split(/,/);
            if (flags.indexOf("notifyBack") >= 0)
                Browser.notifyBackToHost = true;
            if (flags.indexOf("logToHost") >= 0)
                Browser.logToHost = true;
            if (flags.indexOf("noNetwork") >= 0)
                Browser.noNetwork = true;
            if (/Silk|Kindle/.test(userAgent)) {
                if (/ Android [123]\./.test(userAgent))
                    Browser.browser = 10 /* silkOld */;
                else
                    Browser.browser = 11 /* silk */;
                Browser.isTablet = true;
            }
            else if (/ Trident\/[7-9]/.test(userAgent)) {
                Browser.browser = 2 /* ie11 */;
                Browser.isMobile = / IEMobile\//.test(userAgent);
                if (Browser.isMobile)
                    Browser.isCellphone = true;
                else if (window.navigator.msMaxTouchPoints)
                    Browser.isTablet = true;
                else
                    Browser.isDesktop = true;
                Browser.hasHardwareBack = Browser.isCellphone;
                Browser.isTrident = true;
            }
            else if (/Maxthon\//.test(userAgent)) {
                Browser.browser = 14 /* maxthon */;
            }
            else if (/ Android /.test(userAgent)) {
                if (/ Chrome\//.test(userAgent)) {
                    Browser.browser = 6 /* chrome */;
                    setBrowserVersion("Chrome");
                }
                else if (/ Android [123]\./.test(userAgent))
                    Browser.browser = 4 /* android2 */;
                else
                    Browser.browser = 5 /* android4 */;
                if (/ Mobile /.test(userAgent))
                    Browser.isCellphone = true;
                else
                    Browser.isTablet = true;
                Browser.isAndroid = true;
                Browser.hasHardwareBack = true;
            }
            else if (/ Chrome\//.test(userAgent)) {
                Browser.browser = 6 /* chrome */;
                setBrowserVersion("Chrome");
                Browser.isDesktop = true;
            }
            else if (/ MSIE 1[0-9]/.test(userAgent)) {
                Browser.browser = 1 /* ie10 */;
                Browser.isMobile = / IEMobile\//.test(userAgent);
                if (Browser.isMobile)
                    Browser.isCellphone = true;
                else if (window.navigator.msMaxTouchPoints)
                    Browser.isTablet = true;
                else
                    Browser.isDesktop = true;
                Browser.hasHardwareBack = Browser.isCellphone;
                Browser.isTrident = true;
            }
            else if (/ MSIE [2-9]/.test(userAgent)) {
                Browser.browser = 3 /* ieOld */;
                Browser.isDesktop = true;
                Browser.isTrident = true;
            }
            else if (/BB10/.test(userAgent)) {
                Browser.browser = 15 /* bb10 */;
                Browser.isMobile = true;
                Browser.isCellphone = true;
            }
            else if (/\(iPad/.test(userAgent)) {
                Browser.browser = 9 /* safari */;
                setBrowserVersion("Version");
                Browser.isTablet = true;
                addCap("iPad");
            }
            else if (/\(iPhone/.test(userAgent)) {
                Browser.browser = 9 /* safari */;
                setBrowserVersion("Version");
                Browser.isCellphone = true;
                addCap("iPhone");
            }
            else if (/\(iPod/.test(userAgent)) {
                Browser.browser = 9 /* safari */;
                setBrowserVersion("Version");
                Browser.isCellphone = true;
                addCap("iPod");
            }
            else if (/Safari/.test(userAgent)) {
                Browser.browser = 9 /* safari */;
                setBrowserVersion("Version");
                Browser.isDesktop = true;
            }
            else if (/ Firefox\//.test(userAgent)) {
                Browser.browser = 8 /* firefox */;
                setBrowserVersion("Firefox");
                if (/Mobile/.test(userAgent))
                    Browser.isCellphone = true;
                else if (/Tablet/.test(userAgent))
                    Browser.isTablet = true;
                else
                    Browser.isDesktop = true;
                Browser.isAndroid = /Android/.test(userAgent);
                Browser.isGecko = true;
            }
            else if (/Opera\//.test(userAgent)) {
                Browser.browser = 12 /* opera */;
            }
            else if (/NodeJS/.test(userAgent)) {
                Browser.browser = 13 /* nodeJS */;
                Browser.useConsoleLog = true;
            }
            if (Browser.inCordova)
                addCap("cordova");
            if (Browser.isTrident) {
                Browser.videoTracks = false;
                Browser.directionAuto = false;
            }
            if (/lowMemory/.test(url))
                Browser.lowMemory = true;
            if (/noAnim/.test(url))
                Browser.noAnimations = true;
            Browser.isTouchDevice = Browser.isCellphone || Browser.isTablet;
            if (Browser.isMobile === undefined)
                Browser.isMobile = Browser.isTouchDevice;
            Browser.isWebkit = /WebKit/.test(userAgent);
            if (Browser.isWebkit) {
                var m = userAgent.match(/WebKit\/(\d+)\./);
                if (m)
                    Browser.webkitVersion = parseInt(m[1]);
            }
            Browser.isMacOSX = /Macintosh/.test(userAgent);
            if (/Windows NT/.test(userAgent))
                Browser.isWindows = true;
            if (/Windows NT (6.[2-9]|[789])/.test(userAgent))
                Browser.isWindows8plus = true;
            Browser.mobileWebkit = Browser.isWebkit && Browser.isMobile;
            if (!Browser.isMobile)
                Browser.assumeMouse = true;
            Browser.builtinTouchToPan = true;
            Browser.isMobileSafari = (Browser.browser == 9 /* safari */ && Browser.isMobile);
            if (Browser.isMobileSafari) {
                var m = userAgent.match(/Safari\/([^.]*)/);
                Browser.isMobileSafariOld = (!Browser.browserVersion || Browser.browserVersion < 8) && m && m.length > 1 && parseInt(m[1]) < 7534;
            }
            if (Browser.isMobileSafari && !/Safari/.test(userAgent) && !window.navigator.standalone) {
                Browser.isEmbedded = true;
            }
            if ((Browser.browser == 1 /* ie10 */ || Browser.browser == 2 /* ie11 */) && !window.applicationCache) {
                Browser.isEmbedded = true;
            }
            var w = window;
            if (w.indexedDB || w.mozIndexedDB || w.msIndexedDB) {
                Browser.canIndexedDB = true;
            }
            if (w.openDatabase || Browser.inCordova) {
                Browser.canWebSql = true;
            }
            if (Browser.isMobile && Browser.browser == 9 /* safari */ && /CriOS/.test(userAgent)) {
                Browser.browser = 7 /* chromeiOS */;
                setBrowserVersion("CriOS");
            }
            if (Browser.isWebkit) {
                if (!Browser.isMobileSafari)
                    Browser.brokenColumns = true;
                if (Browser.isAndroid)
                    Browser.brokenGradient = true;
            }
            if (Browser.isDesktop) {
                Browser.deviceMotion = false;
                Browser.deviceOrientation = false;
            }
            if (Browser.isMobileSafari && Browser.webkitVersion >= 537) {
                Browser.brokenBackButton = true;
                Browser.brokenResize = true;
            }
            if (/Linux armv7/.test(userAgent)) {
                Browser.isRaspberryPiDebian = true;
                Browser.noAnimations = true;
                Browser.noStorage = true;
                Browser.lowMemory = true;
            }
            Browser.browserShortName = browserName(Browser.browser);
            if (Browser.isCellphone)
                Browser.browserShortName += ".phone";
            else if (Browser.isTablet)
                Browser.browserShortName += ".tablet";
            else
                Browser.browserShortName += ".desktop";
            if (Browser.inCordova)
                Browser.browserShortName += ".cordova";
            addCap(Browser.browserShortName);
            addCap(browserName(Browser.browser));
            if (Browser.isCellphone)
                addCap("cellphone");
            if (Browser.isTablet)
                addCap("tablet");
            if (Browser.isTouchDevice)
                addCap("touch");
            if (Browser.isMobile)
                addCap("mobile");
            if (Browser.isMacOSX)
                addCap("macOSX");
            if (Browser.assumeMouse)
                addCap("assumeMouse");
            if (Browser.isWindows8plus) {
                addCap("win");
                addCap("win8plus");
            }
            if (Browser.isAndroid)
                addCap("android");
            if (/X11/.test(userAgent))
                addCap("x11");
            if (/Windows NT 5.1/.test(userAgent)) {
                addCap("win");
                addCap("winXP");
            }
            if (/Windows NT 6.0/.test(userAgent)) {
                addCap("win");
                addCap("winVista");
            }
            if (/Windows NT 6.1/.test(userAgent)) {
                addCap("win");
                addCap("win7");
            }
            if (Browser.isMobileSafari || (Browser.isMobile && (Browser.browser == 1 /* ie10 */ || Browser.browser == 2 /* ie11 */))) {
                Browser.audioDataUrls = false;
            }
            if (Browser.mobileWebkit)
                Browser.touchStart = true;
            Browser.canWriteLocalStorage = false;
            if (typeof window == "object" && typeof window.localStorage == "object" && window.localStorage.removeItem)
                try {
                    var s = Browser.startTimestamp + "";
                    window.localStorage["test"] = s;
                    if (window.localStorage["test"] == s) {
                        Browser.canWriteLocalStorage = true;
                        window.localStorage.removeItem("test");
                    }
                }
                catch (e) {
                }
            Browser.dragAndDrop = !Browser.isNodeJS && !Browser.isMobile && document && document.createElement && 'draggable' in document.createElement('span');
        }
        Browser.detect = detect;
        var getServiceUrl = function () { return (window.rootUrl); };
        function unsupportedMessage(what, path) {
            if (what === void 0) { what = "Touch Develop"; }
            if (path === void 0) { path = ""; }
            var message = function (problemHTML, fixHTML) {
                if (fixHTML === void 0) { fixHTML = undefined; }
                return { problemHTML: problemHTML, fixHTML: fixHTML };
            };
            var genericMessage = function (problemHTML, upgradedBrowserName) {
                if (upgradedBrowserName === void 0) { upgradedBrowserName = undefined; }
                return message(problemHTML, upgradedBrowserName ? "<p>Follow these easy steps to run " + what + " on your device:</p>" + "<ol class='light'><li>open <b>" + upgradedBrowserName + "</b></li><li>navigate to <u>" + path + "</u></li></ol>" + "<p>You can copy&amp;paste the link into " + upgradedBrowserName + ".</p>" : undefined);
            };
            if (Browser.isEmbedded)
                return genericMessage("<p>It seems you're running " + what + " inside of another app.</p>", "your regular internet browser");
            var olderAndroidMessage = function (problemHTML) { return message(problemHTML, "<p>Follow these easy steps to run " + what + " on Android:</p>" + "<ol class='light'><li><b>try to install the latest <a href='market://details?id=org.mozilla.firefox&hl=en'>Firefox Browser</a></b> from the Google Play Store</li>" + "<li>open <u>" + path + "</u> in the Chrome Browser</li></ol>" + "<p>You can copy&amp;paste the link into Firefox.</p>"); };
            var chromeAndroidMessage = function (problemHTML) { return message(problemHTML, "<p>Follow these easy steps to run " + what + " on Android:</p>" + "<ol class='light'><li><b>install the latest <a href='market://details?id=com.android.chrome&hl=en'>Chrome Browser</a> or <a href='market://details?id=org.mozilla.firefox&hl=en'>Firefox Browser</a> or <a href='market://details?id=com.opera.browser&hl=en'>Opera Browser</a> </b> from the Google Play Store</li>" + "<li>open <u>" + path + "</u> in the Chrome Browser</li></ol>" + "<p>You can copy&amp;paste the link into the installed browser.</p>"); };
            var upgradeMessage = function (problemHTML) { return message(problemHTML, "<p>Follow these easy steps to run " + what + " on your device:</p>" + "<ol class='light'><li>upgrade your browser to the latest version</li><li>navigate to <u>" + path + "</u></li></ol>" + "<p>You can copy&amp;paste the link into your upgraded browser.</p>"); };
            switch (Browser.browser) {
                case 3 /* ieOld */:
                    return message(what + " does not work with Internet Explorer versions earlier than 10.");
                case 10 /* silkOld */:
                    return message(what + " does not work with the Silk browser in Kindle Fire 1st Gen. Please upgrade to Kindle Fire 2nd Gen or Kindle Fire HD.");
                case 12 /* opera */:
                    return genericMessage(what + " does not work with Opera. Please use Internet Explorer 10+, Chrome or Firefox.", "one of the suggested browsers");
                case 9 /* safari */:
                    if (Browser.isMobileSafariOld)
                        return upgradeMessage("Please upgrade to the latest version of iOS / Safari.");
                    if (Browser.isMacOSX && Browser.browserVersion2 < 6)
                        return genericMessage("Safari 5 and older are not supported. Please upgrade Safari or <a href='http://www.google.com/mac/'>install Chrome</a> or <a href='http://www.mozilla.org/en-US/firefox/new/'>Firefox</a>.", "the upgraded browser");
                    if (Browser.isTouchDevice)
                        break;
                    if (Browser.isMacOSX)
                        break;
                    return genericMessage(what + " is not supported in Safari on a PC. Please use Internet Explorer 10 or better, Chrome or Firefox.", "one of the suggested browsers");
                case 4 /* android2 */:
                    return olderAndroidMessage(what + " might require a newer version of Android.");
                case 5 /* android4 */:
                    return chromeAndroidMessage(what + " is not supported in the stock Android browser.");
                case 8 /* firefox */:
                    if (Browser.browserVersion < 16)
                        return upgradeMessage("You are using an outdated version of Firefox.");
                    if (Browser.isAndroid && Browser.browserVersion < 29)
                        return upgradeMessage("Please upgrade to the latest version of Firefox for Android.");
                    break;
                case 6 /* chrome */:
                    if (Browser.isMobileSafari && Browser.browserVersion < 38)
                        return upgradeMessage("<p>You are using an outdated version of Chrome.</p>");
                    if (Browser.isMobile && Browser.browserVersion < 19)
                        return chromeAndroidMessage("<p>You are using an outdated browser.</p>");
                    if (!Browser.isMobile && Browser.browserVersion < 21)
                        return upgradeMessage("<p>You are using an outdated version of Chrome.</p>");
                    break;
                case 7 /* chromeiOS */:
                    if (window.bbcMicrobit)
                        return message(what + " is not supported in Chrome for iOS. Please use Safari instead.");
                    break;
                case 1 /* ie10 */:
                    break;
                case 15 /* bb10 */:
                    break;
                case 14 /* maxthon */:
                case 0 /* unknown */:
                    return genericMessage(what + " is not supported in the current browser.", "<a href='/app/.browsers#supported'>a supported browser</a>");
            }
            if (!Browser.canWriteLocalStorage) {
                if (Browser.browser == 9 /* safari */)
                    return message("<p>You are running Safari in Private Mode or Private Browsing. " + what + " does not support this mode.</p>", "<p><b>Please disable Private Mode or Private Browsing, and then try again.</b></p>" + "<ul>" + "<li>In iOS 6, open 'Settings', select 'Safari', and turn 'Private Browsing' off.</li>" + "<li>In iOS 7, 8 and 8.1, open 'Safari', tap on the Bookmarks button, then tap on the 'Private' button in the lower left corner of the screen.</li>" + "</ul>");
                else
                    return genericMessage("<p>" + what + " does not seem to allow storing data.</p>", "regular internet browser");
            }
            Browser.canMemoryTable = !window.localStorage["disableMemoryTable"];
            if (!Browser.canWebSql && !Browser.canIndexedDB && !Browser.canMemoryTable) {
                if (Browser.browser == 1 /* ie10 */ || Browser.browser == 2 /* ie11 */)
                    return genericMessage("<p>You are running Internet Explorer in the InPrivate mode. " + what + " does not support this mode, as " + what + " needs to maintain a database of installed scripts, but the InPrivate mode does not allow the use of databases.</p>", "a regular Internet Explorer window");
                else
                    return genericMessage("<p>Your browser does not seem to support databases.</p>", "<a href='/app/.browsers#supported'>a supported browser </a>");
            }
            return null;
        }
        function supportMemoryTable(value) {
            if (value) {
                if (Browser.canWriteLocalStorage)
                    window.localStorage.removeItem('disableMemoryTable');
                Browser.canMemoryTable = true;
            }
            else {
                if (Browser.canWriteLocalStorage)
                    window.localStorage["disableMemoryTable"] = "1";
                Browser.canMemoryTable = false;
            }
        }
        Browser.supportMemoryTable = supportMemoryTable;
        function browsersHtml() {
            var url = window.browsersUrl;
            if (url)
                window.location.href = window.browsersUrl;
        }
        function supportedBrowsers(descriptionHTML, fixHTML) {
            if (fixHTML === void 0) { fixHTML = undefined; }
            var e = document.getElementById("browserMessage");
            if (e) {
                var happy = window.browserSupported;
                e.innerHTML = (happy ? "" : fixHTML ? "<p>There is only a slight problem:</p>" : "<p>There is a problem:</p>") + descriptionHTML;
                if (happy)
                    e.style.color = "green";
                if (fixHTML) {
                    e = document.getElementById("browserAlmost");
                    if (e)
                        e.innerHTML = "<p>You are almost there!</p>";
                    e = document.getElementById("browserFix");
                    if (e)
                        e.innerHTML = fixHTML;
                }
            }
            e = document.getElementById("userAgent");
            if (e)
                e.innerText = "User Agent: " + window.navigator.userAgent;
        }
        function reportBrowser(browser) {
            try {
                if (window.tdlite)
                    return;
                var serviceUrl = getServiceUrl();
                if (!serviceUrl)
                    return;
                if (window.localStorage) {
                    if (window.localStorage["browserReported"])
                        return;
                    try {
                        window.localStorage["browserReported"] = "1";
                    }
                    catch (e) {
                    }
                }
                var now = new Date();
                var userAgent = window.navigator.userAgent;
                var dateStr = now.getFullYear() + "." + (now.getMonth() + 1) + "." + now.getDate();
                var se = {};
                se["browser." + browser] = 1;
                var ticksReq = {
                    dateStr: dateStr,
                    sessionEvents: se,
                    platform: [],
                    jsUrl: window.mainJsName
                };
                var client = new XMLHttpRequest();
                client.open("POST", serviceUrl + "/api/ticks");
                client.send(JSON.stringify(ticksReq));
                if (browser == "unknown") {
                    var msg = "Unsupported-" + browser;
                    var bug = {
                        exceptionConstructor: msg,
                        exceptionMessage: msg,
                        context: "detection",
                        currentUrl: "",
                        scriptId: "",
                        stackTrace: "browserNotSupported",
                        sourceURL: "",
                        line: -1,
                        eventTrace: "",
                        userAgent: userAgent,
                        resolution: "",
                        jsUrl: window.mainJsName,
                        timestamp: now.getTime(),
                        platform: [],
                    };
                    var client = new XMLHttpRequest();
                    client.open("POST", serviceUrl + "/api/bug");
                    client.send(JSON.stringify(bug));
                }
            }
            catch (e) {
            }
        }
        function statusMsg(m) {
            var f = window.statusMsg;
            if (f)
                f(m);
        }
        function check(isIndex, what, path) {
            if (what === void 0) { what = undefined; }
            if (path === void 0) { path = undefined; }
            if (window.isNodeJS) {
                detect();
                return;
            }
            statusMsg("browser detector started");
            var userAgent = window.navigator.userAgent;
            if (/ IEMobile\/[3-9]/.test(userAgent)) {
                statusMsg("IEMobile userAgent: " + userAgent);
                if (isIndex) {
                    reportBrowser("IEMobile");
                    browsersHtml();
                }
                else
                    supportedBrowsers("<p>The " + what + " Web App doesn't work on Windows Phone 7.</p>");
            }
            else if (/ MSIE [6789]/.test(userAgent)) {
                statusMsg("IEx userAgent: " + userAgent);
                if (isIndex) {
                    if (/ MSIE 9/.test(userAgent))
                        reportBrowser("IE9");
                    else
                        reportBrowser("IE8-");
                    browsersHtml();
                }
                else {
                    supportedBrowsers("<p>" + what + " doesn't work with Internet Explorer 9 or earlier.<p/>", '<p>You can upgrade your browser to <a href="http://windows.microsoft.com/en-us/internet-explorer/downloads/ie-10/worldwide-languages">Internet Explorer 10</a> if you are running Windows 7, ' + 'or upgrade your operating system to <a href="http://windows.microsoft.com/en-US/windows/buy">Windows 8</a> which comes with Internet Explorer 10, or try the latest version of Chrome or Firefox.</p>');
                }
            }
            else {
                statusMsg("browser detector processing");
                detect();
                var um = unsupportedMessage(what, path);
                if (!um || /ignoreAgent/.test(document.URL) || Browser.inCordova) {
                    statusMsg("browser detector success: " + Browser.browserShortName);
                    window.browserSupported = true;
                    if (isIndex)
                        reportBrowser(Browser.browserShortName);
                    else
                        supportedBrowsers("<p>Your browser is supported.</p>");
                }
                else {
                    statusMsg("browser detector failed: " + Browser.browserShortName);
                    if (isIndex) {
                        reportBrowser(Browser.browserShortName);
                        browsersHtml();
                    }
                    else {
                        supportedBrowsers(um.problemHTML, um.fixHTML);
                    }
                }
            }
        }
        Browser.check = check;
    })(Browser = TDev.Browser || (TDev.Browser = {}));
})(TDev || (TDev = {}));
'use strict';
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var TDev;
(function (TDev) {
    var RT;
    (function (RT) {
        var RTValue = (function () {
            function RTValue() {
                this.on_render_heap = false;
                this.versioncounter = 1;
                this.jsonExportMark = false;
            }
            RTValue.normalize = function (n) {
                return n < 0 ? 0 : n > 1 ? 1 : n;
            };
            RTValue.prototype.post_to_wall = function (s) {
                if (!s.rt.mayPostToWall(s.rt.getCurrentPage()))
                    TDev.Util.userError("cannot post to the wall here");
                var box = TDev.WallBox.CreateOrRecycleLeafBox(s.rt, this);
                if (!box.getContent()) {
                    var e;
                    try {
                        e = this.getViewCore(s, box);
                    }
                    catch (e) {
                        TDev.Util.reportError('getViewCore crash: ' + (typeof this), e, false);
                        e = TDev.div('item item-crash', ':( something went wrong');
                    }
                    if (box instanceof TDev.WallBox)
                        s.rt.addTapEvent(e, this.rtType(), box, this);
                    box.setContent(e);
                    try {
                        this.updateViewCore(s, box);
                    }
                    catch (e) {
                        TDev.Util.reportError('updateViewCore crash: ' + (typeof this), e, false);
                    }
                }
                if (box instanceof TDev.WallBox && box.getDepth() === 1)
                    s.rt.renderBox(box);
            };
            RTValue.prototype.viewIsRefreshable = function () {
                return false;
            };
            RTValue.prototype.refreshViews = function (s) {
            };
            RTValue.prototype.debuggerDisplay = function (clickHandler) {
                return TDev.div("wall-text", this.getShortStringRepresentation()).withClick(clickHandler);
            };
            RTValue.prototype.getViewCore = function (s, b) {
                return TDev.div("wall-text", this.getShortStringRepresentation());
            };
            RTValue.prototype.updateViewCore = function (s, b) {
            };
            RTValue.prototype.getShortStringRepresentation = function () {
                try {
                    if (this.to_string)
                        return this.to_string();
                    else
                        return this.toString();
                }
                catch (e) {
                    TDev.Util.reportError("getShortStringRepresentation", e, false);
                    return "???";
                }
            };
            RTValue.prototype.toString = function () {
                return "[" + this.rtType() + "]";
            };
            RTValue.prototype.isSerializable = function () {
                return false;
            };
            RTValue.prototype.rtType = function () {
                return "RTValue";
            };
            RTValue.mkPicker = function (p, v, n, qn) {
                var fp = p;
                p.set(v);
                fp.userName = n;
                fp.quotedName = qn;
                return fp;
            };
            RTValue.prototype.exportJson = function (ctx) {
                return undefined;
            };
            RTValue.prototype.importJson = function (ctx, json) {
                return undefined;
            };
            RTValue.prototype.jsonExportKey = function (ctx) {
                return undefined;
            };
            RTValue.prototype.toJsonKey = function () {
                throw new Error("cannot use " + this.rtType() + " as a key (it is not a value)");
            };
            RTValue.prototype.keyCompareTo = function (other) {
                throw new Error("cannot use " + this.rtType() + " as a key (it is not a value)");
            };
            RTValue.prototype.isDefaultValue = function () {
                return false;
            };
            RTValue.CompareKeys = function (a, b) {
                if (!a)
                    return (b ? -1 : 0);
                else
                    return (b ? a.keyCompareTo(b) : 1);
            };
            RTValue.copySpecificImpls = function (classPrefix) {
                var rt = TDev.RT;
                var moduleOverrides = rt[classPrefix];
                Object.keys(moduleOverrides).forEach(function (k) {
                    if (/Init$/.test(k)) {
                        var f = moduleOverrides[k];
                        if (f instanceof Function)
                            f();
                    }
                });
                var rx = new RegExp("^" + classPrefix);
                function copyFrom(src) {
                    Object.keys(src).forEach(function (k) {
                        if (rx.test(k)) {
                            var baseName = k.slice(classPrefix.length);
                            var derived = src[k].prototype;
                            if (!derived)
                                return;
                            var base = rt[baseName].prototype;
                            Object.keys(derived).forEach(function (m) {
                                if (m != "constructor" && m != "rtType")
                                    base[m] = derived[m];
                            });
                        }
                    });
                }
                copyFrom(rt);
                copyFrom(moduleOverrides);
            };
            RTValue.setupTypeTable = function () {
                var setClsName = function (name, fn) {
                    fn.prototype.rtType = function () { return name; };
                };
                for (var cls in TDev.RT) {
                    if (!TDev.RT.hasOwnProperty(cls))
                        continue;
                    var fn = TDev.RT[cls];
                    if (fn.prototype && fn.prototype.rtType && !fn.prototype.noMagicRtType) {
                        if (!fn.prototype.hasOwnProperty("rtType"))
                            setClsName(cls, fn);
                    }
                }
            };
            RTValue.initApis = function () {
                RTValue.setupTypeTable();
                if (TDev.Browser.isNodeJS)
                    this.copySpecificImpls("Node");
                else if (TDev.Browser.inCordova)
                    this.copySpecificImpls("Cordova");
            };
            return RTValue;
        })();
        RT.RTValue = RTValue;
        var DisposableHandler = (function () {
            function DisposableHandler(handler) {
                this.handler = handler;
            }
            DisposableHandler.prototype.dispose = function () {
                this.handler();
            };
            return DisposableHandler;
        })();
        RT.DisposableHandler = DisposableHandler;
        var RTDisposableValue = (function (_super) {
            __extends(RTDisposableValue, _super);
            function RTDisposableValue(rt) {
                _super.call(this);
                this.rt = rt;
                this.rt.disposables.push(this);
            }
            RTDisposableValue.prototype.dispose = function () {
                var i = this.rt.disposables.indexOf(this);
                if (i > 0)
                    this.rt.disposables.splice(i, 1);
            };
            return RTDisposableValue;
        })(RTValue);
        RT.RTDisposableValue = RTDisposableValue;
        var DecoratorCollection = (function (_super) {
            __extends(DecoratorCollection, _super);
            function DecoratorCollection() {
                _super.call(this);
            }
            return DecoratorCollection;
        })(RTValue);
        RT.DecoratorCollection = DecoratorCollection;
    })(RT = TDev.RT || (TDev.RT = {}));
})(TDev || (TDev = {}));
'use strict';
var TDev;
(function (TDev) {
    var JsonExportCtx = (function () {
        function JsonExportCtx(stackframe, fullcloudstate) {
            if (fullcloudstate === void 0) { fullcloudstate = false; }
            this.stackframe = stackframe;
            this.fullcloudstate = fullcloudstate;
            this.depth = 0;
        }
        JsonExportCtx.prototype.push = function (node) {
            TDev.Util.assert(!node.jsonExportMark);
            node.jsonExportMark = true;
            this.depth++;
        };
        JsonExportCtx.prototype.pop = function (node) {
            TDev.Util.assert(node.jsonExportMark);
            node.jsonExportMark = false;
            this.depth--;
        };
        JsonExportCtx.prototype.encodeObjectNode = function (node, keys, vals) {
            TDev.Util.assert(keys.length == vals.length);
            var json = {};
            var exportkey = node.jsonExportKey(this);
            if (exportkey)
                json["⌹id"] = exportkey;
            this.encodeValues(vals);
            for (var i = 0; i < vals.length; i++) {
                var val = vals[i];
                if (val !== undefined)
                    json[keys[i]] = val;
            }
            return json;
        };
        JsonExportCtx.prototype.encodeArrayNode = function (node, vals) {
            TDev.Util.assert(!node.jsonExportKey(this));
            this.encodeValues(vals);
            return vals;
        };
        JsonExportCtx.prototype.encodeValues = function (vals) {
            var recursed;
            for (var i = 0; i < vals.length; i++) {
                var v = vals[i];
                if (v && (v instanceof TDev.RT.RTValue)) {
                    var k = v.jsonExportKey(this);
                    if (k !== undefined) {
                        if (v.jsonExportMark || (this.fullcloudstate && this.depth > 0)) {
                            vals[i] = k;
                        }
                        else {
                            v.jsonExportMark = true;
                            if (!recursed)
                                recursed = new Array();
                            recursed.push(v);
                        }
                    }
                }
            }
            for (var i = 0; i < vals.length; i++) {
                var val = vals[i];
                if (val !== undefined && val !== null) {
                    var t = typeof val;
                    if (t == "function")
                        vals[i] = undefined;
                    else if (t !== "boolean" && t !== "string" && t !== "number")
                        vals[i] = val.exportJson(this);
                }
            }
            if (recursed)
                recursed.forEach(function (rv) {
                    TDev.Util.assert(rv.jsonExportMark);
                    rv.jsonExportMark = false;
                });
        };
        return JsonExportCtx;
    })();
    TDev.JsonExportCtx = JsonExportCtx;
    var JsonImportCtx = (function () {
        function JsonImportCtx(s) {
            this.s = s;
            this.mapping = {};
        }
        JsonImportCtx.prototype.map = function (table, id) {
            return id ? (this.mapping[table + id] || id) : id;
        };
        JsonImportCtx.prototype.addmapping = function (table, from, to) {
            this.mapping[table + from] = to;
        };
        JsonImportCtx.prototype.importString = function (source, key) {
            var v = source ? source[key] : undefined;
            return (typeof v == "string") ? v : undefined;
        };
        JsonImportCtx.prototype.importNumber = function (source, key) {
            var v = source ? source[key] : undefined;
            if (typeof v == "string")
                v = Number(v);
            return (typeof v == "number") ? v : undefined;
        };
        JsonImportCtx.prototype.importBoolean = function (source, key) {
            var v = source ? source[key] : undefined;
            return (typeof v == "boolean") ? v : undefined;
        };
        JsonImportCtx.prototype.importDateTime = function (source, key) {
            var v = source ? source[key] : undefined;
            return TDev.RT.DateTime.mkFromJson(this, v);
        };
        JsonImportCtx.prototype.importColor = function (source, key) {
            var v = source ? source[key] : undefined;
            return TDev.RT.Color.mkFromJson(this, v);
        };
        JsonImportCtx.prototype.importJsonObject = function (source, key) {
            var v = source ? source[key] : undefined;
            return TDev.RT.JsonObject.mkFromJson(this, v);
        };
        JsonImportCtx.prototype.importLocation = function (source, key) {
            var v = source ? source[key] : undefined;
            return TDev.RT.Location_.mkFromJson(this, v);
        };
        JsonImportCtx.prototype.importVector3 = function (source, key) {
            var v = source ? source[key] : undefined;
            return TDev.RT.Vector3.mkFromJson(this, v);
        };
        JsonImportCtx.prototype.importUser = function (source, key) {
            var v = source ? source[key] : undefined;
            return TDev.RT.User.mkFromJson(this, v);
        };
        JsonImportCtx.prototype.importStringMap = function (source, target, key) {
            var v = source ? source[key] : undefined;
            if (!v)
                return undefined;
            if (!target)
                target = new TDev.RT.StringMap();
            return target.importJson(this, v);
        };
        JsonImportCtx.prototype.importNumberMap = function (source, target, key) {
            var v = source ? source[key] : undefined;
            if (!v)
                return undefined;
            if (!target)
                target = new TDev.RT.NumberMap();
            return target.importJson(this, v);
        };
        JsonImportCtx.prototype.importCollection = function (source, target, key, typeInfo) {
            var v = source ? source[key] : undefined;
            if (!v)
                return undefined;
            if (!target) {
                target = TDev.RT.Collection.fromArray([], typeInfo);
            }
            return target.importJson(this, v);
        };
        JsonImportCtx.prototype.importJsonBuilder = function (source, target, key) {
            var v = source ? source[key] : undefined;
            if (!v)
                return undefined;
            if (!target)
                target = new TDev.RT.JsonBuilder();
            return target.importJson(this, v);
        };
        JsonImportCtx.prototype.importLink = function (source, target, key) {
            var v = source ? source[key] : undefined;
            if (!v)
                return undefined;
            if (!target)
                target = new TDev.RT.Link();
            return target.importJson(this, v);
        };
        JsonImportCtx.prototype.importOAuthResponse = function (source, target, key) {
            var v = source ? source[key] : undefined;
            if (!v)
                return undefined;
            if (!target)
                target = new TDev.RT.OAuthResponse();
            return target.importJson(this, v);
        };
        JsonImportCtx.prototype.importRecord = function (source, target, key, singleton) {
            var v = source ? source[key] : undefined;
            if (!v)
                return undefined;
            return singleton.importJsonRecord(this, target, v, false);
        };
        return JsonImportCtx;
    })();
    TDev.JsonImportCtx = JsonImportCtx;
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var Cloud;
    (function (Cloud) {
        Cloud.lite = true;
        Cloud.fullTD = true;
        Cloud.litePermissions = {};
        Cloud._migrate;
        Cloud.useNativeCompilation = false;
        Cloud.config = {
            searchApiKey: "E43690E2B2A39FEB68117546BF778DB8",
            searchUrl: "https://tdsearch.search.windows.net",
            cdnUrl: "https://az31353.vo.msecnd.net",
            primaryCdnUrl: "https://az31353.vo.msecnd.net",
            altCdnUrls: [
                "https://az31353.vo.msecnd.net",
                "https://touchdevelop.blob.core.windows.net",
                "http://cdn.touchdevelop.com",
            ],
            translateCdnUrl: "https://tdtutorialtranslator.blob.core.windows.net",
            translateApiUrl: "https://tdtutorialtranslator.azurewebsites.net/api",
            workspaceUrl: null,
            rootUrl: "https://www.touchdevelop.com",
            shareUrl: "http://tdev.ly",
            hashtag: "#TouchDevelop",
            liteVersion: null,
            helpPath: "/docs",
            specHelpPaths: {},
            topicPath: "/docs/",
            legalButtons: [
                { name: "terms of use", url: "/terms-of-use" },
                { name: "privacy and cookies", url: "/privacy" },
                { name: "support", url: "https://touchdevelop.uservoice.com" }
            ],
            doNothingText: "do nothing",
            hintLevel: "full",
            userVoice: "touchdevelop",
            tutorialsid: "vjsseqks",
            showcaseid: "njigpnyj",
            primaryLocale: "en-US",
            cloudId: "touchdevelop.com",
            scriptRenderers: {
                "blocks": function (id) {
                    var url = TDev.Ticker.mainJsName.replace(/main.js$/, "");
                    var match = url.match(/(https?:\/\/[^\/]+)(.*)/);
                    var origin = match[1];
                    if (/http:\/\/localhost/.test(origin))
                        origin += "/editor/local";
                    return origin + "/blockly/render.html?id=" + encodeURIComponent(id);
                }
            },
            microbitGitTag: "v79"
        };
        function isArtUrl(url) {
            if (!url)
                return false;
            if (/\.\/art\//i.test(url))
                return true;
            for (var i = 0; i < Cloud.config.altCdnUrls.length; ++i) {
                var pubUrl = Cloud.config.altCdnUrls[i] + "/pub/";
                if (url.substr(0, pubUrl.length) == pubUrl)
                    return true;
            }
            return false;
        }
        Cloud.isArtUrl = isArtUrl;
        function stripCdnUrl(url) {
            if (!isArtUrl(url))
                return null;
            return url.replace(/^.*?\/pub\//, "");
        }
        function toCdnUrl(url, thumbContainer) {
            if (thumbContainer === void 0) { thumbContainer = ""; }
            if (!thumbContainer)
                thumbContainer = "pub";
            var tmp = stripCdnUrl(url);
            if (tmp)
                return Cloud.config.primaryCdnUrl + "/" + thumbContainer + "/" + tmp;
            else
                return url;
        }
        Cloud.toCdnUrl = toCdnUrl;
        function getArtId(url) {
            var tmp = stripCdnUrl(url);
            if (/^\w+/.test(tmp))
                return tmp;
            else
                return null;
        }
        Cloud.getArtId = getArtId;
        function artCssImg(id, thumb) {
            if (thumb === void 0) { thumb = false; }
            return TDev.HTML.cssImage(Cloud.artUrl(id, thumb));
        }
        Cloud.artCssImg = artCssImg;
        function artUrl(id, thumb) {
            if (thumb === void 0) { thumb = false; }
            return id ? TDev.HTML.proxyResource(TDev.Util.fmt("{0}/{1}/{2:uri}", Cloud.config.primaryCdnUrl, thumb ? "thumb" : "pub", id)) : undefined;
        }
        Cloud.artUrl = artUrl;
        function setPermissions(perms) {
            if (perms === void 0) { perms = null; }
            if (perms !== null)
                localStorage['litePermissions'] = perms;
            Cloud.litePermissions = {};
            (localStorage['litePermissions'] || "").split(",").forEach(function (t) {
                if (t)
                    Cloud.litePermissions[t] = true;
            });
            if (/http:\/\/localhost/i.test(document.URL))
                Cloud.litePermissions['internal'] = true;
        }
        Cloud.setPermissions = setPermissions;
        function hasPermission(perm) {
            return Cloud.litePermissions.hasOwnProperty(perm) || Cloud.litePermissions.hasOwnProperty("admin");
        }
        Cloud.hasPermission = hasPermission;
        function isRestricted() {
            return !Cloud.fullTD;
        }
        Cloud.isRestricted = isRestricted;
        function getServiceUrl() {
            return Cloud.config.rootUrl;
        }
        Cloud.getServiceUrl = getServiceUrl;
        function mkLegalDiv() {
            var link = function (text, lnk) { return TDev.HTML.mkA(null, getServiceUrl() + lnk, "_blank", text); };
            return TDev.div("wall-dialog-body", TDev.div("smallText", TDev.lf("Publishing is subject to our "), link(TDev.lf("terms of use"), "/terms-of-use"), TDev.lf(". Please read our "), link(TDev.lf("privacy policy"), "/privacy"), "."));
        }
        Cloud.mkLegalDiv = mkLegalDiv;
        Cloud.authenticateAsync = function (activity, redirect, dontRedirect, sensitive) {
            if (redirect === void 0) { redirect = false; }
            if (dontRedirect === void 0) { dontRedirect = false; }
            if (sensitive === void 0) { sensitive = false; }
            if (!sensitive && !Cloud.isAccessTokenExpired())
                return TDev.Promise.as(true);
            function loginAsync() {
                var loginUrl = Cloud.getServiceUrl() + "/oauth/dialog?response_type=token&" + "client_id=webapp" + "&identity_provider=" + encodeURIComponent(Cloud.getIdentityProvider() || "");
                return TDev.RT.Web.oauth_v2_async(loginUrl, "touchdevelop").then(function (or) {
                    if (or.is_error())
                        return false;
                    else {
                        var id = or.others().at('id');
                        var oldid = Cloud.getUserId();
                        if (oldid && id != oldid) {
                            return false;
                        }
                        Cloud.setUserId(or.others().at('id'));
                        Cloud.setAccessToken(encodeURIComponent(or.access_token()));
                        Cloud.setIdentityProvider(or.others().at('identity_provider'));
                        return true;
                    }
                });
            }
            return Cloud.isOnlineWithPingAsync().then(function (isOnline) {
                if (!isOnline)
                    return TDev.Promise.as(false);
                var prevHash = (window.location.hash || "#").replace(/#/, "");
                var login = TDev.Login;
                if (login) {
                    if (!login.show || dontRedirect)
                        login = null;
                    if (!redirect && (!prevHash || /^(hub|list:.*:user:me:)/.test(prevHash)))
                        login = null;
                }
                var r = new TDev.PromiseInv();
                var m = new TDev.ModalDialog();
                if (sensitive)
                    m.addHTML(TDev.lf("<h3>we need you to sign in again</h3>") + "<p class='agree'>" + TDev.lf("Accessing private data requires verification of your sign in credentials.") + "</p>");
                else
                    m.addHTML(TDev.lf("<h3>{0:q} requires sign&nbsp;in</h3>", activity) + (!TDev.TheEditor ? "" : "<p class='agree'>" + TDev.lf("You can run and save your scripts locally, but to access your scripts from all devices, you need to be signed in. After you sign in, we will save and sync your scripts between your devices.") + "</p>"));
                m.fullWhite();
                var ignoreDismiss = false;
                m.add(TDev.div("wall-dialog-buttons", TDev.HTML.mkButton(TDev.lf("maybe later"), function () {
                    m.dismiss();
                }), TDev.HTML.mkButton(TDev.lf("sign in"), function () {
                    ignoreDismiss = true;
                    m.dismiss();
                    if (login)
                        login.show();
                    else
                        loginAsync().done(function (v) { return r.success(v); });
                })));
                m.onDismiss = function () {
                    if (!ignoreDismiss)
                        r.success(false);
                };
                m.show();
                return r;
            });
        };
        function anonMode(activity, restart, redirect) {
            if (restart === void 0) { restart = null; }
            if (redirect === void 0) { redirect = false; }
            if (Cloud.isOffline()) {
                Cloud.showModalOnlineInfo(TDev.lf("{0} requires online access", activity));
                return true;
            }
            if (Cloud.getUserId())
                return false;
            Cloud.authenticateAsync(activity, redirect).done(function (ok) {
                if (ok && restart)
                    restart();
            });
            return true;
        }
        Cloud.anonMode = anonMode;
        function parseAccessToken(h, onStateError, onUserError) {
            var stateMatch = h.match(/.*&state=([^&]*)/);
            var state = stateMatch ? stateMatch[1] : "";
            if (Cloud.oauthStates().indexOf(decodeURIComponent(state)) == -1) {
                onStateError();
                return false;
            }
            var token = h.match(/.*#access_token=([^&]*)/)[1];
            var m = h.match(/.*&identity_provider=([^&]*)/);
            var identityProvider = m ? decodeURIComponent(m[1]) : undefined;
            var id = h.match(/.*&id=([^&]*)/)[1];
            var expires = parseInt((h.match(/.*&expires_in=([^&]*)/) || ["0", "0"])[1]);
            var oldid = Cloud.getUserId();
            if (oldid && id != oldid) {
                onUserError();
                return false;
            }
            if (/.*[#&]dbg=true/.test(h))
                window.localStorage.setItem("dbg", "true");
            else
                window.localStorage.removeItem("dbg");
            Cloud.setUserId(id);
            Cloud.setIdentityProvider(identityProvider || "");
            Cloud.setAccessToken(token);
            return true;
        }
        Cloud.parseAccessToken = parseAccessToken;
        function hasAccessToken() {
            return !!getAccessToken();
        }
        Cloud.hasAccessToken = hasAccessToken;
        function getAccessToken() {
            return window.localStorage.getItem("access_token");
        }
        Cloud.getAccessToken = getAccessToken;
        function isAccessTokenExpired() {
            return !hasAccessToken() || !!window.localStorage.getItem("access_token_expired");
        }
        Cloud.isAccessTokenExpired = isAccessTokenExpired;
        function accessTokenExpired() {
            window.localStorage.setItem("access_token_expired", "1");
        }
        Cloud.accessTokenExpired = accessTokenExpired;
        function setAccessToken(token) {
            window.localStorage.removeItem("access_token_expired");
            if (!token)
                window.localStorage.removeItem("access_token");
            else
                window.localStorage.setItem("access_token", token);
        }
        Cloud.setAccessToken = setAccessToken;
        Cloud.getUserId = function () { return window.localStorage.getItem("userid"); };
        Cloud.currentReleaseId = "";
        function getWorldId() {
            var worldId = window.localStorage.getItem("worldId");
            if (!worldId)
                window.localStorage.setItem("worldId", worldId = "$webclient$-" + TDev.Util.guidGen());
            return worldId;
        }
        Cloud.getWorldId = getWorldId;
        function oauthStates() {
            var a = JSON.parse(window.localStorage.getItem("oauth_states") || "[]");
            if (a.length == 0)
                a = [TDev.Random.normalized().toString()];
            window.localStorage.setItem("oauth_states", JSON.stringify(a));
            return a;
        }
        Cloud.oauthStates = oauthStates;
        function setUserId(id) {
            if (!id)
                window.localStorage.removeItem("userid");
            else
                window.localStorage.setItem("userid", id);
        }
        Cloud.setUserId = setUserId;
        function getIdentityProvider() {
            return window.localStorage.getItem("identity_provider");
        }
        Cloud.getIdentityProvider = getIdentityProvider;
        function setIdentityProvider(id) {
            if (!id)
                window.localStorage.removeItem("identity_provider");
            else
                window.localStorage.setItem("identity_provider", id);
        }
        Cloud.setIdentityProvider = setIdentityProvider;
        function mergeProgress(oldData, data) {
            oldData = JSON.parse(JSON.stringify(oldData));
            Object.keys(data).forEach(function (id) {
                var oldProgress = oldData[id] || {};
                var progress = data[id];
                if (oldProgress.index === undefined || oldProgress.index <= progress.index) {
                    if (progress.guid)
                        oldProgress.guid = progress.guid;
                    oldProgress.index = progress.index;
                    if (progress.completed && (oldProgress.completed === undefined || oldProgress.completed > progress.completed))
                        oldProgress.completed = progress.completed;
                    oldProgress.numSteps = progress.numSteps;
                    oldProgress.lastUsed = progress.lastUsed;
                }
                oldData[id] = oldProgress;
            });
            return oldData;
        }
        function storeProgress(data) {
            var newData = mergeProgress(loadPendingProgress(), data);
            window.localStorage.setItem("progress", JSON.stringify(newData));
            window.localStorage.setItem("total_progress", JSON.stringify(mergeProgress(loadProgress(), data)));
        }
        Cloud.storeProgress = storeProgress;
        function clearPendingProgress(data) {
            var oldData = loadPendingProgress();
            Object.keys(data).forEach(function (id) {
                var oldProgress = oldData[id];
                var progress = data[id];
                var uploaded = oldProgress && (!oldProgress.guid || !progress.guid || oldProgress.guid == progress.guid) && (oldProgress.index === undefined || progress.index === undefined || oldProgress.index <= progress.index) && (oldProgress.completed === undefined || progress.completed === undefined || oldProgress.completed <= progress.completed);
                if (uploaded) {
                    delete oldData[id];
                }
            });
            window.localStorage.setItem("progress", JSON.stringify(oldData));
        }
        function loadProgress() {
            return loadPendingProgress("total_progress");
        }
        Cloud.loadProgress = loadProgress;
        function loadPendingProgress(name) {
            if (name === void 0) { name = "progress"; }
            return JSON.parse(window.localStorage.getItem(name) || "{}");
        }
        function isOffline() {
            return !isOnline();
        }
        Cloud.isOffline = isOffline;
        function isOnline() {
            var b = !TDev.Browser.noNetwork && (TDev.Browser.isNodeJS || window.navigator.onLine) && isTouchDevelopOnline();
            if (TDev.dbg && b && isChaosOffline() && TDev.RT.Math_.random(10) < 4)
                b = false;
            return b;
        }
        Cloud.isOnline = isOnline;
        function isOnlineWithPingAsync() {
            if (!isOnline())
                return TDev.Promise.as(false);
            return pingAsync();
        }
        Cloud.isOnlineWithPingAsync = isOnlineWithPingAsync;
        Cloud.transientOfflineMode = false;
        function isTouchDevelopOnline() {
            return !window.localStorage.getItem('offline_mode') && !Cloud.transientOfflineMode;
        }
        Cloud.isTouchDevelopOnline = isTouchDevelopOnline;
        function setTouchDevelopOnline(value) {
            if (value)
                window.localStorage.removeItem('offline_mode');
            else
                window.localStorage.setItem('offline_mode', "true");
        }
        Cloud.setTouchDevelopOnline = setTouchDevelopOnline;
        function isChaosOffline() {
            return !!window.localStorage.getItem('chaos_offline_mode');
        }
        Cloud.isChaosOffline = isChaosOffline;
        function setChaosOffline(value) {
            if (!value)
                window.localStorage.removeItem('chaos_offline_mode');
            else
                window.localStorage.setItem('chaos_offline_mode', "true");
        }
        Cloud.setChaosOffline = setChaosOffline;
        function offlineErrorAsync() {
            var msg = isTouchDevelopOnline() ? "offline mode is on" : "force offline mode is on";
            return new TDev.Promise(function (onSuccess, onError, onProgress) {
                var e = new Error(msg);
                e.status = 502;
                onError(e);
            });
        }
        Cloud.offlineErrorAsync = offlineErrorAsync;
        function canPublish() {
            return Cloud.getUserId() != "paema";
        }
        Cloud.canPublish = canPublish;
        function onlineInfo() {
            if (Cloud.isOffline()) {
                var msg = TDev.lf("You appear to be offline. ") + (isTouchDevelopOnline() ? TDev.lf("Please connect to the internet and try again.") : TDev.lf("Please go to the settings in the main hub to disable offline mode."));
                return msg;
            }
            else {
                return TDev.lf("You are online.");
            }
        }
        Cloud.onlineInfo = onlineInfo;
        function showOnlineInfoProgess() {
            TDev.HTML.showProgressNotification(onlineInfo(), true);
        }
        Cloud.showOnlineInfoProgess = showOnlineInfoProgess;
        function showModalOnlineInfo(title) {
            TDev.ModalDialog.info(title, onlineInfo());
        }
        Cloud.showModalOnlineInfo = showModalOnlineInfo;
        var appendAccessToken = function (url) {
            return (url + (/\?/.test(url) ? "&" : "?") + "access_token=" + getAccessToken() + "&world_id=" + encodeURIComponent(Cloud.getWorldId()) + "&release_id=" + encodeURIComponent(Cloud.currentReleaseId) + "&user_platform=" + encodeURIComponent(TDev.Browser.platformCaps.join(",")) + "&anon_token=" + encodeURIComponent(Cloud.config.anonToken || ""));
        };
        function getPublicApiUrl(path) {
            return appendAccessToken(getServiceUrl() + "/api/" + path);
        }
        Cloud.getPublicApiUrl = getPublicApiUrl;
        function getPrivateApiUrl(path) {
            return appendAccessToken(getServiceUrl() + "/api" + (path == null ? "" : "/" + path));
        }
        Cloud.getPrivateApiUrl = getPrivateApiUrl;
        function getScriptTextAsync(id) {
            return TDev.Util.httpGetTextAsync(getPublicApiUrl(encodeURIComponent(id) + "/text?original=true"));
        }
        Cloud.getScriptTextAsync = getScriptTextAsync;
        function getPrivateApiAsync(path) {
            return TDev.Util.httpGetJsonAsync(getPrivateApiUrl(path));
        }
        Cloud.getPrivateApiAsync = getPrivateApiAsync;
        function getPublicApiAsync(path) {
            return TDev.Util.httpGetJsonAsync(getPublicApiUrl(path));
        }
        Cloud.getPublicApiAsync = getPublicApiAsync;
        function postPrivateApiAsync(path, req) {
            return TDev.Util.httpPostJsonAsync(getPrivateApiUrl(path), req);
        }
        Cloud.postPrivateApiAsync = postPrivateApiAsync;
        function deletePrivateApiAsync(path) {
            return TDev.Util.httpRequestAsync(Cloud.getPrivateApiUrl(path), "DELETE");
        }
        Cloud.deletePrivateApiAsync = deletePrivateApiAsync;
        function deletePublicationAsync(id) {
            return TDev.Util.httpRequestAsync(Cloud.getPrivateApiUrl(id), "DELETE");
        }
        Cloud.deletePublicationAsync = deletePublicationAsync;
        function getRandomAsync() {
            return TDev.Util.httpGetTextAsync(getPublicApiUrl("random"));
        }
        Cloud.getRandomAsync = getRandomAsync;
        function isVersionNewer(version1, version2) {
            if (typeof version1 === "object" && typeof version2 === "object") {
                if (version1.instanceId == version2.instanceId)
                    return version1.version > version2.version || version1.version == version2.version && version1.time > version2.time;
                else
                    return version1.time > version2.time;
            }
            return false;
        }
        Cloud.isVersionNewer = isVersionNewer;
        function getUserInstalledAsync() {
            return getPrivateApiAsync("me/installed");
        }
        Cloud.getUserInstalledAsync = getUserInstalledAsync;
        function getUserInstalledLongAsync(v, m) {
            return getPrivateApiAsync("me/installedlong" + (v ? "?v=" + v + (m ? "&m=1" : "") : ""));
        }
        Cloud.getUserInstalledLongAsync = getUserInstalledLongAsync;
        function getUserInstalledBodyAsync(guid) {
            return getPrivateApiAsync("me/installed/" + guid);
        }
        Cloud.getUserInstalledBodyAsync = getUserInstalledBodyAsync;
        function postUserInstalledAsync(installedBodies) {
            return TDev.Util.httpPostJsonAsync(getPrivateApiUrl("me/installed"), installedBodies);
        }
        Cloud.postUserInstalledAsync = postUserInstalledAsync;
        function postUserInstalledPublishAsync(guid, hidden, scriptVersion, meta) {
            var url = "me/installed/" + guid + "/publish?hidden=" + (hidden ? "true" : "false");
            if (scriptVersion)
                url += "&scriptversion=" + encodeURIComponent(scriptVersion);
            if (!meta)
                meta = {};
            var mergeIds = meta.parentIds;
            if (mergeIds)
                url += "&mergeids=" + encodeURIComponent(mergeIds);
            return TDev.Util.httpPostJsonAsync(getPrivateApiUrl(url), meta);
        }
        Cloud.postUserInstalledPublishAsync = postUserInstalledPublishAsync;
        function isFota() {
            return /fota=1/.test(document.URL) || navigator.userAgent.indexOf("Profile/OTA-DFU1.0") > 0;
        }
        Cloud.isFota = isFota;
        function canCompile() {
            return Cloud.isRestricted();
        }
        Cloud.canCompile = canCompile;
        function postUserInstalledCompileAsync(guid, cppSource, meta) {
            if (meta === void 0) { meta = {}; }
            var r = new TDev.PromiseInv();
            var pollUrl = "";
            var poll = function () {
                TDev.Util.httpGetJsonAsync(pollUrl).done(function (json) {
                    TDev.HTML.showProgressNotification(TDev.lf("compilation finished"));
                    json.url = pollUrl;
                    r.success(json);
                }, function (err) { return TDev.Util.setTimeout(1000, poll); });
            };
            TDev.Util.httpPostJsonAsync(getPrivateApiUrl("me/installed/" + guid + "/compile"), {
                config: "ws",
                source: cppSource,
                meta: meta,
                repohash: Cloud.config.microbitGitTag,
            }).done(function (resp) {
                pollUrl = resp.statusurl;
                poll();
            }, function (e) {
                r.success(undefined);
                Cloud.handlePostingError(e, TDev.lf("could not start compilation"));
            });
            return r;
        }
        Cloud.postUserInstalledCompileAsync = postUserInstalledCompileAsync;
        function errorCallback(action) {
            if (action === void 0) { action = TDev.lf("do this"); }
            return function (e) { return handlePostingError(e, action); };
        }
        Cloud.errorCallback = errorCallback;
        function showSigninNotification(isOnline) {
            if (isOnline)
                TDev.HTML.showWarningNotification(TDev.lf("You are not signed in."), {
                    els: [TDev.HTML.mkLinkButton(TDev.lf("sign in"), function () {
                        var login = TDev.Login;
                        if (login && login.show)
                            login.show();
                    })]
                });
            else
                TDev.HTML.showProgressNotification(TDev.lf("You appear to be offline."));
        }
        Cloud.showSigninNotification = showSigninNotification;
        function handlePostingError(e, action, modal) {
            if (modal === void 0) { modal = true; }
            if (e) {
                if (e.status == 502) {
                    if (modal)
                        Cloud.showModalOnlineInfo(TDev.lf("could not {0}", action));
                    else
                        TDev.HTML.showProgressNotification(TDev.lf("could not {0}, are you connected to internet?", action));
                    return;
                }
                else if (e.status == 429) {
                    TDev.ModalDialog.info(TDev.lf("could not {0}", action), TDev.lf("Did you post a lot recently? Please try again later."));
                    return;
                }
                else if (e.status == 403) {
                    Cloud.accessTokenExpired();
                    if (localStorage['everLoggedIn'])
                        Cloud.isOnlineWithPingAsync().done(function (isOnline) { return Cloud.showSigninNotification(isOnline); });
                    else
                        Cloud.authenticateAsync(action).done();
                    return;
                }
                else if (e.status == 419 || e.status == 402) {
                    TDev.ModalDialog.info(TDev.lf("access denied"), TDev.lf("Your account is not authorized to perform this action."));
                    return;
                }
                else if (e.status == 404) {
                    TDev.ModalDialog.info(TDev.lf("publication not found"), TDev.lf("Maybe it has been removed?"));
                    return;
                }
                else if (e.status == 442 && Cloud._migrate) {
                    Cloud._migrate();
                    return;
                }
                else if (e.status == 452) {
                    return Cloud.authenticateAsync(action, true, false, true).then(function () { return null; });
                }
                else if (e.status == 400)
                    throw new Error(TDev.lf("Cloud precondition violated ({0})", e.errorMessage));
            }
            throw e;
        }
        Cloud.handlePostingError = handlePostingError;
        function postApiBatch(bundle) {
            return TDev.Util.httpPostJsonAsync(getPrivateApiUrl(null), bundle);
        }
        Cloud.postApiBatch = postApiBatch;
        function postBugReportAsync(bug) {
            return postPrivateApiAsync("bug", bug);
        }
        Cloud.postBugReportAsync = postBugReportAsync;
        function postTicksAsync(ticks) {
            return postPrivateApiAsync("ticks", ticks);
        }
        Cloud.postTicksAsync = postTicksAsync;
        function postNotificationsAsync() {
            return postPrivateApiAsync("me/notifications", {});
        }
        Cloud.postNotificationsAsync = postNotificationsAsync;
        function postNotificationChannelAsync(body) {
            return TDev.Util.httpPostJsonAsync(getPrivateApiUrl("me/notificationchannel"), body);
        }
        Cloud.postNotificationChannelAsync = postNotificationChannelAsync;
        function getUserSettingsAsync(priv) {
            if (priv === void 0) { priv = false; }
            return TDev.Util.httpGetJsonAsync(getPrivateApiUrl("me/settings?format=" + (priv ? "sensitive" : "nonsensitive"))).then(function (r) { return r; }, function (e) {
                Cloud.handlePostingError(e, TDev.lf("get settings"));
                return new TDev.PromiseInv();
            });
        }
        Cloud.getUserSettingsAsync = getUserSettingsAsync;
        function postUserSettingsAsync(body) {
            return TDev.Util.httpPostJsonAsync(getPrivateApiUrl("me/settings"), body);
        }
        Cloud.postUserSettingsAsync = postUserSettingsAsync;
        function getAppAsync(id, appPlatform) {
            return TDev.Util.httpGetJsonAsync(getPrivateApiUrl(id + "/" + appPlatform + "app"));
        }
        Cloud.getAppAsync = getAppAsync;
        function postAppAsync(id, appPlatform, data) {
            return TDev.Util.httpPostTextAsync(getPrivateApiUrl(id + "/" + appPlatform + "app"), JSON.stringify(data));
        }
        Cloud.postAppAsync = postAppAsync;
        function postAskBetaAsync(accept) {
            return TDev.Util.httpPostTextAsync(getPrivateApiUrl("/me/askbeta?accept=" + accept), "");
        }
        Cloud.postAskBetaAsync = postAskBetaAsync;
        function postAskSomethingAsync(accept) {
            return TDev.Util.httpPostTextAsync(getPrivateApiUrl("/me/asksomething?accept=" + accept), "");
        }
        Cloud.postAskSomethingAsync = postAskSomethingAsync;
        function pingAsync() {
            if (/http:\/\/localhost/i.test(document.URL))
                return TDev.Promise.as(true);
            var v = TDev.RT.Math_.random(0xffffff).toString();
            var url = getPublicApiUrl("ping?value=" + encodeURIComponent(v));
            return new TDev.Promise(function (onSuccess, onError, onProgress) {
                var client;
                function ready() {
                    if (client.readyState == 4)
                        onSuccess(client.status == 200 && client.responseText === v);
                }
                client = new XMLHttpRequest();
                client.onreadystatechange = ready;
                client.open("GET", url);
                client.send();
            });
        }
        Cloud.pingAsync = pingAsync;
        function postPendingProgressAsync() {
            if (!Cloud.getUserId() || !hasAccessToken() || isOffline())
                return TDev.Promise.as();
            var data = loadPendingProgress();
            if (Object.keys(data).length == 0)
                return TDev.Promise.as();
            TDev.Util.log('progress: ' + JSON.stringify(data));
            return Cloud.postPrivateApiAsync("me/progress", data).then(function () { return clearPendingProgress(data); }, function () {
            });
        }
        Cloud.postPendingProgressAsync = postPendingProgressAsync;
        function postCommentAsync(id, text) {
            var req = { kind: "comment", text: text, userplatform: TDev.Browser.platformCaps };
            return Cloud.postPrivateApiAsync(id + "/comments", req);
        }
        Cloud.postCommentAsync = postCommentAsync;
    })(Cloud = TDev.Cloud || (TDev.Cloud = {}));
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var HTML;
    (function (HTML) {
        function tr(parent, cl) {
            var d = document.createElement('tr');
            d.className = cl;
            parent.appendChild(d);
            return d;
        }
        HTML.tr = tr;
        function td(parent, cl) {
            var d = document.createElement('td');
            d.className = cl;
            parent.appendChild(d);
            return d;
        }
        HTML.td = td;
        function col(parent) {
            var d = document.createElement('col');
            parent.appendChild(d);
            return d;
        }
        HTML.col = col;
        function jsrequireAsync(url) {
            return new TDev.Promise(function (onSuccess, onProgress, onError) {
                if (TDev.Util.children(document.head).some(function (el) { return /script/i.test(el.tagName) && el.getAttribute("src") == url; })) {
                    onSuccess(undefined);
                    return;
                }
                TDev.Util.log('require ' + url);
                var script = document.createElement("script");
                script.type = "text/javascript";
                script.charset = "utf-8";
                script.onload = function () {
                    if (!script.readyState || script.readyState === 'complete') {
                        TDev.Util.log('require success ' + url);
                        onSuccess(undefined);
                    }
                };
                script.onreadystatechange = script.onload;
                script.onerror = function (err) {
                    TDev.Util.log('require error: {0}', err);
                    onSuccess(err);
                };
                script.src = url;
                document.head.appendChild(script);
            });
        }
        HTML.jsrequireAsync = jsrequireAsync;
        function mkOEmbed(url, oe) {
            var d = TDev.div('md-video-link', TDev.div('', HTML.mkImg(oe.thumbnail_url)).withClick(function () { return window.open(url, 'oembed'); }), oe.title, HTML.mkA('', oe.author_url, 'oembed', oe.author_name), HTML.mkA('', oe.provider_url, 'oembed', oe.provider_url));
            return d;
        }
        HTML.mkOEmbed = mkOEmbed;
        function mkVideoIframe(iframeSrc) {
            return TDev.Util.fmt("<div class='md-video-wrapper'><iframe src='{0:url}' frameborder='0' webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe></div>", iframeSrc);
        }
        HTML.mkVideoIframe = mkVideoIframe;
        function mkLazyVideoPlayer(preview, iframeSrc) {
            var d = TDev.div('md-video-link');
            TDev.Browser.setInnerHTML(d, TDev.SVG.getVideoPlay(preview));
            d.setAttribute("data-playerurl", iframeSrc);
            d.withClick(function () {
                d.innerHTML = mkVideoIframe(iframeSrc);
            });
            return d;
        }
        HTML.mkLazyVideoPlayer = mkLazyVideoPlayer;
        function mkYouTubePlayer(ytid) {
            return mkLazyVideoPlayer(TDev.Util.fmt('https://img.youtube.com/vi/{0:q}/hqdefault.jpg', ytid), TDev.Util.fmt("//www.youtube-nocookie.com/embed/{0:uri}?modestbranding=1&autoplay=1&autohide=1&origin={1:uri}", ytid, TDev.Cloud.config.rootUrl));
        }
        HTML.mkYouTubePlayer = mkYouTubePlayer;
        function mkAudio(url, aacUrl, mp3Url, controls) {
            if (aacUrl === void 0) { aacUrl = null; }
            if (mp3Url === void 0) { mp3Url = null; }
            if (controls === void 0) { controls = false; }
            var audio = document.createElement('audio');
            audio.crossorigin = "anonymous";
            audio.controls = controls;
            setAudioSource(audio, url, aacUrl, mp3Url);
            return audio;
        }
        HTML.mkAudio = mkAudio;
        function audioLoadAsync(audio) {
            return new TDev.Promise(function (onSuccess, onError, onProgress) {
                audio.oncanplay = function () {
                    TDev.Util.log('loaded sound oncanplay');
                    audio.oncanplay = null;
                    audio.oncanplaythrough = null;
                    audio.onerror = null;
                    onSuccess(audio);
                };
                audio.oncanplaythrough = function () {
                    TDev.Util.log('loaded sound oncanplaythrough');
                    audio.oncanplay = null;
                    audio.oncanplaythrough = null;
                    audio.onerror = null;
                    onSuccess(audio);
                };
                audio.onerror = function (e) {
                    TDev.Util.log('failed loading sound - ' + audio.readyState);
                    audio.oncanplay = null;
                    audio.oncanplaythrough = null;
                    audio.onerror = null;
                    onSuccess(audio);
                };
                var retry = 20;
                var loadTracker = function () {
                    var readyState = (audio.readyState);
                    if (!audio.oncanplay)
                        return;
                    if (readyState === HTMLMediaElement.HAVE_ENOUGH_DATA) {
                        audio.oncanplay = null;
                        audio.oncanplaythrough = null;
                        audio.onerror = null;
                        onSuccess(audio);
                    }
                    else if (retry-- > 0) {
                        TDev.Util.log('retry loading sound. readState:' + readyState + ', networkState:' + audio.networkState + ', try:' + retry);
                        TDev.Util.setTimeout(250, loadTracker);
                    }
                    else {
                        TDev.Util.log('timeout loading sound');
                        audio.oncanplay = null;
                        audio.oncanplaythrough = null;
                        audio.onerror = null;
                        onSuccess(audio);
                    }
                };
                try {
                    TDev.Util.log('start loading sound');
                    audio.load();
                    TDev.Util.setTimeout(400, loadTracker);
                }
                catch (e) {
                    TDev.Util.log('failed loading sound: ' + e.message);
                    onSuccess(audio);
                }
            });
        }
        HTML.audioLoadAsync = audioLoadAsync;
        function setAudioSource(audio, url, aacUrl, mp3Url) {
            if (aacUrl === void 0) { aacUrl = null; }
            if (mp3Url === void 0) { mp3Url = null; }
            if (!url) {
                audio.setChildren([]);
                return;
            }
            var m = url.match(/^data:audio\/(mpeg|mp3|mp4|wav);base64,/i);
            if (m) {
                TDev.Util.log('audio: src datauri ' + m[1]);
                var src = document.createElement('source');
                src.src = url;
                src.type = 'audio/' + m[1];
                audio.setChildren([src]);
            }
            else {
                var wavSrc = document.createElement('source');
                wavSrc.src = proxyResource(url);
                wavSrc.type = 'audio/wav';
                var mp3Src = document.createElement('source');
                mp3Src.src = proxyResource(mp3Url || url);
                mp3Src.type = 'audio/mp3';
                var aacSrc = document.createElement('source');
                aacSrc.src = proxyResource(aacUrl || url);
                aacSrc.type = 'audio/mp4';
                audio.setChildren([aacSrc, wavSrc, mp3Src]);
            }
        }
        HTML.setAudioSource = setAudioSource;
        function parseWtt(wtt) {
            var r = [];
            if (wtt) {
                try {
                    var rx = /((\d{2}):)?(\d{2}):(\d{2})\.(\d{3}) --> ((\d{2}):)?(\d{2}):(\d{2})\.(\d{3})/gi;
                    var m;
                    while (m = rx.exec(wtt)) {
                        var startTime = parseInt(m[2] || "0") * 3600 + parseInt(m[3]) * 60 + parseInt(m[4]) + parseInt(m[5]) / 1000;
                        var endTime = parseInt(m[7] || "0") * 3600 + parseInt(m[8]) * 60 + parseInt(m[9]) + parseInt(m[10]) / 1000;
                        var message = wtt.substr(m.index + m[0].length).trim();
                        var emptyLine = /^$/m.exec(message);
                        if (emptyLine)
                            message = message.substr(0, emptyLine.index).trim();
                        r.push({ startTime: startTime, endTime: endTime, message: message });
                    }
                }
                catch (e) {
                    TDev.Util.reportError("wtt", e, false);
                    return r;
                }
            }
            return r;
        }
        HTML.parseWtt = parseWtt;
        function pauseVideos(el) {
            if (el) {
                var vids = el.getElementsByTagName("video");
                for (var i = 0; i < vids.length; ++i) {
                    try {
                        vids.item(i).pause();
                    }
                    catch (e) {
                    }
                }
            }
        }
        HTML.pauseVideos = pauseVideos;
        function patchWavToMp4Url(url) {
            if (url) {
                if (/^\.\/art\//i.test(url))
                    return url + '.m4a';
                else if (TDev.Cloud.isArtUrl(url))
                    return TDev.Cloud.toCdnUrl(url, "aac") + ".m4a";
            }
            return url;
        }
        HTML.patchWavToMp4Url = patchWavToMp4Url;
        function mkBr() {
            return document.createElement("br");
        }
        HTML.mkBr = mkBr;
        function mkTextArea(cls) {
            if (cls === void 0) { cls = null; }
            var ta = document.createElement("textarea");
            if (cls != null)
                ta.className = cls;
            TDev.dirAuto(ta);
            ta.onselectstart = function (e) {
                e.stopImmediatePropagation();
                return true;
            };
            return ta;
        }
        HTML.mkTextArea = mkTextArea;
        function wrong(e) {
            TDev.Util.coreAnim("shakeTip", 500, e);
        }
        HTML.wrong = wrong;
        function setupDragAndDrop(r, onFiles) {
            if (!TDev.Browser.dragAndDrop)
                return;
            r.addEventListener('dragover', function (e) {
                if (e.dataTransfer.types[0] == 'Files') {
                    if (e.preventDefault)
                        e.preventDefault();
                    e.dataTransfer.dropEffect = 'copy';
                    return false;
                }
            }, false);
            r.addEventListener('drop', function (e) {
                if (e.dataTransfer.files[0]) {
                    e.stopPropagation();
                    e.preventDefault();
                    onFiles(e.dataTransfer.files);
                }
                return false;
            }, false);
            r.addEventListener('dragend', function (e) {
                return false;
            }, false);
        }
        HTML.setupDragAndDrop = setupDragAndDrop;
        function mkButtonElt(cl) {
            var children = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                children[_i - 1] = arguments[_i];
            }
            var elt = document.createElement("button");
            if (cl != null)
                elt.className = cl;
            elt.appendChildren(children);
            TDev.dirAuto(elt);
            return elt;
        }
        HTML.mkButtonElt = mkButtonElt;
        function mkImg(url, cls, alt, ariaHidden) {
            if (/^\//.test(url))
                url = url.slice(1);
            var m = /^scripticons(96)?\/(.*)\.png/.exec(url);
            if (m) {
                url = "svg:" + m[2] + ",white";
            }
            var img;
            if (/^svg:/.test(url)) {
                img = TDev.SVG.getIconSVG(url.slice(4), ariaHidden ? undefined : alt);
            }
            else {
                var elt = document.createElement("img");
                elt.src = proxyResource(url);
                if (!ariaHidden)
                    elt.alt = alt || "";
                img = elt;
            }
            if (cls)
                img.className += " " + cls;
            if (ariaHidden)
                img.setAttribute("aria-hidden", "true");
            return img;
        }
        HTML.mkImg = mkImg;
        function mkImgButton(img, f) {
            var i = HTML.mkImg(img);
            HTML.setRole(i, "presentation");
            var btn = mkButtonElt("wall-button", i);
            TDev.Util.clickHandler(btn, f);
            return btn;
        }
        HTML.mkImgButton = mkImgButton;
        function mkDisablableButton(content, f) {
            var r = mkButton(content, function () {
                if (!r.getFlag("disabled"))
                    f();
            });
            return r;
        }
        HTML.mkDisablableButton = mkDisablableButton;
        function mkAsyncButton(content, f, cls) {
            if (cls === void 0) { cls = ""; }
            var btn = mkButtonElt("wall-button " + cls, TDev.text(content));
            var running = false;
            TDev.Util.clickHandler(btn, function () {
                if (running)
                    return;
                running = true;
                btn.style.opacity = "0.5";
                btn.setFlag("disabled", true);
                f().done(function () {
                    running = false;
                    btn.style.opacity = null;
                    btn.setFlag("disabled", false);
                });
            });
            return btn;
        }
        HTML.mkAsyncButton = mkAsyncButton;
        function mkButton(content, f, cls) {
            if (cls === void 0) { cls = ""; }
            var btn = mkButtonElt("wall-button " + cls, TDev.text(content));
            TDev.Util.clickHandler(btn, f);
            return btn;
        }
        HTML.mkButton = mkButton;
        function mkAButton(content, href) {
            return HTML.mkA('wall-button', href, '_blank', content);
        }
        HTML.mkAButton = mkAButton;
        function mkLinkButton(content, f, cls) {
            if (cls === void 0) { cls = ""; }
            var btn = mkButtonElt("link-button " + cls, TDev.text(content));
            TDev.Util.clickHandler(btn, f);
            return btn;
        }
        HTML.mkLinkButton = mkLinkButton;
        function mkButtonTick(content, t, f, cls) {
            if (cls === void 0) { cls = ""; }
            var btn = mkButtonElt("wall-button " + cls, TDev.text(content));
            setTickCallback(btn, t, f);
            return btn;
        }
        HTML.mkButtonTick = mkButtonTick;
        function mkButtonOnce(content, f, removeSiblings) {
            if (removeSiblings === void 0) { removeSiblings = false; }
            var btn = mkButtonElt("wall-button", TDev.text(content));
            TDev.Util.clickHandler(btn, function (e) {
                if (removeSiblings)
                    btn.parentNode.removeAllChildren();
                else
                    btn.removeSelf();
                f();
            });
            return btn;
        }
        HTML.mkButtonOnce = mkButtonOnce;
        function setTickCallback(btn, tick, f) {
            if (tick == 0 /* noEvent */) {
                return btn.withClick(f);
            }
            else {
                btn.id = "btn-" + TDev.Ticker.tickName(tick);
                return btn.withClick(function (e) {
                    TDev.Ticker.tick(tick);
                    f(e);
                });
            }
            return btn;
        }
        HTML.setTickCallback = setTickCallback;
        function mkRoundButton(icon, name, tick, f) {
            var btn = HTML.mkButtonElt("topMenu-button " + (name.length > 11 ? "topMenu-button-long-desc" : ""), [
                TDev.div("topMenu-button-frame", HTML.mkImg(icon)),
                TDev.div("topMenu-button-desc", name)
            ]);
            setTickCallback(btn, tick, f);
            return btn;
        }
        HTML.mkRoundButton = mkRoundButton;
        function fileReadAsArrayBufferAsync(f) {
            if (!f)
                return TDev.Promise.as(null);
            else {
                return new TDev.Promise(function (onSuccess, onError, onProgress) {
                    var reader = new FileReader();
                    reader.onerror = function (ev) { return onSuccess(null); };
                    reader.onload = function (ev) { return onSuccess(reader.result); };
                    reader.readAsArrayBuffer(f);
                });
            }
        }
        HTML.fileReadAsArrayBufferAsync = fileReadAsArrayBufferAsync;
        function fileReadAsDataURLAsync(f, fileType) {
            if (fileType === void 0) { fileType = ""; }
            if (!f)
                return TDev.Promise.as(null);
            if (fileType)
                return fileReadAsArrayBufferAsync(f).then(function (buf) {
                    if (buf)
                        return "data:" + fileType + ";base64," + btoa(TDev.Util.uint8ArrayToString(new Uint8Array(buf)));
                    else
                        return null;
                });
            return new TDev.Promise(function (onSuccess, onError, onProgress) {
                var reader = new FileReader();
                reader.onerror = function (ev) { return onSuccess(null); };
                reader.onload = function (ev) { return onSuccess(reader.result); };
                reader.readAsDataURL(f);
            });
        }
        HTML.fileReadAsDataURLAsync = fileReadAsDataURLAsync;
        HTML.documentMimeTypes = {
            "text/css": "css",
            "application/javascript": "js",
            "text/plain": "txt",
            "application/pdf": "pdf",
            "application/x-zip-compressed": "zip",
            "application/vnd.openxmlformats-officedocument.wordprocessingml.document": "docx",
            "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": "xlsx",
            "application/vnd.openxmlformats-officedocument.presentationml.presentation": "pptx",
            "application/x-microbit-hex": "hex",
        };
        function mkDocumentInput(maxMb) {
            var input = HTML.mkTextInput("file", TDev.lf("choose a file"));
            input.accept = Object.keys(HTML.documentMimeTypes).join(";");
            return {
                element: input,
                validate: function () {
                    var f = input.files[0];
                    if (!f)
                        return TDev.lf("Oops, you need to select a file...");
                    if (maxMb > 0 && f.size > maxMb * 1024 * 1024)
                        return TDev.lf("Sorry, the file is too big. It must be less than {0}Mb...", maxMb);
                    if (input.accept.indexOf(f.type) < 0)
                        return TDev.lf("Sorry, this document format is not supported...");
                    return null;
                },
                readAsync: function () { return fileReadAsDataURLAsync(input.files[0]); }
            };
        }
        HTML.mkDocumentInput = mkDocumentInput;
        HTML.mkAudioInput = function (allowEmpty, maxMb) {
            var input = HTML.mkTextInput("file", TDev.lf("choose a file"));
            input.accept = "audio/mpeg";
            return {
                element: input,
                validate: function () {
                    var files = input.files;
                    if (files.length == 0)
                        return allowEmpty ? null : 'Oops, you need to select a sound...';
                    var f = files[0];
                    if (maxMb > 0 && f.size > maxMb * 1000000)
                        return TDev.lf("Sorry, the sound is too big. The sound must be less than {0}Mb...", maxMb);
                    if (f.type !== 'audio/mpeg' && f.type !== 'audio/mp3')
                        return TDev.lf("Sorry, you can only upload MP3 sounds...");
                    return null;
                },
                readAsync: function () { return fileReadAsDataURLAsync(input.files[0]); }
            };
        };
        HTML.mkImageChooser = function (onchanged) {
            var file = HTML.mkTextInput("file", TDev.lf("choose a picture"));
            file.accept = "image/jpeg,image/png";
            file.onchange = function () {
                var f = file.files.length > 0 ? file.files[0] : null;
                if (!f)
                    return;
                var reader = new FileReader();
                reader.onload = function (ev) { return onchanged(reader.result); };
                reader.readAsDataURL(f);
            };
            return file;
        };
        function mkFileInput(file, maxMb, fileType) {
            if (fileType === void 0) { fileType = ""; }
            var input;
            fileType = fileType || file.type;
            if (/^image\//.test(fileType)) {
                input = document.createElement("img");
                input.style.maxWidth = '15em';
                input.style.maxHeight = '7em';
                input.src = file;
                fileReadAsDataURLAsync(file, fileType).done(function (url) { return input.src = url; });
            }
            else if (/^audio\//.test(fileType)) {
                input = document.createElement("audio");
                input.crossorigin = "anonymous";
                input.src = file;
                fileReadAsDataURLAsync(file, fileType).done(function (url) { return input.src = url; });
            }
            else {
                input = TDev.div('wall-textbox', TDev.lf("{0} {1}Kb", file.name, Math.ceil(file.size / 1000)));
            }
            input.style.margins = '0.5em';
            return {
                element: input,
                validate: function () { return null; },
                readAsync: function () { return fileReadAsDataURLAsync(file, fileType); }
            };
        }
        HTML.mkFileInput = mkFileInput;
        HTML.mkImageInput = function (allowEmpty, maxMb) {
            var input = HTML.mkTextInput("file", TDev.lf("choose a picture"));
            input.accept = "image/jpeg,image/png";
            return { element: input, validate: function () {
                var files = input.files;
                if (files.length == 0)
                    return allowEmpty ? null : TDev.lf("Oops, you need to select a picture...");
                var f = files[0];
                if (maxMb > 0 && f.size > maxMb * 1000000)
                    return TDev.lf("Sorry, the picture is too big. The picture must be less than {0} Mb...", maxMb);
                if (f.type !== 'image/jpeg' && f.type !== 'image/png')
                    return TDev.lf("Sorry, you can only upload JPEG and PNG pictures...");
                return null;
            }, readAsync: function () {
                var f = input.files[0];
                if (!f)
                    return TDev.Promise.as(null);
                else {
                    return new TDev.Promise(function (onSuccess, onError, onProgress) {
                        var reader = new FileReader();
                        reader.onerror = function (ev) { return onSuccess(null); };
                        reader.onload = function (ev) { return onSuccess(reader.result); };
                        reader.readAsDataURL(f);
                    });
                }
            } };
        };
        function setRole(el, role) {
            if (!el)
                return;
            if (role)
                el.setAttribute("role", role);
            else
                el.removeAttribute("role");
        }
        HTML.setRole = setRole;
        function enableSpeech(el, changed) {
            el.setAttribute('x-webkit-speech', 'x-webkit-speech');
            el.onwebkitspeechchange = function () {
                changed();
            };
            el.onspeechchange = function () {
                changed();
            };
        }
        HTML.enableSpeech = enableSpeech;
        function mkTextInput(type, placeholder, role, label) {
            var txt = document.createElement("input");
            txt.setAttribute("type", type);
            if (placeholder) {
                txt.setAttribute("placeholder", placeholder);
                txt.setAttribute("aria-label", label || placeholder);
            }
            if (role)
                HTML.setRole(txt, role);
            txt.autofocus = false;
            txt.className = "wall-textbox";
            TDev.dirAuto(txt);
            if (TDev.Browser.browser == 9 /* safari */)
                txt.autocapitalize = false;
            txt.onselectstart = function (e) {
                e.stopImmediatePropagation();
                return true;
            };
            return txt;
        }
        HTML.mkTextInput = mkTextInput;
        function mkTextInputWithOk(type, placeholder, onOk) {
            var res = mkTextInput(type, placeholder);
            var okBtn = null;
            TDev.Util.onInputChange(res, function () {
                if (okBtn)
                    return;
                res.style.width = "calc(100% - 6em)";
                okBtn = mkButton(TDev.lf("ok"), function () {
                    var b = okBtn;
                    okBtn = null;
                    res.style.width = "";
                    if (b)
                        b.removeSelf();
                    res.blur();
                }, "input-confirm");
                res.parentNode.insertBefore(okBtn, res.nextSibling);
            });
            res.addEventListener("blur", function () {
                var b = okBtn;
                okBtn = null;
                res.style.width = "";
                if (b)
                    b.removeSelf();
                if (onOk)
                    onOk();
            }, false);
            return res;
        }
        HTML.mkTextInputWithOk = mkTextInputWithOk;
        function mkOption(value, label, selected) {
            if (selected === void 0) { selected = undefined; }
            var children = [];
            for (var _i = 3; _i < arguments.length; _i++) {
                children[_i - 3] = arguments[_i];
            }
            var option = document.createElement("option");
            option.label = label;
            option.value = value;
            if (selected !== undefined)
                option.selected = selected;
            if (label)
                option.appendChildren(label);
            option.appendChildren(children);
            return option;
        }
        HTML.mkOption = mkOption;
        function mkComboBox(options) {
            var combobox = document.createElement("select");
            combobox.autofocus = false;
            combobox.className = "wall-textbox";
            combobox.appendChildren(options);
            return combobox;
        }
        HTML.mkComboBox = mkComboBox;
        function getCheckboxValue(ch) {
            return !!ch.selected;
        }
        HTML.getCheckboxValue = getCheckboxValue;
        function setCheckboxValue(ch, v) {
            ch.theBox.setChildren(v ? [TDev.text("\u2713")] : []);
            ch.selected = v;
        }
        HTML.setCheckboxValue = setCheckboxValue;
        function mkCheckBox(lbl, onchg, v) {
            if (onchg === void 0) { onchg = undefined; }
            return mkTickCheckBox(0 /* noEvent */, lbl, onchg, v);
        }
        HTML.mkCheckBox = mkCheckBox;
        function mkTickCheckBox(t, lbl, onchg, v) {
            if (onchg === void 0) { onchg = undefined; }
            var b = TDev.div("theBox", TDev.text(""));
            var r = TDev.div("checkbox", b, TDev.text(lbl));
            r.theBox = b;
            setTickCallback(r, t, function () {
                var nv = !r.selected;
                setCheckboxValue(r, nv);
                if (!!onchg)
                    onchg(nv);
            });
            if (v !== undefined)
                setCheckboxValue(r, v);
            return r;
        }
        HTML.mkTickCheckBox = mkTickCheckBox;
        function mkCheckBoxLocalStorage(key, msg) {
            var val = !!window.localStorage.getItem(key);
            var check = HTML.mkCheckBox(msg, function (v) { return TDev.Util.localStore(key, v ? "1" : undefined); }, val);
            return check;
        }
        HTML.mkCheckBoxLocalStorage = mkCheckBoxLocalStorage;
        function mkRadioButtons(lbls) {
            var res = {
                current: -1,
                enabled: true,
                buttons: lbls.map(function (l, i) { return setTickCallback(mkButtonElt("radio-button", TDev.div("radio-outer", TDev.div("radio-inner")), TDev.div("radio-label", l.name)), l.tick, function () {
                    if (res.enabled)
                        res.change(i);
                }); }),
                onchange: function (n) {
                },
                change: function (n) {
                    res.current = n;
                    res.buttons.forEach(function (b, i) { return b.setFlag("selected", i == n); });
                    res.onchange(n);
                },
                elt: TDev.div("radio-group")
            };
            res.elt.setChildren(res.buttons);
            return res;
        }
        HTML.mkRadioButtons = mkRadioButtons;
        function mkModalList(children) {
            var kindList = TDev.div("modalList", children);
            TDev.Util.setupDragToScroll(kindList);
            return kindList;
        }
        HTML.mkModalList = mkModalList;
        var progressNotificationAnimation;
        HTML.showProgressNotification = function (msgText, fadeOut, delay, duration) {
            if (fadeOut === void 0) { fadeOut = true; }
            if (delay === void 0) { delay = 1000; }
            if (duration === void 0) { duration = 2000; }
            if (TDev.Browser.isHeadless) {
                TDev.Util.log("progress: " + msgText);
                return;
            }
            var className = "progressNotification";
            var se = TDev.elt("root");
            var oldMsgs = se.getElementsByClassName(className);
            var msg = oldMsgs.length > 0 ? oldMsgs.item(0) : undefined;
            var f = function () {
                progressNotificationAnimation = undefined;
                if (fadeOut) {
                    progressNotificationAnimation = TDev.Animation.fadeOut(msg);
                    progressNotificationAnimation.delay = delay;
                    progressNotificationAnimation.duration = duration;
                    progressNotificationAnimation.completed = function () {
                        progressNotificationAnimation = undefined;
                    };
                    progressNotificationAnimation.begin();
                }
            };
            if (msg) {
                if (!!progressNotificationAnimation) {
                    progressNotificationAnimation.stop();
                }
                msg.style.opacity = "1";
                if (msgText !== undefined) {
                    msg.removeAllChildren();
                    msg.appendChildren(msgText);
                }
                f();
            }
            else if (msgText) {
                msg = TDev.div(className, msgText);
                msg.setAttribute("role", "alert");
                msg.setAttribute("aria-live", "status");
                se.appendChild(msg);
                progressNotificationAnimation = TDev.Animation.fadeIn(msg);
                progressNotificationAnimation.completed = f;
                progressNotificationAnimation.begin();
            }
        };
        function showWarningNotification(msgText, options) {
            if (options === void 0) { options = {}; }
            if (TDev.Browser.isHeadless) {
                TDev.Util.log("warning: " + msgText);
                return;
            }
            var info = TDev.div('info', msgText);
            var msg = TDev.div("warningNotification", info);
            msg.setAttribute("role", "alert");
            msg.setAttribute("aria-label", msgText);
            var a = TDev.Animation.fadeOut(msg);
            a.delay = 6000;
            a.duration = 500;
            a.begin();
            if (options && options.els)
                info.appendChildren(options.els);
            if (options && options.details) {
                msg.appendChild(TDev.div('info link', TDev.lf("learn more...")));
                msg.withClick(function () {
                    TDev.tick(470 /* warningNotificationTap */);
                    TDev.ModalDialog.info(msgText, options.details);
                });
            }
            info.appendChild(HTML.mkLinkButton(TDev.lf("dismiss"), function () {
                a.complete();
            }));
            TDev.elt("root").appendChild(msg);
        }
        HTML.showWarningNotification = showWarningNotification;
        function showPluginNotification(msgText) {
            var msg = TDev.div("pluginNotification", TDev.div('info', msgText));
            msg.setAttribute("role", "alert");
            msg.setAttribute("aria-live", "status");
            TDev.elt("root").appendChild(msg);
            var a = TDev.Animation.fadeOut(msg);
            a.delay = 6000;
            a.duration = 3000;
            a.begin();
        }
        HTML.showPluginNotification = showPluginNotification;
        function showUndoNotification(msgText, undo) {
            var previous = TDev.elt("infoNotification");
            if (previous)
                previous.removeSelf();
            var msg = TDev.divId("infoNotification", "infoNotification", msgText, HTML.mkButtonOnce(TDev.lf("undo"), function () {
                msg.removeSelf();
                undo();
            }));
            TDev.elt("root").appendChild(msg);
            var fi = TDev.Animation.fadeIn(msg, 1000);
            fi.completed = function () {
                var a = TDev.Animation.fadeOut(msg);
                a.delay = 4000;
                a.duration = 1000;
                a.begin();
            };
            fi.begin();
        }
        HTML.showUndoNotification = showUndoNotification;
        function showErrorNotification(msgText) {
            if (TDev.Browser.isHeadless) {
                TDev.Util.log("error: " + msgText);
                return;
            }
            var msg = TDev.div("errorNotification", msgText);
            msg.setAttribute("role", "alert");
            msg.setAttribute("alert-label", msgText);
            TDev.elt("root").appendChild(msg);
            var a = TDev.Animation.fadeOut(msg);
            a.delay = 2000;
            a.duration = 2000;
            a.begin();
        }
        HTML.showErrorNotification = showErrorNotification;
        function showSaveNotification(msgText, time) {
            if (time === void 0) { time = 1000; }
            var msg = TDev.div("saveNotification", msgText);
            TDev.elt("root").appendChild(msg);
            var a = TDev.Animation.fadeOut(msg);
            a.delay = time;
            a.duration = 1000;
            a.begin();
            return msg;
        }
        HTML.showSaveNotification = showSaveNotification;
        ;
        function showWebNotification(aTitle, aOptions, aTimeout) {
            if (aOptions === void 0) { aOptions = {}; }
            if (aTimeout === void 0) { aTimeout = 10000; }
            if (TDev.Cloud.isRestricted())
                return;
            if (!("Notification" in window))
                return;
            if (document.hasFocus())
                return;
            var Notification = window.Notification;
            var doit = function () {
                var n = new Notification(aTitle, aOptions);
                n.onshow = function () {
                    TDev.Util.setTimeout(aTimeout, function () { return n.close(); });
                };
            };
            if (Notification.permission === "granted") {
                doit();
            }
            else {
                Notification.requestPermission(function (permission) {
                    if (permission === "granted")
                        doit();
                });
            }
        }
        HTML.showWebNotification = showWebNotification;
        function mkA(cl, href, target) {
            var children = [];
            for (var _i = 3; _i < arguments.length; _i++) {
                children[_i - 3] = arguments[_i];
            }
            var elt = document.createElement("a");
            elt.href = href;
            elt.target = target;
            if (cl)
                elt.className = cl;
            elt.appendChildren(children);
            return elt;
        }
        HTML.mkA = mkA;
        function li(cls) {
            var elts = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                elts[_i - 1] = arguments[_i];
            }
            var r = document.createElement("li");
            if (cls)
                r.className = cls;
            r.setChildren(elts);
            return r;
        }
        HTML.li = li;
        function span(cls) {
            var elts = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                elts[_i - 1] = arguments[_i];
            }
            var r = document.createElement("span");
            if (cls)
                r.className = cls;
            r.setChildren(elts);
            return r;
        }
        HTML.span = span;
        function label(cls) {
            var elts = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                elts[_i - 1] = arguments[_i];
            }
            var r = document.createElement("label");
            if (cls)
                r.className = cls;
            r.setChildren(elts);
            return r;
        }
        HTML.label = label;
        function browserDownloadText(text, name, contentType) {
            if (contentType === void 0) { contentType = "octet/stream"; }
            var buf = TDev.Util.stringToUint8Array(TDev.Util.toUTF8(text));
            browserDownloadUInt8Array(buf, name, contentType);
        }
        HTML.browserDownloadText = browserDownloadText;
        function browserDownloadUInt8Array(buf, name, contentType) {
            if (contentType === void 0) { contentType = "octet/stream"; }
            try {
                if (typeof saveAs !== "undefined") {
                    var b = new Blob([buf], { type: contentType });
                    saveAs(b, name, true);
                    return;
                }
                if (window.navigator.msSaveOrOpenBlob && !TDev.Browser.isMobile) {
                    var b = new Blob([buf], { type: contentType });
                    var result = window.navigator.msSaveOrOpenBlob(b, name);
                }
                else {
                    var link = window.document.createElement('a');
                    var dataurl = "data:" + contentType + ";base64," + TDev.Util.base64EncodeBytes(buf);
                    if (typeof link.download == "string") {
                        link.href = dataurl;
                        link.download = name;
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                    }
                    else {
                        document.location.href = dataurl;
                    }
                }
            }
            catch (e) {
                TDev.Util.reportError("browserdownload", e, false);
                HTML.showProgressNotification(TDev.lf("saving file failed..."));
            }
        }
        HTML.browserDownloadUInt8Array = browserDownloadUInt8Array;
        function browserDownload(dataurl, name) {
            try {
                var getblob = function () {
                    var m = /data:([^;]+);base64,/.exec(dataurl);
                    var buf = TDev.Util.stringToUint8Array(atob(dataurl.slice(m[0].length)));
                    return new Blob([buf], { type: m[1] });
                };
                if (typeof saveAs !== "undefined") {
                    saveAs(getblob(), name, true);
                    return;
                }
                if (window.navigator.msSaveOrOpenBlob) {
                    var result = window.navigator.msSaveOrOpenBlob(getblob(), name);
                }
                else {
                    var link = window.document.createElement('a');
                    link.href = dataurl;
                    if (typeof link.download == "string") {
                        link.download = name;
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                    }
                    else {
                        document.location.href = dataurl;
                    }
                }
            }
            catch (e) {
                TDev.Util.reportError("browserdownload", e, false);
                HTML.showProgressNotification(TDev.lf("saving file failed..."));
            }
        }
        HTML.browserDownload = browserDownload;
        function showNotification(msg) {
            TDev.elt("root").appendChild(msg);
            var a = TDev.Animation.fadeOut(msg);
            a.delay = 6000;
            a.duration = 2000;
            a.begin();
        }
        HTML.showNotification = showNotification;
        function showNotificationText(text) {
            var msg = TDev.div("errorNotification", text);
            showNotification(msg);
        }
        HTML.showNotificationText = showNotificationText;
        function showProxyNotification(message, url) {
            var msg = TDev.div("errorNotification", message, mkBr(), span("smallText", "URL: " + url));
            showNotification(msg);
        }
        HTML.showProxyNotification = showProxyNotification;
        function showCorsNotification(url) {
            var msg = TDev.div("errorNotification", TDev.lf("Access Denied: Your web browser and the web site prevent cross-origin resource sharing (CORS)."), mkA("", TDev.Cloud.config.rootUrl + TDev.Cloud.config.topicPath + "CORS", "_blank", TDev.lf("Learn more...")), mkBr(), span("smallText", TDev.lf("URL: {0}", url)));
            showNotification(msg);
        }
        HTML.showCorsNotification = showCorsNotification;
        function mkProgressBar() {
            var r = TDev.div("progressBar", TDev.Util.range(0, 4).map(function (v) { return TDev.div("progressDot progressDot-" + v); }));
            HTML.setRole(r, "progressbar");
            var n = 0;
            function update(k) {
                n += k;
                if (n < 0)
                    n = 0;
                r.style.display = n > 0 ? "block" : "none";
            }
            update(0);
            if (TDev.Browser.noAnimations) {
                r.start = r.stop = r.reset = function () {
                };
            }
            else {
                r.start = function () {
                    update(+1);
                };
                r.stop = function () {
                    update(-1);
                };
                r.reset = function () {
                    update(-n);
                };
            }
            return r;
        }
        HTML.mkProgressBar = mkProgressBar;
        function mkAutoExpandingTextArea(options) {
            if (options === void 0) { options = {}; }
            var ta = HTML.mkTextArea();
            var pre = document.createElement("pre");
            var dismiss;
            var fullScreen;
            var btns;
            if (options.showDismiss || options.editFullScreenAsync) {
                btns = TDev.div('close-round-buttons');
                if (options.showDismiss)
                    btns.appendChild(dismiss = TDev.div('', HTML.mkImg("svg:check,currentColor")).withClick(function () {
                        if (r.onDismiss)
                            r.onDismiss();
                    }));
                if (options.editFullScreenAsync)
                    btns.appendChild(fullScreen = TDev.div('', HTML.mkImg('svg:expand,currentColor')).withClick(function () {
                        options.editFullScreenAsync(ta.value).done(function (value) {
                            ta.value = value;
                            if (r.onDismiss)
                                r.onDismiss();
                        });
                    }));
            }
            var content = span(null, null);
            pre.setChildren([content, mkBr()]);
            var update = function () {
                content.textContent = ta.value;
                r.onUpdate();
            };
            TDev.Util.onInputChange(ta, update);
            var r = {
                div: TDev.div("expandingTextAreaContainer", pre, ta, btns),
                textarea: ta,
                update: update,
                onUpdate: function () {
                },
                dismiss: dismiss,
                onDismiss: function () {
                },
                fullScreen: fullScreen,
            };
            if (options.singleLine) {
                ta.onkeydown = function (ev) {
                    if ((ev.keyCode || ev.which) == 13) {
                        ev.stopPropagation();
                        if (r.onDismiss)
                            r.onDismiss();
                        return true;
                    }
                };
            }
            return r;
        }
        HTML.mkAutoExpandingTextArea = mkAutoExpandingTextArea;
        function fixWp8Links() {
            var elts = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                elts[_i - 0] = arguments[_i];
            }
            elts.forEach(function (elt) {
                var ch = elt.getElementsByTagName("A");
                for (var i = 0; i < ch.length; ++i)
                    (function () {
                        var a = ch[i];
                        var href = a.getAttribute("href");
                        if (/^#/.test(href)) {
                            a.onclick = function () { return false; };
                            a.withClick(function () {
                                TDev.Util.setHash(href);
                                return false;
                            });
                        }
                    })();
            });
        }
        HTML.fixWp8Links = fixWp8Links;
        HTML.localCdn = null;
        function proxyResource(url) {
            if (!url)
                return url;
            url = TDev.Cloud.toCdnUrl(url);
            if (HTML.localCdn && !/http:\/\/localhost/i.test(url) && (TDev.Cloud.isArtUrl(url) || /^(https?:\/\/lexmediaservice3.blob.core.windows.net|https:\/\/tdtutorialtranslator.blob.core.windows.net)/i.test(url))) {
                url = HTML.localCdn + encodeURIComponent(url);
            }
            return url;
        }
        HTML.proxyResource = proxyResource;
        function cssImage(url, opacity) {
            if (opacity === void 0) { opacity = 1; }
            if (!url)
                return "";
            var u = "url(" + proxyResource(url) + ")";
            if (opacity < 1)
                u = TDev.Util.fmt("linear-gradient(to bottom, rgba(255,255,255,{0}) 0%,rgba(255,255,255,{0}) 100%), {1}", (1 - opacity).toFixed(3), u);
            return u;
        }
        HTML.cssImage = cssImage;
        HTML.html5Tags = {
            "dialog": -1,
            "embed": -1,
            "keygen": -1,
            "link": -1,
            "meta": -1,
            "noscript": -1,
            "object": -1,
            "param": -1,
            "script": -1,
            "applet": -1,
            "frame": -1,
            "frameset": -1,
            "noframes": -1,
            "html": -1,
            "body": -1,
            "head": -1,
            "form": -1,
            "style": -1,
            "basefont": -2,
            "font": -2,
            "center": -2,
            "big": -2,
            "dir": -2,
            "acronym": -2,
            "strike": -2,
            "tt": -2,
            "a": 1,
            "ul": 1,
            "h1": 1,
            "h2": 1,
            "h3": 1,
            "h4": 1,
            "h5": 1,
            "h6": 1,
            "ol": 1,
            "li": 1,
            "blockquote": 1,
            "pre": 1,
            "b": 1,
            "button": 1,
            "code": 1,
            "img": 1,
            "strong": 1,
            "span": 1,
            "br": 1,
            "del": 1,
            "div": 1,
            "em": 1,
            "p": 1,
            "i": 1,
            "u": 1,
            "video": 1,
            "source": 1,
            "audio": 1,
            "track": 1,
            "small": 1,
            "hr": 1,
            "iframe": 1,
            "svg": 1,
            "path": 1,
            "circle": 1,
            "g": 1,
            "title": 1,
            "abbr": 2,
            "address": 2,
            "area": 2,
            "article": 2,
            "aside": 2,
            "bdi": 2,
            "bdo": 2,
            "canvas": 2,
            "caption": 2,
            "cite": 2,
            "col": 2,
            "colgroup": 2,
            "datalist": 2,
            "dd": 2,
            "details": 2,
            "dfn": 2,
            "dl": 2,
            "dt": 2,
            "fieldset": 2,
            "figcaption": 2,
            "figure": 2,
            "footer": 2,
            "header": 2,
            "hgroup": 2,
            "input": 2,
            "ins": 2,
            "kbd": 2,
            "label": 2,
            "legend": 2,
            "main": 2,
            "map": 2,
            "mark": 2,
            "menu": 2,
            "menuitem": 2,
            "meter": 2,
            "nav": 2,
            "optgroup": 2,
            "option": 2,
            "output": 2,
            "progress": 2,
            "q": 2,
            "rp": 2,
            "rt": 2,
            "ruby": 2,
            "s": 2,
            "samp": 2,
            "section": 2,
            "select": 2,
            "sub": 2,
            "summary": 2,
            "sup": 2,
            "table": 2,
            "tbody": 2,
            "td": 2,
            "textarea": 2,
            "tfoot": 2,
            "th": 2,
            "thead": 2,
            "time": 2,
            "tr": 2,
            "var": 2,
            "wbr": 2,
        };
        var html5Attributes = {
            "src": 1,
            "srcset": 1,
            "href": 1,
            "xmlns": 1,
            "class": 2,
            "frameborder": 2,
            "allowfullscreen": 2,
            "alt": 2,
            "style": 2,
            "type": 2,
            "target": 2,
            "rel": 2,
            "name": 2,
            "translate": 2,
            "dir": 2,
            "id": 2,
            "width": 2,
            "height": 2,
            "placeholder": 2,
            "title": 2,
            "controls": 2,
            "autoplay": 2,
            "disabled": 2,
            "role": 2,
            "aria-atomic": 2,
            "aria-busy": 2,
            "aria-controls": 2,
            "aria-describedby": 2,
            "aria-disabled": 2,
            "aria-dropeffect": 2,
            "aria-flowto": 2,
            "aria-grabbed": 2,
            "aria-haspopup": 2,
            "aria-hidden": 2,
            "aria-invalid": 2,
            "aria-label": 2,
            "aria-labelledby": 2,
            "aria-live": 2,
            "aria-owns": 2,
            "aria-relevant": 2,
            "viewbox": 2,
            "preserveaspectratio": 2,
            "fill": 2,
            "d": 2,
            "cx": 2,
            "cy": 2,
            "r": 2,
            "stroke": 2,
            "stroke-width": 2,
            "transform": 2,
            "fill-opacity": 2,
            "stroke-miterlimit": 2,
            "stroke-dasharray": 2,
            "sandbox": 2,
        };
        function htmlOops(msg, html, other) {
            if (other)
                msg += ": " + other.slice(0, 100);
            var err = new Error("Critical: HTML sanitization failure, " + msg);
            err.bugAttachments = [html];
            if (other && other.length > 100)
                err.bugAttachments.push(other);
            throw err;
        }
        function validateTag(t, html) {
            if (/^\!--.*--$/.exec(t))
                return;
            var m = /^\/?([a-zA-Z0-9]+)(\s|\/?$)/.exec(t);
            if (!m)
                htmlOops("no tag name", html, t);
            var tn = m[1].toLowerCase();
            if (!HTML.html5Tags.hasOwnProperty(tn))
                htmlOops("unknown tag", html, tn);
            var v = HTML.html5Tags[tn];
            if (v !== 1)
                htmlOops("tag not allowed, " + v, html, tn);
            t = t.slice(m[0].length);
            while (!/^\s*\/?$/.test(t)) {
                m = /^\s*([a-zA-Z0-9-]+)($|\s|="([^"]*)"|='([^']*)'|=([a-zA-Z0-9]+))/.exec(t);
                if (!m)
                    htmlOops("cannot parse html attribute", html, t);
                var an = m[1].toLowerCase();
                var av = m[3] || m[4] || m[5] || "";
                if (/^data-/.test(an)) {
                }
                else if (!html5Attributes.hasOwnProperty(an))
                    htmlOops("unknown attribute", html, t);
                else {
                    var kk = html5Attributes[an];
                    if (kk == 1) {
                        if (!/^(http|\/|\.\/|#|mailto:)/i.test(av))
                            htmlOops("bad URL", html, t);
                    }
                    else if (kk == 2) {
                    }
                    else {
                        htmlOops("forbidden attribute", html, t);
                    }
                }
                t = t.slice(m[0].length);
            }
        }
        function sanitizeHTML(html) {
            if (!TDev.isBeta)
                return html;
            if (!html)
                return html;
            try {
                var reminder = html.replace(/<([^<>]+)>/g, function (allm, t) {
                    validateTag(t, html);
                    return "(tag)";
                });
                if (/[<>]/.test(reminder)) {
                    htmlOops("unexpected tag", html, reminder);
                }
                return html;
            }
            catch (e) {
                TDev.Util.reportError("html", e, false);
                return html;
            }
        }
        HTML.sanitizeHTML = sanitizeHTML;
        function allowedTagName(tn) {
            tn = tn.toLowerCase();
            if (!HTML.html5Tags.hasOwnProperty(tn))
                return false;
            var v = HTML.html5Tags[tn];
            return v === 1 || v === 2;
        }
        HTML.allowedTagName = allowedTagName;
        function allowedAttribute(name, val) {
            if (/^data-/.test(name))
                return true;
            if (!html5Attributes.hasOwnProperty(name))
                return false;
            var v = html5Attributes[val];
            if (v === 1)
                return /^(http|\/|\.\/|#|mailto:)/.test(val);
            else if (v === 2)
                return true;
            else
                return false;
        }
        HTML.allowedAttribute = allowedAttribute;
    })(HTML = TDev.HTML || (TDev.HTML = {}));
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var StackFrameBase = (function () {
        function StackFrameBase(rt) {
            this.rt = rt;
            this.returnAddr = null;
            this.entryAddr = null;
            this.previous = null;
            this.isLibProxy = false;
        }
        return StackFrameBase;
    })();
    TDev.StackFrameBase = StackFrameBase;
    var StackBottom = (function (_super) {
        __extends(StackBottom, _super);
        function StackBottom(rt) {
            _super.call(this, rt);
            this.needsPicker = false;
            this.pc = "";
            this.stackDepth = 0;
            this.name = "<entry-point>";
            this.d = this.rt.datas["this"];
            this.libs = this.rt.compiled.libs;
        }
        return StackBottom;
    })(StackFrameBase);
    TDev.StackBottom = StackBottom;
    var LibProxy = (function (_super) {
        __extends(LibProxy, _super);
        function LibProxy(libs, previous, libRefName, libActionName, invoke) {
            _super.call(this, previous.rt);
            this.libRefName = libRefName;
            this.libActionName = libActionName;
            this.invoke = invoke;
            this.isLibProxy = true;
            this.pc = "";
            this.libs = libs;
            this.previous = previous;
            this.prevPC = previous.pc;
            this.d = this.rt.datas[this.libRefName];
            this.name = this.libActionName;
            this.stackDepth = previous.stackDepth;
        }
        return LibProxy;
    })(StackFrameBase);
    TDev.LibProxy = LibProxy;
    var ResumeCtx = (function () {
        function ResumeCtx(stackframe) {
            this.stackframe = stackframe;
            this.used = false;
            this.isBlocking = false;
            this.rt = stackframe.rt;
            stackframe.rendermode = stackframe.rt.rendermode;
        }
        ResumeCtx.prototype.isTaskCtx = function () {
            return false;
        };
        ResumeCtx.prototype.clearProgress = function () {
            if (this.shownProgress) {
                this.shownProgress = false;
                TDev.HTML.showProgressNotification("");
            }
        };
        ResumeCtx.prototype.resumeVal = function (v) {
            if (this.used)
                return;
            this.used = true;
            this.clearProgress();
            this.resumeCore(v);
        };
        ResumeCtx.prototype.resumeCore = function (v) {
            this.rt._resumeVal(v, this);
        };
        ResumeCtx.prototype.resume = function () {
            return this.resumeVal(undefined);
        };
        ResumeCtx.prototype.progress = function (msg) {
            this.shownProgress = true;
            TDev.HTML.showProgressNotification(msg, false);
        };
        return ResumeCtx;
    })();
    TDev.ResumeCtx = ResumeCtx;
    (function (RtState) {
        RtState[RtState["Stopped"] = 0] = "Stopped";
        RtState[RtState["Running"] = 1] = "Running";
        RtState[RtState["Paused"] = 2] = "Paused";
        RtState[RtState["AtAwait"] = 3] = "AtAwait";
        RtState[RtState["BreakpointHit"] = 4] = "BreakpointHit";
    })(TDev.RtState || (TDev.RtState = {}));
    var RtState = TDev.RtState;
    var RuntimeSettings;
    (function (RuntimeSettings) {
        RuntimeSettings.readSetting = function (key) {
            return window.localStorage[key];
        };
        RuntimeSettings.storeSetting = function (key, value) {
            window.localStorage[key] = value;
        };
        function location() {
            return !RuntimeSettings.readSetting("rtnolocation");
        }
        RuntimeSettings.location = location;
        function setLocation(value) {
            RuntimeSettings.storeSetting("rtnolocation", value ? value : undefined);
        }
        RuntimeSettings.setLocation = setLocation;
        function sounds() {
            return !RuntimeSettings.readSetting("rtsnosounds");
        }
        RuntimeSettings.sounds = sounds;
        function setSounds(value) {
            RuntimeSettings.storeSetting("rtsnosounds", value ? value : undefined);
            if (!value)
                TDev.RT.Player.pause();
        }
        RuntimeSettings.setSounds = setSounds;
        RuntimeSettings.askSourceAccess = true;
    })(RuntimeSettings = TDev.RuntimeSettings || (TDev.RuntimeSettings = {}));
    var Runtime = (function () {
        function Runtime(sessions) {
            this.handlingException = false;
            this.datas = {};
            this.testMode = false;
            this.devMode = true;
            this.eventQ = null;
            this.recordTypesRegistered = false;
            this.resumePointOverride = null;
            this.versionNumber = 1;
            this.restartQueued = false;
            this.tutorialState = null;
            this.renderedComments = "";
            this.webState = {};
            this.state = 0 /* Stopped */;
            this.stateMsg = undefined;
            this.eventExecuting = false;
            this.mainLoopRunning = false;
            this.resumeAllowed = false;
            this.runningPluginOn = "";
            this.headlessPluginMode = false;
            this.tutorialObject = "";
            this.pageTransitionStyle = "slide";
            this.currentScriptId = undefined;
            this.currentAuthorId = undefined;
            this.baseScriptId = undefined;
            this.disposables = [];
            this.asyncStack = [];
            this.asyncTasks = [];
            this.runMap = new TDev.RunBitMap();
            this.debuggerLastState = null;
            this.eventCategory = null;
            this.eventVariable = null;
            this.inCloudCall = false;
            this.inQuery = false;
            this.rendermode = false;
            this.lastBreak = 0;
            this.quickLoopDepth = 0;
            this.sessions = sessions || new TDev.Revisions.Sessions();
            this.sessions.rt = this;
        }
        Runtime.prototype.liveMode = function () {
            return this.host.liveMode();
        };
        Runtime.prototype.getWall = function () {
            return this.host.getWall();
        };
        Runtime.prototype.runtimeKind = function () {
            return this.devMode ? "editor" : "website";
        };
        Runtime.prototype.requiresAuth = function () {
            return this.compiled.hasCloudData && this.sessions.getCurrentSession().requiresAuth;
        };
        Runtime.prototype.getUserId = function () {
            if (this.authUserId)
                return this.authUserId;
            if (this.sessions.isNodeClient()) {
                return this.sessions.getCurrentSession().clientUserId;
            }
            return TDev.Cloud.getUserId();
        };
        Runtime.prototype.getScriptGuid = function () {
            return this.host.currentGuid;
        };
        Runtime.prototype.getScriptName = function () {
            return this.compiled.scriptTitle;
        };
        Runtime.prototype.getScriptColor = function () {
            return this.compiled.scriptColor;
        };
        Runtime.prototype.beenHere = function (id) {
            this.runMap.push(id);
        };
        Runtime.prototype.resetRunMap = function () {
            this.runMap.clear();
        };
        Runtime.prototype.initBreakpoints = function (h) {
            this.breakpoints = h;
            this.updateScriptBreakpoints();
        };
        Runtime.prototype.hitBreakpoint = function (id) {
            this.debuggerLastState = this.state;
            this.setState(4 /* BreakpointHit */, "breakpoint");
            this.host.notifyBreakpointHit(id);
        };
        Runtime.prototype.updateScriptBreakpoints = function () {
            var _this = this;
            if (!this.compiled)
                return;
            var binds = this.compiled.breakpointBindings;
            Object.keys(binds).forEach(function (k) {
                var bind = binds[k];
                bind.setter(_this.breakpoints.get(k));
            });
        };
        Runtime.prototype.debuggerContinue = function () {
            if (!this.debuggerStopped())
                return;
            if (this.debuggerLastState !== null)
                this.setState(this.debuggerLastState, "debugger last state");
            if (this.debuggerCC)
                this.mainLoop(this.debuggerCC, "resume debugger");
        };
        Runtime.prototype.debuggerStopped = function () {
            return this.state === 4 /* BreakpointHit */;
        };
        Runtime.prototype.debuggerQueryGlobalValue = function (stableName) {
            TDev.Util.log("Runtime.debuggerQueryGlobalValue: " + stableName);
            if (!this.compiled || !this.current)
                return;
            return this.current.d[stableName];
        };
        Runtime.prototype.debuggerQueryLocalValue = function (actionId, name, stackFrame) {
            TDev.Util.log("Runtime.debuggerQueryLocalValue: " + name);
            if (!this.compiled || !this.current)
                return;
            var actionBindings;
            this.compiled.forEachLib(function (l) {
                if (!actionBindings && l.localNamesBindings)
                    actionBindings = l.localNamesBindings[actionId];
            });
            if (!actionBindings)
                return;
            name = actionBindings[name];
            TDev.Util.log("Runtime.debuggerQueryLocalValue resolved to: " + name);
            var frame = stackFrame ? stackFrame : this.current;
            return frame && frame["$" + name];
        };
        Runtime.prototype.debuggerQueryOutValue = function (ix, stackFrame) {
            TDev.Util.log("Runtime.debuggerQueryOutValue: " + ix);
            if (!this.compiled || !this.current)
                return;
            var frame = stackFrame ? stackFrame : this.current;
            if (ix > 0)
                return frame.results[ix];
            else
                return frame.orig_result || frame.result || (frame.results && frame.results[0]);
        };
        Runtime.prototype.saveAndCloseAllSessionsAsync = function () {
            return this.sessions.clearScriptContext(true);
        };
        Runtime.prototype.permissionsAsync = function () {
            return this.sessions.getLocalSessionAttributeAsync("____source_access", this).then(function (s) { return JSON.parse(s || "{}"); });
        };
        Runtime.prototype.savePermissionsAsync = function (perm) {
            return this.sessions.setLocalSessionAttributeAsync("____source_access", JSON.stringify(perm), this);
        };
        Runtime.offerNotifications = function () {
            return !!Runtime.refreshNotifications || !!localStorage["gcm"];
        };
        Runtime.prototype.getActionResults = function () {
            var r = this.returnedFrom;
            if (!r)
                return null;
            if (r.results)
                return r.results.slice(0);
            else
                return [r.result];
        };
        Runtime.prototype.setNextEvent = function (c, v) {
            this.eventCategory = c;
            this.eventVariable = v;
        };
        Runtime.prototype.resetNextEvent = function () {
            this.eventCategory = null;
            this.eventVariable = null;
        };
        Runtime.prototype.currentTime = function () {
            return TDev.Util.perfNow();
        };
        Runtime.prototype.setHost = function (h) {
            this.host = h;
            this.host.init(this);
        };
        Runtime.prototype.startCloudCall = function (libName, actionName, paramNames, returnNames, args, isQuery) {
            TDev.Util.assert(!this.inCloudCall);
            TDev.Util.assert(!this.inQuery);
            this.inCloudCall = true;
            if (!isQuery) {
                this.sessions.getCurrentSession().user_start_cloud_operation(libName, actionName, paramNames, returnNames, args, 2 /* OFFLINE */);
            }
            else {
                this.inQuery = true;
            }
        };
        Runtime.prototype.endCloudCall = function (libName, actionName, paramNames, returnNames, args, isQuery) {
            TDev.Util.assert(this.inCloudCall);
            this.inCloudCall = false;
            if (isQuery) {
                TDev.Util.assert(this.inQuery);
                this.inQuery = false;
            }
            else {
                this.sessions.getCurrentSession().user_stop_cloud_operation(libName, actionName, paramNames, returnNames, args);
            }
        };
        Runtime.prototype.log = function (s) {
            TDev.Util.log(s);
        };
        Runtime.prototype.mayPostToWall = function (p) {
            return !this.headlessPluginMode && (!p.isAuto() || this.rendermode || p.crashed);
        };
        Runtime.prototype.clearWall = function () {
            var p = this.getCurrentPage();
            if (p.isAuto())
                TDev.Util.userError(TDev.lf("cannot clear wall on pages"));
            p.clear();
            p.render(this.host);
        };
        Runtime.prototype.setWallDirection = function (topDown) {
            var p = this.getCurrentPage();
            if (p.isAuto())
                TDev.Util.userError(TDev.lf("cannot set wall direction on pages"));
            p.setReversed(topDown);
        };
        Runtime.prototype.postHtml = function (e, pc) {
            this.postBoxedHtml(e, pc);
        };
        Runtime.prototype.postText = function (s, pc) {
            this.postHtml(TDev.div("wall-text", s), pc);
        };
        Runtime.prototype.postException = function (e) {
            var p = this.getCurrentPage();
            if (this.rendermode)
                this.abortRender();
            else if (p.isAuto())
                p.clear();
            p.crashed = true;
            this.postBoxedHtml(e, "");
        };
        Runtime.prototype.addTapEvent = function (e, tp, box, v) {
            var _this = this;
            if (this.eventEnabled("tap wall " + tp)) {
                if (!box || !this.getCurrentPage().isAuto()) {
                    e.style.cursor = "pointer";
                    e.withClick(function () {
                        _this.eventQ.add("tap wall " + tp, null, [v]);
                    });
                }
                else {
                    box.withClick(function () {
                        _this.eventQ.add("tap wall " + tp, null, [v]);
                    });
                }
            }
        };
        Runtime.prototype.getPageCount = function () {
            return !this.pageStack ? 0 : this.pageStack.length < 1 ? 1 : this.pageStack.length;
        };
        Runtime.prototype.pushPage = function (auto) {
            if (auto === void 0) { auto = false; }
            var currentPage = this.getCurrentPage();
            currentPage.deactivate();
            var page = new TDev.WallPage(this, auto);
            if (auto && this.pageStack.length == 1 && !this.pageStack[0].isAuto() && this.pageStack[0].lastChildCount < 0 && !(this.pageStack[0].fullScreenElement))
                this.pageStack[0] = page;
            else
                this.pageStack.push(page);
            var wall = this.getWall();
            wall.appendChild(page.getElement());
            if (this.pageTransitionStyle == "slide")
                TDev.Util.coreAnim("showPageRight", 400, page.getElement());
            else if (this.pageTransitionStyle == "fade")
                TDev.Util.coreAnim("fadeIn", 400, page.getElement());
            this.forcePageRefresh();
            this.host.notifyPagePush();
            this.applyPageAttributes();
            return page;
        };
        Runtime.prototype.popPagesIncluding = function (p) {
            while (this.pageStack.indexOf(p) >= 0) {
                if (!this.popPage())
                    return;
            }
        };
        Runtime.prototype.popPage = function (transition) {
            var _this = this;
            if (transition === void 0) { transition = null; }
            if (this.pageStack.length <= 1)
                return false;
            var currentPage = this.pageStack.pop();
            var prevPage = currentPage;
            var currentElement = currentPage.getElement();
            currentPage = this.getCurrentPage();
            currentPage.activate();
            var hideStyle = transition;
            var hideAnim = null;
            if (hideStyle == "slide" || hideStyle == "slide right")
                hideAnim = "hidePageLeft 0.2";
            else if (hideStyle == "slide up")
                hideAnim = "hidePageUp 0.7";
            else if (hideStyle == "slide down")
                hideAnim = "hidePageDown 0.7";
            else if (hideStyle == "fade")
                hideAnim = "fadeOut 0.3";
            else if (hideStyle == "none")
                hideAnim = "fadeOut 0.01";
            if (!hideAnim && this.pageTransitionStyle == "slide")
                hideAnim = "hidePageLeft 0.2";
            if (hideAnim) {
                currentPage.getElement().style.opacity = "0";
                var parts = hideAnim.split(/ /);
                var hideDuration = parseFloat(parts[1]) * 1000;
                hideAnim = parts[0];
                TDev.Util.coreAnim(hideAnim, hideDuration, currentElement, function () {
                    currentElement.removeSelf();
                    currentPage.getElement().style.opacity = null;
                    if (_this.pageTransitionStyle == "slide")
                        TDev.Util.coreAnim("showPageLeft", 300, currentPage.getElement());
                    else if (_this.pageTransitionStyle == "fade")
                        TDev.Util.coreAnim("fadeIn", 400, currentPage.getElement());
                    else {
                    }
                });
            }
            else if (this.pageTransitionStyle == "fade") {
                TDev.Util.coreAnim("fadeOut", 400, currentElement, function () { return currentElement.removeSelf(); });
                TDev.Util.coreAnim("fadeIn", 400, currentPage.getElement());
            }
            else {
                currentElement.removeSelf();
            }
            if (this.eventEnabled("page navigated from"))
                this.eventQ.add("page navigated from", null, [prevPage.rtPage()]);
            if (prevPage.onNavigatedFrom.handlers)
                this.queueLocalEvent(prevPage.onNavigatedFrom);
            this.host.notifyPagePop(prevPage);
            this.applyPageAttributes();
            if (currentPage.isAuto())
                this.forcePageRefresh();
            else
                currentPage.render(this.host);
            return true;
        };
        Runtime.prototype.getPageAt = function (idx) {
            if (idx == 0)
                return this.getCurrentPage();
            else
                return this.pageStack[idx];
        };
        Runtime.prototype.initPageStack = function () {
            var page = new TDev.WallPage(this, false);
            this.pageStack = [page];
            var wall = this.getWall();
            if (wall)
                wall.setChildren([page.getElement()]);
            this.sessions.scriptRestarted();
            this.resetRender();
        };
        Runtime.prototype.refreshPageStackForNewScript = function () {
            this.pageStack.forEach(function (p) { return p.refreshForNewScript(); });
        };
        Runtime.prototype.getCurrentPage = function () {
            if (!this.pageStack)
                return new TDev.WallPage(this, false);
            return this.pageStack.peek();
        };
        Runtime.prototype.onCssPage = function () {
            if (!this.pageStack)
                return false;
            var pg = this.pageStack.peek();
            return pg ? pg.csslayout : false;
        };
        Runtime.prototype.addPageButton = function (pageButton) {
            this.forceNonRender("You may not add a page button here");
            var currentPage = this.getCurrentPage();
            currentPage.buttons.push(pageButton);
            this.host.notifyPageButtonUpdate();
            this.addTapEvent(pageButton.getElement(), "Page Button", null, pageButton);
        };
        Runtime.prototype.clearPageButtons = function () {
            this.forceNonRender("You may not remove a page button here");
            var currentPage = this.getCurrentPage();
            currentPage.buttons = [];
            this.host.notifyPageButtonUpdate();
        };
        Runtime.prototype.getPageButtons = function () {
            return this.getCurrentPage().buttons;
        };
        Runtime.prototype.applyPageAttributes = function (renderwall) {
            if (renderwall === void 0) { renderwall = false; }
            var p = this.getCurrentPage();
            this.host.applyPageAttributes(p);
            if (renderwall && !p.isAuto())
                p.render(this.host);
        };
        Runtime.prototype.postAutoPage = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i - 0] = arguments[_i];
            }
            this.eventQ.add("page", null, args);
        };
        Runtime.prototype.forceNonRender = function (msg) {
            if (msg === void 0) { msg = "You may not perform this operation here"; }
            if (this.rendermode) {
                TDev.Util.userError(msg + ". Only side-effect-free operations are allowed in page display code.");
            }
        };
        Runtime.prototype.mkLibObject = function (libId, objectName) {
            var singl = this.getLibRecordSingleton(libId, objectName);
            var obj = new singl.entryCtor(this);
            obj.on_render_heap = this.rendermode;
            return obj;
        };
        Runtime.prototype.getLibRecordSingleton = function (libId, objectName) {
            var indir = this.current.libs[libId + "$lib"];
            if (indir)
                libId = indir;
            var d = this.datas[libId];
            var getsingl = this.compiled.libScripts[libId].objectSingletons[objectName];
            return getsingl(d);
        };
        Runtime.prototype.logDataWrite = function (renderheap) {
            if (renderheap === void 0) { renderheap = false; }
            if (!renderheap)
                this.forceNonRender("You may not modify global variables here");
            if (this.inQuery)
                this.forceNonRender("You may not change data in a query function");
            this.forcePageRefresh();
        };
        Runtime.prototype.logObjectMutation = function (value) {
            if (value) {
                value.versioncounter++;
                if (!value.on_render_heap) {
                    this.forcePageRefresh();
                    this.forceNonRender();
                }
            }
            else {
                this.forceNonRender();
                this.forcePageRefresh();
            }
        };
        Runtime.prototype.forcePageRefresh = function () {
            if (!TDev.Browser.isNodeJS) {
                if (this.eventQ)
                    this.eventQ.queuePageUpdate();
            }
        };
        Runtime.prototype.yield_when_possible = function () {
            if (this.eventQ)
                this.eventQ.queueYield();
        };
        Runtime.prototype.yield_now = function () {
            var changes = this.sessions.yieldSession();
            if (this.eventQ) {
                this.eventQ.finishYield(changes, this.eventEnabled("cloud data updated"));
            }
        };
        Runtime.prototype.registerTimeDependency = function () {
            if (this.rendermode && this.eventQ)
                this.eventQ.registerTimeDependency();
        };
        Runtime.prototype.canPause = function () {
            return this.pageStack && this.pageStack.length && this.pageStack[this.pageStack.length - 1].isAuto();
        };
        Runtime.prototype.canResume = function () {
            return this.canPause() && this.resumeAllowed;
        };
        Runtime.prototype.liveViewSupported = function () {
            return this.canResume() && this.getCurrentPage().isAuto();
        };
        Runtime.prototype.enter_render = function () {
            this.rendermode = true;
            TDev.LayoutMgr.SetRenderExecutionMode(true);
            var page = this.getCurrentPage();
            page.startrender();
            TDev.LayoutMgr.setCurrentRenderBox(page.getCurrentBox());
            TDev.Util.log("Enter Render Mode");
        };
        Runtime.prototype.leave_render = function () {
            TDev.Util.log("Leave Render Mode");
            this.render();
            TDev.LayoutMgr.SetRenderExecutionMode(false);
            this.rendermode = false;
            if (this.eventQ)
                this.eventQ.finishPageUpdate();
        };
        Runtime.prototype.abortRender = function () {
            TDev.LayoutMgr.SetRenderExecutionMode(false);
            this.rendermode = false;
            this.getCurrentPage().clear();
            this.host.setFullScreenElement(undefined);
        };
        Runtime.prototype.resetRender = function () {
            TDev.LayoutMgr.SetRenderExecutionMode(false);
            this.rendermode = false;
            this.host.setFullScreenElement(undefined);
        };
        Runtime.prototype.markAllocated = function (obj) {
            if (this.rendermode && obj)
                obj.on_render_heap = true;
        };
        Runtime.prototype.getCurrentBoxBase = function (nonRenderOk) {
            if (nonRenderOk === void 0) { nonRenderOk = false; }
            if (this.rendermode) {
                return TDev.LayoutMgr.getCurrentRenderBox();
            }
            else {
                if (!nonRenderOk)
                    TDev.Util.userError(TDev.lf("'box' can only be accessed in page display code"));
                return this.getCurrentPage().getCurrentBox();
            }
        };
        Runtime.prototype.getCurrentBox = function () {
            var box = this.getCurrentBoxBase();
            if (!(box instanceof TDev.WallBox))
                TDev.Util.userError(TDev.lf("'box' cannot be accessed in HTML layout mode"));
            return box;
        };
        Runtime.prototype.getCurrentHtmlBox = function () {
            var box = this.getCurrentBoxBase();
            if (!(box instanceof TDev.HtmlBox))
                TDev.Util.userError(TDev.lf("'html' can only be accessed in HTML layout mode"));
            return box;
        };
        Runtime.prototype.render = function (popCount) {
            if (popCount === void 0) { popCount = 0; }
            TDev.Util.assertCode(popCount >= 0);
            this.getCurrentPage().render(this.host, popCount);
        };
        Runtime.prototype.renderBox = function (box) {
            var p = this.getCurrentPage();
            if ((p.crashed || !p.isAuto()) && box.getDepth() === 1) {
                var popCount = 0;
                var parent = box.parent;
                TDev.Util.assert(parent instanceof TDev.WallBox);
                if (parent.size() > Runtime.maxBoxLength) {
                    parent.shift();
                    popCount++;
                }
                this.render(popCount);
            }
        };
        Runtime.prototype.postBoxedHtml = function (e, pc, reusekey) {
            if (reusekey === void 0) { reusekey = null; }
            if (!this.mayPostToWall(this.getCurrentPage()))
                TDev.Util.userError(TDev.lf("cannot post to the wall here"));
            var box = TDev.WallBox.CreateOrRecycleLeafBox(this, reusekey);
            box.setContent(e);
            this.renderBox(box);
            return box;
        };
        Runtime.prototype.postBoxedTextWithTap = function (s, rtV, pc) {
            if (!this.mayPostToWall(this.getCurrentPage()))
                TDev.Util.userError(TDev.lf("cannot post to the wall here"));
            var box = TDev.WallBox.CreateOrRecycleLeafBox(this, rtV);
            if (!box.getContent()) {
                box.setContent(s);
                this.renderBox(box);
                var type;
                switch (typeof rtV) {
                    case "boolean":
                        type = "Bool";
                        break;
                    case "string":
                        type = "String";
                        break;
                    case "number":
                        type = "Number";
                        break;
                    default:
                        type = rtV.rtType();
                        break;
                }
                if (box instanceof TDev.WallBox)
                    this.addTapEvent(box.getContent(), type, box, rtV);
            }
            return box;
        };
        Runtime.prototype.postBoxedText = function (s, pc) {
            if (!this.mayPostToWall(this.getCurrentPage()))
                TDev.Util.userError(TDev.lf("cannot post to the wall here"));
            var box = TDev.WallBox.CreateOrRecycleLeafBox(this, s);
            if (!box.getContent()) {
                box.setContent(s);
                this.renderBox(box);
            }
            return box;
        };
        Runtime.prototype.postUnboxedText = function (s, pc) {
            if (!this.mayPostToWall(this.getCurrentPage()))
                TDev.Util.userError(TDev.lf("cannot post to the wall here"));
            var box = TDev.WallBox.CreateOrRecycleLeafBox(this, s);
            if (!box.getContent()) {
                box.setContent(TDev.text(s));
                this.renderBox(box);
            }
            return box;
        };
        Runtime.prototype.postEditableText = function (style, s, handler, pc) {
            if (!this.mayPostToWall(this.getCurrentPage()))
                TDev.Util.userError(TDev.lf("cannot post to the wall here"));
            var box = TDev.WallBox.CreateOrRecycleLeafBox(this, style);
            var current = box.getContent();
            if (!current) {
                if (style === "textarea") {
                    box.textarea = true;
                    var elt = TDev.HTML.mkTextArea();
                    elt.id = "i" + box.getId();
                    box.setContent(elt);
                }
                else {
                    box.textarea = false;
                    style = (Runtime.inputboxstylemap[style] || "text");
                    var elt2 = TDev.HTML.mkTextInput(style, TDev.lf("edit"));
                    elt2.id = "i" + box.getId();
                    box.setContent(elt2);
                }
                box.bindEditableText(s, handler, pc);
                this.renderBox(box);
            }
            else {
                box.textarea = (style === "textarea");
                box.bindEditableText(s, handler, pc);
            }
            return box;
        };
        Runtime.prototype.nextHitCount = function (current) {
            if (current >= 200)
                return Math.round(200 + (Math.random() * 50));
            else
                return Math.round(current * (Math.random() + 1) + 2);
        };
        Runtime.prototype.isHeadless = function () {
            return this.host && this.host.isHeadless();
        };
        Runtime.prototype.restartAfterException = function () {
            this.current = null;
            this.asyncStack = [];
            this.setState(3 /* AtAwait */, "restart after exception");
            this.queueRestart();
        };
        Runtime.prototype.stopAsync = function (isPause) {
            var _this = this;
            if (isPause === void 0) { isPause = false; }
            var p = TDev.Promise.as();
            if (!this.isHeadless()) {
                TDev.HistoryMgr.instance.clearModalStack();
            }
            if (this.state != 0 /* Stopped */) {
                this.setState(0 /* Stopped */, "stopAsync");
                if (!isPause) {
                    this.versionNumber++;
                    if (this.eventQ)
                        this.eventQ.clear();
                }
                this.eventExecuting = false;
                this.resumeAllowed = isPause;
                if (this.headlessPluginMode)
                    TDev.ProgressOverlay.hide();
                this.asyncStack = [];
                this.asyncTasks = [];
                this.compiled.stopFn(this);
                if (!isPause && !this.resumeAllowed && !this.handlingException) {
                    var profilingData = this.compiled._getProfilingResults();
                    this.host.attachProfilingInfo(profilingData);
                    var runMap = this.getRunMap();
                    if (runMap)
                        this.host.attachCoverageInfo({
                            compilerversion: this.compiled._compilerVersion,
                            astnodes: runMap.toJSON()
                        }, this.compiled._showCoverage);
                }
                if (!this.resumeAllowed) {
                    this.killDisposables();
                    this.killTempState();
                }
                p = this.host.notifyStopAsync();
                p = p.then(function () { return _this.sessions.stopAsync(); });
            }
            return p;
        };
        Runtime.prototype.stopAndHideAsync = function () {
            var p = this.stopAsync();
            this.host.notifyHideWall();
            return p;
        };
        Runtime.prototype.isStopped = function () {
            return this.state == 0 /* Stopped */;
        };
        Runtime.prototype.queueEvent = function (category, varValue, args, ignore) {
            if (ignore === void 0) { ignore = true; }
            if (this.eventQ == null)
                return;
            this.eventQ.add(category, varValue, args, ignore);
        };
        Runtime.prototype.queueBoardEvent = function (categories, valueStack, args, ignore, matchAll) {
            if (ignore === void 0) { ignore = true; }
            if (matchAll === void 0) { matchAll = false; }
            if (this.eventQ == null)
                return;
            this.eventQ.addBoardEvent(categories, valueStack, args, ignore, matchAll);
        };
        Runtime.prototype.queueLocalEvent = function (e, args, ignore, skipIfInQueue, filter) {
            if (args === void 0) { args = []; }
            if (ignore === void 0) { ignore = true; }
            if (skipIfInQueue === void 0) { skipIfInQueue = false; }
            if (filter === void 0) { filter = undefined; }
            if (this.eventQ == null)
                return;
            this.eventQ.addLocalEvent(e, args, ignore, skipIfInQueue, filter);
        };
        Runtime.prototype.queueAsyncEvent = function (f) {
            this.asyncTasks.push(f);
            this.queueRestart();
        };
        Runtime.prototype.queueRestart = function () {
            var _this = this;
            if (this.restartQueued || this.state != 3 /* AtAwait */)
                return;
            this.restartQueued = true;
            TDev.Util.setTimeout(0, function () {
                _this.restartQueued = false;
                if (_this.state != 3 /* AtAwait */)
                    return;
                var f = _this.pumpEventsCore();
                if (f) {
                    _this.mainLoop(f, "queue restart");
                }
            });
        };
        Runtime.prototype.eventEnabled = function (category) {
            return this.eventQ != null && !!this.eventQ.eventsByCategory[category];
        };
        Runtime.prototype.enterAsync = function (t, s) {
            var _this = this;
            this.current.continueAt = s.returnAddr;
            this.asyncStack.push(this.current);
            s.asyncTask = t;
            s.returnAddr = function (s) {
                var prev = s.rt.returnedFrom;
                t.resume(prev.results || prev.result);
                _this.setState(3 /* AtAwait */, "enterAsync stop");
                return null;
            };
            return this.enter(s);
        };
        Runtime.prototype.isTopScriptFrame = function (s) {
            return s.libs.scriptId === s.libs.topScriptId;
        };
        Runtime.prototype.getTopScriptPc = function () {
            return this.current ? ((!this.rendermode || this.isTopScriptFrame(this.current)) ? this.current.pc : this.last_topscript_pc) : "";
        };
        Runtime.prototype.enter = function (s) {
            this.current = s;
            if (s.previous) {
                if (this.rendermode && s.previous.isLibProxy && this.isTopScriptFrame(s.previous.previous)) {
                    this.last_topscript_pc = s.previous.previous.pc;
                    s.previous.previous.libs;
                }
                s.stackDepth = s.previous.stackDepth + 1;
                if (s.stackDepth > 1000) {
                    TDev.Util.userError("stack overflow");
                }
            }
            return s.entryAddr;
        };
        Runtime.prototype.leave = function () {
            var c = this.current;
            this.current = c.previous;
            if (this.current.isLibProxy)
                this.current = this.current.previous;
            if (c.serverRequest)
                c.serverRequest.response().sendNow();
            this.returnedFrom = c;
            var ret = c.returnAddr;
            c.returnAddr = Runtime.pumpEvents;
            return ret;
        };
        Runtime.toRestArgument = function (v, s) {
            if (typeof v == "undefined" || typeof v == "string" || typeof v == "number" || typeof v == "boolean") {
                return v;
            }
            else if (v.exportJson) {
                try {
                    var ctx = new TDev.JsonExportCtx(s);
                    var v0 = v;
                    ctx.push(v0);
                    v = v.exportJson(ctx);
                    ctx.pop(v0);
                    return v;
                }
                catch (e) {
                    TDev.Util.userError("JSON export failed on " + v.toString());
                }
            }
            else {
                TDev.Util.userError("unsupported value in JSON cloud call: " + v.toString());
            }
        };
        Runtime.prototype.getRuntimeType = function (libname, typename) {
            var type = this.datas[libname];
            var result;
            Object.keys(type).forEach(function (t) {
                if (type[t].name === typename) {
                    result = type[t];
                }
            });
            return result;
        };
        Runtime.stringToBoolean = function (s) {
            if (!s)
                return false;
            if (/^(false|no|0)$/i.test(s))
                return false;
            return true;
        };
        Runtime.fromRestArgument = function (v, tp, s) {
            var singleton = s.d["$" + tp];
            if (singleton !== undefined) {
                return singleton.fromRest(v);
            }
            var a = tp.indexOf("→");
            if (a !== -1) {
                var lib = tp.slice(0, a);
                var tab = tp.slice(a + 1);
                if (lib.indexOf("Collection of") !== -1) {
                    lib = lib.slice(14);
                    var typ = s.rt.getRuntimeType(lib, tab);
                    return TDev.RT.Collection.fromArray(v.map(function (v) { return typ.fromRest(v); }), typ);
                }
                else {
                    return s.rt.getRuntimeType(lib, tab).fromRest(v);
                }
            }
            switch (tp) {
                case "Number":
                    return parseFloat(v);
                case "String":
                    return v + "";
                case "Boolean":
                    return Runtime.stringToBoolean(v);
                case "Json Object":
                    return RT.JsonObject.wrap(v);
                case "Json Builder":
                    if (typeof v == "object")
                        return RT.JsonBuilder.wrap(TDev.Util.jsonClone(v));
                    return undefined;
                default:
                    TDev.RT.App.logEvent(TDev.RT.App.WARNING, "rest", TDev.lf("unsupported type {0}", tp), undefined);
                    return undefined;
            }
        };
        Runtime.prototype.callServiceOffline = function (isQuery, site, service, libName, actionName, paramNames, returnNames, returnTypes, prev, ret) {
            var args = [];
            for (var _i = 10; _i < arguments.length; _i++) {
                args[_i - 10] = arguments[_i];
            }
            var rt = this;
            var action = prev.libs[libName][actionName](prev);
            var next = ret;
            if (this.rendermode && !isQuery) {
                this.forceNonRender("Can not call a cloud function that is not \"read-only\" in display code");
            }
            if (!rt.inCloudCall && !rt.host.isServer) {
                var req = {};
                for (var i = 0; i < args.length; i++) {
                    req[paramNames[i]] = Runtime.toRestArgument(args[i], prev);
                }
                prev.rt.startCloudCall(service, actionName, paramNames, returnNames, req, isQuery);
                next = function (s) {
                    s.rt.endCloudCall(service, actionName, paramNames, returnNames, req, isQuery);
                    return ret;
                };
            }
            return action.invoke.apply(action, [action, next].concat(args));
        };
        Runtime.prototype.queryServiceAsync = function (path, req, site) {
            if (site === void 0) { site = ""; }
            var hdrs = {};
            hdrs["Content-type"] = "application/json;charset=UTF-8";
            if (this.authAccessToken)
                hdrs["Authorization"] = "Bearer " + this.authAccessToken;
            if (!site)
                site = this.compiled.azureSite;
            return TDev.Util.httpRequestAsync(site + "-tdevrpc-/" + path, "POST", JSON.stringify(req), hdrs).then(function (s) { return s ? JSON.parse(s) : {}; });
        };
        Runtime.prototype.callService = function (isQuery, site, service, libName, actionName, paramNames, returnNames, returnTypes, prev, ret) {
            var _this = this;
            var args = [];
            for (var _i = 10; _i < arguments.length; _i++) {
                args[_i - 10] = arguments[_i];
            }
            var rt = this;
            var run = function (s) {
                if (_this.rendermode) {
                    _this.forceNonRender("Can not call a remote cloud function in display code (only \"offline available\" \"read-only\" are allowed)");
                }
                var ctx = _this.getAwaitResumeCtx(function (s) { return s.rt.leave(); });
                var req = {};
                for (var i = 0; i < args.length; i++) {
                    req[paramNames[i]] = Runtime.toRestArgument(args[i], prev);
                }
                _this.queryServiceAsync(encodeURIComponent(service) + "/" + encodeURIComponent(actionName), req, site).done(function (resp) {
                    var results = returnNames.map(function (n) { return resp[n]; });
                    results = results.map(function (v, i) { return Runtime.fromRestArgument(v, returnTypes[i], s); });
                    if (results.length == 1)
                        s.result = results[0];
                    else
                        s.results = results;
                    ctx.resume();
                }, function (err) {
                    TDev.Runtime.theRuntime.handleException(err, s);
                });
            };
            return {
                previous: prev,
                returnAddr: ret,
                d: prev.d,
                rt: this,
                libs: prev.libs,
                entryAddr: run,
                name: actionName
            };
        };
        Runtime.prototype.pickParameters = function (cont) {
            var _this = this;
            var parms = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                parms[_i - 1] = arguments[_i];
            }
            var ch = parms.map(function (p) { return [TDev.div("picker-name", p.userName + ":"), TDev.div("picker-input", p.html)]; });
            var ctx = this.getAwaitResumeCtx(cont);
            ch.push(TDev.div("wall-dialog-buttons", TDev.HTML.mkButton(TDev.lf("ok"), function () {
                var allOk = true;
                var s = _this.current;
                parms.forEach(function (p) {
                    var ok = p.validate();
                    allOk = allOk && ok;
                    p.html.setFlag("invalid", !ok);
                    if (ok) {
                        s[p.quotedName] = p.get();
                    }
                });
                if (allOk)
                    ctx.resume();
            })));
            this.postHtml(TDev.div("picker-form", ch), "");
        };
        Runtime.prototype.displayResult = function (name, val) {
            var _this = this;
            var e = TDev.div("picker-form");
            var pc = this.current.pc;
            var box = new TDev.WallBox(this, this.getCurrentBoxBase(true), pc);
            box.setContent(e);
            this.getCurrentPage().setCurrentBox(box);
            var dual = function (str) {
                _this.postHtml(TDev.div("picker-name", name + ":"), pc);
                _this.postHtml(TDev.div("picker-input", str), pc);
            };
            try {
                switch (typeof val) {
                    case "string":
                        dual(val);
                        break;
                    case "number":
                        dual(val + "");
                        break;
                    case "boolean":
                        dual(val ? "True" : "False");
                        break;
                    case "undefined":
                        dual("[invalid]");
                        break;
                    default:
                        if (val === null)
                            dual("[null]");
                        else {
                            if (val.postResult)
                                val.postResult(this.current);
                            else {
                                this.postText(name + ":", pc);
                                val.post_to_wall(this.current);
                            }
                        }
                        break;
                }
            }
            finally {
                this.getCurrentPage().setCurrentBox(box.parent);
            }
            box.forEachChild(function (c) {
                e.appendChild(c.getContent());
            });
            this.renderBox(box);
        };
        Runtime.prototype.setState = function (s, msg) {
            if (this.state == 0 /* Stopped */ || s == 0 /* Stopped */)
                TDev.Util.log("runtime state: {0} -> {1}, {2}", this.state, s, msg);
            this.state = s;
            this.stateMsg = msg;
        };
        Runtime.prototype.getResumeCtxCore = function (isBlocking, cont) {
            TDev.Util.assert(this.state == 1 /* Running */);
            if (isBlocking)
                this.setState(2 /* Paused */, "getBlockingResumeCtx");
            else
                this.setState(3 /* AtAwait */, "getAwaitResumeCtx");
            this.current.continueAt = cont;
            var r = new ResumeCtx(this.current);
            r.isBlocking = isBlocking;
            r.versionNumber = this.versionNumber;
            return r;
        };
        Runtime.prototype.getBlockingResumeCtx = function (cont) {
            return this.getResumeCtxCore(true, cont);
        };
        Runtime.prototype.getAwaitResumeCtx = function (cont) {
            if (this.rendermode)
                TDev.Util.userError("non-atomic APIs cannot be called in page display code");
            return this.getResumeCtxCore(false, cont);
        };
        Runtime.prototype.getAsyncResumeCtx = function () {
            TDev.Util.assert(this.state == 1 /* Running */);
            if (this.rendermode)
                TDev.Util.userError("'async' cannot be used in page display code");
            var t = new RT.Task();
            var r = new RT.TaskResumeCtx(t, this.current);
            r.versionNumber = this.versionNumber;
            return r;
        };
        Runtime.prototype.mkActionTask = function () {
            var t = new RT.Task();
            return t;
        };
        Runtime.prototype._resumeVal = function (v, r) {
            var _this = this;
            var frame = r.stackframe;
            if (r.versionNumber != this.versionNumber)
                return;
            if (this.state == 2 /* Paused */) {
                if (r.isBlocking) {
                    this._resumeValCore(v, frame);
                    this.mainLoop(frame.continueAt, "_resumeValBlocking");
                }
                else {
                    this.queueAsyncEvent(function () { return _this.continueStackFrame(v, frame); });
                }
            }
            else if (this.state == 3 /* AtAwait */) {
                TDev.Util.assert(!r.isBlocking, "blocking await");
                this._resumeValCore(v, frame);
                this.mainLoop(frame.continueAt, "_resumeValAwait");
            }
            else {
                TDev.Util.oops("wrong resume state: " + this.state);
            }
        };
        Runtime.prototype.continueStackFrame = function (v, frame) {
            this._resumeValCore(v, frame);
            return frame.continueAt;
        };
        Runtime.prototype._resumeValCore = function (v, frame) {
            this.current = frame;
            if (frame.rendermode !== undefined)
                this.rendermode = frame.rendermode;
            frame.pauseValue = v;
        };
        Runtime.prototype.initFrom = function (cs) {
            this.compiled = cs;
            if (cs.authorId)
                this.currentAuthorId = cs.authorId;
            if (cs.scriptId) {
                this.currentScriptId = this.baseScriptId = cs.scriptId;
            }
            cs.initPages();
            EventQueue.init(this);
            this.sessions.scriptStarted(cs.authorId);
        };
        Runtime.prototype.nextAsyncTask = function () {
            if (this.asyncStack.length > 0) {
                if (this.current.asyncTask)
                    this.current.isDetached = true;
                var f = this.asyncStack.pop();
                this.current = f;
                this.setState(1 /* Running */, "async stack");
                return f.continueAt;
            }
            else if (this.asyncTasks.length > 0) {
                var q = this.asyncTasks.shift();
                this.setState(1 /* Running */, "async task");
                return q();
            }
            else {
                return null;
            }
        };
        Runtime.prototype.runInlineJavascript = function (f) {
            f();
        };
        Runtime.prototype.wrap = function (s, f) {
            if (this.isStopped())
                return function () {
                };
            if (!s)
                s = this.current;
            var rt = s.rt;
            TDev.Util.assert(rt == this);
            return function () {
                try {
                    if (rt.isStopped())
                        return undefined;
                    Runtime.theRuntime = rt;
                    rt.current = s;
                    f.apply(this, arguments);
                }
                catch (e) {
                    e.tdStackFrame = s;
                    throw e;
                }
            };
        };
        Runtime.prototype.pumpEventsCore = function () {
            this.yield_now();
            TDev.Util.assert(!this.isStopped(), "pump-stopped");
            var r = this.nextAsyncTask();
            if (r)
                return r;
            if (this.eventQ == null) {
                this.stopAsync().done();
                return null;
            }
            else if (this.eventExecuting) {
                this.setState(3 /* AtAwait */, "event executing");
                return null;
            }
            else {
                var fn = this.eventQ.maybeRunPageRefresh();
                if (!fn)
                    fn = this.eventQ.process();
                if (!fn && this.host.dontWaitForEvents())
                    this.stopAsync(true).done();
                else if (fn)
                    this.setState(1 /* Running */, "got event");
                else {
                    if (this.liveMode())
                        this.stopAsync(true).done();
                    else if (this.headlessPluginMode)
                        this.stopAsync().done();
                    else
                        this.setState(3 /* AtAwait */, "no event");
                }
                return fn;
            }
        };
        Runtime.pumpEvents = function (s) {
            s.rt.eventExecuting = false;
            return s.rt.pumpEventsCore();
        };
        Runtime.prototype.pauseExecution = function () {
            this.queueEvent("pause", null, []);
        };
        Runtime.prototype.resumeExecution = function (once) {
            if (once === void 0) { once = false; }
            this.eventQ.clearPause();
            if (this.state != 0 /* Stopped */ || !this.resumeAllowed)
                return;
            this.refreshPageStackForNewScript();
            this.eventQ.clear();
            if (!this.liveMode())
                this.getWall().setChildrenIfNeeded(this.pageStack.map(function (p) { return p.getElement(); }));
            try {
                this.eventQ.blockEvents = false;
                this.logDataWrite();
                this.eventQ.blockEvents = once;
                var bot = new StackBottom(this);
                bot.entryAddr = Runtime.pumpEvents;
                bot.returnAddr = Runtime.pumpEvents;
                var frame = this.enter(bot);
                this.mainLoop(frame, "resume execution");
            }
            catch (e) {
                this.handleException(e, this.current);
            }
        };
        Runtime.mkStackFrame = function (prev, ret) {
            return {
                previous: prev,
                prevPC: prev.pc,
                d: prev.d,
                rt: prev.rt,
                libs: prev.libs,
                returnAddr: ret,
            };
        };
        Runtime.syntheticFrame = function (f) {
            return function (prev, ret) {
                var s = Runtime.mkStackFrame(prev, ret);
                s.name = "__synthetic";
                s.entryAddr = function (s) {
                    s.rt.forcePageRefresh();
                    f(s);
                    return s.rt.leave();
                };
                return s;
            };
        };
        Runtime.prototype.getActionFrame = function (mk, args, isBlocking) {
            if (isBlocking === void 0) { isBlocking = true; }
            var bot = new StackBottom(this);
            if (args == null) {
                bot.needsPicker = true;
                args = [];
            }
            var fnObj;
            if (isBlocking)
                this.eventExecuting = true;
            if (args.length == 0)
                fnObj = mk(bot, Runtime.pumpEvents);
            else
                fnObj = mk.apply(null, [bot, Runtime.pumpEvents].concat(args));
            this.resetNextEvent();
            return this.enter(fnObj);
        };
        Runtime.prototype.queueEventCallback = function (cb) {
            var ev = new RT.Event_();
            ev.addHandler(new RT.PseudoAction(function (rt, args) {
                cb(rt, args);
            }));
            this.queueLocalEvent(ev);
        };
        Runtime.prototype.getEventFrame = function (mk, args, isBlocking) {
            if (isBlocking === void 0) { isBlocking = true; }
            try {
                if (this.state != 1 /* Running */) {
                    TDev.Util.assert(this.state == 3 /* AtAwait */);
                    this.setState(1 /* Running */, "getEventFrame dispatch");
                }
                return this.getActionFrame(mk, args, isBlocking);
            }
            catch (e) {
                return function () {
                    throw e;
                    return null;
                };
            }
        };
        Runtime.handleUserError = function (err) {
            var rt = Runtime.theRuntime;
            if (rt && rt.state != 0 /* Stopped */ && !rt.handlingException) {
                if (err.isUserError) {
                    rt.handleException(err, rt.current);
                    return true;
                }
            }
            return false;
        };
        Runtime.stopPendingScriptsAsync = function () {
            if (Runtime.theRuntime && Runtime.theRuntime.state != 0 /* Stopped */) {
                return Runtime.theRuntime.stopAsync();
            }
            else {
                return TDev.Promise.as();
            }
        };
        Runtime.prototype.rerunAsync = function () {
            var _this = this;
            return this.stopAsync().then(function () {
                TDev.Util.assert(_this.isStopped(), "rerun-isStopped");
                _this.initPageStack();
                _this.run(_this.startMk, _this.startArgs);
            });
        };
        Runtime.prototype.run = function (mk, args) {
            var _this = this;
            TDev.Util.assert(this.isStopped(), "run-isStopped");
            this.startMk = mk;
            this.startArgs = args;
            this.tutorialState = null;
            Runtime.stopPendingScriptsAsync().done(function () {
                Runtime.theRuntime = _this;
                if (_this.eventQ)
                    _this.eventQ.blockEvents = false;
                _this.resetRunMap();
                _this.killTempState();
                TDev.ProgressOverlay.setMessage("loading...");
                RT.ArtCache.resetProgress();
                _this.initDataAsync().done(function () {
                    try {
                        if (_this.headlessPluginMode) {
                            TDev.ProgressOverlay.setMessage("running...");
                            TDev.ProgressOverlay.unblockKeyboard();
                            TDev.ProgressOverlay.showLog();
                        }
                        else
                            TDev.ProgressOverlay.hide();
                        if (!_this.isStopped())
                            return;
                        _this.host.agreeTermsOfUseAsync().done(function () {
                            try {
                                var entryPt = _this.getActionFrame(mk, args);
                                if (_this.validatorAction) {
                                    var act = _this.current.libs["tutorialLib"][_this.validatorAction];
                                    if (!act) {
                                        TDev.Util.userError(TDev.lf("problem with tutorial: validator function '{0}' not found", _this.validatorAction));
                                    }
                                    var libcall = act(_this.current);
                                    _this.tutorialObject = libcall.libs.topScriptId;
                                    if (/norun/i.test(_this.validatorActionFlags))
                                        entryPt = Runtime.pumpEvents;
                                    entryPt = _this.enter(libcall.invoke(libcall, entryPt, _this.editorObj));
                                }
                                _this.mainLoop(entryPt, "Runtime.run");
                            }
                            catch (e) {
                                _this.handleException(e, _this.current);
                            }
                        });
                    }
                    catch (e) {
                        _this.handleException(e, _this.current);
                    }
                }, function (e) {
                    _this.handleException(e, null);
                });
            });
        };
        Runtime.prototype.resyncData = function () {
            this.datas = {};
        };
        Runtime.prototype.initDataAsync = function () {
            var _this = this;
            this.compiled.startFn(this);
            var loadSession = this.sessions.ensureSessionLoaded().thenalways(function () {
                _this.sessions.yieldSession();
            });
            this.compiled.initGlobals(this.datas, this);
            return TDev.Promise.join([this.compiled.initArtAsync(this.datas), loadSession]);
        };
        Runtime.prototype.addDisposableHandler = function (handler) {
            var binding = new RT.DisposableHandler(handler);
            this.disposables.push(binding);
            return binding;
        };
        Runtime.prototype.killDisposables = function () {
            this.disposables.forEach(function (d) {
                try {
                    d.dispose();
                }
                catch (e) {
                    TDev.Util.reportError('', e, false);
                }
            });
            this.disposables = [];
        };
        Runtime.prototype.killTempState = function () {
            this.renderedComments = "";
            this._libinitDone = false;
            this.sessions.unlink();
            this.compiled.resetData(this.datas);
        };
        Runtime.prototype.resetData = function () {
            if (this.state == 0 /* Stopped */ && this.resumeAllowed) {
                this.resumeAllowed = false;
                this.killTempState();
                this.initPageStack();
                this.host.notifyRunState();
            }
        };
        Runtime.prototype.quietlyHandleError = function (e, s) {
            var _this = this;
            try {
                this.augmentException(e);
            }
            catch (ee) {
            }
            var foundSome = false;
            var isSecondary = !!s;
            if (!s)
                s = e.tdStackFrame;
            for (; s; s = s.previous) {
                if (s.isDetached) {
                    s.asyncTask.setException(e);
                    break;
                }
                if (s.errorHandler)
                    (function () {
                        foundSome = true;
                        var s0 = s;
                        var h = s.errorHandler;
                        s.errorHandler = null;
                        TDev.Util.setTimeout(0, function () {
                            try {
                                var prev = e.tdIsSecondary;
                                e.tdIsSecondary = isSecondary;
                                h(e, s0);
                                e.tdIsSecondary = prev;
                            }
                            catch (exn) {
                                _this.host.exceptionHandler(exn);
                            }
                        });
                    })();
            }
            return foundSome;
        };
        Runtime.prototype.augmentException = function (e) {
            if (typeof e !== "object")
                return;
            var s = this.current;
            if (e.tdStackFrame)
                s = e.tdStackFrame;
            var st = e.stack;
            if (s && st !== undefined && !e.tdStack) {
                e.tdStack = this.getStackTrace(s, true);
                if (!e.tdMeta)
                    e.tdMeta = {};
                if (s)
                    new RT.AppLogger("dummy").setMetaFromContext(e.tdMeta, s);
                var compr = TDev.StackUtil.compress(e.tdStack);
                if (compr) {
                    compr = "StK" + compr;
                    e.tdMeta.compressedStack = compr;
                }
                if (compr) {
                    e.tdMeta.originalStack = st;
                    st = st.replace(/^\s*at a_\S+\$\d[^]*/m, "");
                    st = st.replace(/((compiled|noderuntime).js):\d+:\d+/g, function (t, f) { return f + ":1:1"; });
                    st = st.replace(/^\s*at /m, function (t) { return t + compr + " (td.js:42:42)\n" + t; });
                    try {
                        e.stack = st;
                    }
                    catch (fail) {
                    }
                }
                if (!e.tdMeta.reportId)
                    e.tdMeta.reportId = TDev.Ticker.mkReportId();
            }
        };
        Runtime.prototype.handleException = function (e, s) {
            if (!e.tdStackFrame)
                e.tdStackFrame = s;
            var handled = this.quietlyHandleError(e);
            this.handlingException = true;
            if (!handled) {
                this.compiled.extractAllRunMaps(this);
                this.host.exceptionHandler(e);
            }
            this.stopAsync().done();
        };
        Runtime.prototype.getStackTrace = function (init, strip) {
            if (strip === void 0) { strip = false; }
            var locs = [];
            for (var s = init || this.current; s; s = s.previous) {
                var ns;
                if (strip)
                    ns = {
                        pc: s.pc,
                        prevPC: s.prevPC,
                        name: s.name,
                        d: { libName: (s.d ? s.d.libName : undefined) }
                    };
                else
                    ns = TDev.Util.flatClone(s);
                locs.push(ns);
            }
            locs.forEach(function (l, i) {
                if (l.prevPC && locs[i + 1])
                    locs[i + 1].pc = l.prevPC;
            });
            return locs;
        };
        Runtime.prototype.getRunMap = function () {
            this.runMap.clear();
            if (this.compiled.extractAllRunMaps(this))
                return this.runMap;
            else
                return undefined;
        };
        Runtime.prototype.saveComment = function (cmt) {
            this.renderedComments += cmt;
        };
        Runtime.prototype.wrapFromHandler = function (f) {
            var prevState = this.state;
            var prevCurr = this.current;
            this.current = new StackBottom(this);
            this.setState(1 /* Running */, "runUserAction from handler");
            try {
                f();
                this.setState(prevState, "runUserAction from handler restore");
                this.current = prevCurr;
            }
            catch (e) {
                this.handleException(e, this.current);
            }
        };
        Runtime.prototype.runUserAction = function (f, args) {
            var _this = this;
            args.unshift(function (s) {
                _this.state = 2 /* Paused */;
                return null;
            });
            args.unshift(this.current);
            var fn = this.enter(f.apply(null, args));
            return this.quickLoop(fn);
        };
        Runtime.prototype.runValidUserAction = function (f, args) {
            var r = this.runUserAction(f, args);
            if (r === undefined)
                TDev.Util.userError("user function passed to library returned invalid");
            return r;
        };
        Runtime.prototype.quickLoop = function (fn) {
            if (this.quickLoopDepth > 20) {
                TDev.Util.userError("stack overflow (more than 20 runtime/user code switches)");
            }
            TDev.Util.assert(this.state == 1 /* Running */);
            this.quickLoopDepth++;
            var prevFrom = this.returnedFrom;
            this.returnedFrom = null;
            try {
                while (true) {
                    var newFn = fn(this.current);
                    if (this.state != 1 /* Running */) {
                        if (this.state == 2 /* Paused */) {
                            this.state = 1 /* Running */;
                            break;
                        }
                        if (this.state == 4 /* BreakpointHit */)
                            TDev.Util.userError("breakpoints in library callbacks are not supported");
                        TDev.Util.oops("wrong state in quick Loop " + this.state);
                    }
                    if (!newFn)
                        TDev.Util.oops("no newFn: " + fn);
                    fn = newFn;
                }
            }
            finally {
                this.quickLoopDepth--;
            }
            var res = this.returnedFrom ? this.returnedFrom.result : undefined;
            this.returnedFrom = prevFrom;
            return res;
        };
        Runtime.prototype.mainLoop = function (fn, comment) {
            var _this = this;
            if (!Runtime.continueAfter)
                Runtime.continueAfter = TDev.Util.setTimeout;
            this.handlingException = false;
            if (this.mainLoopRunning) {
                this.setState(1 /* Running */, "resume point override");
                this.resumePointOverride = fn;
                return;
            }
            var prevState = this.state;
            this.setState(1 /* Running */, comment);
            if (prevState == 0 /* Stopped */)
                this.host.notifyRunState();
            if (!this.sessions.readyForExecution()) {
                this.stopAsync().done();
                return;
            }
            var continueLater = false;
            var continueLaterVersion = 0;
            var numCheck = 0;
            this.mainLoopRunning = true;
            try {
                while (true) {
                    var newFn = fn(this.current);
                    if (this.state != 1 /* Running */) {
                        if (this.state == 4 /* BreakpointHit */) {
                            this.debuggerCC = newFn;
                            break;
                        }
                        if (this.state == 0 /* Stopped */) {
                            break;
                        }
                        if (this.debuggerCC) {
                            this.debuggerCC = null;
                            this.host.notifyBreakpointContinue();
                        }
                        if (this.state == 3 /* AtAwait */) {
                            newFn = this.pumpEventsCore();
                            if (!newFn)
                                break;
                            TDev.Util.check(!this.resumePointOverride);
                            this.resumePointOverride = null;
                        }
                        if (this.state != 1 /* Running */) {
                            break;
                        }
                    }
                    if (!newFn)
                        TDev.Util.oops("no newFn: " + fn);
                    if (!!this.resumePointOverride) {
                        fn = this.resumePointOverride;
                        this.resumePointOverride = null;
                    }
                    else {
                        fn = newFn;
                    }
                    if (numCheck++ > 10) {
                        var now = Date.now();
                        if (now - this.lastBreak > (TDev.Browser.isNodeJS ? 1000 : 50)) {
                            continueLater = true;
                            continueLaterVersion = this.versionNumber;
                            break;
                        }
                        numCheck = 0;
                    }
                }
            }
            catch (e) {
                this.handleException(e, this.current);
            }
            this.mainLoopRunning = false;
            if (continueLater && continueLaterVersion == this.versionNumber && this.state != 0 /* Stopped */) {
                this.setState(2 /* Paused */, "continue later");
                var ver = this.versionNumber;
                var curr = this.current;
                Runtime.continueAfter(1, function () {
                    if (ver != _this.versionNumber)
                        return;
                    _this.lastBreak = Date.now();
                    _this.current = curr;
                    _this.mainLoop(fn, "continue later - run");
                });
            }
            TDev.Util.assert(this.state != 1 /* Running */);
        };
        Runtime.prototype.saveDataAsync = function () {
            this.sessions.yieldSession();
            return TDev.Promise.as();
        };
        Runtime.prototype.getRestRequest = function () {
            var frame = this.current;
            while (frame && !frame.serverRequest)
                frame = frame.previous;
            return frame ? frame.serverRequest : undefined;
        };
        Runtime.prototype.getRestArgument = function (name, tp, s) {
            var r = this.getRestRequest().getRestArgument(name, tp, s);
            return r;
        };
        Runtime.prototype.runLibInits = function (ids, cb) {
            var _this = this;
            if (this._libinitDone)
                return;
            var frame = this.current;
            this._libinitDone = true;
            var loop = function (i) {
                if (i >= ids.length)
                    return cb(frame);
                var libcall = _this.compiled.libs[ids[i]]["_libinit"](frame);
                return _this.enter(libcall.invoke(libcall, function () {
                    return loop(i + 1);
                }));
            };
            return loop(0);
        };
        Runtime.shellVersion = 41;
        Runtime.maxBoxLength = 1000;
        Runtime.lockOrientation = function () {
        };
        Runtime.legalNotice = "";
        Runtime.companyCopyright = "Microsoft";
        Runtime.appName = "TouchDevelop";
        Runtime.notificationIcon = "https://www.touchdevelop.com/images/touchdevelop114x114.png";
        Runtime.accelerometerTiltBooster = 1;
        Runtime.inputboxstylemap = { textline: "text", password: "password", number: "number" };
        return Runtime;
    })();
    TDev.Runtime = Runtime;
    var EventHandlerDesc = (function () {
        function EventHandlerDesc(varId, entry) {
            this.varId = varId;
            this.entry = entry;
        }
        return EventHandlerDesc;
    })();
    TDev.EventHandlerDesc = EventHandlerDesc;
    var EventEntry = (function () {
        function EventEntry(binding, args, isLast) {
            this.binding = binding;
            this.args = args;
            this.isLast = isLast;
            this.category = "local";
            this.done = false;
        }
        EventEntry.prototype.isPageEvent = function () {
            return this.binding._event.isPageEvent;
        };
        EventEntry.prototype.dispatch = function (rt, eventsByCategory) {
            if (this.done)
                return null;
            this.done = true;
            var ev = this.binding._event;
            ev.pendinghandlers--;
            this.binding.inQueue = false;
            var f = this.binding._handler;
            if (!f)
                return null;
            if (f instanceof RT.PseudoAction) {
                f.run(rt, this.args);
                return null;
            }
            var res = rt.getEventFrame(f, this.args, ev.isBlocking);
            if (rt.current) {
                rt.current.currentHandler = this.binding;
                if (ev.finalCallback) {
                    var cb = ev.finalCallback;
                    ev.finalCallback = null;
                    rt.current.returnAddr = function (s) {
                        cb(s);
                        return Runtime.pumpEvents(s);
                    };
                }
                if (ev.errorHandler) {
                    rt.current.errorHandler = ev.errorHandler;
                }
            }
            return res;
        };
        EventEntry.prototype.clear = function () {
            var ev = this.binding._event;
            ev.pendinghandlers = 0;
        };
        EventEntry.prototype.isPause = function () {
            return false;
        };
        EventEntry.prototype.isGameLoop = function () {
            return false;
        };
        return EventEntry;
    })();
    TDev.EventEntry = EventEntry;
    var GlobalEventEntry = (function () {
        function GlobalEventEntry(category, varValue, args, idx) {
            if (idx === void 0) { idx = 0; }
            this.category = category;
            this.varValue = varValue;
            this.args = args;
            this.idx = idx;
            TDev.Util.assert(category != "local");
        }
        GlobalEventEntry.prototype.isPageEvent = function () {
            return false;
        };
        GlobalEventEntry.prototype.dispatch = function (rt, eventsByCategory) {
            if (this.evts === undefined)
                this.evts = eventsByCategory[this.category];
            if (this.evts === undefined)
                return null;
            while (this.idx < this.evts.length) {
                var handler = this.evts[this.idx++];
                var match = this.handlerMatch(handler, rt);
                if (match.matches) {
                    rt.setNextEvent(this.category, handler.varId);
                    return rt.getEventFrame(handler.entry, match.args);
                }
            }
            return null;
        };
        GlobalEventEntry.prototype.handlerMatch = function (desc, rt) {
            if (desc.varId == null)
                return { matches: true, args: this.args };
            if (this.category.search(/ in /) >= 0) {
                var set = rt.datas["this"][desc.varId];
                if (!!set) {
                    var idx = set.index_of_obj(this.varValue);
                    if (idx >= 0) {
                        return { matches: true, args: [this.varValue, idx].concat(this.args) };
                    }
                }
            }
            else {
                if (rt.datas["this"][desc.varId] === this.varValue) {
                    return { matches: true, args: this.args };
                }
            }
            return { matches: false, args: [] };
        };
        GlobalEventEntry.prototype.isGameLoop = function () {
            return this.category == "gameloop" && !this.evts;
        };
        GlobalEventEntry.prototype.isPause = function () {
            return this.category == "pause" && !this.evts;
        };
        GlobalEventEntry.prototype.clear = function () {
        };
        return GlobalEventEntry;
    })();
    TDev.GlobalEventEntry = GlobalEventEntry;
    var BoardEventEntry = (function () {
        function BoardEventEntry(categories, valueStack, args, matchAll) {
            this.categories = categories;
            this.valueStack = valueStack;
            this.args = args;
            this.matchAll = matchAll;
            this.category = "board";
        }
        BoardEventEntry.prototype.dispatch = function (rt, eventsByCategory) {
            if (this.categoryHandlers === undefined)
                this.categoryHandlers = this.categories.map(function (c) { return eventsByCategory[c]; });
            var valueIndex = 0;
            while (!this.matchedHandlers && valueIndex < this.valueStack.length) {
                var value = this.valueStack[valueIndex++];
                var categoryIndex = 0;
                while (categoryIndex < this.categories.length) {
                    var category = this.categories[categoryIndex];
                    var handlers = this.categoryHandlers[categoryIndex++];
                    if (!handlers) {
                        continue;
                    }
                    var handlerIndex = 0;
                    while (handlerIndex < handlers.length) {
                        var handler = handlers[handlerIndex++];
                        var match = this.handlerMatch(handler, category, value, rt);
                        if (match.matches) {
                            if (!this.matchedHandlers) {
                                this.matchedHandlers = [];
                            }
                            this.matchedHandlers.push({ category: category, varid: handler.varId, handler: handler.entry, args: match.args });
                        }
                    }
                }
                if (!this.matchAll && !!this.matchedHandlers) {
                    break;
                }
            }
            if (!!this.matchedHandlers && this.matchedHandlers.length > 0) {
                var matchedHandler = this.matchedHandlers.shift();
                rt.setNextEvent(matchedHandler.category, matchedHandler.varid);
                return rt.getEventFrame(matchedHandler.handler, matchedHandler.args);
            }
            return null;
        };
        BoardEventEntry.prototype.handlerMatch = function (desc, category, varValue, rt) {
            if (category.search(/ sprite in /) >= 0) {
                var set = rt.datas["this"][desc.varId];
                if (!!set) {
                    var idx = set.index_of_obj(varValue);
                    if (idx >= 0) {
                        return { matches: true, args: [varValue, idx].concat(this.args) };
                    }
                }
            }
            if (category.search(/touch over /) >= 0) {
                var set = rt.datas["this"][desc.varId];
                if (!!set) {
                    var idx = set.index_of_obj(varValue);
                    if (idx >= 0) {
                        return { matches: true, args: [varValue, idx].concat(this.args) };
                    }
                }
            }
            else if (category.search(/ sprite:/) >= 0) {
                if (rt.datas["this"][desc.varId] == varValue) {
                    return { matches: true, args: [varValue].concat(this.args) };
                }
            }
            else {
                if (rt.datas["this"][desc.varId] === varValue) {
                    return { matches: true, args: this.args };
                }
            }
            return { matches: false, args: [] };
        };
        BoardEventEntry.prototype.isGameLoop = function () {
            return false;
        };
        BoardEventEntry.prototype.isPause = function () {
            return false;
        };
        BoardEventEntry.prototype.isPageEvent = function () {
            return false;
        };
        BoardEventEntry.prototype.clear = function () {
        };
        return BoardEventEntry;
    })();
    TDev.BoardEventEntry = BoardEventEntry;
    var EventQueue = (function () {
        function EventQueue(rt) {
            this.rt = rt;
            this.queue = [];
            this.needPageRefresh = false;
            this.needYield = false;
            this.needCloudstateRefresh = false;
            this.eventsByCategory = null;
            this.hasGameLoop = false;
            this.needsGameLoopTimer = false;
            this.blockEvents = false;
            this.eps = 0;
            this.minimumEps = 0;
            this.maximumEps = 0;
            this.averageEps = 0;
            this.epsHistory = [];
            this.profiling = false;
            this.numPageEvents = 0;
            this.pageIsTimeDependent = false;
            this.refreshtimerpending = false;
        }
        EventQueue.prototype.add = function (category, varValue, args, ignore) {
            if (ignore === void 0) { ignore = true; }
            if (this.blockEvents)
                return;
            TDev.Util.assert(!(varValue instanceof RT.Event_));
            if (this.eventsByCategory[category] !== undefined) {
                var ev = new GlobalEventEntry(category, varValue, args);
                this.queue.push(ev);
                this.rt.queueRestart();
            }
        };
        EventQueue.prototype.addLocalEvent = function (ev, args, ignore, skipIfInQueue, filter) {
            if (ignore === void 0) { ignore = true; }
            if (skipIfInQueue === void 0) { skipIfInQueue = false; }
            if (filter === void 0) { filter = undefined; }
            if (!this.blockEvents && ev.handlers) {
                var anyPushed = false;
                for (var i = 0; i < ev.handlers.length; ++i) {
                    var binding = ev.handlers[i];
                    if (filter && !filter(binding))
                        continue;
                    if (!(skipIfInQueue && binding.inQueue)) {
                        var ee = new EventEntry(binding, args, i == ev.handlers.length - 1);
                        if (ee.isPageEvent())
                            this.numPageEvents++;
                        ev.pendinghandlers++;
                        binding.inQueue = true;
                        this.queue.push(ee);
                        anyPushed = true;
                    }
                }
                if (anyPushed)
                    this.rt.queueRestart();
            }
            ev.runAwaiters(args);
        };
        EventQueue.prototype.addBoardEvent = function (categories, valueStack, args, ignore, matchAll) {
            if (ignore === void 0) { ignore = true; }
            if (matchAll === void 0) { matchAll = false; }
            if (this.blockEvents)
                return;
            this.queue.push(new BoardEventEntry(categories, valueStack, args, matchAll));
            this.rt.queueRestart();
        };
        EventQueue.prototype.clear = function () {
            this.queue.forEach(function (e) { return e.clear(); });
            this.queue = [];
        };
        EventQueue.prototype.clearPause = function () {
            this.queue = this.queue.filter(function (q) { return !q.isPause(); });
        };
        EventQueue.prototype.calculateEpsInfo = function () {
            if (this.epsHistory.length > 2) {
                var myEpsHistory = this.epsHistory.slice(1);
                myEpsHistory.pop();
                var minimum = Number.MAX_VALUE;
                var maximum = 0;
                var cumulative = 0;
                for (var i = 0; i < myEpsHistory.length; ++i) {
                    if (myEpsHistory[i] > maximum)
                        maximum = myEpsHistory[i];
                    if (myEpsHistory[i] < minimum)
                        minimum = myEpsHistory[i];
                    cumulative += myEpsHistory[i];
                }
                if (TDev.dbg) {
                    TDev.Util.log("Gameloop Events per Second statistics: minimum " + minimum + ", maximum " + maximum + ", average " + (cumulative / myEpsHistory.length).toFixed(2) + ". Ran for " + myEpsHistory.length + "s.");
                }
                this.minimumEps = minimum;
                this.maximumEps = maximum;
                this.averageEps = cumulative / myEpsHistory.length;
                this.epsHistory = [];
            }
        };
        EventQueue.prototype.setupGameLoopTimer = function () {
            var _this = this;
            var stopLogEPS = false;
            var logEPS = function () {
                var eps = _this.eps;
                _this.eps = 0;
                if (!stopLogEPS)
                    TDev.Util.setTimeout(1000, logEPS);
                if (eps > 0)
                    _this.epsHistory.push(eps);
            };
            var gameLoop = function () {
                if (_this.rt.isStopped()) {
                    _this.needsGameLoopTimer = true;
                    stopLogEPS = true;
                    return;
                }
                var hasIt = false;
                for (var i = 0; i < _this.queue.length; ++i)
                    if (_this.queue[i].isGameLoop()) {
                        hasIt = true;
                        break;
                    }
                if (!hasIt)
                    _this.add("gameloop", null, []);
                TDev.Util.setTimeout(20, gameLoop);
            };
            this.needsGameLoopTimer = false;
            gameLoop();
            if (this.profiling)
                logEPS();
        };
        EventQueue.prototype.queuePageUpdate = function () {
            this.needPageRefresh = true;
            this.rt.queueRestart();
        };
        EventQueue.prototype.viewIsCurrent = function () {
            return !this.needPageRefresh;
        };
        EventQueue.prototype.registerTimeDependency = function () {
            this.pageIsTimeDependent = true;
        };
        EventQueue.prototype.finishPageUpdate = function () {
            var _this = this;
            this.needPageRefresh = false;
            if (this.pageIsTimeDependent) {
                this.pageIsTimeDependent = false;
                if (!this.refreshtimerpending) {
                    this.refreshtimerpending = true;
                    TDev.Util.setTimeout(100, function () {
                        if (_this.refreshtimerpending) {
                            _this.refreshtimerpending = false;
                            _this.queuePageUpdate();
                        }
                    });
                }
            }
            else
                this.refreshtimerpending = false;
        };
        EventQueue.prototype.queueYield = function () {
            this.needYield = true;
            this.rt.queueRestart();
        };
        EventQueue.prototype.finishYield = function (changes, fireevent) {
            this.needYield = false;
            if (changes) {
                if (fireevent)
                    this.add("cloud data updated", null, []);
                this.queuePageUpdate();
            }
        };
        EventQueue.prototype.maybeRunPageRefresh = function () {
            var _this = this;
            if (this.rt.isHeadless())
                return null;
            if (!this.needPageRefresh && !this.needYield)
                return null;
            if (this.numPageEvents > 0)
                return null;
            var p = this.rt.getCurrentPage();
            if (p.isAuto() && !p.crashed) {
                return function () {
                    var page = _this.rt.getCurrentPage();
                    return _this.rt.getEventFrame(function (p, b) { return page.getFrame(p, b); }, []);
                };
            }
            else {
                this.needPageRefresh = false;
                this.needYield = false;
                return null;
            }
        };
        EventQueue.prototype.process = function () {
            if (this.needsGameLoopTimer)
                this.setupGameLoopTimer();
            while (this.queue.length > 0) {
                var e = this.queue[0];
                if (this.profiling && this.hasGameLoop && e.isGameLoop()) {
                    ++this.eps;
                }
                var fn = e.dispatch(this.rt, this.eventsByCategory);
                if (fn != null)
                    return fn;
                this.queue.shift();
                if (e.isPageEvent())
                    this.numPageEvents--;
                TDev.Util.assert(this.numPageEvents >= 0);
            }
            return null;
        };
        EventQueue.init = function (rt) {
            var s = rt.compiled;
            var q = new EventQueue(rt);
            rt.eventQ = q;
            if (!s.eventsByCategory || !s.eventsByCategory["local"]) {
                s.registerEventHandler("local", null, null);
            }
            q.hasGameLoop = (s.eventsByCategory && s.eventsByCategory["gameloop"] !== undefined);
            q.eps = 0;
            q.needsGameLoopTimer = q.hasGameLoop;
            q.eventsByCategory = s.eventsByCategory;
        };
        return EventQueue;
    })();
    TDev.EventQueue = EventQueue;
    var BreakpointCollection = (function () {
        function BreakpointCollection(cs) {
            this.cs = cs;
        }
        BreakpointCollection.prototype.init = function (bps) {
            var _this = this;
            bps.forEach(function (k, v) { return _this.cs.breakpointBindings[k].setter(true); });
        };
        BreakpointCollection.prototype.set = function (bp, val) {
            this.cs.breakpointBindings[bp].setter(val);
        };
        BreakpointCollection.prototype.get = function (bp) {
            return this.cs.breakpointBindings[bp].getter();
        };
        return BreakpointCollection;
    })();
    TDev.BreakpointCollection = BreakpointCollection;
    var CompilerOptStatistics = (function () {
        function CompilerOptStatistics(inlinedFunctions, inlinedCalls, eliminatedOks, termsReused, constantsPropagated, reachingDefsTime, inlineAnalysisTime, dominatorsTime, usedAnalysisTime, availableExpressionsTime, constantPropagationTime, compileTime, numActions, numStatements) {
            if (inlinedFunctions === void 0) { inlinedFunctions = 0; }
            if (inlinedCalls === void 0) { inlinedCalls = 0; }
            if (eliminatedOks === void 0) { eliminatedOks = 0; }
            if (termsReused === void 0) { termsReused = 0; }
            if (constantsPropagated === void 0) { constantsPropagated = 0; }
            if (reachingDefsTime === void 0) { reachingDefsTime = 0; }
            if (inlineAnalysisTime === void 0) { inlineAnalysisTime = 0; }
            if (dominatorsTime === void 0) { dominatorsTime = 0; }
            if (usedAnalysisTime === void 0) { usedAnalysisTime = 0; }
            if (availableExpressionsTime === void 0) { availableExpressionsTime = 0; }
            if (constantPropagationTime === void 0) { constantPropagationTime = 0; }
            if (compileTime === void 0) { compileTime = 0; }
            if (numActions === void 0) { numActions = 0; }
            if (numStatements === void 0) { numStatements = 0; }
            this.inlinedFunctions = inlinedFunctions;
            this.inlinedCalls = inlinedCalls;
            this.eliminatedOks = eliminatedOks;
            this.termsReused = termsReused;
            this.constantsPropagated = constantsPropagated;
            this.reachingDefsTime = reachingDefsTime;
            this.inlineAnalysisTime = inlineAnalysisTime;
            this.dominatorsTime = dominatorsTime;
            this.usedAnalysisTime = usedAnalysisTime;
            this.availableExpressionsTime = availableExpressionsTime;
            this.constantPropagationTime = constantPropagationTime;
            this.compileTime = compileTime;
            this.numActions = numActions;
            this.numStatements = numStatements;
        }
        return CompilerOptStatistics;
    })();
    TDev.CompilerOptStatistics = CompilerOptStatistics;
    var CompiledScript = (function () {
        function CompiledScript() {
            this.steps = [];
            this.actionsByName = {};
            this.actionsByStableName = {};
            this.pagesByName = {};
            this.eventsByCategory = null;
            this.reflectionInfo = {};
            this.artInitializers = [];
            this.artPromises = [];
            this.missingApis = [];
            this.globals = [];
            this.packageResources = [];
            this.imports = {
                npmModules: {},
                cordovaPlugins: {},
                pipPackages: {}
            };
            this.scriptTitle = "";
            this.scriptColor = "";
            this.showAd = false;
            this.startFn = function (rt) {
            };
            this.stopFn = function (rt) {
            };
            this.setupRestRoutes = function (rt) {
            };
            this.extractRunMap = undefined;
            this._resetGlobals = function (dt) {
            };
            this._initGlobals = function (dt, rt) {
            };
            this._initGlobals2 = function (dt) {
            };
            this._importJson = function (dt, ctx, json) {
            };
            this._exportJson = function (dt, ctx) {
            };
            this._getProfilingResults = function () { return null; };
            this._showCoverage = false;
            this.breakpointBindings = {};
            this.initBreakpoints = null;
            this.localNamesBindings = {};
            this.optStatistics = new CompilerOptStatistics();
            this.libScripts = { "this": this };
            this.breakpoints = new BreakpointCollection(this);
        }
        CompiledScript.prototype.forEachLib = function (f) {
            var _this = this;
            Object.keys(this.libScripts).forEach(function (k) {
                f(_this.libScripts[k]);
            });
        };
        CompiledScript.prototype.extractAllRunMaps = function (rt) {
            var _this = this;
            var defined = true;
            Object.keys(this.libScripts).forEach(function (k) {
                var extractRunMap = _this.libScripts[k].extractRunMap;
                if (extractRunMap)
                    extractRunMap(rt);
                else
                    defined = false;
            });
            return defined;
        };
        CompiledScript.prototype.registerAction = function (name, stName, entry, isAsync) {
            this.actionsByName[name] = entry;
            this.actionsByStableName[stName] = entry;
            if (isAsync && !this.eventsByCategory)
                this.registerEventHandler("async", null, null);
        };
        CompiledScript.prototype.initPages = function () {
            var _this = this;
            var hasPages = Object.keys(this.libScripts).some(function (k) { return Object.keys(_this.libScripts[k].pagesByName).length > 0; });
            if (!hasPages)
                return;
            this.registerEventHandler("page", null, function (prev, ret, libName, pageName) {
                var args = [];
                for (var _i = 4; _i < arguments.length; _i++) {
                    args[_i - 4] = arguments[_i];
                }
                var p = prev.rt.pushPage(true);
                p.libName = libName;
                p.pageName = pageName;
                p.drawArgs = args;
                return p.getFrame(prev, ret);
            });
        };
        CompiledScript.prototype.getCompiledCode = function () {
            return null;
        };
        CompiledScript.prototype.initFromPrecompiled = function (script) {
            var _this = this;
            if (script === void 0) { script = null; }
            if (!script)
                script = TDev.precompiledScript;
            Object.keys(script).forEach(function (name) {
                if (name == "this")
                    return;
                var f = script[name];
                var cs = _this;
                if (typeof f == "string") {
                    cs = _this.libScripts[f];
                }
                else {
                    cs = new CompiledScript();
                    f(cs);
                }
                _this.registerLibRef(name, cs);
            });
            script["this"](this);
        };
        CompiledScript.prototype.registerPage = function (name, stName, entry) {
            this.actionsByName[name] = entry;
            this.actionsByStableName[stName] = entry;
            this.pagesByName[name] = entry;
        };
        CompiledScript.prototype.registerLambda = function (name, stName, entry) {
            this.actionsByName[name] = entry;
            this.actionsByStableName[stName] = entry;
        };
        CompiledScript.prototype.forEachData = function (datas, f) {
            var _this = this;
            var res = [];
            Object.keys(this.libScripts).forEach(function (lr) {
                if (!datas[lr])
                    datas[lr] = {};
                datas[lr]["libName"] = lr;
                res.push(f(datas[lr], _this.libScripts[lr], lr));
            });
            return res;
        };
        CompiledScript.prototype.resetData = function (datas) {
            this.forEachData(datas, function (d, cs) {
                cs._resetGlobals(d);
            });
        };
        CompiledScript.prototype.initGlobals = function (datas, rt) {
            this.forEachData(datas, function (d, cs) {
                cs._initGlobals(d, rt);
                cs._initGlobals2(d);
            });
        };
        CompiledScript.prototype.registerArtResource = function (clsName, id, url) {
            var _this = this;
            this.artInitializers.push(function (data) {
                if (!!data[id])
                    return;
                var f = TDev.RT[clsName].fromArtUrl;
                if (!!f)
                    _this.artPromises.push(f(url).then(function (v) {
                        if (v === undefined) {
                            switch (clsName) {
                                case "Picture":
                                    v = TDev.RT.Picture.fromArtUrl("data:image/jpeg;base64," + "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")._value;
                                    break;
                                case "Sound":
                                    var missingUrl = TDev.Cloud.artUrl('pxiraczt');
                                    if (!TDev.Browser.audioWav)
                                        missingUrl = TDev.HTML.patchWavToMp4Url(missingUrl);
                                    v = TDev.RT.Sound.mk(missingUrl);
                                    break;
                                default:
                                    break;
                            }
                        }
                        data[id] = v;
                    }));
            });
        };
        CompiledScript.prototype.registerGlobal = function (id) {
            this.globals.push(id);
        };
        CompiledScript.prototype.initArtAsync = function (datas) {
            return TDev.Promise.join(this.forEachData(datas, function (d, cs) { return cs.initArtCoreAsync(d); }));
        };
        CompiledScript.prototype.initArtCoreAsync = function (data) {
            this.artPromises = [];
            this.artInitializers.forEach(function (f) {
                f(data);
            });
            return TDev.Promise.join(this.artPromises);
        };
        CompiledScript.prototype.registerEventHandler = function (category, varId, entry) {
            if (this.eventsByCategory == null)
                this.eventsByCategory = {};
            var curr = this.eventsByCategory[category];
            if (curr === undefined) {
                curr = [];
                this.eventsByCategory[category] = curr;
            }
            curr.push(new EventHandlerDesc(varId, entry));
            if (!this.eventsByCategory["pause"])
                this.registerEventHandler("pause", null, function (prev, ret) {
                    var frame = {};
                    frame.previous = prev;
                    frame.rt = prev.rt;
                    frame.returnAddr = ret;
                    frame.entryAddr = function (s) {
                        s.rt.stopAsync(true).done();
                        return null;
                    };
                    return frame;
                });
            if (!this.eventsByCategory["async"])
                this.registerEventHandler("async", null, null);
        };
        CompiledScript.prototype.registerStep = function (step, name) {
            step.idx = this.steps.length;
            step.theName = name;
            this.steps.push(step);
        };
        CompiledScript.prototype.registerLibRef = function (libRefName, cs) {
            if (this.libScripts.hasOwnProperty(libRefName))
                TDev.Util.oops("redefinition of libref " + libRefName);
            this.libScripts[libRefName] = cs;
        };
        CompiledScript.prototype.mkLambdaProxy = function (libs, libRefName) {
            return function (s) { return new LibProxy(libs, s, libRefName, "inline function", null); };
        };
        CompiledScript.prototype.mkLibProxyFactory = function (libs, libRefName, actionName) {
            var f = this.libScripts[libRefName].actionsByName[actionName];
            TDev.Util.assert(f);
            return function (s) { return new LibProxy(libs, s, libRefName, actionName, f); };
        };
        CompiledScript.prototype.lookupLibPage = function (libRefName, actionName) {
            var _this = this;
            var f = this.libScripts[libRefName].actionsByName[actionName];
            TDev.Util.assert(f);
            return function (s) { return new LibProxy(_this.libBindings[libRefName], s, libRefName, actionName, f); };
        };
        CompiledScript.prototype.lookupAction = function (libName, actName) {
            return this.libScripts[libName].actionsByStableName[actName];
        };
        CompiledScript.prototype.init = function (code, missingApis, packageResources, safe) {
            this.code = code;
            this.missingApis.pushRange(missingApis);
            this.packageResources.pushRange(packageResources);
            if (safe) {
                var f = eval(code);
                f(this);
            }
        };
        CompiledScript.prototype.reinit = function (code) {
            this.additionalCode = code;
            var f = eval(code);
            f(this);
        };
        CompiledScript.additionalScriptStateFields = ["leaderboard_score", "source_access"];
        return CompiledScript;
    })();
    TDev.CompiledScript = CompiledScript;
    var RT;
    (function (RT) {
        function unwrapJson(o) {
            return o ? o.value() : undefined;
        }
        RT.unwrapJson = unwrapJson;
        function wrapJson(o) {
            return RT.JsonObject.wrap(o);
        }
        RT.wrapJson = wrapJson;
        function queueAction(s, a, args, whenDone, errorHandler) {
            if (whenDone === void 0) { whenDone = null; }
            if (errorHandler === void 0) { errorHandler = null; }
            if (a) {
                var ev = new RT.Event_();
                ev.isBlocking = false;
                ev.finalCallback = whenDone;
                ev.errorHandler = errorHandler;
                ev.addHandler(a);
                s.rt.queueLocalEvent(ev, args);
            }
        }
        RT.queueAction = queueAction;
        function protect(s, f) {
            return s.rt.wrap(s, f);
        }
        RT.protect = protect;
        function userError(msg) {
            TDev.Util.userError(msg);
        }
        RT.userError = userError;
        function logError(err, meta) {
            if (err)
                RT.App.logException(err, meta);
        }
        RT.logError = logError;
        function checkAndLog(err, meta) {
            if (!err)
                return true;
            logError(err, meta);
            return false;
        }
        RT.checkAndLog = checkAndLog;
        function checkAndThrow(e) {
            if (!e)
                return;
            TDev.Util.userError(e + "");
        }
        RT.checkAndThrow = checkAndThrow;
        function checkAndResume(s) {
            return protect(s, function (err) {
                checkAndThrow(err);
                s.localResume();
            });
        }
        RT.checkAndResume = checkAndResume;
        function warn(msg, s) {
            var ed = s.rt.editorObj;
            if (ed)
                ed.annotate_caller("warning", msg, s);
        }
        RT.warn = warn;
    })(RT = TDev.RT || (TDev.RT = {}));
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var Revisions;
    (function (Revisions) {
        function revisionservice_http() {
            return revision_service_url;
        }
        Revisions.revisionservice_http = revisionservice_http;
        var revision_service_url = "https://storage.touchdevelop.com/sessions";
        function parseUrlParameters(url) {
            if (/altrevserv3/.test(url))
                revision_service_url = "http://localhost:843/sessions3";
            else if (/altrevserv2/.test(url))
                revision_service_url = "http://localhost:843/sessions2";
            else if (/altrevserv1/.test(url))
                revision_service_url = "http://localhost:843/sessions1";
            else if (/altrevserv/.test(url))
                revision_service_url = "http://localhost:843/sessions";
            else if (/simrevserv1/.test(url))
                revision_service_url = "http://127.0.0.1:82/sessions1";
            else if (/simrevserv/.test(url))
                revision_service_url = "http://127.0.0.1:82/sessions";
            else if (/revserv=/.test(url)) {
                var myRe = new RegExp("revserv=([^?&#]+)", "i");
                var myArray = myRe.exec(url);
                revision_service_url = "https://" + myArray[1] + "/sessions";
            }
        }
        Revisions.parseUrlParameters = parseUrlParameters;
        function localsessionid(scriptguid) {
            return "L" + scriptguid;
        }
        Revisions.localsessionid = localsessionid;
        function nodesessionid(guid) {
            return "userid" + "0pn" + letterify(guid);
        }
        Revisions.nodesessionid = nodesessionid;
        function justmesessionid(userid, guid) {
            return userid + "0pr" + letterify(guid);
        }
        Revisions.justmesessionid = justmesessionid;
        function everyonesessionid(author, scriptname) {
            return author + "0pu" + scripthash(author, scriptname);
        }
        Revisions.everyonesessionid = everyonesessionid;
        function make_astsessionid(userid) {
            return userid + "0pa" + letterify(TDev.Util.guidGen());
        }
        Revisions.make_astsessionid = make_astsessionid;
        function scripthash(author, title) {
            return letterify(author + title);
        }
        Revisions.scripthash = scripthash;
        function publicpermission(script) {
            return "users:*=W" + (script ? " scripts:" + (script) : "");
        }
        Revisions.publicpermission = publicpermission;
        function broadcastpermission(script) {
            return "users:*=R" + (script ? " scripts:" + (script) : "");
        }
        Revisions.broadcastpermission = broadcastpermission;
        function privatepermission(script) {
            return "users:" + (script ? " scripts:" + (script) : "");
        }
        Revisions.privatepermission = privatepermission;
        function letterify(s) {
            var n = Math.floor(Math.abs(TDev.Util.getStableHashCode(s)));
            var c = "";
            while (n > 0) {
                var d = n % 26;
                n = Math.floor(n / 26);
                c = c + String.fromCharCode(97 + d);
            }
            return c;
        }
        Revisions.letterify = letterify;
        function getRevisionServiceTokenAsync(forcefreshtoken) {
            if (forcefreshtoken === void 0) { forcefreshtoken = false; }
            var token = getRevisionServiceToken(forcefreshtoken);
            if (token)
                return TDev.Promise.wrap(token);
            else
                return refreshRevisionServiceTokenAsync();
        }
        Revisions.getRevisionServiceTokenAsync = getRevisionServiceTokenAsync;
        function getRevisionServiceToken(forcefreshtoken) {
            if (forcefreshtoken === void 0) { forcefreshtoken = false; }
            var expires = parseInt(window.localStorage["rs_token_expires"] || "0");
            if (forcefreshtoken || expires > 0 && Date.now() + 600 > expires) {
                setRevisionServiceToken(undefined);
                return undefined;
            }
            return window.localStorage["rs_access_token"];
        }
        function setRevisionServiceToken(token, expires_in) {
            if (expires_in === void 0) { expires_in = 0; }
            if (!token) {
                TDev.Util.log('revision service access token expired');
                window.localStorage.removeItem("rs_access_token");
                window.localStorage.removeItem("rs_token_expires");
            }
            else {
                TDev.Util.log('received revision service token (expires in ' + (expires_in * 1000).toString() + 'ms)');
                window.localStorage["rs_access_token"] = token;
                if (expires_in > 0)
                    window.localStorage["rs_token_expires"] = Date.now() + expires_in * 1000;
                else
                    window.localStorage.removeItem("rs_token_expires");
            }
        }
        function refreshRevisionServiceTokenAsync() {
            if (TDev.Cloud.isOffline())
                return TDev.Promise.wrapError(TDev.lf("cloud is offline"));
            return TDev.Cloud.authenticateAsync(TDev.lf("cloud data")).then(function (authenticated) {
                if (authenticated) {
                    var userid = TDev.Cloud.getUserId();
                    TDev.Util.log('asking TD server for revision service access token');
                    return TDev.Cloud.postPrivateApiAsync("me/storage/access_token", {}).then(function (json) {
                        var token = json["access_token"];
                        var expires_in = json["expires_in"];
                        setRevisionServiceToken(token, expires_in);
                        return token;
                    }, function (error) {
                        TDev.Util.log('could not get revision service token, web request failed');
                        return TDev.Promise.wrapError("Failed to receive revision service token");
                    });
                }
                else {
                    TDev.Util.log('could not get revision service token, user not signed in');
                    return TDev.Promise.wrapError("User not signed in");
                }
            });
        }
        function getServerInfoAsync(id) {
            return Revisions.getRevisionServiceTokenAsync().then(function (token) {
                if (TDev.Cloud.isOffline())
                    return TDev.Promise.wrapError("Cloud is offline");
                var url = Revisions.revisionservice_http() + "/" + id + "/info?user=" + TDev.Cloud.getUserId() + "&access_token=" + encodeURIComponent(token);
                return TDev.Util.httpRequestAsync(url, "GET", undefined).then(function (response) { return TDev.RT.JsonObject.mk(response, TDev.RT.Time.log); }, function (error) { return undefined; });
            }, function (error) { return undefined; });
        }
        Revisions.getServerInfoAsync = getServerInfoAsync;
        function queryMySessionsOnRevisionServerAsync(rt, filter_based_on_current_script) {
            if (filter_based_on_current_script === void 0) { filter_based_on_current_script = false; }
            var userid = TDev.Cloud.getUserId();
            return getRevisionServiceTokenAsync().then(function (token) {
                if (TDev.Cloud.isOffline())
                    return TDev.Promise.wrapError("Cloud is offline");
                var url = revisionservice_http() + "?user=" + userid + "&access_token=" + encodeURIComponent(token);
                if (filter_based_on_current_script) {
                    url = url + "&guidhash=" + encodeURIComponent(letterify(rt.sessions.getScriptGuid())) + "&scripthash=" + encodeURIComponent(scripthash(rt.sessions.getScriptAuthor(), rt.sessions.getScriptName()));
                }
                return TDev.Util.httpRequestAsync(url, "GET", undefined).then(function (s) {
                    var json = JSON.parse(s);
                    var sessions = new Array();
                    for (var f in json)
                        if (json.hasOwnProperty(f)) {
                            var cs = new TDev.RT.CloudSession();
                            cs._id = f;
                            if (!cs.validate())
                                continue;
                            cs.serverinfo = json[f];
                            cs._title = cs.serverinfo.title;
                            cs._permissions = "";
                            sessions.push(cs);
                        }
                    return sessions;
                });
            });
        }
        Revisions.queryMySessionsOnRevisionServerAsync = queryMySessionsOnRevisionServerAsync;
        function queryCachedSessionsAsync(filter_based_on_current_script, rt) {
            var sessions = [];
            var confirmedsessions = [];
            return TDev.Storage.getTableAsync("Sessions").then(function (table) {
                return table.getValueAsync("%").then(function (val) {
                    var sessionlist = (val || "").split(" ");
                    sessionlist.forEach(function (id) {
                        var cs = new TDev.RT.CloudSession();
                        cs._id = id;
                        if (cs.validate()) {
                            if (filter_based_on_current_script) {
                                var privatehash = letterify(rt.sessions.getScriptGuid());
                                var scripthash = Revisions.scripthash(rt.sessions.getScriptAuthor(), rt.sessions.getScriptName());
                                if (cs.tag === "pr" && cs.guidhash != privatehash)
                                    return;
                                if (cs.tag === "pu" && cs.guidhash != scripthash)
                                    return;
                                if (cs.tag === "pn")
                                    return;
                                if (cs.tag[0] === "c" && cs.guidhash[0] === "s" && cs.guidhash.lastIndexOf(scripthash, 1) !== 1)
                                    return;
                            }
                            sessions.push(cs);
                        }
                    });
                    var keys = sessions.map(function (s, idx, arr) { return s._id + "/S"; });
                    return table.getItemsAsync(keys).then(function (results) {
                        for (var i = 0; i < sessions.length; i++) {
                            var cs = sessions[i];
                            var val = results[keys[i]];
                            if (val) {
                                var json = JSON.parse(val);
                                TDev.Util.assert(cs._id === json.servername);
                                TDev.Util.assert(cs._id === json.localname);
                                cs.localname = cs._id;
                                cs._title = json.description;
                                cs._permissions = json.permissions;
                                cs.membernumber = json.membernumber;
                                cs.enable_sync = json.enable_sync;
                                confirmedsessions.push(cs);
                            }
                            else {
                            }
                        }
                        return confirmedsessions;
                    });
                });
            });
        }
        Revisions.queryCachedSessionsAsync = queryCachedSessionsAsync;
        function deleteSessionAsync(desc, rt) {
            var tasks = [];
            tasks.push(Slot.deleteSessionFileAsync(rt.sessions, desc));
            if (!desc.nodeserver && desc.servername) {
                var pos = desc.servername.indexOf("0");
                if (pos > 3 && pos < desc.servername.length - 4 && desc.servername.substr(0, pos) == TDev.Cloud.getUserId()) {
                    tasks.push(Slot.queueSessionWork(desc.localname, "deleting session on server", function () { return getRevisionServiceTokenAsync().then(function (token) {
                        if (TDev.Cloud.isOffline())
                            return TDev.Promise.wrapError("Cloud is offline");
                        var url = revisionservice_http() + "/" + desc.servername + "?user=" + TDev.Cloud.getUserId() + "&access_token=" + encodeURIComponent(token);
                        var deleteonserver = TDev.Util.httpRequestAsync(url, "DELETE", undefined);
                        return deleteonserver;
                    }); }));
                }
            }
            return TDev.Promise.join(tasks);
        }
        Revisions.deleteSessionAsync = deleteSessionAsync;
        var Slot = (function () {
            function Slot(context, getCurrent, setCurrent) {
                this.context = context;
                this.getCurrent = getCurrent;
                this.setCurrent = setCurrent;
            }
            Slot.prototype.connect = function (desc, loadonly) {
                var _this = this;
                if (loadonly === void 0) { loadonly = false; }
                var cs = this.getCurrent();
                if (cs) {
                    if (cs.servername === desc.servername && cs.localname === desc.localname && (cs.user === desc.user || cs.user === "")) {
                        if (cs.script !== desc.script || cs.readonly !== desc.readonly || cs.user !== desc.user) {
                            cs.script = desc.script;
                            cs.readonly = desc.readonly;
                            cs.user = desc.user;
                            if (cs.loaded && (cs.servername != "")) {
                                cs.disconnect();
                                cs.try_reconnect_in(1000);
                            }
                        }
                        this.context.updateStatus();
                        if (!cs.loadtask.isPending())
                            this.context.afterload();
                        return cs.loadtask;
                    }
                    this.disconnect(false, "unload previous session");
                }
                if (desc.localname) {
                    var openedby = Slot.slots[desc.localname];
                    openedby && openedby.disconnect(false, "opening session in different context");
                }
                cs = this.context.createSession(desc);
                this.setCurrent(cs);
                if (cs.localname)
                    Slot.slots[cs.localname] = this;
                cs.user_set_doorbell(function () { return _this.context.onDoorBell(); });
                var loadtask = this.loadSessionAsync(cs);
                return loadtask;
            };
            Slot.prototype.disconnect = function (deletelocalstorage, msg) {
                var cs = this.getCurrent();
                if (!cs)
                    return TDev.Promise.as();
                cs.user_unlink();
                cs.user_set_doorbell(function () { return undefined; });
                this.setCurrent(undefined);
                if (cs.localname && Slot.slots[cs.localname] === this)
                    Slot.slots[cs.localname] = undefined;
                var p = Slot.queueSessionWork(cs.localname, "unloading session" + (msg ? " (" + msg + ")" : ""), function () {
                    var promise = cs.closeAsync(deletelocalstorage);
                    promise.done();
                    return promise;
                });
                this.context.clearCachedData();
                this.context.updateStatus();
                return p;
            };
            Slot.prototype.loadSessionAsync = function (session) {
                var _this = this;
                TDev.Util.assert(session !== undefined);
                TDev.Util.assert(session.loadtask === undefined);
                var loadtask = Slot.queueSessionWork(session.localname, "loading session", function () { return session.loadAsync(function () { return _this.context.afterload(); }); });
                loadtask.thenalways(function () {
                    _this.context.updateStatus();
                    if (session.loaded) {
                        if (session.servername != "")
                            return session.connect(_this.context.url_ws(), function (needfreshtoken) { return _this.context.tokensource(needfreshtoken); });
                    }
                    else
                        session.log("!! failure while loading session");
                }).done();
                this.context.clearCachedData();
                this.context.updateStatus();
                return loadtask;
            };
            Slot.createSessionFileAsync = function (context, desc) {
                TDev.Util.assert(desc.localname && !Slot.slots[desc.localname]);
                var s = context.createSession(desc);
                return Slot.queueSessionWork(desc.localname, "creating session", function () {
                    return s.loadAsync().then(function () { return s.closeAsync(false); }).then(function () { return s; }, function () { return undefined; });
                });
            };
            Slot.deleteSessionFileAsync = function (context, desc) {
                var openedby = desc.localname && Slot.slots[desc.localname];
                if (openedby)
                    return openedby.disconnect(true);
                var s = context.createSession(desc);
                return Slot.queueSessionWork(desc.localname, "deleting session cache", function () {
                    return s.loadAsync().then(function () { return s.closeAsync(true); });
                });
            };
            Slot.queueSessionWork = function (localname, description, work) {
                var waitfor = Slot.busysessions[localname];
                if (waitfor === undefined)
                    waitfor = TDev.Promise.wrap(undefined);
                else
                    TDev.Util.log("[" + localname + "] queued " + description);
                waitfor = waitfor.then(function () {
                    TDev.Util.log("[" + localname + "] started " + description);
                    return work().then(function (x) {
                        Slot.busysessions[localname] = undefined;
                        TDev.Util.log("[" + localname + "] finished " + description);
                        return x;
                    }, function (e) {
                        Slot.busysessions[localname] = undefined;
                        TDev.Util.log("[" + localname + "] unsuccessfully terminated  " + description);
                    });
                });
                Slot.busysessions[localname] = (!!waitfor._state) ? undefined : waitfor;
                return waitfor;
            };
            Slot.slots = {};
            Slot.busysessions = {};
            return Slot;
        })();
        Revisions.Slot = Slot;
        var Sessions = (function () {
            function Sessions(wsServer) {
                var _this = this;
                if (wsServer === void 0) { wsServer = undefined; }
                this.wsServer = wsServer;
                this.CurrentSession = undefined;
                this.LocalSession = undefined;
                this.currentSessionSlot = new Slot(this, function () { return _this.CurrentSession; }, function (cs) { return _this.CurrentSession = cs; });
                this.localSessionSlot = new Slot(this, function () { return _this.LocalSession; }, function (cs) { return _this.LocalSession = cs; });
                this.doorbelllisteners = [];
                this.registereddatacaches = [];
            }
            Sessions.prototype.url_http = function () {
                return (this.current_nodeserver || revisionservice_http());
            };
            Sessions.prototype.url_ws = function () {
                return this.url_http().replace("http", "ws");
            };
            Sessions.prototype.tokensource = function (forcefreshtoken) {
                if (this.current_nodeserver)
                    return TDev.Promise.as(this._authtoken || "token");
                else
                    return Revisions.getRevisionServiceTokenAsync(forcefreshtoken);
            };
            Sessions.prototype.setAccessToken = function (token) {
                this._authtoken = token;
            };
            Sessions.prototype.isNodeServer = function () {
                return this.wsServer !== undefined;
            };
            Sessions.prototype.isNodeClient = function () {
                return this.current_nodeserver && this.wsServer === undefined;
            };
            Sessions.prototype.hasNodeConnection = function () {
                return this.current_nodeserver && this.CurrentSession !== undefined && this.CurrentSession.hasNodeConnection();
            };
            Sessions.prototype.nodeConnectionPending = function () {
                return false;
            };
            Sessions.prototype.afterload = function () {
                return undefined;
            };
            Sessions.prototype.getUserId = function () {
                return this.current_userid;
            };
            Sessions.prototype.getScriptGuid = function () {
                return this.current_scriptguid;
            };
            Sessions.prototype.getScriptAuthor = function () {
                return this.current_scriptauthor;
            };
            Sessions.prototype.getScriptName = function () {
                return this.current_scriptname;
            };
            Sessions.prototype.getScript = function () {
                return this.current_script;
            };
            Sessions.prototype.getNodeServer = function () {
                return this.current_nodeserver;
            };
            Sessions.prototype.setEditorScriptContext = function (user, guid, title, basescript, author) {
                this.current_userid = user;
                this.current_scriptguid = guid;
                this.current_scriptname = title;
                this.current_scriptauthor = author;
                this.current_script = TDev.RT.CloudSession.makeScriptIdentifier(basescript, author);
            };
            Sessions.prototype.refreshFinalScriptContext = function () {
                var changed;
                var userid = TDev.Cloud.getUserId() || "";
                var scriptguid = this.rt.host ? this.rt.host.currentGuid : this.current_scriptguid;
                var scriptname = this.rt.compiled.scriptTitle;
                var scriptauthor = this.rt.compiled.authorId || "";
                var basescript = this.rt.compiled && this.rt.compiled.baseScriptId || "";
                var script = TDev.RT.CloudSession.makeScriptIdentifier(basescript, scriptauthor);
                var nodeserver = this.rt.compiled.azureSite;
                if ((!nodeserver && this.current_userid !== userid) || this.current_script != script || this.current_scriptguid != scriptguid || this.current_scriptname != scriptname || this.current_nodeserver != nodeserver) {
                    changed = true;
                    this.currentSessionSlot.disconnect(false, "script context changed");
                    this.localSessionSlot.disconnect(false, "script context changed");
                }
                this.current_userid = userid;
                this.current_scriptguid = scriptguid;
                this.current_scriptname = scriptname;
                this.current_scriptauthor = scriptauthor;
                this.current_script = script;
                this.current_nodeserver = nodeserver;
                return changed;
            };
            Sessions.prototype.clearScriptContext = function (includinglocal) {
                var tasks = [];
                tasks.push(this.currentSessionSlot.disconnect(false, "clear script context"));
                if (includinglocal)
                    tasks.push(this.localSessionSlot.disconnect(false, "clear script context"));
                this.current_userid = undefined;
                this.current_scriptguid = undefined;
                this.current_scriptname = undefined;
                this.current_script = undefined;
                this.current_scriptauthor = undefined;
                this.current_nodeserver = undefined;
                return TDev.Promise.join(tasks);
            };
            Sessions.prototype.getCurrentSession = function () {
                TDev.Util.assert(this.CurrentSession !== undefined);
                return this.CurrentSession;
            };
            Sessions.prototype.getLocalSession = function () {
                if (!this.isNodeServer()) {
                    TDev.Util.assert(this.LocalSession !== undefined);
                    return this.LocalSession;
                }
                else {
                    TDev.Util.assert(this.CurrentSession !== undefined);
                    return this.CurrentSession;
                }
            };
            Sessions.prototype.getLastSession = function () {
                return this.CurrentSession;
            };
            Sessions.prototype.getJustMeSessionDescriptor = function () {
                if (!this.current_userid)
                    return undefined;
                return this.getCloudSessionDescriptor(justmesessionid(this.current_userid, this.current_scriptguid), "just-me session for script \"" + this.current_scriptname + "\"", privatepermission());
            };
            Sessions.prototype.getNodeSessionDescriptor = function (user) {
                var desc = this.getCloudSessionDescriptor(nodesessionid(this.current_scriptguid), "node session for script \"" + this.current_scriptname + "\"", publicpermission(this.current_script));
                desc.user = user;
                return desc;
            };
            Sessions.prototype.getEveryoneSessionDescriptor = function () {
                return this.getCloudSessionDescriptor(everyonesessionid(this.current_scriptauthor, this.current_scriptname), "everyone session for script \"" + this.current_scriptname + "\"", publicpermission(this.current_script));
            };
            Sessions.prototype.getLocalSessionDescriptor = function () {
                var desc = {};
                desc.servername = "";
                desc.localname = localsessionid(this.current_scriptguid);
                desc.user = "";
                desc.title = "";
                desc.permissions = "";
                desc.script = this.current_script;
                desc.readonly = false;
                desc.nodeserver = "";
                return desc;
            };
            Sessions.prototype.getCloudSessionDescriptor = function (servername, title, permissions) {
                var isnode = servername.indexOf("0pn") != -1;
                var owner = servername.substr(0, servername.indexOf("0"));
                var desc = {};
                desc.servername = servername;
                desc.user = this.current_userid;
                desc.title = title;
                desc.script = this.current_script;
                desc.permissions = permissions;
                desc.nodeserver = this.current_nodeserver;
                desc.localname = (!isnode && TDev.Browser.isNodeJS) ? undefined : servername;
                desc.readonly = !isnode && (owner !== this.current_userid) && (servername.indexOf("0cr") != -1);
                return desc;
            };
            Sessions.prototype.disconnect = function () {
                this.currentSessionSlot.disconnect(false, "disconnect");
                this.localSessionSlot.disconnect(false, "disconnect");
            };
            Sessions.prototype.unlink = function () {
                if (this.CurrentSession)
                    this.CurrentSession.user_unlink();
                if (this.LocalSession)
                    this.LocalSession.user_unlink();
            };
            Sessions.prototype.scriptRestarted = function () {
                this.refreshFinalScriptContext();
            };
            Sessions.prototype.scriptStarted = function (author) {
                this.refreshFinalScriptContext();
            };
            Sessions.prototype.createSession = function (original) {
                var si = original.nodeserver ? (this.isNodeServer() ? new Revisions.ServerSession(original.nodeserver, original.servername, original.localname, original.user, this.rt, this.wsServer) : new Revisions.NodeSession(original.nodeserver, original.servername, original.localname, original.user)) : new Revisions.ClientSession(original.servername, original.localname, original.user);
                si.permissions = original.permissions;
                si.title = original.title;
                si.script = original.script;
                si.readonly = original.readonly;
                si.user = original.user;
                return si;
            };
            Sessions.prototype.connectCurrent = function (desc) {
                var isnodesession = desc.servername.indexOf("0pn") != -1;
                TDev.Util.assert(isnodesession == !!this.current_nodeserver, "must not mix cloud/node sessions");
                TDev.Util.assert(isnodesession || !!this.current_userid, "must be signed in to connect cloud session");
                TDev.Util.assert(!this.isNodeServer() || isnodesession, "can only use node session on server");
                return this.currentSessionSlot.connect(desc);
            };
            Sessions.prototype.enable_script_session_mgt = function () {
                return TDev.Cloud.getUserId() && !!this.current_userid && !!this.current_scriptguid && !!this.current_scriptauthor;
            };
            Sessions.prototype.ensureSessionLoaded = function () {
                var _this = this;
                var sign_in = (this.current_userid || !this.rt.compiled.hasCloudData || this.current_nodeserver) ? TDev.Promise.as() : TDev.Cloud.authenticateAsync(TDev.lf("cloud data"));
                return sign_in.thenalways(function () {
                    _this.refreshFinalScriptContext();
                    var loadlocal;
                    var loadcurrent;
                    if (_this.rt.compiled.hasLocalData && !_this.isNodeServer()) {
                        loadlocal = _this.localSessionSlot.connect(_this.getLocalSessionDescriptor()).thenalways(function () {
                            if (_this.LocalSession && _this.LocalSession.faulted) {
                                TDev.Util.check(false, "local data corrupted - resetting");
                                _this.localSessionSlot.disconnect(true, "delete due to faulted load");
                                _this.localSessionSlot.connect(_this.getLocalSessionDescriptor());
                            }
                        });
                    }
                    else {
                        _this.localSessionSlot.disconnect(false, "no local data");
                        loadlocal = TDev.Promise.as();
                    }
                    if (_this.rt.compiled.hasCloudData || (_this.rt.compiled.hasLocalData && _this.isNodeServer())) {
                        if (!_this.current_nodeserver && !_this.current_userid)
                            loadcurrent = TDev.Promise.wrapError("cannot run this script without first signing in");
                        else if (!_this.current_scriptguid || !_this.current_scriptname || !_this.current_scriptauthor || !_this.current_script)
                            TDev.Util.oops("cannot determine script info: runtime lacks information");
                        else {
                            var session = _this.current_nodeserver ? _this.getNodeSessionDescriptor("") : (_this.CurrentSession || _this.getJustMeSessionDescriptor());
                            loadcurrent = _this.connectCurrent(session);
                        }
                    }
                    else {
                        _this.currentSessionSlot.disconnect(false, "no cloud session");
                        loadcurrent = TDev.Promise.as();
                    }
                    _this.updateStatus();
                    return TDev.Promise.join([loadlocal, loadcurrent]);
                });
            };
            Sessions.prototype.readyForExecution = function () {
                if (this.refreshFinalScriptContext()) {
                    TDev.Util.check(false, "script info changed between loading and execution");
                    return false;
                }
                if (this.rt.compiled.hasCloudData && !this.current_nodeserver && !this.current_userid) {
                    return false;
                }
                if (this.rt.compiled.hasLocalData && !this.isNodeServer() && !(this.LocalSession && this.LocalSession.loaded)) {
                    TDev.Util.check(false, "failed to load local session");
                    return false;
                }
                if ((this.rt.compiled.hasCloudData || (this.rt.compiled.hasLocalData && this.isNodeServer())) && !(this.CurrentSession && this.CurrentSession.loaded)) {
                    TDev.Util.check(false, "failed to load cloud session");
                    return false;
                }
                if (this.LocalSession && this.LocalSession.faulted) {
                    TDev.Util.check(false, "error loading local session from disk");
                    return false;
                }
                return true;
            };
            Sessions.prototype.stopAsync = function () {
                return TDev.Promise.as();
            };
            Sessions.prototype.receive_operation = function (p) {
                if (!this.current_nodeserver)
                    throw new Error("should not be called for unexported apps");
            };
            Sessions.prototype.resetCurrentSession = function () {
                var session = this.CurrentSession;
                if (!session)
                    return;
                var desc = this.getCloudSessionDescriptor(session.servername, session.title, session.permissions);
                this.currentSessionSlot.disconnect(true, "reset current session");
                return this.currentSessionSlot.connect(desc);
            };
            Sessions.prototype.clearCurrentSession = function () {
                if (!this.CurrentSession)
                    return;
                this.CurrentSession.user_clear_all();
                this.clearCachedData();
            };
            Sessions.prototype.getLocalSessionAttributeAsync = function (key, rt) {
                var _this = this;
                TDev.Util.assert(!this.isNodeServer(), "cannot access attributes on server");
                return this.get_attribute_lval(key, rt).then(function (lval) { return TDev.RT.Conv.fromCloud("string", _this.LocalSession.user_get_value(lval)); });
            };
            Sessions.prototype.setLocalSessionAttributeAsync = function (key, value, rt) {
                var _this = this;
                TDev.Util.assert(!this.isNodeServer(), "cannot access attributes on server");
                var op = TDev.RT.Conv.toCloud("string", value, false);
                return this.get_attribute_lval(key, rt).then(function (lval) { return _this.LocalSession.user_modify_lval(lval, op); });
            };
            Sessions.prototype.get_attribute_lval = function (key, rt) {
                var _this = this;
                var waitfor = this.LocalSession ? TDev.Promise.as() : this.localSessionSlot.connect(this.getLocalSessionDescriptor());
                return waitfor.then(function () { return _this.LocalSession.user_get_lval(Revisions.Parser.MakeProperty(key, "attributes[]", "string"), [], []); });
            };
            Sessions.prototype.queueRestRequest = function (sr) {
                sr._onStop = new TDev.PromiseInv();
                this.rt.dispatchServerRequest(sr, sr._onStop).then(function (res) {
                }, function (err) {
                    TDev.RT.App.log("404 " + sr.method().toUpperCase() + " " + sr.url());
                    var resp = sr.getNodeRequest().tdResponse;
                    resp.writeHead(404, "API Error");
                    resp.end(err.message);
                });
            };
            Sessions.prototype.yieldSession = function () {
                var somechanges = false;
                if (this.CurrentSession) {
                    var changes = this.CurrentSession.user_yield();
                    if (changes) {
                        this.updateStatus();
                        this.clearCachedData();
                        somechanges = true;
                    }
                }
                if (this.LocalSession) {
                    var changes = this.LocalSession.user_yield();
                    if (changes) {
                        this.clearCachedData();
                        somechanges = true;
                    }
                }
                return somechanges;
            };
            Sessions.prototype.updateStatus = function () {
                if (this.isNodeServer())
                    return;
                if (this.CurrentSession) {
                    if (this.rt.host)
                        this.rt.host.updateCloudState(true, this.CurrentSession.getCloudSession().type(), this.CurrentSession.user_get_connectionstatus(false));
                    TDev.RT.CloudData.refreshSessionInfo(this.CurrentSession);
                }
                else {
                    if (this.rt.host)
                        this.rt.host.updateCloudState(false, "", "");
                }
            };
            Sessions.prototype.onDoorBell = function () {
                if (this.isNodeClient() && this.CurrentSession && (this.CurrentSession.marooned || this.CurrentSession.faulted)) {
                    var s = this.CurrentSession;
                    s.log("discard cache because it is " + (s.marooned ? "marooned" : s.faulted ? "faulted" : ""));
                    this.currentSessionSlot.disconnect(true, "reset because " + (s.marooned ? "marooned" : s.faulted ? "faulted" : ""));
                    this.currentSessionSlot.connect(s);
                }
                if (!TDev.Browser.isNodeJS) {
                    this.rt.yield_when_possible();
                }
                this.doorbelllisteners = this.doorbelllisteners.filter(function (listener) { return listener(); });
                this.updateStatus();
            };
            Sessions.prototype.addDoorbellListener = function (listener) {
                this.doorbelllisteners.push(listener);
            };
            Sessions.prototype.clearCachedData = function () {
                for (var l in this.registereddatacaches) {
                    if (this.registereddatacaches.hasOwnProperty(l))
                        this.registereddatacaches[l].clearCachedData();
                }
            };
            Sessions.prototype.registerDataCache = function (key, o) {
                this.registereddatacaches[key] = o;
            };
            Sessions.prototype.unregisterDataCache = function (key) {
                delete this.registereddatacaches[key];
            };
            Sessions.prototype.deleteAllLocalDataAsync = function (scriptguid) {
                var localtask = Slot.deleteSessionFileAsync(this, this.getLocalSessionDescriptor());
                if (this.current_nodeserver) {
                    return TDev.Promise.join([
                        Slot.deleteSessionFileAsync(this, this.getNodeSessionDescriptor("")),
                        localtask
                    ]);
                }
                else {
                    var userid = TDev.Cloud.getUserId();
                    if (!userid || userid !== this.current_userid || scriptguid !== this.current_scriptguid)
                        return localtask;
                    else {
                        var justmesession = this.getJustMeSessionDescriptor();
                        var everyonesession = this.getEveryoneSessionDescriptor();
                        return TDev.Promise.join([
                            Slot.deleteSessionFileAsync(this, justmesession),
                            Slot.deleteSessionFileAsync(this, everyonesession),
                            localtask
                        ]);
                    }
                }
            };
            Sessions.prototype.createCustomSessionAsync = function (title, type) {
                TDev.Util.assert(!!this.current_userid, "must be signed in to create a cloud session");
                TDev.Util.assert(!this.current_nodeserver, "cannot create sessions for cloud library");
                var desc = {};
                var letter = (permit_all_scripts ? "a" : "s");
                var scripth = (permit_all_scripts ? "" : scripthash(this.current_scriptauthor, this.current_scriptname));
                var guid = letterify(TDev.Util.guidGen());
                var id;
                var permit_all_scripts = false;
                if (type === "shareable") {
                    desc.servername = this.current_userid + "0cw" + letter + scripth + guid;
                    desc.permissions = publicpermission(permit_all_scripts ? "" : this.current_script);
                }
                else if (type === "broadcast") {
                    desc.servername = this.current_userid + "0cr" + letter + scripth + guid;
                    desc.permissions = broadcastpermission(permit_all_scripts ? "" : this.current_script);
                }
                else {
                    desc.servername = this.current_userid + "0cp" + letter + scripth + guid;
                    desc.permissions = privatepermission(permit_all_scripts ? "" : this.current_script);
                }
                desc.localname = desc.servername;
                desc.readonly = false;
                desc.user = this.current_userid;
                desc.title = title;
                desc.nodeserver = "";
                desc.script = this.current_script;
                return Slot.createSessionFileAsync(this, desc).then(function (s) { return s.getCloudSession(); });
            };
            return Sessions;
        })();
        Revisions.Sessions = Sessions;
        (function (CloudOperationType) {
            CloudOperationType[CloudOperationType["UNKNOWN"] = 0] = "UNKNOWN";
            CloudOperationType[CloudOperationType["RPC"] = 1] = "RPC";
            CloudOperationType[CloudOperationType["OFFLINE"] = 2] = "OFFLINE";
        })(Revisions.CloudOperationType || (Revisions.CloudOperationType = {}));
        var CloudOperationType = Revisions.CloudOperationType;
    })(Revisions = TDev.Revisions || (TDev.Revisions = {}));
    var WebSocketWrapper = (function () {
        function WebSocketWrapper(server, request, socket) {
            this.server = server;
            this.request = request;
            this.socket = socket;
        }
        WebSocketWrapper.prototype.origin = function () {
            return this.request.headers['origin'];
        };
        WebSocketWrapper.prototype.path = function () {
            return this.request.url;
        };
        WebSocketWrapper.prototype.accept = function () {
            var _this = this;
            this.socket.tdWrapper = this;
            this.server._conns.push(this.socket);
            var remove = function () {
                var conns = _this.server._conns;
                var idx = conns.indexOf(_this.socket);
                if (idx >= 0)
                    conns.splice(idx, 1);
            };
            this.onClose(remove);
            this.onError(remove);
            return this.socket;
        };
        WebSocketWrapper.prototype.reject = function () {
            this.socket.close();
        };
        WebSocketWrapper.prototype.remoteAddress = function () {
            return this.socket.remoteAddress;
        };
        WebSocketWrapper.prototype.onMessage = function (h) {
            this.socket.addEventListener("message", function (msg) { return typeof msg.data == "string" ? h(msg.data, null) : h(null, msg.data); }, false);
        };
        WebSocketWrapper.prototype.onClose = function (h) {
            this.socket.addEventListener("close", function (ev) { return h(ev.code, ev.reason); }, false);
        };
        WebSocketWrapper.prototype.onError = function (h) {
            this.socket.addEventListener("error", h, false);
        };
        WebSocketWrapper.prototype.mkTdWebSocket = function (rt) {
            if (!this.socket)
                this.accept();
            var w = new TDev.RT.WebSocket_(this.socket, rt);
            this.onMessage(function (str, buff) {
                var data = str;
                if (buff)
                    data = TDev.RT.Buffer.fromTypedArray(buff);
                w.receiveMessage(TDev.RT.WebSocketMessage.mk(data));
            });
            this.onError(function (ev) {
                var msg = ev.message || (ev + "");
                TDev.RT.App.logEvent(TDev.RT.App.DEBUG, "ws", "error: " + msg, undefined);
                w.receiveMessage(TDev.RT.WebSocketMessage.mkError(msg));
            });
            this.onClose(function (code, reason) {
                w.gotClose();
            });
            return w;
        };
        return WebSocketWrapper;
    })();
    TDev.WebSocketWrapper = WebSocketWrapper;
    var WebSocketServerWrapper = (function () {
        function WebSocketServerWrapper(WebSocketModule) {
            this.WebSocketModule = WebSocketModule;
            this.handlers = [];
            this._conns = [];
        }
        WebSocketServerWrapper.prototype.isReal = function () {
            return !!this.WebSocketModule;
        };
        WebSocketServerWrapper.prototype.upgradeCallback = function (request, socket, body) {
            var _this = this;
            var ws = this.WebSocketModule;
            if (ws.isWebSocket(request)) {
                var conn = new ws(request, socket, body);
                var r = new WebSocketWrapper(this, request, conn);
                var nextOne = function (idx) {
                    if (!_this.handlers[idx])
                        r.reject();
                    else
                        _this.handlers[idx](r, function () { return nextOne(idx + 1); });
                };
                nextOne(0);
            }
        };
        WebSocketServerWrapper.prototype.closeConnections = function () {
            this._conns.forEach(function (c) { return c.close(); });
            this._conns = [];
        };
        WebSocketServerWrapper.prototype.addHandler = function (h) {
            this.handlers.push(h);
        };
        WebSocketServerWrapper.prototype.connections = function () {
            return this._conns;
        };
        return WebSocketServerWrapper;
    })();
    TDev.WebSocketServerWrapper = WebSocketServerWrapper;
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var Revisions;
    (function (Revisions) {
        (function (StatusType) {
            StatusType[StatusType["Error"] = 0] = "Error";
            StatusType[StatusType["Warning"] = 1] = "Warning";
            StatusType[StatusType["Ok"] = 2] = "Ok";
        })(Revisions.StatusType || (Revisions.StatusType = {}));
        var StatusType = Revisions.StatusType;
        (function (EncodingMode) {
            EncodingMode[EncodingMode["CLIENT_LAYER_TO_DISK"] = 0] = "CLIENT_LAYER_TO_DISK";
            EncodingMode[EncodingMode["CLIENT_BASE_TO_DISK"] = 1] = "CLIENT_BASE_TO_DISK";
            EncodingMode[EncodingMode["CLIENT_LAYER_TO_SERVER"] = 2] = "CLIENT_LAYER_TO_SERVER";
            EncodingMode[EncodingMode["SERVER_BASE_TO_DISK"] = 3] = "SERVER_BASE_TO_DISK";
            EncodingMode[EncodingMode["SERVER_LAYER_TO_CLIENT"] = 4] = "SERVER_LAYER_TO_CLIENT";
            EncodingMode[EncodingMode["SERVER_UPDATES_TO_CLIENT"] = 5] = "SERVER_UPDATES_TO_CLIENT";
            EncodingMode[EncodingMode["TRACE_LOAD"] = 6] = "TRACE_LOAD";
        })(Revisions.EncodingMode || (Revisions.EncodingMode = {}));
        var EncodingMode = Revisions.EncodingMode;
        var Layer = (function () {
            function Layer(session, name, data, clientround, serverround, grounded) {
                if (grounded === void 0) { grounded = false; }
                this.delcount = 0;
                this.session = session;
                this.name = name;
                this.data = data;
                if (clientround !== undefined)
                    this.clientround = clientround;
                if (serverround !== undefined)
                    this.serverround = serverround;
                this.grounded = grounded;
            }
            Layer.prototype.hasData = function () {
                return ((this.data && this.data.length !== 0) || (this.cloudOperations && this.cloudOperations.length !== 0) || this.grounded || this.clientrounds);
            };
            Layer.prototype.clear = function () {
                var _this = this;
                var changes = false;
                this.data.forEach(function (d) {
                    if (d.removeOperation(_this) !== undefined)
                        changes = true;
                });
                return changes;
                this.grounded = false;
            };
            Layer.prototype.cleanIfNeeded = function (limit) {
                var _this = this;
                if (this.delcount > limit) {
                    this.data = this.data.filter(function (d) { return (d.getOperation(_this.name) !== undefined); });
                    this.delcount = 0;
                }
            };
            Layer.prototype.invalidate_all = function () {
                this.data.forEach(function (d) {
                    if (d instanceof Item)
                        d.invalidate(true);
                    else
                        d.invalidate(false);
                });
            };
            Layer.prototype.CommitCloudOperation = function (op) {
                if (!this.cloudOperations) {
                    this.cloudOperations = [op];
                }
                else {
                    this.cloudOperations.push(op);
                }
            };
            Layer.prototype.mergeCloudOperations = function (layer) {
                if (!layer.cloudOperations)
                    return;
                if (!this.cloudOperations) {
                    this.cloudOperations = [];
                }
                this.cloudOperations = this.cloudOperations.concat(layer.cloudOperations);
            };
            Layer.prototype.removeCloudOperations = function () {
                delete this.cloudOperations;
            };
            return Layer;
        })();
        Revisions.Layer = Layer;
        var Fence = (function () {
            function Fence(continuation, round, exclusive) {
                this.continuation = continuation;
                this.round = round;
                this.exclusive = exclusive;
            }
            return Fence;
        })();
        var Datum = (function () {
            function Datum() {
                this.fromCloudOp = TDev.Runtime.theRuntime && TDev.Runtime.theRuntime.inCloudCall;
                this.ops = {};
            }
            Datum.prototype.invalidate = function (deleted) {
                delete this.cached;
                if (deleted) {
                    this.deleted = true;
                    this.unlink();
                }
            };
            Datum.prototype.get_op = function (layer) {
                return this.ops[layer];
            };
            Datum.prototype.set_op = function (layer, op) {
                this.ops[layer] = op;
            };
            Datum.prototype.del_op = function (layer) {
                delete this.ops[layer];
            };
            Datum.prototype.all_ops = function () {
                return Object.keys(this.ops);
            };
            Datum.prototype.getOperation = function (lname) {
                return this.get_op(lname);
            };
            Datum.prototype.recordOperation = function (l, op) {
                var val = this.get_op(l.name);
                var result = this.collapse(val, op, l.grounded);
                if (result !== undefined) {
                    this.set_op(l.name, result);
                    if (val === undefined)
                        l.data.push(this);
                }
                else {
                    if (val !== undefined) {
                        this.del_op(l.name);
                        l.delcount += 1;
                    }
                }
                return (val !== result);
            };
            Datum.prototype.removeOperation = function (l) {
                var val = this.get_op(l.name);
                if (val !== undefined) {
                    this.del_op(l.name);
                    l.delcount += 1;
                }
                return val;
            };
            Datum.prototype.compute_current = function () {
                var cur = this.getOperation("B");
                if (!this.session.readonly) {
                    var baseround = this.session.get_layer("B").clientround;
                    var localround = this.session.localround;
                    for (var i = baseround + 1; i < localround; i++) {
                        var datalayer = this.session.get_layer("D" + i);
                        cur = (datalayer.grounded) ? this.getOperation("D" + i) : this.collapse(cur, this.getOperation("D" + i), true);
                    }
                    var locallayer = this.session.get_layer("D" + localround);
                    cur = (locallayer && locallayer.grounded) ? this.getOperation("D" + localround) : this.collapse(cur, this.getOperation("D" + localround), true);
                    var tlayer = this.session.get_layer("T");
                    if (tlayer)
                        cur = (tlayer.grounded) ? this.getOperation("T") : this.collapse(cur, this.getOperation("T"), true);
                }
                TDev.Util.check(!TDev.dbg || (this.cached === undefined) || (this.cached !== null && this.cached === cur) || (this.cached === null && cur === undefined));
                this.cached = (cur === undefined) ? null : cur;
                return cur;
            };
            Datum.prototype.has_deleted_dependencies = function () {
                var _this = this;
                var deleted = false;
                this.ukeys.forEach(function (uid) {
                    var item = _this.session.get_item(uid);
                    if (!item || _this.session.user_is_datum_deleted(item))
                        deleted = true;
                });
                TDev.Util.assert(!deleted || this.deleted);
                return deleted;
            };
            Datum.prototype.linkDeps = function () {
                var _this = this;
                this.ukeys.forEach(function (l) {
                    var item = _this.session.get_item(l);
                    if (!(item && item.addDependency(_this)))
                        _this.deleted = true;
                });
            };
            Datum.prototype.collapse = function (first, second, grounded) {
            };
            Datum.prototype.target = function () {
                return "";
            };
            Datum.prototype.unlink = function () {
            };
            return Datum;
        })();
        Revisions.Datum = Datum;
        var Item = (function (_super) {
            __extends(Item, _super);
            function Item() {
                _super.apply(this, arguments);
                this.deps = {};
            }
            Item.prototype.target = function () {
                return this.uid;
            };
            Item.prototype.unlink = function () {
                if (this.backlink) {
                    this.backlink.unlink();
                    delete this.backlink;
                }
            };
            Item.prototype.collapse = function (first, second, grounded) {
                if (first === undefined)
                    return second;
                if (second === undefined)
                    return first;
                if (first === "D") {
                    this.session.assertConsistency(second === "D");
                    return grounded ? undefined : "D";
                }
                TDev.Util.assert(first[0] === "C");
                if (second !== "D")
                    this.session.assertConsistency(false, "collapse uid=" + this.uid + " def=" + (this.backlink && this.backlink.parent && this.backlink.parent.cloudtype) + " second=" + second);
                return undefined;
            };
            Item.prototype.recordCreation = function (l, serveritemcount) {
                if (serveritemcount === undefined)
                    this.recordOperation(l, "C");
                else {
                    this.recordOperation(l, "C" + serveritemcount);
                }
            };
            Item.prototype.recordDeletion = function (l) {
                this.recordOperation(l, "D");
            };
            Item.prototype.recordOperation = function (l, op) {
                if (op === "D")
                    this.removeRedundantOps(l);
                return _super.prototype.recordOperation.call(this, l, op);
            };
            Item.prototype.compareTo = function (other) {
                var a = this.compute_current();
                if (a === "C") {
                    var b = other.compute_current();
                    if (b === "C")
                        return Number(this.uid) - Number(other.uid);
                    else
                        return 1;
                }
                else {
                    var b = other.compute_current();
                    if (b === "C")
                        return -1;
                    else
                        return Number(a.substr(1)) - Number(b.substr(1));
                }
            };
            Item.prototype.addDependency = function (d) {
                this.deps["$" + d.target()] = d;
                return !this.deleted;
            };
            Item.prototype.removeDependency = function (d) {
                delete this.deps["$" + d.target()];
            };
            Item.prototype.invalidate = function (deleted) {
                _super.prototype.invalidate.call(this, deleted);
                for (var p in this.deps)
                    if (this.deps.hasOwnProperty(p) && p[0] === "$")
                        this.deps[p].invalidate(deleted);
                this.session.remove_item_from_index(this);
            };
            Item.prototype.removeRedundantOps = function (layer) {
                for (var p in this.deps)
                    if (this.deps.hasOwnProperty(p) && p[0] === "$") {
                        var datum = this.deps[p];
                        datum.removeOperation(layer);
                        if (datum instanceof Item)
                            datum.removeRedundantOps(layer);
                    }
            };
            return Item;
        })(Datum);
        Revisions.Item = Item;
        var Entry = (function (_super) {
            __extends(Entry, _super);
            function Entry() {
                _super.apply(this, arguments);
            }
            Entry.prototype.target = function () {
                return ClientSession.MakeModTarget(this.definition, this.ukeys, this.lkeys);
            };
            return Entry;
        })(Datum);
        Revisions.Entry = Entry;
        var LVal = (function (_super) {
            __extends(LVal, _super);
            function LVal() {
                _super.apply(this, arguments);
            }
            LVal.prototype.target = function () {
                return ClientSession.MakeModTarget(this.definition, this.ukeys, this.lkeys);
            };
            LVal.prototype.parseDefinition = function () {
                var p = new Parser(this.definition, 0);
                this.name = p.ParseDefinitionString();
                TDev.Util.assert(p.text[p.pos] === ",");
                p.pos += 1;
                this.codomain = p.ParseDefinitionString();
                TDev.Util.assert(p.text[p.pos] === "[");
                this.indexdomain = p.text.slice(p.pos + 1, p.text.length - 1);
            };
            LVal.prototype.collapse = function (first, second, grounded) {
                if (second === undefined)
                    return first;
                else if (first === undefined) {
                    if (this.codomain === "double" || this.codomain === "long") {
                        if (grounded) {
                            if (second.lastIndexOf("A", 0) === 0)
                                second = second.slice(1);
                            return (second === "0") ? undefined : second;
                        }
                        else
                            return second === "A0" ? undefined : second;
                    }
                    else if (this.codomain === "ast") {
                        return second;
                    }
                    else {
                        if (second.lastIndexOf("^?", 0) !== 0)
                            return (grounded && !second) ? undefined : second;
                        var cond = second.substring(2);
                        if (cond === "")
                            return undefined;
                        if (grounded)
                            return (cond.charAt(0) === "^") ? ("^!" + cond) : cond;
                        return second;
                    }
                }
                else if (this.codomain === "double" || this.codomain === "long") {
                    if (second.charAt(0) !== 'A')
                        return (grounded && second === "0") ? undefined : second;
                    var secondval = Number(second.slice(1));
                    var relative = false;
                    var firstval = Number(first);
                    if (isNaN(firstval)) {
                        TDev.Util.assert(first.charAt(0) === 'A');
                        firstval = Number(first.slice(1));
                        relative = true;
                        TDev.Util.assert(!grounded);
                    }
                    var sum = (firstval + secondval);
                    if (sum !== 0 || (!relative && !grounded))
                        return relative ? ("A" + sum) : sum.toString();
                    else
                        return undefined;
                }
                else if (this.codomain === "ast") {
                    return second;
                }
                else {
                    if (second.lastIndexOf("^?", 0) !== 0) {
                        return (grounded && !second) ? undefined : second;
                    }
                    else {
                        if (first.lastIndexOf("^?", 0) !== 0) {
                            if (first === "" || first === "^!") {
                                var cond = second.substring(2);
                                var r = (cond.charAt(0) === "^") ? ("^!" + cond) : cond;
                                return (grounded && !r) ? undefined : r;
                            }
                            else {
                                return first;
                            }
                        }
                        else {
                            if (first.length === 2)
                                return (grounded && !second) ? undefined : second;
                            else
                                return first;
                        }
                    }
                }
                TDev.Util.oops("missing case in LVal.collapse");
            };
            return LVal;
        })(Datum);
        Revisions.LVal = LVal;
        var ClientSession = (function () {
            function ClientSession(servername, localname, user) {
                this.servername = servername;
                this.localname = localname;
                this.user = user;
                this.sendCloudOperations = false;
                this.concatIdToItem = false;
                this.includeKeysInStatus = false;
                this.acceptsUpdates = false;
                this.requiresAuth = true;
                this.trace_save_and_load = false;
                this.trace_incoming_packets = false;
                this.trace_saving = false;
                this.membernumber = -1;
                this.disambiguator = "";
                this.enable_sync = undefined;
                this.serveritemcount = 0;
                this.userdata = {};
                this.localround = 1;
                this.uidcount = 0;
                this.sendinterval = 250;
                this.pendingroundlimit = 5;
                this.scrublimit = 1000;
                this.connectionretrydelay = 20000;
                this.qcount = 0;
                this.last_S_save = TDev.Promise.as();
                this.last_C_save = TDev.Promise.as();
                this.ring_doorbell_when_done = false;
                this.CLstate_needsave = false;
                this.Sstate_needsave = false;
                this.previewround = 0;
                this.percentfull = 0;
                this.presence = [];
                this.dochannelcompression = false;
                this.statuschanges = false;
                this.fences = [];
                this.doorbell = function () {
                };
                this.initialize_data();
                this.loaded = (localname === undefined);
                if (this.user === undefined)
                    this.user = "";
                TDev.Util.assert(!!servername || !!localname);
            }
            ClientSession.prototype.samesession = function (other) {
                return (this.servername === other.servername && this.localname === other.localname);
            };
            ClientSession.prototype.getMemberNumber = function () {
                return this.membernumber;
            };
            ClientSession.prototype.key_sessionlist = function () {
                return "%";
            };
            ClientSession.prototype.key_Sstate = function () {
                return this.localname + "/S";
            };
            ClientSession.prototype.key_Cstate = function () {
                return this.localname + "/C";
            };
            ClientSession.prototype.key_layer = function (layer) {
                return this.localname + "/" + layer;
            };
            ClientSession.prototype.S_toJSONstring = function () {
                return JSON.stringify({
                    servername: this.servername,
                    localname: this.localname,
                    description: this.title,
                    membernumber: this.membernumber,
                    disambiguator: this.disambiguator,
                    enable_sync: this.enable_sync,
                    serveritemcount: this.serveritemcount,
                    permissions: this.permissions,
                    userdata: this.userdata,
                });
            };
            ClientSession.prototype.S_fromJSONstring = function (s) {
                var json = JSON.parse(s);
                TDev.Util.assert(this.servername === json.servername);
                TDev.Util.assert(this.localname === json.localname);
                if (!this.title && json.description)
                    this.title = json.description;
                this.membernumber = json.membernumber;
                this.disambiguator = json.disambiguator;
                if (this.enable_sync === undefined)
                    this.enable_sync = json.enable_sync;
                this.serveritemcount = json.serveritemcount;
                this.permissions = json.permissions;
                this.userdata = json.userdata || {};
            };
            ClientSession.prototype.C_toJSONstring = function () {
                return JSON.stringify({
                    uidcount: this.uidcount,
                    localround: this.localround,
                });
            };
            ClientSession.prototype.C_fromJSONstring = function (s) {
                var json = JSON.parse(s);
                this.uidcount = json.uidcount;
                this.localround = json.localround;
            };
            ClientSession.prototype.user_specify_ast_encoding = function (s) {
                this.astencoding = s;
            };
            ClientSession.prototype.assertConsistency = function (cond, message) {
                if (!cond) {
                    this.faulted = true;
                    this.statuschanges = true;
                    TDev.Util.check(cond, "local cache inconsistent with server");
                }
            };
            ClientSession.prototype.user_get_lval = function (definition, ukeys, lkeys) {
                var t = ClientSession.MakeModTarget(definition, ukeys, lkeys);
                var lval = this.get_lval(t);
                if (!lval) {
                    lval = new LVal();
                    lval.session = this;
                    lval.definition = definition;
                    lval.ukeys = ukeys;
                    lval.lkeys = lkeys;
                    lval.parseDefinition();
                    lval.entry = this.user_get_entry(lval.indexdomain, ukeys, lkeys);
                    lval.linkDeps();
                    this.add_lval(lval);
                    this.add_lval_to_index(lval);
                }
                else {
                    this.assertConsistency(lval.definition === definition);
                    this.assertConsistency(ukeys.length === lval.ukeys.length);
                    for (var i = 0; i < ukeys.length; i++)
                        this.assertConsistency(ukeys[i] === lval.ukeys[i]);
                    this.assertConsistency(lkeys.length === lval.lkeys.length);
                    for (var i = 0; i < lkeys.length; i++)
                        this.assertConsistency(lkeys[i] === lval.lkeys[i]);
                }
                return lval;
            };
            ClientSession.prototype.user_get_entry = function (definition, ukeys, lkeys) {
                var k = ClientSession.MakeModTarget(definition, ukeys, lkeys);
                var entry = this.get_entry(k);
                if (!entry) {
                    entry = new Entry();
                    entry.session = this;
                    entry.definition = definition;
                    entry.ukeys = ukeys;
                    entry.lkeys = lkeys;
                    entry.linkDeps();
                    this.add_entry(entry);
                }
                else {
                    this.assertConsistency(entry.definition === definition);
                    this.assertConsistency(ukeys.length === entry.ukeys.length);
                    for (var i = 0; i < ukeys.length; i++)
                        this.assertConsistency(ukeys[i] === entry.ukeys[i]);
                    this.assertConsistency(lkeys.length === entry.lkeys.length);
                    for (var i = 0; i < lkeys.length; i++)
                        this.assertConsistency(lkeys[i] === entry.lkeys[i]);
                }
                return entry;
            };
            ClientSession.prototype.user_get_entries_in_indexdomain = function (indexdomain) {
                var _this = this;
                var entries = new Array();
                var qcount = this.qcount;
                this.qcount += 1;
                this.get_lvals_for_indexdomain(indexdomain).forEach(function (lval) {
                    if (!_this.user_is_defaultvalue(lval)) {
                        var e = lval.entry;
                        if (e.qcount !== qcount) {
                            e.qcount = qcount;
                            entries.push(lval.entry);
                            e.lvals = new Array();
                        }
                        e.lvals.push(lval);
                    }
                });
                return entries;
            };
            ClientSession.prototype.user_modify_lval = function (lval, op) {
                if (this.readonly)
                    return;
                var deleted = this.user_is_datum_deleted(lval);
                if (!deleted) {
                    lval.invalidate(false);
                    if (op !== undefined) {
                        var transactionlayer = this.get_layer("T") || this.create_layer("T");
                        lval.recordOperation(transactionlayer, op);
                    }
                }
            };
            ClientSession.prototype.user_get_items_in_domain = function (domain) {
                var _this = this;
                var base = this.get_items_in_domain(domain);
                return base.filter(function (i) { return !_this.user_is_datum_deleted(i); });
            };
            ClientSession.prototype.user_get_item = function (uid) {
                var k = this.get_item(uid);
                if (k === undefined) {
                    var pos = uid.indexOf('.');
                    if (pos != -1 && uid.substr(0, pos) === this.membernumber.toString())
                        k = this.get_item(uid.substr(pos + 1));
                }
                return k;
            };
            ClientSession.prototype.user_create_tombstone = function (definition, uid, ukeys, lkeys) {
                var k = new Item();
                k.session = this;
                k.definition = definition;
                k.uid = uid;
                k.ukeys = ukeys;
                k.lkeys = lkeys;
                k.deleted = true;
                return k;
            };
            ClientSession.prototype.user_create_item = function (definition, ukeys, lkeys) {
                var k = new Item();
                k.session = this;
                k.definition = definition;
                TDev.Util.assert(this.loaded || this.faulted);
                this.uidcount += 1;
                k.uid = (this.concatIdToItem ? (this.membernumber + ".") : "") + this.uidcount.toString();
                k.ukeys = ukeys;
                k.lkeys = lkeys;
                this.assertConsistency(!this.get_item(k.uid));
                if (this.readonly) {
                    k.deleted = true;
                    return k;
                }
                k.linkDeps();
                this.add_item(k);
                if (!k.has_deleted_dependencies()) {
                    var transactionlayer = this.get_layer("T") || this.create_layer("T");
                    k.recordCreation(transactionlayer);
                    this.add_item_to_index(k);
                }
                return k;
            };
            ClientSession.prototype.user_delete_item = function (item) {
                if (this.readonly)
                    return;
                var deleted = this.user_is_datum_deleted(item);
                if (!deleted) {
                    var transactionlayer = this.get_layer("T") || this.create_layer("T");
                    item.recordDeletion(transactionlayer);
                    item.invalidate(true);
                }
            };
            ClientSession.prototype.user_clear_all = function () {
                if (this.readonly)
                    return;
                var baselayer = this.get_layer("B");
                baselayer.invalidate_all();
                var baseround = baselayer.clientround;
                var localround = this.localround;
                for (var i = baseround + 1; i <= localround; i++) {
                    var datalayer = this.get_layer("D" + i);
                    datalayer && datalayer.invalidate_all();
                }
                var transactionlayer = this.get_layer("T");
                transactionlayer && transactionlayer.invalidate_all();
                this.delete_layer("T", false);
                var transactionlayer = this.create_layer("T");
                transactionlayer.grounded = true;
            };
            ClientSession.prototype.log = function (msg) {
                TDev.Util.log("{0}", this.logmsg(msg));
            };
            ClientSession.prototype.logmsg = function (msg) {
                return "[" + (this.servername || this.localname) + "] " + msg;
            };
            ClientSession.prototype.user_is_datum_deleted = function (datum) {
                if (datum.has_deleted_dependencies())
                    return true;
                var deleted = false;
                if (datum instanceof Item) {
                    var s = datum.compute_current();
                    deleted = (!s || s[0] !== "C");
                }
                TDev.Util.assert(!TDev.dbg || deleted === !!datum.deleted);
                return deleted;
            };
            ClientSession.prototype.user_is_datum_confirmed = function (datum) {
                var ops = datum.all_ops();
                if (this.servername)
                    return !ops.some(function (s) { return (s[0] === "D" || s[0] === "T"); });
                else
                    return !ops.some(function (s) { return s != "D1"; });
            };
            ClientSession.prototype.user_get_value = function (lval) {
                var s;
                if (!lval.has_deleted_dependencies())
                    s = lval.compute_current();
                return s;
            };
            ClientSession.prototype.user_is_defaultvalue = function (lval) {
                if (lval.has_deleted_dependencies())
                    return true;
                var s = lval.compute_current();
                if (s === undefined)
                    return true;
                if (lval.codomain === "long" || lval.codomain === "double")
                    return (s === "A0" || s === "0");
                else if (lval.codomain === "string")
                    return (s === "" || s === "^" || s === "^?" || s === "^!");
                else
                    return s === "";
            };
            ClientSession.prototype.get_datum = function (target) {
                return this.data[target];
            };
            ClientSession.prototype.get_item = function (uid) {
                return this.data[uid];
            };
            ClientSession.prototype.get_lval = function (target) {
                return this.data[target];
            };
            ClientSession.prototype.get_entry = function (target) {
                return this.data[target];
            };
            ClientSession.prototype.add_item = function (item) {
                this.data[item.uid] = item;
            };
            ClientSession.prototype.add_lval = function (lval) {
                this.data[lval.target()] = lval;
            };
            ClientSession.prototype.add_entry = function (entry) {
                this.data[entry.target()] = entry;
            };
            ClientSession.prototype.get_items_in_domain = function (domain) {
                var obj = this.domains[domain];
                return obj ? TDev.Util.values(obj) : [];
            };
            ClientSession.prototype.add_item_to_index = function (item) {
                var obj = this.domains[item.definition];
                if (!obj)
                    obj = this.domains[item.definition] = {};
                obj[item.target()] = item;
            };
            ClientSession.prototype.remove_item_from_index = function (item) {
                var obj = this.domains[item.definition];
                if (obj)
                    delete obj[item.target()];
            };
            ClientSession.prototype.get_lvals_for_indexdomain = function (indexdomain) {
                var obj = this.properties[indexdomain];
                if (obj)
                    return TDev.Util.values(obj);
                else
                    return [];
            };
            ClientSession.prototype.add_lval_to_index = function (lval) {
                var obj = this.properties[lval.indexdomain];
                if (!obj)
                    obj = this.properties[lval.indexdomain] = {};
                obj[lval.target()] = lval;
            };
            ClientSession.prototype.remove_lval_from_index = function (lval) {
                var obj = this.properties[lval.indexdomain];
                if (obj)
                    delete obj[lval.target()];
            };
            ClientSession.prototype.user_unlink = function () {
                for (var p in this.data) {
                    var o = this.data[p];
                    if (o.backlink) {
                        o.backlink.unlink();
                        o.backlink = undefined;
                    }
                }
            };
            ClientSession.prototype.checkinvariants = function () {
                var _this = this;
                return;
                this.all_layers().forEach(function (l) {
                    l.data.forEach(function (d) {
                        TDev.Util.assert(_this.get_datum(d.target()) === d);
                    });
                });
            };
            ClientSession.prototype.user_dump_stable_data = function (assert) {
                var _this = this;
                var result = new Array();
                assert(this.loaded);
                this.checkinvariants();
                var count1 = 0;
                for (var x in TDev.Util.values(this.data)) {
                    if (x instanceof Datum) {
                        var ops = x.all_ops();
                        if (ops.length !== 0) {
                            assert(ops.length === 1);
                            assert(ops[0] === "B");
                            count1 += 1;
                        }
                    }
                }
                var basedata = this.get_layer("B").data;
                var count2 = 0;
                basedata.forEach(function (d) {
                    var op = d.getOperation("B");
                    var p;
                    if (op !== undefined) {
                        if (d instanceof Item) {
                            if (op[0] === "C")
                                p = Packet.MakeNewPacket(d.definition, d.uid, d.ukeys, d.lkeys, (op.length === 1) ? undefined : Number(op.substr(1)));
                            else {
                                TDev.Util.assert(op === "D");
                                p = Packet.MakeDelPacket(d.uid);
                            }
                        }
                        else if (d instanceof LVal && (op !== undefined)) {
                            p = Packet.MakeModPacket(d.definition, op, d.ukeys, d.lkeys, _this.astencoding);
                        }
                        result.push(p.toString());
                        count2 += 1;
                    }
                });
                assert(count1 === count2);
                return result;
            };
            ClientSession.prototype.initialize_data = function () {
                this.data = {};
                this.domains = {};
                this.properties = {};
                this.layers = {
                    "B": new Layer(this, "B", new Array(), 0, 0, true)
                };
            };
            ClientSession.prototype.create_layer = function (name, clientround, serverround) {
                TDev.Util.assert(!this.layers[name]);
                var l = new Layer(this, name, new Array(), clientround, serverround, false);
                this.layers[name] = l;
                if (clientround === 1 && serverround === undefined && this.servername === "")
                    l.grounded = true;
                return l;
            };
            ClientSession.prototype.get_layer = function (s) {
                return this.layers[s];
            };
            ClientSession.prototype.collapse_layers = function (firstname, secondname, keepsecond) {
                var _this = this;
                var first = this.layers[firstname];
                var second = this.layers[secondname];
                TDev.Util.assert(first && second);
                var changed = false;
                var observable = (firstname === "B" && secondname === "S");
                if (second.grounded) {
                    changed = first.clear();
                    if (observable)
                        first.invalidate_all();
                }
                if ((first.serverround === undefined) || first.serverround < second.serverround) {
                    changed = true;
                    first.serverround = second.serverround;
                }
                if ((first.clientround === undefined) || first.clientround < second.clientround) {
                    changed = true;
                    first.clientround = second.clientround;
                }
                second.data.forEach(function (d) {
                    var secondop = d.getOperation(second.name);
                    if (!keepsecond) {
                        d.removeOperation(second);
                    }
                    if (d.recordOperation(first, secondop)) {
                        changed = true;
                        if (observable) {
                            if (d instanceof Item) {
                                var item = d;
                                d.invalidate(secondop === "D");
                                if (secondop && secondop[0] === "C")
                                    _this.add_item_to_index(item);
                            }
                            else {
                                TDev.Util.assert(d instanceof LVal);
                                d.invalidate(false);
                                if (secondop !== undefined)
                                    _this.add_lval_to_index(d);
                            }
                        }
                    }
                });
                if (second.grounded)
                    first.grounded = true;
                if (!keepsecond) {
                    delete this.layers[second.name];
                }
                return changed;
            };
            ClientSession.prototype.delete_layer = function (s, assertexists) {
                var l = this.layers[s];
                if (assertexists)
                    TDev.Util.assert(l);
                else if (l === undefined)
                    return false;
                var changes = l.clear();
                delete this.layers[s];
                return changes;
            };
            ClientSession.prototype.all_layers = function () {
                return TDev.Util.values(this.layers);
            };
            ClientSession.prototype.logLayers = function () {
                var layers = this.all_layers();
                for (var i = 0; i < layers.length; i++) {
                    var layer = layers[i];
                    this.log(TDev.Util.fmt("Layer {0} (s:{1}/c:{2})", layer.name, layer.serverround, layer.clientround));
                }
            };
            ClientSession.prototype.unsent_changes = function () {
                var locallayer = this.get_layer("D" + this.localround);
                return locallayer && locallayer.hasData();
            };
            ClientSession.prototype.dependency_is_gone = function (d, layer) {
                var _this = this;
                if (d.ukeys.some(function (uid) { return _this.uid_is_gone(uid, layer); })) {
                    d.removeOperation(layer);
                    return true;
                }
                return false;
            };
            ClientSession.prototype.item_is_gone = function (i, layer) {
                var op = i.getOperation(layer.name);
                if (op === undefined)
                    return true;
                if (op === "D") {
                    i.removeOperation(layer);
                    return true;
                }
                return this.dependency_is_gone(i, layer);
            };
            ClientSession.prototype.uid_is_gone = function (uid, layer) {
                var i = this.get_item(uid);
                if (!i)
                    return true;
                return this.item_is_gone(i, layer);
            };
            ClientSession.prototype.forEachValidDatum = function (layer, fn) {
                var _this = this;
                layer.data.forEach(function (d) {
                    var op = d.getOperation(layer.name);
                    if (op === undefined || (layer.grounded && (d instanceof Item && _this.item_is_gone(d, layer) || _this.dependency_is_gone(d, layer))))
                        return;
                    fn(d, op);
                });
            };
            ClientSession.prototype.EncodeLayer = function (layer, mode, socket) {
                var _this = this;
                var includeCloudEffects = (mode != 2 /* CLIENT_LAYER_TO_SERVER */ && mode != 5 /* SERVER_UPDATES_TO_CLIENT */);
                var withClientRounds = (mode == 3 /* SERVER_BASE_TO_DISK */);
                var packets = new Array();
                var comp = socket && socket.channelCompressor;
                if (layer.grounded) {
                    packets.push(Packet.MakeCldStarPacket(comp));
                }
                layer.data.forEach(function (d) {
                    if (mode == 4 /* SERVER_LAYER_TO_CLIENT */) {
                        if (!socket.keyset.contains_and_clr(d.target()))
                            return;
                    }
                    else if (mode == 5 /* SERVER_UPDATES_TO_CLIENT */) {
                        if (!socket.keyset.is_unsent_and_clr(d.target()))
                            return;
                    }
                    var op = d.getOperation(layer.name);
                    if (op !== undefined) {
                        if (layer.grounded && (d instanceof Item && _this.item_is_gone(d, layer) || _this.dependency_is_gone(d, layer))) {
                        }
                        else {
                            if (d.fromCloudOp && !includeCloudEffects)
                                return;
                            var p;
                            if (d instanceof Item) {
                                if (op[0] === "C") {
                                    p = Packet.MakeNewPacket(d.definition, d.uid, d.ukeys, d.lkeys, (op.length == 1) ? undefined : Number(op.substr(1)), comp);
                                }
                                else {
                                    _this.assertConsistency(op === "D" && !layer.grounded);
                                    p = Packet.MakeDelPacket(d.uid);
                                }
                            }
                            else if (d instanceof LVal) {
                                p = Packet.MakeModPacket(d.definition, op, d.ukeys, d.lkeys, _this.astencoding, comp);
                            }
                            p.fromCloudOp = d.fromCloudOp;
                            packets.push(p);
                        }
                    }
                });
                if (this.sendCloudOperations && layer.cloudOperations !== undefined) {
                    layer.cloudOperations.forEach(function (op) {
                        if (op.optype == 1 /* RPC */ && mode == 0 /* CLIENT_LAYER_TO_DISK */)
                            return;
                        var p = Packet.MakeCopPacket(op.libName + "/" + op.actionName, op.args, op.opid, op.uidcountstart, op.uidcountstop);
                        packets.push(p);
                    });
                }
                packets.push(Packet.MakeFramePacket(layer, withClientRounds));
                return packets;
            };
            ClientSession.MakeModTarget = function (definition, ukeys, lkeys) {
                var s = (definition ? Parser.WriteComboString(definition) : "");
                ukeys.forEach(function (uid) {
                    s = s + "|" + uid;
                });
                lkeys.forEach(function (lit) {
                    s = s + "|+" + Parser.WriteComboString(lit);
                });
                return s;
            };
            ClientSession.ParseModTarget = function (s, datum) {
                var c = (new Parser(s, 0)).ParseComboComponents();
                datum.definition = c[0];
                datum.ukeys = new Array();
                datum.lkeys = new Array();
                for (var i = 2; i < c.length; i++) {
                    var s = c[i];
                    if (s.charAt(0) === "+")
                        datum.lkeys.push(s.slice(1));
                    else
                        datum.ukeys.push(s);
                }
            };
            ClientSession.prototype.isFaulted = function () {
                return this.faulted;
            };
            ClientSession.prototype.isMarooned = function () {
                return this.marooned;
            };
            ClientSession.prototype.isClosed = function () {
                return this.closed;
            };
            ClientSession.prototype.stopAsync = function () {
                return TDev.Promise.as();
            };
            ClientSession.prototype.send_layer = function (layer) {
                var _this = this;
                var packets = this.EncodeLayer(layer, 2 /* CLIENT_LAYER_TO_SERVER */, this.ws);
                this.log(TDev.Util.fmt("Sending {0}[{1},{2}]", layer.name, layer.clientround, layer.serverround));
                packets.forEach(function (p) { return p.send(_this.ws); });
            };
            ClientSession.prototype.getCloudSession = function () {
                if (!this.cachedsession) {
                    var cs = new TDev.RT.CloudSession();
                    cs._id = this.servername;
                    cs._permissions = this.permissions;
                    cs._title = this.title;
                    cs.sessionimpl = this;
                    if (cs.validate())
                        this.cachedsession = cs;
                }
                return this.cachedsession;
            };
            ClientSession.prototype.loadAsync = function (after_load_task) {
                var _this = this;
                TDev.Util.assert(this.loadtask === undefined && !this.loaded);
                if (!this.localname || this.closed)
                    return (after_load_task ? after_load_task() : TDev.Promise.as());
                var promise = this.LoadFromDiskAsync();
                promise = promise.then(function (success) {
                    if (!_this.closed) {
                        _this.intervalhandle = setInterval(function () {
                            if (!_this.closed && !_this.faulted)
                                _this.SaveAndSend();
                        }, _this.sendinterval);
                        var h = _this.intervalhandle;
                        if (h.unref)
                            h.unref();
                    }
                }, function (error) {
                    _this.faulted = true;
                    _this.initialize_data();
                    _this.statuschanges = true;
                    _this.log("failed to load stored session, error=" + error);
                });
                if (after_load_task)
                    promise = promise.thenalways(function () { return after_load_task(); });
                promise.thenalways(this.doorbell);
                return this.loadtask = promise;
            };
            ClientSession.prototype.LoadFromDiskAsync = function () {
                var _this = this;
                return TDev.Storage.getTableAsync("Sessions").then(function (table) {
                    _this.table = table;
                    var keys = [_this.key_Sstate(), _this.key_Cstate(), _this.key_layer("B")];
                    return table.getItemsAsync(keys).then(function (results) {
                        var S = results[keys[0]];
                        var C = results[keys[1]];
                        var B = results[keys[2]];
                        if (!S) {
                            _this.Sstate_needsave = true;
                            _this.loaded = true;
                            _this.statuschanges = true;
                            if (_this.trace_save_and_load)
                                _this.trace_load();
                            return _this.table.getValueAsync(_this.key_sessionlist()).then(function (val) {
                                var kvpairs = {};
                                kvpairs[_this.key_sessionlist()] = (val || "") + _this.localname + " ";
                                return _this.table.setItemsAsync(kvpairs);
                            });
                        }
                        else {
                            _this.S_fromJSONstring(S);
                            if (C)
                                _this.C_fromJSONstring(C);
                            var baselayer = _this.get_layer("B");
                            if (B) {
                                var packets = JSON.parse(B);
                                packets.forEach(function (p) { return _this.ProcessLoadedPacket(p, baselayer); });
                            }
                            keys = new Array();
                            for (var i = baselayer.clientround + 1; i <= _this.localround; i++)
                                keys.push(_this.key_layer("D" + i));
                            return _this.table.getItemsAsync(keys).then(function (result) {
                                keys.forEach(function (k) {
                                    var packetsjson = result[k];
                                    if (packetsjson) {
                                        var packets = JSON.parse(packetsjson);
                                        var datalayer = _this.create_layer(k.substr(k.indexOf("/") + 1));
                                        datalayer.clientround = Number(k.substr(k.indexOf("/") + 2));
                                        packets.forEach(function (p) { return _this.ProcessLoadedPacket(p, datalayer); });
                                    }
                                    else if (k !== _this.key_layer("D" + _this.localround)) {
                                        baselayer.clientround = baselayer.clientround + 1;
                                    }
                                });
                                _this.loaded = true;
                                _this.statuschanges = true;
                                if (_this.trace_save_and_load)
                                    _this.trace_load();
                            });
                        }
                    });
                });
            };
            ClientSession.prototype.trace_load = function () {
                this.log(TDev.Util.fmt("\Loaded S:\n{0}\nLoaded C:{1}\nLoaded Data:\n{2}", this.S_toJSONstring(), this.C_toJSONstring(), this.EncodeLayer(this.get_layer("B"), 6 /* TRACE_LOAD */).map(function (p) { return p.toString(); }).join("\n")));
            };
            ClientSession.prototype.deleteLocalStorageAsync = function () {
                var _this = this;
                var keystodelete = [this.key_Sstate(), this.key_Cstate(), this.key_layer("B")];
                var baselayer = this.get_layer("B");
                for (var i = baselayer.clientround + 1; i <= this.localround; i++)
                    keystodelete.push(this.key_layer("D" + i));
                var kvpairs = [];
                keystodelete.forEach(function (k) { return kvpairs[k] = undefined; });
                return this.table.getValueAsync(this.key_sessionlist()).then(function (val) {
                    var regexp = new RegExp(_this.localname + " ", 'g');
                    kvpairs[_this.key_sessionlist()] = (val || "").replace(regexp, "");
                    return _this.table.setItemsAsync(kvpairs);
                });
            };
            ClientSession.prototype.try_reconnect_in = function (msec) {
                var _this = this;
                var curws = this.ws;
                var currentTime = new Date();
                this.nexttry = currentTime.getTime() + msec;
                this.statuschanges = true;
                this.retrypending = curws;
                TDev.Util.setTimeout(msec, function () { return _this.user_retry_now(); });
            };
            ClientSession.prototype.user_retry_now = function () {
                if (this.retrypending === this.ws) {
                    this.retrypending = undefined;
                    this.connect(this.url, this.tokensource);
                }
            };
            ClientSession.prototype.connect = function (url, tokensource) {
                var _this = this;
                this.url = url;
                this.tokensource = tokensource;
                TDev.Util.assert(this.servername !== "");
                if (this.enable_sync === undefined) {
                    this.enable_sync = true;
                }
                if (TDev.Cloud.isOffline()) {
                    this.try_reconnect_in(this.connectionretrydelay);
                    return;
                }
                if (!this.enable_sync || this.marooned || this.closed || this.faulted)
                    return;
                var need_fresh_token = this.encountered_token_expiration;
                this.delete_layer("R", false);
                this.delete_layer("S", false);
                this.receivedstatus = false;
                this.last_serverround_received = undefined;
                this.last_clientround_received = undefined;
                this.last_serverround_sent = undefined;
                this.last_clientround_sent = undefined;
                this.encountered_token_expiration = undefined;
                var gotconnection = false;
                this.tokenpromise = this.tokensource(need_fresh_token);
                var ws = new WebSocket(url);
                this.log("connecting to " + url);
                this.ws = ws;
                this.nexttry = 0;
                if (this.dochannelcompression)
                    this.ws.channelCompressor = new ChannelCompressor();
                this.ws.onmessage = function (e) {
                    if (_this.ws !== ws)
                        return;
                    if (_this.trace_incoming_packets)
                        _this.log("receive: " + e.data.replace(/\n/g, " ").substr(0, 300));
                    _this.ReceivePacket(Packet.ParsePacket(e.data, _this.ws));
                };
                this.ws.onopen = function () {
                    if (_this.ws !== ws)
                        return;
                    _this.log("connected to " + url);
                    gotconnection = true;
                    _this.nexttry = undefined;
                    _this.tokenpromise.then(function (token) {
                        if (_this.ws !== ws)
                            return;
                        _this.SendStatusPacket(token);
                    }, function (err) {
                        _this.log("could not get authentication token");
                        if (_this.ws !== ws)
                            return;
                        _this.errorcategory = "offline";
                        _this.error = "could not get authentication token from server";
                        _this.disconnect();
                        _this.try_reconnect_in(_this.connectionretrydelay);
                    }).then(function () {
                        _this.doorbell();
                    });
                };
                this.ws.onclose = function (c) {
                    var retryspeed = 1;
                    if (_this.ws !== ws)
                        return;
                    _this.log("disconnected, code=" + c.code + ", reason=" + c.reason);
                    if (c.code === 1011 || c.code === 1005 || c.code === 1000) {
                        if (c.reason.indexOf("switched server") !== -1 || c.reason.indexOf("member not found") !== -1 || c.reason.indexOf("session salt mismatch") !== -1) {
                            _this.marooned = true;
                        }
                        else if (c.reason.indexOf("connection reset") !== -1) {
                            _this.errorcategory = "connecting";
                            _this.error = "refreshing base value";
                            _this.rebase = true;
                            retryspeed = 10;
                        }
                        else if (c.reason.indexOf("cannot create session") !== -1) {
                            if (_this.membernumber !== -1) {
                                _this.marooned = true;
                            }
                            else if (_this.servername.lastIndexOf(_this.user, 0) !== 0) {
                                _this.errorcategory = "not found";
                                _this.error = "possible causes: spelling error in session id, the owner has not connected to this session yet, the session has been deleted";
                                retryspeed = 2;
                            }
                            else {
                                _this.errorcategory = "not found";
                                _this.error = "cannot create session on server" + c.reason.substr(21);
                                retryspeed = 1;
                            }
                        }
                        else if (c.reason.indexOf("Cannot reconnect: member still connected on existing socket") !== -1) {
                            _this.errorcategory = "connecting";
                            _this.error = "cleaning up old connection";
                            retryspeed = 7;
                        }
                        else if (c.reason.indexOf("access denied: readonly.") !== -1) {
                            _this.errorcategory = "connecting";
                            _this.error = "reconnecting as readonly";
                            _this.readonly = true;
                            retryspeed = 10;
                        }
                        else if (c.reason.indexOf("access denied: ") !== -1) {
                            _this.error = c.reason.substr(15);
                            if (c.reason.indexOf("old script version") !== -1 || c.reason.indexOf("outdated script, must update first") !== -1) {
                                _this.errorcategory = "need update";
                                retryspeed = 0.01;
                            }
                            else
                                _this.errorcategory = "access denied";
                        }
                        else if (c.reason.indexOf("Token Expired") !== -1) {
                            _this.errorcategory = "connecting";
                            _this.error = c.reason;
                            _this.encountered_token_expiration = true;
                            retryspeed = 10;
                        }
                        else if (c.reason.indexOf("failed to migrate session") !== -1 || c.reason.indexOf("Migrating session to new script version") !== -1) {
                            _this.errorcategory = "transitioning";
                            _this.error = "server is migrating session to newer script version";
                            retryspeed = 10;
                        }
                        else if (c.reason.indexOf("reset") !== -1) {
                            _this.errorcategory = "transitioning";
                            _this.error = c.reason;
                            retryspeed = 10;
                        }
                        else if (c.reason.indexOf("server: ") !== -1) {
                            _this.errorcategory = "transitioning";
                            _this.error = c.reason;
                        }
                        else {
                            _this.errorcategory = "not working";
                            _this.error = "server error: " + c.reason;
                        }
                    }
                    else if (c.code === 1006) {
                        _this.errorcategory = "offline";
                        _this.error = gotconnection ? "lost connection to server" : "could not connect to server";
                        retryspeed = gotconnection ? 10 : 1;
                    }
                    else {
                        _this.errorcategory = "not working";
                        _this.error = "websocket error " + c.code + " clean=" + c.wasClean + " reason=" + c.reason;
                    }
                    _this.try_reconnect_in(_this.connectionretrydelay / retryspeed);
                    _this.presence = [];
                    _this.statuschanges = true;
                    _this.doorbell();
                };
            };
            ClientSession.prototype.disconnect = function () {
                var curws = this.ws;
                if (curws !== undefined) {
                    this.ws = undefined;
                    this.nexttry = undefined;
                    curws.close();
                    this.statuschanges = true;
                }
            };
            ClientSession.prototype.finishPendingOperationsAsync = function () {
                var _this = this;
                if (!this.localname || !this.loadtask)
                    return TDev.Promise.as();
                if (this.closetask)
                    return this.closetask;
                return this.loadtask.then(function () { return TDev.Promise.join([
                    _this.last_C_save.then(function (saveok) {
                        _this.SaveAndSend();
                        return _this.last_C_save;
                    }, function (savefailure) {
                        _this.faulted = true;
                        TDev.Util.oops("session save failed... local storage full?");
                    }),
                    _this.last_S_save.then(function (saveok) {
                        _this.MergeAndSaveSB();
                        return _this.last_S_save;
                    }, function (savefailure) {
                        _this.faulted = true;
                        TDev.Util.oops("session save failed... local storage full?");
                    })
                ]); });
            };
            ClientSession.prototype.closeAsync = function (deletelocalstorage) {
                var _this = this;
                this.closed = true;
                var loadfirst = this.loadtask;
                if (this.intervalhandle)
                    clearInterval(this.intervalhandle);
                this.disconnect();
                this.user_unlink();
                if (!loadfirst) {
                    if (deletelocalstorage)
                        return this.closetask = this.deleteLocalStorageAsync();
                    else
                        return this.closetask = TDev.Promise.as();
                }
                if (!(this.localname && deletelocalstorage)) {
                    return this.closetask = loadfirst.then(function () { return _this.finishPendingOperationsAsync(); });
                }
                else {
                    return this.closetask = loadfirst.then(function () { return TDev.Promise.join([_this.last_C_save, _this.last_S_save]).then(function () {
                        return _this.deleteLocalStorageAsync();
                    }); });
                }
            };
            ClientSession.prototype.MergeAndSaveSB = function () {
                var _this = this;
                TDev.Util.assert(this.loaded);
                if (this.faulted)
                    return false;
                var save = false;
                var visiblechanges = false;
                var statuschanges = false;
                var changes = {};
                var layers_to_delete = new Array();
                var serverlayer = this.get_layer("S");
                if (serverlayer) {
                    var newround = serverlayer.clientround;
                    for (var i = newround + 1; i <= this.localround; i++) {
                        var unconfirmedlayer = this.get_layer("D" + i);
                        if (unconfirmedlayer && unconfirmedlayer.grounded)
                            serverlayer.invalidate_all();
                    }
                    if (!this.readblock) {
                        var oldbaseround = this.get_layer("B").clientround;
                        visiblechanges = this.collapse_layers("B", "S");
                        statuschanges = (newround === this.localround - 1);
                        this.get_layer("B").cleanIfNeeded(this.scrublimit);
                        for (var i = oldbaseround + 1; i <= newround; i++) {
                            var datalayer = "D" + i;
                            this.delete_layer(datalayer, true);
                            if (this.localname) {
                                changes[this.key_layer(datalayer)] = undefined;
                                save = true;
                            }
                        }
                    }
                    else {
                        if (serverlayer.serverround >= this.readblock) {
                            serverlayer.grounded = true;
                            this.collapse_layers("B", "S");
                            var oldbaseround = this.get_layer("B").clientround;
                            var newround = serverlayer.clientround;
                            visiblechanges = true;
                            statuschanges = true;
                            for (var i = oldbaseround + 1; i <= newround; i++) {
                                var datalayer = "D" + i;
                                this.delete_layer(datalayer, true);
                                if (this.localname) {
                                    changes[this.key_layer(datalayer)] = undefined;
                                    save = true;
                                }
                            }
                            this.readblock = undefined;
                        }
                    }
                }
                if (this.localname && !this.faulted) {
                    var packets;
                    var baselayer;
                    if (visiblechanges) {
                        changes[this.key_layer("B")] = JSON.stringify(packets = this.EncodeLayer(baselayer = this.get_layer("B"), 1 /* CLIENT_BASE_TO_DISK */));
                        save = true;
                    }
                    if (this.Sstate_needsave) {
                        save = true;
                        this.Sstate_needsave = false;
                    }
                    if (save) {
                        changes[this.key_Sstate()] = this.S_toJSONstring();
                        var savemsg = "(" + (packets ? ("B[" + baselayer.clientround + "," + baselayer.serverround + "]: " + packets.length + " pkts") : "status only") + ")";
                        if (this.trace_saving)
                            this.log("saving merged data " + savemsg);
                        if (this.trace_save_and_load)
                            this.log(TDev.Util.fmt("\nSaving S:\n{0}\nSaving B:\n{1}", changes[this.key_Sstate()], packets ? packets.map(function (p) { return p.toString(); }).join("\n") : "none"));
                        this.last_S_save = this.table.setItemsAsync(changes).then(function (saveok) {
                            if (_this.trace_saving)
                                _this.log("saved merged data " + savemsg);
                            if (_this.ring_doorbell_when_done) {
                                _this.ring_doorbell_when_done = false;
                                _this.last_S_save = TDev.Promise.as();
                                _this.doorbell();
                            }
                        }, function (savefailure) {
                            _this.log("!! failure while saving data " + savemsg);
                            TDev.Util.oops("save failed... local storage full?");
                        });
                    }
                }
                return visiblechanges || statuschanges;
            };
            ClientSession.prototype.SaveAndSend = function () {
                var _this = this;
                TDev.Util.assert(this.loaded);
                if (this.last_C_save._state === 0 /* Pending */)
                    return this.last_C_save;
                if (this.ShouldSend()) {
                    var oldlayer = this.get_layer("D" + this.localround);
                    if (!oldlayer)
                        oldlayer = this.create_layer("D" + this.localround, this.localround);
                    var baselayer = this.get_layer("B");
                    this.localround += 1;
                    var newlayer = this.create_layer("D" + this.localround, this.localround);
                    TDev.Util.check(baselayer.serverround !== undefined, "undefined serverround on baselayer");
                    var serverround = oldlayer.serverround = baselayer.serverround;
                    var clientround = oldlayer.clientround;
                    if (!this.localname) {
                        this.send_layer(oldlayer);
                        return TDev.Promise.as();
                    }
                    else {
                        var curws = this.ws;
                        return this.SaveToDiskAsync([oldlayer, newlayer]).then(function () {
                            if (_this.ws === curws)
                                _this.send_layer(oldlayer);
                        });
                    }
                    this.CLstate_needsave = false;
                }
                else if (this.localname && this.CLstate_needsave) {
                    var locallayer = this.get_layer("D" + this.localround);
                    if (!locallayer)
                        locallayer = this.create_layer("D" + this.localround, this.localround);
                    var promise = this.SaveToDiskAsync([locallayer]);
                    this.CLstate_needsave = false;
                    return promise;
                }
            };
            ClientSession.prototype.cleanOutstandingLayers = function () {
                var blayer = this.get_layer("B");
                var deleted = [];
                for (var i = blayer.clientround + 1; i <= this.localround; i++) {
                    this.delete_layer("D" + i, true);
                    deleted.push("D" + i);
                }
                this.localround = blayer.clientround + 1;
                return deleted;
            };
            ClientSession.prototype.RemoveFromDiskAsync = function (layers) {
                var _this = this;
                var kvpairs = {};
                kvpairs[this.key_Cstate()] = this.C_toJSONstring();
                kvpairs[this.key_Sstate()] = this.S_toJSONstring();
                layers.forEach(function (l) { return kvpairs[_this.key_layer(l)] = undefined; });
                return this.table.setItemsAsync(kvpairs);
            };
            ClientSession.prototype.SaveToDiskAsync = function (layers) {
                var _this = this;
                if (this.faulted)
                    return TDev.Promise.as();
                var kvpairs = {};
                kvpairs[this.key_Cstate()] = this.C_toJSONstring();
                layers.forEach(function (l) {
                    var p = _this.EncodeLayer(l, 0 /* CLIENT_LAYER_TO_DISK */);
                    kvpairs[_this.key_layer(l.name)] = JSON.stringify(p);
                });
                var currentws = this.ws;
                var savemsg = "(" + layers.map(function (l) { return (l.name + "[" + l.clientround + ", " + l.serverround + "]"); }).join("/") + ")";
                if (this.trace_saving)
                    this.log("saving data " + savemsg);
                this.last_C_save = this.table.setItemsAsync(kvpairs).then(function (saveok) {
                    if (_this.ws === currentws)
                        return TDev.Promise.as(currentws);
                    if (_this.trace_saving)
                        _this.log("saved data " + savemsg);
                }, function (savefailure) {
                    _this.log("!! failure while saving data " + savemsg);
                    TDev.Util.oops("save failed... local storage full?");
                    _this.faulted = true;
                });
                return this.last_C_save;
            };
            ClientSession.prototype.ShouldSend = function () {
                var _this = this;
                if (this.faulted)
                    return false;
                if (this.ws === undefined || this.ws.readyState != WebSocket.OPEN || !this.receivedstatus)
                    return false;
                if (this.readonly || this.ws.bufferedAmount != 0)
                    return false;
                var baselayer = this.get_layer("B");
                if (this.writeblock !== undefined) {
                    if (baselayer.serverround < this.writeblock)
                        return false;
                    this.writeblock = undefined;
                    this.statuschanges = true;
                    var newround = this.localround;
                    for (var i = baselayer.clientround + 1; i < newround; i++) {
                        this.send_layer(this.get_layer("D" + i));
                    }
                }
                if (this.localround - baselayer.clientround > this.pendingroundlimit)
                    return false;
                if (!this.unsent_changes() && !this.fences.some(function (f) { return (_this.localround === f.round); }))
                    return false;
                return true;
            };
            ClientSession.prototype.user_issue_fence = function (continuation, exclusive) {
                this.fences.push(new Fence(continuation, this.loaded ? this.localround : 0, exclusive));
                this.user_yield();
            };
            ClientSession.prototype.user_set_doorbell = function (doorbell) {
                this.doorbell = doorbell;
            };
            ClientSession.prototype.user_enable_sync = function (enable) {
                if (enable !== this.enable_sync) {
                    this.enable_sync = enable;
                    if (enable)
                        this.try_reconnect_in(500);
                    else
                        this.disconnect();
                    this.Sstate_needsave = true;
                    this.statuschanges = true;
                    this.doorbell();
                }
            };
            ClientSession.prototype.user_sync_enabled = function () {
                return (this.enable_sync === undefined || this.enable_sync);
            };
            ClientSession.prototype.user_get_next_connection_attempt = function () {
                return (this.marooned || this.closed || this.faulted) ? undefined : this.nexttry;
            };
            ClientSession.prototype.user_get_missing_rounds = function () {
                if (!this.faulted && this.loaded && !this.marooned && !this.closed && this.ws && this.ws.readyState === WebSocket.OPEN && this.receivedstatus) {
                    var baselayer = this.get_layer("B");
                    if (this.readblock)
                        return this.readblock - (this.get_layer("S") ? this.get_layer("S").serverround : 0);
                    else if (this.writeblock)
                        return this.writeblock - baselayer.serverround;
                    else if (this.localround - 1 > baselayer.clientround)
                        return (this.localround - 1 - baselayer.clientround);
                    else if (this.previewround > baselayer.serverround)
                        return (this.previewround - baselayer.serverround);
                    else
                        return this.NumberWaitingRpcs();
                }
                else
                    return 0;
            };
            ClientSession.prototype.user_is_websocket_open = function () {
                return this.ws && this.ws.readyState === WebSocket.OPEN;
            };
            ClientSession.prototype.user_get_percent_full = function () {
                return (this.receivedserverinfo && this.percentfull) || 0;
            };
            ClientSession.prototype.user_get_presence = function () {
                if (!this.presence && this.membernumber !== -1)
                    return [{ userId: this.user, sessionId: this.membernumber }];
                else
                    return this.presence;
            };
            ClientSession.prototype.user_get_connectionstatus = function (include_details) {
                var status = this.user_get_connectionstatus_full();
                if (include_details)
                    return status.status + " (" + status.description + ")";
                else
                    return status.status;
            };
            ClientSession.prototype.user_get_connectionstatus_full = function () {
                var retrymsg = "";
                if (this.faulted) {
                    return {
                        type: 0 /* Error */,
                        status: TDev.lf("not working"),
                        description: TDev.lf("local cache corrupted or storage full")
                    };
                }
                else if (!this.loaded) {
                    return {
                        type: 2 /* Ok */,
                        status: TDev.lf("loading"),
                        description: TDev.lf("retrieving state from local storage")
                    };
                }
                else if (this.marooned) {
                    return {
                        type: 0 /* Error */,
                        status: TDev.lf("isolated"),
                        description: TDev.lf("cloud session was deleted on server")
                    };
                }
                else if (this.closed) {
                    return {
                        type: 0 /* Error */,
                        status: TDev.lf("closed"),
                        description: ""
                    };
                }
                else if (this.ws === undefined) {
                    if (this.enable_sync === false)
                        return {
                            type: 1 /* Warning */,
                            status: TDev.lf("disabled"),
                            description: TDev.lf("sync was disabled on purpose")
                        };
                    else if (TDev.Cloud.isOffline())
                        return {
                            type: 1 /* Warning */,
                            status: TDev.lf("offline"),
                            description: TDev.lf("touch develop is in offline mode{0}", retrymsg)
                        };
                    else {
                        return {
                            type: 0 /* Error */,
                            status: TDev.lf("offline"),
                            description: retrymsg
                        };
                    }
                }
                else if (this.ws.readyState === WebSocket.CONNECTING) {
                    return {
                        type: 1 /* Warning */,
                        status: TDev.lf("connecting"),
                        description: TDev.lf("trying to contact server")
                    };
                }
                else if (this.ws.readyState === WebSocket.OPEN) {
                    var baselayer = this.get_layer("B");
                    if (!this.receivedstatus)
                        return {
                            type: 2 /* Ok */,
                            status: TDev.lf("connecting"),
                            description: TDev.lf("waiting for server connection")
                        };
                    else if (this.readblock)
                        return {
                            type: 2 /* Ok */,
                            status: TDev.lf("connecting"),
                            description: TDev.lf("receiving server data")
                        };
                    else if (this.writeblock)
                        return {
                            type: 2 /* Ok */,
                            status: TDev.lf("connecting"),
                            description: TDev.lf("checking changes on server")
                        };
                    else if (this.localround - 1 > baselayer.clientround)
                        return {
                            type: 2 /* Ok */,
                            status: "connected",
                            description: this.NumberWaitingRpcs() ? TDev.lf(" waiting for server") : TDev.lf(" sending changes")
                        };
                    else if (this.previewround > baselayer.serverround)
                        return {
                            type: 2 /* Ok */,
                            status: TDev.lf("connected"),
                            description: TDev.lf("receiving changes")
                        };
                    else if (this.unsent_changes() || this.get_layer("T"))
                        return {
                            type: 2 /* Ok */,
                            status: TDev.lf("connected"),
                            description: TDev.lf("local changes pending")
                        };
                    else if (this.NumberWaitingRpcs())
                        return {
                            type: 2 /* Ok */,
                            status: TDev.lf("connected"),
                            description: TDev.lf("waiting for server")
                        };
                    else
                        return {
                            type: 2 /* Ok */,
                            status: TDev.lf("connected"),
                            description: ""
                        };
                }
                else
                    return {
                        type: 0 /* Error */,
                        status: this.errorcategory,
                        description: (this.error) ? this.error + retrymsg : ""
                    };
            };
            ClientSession.prototype.NumberWaitingRpcs = function () {
                return 0;
            };
            ClientSession.prototype.user_set_userdata = function (key, val, equals) {
                if (equals === undefined || !equals(this.userdata[key], val)) {
                    this.userdata[key] = val;
                    this.Sstate_needsave = true;
                }
            };
            ClientSession.prototype.user_get_userdata = function (key) {
                return this.userdata[key];
            };
            ClientSession.prototype.user_push = function () {
                if (!this.loaded)
                    return;
                this.checkinvariants();
                var locallayer = this.get_layer("D" + this.localround);
                if (!locallayer)
                    locallayer = this.create_layer("D" + this.localround, this.localround);
                var transactionlayer = this.get_layer("T");
                if (transactionlayer) {
                    var changed = this.collapse_layers(locallayer.name, "T");
                    locallayer.cleanIfNeeded(this.scrublimit);
                    this.CLstate_needsave = this.CLstate_needsave || changed;
                }
                this.SaveAndSend();
                this.checkinvariants();
            };
            ClientSession.prototype.user_yield = function () {
                if (!this.loaded)
                    return;
                this.checkinvariants();
                var statuschanges = this.statuschanges;
                this.statuschanges = false;
                var locallayer = this.get_layer("D" + this.localround);
                if (!locallayer)
                    locallayer = this.create_layer("D" + this.localround, this.localround);
                var transactionlayer = this.get_layer("T");
                if (transactionlayer) {
                    var changed = this.collapse_layers(locallayer.name, "T");
                    locallayer.cleanIfNeeded(this.scrublimit);
                    this.CLstate_needsave = this.CLstate_needsave || changed;
                }
                if (this.last_S_save._state === 0 /* Pending */) {
                    this.ring_doorbell_when_done = true;
                    return false;
                }
                var datachanges = this.MergeAndSaveSB();
                this.SaveAndSend();
                this.checkinvariants();
                if (this.fences.length > 0) {
                    var round = this.get_layer("B").clientround;
                    this.fences = this.fences.filter(function (f) {
                        if (round < f.round)
                            return true;
                        f.continuation();
                        return false;
                    });
                }
                return datachanges || statuschanges;
            };
            ClientSession.prototype.protocolversion = function () {
                return "3.0";
            };
            ClientSession.prototype.SendStatusPacket = function (token) {
                var baselayer = this.get_layer("B");
                var keystring = "";
                if (this.includeKeysInStatus) {
                    var keys = [];
                    this.forEachValidDatum(baselayer, function (datum) { return keys.push(datum.target()); });
                    keystring = keys.join("?").replace("|", "/");
                }
                var p = Packet.MakeStatusPacket(this.protocolversion() + (this.dochannelcompression ? "C" : "") + (this.readonly ? "R" : ""), this.servername, this.membernumber.toString(), this.user, this.title, this.disambiguator, baselayer.clientround.toString(), this.rebase ? "0" : baselayer.serverround.toString(), token, this.script, this.permissions, keystring);
                this.rebase = false;
                this.assertConsistency(this.receivedstatus === false);
                this.assertConsistency(this.last_serverround_sent === undefined);
                this.assertConsistency(this.last_serverround_received === undefined);
                this.assertConsistency(this.last_clientround_sent === undefined);
                this.assertConsistency(this.last_clientround_received === undefined);
                p.send(this.ws);
            };
            ClientSession.prototype.ReceivePacket = function (p) {
                if (p.code === "sts") {
                    this.ReceiveStatusPacket(p);
                    this.doorbell();
                }
                else if (p.code === "inf") {
                    this.ReceiveInfoPacket(p);
                    this.doorbell();
                }
                else if (p.code === "frm") {
                    this.ReceiveFramePacket(p);
                    this.doorbell();
                }
                else {
                    var receivelayer = this.get_layer("R") || this.create_layer("R");
                    if (p.code === "new") {
                        p.serveritemcount = this.serveritemcount;
                        this.serveritemcount += 1;
                        this.ProcessNewPacket(p, receivelayer, this.ws.channelCompressor);
                    }
                    else if (p.code === "del") {
                        this.ProcessDelPacket(p, receivelayer);
                    }
                    else if (p.code === "cld") {
                        if (this.ws.channelCompressor)
                            p.definition = this.ws.channelCompressor.InBound(p.definition, p.lkeys);
                        if (p.definition === "*")
                            this.ProcessClearRootPacket(p, receivelayer);
                    }
                    else if (p.code === "clp") {
                        if (this.ws.channelCompressor)
                            p.definition = this.ws.channelCompressor.InBound(p.definition, p.lkeys);
                    }
                    else {
                        TDev.Util.assert(p.code === "mod");
                        this.ProcessModPacket(p, receivelayer, this.ws.channelCompressor);
                    }
                }
            };
            ClientSession.prototype.ProcessLoadedPacket = function (p, l) {
                if (typeof p === "string")
                    p = Packet.ParsePacket(p, this.ws, true);
                if (p.code === "new") {
                    var item = this.ProcessNewPacket(p, l);
                    this.add_item_to_index(item);
                }
                else if (p.code === "del") {
                    var item = this.ProcessDelPacket(p, l);
                    if (item)
                        item.invalidate(true);
                }
                else if (p.code === "mod") {
                    var lval = this.ProcessModPacket(p, l);
                    this.add_lval_to_index(lval);
                }
                else if (p.code === "cld" && p.definition === "*") {
                    this.ProcessClearRootPacket(p, l);
                    if (l.name != "B") {
                        var baselayer = this.get_layer("B");
                        baselayer.invalidate_all();
                        var baseround = baselayer.clientround;
                        var localround = this.localround;
                        for (var i = baselayer.clientround + 1; i < l.clientround; i++) {
                            var datalayer = this.get_layer("D" + i);
                            datalayer && datalayer.invalidate_all();
                        }
                    }
                }
                else if (p.code === "cop") {
                    var json = JSON.parse(p.lkeys[0]);
                    var libName = json.path.split("/")[0];
                    var actionName = json.path.split("/")[1];
                    var cop = {
                        libName: libName,
                        actionName: actionName,
                        paramNames: Object.keys(json.params),
                        returnNames: json.returnNames,
                        args: json.params,
                        opid: json.opid === undefined ? undefined : Number(json.opid),
                        uidcountstart: json.uidcountstart === undefined ? undefined : Number(json.uidcountstart),
                        uidcountstop: json.uidcountstop === undefined ? undefined : Number(json.uidcountstop),
                        optype: json.optype || 0 /* UNKNOWN */
                    };
                    l.CommitCloudOperation(cop);
                }
                else {
                    TDev.Util.assert(p.code === "frm");
                    this.ProcessFramePacket(p, l);
                }
            };
            ClientSession.prototype.ReceiveInfoPacket = function (p) {
                this.receivedserverinfo = true;
                this.previewround = Number(p.lkeys[0]);
                this.percentfull = Number(p.lkeys[1]);
                var userIds = p.lkeys[2].split(",");
                var sessionIds = p.lkeys[3].split(",");
                TDev.Util.assert(userIds.length == sessionIds.length);
                this.presence = userIds.map(function (userId, i) { return ({ userId: userId, sessionId: parseInt(sessionIds[i]) }); });
                this.statuschanges = true;
            };
            ClientSession.prototype.ReceiveStatusPacket = function (p) {
                var version = p.lkeys[0];
                var servername = p.lkeys[1];
                var membernumber = Number(p.lkeys[2]);
                var user = p.lkeys[3];
                var description = p.lkeys[4];
                var disambiguator = p.lkeys[5];
                var curserverround = Number(p.lkeys[6]);
                var serverround = Number(p.lkeys[7]);
                var token = p.lkeys[8];
                var script = p.lkeys[9];
                var permissions = p.lkeys[10];
                var clientUserId = p.lkeys[11];
                this.clientUserId = clientUserId;
                if (description)
                    this.title = description;
                this.disambiguator = disambiguator;
                this.permissions = permissions;
                this.statusPacket = p;
                this.previewround = curserverround;
                TDev.Util.assert(version === this.protocolversion());
                TDev.Util.assert(servername === this.servername);
                TDev.Util.assert(this.membernumber === -1 || this.membernumber === membernumber);
                TDev.Util.assert(membernumber > 0);
                this.membernumber = membernumber;
                TDev.Util.assert(user === this.user);
                var baselayer = this.get_layer("B");
                this.assertConsistency(serverround === baselayer.serverround || serverround === 0);
                this.assertConsistency(curserverround >= baselayer.serverround);
                var rebase = (this.receivedstatus);
                this.receivedstatus = true;
                if (rebase) {
                    this.delete_layer("R", false);
                    this.delete_layer("S", false);
                }
                else {
                    this.assertConsistency(this.last_clientround_received === undefined);
                }
                this.last_serverround_received = serverround;
                this.last_clientround_received = 0;
                if (rebase || (serverround < baselayer.serverround))
                    this.readblock = curserverround;
                if (!rebase && (baselayer.clientround < this.localround - 1))
                    this.writeblock = curserverround;
                this.statuschanges = true;
                this.Sstate_needsave = true;
            };
            ClientSession.prototype.ReceiveFramePacket = function (p) {
                var clientround = Number(p.lkeys[0]);
                var serverround = Number(p.lkeys[1]);
                this.assertConsistency(this.receivedstatus);
                this.assertConsistency(serverround > this.last_serverround_received || this.acceptsUpdates);
                this.assertConsistency(clientround >= this.last_clientround_received);
                this.assertConsistency((!this.last_serverround_sent) || serverround > this.last_serverround_sent || this.acceptsUpdates);
                this.assertConsistency((!this.last_clientround_sent) || clientround <= this.last_clientround_sent);
                this.last_clientround_received = clientround;
                this.last_serverround_received = serverround;
                var baselayer = this.get_layer("B");
                this.assertConsistency(serverround >= baselayer.serverround || this.acceptsUpdates);
                this.assertConsistency(clientround >= baselayer.clientround);
                var serverlayer = this.get_layer("S") || this.create_layer("S", clientround, serverround);
                this.assertConsistency(serverround >= serverlayer.serverround || this.acceptsUpdates);
                this.assertConsistency(clientround >= serverlayer.clientround);
                var receivelayer = this.get_layer("R");
                if (receivelayer)
                    this.collapse_layers("S", "R");
                this.get_layer("S").cleanIfNeeded(this.scrublimit);
                serverlayer.serverround = serverround;
                serverlayer.clientround = clientround;
                if (this.fences.some(function (f) { return f.exclusive; })) {
                    this.user_yield();
                }
            };
            ClientSession.prototype.ProcessFramePacket = function (p, layer) {
                layer.clientround = Number(p.lkeys[0]);
                layer.serverround = p.lkeys[1] == "" ? undefined : Number(p.lkeys[1]);
                if (p.lkeys[2]) {
                    var x = layer.clientrounds = {};
                    p.lkeys[2].split(",").forEach(function (s) {
                        var pair = s.split(":");
                        x[Number(pair[0])] = Number(pair[1]);
                    });
                }
            };
            ClientSession.prototype.ProcessNewPacket = function (p, layer, comp) {
                var uid = p.ukeys.shift();
                var ukeys = p.ukeys;
                var lkeys = p.lkeys;
                var fromCloudOp = p.fromCloudOp;
                var definition = comp ? comp.InBound(p.definition, lkeys) : p.definition;
                var entry = this.get_item(uid);
                if (!entry) {
                    entry = new Item();
                    entry.session = this;
                    entry.definition = definition;
                    entry.uid = uid;
                    entry.ukeys = ukeys;
                    entry.lkeys = lkeys;
                    entry.linkDeps();
                    entry.fromCloudOp = fromCloudOp;
                    this.add_item(entry);
                }
                else {
                    this.assertConsistency(entry.uid === uid);
                    this.assertConsistency(entry.definition === definition);
                    this.assertConsistency(ukeys.length === entry.ukeys.length);
                    for (var i = 0; i < ukeys.length; i++)
                        this.assertConsistency(ukeys[i] === entry.ukeys[i]);
                    this.assertConsistency(lkeys.length === entry.lkeys.length);
                    for (var i = 0; i < lkeys.length; i++)
                        this.assertConsistency(lkeys[i] === entry.lkeys[i]);
                }
                this.assertConsistency((uid.indexOf(".") !== -1) || (Number(uid) <= this.uidcount));
                entry.recordCreation(layer, p.serveritemcount);
                return entry;
            };
            ClientSession.prototype.ProcessDelPacket = function (p, layer) {
                var uid = p.ukeys[0];
                var entry = this.get_item(uid);
                if (entry) {
                    this.assertConsistency(entry.uid === uid);
                    entry.recordDeletion(layer);
                }
                return entry;
            };
            ClientSession.prototype.ProcessModPacket = function (p, layer, comp, member) {
                var ukeys = p.ukeys;
                var lkeys = p.lkeys;
                var definition = comp ? comp.InBound(p.definition, lkeys) : p.definition;
                var fromCloudOp = p.fromCloudOp;
                var op = lkeys.pop();
                if (op.lastIndexOf("^#", 0) === 0) {
                    var c = (new Parser(op.substr(2), 0)).ParseComboComponents();
                    op = c.map(function (code) { return comp ? comp.InBound(code, lkeys) : code; });
                    if (this.astencoding)
                        op = this.astencoding.fromstrings(op);
                }
                var target = ClientSession.MakeModTarget(definition, ukeys, lkeys);
                var lval = this.get_lval(target);
                if (!lval) {
                    lval = new LVal();
                    lval.session = this;
                    lval.definition = definition;
                    lval.ukeys = ukeys;
                    lval.lkeys = lkeys;
                    lval.parseDefinition();
                    lval.entry = this.user_get_entry(lval.indexdomain, ukeys, lkeys);
                    lval.linkDeps();
                    lval.fromCloudOp = fromCloudOp;
                    this.add_lval(lval);
                }
                else {
                    this.assertConsistency(lval.definition === definition);
                    this.assertConsistency(ukeys.length === lval.ukeys.length);
                    for (var i = 0; i < ukeys.length; i++)
                        this.assertConsistency(ukeys[i] === lval.ukeys[i]);
                    this.assertConsistency(lkeys.length === lval.lkeys.length);
                    for (var i = 0; i < lkeys.length; i++)
                        this.assertConsistency(lkeys[i] === lval.lkeys[i]);
                }
                if (member !== undefined && lval.codomain.indexOf("^") === 0) {
                    if (op.indexOf(".") !== 0) {
                        op = member + "." + op;
                    }
                }
                lval.recordOperation(layer, op);
                return lval;
            };
            ClientSession.prototype.ProcessClearRootPacket = function (p, layer) {
                TDev.Util.assert(p.code === "cld" && p.definition === "*");
                layer.grounded = true;
            };
            return ClientSession;
        })();
        Revisions.ClientSession = ClientSession;
        var NodeSession = (function (_super) {
            __extends(NodeSession, _super);
            function NodeSession(nodeserver, servername, localname, user) {
                _super.call(this, servername, localname, user);
                this.returnMap = {};
                this.sendCloudOperations = true;
                this.includeKeysInStatus = true;
                this.acceptsUpdates = true;
                this.requiresAuth = false;
                this.recording = null;
                TDev.Util.assert(!!nodeserver);
                this.nodeserver = nodeserver;
            }
            NodeSession.prototype.hasNodeConnection = function () {
                return this.ws !== undefined && this.ws.readyState === WebSocket.OPEN;
            };
            NodeSession.prototype.stopAsync = function () {
                this.disconnect();
                return TDev.Promise.as();
            };
            NodeSession.prototype.ReceivePacket = function (p) {
                if (p.code === 'rpc') {
                    this.ReceiveOperation(p);
                    this.doorbell();
                }
                else {
                    return _super.prototype.ReceivePacket.call(this, p);
                }
            };
            NodeSession.prototype.user_start_cloud_operation = function (libName, actionName, paramNames, returnNames, args, optype) {
                TDev.Util.assert(this.recording == null);
                TDev.Util.assert(this.recordinground == null);
                TDev.Util.assert(optype == 2 /* OFFLINE */);
                this.log("start recording operation: " + actionName);
                var script = TDev.Runtime.theRuntime.compiled.libScripts[libName];
                this.recording = {
                    libName: libName,
                    actionName: actionName,
                    paramNames: paramNames,
                    returnNames: returnNames,
                    uidcountstart: this.uidcount,
                    args: args,
                    optype: optype
                };
                this.recordinground = this.localround;
            };
            NodeSession.prototype.user_stop_cloud_operation = function (libName, actionName, paramNames, returnNames, args) {
                TDev.Util.assert(this.recording.libName == libName);
                TDev.Util.assert(this.recording.actionName == actionName);
                TDev.Util.assert(this.recording.paramNames == paramNames);
                TDev.Util.assert(this.recording.returnNames == returnNames);
                TDev.Util.assert(this.recording.args == args);
                TDev.Util.assert(this.recordinground == this.localround);
                this.log("done recording operation: " + actionName);
                var tlayer = this.get_layer("T") || this.create_layer("T");
                this.recording.uidcountstop = this.uidcount;
                tlayer.CommitCloudOperation(this.recording);
                this.recording = null;
                this.recordinground = null;
            };
            NodeSession.prototype.user_rpc_cloud_operation = function (libName, actionName, paramNames, returnNames, args) {
                this.log("record rpc operation: " + actionName);
                var promise = new TDev.PromiseInv();
                var script = TDev.Runtime.theRuntime.compiled.libScripts[libName];
                var tlayer = this.get_layer("T") || this.create_layer("T");
                this.uidcount += 1;
                var opid = this.uidcount;
                this.returnMap[opid] = promise;
                var cop = {
                    libName: libName,
                    actionName: actionName,
                    paramNames: paramNames,
                    returnNames: returnNames,
                    args: args,
                    opid: opid,
                    optype: 1 /* RPC */
                };
                tlayer.CommitCloudOperation(cop);
                this.user_yield();
                return promise;
            };
            NodeSession.prototype.NumberWaitingRpcs = function () {
                return Object.keys(this.returnMap).length;
            };
            NodeSession.prototype.ReceiveOperation = function (p) {
                var _this = this;
                var json = JSON.parse(p.lkeys[0]);
                var opid = Number(json.opid);
                var res = json.params;
                var path = json.path;
                if (path === "err") {
                    this.RemoveFromDiskAsync(this.cleanOutstandingLayers()).thenalways(function () {
                        if (opid === -1 || _this.returnMap[opid] === undefined) {
                            TDev.Runtime.theRuntime.handleException(res, null);
                        }
                        else {
                            _this.returnMap[opid].error(res);
                        }
                    }).done();
                }
                else {
                    if (this.returnMap[opid] !== undefined) {
                        this.returnMap[opid].success(res);
                        delete this.returnMap[opid];
                    }
                }
            };
            NodeSession.prototype.unsent_changes = function () {
                var locallayer = this.get_layer("D" + this.localround);
                if (locallayer && ((locallayer.data.length != 0 || locallayer.grounded) || locallayer.cloudOperations && locallayer.cloudOperations.length > 0))
                    return true;
                return false;
            };
            NodeSession.prototype.collapse_layers = function (firstname, secondname, keepsecond) {
                var l1 = this.get_layer(firstname);
                var l2 = this.get_layer(secondname);
                if (!l1.grounded) {
                    l1.mergeCloudOperations(l2);
                }
                return _super.prototype.collapse_layers.call(this, firstname, secondname, keepsecond);
            };
            return NodeSession;
        })(ClientSession);
        Revisions.NodeSession = NodeSession;
        var ServerSession = (function (_super) {
            __extends(ServerSession, _super);
            function ServerSession(nodeserver, servername, localname, user, rt, wsServer) {
                _super.call(this, nodeserver, servername, localname, user);
                this.rt = rt;
                this.wsServer = wsServer;
                this.sendCloudOperations = false;
                this.concatIdToItem = true;
                this.includeKeysInStatus = false;
                this.requiresAuth = false;
                this.current_membernumber = 0;
                this.membernumber = 0;
                this.disambiguators = {};
                this.schema = {};
                this.full_keys = {};
                this.types = {};
                this.transactionFailed = false;
                this.transactionRunning = false;
            }
            ServerSession.prototype.log = function (msg) {
                TDev.Util.log(msg);
            };
            ServerSession.prototype.user_create_item = function (definition, ukeys, lkeys) {
                var k = new Item();
                k.session = this;
                k.definition = definition;
                TDev.Util.assert(this.loaded || this.faulted);
                if (this.uidcountstart === undefined || this.uidcountstart > this.uidcountstop) {
                    this.uidcount++;
                    var uid = "0." + this.uidcount;
                }
                else {
                    this.uidcountstart++;
                    var uid = this.membernumber + "." + this.uidcountstart;
                }
                k.uid = uid;
                k.ukeys = ukeys;
                k.lkeys = lkeys;
                TDev.Util.assert(!this.get_item(k.uid));
                if (this.readonly) {
                    k.deleted = true;
                    return k;
                }
                k.linkDeps();
                this.add_item(k);
                if (!k.has_deleted_dependencies()) {
                    var transactionlayer = this.get_layer("T") || this.create_layer("T");
                    k.recordCreation(transactionlayer);
                    this.add_item_to_index(k);
                }
                return k;
            };
            ServerSession.prototype.create_layer = function (name, clientround, serverround) {
                if (serverround === undefined) {
                    serverround = clientround;
                }
                return _super.prototype.create_layer.call(this, name, clientround, serverround);
            };
            ServerSession.prototype.get_unsaved_layer = function () {
                var locallayer = this.get_layer("D" + this.localround);
                if (!locallayer)
                    locallayer = this.create_layer("D" + this.localround, this.localround, this.localround);
                return locallayer;
            };
            ServerSession.prototype.collapse_layers = function (first, second, keep_second) {
                var l1 = this.get_layer(first);
                var l2 = this.get_layer(second);
                if (l2.clientrounds !== undefined) {
                    if (l1.clientrounds === undefined) {
                        l1.clientrounds = {};
                    }
                    Object.keys(l2.clientrounds).forEach(function (c) {
                        if (l1.clientrounds[c] !== undefined && l2.clientrounds[c] !== undefined)
                            TDev.Util.assert(l1.clientrounds[c] <= l2.clientrounds[c]);
                        l1.clientrounds[c] = l2.clientrounds[c];
                    });
                }
                return _super.prototype.collapse_layers.call(this, first, second, keep_second);
            };
            ServerSession.prototype.user_start_transaction = function (membernumber, clientRound) {
                var tlayer = this.get_layer("T") || this.create_layer("T");
                if (clientRound !== undefined) {
                    tlayer.clientrounds = {};
                    tlayer.clientrounds[membernumber] = clientRound;
                }
                this.checkinvariants();
                return tlayer;
            };
            ServerSession.prototype.user_end_transaction = function () {
                var tlayer = this.get_layer("T") || this.create_layer("T");
                var unsavedlayer = this.get_unsaved_layer();
                this.collapse_layers(unsavedlayer.name, "T");
                unsavedlayer.cleanIfNeeded(this.scrublimit);
                this.Sstate_needsave = true;
            };
            ServerSession.prototype.user_rollback_transaction = function () {
                var tlayer = this.get_layer("T");
                TDev.Util.assert(tlayer !== undefined, "transaction layer has to be created by user_start_transaction before calling user_rollback_transaction");
                this.delete_layer("T", true);
            };
            ServerSession.prototype.user_yield = function () {
                if (this.transactionRunning)
                    return false;
                return _super.prototype.user_yield.call(this);
            };
            ServerSession.prototype.user_push = function () {
                if (this.transactionRunning)
                    return;
                return _super.prototype.user_push.call(this);
            };
            ServerSession.prototype.MergeAndSaveSB = function () {
                return false;
            };
            ServerSession.prototype.sendLayerToClient = function (layer, socket) {
                var _this = this;
                var packets = this.EncodeLayer(layer, 4 /* SERVER_LAYER_TO_CLIENT */, socket);
                var clientround = (layer.clientrounds && layer.clientrounds[socket.membernumber]) || socket.lastclientroundsent;
                var serverround = layer.serverround;
                this.updateForClient(packets, clientround, socket.membernumber);
                packets.forEach(function (p) { return _this.sendPacketToClient(_this, p, socket); });
                TDev.Util.assert(clientround >= socket.lastclientroundsent);
                TDev.Util.assert(serverround > socket.lastserverroundsent);
                socket.lastclientroundsent = clientround;
                socket.lastserverroundsent = serverround;
            };
            ServerSession.prototype.sendUpdatesToClient = function (socket) {
                var _this = this;
                if (socket.keyset.has_unsent_keys()) {
                    var layer = this.get_layer("B");
                    var packets = this.EncodeLayer(layer, 5 /* SERVER_UPDATES_TO_CLIENT */, socket);
                    if (packets.length > 2) {
                        var clientround = (layer.clientrounds && layer.clientrounds[socket.membernumber]) || socket.lastclientroundsent;
                        TDev.Util.assert(clientround >= socket.lastclientroundsent);
                        this.updateForClient(packets, clientround, socket.membernumber);
                        packets.slice(1).forEach(function (p) { return (p.code !== "cld") ? _this.sendPacketToClient(_this, p, socket) : undefined; });
                    }
                }
            };
            ServerSession.prototype.sendPacketToClient = function (session, p, socket) {
                var s = p.toString();
                session.log(socket.membernumber.toString() + "< " + s);
                socket.send(s);
            };
            ServerSession.prototype.updateForClient = function (packets, clientround, membernumber) {
                var _this = this;
                if (packets.length > 0) {
                    packets[packets.length - 1].lkeys[0] = String(clientround);
                }
                for (var i = 0; i < packets.length - 1; i++) {
                    var packet = packets[i];
                    packet.ukeys = packet.ukeys.map(function (uid) { return _this.filteruid(uid, membernumber); });
                    if (packet.code == "mod" && packet.definition.indexOf("^") !== -1) {
                        var l = packet.lkeys.length - 1;
                        var k = packet.lkeys[l];
                        packet.lkeys[l] = this.filteruid(k, membernumber);
                    }
                }
                return packets;
            };
            ServerSession.prototype.filteruid = function (uid, member) {
                var r = /^\d+/.exec(uid);
                var m = r ? r[0] : undefined;
                if (m === String(member)) {
                    return uid.slice(uid.indexOf(".") + 1);
                }
                else {
                    return uid;
                }
            };
            ServerSession.prototype.update_keysets = function (layer) {
                var _this = this;
                this.forEachValidDatum(layer, function (d, op) {
                    if (d instanceof Item) {
                        if (op[0] === "C") {
                            var def = /^\w+/.exec(d.definition)[0];
                            d.uid;
                            if (_this.types[def].replication === "full") {
                                _this.add_item_to_keysets(d);
                            }
                        }
                        else {
                            TDev.Util.assert(op === "D");
                            TDev.Util.assert(!layer.grounded);
                        }
                    }
                    else if (d instanceof LVal) {
                    }
                });
                this.add_closure_to_keysets();
            };
            ServerSession.prototype.add_item_to_keysets = function (item) {
                this.sockets().forEach(function (s) { return s.keyset.add(item.uid); });
            };
            ServerSession.prototype.add_closure_to_keysets = function () {
                var _this = this;
                this.sockets().forEach(function (s) { return _this.add_closure_to_keyset(s.keyset); });
            };
            ServerSession.prototype.add_closure_to_keyset = function (keyset) {
                var added = true;
                while (added) {
                    added = this.add_closure_to_keyset_it(keyset);
                }
            };
            ServerSession.prototype.add_closure_to_keyset_it = function (keyset) {
                var _this = this;
                keyset.track();
                var blayer = this.get_layer("B");
                this.forEachValidDatum(blayer, function (datum) {
                    if (datum instanceof Item) {
                        var item = datum;
                        if (_this.all_keys_in_keyset(item.ukeys, keyset)) {
                            keyset.add(item.uid);
                        }
                        return;
                    }
                    if (datum instanceof LVal) {
                        var lval = datum;
                        if (/^\w+\[.*\]/.exec(lval.indexdomain)) {
                            if (keyset.contains(lval.lkeys[0])) {
                                _this.add_lval_to_keyset(lval, keyset);
                            }
                            return;
                        }
                        if (/\w+\(.*\)/.exec(lval.indexdomain)) {
                            if (keyset.contains(lval.ukeys[0])) {
                                _this.add_lval_to_keyset(lval, keyset);
                            }
                        }
                        return;
                    }
                    if (datum instanceof Entry) {
                        var entry = datum;
                        if (_this.get_replication_type(entry) === "partial") {
                            if (keyset.contains(entry.lkeys[0])) {
                                if (entry.definition.charAt(entry.definition.length - 1) === "]") {
                                    var types = entry.definition.slice(entry.definition.indexOf("["), entry.definition.lastIndexOf("]")).split(",");
                                    for (var i = 0; i < types.length; i++) {
                                        if (types[i].indexOf("(") !== -1) {
                                            keyset.add(entry.ukeys[i]);
                                        }
                                    }
                                }
                            }
                        }
                        return;
                    }
                    TDev.Util.assert(false);
                });
                return keyset.track();
            };
            ServerSession.prototype.add_lval_to_keyset = function (lval, keyset) {
                var key = lval.target();
                keyset.add(key);
                var datum = this.data[key];
                if (datum instanceof Item) {
                    var item = datum;
                    if (this.all_keys_in_keyset(item.ukeys, keyset)) {
                        keyset.add(item.uid);
                    }
                }
            };
            ServerSession.prototype.all_keys_in_keyset = function (keys, keyset) {
                var _this = this;
                return keys.reduce(function (included, uid) {
                    var item = _this.get_item(uid);
                    return included && (item === undefined || keyset.contains(uid));
                }, true);
            };
            ServerSession.prototype.initializeKeyset = function (socket, keys) {
                var _this = this;
                if (keys.length !== 1 || keys[0] !== "") {
                    keys.forEach(function (k) { return socket.keyset.keys[k] = true; });
                }
                if (socket.clientUserId !== undefined) {
                    socket.keyset.add(socket.clientUserId);
                }
                var blayer = this.get_layer("B");
                this.forEachValidDatum(blayer, function (datum) {
                    if (datum instanceof Item) {
                        var item = datum;
                        if (_this.get_replication_type(item) === "full") {
                            socket.keyset.add(item.uid);
                        }
                    }
                });
                this.add_closure_to_keyset(socket.keyset);
            };
            ServerSession.prototype.addKeysFromLayer = function (layer, keyset) {
                this.forEachValidDatum(layer, function (d) { return keyset.add(d.target()); });
            };
            ServerSession.prototype.setupKeyset = function (socket) {
                socket.keyset = new Keyset(this);
            };
            ServerSession.prototype.getMetaData = function () {
                var _this = this;
                if (this.rt === undefined)
                    return;
                var datas = this.rt.datas;
                Object.keys(datas).forEach(function (d) {
                    var lib = datas[d];
                    Object.keys(lib).forEach(function (n) {
                        if (/^\$\w+/.exec(n)) {
                            var name = n.slice(1);
                            _this.types[name] = { replication: (lib[n] ? lib[n].replication : undefined) };
                        }
                    });
                });
            };
            ServerSession.prototype.get_replication_type = function (datum) {
                var def = /^\w+/.exec(datum.definition);
                if (!def)
                    return undefined;
                var repl = this.types[def[0]];
                if (!repl)
                    return undefined;
                return repl.replication;
            };
            ServerSession.prototype.isOriginAllowed = function (origin) {
                return true;
            };
            ServerSession.prototype.connect = function (url, tokensource) {
                this.url = url;
                if (this.closed || this.faulted)
                    return;
                this.hasPartialData = this.rt.compiled.hasPartialData;
                this.hasLocalData = this.rt.compiled.hasLocalData;
                if (this.rt.compiled.hostCloudData)
                    this.setupWebSockets();
                this.getMetaData();
            };
            ServerSession.prototype.sockets = function () {
                return this.wsServer.connections().filter(function (c) { return c.isTdWebSocket; });
            };
            ServerSession.prototype.setupWebSockets = function () {
                var _this = this;
                this.log('setting up websockets server');
                this.wsServer.addHandler(function (request, next) {
                    if (request.path() != "/") {
                        next();
                        return;
                    }
                    if (!_this.isOriginAllowed(request.origin())) {
                        request.reject();
                        _this.log(TDev.Util.fmt("WebSocket connection from {0} rejected", request.origin()));
                        return;
                    }
                    _this.log(TDev.Util.fmt("WS request from {0}", request.origin()));
                    var socket = request.accept();
                    socket.isTdWebSocket = true;
                    _this.log(TDev.Util.fmt("accepted socket {0}", request.remoteAddress()));
                    var buffer = [];
                    var receivedStatus = false;
                    _this.setupKeyset(socket);
                    request.onMessage(function (str, buff) {
                        if (buff) {
                            _this.log('ERROR: Received Binary Message of ' + buff.length + ' bytes');
                        }
                        else {
                            _this.log((socket.membernumber || "?") + "> " + str);
                            var p = Packet.ParsePacket(str, socket);
                            if (p.code === "sts") {
                                _this.handleStatusPacket(p, socket);
                                receivedStatus = true;
                                return;
                            }
                            TDev.Util.assert(receivedStatus);
                            if (p.code === "frm") {
                                _this.queuePackets(buffer, p, socket, request, socket.membernumber);
                                buffer = [];
                            }
                            else {
                                buffer.push(p);
                            }
                        }
                    });
                    request.onClose(function (reasonCode, description) {
                        receivedStatus = false;
                        _this.log(' Peer ' + request.remoteAddress() + ' disconnected.');
                    });
                });
            };
            ServerSession.prototype.handleStatusPacket = function (p, socket) {
                var version = p.lkeys[0];
                var servername = p.lkeys[1];
                var membernumber = Number(p.lkeys[2]);
                var user = p.lkeys[3];
                var description = p.lkeys[4];
                var disambiguator = p.lkeys[5];
                var last_clientround = Number(p.lkeys[6]);
                var last_serverround = Number(p.lkeys[7]);
                var token = p.lkeys[8];
                var script = p.lkeys[9];
                var permissions = p.lkeys[10];
                var keysoruser = p.lkeys[11];
                var keys = keysoruser.replace("/", "|").replace(/(^\d+(?!\.))|(\|\d+(?!\.))|(\?\d+(?!\.))/g, function (d) {
                    if (d.indexOf("|") === 0) {
                        return ("|" + p.lkeys[2] + "." + d.slice(1));
                    }
                    else if (d.indexOf("?") === 0) {
                        return ("?" + p.lkeys[2] + "." + d.slice(1));
                    }
                    else {
                        return (p.lkeys[2] + "." + d);
                    }
                }).split("?");
                var rt = TDev.Runtime.theRuntime;
                if (rt.authValidator) {
                    var clientUserId = "";
                    rt.wrapFromHandler(function () {
                        clientUserId = rt.runUserAction(rt.authValidator, [token]);
                        if (clientUserId && !/:/.test(clientUserId))
                            TDev.Util.userError("user id returned from validator has to have a namespace (eg., fb:123456)");
                    });
                    if (!clientUserId) {
                        this.log("invalid authorization attempt");
                    }
                    else {
                        this.log("authorized as " + clientUserId);
                        socket.keyset.add(clientUserId);
                    }
                    p.lkeys[11] = clientUserId;
                    socket.clientUserId = clientUserId;
                }
                if (servername !== Revisions.nodesessionid(this.rt.host.currentGuid)) {
                    return socket.close(1000, "switched script");
                }
                var baselayer = this.get_layer("B");
                var startFrom = 0;
                if (membernumber === -1) {
                    TDev.Util.assert(disambiguator === "");
                    membernumber = ++this.current_membernumber;
                    disambiguator = (+new Date()).toString(36);
                    p.lkeys[5] = disambiguator;
                    p.lkeys[2] = (membernumber).toString();
                    this.disambiguators[membernumber] = disambiguator;
                }
                else {
                    if (membernumber > this.current_membernumber || this.disambiguators[membernumber] !== disambiguator) {
                        return socket.close(1000, "switched server");
                    }
                    if (last_serverround <= baselayer.serverround && this.get_layer("D" + (last_serverround + 1).toString()) && baselayer.clientrounds && baselayer.clientrounds[membernumber] >= last_clientround) {
                        startFrom = last_serverround;
                    }
                }
                p.lkeys[6] = String(baselayer.serverround);
                p.lkeys[7] = String(startFrom);
                socket.membernumber = membernumber;
                this.sendPacketToClient(this, p, socket);
                this.initializeKeyset(socket, keys);
                this.CLstate_needsave = true;
                if (baselayer.serverround === 0) {
                    this.log("Sending Nothing");
                    socket.lastclientroundsent = 0;
                    socket.lastserverroundsent = 0;
                    return;
                }
                if (startFrom === 0) {
                    this.log("Sending Base (" + baselayer.serverround + ")");
                    socket.lastclientroundsent = 0;
                    socket.lastserverroundsent = 0;
                    this.sendLayerToClient(baselayer, socket);
                }
                else {
                    this.log("Sending " + (baselayer.serverround - startFrom).toString() + " Deltas");
                    socket.lastclientroundsent = last_clientround;
                    socket.lastserverroundsent = startFrom;
                    for (var i = startFrom + 1; i <= baselayer.serverround; i++) {
                        var dlayer = this.get_layer("D" + i);
                        this.sendLayerToClient(dlayer, socket);
                    }
                    this.log("Sending Updates");
                    this.sendUpdatesToClient(socket);
                }
            };
            ServerSession.prototype.queuePackets = function (packets, frame, socket, request, membernumber) {
                var _this = this;
                var clientRound = Number(frame.lkeys[0]);
                this.rt.queueAsync(function (rt, args) {
                    _this.user_start_transaction(membernumber, clientRound);
                    _this.transactionRunning = true;
                    _this.membernumber = membernumber;
                });
                packets.forEach(function (p) {
                    if (p.code === "cop") {
                        if (_this.transactionFailed)
                            return;
                        var json = JSON.parse(p.lkeys[0]);
                        var path = json.path;
                        var params = json.params;
                        var opid = json.opid;
                        var optype = json.optype;
                        var uidcountstart = (isNaN(Number(json.uidcountstart))) ? undefined : Number(json.uidcountstart);
                        var uidcountstop = (isNaN(Number(json.uidcountstop))) ? undefined : Number(json.uidcountstoptart);
                        var promise = _this.queueOperation(path, params, request.origin, socket.membernumber, socket, uidcountstart, uidcountstop);
                        promise.then(function (res) {
                            var tlayer = _this.get_layer("T") || _this.create_layer("T");
                            tlayer.CommitCloudOperation({
                                libName: path.split("/")[0],
                                actionName: path.split("/")[1],
                                paramNames: Object.keys(params),
                                returnNames: [],
                                args: [],
                                optype: optype,
                                opid: opid,
                                res: res,
                                socket: socket
                            });
                        }, function (err) {
                            _this.sendError(opid, err, socket);
                        });
                    }
                    else {
                        _this.rt.queueAsync(function (rt, args) {
                            var tlayer = _this.get_layer("T") || _this.create_layer("T");
                            var key = _this.handleCloudPacket(p, tlayer, request, socket);
                        });
                    }
                });
                this.rt.queueAsync(function (rt, args) {
                    _this.membernumber = 0;
                    if (_this.transactionFailed) {
                        _this.user_rollback_transaction();
                        _this.transactionFailed = false;
                    }
                    else {
                        _this.addKeysFromLayer(_this.get_layer("T"), socket.keyset);
                        _this.user_end_transaction();
                        _this.log("finished handling cloud request");
                        _this.SaveAndSend();
                    }
                    _this.transactionRunning = false;
                });
            };
            ServerSession.prototype.queueOperation = function (path, params, host, membernumber, socket, uidcountstart, uidcountstop) {
                var _this = this;
                var promiseInv = new TDev.PromiseInv();
                var req = {
                    method: "WS",
                    headers: { host: host.replace(/^[a-z]+:\/\//, "") },
                    url: "/api/" + path,
                    body: params,
                    connection: socket,
                    tdQueryString: {},
                };
                var sReq = TDev.RT.ServerRequest.mk(req, promiseInv);
                if (socket.clientUserId)
                    sReq._user = TDev.RT.User.mk(socket.clientUserId);
                sReq.setJsonBody(params);
                sReq._api_path = path;
                this.currentOp = promiseInv;
                promiseInv.thenalways(function () {
                    if (_this.currentOp === promiseInv) {
                        _this.currentOp = undefined;
                    }
                });
                this.rt.queueAsync(function (rt, args) {
                    _this.membernumber = membernumber;
                    _this.uidcountstart = uidcountstart;
                    _this.uidcountstop = uidcountstop;
                });
                var promise = this.rt.dispatchServerRequest(sReq, promiseInv);
                this.rt.queueAsync(function (rt, args) {
                    _this.membernumber = 0;
                    _this.uidcountstart = undefined;
                    _this.uidcountstop = undefined;
                });
                return promise;
            };
            ServerSession.prototype.abortCurrentTransaction = function (bug) {
                if (this.currentOp != undefined) {
                    this.currentOp.error(bug);
                    this.transactionFailed = true;
                    this.log("rolled back transaction because of error");
                }
                this.log(bug.exceptionMessage);
            };
            ServerSession.prototype.handleCloudPacket = function (p, layer, request, socket) {
                TDev.Util.assert(layer !== undefined);
                this.completeIds(p, layer, socket.membernumber);
                if (p.code === "new") {
                    this.log("Handling new effect");
                    p.serveritemcount = this.serveritemcount;
                    this.serveritemcount += 1;
                    var entry = this.ProcessNewPacket(p, layer);
                    return entry.uid;
                }
                else if (p.code === "del") {
                    this.log("Handling del effect");
                    this.ProcessDelPacket(p, layer);
                }
                else if (p.code === "cld") {
                    this.log("Handling cld effect");
                    if (p.definition === "*")
                        this.ProcessClearRootPacket(p, layer);
                }
                else if (p.code === "clp") {
                    this.log("Handling clp effect");
                }
                else {
                    TDev.Util.assert(p.code === "mod");
                    this.log("Handling mod effect");
                    var lval = this.ProcessModPacket(p, layer, undefined, socket.membernumber);
                    return lval.target();
                }
                return undefined;
            };
            ServerSession.prototype.completeIds = function (p, layer, membernumber) {
                p.ukeys.forEach(function (uid) {
                    var uid = p.ukeys[0];
                    if (uid.indexOf(".") === -1) {
                        p.ukeys[0] = String(membernumber) + "." + uid;
                    }
                });
            };
            ServerSession.prototype.sendResults = function (layer) {
                var _this = this;
                if (layer.cloudOperations !== undefined) {
                    layer.cloudOperations.forEach(function (cop) {
                        if (cop.opid !== undefined) {
                            TDev.Util.assert(cop.socket !== undefined);
                            TDev.Util.assert(cop.res !== undefined);
                            _this.sendResult(cop.opid, cop.res, cop.socket);
                        }
                    });
                }
            };
            ServerSession.prototype.sendResult = function (opid, res, socket) {
                var p = Packet.MakeRpcPacket("", res, opid);
                socket.send(p.toString());
            };
            ServerSession.prototype.sendError = function (opid, err, socket) {
                var p = Packet.MakeRpcPacket("err", err, opid);
                socket.send(p.toString());
            };
            ServerSession.prototype.SaveAndSend = function (serverround) {
                var _this = this;
                TDev.Util.assert(this.loaded);
                var promise = TDev.Promise.as();
                if (serverround !== undefined && this.localround > serverround) {
                    return this.last_C_save;
                }
                if (this.last_C_save._state === 0 /* Pending */) {
                    return this.last_C_save.then(function () { return _this.SaveAndSend(serverround); });
                }
                var ulayer = this.get_layer("D" + this.localround);
                if (ulayer && ulayer.hasData()) {
                    var oldlayer = this.get_unsaved_layer();
                    var baselayer = this.get_layer("B");
                    this.localround += 1;
                    var newlayer = this.create_layer("D" + this.localround, this.localround, this.localround);
                    this.collapse_layers("B", oldlayer.name, true);
                    this.last_C_save = this.SaveToDiskAsync().then(function () {
                        _this.update_keysets(oldlayer);
                        _this.log("Broadcasting Layer " + oldlayer.name);
                        _this.sockets().forEach(function (s) {
                            if (s.lastserverroundsent < oldlayer.serverround) {
                                TDev.Util.assert(s.lastserverroundsent == oldlayer.serverround - 1);
                                _this.sendLayerToClient(oldlayer, s);
                            }
                            else
                                TDev.Util.assert(s.lastserverroundsent == oldlayer.serverround);
                        });
                        _this.log("Sending Updates");
                        _this.sockets().forEach(function (s) { return _this.sendUpdatesToClient(s); });
                        _this.sendResults(oldlayer);
                        oldlayer.removeCloudOperations();
                    });
                    promise = this.last_C_save;
                    this.CLstate_needsave = false;
                }
                else if (this.CLstate_needsave) {
                    promise = this.SaveToDiskAsync();
                    this.CLstate_needsave = false;
                    return promise;
                }
                return promise;
            };
            ServerSession.prototype.S_toJSONstring = function () {
                return JSON.stringify({
                    uidcount: this.uidcount,
                    localround: this.localround,
                    disambiguators: this.disambiguators,
                    current_membernumber: this.current_membernumber
                });
            };
            ServerSession.prototype.S_fromJSONstring = function (s) {
                var json = JSON.parse(s);
                this.uidcount = json.uidcount;
                this.disambiguators = json.disambiguators || {};
                this.localround = json.localround;
                this.current_membernumber = json.current_membernumber;
            };
            ServerSession.prototype.SaveToDiskAsync = function () {
                var _this = this;
                var baselayer = this.get_layer("B");
                var kvpairs = {};
                kvpairs[this.key_Sstate()] = this.S_toJSONstring();
                var packets = this.EncodeLayer(baselayer, 3 /* SERVER_BASE_TO_DISK */);
                kvpairs[this.key_layer("B")] = JSON.stringify(packets);
                this.log("saving state...");
                if (this.trace_save_and_load)
                    this.log(TDev.Util.fmt("\nSaved Metadata:\n{0}\nSaved Data:\n{1}", kvpairs[this.key_Sstate()], packets.map(function (p) { return p.toString(); }).join("\n")));
                this.last_C_save = this.table.setItemsAsync(kvpairs).then(function (saveok) {
                    _this.log("saved state.");
                    return TDev.Promise.as();
                }, function (savefailure) {
                    _this.log("!! failure while saving data ");
                    TDev.Util.oops("save failed... local storage full?");
                    _this.faulted = true;
                    throw savefailure;
                });
                return this.last_C_save;
            };
            ServerSession.prototype.LoadFromDiskAsync = function () {
                var _this = this;
                return TDev.Storage.getTableAsync("Sessions").then(function (table) {
                    _this.table = table;
                    var keys = [_this.key_Sstate(), _this.key_layer("B")];
                    return table.getItemsAsync(keys).then(function (results) {
                        var S = results[keys[0]];
                        var B = results[keys[1]];
                        var baselayer = _this.get_layer("B");
                        if (!S) {
                            _this.Sstate_needsave = true;
                        }
                        else {
                            _this.S_fromJSONstring(S);
                            if (B) {
                                var packets = JSON.parse(B);
                                packets.forEach(function (p) { return _this.ProcessLoadedPacket(p, baselayer); });
                            }
                        }
                        if (baselayer.serverround < _this.localround - 1) {
                            _this.log("Corrupted files - lost " + (_this.localround - baselayer.serverround - 1) + " rounds. ");
                            _this.localround = baselayer.serverround + 1;
                        }
                        _this.loaded = true;
                        _this.statuschanges = true;
                        if (_this.trace_save_and_load)
                            _this.log(TDev.Util.fmt("\Loaded Metadata:\n{0}\nLoaded Data:\n{1}", _this.S_toJSONstring(), _this.EncodeLayer(_this.get_layer("B"), 6 /* TRACE_LOAD */).map(function (p) { return p.toString(); }).join("\n")));
                    });
                });
            };
            ServerSession.prototype.user_sync_enabled = function () {
                throw new Error("Should not be called on the server");
            };
            ServerSession.prototype.user_enable_sync = function (b) {
                throw new Error("Should not be called on the server");
            };
            ServerSession.prototype.user_issue_fence = function (continuation, exclusive) {
                throw new Error("Should not be called on the server");
            };
            ServerSession.prototype.user_get_connectionstatus = function (include_details) {
                throw new Error("Should not be called on the server");
            };
            ServerSession.prototype.user_get_next_connection_attempt = function () {
                throw new Error("Should not be called on the server");
            };
            ServerSession.prototype.user_get_missing_rounds = function () {
                throw new Error("Should not be called on the server");
            };
            ServerSession.prototype.user_is_websocket_open = function () {
                throw new Error("Should not be called on the server");
            };
            ServerSession.prototype.user_retry_now = function () {
                throw new Error("Should not be called on the server");
            };
            ServerSession.prototype.user_get_percent_full = function () {
                throw new Error("Should not be called on the server");
            };
            ServerSession.prototype.isFaulted = function () {
                throw new Error("Should not be called on the server");
            };
            ServerSession.prototype.isClosed = function () {
                throw new Error("Should not be called on the server");
            };
            ServerSession.prototype.isMarooned = function () {
                throw new Error("Should not be called on the server");
            };
            ServerSession.prototype.getCloudSession = function () {
                throw new Error("Should not be called on the server");
            };
            return ServerSession;
        })(NodeSession);
        Revisions.ServerSession = ServerSession;
        var Keyset = (function () {
            function Keyset(session) {
                this.session = session;
                this.keys = {};
                this.delta = {};
            }
            Keyset.prototype.add = function (key) {
                TDev.Util.assert(key !== undefined);
                if (this.keys[key])
                    return;
                this.added = true;
                this.delta[key] = true;
                this.keys[key] = true;
            };
            Keyset.prototype.remove = function (key) {
                delete this.keys[key];
                delete this.delta[key];
            };
            Keyset.prototype.contains = function (key) {
                return this.keys[key] !== undefined;
            };
            Keyset.prototype.contains_and_clr = function (key) {
                var contains = this.contains(key);
                if (contains) {
                    if (this.delta[key] !== undefined) {
                        this.session.log("sending " + key);
                    }
                    delete this.delta[key];
                }
                else {
                    this.session.log(TDev.Util.fmt("Does not contain: {0}", key));
                }
                return contains;
            };
            Keyset.prototype.is_unsent_and_clr = function (key) {
                var is_unsent = this.delta[key] !== undefined;
                if (is_unsent) {
                    this.session.log("send update for " + key);
                    delete this.delta[key];
                }
                return is_unsent;
            };
            Keyset.prototype.has_unsent_keys = function () {
                return Object.keys(this.delta).length > 0;
            };
            Keyset.prototype.key_sent = function (key) {
                delete this.delta[key];
            };
            Keyset.prototype.unsent_keys = function () {
                return this.delta;
            };
            Keyset.prototype.reset_delta = function () {
                this.delta = {};
            };
            Keyset.prototype.track = function () {
                var res = this.added;
                this.added = false;
                return res;
            };
            return Keyset;
        })();
        Revisions.Keyset = Keyset;
        var Packet = (function () {
            function Packet() {
            }
            Packet.MakeStatusPacket = function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i - 0] = arguments[_i];
                }
                var p = new Packet();
                p.code = "sts";
                p.ukeys = [];
                p.lkeys = args;
                return p;
            };
            Packet.MakeNewPacket = function (definition, uid, ukeys, lkeys, serveritemcount, comp) {
                var addedliterals = [];
                var p = new Packet();
                p.code = "new";
                p.ukeys = [uid].concat(ukeys);
                if (comp) {
                    p.lkeys = lkeys.slice(0);
                    p.definition = comp.OutBound(definition, p.lkeys);
                }
                else {
                    p.lkeys = lkeys;
                    p.definition = definition;
                }
                p.serveritemcount = serveritemcount;
                return p;
            };
            Packet.MakeDelPacket = function (uid) {
                var p = new Packet();
                p.code = "del";
                p.ukeys = [uid];
                p.lkeys = [];
                return p;
            };
            Packet.MakeCldStarPacket = function (comp) {
                var p = new Packet();
                p.code = "cld";
                p.ukeys = [];
                p.lkeys = [];
                p.definition = comp ? comp.OutBound("*", p.lkeys) : "*";
                return p;
            };
            Packet.MakeModPacket = function (definition, op, ukeys, lkeys, scheme, comp) {
                var p = new Packet();
                p.code = "mod";
                var addedliterals = [];
                if (typeof (op) !== "string") {
                    TDev.Util.assert(Array.isArray(op));
                    if (scheme)
                        op = scheme.tostrings(op);
                    op = "^#" + op.map(function (s) { return Parser.WriteComboString(comp ? comp.OutBound(s, addedliterals) : s); }).join("|");
                }
                addedliterals.reverse();
                addedliterals.push(op);
                p.definition = comp ? comp.OutBound(definition, addedliterals) : definition;
                p.ukeys = ukeys;
                p.lkeys = lkeys.concat(addedliterals);
                return p;
            };
            Packet.MakeFramePacket = function (layer, withClientRounds) {
                var p = new Packet();
                p.code = "frm";
                p.ukeys = [];
                p.lkeys = [layer.clientround.toString()];
                p.lkeys.push(layer.serverround === undefined ? "" : layer.serverround.toString());
                if (withClientRounds && layer.clientrounds)
                    p.lkeys.push(Object.keys(layer.clientrounds).map(function (c) { return c + ":" + layer.clientrounds[c].toString(); }).join(","));
                return p;
            };
            Packet.MakeCopPacket = function (path, params, opid, uidcountstart, uidcountstop) {
                var json = {
                    path: path,
                    params: params,
                    opid: opid,
                    uidcountstart: uidcountstart,
                    uidcountstop: uidcountstop
                };
                var p = new Packet();
                p.code = "cop";
                p.ukeys = [];
                p.lkeys = [JSON.stringify(json)];
                return p;
            };
            Packet.MakeRpcPacket = function (path, params, opid) {
                var json = {
                    path: path,
                    params: params,
                    opid: opid
                };
                var p = new Packet();
                p.code = "rpc";
                p.ukeys = [];
                p.lkeys = [JSON.stringify(json)];
                return p;
            };
            Packet.ParsePacket = function (from, ws, fromDisk) {
                var p = new Packet();
                var code = from.slice(0, 3);
                var c = (new Parser(from, 0)).ParseComboComponents();
                var i = 0;
                p.code = c[i++];
                p.definition = c[i++];
                if (fromDisk) {
                    p.fromCloudOp = Boolean(c[i++]);
                }
                p.ukeys = new Array();
                p.lkeys = new Array();
                for (; i < c.length; i++) {
                    var s = c[i];
                    var first = s.charAt(0);
                    if (first === "+")
                        p.lkeys.push(s.slice(1));
                    else if (first === "-")
                        p.serveritemcount = Number(s.slice(1));
                    else
                        p.ukeys.push(s);
                }
                return p;
            };
            Packet.prototype.toString = function () {
                var s = this.code + "|" + (this.definition ? Parser.WriteComboString(this.definition) : "");
                this.ukeys.forEach(function (uid) {
                    s = s + "|" + uid;
                });
                this.lkeys.forEach(function (lit) {
                    s = s + "|+" + Parser.WriteComboString(lit);
                });
                if (this.serveritemcount !== undefined)
                    s = s + "|-" + this.serveritemcount;
                return s;
            };
            Packet.prototype.send = function (ws) {
                TDev.Util.check(this.code !== "frm" || this.lkeys[1] !== undefined, "undefined serverround sent frame");
                ws.send(this.toString());
            };
            return Packet;
        })();
        Revisions.Packet = Packet;
        var ChannelCompressor = (function () {
            function ChannelCompressor() {
                this.map = {};
                this.hash = {};
                this.localcount = 0;
            }
            ChannelCompressor.prototype.InBound = function (code, lkeys) {
                TDev.Util.assert(code.length > 0);
                var n;
                var s;
                if (code[0] === '+') {
                    n = Number(code.substr(1));
                    TDev.Util.assert(n !== undefined);
                    s = lkeys.pop();
                    this.map[n] = s;
                    this.hash[s] = n;
                }
                else {
                    n = Number(code);
                    TDev.Util.assert(n !== undefined);
                    s = this.map[n];
                    TDev.Util.assert(s !== undefined);
                }
                return s;
            };
            ChannelCompressor.prototype.OutBound = function (s, lkeys) {
                var code;
                var key = this.hash[s];
                if (key !== undefined) {
                    code = key.toString();
                }
                else {
                    code = "+" + (--this.localcount).toString();
                    this.map[this.localcount] = s;
                    this.hash[s] = this.localcount;
                    lkeys.push(s);
                }
                return code;
            };
            return ChannelCompressor;
        })();
        Revisions.ChannelCompressor = ChannelCompressor;
        var Parser = (function () {
            function Parser(text, pos) {
                this.DefinitionEscapeChar = '$';
                this.DefinitionMetaCharacters = "([,])";
                this.ComboEscapeChar = '@';
                this.ComboMetaCharacters = "|";
                this.text = text;
                this.pos = pos;
            }
            Parser.MakeDomain = function (name, type, components) {
                var s = Parser.WriteDefinitionString(name);
                if (type !== Parser.DOMAIN_BUILTIN) {
                    s += (type === Parser.DOMAIN_DYNAMIC ? "(" : "[");
                    s += components.join(",");
                    s += (type === Parser.DOMAIN_DYNAMIC ? ")" : "]");
                }
                return s;
            };
            Parser.MakeProperty = function (name, domain, codomain) {
                return Parser.WriteDefinitionString(name) + "," + codomain + "[" + domain + "]";
            };
            Parser.MakeKeyString = function (ukeys, lkeys) {
                var s = "";
                ukeys.forEach(function (uid) {
                    s = s + "|" + uid;
                });
                lkeys.forEach(function (lit) {
                    s = s + "|+" + Parser.WriteComboString(lit);
                });
                return s;
            };
            Parser.prototype.ParseKeyString = function (ukeys, lkeys) {
                var c = this.ParseComboComponents();
                for (var i = 0; i < c.length; i++) {
                    var s = c[i];
                    if (s.charAt(0) === "+")
                        lkeys.push(s.slice(1));
                    else
                        ukeys.push(s);
                }
            };
            Parser.prototype.ParseComboComponents = function () {
                var result = new Array();
                while (this.pos < this.text.length) {
                    result.push(this.ParseComboString());
                    this.pos++;
                }
                return result;
            };
            Parser.WriteDefinitionString = function (s) {
                var regexp = /[\$\(\[.\]\)]/g;
                return s.replace(regexp, '$$$&');
            };
            Parser.WriteComboString = function (s) {
                var regexp = /[@\|]/g;
                return s.replace(regexp, '@$&');
            };
            Parser.prototype.ParseDefinitionString = function () {
                return this.ParseString(this.DefinitionEscapeChar, this.DefinitionMetaCharacters);
            };
            Parser.prototype.ParseComboString = function () {
                return this.ParseString(this.ComboEscapeChar, this.ComboMetaCharacters);
            };
            Parser.prototype.ParseString = function (escapechar, metachars) {
                var result = "";
                while (this.pos < this.text.length) {
                    var c = this.text.charAt(this.pos);
                    this.pos += 1;
                    if (c === escapechar) {
                        result = result + (this.text.charAt(this.pos) || escapechar);
                        this.pos += 1;
                    }
                    else if (metachars.indexOf(c) != -1) {
                        this.pos -= 1;
                        return result;
                    }
                    else {
                        result = result + c;
                    }
                }
                return result;
            };
            Parser.DOMAIN_BUILTIN = 0;
            Parser.DOMAIN_STATIC = 1;
            Parser.DOMAIN_DYNAMIC = 2;
            return Parser;
        })();
        Revisions.Parser = Parser;
    })(Revisions = TDev.Revisions || (TDev.Revisions = {}));
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var Revisions;
    (function (Revisions) {
        var SessionTests = (function () {
            function SessionTests(rt) {
                this.rt = rt;
            }
            SessionTests.prototype.runtest = function (which) {
                if (typeof this[which] === "function") {
                    this.print("running test \"" + which + "\"");
                    this[which]();
                }
                else
                    this.print("no such test: \"" + which + "\"");
            };
            SessionTests.prototype.print = function (s) {
                this.rt.postBoxedText(s, "");
            };
            SessionTests.prototype.fail = function (msg) {
                this.print("FAILED: " + msg);
            };
            SessionTests.prototype.assert = function (cond) {
                if (!cond)
                    this.print("FAILED");
            };
            SessionTests.prototype.randomsuffix = function () {
                var d = new Date();
                var ms = d.getMilliseconds();
                return String.fromCharCode("a".charCodeAt(0) + ms % 26) + String.fromCharCode("a".charCodeAt(0) + Math.floor(ms / 26) % 26);
            };
            SessionTests.prototype.refreshtoken = function () {
                var _this = this;
                Revisions.getRevisionServiceTokenAsync().then(function (token) {
                    _this.print("success:");
                    _this.print("token=" + token);
                }, function (e) {
                    _this.fail("error: " + e);
                });
            };
            SessionTests.prototype.list = function () {
                var _this = this;
                var user = TDev.Cloud.getUserId();
                this.print("issuing get request for sessions by user " + user + "...");
                Revisions.queryMySessionsOnRevisionServerAsync(this.rt).then(function (s) {
                    _this.print("success:");
                    s.forEach(function (si) {
                        _this.print("");
                        _this.print("id=" + si._id);
                        _this.print("d=" + si._title);
                    });
                }, function (e) {
                    _this.fail("error: " + e);
                });
            };
            SessionTests.prototype.deletetests = function () {
                var _this = this;
                var user = TDev.Cloud.getUserId();
                this.print("issuing get request for sessions by user " + user + "...");
                Revisions.queryMySessionsOnRevisionServerAsync(this.rt).then(function (s) {
                    _this.print("success:");
                    s.forEach(function (si) {
                        if (si._title.indexOf("test session for") == 0) {
                            _this.print("deleting " + si._id);
                            Revisions.deleteSessionAsync(_this.rt.sessions.getCloudSessionDescriptor(s._id, s._title, s._permissions), _this.rt).then(function (ack) {
                                _this.print("successfully deleted " + si._id);
                            }, function (err) {
                                _this.fail("error deleting " + si._id + ": " + err);
                            }).done();
                        }
                    });
                }, function (e) {
                    _this.fail("error: " + e);
                });
            };
            SessionTests.prototype.connect1 = function () {
                var _this = this;
                this.print("connecting...");
                var sfx = this.randomsuffix();
                var testname = "connectone" + sfx;
                var s = new TDev.Revisions.ClientSession(TDev.Cloud.getUserId() + "0" + testname, "a" + sfx, TDev.Cloud.getUserId());
                s.connect(this.rt.sessions.url_ws(), Revisions.getRevisionServiceTokenAsync);
                this.print("create elt...");
                var dcustomer = "customer()";
                var alice = s.user_create_item(dcustomer, [], []);
                var items = s.user_get_items_in_domain(dcustomer);
                this.assert(items.length == 1);
                this.assert(items[0] === alice);
                this.print("issuing fence 1...");
                s.user_issue_fence(function () {
                    _this.print("fence 1 completed.");
                    var items = s.user_get_items_in_domain(dcustomer);
                    _this.assert(items.length == 1);
                    _this.assert(items[0] === alice);
                    _this.print("delete elt...");
                    s.user_delete_item(alice);
                    var items = s.user_get_items_in_domain(dcustomer);
                    _this.assert(items.length == 0);
                    _this.print("issuing fence 2...");
                    s.user_issue_fence(function () {
                        _this.print("fence 2 completed.");
                        var items = s.user_get_items_in_domain(dcustomer);
                        _this.assert(items.length == 0);
                        _this.print("DATA:");
                        var lines = s.user_dump_stable_data(function (b) { return _this.assert(b); });
                        lines.forEach(function (l) { return _this.print(l); });
                        _this.print("test completed.");
                    }, true);
                }, true);
            };
            SessionTests.prototype.connect2 = function () {
                var _this = this;
                this.print("connecting...");
                var testname = TDev.Cloud.getUserId() + "0" + "connecttwo" + this.randomsuffix();
                var s = new TDev.Revisions.ClientSession(testname, testname, TDev.Cloud.getUserId());
                s.connect(this.rt.sessions.url_ws(), Revisions.getRevisionServiceTokenAsync);
                var st = s.user_get_value(s.user_get_lval("mystring,string[void[]]", [], []));
                var db = s.user_get_value(s.user_get_lval("mydouble,double[void[]]", [], []));
                this.assert(st === "");
                this.assert(db === 0.0);
                this.print("writing data...");
                s.user_modify_lval(s.user_get_lval("mystring,string[void[]]", [], []), "");
                s.user_modify_lval(s.user_get_lval("mydouble,double[void[]]", [], []), 3.14);
                var st = s.user_get_value(s.user_get_lval("mystring,string[void[]]", [], []));
                var db = s.user_get_value(s.user_get_lval("mydouble,double[void[]]", [], []));
                this.assert(st === "");
                this.assert(db === 3.14);
                this.print("yielding...");
                s.user_yield();
                s.user_modify_lval(s.user_get_lval("mystring,string[void[]]", [], []), "new");
                s.user_modify_lval(s.user_get_lval("mydouble,double[void[]]", [], []), "A-3");
                var st = s.user_get_value(s.user_get_lval("mystring,string[void[]]", [], []));
                var db = s.user_get_value(s.user_get_lval("mydouble,double[void[]]", [], []));
                this.assert(st === "new");
                this.assert(db - 0.14 < 0.000000001);
                this.print("issuing fence 1...");
                s.user_issue_fence(function () {
                    _this.print("fence 1 completed.");
                    var st = s.user_get_value(s.user_get_lval("mystring,string[void[]]", [], []));
                    var db = s.user_get_value(s.user_get_lval("mydouble,double[void[]]", [], []));
                    _this.assert(st === "new");
                    _this.assert(db - 0.14 < 0.000000001);
                    _this.print("DATA:");
                    var lines = s.user_dump_stable_data(function (b) { return _this.assert(b); });
                    lines.forEach(function (l) { return _this.print(l); });
                    _this.print("test completed.");
                }, true);
            };
            SessionTests.prototype.serverpersistence1 = function () {
                var _this = this;
                this.print("connecting first session...");
                var sfx = this.randomsuffix();
                var testname = TDev.Cloud.getUserId() + "0serverpersistenceone" + sfx;
                var s = new TDev.Revisions.ClientSession(testname, "a", TDev.Cloud.getUserId());
                s.connect(this.rt.sessions.url_ws(), Revisions.getRevisionServiceTokenAsync);
                this.print("data...");
                var alice = s.user_create_item("customer()", [], []);
                var bob = s.user_create_item("customer()", [], []);
                var charlie = s.user_create_item("customer()", [], []);
                var delta = s.user_create_item("customer()", [], []);
                s.user_modify_lval(s.user_get_lval("name,string[customertable[customer()]]", [alice.uid], []), "Alice");
                s.user_modify_lval(s.user_get_lval("name,string[customertable[customer()]]", [bob.uid], []), "Bob");
                s.user_modify_lval(s.user_get_lval("name,string[customertable[customer()]]", [charlie.uid], []), "Charlie");
                s.user_modify_lval(s.user_get_lval("name,string[customertable[customer()]]", [delta.uid], []), "");
                var is = s.user_get_items_in_domain("customer()").map(function (e) { return e.target(); }).sort();
                var ref = [alice.uid, bob.uid, charlie.uid, delta.uid].sort();
                this.assert(is.length == ref.length);
                for (var i = 0; i < is.length; i++)
                    this.assert(is[i] === ref[i]);
                var ks = s.user_get_entries_in_indexdomain("customertable[customer()]").map(function (e) { return e.target(); }).sort();
                var ref = [s.user_get_entry("customertable[customer()]", [alice.uid], []), s.user_get_entry("customertable[customer()]", [bob.uid], []), s.user_get_entry("customertable[customer()]", [charlie.uid], [])].map(function (e) { return e.target(); }).sort();
                this.assert(ks.length == ref.length);
                for (var i = 0; i < ks.length; i++)
                    this.assert(ks[i] === ref[i]);
                this.print("saving...");
                s.user_issue_fence(function () {
                    _this.print("save completed.");
                    _this.print("connecting second session...");
                    s = new TDev.Revisions.ClientSession(testname, "b", TDev.Cloud.getUserId());
                    s.connect(_this.rt.sessions.url_ws(), Revisions.getRevisionServiceTokenAsync);
                    _this.print("loading...");
                    s.user_issue_fence(function () {
                        _this.print("load completed.");
                        _this.print("checking data...");
                        var is = s.user_get_items_in_domain("customer()");
                        _this.assert(is.length == 4);
                        var es = s.user_get_entries_in_indexdomain("customertable[customer()]");
                        _this.assert(es.length == 3);
                        _this.print("DATA:");
                        var lines = s.user_dump_stable_data(function (b) { return _this.assert(b); });
                        var ref = ["new|customer()|1.1", "new|customer()|1.2", "new|customer()|1.3", "new|customer()|1.4", "mod|name,string[customertable[customer()]]|1.1|+Alice", "mod|name,string[customertable[customer()]]|1.2|+Bob", "mod|name,string[customertable[customer()]]|1.3|+Charlie"];
                        _this.assert(lines.length == ref.length);
                        for (var i = 0; i < lines.length; i++) {
                            _this.assert(lines[i] === ref[i]);
                            _this.print(lines[i]);
                        }
                        _this.print("test completed.");
                    }, true);
                }, true);
            };
            return SessionTests;
        })();
        Revisions.SessionTests = SessionTests;
    })(Revisions = TDev.Revisions || (TDev.Revisions = {}));
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var SVG;
    (function (SVG) {
        var actionIcon = "M 90,129L 240,129L 240,149L 90,149L 90,129 Z M 140,169L 240,169L 240,189L 140,189L 140,169 Z M 140,209L 240,209L 240,229L 140,229L 140,209 Z M 190,249L 370,249L 370,269L 190,269L 190,249 Z M 90,289L 370,289L 370,309L 90,309L 90,289 Z M 140,329L 370,329L 370,349L 140,349L 140,329 Z M 140,369L 370,369L 370,389L 140,389L 140,369 Z M ";
        var codeSigns = {
            "\u2339": svgBoilerPlate('0 0 380 380', "<path fill='#000000' d=' M 263.5,153.201L 263.5,181.142L 263.5,181.799L 71.5,181.799L 71.5,181.142L 71.5,153.201L 71.5,152.543L 263.5,152.543L 263.5,153.201 Z M 2.79943e-005,0L 335,0L 335,335L 2.79943e-005,335L 2.79943e-005,0 Z M 24.4999,24.5L 24.4999,310.5L 310.5,310.5L 310.5,24.5L 24.4999,24.5 Z M 167.5,66.6287C 180.203,66.6287 190.5,76.926 190.5,89.6286C 190.5,102.331 180.203,112.629 167.5,112.629C 154.797,112.629 144.5,102.331 144.5,89.6286C 144.5,76.926 154.797,66.6287 167.5,66.6287 Z M 167.5,267.714C 154.797,267.714 144.5,257.416 144.5,244.714C 144.5,232.011 154.797,221.714 167.5,221.714C 180.203,221.714 190.5,232.011 190.5,244.714C 190.5,257.416 180.203,267.714 167.5,267.714 Z '/>"),
            "\u25f3": svgBoilerPlate('0 0 380 380', "<path fill='#000000' d=' M 179.812,155.187L 310.5,155.187L 310.5,24.4998L 179.812,24.4998L 179.812,155.187 Z M 155.172,179.812L 155.172,155.187L 155.188,155.187L 155.188,24.4999L 24.4999,24.4999L 24.4999,310.5L 310.5,310.5L 310.5,179.812L 155.172,179.812 Z M -2.2889e-005,0L 335,0L 335,335L -2.2889e-005,335L -2.2889e-005,0 Z '/>"),
        };
        var scriptIcons = {};
        function loadScriptIcons(icons) {
            scriptIcons = icons;
        }
        SVG.loadScriptIcons = loadScriptIcons;
        var icons = {
            findrefs: "M 100,240L 176,240L 91,155L 117,130L 202,215L 202,138L 232,168L 232,270L 130,270L 100,240 Z M 278,138L 278,215L 363,130L 388,155L 303,240L 380,240L 350,270L 248,270L 248,168L 278,138 Z M 240,279C 260,279 277,296 277,317C 277,337 260,354 240,354C 219,354 203,337 203,317C 203,296 219,279 240,279 Z ",
            back: "M 272,137L 213,137L 112,238L 213,340L 272,340L 196,264L 365,264L 365,213L 196,213L 272,137 Z ",
            select: "M 248,139L 313,120L 313,119L 313,119L 341,119L 341,354L 313,354L 313,354L 313,353L 248,334L 313,315L 313,158L 248,139 Z M 297,175L 297,202L 127,202L 127,175L 297,175 Z M 297,221L 297,249L 127,249L 127,221L 297,221 Z M 297,266L 297,294L 127,294L 127,266L 297,266 Z ",
            add: "M 219,119L 260,119L 260,220L 361,220L 361,261L 260,261L 260,363L 219,363L 219,261L 117,261L 117,220L 219,220L 219,119 Z ",
            color: "M 219,360C 190,355 163,341 145,322C 137,314 135,311 130,302C 115,272 113,230 125,198C 134,174 152,150 171,134C 181,127 198,118 209,115C 223,112 240,112 251,116C 262,119 268,123 275,131C 284,140 287,151 286,165C 285,169 282,180 279,190C 270,215 270,219 269,234C 268,246 268,247 267,247C 262,247 254,251 250,255C 245,259 240,266 237,278C 234,287 231,289 221,292C 216,293 213,293 213,293C 212,293 212,290 211,287C 207,273 192,265 179,269C 161,274 154,294 164,309C 169,318 182,323 192,320C 194,319 198,318 200,316L 204,314L 209,316C 213,318 232,323 237,323C 240,323 240,324 245,330C 253,341 269,343 280,336C 286,333 291,325 292,319C 292,315 293,314 298,310C 305,304 310,295 310,290C 310,286 311,286 314,284C 316,283 319,281 320,280C 322,279 322,279 324,282C 326,283 328,287 329,290C 332,295 332,297 332,307C 332,316 332,318 329,324C 322,338 302,351 272,358C 259,361 231,362 219,360 Z M 176,239C 182,236 188,230 190,224C 194,216 191,203 185,196C 172,183 150,187 142,203C 139,208 139,219 141,224C 147,238 163,245 176,239 Z M 239,193C 249,188 254,180 254,169C 254,161 252,155 246,150C 241,145 236,143 229,143C 215,143 203,152 202,166C 199,186 221,201 239,193 Z M 239,314C 232,312 218,309 214,307C 210,306 211,305 221,302C 238,299 242,295 248,276C 251,267 257,260 264,259C 269,258 270,258 272,262C 278,278 281,281 292,284C 295,285 298,287 299,288C 303,293 289,306 274,312C 267,314 249,315 239,314 Z M 294,277C 290,275 284,269 282,265C 280,260 281,254 285,249C 289,243 310,222 336,197C 366,169 374,163 385,163C 397,163 396,174 383,194C 365,221 330,260 314,271C 304,278 300,280 294,277 Z ",
            script: "M 145,329L 145,314L 176,314L 176,345L 145,345M 197,329L 197,314L 381,314L 381,345L 197,345M 145,278L 145,263L 279,263L 279,293L 145,293M 145,227L 145,212L 176,212L 176,242L 145,242M 197,227L 197,212L 381,212L 381,242L 197,242M 145,176L 145,160L 176,160L 176,191L 145,191M 197,176L 197,160L 381,160L 381,191L 197,191M 145,124L 145,108L 279,108L 279,140L 145,140",
            cursorright: "M 145,372L 204,372L 323,239L 204,105L 145,105L 264,239L 145,372",
            cursorleft: "M 323,105L 264,105L 145,238L 264,372L 323,372L 204,238L 323,105",
            actionlocation: actionIcon + "322,214L 373,162L 259,162L 259,128L 373,128L 322,77L 362,77L 430,145L 362,214L 322,214 Z ",
            actionevent: actionIcon + "333,70L 398,70L 342,128L 392,128L 289,231L 330,149L 283,149L 333,70 Z ",
            play: "M 353,238L 171,139L 171,338L 353,238 Z ",
            touchdevelop: "M 325.771,240.507L 256.702,292.393L 256.702,188.608L 325.771,240.507 Z M 275.211,115.775C 343.573,113.37 400.414,167.062 402.864,234.975C 404.979,302.949 351.353,360.095 283.378,362.207C 240.754,363.628 202.621,343.247 179.365,311.196L 191.855,302.111C 212.239,330.188 245.485,348.056 282.862,346.829C 342.441,344.974 389.341,295.087 387.486,235.491C 385.322,175.842 335.761,129.107 275.822,131.267L 275.727,131.267C 245.163,132.189 218.147,145.678 198.99,166.69L 187.512,156.267C 209.335,132.35 240.382,116.857 275.211,115.775 Z M 143.005,154.602C 176.572,154.602 204.154,181.844 204.154,215.751C 204.154,249.658 176.572,276.806 143.005,276.806C 109.437,276.806 81.2436,249.741 81.2436,215.751C 81.2436,181.766 109.437,154.602 143.005,154.602 Z M 143.005,165.141C 115.101,165.141 91.7829,187.608 91.7829,215.751C 91.7829,239.424 108.257,258.99 130.081,264.628L 120.282,229.356L 118.637,223.613L 167.182,223.613L 165.306,229.472L 154.771,264.908C 177.02,259.672 193.615,239.881 193.615,215.751C 193.615,187.525 170.908,165.141 143.005,165.141 Z M 143.005,266.266L 144.495,266.245L 154.577,232.793L 131.032,232.793L 140.295,266.196L 143.005,266.266 Z M 114.907,279.177L 169.437,279.177L 169.437,284.792L 114.907,289.084L 114.907,279.177 Z M 169.437,288.762L 169.437,296.364L 114.907,300.656L 114.907,293.055L 169.437,288.762 Z M 169.437,300.334L 169.437,306.936L 115.568,311.229L 114.907,304.627L 169.437,300.334 Z M 116.894,314.873L 125.818,314.212L 160.514,311.229L 169.115,310.564L 168.776,311.568L 167.471,314.873L 165.145,319.83C 164.162,321.475 162.84,323.462 160.852,325.123C 158.869,326.767 156.221,328.415 153.251,329.738C 150.284,331.06 146.975,331.725 144.327,332.064C 141.36,332.386 139.034,332.064 136.725,331.725C 134.419,331.06 131.771,330.399 129.788,329.077C 127.801,328.093 125.818,326.767 124.169,325.445C 122.508,324.123 121.186,322.474 119.86,320.491C 118.538,318.826 117.555,317.182 116.894,314.873 Z ",
            undo: "M 256,133C 228,133 202,143 183,163C 174,172 166,183 161,194L 121,148L 121,260L 220,260L 186,221C 189,208 195,195 205,185C 219,172 237,164 256,164C 275,164 293,172 306,185C 320,199 327,217 327,236C 327,255 320,273 306,287C 300,293 300,303 306,309C 310,312 314,314 318,314C 322,314 326,312 329,309C 348,290 359,264 359,236C 359,208 348,182 329,163C 309,143 283,133 256,133 Z ",
            cut: "M 328,324C 325,330 322,333 318,333C 315,333 311,331 308,327L 289,301L 289,299L 276,282L 273,277C 277,272 283,267 291,267C 299,267 307,272 316,281C 331,297 332,315 328,324 Z M 173,326C 165,335 157,334 153,324C 149,315 149,297 165,281C 174,272 182,267 189,267C 197,267 204,273 208,277L 196,293L 192,299L 192,300L 173,326 Z M 333,265C 320,251 305,243 291,243C 277,243 266,251 258,258L 256,254L 262,246L 292,227L 336,156L 336,109L 241,235L 146,109L 146,156L 189,227L 219,246L 225,255L 223,258C 215,251 204,243 189,243C 175,243 161,251 148,265C 124,289 124,317 131,334C 137,348 152,357 165,357C 171,357 192,342 193,341L 204,325L 241,275L 278,326L 290,342C 290,343 310,357 316,357C 330,357 343,348 349,334C 356,317 357,289 333,265 Z ",
            search: "M 277,139C 310,139 338,166 338,200C 338,233 310,261 277,261C 243,261 216,233 216,200C 216,166 243,139 277,139 Z M 156,354L 233,277C 246,284 261,288 277,288C 325,288 365,248 365,200C 365,151 325,112 277,112C 228,112 189,151 189,200C 189,218 194,235 204,249L 127,325C 123,329 122,334 122,339C 122,345 123,350 127,354C 135,362 148,362 156,354 Z ",
            history: "M 343,215L 378,181L 343,146L 257,146L 257,112L 223,112L 223,146L 154,146L 154,215L 223,215L 223,232L 136,232L 102,267L 136,301L 223,301L 223,388L 257,388L 257,301L 326,301L 326,232L 257,232L 257,215L 343,215 Z ",
            edit: "M 135,344L 141,303L 175,337L 135,344 Z M 195,331L 147,283L 269,160L 318,209L 195,331 Z M 328,198L 281,150L 290,141L 294,137C 306,125 327,127 340,139C 352,152 353,173 341,185C 340,186 340,186 339,188L 328,198 Z ",
            backspace: "M 242,198L 267,224L 293,198L 308,213L 282,238L 308,264L 293,279L 267,253L 242,279L 227,264L 253,238L 227,213L 242,198 Z M 75,238L 173,161L 349,161L 349,316L 173,316L 75,238 Z M 105,238L 182,300L 333,300L 333,177L 182,177L 105,238 Z ",
            hammer: "M 251,118C 256,115 268,109 283,109C 298,109 316,116 328,123C 340,130 346,137 349,141C 352,145 352,145 350,147C 348,150 343,154 344,160C 345,166 352,174 357,175C 362,176 367,171 370,169C 373,167 375,170 377,172C 378,174 380,177 380,179C 380,181 379,183 373,189C 367,195 356,206 351,212C 345,217 345,217 343,217C 342,217 339,217 337,216C 334,215 332,212 332,209C 331,207 332,204 333,202C 334,200 336,198 337,196C 338,194 338,192 336,190C 334,187 330,185 327,183C 323,181 320,181 318,182C 315,183 312,185 298,198C 284,211 259,234 246,247C 234,259 234,260 234,261C 235,263 235,264 232,268C 229,272 223,278 209,291C 195,305 174,326 163,337C 152,348 152,348 150,348C 149,348 146,348 142,344C 138,341 133,335 130,331C 128,327 128,326 142,312C 156,298 185,270 199,256C 214,242 214,242 215,242C 216,243 218,243 220,244C 221,244 221,244 234,232C 247,220 272,195 284,183C 297,170 297,170 298,166C 300,163 303,156 302,149C 302,142 297,134 291,130C 285,125 276,124 269,124C 262,123 255,123 252,122C 248,122 246,122 251,118 Z ",
            circleplus: "M 236.481,4.8425C 365.798,4.8425 470.63,109.674 470.63,238.991C 470.63,368.307 365.798,473.139 236.481,473.139C 107.165,473.139 2.33301,368.307 2.33301,238.991C 2.33301,109.674 107.165,4.8425 236.481,4.8425 Z M 236.481,26.9594C 119.379,26.9594 24.4499,121.889 24.4499,238.991C 24.4499,356.092 119.38,451.022 236.481,451.022C 353.583,451.022 448.513,356.092 448.513,238.991C 448.513,121.889 353.583,26.9594 236.481,26.9594 Z M 255.648,137.451L 255.648,219.824L 338.02,219.824L 338.02,258.157L 255.648,258.157L 255.648,340.53L 217.315,340.53L 217.315,258.157L 134.942,258.157L 134.942,219.824L 217.315,219.824L 217.315,137.451L 255.648,137.451 Z ",
            cancel: "M 172.862,139.945L 240.453,207.537L 308.045,139.945L 339.499,171.399L 271.907,238.991L 339.499,306.582L 308.045,338.036L 240.453,270.445L 172.862,338.036L 141.408,306.582L 208.999,238.991L 141.408,171.399L 172.862,139.945 Z ",
            stop: "M 153,153L 326,153L 326,326L 153,326L 153,326 Z ",
            gameboard: "M 154.865,98.1082L 154.865,154.865L 211.622,154.865L 211.622,98.1089L 154.865,98.1082 Z M 98.1082,90.0002L 381.892,90.0002L 390,90.0002L 390,390L 381.892,390L 98.1082,390L 90.0001,390L 90.0001,90.0001L 98.1082,90.0002 Z M 98.1081,325.136L 154.865,325.136L 154.865,268.379L 98.108,268.379L 98.1081,325.136 Z M 98.108,211.622L 154.865,211.622L 154.865,154.866L 98.1081,154.865L 98.108,211.622 Z M 381.892,154.865L 325.135,154.865L 325.135,98.1089L 268.378,98.109L 268.378,154.866L 325.135,154.866L 325.135,211.622L 381.892,211.622L 381.892,154.865 Z M 381.892,268.379L 325.135,268.379L 325.135,325.136L 381.892,325.136L 381.892,268.379 Z M 325.135,268.379L 325.135,211.622L 268.378,211.622L 268.378,268.379L 325.135,268.379 Z M 325.135,381.892L 325.135,325.136L 268.378,325.136L 268.378,381.892L 325.135,381.892 Z M 211.622,381.892L 211.622,325.136L 154.865,325.136L 154.865,381.892L 211.622,381.892 Z M 211.622,154.865L 211.622,211.622L 268.378,211.622L 268.378,154.866L 211.622,154.865 Z M 268.378,268.379L 211.622,268.379L 211.622,325.136L 268.378,325.136L 268.378,268.379 Z M 154.865,268.379L 211.622,268.379L 211.622,211.622L 154.865,211.622L 154.865,268.379 Z ",
            follower: "M 240.779,79.9986C 226.097,79.9986 214.194,91.9003 214.194,106.582C 214.194,121.258 226.097,133.16 240.779,133.16C 255.455,133.16 267.357,121.258 267.357,106.582C 267.357,91.9003 255.455,79.9986 240.779,79.9986 Z M 213.625,146.396C 204.769,146.396 195.965,149.489 189.708,154.791C 183.446,160.1 179.802,167.559 179.802,175.059L 179.802,175.818C 179.784,176.15 179.784,176.476 179.802,176.808L 179.802,288.21C 179.749,293.4 185.117,298.181 191.107,298.258C 197.202,298.335 202.802,293.5 202.743,288.21L 202.743,192.312L 210.1,192.312L 210.1,285.515L 210.137,285.515L 210.137,385.659C 210.041,392.01 215.729,397.883 222.081,397.983C 225.321,398.03 228.562,396.721 230.855,394.427C 233.143,392.136 234.458,388.901 234.404,385.659L 234.404,285.515L 246.538,285.515L 246.538,385.659C 246.443,392.01 252.13,397.883 258.482,397.983C 261.722,398.03 264.963,396.721 267.257,394.427C 269.544,392.136 270.859,388.901 270.806,385.659L 270.806,285.515L 270.847,285.515L 270.847,192.312L 278.163,192.312L 278.163,289.614C 278.082,294.827 283.49,299.638 289.504,299.698C 295.6,299.757 301.187,294.905 301.104,289.614L 301.104,178.247C 301.116,177.958 301.116,177.666 301.104,177.377L 301.104,175.059C 301.104,167.559 297.461,160.1 291.204,154.791C 284.942,149.489 276.137,146.396 267.279,146.396",
            nicehammer: "M 260.037,115.075C 264.533,111.92 274.714,105.811 288.337,105.666C 301.96,105.52 319.025,111.338 330.176,117.64C 341.326,123.943 346.562,130.73 349.18,134.172C 351.798,137.614 351.798,137.711 349.956,139.796C 348.114,141.88 344.429,145.953 345.496,151.48C 346.562,157.006 352.38,163.988 357.276,164.909C 362.173,165.83 366.148,160.691 368.96,159.091C 371.772,157.491 373.421,159.43 374.923,161.612C 376.426,163.794 377.784,166.218 378.123,168.108C 378.462,169.999 377.784,171.357 372.439,177.102C 367.094,182.846 357.083,192.979 351.956,198.118C 346.829,203.257 346.587,203.402 345.241,203.499C 343.896,203.596 341.448,203.645 339.29,202.433C 337.133,201.221 335.266,198.748 334.612,196.421C 333.957,194.094 334.515,191.912 335.727,189.961C 336.939,188.01 338.805,186.289 339.593,184.519C 340.381,182.749 340.09,180.931 338.236,178.726C 336.381,176.52 332.964,173.926 329.873,172.544C 326.782,171.163 324.019,170.993 321.413,171.829C 318.807,172.666 316.359,174.508 301.52,188.886C 286.681,203.265 259.451,230.18 245.902,244.041C 232.352,257.902 232.484,258.71 232.743,259.951C 233.003,261.191 233.391,262.863 230.837,266.31C 228.284,269.757 222.789,274.978 206.547,291.429C 190.305,307.88 163.316,335.561 149.773,349.402C 136.23,363.242 136.133,363.242 134.792,363.242C 133.45,363.242 130.865,363.242 127.168,360.337C 123.471,357.433 118.664,351.623 116.26,348.331C 113.856,345.038 113.856,344.262 130.465,327.068C 147.073,309.873 180.29,276.26 196.996,259.518C 213.702,242.776 213.896,242.906 214.962,243.197C 216.029,243.487 217.968,243.94 219.164,244.198C 220.36,244.457 220.812,244.522 234.532,230.753C 248.252,216.985 275.239,189.383 288.782,175.405C 302.324,161.426 302.421,161.071 303.762,157.855C 305.103,154.639 307.689,148.563 306.913,142.034C 306.138,135.505 302.001,128.524 296.215,124.646C 290.43,120.767 282.996,119.992 276.338,119.507C 269.68,119.022 263.798,118.828 260.263,118.63C 256.728,118.432 255.54,118.23 260.037,115.075 Z ",
            resume: "M 379.088,238.991L 200.911,336.845L 200.911,141.136L 379.088,238.991 Z M 150.921,141.091L 181.27,141.091L 181.27,336.89L 150.921,336.89L 150.921,141.091 Z ",
            pausesq: "M 256.877,141.174L 295.645,141.174L 295.645,336.807L 256.877,336.807L 256.877,141.174 Z M 185.261,141.174L 224.029,141.174L 224.029,336.807L 185.261,336.807L 185.261,141.174 Z ",
            experiment: "M 364.4,192.137L 364.363,192.112L 225.122,99.8953L 232.252,89.1295L 291.226,128.169L 336.644,128.169L 246.104,68.215L 253.232,57.4525L 392.51,149.694C 404.23,157.456 407.439,173.25 399.676,184.97C 391.914,196.69 376.121,199.899 364.4,192.137 Z M 200.75,294.907C 206.525,294.907 211.207,299.589 211.207,305.364C 211.207,311.139 206.525,315.82 200.75,315.82C 194.975,315.82 190.293,311.139 190.293,305.364C 190.293,299.589 194.975,294.907 200.75,294.907 Z M 223.827,267.863C 229.602,267.863 234.284,272.545 234.284,278.32C 234.284,284.095 229.602,288.777 223.827,288.777C 218.052,288.777 213.37,284.095 213.37,278.32C 213.37,272.545 218.052,267.863 223.827,267.863 Z M 217.343,195.686C 223.118,195.686 227.8,200.368 227.8,206.143C 227.8,211.918 223.118,216.6 217.343,216.6C 211.568,216.6 206.886,211.918 206.886,206.143C 206.886,200.368 211.568,195.686 217.343,195.686 Z M 95.4793,378.08L 190.255,258.966L 190.255,138.415L 204.394,138.415L 204.394,267.793L 159.43,325.71L 275.622,325.71L 230.659,267.792L 230.659,138.415L 244.797,138.415L 244.797,258.966L 339.573,378.08L 95.4793,378.08 Z M 183.646,337.876C 177.87,337.876 173.189,342.558 173.189,348.333C 173.189,354.108 177.87,358.79 183.646,358.79C 189.421,358.79 194.102,354.108 194.102,348.333C 194.102,342.558 189.421,337.876 183.646,337.876 Z M 238.19,328.321C 232.415,328.321 227.733,333.002 227.733,338.777C 227.733,344.553 232.415,349.234 238.19,349.234C 243.965,349.234 248.647,344.553 248.647,338.777C 248.647,333.002 243.965,328.321 238.19,328.321 Z ",
            stackpoint: "M 288.576,32.0641L 464.928,240.48L 288.576,464.928L 288.576,320.64C 235.136,320.64 181.696,320.64 133.6,293.839C 85.5041,267.039 42.752,213.438 29.392,162.67C 16.032,111.902 32.064,63.9671 48.0961,16.032C 74.8161,69.472 101.536,122.912 141.616,149.632C 181.696,176.352 235.136,176.352 288.576,176.352L 288.576,32.0641 Z",
            breakpoint: "M 240.48,64.1281C 143.084,64.1281 64.128,143.084 64.128,240.48C 64.128,337.877 143.084,416.832 240.48,416.832C 337.877,416.832 416.832,337.877 416.832,240.48C 416.832,143.084 337.877,64.1281 240.48,64.1281 Z",
            currentpoint: "M 288.576, 32.0641L 464.928, 240.48L 288.576, 464.928L 288.576, 320.64L 64.128, 320.64L 64.128, 176.352L 288.576, 176.352L 288.576, 32.0641 Z",
            stepin: "M 288.576,272.544L 384.768,272.544L 384.768,368.736L 288.576,368.736L 288.576,272.544 Z M 208.416,256.512L 272.544,320.64L 208.416,384.768L 144.288,384.768L 176.352,352.704C 133.6,352.704 90.848,352.704 69.472,312.624C 48.096,272.544 48.096,192.384 77.488,152.304C 106.88,112.224 165.664,112.224 224.448,112.224L 224.448,176.352C 187.04,176.352 149.632,176.352 130.928,195.056C 112.224,213.76 112.224,251.168 122.912,269.872C 133.6,288.576 154.976,288.576 176.352,288.576L 144.288,256.512L 208.416,256.512 Z",
            stepover: "M 224,160L 320,160L 320,256L 224,256L 224,160 Z M 288,288L 352,352L 288,416L 224,416L 256,384C 202.667,384 149.333,384 122.667,330.667C 96,277.333 96,170.667 122.667,117.333C 149.333,64 202.667,64 256,64L 256,128C 224,128 192,128 176,160C 160,192 160,256 176,288C 192,320 224,320 256,320L 224,288L 288,288 Z",
            stepout: "M 272.544,288.576L 368.736,288.576L 368.736,384.768L 272.544,384.768L 272.544,288.576 Z M 296.926,224.448L 361.054,160.32L 296.926,96.192L 232.798,96.192L 264.862,128.256C 200.734,128.256 136.606,128.256 104.542,168.336C 72.478,208.416 72.478,288.576 101.87,328.656C 131.262,368.736 190.046,368.736 248.83,368.736L 248.83,304.608C 211.422,304.608 174.014,304.608 155.31,285.904C 136.606,267.2 136.606,229.792 157.982,211.088C 179.358,192.384 222.11,192.384 264.862,192.384L 232.798,224.448L 296.926,224.448 Z",
            bug: "M 292.799,197.661C 299.238,200.966 301.197,209.996 297.176,217.83C 295.167,221.744 292.045,224.618 288.62,226.103C 290.629,232.763 291.696,240.224 291.803,248.223C 297.67,249.987 304.994,252.703 309.852,254.9C 315.641,257.519 317.928,259.4 320.115,265.05C 322.302,270.701 324.39,280.121 325.146,292.748C 325.902,305.375 325.326,321.209 323.033,323.428C 320.74,325.646 316.73,314.249 314.514,303.137C 312.299,292.025 311.878,281.197 311.642,275.628C 311.406,270.06 311.355,269.751 309.385,268.48C 307.415,267.209 303.526,264.976 299.269,263.357C 296.524,262.313 293.626,261.524 291.2,261.006C 289.985,272.614 286.958,284.971 282.073,297.402C 283.702,298.245 285.222,299.07 286.539,299.83C 291.843,302.893 293.856,304.916 295.416,310.544C 296.976,316.172 298.081,325.406 297.604,337.59C 297.126,349.774 295.066,364.908 292.655,366.818C 290.244,368.728 287.483,357.413 286.417,346.543C 285.35,335.673 285.978,325.247 286.282,319.883C 286.586,314.519 286.566,314.218 284.797,312.811C 283.32,311.636 280.623,309.691 277.486,307.941C 276.823,309.327 276.136,310.713 275.426,312.096C 270.586,321.523 265.021,330.133 258.986,337.767C 260.824,339.452 262.539,341.108 263.918,342.54C 267.756,346.525 268.998,348.784 268.944,354.059C 268.89,359.334 267.54,367.625 264.079,378.081C 260.617,388.536 255.044,401.156 252.475,402.211C 249.905,403.266 250.338,392.755 252.13,383.054C 253.923,373.352 257.075,364.46 258.68,359.881C 260.286,355.301 260.344,355.035 259.161,353.371C 257.977,351.708 255.552,348.648 252.632,345.966C 252.515,345.858 252.397,345.751 252.278,345.645C 230.233,369.66 203.612,381.193 183.106,373.604L 239.423,257.632L 177.902,371.186C 158.057,359.941 151.05,330.794 157.811,297.747C 157.357,297.637 156.901,297.533 156.444,297.438C 152.473,296.61 148.483,296.418 146.395,296.426C 144.306,296.434 144.12,296.641 141.27,300.707C 138.42,304.772 132.907,312.695 125.911,319.97C 118.915,327.245 110.436,333.872 109.78,331.107C 109.124,328.341 116.292,316.183 122.92,307.071C 129.548,297.959 135.636,291.893 139.989,288.703C 144.342,285.513 146.961,285.198 152.562,286.012C 154.806,286.339 157.529,286.846 160.333,287.449C 163.024,278.004 166.804,268.366 171.693,258.842C 172.45,257.367 173.225,255.912 174.017,254.478C 170.422,252.71 166.829,251.497 164.827,250.928C 162.603,250.296 162.341,250.46 158.063,253.911C 153.785,257.362 145.492,264.101 135.819,269.696C 126.146,275.291 115.094,279.742 115.244,276.599C 115.394,273.456 126.747,262.72 136.591,255.057C 146.435,247.395 154.771,242.808 160.38,240.749C 165.989,238.689 168.871,239.157 174.58,241.74C 176.221,242.483 178.097,243.401 180.059,244.415C 187.485,233.022 195.966,223.249 204.893,215.474C 202.919,213.6 200.195,211.32 197.31,209.409C 193.426,206.836 189.251,204.934 187.02,204.054C 184.789,203.174 184.501,203.316 179.731,206.44C 174.961,209.564 165.709,215.671 155.15,220.455C 144.59,225.24 132.725,228.702 133.202,225.472C 133.679,222.243 146.499,212.323 157.447,205.422C 168.395,198.521 177.471,194.64 183.473,193.089C 189.474,191.538 192.401,192.317 198.03,195.568C 203.089,198.491 210.331,203.411 215.377,207.398C 220.512,203.941 225.713,201.157 230.873,199.111C 230.904,196.199 231.633,193.135 233.128,190.224C 237.47,181.765 246.627,177.801 253.58,181.37C 258.671,183.984 261.168,189.911 260.437,196.218C 261.218,196.418 261.993,196.644 262.759,196.896C 271.644,169.666 279.848,143.046 281.456,122.34C 283.248,99.2486 276.837,83.5108 271.788,73.9875C 266.739,64.4644 263.051,61.1559 263.828,58.6207C 264.604,56.0857 269.845,54.3239 275.163,57.0064C 280.481,59.6888 285.876,66.8152 288.889,82.9933C 291.903,99.1714 292.534,124.401 287.268,146.464C 282.807,165.148 274.117,181.562 264.779,197.627C 265.844,198.05 266.893,198.525 267.923,199.053C 269.165,199.691 270.36,200.397 271.507,201.166C 279.203,190.277 287.4,179.795 298.365,171.556C 311.758,161.494 329.278,154.778 341.378,152.35C 353.477,149.922 360.155,151.782 363.759,154.849C 367.362,157.916 367.89,162.191 366.408,163.47C 364.926,164.75 361.434,163.035 353.226,162.105C 345.018,161.176 332.094,161.032 316.844,168.885C 303.547,175.733 288.482,188.661 273.19,202.368C 273.822,202.846 274.437,203.346 275.037,203.865C 279.377,197.427 286.935,194.65 292.799,197.661 Z ",
            twobugs: " M 217.767,207.218C 222.158,209.472 223.494,215.63 220.751,220.973C 219.381,223.642 217.252,225.602 214.917,226.614C 216.287,231.156 217.014,236.245 217.088,241.7C 219.876,242.538 223.148,243.692 225.996,244.821C 228.874,241.683 233.516,237.555 237.748,234.26C 244.462,229.035 250.146,225.907 253.971,224.502C 257.796,223.098 259.762,223.417 263.655,225.179L 267.392,227.003C 272.456,219.233 278.24,212.568 284.327,207.266C 282.981,205.989 281.123,204.433 279.156,203.13C 276.507,201.376 273.66,200.078 272.139,199.478C 270.617,198.878 270.421,198.975 267.168,201.105C 263.915,203.236 257.605,207.401 250.404,210.663C 243.204,213.926 235.112,216.287 235.437,214.085C 235.763,211.883 244.505,205.118 251.971,200.412C 259.437,195.705 265.627,193.059 269.719,192.001C 273.812,190.943 275.808,191.474 279.647,193.692C 283.097,195.685 288.036,199.04 291.477,201.759C 294.979,199.402 298.526,197.503 302.044,196.107C 302.065,194.121 302.563,192.032 303.582,190.047C 306.543,184.278 312.788,181.575 317.53,184.009C 321.001,185.791 322.704,189.833 322.205,194.135L 323.789,194.597C 329.848,176.027 335.443,157.874 336.539,143.753C 337.762,128.006 333.39,117.274 329.946,110.779C 326.503,104.285 323.988,102.029 324.518,100.3C 325.047,98.5709 328.621,97.3695 332.248,99.1988C 335.874,101.028 339.554,105.888 341.609,116.921C 343.664,127.953 344.094,145.159 340.503,160.204C 337.461,172.947 331.535,184.14 325.166,195.096L 327.311,196.068C 328.158,196.503 328.972,196.984 329.755,197.509C 335.003,190.083 340.593,182.935 348.071,177.317C 357.204,170.454 369.152,165.875 377.403,164.219C 385.655,162.563 390.209,163.831 392.666,165.923C 395.124,168.015 395.484,170.93 394.473,171.802C 393.462,172.675 391.081,171.505 385.483,170.871C 379.886,170.238 371.072,170.139 360.673,175.495C 351.605,180.165 341.331,188.981 330.903,198.328L 332.162,199.35C 335.122,194.959 340.276,193.066 344.275,195.119C 348.666,197.373 350.002,203.531 347.26,208.873C 345.89,211.542 343.76,213.502 341.425,214.515C 342.795,219.056 343.523,224.145 343.596,229.6C 347.597,230.803 352.592,232.655 355.904,234.153C 359.852,235.939 361.412,237.222 362.903,241.075C 364.395,244.929 365.818,251.352 366.334,259.963C 366.849,268.575 366.457,279.373 364.893,280.886C 363.329,282.399 360.595,274.627 359.084,267.048C 357.573,259.47 357.286,252.086 357.125,248.289C 356.964,244.491 356.929,244.28 355.586,243.414C 354.242,242.547 351.59,241.025 348.687,239.92C 346.815,239.208 344.839,238.67 343.185,238.317C 342.356,246.233 340.292,254.66 336.96,263.138L 340.006,264.793C 343.623,266.882 344.996,268.261 346.06,272.1C 347.123,275.938 347.877,282.235 347.552,290.544C 347.226,298.853 345.821,309.174 344.177,310.476C 342.533,311.778 340.65,304.063 339.922,296.65C 339.195,289.237 339.623,282.126 339.831,278.468C 340.038,274.811 340.024,274.605 338.818,273.646C 337.811,272.845 335.972,271.518 333.832,270.324L 332.427,273.158C 329.127,279.587 325.332,285.458 321.216,290.664C 322.47,291.814 323.639,292.943 324.58,293.92C 327.197,296.637 328.044,298.178 328.007,301.775C 327.97,305.372 327.05,311.027 324.689,318.157C 322.329,325.287 318.528,333.893 316.776,334.612C 315.023,335.331 315.318,328.164 316.541,321.548C 317.763,314.932 319.913,308.868 321.008,305.745C 322.102,302.622 322.142,302.44 321.335,301.306C 320.528,300.172 318.874,298.085 316.883,296.256L 316.642,296.037C 301.608,312.414 283.454,320.279 269.469,315.104L 307.875,236.016L 265.921,313.455C 252.387,305.786 247.609,285.909 252.22,263.373L 251.287,263.162C 248.579,262.597 245.858,262.466 244.434,262.472C 243.01,262.477 242.883,262.619 240.939,265.391C 240.523,265.984 240.025,266.698 239.45,267.501C 239.603,268.945 239.73,270.466 239.826,272.063C 240.341,280.674 239.948,291.472 238.385,292.985C 236.821,294.498 234.086,286.726 232.576,279.148C 232.414,278.34 232.267,277.533 232.132,276.734C 231.592,277.334 231.036,277.934 230.465,278.528C 226.488,282.664 221.807,286.493 220.101,286.559C 220.855,290.418 221.309,295.86 221.043,302.644C 220.718,310.953 219.312,321.273 217.668,322.575C 216.024,323.878 214.142,316.162 213.414,308.749C 212.687,301.336 213.115,294.226 213.322,290.568C 213.53,286.91 213.516,286.705 212.31,285.745C 211.303,284.944 209.463,283.617 207.324,282.424L 205.919,285.258C 202.619,291.687 198.824,297.558 194.708,302.764C 195.961,303.913 197.131,305.042 198.072,306.019C 200.688,308.737 201.535,310.277 201.499,313.875C 201.462,317.472 200.542,323.126 198.181,330.256C 195.82,337.387 192.02,345.993 190.267,346.712C 188.515,347.431 188.81,340.263 190.033,333.648C 191.255,327.032 193.405,320.968 194.499,317.845C 195.594,314.722 195.634,314.54 194.827,313.406C 194.02,312.271 192.366,310.185 190.375,308.355L 190.133,308.136C 175.1,324.513 156.946,332.379 142.961,327.203L 181.367,248.116L 139.412,325.554C 125.879,317.886 121.1,298.009 125.711,275.472L 124.779,275.261C 122.071,274.697 119.35,274.566 117.926,274.571C 116.502,274.577 116.374,274.718 114.431,277.491C 112.487,280.263 108.728,285.666 103.957,290.627C 99.1859,295.589 93.4034,300.108 92.9563,298.222C 92.5091,296.336 97.3974,288.045 101.917,281.831C 106.437,275.617 110.589,271.48 113.558,269.305C 116.526,267.129 118.312,266.915 122.131,267.47C 123.662,267.692 125.519,268.038 127.431,268.45C 129.266,262.009 131.844,255.436 135.178,248.941L 136.763,245.965C 134.312,244.759 131.861,243.932 130.496,243.544C 128.979,243.113 128.8,243.225 125.883,245.578C 122.966,247.932 117.31,252.527 110.714,256.343C 104.117,260.158 96.5803,263.194 96.6827,261.051C 96.7851,258.907 104.527,251.585 111.24,246.36C 117.953,241.135 123.638,238.007 127.463,236.602C 131.288,235.198 133.254,235.517 137.147,237.278L 140.883,239.102C 145.947,231.333 151.731,224.668 157.819,219.366C 156.473,218.088 154.615,216.533 152.648,215.23C 149.999,213.475 147.152,212.178 145.63,211.578C 144.109,210.978 143.913,211.074 140.66,213.205C 137.407,215.336 131.097,219.5 123.896,222.763C 116.695,226.026 108.604,228.387 108.929,226.184C 109.254,223.982 117.997,217.217 125.463,212.511C 132.929,207.805 139.118,205.158 143.211,204.1C 147.304,203.043 149.3,203.574 153.139,205.791C 156.589,207.784 161.528,211.14 164.968,213.858C 168.471,211.501 172.018,209.602 175.536,208.207C 175.557,206.221 176.055,204.132 177.074,202.147C 180.035,196.378 186.28,193.675 191.021,196.109C 194.493,197.891 196.196,201.933 195.697,206.234L 197.281,206.697C 203.34,188.127 208.935,169.974 210.031,155.853C 211.254,140.106 206.882,129.373 203.438,122.879C 199.995,116.384 197.48,114.128 198.01,112.399C 198.539,110.671 202.113,109.469 205.739,111.298C 209.366,113.128 213.045,117.988 215.1,129.02C 217.155,140.053 217.586,157.258 213.995,172.304C 210.953,185.046 205.026,196.239 198.658,207.195L 200.802,208.168C 201.649,208.603 202.464,209.084 203.246,209.609C 208.495,202.183 214.085,195.035 221.563,189.416C 230.696,182.554 242.644,177.974 250.895,176.319C 259.146,174.663 263.701,175.931 266.158,178.023C 268.615,180.114 268.976,183.029 267.965,183.902C 266.954,184.775 264.572,183.605 258.975,182.971C 253.377,182.337 244.564,182.239 234.164,187.595C 225.097,192.265 214.823,201.081 204.394,210.428L 205.654,211.449C 208.614,207.059 213.768,205.165 217.767,207.218 Z M 236.395,253.175C 236.976,254.676 237.547,256.568 238.057,258.827C 238.774,258.2 239.446,257.66 240.066,257.205C 243.035,255.03 244.82,254.815 248.64,255.37C 250.17,255.593 252.027,255.939 253.939,256.35C 255.774,249.909 258.352,243.336 261.686,236.841L 263.271,233.865C 260.82,232.66 258.37,231.832 257.004,231.444C 255.487,231.014 255.308,231.125 252.391,233.479C 249.474,235.832 243.818,240.428 237.222,244.243C 235.307,245.351 233.312,246.393 231.448,247.262C 233.949,248.636 235.194,250.072 236.395,253.175 Z M 230.617,260.388C 230.456,256.591 230.421,256.38 229.078,255.513C 227.734,254.647 225.082,253.124 222.179,252.02C 220.307,251.308 218.331,250.77 216.676,250.417C 215.848,258.333 213.783,266.76 210.452,275.237L 213.498,276.893C 217.114,278.982 218.488,280.361 219.551,284.199C 219.592,284.345 219.632,284.494 219.671,284.647C 220.669,281.477 224.674,274.889 228.426,269.732C 229.279,268.559 230.118,267.46 230.94,266.435C 230.765,263.992 230.681,261.904 230.617,260.388 Z ",
            bandage: "M 248.07,189.861L 289.582,231.373L 343.085,177.87C 350.508,170.447 350.508,158.412 343.085,150.989L 328.454,136.358C 321.031,128.935 308.996,128.935 301.574,136.358L 248.07,189.861 Z M 289.582,231.373L 232.836,288.12L 240.453,295.737L 297.2,238.991L 289.582,231.373 Z M 232.836,288.12L 191.324,246.608L 137.821,300.111C 130.398,307.534 130.398,319.569 137.821,326.992L 152.452,341.623C 159.875,349.046 171.91,349.046 179.333,341.623L 232.836,288.12 Z M 191.324,246.608L 248.07,189.861L 240.453,182.244L 183.707,238.991L 191.324,246.608 Z M 253.315,251.852C 255.495,249.672 255.495,246.138 253.315,243.958C 251.135,241.778 247.601,241.778 245.421,243.958C 243.241,246.138 243.241,249.672 245.421,251.852C 247.601,254.032 251.135,254.032 253.315,251.852 Z M 235.271,269.896C 237.451,267.717 237.451,264.182 235.271,262.002C 233.091,259.822 229.556,259.822 227.376,262.002C 225.196,264.182 225.196,267.717 227.376,269.896C 229.556,272.077 233.091,272.077 235.271,269.896 Z M 271.359,233.809C 273.539,231.629 273.539,228.094 271.359,225.914C 269.179,223.734 265.644,223.734 263.464,225.914C 261.284,228.094 261.284,231.629 263.464,233.809C 265.644,235.989 269.179,235.989 271.359,233.809 Z M 235.486,234.023C 237.666,231.843 237.666,228.309 235.486,226.129C 233.306,223.949 229.771,223.949 227.591,226.129C 225.411,228.309 225.411,231.843 227.591,234.023C 229.771,236.203 233.306,236.203 235.486,234.023 Z M 217.442,252.067C 219.622,249.887 219.622,246.353 217.442,244.173C 215.262,241.993 211.727,241.993 209.547,244.173C 207.367,246.353 207.367,249.887 209.547,252.067C 211.727,254.247 215.262,254.247 217.442,252.067 Z M 253.53,215.979C 255.71,213.799 255.71,210.265 253.53,208.085C 251.35,205.905 247.815,205.905 245.635,208.085C 243.455,210.265 243.455,213.799 245.635,215.979C 247.815,218.159 251.35,218.159 253.53,215.979 Z M 334.194,126.317L 353.126,145.25C 363.568,155.692 363.568,172.622 353.126,183.064L 297.2,238.991L 353.126,294.917C 363.568,305.359 363.568,322.289 353.126,332.732L 334.194,351.664C 323.752,362.106 306.822,362.106 296.38,351.664L 240.453,295.737L 184.527,351.664C 174.084,362.106 157.154,362.106 146.712,351.664L 127.78,332.732C 117.338,322.289 117.338,305.359 127.78,294.917L 183.707,238.991L 127.78,183.064C 117.338,172.622 117.338,155.692 127.78,145.25L 146.712,126.318C 157.154,115.875 174.084,115.875 184.527,126.318L 240.453,182.244L 296.38,126.318C 306.822,115.875 323.752,115.875 334.194,126.317 Z ",
            eye: "M 349.943,192.816C 353.79,209.607 345.604,223.355 341.548,218.002C 321.074,196.481 291.853,180.14 240.803,180.14C 195.394,180.14 141.395,202.522 131.663,234.793C 130.839,232.063 128.494,234.793 131.663,224.233C 143.803,188.948 198.826,159.234 265.989,159.234C 316.361,159.234 346.03,167.63 349.943,192.816 Z M 224.012,243.188L 209.43,227.165C 207.876,231.401 207.385,236.692 207.385,242.433C 207.385,256.342 215.617,268.375 224.012,268.375C 240.803,268.375 257.594,259.979 257.594,243.188C 257.594,229.278 238.086,217.246 224.176,217.246C 221.994,217.246 220.084,217.524 218.413,218.045L 224.012,243.188 Z M 299.735,250.828C 299.735,283.284 268.787,309.596 240.967,309.596C 213.147,309.596 182.199,283.284 182.199,250.828C 182.199,232.076 192.529,215.376 206.618,204.616C 170.27,212.023 141.014,230.95 133.526,255.781C 143.258,288.052 189.753,310.352 240.803,310.352C 291.853,310.352 338.348,288.052 348.08,255.781C 340.622,231.053 311.576,212.179 275.436,204.708C 289.464,215.471 299.735,232.13 299.735,250.828 Z M 280.633,283.423C 284.181,279.111 287.039,274.209 289.039,268.888L 264.787,254.886C 263.82,260.607 260.841,265.644 256.604,269.245L 256.745,269.632L 256.389,269.426C 252.205,272.899 246.83,274.987 240.967,274.987L 240.826,274.987L 250.404,301.301C 256.041,300.254 261.354,298.286 266.182,295.558C 271.719,292.43 276.618,288.304 280.633,283.423 Z M 349.741,247.386C 349.875,248.771 349.943,250.17 349.943,251.584C 349.943,254.442 349.664,257.243 349.125,259.979C 342.32,294.497 294.038,318.747 240.803,318.747C 187.568,318.747 139.286,294.497 132.481,259.979C 131.941,257.243 131.663,254.442 131.663,251.584C 131.663,250.17 131.731,248.771 131.865,247.386C 135.425,210.652 185.435,184.421 240.803,184.421C 296.171,184.421 346.181,210.652 349.741,247.386 Z M 240.803,335.538L 240.803,327.142L 240.803,335.538 Z M 240.803,142.443L 240.803,150.839L 240.803,142.443 Z",
            timer: "M 346.944,236.425C 346.944,290.093 298.523,333.6 238.792,333.6C 179.062,333.6 130.64,290.093 130.64,236.425C 130.64,186.531 172.492,145.419 226.373,139.884L 226.373,136.022C 211.128,132.468 200.029,121.559 200.029,108.653C 200.029,92.8638 216.641,80.064 237.132,80.064C 257.623,80.064 274.235,92.8638 274.235,108.653C 274.235,121.528 263.19,132.415 248.003,135.996L 248.003,139.598C 266.312,140.985 283.322,146.471 297.894,155.03L 313.116,139.487L 313.581,139.835C 313.62,139.783 313.662,139.734 313.708,139.686C 315.542,137.779 322.03,140.116 328.199,144.906C 334.129,149.51 337.605,154.704 336.238,156.794L 337.022,157.382L 321.223,173.514C 337.265,190.466 346.944,212.43 346.944,236.425 Z M 248.003,132.297C 260.554,128.861 269.541,119.629 269.541,108.78C 269.541,95.0001 255.043,83.8294 237.16,83.8294C 219.277,83.8294 204.779,95.0001 204.779,108.78C 204.779,119.645 213.793,128.889 226.373,132.312L 226.373,122.218L 220.168,122.218L 220.168,102.783L 254.235,102.783L 254.235,122.218L 248.003,122.218L 248.003,132.297 Z M 238.792,148.968C 185.035,148.968 141.456,188.124 141.456,236.425C 141.456,284.727 185.035,323.883 238.792,323.883C 292.549,323.883 336.128,284.727 336.128,236.425C 336.128,188.124 292.549,148.968 238.792,148.968 Z M 291.264,180.523L 256.618,235C 256.697,235.615 256.738,236.24 256.738,236.874C 256.738,245.765 248.716,252.972 238.821,252.972C 228.926,252.972 220.904,245.765 220.904,236.874C 220.904,228.4 228.191,221.455 237.442,220.822L 291.264,180.523 Z M 187.778,207.084C 186.399,208.951 185.144,210.899 184.022,212.917L 159.076,199.977C 160.24,197.982 161.494,196.036 162.833,194.143L 187.778,207.084 Z M 211.527,188.204C 209.281,189.212 207.113,190.34 205.034,191.579L 190.632,169.166C 192.738,167.963 194.904,166.836 197.125,165.791L 211.527,188.204 Z M 159.076,274.963L 184.022,262.022C 185.143,264.041 186.399,265.988 187.778,267.856L 162.833,280.796C 161.494,278.904 160.24,276.958 159.076,274.963 Z M 190.632,305.774L 205.034,283.36C 207.113,284.6 209.28,285.728 211.527,286.736L 197.125,309.149C 194.904,308.103 192.738,306.977 190.632,305.774 Z M 314.872,280.796L 289.927,267.856C 291.306,265.988 292.562,264.041 293.684,262.022L 318.629,274.963C 317.465,276.958 316.211,278.904 314.872,280.796 Z M 280.581,309.149L 266.179,286.736C 268.425,285.728 270.593,284.6 272.671,283.36L 287.074,305.774C 284.967,306.977 282.801,308.103 280.581,309.149 Z M 293.684,212.917C 292.562,210.899 291.306,208.951 289.927,207.083L 314.872,194.143C 316.211,196.036 317.465,197.982 318.629,199.977L 293.684,212.917 Z M 272.671,191.579C 270.593,190.34 268.425,189.212 266.179,188.204L 280.581,165.79C 282.801,166.836 284.967,167.963 287.074,169.166L 272.671,191.579 Z M 328.788,240.84L 299.989,240.84C 300.064,239.725 300.102,238.601 300.102,237.47C 300.102,236.338 300.064,235.215 299.989,234.1L 328.788,234.1L 328.865,237.47L 328.788,240.84 Z M 148.917,234.1L 177.716,234.1C 177.641,235.214 177.603,236.338 177.603,237.47C 177.603,238.601 177.641,239.725 177.716,240.839L 148.917,240.839L 148.841,237.47L 148.917,234.1 Z M 235.102,318.277L 235.102,292.401C 236.343,292.468 237.593,292.503 238.853,292.503C 240.112,292.503 241.363,292.468 242.603,292.401L 242.603,318.277L 238.853,318.346L 235.102,318.277 Z M 235.102,182.538L 235.102,156.662L 238.853,156.593L 242.603,156.662L 242.603,182.538C 241.363,182.471 240.112,182.437 238.853,182.437C 237.593,182.437 236.343,182.471 235.102,182.538 Z",
            chip: "M 136.738,226.451L 170.519,226.451L 170.519,195.786L 136.738,195.786L 136.738,170.707L 170.519,170.707L 170.519,135.695C 170.519,130.129 175.032,125.617 180.598,125.617L 300.309,125.617C 305.875,125.617 310.387,130.129 310.387,135.695L 310.387,170.707L 344.168,170.707L 344.168,195.786L 310.387,195.786L 310.387,226.451L 344.168,226.451L 344.168,251.53L 310.387,251.53L 310.387,282.184L 344.168,282.184L 344.168,307.263L 310.387,307.263L 310.387,342.286C 310.387,347.852 305.875,352.364 300.309,352.364L 180.598,352.364C 175.032,352.364 170.519,347.852 170.519,342.286L 170.519,307.263L 136.738,307.263L 136.738,282.184L 170.519,282.184L 170.519,251.53L 136.738,251.53L 136.738,226.451 Z ",
            "delete": " M 248,316C 231,316 215,311 202,302L 314,190C 323,203 328,219 328,236C 328,280 292,316 248,316 Z M 248,155C 264,155 280,160 293,169L 181,281C 172,268 167,252 167,236C 167,191 203,155 248,155 Z M 248,125C 187,125 137,174 137,236C 137,297 187,346 248,346C 309,346 358,297 358,236C 358,174 309,125 248,125 Z ",
            clock2: "M 240,83.3306C 326,83.3306 396,153 396,238C 396,324 326,394 240,394C 154,394 84.7931,324 84.7931,238C 84.7931,153 154,83.3306 240,83.3306 Z M 240,117C 173,117 119,172 119,238C 119,305 173,360 240,360C 307,360 361,305 361,238C 361,172 307,117 240,117 Z M 226,134L 257,134L 257,222L 344,222L 344,254L 257,254L 226,254L 226,222L 226,134 Z ",
            brokenheart: "M 330.477,132.197C 356.937,138.77 391.78,171.336 377.523,214.52C 363.524,256.922 300.573,315.649 236.736,374.673L 236.661,377.192L 236.462,377.511L 236.458,377.474C 236.027,377.024 235.597,376.574 235.166,376.125C 234.604,376.645 234.041,377.165 233.478,377.686L 234.248,375.165C 173.755,311.965 113.848,249.002 102.394,205.56C 90.7992,161.586 128.204,131.166 155.016,126.221C 181.828,121.275 198.047,141.805 213.619,155.886L 213.62,155.898L 216.057,174.84L 207.556,193.875L 234.339,205.886L 223.103,240.42L 244.574,264.845L 225.139,285.432L 246.366,312.2L 228.578,323.124L 237.755,340.49L 236.989,366.187L 244.202,342.568L 239.924,323.398L 259.961,317.546L 246.537,286.132L 270.708,271.392L 256.431,242.173L 276.367,211.819L 253.695,193.176L 266.91,177.053L 269.626,158.078C 286.004,144.978 304.064,125.636 330.477,132.197 Z ",
            wholeheart: "M 298.517,129.106C 306.097,129.106 313.441,130.486 320.548,133.247C 327.655,136.007 333.928,140.168 339.366,145.73C 344.805,151.292 349.162,158.296 352.437,166.742C 355.712,175.188 357.35,185.159 357.35,196.653C 357.35,209.467 355.3,221.404 351.201,232.466C 347.102,243.529 341.715,253.932 335.04,263.675C 328.366,273.419 320.837,282.545 312.452,291.053C 304.068,299.56 295.581,307.687 286.991,315.433C 278.401,323.178 270.099,330.594 262.086,337.681C 254.072,344.767 247.182,351.709 241.414,358.507L 239.683,358.507C 233.915,351.709 227.066,344.767 219.135,337.681C 211.204,330.594 202.943,323.178 194.353,315.433C 185.763,307.687 177.276,299.56 168.892,291.053C 160.507,282.545 152.978,273.419 146.304,263.675C 139.629,253.932 134.243,243.529 130.143,232.466C 126.044,221.404 123.994,209.467 123.994,196.653C 123.994,185.159 125.632,175.188 128.907,166.742C 132.183,158.296 136.539,151.292 141.978,145.73C 147.416,140.168 153.689,136.007 160.796,133.247C 167.903,130.486 175.247,129.106 182.827,129.106C 190.12,129.106 196.681,130.064 202.511,131.98C 208.34,133.896 213.593,136.491 218.27,139.767C 222.946,143.042 227.045,146.76 230.568,150.922C 234.09,155.083 237.129,159.326 239.683,163.652L 241.414,163.652C 244.009,159.326 247.099,155.083 250.684,150.922C 254.268,146.76 258.398,143.042 263.074,139.767C 267.751,136.491 273.004,133.896 278.833,131.98C 284.663,130.064 291.224,129.106 298.517,129.106 Z ",
            plug: "M 359.701,173.023C 369.366,173.023 377.202,180.858 377.202,190.524C 377.202,200.19 369.366,208.025 359.701,208.025L 286.266,208.025L 286.266,269.956L 359.701,269.956C 369.366,269.956 377.202,277.791 377.202,287.457C 377.202,297.123 369.366,304.958 359.701,304.958L 286.266,304.958L 286.266,341.604L 208.803,341.604L 208.803,341.45C 181.438,341.366 159.277,317.007 159.277,286.97L 159.277,286.88L 159.277,279.85L 159.277,272.47L 107.202,272.47L 107.202,205.511L 159.277,205.511L 159.277,190.702L 159.418,190.701C 159.495,160.685 181.702,136.377 209.085,136.377L 209.203,136.377L 286.266,136.377L 286.266,173.023L 359.701,173.023 Z ",
            diamond: "M 196.624,189.138L 162.308,129.7L 230.941,129.7L 196.624,189.138 Z M 283.757,189.138L 249.441,129.7L 318.074,129.7L 283.757,189.138 Z M 327.492,129.7L 361.809,189.138L 293.176,189.138L 327.492,129.7 Z M 240.51,129.7L 274.826,189.138L 206.193,189.138L 240.51,129.7 Z M 153.415,129.7L 187.731,189.138L 119.098,189.138L 153.415,129.7 Z M 240.453,392.787L 119.062,199.376L 191.65,199.376L 240.453,392.787L 206.066,199.376L 274.841,199.377L 240.453,392.787L 289.257,199.377L 361.844,199.376L 240.453,392.787 Z ",
            cloudupload: "M 307.457,322.847L 263.012,278.402L 263.012,377.169L 233.382,377.169L 233.382,278.402L 188.937,322.847L 188.937,288.279L 248.197,229.019L 307.457,288.279L 307.457,322.847 Z M 134.171,193.154L 134.264,193.154L 152.596,193.154C 155.211,174.969 170.855,160.995 189.763,160.995C 196.549,160.995 202.914,162.795 208.407,165.943C 220.476,139.797 246.926,121.653 277.612,121.653C 318.303,121.653 351.542,153.555 353.684,193.71C 374.206,197.034 389.875,214.834 389.875,236.294C 389.875,260.12 370.561,279.434 346.735,279.434L 312.878,279.434L 298.847,265.403L 342.068,265.403L 342.068,265.08C 357.647,264.738 370.171,252.001 370.171,236.34C 370.171,220.679 357.647,207.942 342.068,207.6L 342.068,207.593L 341.424,207.593L 337.448,207.593C 337.984,204.35 338.263,201.021 338.263,197.626C 338.263,164.096 311.081,136.915 277.552,136.915C 246.798,136.915 221.385,159.782 217.388,189.441C 212.187,181.43 203.163,176.132 192.901,176.132C 176.789,176.132 163.728,189.193 163.728,205.305L 163.816,207.593L 135.032,207.593C 119.156,207.593 106.286,220.464 106.286,236.34C 106.286,252.216 119.156,265.087 135.032,265.087L 135.032,265.403L 197.548,265.403L 183.516,279.434L 134.171,279.434C 110.345,279.434 91.031,260.119 91.031,236.294C 91.031,212.468 110.346,193.154 134.171,193.154 Z ",
            emptyplay: "M 368.719,238.991L 178.28,343.579L 178.28,134.402L 368.719,238.991 Z M 333.017,238.991L 195.594,163.519L 195.594,314.463L 333.017,238.991 Z ",
            braces: "M 162.632,350.534C 136.692,350.21 123.722,337.172 123.722,311.421L 123.722,273.524C 123.722,256.527 116.804,247.61 102.97,246.773L 102.97,231.209C 116.804,230.371 123.722,221.278 123.722,203.931L 123.722,167.087C 123.722,140.985 136.692,127.772 162.632,127.447L 162.632,143.012C 148.798,143.363 141.88,151.78 141.88,168.263L 141.88,205.674C 141.88,223.535 135.476,234.505 122.668,238.585L 122.668,239.112C 135.476,242.922 141.88,253.785 141.88,271.7L 141.88,308.503C 141.88,317.906 143.427,324.627 146.521,328.667C 149.615,332.707 154.985,334.808 162.632,334.97L 162.632,350.534 Z M 377.937,246.773C 364.102,247.61 357.184,256.527 357.184,273.524L 357.184,311.421C 357.184,337.172 344.214,350.21 318.274,350.534L 318.274,334.97C 325.786,334.808 331.122,332.686 334.284,328.606C 337.445,324.526 339.026,317.825 339.026,308.503L 339.026,271.7C 339.026,253.785 345.43,242.922 358.238,239.112L 358.238,238.585C 345.43,234.505 339.026,223.535 339.026,205.674L 339.026,168.263C 339.026,151.78 332.109,143.363 318.274,143.012L 318.274,127.447C 344.214,127.772 357.184,140.985 357.184,167.087L 357.184,203.931C 357.184,221.278 364.102,230.371 377.937,231.209L 377.937,246.773 Z M 179.21,177.142L 194.321,177.142L 301.697,177.142L 301.697,207.604L 194.321,207.604L 194.321,285.313L 255.16,285.313L 255.16,300.839L 179.21,300.839L 179.21,292.62L 179.21,285.313L 179.209,207.604L 179.21,177.142 Z M 201.558,213.199L 268.948,213.199L 268.948,243.661L 201.558,243.661L 201.558,213.199 Z M 201.229,249.256L 293.972,249.256L 293.972,279.718L 201.229,279.718L 201.229,249.256 Z ",
            wand: "M 341.424,128.115L 351.527,138.218L 323.055,166.69L 312.952,156.587L 341.424,128.115 Z M 351.123,249.865L 341.02,259.968L 312.548,231.496L 322.651,221.393L 351.123,249.865 Z M 257.44,156.183L 247.337,166.286L 218.865,137.814L 228.968,127.711L 257.44,156.183 Z M 372.71,189.221L 372.71,203.509L 332.444,203.509L 332.444,189.221L 372.71,189.221 Z M 291.446,147.61L 277.158,147.61L 277.158,107.344L 291.446,107.344L 291.446,147.61 Z M 281.85,158.275L 320.558,196.984L 146.905,370.637L 108.196,331.929L 281.85,158.275 Z M 234.93,216.045L 119.152,331.823L 147.01,359.681L 262.789,243.903L 234.93,216.045 Z ",
            commandline: "M 108.874,328.138L 372.032,328.138L 372.032,149.843L 108.874,149.843L 108.874,328.138 Z M 188.674,271.59L 141.412,304.72L 141.412,286.282L 175.317,265.526L 175.317,265.206L 141.412,242.848L 141.412,224.262L 188.674,258.969L 188.674,271.59 Z M 200.548,287.425L 241.265,287.425L 241.265,302.664L 200.548,302.664L 200.548,287.425 Z ",
            split: "M 168.96,188.271L 130.92,226.311L 215.453,226.311L 215.453,251.67L 130.92,251.67L 168.96,289.71L 139.373,289.71L 88.6535,238.99L 139.373,188.271L 168.96,188.271 Z M 311.946,289.71L 349.986,251.671L 265.453,251.671L 265.453,226.311L 349.986,226.311L 311.946,188.271L 341.533,188.271L 392.253,238.991L 341.533,289.71L 311.946,289.71 Z M 226.511,75.2216L 254.395,75.2216L 254.395,402.76L 226.511,402.76L 226.511,75.2216 Z ",
            "package": "M 142.374,266.405L 233.787,266.405L 233.787,350.836L 142.374,350.836L 142.374,266.405 Z M 247.119,266.405L 338.532,266.405L 338.532,350.836L 247.119,350.836L 247.119,266.405 Z M 350.276,186.1L 350.276,254.025L 247.119,254.025L 247.119,191.217C 245.407,191.325 243.69,191.427 241.973,191.529C 241.966,191.6 241.959,191.67 241.952,191.74L 233.788,191.24L 233.788,254.025L 130.63,254.025L 130.63,186.1L 197.792,186.1C 191.84,184.338 186.527,181.957 182.152,178.668C 168.397,168.327 163.909,149.012 172.104,135.939C 180.298,122.867 201.175,116.039 215.515,120.428C 229.855,124.818 237.66,140.427 240.977,154.182C 241.177,155.013 241.361,155.837 241.53,156.655C 241.677,155.953 241.837,155.246 242.008,154.535C 245.28,140.966 252.979,125.569 267.125,121.238C 281.272,116.908 301.865,123.644 309.949,136.539C 318.033,149.434 313.606,168.488 300.037,178.689C 295.655,181.983 290.32,184.354 284.34,186.1L 350.276,186.1 Z M 232.489,181.725C 233.312,173.359 234.135,164.993 231.803,155.323C 229.472,145.654 223.986,134.682 213.905,131.596C 203.824,128.51 189.149,133.31 183.388,142.499C 177.628,151.689 180.782,165.267 190.452,172.536C 200.121,179.805 216.305,180.765 232.489,181.725 Z M 250.381,181.706C 266.346,180.758 282.311,179.811 291.85,172.641C 301.388,165.47 304.5,152.075 298.818,143.01C 293.135,133.945 278.658,129.21 268.714,132.254C 258.769,135.298 253.357,146.122 251.057,155.661C 248.757,165.199 249.569,173.452 250.381,181.706 Z ",
            smiliesad: "M 197.203,320.447C 191.802,320.447 187.205,318.673 183.41,315.127C 179.615,311.58 177.717,307.325 177.717,302.362C 177.717,297.341 179.615,293.028 183.41,289.423C 187.205,285.818 191.802,284.015 197.203,284.015C 202.691,284.015 207.355,285.818 211.193,289.423C 215.032,293.028 216.951,297.341 216.951,302.362C 216.951,307.325 215.032,311.58 211.193,315.127C 207.355,318.673 202.691,320.447 197.203,320.447 Z M 197.203,211.151C 191.802,211.151 187.205,209.378 183.41,205.831C 179.615,202.284 177.717,198.03 177.717,193.067C 177.717,188.046 179.615,183.733 183.41,180.127C 187.205,176.522 191.802,174.72 197.203,174.72C 202.691,174.72 207.355,176.522 211.193,180.127C 215.032,183.733 216.951,188.046 216.951,193.067C 216.951,198.03 215.032,202.284 211.193,205.831C 207.355,209.378 202.691,211.151 197.203,211.151 Z M 320.642,362.484L 292.618,362.484C 264.593,330.168 250.581,290.321 250.581,242.942C 250.581,195.388 264.593,154.898 292.618,121.473L 320.642,121.473C 292.618,156.153 278.605,196.555 278.605,242.679C 278.605,288.394 292.618,328.329 320.642,362.484 Z ",
            signalalt: "M 125.019,266.274L 169.669,266.274L 169.669,324.752L 125.019,324.752L 125.019,266.274 Z M 183.23,228.487L 227.88,228.487L 227.88,324.752L 183.23,324.752L 183.23,228.487 Z M 241.441,192.022L 286.091,192.022L 286.091,324.752L 241.441,324.752L 241.441,192.022 Z M 299.32,155.063L 343.97,155.063L 343.97,324.752L 299.32,324.752L 299.32,155.063 Z M 305.697,162.256L 305.697,317.208L 337.594,317.208L 337.594,162.256L 305.697,162.256 Z M 247.817,200.291L 247.817,317.208L 279.714,317.208L 279.714,200.291L 247.817,200.291 Z M 189.317,235.184L 189.317,317.208L 221.214,317.208L 221.214,235.184L 189.317,235.184 Z M 131.065,274.708L 131.065,317.208L 162.962,317.208L 162.962,274.708L 131.065,274.708 Z ",
            signal: "M 125.011,266.081L 169.661,266.081L 169.661,324.559L 125.011,324.559L 125.011,266.081 Z M 183.222,228.294L 227.872,228.294L 227.872,324.559L 183.222,324.559L 183.222,228.294 Z M 241.432,191.83L 286.082,191.83L 286.082,324.559L 241.432,324.559L 241.432,191.83 Z M 299.312,154.87L 343.962,154.87L 343.962,324.559L 299.312,324.559L 299.312,154.87 Z ",
            lock: "M 151.624,205.982L 167.789,205.982C 171.332,160.444 202.513,124.832 240.453,124.832C 278.394,124.832 309.574,160.444 313.118,205.982L 329.282,205.982L 329.282,353.149L 151.624,353.149L 151.624,205.982 Z M 240.453,149.899C 216.112,149.899 196.02,177.033 193.033,205.982L 287.874,205.982C 284.886,177.033 264.794,149.899 240.453,149.899 Z M 240.453,244.36C 231.985,244.36 225.12,251.225 225.12,259.693C 225.12,265.145 227.965,269.932 232.251,272.651L 227.403,315.19L 253.503,315.19L 248.655,272.651C 252.941,269.932 255.786,265.145 255.786,259.693C 255.786,251.225 248.921,244.36 240.453,244.36 Z ",
            emptycircle: "M 240.453,101.462C 316.408,101.462 377.982,163.036 377.982,238.991C 377.982,314.946 316.408,376.519 240.453,376.519C 164.498,376.519 102.924,314.946 102.924,238.991C 102.924,163.036 164.498,101.462 240.453,101.462 Z M 240.453,135.773C 183.447,135.773 137.235,181.985 137.235,238.991C 137.235,295.996 183.447,342.209 240.453,342.209C 297.459,342.209 343.671,295.996 343.671,238.991C 343.671,181.985 297.459,135.773 240.453,135.773 Z ",
            group: "M 146.602,137.257C 155.992,137.257 163.608,144.873 163.608,154.267C 163.608,163.658 155.992,171.273 146.602,171.273C 137.208,171.273 129.591,163.658 129.591,154.267C 129.591,144.873 137.208,137.257 146.602,137.257 Z M 129.227,179.743L 163.558,179.743C 169.226,179.743 174.86,181.722 178.867,185.115C 182.87,188.511 185.201,193.284 185.201,198.083L 185.201,199.566L 185.201,200.123L 185.201,271.383C 185.255,274.768 181.679,277.873 177.779,277.835C 173.931,277.797 170.47,274.719 170.523,271.383L 170.523,209.123L 165.841,209.123L 165.841,268.76L 165.815,268.76L 165.815,332.839C 165.849,334.913 165.007,336.983 163.544,338.449C 162.076,339.916 160.002,340.754 157.93,340.724C 153.865,340.66 150.226,336.902 150.287,332.839L 150.287,268.76L 142.523,268.76L 142.523,332.839C 142.557,334.913 141.715,336.983 140.252,338.449C 138.785,339.916 136.711,340.754 134.638,340.724C 130.573,340.66 126.934,336.902 126.995,332.839L 126.995,268.76L 126.972,268.76L 126.972,209.123L 122.264,209.123L 122.264,270.484C 122.302,273.869 118.719,276.963 114.818,276.914C 110.986,276.864 107.551,273.805 107.585,270.484L 107.585,199.202L 107.585,198.569L 107.585,198.083C 107.585,193.284 109.916,188.511 113.923,185.115C 117.927,181.722 123.56,179.743 129.227,179.743 Z M 240.662,137.257C 250.052,137.257 257.668,144.873 257.668,154.267C 257.668,163.658 250.052,171.273 240.662,171.273C 231.267,171.273 223.651,163.658 223.651,154.267C 223.651,144.873 231.267,137.257 240.662,137.257 Z M 223.287,179.743L 257.618,179.743C 263.286,179.743 268.92,181.722 272.927,185.115C 276.93,188.511 279.261,193.284 279.261,198.083L 279.261,199.566L 279.261,200.123L 279.261,271.383C 279.315,274.768 275.739,277.873 271.839,277.835C 267.991,277.797 264.53,274.719 264.583,271.383L 264.583,209.123L 259.901,209.123L 259.901,268.76L 259.875,268.76L 259.875,332.839C 259.909,334.912 259.067,336.983 257.604,338.449C 256.136,339.916 254.062,340.754 251.989,340.724C 247.925,340.66 244.286,336.902 244.347,332.839L 244.347,268.76L 236.583,268.76L 236.583,332.839C 236.617,334.912 235.775,336.983 234.312,338.449C 232.844,339.916 230.77,340.754 228.697,340.724C 224.633,340.66 220.994,336.902 221.055,332.839L 221.055,268.76L 221.032,268.76L 221.032,209.123L 216.324,209.123L 216.324,270.484C 216.362,273.869 212.778,276.963 208.878,276.914C 205.046,276.864 201.611,273.805 201.645,270.484L 201.645,199.202L 201.645,198.569L 201.645,198.083C 201.645,193.284 203.976,188.511 207.983,185.115C 211.987,181.722 217.62,179.743 223.287,179.743 Z M 334.722,137.258C 344.112,137.258 351.728,144.873 351.728,154.267C 351.728,163.658 344.112,171.273 334.722,171.273C 325.327,171.273 317.711,163.658 317.711,154.267C 317.711,144.873 325.327,137.258 334.722,137.258 Z M 317.347,179.743L 351.678,179.743C 357.346,179.743 362.98,181.722 366.987,185.115C 370.99,188.511 373.321,193.284 373.321,198.083L 373.321,199.566L 373.321,200.123L 373.321,271.383C 373.375,274.768 369.799,277.873 365.899,277.835C 362.051,277.797 358.59,274.719 358.642,271.383L 358.642,209.123L 353.961,209.123L 353.961,268.76L 353.935,268.76L 353.935,332.839C 353.969,334.913 353.127,336.983 351.664,338.449C 350.196,339.916 348.122,340.754 346.049,340.724C 341.985,340.66 338.345,336.902 338.407,332.839L 338.407,268.76L 330.643,268.76L 330.643,332.839C 330.677,334.913 329.835,336.983 328.372,338.449C 326.904,339.916 324.83,340.754 322.757,340.724C 318.693,340.66 315.054,336.902 315.115,332.839L 315.115,268.76L 315.091,268.76L 315.091,209.123L 310.384,209.123L 310.384,270.484C 310.421,273.869 306.838,276.963 302.938,276.914C 299.105,276.864 295.671,273.805 295.705,270.484L 295.705,199.202L 295.705,198.569L 295.705,198.083C 295.705,193.284 298.036,188.511 302.043,185.115C 306.046,181.722 311.68,179.743 317.347,179.743 Z ",
            im: "M 393.488,206.958L 393.488,321.247L 357.423,321.247L 357.423,369.234L 328.898,321.247L 196.081,321.247L 196.081,206.958L 393.488,206.958 Z M 87.4178,146.461L 292.537,146.461L 292.537,193.312L 182.971,193.312L 182.971,265.214L 154.531,265.214L 124.892,315.075L 124.892,265.214L 87.4178,265.214L 87.4178,146.461 Z ",
            arrowdownl: "M 183.668,152.318L 141.826,194.16L 141.826,337.618L 285.284,337.618L 327.126,295.776L 219.532,295.776L 339.08,176.228L 303.216,140.364L 183.668,259.911L 183.668,152.318 Z ",
            blockeditor: "M 291.345,115.775C 359.131,119.293 411.588,177.379 408.425,245.148C 404.906,312.946 346.532,365.37 278.767,362.207C 247.808,360.803 220,347.803 199.579,327.738L 209.998,317.088C 227.904,334.688 252.181,346.11 279.378,347.353L 279.473,347.353C 339.239,350.124 390.47,304.138 393.55,244.421C 396.342,184.655 350.368,133.746 290.639,130.649C 259.036,129.1 230.084,141.134 209.387,161.831L 198.853,151.297C 222.42,127.73 255.551,114.036 291.345,115.775 Z M 330.947,239.837L 261.91,291.7L 261.91,187.962L 330.947,239.837 Z M 94.3721,159.556L 179.659,159.556C 185.931,159.556 191.498,162.764 195.239,167.509C 198.981,172.233 201.128,178.543 201.128,185.365L 201.128,292.732C 201.128,299.554 198.981,305.748 195.239,310.493C 191.498,315.217 185.931,318.446 179.659,318.446L 146.623,318.446C 144.797,318.446 142.493,316.815 141.861,315.539C 141.234,314.284 141.345,313.169 141.345,313.169L 141.345,312.558L 141.461,311.926L 145.169,298.104L 145.074,298.104C 145.846,294.991 145.768,291.811 144.748,289.54C 142.927,285.571 140.024,283.085 137.331,282.714L 137.121,282.714L 136.815,282.619L 135.096,282.413C 135.165,282.457 133.721,282.809 132.475,283.651L 132.359,283.651L 132.264,283.746C 130.249,284.956 128.345,287.475 127.313,291.088C 126.925,292.443 126.925,294.264 127.313,295.618L 127.313,295.924L 130.926,312.042L 131.137,312.653L 131.137,313.169L 131.021,313.896C 130.976,314.428 130.765,315.799 129.588,316.993C 128.395,318.186 127.119,318.38 126.586,318.446L 125.765,318.446L 94.0665,318.446C 87.7896,318.446 82.2272,315.217 78.4859,310.493C 74.7239,305.748 72.5972,299.554 72.5972,292.732L 72.5972,263.309L 72.5972,262.583L 72.5972,260.518L 72.4816,254.629L 72.4816,248.645L 72.4816,246.581L 72.5972,245.664L 72.8078,244.821L 73.324,243.599L 73.7246,242.967L 74.4513,242.241L 75.6943,241.534L 77.5485,241.113L 78.4859,241.113L 79.4026,241.534L 93.5503,247.097L 93.6453,247.097C 95.3425,247.807 99.567,247.13 100.777,245.664C 101.826,244.194 102.164,244.21 102.536,243.599C 102.953,242.889 103.535,241.613 103.663,238.627L 103.663,238.532C 103.969,233.193 103.486,233.032 102.115,229.968C 100.872,227.226 98.7452,225.545 96.6474,224.69C 94.5496,223.852 92.584,224.306 92.6129,224.29L 92.4229,224.385L 92.0967,224.5L 85.5969,227.692L 82.1942,229.241C 81.2279,229.691 81.0007,229.984 79.8238,230.368L 79.0021,230.579L 78.2753,230.579L 75.6943,229.968L 74.4513,228.82L 73.9352,228.114L 73.6296,227.597L 73.324,226.565L 73.2084,225.838L 73.2084,224.806L 73.1134,221.919L 72.9978,213.45L 72.9028,201.156L 72.9028,186.092C 72.5642,171.684 81.8555,159.556 94.3721,159.556 Z M 94.3721,169.458C 88.438,169.458 82.5328,175.785 82.8053,185.881L 82.8053,201.156L 82.921,213.334L 83.0159,217.885L 87.6616,215.725L 88.0828,215.609C 91.9687,213.528 96.2427,213.85 100.356,215.514C 104.617,217.224 108.714,220.643 111.101,225.838L 111.196,225.933C 112.472,228.807 113.925,232.565 113.587,239.048C 113.376,243.372 112.294,246.486 111.006,248.645C 109.68,250.838 107.954,252.841 108.825,251.532L 108.615,251.743L 108.52,251.858C 103.791,257.615 96.1643,258.841 89.937,256.293L 89.842,256.293L 82.4048,253.291L 82.4048,254.534L 82.4997,260.423L 82.4997,262.372L 82.4997,263.309L 82.4997,292.732C 82.4997,297.473 84.0153,301.619 86.2287,304.394C 88.4214,307.185 91.0974,308.523 94.0665,308.523L 120.086,308.523L 117.716,298.315L 117.716,298.104C 116.828,294.892 116.795,291.605 117.716,288.392C 119.294,282.858 122.539,278.167 127.007,275.392L 127.313,275.277C 129.811,273.65 132.198,272.506 135.056,272.506L 138.669,272.906L 139.185,273.022L 139.185,273.117C 146.057,274.277 151.008,279.456 153.734,285.295L 153.734,285.41C 155.992,290.378 155.959,295.701 154.766,300.475L 154.766,300.57L 154.671,300.57L 152.606,308.523L 179.659,308.523C 182.624,308.523 185.304,307.185 187.496,304.394C 189.689,301.619 191.205,297.473 191.205,292.732L 191.205,185.365C 191.205,180.624 189.689,176.478 187.496,173.703C 185.304,170.912 182.624,169.458 179.659,169.458L 94.3721,169.458 Z ",
            bitcompile: "M 185.748,120.291L 226.777,161.32L 226.777,88.4853L 254.129,88.4853L 254.13,161.32L 295.159,120.291L 295.159,152.202L 240.453,206.908L 185.748,152.202L 185.748,120.291 Z M 283.951,302.191C 283.951,293.063 291.357,285.652 300.492,285.652C 309.638,285.652 317.027,293.063 317.027,302.191C 317.027,311.322 309.638,318.739 300.492,318.739C 291.357,318.739 283.951,311.322 283.951,302.191 Z M 162.457,302.194C 162.457,293.065 169.87,285.652 179.005,285.652C 188.134,285.652 195.542,293.065 195.542,302.194C 195.542,311.325 188.134,318.741 179.005,318.741C 169.87,318.741 162.457,311.325 162.457,302.194 Z M 179.001,220.264L 301.555,220.466C 347.222,220.466 383.84,257.019 383.84,302.198C 383.84,347.377 347.083,384.132 301.903,384.132L 179.001,384.132C 133.824,384.132 97.0666,347.377 97.0666,302.198C 97.0666,257.019 133.824,220.264 179.001,220.264 Z M 129.837,302.198C 129.837,329.303 151.896,351.362 179.001,351.362L 301.903,351.362C 329.01,351.362 351.062,329.303 351.062,302.198C 351.062,275.086 329.01,253.034 301.903,253.034L 179.001,253.034C 151.896,253.034 129.837,275.086 129.837,302.198 Z ",
            bitload: "M 295.158,156.941L 254.13,115.912L 254.13,188.747L 226.777,188.747L 226.777,115.912L 185.748,156.941L 185.748,125.029L 240.453,70.3241L 295.158,125.029L 295.158,156.941 Z M 283.951,300.514C 283.951,291.385 291.357,283.974 300.492,283.974C 309.639,283.974 317.027,291.385 317.027,300.514C 317.027,309.645 309.639,317.061 300.492,317.061C 291.357,317.061 283.951,309.645 283.951,300.514 Z M 162.457,300.516C 162.457,291.387 169.87,283.974 179.005,283.974C 188.134,283.974 195.542,291.387 195.542,300.516C 195.542,309.647 188.134,317.064 179.005,317.064C 169.87,317.064 162.457,309.647 162.457,300.516 Z M 179.001,218.586L 301.555,218.788C 347.222,218.788 383.84,255.341 383.84,300.52C 383.84,345.699 347.083,382.454 301.903,382.454L 179.001,382.454C 133.824,382.454 97.0667,345.699 97.0667,300.52C 97.0667,255.341 133.824,218.586 179.001,218.586 Z M 129.837,300.52C 129.837,327.625 151.896,349.684 179.001,349.684L 301.903,349.684C 329.01,349.684 351.062,327.625 351.062,300.52C 351.062,273.409 329.01,251.357 301.903,251.357L 179.001,251.357C 151.896,251.357 129.837,273.409 129.837,300.52 Z ",
        };
        var gelIcons = {
            alert: "M42,34v-6c-0.2-4.6-3.6-8.4-8-9.3V16h-4v2.7c-4.4,0.9-7.8,4.7-8,9.3v6l-6,8h32L42,34z M28,44 l8,0 l0,4 l-8,0 z",
            create: "M48,36H36v12h-8V36H16v-8h12V16h8v12h12V36z",
            edit: "M17.1,39.5v7.4h7.4l0.9-0.8l-7.5-7.5L17.1,39.5z M19.8,36.7L40.5,16l7.4,7.4L27.3,44.1L19.8,36.7z",
            duplicate: "M45.4,19.1h-5.8L32.5,12H14v29h12.9v7.7h25.9V26.5L45.4,19.1z M26.9,24.1h-5.5v2.8h5.5v0.9h-5.5v2.8h5.5v0.9h-5.5v2.8h5.5V39H17V15h14.9l4.1,4.1h-9.1V24.1z M50,45.9H29.7v-24h15.1l5.2,5.2C50,27.1,50,45.9,50,45.9z M34.3,31.1h11.1v2.8H34.3V31.1z M34.3,34.8h11.1v2.8H34.3V34.8z M34.3,38.5h11.1v2.8H34.3V38.5z",
            import: "M31.2,39l2,2H15V15h26v21.9l3,3V33h5v16H33v-5h7.5L22,25.3l3.6-3.7L39,34.9V17H17v22H31.2z",
            info: "M32,16c-8.8,0-16,7.2-16,16s7.2,16,16,16s16-7.2,16-16S40.8,16,32,16z M34,41h-4V29h4V41z M34,27h-4v-4h4V27z",
            left: "M19,32l26,16v-7.2L30.4,32L45,23.2V16L19,32z",
            love: "M45.4,20.6c-3.5-3.5-9-3.5-12.5,0c-0.3,0.3-0.6,0.7-0.9,1.1c-0.3-0.4-0.6-0.7-0.9-1.1c-3.5-3.5-9-3.5-12.5,0c-3.5,3.5-3.5,9,0,12.5L32,46.5l13.4-13.4C48.9,29.6,48.9,24,45.4,20.6z",
            pairnew: "M38.1,26.5c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2S39.2,26.5,38.1,26.5z M23.1,26.4c-1.1,0-2.1,0.9-2.1,2s0.9,2.1,2.1,2.1c1.1,0,2-0.9,2-2.1C25.1,27.3,24.2,26.4,23.1,26.4z M48.4,28.5c0-5.5-4.5-10.1-10.1-10.1H23.1c-5.5,0-10.1,4.5-10.1,10.1c0,5.5,4.5,10.1,10.1,10.1h15.2C43.9,38.6,48.4,34,48.4,28.5z M38.3,34.5H23.1c-3.4,0-6.1-2.7-6.1-6.1s2.7-6.1,6.1-6.1h15.2c3.4,0,6.1,2.7,6.1,6.1C44.4,31.8,41.7,34.5,38.3,34.5z M52,38.8v-5.3h-3.5v5.3h-5.3v3.5h5.3v5.2H52v-5.2h5.2v-3.5H52z",
            play: "M21,48l26-16L21,16V48z",
            print: "M40,32H24V16h13l3,3V32z M42,28v4v2h-2H24h-2v-2v-4h-6v12.1l5.9,5.9H22v-5h20v5h0.1l5.9-5.9V28H42z M24,48h16v-5H24V48z",
            publish: "M32.2,28.8L21.3,39.7l2.6,2.7l6.3-6.3v11.3h4.1V36.1l6.3,6.3l2.6-2.7L32.2,28.8z M26.2,32.3l1.3-1.3c-0.2-0.1-0.3-0.2-0.4-0.3c0.1-0.1,0.3-0.2,0.4-0.4c0.3-0.3,0.3-0.4-0.1-0.6c-0.4-0.4-0.7-0.7-1.1-1.2c-0.1-0.1,0-0.2-0.1-0.3c-0.1-0.4-0.1-0.8-0.2-1.2c-0.2-0.5-0.4-1.1-0.6-1.6c-0.1-0.4-0.2-0.7-0.2-1.1c0.1-0.7,0.4-0.9,1-0.4c0.5,0.5,1.1,1.1,1.6,1.6c0.4,0.4,0.8,0.7,1.3,1c0.3,0.3,0.6,0.2,0.9,0c0.1-0.1,0.3-0.2,0.4-0.3c0.4-0.3,0.8-0.5,1.3-0.7c0.5-0.2,1.1,0.2,1.1,0.7c0,0.1,0,0.3,0,0.4l0.7,0.7l4.8,4.9l1.2-1c2-1.9,3.2-4.6,3.2-7.5c0-5.7-4.7-10.4-10.4-10.4S21.9,18,21.9,23.7C21.8,27.3,23.5,30.4,26.2,32.3z M29.9,16.2c0.4-0.2,0.7,0,1,0.3c0.7,0.5,1.3,1.3,1.9,1.9c0.4,0.5,1,0.9,1.6,1.1c0.2,0.1,0.4,0.2,0.6,0.3c0.4,0.3,0.8,0.5,0.9,1.1c0.1,0.4,0.3,0.4,0.5,0.4c0.4-0.2,1-0.4,1.4-0.5c0.5-0.2,1.1-0.2,1.6-0.1c0.2,0.1,0.4,0.1,0.6,0.2c0.4,1,0.6,2,0.6,3.1c0,1.4-0.4,2.8-1,3.9c-0.7,0.2-1.3-0.1-1.5-0.9c-0.1-0.4-0.2-1-0.1-1.5c0.1-0.6,0.4-1.2,0.5-1.8c0.1-0.4,0.3-0.9,0.4-1.3c0.1-0.3-0.1-0.4-0.4-0.5s-0.5-0.1-0.9-0.1c-0.3,0-0.4,0-0.7-0.1c-0.4-0.1-0.7-0.1-1,0.2c-0.4,0.3-0.7,0.6-1.1,0.9c-0.6,0.4-1.3,0.8-2.2,0.9c-0.8,0.1-1.5-0.1-1.9-0.9c-0.3-0.5-0.4-1.2-0.6-1.7c-0.3-0.8-0.4-1.5-0.7-2.3c-0.1-0.4-0.3-0.8-0.3-1.3C29.4,16.8,29.5,16.3,29.9,16.2z",
            right: "M45,32L19,16v7.2L33.6,32L19,40.8V48L45,32z",
            save: "M42.5,15H16v31.6h30.9V19.4L42.5,15z M31.4,17.8h3.9V25h-3.9V17.8z M37.5,43.8H25.2v-9.4h12.4L37.5,43.8L37.5,43.8z M44.1,43.8h-4V32H22.7v11.9h-3.9v-26h6.1v9.7h12.9v-9.7h4.1l2.2,2.2C44.1,20.1,44.1,43.8,44.1,43.8z",
            search: "M48,44.5l-8.2-8.2c3.4-5.1,2.9-12-1.6-16.5C35.7,17.3,32.3,16,29,16s-6.7,1.3-9.2,3.8c-5.1,5.1-5.1,13.3,0,18.4c2.5,2.5,5.9,3.8,9.2,3.8c2.5,0,5-0.7,7.2-2.2l8.3,8.2L48,44.5z M22.6,35.3c-1.7-1.7-2.6-4-2.6-6.4c0-2.4,0.9-4.7,2.6-6.4c1.7-1.6,4-2.5,6.4-2.5s4.7,0.9,6.4,2.6c3.5,3.5,3.5,9.2,0,12.7c-1.7,1.7-4,2.6-6.4,2.6S24.3,37,22.6,35.3z",
            share: "M21.2,37.8c1.6,0,3-0.7,4-1.8l9,4.8c-0.1,0.4-0.2,0.8-0.2,1.3c0,3,2.5,5.5,5.5,5.5s5.5-2.4,5.5-5.5c0-3-2.5-5.5-5.5-5.5c-1.6,0-3,0.7-4,1.8L26,33.2v-2.7l9.7-5.5c1,1,2.3,1.5,3.8,1.5c3,0,5.5-2.5,5.5-5.5s-2.5-5.5-5.5-5.5S34,17.9,34,21c0,0.6,0.1,1.1,0.2,1.6L25 28.4c-1-0.9-2.3-1.5-3.8-1.5c-3,0-5.5,2.4-5.5,5.5C15.8,35.3,18.2,37.8,21.2,37.8z",
            trash: "M40,47.5l-1,0.9l-1-0.9V26h-5v21.5l-1.1,0.9L31,47.5V26h-5v21.5l-1,0.9l-1-0.9V26h-4.2l0.4,25h23.6l0.4-25H40V47.5z M28,16.5c0-0.2,0-0.4,1-0.4l0,0L28.6,16h7.6c0.2,0,0.8,0.3,0.8,0.5V17h2v-0.5c0-1.6-1.2-2.5-2.8-2.5h-7.6l0.4-0.4l0,0c-2,0-3,1.3-3,2.9V17h2V16.5z M45.5,21c0-1-1.1-2-2.9-2h-22c-1.1,0-2.7,0.8-2.7,2.2V25h28v-4H45.5z",
            uninstall: "M35.5,32L48,19.6L44.4,16L32,28.5L19.6,16L16,19.6L28.5,32L15.9,44.5l3.6,3.6L32,35.5L44.5,48l3.6-3.5L35.5,32z",
            upload: "M43.1,31.9L32.3,21.2L21.6,31.9l2.4,2.5l6-6.2V42h-9v-5h-2v6h2.1h2.1h7.1h3.9H34V28.2l6.4,6.2L43.1,31.9zM42,37v5h-7v1h2h4.4H44v-2.5V37H42z",
        };
        var iconMapping = {
            document: "fa-file-o",
            copy: "fa-files-o",
            paste: "fa-clipboard",
            recyclelib: "fa-recycle",
            settings: "fa-cogs",
            setting: "fa-cogs",
            chapback: "fa-fast-backward",
            save: "gel-save",
            email: "fa-envelope-o",
            cycle: "fa-refresh",
            folder: "fa-folder-open",
            video: "fa-video-camera",
            rewind: "fa-backward",
            sharethis: "gel-share",
            subtract: "fa-minus",
            heart: "gel-love",
            award: "fa-trophy",
            person: "fa-user",
            art: "fa-paint-brush",
            videoptr: "fa-video-camera",
            bbc: "play",
            edit: "gel-edit",
            upload: "gel-publish",
            play: "gel-play",
            clone: "gel-duplicate",
            search: "gel-search",
            print: "gel-print",
            info: "gel-info",
            cursorleft: "gel-left",
            cursorright: "gel-right",
        };
        var fontAwesomeIconsByDaveGandy = {
            "cutlery": "M640 1472v-640q0 -61 -35.5 -111t-92.5 -70v-779q0 -52 -38 -90t-90 -38h-128q-52 0 -90 38t-38 90v779q-57 20 -92.5 70t-35.5 111v640q0 26 19 45t45 19t45 -19t19 -45v-416q0 -26 19 -45t45 -19t45 19t19 45v416q0 26 19 45t45 19t45 -19t19 -45v-416q0 -26 19 -45 t45 -19t45 19t19 45v416q0 26 19 45t45 19t45 -19t19 -45zM1408 1472v-1600q0 -52 -38 -90t-90 -38h-128q-52 0 -90 38t-38 90v512h-224q-13 0 -22.5 9.5t-9.5 22.5v800q0 132 94 226t226 94h256q26 0 45 -19t19 -45z",
            "rocket": "M1440 1088q0 40 -28 68t-68 28t-68 -28t-28 -68t28 -68t68 -28t68 28t28 68zM1664 1376q0 -249 -75.5 -430.5t-253.5 -360.5q-81 -80 -195 -176l-20 -379q-2 -16 -16 -26l-384 -224q-7 -4 -16 -4q-12 0 -23 9l-64 64q-13 14 -8 32l85 276l-281 281l-276 -85q-3 -1 -9 -1 q-14 0 -23 9l-64 64q-17 19 -5 39l224 384q10 14 26 16l379 20q96 114 176 195q188 187 358 258t431 71q14 0 24 -9.5t10 -22.5z",
            "code-fork": "M288 64q0 40 -28 68t-68 28t-68 -28t-28 -68t28 -68t68 -28t68 28t28 68zM288 1216q0 40 -28 68t-68 28t-68 -28t-28 -68t28 -68t68 -28t68 28t28 68zM928 1088q0 40 -28 68t-68 28t-68 -28t-28 -68t28 -68t68 -28t68 28t28 68zM1024 1088q0 -52 -26 -96.5t-70 -69.5 q-2 -287 -226 -414q-68 -38 -203 -81q-128 -40 -169.5 -71t-41.5 -100v-26q44 -25 70 -69.5t26 -96.5q0 -80 -56 -136t-136 -56t-136 56t-56 136q0 52 26 96.5t70 69.5v820q-44 25 -70 69.5t-26 96.5q0 80 56 136t136 56t136 -56t56 -136q0 -52 -26 -96.5t-70 -69.5v-497 q54 26 154 57q55 17 87.5 29.5t70.5 31t59 39.5t40.5 51t28 69.5t8.5 91.5q-44 25 -70 69.5t-26 96.5q0 80 56 136t136 56t136 -56t56 -136z",
            "indent": "M352 704q0 -14 -9 -23l-288 -288q-9 -9 -23 -9q-13 0 -22.5 9.5t-9.5 22.5v576q0 13 9.5 22.5t22.5 9.5q14 0 23 -9l288 -288q9 -9 9 -23zM1792 224v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-1728q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5t22.5 9.5h1728q13 0 22.5 -9.5 t9.5 -22.5zM1792 608v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-1088q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5t22.5 9.5h1088q13 0 22.5 -9.5t9.5 -22.5zM1792 992v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-1088q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5t22.5 9.5h1088 q13 0 22.5 -9.5t9.5 -22.5zM1792 1376v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-1728q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5t22.5 9.5h1728q13 0 22.5 -9.5t9.5 -22.5z",
            "history": "M1536 640q0 -156 -61 -298t-164 -245t-245 -164t-298 -61q-172 0 -327 72.5t-264 204.5q-7 10 -6.5 22.5t8.5 20.5l137 138q10 9 25 9q16 -2 23 -12q73 -95 179 -147t225 -52q104 0 198.5 40.5t163.5 109.5t109.5 163.5t40.5 198.5t-40.5 198.5t-109.5 163.5 t-163.5 109.5t-198.5 40.5q-98 0 -188 -35.5t-160 -101.5l137 -138q31 -30 14 -69q-17 -40 -59 -40h-448q-26 0 -45 19t-19 45v448q0 42 40 59q39 17 69 -14l130 -129q107 101 244.5 156.5t284.5 55.5q156 0 298 -61t245 -164t164 -245t61 -298zM896 928v-448q0 -14 -9 -23 t-23 -9h-320q-14 0 -23 9t-9 23v64q0 14 9 23t23 9h224v352q0 14 9 23t23 9h64q14 0 23 -9t9 -23z",
            "file-image-o": "M1468 1156q28 -28 48 -76t20 -88v-1152q0 -40 -28 -68t-68 -28h-1344q-40 0 -68 28t-28 68v1600q0 40 28 68t68 28h896q40 0 88 -20t76 -48zM1024 1400v-376h376q-10 29 -22 41l-313 313q-12 12 -41 22zM1408 -128v1024h-416q-40 0 -68 28t-28 68v416h-768v-1536h1280z M1280 320v-320h-1024v192l192 192l128 -128l384 384zM448 512q-80 0 -136 56t-56 136t56 136t136 56t136 -56t56 -136t-56 -136t-136 -56z",
            "trash": "M512 160v704q0 14 -9 23t-23 9h-64q-14 0 -23 -9t-9 -23v-704q0 -14 9 -23t23 -9h64q14 0 23 9t9 23zM768 160v704q0 14 -9 23t-23 9h-64q-14 0 -23 -9t-9 -23v-704q0 -14 9 -23t23 -9h64q14 0 23 9t9 23zM1024 160v704q0 14 -9 23t-23 9h-64q-14 0 -23 -9t-9 -23v-704 q0 -14 9 -23t23 -9h64q14 0 23 9t9 23zM480 1152h448l-48 117q-7 9 -17 11h-317q-10 -2 -17 -11zM1408 1120v-64q0 -14 -9 -23t-23 -9h-96v-948q0 -83 -47 -143.5t-113 -60.5h-832q-66 0 -113 58.5t-47 141.5v952h-96q-14 0 -23 9t-9 23v64q0 14 9 23t23 9h309l70 167 q15 37 54 63t79 26h320q40 0 79 -26t54 -63l70 -167h309q14 0 23 -9t9 -23z",
            "binoculars": "M704 1216v-768q0 -26 -19 -45t-45 -19v-576q0 -26 -19 -45t-45 -19h-512q-26 0 -45 19t-19 45v512l249 873q7 23 31 23h424zM1024 1216v-704h-256v704h256zM1792 320v-512q0 -26 -19 -45t-45 -19h-512q-26 0 -45 19t-19 45v576q-26 0 -45 19t-19 45v768h424q24 0 31 -23z M736 1504v-224h-352v224q0 14 9 23t23 9h288q14 0 23 -9t9 -23zM1408 1504v-224h-352v224q0 14 9 23t23 9h288q14 0 23 -9t9 -23z",
            "globe": "M768 1408q209 0 385.5 -103t279.5 -279.5t103 -385.5t-103 -385.5t-279.5 -279.5t-385.5 -103t-385.5 103t-279.5 279.5t-103 385.5t103 385.5t279.5 279.5t385.5 103zM1042 887q-2 -1 -9.5 -9.5t-13.5 -9.5q2 0 4.5 5t5 11t3.5 7q6 7 22 15q14 6 52 12q34 8 51 -11 q-2 2 9.5 13t14.5 12q3 2 15 4.5t15 7.5l2 22q-12 -1 -17.5 7t-6.5 21q0 -2 -6 -8q0 7 -4.5 8t-11.5 -1t-9 -1q-10 3 -15 7.5t-8 16.5t-4 15q-2 5 -9.5 10.5t-9.5 10.5q-1 2 -2.5 5.5t-3 6.5t-4 5.5t-5.5 2.5t-7 -5t-7.5 -10t-4.5 -5q-3 2 -6 1.5t-4.5 -1t-4.5 -3t-5 -3.5 q-3 -2 -8.5 -3t-8.5 -2q15 5 -1 11q-10 4 -16 3q9 4 7.5 12t-8.5 14h5q-1 4 -8.5 8.5t-17.5 8.5t-13 6q-8 5 -34 9.5t-33 0.5q-5 -6 -4.5 -10.5t4 -14t3.5 -12.5q1 -6 -5.5 -13t-6.5 -12q0 -7 14 -15.5t10 -21.5q-3 -8 -16 -16t-16 -12q-5 -8 -1.5 -18.5t10.5 -16.5 q2 -2 1.5 -4t-3.5 -4.5t-5.5 -4t-6.5 -3.5l-3 -2q-11 -5 -20.5 6t-13.5 26q-7 25 -16 30q-23 8 -29 -1q-5 13 -41 26q-25 9 -58 4q6 1 0 15q-7 15 -19 12q3 6 4 17.5t1 13.5q3 13 12 23q1 1 7 8.5t9.5 13.5t0.5 6q35 -4 50 11q5 5 11.5 17t10.5 17q9 6 14 5.5t14.5 -5.5 t14.5 -5q14 -1 15.5 11t-7.5 20q12 -1 3 17q-5 7 -8 9q-12 4 -27 -5q-8 -4 2 -8q-1 1 -9.5 -10.5t-16.5 -17.5t-16 5q-1 1 -5.5 13.5t-9.5 13.5q-8 0 -16 -15q3 8 -11 15t-24 8q19 12 -8 27q-7 4 -20.5 5t-19.5 -4q-5 -7 -5.5 -11.5t5 -8t10.5 -5.5t11.5 -4t8.5 -3 q14 -10 8 -14q-2 -1 -8.5 -3.5t-11.5 -4.5t-6 -4q-3 -4 0 -14t-2 -14q-5 5 -9 17.5t-7 16.5q7 -9 -25 -6l-10 1q-4 0 -16 -2t-20.5 -1t-13.5 8q-4 8 0 20q1 4 4 2q-4 3 -11 9.5t-10 8.5q-46 -15 -94 -41q6 -1 12 1q5 2 13 6.5t10 5.5q34 14 42 7l5 5q14 -16 20 -25 q-7 4 -30 1q-20 -6 -22 -12q7 -12 5 -18q-4 3 -11.5 10t-14.5 11t-15 5q-16 0 -22 -1q-146 -80 -235 -222q7 -7 12 -8q4 -1 5 -9t2.5 -11t11.5 3q9 -8 3 -19q1 1 44 -27q19 -17 21 -21q3 -11 -10 -18q-1 2 -9 9t-9 4q-3 -5 0.5 -18.5t10.5 -12.5q-7 0 -9.5 -16t-2.5 -35.5 t-1 -23.5l2 -1q-3 -12 5.5 -34.5t21.5 -19.5q-13 -3 20 -43q6 -8 8 -9q3 -2 12 -7.5t15 -10t10 -10.5q4 -5 10 -22.5t14 -23.5q-2 -6 9.5 -20t10.5 -23q-1 0 -2.5 -1t-2.5 -1q3 -7 15.5 -14t15.5 -13q1 -3 2 -10t3 -11t8 -2q2 20 -24 62q-15 25 -17 29q-3 5 -5.5 15.5 t-4.5 14.5q2 0 6 -1.5t8.5 -3.5t7.5 -4t2 -3q-3 -7 2 -17.5t12 -18.5t17 -19t12 -13q6 -6 14 -19.5t0 -13.5q9 0 20 -10t17 -20q5 -8 8 -26t5 -24q2 -7 8.5 -13.5t12.5 -9.5l16 -8t13 -7q5 -2 18.5 -10.5t21.5 -11.5q10 -4 16 -4t14.5 2.5t13.5 3.5q15 2 29 -15t21 -21 q36 -19 55 -11q-2 -1 0.5 -7.5t8 -15.5t9 -14.5t5.5 -8.5q5 -6 18 -15t18 -15q6 4 7 9q-3 -8 7 -20t18 -10q14 3 14 32q-31 -15 -49 18q0 1 -2.5 5.5t-4 8.5t-2.5 8.5t0 7.5t5 3q9 0 10 3.5t-2 12.5t-4 13q-1 8 -11 20t-12 15q-5 -9 -16 -8t-16 9q0 -1 -1.5 -5.5t-1.5 -6.5 q-13 0 -15 1q1 3 2.5 17.5t3.5 22.5q1 4 5.5 12t7.5 14.5t4 12.5t-4.5 9.5t-17.5 2.5q-19 -1 -26 -20q-1 -3 -3 -10.5t-5 -11.5t-9 -7q-7 -3 -24 -2t-24 5q-13 8 -22.5 29t-9.5 37q0 10 2.5 26.5t3 25t-5.5 24.5q3 2 9 9.5t10 10.5q2 1 4.5 1.5t4.5 0t4 1.5t3 6q-1 1 -4 3 q-3 3 -4 3q7 -3 28.5 1.5t27.5 -1.5q15 -11 22 2q0 1 -2.5 9.5t-0.5 13.5q5 -27 29 -9q3 -3 15.5 -5t17.5 -5q3 -2 7 -5.5t5.5 -4.5t5 0.5t8.5 6.5q10 -14 12 -24q11 -40 19 -44q7 -3 11 -2t4.5 9.5t0 14t-1.5 12.5l-1 8v18l-1 8q-15 3 -18.5 12t1.5 18.5t15 18.5q1 1 8 3.5 t15.5 6.5t12.5 8q21 19 15 35q7 0 11 9q-1 0 -5 3t-7.5 5t-4.5 2q9 5 2 16q5 3 7.5 11t7.5 10q9 -12 21 -2q7 8 1 16q5 7 20.5 10.5t18.5 9.5q7 -2 8 2t1 12t3 12q4 5 15 9t13 5l17 11q3 4 0 4q18 -2 31 11q10 11 -6 20q3 6 -3 9.5t-15 5.5q3 1 11.5 0.5t10.5 1.5 q15 10 -7 16q-17 5 -43 -12zM879 10q206 36 351 189q-3 3 -12.5 4.5t-12.5 3.5q-18 7 -24 8q1 7 -2.5 13t-8 9t-12.5 8t-11 7q-2 2 -7 6t-7 5.5t-7.5 4.5t-8.5 2t-10 -1l-3 -1q-3 -1 -5.5 -2.5t-5.5 -3t-4 -3t0 -2.5q-21 17 -36 22q-5 1 -11 5.5t-10.5 7t-10 1.5t-11.5 -7 q-5 -5 -6 -15t-2 -13q-7 5 0 17.5t2 18.5q-3 6 -10.5 4.5t-12 -4.5t-11.5 -8.5t-9 -6.5t-8.5 -5.5t-8.5 -7.5q-3 -4 -6 -12t-5 -11q-2 4 -11.5 6.5t-9.5 5.5q2 -10 4 -35t5 -38q7 -31 -12 -48q-27 -25 -29 -40q-4 -22 12 -26q0 -7 -8 -20.5t-7 -21.5q0 -6 2 -16z",
            "film": "M384 -64v128q0 26 -19 45t-45 19h-128q-26 0 -45 -19t-19 -45v-128q0 -26 19 -45t45 -19h128q26 0 45 19t19 45zM384 320v128q0 26 -19 45t-45 19h-128q-26 0 -45 -19t-19 -45v-128q0 -26 19 -45t45 -19h128q26 0 45 19t19 45zM384 704v128q0 26 -19 45t-45 19h-128 q-26 0 -45 -19t-19 -45v-128q0 -26 19 -45t45 -19h128q26 0 45 19t19 45zM1408 -64v512q0 26 -19 45t-45 19h-768q-26 0 -45 -19t-19 -45v-512q0 -26 19 -45t45 -19h768q26 0 45 19t19 45zM384 1088v128q0 26 -19 45t-45 19h-128q-26 0 -45 -19t-19 -45v-128q0 -26 19 -45 t45 -19h128q26 0 45 19t19 45zM1792 -64v128q0 26 -19 45t-45 19h-128q-26 0 -45 -19t-19 -45v-128q0 -26 19 -45t45 -19h128q26 0 45 19t19 45zM1408 704v512q0 26 -19 45t-45 19h-768q-26 0 -45 -19t-19 -45v-512q0 -26 19 -45t45 -19h768q26 0 45 19t19 45zM1792 320v128 q0 26 -19 45t-45 19h-128q-26 0 -45 -19t-19 -45v-128q0 -26 19 -45t45 -19h128q26 0 45 19t19 45zM1792 704v128q0 26 -19 45t-45 19h-128q-26 0 -45 -19t-19 -45v-128q0 -26 19 -45t45 -19h128q26 0 45 19t19 45zM1792 1088v128q0 26 -19 45t-45 19h-128q-26 0 -45 -19 t-19 -45v-128q0 -26 19 -45t45 -19h128q26 0 45 19t19 45zM1920 1248v-1344q0 -66 -47 -113t-113 -47h-1600q-66 0 -113 47t-47 113v1344q0 66 47 113t113 47h1600q66 0 113 -47t47 -113z",
            "headphones": "M1664 650q0 -166 -60 -314l-20 -49l-185 -33q-22 -83 -90.5 -136.5t-156.5 -53.5v-32q0 -14 -9 -23t-23 -9h-64q-14 0 -23 9t-9 23v576q0 14 9 23t23 9h64q14 0 23 -9t9 -23v-32q71 0 130 -35.5t93 -95.5l68 12q29 95 29 193q0 148 -88 279t-236.5 209t-315.5 78 t-315.5 -78t-236.5 -209t-88 -279q0 -98 29 -193l68 -12q34 60 93 95.5t130 35.5v32q0 14 9 23t23 9h64q14 0 23 -9t9 -23v-576q0 -14 -9 -23t-23 -9h-64q-14 0 -23 9t-9 23v32q-88 0 -156.5 53.5t-90.5 136.5l-185 33l-20 49q-60 148 -60 314q0 151 67 291t179 242.5 t266 163.5t320 61t320 -61t266 -163.5t179 -242.5t67 -291z",
            "file-text-o": "M1468 1156q28 -28 48 -76t20 -88v-1152q0 -40 -28 -68t-68 -28h-1344q-40 0 -68 28t-28 68v1600q0 40 28 68t68 28h896q40 0 88 -20t76 -48zM1024 1400v-376h376q-10 29 -22 41l-313 313q-12 12 -41 22zM1408 -128v1024h-416q-40 0 -68 28t-28 68v416h-768v-1536h1280z M384 736q0 14 9 23t23 9h704q14 0 23 -9t9 -23v-64q0 -14 -9 -23t-23 -9h-704q-14 0 -23 9t-9 23v64zM1120 512q14 0 23 -9t9 -23v-64q0 -14 -9 -23t-23 -9h-704q-14 0 -23 9t-9 23v64q0 14 9 23t23 9h704zM1120 256q14 0 23 -9t9 -23v-64q0 -14 -9 -23t-23 -9h-704 q-14 0 -23 9t-9 23v64q0 14 9 23t23 9h704z",
            "calculator": "M384 0q0 53 -37.5 90.5t-90.5 37.5t-90.5 -37.5t-37.5 -90.5t37.5 -90.5t90.5 -37.5t90.5 37.5t37.5 90.5zM768 0q0 53 -37.5 90.5t-90.5 37.5t-90.5 -37.5t-37.5 -90.5t37.5 -90.5t90.5 -37.5t90.5 37.5t37.5 90.5zM384 384q0 53 -37.5 90.5t-90.5 37.5t-90.5 -37.5 t-37.5 -90.5t37.5 -90.5t90.5 -37.5t90.5 37.5t37.5 90.5zM1152 0q0 53 -37.5 90.5t-90.5 37.5t-90.5 -37.5t-37.5 -90.5t37.5 -90.5t90.5 -37.5t90.5 37.5t37.5 90.5zM768 384q0 53 -37.5 90.5t-90.5 37.5t-90.5 -37.5t-37.5 -90.5t37.5 -90.5t90.5 -37.5t90.5 37.5 t37.5 90.5zM384 768q0 53 -37.5 90.5t-90.5 37.5t-90.5 -37.5t-37.5 -90.5t37.5 -90.5t90.5 -37.5t90.5 37.5t37.5 90.5zM1152 384q0 53 -37.5 90.5t-90.5 37.5t-90.5 -37.5t-37.5 -90.5t37.5 -90.5t90.5 -37.5t90.5 37.5t37.5 90.5zM768 768q0 53 -37.5 90.5t-90.5 37.5 t-90.5 -37.5t-37.5 -90.5t37.5 -90.5t90.5 -37.5t90.5 37.5t37.5 90.5zM1536 0v384q0 52 -38 90t-90 38t-90 -38t-38 -90v-384q0 -52 38 -90t90 -38t90 38t38 90zM1152 768q0 53 -37.5 90.5t-90.5 37.5t-90.5 -37.5t-37.5 -90.5t37.5 -90.5t90.5 -37.5t90.5 37.5t37.5 90.5z M1536 1088v256q0 26 -19 45t-45 19h-1280q-26 0 -45 -19t-19 -45v-256q0 -26 19 -45t45 -19h1280q26 0 45 19t19 45zM1536 768q0 53 -37.5 90.5t-90.5 37.5t-90.5 -37.5t-37.5 -90.5t37.5 -90.5t90.5 -37.5t90.5 37.5t37.5 90.5zM1664 1408v-1536q0 -52 -38 -90t-90 -38 h-1408q-52 0 -90 38t-38 90v1536q0 52 38 90t90 38h1408q52 0 90 -38t38 -90z",
            "check-square-o": "M1408 606v-318q0 -119 -84.5 -203.5t-203.5 -84.5h-832q-119 0 -203.5 84.5t-84.5 203.5v832q0 119 84.5 203.5t203.5 84.5h832q63 0 117 -25q15 -7 18 -23q3 -17 -9 -29l-49 -49q-10 -10 -23 -10q-3 0 -9 2q-23 6 -45 6h-832q-66 0 -113 -47t-47 -113v-832 q0 -66 47 -113t113 -47h832q66 0 113 47t47 113v254q0 13 9 22l64 64q10 10 23 10q6 0 12 -3q20 -8 20 -29zM1639 1095l-814 -814q-24 -24 -57 -24t-57 24l-430 430q-24 24 -24 57t24 57l110 110q24 24 57 24t57 -24l263 -263l647 647q24 24 57 24t57 -24l110 -110 q24 -24 24 -57t-24 -57z",
            "gift": "M928 180v56v468v192h-320v-192v-468v-56q0 -25 18 -38.5t46 -13.5h192q28 0 46 13.5t18 38.5zM472 1024h195l-126 161q-26 31 -69 31q-40 0 -68 -28t-28 -68t28 -68t68 -28zM1160 1120q0 40 -28 68t-68 28q-43 0 -69 -31l-125 -161h194q40 0 68 28t28 68zM1536 864v-320 q0 -14 -9 -23t-23 -9h-96v-416q0 -40 -28 -68t-68 -28h-1088q-40 0 -68 28t-28 68v416h-96q-14 0 -23 9t-9 23v320q0 14 9 23t23 9h440q-93 0 -158.5 65.5t-65.5 158.5t65.5 158.5t158.5 65.5q107 0 168 -77l128 -165l128 165q61 77 168 77q93 0 158.5 -65.5t65.5 -158.5 t-65.5 -158.5t-158.5 -65.5h440q14 0 23 -9t9 -23z",
            "paint-brush": "M1615 1536q70 0 122.5 -46.5t52.5 -116.5q0 -63 -45 -151q-332 -629 -465 -752q-97 -91 -218 -91q-126 0 -216.5 92.5t-90.5 219.5q0 128 92 212l638 579q59 54 130 54zM706 502q39 -76 106.5 -130t150.5 -76l1 -71q4 -213 -129.5 -347t-348.5 -134q-123 0 -218 46.5 t-152.5 127.5t-86.5 183t-29 220q7 -5 41 -30t62 -44.5t59 -36.5t46 -17q41 0 55 37q25 66 57.5 112.5t69.5 76t88 47.5t103 25.5t125 10.5z",
            "list-ol": "M381 -84q0 -80 -54.5 -126t-135.5 -46q-106 0 -172 66l57 88q49 -45 106 -45q29 0 50.5 14.5t21.5 42.5q0 64 -105 56l-26 56q8 10 32.5 43.5t42.5 54t37 38.5v1q-16 0 -48.5 -1t-48.5 -1v-53h-106v152h333v-88l-95 -115q51 -12 81 -49t30 -88zM383 543v-159h-362 q-6 36 -6 54q0 51 23.5 93t56.5 68t66 47.5t56.5 43.5t23.5 45q0 25 -14.5 38.5t-39.5 13.5q-46 0 -81 -58l-85 59q24 51 71.5 79.5t105.5 28.5q73 0 123 -41.5t50 -112.5q0 -50 -34 -91.5t-75 -64.5t-75.5 -50.5t-35.5 -52.5h127v60h105zM1792 224v-192q0 -13 -9.5 -22.5 t-22.5 -9.5h-1216q-13 0 -22.5 9.5t-9.5 22.5v192q0 14 9 23t23 9h1216q13 0 22.5 -9.5t9.5 -22.5zM384 1123v-99h-335v99h107q0 41 0.5 122t0.5 121v12h-2q-8 -17 -50 -54l-71 76l136 127h106v-404h108zM1792 736v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-1216q-13 0 -22.5 9.5 t-9.5 22.5v192q0 14 9 23t23 9h1216q13 0 22.5 -9.5t9.5 -22.5zM1792 1248v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-1216q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5t22.5 9.5h1216q13 0 22.5 -9.5t9.5 -22.5z",
            "gamepad": "M832 448v128q0 14 -9 23t-23 9h-192v192q0 14 -9 23t-23 9h-128q-14 0 -23 -9t-9 -23v-192h-192q-14 0 -23 -9t-9 -23v-128q0 -14 9 -23t23 -9h192v-192q0 -14 9 -23t23 -9h128q14 0 23 9t9 23v192h192q14 0 23 9t9 23zM1408 384q0 53 -37.5 90.5t-90.5 37.5t-90.5 -37.5 t-37.5 -90.5t37.5 -90.5t90.5 -37.5t90.5 37.5t37.5 90.5zM1664 640q0 53 -37.5 90.5t-90.5 37.5t-90.5 -37.5t-37.5 -90.5t37.5 -90.5t90.5 -37.5t90.5 37.5t37.5 90.5zM1920 512q0 -212 -150 -362t-362 -150q-192 0 -338 128h-220q-146 -128 -338 -128q-212 0 -362 150 t-150 362t150 362t362 150h896q212 0 362 -150t150 -362z",
            "user": "M1408 131q0 -120 -73 -189.5t-194 -69.5h-874q-121 0 -194 69.5t-73 189.5q0 53 3.5 103.5t14 109t26.5 108.5t43 97.5t62 81t85.5 53.5t111.5 20q9 0 42 -21.5t74.5 -48t108 -48t133.5 -21.5t133.5 21.5t108 48t74.5 48t42 21.5q61 0 111.5 -20t85.5 -53.5t62 -81 t43 -97.5t26.5 -108.5t14 -109t3.5 -103.5zM1088 1024q0 -159 -112.5 -271.5t-271.5 -112.5t-271.5 112.5t-112.5 271.5t112.5 271.5t271.5 112.5t271.5 -112.5t112.5 -271.5z",
            "file-o": "M1468 1156q28 -28 48 -76t20 -88v-1152q0 -40 -28 -68t-68 -28h-1344q-40 0 -68 28t-28 68v1600q0 40 28 68t68 28h896q40 0 88 -20t76 -48zM1024 1400v-376h376q-10 29 -22 41l-313 313q-12 12 -41 22zM1408 -128v1024h-416q-40 0 -68 28t-28 68v416h-768v-1536h1280z ",
            "bolt": "M885 970q18 -20 7 -44l-540 -1157q-13 -25 -42 -25q-4 0 -14 2q-17 5 -25.5 19t-4.5 30l197 808l-406 -101q-4 -1 -12 -1q-18 0 -31 11q-18 15 -13 39l201 825q4 14 16 23t28 9h328q19 0 32 -12.5t13 -29.5q0 -8 -5 -18l-171 -463l396 98q8 2 12 2q19 0 34 -15z",
            "book": "M1639 1058q40 -57 18 -129l-275 -906q-19 -64 -76.5 -107.5t-122.5 -43.5h-923q-77 0 -148.5 53.5t-99.5 131.5q-24 67 -2 127q0 4 3 27t4 37q1 8 -3 21.5t-3 19.5q2 11 8 21t16.5 23.5t16.5 23.5q23 38 45 91.5t30 91.5q3 10 0.5 30t-0.5 28q3 11 17 28t17 23 q21 36 42 92t25 90q1 9 -2.5 32t0.5 28q4 13 22 30.5t22 22.5q19 26 42.5 84.5t27.5 96.5q1 8 -3 25.5t-2 26.5q2 8 9 18t18 23t17 21q8 12 16.5 30.5t15 35t16 36t19.5 32t26.5 23.5t36 11.5t47.5 -5.5l-1 -3q38 9 51 9h761q74 0 114 -56t18 -130l-274 -906 q-36 -119 -71.5 -153.5t-128.5 -34.5h-869q-27 0 -38 -15q-11 -16 -1 -43q24 -70 144 -70h923q29 0 56 15.5t35 41.5l300 987q7 22 5 57q38 -15 59 -43zM575 1056q-4 -13 2 -22.5t20 -9.5h608q13 0 25.5 9.5t16.5 22.5l21 64q4 13 -2 22.5t-20 9.5h-608q-13 0 -25.5 -9.5 t-16.5 -22.5zM492 800q-4 -13 2 -22.5t20 -9.5h608q13 0 25.5 9.5t16.5 22.5l21 64q4 13 -2 22.5t-20 9.5h-608q-13 0 -25.5 -9.5t-16.5 -22.5z",
            "table": "M512 160v192q0 14 -9 23t-23 9h-320q-14 0 -23 -9t-9 -23v-192q0 -14 9 -23t23 -9h320q14 0 23 9t9 23zM512 544v192q0 14 -9 23t-23 9h-320q-14 0 -23 -9t-9 -23v-192q0 -14 9 -23t23 -9h320q14 0 23 9t9 23zM1024 160v192q0 14 -9 23t-23 9h-320q-14 0 -23 -9t-9 -23 v-192q0 -14 9 -23t23 -9h320q14 0 23 9t9 23zM512 928v192q0 14 -9 23t-23 9h-320q-14 0 -23 -9t-9 -23v-192q0 -14 9 -23t23 -9h320q14 0 23 9t9 23zM1024 544v192q0 14 -9 23t-23 9h-320q-14 0 -23 -9t-9 -23v-192q0 -14 9 -23t23 -9h320q14 0 23 9t9 23zM1536 160v192 q0 14 -9 23t-23 9h-320q-14 0 -23 -9t-9 -23v-192q0 -14 9 -23t23 -9h320q14 0 23 9t9 23zM1024 928v192q0 14 -9 23t-23 9h-320q-14 0 -23 -9t-9 -23v-192q0 -14 9 -23t23 -9h320q14 0 23 9t9 23zM1536 544v192q0 14 -9 23t-23 9h-320q-14 0 -23 -9t-9 -23v-192 q0 -14 9 -23t23 -9h320q14 0 23 9t9 23zM1536 928v192q0 14 -9 23t-23 9h-320q-14 0 -23 -9t-9 -23v-192q0 -14 9 -23t23 -9h320q14 0 23 9t9 23zM1664 1248v-1088q0 -66 -47 -113t-113 -47h-1344q-66 0 -113 47t-47 113v1088q0 66 47 113t113 47h1344q66 0 113 -47t47 -113 z",
            "list-ul": "M384 128q0 -80 -56 -136t-136 -56t-136 56t-56 136t56 136t136 56t136 -56t56 -136zM384 640q0 -80 -56 -136t-136 -56t-136 56t-56 136t56 136t136 56t136 -56t56 -136zM1792 224v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-1216q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5 t22.5 9.5h1216q13 0 22.5 -9.5t9.5 -22.5zM384 1152q0 -80 -56 -136t-136 -56t-136 56t-56 136t56 136t136 56t136 -56t56 -136zM1792 736v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-1216q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5t22.5 9.5h1216q13 0 22.5 -9.5t9.5 -22.5z M1792 1248v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-1216q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5t22.5 9.5h1216q13 0 22.5 -9.5t9.5 -22.5z",
            "th-list": "M512 288v-192q0 -40 -28 -68t-68 -28h-320q-40 0 -68 28t-28 68v192q0 40 28 68t68 28h320q40 0 68 -28t28 -68zM512 800v-192q0 -40 -28 -68t-68 -28h-320q-40 0 -68 28t-28 68v192q0 40 28 68t68 28h320q40 0 68 -28t28 -68zM1792 288v-192q0 -40 -28 -68t-68 -28h-960 q-40 0 -68 28t-28 68v192q0 40 28 68t68 28h960q40 0 68 -28t28 -68zM512 1312v-192q0 -40 -28 -68t-68 -28h-320q-40 0 -68 28t-28 68v192q0 40 28 68t68 28h320q40 0 68 -28t28 -68zM1792 800v-192q0 -40 -28 -68t-68 -28h-960q-40 0 -68 28t-28 68v192q0 40 28 68t68 28 h960q40 0 68 -28t28 -68zM1792 1312v-192q0 -40 -28 -68t-68 -28h-960q-40 0 -68 28t-28 68v192q0 40 28 68t68 28h960q40 0 68 -28t28 -68z",
            "subscript": "M897 167v-167h-248l-159 252l-24 42q-8 9 -11 21h-3l-9 -21q-10 -20 -25 -44l-155 -250h-258v167h128l197 291l-185 272h-137v168h276l139 -228q2 -4 23 -42q8 -9 11 -21h3q3 9 11 21l25 42l140 228h257v-168h-125l-184 -267l204 -296h109zM1536 -50v-206h-514l-4 27 q-3 45 -3 46q0 64 26 117t65 86.5t84 65t84 54.5t65 54t26 64q0 38 -29.5 62.5t-70.5 24.5q-51 0 -97 -39q-14 -11 -36 -38l-105 92q26 37 63 66q80 65 188 65q110 0 178 -59.5t68 -158.5q0 -66 -34.5 -118.5t-84 -86t-99.5 -62.5t-87 -63t-41 -73h232v80h126z",
            "list-alt": "M384 352v-64q0 -13 -9.5 -22.5t-22.5 -9.5h-64q-13 0 -22.5 9.5t-9.5 22.5v64q0 13 9.5 22.5t22.5 9.5h64q13 0 22.5 -9.5t9.5 -22.5zM384 608v-64q0 -13 -9.5 -22.5t-22.5 -9.5h-64q-13 0 -22.5 9.5t-9.5 22.5v64q0 13 9.5 22.5t22.5 9.5h64q13 0 22.5 -9.5t9.5 -22.5z M384 864v-64q0 -13 -9.5 -22.5t-22.5 -9.5h-64q-13 0 -22.5 9.5t-9.5 22.5v64q0 13 9.5 22.5t22.5 9.5h64q13 0 22.5 -9.5t9.5 -22.5zM1536 352v-64q0 -13 -9.5 -22.5t-22.5 -9.5h-960q-13 0 -22.5 9.5t-9.5 22.5v64q0 13 9.5 22.5t22.5 9.5h960q13 0 22.5 -9.5t9.5 -22.5z M1536 608v-64q0 -13 -9.5 -22.5t-22.5 -9.5h-960q-13 0 -22.5 9.5t-9.5 22.5v64q0 13 9.5 22.5t22.5 9.5h960q13 0 22.5 -9.5t9.5 -22.5zM1536 864v-64q0 -13 -9.5 -22.5t-22.5 -9.5h-960q-13 0 -22.5 9.5t-9.5 22.5v64q0 13 9.5 22.5t22.5 9.5h960q13 0 22.5 -9.5 t9.5 -22.5zM1664 160v832q0 13 -9.5 22.5t-22.5 9.5h-1472q-13 0 -22.5 -9.5t-9.5 -22.5v-832q0 -13 9.5 -22.5t22.5 -9.5h1472q13 0 22.5 9.5t9.5 22.5zM1792 1248v-1088q0 -66 -47 -113t-113 -47h-1472q-66 0 -113 47t-47 113v1088q0 66 47 113t113 47h1472q66 0 113 -47 t47 -113z",
            "facebook": "M959 1524v-264h-157q-86 0 -116 -36t-30 -108v-189h293l-39 -296h-254v-759h-306v759h-255v296h255v218q0 186 104 288.5t277 102.5q147 0 228 -12z",
            "twitter": "M1620 1128q-67 -98 -162 -167q1 -14 1 -42q0 -130 -38 -259.5t-115.5 -248.5t-184.5 -210.5t-258 -146t-323 -54.5q-271 0 -496 145q35 -4 78 -4q225 0 401 138q-105 2 -188 64.5t-114 159.5q33 -5 61 -5q43 0 85 11q-112 23 -185.5 111.5t-73.5 205.5v4q68 -38 146 -41 q-66 44 -105 115t-39 154q0 88 44 163q121 -149 294.5 -238.5t371.5 -99.5q-8 38 -8 74q0 134 94.5 228.5t228.5 94.5q140 0 236 -102q109 21 205 78q-37 -115 -142 -178q93 10 186 50z",
            "upload": "M1280 64q0 26 -19 45t-45 19t-45 -19t-19 -45t19 -45t45 -19t45 19t19 45zM1536 64q0 26 -19 45t-45 19t-45 -19t-19 -45t19 -45t45 -19t45 19t19 45zM1664 288v-320q0 -40 -28 -68t-68 -28h-1472q-40 0 -68 28t-28 68v320q0 40 28 68t68 28h427q21 -56 70.5 -92 t110.5 -36h256q61 0 110.5 36t70.5 92h427q40 0 68 -28t28 -68zM1339 936q-17 -40 -59 -40h-256v-448q0 -26 -19 -45t-45 -19h-256q-26 0 -45 19t-19 45v448h-256q-42 0 -59 40q-17 39 14 69l448 448q18 19 45 19t45 -19l448 -448q31 -30 14 -69z",
            "files-o": "M1696 1152q40 0 68 -28t28 -68v-1216q0 -40 -28 -68t-68 -28h-960q-40 0 -68 28t-28 68v288h-544q-40 0 -68 28t-28 68v672q0 40 20 88t48 76l408 408q28 28 76 48t88 20h416q40 0 68 -28t28 -68v-328q68 40 128 40h416zM1152 939l-299 -299h299v299zM512 1323l-299 -299 h299v299zM708 676l316 316v416h-384v-416q0 -40 -28 -68t-68 -28h-416v-640h512v256q0 40 20 88t48 76zM1664 -128v1152h-384v-416q0 -40 -28 -68t-68 -28h-416v-640h896z",
            "recycle": "M836 367l-15 -368l-2 -22l-420 29q-36 3 -67 31.5t-47 65.5q-11 27 -14.5 55t4 65t12 55t21.5 64t19 53q78 -12 509 -28zM449 953l180 -379l-147 92q-63 -72 -111.5 -144.5t-72.5 -125t-39.5 -94.5t-18.5 -63l-4 -21l-190 357q-17 26 -18 56t6 47l8 18q35 63 114 188 l-140 86zM1680 436l-188 -359q-12 -29 -36.5 -46.5t-43.5 -20.5l-18 -4q-71 -7 -219 -12l8 -164l-230 367l211 362l7 -173q170 -16 283 -5t170 33zM895 1360q-47 -63 -265 -435l-317 187l-19 12l225 356q20 31 60 45t80 10q24 -2 48.5 -12t42 -21t41.5 -33t36 -34.5 t36 -39.5t32 -35zM1550 1053l212 -363q18 -37 12.5 -76t-27.5 -74q-13 -20 -33 -37t-38 -28t-48.5 -22t-47 -16t-51.5 -14t-46 -12q-34 72 -265 436l313 195zM1407 1279l142 83l-220 -373l-419 20l151 86q-34 89 -75 166t-75.5 123.5t-64.5 80t-47 46.5l-17 13l405 -1 q31 3 58 -10.5t39 -28.5l11 -15q39 -61 112 -190z",
            "clipboard": "M768 -128h896v640h-416q-40 0 -68 28t-28 68v416h-384v-1152zM1024 1312v64q0 13 -9.5 22.5t-22.5 9.5h-704q-13 0 -22.5 -9.5t-9.5 -22.5v-64q0 -13 9.5 -22.5t22.5 -9.5h704q13 0 22.5 9.5t9.5 22.5zM1280 640h299l-299 299v-299zM1792 512v-672q0 -40 -28 -68t-68 -28 h-960q-40 0 -68 28t-28 68v160h-544q-40 0 -68 28t-28 68v1344q0 40 28 68t68 28h1088q40 0 68 -28t28 -68v-328q21 -13 36 -28l408 -408q28 -28 48 -76t20 -88z",
            "download": "M1280 192q0 26 -19 45t-45 19t-45 -19t-19 -45t19 -45t45 -19t45 19t19 45zM1536 192q0 26 -19 45t-45 19t-45 -19t-19 -45t19 -45t45 -19t45 19t19 45zM1664 416v-320q0 -40 -28 -68t-68 -28h-1472q-40 0 -68 28t-28 68v320q0 40 28 68t68 28h465l135 -136 q58 -56 136 -56t136 56l136 136h464q40 0 68 -28t28 -68zM1339 985q17 -41 -14 -70l-448 -448q-18 -19 -45 -19t-45 19l-448 448q-31 29 -14 70q17 39 59 39h256v448q0 26 19 45t45 19h256q26 0 45 -19t19 -45v-448h256q42 0 59 -39z",
            "camera": "M960 864q119 0 203.5 -84.5t84.5 -203.5t-84.5 -203.5t-203.5 -84.5t-203.5 84.5t-84.5 203.5t84.5 203.5t203.5 84.5zM1664 1280q106 0 181 -75t75 -181v-896q0 -106 -75 -181t-181 -75h-1408q-106 0 -181 75t-75 181v896q0 106 75 181t181 75h224l51 136 q19 49 69.5 84.5t103.5 35.5h512q53 0 103.5 -35.5t69.5 -84.5l51 -136h224zM960 128q185 0 316.5 131.5t131.5 316.5t-131.5 316.5t-316.5 131.5t-316.5 -131.5t-131.5 -316.5t131.5 -316.5t316.5 -131.5z",
            "cog": "M1024 640q0 106 -75 181t-181 75t-181 -75t-75 -181t75 -181t181 -75t181 75t75 181zM1536 749v-222q0 -12 -8 -23t-20 -13l-185 -28q-19 -54 -39 -91q35 -50 107 -138q10 -12 10 -25t-9 -23q-27 -37 -99 -108t-94 -71q-12 0 -26 9l-138 108q-44 -23 -91 -38 q-16 -136 -29 -186q-7 -28 -36 -28h-222q-14 0 -24.5 8.5t-11.5 21.5l-28 184q-49 16 -90 37l-141 -107q-10 -9 -25 -9q-14 0 -25 11q-126 114 -165 168q-7 10 -7 23q0 12 8 23q15 21 51 66.5t54 70.5q-27 50 -41 99l-183 27q-13 2 -21 12.5t-8 23.5v222q0 12 8 23t19 13 l186 28q14 46 39 92q-40 57 -107 138q-10 12 -10 24q0 10 9 23q26 36 98.5 107.5t94.5 71.5q13 0 26 -10l138 -107q44 23 91 38q16 136 29 186q7 28 36 28h222q14 0 24.5 -8.5t11.5 -21.5l28 -184q49 -16 90 -37l142 107q9 9 24 9q13 0 25 -10q129 -119 165 -170q7 -8 7 -22 q0 -12 -8 -23q-15 -21 -51 -66.5t-54 -70.5q26 -50 41 -98l183 -28q13 -2 21 -12.5t8 -23.5z",
            "cogs": "M896 640q0 106 -75 181t-181 75t-181 -75t-75 -181t75 -181t181 -75t181 75t75 181zM1664 128q0 52 -38 90t-90 38t-90 -38t-38 -90q0 -53 37.5 -90.5t90.5 -37.5t90.5 37.5t37.5 90.5zM1664 1152q0 52 -38 90t-90 38t-90 -38t-38 -90q0 -53 37.5 -90.5t90.5 -37.5 t90.5 37.5t37.5 90.5zM1280 731v-185q0 -10 -7 -19.5t-16 -10.5l-155 -24q-11 -35 -32 -76q34 -48 90 -115q7 -10 7 -20q0 -12 -7 -19q-23 -30 -82.5 -89.5t-78.5 -59.5q-11 0 -21 7l-115 90q-37 -19 -77 -31q-11 -108 -23 -155q-7 -24 -30 -24h-186q-11 0 -20 7.5t-10 17.5 l-23 153q-34 10 -75 31l-118 -89q-7 -7 -20 -7q-11 0 -21 8q-144 133 -144 160q0 9 7 19q10 14 41 53t47 61q-23 44 -35 82l-152 24q-10 1 -17 9.5t-7 19.5v185q0 10 7 19.5t16 10.5l155 24q11 35 32 76q-34 48 -90 115q-7 11 -7 20q0 12 7 20q22 30 82 89t79 59q11 0 21 -7 l115 -90q34 18 77 32q11 108 23 154q7 24 30 24h186q11 0 20 -7.5t10 -17.5l23 -153q34 -10 75 -31l118 89q8 7 20 7q11 0 21 -8q144 -133 144 -160q0 -9 -7 -19q-12 -16 -42 -54t-45 -60q23 -48 34 -82l152 -23q10 -2 17 -10.5t7 -19.5zM1920 198v-140q0 -16 -149 -31 q-12 -27 -30 -52q51 -113 51 -138q0 -4 -4 -7q-122 -71 -124 -71q-8 0 -46 47t-52 68q-20 -2 -30 -2t-30 2q-14 -21 -52 -68t-46 -47q-2 0 -124 71q-4 3 -4 7q0 25 51 138q-18 25 -30 52q-149 15 -149 31v140q0 16 149 31q13 29 30 52q-51 113 -51 138q0 4 4 7q4 2 35 20 t59 34t30 16q8 0 46 -46.5t52 -67.5q20 2 30 2t30 -2q51 71 92 112l6 2q4 0 124 -70q4 -3 4 -7q0 -25 -51 -138q17 -23 30 -52q149 -15 149 -31zM1920 1222v-140q0 -16 -149 -31q-12 -27 -30 -52q51 -113 51 -138q0 -4 -4 -7q-122 -71 -124 -71q-8 0 -46 47t-52 68 q-20 -2 -30 -2t-30 2q-14 -21 -52 -68t-46 -47q-2 0 -124 71q-4 3 -4 7q0 25 51 138q-18 25 -30 52q-149 15 -149 31v140q0 16 149 31q13 29 30 52q-51 113 -51 138q0 4 4 7q4 2 35 20t59 34t30 16q8 0 46 -46.5t52 -67.5q20 2 30 2t30 -2q51 71 92 112l6 2q4 0 124 -70 q4 -3 4 -7q0 -25 -51 -138q17 -23 30 -52q149 -15 149 -31z",
            "floppy-o": "M384 0h768v384h-768v-384zM1280 0h128v896q0 14 -10 38.5t-20 34.5l-281 281q-10 10 -34 20t-39 10v-416q0 -40 -28 -68t-68 -28h-576q-40 0 -68 28t-28 68v416h-128v-1280h128v416q0 40 28 68t68 28h832q40 0 68 -28t28 -68v-416zM896 928v320q0 13 -9.5 22.5t-22.5 9.5 h-192q-13 0 -22.5 -9.5t-9.5 -22.5v-320q0 -13 9.5 -22.5t22.5 -9.5h192q13 0 22.5 9.5t9.5 22.5zM1536 896v-928q0 -40 -28 -68t-68 -28h-1344q-40 0 -68 28t-28 68v1344q0 40 28 68t68 28h928q40 0 88 -20t76 -48l280 -280q28 -28 48 -76t20 -88z",
            "refresh": "M1511 480q0 -5 -1 -7q-64 -268 -268 -434.5t-478 -166.5q-146 0 -282.5 55t-243.5 157l-129 -129q-19 -19 -45 -19t-45 19t-19 45v448q0 26 19 45t45 19h448q26 0 45 -19t19 -45t-19 -45l-137 -137q71 -66 161 -102t187 -36q134 0 250 65t186 179q11 17 53 117 q8 23 30 23h192q13 0 22.5 -9.5t9.5 -22.5zM1536 1280v-448q0 -26 -19 -45t-45 -19h-448q-26 0 -45 19t-19 45t19 45l138 138q-148 137 -349 137q-134 0 -250 -65t-186 -179q-11 -17 -53 -117q-8 -23 -30 -23h-199q-13 0 -22.5 9.5t-9.5 22.5v7q65 268 270 434.5t480 166.5 q146 0 284 -55.5t245 -156.5l130 129q19 19 45 19t45 -19t19 -45z",
            "envelope-o": "M1664 32v768q-32 -36 -69 -66q-268 -206 -426 -338q-51 -43 -83 -67t-86.5 -48.5t-102.5 -24.5h-1h-1q-48 0 -102.5 24.5t-86.5 48.5t-83 67q-158 132 -426 338q-37 30 -69 66v-768q0 -13 9.5 -22.5t22.5 -9.5h1472q13 0 22.5 9.5t9.5 22.5zM1664 1083v11v13.5t-0.5 13 t-3 12.5t-5.5 9t-9 7.5t-14 2.5h-1472q-13 0 -22.5 -9.5t-9.5 -22.5q0 -168 147 -284q193 -152 401 -317q6 -5 35 -29.5t46 -37.5t44.5 -31.5t50.5 -27.5t43 -9h1h1q20 0 43 9t50.5 27.5t44.5 31.5t46 37.5t35 29.5q208 165 401 317q54 43 100.5 115.5t46.5 131.5z M1792 1120v-1088q0 -66 -47 -113t-113 -47h-1472q-66 0 -113 47t-47 113v1088q0 66 47 113t113 47h1472q66 0 113 -47t47 -113z",
            "video-camera": "M1792 1184v-1088q0 -42 -39 -59q-13 -5 -25 -5q-27 0 -45 19l-403 403v-166q0 -119 -84.5 -203.5t-203.5 -84.5h-704q-119 0 -203.5 84.5t-84.5 203.5v704q0 119 84.5 203.5t203.5 84.5h704q119 0 203.5 -84.5t84.5 -203.5v-165l403 402q18 19 45 19q12 0 25 -5 q39 -17 39 -59z",
            "folder-open": "M1879 584q0 -31 -31 -66l-336 -396q-43 -51 -120.5 -86.5t-143.5 -35.5h-1088q-34 0 -60.5 13t-26.5 43q0 31 31 66l336 396q43 51 120.5 86.5t143.5 35.5h1088q34 0 60.5 -13t26.5 -43zM1536 928v-160h-832q-94 0 -197 -47.5t-164 -119.5l-337 -396l-5 -6q0 4 -0.5 12.5 t-0.5 12.5v960q0 92 66 158t158 66h320q92 0 158 -66t66 -158v-32h544q92 0 158 -66t66 -158z",
            "forward": "M45 -115q-19 -19 -32 -13t-13 32v1472q0 26 13 32t32 -13l710 -710q8 -8 13 -19v710q0 26 13 32t32 -13l710 -710q19 -19 19 -45t-19 -45l-710 -710q-19 -19 -32 -13t-13 32v710q-5 -10 -13 -19z",
            "backward": "M1619 1395q19 19 32 13t13 -32v-1472q0 -26 -13 -32t-32 13l-710 710q-8 9 -13 19v-710q0 -26 -13 -32t-32 13l-710 710q-19 19 -19 45t19 45l710 710q19 19 32 13t13 -32v-710q5 11 13 19z",
            "question": "M704 280v-240q0 -16 -12 -28t-28 -12h-240q-16 0 -28 12t-12 28v240q0 16 12 28t28 12h240q16 0 28 -12t12 -28zM1020 880q0 -54 -15.5 -101t-35 -76.5t-55 -59.5t-57.5 -43.5t-61 -35.5q-41 -23 -68.5 -65t-27.5 -67q0 -17 -12 -32.5t-28 -15.5h-240q-15 0 -25.5 18.5 t-10.5 37.5v45q0 83 65 156.5t143 108.5q59 27 84 56t25 76q0 42 -46.5 74t-107.5 32q-65 0 -108 -29q-35 -25 -107 -115q-13 -16 -31 -16q-12 0 -25 8l-164 125q-13 10 -15.5 25t5.5 28q160 266 464 266q80 0 161 -31t146 -83t106 -127.5t41 -158.5z",
            "share-alt": "M1216 512q133 0 226.5 -93.5t93.5 -226.5t-93.5 -226.5t-226.5 -93.5t-226.5 93.5t-93.5 226.5q0 12 2 34l-360 180q-92 -86 -218 -86q-133 0 -226.5 93.5t-93.5 226.5t93.5 226.5t226.5 93.5q126 0 218 -86l360 180q-2 22 -2 34q0 133 93.5 226.5t226.5 93.5 t226.5 -93.5t93.5 -226.5t-93.5 -226.5t-226.5 -93.5q-126 0 -218 86l-360 -180q2 -22 2 -34t-2 -34l360 -180q92 86 218 86z",
            "pause": "M1536 1344v-1408q0 -26 -19 -45t-45 -19h-512q-26 0 -45 19t-19 45v1408q0 26 19 45t45 19h512q26 0 45 -19t19 -45zM640 1344v-1408q0 -26 -19 -45t-45 -19h-512q-26 0 -45 19t-19 45v1408q0 26 19 45t45 19h512q26 0 45 -19t19 -45z",
            "star": "M1664 889q0 -22 -26 -48l-363 -354l86 -500q1 -7 1 -20q0 -21 -10.5 -35.5t-30.5 -14.5q-19 0 -40 12l-449 236l-449 -236q-22 -12 -40 -12q-21 0 -31.5 14.5t-10.5 35.5q0 6 2 20l86 500l-364 354q-25 27 -25 48q0 37 56 46l502 73l225 455q19 41 49 41t49 -41l225 -455 l502 -73q56 -9 56 -46z",
            "minus": "M1408 800v-192q0 -40 -28 -68t-68 -28h-1216q-40 0 -68 28t-28 68v192q0 40 28 68t68 28h1216q40 0 68 -28t28 -68z",
            "check": "M1671 970q0 -40 -28 -68l-724 -724l-136 -136q-28 -28 -68 -28t-68 28l-136 136l-362 362q-28 28 -28 68t28 68l136 136q28 28 68 28t68 -28l294 -295l656 657q28 28 68 28t68 -28l136 -136q28 -28 28 -68z",
            "heart-o": "M1664 940q0 81 -21.5 143t-55 98.5t-81.5 59.5t-94 31t-98 8t-112 -25.5t-110.5 -64t-86.5 -72t-60 -61.5q-18 -22 -49 -22t-49 22q-24 28 -60 61.5t-86.5 72t-110.5 64t-112 25.5t-98 -8t-94 -31t-81.5 -59.5t-55 -98.5t-21.5 -143q0 -168 187 -355l581 -560l580 559 q188 188 188 356zM1792 940q0 -221 -229 -450l-623 -600q-18 -18 -44 -18t-44 18l-624 602q-10 8 -27.5 26t-55.5 65.5t-68 97.5t-53.5 121t-23.5 138q0 220 127 344t351 124q62 0 126.5 -21.5t120 -58t95.5 -68.5t76 -68q36 36 76 68t95.5 68.5t120 58t126.5 21.5 q224 0 351 -124t127 -344z",
            "trophy": "M458 653q-74 162 -74 371h-256v-96q0 -78 94.5 -162t235.5 -113zM1536 928v96h-256q0 -209 -74 -371q141 29 235.5 113t94.5 162zM1664 1056v-128q0 -71 -41.5 -143t-112 -130t-173 -97.5t-215.5 -44.5q-42 -54 -95 -95q-38 -34 -52.5 -72.5t-14.5 -89.5q0 -54 30.5 -91 t97.5 -37q75 0 133.5 -45.5t58.5 -114.5v-64q0 -14 -9 -23t-23 -9h-832q-14 0 -23 9t-9 23v64q0 69 58.5 114.5t133.5 45.5q67 0 97.5 37t30.5 91q0 51 -14.5 89.5t-52.5 72.5q-53 41 -95 95q-113 5 -215.5 44.5t-173 97.5t-112 130t-41.5 143v128q0 40 28 68t68 28h288v96 q0 66 47 113t113 47h576q66 0 113 -47t47 -113v-96h288q40 0 68 -28t28 -68z",
            "bell": "M912 -160q0 16 -16 16q-59 0 -101.5 42.5t-42.5 101.5q0 16 -16 16t-16 -16q0 -73 51.5 -124.5t124.5 -51.5q16 0 16 16zM1728 128q0 -52 -38 -90t-90 -38h-448q0 -106 -75 -181t-181 -75t-181 75t-75 181h-448q-52 0 -90 38t-38 90q50 42 91 88t85 119.5t74.5 158.5 t50 206t19.5 260q0 152 117 282.5t307 158.5q-8 19 -8 39q0 40 28 68t68 28t68 -28t28 -68q0 -20 -8 -39q190 -28 307 -158.5t117 -282.5q0 -139 19.5 -260t50 -206t74.5 -158.5t85 -119.5t91 -88z",
            "wrench": "M384 64q0 26 -19 45t-45 19t-45 -19t-19 -45t19 -45t45 -19t45 19t19 45zM1028 484l-682 -682q-37 -37 -90 -37q-52 0 -91 37l-106 108q-38 36 -38 90q0 53 38 91l681 681q39 -98 114.5 -173.5t173.5 -114.5zM1662 919q0 -39 -23 -106q-47 -134 -164.5 -217.5 t-258.5 -83.5q-185 0 -316.5 131.5t-131.5 316.5t131.5 316.5t316.5 131.5q58 0 121.5 -16.5t107.5 -46.5q16 -11 16 -28t-16 -28l-293 -169v-224l193 -107q5 3 79 48.5t135.5 81t70.5 35.5q15 0 23.5 -10t8.5 -25z",
            "fast-backward": "M1747 1395q19 19 32 13t13 -32v-1472q0 -26 -13 -32t-32 13l-710 710q-9 9 -13 19v-710q0 -26 -13 -32t-32 13l-710 710q-9 9 -13 19v-678q0 -26 -19 -45t-45 -19h-128q-26 0 -45 19t-19 45v1408q0 26 19 45t45 19h128q26 0 45 -19t19 -45v-678q4 11 13 19l710 710 q19 19 32 13t13 -32v-710q4 11 13 19z",
            "flag": "M320 1280q0 -72 -64 -110v-1266q0 -13 -9.5 -22.5t-22.5 -9.5h-64q-13 0 -22.5 9.5t-9.5 22.5v1266q-64 38 -64 110q0 53 37.5 90.5t90.5 37.5t90.5 -37.5t37.5 -90.5zM1792 1216v-763q0 -25 -12.5 -38.5t-39.5 -27.5q-215 -116 -369 -116q-61 0 -123.5 22t-108.5 48 t-115.5 48t-142.5 22q-192 0 -464 -146q-17 -9 -33 -9q-26 0 -45 19t-19 45v742q0 32 31 55q21 14 79 43q236 120 421 120q107 0 200 -29t219 -88q38 -19 88 -19q54 0 117.5 21t110 47t88 47t54.5 21q26 0 45 -19t19 -45z",
            "cloud": "M1920 384q0 -159 -112.5 -271.5t-271.5 -112.5h-1088q-185 0 -316.5 131.5t-131.5 316.5q0 132 71 241.5t187 163.5q-2 28 -2 43q0 212 150 362t362 150q158 0 286.5 -88t187.5 -230q70 62 166 62q106 0 181 -75t75 -181q0 -75 -41 -138q129 -30 213 -134.5t84 -239.5z ",
            "laptop": "M416 256q-66 0 -113 47t-47 113v704q0 66 47 113t113 47h1088q66 0 113 -47t47 -113v-704q0 -66 -47 -113t-113 -47h-1088zM384 1120v-704q0 -13 9.5 -22.5t22.5 -9.5h1088q13 0 22.5 9.5t9.5 22.5v704q0 13 -9.5 22.5t-22.5 9.5h-1088q-13 0 -22.5 -9.5t-9.5 -22.5z M1760 192h160v-96q0 -40 -47 -68t-113 -28h-1600q-66 0 -113 28t-47 68v96h160h1600zM1040 96q16 0 16 16t-16 16h-160q-16 0 -16 -16t16 -16h160z",
            "expand": "M755 480q0 -13 -10 -23l-332 -332l144 -144q19 -19 19 -45t-19 -45t-45 -19h-448q-26 0 -45 19t-19 45v448q0 26 19 45t45 19t45 -19l144 -144l332 332q10 10 23 10t23 -10l114 -114q10 -10 10 -23zM1536 1344v-448q0 -26 -19 -45t-45 -19t-45 19l-144 144l-332 -332 q-10 -10 -23 -10t-23 10l-114 114q-10 10 -10 23t10 23l332 332l-144 144q-19 19 -19 45t19 45t45 19h448q26 0 45 -19t19 -45z",
            "list": "M256 224v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-192q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5t22.5 9.5h192q13 0 22.5 -9.5t9.5 -22.5zM256 608v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-192q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5t22.5 9.5h192q13 0 22.5 -9.5 t9.5 -22.5zM256 992v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-192q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5t22.5 9.5h192q13 0 22.5 -9.5t9.5 -22.5zM1792 224v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-1344q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5t22.5 9.5h1344 q13 0 22.5 -9.5t9.5 -22.5zM256 1376v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-192q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5t22.5 9.5h192q13 0 22.5 -9.5t9.5 -22.5zM1792 608v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-1344q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5 t22.5 9.5h1344q13 0 22.5 -9.5t9.5 -22.5zM1792 992v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-1344q-13 0 -22.5 9.5t-9.5 22.5v192q0 13 9.5 22.5t22.5 9.5h1344q13 0 22.5 -9.5t9.5 -22.5zM1792 1376v-192q0 -13 -9.5 -22.5t-22.5 -9.5h-1344q-13 0 -22.5 9.5t-9.5 22.5v192 q0 13 9.5 22.5t22.5 9.5h1344q13 0 22.5 -9.5t9.5 -22.5z",
            "share": "M1792 896q0 -26 -19 -45l-512 -512q-19 -19 -45 -19t-45 19t-19 45v256h-224q-98 0 -175.5 -6t-154 -21.5t-133 -42.5t-105.5 -69.5t-80 -101t-48.5 -138.5t-17.5 -181q0 -55 5 -123q0 -6 2.5 -23.5t2.5 -26.5q0 -15 -8.5 -25t-23.5 -10q-16 0 -28 17q-7 9 -13 22 t-13.5 30t-10.5 24q-127 285 -127 451q0 199 53 333q162 403 875 403h224v256q0 26 19 45t45 19t45 -19l512 -512q19 -19 19 -45z",
            "youtube": "M971 292v-211q0 -67 -39 -67q-23 0 -45 22v301q22 22 45 22q39 0 39 -67zM1309 291v-46h-90v46q0 68 45 68t45 -68zM343 509h107v94h-312v-94h105v-569h100v569zM631 -60h89v494h-89v-378q-30 -42 -57 -42q-18 0 -21 21q-1 3 -1 35v364h-89v-391q0 -49 8 -73 q12 -37 58 -37q48 0 102 61v-54zM1060 88v197q0 73 -9 99q-17 56 -71 56q-50 0 -93 -54v217h-89v-663h89v48q45 -55 93 -55q54 0 71 55q9 27 9 100zM1398 98v13h-91q0 -51 -2 -61q-7 -36 -40 -36q-46 0 -46 69v87h179v103q0 79 -27 116q-39 51 -106 51q-68 0 -107 -51 q-28 -37 -28 -116v-173q0 -79 29 -116q39 -51 108 -51q72 0 108 53q18 27 21 54q2 9 2 58zM790 1011v210q0 69 -43 69t-43 -69v-210q0 -70 43 -70t43 70zM1509 260q0 -234 -26 -350q-14 -59 -58 -99t-102 -46q-184 -21 -555 -21t-555 21q-58 6 -102.5 46t-57.5 99 q-26 112 -26 350q0 234 26 350q14 59 58 99t103 47q183 20 554 20t555 -20q58 -7 102.5 -47t57.5 -99q26 -112 26 -350zM511 1536h102l-121 -399v-271h-100v271q-14 74 -61 212q-37 103 -65 187h106l71 -263zM881 1203v-175q0 -81 -28 -118q-37 -51 -106 -51q-67 0 -105 51 q-28 38 -28 118v175q0 80 28 117q38 51 105 51q69 0 106 -51q28 -37 28 -117zM1216 1365v-499h-91v55q-53 -62 -103 -62q-46 0 -59 37q-8 24 -8 75v394h91v-367q0 -33 1 -35q3 -22 21 -22q27 0 57 43v381h91z",
            "instagram": "M1362 110v648h-135q20 -63 20 -131q0 -126 -64 -232.5t-174 -168.5t-240 -62q-197 0 -337 135.5t-140 327.5q0 68 20 131h-141v-648q0 -26 17.5 -43.5t43.5 -17.5h1069q25 0 43 17.5t18 43.5zM1078 643q0 124 -90.5 211.5t-218.5 87.5q-127 0 -217.5 -87.5t-90.5 -211.5 t90.5 -211.5t217.5 -87.5q128 0 218.5 87.5t90.5 211.5zM1362 1003v165q0 28 -20 48.5t-49 20.5h-174q-29 0 -49 -20.5t-20 -48.5v-165q0 -29 20 -49t49 -20h174q29 0 49 20t20 49zM1536 1211v-1142q0 -81 -58 -139t-139 -58h-1142q-81 0 -139 58t-58 139v1142q0 81 58 139 t139 58h1142q81 0 139 -58t58 -139z",
            "vine": "M1497 709v-198q-101 -23 -198 -23q-65 -136 -165.5 -271t-181.5 -215.5t-128 -106.5q-80 -45 -162 3q-28 17 -60.5 43.5t-85 83.5t-102.5 128.5t-107.5 184t-105.5 244t-91.5 314.5t-70.5 390h283q26 -218 70 -398.5t104.5 -317t121.5 -235.5t140 -195q169 169 287 406 q-142 72 -223 220t-81 333q0 192 104 314.5t284 122.5q178 0 273 -105.5t95 -297.5q0 -159 -58 -286q-7 -1 -19.5 -3t-46 -2t-63 6t-62 25.5t-50.5 51.5q31 103 31 184q0 87 -29 132t-79 45q-53 0 -85 -49.5t-32 -140.5q0 -186 105 -293.5t267 -107.5q62 0 121 14z",
            "print": "M384 0h896v256h-896v-256zM384 640h896v384h-160q-40 0 -68 28t-28 68v160h-640v-640zM1536 576q0 26 -19 45t-45 19t-45 -19t-19 -45t19 -45t45 -19t45 19t19 45zM1664 576v-416q0 -13 -9.5 -22.5t-22.5 -9.5h-224v-160q0 -40 -28 -68t-68 -28h-960q-40 0 -68 28t-28 68 v160h-224q-13 0 -22.5 9.5t-9.5 22.5v416q0 79 56.5 135.5t135.5 56.5h64v544q0 40 28 68t68 28h672q40 0 88 -20t76 -48l152 -152q28 -28 48 -76t20 -88v-256h64q79 0 135.5 -56.5t56.5 -135.5z",
            "vimeo": "M1254 899q16 85 -21 132q-52 65 -187 45q-17 -3 -41 -12.5t-57.5 -30.5t-64.5 -48.5t-59.5 -70t-44.5 -91.5q80 7 113.5 -16t26.5 -99q-5 -52 -52 -143q-43 -78 -71 -99q-44 -32 -87 14q-23 24 -37.5 64.5t-19 73t-10 84t-8.5 71.5q-23 129 -34 164q-12 37 -35.5 69 t-50.5 40q-57 16 -127 -25q-54 -32 -136.5 -106t-122.5 -102v-7q16 -8 25.5 -26t21.5 -20q21 -3 54.5 8.5t58 10.5t41.5 -30q11 -18 18.5 -38.5t15 -48t12.5 -40.5q17 -46 53 -187q36 -146 57 -197q42 -99 103 -125q43 -12 85 -1.5t76 31.5q131 77 250 237 q104 139 172.5 292.5t82.5 226.5zM1536 1120v-960q0 -119 -84.5 -203.5t-203.5 -84.5h-960q-119 0 -203.5 84.5t-84.5 203.5v960q0 119 84.5 203.5t203.5 84.5h960q119 0 203.5 -84.5t84.5 -203.5z",
            "code": "M617 137l-50 -50q-10 -10 -23 -10t-23 10l-466 466q-10 10 -10 23t10 23l466 466q10 10 23 10t23 -10l50 -50q10 -10 10 -23t-10 -23l-393 -393l393 -393q10 -10 10 -23t-10 -23zM1208 1204l-373 -1291q-4 -13 -15.5 -19.5t-23.5 -2.5l-62 17q-13 4 -19.5 15.5t-2.5 24.5 l373 1291q4 13 15.5 19.5t23.5 2.5l62 -17q13 -4 19.5 -15.5t2.5 -24.5zM1865 553l-466 -466q-10 -10 -23 -10t-23 10l-50 50q-10 10 -10 23t10 23l393 393l-393 393q-10 10 -10 23t10 23l50 50q10 10 23 10t23 -10l466 -466q10 -10 10 -23t-10 -23z",
            "puzzle-piece": "M1664 438q0 -81 -44.5 -135t-123.5 -54q-41 0 -77.5 17.5t-59 38t-56.5 38t-71 17.5q-110 0 -110 -124q0 -39 16 -115t15 -115v-5q-22 0 -33 -1q-34 -3 -97.5 -11.5t-115.5 -13.5t-98 -5q-61 0 -103 26.5t-42 83.5q0 37 17.5 71t38 56.5t38 59t17.5 77.5q0 79 -54 123.5 t-135 44.5q-84 0 -143 -45.5t-59 -127.5q0 -43 15 -83t33.5 -64.5t33.5 -53t15 -50.5q0 -45 -46 -89q-37 -35 -117 -35q-95 0 -245 24q-9 2 -27.5 4t-27.5 4l-13 2q-1 0 -3 1q-2 0 -2 1v1024q2 -1 17.5 -3.5t34 -5t21.5 -3.5q150 -24 245 -24q80 0 117 35q46 44 46 89 q0 22 -15 50.5t-33.5 53t-33.5 64.5t-15 83q0 82 59 127.5t144 45.5q80 0 134 -44.5t54 -123.5q0 -41 -17.5 -77.5t-38 -59t-38 -56.5t-17.5 -71q0 -57 42 -83.5t103 -26.5q64 0 180 15t163 17v-2q-1 -2 -3.5 -17.5t-5 -34t-3.5 -21.5q-24 -150 -24 -245q0 -80 35 -117 q44 -46 89 -46q22 0 50.5 15t53 33.5t64.5 33.5t83 15q82 0 127.5 -59t45.5 -143z",
            "bars": "M1536 192v-128q0 -26 -19 -45t-45 -19h-1408q-26 0 -45 19t-19 45v128q0 26 19 45t45 19h1408q26 0 45 -19t19 -45zM1536 704v-128q0 -26 -19 -45t-45 -19h-1408q-26 0 -45 19t-19 45v128q0 26 19 45t45 19h1408q26 0 45 -19t19 -45zM1536 1216v-128q0 -26 -19 -45 t-45 -19h-1408q-26 0 -45 19t-19 45v128q0 26 19 45t45 19h1408q26 0 45 -19t19 -45z",
            "external-link": "M1408 608v-320q0 -119 -84.5 -203.5t-203.5 -84.5h-832q-119 0 -203.5 84.5t-84.5 203.5v832q0 119 84.5 203.5t203.5 84.5h704q14 0 23 -9t9 -23v-64q0 -14 -9 -23t-23 -9h-704q-66 0 -113 -47t-47 -113v-832q0 -66 47 -113t113 -47h832q66 0 113 47t47 113v320 q0 14 9 23t23 9h64q14 0 23 -9t9 -23zM1792 1472v-512q0 -26 -19 -45t-45 -19t-45 19l-176 176l-652 -652q-10 -10 -23 -10t-23 10l-114 114q-10 10 -10 23t10 23l652 652l-176 176q-19 19 -19 45t19 45t45 19h512q26 0 45 -19t19 -45z",
            "ban": "M1312 643q0 161 -87 295l-754 -753q137 -89 297 -89q111 0 211.5 43.5t173.5 116.5t116 174.5t43 212.5zM313 344l755 754q-135 91 -300 91q-148 0 -273 -73t-198 -199t-73 -274q0 -162 89 -299zM1536 643q0 -157 -61 -300t-163.5 -246t-245 -164t-298.5 -61t-298.5 61 t-245 164t-163.5 246t-61 300t61 299.5t163.5 245.5t245 164t298.5 61t298.5 -61t245 -164t163.5 -245.5t61 -299.5z",
        };
        function svgBoilerPlate(viewPort, svg, iconName, altText) {
            if (iconName === void 0) { iconName = ""; }
            if (altText === void 0) { altText = ""; }
            return "<svg class='svg svg-icon-" + iconName + "' viewBox='" + viewPort + "'" + " preserveAspectRatio='xMinYMin' xmlns='http://www.w3.org/2000/svg'>" + (altText ? "<title>" + altText.replace(/[<>]/g, "") + "</title>" : "") + svg + "</svg>";
        }
        SVG.svgBoilerPlate = svgBoilerPlate;
        var loginButton = svgBoilerPlate('0 0 480 100', '<path fill="#F1511B" d="M 304.013,30.6004L 287.456,30.5787L 287.456,14.0221L 304.012,14.0221L 304.013,30.6004 Z "/>' + '<path fill="#7FCB28" d="M 322.293,30.5783L 305.731,30.5848L 305.736,14.0221L 322.293,14.0221L 322.293,30.5783 Z "/>' + '<path fill="#00ADEE" d="M 304.012,48.8651L 287.456,48.8651L 287.456,32.309L 303.997,32.3036L 304.012,48.8651 Z "/>' + '<path fill="#FABC09" d="M 322.293,48.8651L 305.736,48.8651L 305.747,32.3192L 322.293,32.309L 322.293,48.8651 Z "/>' + '<path fill="#DF4A32" d="M 374.073,59.2197L 401.083,59.2197C 401.73,59.2197 402.255,59.7444 402.255,60.3916L 402.255,87.4013C 402.255,88.0485 401.73,88.5732 401.083,88.5732L 393.197,88.5732L 388.656,88.5732L 374.073,88.5732C 373.426,88.5732 372.901,88.0485 372.901,87.4013L 372.901,60.3916C 372.901,59.7444 373.426,59.2197 374.073,59.2197 Z M 386.737,63.2903L 388.618,63.2903L 390.501,62.1863L 384.402,62.1863C 383.593,62.1863 382.725,62.2811 381.8,62.4701C 380.865,62.6892 379.964,63.1573 379.097,63.874C 377.835,65.099 377.204,66.4629 377.204,67.9665C 377.204,69.2112 377.649,70.3014 378.54,71.2373C 379.391,72.243 380.629,72.7558 382.252,72.7757C 382.559,72.7757 382.886,72.7558 383.232,72.7159L 383.046,73.2413C 382.97,73.4215 382.931,73.647 382.931,73.9171C 382.931,74.3678 383.032,74.7534 383.232,75.0737C 383.404,75.4043 383.6,75.7147 383.82,76.005C 383.109,76.025 382.215,76.1142 381.138,76.2734C 380.051,76.4622 379.013,76.8399 378.025,77.4066C 377.146,77.9331 376.538,78.5444 376.202,79.2404C 375.857,79.9362 375.684,80.5672 375.684,81.1339C 375.684,82.2968 376.215,83.2957 377.279,84.1308C 378.332,85.0252 379.927,85.4825 382.063,85.5025C 384.615,85.4626 386.568,84.8502 387.922,83.6651C 389.226,82.5198 389.879,81.2053 389.879,79.7217C 389.86,78.676 389.623,77.8295 389.166,77.1822C 388.681,76.5448 388.117,75.9625 387.474,75.4345L 386.44,74.5832C 386.29,74.4337 386.137,74.2596 385.978,74.0603C 385.792,73.8512 385.699,73.5874 385.699,73.2686C 385.699,72.94 385.79,72.6512 385.971,72.4022C 386.126,72.1631 386.294,71.9492 386.475,71.7599L 387.375,70.9384C 387.629,70.6694 387.87,70.3758 388.097,70.057C 388.561,69.3997 388.802,68.5236 388.82,67.428C 388.82,66.8304 388.753,66.3076 388.619,65.8595C 388.456,65.4114 388.269,65.0231 388.059,64.6945C 387.838,64.3459 387.613,64.0521 387.383,63.8131C 387.144,63.5841 386.928,63.4098 386.737,63.2903 Z M 387.915,80.9187C 387.915,81.8748 387.546,82.6566 386.808,83.2644C 386.051,83.882 384.953,84.2006 383.516,84.2207C 381.914,84.2006 380.651,83.8421 379.729,83.145C 378.758,82.4475 378.272,81.5611 378.272,80.4855C 378.272,79.9376 378.384,79.4696 378.607,79.0811C 378.802,78.7125 379.039,78.4036 379.321,78.1548C 379.612,77.9159 379.899,77.7314 380.18,77.6021L 380.836,77.333C 381.496,77.1337 382.142,76.9894 382.773,76.8999C 383.414,76.8401 383.812,76.8201 383.968,76.8401L 384.652,76.87C 385.789,77.6668 386.624,78.339 387.158,78.8871C 387.663,79.4644 387.915,80.1418 387.915,80.9187 Z M 383.663,71.9419C 383.027,71.9419 382.462,71.7476 381.968,71.3582C 381.474,70.9691 381.07,70.4952 380.758,69.9363C 380.112,68.739 379.79,67.5862 379.79,66.4785C 379.77,65.6406 379.991,64.8822 380.453,64.2035C 381,63.555 381.688,63.2207 382.514,63.2007C 383.139,63.2207 383.692,63.4054 384.173,63.7545C 384.644,64.1237 385.023,64.6027 385.312,65.1914C 385.927,66.4188 386.234,67.6362 386.234,68.8436C 386.234,69.1232 386.212,69.4674 386.168,69.8763C 386.094,70.2856 385.928,70.6846 385.67,71.0736C 385.135,71.6227 384.466,71.9121 383.663,71.9419 Z M 400.017,71.7155L 396.809,71.7155L 396.809,68.4458L 394.931,68.4458L 394.931,71.7155L 391.703,71.7155L 391.703,73.5403L 391.723,73.5403L 391.723,73.6096L 394.931,73.6096L 394.931,76.8175L 396.809,76.8175L 396.809,73.6096L 400.095,73.6096L 400.095,71.7318L 400.017,71.7318L 400.017,71.7155 Z "/>' + '<path fill="#3F008F" d="M 447.118,85.0025L 442.792,84.4735L 443.273,80.6767L 447.599,81.205L 447.118,85.0025 Z M 451.446,61.9735L 447.311,78.657L 444.089,78.2252L 444.042,61.0608L 451.446,61.9735 Z M 436.542,82.1673C 434.069,84.0011 431.003,85.0745 427.368,85.3876L 422.716,85.3876C 419.055,85.0745 415.993,84.0011 413.561,82.1673C 410.581,79.9555 409.09,77.0707 409.09,73.5128C 409.09,70.0033 410.581,67.1659 413.561,64.9548C 416.494,62.6954 420.34,61.5899 425.051,61.5899C 429.715,61.5899 433.561,62.6954 436.542,64.9548C 439.474,67.1659 440.965,70.0033 440.965,73.5128C 440.965,77.0707 439.474,79.9555 436.542,82.1673 Z M 434.33,70.5798L 434.907,69.7628L 430.965,69.7146L 426.782,69.7146L 426.975,70.5798L 429.474,70.9648C 429.426,71.4932 428.129,72.6952 425.677,74.5702C 423.802,72.2144 422.407,70.3401 421.494,68.9941L 424.426,68.7048L 424.523,68.0311C 423.225,67.936 421.59,67.936 419.619,67.9836C 416.782,67.936 415.244,67.936 415.099,68.0311L 415.099,68.8488L 417.888,69.2332C 418.369,69.6182 419.379,70.7245 420.917,72.5995C 422.407,74.4269 423.177,75.4843 423.273,75.7729L 423.321,77.0232L 423.321,77.6472C 423.321,78.657 423.273,79.2343 423.177,79.3293C 423.033,79.4747 422.6,79.5704 421.878,79.6187L 420.484,79.6662L 420.34,80.5321L 424.667,80.4838L 429.522,80.4838L 429.571,79.5704L 426.59,79.5222L 426.398,77.6961L 426.446,76.9742L 426.542,75.7729C 426.686,75.3396 427.551,74.4745 429.234,73.1284C 430.821,71.83 431.734,71.1563 432.071,71.0613L 434.33,70.5798 Z "/>' + '<path fill="#000000" d="M 448.753,81.205L 448.417,81.205L 448.417,80.9653L 449.33,80.9653L 449.33,81.205L 448.994,81.205L 448.994,82.1184L 448.753,82.1184L 448.753,81.205 Z M 449.811,81.3015L 449.811,82.1184L 449.571,82.1184L 449.571,80.9653L 449.859,80.9653L 450.196,81.5418L 450.532,80.9653L 450.772,80.9653L 450.772,82.1184L 450.532,82.1184L 450.532,81.3015L 450.196,81.8787L 450.147,81.8787L 449.811,81.3015 Z "/>' + '<path fill="#3B5998" d="M 362.345,88.5734L 354.865,88.5734L 354.865,77.2061L 358.68,77.2061L 359.251,72.7761L 354.865,72.7761L 354.865,69.9477C 354.865,68.6651 355.221,67.791 357.06,67.791L 359.406,67.7899L 359.406,63.8277C 359,63.7738 357.608,63.6532 355.988,63.6532C 352.605,63.6532 350.29,65.7177 350.29,69.5091L 350.29,72.7761L 346.465,72.7761L 346.465,77.2061L 350.29,77.2061L 350.29,88.5734L 336.231,88.5734C 335.336,88.5734 334.611,87.848 334.611,86.9534L 334.611,60.8398C 334.611,59.9449 335.336,59.2197 336.231,59.2197L 362.345,59.2197C 363.239,59.2197 363.965,59.9449 363.965,60.8398L 363.965,86.9534C 363.965,87.848 363.239,88.5734 362.345,88.5734 Z "/>' + '<path fill="#686868" d="M 345.055,34.0982L 350.422,20.9961L 355.338,20.9961L 355.338,41.8745L 351.737,41.8745L 351.737,28.6072L 351.897,24.8576L 351.822,24.8576C 351.685,25.4729 351.535,26.1565 351.394,26.507L 345.163,41.8745L 342.802,41.8745L 336.525,26.6446L 336.046,24.8576L 335.972,24.8576L 336.068,26.1946L 336.118,29.0398L 336.118,41.8745L 332.742,41.8745L 332.742,20.9961L 337.86,20.9961L 343.095,34.128C 343.554,35.2844 343.847,36.1942 344.022,36.8356L 344.077,36.8356L 345.055,34.0982 Z M 358.728,41.8747L 358.728,26.9128L 362.247,26.9128L 362.247,41.8747L 358.728,41.8747 Z M 360.524,20.5542C 361.133,20.5542 361.648,20.7572 362.054,21.1582C 362.46,21.5597 362.666,22.0478 362.666,22.61C 362.666,23.183 362.454,23.667 362.037,24.0493C 361.622,24.4293 361.113,24.6219 360.524,24.6219C 359.935,24.6219 359.427,24.4293 359.017,24.049C 358.605,23.667 358.396,23.183 358.396,22.61C 358.396,22.0279 358.607,21.5336 359.024,21.1421C 359.439,20.7522 359.944,20.5542 360.524,20.5542 Z M 374.707,26.7628C 375.387,26.9041 375.935,27.0894 376.336,27.3139L 376.383,27.3408L 376.383,30.7383L 376.235,30.631C 375.169,29.8574 374.042,29.4655 372.885,29.4655C 371.533,29.4655 370.422,29.9241 369.584,30.8282C 368.743,31.7343 368.317,32.9631 368.317,34.4804C 368.317,35.9881 368.726,37.1847 369.533,38.0378C 370.338,38.89 371.446,39.3221 372.827,39.3221C 373.324,39.3221 373.891,39.2119 374.513,38.9948C 375.137,38.7781 375.716,38.4765 376.235,38.0986L 376.383,37.9909L 376.383,41.2148L 376.337,41.2417C 375.192,41.9013 373.764,42.2356 372.091,42.2356C 370.659,42.2356 369.364,41.9207 368.243,41.3005C 367.122,40.679 366.236,39.7833 365.61,38.6372C 364.985,37.4933 364.668,36.1969 364.668,34.7828C 364.668,33.1691 364.994,31.7227 365.638,30.4834C 366.283,29.2413 367.233,28.2648 368.46,27.5811C 369.685,26.8979 371.125,26.552 372.741,26.552C 373.369,26.552 374.03,26.6228 374.707,26.7628 Z M 386.304,26.6528C 386.891,26.6528 387.355,26.7232 387.682,26.8624L 387.739,26.8864L 387.739,30.4347L 387.591,30.3278C 387.428,30.2105 387.152,30.0987 386.771,29.9959C 386.385,29.8927 386.03,29.8405 385.712,29.8405C 384.777,29.8405 384.011,30.2449 383.436,31.0429C 382.854,31.85 382.559,32.9189 382.559,34.2207L 382.559,41.8745L 379.04,41.8745L 379.04,26.9126L 382.559,26.9126L 382.559,29.5033L 382.596,29.5033C 382.926,28.6622 383.355,27.9881 383.95,27.4967C 384.628,26.937 385.42,26.6528 386.304,26.6528 Z M 398.661,38.0724C 399.328,37.2372 399.666,35.99 399.666,34.3647C 399.666,32.76 399.307,31.5278 398.599,30.7029C 397.894,29.8813 396.911,29.4657 395.676,29.4657C 394.402,29.4657 393.392,29.9008 392.673,30.7597C 391.951,31.6231 391.584,32.8652 391.584,34.4513C 391.584,35.9896 391.951,37.1999 392.673,38.0488C 393.391,38.8936 394.411,39.322 395.704,39.322C 397.005,39.322 398,38.9019 398.661,38.0724 Z M 395.863,26.5518C 398.187,26.5518 400.031,27.2433 401.341,28.6077C 402.651,29.9708 403.315,31.8688 403.315,34.2491C 403.315,36.6588 402.607,38.6127 401.211,40.057C 399.815,41.5026 397.893,42.2355 395.502,42.2355C 393.207,42.2355 391.352,41.539 389.989,40.1664C 388.626,38.7933 387.935,36.9094 387.935,34.5669C 387.935,32.1 388.642,30.1262 390.039,28.7009C 391.436,27.2748 393.396,26.5518 395.863,26.5518 Z M 411.121,33.0948C 412.514,33.6559 413.512,34.2914 414.087,34.9833C 414.666,35.6802 414.96,36.5453 414.96,37.5538C 414.96,38.9529 414.414,40.096 413.337,40.9529C 412.267,41.8039 410.801,42.2356 408.979,42.2356C 408.39,42.2356 407.711,42.1573 406.962,42.0023C 406.213,41.8478 405.577,41.6514 405.073,41.4189L 405.019,41.3937L 405.019,37.9631L 405.167,38.0696C 405.772,38.5046 406.443,38.8448 407.161,39.081C 407.879,39.3175 408.534,39.4373 409.11,39.4373C 410.658,39.4373 411.411,38.9488 411.411,37.9428C 411.411,37.5894 411.337,37.304 411.19,37.0947C 411.04,36.8813 410.773,36.6617 410.397,36.4438L 408.596,35.6048C 407.631,35.1897 406.902,34.782 406.431,34.3933C 405.955,34.0014 405.597,33.5332 405.366,33.0016C 405.136,32.4734 405.019,31.8494 405.019,31.1471C 405.019,29.7957 405.56,28.679 406.626,27.8276C 407.688,26.9812 409.076,26.5519 410.754,26.5519C 411.267,26.5519 411.858,26.6128 412.51,26.7334C 413.164,26.8548 413.701,27.0048 414.11,27.1796L 414.166,27.2036L 414.166,30.4573L 414.02,30.3583C 413.578,30.0571 413.047,29.8109 412.444,29.6274C 411.84,29.4435 411.233,29.3498 410.639,29.3498C 409.999,29.3498 409.489,29.494 409.123,29.7778C 408.759,30.06 408.582,30.4088 408.582,30.8439C 408.582,31.3348 408.725,31.7222 409.008,31.9965C 409.3,32.2795 410.011,32.649 411.121,33.0948 Z M 427.222,38.0724C 427.888,37.2371 428.226,35.99 428.226,34.3646C 428.226,32.7599 427.868,31.5277 427.16,30.7029C 426.455,29.8812 425.471,29.4657 424.236,29.4657C 422.963,29.4657 421.952,29.9007 421.234,30.7596C 420.511,31.623 420.145,32.8651 420.145,34.4512C 420.145,35.9895 420.511,37.1998 421.234,38.0487C 421.952,38.8935 422.972,39.3219 424.265,39.3219C 425.566,39.3219 426.561,38.9018 427.222,38.0724 Z M 424.423,26.5518C 426.747,26.5518 428.591,27.2433 429.902,28.6076C 431.212,29.9707 431.876,31.8687 431.876,34.249C 431.876,36.6587 431.168,38.6126 429.771,40.0569C 428.375,41.5025 426.454,42.2354 424.063,42.2354C 421.768,42.2354 419.913,41.5389 418.55,40.1663C 417.186,38.7932 416.495,36.9093 416.495,34.5668C 416.495,32.0999 417.203,30.1261 418.599,28.7008C 419.997,27.2747 421.956,26.5518 424.423,26.5518 Z M 450.642,29.7826L 447.077,29.7826L 447.077,36.8463C 447.077,37.7525 447.24,38.3993 447.56,38.7692C 447.877,39.1359 448.387,39.3215 449.077,39.3215L 449.78,39.2022L 450.497,38.8894L 450.642,38.7928L 450.642,41.691L 450.595,41.7179C 450.383,41.8393 450.023,41.9533 449.493,42.0672C 448.974,42.1787 448.464,42.2354 447.98,42.2354C 445.036,42.2354 443.544,40.6312 443.544,37.467L 443.544,29.7826L 438.263,29.7826L 438.263,41.8745L 434.7,41.8745L 434.7,29.7826L 432.218,29.7826L 432.218,26.9122L 434.7,26.9122L 434.7,24.841C 434.7,23.8007 434.929,22.8606 435.383,22.0469C 435.837,21.2319 436.485,20.5909 437.31,20.1414C 438.133,19.6939 439.078,19.4669 440.118,19.4669C 440.943,19.4669 441.608,19.5559 442.097,19.7321L 442.159,19.754L 442.159,22.7773L 442.028,22.7189C 441.503,22.4848 440.981,22.3659 440.478,22.3659C 439.779,22.3659 439.23,22.5905 438.846,23.0338C 438.459,23.4808 438.263,24.152 438.263,25.0287L 438.263,26.9122L 443.544,26.9122L 443.544,23.5314L 443.609,23.5111L 446.957,22.4865L 447.077,22.4496L 447.077,26.9122L 450.642,26.9122L 450.642,29.7826 Z "/>' + '<path fill="#686868" d="M 295.763,86.9415C 293.441,86.9415 291.587,86.2508 290.201,84.8695C 288.815,83.4882 288.122,81.6565 288.122,79.3746C 288.122,76.891 288.844,74.9517 290.289,73.5563C 291.734,72.161 293.681,71.4635 296.131,71.4635C 298.484,71.4635 300.317,72.1418 301.63,73.4982C 302.944,74.8547 303.6,76.7375 303.6,79.1466C 303.6,81.503 302.892,83.3913 301.477,84.8114C 300.062,86.2314 298.157,86.9415 295.763,86.9415 Z M 295.935,74.1424C 294.627,74.1424 293.593,74.5982 292.833,75.5097C 292.074,76.4213 291.694,77.6786 291.694,79.2816C 291.694,80.8257 292.078,82.0418 292.847,82.9301C 293.616,83.8185 294.646,84.2627 295.935,84.2627C 297.25,84.2627 298.261,83.8262 298.968,82.9534C 299.675,82.0806 300.028,80.8381 300.028,79.2258C 300.028,77.6042 299.675,76.3515 298.968,75.4679C 298.261,74.5843 297.25,74.1424 295.935,74.1424 Z M 315.506,75.0354C 315.091,74.6385 314.494,74.4401 313.716,74.4401C 312.699,74.4401 311.85,74.8927 311.169,75.7981C 310.489,76.7035 310.148,77.9344 310.148,79.4908L 310.148,86.6438L 306.874,86.6438L 306.874,71.7612L 310.148,71.7612L 310.148,74.7749L 310.209,74.7749C 310.544,73.7332 311.059,72.9208 311.755,72.3379C 312.451,71.7549 313.227,71.4635 314.083,71.4635C 314.706,71.4635 315.181,71.5581 315.506,71.7472L 315.506,75.0354 Z "/>' + '<path fill="#686868" d="M 28.7274,69.3415L 28.7274,61.271C 29.4541,61.9977 30.3205,62.6527 31.3267,63.2362C 32.3329,63.8197 33.4002,64.3105 34.5287,64.7088C 35.6572,65.1071 36.7839,65.4163 37.9089,65.6364C 39.0339,65.8565 40.0715,65.9666 41.0218,65.9666C 44.3338,65.9666 46.8021,65.39 48.4267,64.2372C 50.0513,63.0842 50.8636,61.4142 50.8636,59.2272C 50.8636,58.1162 50.5928,57.1537 50.0513,56.3396C 49.5098,55.5256 48.7534,54.7814 47.7821,54.1071C 46.8109,53.4328 45.6702,52.7865 44.36,52.1681L 40.1414,50.2343C 38.5343,49.3888 37.0355,48.5312 35.645,47.6612C 34.2545,46.7913 33.0456,45.8288 32.0185,44.7737C 30.9913,43.7185 30.186,42.529 29.6026,41.2048C 29.0191,39.8807 28.7274,38.3278 28.7274,36.5459C 28.7274,34.3519 29.2252,32.446 30.221,30.8285C 31.2167,29.2109 32.5321,27.8745 34.1671,26.8194C 35.8022,25.7644 37.6608,24.9818 39.7431,24.4717C 41.8253,23.9616 43.9495,23.7065 46.1156,23.7065C 51.0488,23.7065 54.6438,24.2655 56.9007,25.3835L 56.9007,33.0977C 54.2036,30.8617 50.7343,29.7437 46.493,29.7437C 45.3191,29.7437 44.1522,29.859 42.9922,30.0896C 41.8323,30.3202 40.7929,30.7027 39.8741,31.2373C 38.9553,31.7718 38.2093,32.4566 37.6364,33.2915C 37.0634,34.1266 36.7769,35.1345 36.7769,36.3153C 36.7769,37.3565 36.997,38.2578 37.4372,39.0195C 37.8774,39.7811 38.522,40.4764 39.371,41.1052C 40.22,41.7341 41.2576,42.3473 42.4839,42.9447L 46.734,44.8889C 48.39,45.7344 49.9517,46.6253 51.4191,47.5616C 52.8865,48.498 54.1774,49.5304 55.2919,50.6588C 56.4064,51.7873 57.2885,53.0415 57.9384,54.4215C 58.5882,55.8016 58.9131,57.372 58.9131,59.1328C 58.9131,61.5016 58.431,63.5 57.4667,65.1281C 56.5025,66.7561 55.2028,68.0802 53.5677,69.1004C 51.9327,70.1206 50.0531,70.8595 47.9289,71.3172C 45.8047,71.7749 43.5582,72.0037 41.1895,72.0037C 40.3999,72.0037 39.4304,71.9425 38.281,71.8203C 37.1315,71.698 35.9542,71.5216 34.7488,71.291C 33.5435,71.0604 32.4028,70.7809 31.3267,70.4525C 30.2507,70.1241 29.3842,69.7538 28.7274,69.3415 Z M 69.5934,30.4146C 68.3147,30.4146 67.2212,30.0077 66.3128,29.1936C 65.4044,28.3795 64.9502,27.3437 64.9502,26.0859C 64.9502,24.8352 65.4044,23.7906 66.3128,22.9521C 67.2212,22.1136 68.3147,21.6944 69.5934,21.6944C 70.921,21.6944 72.0442,22.1136 72.9631,22.9521C 73.8819,23.7906 74.3414,24.8352 74.3414,26.0859C 74.3414,27.2738 73.8819,28.2922 72.9631,29.1412C 72.0442,29.9902 70.921,30.4146 69.5934,30.4146 Z M 73.6706,71.3331L 66.2918,71.3331L 66.2918,37.7934L 73.5497,37.8614L 73.6706,71.3331 Z M 113.918,68.8385C 113.918,81.2343 107.829,87.4321 95.6495,87.4321C 91.3523,87.4321 87.6035,86.6809 84.4032,85.1787L 84.4032,78.041C 88.0297,80.2769 91.471,81.395 94.7272,81.395C 102.602,81.395 106.539,77.3807 106.539,69.3521L 106.539,65.5999L 106.414,65.5999C 103.926,69.8692 100.188,72.0039 95.1988,72.0039C 91.1601,72.0039 87.904,70.5225 85.4304,67.5598C 82.9568,64.5972 81.7201,60.6213 81.7201,55.6323C 81.7201,49.9724 83.0494,45.4725 85.7082,42.1326C 88.3669,38.7926 92.0161,37.1226 96.6557,37.1226C 101.044,37.1226 104.296,38.9288 106.414,42.5414L 106.539,42.5414L 106.539,37.7933L 113.918,37.7933L 113.918,68.8385 Z M 106.613,55.9572L 106.613,51.6389C 106.613,49.2982 105.856,47.2998 104.344,45.6438C 102.831,43.9877 100.943,43.1597 98.6786,43.1597C 95.8906,43.1597 93.7088,44.2148 92.1331,46.325C 90.5574,48.4352 89.7696,51.3875 89.7696,55.1816C 89.7696,58.4517 90.526,61.0668 92.0388,63.0267C 93.5515,64.9867 95.5552,65.9667 98.0497,65.9667C 100.586,65.9667 102.647,65.0304 104.234,63.1577C 105.82,61.2851 106.613,58.8849 106.613,55.9572 Z M 153.495,71.333L 146.116,71.333L 146.116,52.5193C 146.116,46.2795 143.884,43.1597 139.419,43.1597C 137.085,43.1597 135.158,44.0244 133.638,45.7538C 132.119,47.4832 131.359,49.6615 131.359,52.2887L 131.359,71.333L 123.98,71.333L 123.98,37.7933L 131.359,37.7933L 131.359,43.4846L 131.485,43.4846C 133.986,39.2432 137.595,37.1225 142.312,37.1225C 145.945,37.1225 148.717,38.3034 150.628,40.6652C 152.54,43.0269 153.495,46.4368 153.495,50.8948L 153.495,71.333 Z M 184.299,30.4146C 183.02,30.4146 181.927,30.0075 181.019,29.1935C 180.11,28.3794 179.656,27.3436 179.656,26.0858C 179.656,24.8351 180.11,23.7904 181.019,22.952C 181.927,22.1135 183.02,21.6942 184.299,21.6942C 185.627,21.6942 186.75,22.1135 187.669,22.952C 188.588,23.7904 189.047,24.8351 189.047,26.0858C 189.047,27.2737 188.588,28.2921 187.669,29.1411C 186.75,29.9901 185.627,30.4146 184.299,30.4146 Z M 188.376,71.333L 180.998,71.333L 180.998,37.7932L 188.344,37.8003L 188.376,71.333 Z M 227.953,71.3329L 220.574,71.3329L 220.574,52.5193C 220.574,46.2795 218.342,43.1596 213.877,43.1596C 211.543,43.1596 209.616,44.0243 208.097,45.7537C 206.577,47.4831 205.817,49.6614 205.817,52.2887L 205.817,71.3329L 198.438,71.3329L 198.438,37.7932L 205.817,37.7932L 205.817,43.4845L 205.943,43.4845C 208.444,39.2431 212.053,37.1224 216.77,37.1224C 220.403,37.1224 223.175,38.3033 225.087,40.6651C 226.998,43.0269 227.953,46.4367 227.953,50.8947L 227.953,71.3329 Z "/>' + '', 'login');
        var tdLogoHoriz = svgBoilerPlate('-20 -15 455 58', '<path fill="#5ACC13" d="M 144.047,34.0633C 152.854,34.0633 160.032,26.8941 160.032,18.0977C 160.032,9.30162 152.854,2.13243 144.047,2.13243C 135.24,2.13243 128.062,9.30162 128.062,18.0977C 128.062,26.8941 135.24,34.0633 144.047,34.0633 Z M 144.047,32.1437C 136.25,32.1437 129.984,25.8845 129.984,18.0977C 129.984,10.3109 136.251,3.96493 144.047,3.96493C 151.844,3.96493 158.11,10.3109 158.11,18.0977C 158.11,25.8845 151.844,32.1437 144.047,32.1437 Z M 142.113,22.7178C 142.452,22.7178 142.74,22.6112 142.977,22.3938C 143.213,22.1789 143.329,21.9187 143.329,21.617C 143.329,21.3135 143.213,21.0512 142.977,20.8303C 142.74,20.6126 142.452,20.5035 142.113,20.5035C 141.778,20.5035 141.496,20.6126 141.264,20.8303C 141.029,21.0512 140.914,21.3135 140.914,21.617C 140.914,21.9187 141.029,22.1789 141.264,22.3938C 141.496,22.6112 141.778,22.7178 142.113,22.7178 Z M 142.113,16.0708C 142.452,16.0708 142.74,15.9646 142.977,15.7489C 143.213,15.5312 143.329,15.2751 143.329,14.9734C 143.329,14.6666 143.213,14.4033 142.977,14.1858C 142.74,13.965 142.452,13.8566 142.113,13.8566C 141.778,13.8566 141.496,13.965 141.264,14.1858C 141.029,14.4033 140.914,14.6666 140.914,14.9734C 140.914,15.2751 141.029,15.5312 141.264,15.7489C 141.496,15.9646 141.778,16.0708 142.113,16.0708 Z M 145.957,25.2742C 147.724,23.309 148.61,20.8861 148.61,18.0047C 148.61,15.1131 147.727,12.6509 145.966,10.6178L 144.319,10.6178C 146.044,12.7258 146.908,15.1849 146.908,17.9883C 146.908,20.7687 146.047,23.1975 144.328,25.2742L 145.957,25.2742 Z M 15.8976,34.0625C 24.7052,34.0625 31.8824,26.8933 31.8824,18.0969C 31.8824,9.30157 24.7052,2.13238 15.8976,2.13238C 7.09033,2.13238 -7.77965e-006,9.30157 -7.77965e-006,18.0969C -7.77965e-006,26.8933 7.09033,34.0625 15.8976,34.0625 Z M 15.8976,32.2297C 8.10089,32.2297 1.83402,25.8838 1.83402,18.0969C 1.83402,10.3111 8.10089,4.05116 15.8976,4.05116C 23.6944,4.05116 30.0487,10.3111 30.0487,18.0969C 30.0487,25.8838 23.6944,32.2297 15.8976,32.2297 Z M 16.3347,20.453C 19.3352,20.453 21.7501,18.0391 21.7501,15.0444C 21.7501,12.0464 19.3352,9.63488 16.3347,9.63488C 13.3359,9.63488 10.8311,12.0464 10.8311,15.0444C 10.8311,18.0391 13.3359,20.453 16.3347,20.453 Z M 16.3347,19.0567C 16.1515,19.0567 15.9708,19.0449 15.7936,19.0221L 14.7623,15.2186L 17.9069,15.2186L 16.7929,19.0318C 16.6427,19.0483 16.4898,19.0567 16.3347,19.0567 Z M 20.352,15.0444C 20.352,16.7246 19.3582,18.1402 17.9135,18.744L 19.0423,14.8692C 19.0524,14.8114 19.0524,14.7529 19.0423,14.695C 19.0251,14.6313 18.9958,14.5714 18.9551,14.5209L 18.8681,14.4328L 18.7799,14.3457L 18.6927,14.3457L 18.6055,14.2586L 18.5183,14.2586L 14.1511,14.2586L 14.0629,14.2586C 14.0001,14.2759 13.9401,14.3063 13.8885,14.3457C 13.8166,14.3882 13.7556,14.4491 13.7141,14.5209C 13.6736,14.5725 13.6432,14.6323 13.6269,14.695L 13.6269,14.7821L 13.6269,14.8692L 14.7566,18.7495C 13.2804,18.1489 12.2288,16.7297 12.2288,15.0444C 12.2288,12.7988 14.0891,11.0309 16.3347,11.0309C 18.5832,11.0309 20.352,12.7988 20.352,15.0444 Z M 13.6513,21.9858L 18.9561,21.5727L 18.9624,21.034L 13.6645,21.026L 13.6513,21.9858 Z M 13.6513,22.3766L 13.6513,23.1086L 18.9512,22.6864L 18.9562,21.9474L 13.6513,22.3766 Z M 13.6706,23.4914L 13.7344,24.1272L 18.9513,23.7252L 18.9562,23.0752L 13.6706,23.4914 Z M 13.838,24.4958L 13.838,24.516L 13.8462,24.5151L 13.838,24.4958 Z M 13.8462,24.5151C 13.9245,24.6987 14.004,24.8784 14.1125,25.0484C 14.2241,25.2215 14.3692,25.3835 14.5262,25.5232C 14.6824,25.6629 14.8527,25.7855 15.0595,25.8889C 15.2643,25.9952 15.5046,26.0841 15.7366,26.1378C 15.9707,26.1906 16.1999,26.2067 16.4747,26.1764C 16.7485,26.146 17.0635,26.0649 17.3516,25.9444C 17.6425,25.8249 17.908,25.6629 18.1037,25.4949C 18.2994,25.3278 18.4281,25.1518 18.5265,24.9846C 18.6269,24.8146 18.6967,24.6526 18.7525,24.516L 18.8672,24.1938L 18.8833,24.1018L 18.045,24.1555L 14.6905,24.4289L 13.8462,24.5151 Z M 58.7067,34.0625C 67.5139,34.0625 74.6922,26.8933 74.6922,18.0969C 74.6922,9.30154 67.5139,2.13235 58.7067,2.13235C 49.9001,2.13235 42.7218,9.30154 42.7218,18.0969C 42.7218,26.8933 49.9001,34.0625 58.7067,34.0625 Z M 58.7063,32.2299C 50.9106,32.2299 44.6434,25.8839 44.6434,18.0971C 44.6434,10.3113 50.9106,4.05133 58.7063,4.05133C 66.503,4.05133 72.7698,10.3113 72.7698,18.0971C 72.7698,25.8839 66.503,32.2299 58.7063,32.2299 Z M 51.8838,25.6428L 54.5955,25.2188L 52.3063,22.9356L 51.8838,25.6428 Z M 55.9113,24.8147L 64.1227,16.6148L 60.8909,13.386L 52.6795,21.587L 55.9113,24.8147 Z M 64.8214,15.9162L 65.52,15.2187C 65.6506,15.089 65.6278,15.0956 65.6831,15.0404C 66.5185,14.2061 66.4252,12.8181 65.5898,11.9838C 64.7565,11.1515 63.3626,11.0148 62.5304,11.8491L 62.288,12.0778L 61.6768,12.6885L 64.8214,15.9162 Z M 101.238,34.0624C 110.045,34.0624 117.223,26.8932 117.223,18.0968C 117.223,9.30075 110.045,2.13233 101.238,2.13233C 92.4305,2.13233 85.3402,9.30075 85.3402,18.0968C 85.3402,26.8932 92.4305,34.0624 101.238,34.0624 Z M 101.238,32.23C 93.4411,32.23 87.1742,25.8837 87.1742,18.0969C 87.1742,10.3101 93.4411,4.05118 101.238,4.05118C 109.035,4.05118 115.389,10.3101 115.389,18.0969C 115.389,25.8837 109.035,32.23 101.238,32.23 Z M 107.567,18.1122L 98.0294,10.9521L 98.0294,25.2702L 107.567,18.1122 Z "/>' + '<path fill="#000000" d="M 201.679,28.4272C 200.753,28.851 199.884,29.0629 199.072,29.0629C 196.153,29.0629 194.694,27.3434 194.694,23.9042L 194.694,10.8501L 191.208,10.8501L 191.208,9.30013L 194.694,9.30013L 194.694,4.09301L 195.664,3.77817C 196,3.68936 196.323,3.59248 196.634,3.48754L 196.634,9.30013L 201.679,9.30013L 201.679,10.8501L 196.634,10.8501L 196.634,23.6923C 196.634,25.0365 196.843,26.0093 197.259,26.6107C 197.675,27.2122 198.383,27.5129 199.381,27.5129C 200.092,27.5129 200.858,27.2788 201.679,26.8105L 201.679,28.4272 Z M 213.331,29.0629C 210.458,29.0629 208.185,28.1406 206.514,26.2959C 204.842,24.4512 204.007,22.0535 204.007,19.1029C 204.007,15.91 204.881,13.4134 206.629,11.6131C 208.377,9.81281 210.68,8.91267 213.538,8.91267C 216.347,8.91267 218.565,9.80676 220.192,11.5949C 221.818,13.3831 222.632,15.8595 222.632,19.0241C 222.632,22.0152 221.802,24.4361 220.143,26.2868C 218.484,28.1376 216.213,29.0629 213.331,29.0629 Z M 213.459,10.4627C 211.171,10.4627 209.347,11.2276 207.987,12.7575C 206.627,14.2873 205.947,16.4145 205.947,19.1392C 205.947,21.662 206.611,23.6883 207.939,25.2182C 209.266,26.748 211.082,27.5129 213.386,27.5129C 215.726,27.5129 217.529,26.7601 218.794,25.2545C 220.059,23.7489 220.692,21.66 220.692,18.9878C 220.692,16.2389 220.062,14.1309 218.803,12.6636C 217.544,11.1963 215.763,10.4627 213.459,10.4627 Z M 240.093,28.6754L 240.093,25.085L 240.02,25.085C 238.666,27.7369 236.583,29.0629 233.769,29.0629C 229.19,29.0629 226.9,26.193 226.9,20.4531L 226.9,9.30017L 228.84,9.30017L 228.84,20.0413C 228.84,22.657 229.266,24.5562 230.117,25.7389C 230.967,26.9216 232.306,27.5129 234.133,27.5129C 235.908,27.5129 237.344,26.8519 238.444,25.53C 239.543,24.208 240.093,22.4471 240.093,20.2472L 240.093,9.30017L 242.033,9.30017L 242.033,28.6754L 240.093,28.6754 Z M 260.967,27.7733C 259.496,28.633 257.74,29.0629 255.699,29.0629C 252.999,29.0629 250.822,28.1658 249.169,26.3716C 247.516,24.5774 246.689,22.2291 246.689,19.3269C 246.689,16.2753 247.619,13.7767 249.478,11.8311C 251.338,9.88546 253.728,8.91266 256.651,8.91266C 258.158,8.91266 259.623,9.20732 261.046,9.79665L 261.046,11.7523C 259.636,10.8926 258.09,10.4627 256.408,10.4627C 254.096,10.4627 252.222,11.275 250.785,12.8997C 249.348,14.5244 248.629,16.6285 248.629,19.2118C 248.629,21.7104 249.287,23.7186 250.603,25.2363C 251.919,26.754 253.654,27.5129 255.808,27.5129C 257.784,27.5129 259.504,26.9942 260.967,25.9569L 260.967,27.7733 Z M 278.507,28.6754L 278.507,17.0866C 278.507,14.7979 278.097,13.1217 277.276,12.0581C 276.456,10.9945 275.177,10.4627 273.439,10.4627C 271.802,10.4627 270.362,11.1105 269.119,12.4063C 267.876,13.702 267.255,15.5588 267.255,17.9767L 267.255,28.6754L 265.314,28.6754L 265.314,2.67029e-005L 267.255,2.67029e-005L 267.255,12.8483L 267.333,12.8483C 268.861,10.2245 271.084,8.91265 274.003,8.91265C 276.1,8.91265 277.699,9.58473 278.798,10.9289C 279.898,12.2731 280.447,14.2005 280.447,16.7112L 280.447,28.6754L 278.507,28.6754 Z M 303.341,28.6754L 299.072,28.6754L 299.072,25.309L 299,25.309C 297.597,27.8116 295.439,29.0629 292.525,29.0629C 290.16,29.0629 288.267,28.2011 286.847,26.4776C 285.426,24.754 284.716,22.4087 284.716,19.4419C 284.716,16.2571 285.501,13.706 287.071,11.7887C 288.641,9.87132 290.734,8.91265 293.349,8.91265C 295.94,8.91265 297.823,9.95609 299,12.043L 299.072,12.043L 299.072,2.28882e-005L 303.341,2.28882e-005L 303.341,28.6754 Z M 299.133,19.8052L 299.133,17.2925C 299.133,15.9281 298.698,14.7717 297.827,13.8231C 296.955,12.8745 295.847,12.4002 294.501,12.4002C 292.909,12.4002 291.656,13.0057 290.742,14.2166C 289.829,15.4276 289.372,17.1088 289.372,19.2603C 289.372,21.2099 289.81,22.7498 290.688,23.8801C 291.565,25.0103 292.743,25.5754 294.222,25.5754C 295.681,25.5754 296.865,25.0284 297.772,23.9345C 298.679,22.8407 299.133,21.4642 299.133,19.8052 Z M 326.234,20.1503L 312.653,20.1503C 312.706,21.886 313.274,23.2241 314.357,24.1646C 315.44,25.1051 316.93,25.5754 318.825,25.5754C 320.951,25.5754 322.904,24.9295 324.682,23.6379L 324.682,27.3252C 322.855,28.4837 320.442,29.0629 317.443,29.0629C 314.496,29.0629 312.185,28.189 310.51,26.4412C 308.835,24.6934 307.997,22.2332 307.997,19.0604C 307.997,16.0654 308.919,13.6253 310.762,11.7402C 312.605,9.85517 314.894,8.91264 317.631,8.91264C 320.367,8.91264 322.485,9.75728 323.985,11.4466C 325.484,13.1359 326.234,15.4801 326.234,18.4792L 326.234,20.1503 Z M 321.578,17.0503C 321.566,15.581 321.196,14.4386 320.468,13.6233C 319.741,12.8079 318.736,12.4002 317.455,12.4002C 316.198,12.4002 315.134,12.8291 314.263,13.6868C 313.392,14.5446 312.855,15.6657 312.653,17.0503L 321.578,17.0503 Z M 346.799,9.30015L 339.148,28.6754L 334.298,28.6754L 327.01,9.30015L 331.788,9.30015L 336.256,22.8507C 336.595,23.8478 336.806,24.7176 336.887,25.4603L 336.947,25.4603C 337.064,24.5279 337.246,23.6823 337.493,22.9234L 342.179,9.30015L 346.799,9.30015 Z M 366.589,20.1503L 353.008,20.1503C 353.06,21.886 353.628,23.2241 354.711,24.1646C 355.795,25.1051 357.284,25.5754 359.18,25.5754C 361.306,25.5754 363.258,24.9295 365.036,23.6379L 365.036,27.3252C 363.209,28.4837 360.796,29.0629 357.797,29.0629C 354.851,29.0629 352.54,28.189 350.864,26.4412C 349.189,24.6934 348.351,22.2331 348.351,19.0604C 348.351,16.0653 349.273,13.6253 351.116,11.7402C 352.959,9.85516 355.249,8.91264 357.985,8.91264C 360.722,8.91264 362.84,9.75727 364.339,11.4466C 365.839,13.1358 366.589,15.48 366.589,18.4792L 366.589,20.1503 Z M 361.932,17.0503C 361.92,15.581 361.55,14.4386 360.823,13.6233C 360.095,12.8079 359.091,12.4002 357.809,12.4002C 356.552,12.4002 355.488,12.8291 354.617,13.6868C 353.746,14.5446 353.21,15.6657 353.008,17.0503L 361.932,17.0503 Z M 374.349,28.6754L 370.081,28.6754L 370.081,0L 374.349,0L 374.349,28.6754 Z M 388.967,29.0629C 385.939,29.0629 383.522,28.1638 381.715,26.3655C 379.909,24.5672 379.005,22.1827 379.005,19.2118C 379.005,15.9786 379.947,13.4537 381.831,11.6373C 383.714,9.82084 386.252,8.91263 389.446,8.91263C 392.513,8.91263 394.903,9.79562 396.615,11.5616C 398.327,13.3276 399.182,15.7787 399.182,18.9151C 399.182,21.9829 398.26,24.4411 396.415,26.2898C 394.57,28.1386 392.087,29.0629 388.967,29.0629 Z M 389.191,12.4002C 387.485,12.4002 386.137,12.9935 385.147,14.1803C 384.157,15.367 383.662,17.0038 383.662,19.0907C 383.662,21.1009 384.163,22.6842 385.165,23.8407C 386.168,24.9971 387.509,25.5754 389.191,25.5754C 390.905,25.5754 392.222,25.0072 393.144,23.871C 394.065,22.7347 394.526,21.117 394.526,19.018C 394.526,16.9069 394.065,15.2762 393.144,14.1258C 392.222,12.9754 390.905,12.4002 389.191,12.4002 Z M 407.798,25.7449L 407.719,25.7449L 407.719,37.588L 403.451,37.588L 403.451,9.30013L 407.719,9.30013L 407.719,12.7574L 407.798,12.7574C 409.326,10.1942 411.561,8.91262 414.503,8.91262C 417.009,8.91262 418.963,9.77341 420.363,11.495C 421.764,13.2166 422.464,15.5285 422.464,18.4307C 422.464,21.6478 421.674,24.2241 420.093,26.1597C 418.513,28.0952 416.355,29.0629 413.618,29.0629C 411.1,29.0629 409.16,27.9569 407.798,25.7449 Z M 407.683,18.1704L 407.683,20.5499C 407.683,21.9506 408.138,23.1383 409.05,24.1131C 409.961,25.088 411.12,25.5754 412.527,25.5754C 414.172,25.5754 415.463,24.9477 416.401,23.6923C 417.339,22.437 417.808,20.6851 417.808,18.4368C 417.808,16.5477 417.371,15.0693 416.498,14.0017C 415.625,12.934 414.441,12.4002 412.945,12.4002C 411.365,12.4002 410.093,12.9501 409.129,14.0501C 408.165,15.1501 407.683,16.5235 407.683,18.1704 Z "/>');
        var horizontalMarker = svgBoilerPlate('0 0 100 30', "<path fill='#E72A59' d='M 0.583332,10.9896L 71.726,10.9896C 73.4524,5.17697 78.8353,0.937502 85.2083,0.937502C 92.9748,0.937502 99.2708,7.2335 99.2708,15C 99.2708,22.7665 92.9748,29.0625 85.2083,29.0625C 78.8353,29.0625 73.4524,24.823 71.726,19.0104L 0.583332,19.0104L 0.583332,10.9896 Z'/>" + "<path fill='#FFFFFF' d='M 85.2083,5.52735C 90.4399,5.52735 94.681,9.76839 94.681,15C 94.681,20.2316 90.4399,24.4727 85.2083,24.4727C 79.9767,24.4727 75.7158,20.2316 75.7357,15C 75.7552,9.85417 79.9767,5.52735 85.2083,5.52735 Z '/>");
        var verticalMarker = svgBoilerPlate('0 0 30 100', "<path fill='#E72A59' d='M 19.0104,0.583336L 19.0104,71.726C 24.823,73.4524 29.0625,78.8353 29.0625,85.2083C 29.0625,92.9748 22.7665,99.2708 15,99.2708C 7.23349,99.2708 0.937499,92.9748 0.937499,85.2083C 0.937499,78.8353 5.17696,73.4524 10.9896,71.726L 10.9896,0.583336L 19.0104,0.583336 Z'/>" + "<path fill='#FFFFFF' d='M 24.4727,85.2083C 24.4727,90.4399 20.2316,94.681 15,94.681C 9.7684,94.681 5.52735,90.4399 5.52735,85.2083C 5.52735,79.9767 9.76844,75.7158 15,75.7357C 20.1458,75.7552 24.4727,79.9767 24.4727,85.2083 Z'/>");
        var tdLogo = svgBoilerPlate('0 0 2200 480', '<path fill="#0095FF" d="M 396.586,234.249L 284.566,318.402L 284.566,150.077L 396.586,234.249 Z M 314.585,31.9531C 425.459,28.0533 517.645,115.134 521.618,225.278C 525.049,335.522 438.076,428.204 327.832,431.628C 258.702,433.933 196.856,400.879 159.138,348.896L 179.394,334.162C 212.455,379.699 266.374,408.679 326.994,406.689C 423.623,403.68 499.688,322.771 496.679,226.115C 493.168,129.373 412.788,53.5758 315.576,57.0802L 315.422,57.0802C 265.851,58.5744 222.036,80.4518 190.966,114.531L 172.352,97.6253C 207.744,58.8358 258.099,33.7086 314.585,31.9531 Z M 100.167,94.925C 154.609,94.925 199.342,139.108 199.342,194.1C 199.342,249.091 154.609,293.121 100.167,293.121C 45.7246,293.121 -5.03592e-005,249.225 -5.03592e-005,194.1C -5.03592e-005,138.981 45.7246,94.925 100.167,94.925 Z M 100.167,112.018C 54.911,112.018 17.0931,148.456 17.0931,194.1C 17.0931,232.494 43.8115,264.227 79.2072,273.371L 63.3136,216.165L 60.6467,206.851L 139.378,206.851L 136.336,216.352L 119.25,273.825C 155.335,265.333 182.248,233.235 182.248,194.1C 182.248,148.322 145.422,112.018 100.167,112.018 Z M 100.167,276.028L 102.584,275.993L 118.935,221.74L 80.7484,221.74L 95.7724,275.913L 100.167,276.028 Z M 54.5961,296.967L 143.037,296.967L 143.037,306.073L 54.5961,313.035L 54.5961,296.967 Z M 143.037,312.512L 143.037,324.841L 54.5961,331.803L 54.5961,319.474L 143.037,312.512 Z M 143.037,331.28L 143.037,341.988L 55.6682,348.95L 54.5962,338.242L 143.037,331.28 Z M 57.8191,354.86L 72.2924,353.788L 128.564,348.95L 142.514,347.871L 141.965,349.499L 139.847,354.86L 136.075,362.9C 134.48,365.567 132.336,368.79 129.113,371.484C 125.897,374.151 121.602,376.824 116.784,378.968C 111.973,381.112 106.606,382.191 102.311,382.741C 97.4999,383.263 93.7275,382.741 89.9818,382.191C 86.2429,381.112 81.9479,380.04 78.7316,377.896C 75.5086,376.301 72.2924,374.151 69.6188,372.006C 66.9252,369.862 64.781,367.189 62.6302,363.972C 60.486,361.272 58.8912,358.605 57.8191,354.86 Z "/>' + '<path class="hidden-portrait" fill="#7e7e7e" d="M 751.846,162.195L 732.672,162.195L 732.672,89.8798C 732.672,83.9597 733.055,76.7088 733.821,68.1279L 733.521,68.1279C 732.423,73.017 731.441,76.5259 730.575,78.6546L 698.32,162.195L 685.986,162.195L 653.656,79.2782C 652.74,76.8335 651.783,73.1168 650.785,68.1279L 650.485,68.1279C 650.951,72.6013 651.184,79.9018 651.184,90.0294L 651.184,162.195L 632.011,162.195L 632.011,50.4419L 660.147,50.4419L 688.233,124.877C 690.38,130.582 691.778,134.839 692.428,137.649L 692.802,137.649C 694.633,131.779 696.123,127.414 697.271,124.553L 725.882,50.4419L 751.846,50.4419L 751.846,162.195 Z M 780.48,64.814C 777.435,64.814 774.83,63.8453 772.666,61.9079C 770.502,59.9706 769.42,57.5052 769.42,54.5116C 769.42,51.5348 770.502,49.0488 772.666,47.0532C 774.83,45.0575 777.435,44.0597 780.48,44.0597C 783.643,44.0597 786.318,45.0575 788.507,47.0532C 790.695,49.0488 791.79,51.5348 791.79,54.5116C 791.79,57.3388 790.695,59.7625 788.507,61.7832C 786.318,63.8036 783.643,64.814 780.48,64.814 Z M 790.192,162.198L 772.616,162.198L 772.616,82.3751L 790.192,82.3751L 790.192,162.198 Z M 868.485,158.407C 862.093,161.999 854.529,163.795 845.791,163.795C 833.94,163.795 824.374,160.116 817.093,152.757C 809.811,145.398 806.17,135.865 806.17,124.157C 806.17,111.087 810.077,100.589 817.891,92.6648C 825.706,84.7408 836.154,80.7786 849.236,80.7786C 856.509,80.7786 862.926,82.0591 868.485,84.6201L 868.485,101.533C 863.025,97.2756 857.2,95.147 851.008,95.147C 843.502,95.147 837.348,97.7079 832.546,102.83C 827.745,107.952 825.344,114.654 825.344,122.935C 825.344,131.117 827.607,137.578 832.135,142.317C 836.662,147.057 842.737,149.427 850.359,149.427C 856.767,149.427 862.809,147.298 868.485,143.041L 868.485,158.407 Z M 929.202,99.9362C 926.971,97.8075 923.768,96.7432 919.59,96.7432C 914.131,96.7432 909.575,99.1714 905.921,104.027C 902.268,108.883 900.441,115.485 900.441,123.833L 900.441,162.198L 882.865,162.198L 882.865,82.3751L 900.441,82.3751L 900.441,98.5393L 900.766,98.5393C 902.563,92.9518 905.331,88.5946 909.067,85.4682C 912.803,82.3418 916.969,80.7786 921.562,80.7786C 924.908,80.7786 927.454,81.2856 929.202,82.3002L 929.202,99.9362 Z M 975.014,163.795C 962.548,163.795 952.595,160.09 945.155,152.682C 937.716,145.273 933.996,135.449 933.996,123.209C 933.996,109.889 937.874,99.4871 945.63,92.0038C 953.386,84.5203 963.838,80.7784 976.987,80.7784C 989.619,80.7784 999.46,84.4163 1006.51,91.6918C 1013.56,98.9675 1017.08,109.066 1017.08,121.987C 1017.08,134.626 1013.28,144.753 1005.68,152.37C 998.087,159.986 987.863,163.795 975.014,163.795 Z M 975.938,95.1467C 968.914,95.1467 963.364,97.5914 959.286,102.48C 955.208,107.37 953.169,114.113 953.169,122.71C 953.169,130.992 955.233,137.515 959.361,142.28C 963.489,147.044 969.014,149.427 975.938,149.427C 982.995,149.427 988.421,147.086 992.216,142.404C 996.011,137.723 997.908,131.059 997.908,122.411C 997.908,113.714 996.011,106.996 992.216,102.256C 988.421,97.5167 982.995,95.1467 975.938,95.1467 Z M 1026.67,159.18L 1026.67,141.444C 1033.36,146.766 1040.74,149.427 1048.81,149.427C 1059.62,149.427 1065.02,146.574 1065.02,140.87C 1065.02,139.058 1064.55,137.519 1063.63,136.256C 1062.71,134.992 1061.46,133.869 1059.89,132.888C 1058.31,131.907 1056.46,131.03 1054.32,130.256L 1047.17,127.625C 1043.92,126.344 1041,124.98 1038.39,123.534C 1035.79,122.087 1033.62,120.449 1031.89,118.62C 1030.16,116.791 1028.85,114.712 1027.98,112.384C 1027.11,110.055 1026.67,107.345 1026.67,104.252C 1026.67,100.427 1027.58,97.055 1029.42,94.1364C 1031.25,91.218 1033.71,88.765 1036.79,86.7776C 1039.88,84.7904 1043.38,83.2937 1047.3,82.2876C 1051.22,81.2815 1055.28,80.7784 1059.47,80.7784C 1066.9,80.7784 1073.54,81.9842 1079.4,84.3953L 1079.4,101.533C 1073.92,97.2754 1067.63,95.1467 1060.52,95.1467C 1058.29,95.1467 1056.28,95.3545 1054.48,95.7704C 1052.68,96.1862 1051.15,96.7597 1049.87,97.4915C 1048.6,98.2231 1047.61,99.1046 1046.9,100.136C 1046.2,101.167 1045.84,102.306 1045.84,103.553C 1045.84,105.249 1046.2,106.692 1046.93,107.881C 1047.65,109.07 1048.73,110.118 1050.15,111.024C 1051.57,111.93 1053.27,112.758 1055.25,113.506L 1062.12,115.951C 1065.52,117.331 1068.57,118.745 1071.28,120.191C 1074,121.638 1076.31,123.28 1078.22,125.118C 1080.14,126.955 1081.61,129.071 1082.64,131.466C 1083.67,133.861 1084.19,136.713 1084.19,140.022C 1084.19,144.047 1083.24,147.556 1081.34,150.549C 1079.45,153.542 1076.92,156.02 1073.75,157.983C 1070.59,159.945 1066.94,161.404 1062.79,162.36C 1058.65,163.317 1054.28,163.795 1049.69,163.795C 1040.83,163.795 1033.16,162.257 1026.67,159.18 Z M 1133.2,163.795C 1120.73,163.795 1110.78,160.09 1103.34,152.682C 1095.9,145.273 1092.18,135.449 1092.18,123.209C 1092.18,109.889 1096.06,99.4871 1103.81,92.0036C 1111.57,84.52 1122.02,80.7784 1135.17,80.7784C 1147.8,80.7784 1157.64,84.416 1164.69,91.6918C 1171.74,98.9673 1175.27,109.066 1175.27,121.987C 1175.27,134.626 1171.47,144.753 1163.87,152.37C 1156.27,159.986 1146.05,163.795 1133.2,163.795 Z M 1134.12,95.1465C 1127.1,95.1465 1121.55,97.5912 1117.47,102.48C 1113.39,107.37 1111.35,114.113 1111.35,122.71C 1111.35,130.992 1113.42,137.515 1117.55,142.28C 1121.67,147.044 1127.2,149.427 1134.12,149.427C 1141.18,149.427 1146.61,147.086 1150.4,142.404C 1154.19,137.723 1156.09,131.059 1156.09,122.411C 1156.09,113.714 1154.19,106.996 1150.4,102.256C 1146.61,97.5164 1141.18,95.1465 1134.12,95.1465 Z M 1231.99,58.4276C 1229.44,57.3633 1226.54,56.8311 1223.28,56.8311C 1214.12,56.8311 1209.54,61.7621 1209.54,71.6234L 1209.54,82.3746L 1228.79,82.3746L 1228.79,96.743L 1209.62,96.743L 1209.62,162.198L 1192.04,162.198L 1192.04,96.743L 1177.66,96.743L 1177.66,82.3746L 1192.04,82.3746L 1192.04,69.5032C 1192.04,61.1382 1194.83,54.5403 1200.39,49.7094C 1205.96,44.8783 1212.92,42.4628 1221.28,42.4628C 1225.79,42.4628 1229.36,42.9367 1231.99,43.8847L 1231.99,58.4276 Z M 1282.32,161.051C 1278.82,162.88 1274.23,163.795 1268.54,163.795C 1253.23,163.795 1245.57,156.403 1245.57,141.619L 1245.57,96.743L 1232.79,96.743L 1232.79,82.3746L 1245.57,82.3746L 1245.57,63.641L 1263.15,58.4276L 1263.15,82.3746L 1282.32,82.3746L 1282.32,96.743L 1263.15,96.743L 1263.15,136.355C 1263.15,141.045 1264.01,144.396 1265.73,146.408C 1267.45,148.42 1270.32,149.426 1274.33,149.426C 1277.41,149.426 1280.07,148.362 1282.32,146.233L 1282.32,161.051 Z M 746.992,250.992L 699.508,250.992L 699.508,393.442L 671.018,393.442L 671.018,250.992L 623.535,250.992L 623.535,227.249L 746.992,227.249L 746.992,250.992 Z M 796.071,395.816C 777.548,395.816 762.758,390.307 751.704,379.289C 740.649,368.272 735.121,353.662 735.121,335.459C 735.121,315.651 740.884,300.182 752.408,289.053C 763.933,277.924 779.464,272.359 799.002,272.359C 817.773,272.359 832.395,277.769 842.869,288.589C 853.343,299.409 858.579,314.427 858.579,333.642C 858.579,352.437 852.935,367.499 841.645,378.826C 830.355,390.152 815.164,395.816 796.071,395.816 Z M 797.444,293.727C 787.007,293.727 778.76,297.362 772.7,304.633C 766.641,311.904 763.612,321.933 763.612,334.718C 763.612,347.034 766.678,356.734 772.812,363.82C 778.945,370.905 787.156,374.448 797.444,374.448C 807.93,374.448 815.992,370.967 821.631,364.005C 827.27,357.044 830.089,347.133 830.089,334.272C 830.089,321.339 827.27,311.348 821.631,304.299C 815.992,297.251 807.93,293.727 797.444,293.727 Z M 986.786,393.442L 960.67,393.442L 960.67,374.226L 960.225,374.226C 952.459,388.619 940.415,395.816 924.092,395.816C 896.245,395.816 882.322,379.023 882.322,345.438L 882.322,274.733L 908.438,274.733L 908.438,342.582C 908.438,363.826 916.698,374.448 933.218,374.448C 941.206,374.448 947.779,371.524 952.935,365.675C 958.092,359.826 960.67,352.165 960.67,342.693L 960.67,274.733L 986.786,274.733L 986.786,393.442 Z M 1107.87,387.803C 1098.37,393.145 1087.13,395.816 1074.15,395.816C 1056.54,395.816 1042.33,390.344 1031.51,379.4C 1020.69,368.457 1015.28,354.28 1015.28,336.869C 1015.28,317.431 1021.08,301.82 1032.69,290.035C 1044.3,278.251 1059.83,272.358 1079.27,272.358C 1090.08,272.358 1099.61,274.263 1107.87,278.071L 1107.87,303.223C 1099.76,296.892 1091.1,293.726 1081.9,293.726C 1070.75,293.726 1061.6,297.535 1054.47,305.152C 1047.33,312.769 1043.77,322.736 1043.77,335.051C 1043.77,347.219 1047.13,356.827 1053.86,363.875C 1060.58,370.924 1069.61,374.448 1080.94,374.448C 1090.46,374.448 1099.44,371.282 1107.87,364.951L 1107.87,387.803 Z M 1238.45,393.441L 1212.33,393.441L 1212.33,328.819C 1212.33,305.424 1204.4,293.726 1188.52,293.726C 1180.53,293.726 1173.8,297.114 1168.32,303.891C 1162.84,310.667 1160.1,319.323 1160.1,329.857L 1160.1,393.441L 1133.99,393.441L 1133.99,217.752L 1160.1,217.752L 1160.1,294.876L 1160.55,294.876C 1169.5,279.864 1182.31,272.358 1198.98,272.358C 1225.29,272.358 1238.45,288.421 1238.45,320.547L 1238.45,393.441 Z M 1340.54,393.441L 1340.54,227.248L 1388.58,227.248C 1449.94,227.248 1480.62,254.255 1480.62,308.268C 1480.62,333.913 1472.1,354.521 1455.08,370.089C 1438.05,385.657 1415.23,393.441 1386.62,393.441L 1340.54,393.441 Z M 1369.03,250.99L 1369.03,369.699L 1390.96,369.699C 1410.27,369.699 1425.3,364.401 1436.03,353.803C 1446.76,343.206 1452.13,328.238 1452.13,308.898C 1452.13,270.293 1432.08,250.99 1391.99,250.99L 1369.03,250.99 Z M 1611.2,341.209L 1528.1,341.209C 1528.42,351.843 1531.9,360.042 1538.53,365.804C 1545.15,371.566 1554.27,374.448 1565.87,374.448C 1578.88,374.448 1590.82,370.491 1601.7,362.577L 1601.7,385.169C 1590.52,392.266 1575.76,395.815 1557.41,395.815C 1539.38,395.815 1525.24,390.461 1514.99,379.752C 1504.74,369.044 1499.61,353.97 1499.61,334.531C 1499.61,316.182 1505.25,301.232 1516.53,289.682C 1527.81,278.133 1541.82,272.358 1558.56,272.358C 1575.3,272.358 1588.26,277.533 1597.44,287.883C 1606.61,298.233 1611.2,312.596 1611.2,330.97L 1611.2,341.209 Z M 1582.71,322.216C 1582.63,313.214 1580.37,306.215 1575.92,301.219C 1571.47,296.224 1565.32,293.726 1557.48,293.726C 1549.79,293.726 1543.28,296.353 1537.95,301.609C 1532.62,306.864 1529.34,313.733 1528.1,322.216L 1582.71,322.216 Z M 1737.03,274.732L 1690.22,393.441L 1660.54,393.441L 1615.95,274.732L 1645.18,274.732L 1672.52,357.754C 1674.6,363.863 1675.88,369.192 1676.38,373.743L 1676.75,373.743C 1677.47,368.03 1678.58,362.849 1680.09,358.199L 1708.76,274.732L 1737.03,274.732 Z M 1858.12,341.209L 1775.02,341.209C 1775.34,351.843 1778.81,360.042 1785.44,365.804C 1792.07,371.566 1801.18,374.447 1812.78,374.447C 1825.79,374.447 1837.74,370.49 1848.62,362.576L 1848.62,385.168C 1837.44,392.266 1822.68,395.815 1804.33,395.815C 1786.3,395.815 1772.16,390.461 1761.91,379.752C 1751.65,369.044 1746.53,353.97 1746.53,334.531C 1746.53,316.181 1752.17,301.231 1763.44,289.682C 1774.72,278.132 1788.73,272.357 1805.48,272.357C 1822.22,272.357 1835.18,277.533 1844.35,287.882C 1853.53,298.233 1858.12,312.595 1858.12,330.97L 1858.12,341.209 Z M 1829.63,322.216C 1829.55,313.214 1827.29,306.215 1822.84,301.219C 1818.38,296.223 1812.24,293.725 1804.4,293.725C 1796.71,293.725 1790.2,296.353 1784.87,301.608C 1779.54,306.864 1776.26,313.733 1775.02,322.216L 1829.63,322.216 Z M 1905.6,393.441L 1879.48,393.441L 1879.48,217.751L 1905.6,217.751L 1905.6,393.441 Z M 1995.04,395.815C 1976.52,395.815 1961.73,390.306 1950.67,379.288C 1939.62,368.271 1934.09,353.661 1934.09,335.458C 1934.09,315.649 1939.85,300.18 1951.38,289.051C 1962.9,277.922 1978.43,272.357 1997.97,272.357C 2016.74,272.357 2031.36,277.767 2041.84,288.587C 2052.31,299.407 2057.55,314.425 2057.55,333.641C 2057.55,352.436 2051.9,367.498 2040.61,378.825C 2029.32,390.151 2014.13,395.815 1995.04,395.815 Z M 1996.41,293.725C 1985.98,293.725 1977.73,297.36 1971.67,304.631C 1965.61,311.902 1962.58,321.931 1962.58,334.717C 1962.58,347.033 1965.65,356.733 1971.78,363.819C 1977.91,370.904 1986.12,374.447 1996.41,374.447C 2006.9,374.447 2014.96,370.966 2020.6,364.004C 2026.24,357.043 2029.06,347.132 2029.06,334.271C 2029.06,321.337 2026.24,311.346 2020.6,304.297C 2014.96,297.249 2006.9,293.725 1996.41,293.725 Z M 2110.26,375.486L 2109.78,375.486L 2109.78,448.047L 2083.66,448.047L 2083.66,274.731L 2109.78,274.731L 2109.78,295.913L 2110.26,295.913C 2119.61,280.209 2133.29,272.357 2151.29,272.357C 2166.63,272.357 2178.58,277.631 2187.15,288.179C 2195.72,298.726 2200,312.891 2200,330.673C 2200,350.384 2195.17,366.168 2185.5,378.027C 2175.83,389.885 2162.62,395.815 2145.88,395.815C 2130.47,395.815 2118.6,389.039 2110.26,375.486 Z M 2109.56,329.078L 2109.56,343.657C 2109.56,352.238 2112.35,359.516 2117.92,365.488C 2123.5,371.461 2130.59,374.447 2139.2,374.447C 2149.26,374.447 2157.17,370.601 2162.9,362.91C 2168.64,355.219 2171.51,344.485 2171.51,330.71C 2171.51,319.136 2168.84,310.078 2163.5,303.537C 2158.16,296.995 2150.91,293.725 2141.76,293.725C 2132.09,293.725 2124.3,297.094 2118.41,303.833C 2112.51,310.573 2109.56,318.987 2109.56,329.078 Z "/>');
        var videoPlay = svgBoilerPlate('0 0 320 180', '<g transform="translate(0,-872.36218)"><path d="m193.35,76.144a35.355,35.355,0,1,1,-70.711,0,35.355,35.355,0,1,1,70.711,0z" fill-opacity="0.41269842000000001" transform="matrix(1.4083841,0,0,1.4083841,-58.307492,855.21509)" stroke="#FFF" stroke-miterlimit="10" stroke-dasharray="none" stroke-width="6.85040394999999960" fill="#000"/><path fill="#FFF" d="m151.19,939.89-0.21124,46.293,36.567-22.321z"/></g>', "videoplay", "Play video icon");
        var cloudpath = "<path style='fill:none;stroke:fgcolor;stroke-width:4;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:desiredopacity;stroke-dasharray:none;marker-start:none' d='M 53.728638,839.48313 C 44.890866,821.0777 75.842011,799.132 90.002668,814.85472 m 95.479832,42.85851 c -1.38106,-5.8005 4.40628,-18.7826 16.84904,-18.7826 13.54573,0 21.94059,7.3948 22.09708,21.2685 0.12491,11.0738 -9.9144,15.1917 -18.78252,15.1917 -113.282692,0 -116.668932,-0.117 -192.520858,0 -19.4386752,0.03 -13.81264047,-42.1213 18.48727,-28.1053 M 171.91337,824.7065 c -4.93156,-14.64758 -17.61648,-26.12905 -40.14249,-26.46505 -23.58689,-0.35183 -48.384356,11.52296 -51.525738,39.03198 m 118.210358,2.1465 c -2.39812,-10.1263 -12.21999,-14.27103 -22.09021,-14.82478 -25.14358,-1.41071 -32.89057,15.94078 -28.71083,28.10798 m -117.127762,6.9436 c -2.458337,-17.837 10.678185,-24.8171 21.948736,-24.6319'/>";
        var peoplepath = "<path style='fill:fgcolor;fill-opacity:desiredopacity;fill-rule:nonzero;stroke:none' d='m 166.22645,843.32735 c 2.92046,0 5.28806,3.01049 5.28806,6.72401 0,3.71352 -2.3676,6.72401 -5.28806,6.72401 -2.92065,0 -5.28825,-3.01049 -5.28825,-6.72401 0,-3.71352 2.3676,-6.72401 5.28825,-6.72401 z m 11.17157,32.21923 -22.41337,0 c 0,-5.97691 0,-11.95381 1.49422,-14.94226 1.49423,-2.98845 4.48268,-2.98845 6.91658,-2.98845 2.4341,0 4.31346,0 6.19301,0 2.60312,0 5.20644,0 6.50791,2.98845 1.30165,2.98845 1.30165,8.96535 1.30165,14.94226 z M 87.781795,843.05114 c 2.920462,0 5.288062,3.01049 5.288062,6.72401 0,3.71352 -2.3676,6.72401 -5.288062,6.72401 -2.92065,0 -5.288249,-3.01049 -5.288249,-6.72401 0,-3.71352 2.367599,-6.72401 5.288249,-6.72401 z m 11.171572,32.21923 -22.413373,0 c 0,-5.97691 0,-11.95381 1.494225,-14.94226 1.494225,-2.98845 4.482674,-2.98845 6.91658,-2.98845 2.434092,0 4.313454,0 6.193002,0 2.603126,0 5.20644,0 6.50791,2.98845 1.301656,2.98845 1.301656,8.96535 1.301656,14.94226 z m 20.869203,-32.21924 c 2.92046,0 5.28806,3.01049 5.28806,6.72401 0,3.71352 -2.3676,6.72401 -5.28806,6.72401 -2.92065,0 -5.28825,-3.01049 -5.28825,-6.72401 0,-3.71352 2.3676,-6.72401 5.28825,-6.72401 z m 11.17157,32.21923 -22.41337,0 c 0,-5.97691 0,-11.95381 1.49422,-14.94226 1.49423,-2.98845 4.48268,-2.98845 6.91658,-2.98845 2.4341,0 4.31346,0 6.19301,0 2.60312,0 5.20644,0 6.50791,2.98845 1.30165,2.98845 1.30165,8.96535 1.30165,14.94226 z M 66.249157,842.77492 c 2.920462,0 5.288062,3.01049 5.288062,6.72401 0,3.71352 -2.3676,6.72401 -5.288062,6.72401 -2.92065,0 -5.288249,-3.01049 -5.288249,-6.72401 0,-3.71352 2.367599,-6.72401 5.288249,-6.72401 z m 11.171572,32.21923 -22.413373,0 c 0,-5.97691 0,-11.95381 1.494225,-14.94226 1.494225,-2.98845 4.482674,-2.98845 6.91658,-2.98845 2.434092,0 4.313454,0 6.193002,0 2.603126,0 5.20644,0 6.50791,2.98845 1.301656,2.98845 1.301656,8.96535 1.301656,14.94226 z'/>";
        var broadcastpath = "<path style='fill:fgcolor;fill-opacity:desiredopacity;fill-rule:nonzero;stroke:none' d='m 158.25,47.375 c -2.92046,0 -5.28125,3.00523 -5.28125,6.71875 0,3.71352 2.36079,6.75 5.28125,6.75 2.92065,0 5.28125,-3.03648 5.28125,-6.75 0,-3.71352 -2.3606,-6.71875 -5.28125,-6.71875 z m -45.5625,0.28125 c -2.92046,0 -5.3125,3.00523 -5.3125,6.71875 0,3.71352 2.39204,6.71875 5.3125,6.71875 2.92065,0 5.28125,-3.00523 5.28125,-6.71875 0,-3.71352 -2.3606,-6.71875 -5.28125,-6.71875 z m 24.03125,0 c -2.92046,0 -5.28125,3.00523 -5.28125,6.71875 0,3.71352 2.36079,6.71875 5.28125,6.71875 2.92065,0 5.28125,-3.00523 5.28125,-6.71875 0,-3.71352 -2.3606,-6.71875 -5.28125,-6.71875 z m -74.4375,0.28125 c -2.92046,0 -5.3125,3.00523 -5.3125,6.71875 0,3.71352 2.39204,6.71875 5.3125,6.71875 2.92065,0 5.28125,-3.00523 5.28125,-6.71875 0,-3.71352 -2.3606,-6.71875 -5.28125,-6.71875 z m 34.932585,-5.692657 -10.799454,9.091808 -11.274272,0 0.276214,10.50813 3.443568,-0.276213 2.762136,9.509162 3.875,0 -1.933496,-8.847876 13.650304,10.65534 z M 154.875,61.6875 c -2.60312,0 -5.19853,-0.0197 -6.5,2.96875 -0.4408,1.012029 -0.71345,2.387341 -0.90625,3.96875 -0.22102,-1.459898 -0.52452,-2.736531 -1,-3.6875 -1.49423,-2.98845 -4.5036,-3 -6.9375,-3 l -6.1875,0 c -2.60312,0 -5.19853,0.01155 -6.5,3 -1.30165,2.98845 -1.3125,8.96059 -1.3125,14.9375 l 22.4375,0 c 0,-0.0947 1e-5,-0.186562 0,-0.28125 l 21.53125,0 c 0,-5.97691 -0.006,-11.94905 -1.5,-14.9375 -1.49422,-2.98845 -4.50359,-2.96875 -6.9375,-2.96875 z m -45.5625,0.25 c -2.60312,0 -5.19853,0.01155 -6.5,3 -1.30165,2.98845 -1.3125,8.96059 -1.3125,14.9375 l 22.40625,0 c 0,-5.97691 -0.006,-11.94905 -1.5,-14.9375 -1.49423,-2.98845 -4.47235,-3 -6.90625,-3 z m -50.40625,0.28125 c -2.60312,0 -5.19853,0.01155 -6.5,3 -1.30165,2.98845 -1.3125,8.96059 -1.3125,14.9375 l 22.40625,0 c 0,-5.97691 0.02547,-11.94905 -1.46875,-14.9375 -1.49423,-2.98845 -4.5036,-3 -6.9375,-3 z' transform='translate(-0.0892384, 795.39085)'/>";
        var codekingdomsLogo = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:cc="http://creativecommons.org/ns#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd" xmlns:svg="http://www.w3.org/2000/svg" width="107" height="107.00001" viewBox="0 0 107 107.00001" id="svg4207" version="1.1" inkscape:version="0.91 r13725" sodipodi:docname="Microbit CK Logo.svg"><defs id="defs4209" /><sodipodi:namedview id="base" pagecolor="#ffffff" bordercolor="#666666" borderopacity="1.0" inkscape:pageopacity="0.0" inkscape:pageshadow="2" inkscape:zoom="2.8" inkscape:cx="11.591697" inkscape:cy="15.87942" inkscape:document-units="px" inkscape:current-layer="layer1" showgrid="false" units="px" fit-margin-top="0" fit-margin-left="0" fit-margin-right="0" fit-margin-bottom="0" inkscape:window-width="1680" inkscape:window-height="1001" inkscape:window-x="0" inkscape:window-y="23" inkscape:window-maximized="1" /><metadata id="metadata4212"><rdf:RDF><cc:Work rdf:about=""><dc:format>image/svg+xml</dc:format><dc:type rdf:resource="http://purl.org/dc/dcmitype/StillImage" /><dc:title /></cc:Work></rdf:RDF></metadata><g inkscape:label="Layer 1" inkscape:groupmode="layer" id="layer1" transform="translate(-154.28575,-805.36218)"><rect style="opacity:1;fill:#333333;fill-opacity:1;stroke:none;stroke-width:0.07577424;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1" id="rect11957" width="107" height="107.00001" x="154.28575" y="805.36218" /><path id="path12604" d="m 167.13201,841.77337 c -1.09811,-1.17115 -2.4386,-1.31504 -3.58068,-0.38517 -1.17442,0.95712 -1.33105,2.37283 -0.40153,3.63846 0.88264,1.18679 2.51601,1.3543 3.70096,0.403 0.94441,-0.75837 1.39754,-2.56616 0.28125,-3.65629 z" inkscape:connector-curvature="0" style="clip-rule:evenodd;fill:#f48023;fill-opacity:1;fill-rule:evenodd" /><path id="path12606" d="m 195.32515,827.53564 c -1.12791,-1.23947 -2.4782,-1.42079 -3.63883,-0.48983 -1.22347,0.9822 -1.37501,2.38192 -0.40117,3.70206 0.73075,1.07667 2.47422,1.33902 3.64757,0.379 1.10392,-0.903 1.28634,-2.46333 0.39243,-3.59123 z" inkscape:connector-curvature="0" style="clip-rule:evenodd;fill:#f48023;fill-opacity:1;fill-rule:evenodd" /><path id="path12608" d="m 183.0551,829.91611 c 0.99746,1.22384 2.68969,1.43169 3.94151,0.48437 1.21948,-0.9237 1.49237,-2.59558 0.62936,-3.85903 -1.10211,-1.45642 -2.70132,-1.75474 -4.04072,-0.75437 -1.41207,1.05487 -1.61447,2.62901 -0.53015,4.12903 z" inkscape:connector-curvature="0" style="clip-rule:evenodd;fill:#f48023;fill-opacity:1;fill-rule:evenodd" /><path id="path12610" d="m 167.42926,837.87472 c 0.94478,1.29253 2.74166,1.52873 4.01311,0.52726 1.27218,-1.00218 1.48474,-2.81214 0.4713,-4.01819 -1.18461,-1.32995 -2.68316,-1.53163 -3.96696,-0.53344 -1.32668,1.03126 -1.52654,2.58469 -0.51745,4.02437 z" inkscape:connector-curvature="0" style="clip-rule:evenodd;fill:#f48023;fill-opacity:1;fill-rule:evenodd" /><path id="path12612" d="m 179.04562,827.68135 c -1.49566,-1.52327 -3.32561,-1.73402 -4.84378,-0.5556 -1.47712,1.14681 -2.04907,3.1628 -0.79506,4.93099 0.80704,1.19841 2.18496,1.77763 3.64028,1.46803 1.35321,-0.28779 2.3056,-1.09339 2.70931,-2.43024 0.37646,-1.24493 0.24346,-2.42481 -0.71075,-3.41318 z" inkscape:connector-curvature="0" style="clip-rule:evenodd;fill:#f48023;fill-opacity:1;fill-rule:evenodd" /><path id="path12614" d="m 181.91736,845.16983 c -0.2013,-0.12973 -0.40987,-0.25 -0.60248,-0.39135 -2.67261,-1.96295 -5.34196,-3.93025 -8.01676,-5.88993 -0.16243,-0.11919 -0.34157,-0.41897 -0.53706,-0.2511 -0.27145,0.23402 0.0839,0.42151 0.19804,0.58649 1.83212,2.64609 3.68061,5.28128 5.52038,7.92192 0.1319,0.18933 0.32268,0.35031 0.35174,0.61483 -0.3194,0.0665 -0.5694,-0.11592 -0.83285,-0.20966 -2.91244,-1.03888 -5.81981,-2.09085 -8.73189,-3.12938 -0.17115,-0.0611 -0.38409,-0.29361 -0.55487,-0.002 -0.15153,0.25799 -0.1388,0.49782 0.14135,0.68605 0.13917,0.0934 0.25473,0.22202 0.38264,0.33322 2.37755,2.06397 4.75693,4.12539 7.13049,6.19371 0.29071,0.25328 0.57594,0.52145 0.82123,0.8176 1.1577,1.39898 2.36956,2.76127 3.42298,4.23585 0.64426,0.90154 1.42443,1.09448 2.41172,1.06179 2.50184,-0.0833 4.72641,-0.96731 6.74896,-2.36957 3.17226,-2.19987 5.54146,-5.01748 6.59923,-8.81619 0.23693,-0.85176 0.25365,-1.59776 -0.26562,-2.39536 -0.75073,-1.1519 -1.35175,-2.40082 -2.05343,-3.58688 -0.32012,-0.54033 -0.44877,-1.09885 -0.48874,-1.71622 -0.12209,-1.88482 -0.29215,-3.76564 -0.41606,-5.65011 -0.0225,-0.3423 -0.15625,-0.41242 -0.45676,-0.49201 -0.39063,-0.10356 -0.45495,0.1152 -0.54325,0.37246 -0.30632,0.89099 -0.60938,1.78309 -0.92043,2.67227 -0.43895,1.25363 -0.88409,2.50582 -1.36919,3.87829 -1.18679,-2.51238 -2.31396,-4.89102 -3.42989,-7.27477 -0.13772,-0.2936 -0.26309,-0.45348 -0.64426,-0.37645 -0.41316,0.0833 -0.32668,0.33576 -0.31505,0.59121 0.1439,3.04835 0.28998,6.09597 0.42733,9.14432 0.007,0.17151 0.13409,0.37972 -0.0999,0.5407 -0.14208,-0.16678 -0.28452,-0.32776 -0.41897,-0.49491 -1.98875,-2.47094 -3.99312,-4.92918 -5.94845,-7.42665 -0.37173,-0.47529 -0.61845,-0.37645 -1.06249,-0.1726 -0.57704,0.26526 -0.24093,0.58648 -0.13118,0.87718 1.26019,3.34487 2.53272,6.68537 3.80162,10.02731 -0.04,0.0298 -0.0793,0.06 -0.1181,0.0902 z" inkscape:connector-curvature="0" style="clip-rule:evenodd;fill:#ffce3c;fill-opacity:1;fill-rule:evenodd" /><path id="path12616" d="m 200.39423,846.01541 c -0.84885,-0.28853 -1.70641,-0.12065 -2.56216,-0.0476 -0.28452,0.0244 -0.30159,0.23982 -0.34919,0.46511 -1.31942,6.26385 -8.51278,12.69703 -15.10476,12.36418 -0.29942,-0.0148 -0.44877,0.0829 -0.50618,0.36701 -0.27581,1.37174 -0.52726,2.74494 -0.29506,4.15228 0.0723,0.86665 0.10247,1.73912 0.22348,2.59885 0.75618,5.37612 3.38592,9.45937 8.37033,11.82385 3.47786,1.65008 7.18608,2.02399 10.97863,1.65262 1.24891,-0.12208 2.48185,-0.38264 3.63448,-0.93459 0.3928,-0.18824 0.58539,-0.4237 0.5923,-0.88046 0.0134,-0.91825 0.0556,-1.83941 0.14606,-2.75293 0.0683,-0.68604 -0.11264,-0.78452 -0.77762,-0.60683 -5.01601,1.34195 -9.4539,-1.55197 -10.10726,-6.55201 -0.55704,-4.26237 1.96804,-7.86051 6.12759,-8.63959 1.70132,-0.31868 3.42625,-0.23438 5.12212,0.10756 0.54616,0.1101 0.62428,-0.0284 0.6232,-0.54106 -0.006,-2.5429 -0.16098,-5.07926 -0.33613,-7.61343 -0.0814,-1.17878 -0.25508,-2.35139 -0.53052,-3.5091 -0.12973,-0.54688 -0.4168,-0.79652 -0.94187,-0.93278 -1.41499,-0.36775 -2.85503,-0.48438 -4.30744,-0.52108 z" inkscape:connector-curvature="0" style="clip-rule:evenodd;fill:#33c5f3;fill-opacity:1;fill-rule:evenodd" /><path id="path12618" d="m 217.44994,846.74471 c -1.87102,0.0938 -3.90847,0.0167 -5.93282,0.27688 -0.37427,0.0484 -0.55815,0.14645 -0.54361,0.57123 0.0469,1.37937 0.0163,2.76237 0.0891,4.14029 0.35901,6.7951 0.7322,13.58947 1.12246,20.38275 0.12537,2.17371 0.21658,4.35251 0.55633,6.5095 0.0755,0.48001 0.27181,0.67842 0.79761,0.70131 3.17298,0.13771 6.34379,0.0683 9.51606,-0.0109 0.72165,-0.0181 0.94113,-0.23475 0.8899,-0.97531 -0.1886,-2.7322 -0.15371,-5.46987 -0.13228,-8.20716 0.006,-0.58686 0.36338,-0.5756 0.72531,-0.66608 0.37681,-0.0941 0.66897,-0.11919 0.85392,0.36229 0.35466,0.92333 0.80088,1.81069 1.18242,2.72459 1.00582,2.40916 1.87974,4.86593 2.63447,7.36559 0.0738,0.24492 0.0622,0.56832 0.51418,0.55306 3.12065,-0.10574 6.24422,-0.15335 9.31001,-0.8612 0.58249,-0.13445 0.74347,-0.31323 0.53743,-0.97057 -1.6301,-5.20861 -3.88084,-10.14868 -6.39212,-14.97721 -0.2649,-0.50945 -0.23582,-0.84048 0.11846,-1.28307 3.38447,-4.22569 5.66719,-9.02912 7.35979,-14.13927 0.129,-0.3899 0.16278,-0.55922 -0.35575,-0.65626 -3.0102,-0.56286 -6.05599,-0.68313 -9.1018,-0.84047 -0.5189,-0.0269 -0.74129,0.12354 -0.899,0.63517 -1.38191,4.48514 -3.22312,8.7962 -5.03782,13.11673 -0.0719,0.17115 -0.0876,0.39099 -0.30996,0.45276 -0.58139,0.16098 -1.19222,-0.26272 -1.23437,-0.87319 -0.2947,-4.2533 -0.48911,-8.50986 -0.4019,-12.77442 0.01,-0.45495 -0.0985,-0.57304 -0.54724,-0.56651 -1.71912,0.0244 -3.43898,0.01 -5.31871,0.01 z" inkscape:connector-curvature="0" style="clip-rule:evenodd;fill:#ffce3c;fill-opacity:1;fill-rule:evenodd" /></g></svg>';
        var pythonLogo = '<svg viewBox="0 0 90 90" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:cc="http://creativecommons.org/ns#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd" xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape" width="78" height="77.593796" id="svg2169" sodipodi:version="0.32" inkscape:version="0.48.5 r10040" version="1.0" sodipodi:docname="python-logo1.svg" inkscape:output_extension="org.inkscape.output.svg.inkscape"> <defs id="defs2171"> <linearGradient id="linearGradient11301" inkscape:collect="always"> <stop id="stop11303" offset="0" style="stop-color:#ffe052;stop-opacity:1" /> <stop id="stop11305" offset="1" style="stop-color:#ffc331;stop-opacity:1" /> </linearGradient> <linearGradient gradientUnits="userSpaceOnUse" y2="168.1012" x2="147.77737" y1="111.92053" x1="89.136749" id="linearGradient11307" xlink:href="#linearGradient11301" inkscape:collect="always" /> <linearGradient id="linearGradient9515" inkscape:collect="always"> <stop id="stop9517" offset="0" style="stop-color:#387eb8;stop-opacity:1" /> <stop id="stop9519" offset="1" style="stop-color:#366994;stop-opacity:1" /> </linearGradient> <linearGradient gradientUnits="userSpaceOnUse" y2="131.85291" x2="110.14919" y1="77.070274" x1="55.549179" id="linearGradient9521" xlink:href="#linearGradient9515" inkscape:collect="always" /> </defs> <sodipodi:namedview id="base" pagecolor="#ffffff" bordercolor="#666666" borderopacity="1.0" inkscape:pageopacity="0.0" inkscape:pageshadow="2" inkscape:zoom="1" inkscape:cx="9.3947058" inkscape:cy="72.439766" inkscape:document-units="px" inkscape:current-layer="layer1" width="131.10236px" height="184.25197px" inkscape:window-width="872" inkscape:window-height="624" inkscape:window-x="82" inkscape:window-y="82" showgrid="false" fit-margin-top="0" fit-margin-left="0" fit-margin-right="0" fit-margin-bottom="0" showborder="true" inkscape:showpageshadow="false" inkscape:window-maximized="0" /> <metadata id="metadata2174"> <rdf:RDF> <cc:Work rdf:about=""> <dc:format>image/svg+xml</dc:format> <dc:type rdf:resource="http://purl.org/dc/dcmitype/StillImage" /> </cc:Work> </rdf:RDF> </metadata> <g inkscape:label="Calque 1" inkscape:groupmode="layer" id="layer1" transform="translate(-489.57146,-267.85101)"> <g id="g1894" transform="matrix(0.70638641,0,0,0.70638641,457.82822,220.192)"> <path style="color:#000000;fill:url(#linearGradient9521);fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:1;marker:none;visibility:visible;display:inline;overflow:visible" d="M 99.75,67.46875 C 71.718268,67.468752 73.46875,79.625 73.46875,79.625 L 73.5,92.21875 l 26.75,0 0,3.78125 -37.375,0 c 0,0 -17.9375,-2.034276 -17.9375,26.25 -2e-6,28.28427 15.65625,27.28125 15.65625,27.28125 l 9.34375,0 0,-13.125 c 0,0 -0.503652,-15.65625 15.40625,-15.65625 15.9099,0 26.53125,0 26.53125,0 0,0 14.90625,0.24096 14.90625,-14.40625 0,-14.647206 0,-24.21875 0,-24.21875 0,-2e-6 2.26318,-14.65625 -27.03125,-14.65625 z M 85,75.9375 c 2.661429,-2e-6 4.8125,2.151071 4.8125,4.8125 2e-6,2.661429 -2.151071,4.8125 -4.8125,4.8125 -2.661429,2e-6 -4.8125,-2.151071 -4.8125,-4.8125 -2e-6,-2.661429 2.151071,-4.8125 4.8125,-4.8125 z" id="path8615" inkscape:connector-curvature="0" /> <path id="path8620" d="m 100.5461,177.31485 c 28.03174,0 26.28125,-12.15625 26.28125,-12.15625 l -0.0312,-12.59375 -26.75,0 0,-3.78125 37.375,0 c 0,0 17.9375,2.03427 17.9375,-26.25001 10e-6,-28.284267 -15.65625,-27.281247 -15.65625,-27.281247 l -9.34375,0 0,13.124997 c 0,0 0.50366,15.65625 -15.40625,15.65625 -15.909902,0 -26.531252,0 -26.531252,0 0,0 -14.90625,-0.24096 -14.90625,14.40626 0,14.6472 0,24.21875 0,24.21875 0,0 -2.26318,14.65625 27.031252,14.65625 z m 14.75,-8.46875 c -2.66143,0 -4.8125,-2.15107 -4.8125,-4.8125 0,-2.66143 2.15107,-4.8125 4.8125,-4.8125 2.66143,0 4.8125,2.15107 4.8125,4.8125 1e-5,2.66143 -2.15107,4.8125 -4.8125,4.8125 z" style="color:#000000;fill:url(#linearGradient11307);fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:1;marker:none;visibility:visible;display:inline;overflow:visible" inkscape:connector-curvature="0" /> </g> </g> </svg>';
        function getIconSVG(name, alt) {
            var title = alt || name.split(',')[0];
            var d = TDev.div(null);
            d.innerHTML = getIconSVGCore(name);
            var svg = d.firstChild;
            TDev.HTML.setRole(svg, "img");
            svg.setAttribute("aria-label", title);
            var tt = document.createElementNS("http://www.w3.org/2000/svg", 'title');
            tt.textContent = title;
            svg.insertBefore(tt, svg.firstElementChild);
            return svg;
        }
        SVG.getIconSVG = getIconSVG;
        function getIconNames() {
            return Object.keys(icons).concat(Object.keys(gelIcons).map(function (i) { return "gel-" + i; })).concat(Object.keys(fontAwesomeIconsByDaveGandy).map(function (i) { return "fa-" + i; }));
        }
        SVG.getIconNames = getIconNames;
        function getAllIcons() {
            var r = "";
            getIconNames().forEach(function (i) {
                var s = getIconSVGCore(i + ",currentColor");
                s = s.replace(/^<svg /, "<svg style='width:100%;height:100%' ");
                s = "<div style='margin:1em;display:inline-block;width:3em;height:3em;'>" + s + "<div style='font-size:0.6em;text-align:center'>" + i + "</div></div>";
                r += s;
            });
            return r;
        }
        SVG.getAllIcons = getAllIcons;
        function getIconSVGUrl(name) {
            return "data:image/svg+xml," + escape(getIconSVGCore(name));
        }
        SVG.getIconSVGUrl = getIconSVGUrl;
        function getVideoPlay(bg, alt) {
            if (alt === void 0) { alt = ""; }
            return TDev.Util.fmt("<img src='{0:url}' alt='{1:q}' />", bg, alt || "") + videoPlay;
        }
        SVG.getVideoPlay = getVideoPlay;
        function getIconSVGCore(name) {
            var toks = name.split(/,/);
            var h = 480;
            name = toks[0];
            var fill = toks[1];
            var viewDiff = 0;
            var opacity = 1;
            toks.forEach(function (s) {
                if (/clip=/.test(s)) {
                    viewDiff = s.slice(5) * 1;
                }
                if (/opacity=/.test(s)) {
                    opacity = s.slice(8) * 1;
                }
                if (/h=/.test(s)) {
                    h = s.slice(2) * 1;
                }
            });
            var lname = name.toLowerCase();
            if (lname == "codekingdoms")
                return codekingdomsLogo;
            if (lname == "python")
                return pythonLogo;
            if (iconMapping.hasOwnProperty(lname))
                lname = iconMapping[lname];
            var ic = icons[lname];
            var fa = false;
            var gel = false;
            if (!ic) {
                ic = fontAwesomeIconsByDaveGandy[lname.replace(/^fa-/, "")];
                if (ic)
                    fa = true;
            }
            if (!ic && /^gel-/.test(lname)) {
                ic = gelIcons[lname.replace(/^gel-/, "")];
                if (ic) {
                    gel = true;
                }
            }
            if (!ic) {
                TDev.Util.log("SCRIPTICON: " + name);
                ic = icons["cancel"];
            }
            var viewPort = viewDiff + " " + viewDiff + " " + (480 - 2 * viewDiff) + " " + (h - 2 * viewDiff);
            var style = "";
            if (opacity != 1)
                style = " style='fill-opacity:" + opacity + "' ";
            if (fa)
                style += " transform='scale(0.13,-0.13) translate(1000,-2500)' ";
            if (gel)
                style += " transform='scale(7.5,7.5)' ";
            var svg = svgBoilerPlate(viewPort, "<path fill='" + fill + "' " + style + " d='" + ic + "' />", name);
            return svg;
        }
        SVG.getIconSVGCore = getIconSVGCore;
        function drawSVG(ctx, name) {
            var path = icons[name.toLowerCase()] || (scriptIcons ? scriptIcons[name.toLowerCase()] : null);
            if (path == null)
                return;
            path = path.replace(/,/g, " ");
            path = path.replace(/([0-9])([A-Z])/g, (function (str, n, l) { return n + " " + l; }));
            var words = path.split(/ +/);
            var implicitCmd = "";
            var w = function (n) { return parseFloat(words[n]); };
            for (var i = 0; i < words.length;) {
                var cmd = words[i];
                if (/^[A-Za-z]$/.test(cmd))
                    i++;
                else
                    cmd = implicitCmd;
                switch (cmd) {
                    case "M":
                        ctx.moveTo(w(i + 0), w(i + 1));
                        i += 2;
                        implicitCmd = "L";
                        break;
                    case "C":
                        ctx.bezierCurveTo(w(i + 0), w(i + 1), w(i + 2), w(i + 3), w(i + 4), w(i + 5));
                        i += 6;
                        implicitCmd = "C";
                        break;
                    case "L":
                        ctx.lineTo(w(i + 0), w(i + 1));
                        i += 2;
                        implicitCmd = "L";
                        break;
                    case "Z":
                        ctx.closePath();
                        break;
                    default:
                        i++;
                        break;
                }
            }
            ctx.fill();
        }
        SVG.drawSVG = drawSVG;
        function svgToElement(svg) {
            var d = TDev.div(null);
            d.innerHTML = svg;
            return d.firstChild;
        }
        SVG.svgToElement = svgToElement;
        function codeSignHtml(name) {
            return codeSigns[name];
        }
        SVG.codeSignHtml = codeSignHtml;
        function getHorizLogo() {
            return svgToElement(tdLogoHoriz);
        }
        SVG.getHorizLogo = getHorizLogo;
        function getTopLogo() {
            return svgToElement(tdLogo);
        }
        SVG.getTopLogo = getTopLogo;
        function getLoginButton() {
            return svgToElement(loginButton);
        }
        SVG.getLoginButton = getLoginButton;
        function getHorizontalCursorMarker() {
            return svgToElement(horizontalMarker);
        }
        SVG.getHorizontalCursorMarker = getHorizontalCursorMarker;
        function getVerticalCursorMarker() {
            return svgToElement(verticalMarker);
        }
        SVG.getVerticalCursorMarker = getVerticalCursorMarker;
        function getCloudSymbol(color, type, connected, height_in_em) {
            var opacity = connected ? "1" : "0.3";
            var extrapath = (type == "public" ? peoplepath : (type == "broadcast" ? broadcastpath : ""));
            var svg = svgToElement(svgBoilerPlate('0 795 227 82', cloudpath.replace(/fgcolor/, color).replace(/desiredopacity/, opacity) + (extrapath ? extrapath.replace(/fgcolor/, color).replace(/desiredopacity/, opacity) : "")));
            if (height_in_em) {
                svg.style.height = height_in_em.toString() + "em";
                svg.style.width = (height_in_em * 2.77).toString() + "em";
            }
            return svg;
        }
        SVG.getCloudSymbol = getCloudSymbol;
        function justName(s) {
            return s ? s.replace(/^svg:/, "").replace(/,.*/, "") : null;
        }
        SVG.justName = justName;
    })(SVG = TDev.SVG || (TDev.SVG = {}));
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var CallNode = (function () {
        function CallNode(id, action) {
            this.id = id;
            this.action = action;
        }
        return CallNode;
    })();
    TDev.CallNode = CallNode;
    var PackedStackTrace = (function () {
        function PackedStackTrace() {
            this.pack = [];
            this.path = [];
        }
        PackedStackTrace.buildFrom = function (st) {
            var ret = new PackedStackTrace();
            var pack = [];
            var actions = [];
            st.forEach(function (sf) {
                var ix = pack.indexOf(sf.pc);
                if (ix === -1) {
                    ix = pack.push(sf.pc) - 1;
                    actions.push(sf.name);
                }
                ret.path.push(ix);
            });
            pack.forEach(function (x, i) { return ret.pack.push(new CallNode(x, actions[i])); });
            return ret;
        };
        PackedStackTrace.toFakeStackTrace = function (st) {
            if (!st)
                return [];
            var fakePack = st.pack.map(function (cnode) {
                return { pc: cnode.id, name: cnode.action };
            });
            return st.path.map(function (ix) { return fakePack[ix]; });
        };
        return PackedStackTrace;
    })();
    TDev.PackedStackTrace = PackedStackTrace;
    var RunBitMap = (function () {
        function RunBitMap() {
            this.empty = true;
            this.data = {};
        }
        RunBitMap.prototype.push = function (id) {
            this.data[id] = true;
            this.empty = false;
        };
        RunBitMap.prototype.contains = function (id) {
            return !!this.data[id];
        };
        RunBitMap.prototype.toJSON = function () {
            return Object.keys(this.data);
        };
        RunBitMap.prototype.isEmpty = function () {
            return this.empty;
        };
        RunBitMap.prototype.clear = function () {
            this.empty = true;
            this.data = {};
        };
        RunBitMap.fromJSON = function (json) {
            if (json == null)
                return null;
            if (json instanceof Array) {
                var ret = new RunBitMap();
                json.forEach(function (e) {
                    if (e != undefined) {
                        ret.push(e);
                    }
                });
                return ret;
            }
            return undefined;
        };
        return RunBitMap;
    })();
    TDev.RunBitMap = RunBitMap;
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    TDev.debuggerExceptions = false;
    TDev.forceLocalStorage = false;
    TDev.withTracing = false;
    TDev.asyncEnabled = true;
    TDev.isWebWorker = false;
    TDev.noHub = false;
    TDev.hubHash = "hub";
    function enumToString(enumType, theEnum) {
        var ret = enumType[theEnum];
        if (!ret)
            throw new Error("Cannot convert enum to string: " + theEnum);
        return ret;
    }
    TDev.enumToString = enumToString;
    function nullify(v) {
        return (v == null) ? null : v;
    }
    TDev.nullify = nullify;
    function coalesce(v) {
        return function (f) {
            if (f && (v != null))
                return coalesce(f(v));
            else if (!f)
                return v;
            else
                return coalesce(null);
        };
    }
    TDev.coalesce = coalesce;
    function tweetify(text) {
        if (!text)
            return text;
        if (text.length > 140)
            return text.substr(0, 140) + '...';
        return text;
    }
    TDev.tweetify = tweetify;
    function elt(name) {
        return document.getElementById(name);
    }
    TDev.elt = elt;
    function span(cl, kw) {
        return createElement("span", cl, kw);
    }
    TDev.span = span;
    function show(v) {
        if (v instanceof TDev.Promise)
            v.done(show);
        else
            console.log(v);
    }
    TDev.show = show;
    function createElement(tag, cl, kw) {
        if (cl === void 0) { cl = null; }
        if (kw === void 0) { kw = null; }
        var elt = document.createElement(tag);
        if (cl)
            elt.className = cl;
        if (typeof kw === "string")
            elt.appendChild(document.createTextNode(kw));
        else
            elt.appendChildren(kw);
        return elt;
    }
    TDev.createElement = createElement;
    function text(s) {
        return document.createTextNode(s);
    }
    TDev.text = text;
    function lzmaDecompressAsync(buf) {
        var lzma = window.LZMA;
        if (!lzma)
            return TDev.Promise.as(undefined);
        return new TDev.Promise(function (onSuccess, onError, onProgress) {
            try {
                lzma.decompress(buf, function (res, error) {
                    onSuccess(error ? undefined : res);
                });
            }
            catch (e) {
                onSuccess(undefined);
            }
        });
    }
    TDev.lzmaDecompressAsync = lzmaDecompressAsync;
    function lzmaCompressAsync(text) {
        var lzma = window.LZMA;
        if (!lzma)
            return TDev.Promise.as(undefined);
        return new TDev.Promise(function (onSuccess, onError, onProgress) {
            try {
                lzma.compress(text, 7, function (res, error) {
                    onSuccess(error ? undefined : new Uint8Array(res));
                });
            }
            catch (e) {
                onSuccess(undefined);
            }
        });
    }
    TDev.lzmaCompressAsync = lzmaCompressAsync;
    function img(cl, src, alt) {
        var elt = document.createElement("img");
        if (cl)
            elt.className = cl;
        elt.src = src;
        elt.alt = alt;
        return elt;
    }
    TDev.img = img;
    function spanDirAuto(txt) {
        return dirAuto(span('', txt));
    }
    TDev.spanDirAuto = spanDirAuto;
    function dirAuto(el) {
        if (el) {
            if (TDev.Browser.directionAuto)
                el.setAttribute('dir', 'auto');
            else {
                var t = el.innerText;
                var dir = /^[\s\.;:(+0-9]*[\u0591-\u07FF\uFB1D-\uFDFD\uFE70-\uFEFC]/i.test(t) ? "rtl" : "ltr";
                el.setAttribute('dir', dir);
            }
        }
        return el;
    }
    TDev.dirAuto = dirAuto;
    function div(cl) {
        var children = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            children[_i - 1] = arguments[_i];
        }
        var tag = "div";
        if (cl == "wall-dialog-header" || cl == "modalSearchHeader")
            tag = "h1";
        var elt = document.createElement(tag);
        if (cl)
            elt.className = cl;
        elt.tabIndex = -1;
        elt.appendChildren(children.filter(function (e) { return e != undefined; }));
        if (cl == "sdLoadingMore")
            elt.setAttribute("aria-live", "polite");
        return elt;
    }
    TDev.div = div;
    function divId(id, cls) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        var d = div(cls, args);
        d.id = id;
        return d;
    }
    TDev.divId = divId;
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var Debug;
    (function (Debug) {
        function whenSet(f) {
            f();
        }
        Debug.whenSet = whenSet;
    })(Debug = TDev.Debug || (TDev.Debug = {}));
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var HttpLog;
    (function (HttpLog) {
        HttpLog.enabled = false;
        var theLog = [];
        var startTime = 0;
        function log(req) {
            req.timestamp = Date.now();
            if (/^[\{\[]/.test(req.contentText)) {
                req.contentJson = JSON.parse(req.contentText);
                delete req.contentText;
            }
            req.method = req.method.toUpperCase();
            if (Util.startsWith(req.url, TDev.Cloud.getServiceUrl())) {
                req.url = req.url.slice(TDev.Cloud.getServiceUrl().length).replace(/.access_token=.*/, "");
            }
            if (!startTime)
                startTime = req.timestamp;
            req.relativeTime = req.timestamp - startTime;
            theLog.push(Util.jsonClone(req));
        }
        HttpLog.log = log;
        function show() {
            theLog.forEach(function (e) { return console.log(e); });
            return theLog;
        }
        HttpLog.show = show;
    })(HttpLog = TDev.HttpLog || (TDev.HttpLog = {}));
    var Util;
    (function (Util) {
        Util.eventLogging = false;
        Util.mouseLogging = false;
        function splitKeyValues(text, sep, valSep) {
            if (sep === void 0) { sep = ','; }
            if (valSep === void 0) { valSep = '='; }
            var result = {};
            if (text)
                text.split(sep).forEach(function (x) {
                    var arr = x.split(valSep);
                    if (arr[1])
                        result[arr[0]] = arr[1];
                });
            return result;
        }
        Util.splitKeyValues = splitKeyValues;
        function hasCJKChars(s) {
            var b = /[\u3000-\u303f\u3040-\u309f\u30a0-\u30ff\uff00-\uff9f\u4e00-\u9faf\u3400-\u4dbf\u3130-\u318F\uAC00-\uD7AF]/.test(s);
            return b;
        }
        Util.hasCJKChars = hasCJKChars;
        function wordLength(s) {
            var max = 0;
            s.split(/(\s+|-)/).forEach(function (w) { return max = Math.max(w.length, max); });
            return max;
        }
        Util.wordLength = wordLength;
        function isoTime(time) {
            var d = new Date(time * 1000);
            return Util.fmt("{0}-{1:f02.0}-{2:f02.0} {3:f02.0}:{4:f02.0}:{5:f02.0}", d.getFullYear(), d.getMonth() + 1, d.getDate(), d.getHours(), d.getMinutes(), d.getSeconds());
        }
        Util.isoTime = isoTime;
        function timeSince(time) {
            var now = Util.now();
            time *= 1000;
            var diff = (now - time) / 1000;
            if (isNaN(diff))
                return "";
            if (diff < -30) {
                diff = -diff;
                if (diff < 60)
                    return lf("in a few seconds");
                if (diff < 2 * 60)
                    return lf("in a minute");
                if (diff < 60 * 60)
                    return lf("in {0} minute{0:s}", Math.floor(diff / 60));
                if (diff < 2 * 60 * 60)
                    return lf("in an hour");
                if (diff < 60 * 60 * 24)
                    return lf("in {0} hour{0:s}", Math.floor(diff / 60 / 60));
                if (diff < 60 * 60 * 24 * 30)
                    return lf("in {0} day{0:s}", Math.floor(diff / 60 / 60 / 24));
                if (diff < 60 * 60 * 24 * 365)
                    return lf("in {0} month{0:s}", Math.floor(diff / 60 / 60 / 24 / 30));
                return lf("in {0} year{0:s}", Math.floor(diff / 60 / 60 / 24 / 365));
            }
            else {
                if (diff < 0)
                    return lf("now");
                if (diff < 10)
                    return lf("a few seconds ago");
                if (diff < 60)
                    return lf("{0} second{0:s} ago", Math.floor(diff));
                if (diff < 2 * 60)
                    return lf("a minute ago");
                if (diff < 60 * 60)
                    return lf("{0} minute{0:s} ago", Math.floor(diff / 60));
                if (diff < 2 * 60 * 60)
                    return lf("an hour ago");
                if (diff < 60 * 60 * 24)
                    return lf("{0} hour{0:s} ago", Math.floor(diff / 60 / 60));
                if (diff < 60 * 60 * 24 * 30)
                    return lf("{0} day{0:s} ago", Math.floor(diff / 60 / 60 / 24));
                if (diff < 60 * 60 * 24 * 365)
                    return lf("{0} month{0:s} ago", Math.floor(diff / 60 / 60 / 24 / 30));
                return lf("{0} year{0:s} ago", Math.floor(diff / 60 / 60 / 24 / 365));
            }
        }
        Util.timeSince = timeSince;
        function toAbsoluteUrl(url) {
            if (/^http(s)?:/i.test(url))
                return url;
            var a = document.createElement('a');
            a.href = url;
            return a.href;
        }
        Util.toAbsoluteUrl = toAbsoluteUrl;
        function trimAfter(s, searchString) {
            if (!s)
                return s;
            var index = s.indexOf(searchString, 0);
            if (index > -1)
                return s.substr(0, index + searchString.length);
            else
                return s;
        }
        Util.trimAfter = trimAfter;
        function translatedFirstSentence(desc) {
            desc = desc.replace(/{hints:[^}]+}/g, "");
            desc = desc.replace(/\n/g, " ");
            desc = desc.replace(/^\s+/, "");
            desc = desc.replace(/\s+$/, "");
            var d2 = lf_static(desc, !!Util.translationToken);
            var trimmed = firstSentence(d2);
            if (d2 == desc)
                return lf_static(trimmed, false);
            else
                return trimmed;
        }
        Util.translatedFirstSentence = translatedFirstSentence;
        function firstSentence(s) {
            return Util.trimAfter(s, ".");
        }
        Util.firstSentence = firstSentence;
        function httpGetJsonAsync(filename, contentTypeOrHeaders) {
            return httpGetTextAsync(filename, contentTypeOrHeaders).then(function (s) { return JSON.parse(s); });
        }
        Util.httpGetJsonAsync = httpGetJsonAsync;
        function forEachResponseHeader(client, action) {
            var headers = client.getAllResponseHeaders();
            if (headers) {
                headers = headers.replace(/^\s*/, '');
                headers.split('\r\n').forEach(function (line) {
                    var i = line.indexOf(': ');
                    if (i > 0)
                        action(line.substr(0, i), line.substr(i + 2));
                });
            }
        }
        Util.forEachResponseHeader = forEachResponseHeader;
        function decodeErrorMessage(errorMessage) {
            if (errorMessage)
                errorMessage = decodeURIComponent(errorMessage.replace(/[+]/g, " "));
            return errorMessage;
        }
        Util.decodeErrorMessage = decodeErrorMessage;
        function networkError(client, meth, filename) {
            var e = new Error(Util.fmt("cannot {0} '{1}'; status={2}", meth, filename, client.status));
            e.status = client.status;
            try {
                e.errorMessage = decodeErrorMessage(client.getResponseHeader("ErrorMessage"));
            }
            catch (e) {
            }
            if (e.errorMessage == undefined) {
                e.errorMessage = client.responseText;
            }
            if (client.status == 404 || client.status == 403 || client.status == 409 || client.status == 400) {
            }
            else {
                e.isNetworkError = 1;
            }
            return e;
        }
        function httpGetTextAsync(filename, contentTypeOrHeaders) {
            return Util.httpRequestAsync(toAbsoluteUrl(filename), "get", undefined, contentTypeOrHeaders);
        }
        Util.httpGetTextAsync = httpGetTextAsync;
        function httpPostRealJsonAsync(url, body) {
            return Util.httpRequestAsync(url, "POST", JSON.stringify(body), "application/json;charset=UTF-8").then(function (s) { return s ? JSON.parse(s) : {}; });
        }
        Util.httpPostRealJsonAsync = httpPostRealJsonAsync;
        function parseJsonWithHack(s) {
            if (!s)
                return {};
            try {
                return JSON.parse(s);
            }
            catch (e) {
                return JSON.parse(s.replace(/":NaN,"/g, '":0,"'));
            }
        }
        Util.parseJsonWithHack = parseJsonWithHack;
        function httpPostJsonAsync(url, body) {
            return Util.httpRequestAsync(url, "POST", JSON.stringify(body), TDev.Cloud.lite ? "application/json;charset=UTF-8" : "text/plain;charset=UTF-8").then(function (s) { return s ? parseJsonWithHack(s) : {}; });
        }
        Util.httpPostJsonAsync = httpPostJsonAsync;
        function httpPostTextAsync(url, body) {
            return Util.httpRequestAsync(url, "POST", body);
        }
        Util.httpPostTextAsync = httpPostTextAsync;
        function httpDeleteAsync(url) {
            return Util.httpRequestAsync(url, "DELETE");
        }
        Util.httpDeleteAsync = httpDeleteAsync;
        function authenticationOverride(client, url, headers) {
            if (!TDev.Cloud.lite)
                return url;
            var pref = TDev.Cloud.getServiceUrl() + "/api";
            if (!(url.slice(0, pref.length) == pref && /^[\/\?]/.test(url.slice(pref.length))))
                return url;
            client.withCredentials = true;
            var m = /([^\?]+)\?(.*)/.exec(url);
            var qs = "";
            if (m) {
                m[2].split(/&/).forEach(function (kv) {
                    var k = kv;
                    var v = "true";
                    var mm = /([^=]+)=(.*)/.exec(kv);
                    if (mm) {
                        k = mm[1];
                        v = decodeURIComponent(mm[2]);
                    }
                    k = decodeURIComponent(k);
                    switch (k) {
                        case "user_platform":
                            if (TDev.Cloud.isRestricted())
                                break;
                        case "world_id":
                        case "release_id":
                        case "access_token":
                            if (v)
                                headers["x-td-" + k.replace(/_/g, "-")] = v;
                            break;
                        case "anon_token":
                            if (v)
                                headers["authorization"] = v;
                            break;
                        default:
                            if (qs)
                                qs += "&";
                            else
                                qs += "?";
                            qs += kv;
                            break;
                    }
                });
                url = m[1] + qs;
            }
            return url;
        }
        Util.httpRequestAsync = function (url, method, body, contentTypeOrHeaders) {
            if (method === void 0) { method = "GET"; }
            if (body === void 0) { body = undefined; }
            if (contentTypeOrHeaders === void 0) { contentTypeOrHeaders = null; }
            if (TDev.Cloud.isOffline())
                return TDev.Cloud.offlineErrorAsync();
            return new TDev.Promise(function (onSuccess, onError, onProgress) {
                var client;
                var resolved = false;
                function innerSuccess() {
                    onSuccess(client.responseText);
                }
                function innerError() {
                    onError(networkError(client, method, url));
                }
                function ready() {
                    if (resolved)
                        return;
                    if (client.readyState == 4) {
                        resolved = true;
                        if (client.status == 200)
                            innerSuccess();
                        else
                            innerError();
                    }
                }
                var headers = contentTypeOrHeaders || {};
                if (typeof headers == "string")
                    headers = { "Content-Type": headers };
                if (HttpLog.enabled)
                    HttpLog.log({
                        url: url,
                        method: method,
                        contentText: body,
                        headers: Object.keys(headers).map(function (k) {
                            return { name: k, value: headers[k] };
                        })
                    });
                client = new XMLHttpRequest();
                if (TDev.Cloud.lite)
                    url = authenticationOverride(client, url, headers);
                client.onreadystatechange = ready;
                client.open(method, url);
                Object.keys(headers).forEach(function (k) {
                    client.setRequestHeader(k, headers[k]);
                });
                if (body === undefined)
                    client.send();
                else
                    client.send(body);
            });
        };
        function betaCheck(cond, msg) {
            if (msg === void 0) { msg = ""; }
            if (TDev.isBeta)
                check(cond, msg);
        }
        Util.betaCheck = betaCheck;
        function check(cond, msg) {
            if (msg === void 0) { msg = ""; }
            try {
                if (!cond)
                    throw Error("check failed: " + msg);
            }
            catch (e) {
                try {
                    reportError("check", e, false);
                }
                catch (e) {
                }
            }
            return cond;
        }
        Util.check = check;
        function assert(cond, msg) {
            if (msg === void 0) { msg = ""; }
            if (!cond)
                throw Error("assertion failed: " + msg);
        }
        Util.assert = assert;
        function assertCode(cond) {
            if (!cond) {
                var e = Error("assertion failed");
                e.includeSource = true;
                throw e;
            }
        }
        Util.assertCode = assertCode;
        function die() {
            throw Error("OOPS");
        }
        Util.die = die;
        function oops(msg, attachments) {
            if (attachments === void 0) { attachments = null; }
            var err = new Error("OOPS: " + msg);
            if (attachments)
                err.bugAttachments = attachments;
            throw err;
        }
        Util.oops = oops;
        function abstract() {
            oops("this method should have been overriden");
            return undefined;
        }
        Util.abstract = abstract;
        function initHtmlExtensions() {
            if (window.performance && window.performance.now)
                Util.perfNow = function () { return window.performance.now(); };
            else
                Util.perfNow = function () { return Date.now(); };
            TDev.Promise.errorHandler = Util.reportError;
            TDev.Promise.checkHandler = function (msg) { return Util.check(false, msg); };
            var pelt = Element.prototype;
            pelt.removeAllChildren = function () {
                while (this.hasChildNodes()) {
                    this.removeChild(this.firstChild);
                }
            };
            pelt.removeSelf = function () {
                if (!!this.parentNode)
                    this.parentNode.removeChild(this);
            };
            pelt.setFlag = function (name, v) {
                this.setAttribute("data-" + name, v ? "yes" : "no");
            };
            pelt.getFlag = function (name) {
                var s = this.getAttribute("data-" + name);
                if (!s || s == "no")
                    return false;
                else
                    return true;
            };
            pelt.appendChildren = function (children) {
                var th = this;
                if (!children)
                    return;
                if (Array.isArray(children))
                    for (var i = 0; i < children.length; ++i)
                        th.appendChildren(children[i]);
                else if (typeof children === "string")
                    th.appendChild(TDev.text(children));
                else
                    th.appendChild(children);
            };
            pelt.setChildren = function (children) {
                this.removeAllChildren();
                this.appendChildren(children);
            };
            pelt.setChildrenIfNeeded = function (children) {
                if (Array.isArray(children) && children.length == this.childNodes.length) {
                    var ok = true;
                    for (var i = 0; i < children.length; ++i) {
                        if (this.childNodes[i] !== children[i]) {
                            ok = false;
                            break;
                        }
                    }
                    if (ok)
                        return;
                }
                this.removeAllChildren();
                this.appendChildren(children);
            };
            pelt.setPosition = function (x, y, w, h) {
                var accentBox = this;
                accentBox.style.left = x + "px";
                accentBox.style.top = y + "px";
                if (w)
                    accentBox.style.width = w + "px";
                if (h)
                    accentBox.style.height = h + "px";
            };
            pelt.offsetPosition = function () {
                return {
                    top: this.offsetTop,
                    bot: this.offsetTop + this.offsetHeight,
                    left: this.offsetLeft,
                    right: this.offsetLeft + this.offsetWidth,
                    width: this.offsetWidth,
                    height: this.offsetHeight
                };
            };
            setupTimeoutZero();
            Error.stackTraceLimit = 64;
            TDev.Browser.setInnerHTML = function (el, html) {
                el.innerHTML = TDev.HTML.sanitizeHTML(html);
            };
        }
        Util.initHtmlExtensions = initHtmlExtensions;
        var zeroTimeoutFunctions;
        var zeroTimeoutName = "tdev-zero-timeout-message";
        function setZeroTimeout(cb) {
            zeroTimeoutFunctions.push(function () {
                if (Util.eventLogging)
                    Util.log("executing zero timeout " + cb.toString());
                try {
                    cb();
                }
                catch (err) {
                    Util.reportError("zero-timeout-" + cb.toString(), err);
                }
            });
            window.postMessage(zeroTimeoutName, "*");
        }
        function setupTimeoutZero() {
            zeroTimeoutFunctions = [];
            window.addEventListener("message", function (ev) {
                if (ev.source == window && ev.data == zeroTimeoutName) {
                    ev.stopPropagation();
                    while (zeroTimeoutFunctions.length > 0) {
                        var f = zeroTimeoutFunctions.shift();
                        f();
                    }
                }
            }, true);
        }
        function initGenericExtensions() {
            var arr = Array.prototype;
            arr.peek = function () {
                return this.length === 0 ? undefined : this[this.length - 1];
            };
            arr.collect = function (fn) {
                var res = [];
                for (var i = 0; i < this.length; ++i) {
                    var tmp = fn(this[i]);
                    for (var j = 0; j < tmp.length; ++j) {
                        res.push(tmp[j]);
                    }
                }
                return res;
            };
            arr.pushRange = function (other) {
                for (var i = 0; i < other.length; ++i)
                    this.push(other[i]);
            };
            arr.max = function () {
                return Math.max.apply(null, this);
            };
            arr.min = function () {
                return Math.min.apply(null, this);
            };
            arr.spliceArr = function (f, t, a) {
                return Array.prototype.splice.apply(this, [f, t].concat(a));
            };
            arr.stableSortObjs = function (cmp) {
                for (var i = 0; i < this.length; ++i)
                    this[i].__stableSortIdx = i;
                this.sort(function (a, b) {
                    var r = cmp(a, b);
                    if (r == 0)
                        return a.__stableSortIdx - b.__stableSortIdx;
                    else
                        return r;
                });
                for (var i = 0; i < this.length; ++i)
                    delete this[i].__stableSortIdx;
            };
            arr.stableSorted = function (cmp) {
                var idx = new Array(this.length);
                for (var i = 0; i < idx.length; ++i)
                    idx[i] = i;
                var t = this;
                idx.sort(function (a, b) {
                    var r = cmp(t[a], t[b]);
                    if (r == 0)
                        return a - b;
                    else
                        return r;
                });
                for (var i = 0; i < idx.length; ++i)
                    idx[i] = t[idx[i]];
                return idx;
            };
            arr.stableSort = function (cmp) {
                var idx = this.stableSorted(cmp);
                for (var i = 0; i < this.length; ++i)
                    this[i] = idx[i];
            };
            arr.clear = function () {
                return this.splice(0, this.length);
            };
            var str = String.prototype;
            str.startsWith = function (str) {
                this.slice(0, str.length) == str;
            };
            str.endsWith = function (str) {
                this.slice(-str.length) == str;
            };
            str.count = function () {
                return this.length;
            };
            str.at = function (idx) {
                return this.charAt(idx);
            };
        }
        Util.initGenericExtensions = initGenericExtensions;
        function intersectArraysVA(arrays) {
            if (!arrays.length)
                return [];
            arrays.sort(function (a, b) { return a.length - b.length; });
            var res = [];
            arrays[0].forEach(function (e) {
                for (var i = 1; i < arrays.length; ++i)
                    if (arrays[i].indexOf(e) < 0)
                        return;
                res.push(e);
            });
            return res;
        }
        Util.intersectArraysVA = intersectArraysVA;
        function concatArraysVA(arrays) {
            var res = [];
            for (var i = 0; i < arrays.length; ++i) {
                var a = arrays[i];
                for (var j = 0; j < a.length; ++j)
                    res.push(a[j]);
            }
            return res;
        }
        Util.concatArraysVA = concatArraysVA;
        function concatArrays() {
            var arrays = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                arrays[_i - 0] = arguments[_i];
            }
            return concatArraysVA(arrays);
        }
        Util.concatArrays = concatArrays;
        function startsWith(s, pref) {
            if (!pref)
                return true;
            if (!s || s.length < pref.length)
                return false;
            return s.slice(0, pref.length) == pref;
        }
        Util.startsWith = startsWith;
        function stableSum(v) {
            var sum = 0.0;
            var c = 0.0;
            for (var i = 0; i < v.length; i++) {
                var y = v[i] - c;
                var t = sum + y;
                c = (t - sum) - y;
                sum = t;
            }
            return sum;
        }
        Util.stableSum = stableSum;
        function initCscript() {
            TDev.Browser.cscript = true;
            var arr = Array.prototype;
            arr.map = function (f) {
                var res = [];
                for (var i = 0; i < this.length; ++i) {
                    var tmp = f(this[i], i);
                    res.push(tmp);
                }
                return res;
            };
            arr.forEach = function (f) {
                for (var i = 0; i < this.length; ++i) {
                    f(this[i], i);
                }
            };
            arr.filter = function (f) {
                var res = [];
                for (var i = 0; i < this.length; ++i) {
                    if (f(this[i], i))
                        res.push(this[i]);
                }
                return res;
            };
            var obj = Object.prototype;
            obj.create = function (o) {
                function F() {
                }
                F.prototype = o;
                return new F();
            };
            Object.keys = function (o) {
                var res = [];
                for (var k in o) {
                    if (o.hasOwnProperty(k))
                        res.push(k);
                }
                return res;
            };
        }
        Util.initCscript = initCscript;
        function values(o) {
            return Object.keys(o).map(function (k) { return o[k]; });
        }
        Util.values = values;
        function userError(msg, pc, statusCode) {
            if (pc === void 0) { pc = ""; }
            var e = new Error(msg);
            e.isUserError = true;
            if (statusCode)
                e.statusCode = statusCode;
            try {
                throw e;
            }
            catch (err) {
                Util.log('error: {0}, {1}, {2}', msg, pc, statusCode);
                Util.log(err.stack + "");
                throw e;
            }
        }
        Util.userError = userError;
        function syntaxError(msg, declName) {
            var e = new Error(msg);
            e.syntaxErrorDeclName = declName;
            e.isUserError = true;
            throw e;
        }
        Util.syntaxError = syntaxError;
        function indexCheck(i, length) {
            i = Math.floor(i);
            if (i < 0 || i >= length)
                Util.userError("index " + i + " out of bounds (collection size: " + length + ")");
            return i;
        }
        Util.indexCheck = indexCheck;
        function isOOB(i, length) {
            i = Math.floor(i);
            return (i < 0 || i >= length);
        }
        Util.isOOB = isOOB;
        function notImplementedYet(s, apiName) {
            if (s.rt.devMode)
                Util.userError(apiName + " not implemented yet");
            return undefined;
        }
        Util.notImplementedYet = notImplementedYet;
        function notSupported(s, apiName) {
            if (s.rt.devMode)
                Util.userError(apiName + " is not supported in this version of Touch Develop");
            return undefined;
        }
        Util.notSupported = notSupported;
        function guidGen() {
            function f() {
                return (TDev.Random.uint32() | 0x10000).toString(16).slice(-4);
            }
            return f() + f() + "-" + f() + "-4" + f().slice(-3) + "-" + f() + "-" + f() + f() + f();
        }
        Util.guidGen = guidGen;
        function guidToAlpha(guid) {
            var nohyphens = guid.replace(/-/g, 'z');
            var nonumbers = nohyphens.replace(/[0-9]/g, function (s) {
                var digit = s.charCodeAt(0) - ("0".charCodeAt(0)) + ("m".charCodeAt(0));
                return String.fromCharCode(digit);
            });
            return nonumbers;
        }
        Util.guidToAlpha = guidToAlpha;
        Util.colors = [
            "#FF00FF",
            "#800080",
            "#A52A2A",
            "#E25822",
            "#FF0038",
            "#008080",
            "#00008B",
            "#004B49",
        ];
        function svgGravatar(id) {
            if (!id)
                id = "none";
            var advance = function (hash, v) { return ((hash << 16) + (hash << 6) + v - hash) << 0; };
            var hash = 0;
            for (var i = 0; i < id.length; ++i) {
                hash = advance(hash, id.charCodeAt(i));
            }
            var n = hash & 0xffff;
            var idx = n % (Util.colors.length - 1);
            var c = Util.colors[idx];
            var d = "";
            var numPixels = 0;
            while (numPixels < 6) {
                for (var x = 0; x < 3; ++x) {
                    for (var y = 0; y < 5; ++y) {
                        hash = advance(hash, id.charCodeAt(i++ % id.length));
                        n = hash & 0xffff;
                        if (n > 30000) {
                        }
                        else {
                            d += Util.fmt(" M {0} {1} l 46 0 0 46 -46 0 Z", 50 * x + 2, 50 * y + 2);
                            if (x != 2)
                                d += Util.fmt(" M {0} {1} l 46 0 0 46 -46 0 Z", 50 * (4 - x) + 2, 50 * y + 2);
                            numPixels++;
                        }
                    }
                }
                numPixels++;
            }
            var svg = Util.fmt("<path fill='{0}' d='{1}' />", c, d);
            return TDev.SVG.svgBoilerPlate('0 0 250 250', svg);
        }
        Util.svgGravatar = svgGravatar;
        function base64Encode(_input) {
            function _base64(_x) {
                return ((_x <= 0x19) ? (_x + 0x41) : ((_x <= 0x33) ? (_x + 0x47) : ((_x <= 0x3D) ? (_x - 0x4) : ((_x == 0x3E) ? 0x2B : 0x2F))));
            }
            ;
            var result = new Array();
            var _q = 0x0;
            var _r = 0x0;
            for (var _i = 0; _i < _input.length; _i++) {
                var _x = _input.charCodeAt(_i);
                if ((_x > 0xFF)) {
                    return undefined;
                }
                else if ((_q == 0x0)) {
                    result.push(String.fromCharCode(_base64((_x >> 0x2))));
                    _q = 0x1;
                    _r = ((_x & 0x3) << 0x4);
                }
                else if ((_q == 0x1)) {
                    result.push(String.fromCharCode(_base64((_r | (_x >> 0x4)))));
                    _q = 0x2;
                    _r = ((_x & 0xF) << 0x2);
                }
                else if ((_q == 0x2)) {
                    result.push(String.fromCharCode(_base64((_r | (_x >> 0x6))), _base64((_x & 0x3F))));
                    _q = 0x0;
                    _r = 0x0;
                }
            }
            if ((_q == 0x1)) {
                result.push(String.fromCharCode(_base64(_r), 0x3D, 0x3D));
            }
            else if ((_q == 0x2)) {
                result.push(String.fromCharCode(_base64(_r), 0x3D));
            }
            return result.join('');
        }
        Util.base64Encode = base64Encode;
        function base64EncodeBytes(_input) {
            function _base64(_x) {
                return ((_x <= 0x19) ? (_x + 0x41) : ((_x <= 0x33) ? (_x + 0x47) : ((_x <= 0x3D) ? (_x - 0x4) : ((_x == 0x3E) ? 0x2B : 0x2F))));
            }
            ;
            var result = new Array();
            var _q = 0x0;
            var _r = 0x0;
            for (var _i = 0; _i < _input.length; _i++) {
                var _x = _input[_i];
                if ((_x > 0xFF)) {
                    return undefined;
                }
                else if ((_q == 0x0)) {
                    result.push(String.fromCharCode(_base64((_x >> 0x2))));
                    _q = 0x1;
                    _r = ((_x & 0x3) << 0x4);
                }
                else if ((_q == 0x1)) {
                    result.push(String.fromCharCode(_base64((_r | (_x >> 0x4)))));
                    _q = 0x2;
                    _r = ((_x & 0xF) << 0x2);
                }
                else if ((_q == 0x2)) {
                    result.push(String.fromCharCode(_base64((_r | (_x >> 0x6))), _base64((_x & 0x3F))));
                    _q = 0x0;
                    _r = 0x0;
                }
            }
            if ((_q == 0x1)) {
                result.push(String.fromCharCode(_base64(_r), 0x3D, 0x3D));
            }
            else if ((_q == 0x2)) {
                result.push(String.fromCharCode(_base64(_r), 0x3D));
            }
            return result.join('');
        }
        Util.base64EncodeBytes = base64EncodeBytes;
        function stringToUint8Array(input) {
            var len = input.length;
            var res = new Uint8Array(len);
            for (var i = 0; i < len; ++i)
                res[i] = input.charCodeAt(i) & 0xff;
            return res;
        }
        Util.stringToUint8Array = stringToUint8Array;
        function uint8ArrayToString(input) {
            var len = input.length;
            var res = "";
            for (var i = 0; i < len; ++i)
                res += String.fromCharCode(input[i]);
            return res;
        }
        Util.uint8ArrayToString = uint8ArrayToString;
        function base64Decode(_input) {
            function _D(_x) {
                return ((_x == 0x2F) ? 0x3F : ((_x == 0x2B) ? 0x3E : ((_x <= 0x39) ? (_x + 0x4) : ((_x <= 0x5A) ? (_x - 0x41) : (_x - 0x47)))));
            }
            ;
            function _Bits(m, n, c) {
                var mask = 0;
                for (var i = 0; i <= (m - n); i++) {
                    mask = (mask << 1) + 1;
                }
                return (c >> n) & mask;
            }
            ;
            var result = new Array();
            var _q0 = true;
            var _q1 = false;
            var _q2 = false;
            var _q3 = false;
            var _q4 = false;
            var _q5 = false;
            var _r = 0x0;
            var rx = new RegExp("^([A-Za-z0-9+/=])$");
            for (var _i = 0; _i < _input.length; _i++) {
                var _x = _input.charCodeAt(_i);
                if ((!String.fromCharCode(_x).match(rx) || ((_x == 0x3D) && (_q0 || _q1)) || ((_x == 0x3D) && !(_r == 0x0)) || (!(_x == 0x3D) && _q4) || _q5)) {
                    return undefined;
                }
                else if (_q0) {
                    _r = (_D(_x) << 0x2);
                    _q0 = false;
                    _q1 = true;
                    _q2 = false;
                    _q3 = false;
                    _q4 = false;
                    _q5 = false;
                }
                else if (_q1) {
                    result.push(String.fromCharCode((_r | _Bits(0x5, 0x4, _D(_x)))));
                    _r = ((_D(_x) & 0xF) << 0x4);
                    _q0 = false;
                    _q1 = false;
                    _q2 = true;
                    _q3 = false;
                    _q4 = false;
                    _q5 = false;
                }
                else if (_q2) {
                    if ((_x == 0x3D)) {
                        _r = 0x0;
                        _q0 = false;
                        _q1 = false;
                        _q2 = false;
                        _q3 = false;
                        _q4 = true;
                        _q5 = false;
                    }
                    else {
                        result.push(String.fromCharCode((_r | _Bits(0x5, 0x2, _D(_x)))));
                        _r = ((_D(_x) & 0x3) << 0x6);
                        _q0 = false;
                        _q1 = false;
                        _q2 = false;
                        _q3 = true;
                        _q4 = false;
                        _q5 = false;
                    }
                }
                else if (_q3) {
                    if ((_x == 0x3D)) {
                        _r = 0x0;
                        _q0 = false;
                        _q1 = false;
                        _q2 = false;
                        _q3 = false;
                        _q4 = false;
                        _q5 = true;
                    }
                    else {
                        result.push(String.fromCharCode((_r | _D(_x))));
                        _r = 0x0;
                        _q0 = true;
                        _q1 = false;
                        _q2 = false;
                        _q3 = false;
                        _q4 = false;
                        _q5 = false;
                    }
                }
                else if (_q4) {
                    _r = 0x0;
                    _q0 = false;
                    _q1 = false;
                    _q2 = false;
                    _q3 = false;
                    _q4 = false;
                    _q5 = true;
                }
            }
            if (!(_q0 || _q5)) {
                return undefined;
            }
            return result.join('');
        }
        Util.base64Decode = base64Decode;
        function splitDataUrl(url) {
            if (!!url) {
                var match = /^data:([^;]+);base64,/.exec(url);
                if (!!match)
                    return {
                        contentType: match[1],
                        content: url.substr(match[0].length)
                    };
            }
            return null;
        }
        Util.splitDataUrl = splitDataUrl;
        function base64EncodeToBase64(url, mimeType) {
            var prefix = 'data:' + mimeType + ';base64,';
            if (!!url && TDev.RT.String_.starts_with(url, prefix))
                return url.substr(prefix.length);
            return undefined;
        }
        Util.base64EncodeToBase64 = base64EncodeToBase64;
        function decodeDataURL(url, mimeType) {
            if (mimeType === void 0) { mimeType = null; }
            if (!mimeType) {
                var m = url.match(/^data:([^;]+);base64,/);
                if (!m)
                    return undefined;
                mimeType = m[1];
            }
            var prefix = 'data:' + mimeType + ';base64,';
            var binaryEncoded = url.substr(prefix.length);
            var binary = atob(binaryEncoded);
            var arrayBuffer = new ArrayBuffer(binary.length);
            var array = new Uint8Array(arrayBuffer);
            for (var i = 0; i < binary.length; i++)
                array[i] = binary.charCodeAt(i) & 0xff;
            return array;
        }
        Util.decodeDataURL = decodeDataURL;
        function hex1(a) {
            var h = a & 0xF;
            h = (h <= 9 ? h + 48 : h + 55);
            return h;
        }
        ;
        function hex2(a0, a1) {
            var h = (a1 >> (4 * a0)) & 0xF;
            h = (h <= 9 ? h + 48 : h + 55);
            return h;
        }
        ;
        var entities = undefined;
        var entitiesRx = undefined;
        function htmlUnescape(_w) {
            if (!_w)
                return _w;
            if (!entities) {
                entities = {};
                entities['nbsp'] = ' ';
                entities['iexcl'] = '¡';
                entities['cent'] = '¢';
                entities['pound'] = '£';
                entities['curren'] = '¤';
                entities['yen'] = '¥';
                entities['brvbar'] = '¦';
                entities['sect'] = '§';
                entities['uml'] = '¨';
                entities['copy'] = '©';
                entities['ordf'] = 'ª';
                entities['laquo'] = '«';
                entities['not'] = '¬';
                entities['shy'] = '­';
                entities['reg'] = '®';
                entities['macr'] = '¯';
                entities['deg'] = '°';
                entities['plusmn'] = '±';
                entities['sup2'] = '²';
                entities['sup3'] = '³';
                entities['acute'] = '´';
                entities['micro'] = 'µ';
                entities['para'] = '¶';
                entities['middot'] = '·';
                entities['cedil'] = '¸';
                entities['sup1'] = '¹';
                entities['ordm'] = 'º';
                entities['raquo'] = '»';
                entities['frac14'] = '¼';
                entities['frac12'] = '½';
                entities['frac34'] = '¾';
                entities['iquest'] = '¿';
                entities['times'] = '×';
                entities['divide'] = '÷';
                entities['Agrave'] = 'À';
                entities['Aacute'] = 'Á';
                entities['Acirc'] = 'Â';
                entities['Atilde'] = 'Ã';
                entities['Auml'] = 'Ä';
                entities['Aring'] = 'Å';
                entities['AElig'] = 'Æ';
                entities['Ccedil'] = 'Ç';
                entities['Egrave'] = 'È';
                entities['Eacute'] = 'É';
                entities['Ecirc'] = 'Ê';
                entities['Euml'] = 'Ë';
                entities['Igrave'] = 'Ì';
                entities['Iacute'] = 'Í';
                entities['Icirc'] = 'Î';
                entities['Iuml'] = 'Ï';
                entities['ETH'] = 'Ð';
                entities['Ntilde'] = 'Ñ';
                entities['Ograve'] = 'Ò';
                entities['Oacute'] = 'Ó';
                entities['Ocirc'] = 'Ô';
                entities['Otilde'] = 'Õ';
                entities['Ouml'] = 'Ö';
                entities['Oslash'] = 'Ø';
                entities['Ugrave'] = 'Ù';
                entities['Uacute'] = 'Ú';
                entities['Ucirc'] = 'Û';
                entities['Uuml'] = 'Ü';
                entities['Yacute'] = 'Ý';
                entities['THORN'] = 'Þ';
                entities['szlig'] = 'ß';
                entities['agrave'] = 'à';
                entities['aacute'] = 'á';
                entities['acirc'] = 'â';
                entities['atilde'] = 'ã';
                entities['auml'] = 'ä';
                entities['aring'] = 'å';
                entities['aelig'] = 'æ';
                entities['ccedil'] = 'ç';
                entities['egrave'] = 'è';
                entities['eacute'] = 'é';
                entities['ecirc'] = 'ê';
                entities['euml'] = 'ë';
                entities['igrave'] = 'ì';
                entities['iacute'] = 'í';
                entities['icirc'] = 'î';
                entities['iuml'] = 'ï';
                entities['eth'] = 'ð';
                entities['ntilde'] = 'ñ';
                entities['ograve'] = 'ò';
                entities['oacute'] = 'ó';
                entities['ocirc'] = 'ô';
                entities['otilde'] = 'õ';
                entities['ouml'] = 'ö';
                entities['oslash'] = 'ø';
                entities['ugrave'] = 'ù';
                entities['uacute'] = 'ú';
                entities['ucirc'] = 'û';
                entities['uuml'] = 'ü';
                entities['yacute'] = 'ý';
                entities['thorn'] = 'þ';
                entities['yuml'] = 'ÿ';
                entitiesRx = new RegExp('&(' + Object.keys(entities).join('|') + ');', 'gim');
            }
            _w = _w.replace(entitiesRx, function (m, args) {
                return entities[args];
            });
            function _IsDecDig(_x) {
                return ((0x30 <= _x) && (_x <= 0x39));
            }
            ;
            function _F(_x, _y) {
                return ((0xA * _x) + (_y - 0x30));
            }
            ;
            function _D1(_x) {
                return ((_x % 0xA) + 0x30);
            }
            ;
            function _D2(_x) {
                return (((_x / 0xA) % 0xA) + 0x30);
            }
            ;
            function _D3(_x) {
                return (((_x / 0x64) % 0xA) + 0x30);
            }
            ;
            function _D4(_x) {
                return (((_x / 0x3E8) % 0xA) + 0x30);
            }
            ;
            function _D5(_x) {
                return (((_x / 0x2710) % 0xA) + 0x30);
            }
            ;
            function _IsHexDig(_x) {
                return (((0x30 <= _x) && (_x <= 0x39)) || ((0x41 <= _x) && (_x <= 0x46)));
            }
            ;
            function _Fx(_x, _y) {
                return ((_x << 0x4) | (_IsDecDig(_y) ? (_y - 0x30) : (_y - 0x37)));
            }
            ;
            function _H1(_x) {
                return (_IsDec((_x & 0xF)) ? ((_x & 0xF) + 0x30) : ((_x & 0xF) + 0x37));
            }
            ;
            function _IsDec(_x) {
                return ((0x0 <= _x) && (_x <= 0x9));
            }
            ;
            function _H2(_x) {
                return (_IsDec(((_x >> 0x4) & 0xF)) ? (((_x >> 0x4) & 0xF) + 0x30) : (((_x >> 0x4) & 0xF) + 0x37));
            }
            ;
            function _H3(_x) {
                return (_IsDec(((_x >> 0x8) & 0xF)) ? (((_x >> 0x8) & 0xF) + 0x30) : (((_x >> 0x8) & 0xF) + 0x37));
            }
            ;
            function _H4(_x) {
                return (_IsDec(((_x >> 0xC) & 0xF)) ? (((_x >> 0xC) & 0xF) + 0x30) : (((_x >> 0xC) & 0xF) + 0x37));
            }
            ;
            var result = new Array();
            var _q = 0x0;
            var _d = 0x0;
            for (var _i = 0; _i < _w.length; _i++) {
                var _c = _w.charCodeAt(_i);
                if (((_q == 0x0) && (_c == 0x26))) {
                    _q = 0x26;
                }
                else if ((_q == 0x0)) {
                    result.push(String.fromCharCode(_c));
                }
                else if (((_q == 0x26) && (_c == 0x23))) {
                    _q = 0x23;
                }
                else if (((_q == 0x26) && (_c == 0x61))) {
                    _q = 0x61;
                }
                else if (((_q == 0x26) && (_c == 0x71))) {
                    _q = 0x71;
                }
                else if (((_q == 0x26) && (_c == 0x6C))) {
                    _q = 0x6C;
                }
                else if (((_q == 0x26) && (_c == 0x67))) {
                    _q = 0x67;
                }
                else if (((_q == 0x26) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26));
                }
                else if ((_q == 0x26)) {
                    result.push(String.fromCharCode(0x26, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x23) && (_c == 0x58))) {
                    _q = 0x58;
                }
                else if (((_q == 0x23) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x23));
                    _q = 0x26;
                }
                else if (((_q == 0x23) && _IsDecDig(_c))) {
                    _q = 0x1;
                    _d = (_c - 0x30);
                }
                else if ((_q == 0x23)) {
                    result.push(String.fromCharCode(0x26, 0x23, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x1) && _IsDecDig(_c))) {
                    _q = 0x2;
                    _d = _F(_d, _c);
                }
                else if (((_q == 0x1) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(_d));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x1) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x23, _D1(_d)));
                    _q = 0x26;
                    _d = 0x0;
                }
                else if ((_q == 0x1)) {
                    result.push(String.fromCharCode(0x26, 0x23, _D1(_d), _c));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x2) && _IsDecDig(_c))) {
                    _q = 0x3;
                    _d = _F(_d, _c);
                }
                else if (((_q == 0x2) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(_d));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x2) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x23, _D2(_d), _D1(_d)));
                    _q = 0x26;
                    _d = 0x0;
                }
                else if ((_q == 0x2)) {
                    result.push(String.fromCharCode(0x26, 0x23, _D2(_d), _D1(_d), _c));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x3) && _IsDecDig(_c))) {
                    _q = 0x4;
                    _d = _F(_d, _c);
                }
                else if (((_q == 0x3) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(_d));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x3) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x23, _D3(_d), _D2(_d), _D1(_d)));
                    _q = 0x26;
                    _d = 0x0;
                }
                else if ((_q == 0x3)) {
                    result.push(String.fromCharCode(0x26, 0x23, _D3(_d), _D2(_d), _D1(_d), _c));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x4) && _IsDecDig(_c) && (_F(_d, _c) <= 0xFFFF))) {
                    _q = 0x5;
                    _d = _F(_d, _c);
                }
                else if (((_q == 0x4) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(_d));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x4) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x23, _D4(_d), _D3(_d), _D2(_d), _D1(_d)));
                    _q = 0x26;
                    _d = 0x0;
                }
                else if ((_q == 0x4)) {
                    result.push(String.fromCharCode(0x26, 0x23, _D4(_d), _D3(_d), _D2(_d), _D1(_d), _c));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x5) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(_d));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x5) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x23, _D5(_d), _D4(_d), _D3(_d), _D2(_d), _D1(_d)));
                    _q = 0x26;
                    _d = 0x0;
                }
                else if ((_q == 0x5)) {
                    result.push(String.fromCharCode(0x26, 0x23, _D5(_d), _D4(_d), _D3(_d), _D2(_d), _D1(_d), _c));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x58) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x23, 0x58));
                    _q = 0x26;
                }
                else if (((_q == 0x58) && _IsHexDig(_c))) {
                    _q = 0x6;
                    _d = _Fx(0x0, _c);
                }
                else if ((_q == 0x58)) {
                    _q = 0x0;
                    result.push(String.fromCharCode(0x26, 0x23, 0x58, _c));
                    _d = 0x0;
                }
                else if (((_q == 0x6) && _IsHexDig(_c))) {
                    _q = 0x7;
                    _d = _Fx(_d, _c);
                }
                else if (((_q == 0x6) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(_d));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x6) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x23, 0x58, _H1(_d)));
                    _q = 0x26;
                    _d = 0x0;
                }
                else if ((_q == 0x6)) {
                    result.push(String.fromCharCode(0x26, 0x23, 0x58, _H1(_d), _c));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x7) && _IsHexDig(_c))) {
                    _q = 0x8;
                    _d = _Fx(_d, _c);
                }
                else if (((_q == 0x7) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(_d));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x7) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x23, 0x58, _H2(_d), _H1(_d)));
                    _q = 0x26;
                    _d = 0x0;
                }
                else if ((_q == 0x7)) {
                    result.push(String.fromCharCode(0x26, 0x23, 0x58, _H2(_d), _H1(_d), _c));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x8) && _IsHexDig(_c))) {
                    _q = 0x9;
                    _d = _Fx(_d, _c);
                }
                else if (((_q == 0x8) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(_d));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x8) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x23, 0x58, _H3(_d), _H2(_d), _H1(_d)));
                    _q = 0x26;
                    _d = 0x0;
                }
                else if ((_q == 0x8)) {
                    result.push(String.fromCharCode(0x26, 0x23, 0x58, _H3(_d), _H2(_d), _H1(_d), _c));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x9) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(_d));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x9) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x23, 0x58, _H4(_d), _H3(_d), _H2(_d), _H1(_d)));
                    _q = 0x26;
                    _d = 0x0;
                }
                else if ((_q == 0x9)) {
                    result.push(String.fromCharCode(0x26, 0x23, 0x58, _H4(_d), _H3(_d), _H2(_d), _H1(_d), _c));
                    _q = 0x0;
                    _d = 0x0;
                }
                else if (((_q == 0x6C) && (_c == 0x74))) {
                    _q = 0x4C;
                }
                else if (((_q == 0x6C) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x6C));
                    _q = 0x26;
                }
                else if ((_q == 0x6C)) {
                    result.push(String.fromCharCode(0x26, 0x6C, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x4C) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(0x3C));
                    _q = 0x0;
                }
                else if (((_q == 0x4C) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x6C, 0x74));
                    _q = 0x26;
                }
                else if ((_q == 0x4C)) {
                    result.push(String.fromCharCode(0x26, 0x6C, 0x74, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x67) && (_c == 0x74))) {
                    _q = 0x47;
                }
                else if (((_q == 0x67) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x67));
                    _q = 0x26;
                }
                else if ((_q == 0x67)) {
                    result.push(String.fromCharCode(0x26, 0x67, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x47) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(0x3E));
                    _q = 0x0;
                }
                else if (((_q == 0x47) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x67, 0x74));
                    _q = 0x26;
                }
                else if ((_q == 0x47)) {
                    result.push(String.fromCharCode(0x26, 0x67, 0x74, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x71) && (_c == 0x75))) {
                    _q = 0x75;
                }
                else if (((_q == 0x71) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x71));
                    _q = 0x26;
                }
                else if ((_q == 0x71)) {
                    result.push(String.fromCharCode(0x26, 0x71, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x75) && (_c == 0x6F))) {
                    _q = 0x6F;
                }
                else if (((_q == 0x75) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x71, 0x75));
                    _q = 0x26;
                }
                else if ((_q == 0x75)) {
                    result.push(String.fromCharCode(0x26, 0x71, 0x75, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x6F) && (_c == 0x74))) {
                    _q = 0x74;
                }
                else if (((_q == 0x6F) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x71, 0x75, 0x6F));
                    _q = 0x26;
                }
                else if ((_q == 0x6F)) {
                    result.push(String.fromCharCode(0x26, 0x71, 0x75, 0x6F, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x74) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(0x22));
                    _q = 0x0;
                }
                else if (((_q == 0x74) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x71, 0x75, 0x6F, 0x74));
                    _q = 0x26;
                }
                else if ((_q == 0x74)) {
                    result.push(String.fromCharCode(0x26, 0x71, 0x75, 0x6F, 0x74, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x61) && (_c == 0x6D))) {
                    _q = 0x6D;
                }
                else if (((_q == 0x61) && (_c == 0x70))) {
                    _q = 0x50;
                }
                else if (((_q == 0x61) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x61));
                    _q = 0x26;
                }
                else if ((_q == 0x61)) {
                    result.push(String.fromCharCode(0x26, 0x61, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x6D) && (_c == 0x70))) {
                    _q = 0x70;
                }
                else if (((_q == 0x6D) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x61, 0x6D));
                    _q = 0x26;
                }
                else if ((_q == 0x6D)) {
                    result.push(String.fromCharCode(0x26, 0x61, 0x6D, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x70) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(0x26));
                    _q = 0x0;
                }
                else if (((_q == 0x70) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x61, 0x6D, 0x70));
                    _q = 0x26;
                }
                else if ((_q == 0x70)) {
                    result.push(String.fromCharCode(0x26, 0x61, 0x6D, 0x70, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x50) && (_c == 0x6F))) {
                    _q = 0x4F;
                }
                else if (((_q == 0x50) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x61, 0x70));
                    _q = 0x26;
                }
                else if ((_q == 0x50)) {
                    result.push(String.fromCharCode(0x26, 0x61, 0x70, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x4F) && (_c == 0x73))) {
                    _q = 0x53;
                }
                else if (((_q == 0x4F) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x61, 0x70, 0x6F));
                    _q = 0x26;
                }
                else if ((_q == 0x4F)) {
                    result.push(String.fromCharCode(0x26, 0x61, 0x70, 0x6F, _c));
                    _q = 0x0;
                }
                else if (((_q == 0x53) && (_c == 0x3B))) {
                    result.push(String.fromCharCode(0x27));
                    _q = 0x0;
                }
                else if (((_q == 0x53) && (_c == 0x26))) {
                    result.push(String.fromCharCode(0x26, 0x61, 0x70, 0x6F, 0x73));
                    _q = 0x26;
                }
                else if ((_q == 0x53)) {
                    result.push(String.fromCharCode(0x26, 0x61, 0x70, 0x6F, 0x73, _c));
                    _q = 0x0;
                }
                else if (true) {
                    _q = 0x0;
                    _d = 0x0;
                }
            }
            if ((_q == 0x0)) {
            }
            else if ((_q == 0x26)) {
                result.push(String.fromCharCode(0x26));
            }
            else if ((_q == 0x23)) {
                result.push(String.fromCharCode(0x26, 0x23));
            }
            else if ((_q == 0x58)) {
                result.push(String.fromCharCode(0x26, 0x23, 0x58));
            }
            else if ((_q == 0x1)) {
                result.push(String.fromCharCode(0x26, 0x23, _D1(_d)));
            }
            else if ((_q == 0x2)) {
                result.push(String.fromCharCode(0x26, 0x23, _D2(_d), _D1(_d)));
            }
            else if ((_q == 0x3)) {
                result.push(String.fromCharCode(0x26, 0x23, _D3(_d), _D2(_d), _D1(_d)));
            }
            else if ((_q == 0x4)) {
                result.push(String.fromCharCode(0x26, 0x23, _D4(_d), _D3(_d), _D2(_d), _D1(_d)));
            }
            else if ((_q == 0x5)) {
                result.push(String.fromCharCode(0x26, 0x23, _D5(_d), _D4(_d), _D3(_d), _D2(_d), _D1(_d)));
            }
            else if ((_q == 0x6)) {
                result.push(String.fromCharCode(0x26, 0x23, 0x58, _H1(_d)));
            }
            else if ((_q == 0x7)) {
                result.push(String.fromCharCode(0x26, 0x23, 0x58, _H2(_d), _H1(_d)));
            }
            else if ((_q == 0x8)) {
                result.push(String.fromCharCode(0x26, 0x23, 0x58, _H3(_d), _H2(_d), _H1(_d)));
            }
            else if ((_q == 0x9)) {
                result.push(String.fromCharCode(0x26, 0x23, 0x58, _H4(_d), _H3(_d), _H2(_d), _H1(_d)));
            }
            else if ((_q == 0x6C)) {
                result.push(String.fromCharCode(0x26, 0x6C));
            }
            else if ((_q == 0x4C)) {
                result.push(String.fromCharCode(0x26, 0x6C, 0x74));
            }
            else if ((_q == 0x67)) {
                result.push(String.fromCharCode(0x26, 0x67));
            }
            else if ((_q == 0x47)) {
                result.push(String.fromCharCode(0x26, 0x67, 0x74));
            }
            else if ((_q == 0x71)) {
                result.push(String.fromCharCode(0x26, 0x71));
            }
            else if ((_q == 0x75)) {
                result.push(String.fromCharCode(0x26, 0x71, 0x75));
            }
            else if ((_q == 0x6F)) {
                result.push(String.fromCharCode(0x26, 0x71, 0x75, 0x6F));
            }
            else if ((_q == 0x74)) {
                result.push(String.fromCharCode(0x26, 0x71, 0x75, 0x6F, 0x74));
            }
            else if ((_q == 0x61)) {
                result.push(String.fromCharCode(0x26, 0x61));
            }
            else if ((_q == 0x6D)) {
                result.push(String.fromCharCode(0x26, 0x61, 0x6D));
            }
            else if ((_q == 0x70)) {
                result.push(String.fromCharCode(0x26, 0x61, 0x6D, 0x70));
            }
            else if ((_q == 0x50)) {
                result.push(String.fromCharCode(0x26, 0x61, 0x70));
            }
            else if ((_q == 0x4F)) {
                result.push(String.fromCharCode(0x26, 0x61, 0x70, 0x6F));
            }
            else if ((_q == 0x53)) {
                result.push(String.fromCharCode(0x26, 0x61, 0x70, 0x6F, 0x73));
            }
            else if (true) {
            }
            return result.join('');
        }
        Util.htmlUnescape = htmlUnescape;
        function htmlEscape(_input) {
            if (!_input)
                return _input;
            var result = new Array();
            var _HS = false;
            var _r = 0x0;
            for (var _i = 0; _i < _input.length; _i++) {
                var _x = _input.charCodeAt(_i);
                if (!_HS) {
                    if (String.fromCharCode(_x).match(/^([\x20\x21\x23-\x25\x28-\x3B\x3D\x3F-\x7E\xA1-\xAC\xAE-\u036F])$/)) {
                        result.push(String.fromCharCode(_x));
                    }
                    else {
                        if ((_x == 0x22)) {
                            result.push(String.fromCharCode(0x26, 0x71, 0x75, 0x6F, 0x74, 0x3B));
                        }
                        else {
                            if ((_x == 0x26)) {
                                result.push(String.fromCharCode(0x26, 0x61, 0x6D, 0x70, 0x3B));
                            }
                            else {
                                if ((_x == 0x3C)) {
                                    result.push(String.fromCharCode(0x26, 0x6C, 0x74, 0x3B));
                                }
                                else {
                                    if ((_x == 0x3E)) {
                                        result.push(String.fromCharCode(0x26, 0x67, 0x74, 0x3B));
                                    }
                                    else {
                                        if ((_x < 0x10)) {
                                            result.push(String.fromCharCode(0x26, 0x23, 0x58, hex2(0x0, _x), 0x3B));
                                        }
                                        else {
                                            if ((_x < 0x100)) {
                                                result.push(String.fromCharCode(0x26, 0x23, 0x58, hex2(0x1, _x), hex2(0x0, _x), 0x3B));
                                            }
                                            else {
                                                if ((_x < 0x1000)) {
                                                    result.push(String.fromCharCode(0x26, 0x23, 0x58, hex2(0x2, _x), hex2(0x1, _x), hex2(0x0, _x), 0x3B));
                                                }
                                                else {
                                                    if (((0xD800 <= _x) && (_x <= 0xDBFF))) {
                                                        if ((((_x >> 0x6) & 0xF) == 0xF)) {
                                                            result.push(String.fromCharCode(0x26, 0x23, 0x58, 0x31, 0x30, hex2(0x0, (_x >> 0x2))));
                                                            _HS = true;
                                                            _r = (_x & 0x3);
                                                        }
                                                        else {
                                                            result.push(String.fromCharCode(0x26, 0x23, 0x58, hex2(0x0, ((_x >> 0x6) + 0x1)), hex2(0x0, (_x >> 0x2))));
                                                            _HS = true;
                                                            _r = (_x & 0x3);
                                                        }
                                                    }
                                                    else {
                                                        if ((((0xDC00 <= _x) && (_x <= 0xDFFF)) || (_x == 0xFFFF) || (_x == 0xFFFE))) {
                                                            return undefined;
                                                        }
                                                        else {
                                                            result.push(String.fromCharCode(0x26, 0x23, 0x58, hex2(0x3, _x), hex2(0x2, _x), hex2(0x1, _x), hex2(0x0, _x), 0x3B));
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                else if (true) {
                    if (((0xDC00 <= _x) && (_x <= 0xDFFF))) {
                        result.push(String.fromCharCode(hex1(((_r << 0x2) | ((_x >> 0x8) & 0x3))), hex2(0x1, _x), hex2(0x0, _x), 0x3B));
                        _HS = false;
                        _r = 0x0;
                    }
                    else {
                        return undefined;
                    }
                }
            }
            if (_HS) {
                return undefined;
            }
            return result.join('');
        }
        Util.htmlEscape = htmlEscape;
        function formatText(s) {
            return htmlEscape(s).replace(/&#XA;/g, "<br/>\n").replace(/ /g, "&#x2005;");
        }
        Util.formatText = formatText;
        function selectOnFocusTextArea(elt) {
            elt.onfocus = function () {
                elt.select();
            };
            elt.onmouseup = function () { return false; };
        }
        Util.selectOnFocusTextArea = selectOnFocusTextArea;
        function selectOnFocus(elt) {
            elt.onfocus = function () {
                elt.select();
            };
            elt.onmouseup = function () { return false; };
        }
        Util.selectOnFocus = selectOnFocus;
        function setKeyboardFocusTextArea(elt, selectAll) {
            if (selectAll === void 0) { selectAll = false; }
            elt.focus();
            try {
                elt.setSelectionRange(selectAll ? 0 : elt.value.length, elt.value.length);
            }
            catch (e) {
            }
        }
        Util.setKeyboardFocusTextArea = setKeyboardFocusTextArea;
        function setKeyboardFocus(elt, selectAll) {
            if (selectAll === void 0) { selectAll = false; }
            elt.focus();
            if (elt.type === "text" || elt.type === "number")
                try {
                    elt.setSelectionRange(selectAll ? 0 : elt.value.length, elt.value.length);
                }
                catch (e) {
                }
        }
        Util.setKeyboardFocus = setKeyboardFocus;
        function hideKeyboard() {
            var active = document.activeElement;
            if (active && active.blur) {
                if (TDev.Browser.isAndroid) {
                    active.readonly = "readonly";
                    active.disabled = "true";
                    Util.setTimeout(10, function () {
                        active.blur();
                        active.removeAttribute("readonly");
                        active.removeAttribute("disabled");
                    });
                }
                else {
                    active.blur();
                }
            }
        }
        Util.hideKeyboard = hideKeyboard;
        function offsetIn(elt, par) {
            var x = 0;
            var y = 0;
            while (!!elt) {
                if (elt == par)
                    break;
                x += elt.offsetLeft + elt.clientLeft - elt.scrollLeft;
                y += elt.offsetTop + elt.clientTop - elt.scrollTop;
                elt = elt.offsetParent;
            }
            return { x: x, y: y };
        }
        Util.offsetIn = offsetIn;
        function children() {
            var elts = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                elts[_i - 0] = arguments[_i];
            }
            var res = [];
            elts.forEach(function (elt) {
                var cn = elt.children;
                for (var i = 0; i < cn.length; ++i)
                    res.push(cn[i]);
            });
            return res;
        }
        Util.children = children;
        function childNodes() {
            var elts = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                elts[_i - 0] = arguments[_i];
            }
            var res = [];
            elts.forEach(function (elt) {
                var cn = elt.childNodes;
                for (var i = 0; i < cn.length; ++i)
                    res.push(cn[i]);
            });
            return res;
        }
        Util.childNodes = childNodes;
        var transformPropertyName = "";
        var perspectivePropertyName = "";
        function setTransform(e, t, origin, perspective) {
            if (origin === void 0) { origin = undefined; }
            if (perspective === void 0) { perspective = undefined; }
            var style = e.style;
            if (!transformPropertyName) {
                if (style["transform"] !== undefined)
                    transformPropertyName = "transform";
                else
                    ["Webkit", "ms", "Moz", "O"].forEach(function (pref) {
                        var tt = pref + "Transform";
                        if (!transformPropertyName && style[tt] !== undefined) {
                            transformPropertyName = tt;
                            perspectivePropertyName = pref + "Perspective";
                        }
                    });
                if (!transformPropertyName) {
                    transformPropertyName = "transform";
                    perspectivePropertyName = "perspective";
                }
            }
            if (origin !== undefined)
                style[transformPropertyName + "Origin"] = origin;
            if (perspective !== undefined)
                style[perspectivePropertyName] = perspective;
            style[transformPropertyName] = t;
        }
        Util.setTransform = setTransform;
        function id(e) {
            return e;
        }
        Util.id = id;
        function doNothing() {
            var pars = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                pars[_i - 0] = arguments[_i];
            }
        }
        Util.doNothing = doNothing;
        ;
        var logMsgs = [];
        Util.logSz = 200;
        var logIdx = -1;
        function timeSeries(f, len) {
            if (len === void 0) { len = 10; }
            var times = [];
            var avg = function (v) {
                var sum = 0;
                v.forEach(function (x) { return sum += x; });
                return Math.round(sum / v.length * 100) / 100;
            };
            var report = function (m) {
                if (m === void 0) { m = ""; }
                times.sort(function (a, b) { return a - b; });
                var t = times.slice(0, Math.round(0.7 * times.length));
                var sum = 0;
                t.forEach(function (v) { return sum += v; });
                var sum2 = 0;
                times.forEach(function (v) { return sum2 += v; });
                Util.log("iter {0}; {2}ms (with drop {1}; otherwise {3}ms) [{5}] {4}", times.length, times.length - t.length, avg(t), avg(times), m, times.map(function (v) { return Math.round(v); }).join(", "));
            };
            var tot = 0;
            for (var i = 0; i < len; ++i) {
                var st = Util.perfNow();
                f();
                var tm = Util.perfNow() - st;
                tot += tm;
                times.push(tm);
                if (tot > 1000) {
                    report();
                    tot = 0;
                }
            }
            report("done");
        }
        Util.timeSeries = timeSeries;
        function time(msg, f, dontDoIt) {
            if (dontDoIt === void 0) { dontDoIt = false; }
            if (dontDoIt)
                f();
            else {
                var ts = TDev.RT.Perf.start(msg);
                f();
                TDev.RT.Perf.stop(ts);
            }
        }
        Util.time = time;
        function now() {
            return Date.now();
        }
        Util.now = now;
        Util.startupTime = now();
        Util.perfNow;
        Util.externalLog = null;
        Util.remoteLogEndpoint = "";
        var remoteLogConnection = null;
        var remoteLogConnecting = false;
        function handleRemoteLog(m) {
            if (!Util.remoteLogEndpoint)
                return;
            if (!remoteLogConnecting) {
                remoteLogConnecting = true;
                var conn = new WebSocket(Util.remoteLogEndpoint);
                conn.onopen = function () {
                    console.log("Remote log connection opened");
                    remoteLogConnection = conn;
                    getLogMsgs().forEach(function (m) { return conn.send(m.elapsed + ": " + m.msg); });
                };
                conn.onclose = function () {
                    console.log("Remote log connection closed");
                    remoteLogConnection = null;
                };
                conn.onerror = function () {
                    console.log("Remote log connection error");
                    remoteLogConnection = null;
                };
            }
            if (remoteLogConnection)
                remoteLogConnection.send(m);
        }
        function log(f) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            var msg = fmt_va(f, args);
            var n = now();
            var diff = (now() - Util.startupTime) / 1000;
            var m = fmt_va("{0:f04.3}: {1}", [diff, msg]);
            var lm = {
                timestamp: n,
                level: /^log:/.test(f) ? 6 : /^crash/i.test(f) ? 3 : 7,
                category: "tdlog",
                msg: msg
            };
            if (logIdx >= 0) {
                logMsgs[logIdx++] = lm;
                if (logIdx >= Util.logSz)
                    logIdx = 0;
            }
            else {
                logMsgs.push(lm);
                if (logMsgs.length >= Util.logSz)
                    logIdx = 0;
            }
            if (!/^(DBG|TICK): /.test(f))
                TDev.Ticker.tick(454 /* dbgLogEvent */, msg.slice(0, 200));
            if (TDev.Browser.cscript) {
            }
            else if (TDev.Browser.useConsoleLog) {
                if (TDev.isWebWorker)
                    console.log("WORK-TD-LOG: " + m);
                else
                    console.log("TD-LOG: " + m);
            }
            if (TDev.Browser.logToHost)
                Util.externalNotify("LOG: " + m);
            handleRemoteLog(m);
            if (Util.externalLog)
                Util.externalLog(m);
            if (!TDev.Browser.loadingDone && /debugMsg/.test(document.URL)) {
                var e = TDev.elt("statusMsg");
                if (e)
                    TDev.Browser.setInnerHTML(e, Util.formatText(m) + "</br>" + e.innerHTML);
            }
        }
        Util.log = log;
        Util.dbglog = log;
        function elapsed(start, end) {
            return ("00000000" + (end - start)).slice(-7).replace(/(\d\d\d)$/, function (k) { return "." + k; });
        }
        Util.elapsed = elapsed;
        function getLogMsgs() {
            var i = logIdx;
            var res = [];
            var wrapped = false;
            if (i < 0)
                i = 0;
            var n = now();
            while (i < logMsgs.length) {
                var c = Util.clone(logMsgs[i]);
                c.elapsed = Util.elapsed(c.timestamp, n);
                res.push(c);
                if (++i == logMsgs.length && !wrapped) {
                    wrapped = true;
                    i = 0;
                }
                if (wrapped && i >= logIdx)
                    break;
            }
            return res;
        }
        Util.getLogMsgs = getLogMsgs;
        function externalNotify(msg) {
            var w = window;
            if (w && w.external && "notify" in w.external)
                w.external.notify(msg);
        }
        Util.externalNotify = externalNotify;
        function showLog(ld) {
            Util.log("show log");
            var res = getLogMsgs().map(function (m) { return "<div class='logMsg'>" + Util.formatText(m.msg) + "</div>\n"; });
            res.reverse();
            TDev.Browser.setInnerHTML(ld, res.join(""));
        }
        Util.showLog = showLog;
        function jsonEq(a, b) {
            switch (typeof a) {
                case "string":
                case "number":
                case "boolean":
                    return a === b;
            }
            if (a === b)
                return true;
            if (a === null || a === undefined || b === null || b === undefined)
                return false;
            if (Array.isArray(a)) {
                if (Array.isArray(b)) {
                    if (a.length != b.length)
                        return false;
                    for (var i = 0; i < a.length; ++i)
                        if (!jsonEq(a[i], b[i]))
                            return false;
                    return true;
                }
                else
                    return false;
            }
            for (var p in b)
                if (b.hasOwnProperty(p) && !a.hasOwnProperty(p))
                    return false;
            for (var p in a) {
                if (a.hasOwnProperty(p)) {
                    if (!b.hasOwnProperty(p))
                        return false;
                    if (!jsonEq(a[p], b[p]))
                        return false;
                }
            }
            return true;
        }
        Util.jsonEq = jsonEq;
        function range(from, length) {
            var res = [];
            for (var i = 0; i < length; ++i)
                res.push(i + from);
            return res;
        }
        Util.range = range;
        function iterHtml(e, f) {
            if (!(e instanceof HTMLElement))
                return;
            if (f(e))
                return;
            for (var i = 0; i < e.childNodes.length; ++i) {
                var node = e.childNodes[i];
                iterHtml(node, f);
            }
        }
        Util.iterHtml = iterHtml;
        function highlightWords(e, terms, keepCache) {
            if (keepCache === void 0) { keepCache = false; }
            if (e instanceof Text) {
                var d = e.data;
                var lc = d.toLowerCase();
                var res = [];
                var prev = 0;
                for (var i = 0; i < lc.length; ++i) {
                    for (var j = 0; j < terms.length; ++j) {
                        if (terms[j].length == 0)
                            continue;
                        if (lc.slice(i, i + terms[j].length) == terms[j]) {
                            var t0 = document.createTextNode(d.slice(prev, i));
                            var t1 = TDev.span("highlight", d.slice(i, i + terms[j].length));
                            res.push(t0);
                            res.push(t1);
                            i += terms[j].length;
                            prev = i;
                            i--;
                            break;
                        }
                    }
                }
                if (prev == 0)
                    return;
                res.push(document.createTextNode(d.slice(prev, d.length)));
                var par = e.parentNode;
                if (keepCache && !par.originalCache)
                    par.originalCache = par.innerHTML;
                e.parentNode.replaceChild(TDev.span(null, res), e);
            }
            else if (e instanceof HTMLElement) {
                var ee = e;
                if (keepCache && ee.originalCache)
                    ee.innerHTML = ee.originalCache;
                for (var i = 0; i < e.childNodes.length; ++i) {
                    var node = e.childNodes[i];
                    highlightWords(node, terms);
                }
            }
        }
        Util.highlightWords = highlightWords;
        function animationProperty() {
            if (TDev.Browser.isWebkit)
                return "webkitAnimation";
            if (TDev.Browser.isGecko)
                return "MozAnimation";
            return "animation";
        }
        Util.animationProperty = animationProperty;
        function cancelAnim(elt) {
            elt.style[animationProperty()] = "";
        }
        Util.cancelAnim = cancelAnim;
        function coreAnim(name, duration, elt, andThen) {
            if (andThen === void 0) { andThen = undefined; }
            var remove = function () {
                elt.removeSelf();
            };
            if (TDev.Browser.noAnimations) {
                if (/^fadeOut/.test(name)) {
                    elt.style.opacity = "0";
                    if (!andThen)
                        andThen = remove;
                }
                if (andThen)
                    Util.setTimeout(300, function () { return andThen(); });
                return;
            }
            var evtName = TDev.Browser.isWebkit ? "webkitAnimationEnd" : "animationend";
            var propName = animationProperty();
            var oldOpacity = elt.style.opacity;
            var callbackExecuted = false;
            var f = Util.catchErrors("animationEnd " + name, function () {
                if (callbackExecuted)
                    return;
                callbackExecuted = true;
                window.clearTimeout(id);
                elt.removeEventListener(evtName, f);
                elt.style[propName] = "";
                elt.style.opacity = oldOpacity;
                if (andThen)
                    andThen();
            });
            var id = Util.setTimeout(duration + 300, f);
            elt.addEventListener(evtName, f);
            if (/^fadeOut/.test(name)) {
                elt.style.opacity = "0";
                if (!andThen)
                    andThen = remove;
            }
            elt.style[propName] = name + " " + duration + "ms";
            return elt;
        }
        Util.coreAnim = coreAnim;
        function delayButton(b, time, blink) {
            if (time === void 0) { time = 3000; }
            if (blink === void 0) { blink = false; }
            b.style.opacity = "0";
            b.style.visibility = "hidden";
            Util.setTimeout(time, function () {
                b.style.visibility = "";
                Util.fadeIn(b, function () {
                    b.style.opacity = '1';
                    if (blink)
                        Util.setTimeout(2000, function () { return Util.coreAnim("blinkLocation", 4000, b); });
                });
            });
            return b;
        }
        Util.delayButton = delayButton;
        function animAsync(name, duration, elt) {
            return new TDev.Promise(function (onSuccess, onError, onProgress) {
                coreAnim(name, duration, elt, function () { return onSuccess(null); });
            });
        }
        Util.animAsync = animAsync;
        var easeOut = " cubic-bezier(0.1, 0.9, 0.2, 1)";
        function showPopup(elt, andThen) {
            if (andThen === void 0) { andThen = undefined; }
            return coreAnim("showPopup" + easeOut, 300, elt, andThen);
        }
        Util.showPopup = showPopup;
        function hidePopup(elt, andThen) {
            if (andThen === void 0) { andThen = undefined; }
            return coreAnim("fadeOut", 100, elt, andThen);
        }
        Util.hidePopup = hidePopup;
        function fadeIn(elt, andThen) {
            if (andThen === void 0) { andThen = undefined; }
            return coreAnim("fadeIn", 150, elt, andThen);
        }
        Util.fadeIn = fadeIn;
        function fadeOut(elt, andThen) {
            if (andThen === void 0) { andThen = undefined; }
            return coreAnim("fadeOut", 150, elt, andThen);
        }
        Util.fadeOut = fadeOut;
        function showLeftPanel(elt, andThen) {
            if (andThen === void 0) { andThen = undefined; }
            return coreAnim("showLeftPanel" + easeOut, 250, elt, andThen);
        }
        Util.showLeftPanel = showLeftPanel;
        function showRightPanel(elt, andThen) {
            if (andThen === void 0) { andThen = undefined; }
            return coreAnim("showRightPanel" + easeOut, 250, elt, andThen);
        }
        Util.showRightPanel = showRightPanel;
        function showBottomPanel(elt, andThen) {
            if (andThen === void 0) { andThen = undefined; }
            return coreAnim("showBottomPanel" + easeOut, 150, elt, andThen);
        }
        Util.showBottomPanel = showBottomPanel;
        function stopEvent() {
            var e = this;
            e.stopPropagation();
            e.preventDefault();
            return false;
        }
        function geckoKeyName(code) {
            switch (code) {
                case 0x0D: return "Enter";
                case 0x21: return "PageUp";
                case 0x22: return "PageDown";
                case 0x23: return "End";
                case 0x24: return "Home";
                case 0x25: return "Left";
                case 0x26: return "Up";
                case 0x27: return "Right";
                case 0x28: return "Down";
                case 0x2D: return "Insert";
                case 0x2E: return "Del";
                case 0x08: return "Backspace";
                case 0x11: return "Control";
                default: return null;
            }
        }
        function normalizeKeyEvent(e) {
            var keyName = e.key;
            if (e.keyIdentifier)
                keyName = e.keyIdentifier;
            switch (e.keyCode) {
                case 27:
                    keyName = "Esc";
                    break;
                case 9:
                    keyName = "Tab";
                    break;
                case 32:
                    keyName = "Space";
                    break;
                default:
                    if (TDev.Browser.isGecko && geckoKeyName(e.keyCode)) {
                        keyName = geckoKeyName(e.keyCode);
                    }
                    else {
                        var s = String.fromCharCode(e.keyCode);
                        if (/^[A-Z0-9]$/.test(s))
                            keyName = s;
                    }
                    break;
            }
            switch (keyName) {
                case "U+007F":
                    if (!e.charCode)
                        keyName = "Del";
                    break;
                case "U+0008":
                    keyName = "Backspace";
                    break;
                case "U+0020":
                    keyName = "Space";
                    break;
                case "Insert":
                    keyName = "Ins";
                    break;
                case "PageDown":
                    keyName = "PgDn";
                    break;
                case "PageUp":
                    keyName = "PgUp";
                    break;
            }
            if (e.altKey)
                keyName = "Alt-" + keyName;
            if (e.ctrlKey)
                keyName = "Ctrl-" + keyName;
            if (e.shiftKey)
                keyName = "Shift-" + keyName;
            e.keyName = keyName;
            var srcElt = e.srcElement;
            if (!srcElt)
                srcElt = e.originalTarget;
            try {
                var srcType = !srcElt ? "" : srcElt.type;
                e.fromTextBox = e.fromTextBox || srcType == "text" || srcType == "textarea" || srcElt.className == "wall-textbox";
                e.fromTextArea = e.fromTextArea || srcType == "textarea";
            }
            catch (e) {
            }
            if (srcElt && e.fromTextBox)
                TDev.LayoutMgr.instance.FlagTypingActivity(srcElt.getAttribute("id"));
            e.stopIt = stopEvent;
        }
        Util.normalizeKeyEvent = normalizeKeyEvent;
        function keyEventString(e, additionalChars) {
            if (additionalChars === void 0) { additionalChars = ""; }
            if (!e.fromTextBox) {
                var s = String.fromCharCode(e.charCode);
                if (/^[A-Za-z0-9]$/.test(s) || additionalChars.indexOf(s) >= 0)
                    return s;
            }
            return "";
        }
        Util.keyEventString = keyEventString;
        function onInputChange(e, f) {
            var current = e.value;
            e.addEventListener("input", function () {
                if (e.value != current) {
                    current = e.value;
                    f(current);
                }
            });
        }
        Util.onInputChange = onInputChange;
        function boundTo(low, x, high) {
            if (x < low)
                x = low;
            if (x > high)
                x = high;
            return x;
        }
        Util.boundTo = boundTo;
        function between(low, x, high) {
            return boundTo(low, x, high);
        }
        Util.between = between;
        function intBetween(low, x, high) {
            return Math.round(boundTo(low, x, high));
        }
        Util.intBetween = intBetween;
        function fmt_va(f, args) {
            if (args.length == 0)
                return f;
            return f.replace(/\{([0-9]+)(\:[^\}]+)?\}/g, function (s, n, spec) {
                var v = args[parseInt(n)];
                var r = "";
                var fmtMatch = /^:f(\d*)\.(\d+)/.exec(spec);
                if (fmtMatch) {
                    var precision = parseInt(fmtMatch[2]);
                    var len = parseInt(fmtMatch[1]) || 0;
                    var fillChar = /^0/.test(fmtMatch[1]) ? "0" : " ";
                    var num = v.toFixed(precision);
                    if (len > 0 && precision > 0)
                        len += precision + 1;
                    if (len > 0) {
                        while (num.length < len) {
                            num = fillChar + num;
                        }
                    }
                    r = num;
                }
                else if (spec == ":x") {
                    r = "0x" + v.toString(16);
                }
                else if (v === undefined)
                    r = "(undef)";
                else if (v === null)
                    r = "(null)";
                else if (v.toString)
                    r = v.toString();
                else
                    r = v + "";
                if (spec == ":a") {
                    if (/^\s*[euioah]/.test(r.toLowerCase()))
                        r = "an " + r;
                    else if (/^\s*[bcdfgjklmnpqrstvwxz]/.test(r.toLowerCase()))
                        r = "a " + r;
                }
                else if (spec == ":s") {
                    if (v == 1)
                        r = "";
                    else
                        r = "s";
                }
                else if (spec == ":q") {
                    r = Util.htmlEscape(r);
                }
                else if (spec == ":jq") {
                    r = Util.jsStringQuote(r);
                }
                else if (spec == ":uri") {
                    r = encodeURIComponent(r).replace(/'/g, "%27").replace(/"/g, "%22");
                }
                else if (spec == ":url") {
                    r = encodeURI(r).replace(/'/g, "%27").replace(/"/g, "%22");
                }
                else if (spec == ":%") {
                    r = (v * 100).toFixed(1).toString() + '%';
                }
                return r;
            });
        }
        Util.fmt_va = fmt_va;
        function fmt(f) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            return fmt_va(f, args);
        }
        Util.fmt = fmt;
        function ensureVisible(node, parent, margin) {
            if (parent === void 0) { parent = undefined; }
            if (margin === void 0) { margin = undefined; }
            if (!parent) {
                parent = node.parentNode;
                if (!parent)
                    return;
                while (!parent.scrollEnabled) {
                    parent = parent.parentNode;
                    if (!parent)
                        return;
                }
            }
            if (!margin)
                margin = 5;
            if (margin < 1)
                margin = parent.clientHeight * margin;
            var pos = offsetIn(node, parent);
            var y0 = pos.y;
            var y1 = pos.y + node.offsetHeight;
            var target = parent.scrollTop;
            if (target < y1 - parent.clientHeight + margin)
                target = y1 - parent.clientHeight + margin;
            if (target > y0 - margin)
                target = y0 - margin;
            parent.scrollTop = target;
            if (TDev.Browser.isMobileSafari)
                Util.setTimeout(500, function () {
                    parent.scrollTop = target;
                });
        }
        Util.ensureVisible = ensureVisible;
        function flatClone(obj) {
            var r = {};
            Object.keys(obj).forEach(function (k) {
                r[k] = obj[k];
            });
            return r;
        }
        Util.flatClone = flatClone;
        function sendErrorReport(bug, willReload) {
            if (willReload === void 0) { willReload = false; }
            try {
                var bb = Util.flatClone(bug);
                bb.eventTrace = "";
                Util.log(TDev.Ticker.bugReportToString(bb));
            }
            catch (e) {
                debugger;
            }
            TDev.Cloud.postBugReportAsync(bug).done(function () {
            }, function (e) { return undefined; });
        }
        Util.sendErrorReport = sendErrorReport;
        var recentBugReports = {};
        function sendPendingBugReports() {
            var b = window.localStorage["storedBug"];
            if (b) {
                window.localStorage.removeItem("storedBug");
                try {
                    sendErrorReport(JSON.parse(b));
                }
                catch (e) {
                    debugger;
                }
            }
        }
        Util.sendPendingBugReports = sendPendingBugReports;
        Util.navigatingAway = false;
        function navigateInWindow(url) {
            window.location.href = url;
            Util.navigatingAway = true;
        }
        Util.navigateInWindow = navigateInWindow;
        function navigateNewWindow(url) {
            TDev.RT.Web.browseAsync(url).done();
        }
        Util.navigateNewWindow = navigateNewWindow;
        function isError(err, f) {
            return err && (f(err) || (typeof err == "object" && Object.keys(err).some(function (k) { return err[k] && f(err[k]); })));
        }
        Util.isError = isError;
        function getErrorInfo(err) {
            var res = undefined;
            if (err) {
                if (err.constructor && err.code != undefined)
                    res = err.constructor.name + " code " + err.code + ": " + err.message;
                else if (err.name)
                    res = err.name;
                else if (typeof err == "object")
                    Object.keys(err).forEach(function (k) {
                        if (res == undefined)
                            res = getErrorInfo(err[k]);
                    });
                if (err.databaseOrigin)
                    res += "; origin: " + err.databaseOrigin;
            }
            return res;
        }
        Util.getErrorInfo = getErrorInfo;
        function reportError(ctx, err, fatal) {
            if (fatal === void 0) { fatal = true; }
            if (TDev.Runtime.handleUserError(err))
                return;
            var bug = TDev.Ticker.mkBugReport(err, ctx);
            var willReload = fatal;
            var lastBugReload = window.localStorage["lastBugReload"];
            if (lastBugReload && now() - lastBugReload < 30 * 1000)
                willReload = false;
            if (now() - Util.startupTime < 30 * 1000)
                willReload = false;
            if (TDev.dbg)
                willReload = false;
            if (isError(err, function (e) { return e.isNetworkError; })) {
                willReload = false;
                if (err && err.status === 424)
                    TDev.HTML.showProgressNotification(lf("we're having problems, try again later..."));
                else {
                    TDev.HTML.showProgressNotification(lf("we're having network problems..."));
                    return;
                }
            }
            var hashBug = TDev.Ticker.bugReportForHash(bug);
            var lastTime = recentBugReports[hashBug];
            if (lastTime && now() - lastTime < 5 * 60 * 1000) {
            }
            else {
                sendErrorReport(bug, willReload);
                if (Object.keys(recentBugReports).length > 30)
                    recentBugReports = {};
                recentBugReports[hashBug] = now();
            }
            if (isError(err, function (e) { return e.isDatabaseError; })) {
                if (false) {
                    var m = TDev.ModalDialog.info("", "");
                }
                if (!willReload) {
                    Util.navigateInWindow(window.errorUrl + "#storage," + encodeURIComponent(getErrorInfo(err)));
                    return;
                }
            }
            if (willReload && !TDev.Storage.showTemporaryWarning()) {
                try {
                    TDev.ProgressOverlay.show(lf("Whoops! Something went wrong."));
                    TDev.ProgressOverlay.setProgress("");
                    TDev.ProgressOverlay.setAddInfo([
                        TDev.div(null, lf("We're reloading the page.")),
                        TDev.div("item-subtle", lf("Technical information: {0}", bug.exceptionMessage || "None"))
                    ]);
                }
                catch (e) {
                    debugger;
                }
                Util.setTimeout(3000, function () {
                    window.location.reload();
                });
                return;
            }
            try {
                if (fatal || TDev.dbg) {
                    var msgText = Util.formatText(TDev.dbg ? bug.exceptionMessage : "Something went wrong; please reload the webpage.");
                    var dmsg = TDev.div("errorNotification");
                    TDev.Browser.setInnerHTML(dmsg, msgText);
                    TDev.elt("root").appendChild(dmsg);
                    Util.setTimeout(5000, function () {
                        dmsg.removeSelf();
                    });
                }
            }
            catch (e) {
                debugger;
            }
        }
        Util.reportError = reportError;
        function catchErrors(ctx, f) {
            return function () {
                if (Util.eventLogging)
                    Util.log("catching errors in " + ctx);
                try {
                    return f.apply(this, arguments);
                }
                catch (e) {
                    if (TDev.Browser.isHeadless)
                        TDev.Promise.errorHandler(ctx, e);
                    else
                        reportError(ctx, e);
                    return undefined;
                }
            };
        }
        Util.catchErrors = catchErrors;
        function setTimeout(ms, cb) {
            if (ms == 0 && zeroTimeoutFunctions) {
                setZeroTimeout(cb);
                return -1;
            }
            else {
                return window.setTimeout(function () {
                    if (Util.eventLogging)
                        Util.log("executing timeout " + ms + " / " + cb.toString());
                    try {
                        cb();
                    }
                    catch (err) {
                        Util.reportError("timeout-" + ms + "-" + cb.toString(), err);
                    }
                }, ms);
            }
        }
        Util.setTimeout = setTimeout;
        var FNV1_prime_32 = 16777619;
        var FNV1_basis_32 = 2166136261 | 0;
        function toUTF16LE(str) {
            var res = "";
            if (!str)
                return res;
            for (var i = 0; i < str.length; ++i) {
                var code = str.charCodeAt(i);
                res += String.fromCharCode(code & 0xff);
                res += String.fromCharCode((code >> 8) & 0xff);
            }
            return res;
        }
        Util.toUTF16LE = toUTF16LE;
        function fromUTF8Bytes(binstr) {
            if (!binstr)
                return "";
            var escaped = "";
            for (var i = 0; i < binstr.length; ++i) {
                var k = binstr[i] & 0xff;
                if (k == 37 || k > 0x7f) {
                    escaped += "%" + k.toString(16);
                }
                else {
                    escaped += String.fromCharCode(k);
                }
            }
            return decodeURIComponent(escaped);
        }
        Util.fromUTF8Bytes = fromUTF8Bytes;
        function fromUTF8(binstr) {
            if (!binstr)
                return "";
            var escaped = "";
            for (var i = 0; i < binstr.length; ++i) {
                var k = binstr.charCodeAt(i) & 0xff;
                if (k == 37 || k > 0x7f) {
                    escaped += "%" + k.toString(16);
                }
                else {
                    escaped += binstr.charAt(i);
                }
            }
            return decodeURIComponent(escaped);
        }
        Util.fromUTF8 = fromUTF8;
        function toUTF8(str) {
            var res = "";
            if (!str)
                return res;
            for (var i = 0; i < str.length; ++i) {
                var code = str.charCodeAt(i);
                if (code <= 0x7f)
                    res += str.charAt(i);
                else if (code <= 0x7ff) {
                    res += String.fromCharCode(0xc0 | (code >> 6), 0x80 | (code & 0x3f));
                }
                else {
                    if (0xd800 <= code && code <= 0xdbff) {
                        var next = str.charCodeAt(++i);
                        if (!isNaN(next))
                            code = 0x10000 + ((code - 0xd800) << 10) + (next - 0xdc00);
                    }
                    if (code <= 0xffff)
                        res += String.fromCharCode(0xe0 | (code >> 12), 0x80 | ((code >> 6) & 0x3f), 0x80 | (code & 0x3f));
                    else
                        res += String.fromCharCode(0xf0 | (code >> 18), 0x80 | ((code >> 12) & 0x3f), 0x80 | ((code >> 6) & 0x3f), 0x80 | (code & 0x3f));
                }
            }
            return res;
        }
        Util.toUTF8 = toUTF8;
        function intMult(a, b) {
            return (((a & 0xffff) * (b >>> 16) + (b & 0xffff) * (a >>> 16)) << 16) + ((a & 0xffff) * (b & 0xffff));
        }
        Util.intMult = intMult;
        function getStableHashCodeBytes(bytes) {
            var hc = FNV1_basis_32;
            if (bytes) {
                for (var i = 0; i < bytes.length; ++i)
                    hc = intMult(hc, FNV1_prime_32) ^ bytes.charCodeAt(i);
            }
            return hc;
        }
        Util.getStableHashCodeBytes = getStableHashCodeBytes;
        function getStableHashCode(str) {
            return getStableHashCodeBytes(toUTF16LE(str));
        }
        Util.getStableHashCode = getStableHashCode;
        function isntNull(o) {
            return o !== null && o !== undefined;
        }
        Util.isntNull = isntNull;
        function capitalizeFirst(s) {
            return s.slice(0, 1).toUpperCase() + s.slice(1);
        }
        Util.capitalizeFirst = capitalizeFirst;
        function tagify(name) {
            return name.replace(/([^a-zA-Z0-9])([a-z])/g, function (m, a, b) { return a + b.toUpperCase(); }).replace(/[^a-zA-Z0-9]/g, "");
        }
        Util.tagify = tagify;
        function toHashTag(name) {
            return "#" + tagify(name);
        }
        Util.toHashTag = toHashTag;
        function getHashTags(s) {
            var r = [];
            s.replace(/#(\w+)/g, function (m, h) {
                r.push(h);
                return "";
            });
            return r;
        }
        Util.getHashTags = getHashTags;
        function jsStringQuote(s) {
            return s.replace(/[^A-Z0-9a-z .!?_\-$]/g, function (c) {
                var h = c.charCodeAt(0).toString(16);
                return "\\u" + "0000".substr(0, 4 - h.length) + h;
            });
        }
        Util.jsStringQuote = jsStringQuote;
        function jsStringLiteral(s) {
            return "\"" + jsStringQuote(s) + "\"";
        }
        Util.jsStringLiteral = jsStringLiteral;
        function canvasToBlob(canvas, blobName) {
            if (blobName === void 0) { blobName = null; }
            if (canvas.mozGetAsFile) {
                var blob = canvas.mozGetAsFile(blobName || 'img.png', 'image/png');
                return blob;
            }
            if (canvas.msToBlob)
                return canvas.msToBlob();
            var dataUrl = canvas.toDataURL('image/png');
            var bytes = decodeDataURL(dataUrl, 'image/png');
            try {
                var blob = new Blob([bytes], { type: 'image/png' });
                return blob;
            }
            catch (e) {
                return null;
            }
        }
        Util.canvasToBlob = canvasToBlob;
        function stringCompare(an, bn) {
            if (an == bn)
                return 0;
            if (an < bn)
                return -1;
            return 1;
        }
        Util.stringCompare = stringCompare;
        function nameCompare(a, b) {
            return stringCompare(a.getName(), b.getName());
        }
        Util.nameCompare = nameCompare;
        function jsonClone(obj) {
            return JSON.parse(JSON.stringify(obj));
        }
        Util.jsonClone = jsonClone;
        function jsonCopyFrom(trg, src) {
            var v = jsonClone(src);
            Object.keys(src).forEach(function (k) {
                trg[k] = v[k];
            });
        }
        Util.jsonCopyFrom = jsonCopyFrom;
        function clone(obj) {
            var r = new obj.constructor;
            for (var k in obj) {
                if (obj.hasOwnProperty(k))
                    r[k] = obj[k];
            }
            return r;
        }
        Util.clone = clone;
        function chopArray(arr, chunkSize) {
            var res = [];
            for (var i = 0; i < arr.length; i += chunkSize)
                res.push(arr.slice(i, i + chunkSize));
            return res;
        }
        Util.chopArray = chopArray;
        function unique(arr, f) {
            var v = [];
            var r = {};
            arr.forEach(function (e) {
                var k = f(e);
                if (!r.hasOwnProperty(k)) {
                    r[k] = null;
                    v.push(e);
                }
            });
            return v;
        }
        Util.unique = unique;
        function groupBy(arr, f) {
            var r = {};
            arr.forEach(function (e) {
                var k = f(e);
                if (!r.hasOwnProperty(k))
                    r[k] = [];
                r[k].push(e);
            });
            return r;
        }
        Util.groupBy = groupBy;
        function toDictionary(arr, f) {
            var r = {};
            arr.forEach(function (e) {
                r[f(e)] = e;
            });
            return r;
        }
        Util.toDictionary = toDictionary;
        function toArray(a) {
            var r = [];
            for (var i = 0; i < a.length; ++i)
                r.push(a[i]);
            return r;
        }
        Util.toArray = toArray;
        function indexOfMatching(arr, f) {
            for (var i = 0; i < arr.length; ++i)
                if (f(arr[i]))
                    return i;
            return -1;
        }
        Util.indexOfMatching = indexOfMatching;
        function memoize(f) {
            var cache = {};
            return function (s) {
                if (cache.hasOwnProperty(s))
                    return cache[s];
                return (cache[s] = f(s));
            };
        }
        Util.memoize = memoize;
        function memoizeHashed(h, f) {
            var cache = {};
            return function (e) {
                var s = h(e);
                if (cache.hasOwnProperty(s))
                    return cache[s];
                return (cache[s] = f(e));
            };
        }
        Util.memoizeHashed = memoizeHashed;
        function even(arr) {
            var r = [];
            for (var i = 0; i < arr.length; i += 2)
                r.push(arr[i]);
            return r;
        }
        Util.even = even;
        function odd(arr) {
            var r = [];
            for (var i = 1; i < arr.length; i += 2)
                r.push(arr[i]);
            return r;
        }
        Util.odd = odd;
        function repeatString(s, n) {
            return Array(n + 1).join(s);
        }
        Util.repeatString = repeatString;
        function numberToStringNoE(v) {
            var s = v.toString();
            var m = /^([+\-])?(\d)(\.(\d*))?[eE]([+\-])?(\d+)$/.exec(s);
            if (!m)
                return s;
            var sign = m[1] || "";
            var pref = m[2];
            var suff = m[4] || "";
            var esign = m[5];
            var exp = parseInt(m[6]);
            if (esign == "-") {
                return sign + "0." + repeatString("0", exp - 1) + pref + suff;
            }
            else {
                var add = exp - suff.length;
                if (add < 0) {
                    return sign + pref + suff.slice(0, exp) + "." + suff.slice(add);
                }
                else {
                    return sign + pref + suff + repeatString("0", add);
                }
            }
        }
        Util.numberToStringNoE = numberToStringNoE;
        function msSubtract(a, b) {
            var r = {};
            Object.keys(a).forEach(function (k) {
                var d = 0;
                if (b.hasOwnProperty(k))
                    d = b[k];
                var n = a[k] - d;
                if (n > 0)
                    r[k] = n;
            });
            return r;
        }
        Util.msSubtract = msSubtract;
        function msAdd(a, b) {
            var r = {};
            Object.keys(a).forEach(function (k) {
                var d = 0;
                if (b.hasOwnProperty(k))
                    d = b[k];
                r[k] = a[k] + d;
            });
            Object.keys(b).forEach(function (k) {
                if (!a.hasOwnProperty(k))
                    r[k] = b[k];
            });
            return r;
        }
        Util.msAdd = msAdd;
        function setAdd(a, b) {
            var r = {};
            Object.keys(a).forEach(function (v) { return r[v] = true; });
            Object.keys(b).forEach(function (v) { return r[v] = true; });
            return r;
        }
        Util.setAdd = setAdd;
        function setAddTo(a, b) {
            Object.keys(b).forEach(function (v) { return a[v] = true; });
        }
        Util.setAddTo = setAddTo;
        function setIntersect(a, b) {
            var r = {};
            Object.keys(a).forEach(function (v) {
                if (b.hasOwnProperty(v))
                    r[v] = true;
            });
            return r;
        }
        Util.setIntersect = setIntersect;
        Util.onSetHash;
        Util.onGoBack;
        function setHash(s, replace) {
            if (replace === void 0) { replace = false; }
            Util.log("navigate " + s);
            s = s.replace(/^#/, "");
            Util.setTimeout(1, function () { return Util.onSetHash(s, replace); });
        }
        Util.setHash = setHash;
        function goBack() {
            Util.onGoBack();
        }
        Util.goBack = goBack;
        function toFileName(name, defaultName) {
            name = name || "";
            var filename = name.replace(/[^\w]+/g, " ").trim().replace(/ /g, "-") || defaultName;
            if (!/^\w/.test(filename))
                filename = "_" + filename;
            return filename;
        }
        Util.toFileName = toFileName;
        function mkAbsoluteUrl(relativeUrl) {
            return TDev.Ticker.mainJsName.replace(/main.js$/, "") + relativeUrl;
        }
        Util.mkAbsoluteUrl = mkAbsoluteUrl;
        function localStore(key, data) {
            if (!data)
                window.localStorage.removeItem(key);
            else
                window.localStorage.setItem(key, data);
        }
        Util.localStore = localStore;
        Util.translationDebug = false;
        Util.translations = {};
        function enableTranslationTracking(local) {
            if (local === void 0) { local = false; }
            translationTracker = {};
            if (local) {
                translationScheduled = true;
                Util.localTranslationTracking = true;
            }
        }
        Util.enableTranslationTracking = enableTranslationTracking;
        function dumpTranslationFreqs() {
            var lst = Object.keys(translationTracker);
            lst.sort(function (a, b) { return translationTracker[b] - translationTracker[a]; });
            var words = 0;
            var str = "";
            lst.forEach(function (e) {
                words += e.split(/\s+/).filter(function (s) { return !!s; }).length;
                str += JSON.stringify(e).slice(1).replace(/"$/, "") + "\n";
            });
            str = "# words: " + words + ", texts: " + lst.length + "\n" + str;
            return str;
        }
        Util.dumpTranslationFreqs = dumpTranslationFreqs;
        var translationTracker;
        var lastTranslationUpload = 0;
        var translationScheduled = false;
        var translationSending = false;
        Util.translationToken = "";
        Util.localTranslationTracking = false;
        function scheduleTranslations() {
            translationScheduled = true;
            Util.setTimeout(10000, function () {
                translationScheduled = false;
                translationSending = true;
                var toSend = translationTracker;
                translationTracker = {};
                Util.httpPostRealJsonAsync("https://touchdeveloptranslator.azurewebsites.net/api/Svc/submit", {
                    freqs: toSend,
                    lang: getTranslationLanguage(),
                    token: Util.translationToken,
                }).done(function (resp) {
                    translationSending = false;
                    if (Object.keys(translationTracker).length > 0 && !translationScheduled)
                        scheduleTranslations();
                }, function (err) {
                });
            });
        }
        function _localize(msg, account) {
            if (translationTracker && account) {
                translationTracker[msg] = (translationTracker[msg] || 0) + 1;
                if (!translationScheduled && !translationSending)
                    scheduleTranslations();
            }
            if (Util.translations.hasOwnProperty(msg))
                return Util.translations[msg];
            return msg;
        }
        Util._localize = _localize;
        Util._languageData;
        var translationLang = null;
        function seeTranslatedText(value) {
            if (value !== undefined) {
                if (!value)
                    window.localStorage.setItem("skipTranslatedText", "1");
                else
                    window.localStorage.removeItem("skipTranslatedText");
                return !value;
            }
            else {
                return !window.localStorage.getItem("skipTranslatedText");
            }
        }
        Util.seeTranslatedText = seeTranslatedText;
        function getTranslationLanguage() {
            return translationLang;
        }
        Util.getTranslationLanguage = getTranslationLanguage;
        Util.sForPlural = true;
        function loadUserLanguageSetting() {
            var ln = getUserLanguageSetting();
            if (ln) {
                setTranslationLanguage(ln);
                return true;
            }
            else
                return false;
        }
        Util.loadUserLanguageSetting = loadUserLanguageSetting;
        function getUserLanguageSetting() {
            return window.localStorage.getItem("userLocale") || "";
        }
        Util.getUserLanguageSetting = getUserLanguageSetting;
        function setUserLanguageSetting(culture, reloadIfNeeded) {
            if (reloadIfNeeded === void 0) { reloadIfNeeded = false; }
            var locale = culture || "";
            var currentLocale = getUserLanguageSetting();
            if (currentLocale != locale) {
                window.localStorage.setItem("userLocale", locale);
                seeTranslatedText(true);
                if (reloadIfNeeded && !TDev.Storage.temporary)
                    Util.setTimeout(500, function () { return window.location.reload(); });
            }
        }
        Util.setUserLanguageSetting = setUserLanguageSetting;
        function setTranslationLanguage(ln) {
            var m = /^([a-z]{2,})(-([a-z]{2,}))$/i.exec(ln);
            if (m) {
                ln = m[1].toLowerCase();
                if (m[2])
                    ln += '-' + m[3].toUpperCase();
            }
            var ln2 = ln.slice(0, 2);
            if (ln2 == "zh") {
                if (ln == "zh-TW" || ln == "zh-HK")
                    ln = "zh-CHT";
                else
                    ln = "zh-CHS";
            }
            if (TDev.Cloud.config.primaryLocale.slice(0, 2) == ln) {
                ln = TDev.Cloud.config.primaryLocale;
            }
            Util.sForPlural = ln2 == "en" || ln2 == "es" || ln2 == "pt" || ln2 == "de" || ln2 == "fr";
            Util.translations = {};
            translationLang = ln2;
            if (Util._languageData) {
                if (Util._languageData(ln))
                    translationLang = ln;
                else
                    Util._languageData(ln2);
            }
        }
        Util.setTranslationLanguage = setTranslationLanguage;
        function setTranslationTable(tr) {
            Util.translations = tr;
        }
        Util.setTranslationTable = setTranslationTable;
        function _setLanguageArray(keys, trans) {
            Util.translations = {};
            trans.forEach(function (t, i) {
                if (t)
                    Util.translations[keys[i]] = t;
            });
        }
        Util._setLanguageArray = _setLanguageArray;
    })(Util = TDev.Util || (TDev.Util = {}));
    var numStatic = 1;
    function lf_static(format, account) {
        if (Util.translationDebug)
            return Util._localize(format, account).toUpperCase();
        else
            return Util._localize(format, account);
    }
    TDev.lf_static = lf_static;
    function lf_va(format, args) {
        var lfmt = Util._localize(format, true);
        if (!Util.sForPlural && lfmt != format && /\d:s\}/.test(lfmt)) {
            lfmt = lfmt.replace(/\{\d+:s\}/g, "");
        }
        if (Util.translationDebug)
            return Util.fmt_va(lfmt, args).toUpperCase();
        else
            return Util.fmt_va(lfmt, args);
    }
    TDev.lf_va = lf_va;
    function lf(format) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        return lf_va(format, args);
    }
    TDev.lf = lf;
    var Lock = (function () {
        function Lock() {
            this.waiting = [];
            this.acquired = false;
        }
        Lock.prototype.acquire = function (f) {
            if (this.acquired) {
                this.waiting.push(f);
            }
            else {
                this.acquired = true;
                f();
            }
        };
        Lock.prototype.release = function () {
            Util.assert(this.acquired);
            if (this.waiting.length > 0) {
                var f = this.waiting.shift();
                f();
            }
            else {
                this.acquired = false;
            }
        };
        return Lock;
    })();
    TDev.Lock = Lock;
    var RefreshTimer = (function () {
        function RefreshTimer(interval, callback) {
            this.interval = interval;
            this.callback = callback;
            this.tick = 0;
        }
        RefreshTimer.prototype.restart = function () {
            var _this = this;
            this.tick++;
            var tick0 = this.tick;
            Util.setTimeout(this.interval, function () {
                if (tick0 == _this.tick) {
                    _this.callback();
                }
            });
        };
        return RefreshTimer;
    })();
    TDev.RefreshTimer = RefreshTimer;
    var KeyboardAutoUpdate = (function () {
        function KeyboardAutoUpdate(read, update) {
            this.read = read;
            this.update = update;
            this.version = 0;
            this.lastValue = null;
            this.updateValue = null;
            this.delay = TDev.Browser.isDesktop ? 300 : TDev.Browser.isCellphone ? 800 : 500;
        }
        KeyboardAutoUpdate.createInput = function (placeholder, update) {
            var up = KeyboardAutoUpdate.mkInput(TDev.HTML.mkTextInput("text", placeholder), update);
            up.attach();
            return up;
        };
        KeyboardAutoUpdate.mkInput = function (textbox, update) {
            var kb = new KeyboardAutoUpdate(function () { return textbox.value; }, update);
            kb.element = textbox;
            return kb;
        };
        KeyboardAutoUpdate.mkTextArea = function (textbox, update) {
            var kb = new KeyboardAutoUpdate(function () { return textbox.value; }, update);
            kb.element = textbox;
            return kb;
        };
        KeyboardAutoUpdate.prototype.attach = function () {
            var _this = this;
            Util.onInputChange(this.element, function () { return _this.keypress(); });
        };
        KeyboardAutoUpdate.prototype.keypress = function () {
            var _this = this;
            var searchValue = this.read();
            if (searchValue == this.lastValue)
                return;
            var v = ++this.version;
            this.lastValue = searchValue;
            if (!this.update)
                return;
            if (this.delay <= 0) {
                this.update(searchValue);
            }
            else {
                Util.setTimeout(this.delay, function () {
                    if (v == _this.version && _this.update && searchValue == _this.read()) {
                        _this.update(searchValue);
                    }
                });
            }
        };
        KeyboardAutoUpdate.prototype.resultsCurrent = function (s) {
            return this.read() == s;
        };
        return KeyboardAutoUpdate;
    })();
    TDev.KeyboardAutoUpdate = KeyboardAutoUpdate;
    var CsvParser = (function () {
        function CsvParser() {
            this.m_pos = 0;
            this.m_line = 1;
            this.m_col = 1;
            this.space = ' '.charCodeAt(0);
            this.comma = ','.charCodeAt(0);
            this.semiColumn = ';'.charCodeAt(0);
            this.doubleQuote = '"'.charCodeAt(0);
            this.cr = '\r'.charCodeAt(0);
            this.lf = '\n'.charCodeAt(0);
            this.tab = '\t'.charCodeAt(0);
            this.dot = '.'.charCodeAt(0);
            this.backwack = '\\'.charCodeAt(0);
        }
        CsvParser.prototype.parse = function (text, separator) {
            if (!text)
                return null;
            this.m_text = text;
            this.m_errors = [];
            this.file = { headers: [], records: [] };
            this.m_pos = 0;
            this.m_line = 1;
            this.m_col = 1;
            this.m_separator = (separator) ? separator.charCodeAt(0) : 0;
            try {
                if (!this.parseHeader())
                    return null;
                if (this.atEnd())
                    return this.file;
                this.parseRecords();
                return this.file;
            }
            catch (e) {
                return null;
            }
        };
        CsvParser.prototype.atEnd = function () {
            return this.m_text.length == this.m_pos;
        };
        CsvParser.prototype.peek = function () {
            if (this.atEnd())
                return -1;
            return this.m_text.charCodeAt(this.m_pos);
        };
        CsvParser.prototype.read = function () {
            if (this.atEnd()) {
                this.fail("end of file.");
                throw new Error();
            }
            if (this.m_text.charCodeAt(this.m_pos) === this.lf) {
                this.m_line++;
                this.m_col = 1;
            }
            return this.m_text.charCodeAt(this.m_pos++);
        };
        CsvParser.prototype.expected = function (expectedToken) {
            this.fail("expecting: " + expectedToken);
        };
        CsvParser.prototype.fail = function (message) {
            this.m_errors.push({ line: this.m_line, column: this.m_col, message: message });
        };
        CsvParser.prototype.parseHeader = function () {
            var firstName = this.parseField();
            if (firstName == null)
                return false;
            this.file.headers.push(firstName);
            this.inferSeparator();
            while (this.peek() === this.m_separator) {
                if (!this.parseSeparator())
                    return false;
                var nextName = this.parseField();
                if (nextName == null)
                    return false;
                this.file.headers.push(nextName);
            }
            return this.parseCRLF();
        };
        CsvParser.prototype.inferSeparator = function () {
            if (this.m_separator == 0 && !this.atEnd()) {
                var c = this.peek();
                if (c == this.comma || c == this.semiColumn || c == this.tab)
                    this.m_separator = c;
            }
        };
        CsvParser.prototype.parseSeparator = function () {
            var c = this.read();
            if (c != this.m_separator) {
                this.expected(String.fromCharCode(this.m_separator));
                return false;
            }
            this.eatWhitespace();
            return true;
        };
        CsvParser.prototype.eatWhitespace = function () {
            while (!this.atEnd() && this.peek() == this.space)
                this.read();
        };
        CsvParser.prototype.parseCRLF = function () {
            this.eatWhitespace();
            this.eatCR();
            return this.parseLF();
        };
        CsvParser.prototype.parseLF = function () {
            var c = this.read();
            if (c != this.lf) {
                this.expected("<LF>");
                return false;
            }
            return true;
        };
        CsvParser.prototype.eatCR = function () {
            if (!this.atEnd() && this.peek() == this.cr)
                this.read();
        };
        CsvParser.prototype.parseRecords = function () {
            if (!this.parseRecord())
                return false;
            while (!this.atEnd()) {
                if (!this.parseCRLF())
                    return false;
                if (this.atEnd())
                    break;
                if (!this.parseRecord())
                    return false;
            }
            return true;
        };
        CsvParser.prototype.parseRecord = function () {
            var record = [];
            var firstField = this.parseField();
            if (firstField == null)
                return false;
            record.push(firstField);
            this.inferSeparator();
            while (!this.atEnd() && this.peek() === this.m_separator) {
                if (!this.parseSeparator())
                    return false;
                var nextField = this.parseField();
                if (nextField == null)
                    return false;
                record.push(nextField);
            }
            this.file.records.push(record);
            return true;
        };
        CsvParser.prototype.parseField = function () {
            if (this.peek() == this.doubleQuote)
                return this.parseEscaped();
            return this.parseNonescaped();
        };
        CsvParser.prototype.parseNonescaped = function () {
            var data = [];
            while (!this.atEnd() && !this.isSeparatorOrCRLF(this.peek())) {
                data.push(String.fromCharCode(this.read()));
            }
            return data.join('');
        };
        CsvParser.prototype.isSeparatorOrCRLF = function (val) {
            return val === this.m_separator || val === this.cr || val === this.lf;
        };
        CsvParser.isTextData = function (val) {
            return val == 0x20 || val == 0x21 || (val >= 0x23 && val <= 0x2b) || (val >= 0x2D && val <= 0x7e);
        };
        CsvParser.isEscaped = function (val) {
            return CsvParser.isTextData(val) || val == 0x2c || val == 0xD || val == 0xa;
        };
        CsvParser.prototype.parseEscaped = function () {
            var data = [];
            if (!this.parseDoubleQuote())
                return null;
            while (!this.atEnd()) {
                var c = this.read();
                if (c == this.doubleQuote) {
                    if (this.peek() == this.doubleQuote)
                        data.push(String.fromCharCode(this.read()));
                    else
                        break;
                }
                else if (c == this.backwack) {
                    if (this.peek() == this.doubleQuote)
                        data.push(String.fromCharCode(this.read()));
                }
                else
                    data.push(String.fromCharCode(c));
            }
            return data.join('');
        };
        CsvParser.prototype.parseDoubleQuote = function () {
            this.eatWhitespace();
            var c = this.read();
            if (c != this.doubleQuote) {
                this.expected("<DoubleQuote>");
                return false;
            }
            return true;
        };
        return CsvParser;
    })();
    TDev.CsvParser = CsvParser;
    var Set = (function () {
        function Set() {
            this._list = [];
        }
        Set.prototype.add = function (e) {
            if (!this.contains(e))
                this._list.push(e);
        };
        Set.prototype.contains = function (e) {
            return this._list.indexOf(e) >= 0;
        };
        Set.prototype.elts = function () {
            return this._list;
        };
        Set.prototype.length = function () {
            return this._list.length;
        };
        return Set;
    })();
    TDev.Set = Set;
    var Lcs = (function () {
        function Lcs(equal, l1, l2) {
            this.equal = equal;
            this.l1 = l1;
            this.l2 = l2;
            this.table = [];
            for (var i = -1; i < l1.length; ++i)
                this.table[i] = [];
        }
        Lcs.prototype.lcs_m = function (i, j) {
            if (this.table[i][j] !== undefined) {
                return this.table[i][j];
            }
            else {
                var r = this.lcs_i(i, j);
                this.table[i][j] = r;
                return r;
            }
        };
        Lcs.prototype.lcs_i = function (i, j) {
            var c1 = this.l1[i];
            var c2 = this.l2[j];
            if (i == -1 || j == -1) {
                return [];
            }
            else if (this.equal(c1, c2)) {
                return this.lcs_m(i - 1, j - 1).concat([c1]);
            }
            else {
                var lcs1 = i > 0 ? this.lcs_m(i - 1, j) : [];
                var lcs2 = j > 0 ? this.lcs_m(i, j - 1) : [];
                return lcs1.length > lcs2.length ? lcs1 : lcs2;
            }
        };
        Lcs.prototype.lcs = function () {
            return this.lcs_i(this.l1.length - 1, this.l2.length - 1);
        };
        return Lcs;
    })();
    TDev.Lcs = Lcs;
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var Random;
    (function (Random) {
        var sha256_k = new Uint32Array([
            0x428a2f98,
            0x71374491,
            0xb5c0fbcf,
            0xe9b5dba5,
            0x3956c25b,
            0x59f111f1,
            0x923f82a4,
            0xab1c5ed5,
            0xd807aa98,
            0x12835b01,
            0x243185be,
            0x550c7dc3,
            0x72be5d74,
            0x80deb1fe,
            0x9bdc06a7,
            0xc19bf174,
            0xe49b69c1,
            0xefbe4786,
            0x0fc19dc6,
            0x240ca1cc,
            0x2de92c6f,
            0x4a7484aa,
            0x5cb0a9dc,
            0x76f988da,
            0x983e5152,
            0xa831c66d,
            0xb00327c8,
            0xbf597fc7,
            0xc6e00bf3,
            0xd5a79147,
            0x06ca6351,
            0x14292967,
            0x27b70a85,
            0x2e1b2138,
            0x4d2c6dfc,
            0x53380d13,
            0x650a7354,
            0x766a0abb,
            0x81c2c92e,
            0x92722c85,
            0xa2bfe8a1,
            0xa81a664b,
            0xc24b8b70,
            0xc76c51a3,
            0xd192e819,
            0xd6990624,
            0xf40e3585,
            0x106aa070,
            0x19a4c116,
            0x1e376c08,
            0x2748774c,
            0x34b0bcb5,
            0x391c0cb3,
            0x4ed8aa4a,
            0x5b9cca4f,
            0x682e6ff3,
            0x748f82ee,
            0x78a5636f,
            0x84c87814,
            0x8cc70208,
            0x90befffa,
            0xa4506ceb,
            0xbef9a3f7,
            0xc67178f2
        ]);
        function rotr(v, b) {
            return (v >>> b) | (v << (32 - b));
        }
        function sha256round(hs, w) {
            TDev.Util.assert(hs.length == 8);
            TDev.Util.assert(w.length == 64);
            for (var i = 16; i < 64; ++i) {
                var s0 = rotr(w[i - 15], 7) ^ rotr(w[i - 15], 18) ^ (w[i - 15] >>> 3);
                var s1 = rotr(w[i - 2], 17) ^ rotr(w[i - 2], 19) ^ (w[i - 2] >>> 10);
                w[i] = (w[i - 16] + s0 + w[i - 7] + s1) | 0;
            }
            var a = hs[0];
            var b = hs[1];
            var c = hs[2];
            var d = hs[3];
            var e = hs[4];
            var f = hs[5];
            var g = hs[6];
            var h = hs[7];
            for (var i = 0; i < 64; ++i) {
                var s1 = rotr(e, 6) ^ rotr(e, 11) ^ rotr(e, 25);
                var ch = (e & f) ^ (~e & g);
                var temp1 = (h + s1 + ch + sha256_k[i] + w[i]) | 0;
                var s0 = rotr(a, 2) ^ rotr(a, 13) ^ rotr(a, 22);
                var maj = (a & b) ^ (a & c) ^ (b & c);
                var temp2 = (s0 + maj) | 0;
                h = g;
                g = f;
                f = e;
                e = (d + temp1) | 0;
                d = c;
                c = b;
                b = a;
                a = (temp1 + temp2) | 0;
            }
            hs[0] += a;
            hs[1] += b;
            hs[2] += c;
            hs[3] += d;
            hs[4] += e;
            hs[5] += f;
            hs[6] += g;
            hs[7] += h;
        }
        function sha256buffer(buf) {
            var h = new Uint32Array(8);
            h[0] = 0x6a09e667;
            h[1] = 0xbb67ae85;
            h[2] = 0x3c6ef372;
            h[3] = 0xa54ff53a;
            h[4] = 0x510e527f;
            h[5] = 0x9b05688c;
            h[6] = 0x1f83d9ab;
            h[7] = 0x5be0cd19;
            var work = new Uint32Array(64);
            var chunkLen = 16 * 4;
            function addBuf(buf) {
                var end = buf.length - (chunkLen - 1);
                for (var i = 0; i < end; i += chunkLen) {
                    for (var j = 0; j < 16; j++) {
                        var off = (j << 2) + i;
                        work[j] = (buf[off] << 24) | (buf[off + 1] << 16) | (buf[off + 2] << 8) | buf[off + 3];
                    }
                    sha256round(h, work);
                }
            }
            addBuf(buf);
            var padSize = 64 - (buf.length + 9) % 64;
            if (padSize == 64)
                padSize = 0;
            var endPos = buf.length - (buf.length % chunkLen);
            var padBuf = new Uint8Array((buf.length - endPos) + 1 + padSize + 8);
            var dst = 0;
            while (endPos < buf.length)
                padBuf[dst++] = buf[endPos++];
            padBuf[dst++] = 0x80;
            while (padSize-- > 0)
                padBuf[dst++] = 0x00;
            var len = buf.length * 8;
            dst = padBuf.length;
            while (len > 0) {
                padBuf[--dst] = len & 0xff;
                len >>= 8;
            }
            addBuf(padBuf);
            var res = "";
            for (var i = 0; i < h.length; ++i)
                res += ("000000000" + h[i].toString(16)).slice(-8);
            return res.toLowerCase();
        }
        Random.sha256buffer = sha256buffer;
        function sha256string(s) {
            return sha256buffer(TDev.Util.stringToUint8Array(TDev.Util.toUTF8(s)));
        }
        Random.sha256string = sha256string;
        var RC4 = (function () {
            function RC4() {
                this.rc4_i = 0;
                this.rc4_j = 0;
                this.rc4_buf = new Uint8Array(256);
                for (var i = 0; i < 256; ++i)
                    this.rc4_buf[i] = i;
            }
            RC4.prototype.getBytes = function (arr) {
                var rc4_i = this.rc4_i;
                var rc4_j = this.rc4_j;
                var rc4_buf = this.rc4_buf;
                for (var i = 0; i < arr.length; ++i) {
                    rc4_i = (rc4_i + 1) & 0xff;
                    rc4_j = (rc4_j + rc4_buf[rc4_i]) & 0xff;
                    var tmp = rc4_buf[rc4_i];
                    var tmp2 = rc4_buf[rc4_j];
                    rc4_buf[rc4_i] = tmp2;
                    rc4_buf[rc4_j] = tmp;
                    arr[i] = rc4_buf[(tmp + tmp2) & 0xff];
                }
                this.rc4_i = rc4_i;
                this.rc4_j = rc4_j;
            };
            RC4.prototype.addEntropy = function (key) {
                var rc4_buf = this.rc4_buf;
                var j = 0;
                for (var i = 0; i < 256; ++i) {
                    j = (j + rc4_buf[i] + key[i % key.length]) & 0xff;
                    var tmp = rc4_buf[i];
                    rc4_buf[i] = rc4_buf[j];
                    rc4_buf[j] = tmp;
                }
                bytes(new Uint8Array(4096));
            };
            RC4.prototype.uniqueId = function (len) {
                if (len === void 0) { len = 24; }
                var buf = new Uint8Array(len);
                this.getBytes(buf);
                var r = "";
                for (var i = 0; i < buf.length; ++i)
                    r += RC4.idChars.charAt(buf[i] & 63);
                return r.replace(/^[0-9]/, "x");
            };
            RC4.idChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz012345678942";
            return RC4;
        })();
        Random.RC4 = RC4;
        var rc4;
        var saveScheduled = false;
        var u32_8;
        var u32_32;
        Random.strongEntropySource = null;
        function addEntropy(key) {
            rc4.addEntropy(key);
        }
        function scheduleSave() {
            if (saveScheduled || Random.strongEntropySource)
                return;
            saveScheduled = true;
            TDev.Util.setTimeout(1000, function () {
                saveScheduled = false;
                saveState();
            });
        }
        function setup() {
            if (rc4)
                return;
            rc4 = new RC4();
            u32_8 = new Uint8Array(4);
            u32_32 = new Uint32Array(u32_8.buffer);
            var key = new Uint8Array(64);
            for (var i = 0; i < key.length; ++i)
                key[i] = (Math.random() * 0x100) & 0xff;
            addEntropy(key);
            var needsMoreEntropy = true;
            var wc = window.crypto;
            try {
                if (wc && wc.getRandomValues) {
                    wc.getRandomValues(key);
                    addEntropy(key);
                    needsMoreEntropy = false;
                }
            }
            catch (exn) {
            }
            if (needsMoreEntropy) {
                if (Random.strongEntropySource) {
                    Random.strongEntropySource(key);
                    addEntropy(key);
                }
                else {
                    addEntropy64(window.localStorage["entropy"]);
                    if (!window.localStorage["gotCloudEntropy"])
                        TDev.Util.setTimeout(1000, function () {
                            if (!window.localStorage["gotCloudEntropy"])
                                TDev.Cloud.getRandomAsync().done(addCloudEntropy, function (err) {
                                });
                        });
                }
            }
            scheduleSave();
        }
        function bytes(arr) {
            setup();
            bytes_internal(arr);
            scheduleSave();
        }
        Random.bytes = bytes;
        function bytes_internal(arr) {
            rc4.getBytes(arr);
        }
        function uint32() {
            setup();
            bytes_internal(u32_8);
            scheduleSave();
            return u32_32[0];
        }
        Random.uint32 = uint32;
        var m32 = 1 / 0x100000000;
        var m64 = 1 / 0x10000000000000000;
        function normalized() {
            return uint32() * m32 + uint32() * m64;
        }
        Random.normalized = normalized;
        function saveState() {
            setup();
            if (Random.strongEntropySource)
                return;
            var state = new Uint8Array(8 * 4);
            bytes_internal(state);
            window.localStorage["entropy"] = TDev.Util.base64EncodeBytes(state);
        }
        function addCloudEntropy(buf) {
            if (buf) {
                addEntropy64(buf);
                saveState();
                window.localStorage["gotCloudEntropy"] = "yes";
            }
        }
        Random.addCloudEntropy = addCloudEntropy;
        function addEntropy64(buf) {
            if (!buf)
                return;
            var strbuf = TDev.Util.base64Decode(buf);
            if (!strbuf)
                return;
            setup();
            addEntropy(TDev.Util.stringToUint8Array(strbuf));
            scheduleSave();
        }
        function uniqueId(len) {
            if (len === void 0) { len = 24; }
            setup();
            var r = rc4.uniqueId(len);
            scheduleSave();
            return r;
        }
        Random.uniqueId = uniqueId;
        function permute(arr) {
            for (var i = 0; i < arr.length; ++i) {
                var j = uint32() % arr.length;
                var tmp = arr[i];
                arr[i] = arr[j];
                arr[j] = tmp;
            }
        }
        Random.permute = permute;
        function pick(arr) {
            if (arr.length == 0)
                return null;
            return arr[uint32() % arr.length];
        }
        Random.pick = pick;
    })(Random = TDev.Random || (TDev.Random = {}));
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    (function (PromiseState) {
        PromiseState[PromiseState["Pending"] = 0] = "Pending";
        PromiseState[PromiseState["Success"] = 1] = "Success";
        PromiseState[PromiseState["Error"] = 2] = "Error";
    })(TDev.PromiseState || (TDev.PromiseState = {}));
    var PromiseState = TDev.PromiseState;
    var Promise = (function () {
        function Promise(init, _onNotify) {
            if (_onNotify === void 0) { _onNotify = undefined; }
            this._onNotify = _onNotify;
            this._listeners = [];
            this._state = 0 /* Pending */;
            if (!!init) {
                var promise = this;
                try {
                    init(function (v) {
                        if (promise._state != 0 /* Pending */) {
                            Promise.checkHandler("trying to resolve promise more than once");
                            return;
                        }
                        promise._value = v;
                        promise._state = 1 /* Success */;
                        promise._notifyListeners();
                    }, function (v) {
                        if (promise._state == 2 /* Error */) {
                            Promise.checkHandler("trying to resolve (error) promise more than once");
                            return;
                        }
                        promise._value = v || new Error("An error occured");
                        promise._state = 2 /* Error */;
                        promise._notifyListeners();
                    }, undefined);
                }
                catch (err) {
                    Promise.errorHandler("promiseCtor", err);
                }
            }
        }
        Promise.prototype._notify = function (l) {
            if (this._value instanceof Promise) {
                var p = this._value;
                if (!!p._state)
                    p._notify(l);
                else
                    p._listeners.push(l);
            }
            else
                l._onNotify(this);
        };
        Promise.prototype.isPending = function () {
            return this._state == 0 /* Pending */;
        };
        Promise.prototype._notifyListeners = function () {
            var _this = this;
            this._listeners.forEach(function (p) { return _this._notify(p); });
        };
        Promise.propagate = function (s, v, onSuccess, onError) {
            if (s === 1 /* Success */ && v instanceof Promise) {
                var q = v;
                if (!!q._state) {
                    v = q._value;
                    if (q._state == 2 /* Error */)
                        s = 2 /* Error */;
                }
                else {
                    q._listeners.push(new Promise(undefined, function () {
                        Promise.propagate(q._state, q._value, onSuccess, onError);
                    }));
                    return;
                }
            }
            if (s === 2 /* Error */)
                onError(v);
            else
                onSuccess(v);
        };
        Promise.prototype.then = function (onSuccess, onError, onProgress) {
            if (onError === void 0) { onError = undefined; }
            if (onProgress === void 0) { onProgress = undefined; }
            var onSuccess3;
            var onError3;
            var r = new Promise(function (onSuccess2, onError2, onProgress2) {
                onSuccess3 = onSuccess2;
                onError3 = onError2;
            }, function (p) {
                var v = p._value;
                var s = p._state;
                if (s === 2 /* Error */) {
                    if (!!onError)
                        try {
                            v = onError(v);
                            s = 1 /* Success */;
                        }
                        catch (e) {
                            v = e;
                            s = 2 /* Error */;
                        }
                }
                else {
                    if (!!onSuccess)
                        try {
                            v = onSuccess(v);
                            s = 1 /* Success */;
                        }
                        catch (e) {
                            v = e;
                            s = 2 /* Error */;
                        }
                }
                Promise.propagate(s, v, onSuccess3, onError3);
            });
            if (!!this._state)
                this._notify(r);
            else
                this._listeners.push(r);
            return r;
        };
        Promise.prototype.done = function (onSuccess, onError, onProgress) {
            if (onSuccess === void 0) { onSuccess = undefined; }
            if (onError === void 0) { onError = undefined; }
            if (onProgress === void 0) { onProgress = undefined; }
            this.then(onSuccess, onError, onProgress).then(undefined, function (e) {
                Promise.errorHandler("promiseDone", e);
            });
        };
        Promise.prototype.thenalways = function (onSuccessOrError, onProgress) {
            if (onProgress === void 0) { onProgress = undefined; }
            return this.then(onSuccessOrError, onSuccessOrError, onProgress);
        };
        Promise.is = function (v) {
            return v instanceof Promise;
        };
        Promise.as = function (v) {
            if (v === void 0) { v = undefined; }
            return v instanceof Promise ? v : Promise.wrap(v);
        };
        Promise.wrap = function (v) {
            if (v === void 0) { v = undefined; }
            return new Promise(function (onSuccess, onError, onProgress) {
                onSuccess(v);
            });
        };
        Promise.wrapError = function (v) {
            if (v === void 0) { v = undefined; }
            return new Promise(function (onSuccess, onError, onProgress) {
                onError(v);
            });
        };
        Promise.delay = function (ms, f) {
            if (f === void 0) { f = null; }
            return new Promise(function (onSuccess, onError, onProgress) {
                window.setTimeout(function () { return f ? f().then(function (v) { return onSuccess(v); }, function (e) { return onError(e); }, function (v) { return onProgress(v); }) : onSuccess(undefined); }, ms);
            });
        };
        Promise.join = function (values) {
            return new Promise(function (onSuccess, onError, onProgress) {
                var keys = Object.keys(values);
                var errors = Array.isArray(values) ? new Array(values.length) : {};
                var results = Array.isArray(values) ? new Array(values.length) : {};
                if (keys.length == 0) {
                    onSuccess(results);
                    return;
                }
                var missing = keys.length;
                var next = function () {
                    if (--missing == 0)
                        if (Object.keys(errors).length == 0)
                            onSuccess(results);
                        else
                            onError(errors);
                };
                keys.forEach(function (key) {
                    Promise.as(values[key]).then(function (v) {
                        results[key] = v;
                        next();
                    }, function (v) {
                        errors[key] = v;
                        next();
                    });
                });
            });
        };
        Promise.thenEach = function (values, onSuccess, onError, onProgress) {
            if (onSuccess === void 0) { onSuccess = undefined; }
            if (onError === void 0) { onError = undefined; }
            if (onProgress === void 0) { onProgress = undefined; }
            var result = Array.isArray(values) ? new Array(values.length) : {};
            Object.keys(values).forEach(function (key) {
                result[key] = Promise.as(values[key]).then(onSuccess, onError, onProgress);
            });
            return Promise.join(result);
        };
        Promise.sequentialMap = function (values, f) {
            return new Promise(function (onSuccess, onError, onProgress) {
                var keys = Object.keys(values);
                var results = Array.isArray(values) ? new Array(values.length) : {};
                function next(i) {
                    if (i >= keys.length) {
                        onSuccess(results);
                    }
                    else {
                        var key = keys[i];
                        try {
                            Promise.as(values[key]).done(function (x) {
                                Promise.as(f(x, key, results)).done(function (v) {
                                    results[key] = v;
                                    next(i + 1);
                                }, onError);
                            });
                        }
                        catch (e) {
                            onError(e);
                        }
                    }
                }
                next(0);
            });
        };
        Promise.errorHandler = function (ctx, err) {
            throw err;
        };
        Promise.checkHandler = function (msg) {
            Promise.errorHandler("promise-check", new Error(msg));
        };
        return Promise;
    })();
    TDev.Promise = Promise;
    var PromiseInv = (function (_super) {
        __extends(PromiseInv, _super);
        function PromiseInv() {
            var _this = this;
            _super.call(this, function (onSuccess, onError) {
                _this.success = onSuccess;
                _this.error = onError;
            });
        }
        PromiseInv.as = function (v) {
            if (v === void 0) { v = undefined; }
            var r = new PromiseInv();
            r.success(v);
            return r;
        };
        return PromiseInv;
    })(Promise);
    TDev.PromiseInv = PromiseInv;
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var Animation = (function () {
        function Animation(update) {
            var _this = this;
            this.update = update;
            this.running = false;
            this.beginValue = 0;
            this.delay = 0;
            this.endValue = 1;
            this.duration = 1000;
            this.frameLength = 30;
            this.beginTime = 0;
            this.quadratic = true;
            this.stepFn = function () {
                _this.step();
            };
        }
        Animation.prototype.begin = function () {
            var _this = this;
            var run = function () {
                _this.beginTime = new Date().getTime();
                _this.step();
            };
            this.running = true;
            if (this.delay > 0)
                window.setTimeout(run, this.delay);
            else
                run();
        };
        Animation.prototype.complete = function () {
            if (this.running) {
                this.running = false;
                this.update(this.endValue);
                if (!!this.completed)
                    this.completed();
            }
        };
        Animation.prototype.stop = function () {
            this.running = false;
        };
        Animation.prototype.step = function () {
            try {
                if (!this.running)
                    return;
                var now = new Date().getTime();
                if (now > this.beginTime + this.duration || TDev.Browser.noAnimations) {
                    this.complete();
                    return;
                }
                var phase = 1 - (now - this.beginTime) / this.duration;
                if (this.quadratic)
                    phase = (this.beginValue - this.endValue) * phase * phase + this.endValue;
                else
                    phase = (this.beginValue - this.endValue) * phase + this.endValue;
                this.update(phase);
                window.setTimeout(this.stepFn, this.frameLength);
            }
            catch (err) {
                TDev.Util.reportError("animation", err);
            }
        };
        Animation.fadeIn = function (elt, duration) {
            if (duration === void 0) { duration = 300; }
            var a = new Animation(function (v) {
                elt.style.opacity = v + "";
            });
            a.duration = duration;
            return a;
        };
        Animation.fadeOut = function (elt, duration) {
            if (duration === void 0) { duration = 300; }
            var a = new Animation(function (v) {
                if (v == 0)
                    elt.removeSelf();
                else
                    elt.style.opacity = v + "";
            });
            a.beginValue = 1;
            a.endValue = 0;
            a.duration = duration;
            return a;
        };
        return Animation;
    })();
    TDev.Animation = Animation;
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var ClickHandler = (function () {
        function ClickHandler(helt, f) {
            this.helt = helt;
            this.f = f;
            this.begX = 0;
            this.begY = 0;
            this.cleared = false;
            this.version = 0;
            this.mouseCaptureOverlay = document.body;
            this.setup();
        }
        ClickHandler.prototype.clickBegin = function (pos) {
            this.helt.setFlag("active", true);
            this.begX = pos.pageX;
            this.begY = pos.pageY;
            this.cleared = false;
            this.setupVersion();
        };
        ClickHandler.prototype.setupVersion = function () {
            var _this = this;
            var v = ++this.version;
            Util.setTimeout(300, function () {
                if (!_this.cleared && v == _this.version)
                    _this.clear();
            });
        };
        ClickHandler.prototype.onMove = function (e) {
            if (Math.abs(e.pageX - this.begX) > 10 || Math.abs(e.pageY - this.begY) > 10)
                this.clear();
        };
        ClickHandler.prototype.getPos = function (e) {
            if (!e.getPointerList)
                return { pageX: e.clientX, pageY: e.clientY };
            var pt = e.getPointerList()[0];
            return {
                pageX: pt.clientX,
                pageY: pt.clientY
            };
        };
        ClickHandler.prototype.skipIt = function (e) {
            var targ = e.target;
            if (e.target != e.currentTarget && (targ.nodeName == "INPUT" || targ.nodeName == "TEXTAREA"))
                return true;
            return false;
        };
        ClickHandler.prototype.isCanceled = function (e) {
            if (this.skipIt(e))
                return true;
            if (e.utilClickCancel)
                return true;
            e.utilClickCancel = true;
            return false;
        };
        ClickHandler.prototype.getPosition = function (element) {
            var xPosition = 0;
            var yPosition = 0;
            while (element) {
                xPosition += (element.offsetLeft - element.scrollLeft + element.clientLeft);
                yPosition += (element.offsetTop - element.scrollTop + element.clientTop);
                element = element.offsetParent;
            }
            return { x: xPosition, y: yPosition };
        };
        ClickHandler.prototype.handleEvent = function (e) {
            try {
                var ep = e;
                if (Util.mouseLogging) {
                    Util.log("executing click handler " + e.type + " on " + this.helt.id);
                    Util.log("pageX:{0} pageY:{1} offsetX:{2} offsetY:{3} clientX:{4} clientY:{5}", ep.pageX, ep.pageY, ep.offsetX, ep.offsetY, ep.clientX, ep.clientY);
                }
                if (ep.touches && ep.touches[0]) {
                    ep = ep.touches[0];
                }
                else if (ep.touches && ep.touches.item(0)) {
                    ep = ep.touches.item(0);
                }
                else if (ep.changedTouches && ep.changedTouches.item(0)) {
                    ep = ep.changedTouches.item(0);
                }
                if (Util.mouseLogging) {
                    Util.log("after touch adjustment");
                    var pos = this.getPosition(this.helt);
                    Util.log("pageX:{0} pageY:{1} offsetX:{2} offsetY:{3} clientX:{4} clientY:{5} eltX:{6} eltY:{7}", ep.pageX, ep.pageY, ep.offsetX, ep.offsetY, ep.clientX, ep.clientY, pos.x, pos.y);
                }
                switch (e.type) {
                    case "pointerdown":
                        if (this.isCanceled(e))
                            break;
                        this.prepareMouseOverlay();
                        this.clickBegin(this.getPos(e));
                        this.mouseCaptureOverlay.addEventListener("pointermove", this, false);
                        this.mouseCaptureOverlay.addEventListener("pointerup", this, false);
                        break;
                    case "MSPointerDown":
                        if (this.isCanceled(e))
                            break;
                        this.prepareMouseOverlay();
                        this.clickBegin(this.getPos(e));
                        this.mouseCaptureOverlay.addEventListener("MSPointerMove", this, false);
                        this.mouseCaptureOverlay.addEventListener("MSPointerUp", this, false);
                        break;
                    case "pointermove":
                    case "MSPointerMove":
                        if (!this.cleared)
                            this.onMove(this.getPos(e));
                        break;
                    case "pointerup":
                    case "MSPointerUp":
                        if (!this.cleared)
                            this.fireClick(e);
                        break;
                    case "touchstart":
                        if (this.isCanceled(e))
                            break;
                        this.helt.addEventListener("touchend", this, false);
                        document.body.addEventListener("touchmove", this, false);
                        document.body.addEventListener("touchend", this, false);
                        this.clickBegin(ep);
                        break;
                    case "touchmove":
                        if (!this.cleared)
                            this.onMove(ep);
                        break;
                    case "touchend":
                        if (!this.cleared)
                            this.fireClick(ep);
                        break;
                    case "mousedown":
                        if (this.isCanceled(e))
                            break;
                        if (e.button != 0)
                            break;
                        this.helt.hideFocus = true;
                        this.helt.addEventListener("mouseup", this, false);
                        document.addEventListener("mouseup", this, false);
                        document.body.addEventListener("mousemove", this, false);
                        this.clickBegin(e);
                        break;
                    case "mousemove":
                        if (!this.cleared)
                            this.onMove(e);
                        break;
                    case "mouseup":
                        if (!this.cleared)
                            this.fireClick(e);
                        break;
                    case "keypress":
                        var ke = e;
                        if (ke.target == this.helt && (ke.which == 13 || ke.which == 32)) {
                            this.f(e);
                        }
                        break;
                }
            }
            catch (err) {
                Util.reportError("clickHandler", err);
            }
        };
        ClickHandler.prototype.fireClick = function (e) {
            this.clear();
            var canc = e.clickCancelled;
            e.clickCancelled = true;
            if (!canc) {
                e.pgX = this.begX;
                e.pgY = this.begY;
                this.f(e);
            }
        };
        ClickHandler.prototype.clear = function () {
            this.hideMouseOverlay();
            this.cleared = true;
            this.hideMouseOverlay();
            this.helt.removeEventListener("touchend", this, false);
            this.helt.removeEventListener("mouseup", this, false);
            this.helt.setFlag("active", false);
            document.body.removeEventListener("touchmove", this, false);
            document.removeEventListener("mouseup", this, false);
            document.body.removeEventListener("mouseup", this, false);
            document.body.removeEventListener("mousemove", this, false);
            document.body.removeEventListener("touchend", this, false);
            this.mouseCaptureOverlay.removeEventListener("MSPointerMove", this, false);
            this.mouseCaptureOverlay.removeEventListener("MSPointerUp", this, false);
            this.mouseCaptureOverlay.removeEventListener("pointermove", this, false);
            this.mouseCaptureOverlay.removeEventListener("pointerup", this, false);
        };
        ClickHandler.prototype.prepareMouseOverlay = function () {
        };
        ClickHandler.prototype.hideMouseOverlay = function () {
        };
        ClickHandler.prototype.setup = function () {
            if (window.navigator.pointerEnabled)
                this.helt.addEventListener("pointerdown", this, false);
            else if (window.navigator.msPointerEnabled)
                this.helt.addEventListener("MSPointerDown", this, false);
            else if (TDev.Browser.touchStart)
                this.helt.addEventListener("touchstart", this, false);
            else
                this.helt.addEventListener("mousedown", this, false);
            this.helt.addEventListener("keypress", this, true);
        };
        ClickHandler.prototype.unhook = function () {
            this.helt.removeEventListener("MSPointerDown", this, false);
            this.helt.removeEventListener("touchstart", this, false);
            this.helt.removeEventListener("mousedown", this, false);
            this.helt.removeEventListener("keypress", this, true);
        };
        return ClickHandler;
    })();
    TDev.ClickHandler = ClickHandler;
    var Util;
    (function (Util) {
        function clickHandler(e, cb, allowSelect) {
            if (e) {
                e.setAttribute("role", "button");
                e.tabIndex = 0;
            }
            function newCb(e) {
                try {
                    return cb(e);
                }
                catch (err) {
                    Util.reportError("clickHandler " + cb.toString(), err);
                }
            }
            var oldH = e.clickHandler;
            if (oldH)
                oldH.unhook();
            var handler = new ClickHandler(e, newCb);
            e.clickHandler = handler;
            if (!allowSelect)
                e.onselectstart = function () {
                    return false;
                };
            else
                e.onselectstart = function (e) {
                    e.stopImmediatePropagation();
                    return true;
                };
        }
        Util.clickHandler = clickHandler;
        try {
            if (typeof HTMLElement != "undefined")
                HTMLElement.prototype.withClick = function (cb, allowSelect) {
                    Util.clickHandler(this, cb, allowSelect);
                    return this;
                };
        }
        catch (e) {
        }
    })(Util = TDev.Util || (TDev.Util = {}));
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var DragHandler = (function (_super) {
        __extends(DragHandler, _super);
        function DragHandler(helt, cb) {
            _super.call(this, helt, null);
            this.helt = helt;
            this.cb = cb;
            this.offX = 0;
            this.offY = 0;
            this.lockX = false;
            this.lockY = false;
            this.isTap = true;
            this.lastX = 0;
            this.lastY = 0;
            this.beginTime = 0;
            this.moveElt = true;
            this.isIeTouch = false;
            this.helt.style.msTouchAction = "none";
            this.helt.style.touchAction = "none";
        }
        DragHandler.prototype.setupVersion = function () {
        };
        DragHandler.prototype.clickBegin = function (pos) {
            _super.prototype.clickBegin.call(this, pos);
            this.offX = this.helt.offsetLeft - this.begX;
            this.offY = this.helt.offsetTop - this.begY;
            this.beginTime = TDev.Util.now();
            this.isTap = true;
            this.lastX = this.begX;
            this.lastY = this.begY;
            this.cb("drag", 0, 0, this.begX, this.begY);
        };
        DragHandler.prototype.onMove = function (pos) {
            this.lastX = pos.pageX;
            this.lastY = pos.pageY;
            if (this.lockX)
                this.lastX = this.begX;
            if (this.lockY)
                this.lastY = this.begY;
            if (this.moveElt) {
                this.helt.style.left = this.offX + this.lastX + "px";
                this.helt.style.top = this.offY + this.lastY + "px";
            }
            var dx = this.lastX - this.begX;
            var dy = this.lastY - this.begY;
            if (Math.abs(dx) > 10 || Math.abs(dy) > 10)
                this.isTap = false;
            this.cb("move", dx, dy, undefined, undefined);
        };
        DragHandler.prototype.fireClick = function (pos) {
            if (TDev.Util.now() - this.beginTime > 300)
                this.isTap = false;
            this.clear();
            this.cb("release", this.lastX - this.begX, this.lastY - this.begY, this.isTap, undefined);
        };
        DragHandler.prototype.prepareMouseOverlay = function () {
            if (this.isIeTouch)
                this.mouseCaptureOverlay = this.helt;
            else
                this.mouseCaptureOverlay = document.body;
        };
        DragHandler.prototype.hideMouseOverlay = function () {
        };
        DragHandler.prototype.handleEvent = function (e) {
            try {
                if (this.skipIt(e))
                    return;
                e.stopPropagation();
                e.preventDefault();
                this.isIeTouch = e.pointerType == 2;
                if (e.preventMouseEvent) {
                    e.preventMouseEvent();
                }
                if (e.preventManipulation) {
                    e.preventManipulation();
                }
                _super.prototype.handleEvent.call(this, e);
            }
            catch (err) {
                TDev.Util.reportError("dragHandler", err);
            }
        };
        return DragHandler;
    })(TDev.ClickHandler);
    TDev.DragHandler = DragHandler;
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var DragToScrollHandler = (function () {
        function DragToScrollHandler(helt) {
            this.helt = helt;
            this.posX = 0;
            this.posY = 0;
            this.theHistory = [];
            this.vertical = true;
            this.horizontal = false;
            this.seenTouchEvent = false;
            this.captureingMouse = false;
        }
        DragToScrollHandler.prototype.unhook = function () {
            var t = this;
            if (TDev.Browser.touchStart) {
                this.helt.removeEventListener("touchstart", t, false);
                this.helt.removeEventListener("touchmove", t, false);
                this.helt.removeEventListener("touchend", t, false);
            }
            else {
                this.helt.removeEventListener("mousedown", t, false);
                this.helt.removeEventListener("mouseup", t, false);
                this.helt.removeEventListener("mouseout", t, false);
                this.helt.removeEventListener("mouseleave", t, false);
                this.helt.removeEventListener("mousemove", t, false);
            }
        };
        DragToScrollHandler.prototype.init = function () {
            this.helt.dragToScroll = this;
            var t = this;
            if (TDev.Browser.touchStart) {
                this.helt.addEventListener("touchstart", t, false);
                this.helt.addEventListener("touchmove", t, false);
                this.helt.addEventListener("touchend", t, false);
            }
            else {
                this.helt.addEventListener("mousedown", t, false);
                this.helt.addEventListener("mouseup", t, false);
                this.helt.addEventListener("mouseout", t, false);
                this.helt.addEventListener("mouseleave", t, false);
                this.helt.addEventListener("mousemove", t, false);
            }
        };
        DragToScrollHandler.prototype.record = function (pos) {
            var n = new Date().getTime();
            this.theHistory.push({ x: pos.pageX, y: pos.pageY, t: n });
        };
        DragToScrollHandler.prototype.stopInertialAnimation = function () {
            if (!this.inertialAnimation)
                return;
            this.inertialAnimation.complete();
            this.inertialAnimation = null;
        };
        DragToScrollHandler.prototype.begin = function (pos) {
            this.posX = this.helt.scrollLeft + pos.pageX;
            this.posY = this.helt.scrollTop + pos.pageY;
            this.stopInertialAnimation();
            this.theHistory = [];
            this.record(pos);
        };
        DragToScrollHandler.prototype.scrollTo = function (x, y) {
            if (this.horizontal) {
                this.helt.scrollLeft = x;
            }
            if (this.vertical) {
                this.helt.scrollTop = y;
            }
        };
        DragToScrollHandler.prototype.move = function (pos) {
            this.scrollTo(this.posX - pos.pageX, this.posY - pos.pageY);
            this.record(pos);
        };
        DragToScrollHandler.prototype.log = function () {
            var n = new Date().getTime();
            var k = this.theHistory.slice(this.theHistory.length - 5).map(function (h) { return h.x + "," + h.y + "," + (h.t - n); }).join(" : ");
            Util.log(k);
        };
        DragToScrollHandler.prototype.end = function (pos) {
            var _this = this;
            if (!!pos)
                this.record(pos);
            if (this.theHistory.length == 0)
                return;
            var last = this.theHistory[this.theHistory.length - 1];
            var beg = last.t - 200;
            var first = last;
            for (var i = 0; i < this.theHistory.length; ++i) {
                if (this.theHistory[i].t >= beg) {
                    first = this.theHistory[i];
                    break;
                }
            }
            var dt = last.t - first.t;
            if (dt > 0) {
                var m = 150;
                var dx = (last.x - first.x) / dt * m;
                var dy = (last.y - first.y) / dt * m;
                var speed = Math.abs(dx) + Math.abs(dy);
                if (speed < 50)
                    return;
                this.inertialAnimation = new TDev.Animation(function (p) {
                    _this.scrollTo(_this.posX - (last.x + dx * p), _this.posY - (last.y + dy * p));
                });
                this.inertialAnimation.duration = 700;
                this.inertialAnimation.begin();
            }
        };
        DragToScrollHandler.prototype.handleEvent = function (e) {
            try {
                var now = new Date().getTime();
                switch (e.type) {
                    case "mousedown":
                        if (!this.seenTouchEvent && e.button == 0) {
                            this.captureingMouse = true;
                            this.begin(e);
                        }
                        break;
                    case "mousemove":
                        if (this.captureingMouse) {
                            this.move(e);
                        }
                        break;
                    case "mouseleave":
                        this.end(e);
                        this.captureingMouse = false;
                        break;
                    case "mouseout":
                        if (this.captureingMouse) {
                            var me = e;
                            if (!!me.relatedTarget) {
                                var elts = this.helt.getElementsByTagName(me.relatedTarget.nodeName);
                                for (var i = 0; i < elts.length; ++i)
                                    if (elts[i] == me.relatedTarget)
                                        return;
                            }
                            this.end(e);
                            this.captureingMouse = false;
                        }
                        break;
                    case "mouseup":
                        this.end(e);
                        this.captureingMouse = false;
                        break;
                    case "touchstart":
                        this.seenTouchEvent = true;
                        this.begin(e.touches[0]);
                        break;
                    case "touchmove":
                        e.preventDefault();
                        this.move(e.touches[0]);
                        break;
                    case "touchend":
                        this.end(e.touches[0]);
                        break;
                }
            }
            catch (err) {
                Util.reportError("dragToScroll", err);
            }
        };
        return DragToScrollHandler;
    })();
    TDev.DragToScrollHandler = DragToScrollHandler;
    var Util;
    (function (Util) {
        function setupDragToScroll(e) {
            e.scrollEnabled = true;
            if (TDev.Browser.isMobileSafari) {
                e.style.boxSizing = "border-box";
                e.style.overflowY = "scroll";
                e.className += " iOSScroll";
            }
            else if (TDev.Browser.builtinTouchToPan) {
                e.style.boxSizing = "border-box";
                e.style.overflowY = "auto";
            }
            else {
                e.style.overflowY = "hidden";
                var d = new DragToScrollHandler(e);
                d.init();
            }
        }
        Util.setupDragToScroll = setupDragToScroll;
        function resetDragToScroll(e) {
            e.scrollEnabled = false;
            if (TDev.Browser.builtinTouchToPan || TDev.Browser.isMobileSafari) {
                e.style.boxSizing = "";
                e.style.overflowX = "";
                e.style.overflowY = "";
                if (TDev.Browser.isMobileSafari)
                    e.className = e.className.replace(/iOSScroll/g, "");
            }
            else {
                var d = e.dragToScroll;
                if (d)
                    d.unhook();
            }
        }
        Util.resetDragToScroll = resetDragToScroll;
        function setupHDragToScroll(e) {
            e.scrollEnabled = true;
            if (TDev.Browser.isMobileSafari) {
                e.style.boxSizing = "border-box";
                e.style.overflowY = "auto";
                e.className += " iOSScroll";
            }
            else if (TDev.Browser.builtinTouchToPan) {
                e.style.boxSizing = "border-box";
                e.style.overflowX = "auto";
                if (TDev.Browser.isTrident)
                    e.style.msScrollTranslation = 'vertical-to-horizontal';
            }
            else {
                e.style.overflowX = "hidden";
                var d = new DragToScrollHandler(e);
                d.horizontal = true;
                d.vertical = false;
                d.init();
            }
        }
        Util.setupHDragToScroll = setupHDragToScroll;
    })(Util = TDev.Util || (TDev.Util = {}));
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var TouchHandler = (function (_super) {
        __extends(TouchHandler, _super);
        function TouchHandler(helt, cb) {
            _super.call(this, helt, null);
            this.helt = helt;
            this.cb = cb;
            this.offX = 0;
            this.offY = 0;
            this.lockX = false;
            this.lockY = false;
            this.lastX = 0;
            this.lastY = 0;
            this.isIeTouch = false;
            this.helt.style.touchAction = "none";
            this.helt.style.msTouchAction = "none";
        }
        TouchHandler.prototype.setupVersion = function () {
        };
        TouchHandler.prototype.getRelativePos = function (pos) {
            if (TDev.Util.mouseLogging) {
                TDev.Util.log("touch handler ");
                var apos = this.getPosition(this.helt);
                TDev.Util.log("pageX:{0} pageY:{1} offsetX:{2} offsetY:{3} clientX:{4} clientY:{5} eltX:{6} eltY:{7}", pos.pageX, pos.pageY, pos.offsetX, pos.offsetY, pos.clientX, pos.clientY, apos.x, apos.y);
            }
            var x, y;
            if (pos.pageX) {
                x = pos.pageX;
                y = pos.pageY;
            }
            else {
                x = pos.clientX;
                y = pos.clientY;
            }
            var absPos = this.getPosition(this.helt);
            pos.offX = x - absPos.x;
            pos.offY = y - absPos.y;
            return pos;
        };
        TouchHandler.prototype.clickBegin = function (pos) {
            _super.prototype.clickBegin.call(this, pos);
            this.getRelativePos(pos);
            if (TDev.Util.mouseLogging) {
                TDev.Util.log("touchBegin: {0},{1}", pos.offX, pos.offY);
            }
            this.offX = this.helt.offsetLeft - this.begX;
            this.offY = this.helt.offsetTop - this.begY;
            this.cb("down", pos.offX, pos.offY);
        };
        TouchHandler.prototype.onMove = function (pos) {
            this.getRelativePos(pos);
            if (TDev.Util.mouseLogging) {
                TDev.Util.log("onMove: {0},{1}", pos.offX, pos.offY);
            }
            this.cb("move", pos.offX, pos.offY);
        };
        TouchHandler.prototype.fireClick = function (pos) {
            this.getRelativePos(pos);
            if (TDev.Util.mouseLogging) {
                TDev.Util.log("touchEnd: {0},{1}", pos.offX, pos.offY);
            }
            this.clear();
            this.cb("up", pos.offX, pos.offY);
        };
        TouchHandler.prototype.prepareMouseOverlay = function () {
            if (this.isIeTouch)
                this.mouseCaptureOverlay = this.helt;
            else
                this.mouseCaptureOverlay = document.body;
        };
        TouchHandler.prototype.hideMouseOverlay = function () {
        };
        TouchHandler.prototype.handleEvent = function (e) {
            try {
                e.stopPropagation();
                e.preventDefault();
                this.isIeTouch = e.pointerType == 2;
                if (e.preventMouseEvent) {
                    e.preventMouseEvent();
                }
                if (e.preventManipulation) {
                    e.preventManipulation();
                }
                _super.prototype.handleEvent.call(this, e);
            }
            catch (err) {
                TDev.Util.reportError("dragHandler", err);
            }
        };
        return TouchHandler;
    })(TDev.ClickHandler);
    TDev.TouchHandler = TouchHandler;
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var HashtableEntry = (function () {
        function HashtableEntry(key, next) {
            this.key = key;
            this.next = next;
        }
        return HashtableEntry;
    })();
    TDev.HashtableEntry = HashtableEntry;
    var Hashtable = (function () {
        function Hashtable(getHashCode, equals, initialSize) {
            if (initialSize === void 0) { initialSize = 13; }
            this.getHashCode = getHashCode;
            this.equals = equals;
            this.initialSize = initialSize;
            this.entryCount = 0;
        }
        Hashtable.prototype.count = function () {
            return this.entryCount;
        };
        Hashtable.prototype.deleteKey = function (k) {
            if (!this.entries)
                return null;
            var h = (this.getHashCode(k) & 0x7fffffff) % this.entries.length;
            var e0 = this.entries[h];
            if (!e0)
                return null;
            if (this.equals(k, e0.key)) {
                this.entries[h] = e0.next;
                e0.next = null;
                this.entryCount--;
                return e0;
            }
            var e = e0;
            while (e && e.next && !this.equals(k, e.next.key))
                e = e.next;
            if (!e.next)
                return null;
            var found = e.next;
            e.next = found.next;
            found.next = null;
            this.entryCount--;
            return found;
        };
        Hashtable.prototype.remove = function (k) {
            return this.deleteKey(k);
        };
        Hashtable.prototype.lookup = function (k, addNew) {
            if (addNew === void 0) { addNew = false; }
            if (!this.entries) {
                if (!addNew)
                    return null;
                this.entries = [];
                for (var i = 0; i < this.initialSize; ++i)
                    this.entries[i] = null;
            }
            var h = (this.getHashCode(k) & 0x7fffffff) % this.entries.length;
            var e0 = this.entries[h];
            var e = e0;
            while (e && !this.equals(k, e.key))
                e = e.next;
            if (!e && addNew) {
                e = new HashtableEntry(k, e0);
                this.entryCount++;
                this.entries[h] = e;
                if (this.entryCount > this.entries.length + this.entries.length) {
                    this.rehash();
                }
            }
            return e;
        };
        Hashtable.prototype.sizeAtLeast = function (n) {
            for (var i = 0; i < Hashtable.primeSizes.length; ++i)
                if (Hashtable.primeSizes[i] > n)
                    return Hashtable.primeSizes[i];
            return 0;
        };
        Hashtable.prototype.rehash = function () {
            var size = this.sizeAtLeast(this.entries.length);
            if (size == 0)
                return;
            var oldEntries = this.entries;
            this.entries = [];
            for (var i = 0; i < size; ++i)
                this.entries[i] = null;
            for (var i = 0; i < oldEntries.length; ++i) {
                var next;
                for (var e = oldEntries[i]; e; e = next) {
                    next = e.next;
                    var h = (this.getHashCode(e.key) & 0x7fffffff) % this.entries.length;
                    e.next = this.entries[h];
                    this.entries[h] = e;
                }
            }
        };
        Hashtable.prototype.forEachEntry = function (f) {
            if (!this.entries)
                return;
            for (var i = 0; i < this.entries.length; ++i)
                for (var e = this.entries[i]; e; e = e.next)
                    f(e);
        };
        Hashtable.prototype.forEach = function (f) {
            this.forEachEntry(function (e) { return f(e.key, e.value); });
        };
        Hashtable.prototype.mapEntries = function (f) {
            var res = [];
            if (this.entries) {
                for (var i = 0; i < this.entries.length; ++i)
                    for (var e = this.entries[i]; e; e = e.next)
                        res.push(f(e));
            }
            return res;
        };
        Hashtable.prototype.keys = function () {
            return this.mapEntries(function (e) { return e.key; });
        };
        Hashtable.prototype.pairs = function () {
            return this.mapEntries(function (e) {
                return { key: e.key, value: e.value };
            });
        };
        Hashtable.prototype.filteredValues = function (filter) {
            var res = [];
            if (this.entries) {
                for (var i = 0; i < this.entries.length; ++i)
                    for (var e = this.entries[i]; e; e = e.next) {
                        var val = e.value;
                        if (filter(val))
                            res.push(val);
                    }
            }
            return res;
        };
        Hashtable.prototype.countFiltered = function (filter) {
            var count = 0;
            if (this.entries) {
                for (var i = 0; i < this.entries.length; ++i)
                    for (var e = this.entries[i]; e; e = e.next) {
                        var val = e.value;
                        if (filter(val))
                            count = count + 1;
                    }
            }
            return count;
        };
        Hashtable.prototype.set = function (k, v) {
            var e = this.lookup(k, true);
            e.value = v;
        };
        Hashtable.prototype.get = function (k) {
            var e = this.lookup(k);
            if (!e)
                return undefined;
            return e.value;
        };
        Hashtable.prototype.clear = function () {
            this.entries = null;
            this.entryCount = 0;
        };
        Hashtable.stringHash = function (s) {
            var res = 5381;
            for (var i = 0; i < s.length; ++i)
                res = (((res + (res << 5)) | 0) + s.charCodeAt(i)) | 0;
            return res;
        };
        Hashtable.stringEq = function (a, b) {
            return a == b;
        };
        Hashtable.forStrings = function () {
            return new Hashtable(Hashtable.stringHash, Hashtable.stringEq);
        };
        Hashtable.jsonHash = function (v) {
            return Hashtable.stringHash(JSON.stringify(v));
        };
        Hashtable.jsonEq = function (a, b) {
            return (a == b) || JSON.stringify(a) == JSON.stringify(b);
        };
        Hashtable.forJson = function () {
            return new Hashtable(Hashtable.jsonHash, Hashtable.jsonEq);
        };
        Hashtable.primeSizes = [13, 29, 59, 127, 257, 521, 1049, 2099, 4201, 8419, 16843, 33703, 67409, 134837, 269683, 539389, 1078787, 2157587, 4315183, 8630387, 17260781, 34521589, 69043189, 138086407, 276172823, 552345671, 1104691373, 2209382761];
        return Hashtable;
    })();
    TDev.Hashtable = Hashtable;
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    (function (Ticks) {
        Ticks[Ticks["noEvent"] = 0] = "noEvent";
        Ticks[Ticks["mainInit"] = 1] = "mainInit";
        Ticks[Ticks["mainHashChange"] = 2] = "mainHashChange";
        Ticks[Ticks["mainKeyEvent"] = 3] = "mainKeyEvent";
        Ticks[Ticks["mainShortcutKeyEvent"] = 4] = "mainShortcutKeyEvent";
        Ticks[Ticks["mainResetWorld"] = 5] = "mainResetWorld";
        Ticks[Ticks["artSoundPreviewPlay"] = 6] = "artSoundPreviewPlay";
        Ticks[Ticks["docsEdit"] = 7] = "docsEdit";
        Ticks[Ticks["exportAzure"] = 8] = "exportAzure";
        Ticks[Ticks["exportCordova"] = 9] = "exportCordova";
        Ticks[Ticks["exportHTML5"] = 10] = "exportHTML5";
        Ticks[Ticks["scriptPropsIconArt"] = 11] = "scriptPropsIconArt";
        Ticks[Ticks["scriptPropsSplashArt"] = 12] = "scriptPropsSplashArt";
        Ticks[Ticks["hourOfCodeDoneStep"] = 13] = "hourOfCodeDoneStep";
        Ticks[Ticks["hourOfCodeKeepCoding"] = 14] = "hourOfCodeKeepCoding";
        Ticks[Ticks["hourOfCodeConfirm"] = 15] = "hourOfCodeConfirm";
        Ticks[Ticks["hourOfCodeDone"] = 16] = "hourOfCodeDone";
        Ticks[Ticks["hourOfCodeMore"] = 17] = "hourOfCodeMore";
        Ticks[Ticks["hourOfCodeFinal"] = 18] = "hourOfCodeFinal";
        Ticks[Ticks["tutorialStart"] = 19] = "tutorialStart";
        Ticks[Ticks["tutorialEnd"] = 20] = "tutorialEnd";
        Ticks[Ticks["tutorialTranslateSplash"] = 21] = "tutorialTranslateSplash";
        Ticks[Ticks["tutorialTranslateStep"] = 22] = "tutorialTranslateStep";
        Ticks[Ticks["tutorialTranslateScript"] = 23] = "tutorialTranslateScript";
        Ticks[Ticks["tutorialKeepEditing"] = 24] = "tutorialKeepEditing";
        Ticks[Ticks["tutorialMoreTutorials"] = 25] = "tutorialMoreTutorials";
        Ticks[Ticks["tutorialNextStep"] = 26] = "tutorialNextStep";
        Ticks[Ticks["dodStart"] = 27] = "dodStart";
        Ticks[Ticks["dodDrop"] = 28] = "dodDrop";
        Ticks[Ticks["dodWrongTarget"] = 29] = "dodWrongTarget";
        Ticks[Ticks["cordovaBuild"] = 30] = "cordovaBuild";
        Ticks[Ticks["translateDocTopic"] = 31] = "translateDocTopic";
        Ticks[Ticks["legalNoticeSignIn"] = 32] = "legalNoticeSignIn";
        Ticks[Ticks["legalNoticeAgree"] = 33] = "legalNoticeAgree";
        Ticks[Ticks["calcAddMissingArgs"] = 34] = "calcAddMissingArgs";
        Ticks[Ticks["calcBackspace"] = 35] = "calcBackspace";
        Ticks[Ticks["calcCopy"] = 36] = "calcCopy";
        Ticks[Ticks["calcCut"] = 37] = "calcCut";
        Ticks[Ticks["calcDedicatedOp"] = 38] = "calcDedicatedOp";
        Ticks[Ticks["calcEdit"] = 39] = "calcEdit";
        Ticks[Ticks["calcEditString"] = 40] = "calcEditString";
        Ticks[Ticks["calcExtract"] = 41] = "calcExtract";
        Ticks[Ticks["calcPromoteToParameter"] = 42] = "calcPromoteToParameter";
        Ticks[Ticks["calcGoToDef"] = 43] = "calcGoToDef";
        Ticks[Ticks["calcFindRefs"] = 44] = "calcFindRefs";
        Ticks[Ticks["calcAddDataVar"] = 45] = "calcAddDataVar";
        Ticks[Ticks["calcUnselect"] = 46] = "calcUnselect";
        Ticks[Ticks["calcExtend"] = 47] = "calcExtend";
        Ticks[Ticks["calcReplaceInScript"] = 48] = "calcReplaceInScript";
        Ticks[Ticks["calcReplaceInSelection"] = 49] = "calcReplaceInSelection";
        Ticks[Ticks["calcReplaceInAction"] = 50] = "calcReplaceInAction";
        Ticks[Ticks["calcInsertAssignment"] = 51] = "calcInsertAssignment";
        Ticks[Ticks["calcInsertString"] = 52] = "calcInsertString";
        Ticks[Ticks["calcIntelliButton"] = 53] = "calcIntelliButton";
        Ticks[Ticks["calcIntelliButton0"] = 54] = "calcIntelliButton0";
        Ticks[Ticks["calcIntelliButton1"] = 55] = "calcIntelliButton1";
        Ticks[Ticks["calcIntelliButton2"] = 56] = "calcIntelliButton2";
        Ticks[Ticks["calcIntelliButton3"] = 57] = "calcIntelliButton3";
        Ticks[Ticks["calcIntelliButton4"] = 58] = "calcIntelliButton4";
        Ticks[Ticks["calcIntelliButton5plus"] = 59] = "calcIntelliButton5plus";
        Ticks[Ticks["calcIntelliLiteral"] = 60] = "calcIntelliLiteral";
        Ticks[Ticks["calcIntelliLocal"] = 61] = "calcIntelliLocal";
        Ticks[Ticks["calcIntelliProperty"] = 62] = "calcIntelliProperty";
        Ticks[Ticks["calcIntelliPropertyPrimary"] = 63] = "calcIntelliPropertyPrimary";
        Ticks[Ticks["calcIntelliSingleton"] = 64] = "calcIntelliSingleton";
        Ticks[Ticks["calcIntelliLibrary"] = 65] = "calcIntelliLibrary";
        Ticks[Ticks["calcIntelliResource"] = 66] = "calcIntelliResource";
        Ticks[Ticks["calcKeyboardSearch"] = 67] = "calcKeyboardSearch";
        Ticks[Ticks["calcMoveCursorLeft"] = 68] = "calcMoveCursorLeft";
        Ticks[Ticks["calcMoveCursorRight"] = 69] = "calcMoveCursorRight";
        Ticks[Ticks["calcNewLine"] = 70] = "calcNewLine";
        Ticks[Ticks["calcNextIntelliTopPage"] = 71] = "calcNextIntelliTopPage";
        Ticks[Ticks["calcNextIntelliPageSearch"] = 72] = "calcNextIntelliPageSearch";
        Ticks[Ticks["calcNextIntelliPage"] = 73] = "calcNextIntelliPage";
        Ticks[Ticks["calcNextIntelliPage0"] = 74] = "calcNextIntelliPage0";
        Ticks[Ticks["calcNextIntelliPage1"] = 75] = "calcNextIntelliPage1";
        Ticks[Ticks["calcNextIntelliPage2"] = 76] = "calcNextIntelliPage2";
        Ticks[Ticks["calcNextIntelliPage3"] = 77] = "calcNextIntelliPage3";
        Ticks[Ticks["calcNextIntelliPage4"] = 78] = "calcNextIntelliPage4";
        Ticks[Ticks["calcNextIntelliPage5plus"] = 79] = "calcNextIntelliPage5plus";
        Ticks[Ticks["calcAsync"] = 80] = "calcAsync";
        Ticks[Ticks["calcAwait"] = 81] = "calcAwait";
        Ticks[Ticks["calcNot"] = 82] = "calcNot";
        Ticks[Ticks["calcNumber"] = 83] = "calcNumber";
        Ticks[Ticks["calcPaste"] = 84] = "calcPaste";
        Ticks[Ticks["calcPickColor"] = 85] = "calcPickColor";
        Ticks[Ticks["calcPickNumber"] = 86] = "calcPickNumber";
        Ticks[Ticks["calcDemoteIntoLocal"] = 87] = "calcDemoteIntoLocal";
        Ticks[Ticks["calcPromoteIntoGlobal"] = 88] = "calcPromoteIntoGlobal";
        Ticks[Ticks["calcPromoteIntoField"] = 89] = "calcPromoteIntoField";
        Ticks[Ticks["calcRenameLocal"] = 90] = "calcRenameLocal";
        Ticks[Ticks["calcRenameProperty"] = 91] = "calcRenameProperty";
        Ticks[Ticks["calcSearchBack"] = 92] = "calcSearchBack";
        Ticks[Ticks["calcSearchRun"] = 93] = "calcSearchRun";
        Ticks[Ticks["calcSearchCompile"] = 94] = "calcSearchCompile";
        Ticks[Ticks["calcSimplify"] = 95] = "calcSimplify";
        Ticks[Ticks["calcStrip"] = 96] = "calcStrip";
        Ticks[Ticks["calcSpecialKey"] = 97] = "calcSpecialKey";
        Ticks[Ticks["calcStartSearch"] = 98] = "calcStartSearch";
        Ticks[Ticks["calcStoreInVar"] = 99] = "calcStoreInVar";
        Ticks[Ticks["calcSwapBoolean"] = 100] = "calcSwapBoolean";
        Ticks[Ticks["calcSwapAsync"] = 101] = "calcSwapAsync";
        Ticks[Ticks["calcIntelliAsync"] = 102] = "calcIntelliAsync";
        Ticks[Ticks["calcSwitchToNormal"] = 103] = "calcSwitchToNormal";
        Ticks[Ticks["calcSwitchToNumber"] = 104] = "calcSwitchToNumber";
        Ticks[Ticks["calcTrueFalse"] = 105] = "calcTrueFalse";
        Ticks[Ticks["calcUndo"] = 106] = "calcUndo";
        Ticks[Ticks["calcGoToBoxProperty"] = 107] = "calcGoToBoxProperty";
        Ticks[Ticks["calcAddBoxProperty"] = 108] = "calcAddBoxProperty";
        Ticks[Ticks["calcInsertStringParamterValue"] = 109] = "calcInsertStringParamterValue";
        Ticks[Ticks["calcHelp"] = 110] = "calcHelp";
        Ticks[Ticks["calcHelpOverlay"] = 111] = "calcHelpOverlay";
        Ticks[Ticks["calcElseIf"] = 112] = "calcElseIf";
        Ticks[Ticks["calcUnElseIf"] = 113] = "calcUnElseIf";
        Ticks[Ticks["calcBindGlobal"] = 114] = "calcBindGlobal";
        Ticks[Ticks["calcFixItAtomic"] = 115] = "calcFixItAtomic";
        Ticks[Ticks["calcEditArt"] = 116] = "calcEditArt";
        Ticks[Ticks["calcAddOptionalParameter"] = 117] = "calcAddOptionalParameter";
        Ticks[Ticks["calcChangeOptionalParameter"] = 118] = "calcChangeOptionalParameter";
        Ticks[Ticks["codeAddAbove"] = 119] = "codeAddAbove";
        Ticks[Ticks["codeAddBelow"] = 120] = "codeAddBelow";
        Ticks[Ticks["codeShow"] = 121] = "codeShow";
        Ticks[Ticks["codeContinue"] = 122] = "codeContinue";
        Ticks[Ticks["codeReturn"] = 123] = "codeReturn";
        Ticks[Ticks["codeBreak"] = 124] = "codeBreak";
        Ticks[Ticks["codeBoxed"] = 125] = "codeBoxed";
        Ticks[Ticks["codeCopy"] = 126] = "codeCopy";
        Ticks[Ticks["codeCopySelection"] = 127] = "codeCopySelection";
        Ticks[Ticks["codeDeleteSelection"] = 128] = "codeDeleteSelection";
        Ticks[Ticks["codeCut"] = 129] = "codeCut";
        Ticks[Ticks["codeCutSelection"] = 130] = "codeCutSelection";
        Ticks[Ticks["codeCycleSidePane"] = 131] = "codeCycleSidePane";
        Ticks[Ticks["codeCycleSidePaneFull"] = 132] = "codeCycleSidePaneFull";
        Ticks[Ticks["codeExtractAction"] = 133] = "codeExtractAction";
        Ticks[Ticks["codeFocusSidePane"] = 134] = "codeFocusSidePane";
        Ticks[Ticks["codeFocusSidePaneFull"] = 135] = "codeFocusSidePaneFull";
        Ticks[Ticks["codeFor"] = 136] = "codeFor";
        Ticks[Ticks["codeForEach"] = 137] = "codeForEach";
        Ticks[Ticks["codeHub"] = 138] = "codeHub";
        Ticks[Ticks["codeIf"] = 139] = "codeIf";
        Ticks[Ticks["codeMoveLeft"] = 140] = "codeMoveLeft";
        Ticks[Ticks["codeNewVar"] = 141] = "codeNewVar";
        Ticks[Ticks["codePaste"] = 142] = "codePaste";
        Ticks[Ticks["codeRun"] = 143] = "codeRun";
        Ticks[Ticks["codeResume"] = 144] = "codeResume";
        Ticks[Ticks["codeStartSelection"] = 145] = "codeStartSelection";
        Ticks[Ticks["codeSurround"] = 146] = "codeSurround";
        Ticks[Ticks["codeUndo"] = 147] = "codeUndo";
        Ticks[Ticks["codeSplit"] = 148] = "codeSplit";
        Ticks[Ticks["codeWhile"] = 149] = "codeWhile";
        Ticks[Ticks["codeUninstallScript"] = 150] = "codeUninstallScript";
        Ticks[Ticks["codeBackFromSearch"] = 151] = "codeBackFromSearch";
        Ticks[Ticks["actionPropPrivate"] = 152] = "actionPropPrivate";
        Ticks[Ticks["actionPropTest"] = 153] = "actionPropTest";
        Ticks[Ticks["actionPropAtomic"] = 154] = "actionPropAtomic";
        Ticks[Ticks["siteMenuCreateCode"] = 155] = "siteMenuCreateCode";
        Ticks[Ticks["siteMenuImportCode"] = 156] = "siteMenuImportCode";
        Ticks[Ticks["siteMenuGroups"] = 157] = "siteMenuGroups";
        Ticks[Ticks["siteMenuTutorials"] = 158] = "siteMenuTutorials";
        Ticks[Ticks["siteMenuProjects"] = 159] = "siteMenuProjects";
        Ticks[Ticks["siteMenuHome"] = 160] = "siteMenuHome";
        Ticks[Ticks["siteMenuHelp"] = 161] = "siteMenuHelp";
        Ticks[Ticks["siteMenuGettingStarted"] = 162] = "siteMenuGettingStarted";
        Ticks[Ticks["siteMenuMyScripts"] = 163] = "siteMenuMyScripts";
        Ticks[Ticks["siteMenuSignIn"] = 164] = "siteMenuSignIn";
        Ticks[Ticks["siteMenuProfile"] = 165] = "siteMenuProfile";
        Ticks[Ticks["siteMenuChannels"] = 166] = "siteMenuChannels";
        Ticks[Ticks["btnPaste"] = 167] = "btnPaste";
        Ticks[Ticks["btnCopy"] = 168] = "btnCopy";
        Ticks[Ticks["btnCut"] = 169] = "btnCut";
        Ticks[Ticks["btnSelect"] = 170] = "btnSelect";
        Ticks[Ticks["btnTryFix"] = 171] = "btnTryFix";
        Ticks[Ticks["btnUndoFix"] = 172] = "btnUndoFix";
        Ticks[Ticks["btnAddUp"] = 173] = "btnAddUp";
        Ticks[Ticks["btnAddDown"] = 174] = "btnAddDown";
        Ticks[Ticks["btnMoveLeft"] = 175] = "btnMoveLeft";
        Ticks[Ticks["btnBreakpoint"] = 176] = "btnBreakpoint";
        Ticks[Ticks["btnChangeKind"] = 177] = "btnChangeKind";
        Ticks[Ticks["calcBtnBackspace"] = 178] = "calcBtnBackspace";
        Ticks[Ticks["calcBtnUndo"] = 179] = "calcBtnUndo";
        Ticks[Ticks["calcBtnNumberKeypad"] = 180] = "calcBtnNumberKeypad";
        Ticks[Ticks["calcBtnMiscKeypad"] = 181] = "calcBtnMiscKeypad";
        Ticks[Ticks["calcBtnNormalKeypad"] = 182] = "calcBtnNormalKeypad";
        Ticks[Ticks["calcBtnApiSearch"] = 183] = "calcBtnApiSearch";
        Ticks[Ticks["editBtnSideSearch"] = 184] = "editBtnSideSearch";
        Ticks[Ticks["chooseCancel"] = 185] = "chooseCancel";
        Ticks[Ticks["editTapBelow"] = 186] = "editTapBelow";
        Ticks[Ticks["coverageShown"] = 187] = "coverageShown";
        Ticks[Ticks["coverageOpenInEditor"] = 188] = "coverageOpenInEditor";
        Ticks[Ticks["coverageBucketSurveyActionEdit"] = 189] = "coverageBucketSurveyActionEdit";
        Ticks[Ticks["coverageBucketSurveyStatementEdit"] = 190] = "coverageBucketSurveyStatementEdit";
        Ticks[Ticks["coverageBucketSurveyDebugger"] = 191] = "coverageBucketSurveyDebugger";
        Ticks[Ticks["coverageBucketSurveyBreakpoint"] = 192] = "coverageBucketSurveyBreakpoint";
        Ticks[Ticks["coverageBucketSurveyExceededSuccessfully"] = 193] = "coverageBucketSurveyExceededSuccessfully";
        Ticks[Ticks["profileShown"] = 194] = "profileShown";
        Ticks[Ticks["profileOpenInEditor"] = 195] = "profileOpenInEditor";
        Ticks[Ticks["debuggerExit"] = 196] = "debuggerExit";
        Ticks[Ticks["debuggerContinue"] = 197] = "debuggerContinue";
        Ticks[Ticks["debuggerStepIn"] = 198] = "debuggerStepIn";
        Ticks[Ticks["debuggerStepOver"] = 199] = "debuggerStepOver";
        Ticks[Ticks["debuggerStepOut"] = 200] = "debuggerStepOut";
        Ticks[Ticks["debuggerToggleBreakpoint"] = 201] = "debuggerToggleBreakpoint";
        Ticks[Ticks["debuggerViewInit"] = 202] = "debuggerViewInit";
        Ticks[Ticks["debuggerPauseWall"] = 203] = "debuggerPauseWall";
        Ticks[Ticks["debuggerShowValues"] = 204] = "debuggerShowValues";
        Ticks[Ticks["debuggerShowStack"] = 205] = "debuggerShowStack";
        Ticks[Ticks["debuggerGotoWall"] = 206] = "debuggerGotoWall";
        Ticks[Ticks["debuggerGotoCurrent"] = 207] = "debuggerGotoCurrent";
        Ticks[Ticks["debuggerAppLog"] = 208] = "debuggerAppLog";
        Ticks[Ticks["debuggerHelp"] = 209] = "debuggerHelp";
        Ticks[Ticks["debuggerValueClicked"] = 210] = "debuggerValueClicked";
        Ticks[Ticks["debuggerKeyboardEvent"] = 211] = "debuggerKeyboardEvent";
        Ticks[Ticks["editorTutorialClose"] = 212] = "editorTutorialClose";
        Ticks[Ticks["editorTutorialNext"] = 213] = "editorTutorialNext";
        Ticks[Ticks["editorTutorialPrevious"] = 214] = "editorTutorialPrevious";
        Ticks[Ticks["externalSave"] = 215] = "externalSave";
        Ticks[Ticks["externalLoad"] = 216] = "externalLoad";
        Ticks[Ticks["externalCompile"] = 217] = "externalCompile";
        Ticks[Ticks["externalRun"] = 218] = "externalRun";
        Ticks[Ticks["sideAddAction"] = 219] = "sideAddAction";
        Ticks[Ticks["sideAddActionTest"] = 220] = "sideAddActionTest";
        Ticks[Ticks["sideAddActionTypeDef"] = 221] = "sideAddActionTypeDef";
        Ticks[Ticks["sideAddEvent"] = 222] = "sideAddEvent";
        Ticks[Ticks["sideAddLibrary"] = 223] = "sideAddLibrary";
        Ticks[Ticks["sideAddPage"] = 224] = "sideAddPage";
        Ticks[Ticks["sideAddRecord"] = 225] = "sideAddRecord";
        Ticks[Ticks["sideAddObject"] = 226] = "sideAddObject";
        Ticks[Ticks["sideAddTable"] = 227] = "sideAddTable";
        Ticks[Ticks["sideAddIndex"] = 228] = "sideAddIndex";
        Ticks[Ticks["sideAddDecorator"] = 229] = "sideAddDecorator";
        Ticks[Ticks["sideAddResource"] = 230] = "sideAddResource";
        Ticks[Ticks["sideAddVariable"] = 231] = "sideAddVariable";
        Ticks[Ticks["sideAddAnything"] = 232] = "sideAddAnything";
        Ticks[Ticks["sideHelp"] = 233] = "sideHelp";
        Ticks[Ticks["sideBraces"] = 234] = "sideBraces";
        Ticks[Ticks["sideDebug"] = 235] = "sideDebug";
        Ticks[Ticks["sideLogs"] = 236] = "sideLogs";
        Ticks[Ticks["sideErrors"] = 237] = "sideErrors";
        Ticks[Ticks["sideDeployWebSite"] = 238] = "sideDeployWebSite";
        Ticks[Ticks["sidePlugins"] = 239] = "sidePlugins";
        Ticks[Ticks["sideButtonPlugin"] = 240] = "sideButtonPlugin";
        Ticks[Ticks["sidePreview"] = 241] = "sidePreview";
        Ticks[Ticks["sideHistory"] = 242] = "sideHistory";
        Ticks[Ticks["sideHistoryGoTo"] = 243] = "sideHistoryGoTo";
        Ticks[Ticks["sidePaste"] = 244] = "sidePaste";
        Ticks[Ticks["sideScript"] = 245] = "sideScript";
        Ticks[Ticks["sideScriptGoToDecl"] = 246] = "sideScriptGoToDecl";
        Ticks[Ticks["sideSearch"] = 247] = "sideSearch";
        Ticks[Ticks["sideSearchGoToDecl"] = 248] = "sideSearchGoToDecl";
        Ticks[Ticks["sideSearchGoToStmt"] = 249] = "sideSearchGoToStmt";
        Ticks[Ticks["sidePublish"] = 250] = "sidePublish";
        Ticks[Ticks["sideShare"] = 251] = "sideShare";
        Ticks[Ticks["sideDisconnect"] = 252] = "sideDisconnect";
        Ticks[Ticks["sideRun"] = 253] = "sideRun";
        Ticks[Ticks["sideCut"] = 254] = "sideCut";
        Ticks[Ticks["sideCopy"] = 255] = "sideCopy";
        Ticks[Ticks["sideDelete"] = 256] = "sideDelete";
        Ticks[Ticks["sideFindRefs"] = 257] = "sideFindRefs";
        Ticks[Ticks["sideActionHeaderInit"] = 258] = "sideActionHeaderInit";
        Ticks[Ticks["sideCommentInit"] = 259] = "sideCommentInit";
        Ticks[Ticks["sideParameterInit"] = 260] = "sideParameterInit";
        Ticks[Ticks["sideResetSidePane"] = 261] = "sideResetSidePane";
        Ticks[Ticks["sideInlineActionInit"] = 262] = "sideInlineActionInit";
        Ticks[Ticks["sideExport"] = 263] = "sideExport";
        Ticks[Ticks["sideAllTests"] = 264] = "sideAllTests";
        Ticks[Ticks["sideTestOne"] = 265] = "sideTestOne";
        Ticks[Ticks["sideEditLibrary"] = 266] = "sideEditLibrary";
        Ticks[Ticks["sideEditString"] = 267] = "sideEditString";
        Ticks[Ticks["sideUpdate"] = 268] = "sideUpdate";
        Ticks[Ticks["sideUpdateOne"] = 269] = "sideUpdateOne";
        Ticks[Ticks["sideActionAddInput"] = 270] = "sideActionAddInput";
        Ticks[Ticks["sideActionAddOutput"] = 271] = "sideActionAddOutput";
        Ticks[Ticks["sideTutorialCancel"] = 272] = "sideTutorialCancel";
        Ticks[Ticks["sideTutorialRedisplay"] = 273] = "sideTutorialRedisplay";
        Ticks[Ticks["sideMoreOptions"] = 274] = "sideMoreOptions";
        Ticks[Ticks["appsCreateAzureWebsite"] = 275] = "appsCreateAzureWebsite";
        Ticks[Ticks["appsDeployWebsite"] = 276] = "appsDeployWebsite";
        Ticks[Ticks["pluginStop"] = 277] = "pluginStop";
        Ticks[Ticks["pluginRunOperation"] = 278] = "pluginRunOperation";
        Ticks[Ticks["pluginAddMore"] = 279] = "pluginAddMore";
        Ticks[Ticks["pluginRunAnnotationOperation"] = 280] = "pluginRunAnnotationOperation";
        Ticks[Ticks["searchApiSynthesis"] = 281] = "searchApiSynthesis";
        Ticks[Ticks["searchApiSearchArt"] = 282] = "searchApiSearchArt";
        Ticks[Ticks["searchApiSearchLib"] = 283] = "searchApiSearchLib";
        Ticks[Ticks["searchApiSearchAuto"] = 284] = "searchApiSearchAuto";
        Ticks[Ticks["searchApiInsertArt"] = 285] = "searchApiInsertArt";
        Ticks[Ticks["searchApiUploadArt"] = 286] = "searchApiUploadArt";
        Ticks[Ticks["searchApiInsertLib"] = 287] = "searchApiInsertLib";
        Ticks[Ticks["wallBack"] = 288] = "wallBack";
        Ticks[Ticks["wallJS"] = 289] = "wallJS";
        Ticks[Ticks["wallEdit"] = 290] = "wallEdit";
        Ticks[Ticks["wallReplay"] = 291] = "wallReplay";
        Ticks[Ticks["wallScreenshot"] = 292] = "wallScreenshot";
        Ticks[Ticks["wallLogs"] = 293] = "wallLogs";
        Ticks[Ticks["wallSerial"] = 294] = "wallSerial";
        Ticks[Ticks["wallStop"] = 295] = "wallStop";
        Ticks[Ticks["wallStopForce"] = 296] = "wallStopForce";
        Ticks[Ticks["wallPause"] = 297] = "wallPause";
        Ticks[Ticks["wallResume"] = 298] = "wallResume";
        Ticks[Ticks["wallRun"] = 299] = "wallRun";
        Ticks[Ticks["wallTraces"] = 300] = "wallTraces";
        Ticks[Ticks["wallAddHeart"] = 301] = "wallAddHeart";
        Ticks[Ticks["wallRemoveHeart"] = 302] = "wallRemoveHeart";
        Ticks[Ticks["commentAttach"] = 303] = "commentAttach";
        Ticks[Ticks["commentBugTracking"] = 304] = "commentBugTracking";
        Ticks[Ticks["coreRun"] = 305] = "coreRun";
        Ticks[Ticks["coreNativeCompile"] = 306] = "coreNativeCompile";
        Ticks[Ticks["coreResume"] = 307] = "coreResume";
        Ticks[Ticks["coreRerun"] = 308] = "coreRerun";
        Ticks[Ticks["corePublishHidden"] = 309] = "corePublishHidden";
        Ticks[Ticks["corePublishPublic"] = 310] = "corePublishPublic";
        Ticks[Ticks["runtimePlayAgain"] = 311] = "runtimePlayAgain";
        Ticks[Ticks["runtimeBack"] = 312] = "runtimeBack";
        Ticks[Ticks["appUpdateAvailable"] = 313] = "appUpdateAvailable";
        Ticks[Ticks["appNoUpdate"] = 314] = "appNoUpdate";
        Ticks[Ticks["appQuickUpdate"] = 315] = "appQuickUpdate";
        Ticks[Ticks["appUpdate"] = 316] = "appUpdate";
        Ticks[Ticks["editorUpdateScript"] = 317] = "editorUpdateScript";
        Ticks[Ticks["editorUpdateLibrary"] = 318] = "editorUpdateLibrary";
        Ticks[Ticks["editorRunWithProfiling"] = 319] = "editorRunWithProfiling";
        Ticks[Ticks["editorRunWithCoverage"] = 320] = "editorRunWithCoverage";
        Ticks[Ticks["editorRunAsMinion"] = 321] = "editorRunAsMinion";
        Ticks[Ticks["viewActionInit"] = 322] = "viewActionInit";
        Ticks[Ticks["viewLibraryRefInit"] = 323] = "viewLibraryRefInit";
        Ticks[Ticks["viewRecordInit"] = 324] = "viewRecordInit";
        Ticks[Ticks["viewScriptInit"] = 325] = "viewScriptInit";
        Ticks[Ticks["viewVariableInit"] = 326] = "viewVariableInit";
        Ticks[Ticks["hubCreateScript"] = 327] = "hubCreateScript";
        Ticks[Ticks["hubCreateGame"] = 328] = "hubCreateGame";
        Ticks[Ticks["hubCreateGroup"] = 329] = "hubCreateGroup";
        Ticks[Ticks["hubCreateList"] = 330] = "hubCreateList";
        Ticks[Ticks["hubJoinGroup"] = 331] = "hubJoinGroup";
        Ticks[Ticks["hubUploadPicture"] = 332] = "hubUploadPicture";
        Ticks[Ticks["hubUploadSound"] = 333] = "hubUploadSound";
        Ticks[Ticks["hubGameTutorial"] = 334] = "hubGameTutorial";
        Ticks[Ticks["hubWinStore"] = 335] = "hubWinStore";
        Ticks[Ticks["hubDocs"] = 336] = "hubDocs";
        Ticks[Ticks["hubFirstTutorial"] = 337] = "hubFirstTutorial";
        Ticks[Ticks["hubDocsTutorial"] = 338] = "hubDocsTutorial";
        Ticks[Ticks["hubBasicEditorVideo"] = 339] = "hubBasicEditorVideo";
        Ticks[Ticks["hubBasicEditorVideoVoice"] = 340] = "hubBasicEditorVideoVoice";
        Ticks[Ticks["hubBasicEditorVideoSubtitles"] = 341] = "hubBasicEditorVideoSubtitles";
        Ticks[Ticks["hubBeginnersGettingStarted"] = 342] = "hubBeginnersGettingStarted";
        Ticks[Ticks["hubCCGA"] = 343] = "hubCCGA";
        Ticks[Ticks["hubChatSearch"] = 344] = "hubChatSearch";
        Ticks[Ticks["hubChooseSkill"] = 345] = "hubChooseSkill";
        Ticks[Ticks["hubDevBootCamp"] = 346] = "hubDevBootCamp";
        Ticks[Ticks["hubDocsApi"] = 347] = "hubDocsApi";
        Ticks[Ticks["hubDocsWhatsNew"] = 348] = "hubDocsWhatsNew";
        Ticks[Ticks["hubAdvancedEditorVideo"] = 349] = "hubAdvancedEditorVideo";
        Ticks[Ticks["hubSeeMoreMyScripts"] = 350] = "hubSeeMoreMyScripts";
        Ticks[Ticks["hubSeeMoreNewScripts"] = 351] = "hubSeeMoreNewScripts";
        Ticks[Ticks["hubSeeMoreArt"] = 352] = "hubSeeMoreArt";
        Ticks[Ticks["hubSeeMoreUsers"] = 353] = "hubSeeMoreUsers";
        Ticks[Ticks["hubSeeMoreCloudOther"] = 354] = "hubSeeMoreCloudOther";
        Ticks[Ticks["hubSeeMoreShowcase"] = 355] = "hubSeeMoreShowcase";
        Ticks[Ticks["hubSeeMoreTutorials"] = 356] = "hubSeeMoreTutorials";
        Ticks[Ticks["hubSeeMoreTopScripts"] = 357] = "hubSeeMoreTopScripts";
        Ticks[Ticks["hubSeeMoreDocs"] = 358] = "hubSeeMoreDocs";
        Ticks[Ticks["hubSeeMoreCloud"] = 359] = "hubSeeMoreCloud";
        Ticks[Ticks["hubSeeMoreGroups"] = 360] = "hubSeeMoreGroups";
        Ticks[Ticks["hubSeeMoreLists"] = 361] = "hubSeeMoreLists";
        Ticks[Ticks["hubMyScriptsShowcase"] = 362] = "hubMyScriptsShowcase";
        Ticks[Ticks["hubMyScriptsTemplate"] = 363] = "hubMyScriptsTemplate";
        Ticks[Ticks["hubNotifications"] = 364] = "hubNotifications";
        Ticks[Ticks["hubUpdates"] = 365] = "hubUpdates";
        Ticks[Ticks["hubDoUpdates"] = 366] = "hubDoUpdates";
        Ticks[Ticks["hubTests"] = 367] = "hubTests";
        Ticks[Ticks["hubShowcaseMgmt"] = 368] = "hubShowcaseMgmt";
        Ticks[Ticks["hubBenchmarks"] = 369] = "hubBenchmarks";
        Ticks[Ticks["hubForum"] = 370] = "hubForum";
        Ticks[Ticks["hubFacebook"] = 371] = "hubFacebook";
        Ticks[Ticks["hubTwitter"] = 372] = "hubTwitter";
        Ticks[Ticks["hubYouTube"] = 373] = "hubYouTube";
        Ticks[Ticks["hubSettings"] = 374] = "hubSettings";
        Ticks[Ticks["hubAbout"] = 375] = "hubAbout";
        Ticks[Ticks["hubHelp"] = 376] = "hubHelp";
        Ticks[Ticks["hubWrongTime"] = 377] = "hubWrongTime";
        Ticks[Ticks["hubTag"] = 378] = "hubTag";
        Ticks[Ticks["hubTagFromList"] = 379] = "hubTagFromList";
        Ticks[Ticks["hubFeedback"] = 380] = "hubFeedback";
        Ticks[Ticks["hubChooseWallpaper"] = 381] = "hubChooseWallpaper";
        Ticks[Ticks["changeSkillScriptProperties"] = 382] = "changeSkillScriptProperties";
        Ticks[Ticks["changeSkillActionProperties"] = 383] = "changeSkillActionProperties";
        Ticks[Ticks["changeSkillScriptExplorer"] = 384] = "changeSkillScriptExplorer";
        Ticks[Ticks["editorSkillBlock"] = 385] = "editorSkillBlock";
        Ticks[Ticks["editorSkillClassic"] = 386] = "editorSkillClassic";
        Ticks[Ticks["editorSkillCurly"] = 387] = "editorSkillCurly";
        Ticks[Ticks["groupCodeReset"] = 388] = "groupCodeReset";
        Ticks[Ticks["groupCodeNew"] = 389] = "groupCodeNew";
        Ticks[Ticks["groupCodeGet"] = 390] = "groupCodeGet";
        Ticks[Ticks["groupDelete"] = 391] = "groupDelete";
        Ticks[Ticks["groupLeave"] = 392] = "groupLeave";
        Ticks[Ticks["groupJoin"] = 393] = "groupJoin";
        Ticks[Ticks["groupAllowAnyoneToJoin"] = 394] = "groupAllowAnyoneToJoin";
        Ticks[Ticks["groupRequireInvitationCodeToJoin"] = 395] = "groupRequireInvitationCodeToJoin";
        Ticks[Ticks["groupChangePicture"] = 396] = "groupChangePicture";
        Ticks[Ticks["publishShareGroup"] = 397] = "publishShareGroup";
        Ticks[Ticks["browseEditInstall"] = 398] = "browseEditInstall";
        Ticks[Ticks["browseRunInstall"] = 399] = "browseRunInstall";
        Ticks[Ticks["browseRun"] = 400] = "browseRun";
        Ticks[Ticks["browseEdit"] = 401] = "browseEdit";
        Ticks[Ticks["browsePin"] = 402] = "browsePin";
        Ticks[Ticks["browseHeart"] = 403] = "browseHeart";
        Ticks[Ticks["browseUnHeart"] = 404] = "browseUnHeart";
        Ticks[Ticks["browseModerate"] = 405] = "browseModerate";
        Ticks[Ticks["browsePublish"] = 406] = "browsePublish";
        Ticks[Ticks["browseUninstall"] = 407] = "browseUninstall";
        Ticks[Ticks["browsePush"] = 408] = "browsePush";
        Ticks[Ticks["browseDiffBase"] = 409] = "browseDiffBase";
        Ticks[Ticks["browseConvertToTutorial"] = 410] = "browseConvertToTutorial";
        Ticks[Ticks["browseConvertToLesson"] = 411] = "browseConvertToLesson";
        Ticks[Ticks["browseAddScriptToList"] = 412] = "browseAddScriptToList";
        Ticks[Ticks["browseUpdate"] = 413] = "browseUpdate";
        Ticks[Ticks["browseSendPullRequest"] = 414] = "browseSendPullRequest";
        Ticks[Ticks["browseClone"] = 415] = "browseClone";
        Ticks[Ticks["browseSave"] = 416] = "browseSave";
        Ticks[Ticks["browseCreateCode"] = 417] = "browseCreateCode";
        Ticks[Ticks["browseImportCode"] = 418] = "browseImportCode";
        Ticks[Ticks["browsePublicationNotes"] = 419] = "browsePublicationNotes";
        Ticks[Ticks["browseListPointers"] = 420] = "browseListPointers";
        Ticks[Ticks["browseListBugs"] = 421] = "browseListBugs";
        Ticks[Ticks["browseListReleases"] = 422] = "browseListReleases";
        Ticks[Ticks["browseShare"] = 423] = "browseShare";
        Ticks[Ticks["browseListMyScripts"] = 424] = "browseListMyScripts";
        Ticks[Ticks["browseListNew"] = 425] = "browseListNew";
        Ticks[Ticks["browseListTop"] = 426] = "browseListTop";
        Ticks[Ticks["browseListShowcase"] = 427] = "browseListShowcase";
        Ticks[Ticks["browseListForum"] = 428] = "browseListForum";
        Ticks[Ticks["browseListDocs"] = 429] = "browseListDocs";
        Ticks[Ticks["browseListHelp"] = 430] = "browseListHelp";
        Ticks[Ticks["browseListGroups"] = 431] = "browseListGroups";
        Ticks[Ticks["browseListArt"] = 432] = "browseListArt";
        Ticks[Ticks["browseListMyArt"] = 433] = "browseListMyArt";
        Ticks[Ticks["browseListTags"] = 434] = "browseListTags";
        Ticks[Ticks["browseListSearch"] = 435] = "browseListSearch";
        Ticks[Ticks["browseListUsers"] = 436] = "browseListUsers";
        Ticks[Ticks["browseListLists"] = 437] = "browseListLists";
        Ticks[Ticks["browseFollowTopic"] = 438] = "browseFollowTopic";
        Ticks[Ticks["introSlideGetStarted"] = 439] = "introSlideGetStarted";
        Ticks[Ticks["introSlideLimitations"] = 440] = "introSlideLimitations";
        Ticks[Ticks["introSlideCreateApps"] = 441] = "introSlideCreateApps";
        Ticks[Ticks["introSlidePopCorn"] = 442] = "introSlidePopCorn";
        Ticks[Ticks["introSlideLogIn"] = 443] = "introSlideLogIn";
        Ticks[Ticks["introSlideDismiss"] = 444] = "introSlideDismiss";
        Ticks[Ticks["recordAddKey"] = 445] = "recordAddKey";
        Ticks[Ticks["recordAddValue"] = 446] = "recordAddValue";
        Ticks[Ticks["recordAddAction"] = 447] = "recordAddAction";
        Ticks[Ticks["recordPersTemporary"] = 448] = "recordPersTemporary";
        Ticks[Ticks["recordPersLocal"] = 449] = "recordPersLocal";
        Ticks[Ticks["recordPersCloud"] = 450] = "recordPersCloud";
        Ticks[Ticks["recordPersPartial"] = 451] = "recordPersPartial";
        Ticks[Ticks["recordExported"] = 452] = "recordExported";
        Ticks[Ticks["dbgEvent"] = 453] = "dbgEvent";
        Ticks[Ticks["dbgLogEvent"] = 454] = "dbgLogEvent";
        Ticks[Ticks["learnPlayVideo"] = 455] = "learnPlayVideo";
        Ticks[Ticks["learnBrowseDoc"] = 456] = "learnBrowseDoc";
        Ticks[Ticks["offlineLoginSync"] = 457] = "offlineLoginSync";
        Ticks[Ticks["offlineLoginSyncNoToken"] = 458] = "offlineLoginSyncNoToken";
        Ticks[Ticks["offlineLoginGettingStarted"] = 459] = "offlineLoginGettingStarted";
        Ticks[Ticks["offlineEnsureLogin"] = 460] = "offlineEnsureLogin";
        Ticks[Ticks["offlineEnsureLoginOk"] = 461] = "offlineEnsureLoginOk";
        Ticks[Ticks["translateNagDisplay"] = 462] = "translateNagDisplay";
        Ticks[Ticks["translateNagOk"] = 463] = "translateNagOk";
        Ticks[Ticks["benchmarksNagDisplay"] = 464] = "benchmarksNagDisplay";
        Ticks[Ticks["benchmarksNagDismiss"] = 465] = "benchmarksNagDismiss";
        Ticks[Ticks["benchmarksNagRunOne"] = 466] = "benchmarksNagRunOne";
        Ticks[Ticks["benchmarksNagRunSuite"] = 467] = "benchmarksNagRunSuite";
        Ticks[Ticks["songAlbumPlay"] = 468] = "songAlbumPlay";
        Ticks[Ticks["songPlay"] = 469] = "songPlay";
        Ticks[Ticks["warningNotificationTap"] = 470] = "warningNotificationTap";
        Ticks[Ticks["crashDialogEdit"] = 471] = "crashDialogEdit";
        Ticks[Ticks["crashDialogDebug"] = 472] = "crashDialogDebug";
        Ticks[Ticks["toLibNewLib"] = 473] = "toLibNewLib";
        Ticks[Ticks["toLibExistingLib"] = 474] = "toLibExistingLib";
        Ticks[Ticks["toLibOKtoMove"] = 475] = "toLibOKtoMove";
        Ticks[Ticks["toLibAdvanceSelectedToPending"] = 476] = "toLibAdvanceSelectedToPending";
        Ticks[Ticks["toLibMakeTheMove"] = 477] = "toLibMakeTheMove";
        Ticks[Ticks["toLibDiscardPending"] = 478] = "toLibDiscardPending";
        Ticks[Ticks["toLibExitToEditor"] = 479] = "toLibExitToEditor";
        Ticks[Ticks["collabFirstLoad"] = 480] = "collabFirstLoad";
        Ticks[Ticks["collabResume"] = 481] = "collabResume";
        Ticks[Ticks["collabRecordAst"] = 482] = "collabRecordAst";
        Ticks[Ticks["collabRealMerge"] = 483] = "collabRealMerge";
        Ticks[Ticks["collabPostChatMessage"] = 484] = "collabPostChatMessage";
        Ticks[Ticks["collabStartCollaboration"] = 485] = "collabStartCollaboration";
        Ticks[Ticks["collabStopCollaboration"] = 486] = "collabStopCollaboration";
        Ticks[Ticks["codeCompile"] = 487] = "codeCompile";
    })(TDev.Ticks || (TDev.Ticks = {}));
    var Ticks = TDev.Ticks;
    var Ticker;
    (function (Ticker) {
        var logMsgs = [];
        var logSz = 200;
        var logIdx = -1;
        var thresholdTime = -1;
        var dateStr = "";
        var sessionEvents = {};
        var disabled = false;
        var delay = 10;
        var chunkId = 1;
        var maxDelay = 300;
        var initialized = false;
        Ticker.mainJsName = "unknown";
        Ticker.fillEditorInfoBugReport;
        Ticker.fillEditorInfoTicksReport;
        function setDate() {
            var now = new Date();
            dateStr = TDev.Util.fmt("{0}.{1}.{2}", now.getFullYear(), now.getMonth() + 1, now.getDate());
            if (delay > maxDelay)
                delay = maxDelay;
            thresholdTime = now.getTime() + delay * 1000;
        }
        function disable() {
            disabled = true;
        }
        Ticker.disable = disable;
        function init() {
            if (/ckns_policy=..0/.test(document.cookie)) {
                disable();
                return;
            }
            var d = window.localStorage["ticksDelay"] * 1;
            if (d)
                delay = d;
            setDate();
            var archived = window.localStorage["archivedEvents"];
            if (archived) {
                var prevEvents;
                try {
                    prevEvents = JSON.parse(archived);
                }
                catch (e) {
                    TDev.Util.log("bogus JSON in archivedEvents: " + archived);
                    TDev.Util.check(false, "malformed JSON in archived events");
                    delete window.localStorage["archivedEvents"];
                }
                if (prevEvents) {
                    prevEvents.forEach(function (e) {
                        chunkId = Math.max(e.chunkId, chunkId);
                    });
                    chunkId++;
                    var last = prevEvents.peek();
                    if (!!last && last.dateStr == dateStr) {
                        sessionEvents = last.sessionEvents;
                        prevEvents.pop();
                        window.localStorage["archivedEvents"] = JSON.stringify(prevEvents);
                    }
                    sendOutEvents(prevEvents);
                }
            }
            usageTick();
            initialized = true;
        }
        Ticker.init = init;
        function saveCurrent(sendCurrent) {
            if (sendCurrent === void 0) { sendCurrent = false; }
            var prevEvents = [];
            var archived = window.localStorage["archivedEvents"];
            if (archived)
                prevEvents = JSON.parse(archived);
            prevEvents.push({
                sessionEvents: sessionEvents,
                dateStr: dateStr,
                chunkId: chunkId++
            });
            prevEvents = prevEvents.filter(function (e) { return !!e.dateStr; });
            if (prevEvents.length > 30)
                prevEvents = prevEvents.slice(prevEvents.length - 30);
            var newVal = JSON.stringify(prevEvents);
            if (newVal.length > 50000)
                newVal = "[]";
            window.localStorage["archivedEvents"] = newVal;
            if (sendCurrent && TDev.Cloud.hasAccessToken() && TDev.Cloud.isOnline())
                sendOutEvents(prevEvents);
        }
        Ticker.saveCurrent = saveCurrent;
        function checkDate() {
            if (TDev.Util.now() > thresholdTime) {
                setDate();
                saveCurrent(true);
                TDev.RT.Perf.saveCurrentAsync(true).done();
                if (delay < maxDelay) {
                    delay *= 1.1;
                    window.localStorage["ticksDelay"] = delay + "";
                }
                sessionEvents = {};
            }
        }
        function sendOutEvents(events) {
            if (events.length == 0)
                return;
            var currId = events[0].chunkId;
            var req = {
                dateStr: events[0].dateStr,
                sessionEvents: events[0].sessionEvents,
                platform: TDev.Browser.platformCaps,
                worldId: "",
                jsUrl: Ticker.mainJsName
            };
            if (Ticker.fillEditorInfoTicksReport)
                Ticker.fillEditorInfoTicksReport(req);
            function sendNextEvents() {
                var events = window.localStorage["archivedEvents"];
                if (events) {
                    var newEvents = JSON.parse(events);
                    window.localStorage["archivedEvents"] = JSON.stringify(newEvents.filter(function (t) { return t.chunkId != currId; }));
                    sendOutEvents(newEvents);
                }
            }
            if (Object.keys(req.sessionEvents).length == 0)
                sendNextEvents();
            else
                TDev.Cloud.postTicksAsync(req).done(function () { return sendNextEvents(); }, function (e) {
                });
        }
        function tickName(t) {
            return TDev.enumToString(Ticks, t);
        }
        Ticker.tickName = tickName;
        function tickN(t, v) {
            tick(t + TDev.Util.boundTo(0, v, 5));
        }
        Ticker.tickN = tickN;
        function dbg(f) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            var msg = TDev.Util.fmt_va(f, args);
            tick(453 /* dbgEvent */, msg);
        }
        Ticker.dbg = dbg;
        function localStorageState() {
            if (!window || !window.localStorage)
                return "";
            var l = window.localStorage;
            var r = "";
            for (var i = 0; i < l.length; ++i) {
                r += l.key(i) + " -> " + l[l.key(i)].length + ",  ";
            }
            return r;
        }
        Ticker.localStorageState = localStorageState;
        function mkReportId() {
            return "BuG" + (20000000000000 - Date.now()) + TDev.Random.uniqueId(12);
        }
        Ticker.mkReportId = mkReportId;
        function mkBugReport(err, ctx) {
            if (ctx === void 0) { ctx = ""; }
            var r = {
                exceptionConstructor: "(unknown)",
                exceptionMessage: "(unknown)",
                context: ctx,
                currentUrl: "",
                worldId: "",
                kind: "",
                scriptId: "",
                stackTrace: "",
                sourceURL: "",
                line: -1,
                eventTrace: "",
                userAgent: "",
                resolution: "",
                jsUrl: Ticker.mainJsName,
                timestamp: TDev.Util.now(),
                platform: [],
                attachments: [],
                tdVersion: TDev.Cloud.config.tdVersion || "",
                reportId: mkReportId(),
            };
            if (Ticker.fillEditorInfoBugReport)
                Ticker.fillEditorInfoBugReport(r);
            if (Array.isArray(err.bugAttachments))
                r.attachments.pushRange(err.bugAttachments);
            var meta = err.tdMeta;
            if (meta) {
                if (meta.reportId)
                    r.reportId = meta.reportId;
            }
            try {
                var isDatabaseError = TDev.Util.isError(err, function (e) { return e.isDatabaseError; });
                var isNetworkError = TDev.Util.isError(err, function (e) { return e.isNetworkError; });
                r.kind = isDatabaseError ? "databaseError" : isNetworkError ? "networkError" : "";
                if (!err)
                    r.exceptionMessage = "(null)";
                else if (err.message) {
                    r.exceptionMessage = err.message + "";
                    if (err.stack)
                        r.stackTrace = err.stack + "";
                    else if (err.sourceURL)
                        r.stackTrace = "@" + err.sourceURL + ":" + err.line;
                }
                else if (Array.isArray(err)) {
                    r.exceptionMessage = err.join("\n");
                }
                else {
                    r.exceptionMessage = err + "";
                }
                if (err && err.name && err.name != "Error")
                    r.exceptionConstructor = err.name;
                else
                    r.exceptionConstructor = r.exceptionMessage.substr(0, 40);
                if (isDatabaseError)
                    r.exceptionConstructor = "DB " + r.exceptionConstructor;
                if (/autotest-/.test(ctx))
                    r.exceptionConstructor = "TEST " + r.exceptionConstructor;
                if (/^bitvm/.test(ctx))
                    r.exceptionConstructor = "BITVM " + r.exceptionConstructor;
                if (r.exceptionMessage && /\[object /.test(r.exceptionMessage)) {
                    var msg = r.exceptionMessage;
                    var errorInfo = TDev.Util.getErrorInfo(err);
                    if (errorInfo)
                        msg += " " + errorInfo;
                    else
                        Object.keys(err).forEach(function (k) {
                            if (msg.length < 2000) {
                                msg += " " + k + ": '" + err[k] + "'";
                            }
                        });
                    r.exceptionMessage = msg;
                }
                if (/QUOTA/.test(r.exceptionMessage))
                    r.exceptionMessage += "  " + localStorageState();
                if (ctx != "custom")
                    Ticker.dbg("CRASH REPORT " + r.exceptionMessage);
                if (err.sourceURL)
                    r.sourceURL = err.sourceURL;
                if (err.line)
                    r.line = err.line;
            }
            catch (e) {
                debugger;
            }
            try {
                r.logMessages = TDev.Util.getLogMsgs();
                r.logMessages.reverse();
                var maxSize = 100000;
                var maxIter = 20;
                while (JSON.stringify(r.logMessages).length > maxSize) {
                    r.logMessages = r.logMessages.slice(0, Math.floor(r.logMessages.length / 2));
                    if (maxIter-- < 0) {
                        r.logMessages = [];
                        break;
                    }
                }
                r.eventTrace = "";
            }
            catch (e) {
                debugger;
            }
            if (ctx != "custom" && window.tdAppInsights)
                try {
                    window.tdAppInsights.trackException(err, r);
                }
                catch (e) {
                }
            return r;
        }
        Ticker.mkBugReport = mkBugReport;
        function bugReportToString(b, short) {
            if (short === void 0) { short = false; }
            var e = function (s) { return s.replace(/\r?\n/, " "); };
            var r = "Error: " + e(b.exceptionMessage) + "\n" + "URL: " + e(b.currentUrl) + " (script: " + e(b.scriptId) + ", context: " + e(b.context) + ")\n" + "JS-URL: " + e(b.jsUrl) + "\n" + "Platform: " + e(TDev.Browser.platformCaps.join(", ")) + "\n" + "UserAgent: " + e(b.userAgent) + " (resolution: " + e(b.resolution) + ")\n" + "Date: " + new Date(b.timestamp).toString() + "\n";
            if (!short)
                r += "\n" + "RecentEvents:\n" + b.eventTrace + "\n\n" + "StackTrace:\n" + b.stackTrace + "\n\n";
            return r;
        }
        Ticker.bugReportToString = bugReportToString;
        function bugReportForHash(b) {
            return b.exceptionMessage + " " + b.stackTrace;
        }
        Ticker.bugReportForHash = bugReportForHash;
        function rawTick(tn) {
            TDev.Util.log("TICK: " + tn);
            if (!initialized || disabled)
                return;
            checkDate();
            tn = tn.replace(/[^a-zA-Z_]/g, "_");
            if (shouldStoreTick(tn))
                if (sessionEvents[tn])
                    sessionEvents[tn]++;
                else
                    sessionEvents[tn] = 1;
        }
        Ticker.rawTick = rawTick;
        function shouldStoreTick(tn) {
            if (!tn)
                return false;
            if (TDev.Cloud.config.tickFilter)
                return !!TDev.Cloud.config.tickFilter[tn.replace(/\|.*/, "")];
            else
                return true;
        }
        function tickBase(t, sep, arg) {
            if (t == 0 /* noEvent */ || !t)
                return;
            var tn = tickName(t);
            if (arg)
                tn += sep + arg;
            if (t == 454 /* dbgLogEvent */) {
                t = 453 /* dbgEvent */;
            }
            else if (t == 453 /* dbgEvent */)
                TDev.Util.log("DBG: " + tn);
            else
                TDev.Util.log("TICK: " + tn);
            if (!initialized || disabled)
                return;
            checkDate();
            var m = { timestamp: TDev.Util.now(), event: t, arg: arg };
            if (logIdx >= 0) {
                logMsgs[logIdx++] = m;
                if (logIdx >= logSz)
                    logIdx = 0;
            }
            else {
                logMsgs.push(m);
                if (logMsgs.length >= logSz)
                    logIdx = 0;
            }
            if (t != 453 /* dbgEvent */)
                poke();
            if (t != 453 /* dbgEvent */ && shouldStoreTick(tn)) {
                if (sessionEvents[tn])
                    sessionEvents[tn]++;
                else
                    sessionEvents[tn] = 1;
                if (window.tdAppInsights)
                    try {
                        window.tdAppInsights.trackEvent(tn);
                    }
                    catch (e) {
                    }
            }
        }
        function tickArg(t, arg) {
            return tickBase(t, "$", arg);
        }
        Ticker.tickArg = tickArg;
        function tick(t, arg) {
            return tickBase(t, "|", arg);
        }
        Ticker.tick = tick;
        function getRecentEvents() {
            if (logIdx >= 0)
                return logMsgs.slice(logIdx).concat(logMsgs.slice(0, logIdx));
            else
                return logMsgs.slice(0);
        }
        Ticker.getRecentEvents = getRecentEvents;
        function usageTick() {
            var id = getCurrentEditorId();
            if (id && !document.hidden && lastPoke) {
                if (TDev.Browser.isCellphone)
                    id += "_mobile";
                rawTick("editor_" + id);
                lastPoke = 0;
            }
            TDev.Util.setTimeout(TDev.RT.Math_.random_range(3000, 17000), usageTick);
        }
        var currentEditorId;
        var lastPoke;
        function poke() {
            lastPoke = TDev.Util.now();
        }
        Ticker.poke = poke;
        function setCurrentEditorId(id) {
            TDev.Util.log("set editor: " + id);
            currentEditorId = id;
        }
        Ticker.setCurrentEditorId = setCurrentEditorId;
        function getCurrentEditorId() {
            return currentEditorId;
        }
        Ticker.getCurrentEditorId = getCurrentEditorId;
    })(Ticker = TDev.Ticker || (TDev.Ticker = {}));
    function tick(t, arg) {
        Ticker.tick(t, arg);
    }
    TDev.tick = tick;
    function tickArg(t, arg) {
        Ticker.tickArg(t, arg);
    }
    TDev.tickArg = tickArg;
    function tickN(t, v) {
        Ticker.tickN(t, v);
    }
    TDev.tickN = tickN;
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    TDev.snapView = false;
    var SizeMgr;
    (function (SizeMgr) {
        SizeMgr.topFontSize = 24;
        SizeMgr.windowHeight = 800;
        SizeMgr.windowWidth = 1300;
        SizeMgr.wallWindowWidth = 1300;
        SizeMgr.editorWindowWidth = 1300;
        SizeMgr.portraitMode = false;
        SizeMgr.phoneMode = false;
        SizeMgr.devicePixelRatio = 1;
        SizeMgr.hubFontSize = 30;
        SizeMgr.lastOrientationLockTime = 0;
        SizeMgr.splitScreen = false;
        SizeMgr.splitScreenRequested = false;
        var phoneSimulationW = -1;
        var phoneSimulationH = -1;
        var previousHeight = 0;
        var previousWidth = 0;
        var savedPortraitWidth = 320;
        var savedPortraitHeight = 460;
        function setupPhoneSimulation() {
            if (phoneSimulationW >= 0)
                return;
            var m = /phone=([\d\.]+)(x([\d\.]+))?/.exec(window.document.URL);
            if (m) {
                phoneSimulationW = parseFloat(m[1]);
                var h = m[3];
                if (!h)
                    h = m[1];
                phoneSimulationH = parseFloat(h);
            }
            else {
                phoneSimulationW = 0;
                phoneSimulationH = 0;
            }
        }
        function earlyInit() {
            SizeMgr.phoneMode = TDev.Browser.isCellphone || /phone=([\d\.]+)/.test(window.document.URL);
        }
        SizeMgr.earlyInit = earlyInit;
        function canSplitScreen() {
            return !SizeMgr.phoneMode && !SizeMgr.portraitMode && SizeMgr.windowWidth * 1.2 > SizeMgr.windowHeight;
        }
        SizeMgr.canSplitScreen = canSplitScreen;
        function setSplitScreen(isSplit) {
            SizeMgr.splitScreenRequested = isSplit;
            var newSplit = SizeMgr.splitScreenRequested && canSplitScreen();
            if (newSplit != SizeMgr.splitScreen) {
                SizeMgr.splitScreen = newSplit;
                applySizes(true);
            }
        }
        SizeMgr.setSplitScreen = setSplitScreen;
        function applySizes(force) {
            if (force === void 0) { force = false; }
            setupPhoneSimulation();
            var h = window.innerHeight;
            var w = window.innerWidth;
            if (TDev.Browser.isTrident && TDev.Browser.isCellphone) {
                if (w < h) {
                    SizeMgr.devicePixelRatio = window.screen.width / w;
                }
                else {
                    SizeMgr.devicePixelRatio = window.screen.height / w;
                }
            }
            TDev.Ticker.dbg("resize(prev w={0} h={1}, curr w={2} h={3})", previousWidth, previousHeight, w, h);
            if (!force && previousHeight > 0) {
                if (TDev.Browser.isTouchDevice && Math.abs(w - previousWidth) < 30 && Math.abs(previousHeight - h) > 1) {
                    if (TDev.Util.now() - SizeMgr.lastOrientationLockTime > 600) {
                        return;
                    }
                }
            }
            if (TDev.Browser.brokenResize) {
                if (w < h) {
                    if (h <= 300) {
                        w = savedPortraitWidth;
                        h = savedPortraitHeight;
                        TDev.Ticker.dbg("brokenResize, fixing up to {0}x{1}", w, h);
                    }
                    else {
                        savedPortraitWidth = w;
                        savedPortraitHeight = h;
                    }
                }
            }
            if (TDev.Browser.browser == 9 /* safari */ && TDev.Browser.isCellphone) {
                if (350 < h && h <= 416)
                    h = 417;
            }
            if (TDev.Browser.mobileWebkit) {
                TDev.Util.setTimeout(100, function () {
                    window.scrollTo(0, 1);
                });
            }
            var origW = w;
            var origH = h;
            var applySim = function (w, simW) { return simW <= 0 ? w : simW <= 2 ? simW * w : simW; };
            w = applySim(w, phoneSimulationW);
            h = applySim(h, phoneSimulationH);
            if (!force && h == previousHeight && w == previousWidth)
                return;
            previousHeight = h;
            previousWidth = w;
            var portraitThreshold = TDev.Browser.isDesktop ? 0.9 : 1.2;
            SizeMgr.portraitMode = w * portraitThreshold < h;
            if (TDev.Browser.isCellphone)
                SizeMgr.phoneMode = true;
            if (phoneSimulationW > 0) {
                SizeMgr.phoneMode = true;
            }
            SizeMgr.splitScreen = SizeMgr.splitScreenRequested && canSplitScreen();
            if (SizeMgr.phoneMode || SizeMgr.splitScreen)
                SizeMgr.portraitMode = true;
            TDev.Util.log("view:" + (SizeMgr.portraitMode ? " portrait" : " landscape") + (SizeMgr.phoneMode ? " phone" : "") + (SizeMgr.splitScreen ? " split" : "") + " size:" + w + "x" + h);
            var statusBarSize = 0;
            SizeMgr.windowHeight = h;
            SizeMgr.windowWidth = w;
            if (SizeMgr.splitScreen) {
                SizeMgr.editorWindowWidth = SizeMgr.windowWidth / 1.618;
                SizeMgr.wallWindowWidth = SizeMgr.windowWidth - SizeMgr.editorWindowWidth;
            }
            else {
                SizeMgr.editorWindowWidth = SizeMgr.windowWidth;
                SizeMgr.wallWindowWidth = SizeMgr.windowWidth;
            }
            SizeMgr.topFontSize = Math.floor(Math.min(h / 25, SizeMgr.editorWindowWidth / (SizeMgr.phoneMode ? 25 : SizeMgr.portraitMode ? 36 : 55)));
            if (SizeMgr.splitScreen)
                SizeMgr.wallWindowWidth -= 0.15 * SizeMgr.topFontSize;
            var zoom = window.localStorage["zoomFactor"];
            if (zoom && parseFloat(zoom)) {
                SizeMgr.topFontSize = Math.round(SizeMgr.topFontSize * TDev.Util.between(0.3, parseFloat(zoom), 2));
            }
            TDev.elt("root").style.height = h + "px";
            if (phoneSimulationW > 0)
                TDev.elt("root").style.width = w + "px";
            if (!TDev.Browser.isMobile)
                SizeMgr.topFontSize = 16;
            TDev.elt("root").style.fontSize = SizeMgr.topFontSize + "px";
            var rootClass = SizeMgr.portraitMode ? "portrait" : "landscape";
            if (SizeMgr.phoneMode)
                rootClass += " phone";
            if (SizeMgr.splitScreen)
                rootClass += " split";
            if (TDev.Browser.assumeMouse)
                rootClass += " assume-mouse";
            if (TDev.Browser.assumeMouse && TDev.Browser.browser != 1 /* ie10 */ && TDev.Browser.browser != 2 /* ie11 */)
                rootClass += " assume-notouch";
            if (SizeMgr.topFontSize <= 12)
                rootClass += " tinyFont";
            if (SizeMgr.topFontSize <= 18)
                rootClass += " smallFont";
            rootClass += " rootClass";
            if (TDev.Browser.brokenColumns)
                rootClass += " brokenColumns";
            TDev.elt("root").className = rootClass;
            var rootStyle = TDev.elt("root").style;
            if (phoneSimulationW > 0) {
                rootStyle.left = (origW - w) / 2 + "px";
                rootStyle.top = (origH - h) / 2 + "px";
                rootStyle.background = "#fff";
                document.body.style.background = "#666";
            }
            if (TDev.currentScreen)
                TDev.currentScreen.applySizes();
        }
        SizeMgr.applySizes = applySizes;
        function getColumnWidth() {
            return this.portraitMode ? (window.innerWidth - (2 * this.topFontSize)) : (18.5 * this.topFontSize);
        }
        SizeMgr.getColumnWidth = getColumnWidth;
    })(SizeMgr = TDev.SizeMgr || (TDev.SizeMgr = {}));
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    TDev.currentScreen = null;
    TDev.allScreens = [];
    var HistoryMgr = (function () {
        function HistoryMgr() {
            var _this = this;
            this.numReloads = 0;
            this.urlStack = [];
            this.numPush = 1;
            this.lastSetHash = "";
            this.replaceNext = false;
            Screen.pushModalHash = function (s, f) { return _this.pushModalHash(s, f); };
            Screen.popModalHash = function (s) { return _this.popModalHash(s); };
            HistoryMgr.instance = this;
            TDev.Util.onSetHash = function (s, r) { return _this.setHashHandler(s, r); };
            TDev.Util.onGoBack = function () { return _this.back(); };
        }
        HistoryMgr.prototype.currentHash = function () {
            return this.lastSetHash;
        };
        HistoryMgr.urlHash = function (url) {
            var i = url.indexOf('#');
            if (i > 0 && i < url.length - 1)
                return url.slice(i);
            else
                return "#" + TDev.hubHash;
        };
        HistoryMgr.windowHash = function () {
            var h = window.location.href;
            return HistoryMgr.urlHash(h);
        };
        HistoryMgr.prototype.pushState = function (h) {
            try {
                TDev.Util.log("pushState: " + h);
                h = window.location.href.replace(/#.*/, "") + (h || "");
                window.history.pushState(++this.numPush, null, h);
            }
            catch (e) {
            }
        };
        HistoryMgr.prototype.setHash = function (h, t) {
            TDev.Util.log("sethash: " + h + " - " + t);
            TDev.Ticker.dbg("History.setHash|" + h);
            var repl = this.replaceNext;
            this.replaceNext = false;
            if (repl) {
                TDev.Ticker.dbg("History.setHash is a replace");
            }
            this.numReloads++;
            if (!/^#/.test(h))
                h = "#" + h;
            if (h == "#" + TDev.hubHash)
                h = "#";
            this.clearModalSuffix();
            Screen.arrivedAtHash(h);
            if (this.urlStack.length == 0 || this.urlStack.peek().url != h) {
                this.urlStack.push({ url: h, onPop: function () {
                } });
                this.pushState(h);
            }
            else {
                TDev.Ticker.dbg("setHash.. ignoring same hash");
            }
            if (t !== null) {
                if (t)
                    document.title = t + " - " + TDev.Runtime.appName;
                else
                    document.title = TDev.Runtime.appName;
            }
        };
        HistoryMgr.prototype.pushModalHash = function (s, f) {
            var hash = '#modal-' + s;
            if (this.urlStack.length > 0 && this.urlStack.peek().url == hash) {
                this.urlStack.pop();
            }
            this.urlStack.push({ url: hash, onPop: f });
            this.pushState(this.topHash());
            Screen.arrivedAtHash(hash);
        };
        HistoryMgr.prototype.popModalHash = function (s) {
            TDev.Ticker.dbg("popModal " + s);
            var hash = '#modal-' + s;
            var index = -1;
            for (var i = 0; i < this.urlStack.length; i++) {
                if (this.urlStack[i].url == hash) {
                    index = i;
                    this.urlStack[i].onPop = null;
                    break;
                }
            }
            if (index < 0)
                return;
            this.popBack(this.urlStack.length - index);
        };
        HistoryMgr.prototype.popBack = function (toPop) {
            if (toPop === void 0) { toPop = 1; }
            TDev.Ticker.dbg("historyMgr: popBack " + toPop);
            var popped = this.urlStack.splice(this.urlStack.length - toPop, toPop);
            var seenNonModal = false;
            for (var i = popped.length - 1; i >= 0; i--) {
                var entry = popped[i];
                if (!/#modal-/.test(entry.url))
                    seenNonModal = true;
                if (entry.onPop) {
                    var f = entry.onPop;
                    entry.onPop = null;
                    f();
                }
            }
            var last = this.urlStack.peek();
            Screen.arrivedAtHash(last ? last.url : "#");
            if (seenNonModal)
                this.dispatch(this.topHash());
            else
                this.hashReloaded();
        };
        HistoryMgr.prototype.hashReloaded = function () {
            this.pushState(this.topHash());
        };
        HistoryMgr.prototype.topHash = function () {
            for (var i = this.urlStack.length - 1; i >= 0; i--) {
                var t = this.urlStack[i];
                if (t && !/^#modal-/.test(t.url))
                    return t.url;
            }
            return "#";
        };
        HistoryMgr.prototype.dispatch = function (h) {
            TDev.Util.log("dispatch: " + h);
            TDev.ModalDialog.dismissCurrent();
            this.pushState(h);
            this.reload(h);
        };
        HistoryMgr.prototype.initialHash = function () {
            this.setHashHandler(HistoryMgr.windowHash(), true);
            if (this.lastSetHash == "" && !this.replaceNext) {
                this.pushState(null);
                this.replaceNext = true;
                this.showStartScreen();
            }
        };
        HistoryMgr.prototype.showStartScreen = function () {
        };
        HistoryMgr.prototype.reload = function (hash) {
        };
        HistoryMgr.prototype.confirmLoadHash = function () {
            TDev.Ticker.dbg("History.confirmLoadHash");
            this.replaceNext = false;
        };
        HistoryMgr.prototype.clearModalSuffix = function () {
            for (var i = 0; i < this.urlStack.length; i++) {
                if (/^#modal-/.test(this.urlStack[i].url)) {
                    var removed = this.urlStack.splice(i, this.urlStack.length - i);
                    return removed.length;
                }
            }
            return 0;
        };
        HistoryMgr.prototype.clearModalStack = function () {
            var n = this.clearModalSuffix();
        };
        HistoryMgr.prototype.commandHandler = function (h) {
        };
        HistoryMgr.prototype.popState = function (event) {
            var _this = this;
            TDev.Ticker.dbg("popState: " + event.state);
            if (this.urlStack.length == 1) {
                window.history.back();
                return;
            }
            var h = HistoryMgr.windowHash();
            if (/^#cmd:/.test(h)) {
                var nh = this.topHash();
                this.whenSafe(function () {
                    _this.pushState(nh);
                    _this.commandHandler(h);
                });
            }
            else {
                this.back();
            }
        };
        HistoryMgr.prototype.back = function () {
            var _this = this;
            this.whenSafe(function () { return _this.popBack(); });
        };
        HistoryMgr.prototype.whenSafe = function (f) {
            var _this = this;
            if (TDev.ProgressOverlay.isActive())
                TDev.Util.setTimeout(500, function () { return _this.whenSafe(f); });
            else
                f();
        };
        HistoryMgr.prototype.setHashHandler = function (h, replace) {
            var _this = this;
            this.whenSafe(function () {
                if (!h)
                    h = "#";
                if (!/^#/.test(h))
                    h = "#" + h;
                if (replace) {
                    for (var i = _this.urlStack.length - 1; i >= 0; --i) {
                        if (_this.urlStack[i].url == h) {
                            if (i == _this.urlStack.length - 1) {
                                TDev.Util.log("replaced hash already current, skipping " + h);
                                return;
                            }
                            else {
                                TDev.Util.log("found hash to replace in stack, popping " + h);
                                _this.popBack(_this.urlStack.length - 1 - i);
                                return;
                            }
                        }
                    }
                }
                _this.dispatch(h);
            });
        };
        HistoryMgr.prototype.scriptOrHub = function (h) {
            var id = h.filter(function (s) { return /^id=/.test(s); })[0];
            if (id) {
                var scr = id.replace(/^id=/, "script:");
                if (h[0] == "list")
                    TDev.Util.setHash(h[0] + ":" + h[1] + ":" + scr, true);
                else
                    TDev.Util.setHash(scr, true);
            }
            else {
                TDev.Util.setHash(TDev.hubHash, true);
            }
        };
        HistoryMgr.prototype.hashChange = function () {
            TDev.Util.log("hashChange: " + HistoryMgr.windowHash());
        };
        return HistoryMgr;
    })();
    TDev.HistoryMgr = HistoryMgr;
    var Screen = (function () {
        function Screen() {
            this.paneState = 0;
        }
        Screen.prototype.init = function () {
        };
        Screen.prototype.hide = function () {
        };
        Screen.prototype.screenId = function () {
            return "";
        };
        Screen.prototype.loadHash = function (h) {
        };
        Screen.prototype.keyDown = function (e) {
            return false;
        };
        Screen.prototype.applySizes = function () {
        };
        Screen.prototype.syncDone = function () {
        };
        Screen.prototype.hashReloaded = function () {
        };
        Screen.prototype.autoHide = function () {
            return TDev.SizeMgr.portraitMode;
        };
        Screen.prototype.sidePaneVisible = function () {
            return !this.autoHide() || this.sidePane().style.display == "block";
        };
        Screen.prototype.sidePaneVisibleNow = function () {
            return !this.autoHide() || this.paneState > 0;
        };
        Screen.prototype.updateSidePane = function () {
            var pane = this.sidePane();
            if (!this.autoHide()) {
                pane.style.display = "block";
                pane.style.opacity = "1";
            }
            else if (this.autoHide() && this.paneState < 0) {
                pane.style.display = "none";
            }
            TDev.elt("root").setFlag("pane-hidden", pane.style.display == "none");
        };
        Screen.prototype.showSidePane = function () {
            var _this = this;
            if (!this.autoHide() || this.paneState > 0)
                return;
            Screen.pushModalHash("side", function () { return _this.hideSidePane(); });
            TDev.elt("root").setFlag("pane-hidden", false);
            this.paneState = 1;
            var pane = this.sidePane();
            pane.style.display = "block";
            pane.style.opacity = "1";
            TDev.Util.showRightPanel(pane);
        };
        Screen.prototype.sidePane = function () {
            return null;
        };
        Screen.prototype.hideSidePane = function () {
            var _this = this;
            var pane = this.sidePane();
            if (!this.autoHide()) {
                pane.style.display = "block";
                pane.style.opacity = "1";
                return;
            }
            if (this.paneState < 0)
                return;
            Screen.popModalHash("side");
            TDev.elt("root").setFlag("pane-hidden", true);
            this.paneState = -1;
            TDev.Util.hidePopup(pane, function () {
                if (_this.paneState < 0 && _this.autoHide())
                    pane.style.display = "none";
            });
        };
        Screen.prototype.hashCommandHandler = function (h) {
        };
        Screen.pushModalHash = function (s, removeCb) {
        };
        Screen.popModalHash = function (s) {
        };
        Screen.arrivedAtHash = function (s) {
        };
        return Screen;
    })();
    TDev.Screen = Screen;
    var KeyboardMgr = (function () {
        function KeyboardMgr() {
            this.handlers = {};
        }
        KeyboardMgr.prototype.register = function (key, cb) {
            if (/^-/.test(key))
                return;
            this.handlers[key] = cb;
        };
        KeyboardMgr.prototype.saveState = function () {
            return TDev.Util.flatClone(this.handlers);
        };
        KeyboardMgr.prototype.loadState = function (s) {
            if (!TDev.Util.check(!!s))
                return;
            this.handlers = s;
        };
        KeyboardMgr.prototype.triggerKey = function (name) {
            var h = this.handlers[name];
            if (h && h.isBtnShortcut)
                h();
        };
        KeyboardMgr.triggerClick = function (e) {
            var h = e.clickHandler;
            if (!!h) {
                var active = document.activeElement;
                if (!!active && !!active.blur)
                    active.blur();
                e.setFlag("active", true);
                TDev.Util.setTimeout(150, function () {
                    e.setFlag("active", false);
                });
                h.fireClick({});
            }
        };
        KeyboardMgr.elementVisible = function (e) {
            while (e) {
                if (e.id == "root")
                    return true;
                if (window.getComputedStyle(e).display == "none")
                    return false;
                e = e.parentNode;
            }
            return false;
        };
        KeyboardMgr.prototype.btnShortcut = function (e, key) {
            var _this = this;
            if (!key)
                return;
            var handle = function () {
                if (KeyboardMgr.elementVisible(e)) {
                    KeyboardMgr.triggerClick(e);
                    return true;
                }
                return false;
            };
            handle.isBtnShortcut = true;
            if (!/^ /.test(key))
                key.split(", ").forEach(function (k) { return _this.register(k, handle); });
            e.title = key.replace(/(^| )-/g, "");
        };
        KeyboardMgr.prototype.keyUp = function (e) {
            TDev.Util.normalizeKeyEvent(e);
            if (/-(Control|Alt)$/.test(e.keyName))
                return true;
            var h = this.handlers["*keyup*"];
            if (h) {
                TDev.Ticker.dbg("keyUp.run");
                if (h(e))
                    return true;
            }
        };
        KeyboardMgr.prototype.processKey = function (e) {
            TDev.Util.normalizeKeyEvent(e);
            if (/-(Control|Alt)$/.test(e.keyName))
                return true;
            if (TDev.Browser.isGecko) {
                var isRepeated = e.type == "keypress" && this.previousStoppedEvent && this.previousStoppedEvent.type == "keydown";
                this.previousStoppedEvent = null;
                if (isRepeated)
                    return e.stopIt();
            }
            if (this.keyHandler(e)) {
                if (TDev.Browser.isGecko)
                    this.previousStoppedEvent = e;
                return e.stopIt();
            }
        };
        KeyboardMgr.prototype.attach = function (inp) {
            var _this = this;
            inp.onkeydown = TDev.Util.catchErrors("textboxKey", function (e) {
                e.fromTextBox = true;
                return _this.processKey(e);
            });
        };
        KeyboardMgr.prototype.keyHandler = function (e) {
            if (TDev.ProgressOverlay.isKeyboardBlocked())
                return true;
            if (e.keyName == "Ctrl-Control")
                return false;
            if (/^(Del|Ctrl-[CXVA]|Shift-(Left|Right)|(Ctrl|Shift)-(Ins|Del))$/.test(e.keyName) && e.fromTextBox)
                return false;
            if (TDev.dbg && e.keyName)
                TDev.tick(3 /* mainKeyEvent */);
            h = this.handlers["*keydown*"];
            if (h) {
                if (TDev.dbg && e.keyName)
                    TDev.Ticker.dbg("keyHandler.preCatchAll." + e.keyName);
                if (h(e))
                    return true;
            }
            var h = this.handlers[e.keyName];
            if (h) {
                if (TDev.dbg && e.keyName)
                    TDev.Ticker.dbg("keyHandler.byName." + e.keyName);
                if (h(e))
                    return true;
            }
            h = this.handlers["***"];
            if (h) {
                if (TDev.dbg && e.keyName)
                    TDev.Ticker.dbg("keyHandler.catchAll." + e.keyName);
                if (h(e))
                    return true;
            }
            if (TDev.currentScreen) {
                if (TDev.dbg && e.keyName)
                    TDev.Ticker.dbg("keyHandler.currentScreen." + e.keyName);
                if (TDev.currentScreen.keyDown(e))
                    return true;
            }
            if (e.keyCode == 8 && !e.fromTextBox)
                return true;
            return false;
        };
        KeyboardMgr.instance = new KeyboardMgr();
        return KeyboardMgr;
    })();
    TDev.KeyboardMgr = KeyboardMgr;
})(TDev || (TDev = {}));
var TDev;
(function (TDev) {
    var LayoutMgr = (function () {
        function LayoutMgr() {
            this.onBoxSelected = function () {
            };
            this.onRendered = function () {
            };
            this.numBoxes = 0;
            this.scrollspeculation = true;
            this.currentAstNodeId = "";
            this.selectedBox = null;
            this.boxMenu = null;
            this.scrollTop = undefined;
            this.scrollLeft = undefined;
            this.sideview = false;
            this.scrollbarWidth = undefined;
            this.scrollbarHeight = undefined;
        }
        LayoutMgr.prototype.updateEditMode = function (rt) {
            this.editMode = rt.liveViewSupported() && (rt.isStopped() || rt.liveMode());
            if (this.editMode) {
            }
            else {
                if (this.currentAstNodeId) {
                    this.clearRelatedBoxes();
                }
                if (this.selectedBox !== null) {
                    this.unselectBox();
                }
                this.adjustForNormalView();
            }
            if (!!this.rootBox)
                this.updateRootElement();
        };
        LayoutMgr.RenderExecutionMode = function () {
            return LayoutMgr.renderexecutionmode;
        };
        LayoutMgr.SetRenderExecutionMode = function (val) {
            LayoutMgr.renderexecutionmode = val;
        };
        LayoutMgr.QueueReLayout = function () {
            var check = function () {
                if (LayoutMgr.needrelayout) {
                    if (!LayoutMgr.renderexecutionmode && LayoutMgr.instance.rootBox) {
                        LayoutMgr.instance.CoreLayout();
                        LayoutMgr.needrelayout = false;
                    }
                    else
                        TDev.Util.setTimeout(100, check);
                }
            };
            if (!LayoutMgr.needrelayout) {
                LayoutMgr.needrelayout = true;
                TDev.Util.setTimeout(50, check);
            }
        };
        LayoutMgr.prototype.adjustForSideView = function () {
            if (!this.sideview) {
                this.rootElement.style.overflow = "auto";
                this.rootElement.style.msContentZooming = "zoom";
                if (this.rootBox instanceof WallBox)
                    this.rootBox.setRenderedSideView(true);
                this.updateRootElement();
                this.sideview = true;
            }
        };
        LayoutMgr.prototype.adjustForNormalView = function () {
            if (this.sideview) {
                var rootelt = this.rootElement;
                rootelt.style.overflow = "";
                rootelt.style.msContentZooming = "";
                rootelt.scrollTop = 0;
                rootelt.scrollLeft = 0;
                rootelt.msContentZoomFactor = 1;
                if (this.rootBox instanceof WallBox)
                    this.rootBox.setRenderedSideView(false);
                this.updateRootElement();
                this.sideview = false;
            }
        };
        LayoutMgr.prototype.FlagTypingActivity = function (id) {
            this.lastbox_edited = id;
        };
        LayoutMgr.prototype.ClearTypingActivity = function (id) {
            if (this.lastbox_edited === id)
                this.lastbox_edited = undefined;
        };
        LayoutMgr.prototype.CheckTypingActivity = function (id) {
            return this.lastbox_edited === id;
        };
        LayoutMgr.createOrRecycleContainerBoxDelayed = function (rt, cur) {
            var pc = rt.getTopScriptPc();
            LayoutMgr.lazyInitCurrentRanderBox = function () {
                LayoutMgr.lazyInitCurrentRanderBox = function () {
                };
                var tag = LayoutMgr.htmlTagName || "div";
                LayoutMgr.htmlTagName = undefined;
                var w = WallBox.CreateOrRecycleContainerBox(rt, cur, pc, tag);
                LayoutMgr.currentbox = w;
            };
            LayoutMgr.currentbox = null;
        };
        LayoutMgr.setHtmlTagName = function (name) {
            if (LayoutMgr.currentbox)
                TDev.Util.userError(TDev.lf("you cannot set the HTML tag name here"));
            LayoutMgr.htmlTagName = name;
        };
        LayoutMgr.getCurrentRenderBox = function () {
            LayoutMgr.lazyInitCurrentRanderBox();
            return LayoutMgr.currentbox;
        };
        LayoutMgr.setCurrentRenderBox = function (box) {
            LayoutMgr.lazyInitCurrentRanderBox();
            LayoutMgr.currentbox = box;
        };
        LayoutMgr.prototype.findFirstBoxByNodeId = function (astNodeId) {
            if (!this.pcTable)
                return null;
            var box = this.pcTable[astNodeId];
            return box === undefined ? null : box;
        };
        LayoutMgr.prototype.findAllBoxesByNodeId = function (astNodeId) {
            var boxes = [];
            if (this.boxes)
                this.boxes.forEach(function (box) {
                    if (box.getAstNodeId() === astNodeId)
                        boxes.push(box);
                });
            return boxes;
        };
        LayoutMgr.prototype.findAllBoxesByPropertyNodeId = function (astNodeId) {
            var boxes = [];
            if (this.boxes)
                this.boxes.forEach(function (box) {
                    var pcTable = box.pcTable;
                    for (var propName in pcTable) {
                        if (pcTable[propName] === astNodeId) {
                            boxes.push(box);
                            break;
                        }
                    }
                });
            return boxes;
        };
        LayoutMgr.prototype.getSelectedBox = function () {
            return this.selectedBox;
        };
        LayoutMgr.prototype.setCurrentId = function (astNodeId) {
            this.currentAstNodeId = astNodeId;
        };
        LayoutMgr.prototype.getCurrentId = function () {
            return this.currentAstNodeId;
        };
        LayoutMgr.prototype.selectBox = function (box) {
            if (this.selectedBox !== null) {
                var parent = box;
                while (parent !== null) {
                    if (parent === this.selectedBox)
                        return false;
                    parent = parent.parent;
                }
                this.unselectBox();
            }
            if (this.currentAstNodeId)
                this.clearRelatedBoxes();
            if (!box || box.depth <= 0 || (box.isSingleChild && box.isLeaf() && box.depth > 1))
                return false;
            this.selectedBox = box;
            this.highlightSelectedBox();
            if (this.onBoxSelected)
                this.onBoxSelected();
            return true;
        };
        LayoutMgr.prototype.showBoxMenu = function (cb) {
            var editButton = TDev.HTML.mkRoundButton("svg:edit,currentColor", TDev.lf("edit"), 290 /* wallEdit */, function () {
                if (cb)
                    cb();
            });
            this.boxMenu = TDev.div("wall-selected", [editButton]);
            this.refreshBoxMenu();
        };
        LayoutMgr.prototype.refreshBoxMenu = function () {
            if (this.boxMenu !== null) {
                this.updateBoxMenuPosition();
                this.rootElement.appendChild(this.boxMenu);
                this.checkBoxMenuPosition();
            }
        };
        LayoutMgr.prototype.hideBoxMenu = function () {
            if (this.boxMenu !== null) {
                TDev.Animation.fadeOut(this.boxMenu).begin();
                this.boxMenu = null;
            }
        };
        LayoutMgr.prototype.updateBoxMenuPosition = function () {
            if (this.selectedBox === null || this.boxMenu === null)
                return;
            var box = this.selectedBox;
            var offset = TDev.Util.offsetIn(box.element, this.rootElement);
            var renderedScale = 1;
            var viewWidth = this.rootElement.clientWidth, viewHeight = this.rootElement.clientHeight;
            var boxWidth = box.getRenderedWidth() * renderedScale, boxHeight = box.getRenderedHeight() * renderedScale;
            var viewLeft = offset.x * renderedScale, viewTop = offset.y * renderedScale;
            var margin = TDev.SizeMgr.topFontSize * 0.2;
            if (viewLeft + boxWidth / 2 < viewWidth / 2) {
                this.boxMenu.style.right = "auto";
                this.boxMenu.style.left = (viewLeft + boxWidth + margin) + "px";
            }
            else {
                this.boxMenu.style.left = "auto";
                this.boxMenu.style.right = (viewWidth - (viewLeft - margin)) + "px";
            }
            if (viewTop + boxHeight / 2 < viewHeight / 2) {
                this.boxMenu.style.bottom = "auto";
                this.boxMenu.style.top = viewTop + "px";
            }
            else {
                this.boxMenu.style.top = "auto";
                this.boxMenu.style.bottom = (viewHeight - (viewTop + boxHeight)) + "px";
            }
        };
        LayoutMgr.prototype.checkBoxMenuPosition = function () {
            if (this.boxMenu === null)
                return;
            var box = this.selectedBox;
            var offset = TDev.Util.offsetIn(this.boxMenu, this.rootElement);
            var renderedScale = 1;
            var viewWidth = this.rootElement.clientWidth, viewHeight = this.rootElement.clientHeight;
            var menuWidth = this.boxMenu.clientWidth * renderedScale, menuHeight = this.boxMenu.clientHeight * renderedScale;
            var viewLeft = offset.x * renderedScale - this.rootElement.scrollLeft, viewTop = offset.y * renderedScale - this.rootElement.scrollTop;
            var viewRight = viewLeft + menuWidth, viewBottom = viewTop + menuHeight;
            if (viewLeft < 0) {
                this.boxMenu.style.left = "0px";
                this.boxMenu.style.right = "auto";
            }
            else if (viewRight > viewWidth) {
                this.boxMenu.style.right = "0px";
                this.boxMenu.style.left = "auto";
            }
            if (viewTop < 0) {
                this.boxMenu.style.top = "0px";
                this.boxMenu.style.bottom = "auto";
            }
            else if (viewBottom > viewHeight) {
                this.boxMenu.style.bottom = "0px";
                this.boxMenu.style.top = "auto";
            }
        };
        LayoutMgr.prototype.unselectBox = function () {
            if (this.selectedBox !== null) {
                this.findAllBoxesByNodeId(this.selectedBox.getAstNodeId()).forEach(function (box) {
                    box.clearHighlight();
                });
                this.selectedBox = null;
                this.hideBoxMenu();
            }
        };
        LayoutMgr.prototype.highlightSelectedBox = function () {
            var _this = this;
            if (this.selectedBox !== null) {
                this.selectedBox.setHighlight();
                this.scrollToShow(this.selectedBox);
                this.findAllBoxesByNodeId(this.selectedBox.getAstNodeId()).forEach(function (box) {
                    if (_this.selectedBox !== box)
                        box.setHighlight(false);
                });
            }
        };
        LayoutMgr.prototype.highlightRelatedBoxes = function () {
            if (this.selectedBox !== null)
                this.unselectBox();
            if (this.currentAstNodeId) {
                var firstBox = this.findFirstBoxByNodeId(this.currentAstNodeId);
                if (firstBox !== null) {
                    firstBox.setHighlight();
                    this.selectedBox = firstBox;
                }
                this.findAllBoxesByPropertyNodeId(this.currentAstNodeId).forEach(function (box) {
                    if (firstBox !== box)
                        box.setHighlight(false);
                });
            }
        };
        LayoutMgr.prototype.clearRelatedBoxes = function () {
            if (this.currentAstNodeId) {
                this.findAllBoxesByPropertyNodeId(this.currentAstNodeId).forEach(function (box) {
                    box.clearHighlight();
                });
            }
            this.currentAstNodeId = "";
        };
        LayoutMgr.prototype.createZoomingUI = function () {
            var _this = this;
            var scaleSpan = TDev.span(null, "");
            var scaleSliderCursor = TDev.div("cursor");
            var scaleSlider = TDev.div("slider", [scaleSliderCursor]);
            this.updateslider = function (zoom, adjustscroll) {
                var oldScale = _this.scale;
                _this.scale = Math.max(_this.minimumScale, Math.min(zoom, _this.maximumScale));
                scaleSliderCursor.style.top = "0";
                scaleSliderCursor.style.left = (scaleSlider.clientWidth - scaleSliderCursor.clientWidth) * _this.fromZoomToSliderValue(_this.scale) + "px";
                scaleSpan.setChildren([Math.round(_this.scale * 100).toString() + "%"]);
                if (adjustscroll) {
                    _this.updateScaling(_this.scale);
                    if (_this.scrollTop !== undefined) {
                        _this.scrollTop = _this.scrollTop * _this.scale / oldScale + _this.rootElement.offsetHeight / 2 * (_this.scale / oldScale - 1);
                        _this.scrollLeft = _this.scrollLeft * _this.scale / oldScale + _this.rootElement.offsetWidth / 2 * (_this.scale / oldScale - 1);
                        _this.recoverScroll();
                    }
                }
            };
            new TDev.DragHandler(scaleSliderCursor, function (e, dx, dy) {
                var pos = TDev.Util.offsetIn(scaleSliderCursor, scaleSlider);
                var max = scaleSlider.clientWidth - scaleSliderCursor.clientWidth;
                _this.updateslider(_this.fromSliderValueToZoom(pos.x / max), true);
            });
            var zoomOutButton = TDev.HTML.mkButtonElt("wall-zoom-out", "-");
            zoomOutButton.withClick(function () {
                _this.updateslider(_this.scale * 0.9, true);
            });
            var zoomInButton = TDev.HTML.mkButtonElt("wall-zoom-in", "+");
            zoomInButton.withClick(function () {
                _this.updateslider(_this.scale * 1.1, true);
            });
            var ui = TDev.div("wall-zoom", scaleSpan, zoomOutButton, scaleSlider, zoomInButton);
            return ui;
        };
        LayoutMgr.prototype.fromSliderValueToZoom = function (value) {
            return this.minimumScale * Math.exp(Math.log(this.maximumScale / this.minimumScale) * value);
        };
        LayoutMgr.prototype.fromZoomToSliderValue = function (zoom) {
            return this.minimumScale >= this.maximumScale ? 1 : Math.log(zoom / this.minimumScale) / Math.log(this.maximumScale / this.minimumScale);
        };
        LayoutMgr.prototype.getRootElement = function () {
            return this.rootElement;
        };
        LayoutMgr.prototype.getRootBox = function () {
            return this.rootBox;
        };
        LayoutMgr.prototype.updateRootElement = function () {
            this.rootElement.setAttribute("livemode", this.editMode ? "true" : "false");
        };
        LayoutMgr.prototype.calcDefaultScaling = function () {
            if (this.sideview) {
                if (this.scale === undefined || isNaN(this.scale)) {
                    var horizontalScale = this.rootElement.offsetWidth / this.rootBox.element.offsetWidth;
                    var verticalScale = this.rootElement.offsetHeight / this.rootBox.element.offsetHeight;
                    this.minimumScale = Math.min(horizontalScale, verticalScale) * 0.5;
                    this.maximumScale = this.minimumScale * 100;
                    var defaultScale = Math.max(horizontalScale, verticalScale);
                    this.scale = defaultScale;
                    this.updateScaling(this.scale);
                }
            }
            else {
                this.updateScaling(1);
            }
        };
        LayoutMgr.prototype.updateScaling = function (scale) {
            if (this.sideview && this.rootElement.msContentZoomFactor) {
                TDev.Util.setTransform(this.rootBox.element, "scale(" + this.minimumScale * 10 + ", " + this.minimumScale * 10 + ")", "0% 0%");
                this.rootElement.msContentZoomFactor = scale / (this.minimumScale * 10);
                this.rootElement.style.msContentZoomLimit = "10% 1000%";
            }
            else {
                TDev.Util.setTransform(this.rootBox.element, "scale(" + scale + ", " + scale + ")", "0% 0%");
            }
        };
        LayoutMgr.prototype.FindScrollbarSizes = function (elt) {
            if (this.scrollbarWidth === undefined) {
                var saved = elt.style.overflow || "";
                this.scrollbarWidth = elt.clientWidth;
                this.scrollbarHeight = elt.clientHeight;
                elt.style.overflow = "scroll";
                this.scrollbarWidth -= elt.clientWidth;
                this.scrollbarHeight -= elt.clientHeight;
                elt.style.overflow = saved;
            }
        };
        LayoutMgr.prototype.recoverScroll = function () {
            if (this.sideview) {
                if (this.scrollTop !== undefined) {
                    this.rootElement.scrollTop = this.scrollTop;
                    this.rootElement.scrollLeft = this.scrollLeft;
                }
            }
        };
        LayoutMgr.prototype.onScroll = function () {
            this.scrollTop = this.rootElement.scrollTop;
            this.scrollLeft = this.rootElement.scrollLeft;
            var zoomfactor = this.rootElement.msContentZoomFactor;
            if (zoomfactor)
                this.updateslider(zoomfactor * this.minimumScale * 10, false);
        };
        LayoutMgr.prototype.scrollToShow = function (box) {
        };
        LayoutMgr.prototype.render = function (box, e) {
            if (box === null || (box.parent !== null && box.parent !== undefined)) {
                return;
            }
            this.rootElement = e;
            this.rootBox = box;
            box.isRoot = true;
            var el = box.element;
            if (this.rootElement.firstChild != el || !this.rootBox.structuring_done) {
                this.CreateOrFixElementStructure();
            }
            this.CoreLayout();
        };
        LayoutMgr.prototype.isOnScreen = function (node) {
            var top = document.documentElement;
            while (node) {
                if (node === top)
                    return true;
                if (node.style.display === "none")
                    return false;
                node = node.parentNode;
            }
            return false;
        };
        LayoutMgr.prototype.CoreLayout = function () {
            var _this = this;
            if (this.rootBox instanceof HtmlBox) {
                this.rootBox.doLayout();
                return;
            }
            if (!this.isOnScreen(this.rootElement))
                return;
            TDev.Util.time("CoreLayout", function () {
                _this.FindScrollbarSizes(_this.rootElement);
                if (_this.sideview && _this.scale !== undefined && _this.scale != 1)
                    _this.updateScaling(_this.scale);
                _this.rootBox.doLayout();
                if (_this.rootBox instanceof WallBox && !_this.rootBox.speculationwascorrect(_this.scrollspeculation)) {
                    _this.scrollspeculation = !_this.scrollspeculation;
                    _this.rootBox.doLayout();
                }
                _this.calcDefaultScaling();
                if (_this.sideview) {
                    _this.recoverScroll();
                    _this.updateslider(_this.scale, true);
                }
                if (_this.onRendered)
                    _this.onRendered();
            }, false);
        };
        LayoutMgr.prototype.CreateOrFixElementStructure = function () {
            this.boxes = [];
            this.pcTable = {};
            var e = this.rootElement;
            var el = this.rootBox.element;
            while (e.hasChildNodes()) {
                var b = e.firstChild;
                if (b == el)
                    break;
                e.removeChild(b);
            }
            while (e.hasChildNodes()) {
                var b = e.lastChild;
                if (b == el)
                    break;
                e.removeChild(b);
            }
            this.passS(this.rootBox);
            this.rootBox.structuring_done = true;
        };
        LayoutMgr.prototype.passS = function (box) {
            if (box.doLiveNavigation()) {
                this.boxes.push(box);
                this.recordmapping(box);
            }
            box.visitS();
            for (var i = 0; i < box.children.length; i++)
                this.passS(box.children[i]);
        };
        LayoutMgr.prototype.recordmapping = function (box) {
            if (this.pcTable[box.getAstNodeId()] === undefined)
                this.pcTable[box.getAstNodeId()] = box;
            for (var propName in box.pcTable)
                if (this.pcTable[box.pcTable[propName]] === undefined)
                    this.pcTable[box.pcTable[propName]] = box;
        };
        LayoutMgr.instance = new LayoutMgr();
        LayoutMgr.renderexecutionmode = false;
        LayoutMgr.needrelayout = false;
        LayoutMgr.lazyInitCurrentRanderBox = function () {
        };
        return LayoutMgr;
    })();
    TDev.LayoutMgr = LayoutMgr;
    var WallPage = (function () {
        function WallPage(rt, auto) {
            this.topDown = false;
            this.crashed = false;
            this.id = TDev.Random.uniqueId();
            this.csslayout = false;
            this.lastChildCount = -1;
            this.title = "";
            this.subtitle = "";
            this.chromeVisible = true;
            this.backButtonVisible = true;
            this.fgColor = "#000000";
            this.bgColor = "#ffffff";
            this.renderCount = 0;
            this.onNavigatedFrom = new TDev.RT.Event_();
            this.runtime = rt;
            this.element = TDev.div("wall-page");
            this.buttons = [];
            this.auto = auto;
            this.onNavigatedFrom.isPageEvent = true;
            this.clear();
        }
        WallPage.prototype.activate = function () {
            this.getElement().style.display = "block";
        };
        WallPage.prototype.deactivate = function () {
            this.getElement().style.display = "none";
        };
        WallPage.prototype.getElement = function () {
            return this.element;
        };
        WallPage.prototype.isAuto = function () {
            return this.auto;
        };
        WallPage.prototype.isReversed = function () {
            return this.topDown;
        };
        WallPage.prototype.setReversed = function (reversed) {
            if (this.topDown != reversed) {
                this.lastChildCount = -1;
                this.topDown = reversed;
            }
        };
        WallPage.prototype.rtPage = function () {
            if (!this._rtPage)
                this._rtPage = TDev.RT.Page.mk(this);
            return this._rtPage;
        };
        WallPage.applySizeUpdate = function (e) {
            var walkHtml = function (e) {
                if (!e)
                    return;
                if (e.updateSizes)
                    e.updateSizes();
                TDev.Util.childNodes(e).forEach(walkHtml);
            };
            walkHtml(e);
        };
        WallPage.prototype.getFrame = function (prev, ret) {
            var _this = this;
            var rt = prev.rt;
            if (!this.isAuto()) {
                var frame = {};
                frame.previous = prev;
                frame.rt = prev.rt;
                frame.returnAddr = ret;
                frame.entryAddr = function (s) {
                    return s.rt.leave();
                };
                return frame;
            }
            if (!this.drawFn) {
                var f = prev.rt.compiled.lookupLibPage(this.libName, this.pageName);
                this.drawFn = function (prev, ret) {
                    var newFrame = f(prev);
                    return newFrame.invoke.apply(null, [newFrame, ret].concat(_this.drawArgs));
                };
            }
            return this.drawFn(prev, ret);
        };
        WallPage.prototype.refreshForNewScript = function () {
            this.drawFn = null;
        };
        WallPage.prototype.getCurrentBox = function () {
            return this.currentBox;
        };
        WallPage.prototype.setCurrentBox = function (box) {
            this.currentBox = box;
        };
        WallPage.prototype.setFullScreenElement = function (host, elt) {
            this.fullScreenElement = elt;
            host.setFullScreenElement(elt);
        };
        WallPage.prototype.clear = function () {
            this.rootBox = WallBox.CreateOrRecycleRoot(this.runtime, null);
            this.setCurrentBox(this.rootBox);
            this.lastChildCount = -1;
        };
        WallPage.prototype.startrender = function () {
            this.renderCount++;
            this.rootBox = WallBox.CreateOrRecycleRoot(this.runtime, this.rootBox);
            this.setCurrentBox(this.rootBox);
            this.lastChildCount = -1;
        };
        WallPage.prototype.render = function (host, popCount) {
            if (popCount === void 0) { popCount = 0; }
            TDev.Util.assertCode(popCount >= 0);
            var rootElt = this.getElement();
            var getElt = function (b) {
                return TDev.div("legacy-wall-box", b.getContent());
            };
            rootElt.style.background = "none";
            rootElt.style.color = this.fgColor;
            if (this.isAuto()) {
                rootElt.className = "wall-page " + (this.csslayout ? " html-page" : "box-page");
                this.setFullScreenElement(host, null);
                LayoutMgr.instance.render(this.rootBox, rootElt);
            }
            else {
                TDev.Util.assert(this.rootBox instanceof WallBox);
                var i = 0;
                var sz = this.rootBox.size();
                var newElts = [];
                if (sz > 0) {
                    var last = this.rootBox.get(sz - 1);
                    if (last.fullScreen) {
                        this.setFullScreenElement(host, TDev.div("wall-fullscreen", last.getContent()));
                        this.lastChildCount = -1;
                        return;
                    }
                }
                this.setFullScreenElement(host, null);
                rootElt.className = "wall-page classic-page";
                if (this.lastChildCount < 0) {
                    var children = [];
                    for (i = 0; i < sz; ++i)
                        children.push(this.rootBox.get(this.isReversed() ? i : sz - i - 1));
                    rootElt.setChildren(children.map(getElt));
                    newElts = [rootElt];
                }
                else {
                    for (i = this.lastChildCount - popCount; i < sz; ++i) {
                        var ch = getElt(this.rootBox.get(i));
                        newElts.push(ch);
                        if (this.isReversed()) {
                            rootElt.appendChild(ch);
                        }
                        else {
                            var first = rootElt.firstChild;
                            if (!first)
                                rootElt.appendChild(ch);
                            else
                                rootElt.insertBefore(ch, first);
                        }
                    }
                    for (var i = 0; i < popCount; ++i) {
                        if (this.isReversed()) {
                            var firstChild = rootElt.firstChild;
                            if (firstChild)
                                rootElt.removeChild(firstChild);
                        }
                        else {
                            var lastChild = rootElt.lastChild;
                            if (lastChild)
                                rootElt.removeChild(lastChild);
                        }
                    }
                }
                this.lastChildCount = sz;
                newElts.forEach(WallPage.applySizeUpdate);
            }
        };
        return WallPage;
    })();
    TDev.WallPage = WallPage;
    var BoxAttributes = (function () {
        function BoxAttributes() {
            this.tappedEvent = this.mkEv();
            this.textEditingEvent = this.mkEv();
        }
        BoxAttributes.prototype.applyToStyle = function (b) {
            TDev.Util.oops("must override");
        };
        BoxAttributes.prototype.mkEv = function () {
            var r = new TDev.RT.Event_();
            r.isPageEvent = true;
            return r;
        };
        return BoxAttributes;
    })();
    TDev.BoxAttributes = BoxAttributes;
    var HtmlAttributes = (function (_super) {
        __extends(HtmlAttributes, _super);
        function HtmlAttributes() {
            _super.apply(this, arguments);
        }
        HtmlAttributes.prototype.applyToStyle = function (b) {
            TDev.Util.assert(b instanceof HtmlBox);
            var bb = b;
            if (bb.element.nodeType == Node.ELEMENT_NODE) {
                bb.setRenderedClassnames(this.classnames);
                bb.setRenderedStyles(this.styles);
                bb.setRenderedAttributes(this.attributes);
            }
        };
        return HtmlAttributes;
    })(BoxAttributes);
    TDev.HtmlAttributes = HtmlAttributes;
    var LayoutAttributes = (function (_super) {
        __extends(LayoutAttributes, _super);
        function LayoutAttributes(isroot) {
            _super.call(this);
            this.flow = WallBox.FLOW_VERTICAL;
            this.fontSize = 0;
            this.fontFamily = "";
            this.background = "transparent";
            this.width = [0, Infinity];
            this.height = [0, Infinity];
            this.margin = [0, 0, 0, 0];
            this.padding = [0, 0, 0, 0];
            this.stretchwidth = -1;
            this.stretchheight = -1;
            this.stretchmargin = [0, 0, 0, 0];
            this.borderwidth = [0, 0, 0, 0];
            this.arrangement = [undefined, WallBox.ARRANGE_BASELINE];
            this.scroll = [isroot, isroot];
            this.legacystretch = [false, false];
            this.legacybaseline = true;
            this.wrap = undefined;
            this.wraplimit = 15;
            this.textEditedEvent = this.mkEv();
        }
        LayoutAttributes.prototype.applyToStyle = function (b) {
            b.setRenderedPositionMode("absolute");
            b.setRenderedTextAlign(this.textalign);
            b.setRenderedBackgroundColor(this.background);
            b.setRenderedBackgroundImages(this.backgroundImages);
            b.setRenderedColor(this.foreground);
            b.setRenderedFontWeight(this.fontWeight);
            b.setRenderedFontFamily(this.fontFamily);
            b.setRenderedFontSize(this.fontSize);
            b.setRenderedWrap(this.wrap, this.wraplimit);
            b.setRenderedBorder(this.border, this.borderwidth);
        };
        return LayoutAttributes;
    })(BoxAttributes);
    TDev.LayoutAttributes = LayoutAttributes;
    var BoxBase = (function () {
        function BoxBase(rt, parent, nodeId) {
            this.obsolete = false;
            this.recycled = false;
            this.reuseindex = 0;
            this.fresh = true;
            this.structuring_done = false;
            this.isSingleChild = false;
            this.delayedlayout = false;
            this.inputversions = new Array();
            this.runtime = rt;
            this.id = LayoutMgr.instance.numBoxes++;
            this.astNodeId = nodeId;
            this.isRoot = false;
            this.parent = parent;
            if (this.parent) {
                this.parent.children.push(this);
                this.depth = this.parent.depth + 1;
            }
            else {
                this.depth = 0;
            }
            this.children = [];
            this.pcTable = { "": this.astNodeId };
        }
        BoxBase.prototype.getContent = function () {
            return undefined;
        };
        BoxBase.prototype.setContent = function (e) {
        };
        BoxBase.prototype.RefreshOnScreen = function () {
        };
        BoxBase.prototype.SwapImageContent = function (newcontent) {
        };
        BoxBase.prototype.hookContent = function () {
        };
        BoxBase.prototype.mayReplaceWith = function (tagname) {
            return false;
        };
        BoxBase.prototype.isLeaf = function () {
            return false;
        };
        BoxBase.prototype.doLiveNavigation = function () {
            return true;
        };
        BoxBase.prototype.getRenderedWidth = function () {
            return 0;
        };
        BoxBase.prototype.getRenderedHeight = function () {
            return 0;
        };
        BoxBase.prototype.setHighlight = function (strong) {
            if (strong === void 0) { strong = true; }
        };
        BoxBase.prototype.clearHighlight = function () {
        };
        BoxBase.prototype.Obsolete = function () {
            this.obsolete = true;
            this.children.forEach(function (c) { return c.Obsolete(); });
        };
        BoxBase.prototype.getAstNodeId = function () {
            return this.astNodeId;
        };
        BoxBase.prototype.onFunctionCall = function (f, pc) {
            var functionNames = f.toString().match(/function ([^\(]+)/);
            if (functionNames !== null) {
                var functionName = functionNames[1];
                this.onCall(functionName, pc);
            }
        };
        BoxBase.prototype.onCall = function (fName, pc) {
            if (!pc)
                return;
            this.pcTable[fName] = pc;
        };
        BoxBase.prototype.tapped = function () {
            var done = false;
            if (LayoutMgr.instance.editMode) {
                if (LayoutMgr.instance.selectBox(this))
                    done = true;
            }
            else {
                if (this.obsolete || (this.runtime.eventQ && !this.runtime.eventQ.viewIsCurrent()))
                    return;
                if (this.attributes.tappedEvent.handlers) {
                    done = true;
                    this.setRenderedTappable(true, true);
                    this.runtime.queueLocalEvent(this.attributes.tappedEvent);
                    this.runtime.forcePageRefresh();
                }
                else if (this.contenttapapplies()) {
                    this.contenttaphandler();
                    done = true;
                }
            }
            if (LayoutMgr.instance.editMode || this instanceof WallBox)
                if (!done && this.parent)
                    this.parent.tapped();
        };
        BoxBase.prototype.withClick = function (h) {
            this.contenttaphandler = h;
        };
        BoxBase.prototype.contenttapapplies = function () {
            return this.contenttaphandler && !this.attributes.tappedEvent.handlers && !(this.isSingleChild && this.parent.attributes.tappedEvent.handlers);
        };
        BoxBase.prototype.setRenderedTappable = function (tappable, tapped) {
        };
        BoxBase.prototype.bindEditableText = function (s, handler, pc) {
            this.addTextEditHandler(handler);
            this.setInputText(s);
            this.onCall("binding", pc);
        };
        BoxBase.prototype.addTextEditHandler = function (handler) {
            if (handler instanceof TDev.RT.Ref) {
                this.attributes.textEditingEvent.addHandler(new TDev.RT.PseudoAction(function (rt, args) {
                    handler._set(args[0], rt.current);
                    rt.forcePageRefresh();
                }));
            }
            else
                this.attributes.textEditingEvent.addHandler(handler);
        };
        BoxBase.prototype.getEditableContent = function () {
            TDev.Util.oops("virtual");
            return undefined;
        };
        BoxBase.prototype.setEditableContent = function (s) {
            TDev.Util.oops("virtual");
        };
        BoxBase.prototype.invalidateCachedLayout = function (triggerdelayedrelayout) {
        };
        BoxBase.prototype.onInputTextChange = function () {
            if (LayoutMgr.instance.editMode)
                return;
            var text = this.getEditableContent();
            if (this.obsolete)
                return;
            if (this.inputversions.length === 3)
                this.inputversions.pop();
            if (this.inputversions[this.inputversions.length - 1] === text) {
                if (WallBox.debuginput)
                    TDev.Util.log("&&&" + this.id + "                 flag \"" + this.inputversions + "\"");
                LayoutMgr.instance.FlagTypingActivity("i" + this.id);
                return;
            }
            this.inputversions.push(text);
            if (WallBox.debuginput)
                TDev.Util.log("&&&" + this.id + "                 push \"" + this.inputversions + "\"");
            var parent = this.parent;
            if (this.attributes.textEditingEvent.handlers) {
                this.invalidateCachedLayout(false);
                if (this.inputversions.length >= 2) {
                    this.runtime.queueLocalEvent(this.lastqueuededit = this.attributes.textEditingEvent, [this.inputversions[1]]);
                    this.runtime.forcePageRefresh();
                }
            }
            else {
                this.invalidateCachedLayout(true);
            }
        };
        BoxBase.prototype.setInputText = function (text) {
            var cur = this.getEditableContent();
            var requeue = false;
            if (text === this.inputversions[1]) {
                this.inputversions.shift();
                if (WallBox.debuginput)
                    TDev.Util.log("&&&" + this.id + "                 prune \"" + this.inputversions + "\"");
                if (text !== cur) {
                    this.inputversions[1] = cur;
                    requeue = true;
                }
            }
            else if (this.inputversions.length === 1 && text != cur && LayoutMgr.instance.CheckTypingActivity("i" + this.id)) {
                this.inputversions = [text, cur];
                LayoutMgr.instance.ClearTypingActivity("i" + this.id);
                if (WallBox.debuginput)
                    TDev.Util.log("&&&" + this.id + "                 skip \"" + this.inputversions + "\"");
                requeue = true;
            }
            else {
                this.inputversions = [text];
                this.lastqueuededit = undefined;
                if (WallBox.debuginput)
                    TDev.Util.log("&&&" + this.id + "                 set \"" + this.inputversions + "\"");
            }
            if (this.inputversions.length == 1) {
                if (text !== cur) {
                    this.setEditableContent(text);
                    this.invalidateCachedLayout(false);
                }
                LayoutMgr.instance.ClearTypingActivity("i" + this.id);
            }
            else if (this.inputversions.length == 2 && requeue) {
                if (this.attributes.textEditingEvent.handlers) {
                    if (WallBox.debuginput)
                        TDev.Util.log("&&&" + this.id + "                 requeue \"" + this.inputversions + "\"");
                    this.runtime.queueLocalEvent(this.lastqueuededit = this.attributes.textEditingEvent, [this.inputversions[1]]);
                }
            }
        };
        BoxBase.CreateOrRecycleRoot = function (rt, p) {
            var cssmode = rt.onCssPage();
            if (LayoutMgr.RenderExecutionMode() && p && (cssmode == p instanceof HtmlBox)) {
                return p.recycle(rt, null, "", rt.onCssPage());
            }
            else {
                return cssmode ? (new HtmlBox(rt, null, "", "div")) : (new WallBox(rt, null, ""));
            }
        };
        BoxBase.CreateOrRecycleContainerBox = function (rt, cur, pc, tagName) {
            var candidate = null;
            if (LayoutMgr.RenderExecutionMode() && cur.recycled && cur.reuseindex < cur.prevchildren.length) {
                candidate = cur.prevchildren[cur.reuseindex];
                cur.reuseindex = cur.reuseindex + 1;
                if (candidate.mayReplaceWith(tagName))
                    return candidate.recycle(rt, cur, pc, rt.onCssPage());
            }
            var box = rt.onCssPage() ? new HtmlBox(rt, cur, pc, tagName) : new WallBox(rt, cur, pc);
            box.replaces = candidate;
            return box;
        };
        BoxBase.CreateOrRecycleLeafBox = function (rt, val) {
            var cur = rt.getCurrentBoxBase(true);
            var candidate = null;
            var pc = rt.getTopScriptPc();
            if (LayoutMgr.RenderExecutionMode() && cur.recycled && cur.reuseindex < cur.prevchildren.length) {
                candidate = cur.prevchildren[cur.reuseindex];
                cur.reuseindex = cur.reuseindex + 1;
                if (val !== null && candidate.content && candidate.reusekey === val && (!candidate.reuseversion || (candidate.reuseversion === val.versioncounter))) {
                    return candidate.recycle(rt, cur, pc, rt.onCssPage());
                }
            }
            var cssmode = rt.onCssPage();
            var box = rt.onCssPage() ? new HtmlBox(rt, cur, pc) : new WallBox(rt, cur, pc);
            box.reusekey = val;
            box.reuseversion = val && val.versioncounter;
            box.replaces = candidate;
            return box;
        };
        BoxBase.prototype.recycle = function (rt, parent, nodeId, cssmode) {
            TDev.Util.assert(!!cssmode === (this instanceof HtmlBox), "mixed up boxes");
            this.runtime = rt;
            this.parent = parent;
            this.astNodeId = nodeId;
            if (this.parent) {
                this.parent.children.push(this);
                TDev.Util.assert(this.depth === this.parent.depth + 1);
            }
            else {
                TDev.Util.assert(this.depth === 0);
            }
            this.recycled = true;
            this.structuring_done = false;
            this.prevchildren = this.children;
            this.reuseindex = 0;
            this.children = [];
            this.attributes = cssmode ? new HtmlAttributes() : new LayoutAttributes(this.depth == 0);
            this.pcTable = { "": this.astNodeId };
            return this;
        };
        BoxBase.prototype.doLayout = function () {
        };
        BoxBase.prototype.visitS = function () {
            if (this.recycled) {
                for (var i = this.children.length; i < this.prevchildren.length; i++) {
                    var b = this.prevchildren[i];
                    b.Obsolete();
                    this.element.removeChild(b.element);
                }
            }
            var p = this.parent;
            if (this.fresh || (p && !p.recycled)) {
                if (p) {
                    if (this.replaces) {
                        this.replaces.Obsolete();
                        p.element.replaceChild(this.element, this.replaces.element);
                        this.replaces = null;
                    }
                    else {
                        p.element.appendChild(this.element);
                    }
                }
                else {
                    TDev.Util.assert(this.isRoot);
                    LayoutMgr.instance.rootElement.appendChild(this.element);
                    LayoutMgr.instance.rootElement.onscroll = function (e) {
                        LayoutMgr.instance.onScroll();
                    };
                }
                if (this.fresh) {
                    this.hookContent();
                    this.fresh = false;
                }
            }
        };
        BoxBase.prototype.visitI = function () {
            this.attributes.applyToStyle(this);
        };
        BoxBase.debuginput = false;
        return BoxBase;
    })();
    TDev.BoxBase = BoxBase;
    var HtmlBox = (function (_super) {
        __extends(HtmlBox, _super);
        function HtmlBox(rt, parent, nodeId, tagName) {
            _super.call(this, rt, parent, nodeId);
            if (parent)
                TDev.Util.assert(parent instanceof HtmlBox);
            this.attributes = new HtmlAttributes();
            if (tagName !== undefined) {
                this.tagName = tagName;
                if (tagName && !TDev.HTML.allowedTagName(tagName))
                    TDev.Util.userError(TDev.lf("tag name {0} is not allowed", tagName));
                this.element = document.createElement(tagName);
                this.element.id = this.id.toString();
                this.attributes.applyToStyle(this);
            }
        }
        HtmlBox.prototype.isLeaf = function () {
            return !this.tagName;
        };
        HtmlBox.prototype.mayReplaceWith = function (tagName) {
            return (this.tagName === tagName);
        };
        HtmlBox.prototype.doLiveNavigation = function () {
            return !!this.tagName;
        };
        HtmlBox.prototype.setContent = function (e) {
            TDev.Util.check(this.isLeaf());
            TDev.Util.check(e != null);
            this.element = e;
            this.attributes.applyToStyle(this);
        };
        HtmlBox.prototype.getContent = function () {
            return this.element;
        };
        HtmlBox.prototype.RefreshOnScreen = function () {
        };
        HtmlBox.prototype.invalidateCachedLayout = function (triggerdelayedrelayout) {
        };
        HtmlBox.prototype.withClick = function (h) {
        };
        HtmlBox.prototype.getRenderedWidth = function () {
            return this.element.clientWidth;
        };
        HtmlBox.prototype.getRenderedHeight = function () {
            return this.element.clientHeight;
        };
        HtmlBox.prototype.getEditableContent = function () {
            return this.element.value;
        };
        HtmlBox.prototype.setEditableContent = function (text) {
            this.element.value = text;
        };
        HtmlBox.prototype.hookContent = function () {
            var _this = this;
            var tag = this.element && this.element.tagName;
            if (tag) {
                this.element.withClick(function () {
                    _this.tapped();
                });
                if (/input|textarea/i.test(tag))
                    this.element.oninput = function (e) {
                        _this.onInputTextChange();
                    };
            }
        };
        HtmlBox.prototype.SwapImageContent = function (newcontent) {
            var p = this.element.parentNode;
            if (p)
                p.replaceChild(newcontent, this.element);
            this.element = newcontent;
        };
        HtmlBox.prototype.setHighlight = function (strong) {
            if (strong === void 0) { strong = true; }
            if (this.element && this.element.style) {
                this.element.style.border = strong ? "5px dotted #C00" : "5px dotted #rgba(204, 0, 0, 0.6)";
                if (!strong)
                    this.element.style.background = "rgba(204, 0, 0, 0.4)";
            }
        };
        HtmlBox.prototype.clearHighlight = function () {
            this.element.style.cssText = this.rendered_styles;
        };
        HtmlBox.prototype.doLayout = function () {
            this.passA();
        };
        HtmlBox.prototype.passA = function () {
            this.visitI();
            for (var i = 0; i < this.children.length; i++) {
                this.children[i].passA();
            }
        };
        HtmlBox.prototype.addClassName = function (s, pc) {
            if (pc === void 0) { pc = ""; }
            if (!this.attributes.classnames)
                this.attributes.classnames = [];
            this.attributes.classnames.push(s);
            this.onCall("class name", pc);
        };
        HtmlBox.prototype.setAttribute = function (name, value, pc) {
            if (pc === void 0) { pc = ""; }
            if (!this.attributes.attributes)
                this.attributes.attributes = {};
            this.attributes.attributes[name] = value;
            this.onCall("attr:" + name, pc);
        };
        HtmlBox.prototype.setStyle = function (property, value, pc) {
            if (pc === void 0) { pc = ""; }
            if (!this.attributes.styles)
                this.attributes.styles = {};
            this.attributes.styles[property] = value;
            this.onCall("style:" + property, pc);
        };
        HtmlBox.prototype.setRenderedClassnames = function (names) {
            var cmp = (names && names.length > 0) ? names.join(' ') : '';
            if (cmp !== this.rendered_classnames) {
                if (cmp)
                    this.element.className = cmp;
                else
                    this.element.removeAttribute("class");
                this.rendered_classnames = cmp;
            }
        };
        HtmlBox.prototype.setRenderedStyles = function (styles) {
            var s = styles ? Object.keys(styles).map(function (k) { return k + ": " + styles[k]; }).join("; ") : "";
            if (s !== this.rendered_styles) {
                this.element.style.cssText = s;
                this.rendered_styles = s;
            }
        };
        HtmlBox.prototype.setRenderedAttributes = function (attributes) {
            var _this = this;
            var s = JSON.stringify(attributes);
            if (s !== this.rendered_attributes) {
                var prev = JSON.parse(this.rendered_attributes || "{}");
                Object.keys(attributes).forEach(function (k) {
                    _this.element.setAttribute(k, attributes[k]);
                    delete prev[k];
                });
                Object.keys(prev).forEach(function (k) { return _this.element.removeAttribute(k); });
                this.rendered_attributes = s;
            }
        };
        return HtmlBox;
    })(BoxBase);
    TDev.HtmlBox = HtmlBox;
    var WallBox = (function (_super) {
        __extends(WallBox, _super);
        function WallBox(rt, parent, nodeId) {
            var _this = this;
            _super.call(this, rt, parent, nodeId);
            this.cached_width = -1;
            this.cached_height = -1;
            this.cached_baseline = -1;
            this.cached_aspectratio = 0;
            if (parent)
                TDev.Util.assert(parent instanceof WallBox);
            this.attributes = new LayoutAttributes(this.depth == 0);
            this.contentType = WallBox.CONTENT_NONE;
            this.content = null;
            this.element = document.createElement("div");
            this.element.id = this.id.toString();
            this.element.withClick(function () {
                _this.tapped();
            });
            this.attributes.applyToStyle(this);
        }
        WallBox.prototype.mayReplaceWith = function (tagname) {
            return (tagname === "div" && this.content === null && this.contentType === WallBox.CONTENT_NONE);
        };
        WallBox.prototype.isLeaf = function () {
            return this.contentType != WallBox.CONTENT_NONE;
        };
        WallBox.prototype.RefreshOnScreen = function () {
            if (this.contentType == WallBox.CONTENT_NONE)
                return;
            TDev.Util.assert(this.contentType == WallBox.CONTENT_IMAGE);
            this.cached_height = -1;
            this.cached_width = -1;
            LayoutMgr.QueueReLayout();
        };
        WallBox.prototype.SwapImageContent = function (newcontent) {
            TDev.Util.assert(this.contentType == WallBox.CONTENT_IMAGE);
            this.element.removeAllChildren();
            this.element.appendChild(newcontent);
            this.content = newcontent;
            this.cached_height = -1;
            this.cached_width = -1;
            LayoutMgr.QueueReLayout();
        };
        WallBox.prototype.hookContent = function () {
            var _this = this;
            if (this.content && this.content !== this.element) {
                var e = this.element;
                if (this.contentType === WallBox.CONTENT_TEXT) {
                }
                else if (this.contentType === WallBox.CONTENT_INPUT) {
                    this.content.oninput = function (e) {
                        _this.onInputTextChange();
                    };
                    this.content.onchange = function (e) {
                        _this.onInputTextChangeDone();
                    };
                    this.content.onclick = function (e) {
                        if (LayoutMgr.instance.editMode) {
                            _this.tapped();
                        }
                        else {
                            if (_this.attributes.tappedEvent.handlers) {
                                _this.runtime.queueLocalEvent(_this.attributes.tappedEvent);
                            }
                        }
                    };
                }
                if (this.auxcontent)
                    e.appendChild(this.auxcontent);
                e.appendChild(this.content);
            }
        };
        WallBox.prototype.setHighlight = function (strong) {
            if (strong === void 0) { strong = true; }
            this.element.style.zIndex = strong ? "2" : "1";
            this.element.setAttribute("sel", strong ? "strong" : "weak");
        };
        WallBox.prototype.clearHighlight = function () {
            this.element.setAttribute("sel", "");
            this.element.style.zIndex = "auto";
        };
        WallBox.prototype.visitI = function () {
            if (!this.isRoot) {
                if (this.getFontFamily() === "")
                    this.setFontFamily(this.parent.getFontFamily());
                if (this.getFontSize() <= 0)
                    this.setFontSize(this.parent.getFontSize());
            }
            else {
                var width = this.runtime.host.fullWallWidth();
                var height = this.runtime.host.userWallHeight();
                this.setRenderedWidth(width);
                this.setRenderedHeight(height);
                if (this.getFontFamily() === "")
                    this.setFontFamily('"Segoe UI", "Segoe WP", "Helvetica Neue", Sans-Serif');
                if (this.getFontSize() <= 0)
                    this.setFontSize(TDev.SizeMgr.topFontSize);
            }
            var parent = this.parent;
            if (parent && parent.children.length === 1)
                this.isSingleChild = true;
            if (this.contentType == WallBox.CONTENT_TEXT) {
                var parentattributes = (parent.attributes);
                this.attributes.textalign = parentattributes.textalign;
                this.attributes.wrap = parentattributes.wrap;
                this.attributes.wraplimit = parentattributes.wraplimit;
            }
            if (this.contentType == WallBox.CONTENT_INPUT) {
                var parentattributes = (parent.attributes);
                this.attributes.textalign = WallBox.ARRANGE_LEFT;
                this.attributes.wrap = this.textarea ? (parentattributes.wrap === undefined ? true : parentattributes.wrap) : false;
                this.attributes.wraplimit = parentattributes.wraplimit;
            }
            if (this.contentType == WallBox.CONTENT_IMAGE) {
                var parentattributes = (parent.attributes);
                this.attributes.textalign = parentattributes.textalign;
                this.attributes.width = parentattributes.width;
                this.attributes.height = parentattributes.height;
                if (parentattributes.stretchwidth !== -1)
                    this.attributes.stretchwidth = parentattributes.stretchwidth;
                if (parentattributes.stretchheight !== -1)
                    this.attributes.stretchheight = parentattributes.stretchheight;
                this.attributes.wrap = parentattributes.wrap;
                this.attributes.wraplimit = parentattributes.wraplimit;
            }
            var numchildren = this.children.length;
            var harr = this.attributes.arrangement[WallBox.H];
            if (harr !== undefined) {
                if (this.attributes.flow !== WallBox.FLOW_HORIZONTAL) {
                    for (var i = 0; i < numchildren; i++) {
                        var child = this.children[i];
                        child.attributes.stretchmargin[WallBox.L] = (harr == WallBox.ARRANGE_RIGHT || harr == WallBox.ARRANGE_CENTER || harr == WallBox.ARRANGE_SPREAD) ? 1 : 0;
                        child.attributes.stretchmargin[WallBox.R] = (harr == WallBox.ARRANGE_LEFT || harr == WallBox.ARRANGE_CENTER || harr == WallBox.ARRANGE_SPREAD) ? 1 : 0;
                    }
                }
                else {
                    for (var i = 0; i < numchildren; i++) {
                        var child = this.children[i];
                        child.attributes.stretchmargin[WallBox.L] = (harr == WallBox.ARRANGE_SPREAD || (i == 0 ? (harr == WallBox.ARRANGE_RIGHT || harr == WallBox.ARRANGE_CENTER) : (harr == WallBox.ARRANGE_JUSTIFY))) ? 1 : 0;
                        child.attributes.stretchmargin[WallBox.R] = (harr == WallBox.ARRANGE_SPREAD || (i == (numchildren - 1) ? (harr == WallBox.ARRANGE_LEFT || harr == WallBox.ARRANGE_CENTER) : (harr == WallBox.ARRANGE_JUSTIFY || harr == WallBox.ARRANGE_CENTER))) ? 1 : 0;
                    }
                }
            }
            var varr = this.attributes.arrangement[WallBox.V];
            if (varr !== WallBox.ARRANGE_BASELINE) {
                if (this.attributes.flow !== WallBox.FLOW_VERTICAL) {
                    for (var i = 0; i < numchildren; i++) {
                        var child = this.children[i];
                        child.attributes.stretchmargin[WallBox.T] = (varr == WallBox.ARRANGE_BOTTOM || varr == WallBox.ARRANGE_CENTER || varr == WallBox.ARRANGE_SPREAD) ? 1 : 0;
                        child.attributes.stretchmargin[WallBox.B] = (varr == WallBox.ARRANGE_TOP || varr == WallBox.ARRANGE_CENTER || varr == WallBox.ARRANGE_SPREAD) ? 1 : 0;
                    }
                }
                else {
                    for (var i = 0; i < numchildren; i++) {
                        var child = this.children[i];
                        child.attributes.stretchmargin[WallBox.T] = (varr == WallBox.ARRANGE_SPREAD || (i == 0 ? (varr == WallBox.ARRANGE_BOTTOM || varr == WallBox.ARRANGE_CENTER) : (varr == WallBox.ARRANGE_JUSTIFY))) ? 1 : 0;
                        child.attributes.stretchmargin[WallBox.B] = (varr == WallBox.ARRANGE_SPREAD || (i == (numchildren - 1) ? (varr == WallBox.ARRANGE_TOP || varr == WallBox.ARRANGE_CENTER) : (varr == WallBox.ARRANGE_JUSTIFY))) ? 1 : 0;
                    }
                }
            }
            if (!this.attributes.legacybaseline && (this.attributes.flow !== WallBox.FLOW_HORIZONTAL || varr !== WallBox.ARRANGE_BASELINE || numchildren < 2))
                for (var i = 0; i < numchildren; i++) {
                    var child = this.children[i];
                    child.attributes.legacybaseline = false;
                }
            _super.prototype.visitI.call(this);
            this.setRenderedTappable((this.attributes.tappedEvent.handlers || this.contenttapapplies()) ? true : false, false);
        };
        WallBox.prototype.speculationwascorrect = function (scroll) {
            return scroll === this.D_scr;
        };
        WallBox.prototype.bound = function (min, val, max) {
            if (min > val)
                return min;
            if (max < val)
                return max;
            return val;
        };
        WallBox.prototype.tryPreserveAspectRatio = function () {
            return /img|canvas|video|audio|boardContainer|viewPicture/i.test(this.content.tagName) || /boardContainer|viewPicture/i.test(this.content.className);
        };
        WallBox.prototype.fillh = function (f) {
            if (f <= 0)
                return false;
            if (Math.abs(1 - f) < 0.0001 || this.isRoot)
                return true;
            var a = this.attributes.arrangement[WallBox.H];
            return (a === WallBox.ARRANGE_LEFT || a === WallBox.ARRANGE_CENTER || a === WallBox.ARRANGE_SPREAD || a === WallBox.ARRANGE_RIGHT);
        };
        WallBox.prototype.fillv = function (f) {
            if (f <= 0)
                return false;
            if (f == 1 || this.isRoot)
                return true;
            var a = this.attributes.arrangement[WallBox.V];
            return (a === WallBox.ARRANGE_TOP || a === WallBox.ARRANGE_BOTTOM || a === WallBox.ARRANGE_CENTER || a === WallBox.ARRANGE_SPREAD);
        };
        WallBox.prototype.doLayout = function () {
            this.passA();
            this.passBC();
            this.passD();
        };
        WallBox.prototype.passA = function () {
            this.visitI();
            for (var i = 0; i < this.children.length; i++) {
                this.children[i].passA();
            }
            this.visitA();
        };
        WallBox.prototype.passBC = function () {
            this.visitB();
            for (var i = 0; i < this.children.length; i++)
                this.children[i].passBC();
            this.visitC();
        };
        WallBox.prototype.passD = function () {
            this.visitD();
            for (var i = 0; i < this.children.length; i++)
                this.children[i].passD();
            if (this.layoutcompletehandler)
                this.layoutcompletehandler(this.getRenderedWidth(), this.getRenderedHeight());
        };
        WallBox.prototype.visitA = function () {
            var numchildren = this.children.length;
            if (numchildren === 0) {
                if (this.contentType != WallBox.CONTENT_NONE && this.cached_width === -1) {
                    this.setRenderedWidth(-1);
                    this.setRenderedHeight(-1);
                    if ((this.contentType === WallBox.CONTENT_TEXT || this.contentType === WallBox.CONTENT_INPUT)) {
                        if (this.contentType === WallBox.CONTENT_INPUT) {
                            var text = this.textarea ? this.content.value : this.content.value;
                            text = text + " abc";
                            this.auxcontent.textContent = text;
                        }
                        this.setRenderedWrap(false, this.attributes.wraplimit);
                        var newwidth = (this.contentType === WallBox.CONTENT_INPUT) ? this.auxcontent.scrollWidth + (this.textarea ? (LayoutMgr.instance.scrollbarWidth + 50) : 50) : this.element.scrollWidth;
                        this.setRenderedWrap(this.attributes.wrap, this.attributes.wraplimit);
                        this.cached_width = newwidth;
                        this.cached_aspectratio = 0;
                        if (this.attributes.legacybaseline && this.cached_baseline === -1) {
                            if (!this.baselineprobe) {
                                this.baselineprobe = TDev.span(null, "s");
                                this.baselineprobe.style.fontSize = "0";
                                var c = TDev.div(null, TDev.span(null, "L"), this.baselineprobe);
                                c.style.visibility = "hidden";
                                c.style.position = "absolute";
                                this.element.appendChild(c);
                            }
                            var yPosition = 0;
                            this.cached_baseline = this.baselineprobe.offsetTop - this.baselineprobe.scrollTop + this.baselineprobe.clientTop;
                            this.element.removeChild(this.baselineprobe.parentElement);
                            this.baselineprobe = null;
                        }
                    }
                    else {
                        var targetelt = (this.content.className === "viewPicture") ? this.content.firstChild : this.content;
                        var ha = targetelt ? Number(targetelt.getAttribute("height")) : 0;
                        var wa = targetelt ? Number(targetelt.getAttribute("width")) : 0;
                        if (targetelt && (targetelt.tagName == "IMG" || targetelt.tagName == "VIDEO" || targetelt.tagName == "AUDIO")) {
                            ha = ha || targetelt.height;
                            wa = wa || targetelt.width;
                        }
                        this.cached_width = wa || this.element.scrollWidth;
                        this.cached_aspectratio = (this.tryPreserveAspectRatio() && this.cached_width) ? ((ha || this.element.scrollHeight) / this.cached_width) : 0;
                        if ((this.cached_width == 0) && targetelt && (targetelt.tagName == "VIDEO" || targetelt.tagName == "AUDIO")) {
                            this.cached_width = 300;
                        }
                        if ((this.cached_width == 0) && targetelt && (targetelt.tagName == "IMG")) {
                            this.cached_width = 100;
                        }
                    }
                }
                if (this.contentType === WallBox.CONTENT_IMAGE) {
                    if (this.cached_aspectratio > 0) {
                        var scmin = this.attributes.height[WallBox.MIN] / this.cached_aspectratio;
                        var scmax = this.attributes.height[WallBox.MAX] / this.cached_aspectratio;
                        if ((this.attributes.width[WallBox.MIN] <= scmax) && (this.attributes.width[WallBox.MAX] >= scmin))
                            this.A_sc = this.bound(scmin, this.cached_width, scmax);
                        else
                            this.A_sc = this.cached_width;
                    }
                    else {
                        this.A_sc = this.cached_width;
                    }
                    this.A_asc = this.A_sc;
                    var flex = (this.attributes.stretchwidth == 1 || !this.tryPreserveAspectRatio() || (this.attributes.stretchwidth == -1 && this.content && this.content.tagName == "IMG")) ? 1 : 0;
                    this.A_mc = flex ? 0 : this.A_asc;
                    this.A_fcc = flex;
                }
                else if (this.contentType === WallBox.CONTENT_TEXT) {
                    var statedwidth = this.cached_width;
                    var safetywidth = statedwidth + 1;
                    this.A_sc = safetywidth;
                    this.A_asc = (this.attributes.wrap) ? Math.min(this.A_sc, this.attributes.wraplimit * TDev.SizeMgr.topFontSize) : this.A_sc;
                    this.A_mc = this.A_asc;
                    this.A_fcc = 1;
                }
                else if (this.contentType === WallBox.CONTENT_INPUT) {
                    this.A_sc = this.cached_width;
                    this.A_asc = (this.attributes.wrap) ? Math.min(this.A_sc, this.attributes.wraplimit * TDev.SizeMgr.topFontSize) : this.A_sc;
                    this.A_mc = this.A_asc;
                    this.A_fcc = 1;
                }
                else {
                    this.A_sc = 0;
                    this.A_mc = 0;
                    this.A_asc = 0;
                    this.A_fcc = 0;
                }
            }
            else {
                if (this.attributes.flow === WallBox.FLOW_HORIZONTAL) {
                    var lm_s = this.attributes.padding[WallBox.L];
                    var lm_f = 0;
                    this.A_mc = lm_s;
                    this.A_sc = lm_s;
                    this.A_scc = 0;
                    this.A_asc = lm_s;
                    this.A_fcc = 0;
                    this.A_fcs = 0;
                    this.A_fp = 0;
                    for (var i = 0; i < numchildren; i++) {
                        var child = this.children[i];
                        var ws = Math.max(0, child.A_sl - lm_s) + child.A_sr;
                        lm_s = child.A_sr;
                        if (i == numchildren - 1)
                            ws += Math.max(0, this.attributes.padding[WallBox.R] - lm_s);
                        this.A_mc += child.A_m + ws;
                        this.A_sc += child.A_s + ws;
                        this.A_scc += child.A_s;
                        this.A_asc += child.A_as + ws;
                        this.A_fcc += child.A_f;
                        this.A_fcs += Math.max(0, child.A_fl - lm_f) + child.A_fr;
                        this.A_fp = this.A_fp || child.A_fp;
                        lm_f = child.A_fr;
                    }
                }
                else if (this.attributes.flow === WallBox.FLOW_VERTICAL || this.attributes.flow === WallBox.FLOW_OVERLAY) {
                    this.A_mc = 0;
                    this.A_sc = 0;
                    this.A_asc = 0;
                    this.A_fcc = 0;
                    this.A_fp = 0;
                    for (var i = 0; i < this.children.length; i++) {
                        var child = this.children[i];
                        var ws = Math.max(child.A_sl, this.attributes.padding[WallBox.L]) + Math.max(child.A_sr, this.attributes.padding[WallBox.R]);
                        this.A_mc = Math.max(this.A_mc, child.A_m + ws);
                        this.A_asc = Math.max(this.A_asc, child.A_as + ws);
                        this.A_sc = Math.max(this.A_sc, child.A_s + ws);
                        this.A_fcc = Math.max(this.A_fcc, child.A_f);
                        this.A_fp = this.A_fp || child.A_fp;
                    }
                }
            }
            var min = this.attributes.width[WallBox.MIN];
            var max = this.attributes.width[WallBox.MAX];
            var borderwidth = this.attributes.borderwidth[WallBox.L] + this.attributes.borderwidth[WallBox.R];
            this.A_scr = (this.attributes.scroll[WallBox.V] && (!this.isRoot || LayoutMgr.instance.scrollspeculation)) ? LayoutMgr.instance.scrollbarWidth : 0;
            this.A_m = this.bound(min, (this.attributes.scroll[WallBox.H] ? Math.min(this.A_mc, TDev.SizeMgr.topFontSize * 6) : this.A_mc) + this.A_scr, max) + borderwidth;
            this.A_as = this.bound(min, (this.attributes.scroll[WallBox.H] ? Math.min(this.A_mc, TDev.SizeMgr.topFontSize * 10) : this.A_asc) + this.A_scr, max) + borderwidth;
            this.A_s = this.bound(min, this.A_sc + this.A_scr, max) + borderwidth;
            this.A_sl = this.attributes.margin[WallBox.L];
            this.A_sr = this.attributes.margin[WallBox.R];
            this.A_f = (this.attributes.stretchwidth == -1) ? ((this.A_fp || (numchildren == 0)) ? (this.fillh(this.A_fcc) ? 1 : this.A_fcc) : 0) : this.attributes.stretchwidth;
            this.A_fp = (this.attributes.stretchwidth == -1) ? ((numchildren > 0) && (max > min) && this.A_fp) : (this.attributes.legacystretch[WallBox.H] ? 0 : this.attributes.stretchwidth);
            this.A_fl = this.attributes.stretchmargin[WallBox.L];
            this.A_fr = this.attributes.stretchmargin[WallBox.R];
        };
        WallBo