/// <reference path="../typings/globals/bluebird/index.d.ts" />
/// <reference path="../localtypings/pxtpackage.d.ts" />
/// <reference path="../localtypings/pxtparts.d.ts" />
/// <reference path="../localtypings/pxtarget.d.ts" />
/// <reference path="../typings/globals/winrt/index.d.ts" />
/// <reference path="../typings/globals/marked/index.d.ts" />
/// <reference path="../typings/globals/highlightjs/index.d.ts" />
/// <reference path="typescriptServices.d.ts" />
declare namespace pxt.analytics {
    function enable(): void;
}
declare namespace ts.pxtc {
    var __dummy: number;
}
import pxtc = ts.pxtc;
declare namespace ts.pxtc.Util {
    function assert(cond: boolean, msg?: string): void;
    function repeatMap<T>(n: number, fn: (index: number) => T): T[];
    function listsEqual<T>(a: T[], b: T[]): boolean;
    function oops(msg?: string): Error;
    function reversed<T>(arr: T[]): T[];
    function flatClone<T>(obj: T): T;
    function clone<T>(v: T): T;
    function iterMap<T>(m: pxt.Map<T>, f: (k: string, v: T) => void): void;
    function mapMap<T, S>(m: pxt.Map<T>, f: (k: string, v: T) => S): pxt.Map<S>;
    function mapStringMapAsync<T, S>(m: pxt.Map<T>, f: (k: string, v: T) => Promise<S>): Promise<pxt.Map<S>>;
    function values<T>(m: pxt.Map<T>): T[];
    function lookup<T>(m: pxt.Map<T>, key: string): T;
    function pushRange<T>(trg: T[], src: T[]): void;
    function concat<T>(arrays: T[][]): T[];
    function memcpy(trg: Uint8Array, trgOff: number, src: ArrayLike<number>, srcOff?: number, len?: number): void;
    function jsonMergeFrom(trg: any, src: any): void;
    function jsonCopyFrom<T>(trg: T, src: T): void;
    function jsonFlatten(v: any): pxt.Map<any>;
    function jsonUnFlatten(v: pxt.Map<any>): any;
    function strcmp(a: string, b: string): number;
    function stringMapEq(a: pxt.Map<string>, b: pxt.Map<string>): boolean;
    function endsWith(str: string, suffix: string): boolean;
    function startsWith(str: string, prefix: string): boolean;
    function contains(str: string, contains: string): boolean;
    function replaceAll(str: string, old: string, new_: string): string;
    function sortObjectFields<T>(o: T): T;
    function chopArray<T>(arr: T[], chunkSize: number): T[][];
    function unique<T>(arr: T[], f: (t: T) => string): T[];
    function groupBy<T>(arr: T[], f: (t: T) => string): pxt.Map<T[]>;
    function toDictionary<T>(arr: T[], f: (t: T) => string): pxt.Map<T>;
    interface ArrayLike<T> {
        [index: number]: T;
        length: number;
    }
    function toArray<T>(a: ArrayLike<T>): T[];
    function indexOfMatching<T>(arr: T[], f: (t: T) => boolean): number;
    function nextTick(f: () => void): void;
    function memoizeString<T>(createNew: (id: string) => T): (id: string) => T;
    function memoize<S, T>(getId: (v: S) => string, createNew: (v: S) => T): (id: S) => T;
    function debounce(func: () => void, wait: number, immediate: boolean): () => void;
    function randomPermute<T>(arr: T[]): void;
    function randomPick<T>(arr: T[]): T;
    function isoTime(time: number): string;
    function timeSince(time: number): string;
    function unicodeToChar(text: string): string;
    function escapeForRegex(str: string): string;
    function stripUrlProtocol(str: string): string;
    let isNodeJS: boolean;
    interface HttpRequestOptions {
        url: string;
        method?: string;
        data?: any;
        headers?: pxt.Map<string>;
        allowHttpErrors?: boolean;
        allowGzipPost?: boolean;
        responseArrayBuffer?: boolean;
    }
    interface HttpResponse {
        statusCode: number;
        headers: pxt.Map<string>;
        buffer?: any;
        text?: string;
        json?: any;
    }
    function requestAsync(options: HttpRequestOptions): Promise<HttpResponse>;
    function httpGetTextAsync(url: string): Promise<string>;
    function httpGetJsonAsync(url: string): Promise<any>;
    function httpPostJsonAsync(url: string, data: any): Promise<any>;
    function userError(msg: string): Error;
    function stringToUint8Array(input: string): Uint8Array;
    function uint8ArrayToString(input: Uint8Array): string;
    function fromUTF8(binstr: string): string;
    function toUTF8(str: string): string;
    function toHex(bytes: Uint8Array): string;
    function fromHex(hex: string): Uint8Array;
    class PromiseQueue {
        promises: pxt.Map<(() => Promise<any>)[]>;
        enqueue<T>(id: string, f: () => Promise<T>): Promise<T>;
    }
    class PromiseBuffer<T> {
        private waiting;
        private available;
        drain(): void;
        pushError(v: Error): void;
        push(v: T): void;
        shiftAsync(timeout?: number): Promise<T>;
    }
    function now(): number;
    function nowSeconds(): number;
    function getMime(filename: string): string;
    function randomUint32(): number;
    function guidGen(): string;
    var localizeLive: boolean;
    /**
     * Returns the current user language, prepended by "live-" if in live mode
     */
    function localeInfo(): string;
    /**
     * Returns current user language iSO-code. Default is `en`.
     */
    function userLanguage(): string;
    function isUserLanguageRtl(): boolean;
    function _localize(s: string): string;
    function downloadLiveTranslationsAsync(lang: string, filename: string, branch?: string): Promise<pxt.Map<string>>;
    function getLocalizedStrings(): pxt.Map<string>;
    function setLocalizedStrings(strs: pxt.Map<string>): void;
    function updateLocalizationAsync(targetId: string, simulator: boolean, baseUrl: string, code: string, pxtBranch: string, targetBranch: string, live?: boolean): Promise<any>;
    function htmlEscape(_input: string): string;
    function jsStringQuote(s: string): string;
    function jsStringLiteral(s: string): string;
    function fmt_va(f: string, args: any[]): string;
    function fmt(f: string, ...args: any[]): string;
    function dumpLocStats(): void;
    function lf_va(format: string, args: any[]): string;
    function lf(format: string, ...args: any[]): string;
    /**
     * Similar to lf but the string do not get extracted into the loc file.
     */
    function rlf(format: string, ...args: any[]): string;
    let httpRequestCoreAsync: (options: HttpRequestOptions) => Promise<HttpResponse>;
    let sha256: (hashData: string) => string;
    let getRandomBuf: (buf: Uint8Array) => void;
    function capitalize(n: string): string;
    function uncapitalize(n: string): string;
    function range(len: number): number[];
    function multipartPostAsync(uri: string, data?: any, filename?: string, filecontents?: string): Promise<HttpResponse>;
    function toDataUri(data: string, mimetype?: string): string;
}
declare namespace ts.pxtc.BrowserImpl {
    function sha256block(buf: Uint8Array): Uint32Array;
    function sha256buffer(buf: Uint8Array): string;
    function sha256string(s: string): string;
}
declare namespace pxt {
    export import U = pxtc.Util;
    export import Util = pxtc.Util;
    let appTarget: TargetBundle;
    function setAppTarget(trg: TargetBundle): void;
    interface PxtOptions {
        debug?: boolean;
        light?: boolean;
        wsPort?: number;
    }
    var options: PxtOptions;
    var debug: (msg: any) => void;
    var log: (msg: any) => void;
    var reportException: (err: any, data?: Map<string>) => void;
    var reportError: (cat: string, msg: string, data?: Map<string>) => void;
    /**
     * Track an event.
     */
    var tickEvent: (id: string, data?: Map<string | number>) => void;
    /**
     * Ticks activity events. This event gets aggregated and eventually gets sent.
     */
    function tickActivity(...ids: string[]): void;
    interface WebConfig {
        relprefix: string;
        workerjs: string;
        tdworkerjs: string;
        monacoworkerjs: string;
        pxtVersion: string;
        pxtRelId: string;
        pxtCdnUrl: string;
        commitCdnUrl: string;
        blobCdnUrl: string;
        cdnUrl: string;
        targetUrl: string;
        targetVersion: string;
        targetRelId: string;
        targetId: string;
        simUrl: string;
        partsUrl?: string;
        runUrl?: string;
        docsUrl?: string;
        isStatic?: boolean;
    }
    function localWebConfig(): WebConfig;
    var webConfig: WebConfig;
    function getOnlineCdnUrl(): string;
    function setupWebConfig(cfg: WebConfig): void;
    interface CompileTarget extends pxtc.CompileTarget {
        preferredEditor?: string;
    }
    interface Host {
        readFile(pkg: Package, filename: string): string;
        writeFile(pkg: Package, filename: string, contents: string, force?: boolean): void;
        downloadPackageAsync(pkg: Package): Promise<void>;
        getHexInfoAsync(extInfo: pxtc.ExtensionInfo): Promise<pxtc.HexInfo>;
        cacheStoreAsync(id: string, val: string): Promise<void>;
        cacheGetAsync(id: string): Promise<string>;
    }
    interface FsFile {
        name: string;
        mtime: number;
        content?: string;
        prevContent?: string;
    }
    interface FsPkg {
        path: string;
        config: pxt.PackageConfig;
        files: FsFile[];
        icon?: string;
    }
    interface FsPkgs {
        pkgs: FsPkg[];
    }
    interface ICompilationOptions {
    }
    function getEmbeddedScript(id: string): Map<string>;
    class Package {
        id: string;
        _verspec: string;
        parent: MainPackage;
        static getConfigAsync(id: string, fullVers: string): Promise<pxt.PackageConfig>;
        static upgradePackageReference(pkg: string, val: string): string;
        addedBy: Package[];
        config: PackageConfig;
        level: number;
        isLoaded: boolean;
        private resolvedVersion;
        constructor(id: string, _verspec: string, parent: MainPackage, addedBy: Package);
        version(): string;
        verProtocol(): string;
        verArgument(): string;
        commonDownloadAsync(): Promise<Map<string>>;
        host(): Host;
        readFile(fn: string): string;
        resolveDep(id: string): Package;
        saveConfig(): void;
        private resolveVersionAsync();
        private downloadAsync();
        protected validateConfig(): void;
        isPackageInUse(pkgId: string, ts?: string): boolean;
        getMissingPackages(config: pxt.PackageConfig, ts: string): Map<string>;
        /**
         * For the given package config or ID, looks through all the currently installed packages to find conflicts in
         * Yotta settings and version spec
         */
        findConflictsAsync(pkgOrId: string | PackageConfig, version: string): Promise<cpp.PkgConflictError[]>;
        upgradeAPI(fileContents: string): string;
        private parseConfig(cfgSrc);
        loadAsync(isInstall?: boolean): Promise<void>;
        getFiles(): string[];
        addSnapshot(files: Map<string>, exts?: string[]): void;
        /**
         * Returns localized strings qName -> translation
         */
        packageLocalizationStringsAsync(lang: string): Promise<Map<string>>;
    }
    class MainPackage extends Package {
        _host: Host;
        deps: Map<Package>;
        constructor(_host: Host);
        installAllAsync(): Promise<void>;
        sortedDeps(): Package[];
        localizationStringsAsync(lang: string): Promise<Map<string>>;
        getTargetOptions(): CompileTarget;
        getCompileOptionsAsync(target?: CompileTarget): Promise<pxtc.CompileOptions>;
        filesToBePublishedAsync(allowPrivate?: boolean): Promise<Map<string>>;
        compressToFileAsync(editor?: string): Promise<Uint8Array>;
        computePartDefinitions(parts: string[]): pxt.Map<pxsim.PartDefinition>;
    }
    function targetConfigAsync(): Promise<pxt.TargetConfig>;
    function packagesConfigAsync(): Promise<pxt.PackagesConfig>;
    const CONFIG_NAME: string;
    const CLOUD_ID: string;
    const BLOCKS_PROJECT_NAME: string;
    const JAVASCRIPT_PROJECT_NAME: string;
}
declare namespace pxt.blocks {
    interface BlockParameter {
        name: string;
        type?: string;
        shadowType?: string;
        shadowValue?: string;
    }
    function normalizeBlock(b: string): string;
    function parameterNames(fn: pxtc.SymbolInfo): Map<BlockParameter>;
    interface FieldDescription {
        n: string;
        pre?: string;
        p?: string;
        ni: number;
    }
    function parseFields(b: string): FieldDescription[];
    interface BlockDefinition {
        name: string;
        category: string;
        url: string;
        tooltip?: string | Map<string>;
        operators?: Map<string[]>;
        block?: Map<string>;
        blockTextSearch?: string;
        tooltipSearch?: string;
    }
    function blockDefinitions(): Map<BlockDefinition>;
    function getBlockDefinition(blockId: string): BlockDefinition;
}
declare namespace pxt.BrowserUtils {
    function isWinRT(): boolean;
    function isIFrame(): boolean;
    function hasNavigator(): boolean;
    function isWindows(): boolean;
    function isMobile(): boolean;
    function isMac(): boolean;
    function isLinux(): boolean;
    function isARM(): boolean;
    function isEdge(): boolean;
    function isIE(): boolean;
    function isChrome(): boolean;
    function isSafari(): boolean;
    function isFirefox(): boolean;
    function isOpera(): boolean;
    function isMidori(): boolean;
    function isEpiphany(): boolean;
    function isTouchEnabled(): boolean;
    function hasSaveAs(): boolean;
    function os(): string;
    function browser(): string;
    function browserVersion(): string;
    function isBrowserSupported(): boolean;
    function devicePixelRatio(): number;
    function browserDownloadBinText(text: string, name: string, contentType?: string, userContextWindow?: Window, onError?: (err: any) => void): string;
    function browserDownloadText(text: string, name: string, contentType?: string, userContextWindow?: Window, onError?: (err: any) => void): string;
    function isBrowserDownloadInSameWindow(): boolean;
    function browserDownloadDataUri(uri: string, name: string, userContextWindow?: Window): void;
    function browserDownloadUInt8Array(buf: Uint8Array, name: string, contentType?: string, userContextWindow?: Window, onError?: (err: any) => void): string;
    function browserDownloadBase64(b64: string, name: string, contentType?: string, userContextWindow?: Window, onError?: (err: any) => void): string;
    function loadImageAsync(data: string): Promise<HTMLImageElement>;
    function loadScriptAsync(url: string): Promise<void>;
    function loadAjaxAsync(url: string): Promise<string>;
}
declare namespace pxt.commands {
    let deployCoreAsync: (r: ts.pxtc.CompileResult) => Promise<void>;
    let browserDownloadAsync: (text: string, name: string, contentType: string) => Promise<void>;
    let saveOnlyAsync: (r: ts.pxtc.CompileResult) => Promise<void>;
}
declare namespace pxt {
    function lzmaDecompressAsync(buf: Uint8Array): Promise<string>;
    function lzmaCompressAsync(text: string): Promise<Uint8Array>;
}
declare namespace pxt.cpp {
    function nsWriter(nskw?: string): {
        setNs: (ns: string, over?: string) => void;
        clear: () => void;
        write: (s: string) => void;
        incrIndent: () => void;
        decrIndent: () => void;
        finish: () => string;
    };
    function parseCppInt(v: string): number;
    class PkgConflictError extends Error {
        pkg0: Package;
        pkg1: Package;
        settingName: string;
        isUserError: boolean;
        isVersionConflict: boolean;
        constructor(msg: string);
    }
    function getExtensionInfo(mainPkg: MainPackage): pxtc.ExtensionInfo;
    interface HexFile {
        meta?: {
            cloudId: string;
            targetVersions?: pxt.TargetVersions;
            editor: string;
            name: string;
        };
        source: string;
    }
    function unpackSourceFromHexFileAsync(file: File): Promise<HexFile>;
    function unpackSourceFromHexAsync(dat: Uint8Array): Promise<HexFile>;
}
declare namespace pxt.hex {
    function storeWithLimitAsync(host: Host, idxkey: string, newkey: string, newval: string, maxLen?: number): Promise<void>;
    function recordGetAsync(host: Host, idxkey: string, newkey: string): Promise<void>;
    function getHexInfoAsync(host: Host, extInfo: pxtc.ExtensionInfo, cloudModule?: any): Promise<pxtc.HexInfo>;
}
declare namespace pxt.crowdin {
    const KEY_VARIABLE: string;
    interface DownloadOptions {
        translatedOnly?: boolean;
        validatedOnly?: boolean;
    }
    function downloadTranslationsAsync(branch: string, prj: string, key: string, filename: string, options?: DownloadOptions): Promise<Map<Map<string>>>;
    function createDirectoryAsync(branch: string, prj: string, key: string, name: string, incr?: () => void): Promise<void>;
    function uploadTranslationAsync(branch: string, prj: string, key: string, filename: string, data: string): Promise<void>;
}
declare namespace pxt.docs {
    function htmlQuote(s: string): string;
    function html2Quote(s: string): string;
    interface BreadcrumbEntry {
        name: string;
        href: string;
    }
    var requireMarked: () => any;
    interface RenderData {
        html: string;
        theme: AppTheme;
        params: Map<string>;
        filepath?: string;
        ghEditURLs?: string[];
        finish?: () => string;
        boxes?: Map<string>;
        macros?: Map<string>;
        settings?: Map<string>;
    }
    function prepTemplate(d: RenderData): void;
    interface RenderOptions {
        template: string;
        markdown: string;
        theme?: AppTheme;
        pubinfo?: Map<string>;
        filepath?: string;
        locale?: Map<string>;
        ghEditURLs?: string[];
        repo?: {
            name: string;
            fullName: string;
            tag?: string;
        };
    }
    function renderMarkdown(opts: RenderOptions): string;
    function embedUrl(rootUrl: string, tag: string, id: string, height?: number): string;
    function runUrl(url: string, padding: string, id: string): string;
    function docsEmbedUrl(rootUrl: string, id: string, height?: number): string;
    function translate(html: string, locale: Map<string>): {
        text: string;
        missing: Map<string>;
    };
    function buildTOC(summaryMD: string): pxt.TOCMenuEntry[];
    function visitTOC(toc: TOCMenuEntry[], fn: (e: TOCMenuEntry) => void): void;
    function augmentDocs(baseMd: string, childMd: string): string;
}
declare namespace pxt.github {
    function listRefsAsync(repopath: string, namespace?: string): Promise<string[]>;
    function tagToShaAsync(repopath: string, tag: string): Promise<string>;
    interface CachedPackage {
        sha: string;
        files: Map<string>;
    }
    function pkgConfigAsync(repopath: string, tag?: string): Promise<PackageConfig>;
    function downloadPackageAsync(repoWithTag: string, config: pxt.PackagesConfig, current?: CachedPackage): Promise<CachedPackage>;
    interface ParsedRepo {
        owner?: string;
        fullName: string;
        tag?: string;
    }
    enum GitRepoStatus {
        Unknown = 0,
        Approved = 1,
        Banned = 2,
    }
    interface GitRepo extends ParsedRepo {
        name: string;
        description: string;
        defaultBranch: string;
        status?: GitRepoStatus;
    }
    function repoIconUrl(repo: GitRepo): string;
    function repoStatus(rr: ParsedRepo, config: pxt.PackagesConfig): GitRepoStatus;
    function repoAsync(id: string, config: pxt.PackagesConfig): Promise<GitRepo>;
    function searchAsync(query: string, config: pxt.PackagesConfig): Promise<GitRepo[]>;
    function parseRepoUrl(url: string): {
        repo: string;
        tag?: string;
        path?: string;
    };
    function parseRepoId(repo: string): ParsedRepo;
    function isGithubId(id: string): boolean;
    function stringifyRepo(p: ParsedRepo): string;
    function noramlizeRepoId(id: string): string;
    function latestVersionAsync(path: string, config: TargetConfig): Promise<string>;
    function publishGistAsync(token: string, forceNew: boolean, files: any, name: string, currentGistId: string): Promise<any>;
}
declare namespace pxt.HF2 {
    const enum VID {
        ATMEL = 1003,
        ARDUINO = 9025,
        ADAFRUIT = 9114,
        NXP = 3368,
    }
    interface TalkArgs {
        cmd: number;
        data?: Uint8Array;
    }
    interface PacketIO {
        sendPacketAsync(pkt: Uint8Array): Promise<void>;
        onData: (v: Uint8Array) => void;
        onError: (e: Error) => void;
        onEvent: (v: Uint8Array) => void;
        error(msg: string): any;
        reconnectAsync(): Promise<void>;
        disconnectAsync(): Promise<void>;
        talksAsync?(cmds: TalkArgs[]): Promise<Uint8Array[]>;
        sendSerialAsync?(buf: Uint8Array, useStdErr: boolean): Promise<void>;
        onSerial?: (v: Uint8Array, isErr: boolean) => void;
    }
    let mkPacketIOAsync: () => Promise<pxt.HF2.PacketIO>;
    const HF2_CMD_BININFO: number;
    const HF2_MODE_BOOTLOADER: number;
    const HF2_MODE_USERSPACE: number;
    const HF2_CMD_INFO: number;
    const HF2_CMD_RESET_INTO_APP: number;
    const HF2_CMD_RESET_INTO_BOOTLOADER: number;
    const HF2_CMD_START_FLASH: number;
    const HF2_CMD_WRITE_FLASH_PAGE: number;
    const HF2_CMD_CHKSUM_PAGES: number;
    const HF2_CMD_READ_WORDS: number;
    const HF2_CMD_WRITE_WORDS: number;
    const HF2_CMD_DMESG: number;
    const HF2_FLAG_SERIAL_OUT: number;
    const HF2_FLAG_SERIAL_ERR: number;
    const HF2_FLAG_CMDPKT_LAST: number;
    const HF2_FLAG_CMDPKT_BODY: number;
    const HF2_FLAG_MASK: number;
    const HF2_SIZE_MASK: number;
    const HF2_STATUS_OK: number;
    const HF2_STATUS_INVALID_CMD: number;
    const HF2_STATUS_EXEC_ERR: number;
    const HF2_STATUS_EVENT: number;
    const HF2_EV_MASK: number;
    function write32(buf: ArrayLike<number>, pos: number, v: number): void;
    function write16(buf: ArrayLike<number>, pos: number, v: number): void;
    function read32(buf: ArrayLike<number>, pos: number): number;
    function read16(buf: ArrayLike<number>, pos: number): number;
    function encodeU32LE(words: number[]): Uint8Array;
    function decodeU32LE(buf: Uint8Array): number[];
    interface BootloaderInfo {
        Header: string;
        Parsed: {
            Version: string;
            Features: string;
        };
        Model: string;
        BoardID: string;
    }
    function enableLog(): void;
    class Wrapper {
        io: PacketIO;
        private cmdSeq;
        constructor(io: PacketIO);
        private lock;
        rawMode: boolean;
        infoRaw: string;
        info: BootloaderInfo;
        pageSize: number;
        flashSize: number;
        maxMsgSize: number;
        bootloaderMode: boolean;
        reconnectTries: number;
        msgs: U.PromiseBuffer<Uint8Array>;
        eventHandlers: pxt.Map<(buf: Uint8Array) => void>;
        onSerial: (buf: Uint8Array, isStderr: boolean) => void;
        private resetState();
        onEvent(id: number, f: (buf: Uint8Array) => void): void;
        reconnectAsync(first?: boolean): Promise<void>;
        disconnectAsync(): Promise<void>;
        error(m: string): any;
        talkAsync(cmd: number, data?: Uint8Array): Promise<Uint8Array>;
        private sendMsgAsync(buf);
        sendSerialAsync(buf: Uint8Array, useStdErr?: boolean): Promise<void>;
        private sendMsgCoreAsync(buf, serial?);
        switchToBootloaderAsync(): Promise<void>;
        reflashAsync(blocks: pxtc.UF2.Block[]): Promise<void>;
        writeWordsAsync(addr: number, words: number[]): Promise<void>;
        readWordsAsync(addr: number, numwords: number): Promise<Uint8Array>;
        flashAsync(blocks: pxtc.UF2.Block[]): Promise<void>;
        private initAsync();
    }
    type ReadAsync = (addr: number, len: number) => Promise<ArrayLike<number>>;
    function onlyChangedBlocksAsync(blocks: pxtc.UF2.Block[], readWordsAsync: ReadAsync): Promise<pxtc.UF2.Block[]>;
}
declare namespace pxt.semver {
    interface Version {
        major: number;
        minor: number;
        patch: number;
        pre: string[];
        build: string[];
    }
    function cmp(a: Version, b: Version): number;
    function parse(v: string): Version;
    function tryParse(v: string): Version;
    function stringify(v: Version): string;
    function majorCmp(a: string, b: string): number;
    function strcmp(a: string, b: string): number;
    function test(): void;
}
declare namespace ts.pxtc {
    const assert: typeof U.assert;
    const oops: typeof U.oops;
    export import U = pxtc.Util;
    const ON_START_TYPE: string;
    const ON_START_COMMENT: string;
    const TS_STATEMENT_TYPE: string;
    const TS_OUTPUT_TYPE: string;
    const BINARY_JS: string;
    const BINARY_HEX: string;
    const BINARY_ASM: string;
    const BINARY_UF2: string;
    interface ParameterDesc {
        name: string;
        description: string;
        type: string;
        initializer?: string;
        default?: string;
        properties?: PropertyDesc[];
        options?: pxt.Map<PropertyOption>;
        isEnum?: boolean;
    }
    interface PropertyDesc {
        name: string;
        type: string;
    }
    interface PropertyOption {
        value: any;
    }
    enum SymbolKind {
        None = 0,
        Method = 1,
        Property = 2,
        Function = 3,
        Variable = 4,
        Module = 5,
        Enum = 6,
        EnumMember = 7,
        Class = 8,
        Interface = 9,
    }
    interface SymbolInfo {
        attributes: CommentAttrs;
        name: string;
        namespace: string;
        kind: SymbolKind;
        parameters: ParameterDesc[];
        retType: string;
        extendsTypes?: string[];
        isContextual?: boolean;
        qName?: string;
        pkg?: string;
        snippet?: string;
    }
    interface ApisInfo {
        byQName: pxt.Map<SymbolInfo>;
    }
    interface BlocksInfo {
        apis: ApisInfo;
        blocks: SymbolInfo[];
        blocksById: pxt.Map<SymbolInfo>;
    }
    interface CompletionEntry {
        name: string;
        kind: string;
        qualifiedName: string;
    }
    interface CompletionInfo {
        entries: pxt.Map<SymbolInfo>;
        isMemberCompletion: boolean;
        isNewIdentifierLocation: boolean;
        isTypeLocation: boolean;
    }
    interface CommentAttrs {
        debug?: boolean;
        shim?: string;
        enumval?: string;
        helper?: string;
        help?: string;
        async?: boolean;
        promise?: boolean;
        hidden?: boolean;
        callingConvention: ir.CallingConvention;
        block?: string;
        blockId?: string;
        blockGap?: string;
        blockExternalInputs?: boolean;
        blockImportId?: string;
        blockBuiltin?: boolean;
        blockNamespace?: string;
        blockIdentity?: string;
        blockAllowMultiple?: boolean;
        blockHidden?: boolean;
        blockImage?: boolean;
        fixedInstances?: boolean;
        fixedInstance?: boolean;
        indexedInstanceNS?: string;
        indexedInstanceShim?: string;
        defaultInstance?: string;
        autoCreate?: string;
        noRefCounting?: boolean;
        color?: string;
        icon?: string;
        imageLiteral?: number;
        weight?: number;
        parts?: string;
        trackArgs?: number[];
        advanced?: boolean;
        deprecated?: boolean;
        useEnumVal?: boolean;
        subcategory?: string;
        subcategories?: string[];
        indexerGet?: string;
        indexerSet?: string;
        mutate?: string;
        mutateText?: string;
        mutatePrefix?: string;
        mutateDefaults?: string;
        mutatePropertyEnum?: string;
        _name?: string;
        _source?: string;
        jsDoc?: string;
        paramHelp?: pxt.Map<string>;
        paramDefl: pxt.Map<string>;
        paramMin?: pxt.Map<string>;
        paramMax?: pxt.Map<string>;
        paramFieldEditor?: pxt.Map<string>;
        paramShadowOptions?: pxt.Map<pxt.Map<string>>;
        paramFieldEditorOptions?: pxt.Map<pxt.Map<string>>;
    }
    interface LocationInfo {
        fileName: string;
        start: number;
        length: number;
        line: number;
        column: number;
        endLine?: number;
        endColumn?: number;
    }
    interface FunctionLocationInfo extends LocationInfo {
        functionName: string;
    }
    interface KsDiagnostic extends LocationInfo {
        code: number;
        category: DiagnosticCategory;
        messageText: string | DiagnosticMessageChain;
    }
    interface CompileResult {
        outfiles: pxt.Map<string>;
        diagnostics: KsDiagnostic[];
        success: boolean;
        times: pxt.Map<number>;
        breakpoints?: Breakpoint[];
        procDebugInfo?: ProcDebugInfo[];
        blocksInfo?: BlocksInfo;
        usedSymbols?: pxt.Map<SymbolInfo>;
        usedArguments?: pxt.Map<string[]>;
        saveOnly?: boolean;
        userContextWindow?: Window;
    }
    interface Breakpoint extends LocationInfo {
        id: number;
        isDebuggerStmt: boolean;
        successors: number[];
        binAddr?: number;
    }
    interface CellInfo {
        name: string;
        type: string;
    }
    interface ProcCallInfo {
        procIndex: number;
        callLabel: string;
        addr: number;
        stack: number;
    }
    interface ProcDebugInfo {
        name: string;
        idx: number;
        bkptLoc: number;
        codeStartLoc: number;
        locals: CellInfo[];
        args: CellInfo[];
        localsMark: number;
        calls: ProcCallInfo[];
    }
    function computeUsedParts(resp: CompileResult, ignoreBuiltin?: boolean): string[];
    /**
     * Unlocalized category name for a symbol
     */
    function blocksCategory(si: SymbolInfo): string;
    function getBlocksInfo(info: ApisInfo): BlocksInfo;
    function localizeApisAsync(apis: pxtc.ApisInfo, mainPkg: pxt.MainPackage): Promise<pxtc.ApisInfo>;
    function emptyExtInfo(): ExtensionInfo;
    function parseCommentString(cmt: string): CommentAttrs;
    namespace hex {
        function isSetupFor(extInfo: ExtensionInfo): boolean;
        let currentSetup: string;
        let currentHexInfo: pxtc.HexInfo;
        interface ChecksumBlock {
            magic: number;
            endMarkerPos: number;
            endMarker: number;
            regions: {
                start: number;
                length: number;
                checksum: number;
            }[];
        }
        function parseChecksumBlock(buf: ArrayLike<number>, pos?: number): ChecksumBlock;
    }
    var decodeBase64: (s: string) => string;
    namespace UF2 {
        const UF2_MAGIC_START0: number;
        const UF2_MAGIC_START1: number;
        const UF2_MAGIC_END: number;
        interface Block {
            flags: number;
            targetAddr: number;
            payloadSize: number;
            blockNo: number;
            numBlocks: number;
            data: Uint8Array;
        }
        function parseBlock(block: Uint8Array): Block;
        function parseFile(blocks: Uint8Array): Block[];
        function toBin(blocks: Uint8Array): {
            buf: Uint8Array;
            start: number;
        };
        function readBytes(blocks: Block[], addr: number, length: number): Uint8Array;
        const startMagic: string;
        const endMagic: string;
        interface BlockFile {
            currBlock: Uint8Array;
            currPtr: number;
            blocks: Uint8Array[];
            ptrs: number[];
        }
        function newBlockFile(): BlockFile;
        function serializeFile(f: BlockFile): string;
        function writeBytes(f: BlockFile, addr: number, bytes: number[]): void;
        function writeHex(f: BlockFile, hex: string[]): void;
    }
}
declare namespace ts.pxtc.service {
    interface OpArg {
        fileName?: string;
        fileContent?: string;
        position?: number;
        options?: CompileOptions;
        search?: SearchOptions;
        format?: FormatOptions;
    }
    interface SearchOptions {
        subset?: pxt.Map<boolean>;
        term: string;
        localizedApis?: ApisInfo;
        localizedStrings?: pxt.Map<string>;
    }
    interface FormatOptions {
        input: string;
        pos: number;
    }
    interface SearchInfo {
        id: string;
        name: string;
        qName?: string;
        block?: string;
        namespace?: string;
        jsdoc?: string;
        field?: [string, string];
    }
}
declare namespace ts.pxtc.ir {
    enum CallingConvention {
        Plain = 0,
        Async = 1,
        Promise = 2,
    }
}
declare namespace pxt.streams {
    interface JsonStreamField {
        name: string;
        sum: number;
        min: number;
        max: number;
        count: number;
    }
    interface JsonStreamMeta {
        fields: JsonStreamField[];
        size: number;
        rows: number;
        batches: number;
    }
    interface JsonStream {
        kind: string;
        id: string;
        time: number;
        name?: string;
        meta: JsonStreamMeta;
        privatekey?: string;
    }
    interface JsonStreamPayload {
        fields: string[];
        values: number[][];
    }
    interface JsonStreamPayloadResponse {
        meta: JsonStreamMeta;
        quotaUsedHere: number;
        quotaLeft: number;
    }
    interface JsonStreamData {
        fields: JsonStreamField[];
        values: number[][];
        continuation?: string;
        continuationUrl?: string;
    }
    function createStreamAsync(target: string, name?: string): Promise<JsonStream>;
    function postPayloadAsync(stream: JsonStream, data: JsonStreamPayload): Promise<void>;
}
declare namespace ts.pxtc {
    function flattenDiagnosticMessageText(messageText: string | DiagnosticMessageChain, newLine: string): string;
    enum ScriptTarget {
        ES3 = 0,
        ES5 = 1,
        ES6 = 2,
        ES2015 = 2,
        Latest = 2,
    }
    const enum CharacterCodes {
        nullCharacter = 0,
        maxAsciiCharacter = 127,
        lineFeed = 10,
        carriageReturn = 13,
        lineSeparator = 8232,
        paragraphSeparator = 8233,
        nextLine = 133,
        space = 32,
        nonBreakingSpace = 160,
        enQuad = 8192,
        emQuad = 8193,
        enSpace = 8194,
        emSpace = 8195,
        threePerEmSpace = 8196,
        fourPerEmSpace = 8197,
        sixPerEmSpace = 8198,
        figureSpace = 8199,
        punctuationSpace = 8200,
        thinSpace = 8201,
        hairSpace = 8202,
        zeroWidthSpace = 8203,
        narrowNoBreakSpace = 8239,
        ideographicSpace = 12288,
        mathematicalSpace = 8287,
        ogham = 5760,
        _ = 95,
        $ = 36,
        _0 = 48,
        _1 = 49,
        _2 = 50,
        _3 = 51,
        _4 = 52,
        _5 = 53,
        _6 = 54,
        _7 = 55,
        _8 = 56,
        _9 = 57,
        a = 97,
        b = 98,
        c = 99,
        d = 100,
        e = 101,
        f = 102,
        g = 103,
        h = 104,
        i = 105,
        j = 106,
        k = 107,
        l = 108,
        m = 109,
        n = 110,
        o = 111,
        p = 112,
        q = 113,
        r = 114,
        s = 115,
        t = 116,
        u = 117,
        v = 118,
        w = 119,
        x = 120,
        y = 121,
        z = 122,
        A = 65,
        B = 66,
        C = 67,
        D = 68,
        E = 69,
        F = 70,
        G = 71,
        H = 72,
        I = 73,
        J = 74,
        K = 75,
        L = 76,
        M = 77,
        N = 78,
        O = 79,
        P = 80,
        Q = 81,
        R = 82,
        S = 83,
        T = 84,
        U = 85,
        V = 86,
        W = 87,
        X = 88,
        Y = 89,
        Z = 90,
        ampersand = 38,
        asterisk = 42,
        at = 64,
        backslash = 92,
        backtick = 96,
        bar = 124,
        caret = 94,
        closeBrace = 125,
        closeBracket = 93,
        closeParen = 41,
        colon = 58,
        comma = 44,
        dot = 46,
        doubleQuote = 34,
        equals = 61,
        exclamation = 33,
        greaterThan = 62,
        hash = 35,
        lessThan = 60,
        minus = 45,
        openBrace = 123,
        openBracket = 91,
        openParen = 40,
        percent = 37,
        plus = 43,
        question = 63,
        semicolon = 59,
        singleQuote = 39,
        slash = 47,
        tilde = 126,
        backspace = 8,
        formFeed = 12,
        byteOrderMark = 65279,
        tab = 9,
        verticalTab = 11,
    }
    function isIdentifierStart(ch: number, languageVersion: ts.pxtc.ScriptTarget): boolean;
    function isIdentifierPart(ch: number, languageVersion: ts.pxtc.ScriptTarget): boolean;
    function isUnicodeIdentifierStart(code: number, languageVersion: ts.pxtc.ScriptTarget): boolean;
    enum DiagnosticCategory {
        Warning = 0,
        Error = 1,
        Message = 2,
    }
}
declare namespace pxt.usb {
    class USBError extends Error {
        constructor(msg: string);
    }
    const enum VID {
        ATMEL = 1003,
        ARDUINO = 9025,
        ADAFRUIT = 9114,
        NXP = 3368,
    }
    type USBEndpointType = "bulk" | "interrupt" | "isochronous";
    type USBRequestType = "standard" | "class" | "vendor";
    type USBRecipient = "device" | "interface" | "endpoint" | "other";
    type USBTransferStatus = "ok" | "stall" | "babble";
    type USBDirection = "in" | "out";
    type BufferSource = Uint8Array;
    interface USBConfiguration {
        configurationValue: number;
        configurationName: string;
        interfaces: USBInterface[];
    }
    interface USBInterface {
        interfaceNumber: number;
        alternate: USBAlternateInterface;
        alternates: USBAlternateInterface[];
        claimed: boolean;
    }
    interface USBAlternateInterface {
        alternateSetting: number;
        interfaceClass: number;
        interfaceSubclass: number;
        interfaceProtocol: number;
        interfaceName: string;
        endpoints: USBEndpoint[];
    }
    interface USBEndpoint {
        endpointNumber: number;
        direction: USBDirection;
        type: USBEndpointType;
        packetSize: number;
    }
    interface USBDevice {
        vendorId: number;
        productId: number;
        manufacturerName: string;
        productName: string;
        serialNumber: string;
        deviceClass: number;
        deviceSubclass: number;
        deviceProtocol: number;
        deviceVersionMajor: number;
        deviceVersionMinor: number;
        deviceVersionSubminor: number;
        usbVersionMajor: number;
        usbVersionMinor: number;
        usbVersionSubminor: number;
        configurations: USBConfiguration[];
        opened: boolean;
        open(): Promise<void>;
        close(): Promise<void>;
        selectConfiguration(configurationValue: number): Promise<void>;
        claimInterface(interfaceNumber: number): Promise<void>;
        releaseInterface(interfaceNumber: number): Promise<void>;
        selectAlternateInterface(interfaceNumber: number, alternateSetting: number): Promise<void>;
        controlTransferIn(setup: USBControlTransferParameters, length: number): Promise<USBInTransferResult>;
        controlTransferOut(setup: USBControlTransferParameters, data?: BufferSource): Promise<USBOutTransferResult>;
        clearHalt(direction: USBDirection, endpointNumber: number): Promise<void>;
        transferIn(endpointNumber: number, length: number): Promise<USBInTransferResult>;
        transferOut(endpointNumber: number, data: BufferSource): Promise<USBOutTransferResult>;
        isochronousTransferIn(endpointNumber: number, packetLengths: number[]): Promise<USBIsochronousInTransferResult>;
        isochronousTransferOut(endpointNumber: number, data: BufferSource, packetLengths: number[]): Promise<USBIsochronousOutTransferResult>;
        reset(): Promise<void>;
    }
    interface USBControlTransferParameters {
        requestType: USBRequestType;
        recipient: USBRecipient;
        request: number;
        value: number;
        index: number;
    }
    interface USBInTransferResult {
        data: {
            buffer: ArrayBuffer;
        };
        status: USBTransferStatus;
    }
    interface USBOutTransferResult {
        bytesWritten: number;
        status: USBTransferStatus;
    }
    interface USBIsochronousInTransferPacket {
        data: DataView;
        status: USBTransferStatus;
    }
    interface USBIsochronousInTransferResult {
        data: DataView;
        packets: USBIsochronousInTransferPacket[];
    }
    interface USBIsochronousOutTransferPacket {
        bytesWritten: number;
        status: USBTransferStatus;
    }
    interface USBIsochronousOutTransferResult {
        packets: USBIsochronousOutTransferPacket[];
    }
    function initAsync(): Promise<HF2.Wrapper>;
}
declare namespace pxt.worker {
    interface Iface {
        opAsync: (op: string, arg: any) => Promise<any>;
        recvHandler: (v: any) => void;
    }
    function wrap(send: (v: any) => void): Iface;
    function makeWebWorker(workerFile: string): Iface;
    function makeWebSocket(url: string, onOOB?: (v: any) => void): Iface;
}
declare namespace ts.pxtc.assembler {
    interface InlineError {
        scope: string;
        message: string;
        line: string;
        lineNo: number;
        coremsg: string;
        hints: string;
    }
    interface EmitResult {
        stack: number;
        opcode: number;
        opcode2?: number;
        numArgs?: number[];
        error?: string;
        errorAt?: string;
        labelName?: string;
    }
    function lf(fmt: string, ...args: any[]): string;
    class Instruction {
        opcode: number;
        mask: number;
        jsFormat: string;
        name: string;
        args: string[];
        friendlyFmt: string;
        code: string;
        private ei;
        is32bit: boolean;
        constructor(ei: AbstractProcessor, format: string, opcode: number, mask: number, jsFormat: string);
        emit(ln: Line): EmitResult;
        toString(): string;
    }
    class Line {
        bin: File;
        text: string;
        type: string;
        lineNo: number;
        words: string[];
        scope: string;
        location: number;
        instruction: Instruction;
        numArgs: number[];
        constructor(bin: File, text: string);
        getOpExt(): string;
        getOp(): string;
        update(s: string): void;
    }
    class File {
        constructor(ei: AbstractProcessor);
        baseOffset: number;
        finalEmit: boolean;
        reallyFinalEmit: boolean;
        checkStack: boolean;
        inlineMode: boolean;
        lookupExternalLabel: (name: string) => number;
        normalizeExternalLabel: (n: string) => string;
        private ei;
        private lines;
        private currLineNo;
        private realCurrLineNo;
        private currLine;
        private scope;
        private scopeId;
        errors: InlineError[];
        buf: number[];
        private labels;
        private userLabelsCache;
        private stackpointers;
        private stack;
        peepOps: number;
        peepDel: number;
        private stats;
        throwOnError: boolean;
        disablePeepHole: boolean;
        stackAtLabel: pxt.Map<number>;
        private prevLabel;
        private emitShort(op);
        location(): number;
        pc(): number;
        parseOneInt(s: string): number;
        private looksLikeLabel(name);
        private scopedName(name);
        lookupLabel(name: string, direct?: boolean): number;
        private align(n);
        pushError(msg: string, hints?: string): void;
        private directiveError(msg);
        private emitString(l);
        private parseNumber(words);
        private parseNumbers(words);
        private emitSpace(words);
        private emitBytes(words);
        private emitHex(words);
        private handleDirective(l);
        private handleOneInstruction(ln, instr);
        private handleInstruction(ln);
        private mkLine(tx);
        private prepLines(text);
        private iterLines();
        getSource(clean: boolean): string;
        private peepHole();
        private peepPass(reallyFinal);
        getLabels(): pxt.Map<number>;
        emit(text: string): void;
    }
    interface Encoder {
        name: string;
        pretty: string;
        encode: (v: number) => number;
        isRegister: boolean;
        isImmediate: boolean;
        isRegList: boolean;
        isLabel: boolean;
        isWordAligned?: boolean;
    }
    abstract class AbstractProcessor {
        encoders: pxt.Map<Encoder>;
        instructions: pxt.Map<Instruction[]>;
        file: File;
        constructor();
        wordSize(): number;
        computeStackOffset(kind: string, offset: number): number;
        is32bit(i: Instruction): boolean;
        emit32(v1: number, v2: number, actual: string): EmitResult;
        postProcessRelAddress(f: File, v: number): number;
        postProcessAbsAddress(f: File, v: number): number;
        peephole(ln: Line, lnNext: Line, lnNext2: Line): void;
        registerNo(actual: string): number;
        getAddressFromLabel(f: File, i: Instruction, s: string, wordAligned?: boolean): number;
        isPop(opcode: number): boolean;
        isPush(opcode: number): boolean;
        isAddSP(opcode: number): boolean;
        isSubSP(opcode: number): boolean;
        testAssembler(): void;
        protected addEnc: (n: string, p: string, e: (v: number) => number) => Encoder;
        protected inrange: (max: number, v: number, e: number) => number;
        protected inminmax: (min: number, max: number, v: number, e: number) => number;
        protected inseq: (seq: number[], v: number) => number;
        protected inrangeSigned: (max: number, v: number, e: number) => number;
        protected addInst: (name: string, code: number, mask: number, jsFormat?: string) => void;
    }
    function emitErr(msg: string, tok: string): {
        stack: number;
        opcode: number;
        error: string;
        errorAt: string;
    };
    function expectError(ei: AbstractProcessor, asm: string): void;
    function tohex(n: number): string;
    function expect(ei: AbstractProcessor, disasm: string): void;
}
declare namespace pxt.Cloud {
    import Util = pxtc.Util;
    var apiRoot: string;
    var accessToken: string;
    var localToken: string;
    var onOffline: () => void;
    function hasAccessToken(): boolean;
    function isLocalHost(): boolean;
    function privateRequestAsync(options: Util.HttpRequestOptions): Promise<any>;
    function privateGetTextAsync(path: string): Promise<string>;
    function privateGetAsync(path: string): Promise<any>;
    function downloadScriptFilesAsync(id: string): Promise<any>;
    function downloadMarkdownAsync(docid: string, locale?: string, live?: boolean): Promise<string>;
    function privateDeleteAsync(path: string): Promise<any>;
    function privatePostAsync(path: string, data: any): Promise<any>;
    function isLoggedIn(): boolean;
    function isOnline(): boolean;
    function getServiceUrl(): string;
    function getUserId(): string;
    function parseScriptId(uri: string): string;
    interface JsonProgress {
        kind: string;
        userid: string;
        progressid: string;
        index: number;
        completed?: number;
    }
    interface JsonProgressStep {
        index: number;
        text: string;
        count: number;
        minDuration?: number;
        medDuration?: number;
        medModalDuration?: number;
        medPlayDuration?: number;
    }
    interface JsonProgressStats {
        kind: string;
        publicationId: string;
        count: number;
        steps: JsonProgressStep[];
    }
    interface JsonCapability {
        name: string;
        iconurl: string;
    }
    interface JsonIdObject {
        kind: string;
        id: string;
        url: string;
    }
    interface JsonPublication extends JsonIdObject {
        time: number;
        userid: string;
        userscore: number;
        username: string;
        userhaspicture: boolean;
    }
    interface JsonNotification extends JsonPubOnPub {
        notificationkind: string;
        supplementalid: string;
        supplementalkind: string;
        supplementalname: string;
    }
    interface JsonDocument {
        url: string;
        kind: string;
        name: string;
        abstract: string;
        mimetype: string;
        views: number;
        thumburl: string;
    }
    interface JsonArt extends JsonPublication {
        name: string;
        description: string;
        pictureurl: string;
        mediumthumburl: string;
        thumburl: string;
        flags: string[];
        wavurl: string;
        aacurl: string;
        bloburl?: string;
        arttype?: string;
    }
    interface JsonUser extends JsonIdObject {
        name: string;
        about: string;
        features: number;
        receivedpositivereviews: number;
        activedays: number;
        subscribers: number;
        score: number;
        haspicture: boolean;
        isadult?: boolean;
    }
    interface JsonScore {
        points: number;
    }
    interface JsonReceivedPositiveReviewsScore extends JsonScore {
        scripts: JsonScript[];
    }
    interface JsonFeature {
        name: string;
        title: string;
        text: string;
        count: number;
    }
    interface JsonLanguageFeaturesScore extends JsonScore {
        features: JsonFeature[];
    }
    interface JsonUserScore {
        receivedPositiveReviews: JsonReceivedPositiveReviewsScore;
        receivedSubscriptions: JsonScore;
        languageFeatures: JsonLanguageFeaturesScore;
        activeDays: JsonScore;
    }
    interface JsonGroup extends JsonPublication {
        name: string;
        description: string;
        isrestricted: boolean;
        isclass: boolean;
        pictureid: string;
        comments: number;
        positivereviews: number;
        subscribers: number;
    }
    interface JsonCode {
        kind: string;
        time: number;
        expiration: number;
        userid: string;
        username: string;
        userscore: number;
        userhaspicture: boolean;
        verb: string;
        data: string;
        credit?: number;
    }
    interface JsonScriptMeta {
        youtube?: string;
        instagram?: string;
        blocksWidth?: number;
        blocksHeight?: number;
    }
    interface JsonScript extends JsonPublication {
        shortid?: string;
        name: string;
        description: string;
        icon: string;
        iconbackground: string;
        iconurl: string;
        iconArtId?: string;
        splashArtId?: string;
        positivereviews: number;
        cumulativepositivereviews: number;
        comments: number;
        subscribers: number;
        capabilities: JsonCapability[];
        flows: any[];
        haserrors: boolean;
        rootid: string;
        baseid?: string;
        updateid: string;
        updatetime: number;
        ishidden: boolean;
        islibrary: boolean;
        useCppCompiler: boolean;
        installations: number;
        runs: number;
        platforms: string[];
        userplatform?: string[];
        screenshotthumburl: string;
        screenshoturl: string;
        mergeids: string[];
        editor?: string;
        target?: string;
        meta?: JsonScriptMeta;
        updateroot: string;
        unmoderated?: boolean;
        noexternallinks?: boolean;
        promo?: any;
        lastpointer?: string;
    }
    interface JsonHistoryItem {
        kind: string;
        time: number;
        historyid: string;
        scriptstatus: string;
        scriptname: string;
        scriptdescription: string;
        scriptid: string;
        scriptsize?: number;
        isactive: boolean;
        meta: any;
        entryNo?: number;
    }
    interface JsonPubOnPub extends JsonPublication {
        publicationid: string;
        publicationname: string;
        publicationkind: string;
    }
    interface JsonPointer extends JsonPublication {
        path: string;
        scriptid: string;
        artid: string;
        releaseid: string;
        redirect: string;
        description: string;
        htmlartid: string;
        scriptname: string;
        scriptdescription: string;
        breadcrumbtitle: string;
        parentpath: string;
        oldscriptid?: string;
    }
    interface JsonComment extends JsonPubOnPub {
        text: string;
        nestinglevel: number;
        positivereviews: number;
        comments: number;
        assignedtoid?: string;
        resolved?: string;
    }
    interface JsonAbuseReport extends JsonPubOnPub {
        text: string;
        resolution: string;
        publicationuserid: string;
        usernumreports?: number;
        publicationnumabuses?: number;
        publicationusernumabuses?: number;
    }
    interface JsonChannel extends JsonPublication {
        name: string;
        description: string;
        pictureid: string;
        comments: number;
        positivereviews: number;
    }
    interface JsonReview extends JsonPubOnPub {
        ispositive: boolean;
    }
    interface JsonRelease extends JsonPublication {
        name: string;
        releaseid: string;
        labels: JsonReleaseLabel[];
        buildnumber: number;
        version: string;
        commit: string;
        branch: string;
        cdnUrl: string;
    }
    interface JsonReleaseLabel {
        name: string;
        userid: string;
        time: number;
        releaseid: string;
    }
    interface JsonEtag {
        id: string;
        kind: string;
        ETag: string;
    }
    interface JsonList {
        items: JsonIdObject[];
        etags: JsonEtag[];
        continuation: string;
    }
    interface JsonTag extends JsonIdObject {
        time: number;
        name: string;
        category: string;
        description: string;
        instances: number;
        topscreenshotids: string[];
    }
    interface JsonScreenShot extends JsonPubOnPub {
        pictureurl: string;
        thumburl: string;
    }
    interface JsonVideoSource {
        poster?: string;
        srclang: string;
        src: string;
        type: string;
    }
    interface JsonVideoTrack {
        srclang: string;
        src: string;
        kind?: string;
        label?: string;
    }
    interface JsonVideo {
        poster: string;
        tracks?: JsonVideoTrack[];
        sources: JsonVideoSource[];
    }
    interface CanDeleteResponse {
        publicationkind: string;
        publicationname: string;
        publicationuserid: string;
        candelete: boolean;
        candeletekind: boolean;
        canmanage: boolean;
        hasabusereports: boolean;
    }
    interface UserSettings {
        nickname?: string;
        aboutme?: string;
        website?: string;
        notifications?: boolean;
        notifications2?: string;
        picturelinkedtofacebook?: boolean;
        realname?: string;
        gender?: string;
        howfound?: string;
        culture?: string;
        yearofbirth?: number;
        programmingknowledge?: string;
        occupation?: string;
        emailnewsletter2?: string;
        emailfrequency?: string;
        email?: string;
        emailverified?: boolean;
        previousemail?: string;
        location?: string;
        twitterhandle?: string;
        githubuser?: string;
        minecraftuser?: string;
        editorMode?: string;
        school?: string;
        wallpaper?: string;
        permissions?: string;
        credit?: number;
    }
}
