/// <reference path="../typings/globals/bluebird/index.d.ts" />
/// <reference path="../localtypings/monaco.d.ts" />
/// <reference path="pxtlib.d.ts" />
declare namespace pxt.editor {
    interface IEditor {
        undo(): void;
        redo(): void;
        hasUndo(): boolean;
        hasRedo(): boolean;
        zoomIn(): void;
        zoomOut(): void;
        resize(): void;
    }
    interface IFile {
        name: string;
    }
    interface FileHistoryEntry {
        id: string;
        name: string;
        pos: any;
    }
    interface EditorSettings {
        editorFontSize: number;
        fileHistory: FileHistoryEntry[];
    }
    interface IAppProps {
    }
    interface IAppState {
        active?: boolean;
        header?: pxt.workspace.Header;
        filters?: pxt.editor.ProjectFilters;
        currFile?: IFile;
        fileState?: string;
        showFiles?: boolean;
        sideDocsLoadUrl?: string;
        sideDocsCollapsed?: boolean;
        projectName?: string;
        tutorialOptions?: TutorialOptions;
        hintShown?: boolean;
        notification?: pxt.Notification;
        running?: boolean;
        compiling?: boolean;
        publishing?: boolean;
        hideEditorFloats?: boolean;
        collapseEditorTools?: boolean;
        showBlocks?: boolean;
        showParts?: boolean;
        fullscreen?: boolean;
        mute?: boolean;
        embedSimView?: boolean;
        tracing?: boolean;
        highContrast?: boolean;
    }
    interface ProjectCreationOptions {
        prj?: pxt.ProjectTemplate;
        name?: string;
        documentation?: string;
        filesOverride?: pxt.Map<string>;
        filters?: ProjectFilters;
        temporary?: boolean;
    }
    interface ProjectFilters {
        namespaces?: {
            [index: string]: FilterState;
        };
        blocks?: {
            [index: string]: FilterState;
        };
        fns?: {
            [index: string]: FilterState;
        };
        defaultState?: FilterState;
    }
    enum FilterState {
        Hidden = 0,
        Visible = 1,
        Disabled = 2,
    }
    interface TutorialStepInfo {
        fullscreen?: boolean;
        hasHint?: boolean;
        content?: string;
        headerContent?: string;
        ariaLabel?: string;
    }
    interface TutorialOptions {
        tutorial?: string;
        tutorialName?: string;
        tutorialStepInfo?: TutorialStepInfo[];
        tutorialStep?: number;
        tutorialReady?: boolean;
    }
    interface IProjectView {
        state: IAppState;
        setState(st: IAppState): void;
        forceUpdate(): void;
        openBlocks(): void;
        openJavaScript(): void;
        openPreviousEditor(): void;
        switchTypeScript(): void;
        openTypeScriptAsync(): Promise<void>;
        saveBlocksToTypeScriptAsync(): Promise<string>;
        saveFileAsync(): Promise<void>;
        loadHeaderAsync(h: pxt.workspace.Header): Promise<void>;
        reloadHeaderAsync(): Promise<void>;
        importProjectAsync(prj: pxt.workspace.Project, filters?: pxt.editor.ProjectFilters): Promise<void>;
        overrideTypescriptFile(text: string): void;
        exportAsync(): Promise<string>;
        newEmptyProject(name?: string, documentation?: string): void;
        newProject(options?: ProjectCreationOptions): void;
        createProjectAsync(options: ProjectCreationOptions): Promise<void>;
        importFileDialog(): void;
        importUrlDialog(): void;
        removeProject(): void;
        editText(): void;
        getPreferredEditor(): string;
        saveAndCompile(): void;
        updateHeaderName(name: string): void;
        compile(): void;
        setFile(fn: IFile): void;
        setSideFile(fn: IFile): void;
        setSideDoc(path: string, blocksEditor?: boolean): void;
        setSideMarkdown(md: string): void;
        removeFile(fn: IFile, skipConfirm?: boolean): void;
        openTutorials(): void;
        setTutorialStep(step: number): void;
        exitTutorial(keep?: boolean): void;
        completeTutorial(): void;
        showTutorialHint(): void;
        anonymousPublishAsync(): Promise<string>;
        startStopSimulator(): void;
        stopSimulator(unload?: boolean): void;
        restartSimulator(): void;
        startSimulator(): void;
        runSimulator(): void;
        expandSimulator(): void;
        collapseSimulator(): void;
        toggleSimulatorCollapse(): void;
        proxySimulatorMessage(content: string): void;
        toggleTrace(): void;
        startTutorial(tutorialId: string): void;
        addPackage(): void;
        typecheckNow(): void;
        fireResize(): void;
        isBlocksEditor(): boolean;
        isTextEditor(): boolean;
        renderBlocksAsync(req: EditorMessageRenderBlocksRequest): Promise<string>;
        convertTouchDevelopToTypeScriptAsync(td: string): Promise<string>;
        settings: EditorSettings;
        editor: IEditor;
    }
    interface IHexFileImporter {
        id: string;
        canImport(data: pxt.cpp.HexFile): boolean;
        importAsync(project: IProjectView, data: pxt.cpp.HexFile): Promise<void>;
    }
    interface ISettingsProps {
        parent: IProjectView;
        visible?: boolean;
    }
    interface IFieldCustomOptions {
        selector: string;
        editor: Blockly.FieldCustomConstructor;
        text?: string;
        validator?: any;
    }
    interface ExtensionOptions {
    }
    interface ExtensionResult {
        hexFileImporters?: IHexFileImporter[];
        fieldEditors?: IFieldCustomOptions[];
    }
    let initExtensionsAsync: (opts: ExtensionOptions) => Promise<ExtensionResult>;
}
declare namespace pxt.editor {
    interface EditorMessage {
        /**
         * Constant identifier
         */
        type: "pxteditor" | "pxthost";
        /**
         * Original request id
         */
        id?: string;
        /**
         * flag to request response
         */
        response?: boolean;
    }
    interface EditorMessageResponse extends EditorMessage {
        /**
         * Additional response payload provided by the command
         */
        resp?: any;
        /**
         * indicate if operation started or completed successfully
         */
        success: boolean;
        /**
         * Error object if any
         */
        error?: any;
    }
    interface EditorMessageRequest extends EditorMessage {
        /**
         * Request action
         */
        action: "switchblocks" | "switchjavascript" | "startsimulator" | "restartsimulator" | "stopsimulator" | "hidesimulator" | "showsimulator" | "newproject" | "importproject" | "proxytosim" | "undo" | "redo" | "renderblocks" | "workspacesync" | "workspacereset" | "workspacesave" | "event";
    }
    /**
     * Request sent by the editor when a tick/error/expection is registered
     */
    interface EditorMessageEventRequest extends EditorMessageRequest {
        action: "event";
        tick: string;
        category?: string;
        message?: string;
        data?: Map<string | number>;
    }
    interface EditorMessageStopRequest extends EditorMessageRequest {
        action: "stopsimulator";
        /**
         * Indicates if simulator iframes should be unloaded or kept hot.
         */
        unload?: boolean;
    }
    interface EditorMessageNewProjectRequest extends EditorMessageRequest {
        action: "newproject";
        /**
         * Additional optional to create new project
         */
        options?: ProjectCreationOptions;
    }
    interface EditorMessageSimulatorMessageProxyRequest extends EditorMessageRequest {
        action: "proxytosim";
        /**
         * Content to send to the simulator
         */
        content: any;
    }
    interface EditorWorkspaceSyncRequest extends EditorMessageRequest {
        /**
         * Synching projects from host into
         */
        action: "workspacesync" | "workspacereset";
    }
    interface EditorSyncState {
        filters?: pxt.editor.ProjectFilters;
    }
    interface EditorWorkspaceSyncResponse extends EditorMessageResponse {
        projects: pxt.workspace.Project[];
        editor?: EditorSyncState;
    }
    interface EditorWorkspaceSaveRequest extends EditorMessageRequest {
        action: "workspacesave";
        project: pxt.workspace.Project;
    }
    interface EditorMessageImportProjectRequest extends EditorMessageRequest {
        action: "importproject";
        project: pxt.workspace.Project;
        filters?: pxt.editor.ProjectFilters;
    }
    interface EditorMessageRenderBlocksRequest extends EditorMessageRequest {
        action: "renderblocks";
        ts: string;
    }
    interface EditorMessageRenderBlocksResponse {
        mime: "application/svg+xml";
        data: string;
    }
    /**
     * Binds incoming window messages to the project view.
     * Requires the "allowParentController" flag in the pxtarget.json/appTheme object.
     *
     * When the project view receives a request (EditorMessageRequest),
     * it starts the command and returns the result upon completion.
     * The response (EditorMessageResponse) contains the request id and result.
     * Some commands may be async, use the ``id`` field to correlate to the original request.
     */
    function bindEditorMessages(projectView: IProjectView): void;
    /**
     * Sends analytics messages upstream to container if any
     */
    function enableControllerAnalytics(): void;
    /**
     * Posts a message from the editor to the host
     */
    function postHostMessageAsync(msg: EditorMessageRequest): Promise<EditorMessageResponse>;
}
declare namespace pxt.storage {
    function storageId(): string;
    function setLocal(key: string, value: string): void;
    function getLocal(key: string): string;
    function removeLocal(key: string): void;
    function clearLocal(): void;
}
declare namespace pxt.vs {
    interface BlockDefiniton {
        commentAttr: pxtc.CommentAttrs;
        fns?: Map<string>;
    }
    interface MethodDef {
        sig: string;
        snippet: string;
        comment?: string;
        metaData?: pxtc.CommentAttrs;
        snippetOnly?: boolean;
    }
    interface NameDefiniton {
        fns: {
            [fn: string]: MethodDef;
        };
        vars?: {
            [index: string]: string;
        };
        metaData?: pxtc.CommentAttrs;
        builtin?: boolean;
    }
    type DefinitionMap = {
        [ns: string]: NameDefiniton;
    };
    function syncModels(mainPkg: MainPackage, libs: {
        [path: string]: monaco.IDisposable;
    }, currFile: string, readOnly: boolean): void;
    function initMonacoAsync(element: HTMLElement): Promise<monaco.editor.IStandaloneCodeEditor>;
    function createEditor(element: HTMLElement): monaco.editor.IStandaloneCodeEditor;
}
declare namespace pxt.shell {
    enum EditorLayoutType {
        IDE = 0,
        Sandbox = 1,
        Widget = 2,
    }
    function layoutTypeClass(): string;
    function isSandboxMode(): boolean;
    function isReadOnly(): boolean;
}
declare namespace pxt.workspace {
    interface InstallHeader {
        name: string;
        meta: pxt.Cloud.JsonScriptMeta;
        editor: string;
        temporary?: boolean;
        target: string;
        pubId: string;
        pubCurrent: boolean;
    }
    interface Header extends InstallHeader {
        _rev: string;
        id: string;
        recentUse: number;
        modificationTime: number;
        blobId: string;
        blobCurrent: boolean;
        isDeleted: boolean;
        saveId?: any;
        icon?: string;
    }
    type ScriptText = pxt.Map<string>;
    interface Project {
        header?: Header;
        text?: ScriptText;
    }
    interface WorkspaceProvider {
        getHeaders(): Header[];
        getHeader(id: string): Header;
        getTextAsync(id: string): Promise<ScriptText>;
        initAsync(target: string): Promise<void>;
        saveAsync(h: Header, text?: ScriptText): Promise<void>;
        installAsync(h0: InstallHeader, text: ScriptText): Promise<Header>;
        saveToCloudAsync(h: Header): Promise<void>;
        syncAsync(): Promise<pxt.editor.EditorSyncState>;
        resetAsync(): Promise<void>;
        saveScreenshotAsync?: (h: Header, screenshot: string, icon: string) => Promise<void>;
        legacyScriptsUrl?: () => string;
        importLegacyScriptsAsync?: () => Promise<void>;
    }
}
