/*
 * Decompiled with CFR 0.152.
 */
package processing.app.legacy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class PApplet {
    public String sketchPath;
    public static final String javaVersionName = System.getProperty("java.version");
    public static final float javaVersion = new Float(javaVersionName.substring(0, 3)).floatValue();
    public static int platform;
    static String openLauncher;
    private static NumberFormat int_nf;
    private static int int_nf_digits;
    private static boolean int_nf_commas;

    static {
        String osname = System.getProperty("os.name");
        platform = osname.indexOf("Mac") != -1 ? 2 : (osname.indexOf("Windows") != -1 ? 1 : (osname.equals("Linux") ? 3 : 0));
    }

    public static String[] splitTokens(String what) {
        return PApplet.splitTokens(what, " \t\n\r\f\u00a0");
    }

    public static String[] splitTokens(String what, String delim) {
        StringTokenizer toker = new StringTokenizer(what, delim);
        String[] pieces = new String[toker.countTokens()];
        int index = 0;
        while (toker.hasMoreTokens()) {
            pieces[index++] = toker.nextToken();
        }
        return pieces;
    }

    public static String[] split(String what, char delim) {
        if (what == null) {
            return null;
        }
        char[] chars = what.toCharArray();
        int splitCount = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == delim) {
                ++splitCount;
            }
            ++i;
        }
        if (splitCount == 0) {
            String[] splits = new String[]{new String(what)};
            return splits;
        }
        String[] splits = new String[splitCount + 1];
        int splitIndex = 0;
        int startIndex = 0;
        int i2 = 0;
        while (i2 < chars.length) {
            if (chars[i2] == delim) {
                splits[splitIndex++] = new String(chars, startIndex, i2 - startIndex);
                startIndex = i2 + 1;
            }
            ++i2;
        }
        splits[splitIndex] = new String(chars, startIndex, chars.length - startIndex);
        return splits;
    }

    public static String[] subset(String[] list, int start, int count) {
        String[] output = new String[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static String join(String[] str, char separator) {
        return PApplet.join(str, String.valueOf(separator));
    }

    public static String join(String[] str, String separator) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < str.length) {
            if (i != 0) {
                buffer.append(separator);
            }
            buffer.append(str[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static final int parseInt(String what) {
        return PApplet.parseInt(what, 0);
    }

    public static final int parseInt(String what, int otherwise) {
        try {
            int offset = what.indexOf(46);
            if (offset == -1) {
                return Integer.parseInt(what);
            }
            return Integer.parseInt(what.substring(0, offset));
        }
        catch (NumberFormatException numberFormatException) {
            return otherwise;
        }
    }

    public static int[] parseInt(String[] what) {
        return PApplet.parseInt(what, 0);
    }

    public static int[] parseInt(String[] what, int missing) {
        int[] output = new int[what.length];
        int i = 0;
        while (i < what.length) {
            try {
                output[i] = Integer.parseInt(what[i]);
            }
            catch (NumberFormatException e) {
                output[i] = missing;
            }
            ++i;
        }
        return output;
    }

    public static String[] loadStrings(File file) {
        InputStream is = null;
        try {
            is = PApplet.createInput(file);
            if (is != null) {
                String[] stringArray = PApplet.loadStrings(is);
                return stringArray;
            }
            return null;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public static String[] loadStrings(InputStream input) {
        block9: {
            String[] stringArray;
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
                String[] lines = new String[100];
                int lineCount = 0;
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (lineCount == lines.length) {
                        String[] temp = new String[lineCount << 1];
                        System.arraycopy(lines, 0, temp, 0, lineCount);
                        lines = temp;
                    }
                    lines[lineCount++] = line;
                }
                if (lineCount == lines.length) {
                    String[] stringArray2 = lines;
                    IOUtils.closeQuietly(reader);
                    return stringArray2;
                }
                String[] output = new String[lineCount];
                System.arraycopy(lines, 0, output, 0, lineCount);
                stringArray = output;
                IOUtils.closeQuietly(reader);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block9;
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
            return stringArray;
        }
        return null;
    }

    public void saveStrings(String filename, String[] strings) {
        PApplet.saveStrings(this.saveFile(filename), strings);
    }

    public static void saveStrings(File file, String[] strings) {
        OutputStream outputStream = null;
        try {
            outputStream = PApplet.createOutput(file);
            PApplet.saveStrings(outputStream, strings);
        }
        finally {
            IOUtils.closeQuietly(outputStream);
        }
    }

    public static void saveStrings(OutputStream output, String[] strings) {
        PrintWriter writer = null;
        try {
            writer = PApplet.createWriter(output);
            if (writer == null) {
                return;
            }
            String[] stringArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                writer.println(string);
                ++n2;
            }
            writer.flush();
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    public static int[] expand(int[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static int[] expand(int[] list, int newSize) {
        int[] temp = new int[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static final String hex(int what, int digits) {
        String stuff = Integer.toHexString(what).toUpperCase();
        int length = stuff.length();
        if (length > digits) {
            return stuff.substring(length - digits);
        }
        if (length < digits) {
            return String.valueOf("00000000".substring(8 - (digits - length))) + stuff;
        }
        return stuff;
    }

    public static final int constrain(int amt, int low, int high) {
        return amt < low ? low : (amt > high ? high : amt);
    }

    public static final float constrain(float amt, float low, float high) {
        return amt < low ? low : (amt > high ? high : amt);
    }

    public static void open(String filename) {
        PApplet.open(new String[]{filename});
    }

    public static Process open(String[] argv) {
        String[] params = null;
        if (platform == 1) {
            params = new String[]{"cmd", "/c"};
        } else if (platform == 2) {
            params = new String[]{"open"};
        } else if (platform == 3) {
            Process p2;
            if (openLauncher == null) {
                try {
                    p2 = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                    p2.waitFor();
                    openLauncher = "gnome-open";
                }
                catch (Exception p2) {
                    // empty catch block
                }
            }
            if (openLauncher == null) {
                try {
                    p2 = Runtime.getRuntime().exec(new String[]{"kde-open"});
                    p2.waitFor();
                    openLauncher = "kde-open";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (openLauncher == null) {
                System.err.println("Could not find gnome-open or kde-open, the open() command may not work.");
            }
            if (openLauncher != null) {
                params = new String[]{openLauncher};
            }
        }
        if (params != null) {
            if (params[0].equals(argv[0])) {
                return PApplet.exec(argv);
            }
            params = PApplet.concat(params, argv);
            return PApplet.exec(params);
        }
        return PApplet.exec(argv);
    }

    public static Process exec(String[] argv) {
        try {
            return Runtime.getRuntime().exec(argv);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not open " + PApplet.join(argv, ' '));
        }
    }

    public static String[] concat(String[] a, String[] b) {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static String[][] matchAll(String what, String regexp) {
        int i;
        Pattern p = Pattern.compile(regexp, 40);
        Matcher m = p.matcher(what);
        ArrayList<String[]> results = new ArrayList<String[]>();
        int count = m.groupCount() + 1;
        while (m.find()) {
            String[] groups = new String[count];
            i = 0;
            while (i < count) {
                groups[i] = m.group(i);
                ++i;
            }
            results.add(groups);
        }
        if (results.isEmpty()) {
            return null;
        }
        String[][] matches = new String[results.size()][count];
        i = 0;
        while (i < matches.length) {
            matches[i] = (String[])results.get(i);
            ++i;
        }
        return matches;
    }

    public static String[] match(String what, String regexp) {
        Pattern p = Pattern.compile(regexp, 40);
        return PApplet.match(what, p);
    }

    public static String[] match(String what, Pattern pattern) {
        Matcher m = pattern.matcher(what);
        if (m.find()) {
            int count = m.groupCount() + 1;
            String[] groups = new String[count];
            int i = 0;
            while (i < count) {
                groups[i] = m.group(i);
                ++i;
            }
            return groups;
        }
        return null;
    }

    public static String[] nf(int[] num, int digits) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nf(num[i], digits);
            ++i;
        }
        return formatted;
    }

    public static String nf(int num, int digits) {
        if (int_nf != null && int_nf_digits == digits && !int_nf_commas) {
            return int_nf.format(num);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(false);
        int_nf_commas = false;
        int_nf.setMinimumIntegerDigits(digits);
        int_nf_digits = digits;
        return int_nf.format(num);
    }

    public static final String[] str(int[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x[i]);
            ++i;
        }
        return s;
    }

    public static PrintWriter createWriter(File file) {
        try {
            PApplet.createPath(file);
            OutputStream output = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                output = new GZIPOutputStream(output);
            }
            return PApplet.createWriter(output);
        }
        catch (Exception e) {
            if (file == null) {
                throw new RuntimeException("File passed to createWriter() was null");
            }
            e.printStackTrace();
            throw new RuntimeException("Couldn't create a writer for " + file.getAbsolutePath());
        }
    }

    public static PrintWriter createWriter(OutputStream output) {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(output, "UTF-8");
            return new PrintWriter(osw);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static InputStream createInput(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File passed to createInput() was null");
        }
        try {
            FileInputStream input = new FileInputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return new GZIPInputStream(input);
            }
            return input;
        }
        catch (IOException e) {
            System.err.println("Could not createInput() for " + file);
            e.printStackTrace();
            return null;
        }
    }

    public String savePath(String where) {
        if (where == null) {
            return null;
        }
        String filename = this.sketchPath(where);
        PApplet.createPath(filename);
        return filename;
    }

    public File saveFile(String where) {
        return new File(this.savePath(where));
    }

    public OutputStream createOutput(String filename) {
        return PApplet.createOutput(this.saveFile(filename));
    }

    public static OutputStream createOutput(File file) {
        try {
            PApplet.createPath(file);
            FileOutputStream fos = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return new GZIPOutputStream(fos);
            }
            return fos;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String sketchPath(String where) {
        if (this.sketchPath == null) {
            return where;
        }
        try {
            if (new File(where).isAbsolute()) {
                return where;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(this.sketchPath) + File.separator + where;
    }

    public static void createPath(String path) {
        PApplet.createPath(new File(path));
    }

    public static void createPath(File file) {
        try {
            File unit;
            String parent = file.getParent();
            if (parent != null && !(unit = new File(parent)).exists()) {
                unit.mkdirs();
            }
        }
        catch (SecurityException se) {
            System.err.println("You don't have permissions to create " + file.getAbsolutePath());
        }
    }
}

