/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;

public abstract class NetUtils {
    private static boolean isReachableByEcho(InetAddress address) {
        try {
            return address.isReachable(300);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isReachable(InetAddress address, int port) {
        return NetUtils.isReachable(address, Arrays.asList(port));
    }

    public static boolean isReachable(InetAddress address, List<Integer> ports) {
        if (NetUtils.isReachableByEcho(address)) {
            return true;
        }
        boolean reachable = false;
        for (Integer port : ports) {
            boolean bl = reachable = reachable || NetUtils.isPortOpen(address, port);
        }
        return reachable;
    }

    /*
     * Loose catch block
     */
    private static boolean isPortOpen(InetAddress address, int port) {
        Socket socket;
        block12: {
            socket = null;
            socket = new Socket();
            socket.connect(new InetSocketAddress(address, port), 1000);
            if (socket == null) break block12;
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
        catch (IOException e) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
            catch (Throwable throwable) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

