/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.compress.utils.IOUtils;

public class FileUtils {
    private static final List<String> SOURCE_CONTROL_FOLDERS = Arrays.asList("CVS", "RCS", ".git", ".svn", ".hg", ".bzr");
    private static final Pattern BACKSLASH = Pattern.compile("\\\\");

    public static boolean isSubDirectory(File base, File child) {
        try {
            base = base.getCanonicalFile();
            child = child.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentFile = child;
        while (parentFile != null) {
            if (base.equals(parentFile)) {
                return true;
            }
            parentFile = parentFile.getParentFile();
        }
        return false;
    }

    public static void copyFile(File source, File dest) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(dest);
            byte[] buf = new byte[4096];
            int readBytes = -1;
            while ((readBytes = fis.read(buf, 0, buf.length)) != -1) {
                fos.write(buf, 0, readBytes);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(fis);
        IOUtils.closeQuietly(fos);
    }

    public static void copy(File sourceFolder, File destFolder) throws IOException {
        File[] fileArray = sourceFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            File destFile = new File(destFolder, file.getName());
            if (file.isDirectory() && !SOURCE_CONTROL_FOLDERS.contains(file.getName())) {
                if (!destFile.exists() && !destFile.mkdir()) {
                    throw new IOException("Unable to create folder: " + destFile);
                }
                FileUtils.copy(file, destFile);
            } else if (!file.isDirectory()) {
                FileUtils.copyFile(file, destFile);
            }
            ++n2;
        }
    }

    public static void recursiveDelete(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File current = fileArray[n2];
                FileUtils.recursiveDelete(current);
                ++n2;
            }
        }
        file.delete();
    }

    public static File createTempFolder() throws IOException {
        return FileUtils.createTempFolder(new File(System.getProperty("java.io.tmpdir")));
    }

    public static File createTempFolder(File parent) throws IOException {
        return FileUtils.createTempFolder(parent, "arduino_");
    }

    public static File createTempFolder(File parent, String prefix) throws IOException {
        return FileUtils.createTempFolder(parent, prefix, Integer.toString(new Random().nextInt(1000000)));
    }

    public static File createTempFolder(String prefix) throws IOException {
        return FileUtils.createTempFolder(new File(System.getProperty("java.io.tmpdir")), prefix);
    }

    public static File createTempFolder(String prefix, String suffix) throws IOException {
        return FileUtils.createTempFolder(new File(System.getProperty("java.io.tmpdir")), prefix, suffix);
    }

    public static File createTempFolder(File parent, String prefix, String suffix) throws IOException {
        return Files.createDirectories(Paths.get(parent.getAbsolutePath(), String.valueOf(prefix) + suffix), new FileAttribute[0]).toFile();
    }

    public static String relativePath(String origin, String target) {
        try {
            origin = new File(origin).getCanonicalPath();
            File targetFile = new File(target);
            target = targetFile.isAbsolute() ? targetFile.getCanonicalPath() : new File(origin, target).getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
        if (origin.equals(target)) {
            return ".";
        }
        if (origin.equals(File.separator)) {
            return "." + target;
        }
        String prefix = "";
        String root = File.separator;
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            if (origin.startsWith("\\\\") || target.startsWith("\\\\")) {
                return null;
            }
            char originLetter = origin.charAt(0);
            char targetLetter = target.charAt(0);
            if (Character.isLetter(originLetter) && Character.isLetter(targetLetter) && originLetter != targetLetter) {
                return null;
            }
            prefix = "" + originLetter + ':';
            root = String.valueOf(prefix) + File.separator;
        }
        String relative = "";
        while (!target.startsWith(String.valueOf(origin) + File.separator)) {
            if ((origin = new File(origin).getParent()).equals(root)) {
                origin = prefix;
            }
            relative = String.valueOf(relative) + "..";
            relative = String.valueOf(relative) + File.separator;
        }
        return String.valueOf(relative) + target.substring(origin.length() + 1);
    }

    public static String getLinuxPathFrom(File file) {
        return BACKSLASH.matcher(file.getAbsolutePath()).replaceAll("/");
    }

    public static boolean isSCCSOrHiddenFile(File file) {
        return FileUtils.isSCCSFolder(file) || FileUtils.isHiddenFile(file);
    }

    public static boolean isHiddenFile(File file) {
        return file.isHidden() || file.getName().charAt(0) == '.';
    }

    public static boolean isSCCSFolder(File file) {
        return file.isDirectory() && SOURCE_CONTROL_FOLDERS.contains(file.getName());
    }

    public static String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString(file, "UTF-8");
    }

    public static String readFileToString(File file, String encoding) throws IOException {
        String string;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        return string;
    }

    public static List<String> readFileToListOfStrings(File file) throws IOException {
        LinkedList<String> strings = new LinkedList<String>();
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                line = line.replaceAll("\r", "").replaceAll("\n", "").replaceAll(" ", "");
                strings.add(line);
            }
            LinkedList<String> linkedList = strings;
            return linkedList;
        }
    }

    public static boolean hasExtension(File file, String ... extensions) {
        return FileUtils.hasExtension(file, Arrays.asList(extensions));
    }

    public static boolean hasExtension(File file, List<String> extensions) {
        String extension = FileUtils.splitFilename((File)file).extension;
        return extensions.contains(extension.toLowerCase());
    }

    public static String replaceExtension(String filename, String extension) {
        SplitFile split = FileUtils.splitFilename(filename);
        split.extension = extension;
        return split.join();
    }

    public static File replaceExtension(File file, String extension) {
        return new File(file.getParentFile(), FileUtils.replaceExtension(file.getName(), extension));
    }

    public static String addExtension(String filename, String extension) {
        return extension.equals("") ? filename : String.valueOf(filename) + "." + extension;
    }

    public static File addExtension(File file, String extension) {
        return new File(file.getParentFile(), FileUtils.addExtension(file.getName(), extension));
    }

    public static SplitFile splitFilename(String filename) {
        int index = filename.lastIndexOf(".");
        if (index >= 0) {
            return new SplitFile(filename.substring(0, index), filename.substring(index + 1));
        }
        return new SplitFile(filename, "");
    }

    public static SplitFile splitFilename(File file) {
        return FileUtils.splitFilename(file.getName());
    }

    public static List<File> listFiles(File folder, boolean recursive, String ... extensions) {
        return FileUtils.listFiles(folder, recursive, Arrays.asList(extensions));
    }

    public static List<File> listFiles(File folder, boolean recursive, List<String> extensions) {
        ArrayList<File> result = new ArrayList<File>();
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!FileUtils.isSCCSOrHiddenFile(file)) {
                if (file.isDirectory()) {
                    if (recursive) {
                        result.addAll(FileUtils.listFiles(file, true, extensions));
                    }
                } else if (extensions.isEmpty() || FileUtils.hasExtension(file, extensions)) {
                    result.add(file);
                }
            }
            ++n2;
        }
        return result;
    }

    public static File newFile(File parent, String ... parts) {
        File result = parent;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            result = new File(result, part);
            ++n2;
        }
        return result;
    }

    public static boolean deleteIfExists(File file) {
        if (file == null) {
            return true;
        }
        return file.delete();
    }

    public static class SplitFile {
        public String basename;
        public String extension;

        public SplitFile(String basename, String extension) {
            this.basename = basename;
            this.extension = extension;
        }

        public String join() {
            return FileUtils.addExtension(this.basename, this.extension);
        }
    }
}

