/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.legacy.PConstants;

public class Platform {
    static {
        Platform.loadLib(new File(BaseNoGui.getContentFile("lib"), System.mapLibraryName("listSerialsj")));
    }

    public void setLookAndFeel() throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public void init() throws Exception {
    }

    public File getSettingsFolder() throws Exception {
        File home = new File(System.getProperty("user.home"));
        File dataFolder = new File(home, ".arduino15");
        return dataFolder;
    }

    public File getDefaultSketchbookFolder() throws Exception {
        return null;
    }

    public void openURL(File folder, String url) throws Exception {
        if (!url.startsWith("file://./")) {
            this.openURL(url);
            return;
        }
        url = url.replaceAll("file://./", folder.getCanonicalFile().toURI().toASCIIString());
        this.openURL(url);
    }

    public void openURL(String url) throws Exception {
        String launcher = PreferencesData.get("launcher");
        if (launcher != null) {
            Runtime.getRuntime().exec(new String[]{launcher, url});
        } else {
            this.showLauncherWarning();
        }
    }

    public boolean openFolderAvailable() {
        return PreferencesData.get("launcher") != null;
    }

    public void openFolder(File file) throws Exception {
        String launcher = PreferencesData.get("launcher");
        if (launcher != null) {
            String folder = file.getAbsolutePath();
            Runtime.getRuntime().exec(new String[]{launcher, folder});
        } else {
            this.showLauncherWarning();
        }
    }

    private static void loadLib(File lib) {
        try {
            System.load(lib.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            System.out.println("Cannot load native library " + lib.getAbsolutePath());
            System.out.println("The program has terminated!");
            System.exit(1);
        }
    }

    private native String resolveDeviceAttachedToNative(String var1);

    private native String[] listSerialsNative();

    public String preListAllCandidateDevices() {
        return null;
    }

    public List<String> listSerials() {
        return new ArrayList<String>(Arrays.asList(this.listSerialsNative()));
    }

    public List<String> listSerialsNames() {
        LinkedList<String> list = new LinkedList<String>();
        String[] stringArray = this.listSerialsNative();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String port = stringArray[n2];
            list.add(port.split("_")[0]);
            ++n2;
        }
        return list;
    }

    public synchronized void getBoardWithMatchingVidPidFromCloud(String vid, String pid) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            URL jsonUrl = new URL("http", "api-builder.arduino.cc", 80, "/builder/v1/boards/0x" + vid + "/0x" + pid);
            URLConnection connection = jsonUrl.openConnection();
            connection.connect();
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            int code = httpConnection.getResponseCode();
            if (code == 404) {
                return;
            }
            InputStream is = httpConnection.getInputStream();
            BoardCloudAPIid board = mapper.readValue(is, BoardCloudAPIid.class);
            String realBoardName = board.getName().replaceAll("\\(.*?\\)", "").trim();
            String boardNameReplaced = realBoardName.replaceAll(" ", "&");
            String message = I18n.format(I18n.tr("{0}Install this package{1} to use your {2} board"), "<a href=\"http://boardsmanager/all#" + boardNameReplaced + "\">", "</a>", realBoardName);
            BaseNoGui.setBoardManagerLink(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized Map<String, Object> resolveDeviceByVendorIdProductId(String serial, Map<String, TargetPackage> packages) {
        String vid_pid_iSerial = this.resolveDeviceAttachedToNative(serial);
        for (TargetPackage targetPackage : packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.getPlatforms().values()) {
                for (TargetBoard board : targetPlatform.getBoards().values()) {
                    LinkedList vids = new LinkedList(board.getPreferences().subTree("vid", 1).values());
                    if (vids.isEmpty()) continue;
                    LinkedList pids = new LinkedList(board.getPreferences().subTree("pid", 1).values());
                    LinkedList descriptors = new LinkedList(board.getPreferences().subTree("descriptor", 1).values());
                    int i = 0;
                    while (i < vids.size()) {
                        block9: {
                            String vidPid;
                            block10: {
                                vidPid = String.valueOf((String)vids.get(i)) + "_" + (String)pids.get(i);
                                if (!vid_pid_iSerial.toUpperCase().contains(vidPid.toUpperCase())) break block9;
                                if (descriptors.isEmpty()) break block10;
                                boolean matched = false;
                                int j = 0;
                                while (j < descriptors.size()) {
                                    if (vid_pid_iSerial.toUpperCase().contains(((String)descriptors.get(j)).toUpperCase())) {
                                        matched = true;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!matched) break block9;
                            }
                            HashMap<String, Object> boardData = new HashMap<String, Object>();
                            boardData.put("board", board);
                            boardData.put("vid", vids.get(i));
                            boardData.put("pid", pids.get(i));
                            String extrafields = vid_pid_iSerial.substring(vidPid.length() + 1);
                            String[] parts = extrafields.split("_");
                            boardData.put("iserial", parts[0]);
                            return boardData;
                        }
                        ++i;
                    }
                }
            }
        }
        return null;
    }

    public String resolveDeviceByBoardID(Map<String, TargetPackage> packages, String boardId) {
        assert (packages != null);
        assert (boardId != null);
        for (TargetPackage targetPackage : packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.getPlatforms().values()) {
                for (TargetBoard board : targetPlatform.getBoards().values()) {
                    if (!boardId.equals(board.getId())) continue;
                    return board.getName();
                }
            }
        }
        return null;
    }

    public String getName() {
        return PConstants.platformNames[0];
    }

    protected void showLauncherWarning() {
        BaseNoGui.showWarning(I18n.tr("No launcher available"), I18n.tr("Unspecified platform, no launcher available.\nTo enable opening URLs or folders, add a \n\"launcher=/path/to/app\" line to preferences.txt"), null);
    }

    public List<BoardPort> filterPorts(List<BoardPort> ports, boolean aBoolean) {
        return new LinkedList<BoardPort>(ports);
    }

    public void fixPrefsFilePermissions(File prefsFile) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(new String[]{"chmod", "600", prefsFile.getAbsolutePath()}, null, null);
        process.waitFor();
    }

    public List<File> postInstallScripts(File folder) {
        LinkedList<File> scripts = new LinkedList<File>();
        scripts.add(new File(folder, "install_script.sh"));
        scripts.add(new File(folder, "post_install.sh"));
        return scripts;
    }

    public List<File> preUninstallScripts(File folder) {
        LinkedList<File> scripts = new LinkedList<File>();
        scripts.add(new File(folder, "pre_uninstall.sh"));
        return scripts;
    }

    public String getOsName() {
        return System.getProperty("os.name");
    }

    public String getOsArch() {
        return System.getProperty("os.arch");
    }

    public void symlink(String something, File somewhere) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(new String[]{"ln", "-s", something, somewhere.getAbsolutePath()}, null, somewhere.getParentFile());
        process.waitFor();
    }

    public void link(File something, File somewhere) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(new String[]{"ln", something.getAbsolutePath(), somewhere.getAbsolutePath()}, null, null);
        process.waitFor();
    }

    public void chmod(File file, int mode) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(new String[]{"chmod", Integer.toOctalString(mode), file.getAbsolutePath()}, null, null);
        process.waitFor();
    }

    public void fixSettingsLocation() throws Exception {
    }

    public int getSystemDPI() {
        return 96;
    }

    public static class BoardCloudAPIid {
        private String name;
        private String architecture;
        private String id;

        public String getName() {
            return this.name;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public String getId() {
            return this.id;
        }

        public void setName(String tmp) {
            this.name = tmp;
        }

        public void setArchitecture(String tmp) {
            this.architecture = tmp;
        }

        public void setId(String tmp) {
            this.id = tmp;
        }
    }
}

