/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.Compiler;
import cc.arduino.UploaderUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Sketch;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.CommandlineParser;
import processing.app.helpers.UserNotifier;

public class ArduinoHelper {
    private static boolean initialized = false;
    private static UploaderUtils uploader = null;
    private static Compiler compiler = null;
    private static Hashtable<String, String> board2id = new Hashtable();
    private static Hashtable<String, String> board2cpu = new Hashtable();

    public static boolean isInitialized() {
        return initialized;
    }

    public static String[] parseCmd(String cmd) {
        int index = cmd.indexOf("arduino_debug ");
        if (index >= 0) {
            cmd = cmd.substring(index + 14);
        } else {
            index = cmd.indexOf("arduino ");
            cmd = cmd.substring(index + 8);
        }
        return ArduinoHelper.translateCommandline(cmd);
    }

    public static void init(String arduinoDir) {
        if (initialized) {
            return;
        }
        initialized = true;
        System.setProperty("APP_DIR", arduinoDir);
        BaseNoGui.notifier = new CustomUserNotifier();
        BaseNoGui.initLogger();
        BaseNoGui.initPlatform();
        try {
            BaseNoGui.getPlatform().init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseNoGui.initPortableFolder();
        BaseNoGui.initVersion();
        BaseNoGui.checkInstallationFolder();
        if (BaseNoGui.getSketchbookPath() == null) {
            File defaultFolder = ArduinoHelper.getDefaultSketchbookFolderOrPromptForIt();
            if (BaseNoGui.getPortableFolder() != null) {
                PreferencesData.set("sketchbook.path", BaseNoGui.getPortableSketchbookFolder());
            } else {
                PreferencesData.set("sketchbook.path", defaultFolder.getAbsolutePath());
            }
            if (!defaultFolder.exists()) {
                defaultFolder.mkdirs();
            }
        }
        try {
            BaseNoGui.initPackages();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PreferencesData.save();
    }

    public static boolean run(String cmd) {
        System.out.println(cmd);
        return ArduinoHelper.run(ArduinoHelper.parseCmd(cmd));
    }

    public static boolean run(String[] args) {
        try {
            BaseNoGui.initParameters(args);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        CommandlineParser parser = new CommandlineParser(args);
        parser.parseArgumentsPhase1();
        parser.parseArgumentsPhase2();
        if (parser.isVerifyOrUploadMode()) {
            PreferencesData.setBoolean("build.verbose", parser.isDoVerboseBuild());
            PreferencesData.setBoolean("upload.verbose", parser.isDoVerboseUpload());
            PreferencesData.setBoolean("runtime.preserve.temp.files", parser.isPreserveTempFiles());
            PreferencesData.setDoSave(false);
            Sketch sketch = null;
            String outputFile = null;
            try {
                File sketchFile = new File(parser.getFilenames().get(0));
                sketch = new Sketch(sketchFile);
                compiler = new Compiler(sketch);
                outputFile = compiler.build(progress -> {}, false);
            }
            catch (Exception e) {
                return false;
            }
            if (parser.isUploadMode()) {
                try {
                    ArrayList<String> warnings = new ArrayList<String>();
                    uploader = new UploaderUtils();
                    boolean res = uploader.upload(sketch, null, outputFile, parser.isDoUseProgrammer(), parser.isNoUploadPort(), warnings);
                    for (String warning : warnings) {
                        System.out.println(String.valueOf(I18n.tr("Warning")) + ": " + warning);
                    }
                    System.out.flush();
                    Thread.sleep(300L);
                    if (!res) {
                        return false;
                    }
                }
                catch (Exception e) {
                    System.out.flush();
                    System.err.flush();
                    System.err.println(I18n.tr("An error occurred while uploading the sketch"));
                    return false;
                }
            }
            compiler = null;
            uploader = null;
        }
        return true;
    }

    public static File getDefaultSketchbookFolderOrPromptForIt() {
        return BaseNoGui.getDefaultSketchbookFolder();
    }

    public static void cancelRun() {
        try {
            if (compiler != null) {
                compiler.cancelCompile();
            }
            if (uploader != null) {
                uploader.cancelUpload();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        break;
                    }
                    current.append(nextTok);
                    break;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        break;
                    }
                    current.append(nextTok);
                    break;
                }
                default: {
                    if ("'".equals(nextTok)) {
                        state = 1;
                    } else if ("\"".equals(nextTok)) {
                        state = 2;
                    } else if (" ".equals(nextTok)) {
                        if (lastTokenHasBeenQuoted || current.length() != 0) {
                            list.add(current.toString());
                            current = new StringBuilder();
                        }
                    } else {
                        current.append(nextTok);
                    }
                    lastTokenHasBeenQuoted = false;
                }
            }
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            list.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in " + toProcess);
        }
        String[] args = new String[list.size()];
        return list.toArray(args);
    }

    public static ArrayList<String> rebuildBoardList() {
        ArrayList<String> boards = new ArrayList<String>();
        String regex = "menu.(\\w+).(\\w)+";
        if (BaseNoGui.packages.size() == 0) {
            return boards;
        }
        for (TargetPackage targetPackage : BaseNoGui.packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.platforms()) {
                String platformLabel = (String)targetPlatform.getPreferences().get("name");
                for (TargetBoard board : targetPlatform.getBoards().values()) {
                    if (board.getPreferences().get("hide") != null) continue;
                    String id = String.valueOf(targetPackage.getId()) + ":" + targetPlatform.getId() + ":" + board.getId();
                    boolean hasCpu = false;
                    Iterator it = board.getPreferences().keySet().iterator();
                    ArrayList<String> menuList = new ArrayList<String>();
                    HashSet<String> menukeySet = new HashSet<String>();
                    String cpu = "";
                    while (it.hasNext()) {
                        String[] keyParts;
                        String key = (String)it.next();
                        if (!key.matches(regex) || (keyParts = key.split("\\.")).length != 3) continue;
                        String menukey = keyParts[1];
                        String menuval = keyParts[2];
                        if (menukeySet.contains(menukey)) continue;
                        if (!menukey.equals("cpu")) {
                            menukeySet.add(menukey);
                        }
                        if (menukey.equals("cpu")) {
                            hasCpu = true;
                            cpu = menuval;
                            String boardName = String.valueOf(board.getName()) + "[" + cpu + "]";
                            boards.add(boardName);
                            board2id.put(boardName, id);
                            board2cpu.put(boardName, ":cpu=" + cpu);
                            continue;
                        }
                        menuList.add(String.valueOf(menukey) + "=" + menuval);
                    }
                    String menustr = String.join((CharSequence)",", menuList);
                    String boardName = board.getName();
                    if (hasCpu) {
                        boardName = String.valueOf(board.getName()) + "[" + cpu + "]";
                        if (menustr.equals("")) continue;
                        board2cpu.put(boardName, String.valueOf(board2cpu.get(boardName)) + "," + menustr);
                        continue;
                    }
                    boards.add(boardName);
                    board2id.put(boardName, id);
                    if (menustr.equals("")) {
                        board2cpu.put(boardName, "");
                        continue;
                    }
                    board2cpu.put(boardName, ":" + menustr);
                }
            }
        }
        return boards;
    }

    public static String getBoardId(String boardName) {
        return board2id.get(boardName);
    }

    public static String getBoardCpu(String boardName) {
        return board2cpu.get(boardName);
    }

    static class CustomUserNotifier
    extends UserNotifier {
        CustomUserNotifier() {
        }

        @Override
        public void showError(String title, String message, Throwable e, int exit_code) {
            if (title == null) {
                title = I18n.tr("Error");
            }
            System.err.println(String.valueOf(title) + ": " + message);
            if (e != null) {
                e.printStackTrace();
            }
        }

        @Override
        public void showMessage(String title, String message) {
            if (title == null) {
                title = I18n.tr("Message");
            }
            System.out.println(String.valueOf(title) + ": " + message);
        }

        @Override
        public void showWarning(String title, String message, Exception e) {
            if (title == null) {
                title = I18n.tr("Warning");
            }
            System.out.println(String.valueOf(title) + ": " + message);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }
}

