/*
 * Decompiled with CFR 0.152.
 */
package org.test;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.stage.Stage;
import javafx.util.Duration;

public class AdvancedStockLineChartSample
extends Application {
    private XYChart.Series<Number, Number> hourDataSeries;
    private XYChart.Series<Number, Number> minuteDataSeries;
    private NumberAxis xAxis;
    private Timeline animation;
    private double hours = 0.0;
    private double minutes = 0.0;
    private double timeInHours = 0.0;
    private double prevY = 10.0;
    private double y = 10.0;

    private void init(Stage primaryStage) {
        Group root = new Group();
        primaryStage.setScene(new Scene(root));
        root.getChildren().add(this.createChart());
        this.animation = new Timeline();
        this.animation.getKeyFrames().add(new KeyFrame(Duration.millis(16.0), new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                int count = 0;
                while (count < 6) {
                    AdvancedStockLineChartSample.this.nextTime();
                    AdvancedStockLineChartSample.this.plotTime();
                    ++count;
                }
            }
        }, new KeyValue[0]));
        this.animation.setCycleCount(-1);
    }

    protected LineChart<Number, Number> createChart() {
        this.xAxis = new NumberAxis(0.0, 24.0, 3.0);
        NumberAxis yAxis = new NumberAxis(0.0, 100.0, 10.0);
        LineChart<Number, Number> lc = new LineChart<Number, Number>(this.xAxis, yAxis);
        lc.setId("lineStockDemo");
        lc.setCreateSymbols(false);
        lc.setAnimated(false);
        lc.setLegendVisible(false);
        lc.setTitle("ACME Company Stock");
        this.xAxis.setLabel("Time");
        this.xAxis.setForceZeroInRange(false);
        yAxis.setLabel("Share Price");
        yAxis.setTickLabelFormatter(new NumberAxis.DefaultFormatter(yAxis, "$", null));
        this.hourDataSeries = new XYChart.Series();
        this.hourDataSeries.setName("Hourly Data");
        this.minuteDataSeries = new XYChart.Series();
        this.minuteDataSeries.setName("Minute Data");
        this.hourDataSeries.getData().add(new XYChart.Data<Double, Double>(this.timeInHours, this.prevY));
        this.minuteDataSeries.getData().add(new XYChart.Data<Double, Double>(this.timeInHours, this.prevY));
        double m = 0.0;
        while (m < 60.0) {
            this.nextTime();
            this.plotTime();
            m += 1.0;
        }
        lc.getData().add(this.minuteDataSeries);
        lc.getData().add(this.hourDataSeries);
        return lc;
    }

    private void nextTime() {
        if (this.minutes == 59.0) {
            this.hours += 1.0;
            this.minutes = 0.0;
        } else {
            this.minutes += 1.0;
        }
        this.timeInHours = this.hours + 0.016666666666666666 * this.minutes;
    }

    private void plotTime() {
        if (this.timeInHours % 1.0 == 0.0) {
            double oldY = this.y;
            this.y = this.prevY - 10.0 + Math.random() * 20.0;
            this.prevY = oldY;
            while (this.y < 10.0 || this.y > 90.0) {
                this.y = this.y - 10.0 + Math.random() * 20.0;
            }
            this.hourDataSeries.getData().add(new XYChart.Data<Double, Double>(this.timeInHours, this.prevY));
            if (this.timeInHours > 25.0) {
                this.hourDataSeries.getData().remove(0);
            }
            if (this.timeInHours > 24.0) {
                this.xAxis.setLowerBound(this.xAxis.getLowerBound() + 1.0);
                this.xAxis.setUpperBound(this.xAxis.getUpperBound() + 1.0);
            }
        }
        double min = this.timeInHours % 1.0;
        double randomPickVariance = Math.random();
        if (randomPickVariance < 0.3) {
            double minY = this.prevY + (this.y - this.prevY) * min - 4.0 + Math.random() * 8.0;
            this.minuteDataSeries.getData().add(new XYChart.Data<Double, Double>(this.timeInHours, minY));
        } else if (randomPickVariance < 0.7) {
            double minY = this.prevY + (this.y - this.prevY) * min - 6.0 + Math.random() * 12.0;
            this.minuteDataSeries.getData().add(new XYChart.Data<Double, Double>(this.timeInHours, minY));
        } else if (randomPickVariance < 0.95) {
            double minY = this.prevY + (this.y - this.prevY) * min - 10.0 + Math.random() * 20.0;
            this.minuteDataSeries.getData().add(new XYChart.Data<Double, Double>(this.timeInHours, minY));
        } else {
            double minY = this.prevY + (this.y - this.prevY) * min - 15.0 + Math.random() * 30.0;
            this.minuteDataSeries.getData().add(new XYChart.Data<Double, Double>(this.timeInHours, minY));
        }
        if (this.timeInHours > 25.0) {
            this.minuteDataSeries.getData().remove(0);
        }
    }

    public void play() {
        this.animation.play();
    }

    @Override
    public void stop() {
        this.animation.pause();
    }

    @Override
    public void start(Stage primaryStage) throws Exception {
        this.init(primaryStage);
        primaryStage.show();
        this.play();
    }

    public static void main(String[] args) {
        AdvancedStockLineChartSample.launch(args);
    }
}

