/*
 * Decompiled with CFR 0.152.
 */
package org.mixly.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.mixly.util.LanguageProvider;

public class DataReceiverPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private List<List> values = Collections.synchronizedList(new ArrayList());
    private List timestamps = new ArrayList();
    private int MAX_VALUE = 1024;
    private int MIN_VALUE = 0;
    private static final int MAX_COUNT_OF_VALUES = 50;
    private static final Color[] COLOR = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.ORANGE, Color.MAGENTA, Color.CYAN, Color.PINK, Color.YELLOW};
    private int num = 0;
    private int left = 30;
    private int right = 30;
    private int top = 10;
    private int bottom = 50;
    private boolean isAlive = true;

    public void setAlive(boolean isAlive) {
        this.isAlive = isAlive;
    }

    public DataReceiverPanel(int n) {
        this.setNum(n);
    }

    public void begin() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (DataReceiverPanel.this.isAlive) {
                    DataReceiverPanel.this.repaint();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    public void setNum(int num) {
        this.num = num;
        this.values.clear();
        int i = 0;
        while (i < this.num) {
            this.values.add(new ArrayList());
            ++i;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String[] txt = new String[]{"" + (double)this.MAX_VALUE * 1.0, "" + ((double)this.MIN_VALUE + 3.0 * (double)(this.MAX_VALUE - this.MIN_VALUE) / 4.0), "" + ((double)this.MIN_VALUE + 2.0 * (double)(this.MAX_VALUE - this.MIN_VALUE) / 4.0), "" + ((double)this.MIN_VALUE + 1.0 * (double)(this.MAX_VALUE - this.MIN_VALUE) / 4.0), "" + (double)this.MIN_VALUE * 1.0};
        int strMaxWidth = 0;
        int i = 0;
        while (i < 5) {
            if (g.getFontMetrics().stringWidth(txt[i]) > strMaxWidth) {
                strMaxWidth = g.getFontMetrics().stringWidth(txt[i]);
            }
            ++i;
        }
        this.left = strMaxWidth + 5;
        int w = this.getWidth() - this.left - this.right;
        int h = this.getHeight() - this.top - this.bottom;
        float xDelta = (float)w * 1.0f / 50.0f;
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setPaint(Color.LIGHT_GRAY);
        g2d.fillRect(this.left, this.top, w, h);
        g2d.setColor(Color.BLACK);
        int i2 = 0;
        while (i2 < 5) {
            int x = strMaxWidth - g.getFontMetrics().stringWidth(txt[i2]);
            g2d.drawString(txt[i2], x + 2, this.top + i2 * h / 4 + 3);
            ++i2;
        }
        g2d.setStroke(new BasicStroke(0.5f));
        g2d.setColor(Color.WHITE);
        i2 = 1;
        while (i2 < 4) {
            g2d.drawLine(this.left, this.top + i2 * h / 4, this.left + w, this.top + i2 * h / 4);
            ++i2;
        }
        g2d.setStroke(new BasicStroke(3.0f));
        int tmp = this.num > 5 ? 7 : this.num + 1;
        int i3 = 0;
        while (i3 < (this.num < 5 ? this.num : 5)) {
            g2d.setColor(Color.BLACK);
            g2d.drawString(String.valueOf(LanguageProvider.getLocalString("value")) + (i3 + 1), w / tmp * (i3 + 1), this.top + h + 35);
            g2d.setColor(COLOR[i3 % COLOR.length]);
            g2d.drawLine(w / tmp * (i3 + 1) + 45, this.top + h + 30, w / tmp * (i3 + 1) + 55, this.top + h + 30);
            ++i3;
        }
        if (this.num > 5) {
            g2d.setColor(Color.BLACK);
            g2d.drawString("\u9225\ufffd", w / tmp * 6, this.top + h + 35);
        }
        g2d.setStroke(new BasicStroke(1.0f));
        i3 = 0;
        while (i3 < this.num) {
            if (this.values != null && this.values.size() > 0 && this.values.get(i3) != null) {
                int length = this.values.get(i3).size();
                int j = 0;
                while (j < length - 1) {
                    int x1 = (int)(xDelta * (float)(50 - length + j)) + this.left;
                    int x2 = (int)(xDelta * (float)(50 - length + j + 1)) + this.left;
                    int y1 = this.normalizeValueForYAxis(((Float)this.values.get(i3).get(j)).floatValue(), h) + this.top;
                    int y2 = this.normalizeValueForYAxis(((Float)this.values.get(i3).get(j + 1)).floatValue(), h) + this.top;
                    g2d.setColor(COLOR[i3 % COLOR.length]);
                    g2d.drawLine(x1, y1, x2, y2);
                    g2d.fillOval(x1 - 3, y1 - 3, 6, 6);
                    if (j % 4 == 0) {
                        g2d.setColor(Color.BLACK);
                        try {
                            g2d.drawString(String.valueOf((Long)this.timestamps.get(j) - (Long)this.timestamps.get(0)), x1, this.top + h + 12);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++j;
                }
            }
            ++i3;
        }
        g2d.setColor(Color.BLACK);
        g2d.drawString("ms", this.left + w + 5, this.top + h + 12);
    }

    /*
     * Unable to fully structure code
     */
    public void addValue(ArrayList<Float> value) {
        if (value == null || value.size() != this.num) {
            return;
        }
        i = 0;
        ** GOTO lbl18
        {
            this.values.get(i).remove(0);
            do {
                if (this.values.get(i).size() >= 50) continue block0;
                this.values.get(i).add(value.get(i));
                while (this.timestamps.size() >= 50) {
                    this.timestamps.remove(0);
                }
                this.timestamps.add(System.currentTimeMillis());
                ++i;
lbl18:
                // 2 sources

            } while (i < this.num);
        }
    }

    public void setMaxAndMin(int max, int min) {
        if (max > min) {
            this.MAX_VALUE = max;
            this.MIN_VALUE = min;
        }
    }

    private int normalizeValueForYAxis(float value, int height) {
        int re = (int)((float)height * (value - (float)this.MIN_VALUE) / (float)(this.MAX_VALUE - this.MIN_VALUE));
        return height - re;
    }

    private static void createGuiAndShow() {
        JFrame frame = new JFrame("\u6d93\u63d2\u5f5b\u93c1\u7248\u5d41\u93c7\u832c\u568e");
        DataReceiverPanel dataPanel = new DataReceiverPanel(3);
        frame.getContentPane().add(dataPanel);
        dataPanel.begin();
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 400);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        DataReceiverPanel.createGuiAndShow();
    }

    public void clear() {
        this.values.clear();
        int i = 0;
        while (i < this.num) {
            this.values.add(new ArrayList());
            ++i;
        }
    }
}

