/*
 * Decompiled with CFR 0.152.
 */
package org.mixly.util;

public class SystemUtils {
    public static final String OS_NAME = SystemUtils.getSystemProperty("os.name");
    public static final boolean IS_OS_WINDOWS = SystemUtils.isOSNameMatch("Windows");
    public static final boolean IS_OS_MAC = SystemUtils.isOSNameMatch("Mac");
    public static final boolean IS_OS_LINUX = SystemUtils.isOSNameMatch("Linux");
    public static final String CWD = SystemUtils.getSystemProperty("user.dir");

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            System.err.println("Caught a SecurityException reading the system property '" + property + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    static boolean isOSNameMatch(String osNamePrefix) {
        return SystemUtils.isOSNameMatch(OS_NAME, osNamePrefix);
    }

    static boolean isOSNameMatch(String osName, String osNamePrefix) {
        return osName != null && osName.toLowerCase().startsWith(osNamePrefix.toLowerCase());
    }
}

