/*
 * Decompiled with CFR 0.152.
 */
package org.mixly.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mixly.Browser_new;
import org.mixly.util.FileUtil;
import org.mixly.util.OrderedProperties;
import org.mixly.util.SystemUtils;

public class MyMethod {
    public static String config = "setting/config.properties";
    public static Hashtable<String, String> boardName_Path = new Hashtable();

    public static String getProp(String filePath, String key) {
        Properties props = new Properties();
        try {
            String configBak;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
            props.load(in);
            ((InputStream)in).close();
            String value = props.getProperty(key);
            if (value == null && !key.equals("arduino_builder") && MyMethod.writeFile(configBak = MyMethod.readFile(new File("setting/config_bak.properties")), config)) {
                in = new BufferedInputStream(new FileInputStream(filePath));
                props.load(in);
                ((InputStream)in).close();
                value = props.getProperty(key);
            }
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized void changeSettingProperties(String filePath, String key, String value) {
        Properties prop = new Properties();
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileInputStream fis = new FileInputStream(file);
            prop.load(fis);
            ((InputStream)fis).close();
            prop.setProperty(key, value);
            FileOutputStream fos = new FileOutputStream(filePath);
            prop.store(fos, "Update '" + key + "' value");
            ((OutputStream)fos).close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static synchronized void changeCurrentBoard(String filePath, String key, String value) {
        try {
            MyMethod.changeSettingProperties(filePath, key, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void getKeysAndValues(String filePath) {
        OrderedProperties properties = new OrderedProperties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
            properties.load(in);
            for (Object entry : properties.keySet()) {
                String key = (String)entry;
                key.endsWith(".name");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<String> getBoards(String filePath) {
        ArrayList<String> list = new ArrayList<String>();
        OrderedProperties properties = new OrderedProperties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
            properties.load(in);
            for (Object entry : properties.keySet()) {
                String key = (String)entry;
                if (!key.endsWith(".name")) continue;
                String value = properties.getProperty(key);
                ArrayList<String> cpu = MyMethod.getCpuByBoard(filePath, value);
                if (cpu != null && cpu.size() > 0) {
                    int i = 0;
                    while (i < cpu.size()) {
                        list.add(String.valueOf(value) + "[" + cpu.get(i) + "]");
                        boardName_Path.put(String.valueOf(value) + "[" + cpu.get(i) + "]", filePath);
                        ++i;
                    }
                    continue;
                }
                list.add(value);
                boardName_Path.put(value, filePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String getCompileKeyByBoards(String filePath, String board) {
        String re = "";
        OrderedProperties properties = new OrderedProperties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
            properties.load(in);
            for (Object entry : properties.keySet()) {
                String value;
                String key = (String)entry;
                if (!key.endsWith(".name") || !(value = properties.getProperty(key)).equals(board)) continue;
                re = key.substring(0, key.indexOf(".name"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return re;
    }

    public static ArrayList<String> getCpuByBoard(String filePath, String board) {
        ArrayList<String> re = new ArrayList<String>();
        String regex = String.valueOf(MyMethod.getCompileKeyByBoards(filePath, board)) + ".menu.cpu.(\\w)+";
        OrderedProperties properties = new OrderedProperties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
            properties.load(in);
            for (Object entry : properties.keySet()) {
                String key = (String)entry;
                if (!key.matches(regex)) continue;
                re.add(key.substring(key.lastIndexOf(".") + 1, key.length()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return re;
    }

    public static void saveYuanma(String yuanma) {
        String filepath = "testArduino/testArduino.ino";
        String currBoard = Browser_new.getCurrentBoard();
        if (currBoard.equals(Browser_new.MICROBIT_JS)) {
            filepath = "microbitBuild/main.ts";
        } else if (currBoard.equals(Browser_new.MIXPY)) {
            filepath = "python3/main.py";
        } else if (currBoard.equals(Browser_new.MICROPYTHON_ESP32)) {
            filepath = "esp32Build/mixly.py";
        }
        try {
            File file = new File(filepath);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWritter = new FileWriter(file);
            BufferedWriter bufferWritter = new BufferedWriter(fileWritter);
            bufferWritter.write(yuanma);
            bufferWritter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveYuanma(String yuanma, String filepath) {
        try {
            File file = new File(filepath);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWritter = new FileWriter(file);
            BufferedWriter bufferWritter = new BufferedWriter(fileWritter);
            bufferWritter.write(yuanma);
            bufferWritter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveLanguage(String value, String filepath) {
        try {
            File file = new File(filepath);
            if (!file.exists()) {
                file.createNewFile();
            }
            OutputStreamWriter writerStream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            BufferedWriter bufferWritter = new BufferedWriter(writerStream);
            bufferWritter.write(value);
            bufferWritter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveDigitalPinToInterrupt(String str) {
        String filepath = "blockly/apps/mixly/digitalPinToInterrupt.js";
        try {
            File file = new File(filepath);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWritter = new FileWriter(file);
            BufferedWriter bufferWritter = new BufferedWriter(fileWritter);
            bufferWritter.write(str);
            bufferWritter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean writeFile(String xml, String filepath) {
        try {
            File file = new File(filepath);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(filepath);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            BufferedWriter bufferWritter = new BufferedWriter(osw);
            bufferWritter.write(xml);
            bufferWritter.close();
            osw.close();
            fos.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean saveXML(String xml, String filepath) {
        return MyMethod.writeFile(xml, filepath);
    }

    public static boolean saveINO(String ino, String filepath) {
        return MyMethod.writeFile(ino, filepath);
    }

    public static String readXml(File file) {
        if (!file.exists()) {
            System.err.println("Can't Find file!");
            return null;
        }
        String s = "";
        try {
            String str;
            FileInputStream fis = new FileInputStream(file.getAbsolutePath());
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader in = new BufferedReader(isr);
            while ((str = in.readLine()) != null) {
                s = String.valueOf(s) + str.trim();
            }
            in.close();
            isr.close();
            fis.close();
            return s;
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }

    public static String readFile(File file) {
        if (!file.exists()) {
            System.err.println("Can't Find file!");
            return null;
        }
        StringBuilder s = new StringBuilder("");
        try {
            String str;
            InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            BufferedReader in = new BufferedReader(read);
            while ((str = in.readLine()) != null) {
                s.append(str).append("\n");
            }
            in.close();
            return s.toString();
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }

    public static String readBoardNameFromXml(File file) {
        if (!file.exists()) {
            System.err.println("Can't Find file!");
            return null;
        }
        String s = "";
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((str = in.readLine()) != null) {
                s = String.valueOf(s) + str;
            }
            in.close();
            Pattern p = Pattern.compile("board=\"(.+?)\"");
            Matcher matcher = p.matcher(s);
            if (matcher.find()) {
                return matcher.group(1);
            }
            p = Pattern.compile("board=\\\\\"(.+?)\\\\\"");
            matcher = p.matcher(s);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }

    public static boolean compareStrArray(String[] pre, String[] cur) {
        if (pre == null && cur == null) {
            return true;
        }
        if (pre != null && cur != null) {
            if (pre.length != cur.length) {
                return false;
            }
            int i = 0;
            while (i < pre.length) {
                if (!pre[i].equals(cur[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean deleteFile(String f) {
        boolean flag = false;
        File file = new File(f);
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }

    public static boolean deleteDirectory(String sPath) {
        File dirFile;
        if (!sPath.endsWith(File.separator)) {
            sPath = String.valueOf(sPath) + File.separator;
        }
        if (!(dirFile = new File(sPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() ? !(flag = MyMethod.deleteFile(files[i].getAbsolutePath())) : !(flag = MyMethod.deleteDirectory(files[i].getAbsolutePath()))) break;
            ++i;
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static int renameFile(String path, String oldname, String newname) {
        if (!oldname.equals(newname)) {
            File oldfile = new File(String.valueOf(path) + "/" + oldname);
            File newfile = new File(String.valueOf(path) + "/" + newname);
            if (!oldfile.exists()) {
                return -1;
            }
            if (newfile.exists()) {
                return 1;
            }
            oldfile.renameTo(newfile);
            return 2;
        }
        return -1;
    }

    public static List<String> getXmlMilList(String path) {
        File file = new File(path);
        ArrayList<String> namelist = new ArrayList<String>();
        if (file.isDirectory()) {
            File[] dirFile;
            File[] fileArray = dirFile = file.listFiles();
            int n = dirFile.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!f.isDirectory() && (f.getName().endsWith(".xml") || f.getName().endsWith(".XML") || f.getName().endsWith(".mil") || f.getName().endsWith(".MIL"))) {
                    namelist.add(f.getAbsolutePath());
                }
                ++n2;
            }
        }
        return namelist;
    }

    public static List<String> getBoardsList(String path) {
        File file = new File(path);
        ArrayList<String> namelist = new ArrayList<String>();
        if (file.isDirectory()) {
            File[] dirFile;
            File[] fileArray = dirFile = file.listFiles();
            int n = dirFile.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    namelist.addAll(MyMethod.getBoardsList(f.getAbsolutePath()));
                } else if (f.getName().equals("boards.txt")) {
                    namelist.add(f.getAbsolutePath());
                }
                ++n2;
            }
        }
        return namelist;
    }

    public static List<String> getJSList(String path) {
        File file = new File(path);
        ArrayList<String> namelist = new ArrayList<String>();
        if (file.isDirectory()) {
            File[] dirFile;
            File[] fileArray = dirFile = file.listFiles();
            int n = dirFile.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    namelist.addAll(MyMethod.getJSList(f.getAbsolutePath()));
                } else if (f.getName().endsWith(".js") || f.getName().endsWith(".JS")) {
                    namelist.add(f.getAbsolutePath());
                }
                ++n2;
            }
        }
        return namelist;
    }

    public static void setCustom() {
        File parentMyblockDir;
        String temp;
        String xmlname;
        int i;
        String otherBoard;
        block8: {
            otherBoard = "";
            try {
                if (Browser_new.isNotArduinoForCurrentBoard()) {
                    otherBoard = Browser_new.getCurrentBoard();
                }
            }
            catch (Exception e) {
                String otherBoardMyblockDir;
                String currentBoard = MyMethod.getProp("setting/config.properties", "currentBoard").trim();
                if (currentBoard == null || !new File(otherBoardMyblockDir = "blockly/apps/mixly/" + currentBoard).isDirectory()) break block8;
                otherBoard = currentBoard;
            }
        }
        List<String> xmlList = MyMethod.getXmlMilList("mylib/" + otherBoard);
        List<String> companyList = MyMethod.getXmlMilList("company/" + otherBoard);
        String customblock = "null";
        String company_block = "null";
        if (xmlList != null && xmlList.size() > 0) {
            customblock = "<sep></sep>";
            i = 0;
            while (i < xmlList.size()) {
                xmlname = xmlList.get(i);
                temp = MyMethod.readXml(new File(xmlname)).replaceAll("<xml board=\"(.+?)\">|<xml>|</xml>", "");
                customblock = String.valueOf(customblock) + "<category colour=\"290\" name=\"";
                customblock = String.valueOf(customblock) + xmlname.substring(xmlname.lastIndexOf(System.getProperty("file.separator")) + 1, xmlname.lastIndexOf("."));
                customblock = String.valueOf(customblock) + "\">";
                customblock = String.valueOf(customblock) + temp;
                customblock = String.valueOf(customblock) + "</category>";
                ++i;
            }
        }
        if (companyList != null && companyList.size() > 0) {
            company_block = "<sep></sep>";
            i = 0;
            while (i < companyList.size()) {
                xmlname = companyList.get(i);
                temp = MyMethod.readXml(new File(xmlname));
                company_block = String.valueOf(company_block) + temp;
                ++i;
            }
        }
        String myblockPath = "blockly/apps/mixly/myblock.js";
        if (!otherBoard.equals("") && !(parentMyblockDir = new File(myblockPath = "blockly/apps/mixly/" + otherBoard + "/myblock.js").getParentFile()).isDirectory()) {
            FileUtil.createEmptyFolder(parentMyblockDir.getAbsolutePath());
        }
        MyMethod.saveMyBlock("var myblock='" + customblock + "';\n" + "var company_block='" + company_block + "';\n", myblockPath);
    }

    public static void saveMyBlock(String str, String filepath) {
        try {
            File file = new File(filepath);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileWritter = new FileOutputStream(file);
            BufferedWriter bufferWritter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileWritter, "UTF-8"));
            bufferWritter.write(str);
            bufferWritter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setLanguage() {
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        MyMethod.changeCurrentBoard(config, "language", lang.contains("zh") ? "zh-hans" : "en");
    }

    public static void setCompanyLanguage() {
        List<String> ls = MyMethod.getJSList("blockly/msg/js/company/language");
        StringBuilder en = new StringBuilder("");
        StringBuilder spa = new StringBuilder("");
        StringBuilder zhs = new StringBuilder("");
        StringBuilder zht = new StringBuilder("");
        int i = 0;
        while (i < ls.size()) {
            String value = String.valueOf(MyMethod.readFile(new File(ls.get(i)))) + "\n";
            if (value != null) {
                if (ls.get(i).endsWith("en.js")) {
                    en.append(value);
                } else if (ls.get(i).endsWith("spa.js")) {
                    spa.append(value);
                } else if (ls.get(i).endsWith("zh-hans.js")) {
                    zhs.append(value);
                } else if (ls.get(i).endsWith("zh-hant.js")) {
                    zht.append(value);
                }
            }
            ++i;
        }
        MyMethod.saveLanguage(en.toString(), "blockly/msg/js/company/en.js");
        MyMethod.saveLanguage(spa.toString(), "blockly/msg/js/company/spa.js");
        MyMethod.saveLanguage(zhs.toString(), "blockly/msg/js/company/zh-hans.js");
        MyMethod.saveLanguage(zht.toString(), "blockly/msg/js/company/zh-hant.js");
    }

    public static void setCompanyPin() {
        List<String> ls = MyMethod.getJSList("blockly/apps/mixly/companypin");
        StringBuilder str = new StringBuilder("");
        int i = 0;
        while (i < ls.size()) {
            String value = String.valueOf(MyMethod.readFile(new File(ls.get(i)))) + "\n";
            if (value != null) {
                str.append(value);
            }
            ++i;
        }
        MyMethod.saveLanguage(str.toString(), "blockly/apps/mixly/company_pin.js");
    }

    public static void createSomeFolder() {
        FileUtil.createEmptyFolder("sample");
        FileUtil.createEmptyFolder("company");
        FileUtil.createEmptyFolder("blockly/blocks/company");
        FileUtil.createEmptyFolder("blockly/generators/arduino/company");
        FileUtil.createEmptyFolder("blockly/msg/js/company");
        FileUtil.createEmptyFolder("blockly/msg/js/company/language");
        FileUtil.createEmptyFolder("blockly/apps/mixly/companypin");
        String arduinoPath = MyMethod.getProp(config, "arduinoPath");
        FileUtil.createEmptyFolder(String.valueOf(arduinoPath) + "/mixlyBuild");
    }

    public static void deletePreferences() {
        String dir;
        String preferences = "Arduino15" + File.separator + "preferences.txt";
        if (SystemUtils.IS_OS_WINDOWS) {
            String dir2 = System.getenv("AppData");
            if (dir2 != null) {
                new File(dir2, preferences).delete();
            }
            if ((dir2 = System.getenv("LOCALAPPDATA")) != null) {
                new File(dir2, preferences).delete();
            }
        } else if (SystemUtils.IS_OS_MAC && (dir = System.getProperty("user.home")) != null) {
            new File(dir, "Library" + File.separator + preferences).delete();
        }
    }

    public static void main(String[] args) {
        System.out.println(SystemUtils.OS_NAME);
        System.out.println(SystemUtils.CWD);
    }
}

