/*
 * Decompiled with CFR 0.152.
 */
package org.mixly.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.mixly.Browser_new;

public class FileUtil {
    public static String trimTrailingSlash(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        char c = path.charAt(path.length() - 1);
        if (c == '/' || c == '\\') {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String toString(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append(System.lineSeparator());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return sb.toString();
    }

    public static boolean copyFileTo(String file, String to) {
        File f = new File(file);
        File t = new File(String.valueOf(to) + "/" + f.getName());
        FileInputStream fi = null;
        FileOutputStream fo = null;
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            fi = new FileInputStream(f);
            fo = new FileOutputStream(t);
            in = fi.getChannel();
            out = fo.getChannel();
            ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fi.close();
                in.close();
                fo.close();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void copyFolderTo(File src, File dest) {
        try {
            if (src.isDirectory()) {
                String[] files;
                if (!dest.exists()) {
                    dest.mkdir();
                }
                String[] stringArray = files = src.list();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    File srcFile = new File(src, file);
                    File destFile = new File(dest, file);
                    FileUtil.copyFolderTo(srcFile, destFile);
                    ++n2;
                }
            } else {
                FileUtil.copyFileTo(src.getAbsolutePath(), dest.getParent());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createEmptyFolder(String path) {
        File dest = new File(path);
        if (!dest.exists()) {
            dest.mkdir();
            System.out.println("\u521b\u5efa\uff1a" + path);
        }
    }

    public static void main(String[] args) {
    }

    public static void searchAndExport(String lib, String path) {
        File searchPath = new File(String.valueOf(Browser_new.arduinoPath) + "libraries");
        if (FileUtil.searchAndExportDetail(lib, searchPath, path)) {
            return;
        }
        searchPath = new File(String.valueOf(Browser_new.arduinoPath) + "hardware/arduino/avr/libraries");
        FileUtil.searchAndExportDetail(lib, searchPath, path);
    }

    private static boolean searchAndExportDetail(String lib, File searchPath, String dest) {
        if (searchPath.isDirectory()) {
            String[] files;
            String[] stringArray = files = searchPath.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File src = new File(searchPath + "/" + file);
                if (src.isDirectory() && FileUtil.cotainsFile(src, lib)) {
                    String srcname = src.getName();
                    FileUtil.copyFolderTo(src, new File(String.valueOf(dest) + "/" + srcname));
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean cotainsFile(File path, String name) {
        if (path.isDirectory()) {
            String[] files;
            String[] stringArray = files = path.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (FileUtil.cotainsFile(new File(path + "/" + file), name)) {
                    return true;
                }
                ++n2;
            }
        } else if (path.getName().equals(name)) {
            return true;
        }
        return false;
    }
}

