/*
 * Decompiled with CFR 0.152.
 */
package org.mixly.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileSystemView;
import org.mixly.util.SystemUtils;

public class DiskUtil {
    public static String removableDiskName = "\u53ef\u79fb\u52a8\u78c1\u76d8";
    public static String enRemovableDiskName = "Removable Disk";
    private static Hashtable<String, File> disk2fd = new Hashtable();
    public static String MICROBIT = "MICROBIT";

    public static void initDisk2fd() {
        File[] roots;
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        if (SystemUtils.IS_OS_WINDOWS) {
            roots = File.listRoots();
        } else {
            File devFile = fileSystemView.getChild(fileSystemView.getRoots()[0], "Volumes");
            roots = devFile.listFiles();
        }
        disk2fd.clear();
        File[] fileArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String diskType = fileSystemView.getSystemTypeDescription(file);
            String diskName = fileSystemView.getSystemDisplayName(file);
            try {
                if (diskName.startsWith(MICROBIT)) {
                    disk2fd.put(diskName, file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    public static String[] getRemovableDiskNameList() {
        ArrayList<String> removableDiskArr = new ArrayList<String>();
        DiskUtil.initDisk2fd();
        Enumeration<String> e = disk2fd.keys();
        while (e.hasMoreElements()) {
            removableDiskArr.add(e.nextElement());
        }
        return removableDiskArr.toArray(new String[0]);
    }

    public static File getRemovableDiskFd(String diskName) {
        DiskUtil.initDisk2fd();
        return disk2fd.get(diskName);
    }

    public static File[] getRemovableDiskFdList() {
        ArrayList<File> removableDiskFdArr = new ArrayList<File>();
        DiskUtil.initDisk2fd();
        Enumeration<String> e = disk2fd.keys();
        while (e.hasMoreElements()) {
            removableDiskFdArr.add(disk2fd.get(e.nextElement()));
        }
        return removableDiskFdArr.toArray(new File[0]);
    }

    public static void main(String[] args) {
        String[] stringArray = DiskUtil.getRemovableDiskNameList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            System.out.println(f);
            System.out.println(disk2fd.get(f));
            ++n2;
        }
        System.out.println(disk2fd.get("11"));
    }
}

