/*
 * Decompiled with CFR 0.152.
 */
package org.mixly.esp32;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Queue;
import jssc.SerialPort;
import org.apache.commons.lang3.ArrayUtils;
import org.mixly.Browser_new;
import org.mixly.esp32.Esp32Util;
import org.mixly.util.SystemUtils;

public class ReadWriteUart
extends Thread {
    private String model = "";
    private byte[] writemsg;
    private String lastmodel = "";
    private Queue<String> queue;
    private byte[] maybeCN;
    private String currentBoard;
    private SerialPort ser;
    private String recvAllData;
    private boolean isWriteFile;
    private boolean isSetMain;
    private boolean isRunProgram;
    private boolean isSha1File;
    private String writeFileMsg;
    private String setMainMsg;
    private String runProgramMsg;
    private String sha1FileMsg;

    public ReadWriteUart(String board, SerialPort serial, Queue<String> queue) {
        this.queue = queue;
        this.maybeCN = null;
        this.currentBoard = board;
        this.ser = serial;
        this.isWriteFile = false;
        this.isSetMain = false;
        this.isRunProgram = false;
        this.isSha1File = false;
        this.writeFileMsg = "";
        this.setMainMsg = "";
        this.runProgramMsg = "";
        this.sha1FileMsg = "";
    }

    public boolean isSha1File() {
        return this.isSha1File;
    }

    public void setSha1File(boolean isSha1File) {
        this.isSha1File = isSha1File;
    }

    public String getSha1FileMsg() {
        return this.sha1FileMsg;
    }

    public void setSha1FileMsg(String sha1FileMsg) {
        this.sha1FileMsg = sha1FileMsg;
    }

    public void setWriteFile(boolean isWriteFile) {
        this.isWriteFile = isWriteFile;
    }

    public void setSetMain(boolean isSetMain) {
        this.isSetMain = isSetMain;
    }

    public void setRunProgram(boolean isRunProgram) {
        this.isRunProgram = isRunProgram;
    }

    public String getWriteFileMsg() {
        return this.writeFileMsg;
    }

    public void setWriteFileMsg(String writeFileMsg) {
        this.writeFileMsg = writeFileMsg;
    }

    public String getSetMainMsg() {
        return this.setMainMsg;
    }

    public void setSetMainMsg(String setMainMsg) {
        this.setMainMsg = setMainMsg;
    }

    public String getRunProgramMsg() {
        return this.runProgramMsg;
    }

    public void setRunProgramMsg(String runProgramMsg) {
        this.runProgramMsg = runProgramMsg;
    }

    public boolean resetSerial(int baudrate) {
        try {
            if (SystemUtils.IS_OS_MAC) {
                this.ser.setParams(baudrate, 8, 1, 0, false, false);
            } else {
                this.ser.setParams(baudrate, 8, 1, 0);
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void recvUartMsg(String data) {
        if (data == null || data.equals("")) {
            return;
        }
        if (this.isWriteFile) {
            this.recvAllData = String.valueOf(this.recvAllData) + data;
            if (this.recvAllData.indexOf(">>> ") >= 0 || this.recvAllData.indexOf("... ") >= 0) {
                this.writeFileMsg = this.recvAllData;
                this.recvAllData = "";
            }
        } else if (this.isSetMain) {
            this.recvAllData = String.valueOf(this.recvAllData) + data;
            if (this.recvAllData.indexOf(">>> ") >= 0 || this.recvAllData.indexOf("... ") >= 0) {
                this.setMainMsg = this.recvAllData;
                this.recvAllData = "";
            }
        } else if (this.isRunProgram) {
            this.recvAllData = String.valueOf(this.recvAllData) + data;
            if (this.recvAllData.indexOf(">>> ") >= 0 || this.recvAllData.indexOf("... ") >= 0) {
                this.runProgramMsg = this.recvAllData;
                this.recvAllData = "";
            }
        } else if (this.isSha1File) {
            this.recvAllData = String.valueOf(this.recvAllData) + data;
            if (this.recvAllData.indexOf(":::sha1_file_end") >= 0 || this.recvAllData.indexOf("... ") >= 0) {
                this.sha1FileMsg = this.recvAllData;
                this.recvAllData = "";
            }
        }
    }

    @Override
    public void run() {
        int readNum = 0;
        String sendData = "";
        String execSendData = "";
        this.maybeCN = new byte[0];
        String cmd = "";
        byte[] data = null;
        String dataStr = "";
        while (true) {
            if (this.ser.isOpened()) {
                block59: {
                    byte[] tmpData;
                    block58: {
                        if (!this.queue.isEmpty()) {
                            block57: {
                                cmd = this.queue.poll();
                                if (cmd.indexOf(":::") >= 0) {
                                    String[] cmdParts = cmd.split(":::");
                                    this.model = cmdParts[0];
                                    try {
                                        if (cmdParts.length == 3) {
                                            this.writemsg = Esp32Util.hexDecode(cmdParts[2]);
                                            break block57;
                                        }
                                        this.writemsg = cmdParts[1].getBytes("UTF-8");
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        e.printStackTrace();
                                    }
                                } else {
                                    this.model = cmd;
                                    this.writemsg = new byte[0];
                                }
                            }
                            if (this.model.equals("close")) {
                                this.lastmodel = "";
                                this.model = "";
                                break;
                            }
                            if (this.model.equals("kill_")) {
                                try {
                                    this.ser.writeBytes(this.writemsg);
                                    this.lastmodel = "kill_";
                                    break block58;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.lastmodel = "";
                                    this.model = "";
                                    break;
                                }
                            }
                            if (this.model.equals("ctrltouart")) {
                                if (this.lastmodel.equals("exec_")) {
                                    Browser_new.updateTextArea("another program is running!", true);
                                    this.model = "uitouart";
                                    continue;
                                }
                                try {
                                    this.ser.writeBytes(this.writemsg);
                                    break block58;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.lastmodel = "";
                                    this.model = "";
                                    break;
                                }
                            }
                            if (this.model.equals("exec_")) {
                                if (this.lastmodel.equals("exec_")) {
                                    Browser_new.updateTextArea("another program is running!", true);
                                    this.model = "uitouart";
                                    continue;
                                }
                                this.lastmodel = "exec_";
                                try {
                                    this.ser.writeBytes(this.writemsg);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.lastmodel = "";
                                    this.model = "";
                                    break;
                                }
                            }
                        }
                    }
                    if (this.model.equals("") || this.model.equals("uitouart")) {
                        try {
                            data = this.ser.readBytes(1, 5);
                            if (data == null || data.length == 0 || data.equals("".getBytes("UTF-8")) || data[0] > 127) continue;
                            dataStr = new String(data);
                            if (!this.lastmodel.equals("exec_")) continue;
                            if ((execSendData = String.valueOf(execSendData) + dataStr).indexOf(">") < 0) {
                                execSendData = "";
                                continue;
                            }
                            if (execSendData.indexOf(">>> ") < 0) continue;
                            execSendData = "";
                            this.lastmodel = "";
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (this.model.equals("exec_")) {
                        try {
                            data = this.ser.readBytes(1, 5);
                            if (Esp32Util.byteArrayToHexStr(data).startsWith("E")) {
                                data = ArrayUtils.addAll(data, this.ser.readBytes(2, 5));
                            }
                            dataStr = new String(data);
                            Browser_new.updateTextArea(dataStr, false);
                            execSendData = String.valueOf(execSendData) + dataStr;
                            if (execSendData.indexOf(">") < 0) {
                                execSendData = "";
                            } else if (execSendData.indexOf(">>> ") >= 0) {
                                execSendData = "";
                                this.lastmodel = "";
                            }
                            this.recvUartMsg(dataStr);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (!this.model.equals("ctrltouart") && !this.model.equals("kill_")) continue;
                    data = new byte[]{};
                    do {
                        try {
                            tmpData = this.ser.readBytes(1, 5);
                        }
                        catch (Exception e) {
                            break;
                        }
                    } while ((data = ArrayUtils.addAll(data, tmpData)).length != 10);
                    if (data.length >= 2) {
                        byte[] recv;
                        byte[] subData = Arrays.copyOfRange(data, data.length - 2, data.length - 1);
                        byte[] subData2 = Arrays.copyOfRange(data, data.length - 1, data.length);
                        if (Esp32Util.byteArrayToHexStr(subData).startsWith("E")) {
                            try {
                                Thread.sleep(1L);
                                recv = this.ser.readBytes(1, 5);
                                if (recv == null || recv.length == 0 || recv.equals("".getBytes("UTF-8"))) {
                                    data = Arrays.copyOfRange(data, 0, data.length - 2);
                                    break block59;
                                }
                                data = ArrayUtils.addAll(data, recv);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if (Esp32Util.byteArrayToHexStr(subData2).startsWith("E")) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            try {
                                recv = this.ser.readBytes(2, 5);
                                if (recv == null || recv.length == 0 || recv.equals("".getBytes("UTF-8")) || recv.length != 2) {
                                    data = Arrays.copyOfRange(data, 0, data.length - 1);
                                    break block59;
                                }
                                data = ArrayUtils.addAll(data, recv);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        try {
                            int idx;
                            if (data != null && data.length != 0 && !data.equals("".getBytes("UTF-8")) && (idx = Esp32Util.byteArrayToHexStr(data).indexOf("E")) != -1 && idx % 2 == 0) {
                                Thread.sleep(1L);
                                byte[] recv = this.ser.readBytes(2, 5);
                                data = recv == null || recv.length == 0 || recv.equals("".getBytes("UTF-8")) || recv.length != 2 ? Arrays.copyOfRange(data, 0, data.length - 1) : ArrayUtils.addAll(data, recv);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (this.maybeCN != null && this.maybeCN.length != 0) {
                    data = ArrayUtils.addAll(this.maybeCN, data);
                }
                try {
                    dataStr = new String(data);
                    this.maybeCN = new byte[0];
                }
                catch (Exception e) {
                    if (this.maybeCN.length >= 3) {
                        this.maybeCN = new byte[0];
                        continue;
                    }
                    this.maybeCN = data;
                    continue;
                }
                this.maybeCN = new byte[0];
                if (dataStr == null || dataStr.equals("")) {
                    if (++readNum != 6) continue;
                    this.recvUartMsg(sendData);
                    sendData = "";
                    readNum = 0;
                    continue;
                }
                sendData = String.valueOf(sendData) + dataStr;
                readNum = 0;
                continue;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.lastmodel = "";
        this.model = "";
    }

    public void setCurrentBoard(String board) {
        this.currentBoard = board;
    }

    public void setSerialPort(SerialPort serial) {
        this.ser = serial;
    }

    public String getRecvMsg(String msgType) {
        if (msgType.equals("runProgramMsg")) {
            return this.getRunProgramMsg();
        }
        if (msgType.equals("writeFileMsg")) {
            return this.getWriteFileMsg();
        }
        if (msgType.equals("setMainMsg")) {
            return this.getSetMainMsg();
        }
        if (msgType.equals("sha1FileMsg")) {
            return this.getSha1FileMsg();
        }
        return "";
    }

    public void setRecvMsg(String msgType, String msg) {
        if (msgType.equals("runProgramMsg")) {
            this.setRunProgramMsg(msg);
        } else if (msgType.equals("writeFileMsg")) {
            this.setWriteFileMsg(msg);
        } else if (msgType.equals("setMainMsg")) {
            this.setSetMainMsg(msg);
        } else if (msgType.equals("sha1FileMsg")) {
            this.setSha1FileMsg(msg);
        }
    }

    public void setOperationFlag(String msgType, boolean flag) {
        if (msgType.equals("runProgramMsg")) {
            this.setRunProgram(flag);
        } else if (msgType.equals("writeFileMsg")) {
            this.setWriteFile(flag);
        } else if (msgType.equals("setMainMsg")) {
            this.setSetMain(flag);
        } else if (msgType.equals("sha1FileMsg")) {
            this.setSha1File(flag);
        }
    }

    public boolean waitingResp(String msgType, int deltaTime, String errorMsg) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        long endTime = 0L;
        while (this.getRecvMsg(msgType).equals("")) {
            Thread.sleep(5L);
            endTime = System.currentTimeMillis();
            if (endTime - startTime <= (long)deltaTime) continue;
            this.setOperationFlag(msgType, false);
            this.setRecvMsg(msgType, "");
            System.out.println("Timeout: " + errorMsg);
            return false;
        }
        if (this.getRecvMsg(msgType).indexOf("Trackback") >= 0 || this.getRecvMsg(msgType).indexOf("... ") >= 0) {
            this.setOperationFlag(msgType, false);
            String returnData = this.getRecvMsg(msgType);
            this.setRecvMsg(msgType, "");
            if (returnData.indexOf("Traceback") >= 0) {
                System.out.println(returnData);
            } else {
                this.queue.offer("kill_:::byte:::03");
            }
            System.out.println(errorMsg);
            Thread.sleep(10L);
            return false;
        }
        return true;
    }
}

