/*
 * Decompiled with CFR 0.152.
 */
package org.mixly.esp32;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.mixly.util.MyMethod;
import org.mixly.util.SystemUtils;

public class Esp32Util {
    public static HashSet<String> detectPyModule(String pyfile) {
        HashSet<String> modules = new HashSet<String>();
        String content = MyMethod.readFile(new File(pyfile)).replaceAll("\r\n", "\n").replaceAll(" ?#.*?\n", "");
        CharSequence[] importPtns = new String[]{"from +(.*?)import +.+?\n", "import +(.*?) +?as +.+?\r{0,1}\n", "import +(.*?)\n"};
        String importPtnStr = String.join((CharSequence)"|", importPtns);
        Pattern r = Pattern.compile(importPtnStr);
        Matcher m = r.matcher(content);
        while (m.find()) {
            int i = 1;
            while (i <= importPtns.length) {
                if (m.group(i) != null) {
                    String[] stringArray = m.group(i).replaceAll(" ", "").split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String module = stringArray[n2];
                        modules.add(module);
                        ++n2;
                    }
                }
                ++i;
            }
        }
        return modules;
    }

    public static HashSet<String> detectStaticFile(String f) {
        HashSet<String> maybeStaticFiles = new HashSet<String>();
        String content = MyMethod.readFile(new File(f)).replaceAll("\r\n", "\n").replaceAll(" ?#.*?\n", "");
        String singleWord = "[0-9A-Za-z\\-\\_\\.\u4e00-\u9fa5]";
        CharSequence[] staticFilePtns = new String[]{String.format("\"(%s+?\\.%s+?)\"", singleWord, singleWord), String.format("'(%s+?\\.%s+?)'", singleWord, singleWord)};
        String staticFileStr = String.join((CharSequence)"|", staticFilePtns);
        Pattern r = Pattern.compile(staticFileStr);
        Matcher m = r.matcher(content);
        while (m.find()) {
            int i = 1;
            while (i <= staticFilePtns.length) {
                if (m.group(i) != null) {
                    maybeStaticFiles.add(m.group(i));
                }
                ++i;
            }
        }
        return maybeStaticFiles;
    }

    public static String byteArrayToHexStr(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[byteArray.length * 2];
        int j = 0;
        while (j < byteArray.length) {
            int v = byteArray[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        String hexStr = new String(hexChars);
        String newHexStr = "[";
        boolean isOdd = true;
        int i = 0;
        while (i < hexStr.length()) {
            boolean bl = isOdd = i % 2 == 1;
            if (!isOdd) {
                newHexStr = String.valueOf(newHexStr) + "0x";
            }
            newHexStr = String.valueOf(newHexStr) + hexStr.charAt(i);
            if (isOdd) {
                newHexStr = String.valueOf(newHexStr) + ",";
            }
            ++i;
        }
        newHexStr = String.valueOf(newHexStr) + "]";
        return newHexStr;
    }

    public static byte[] hexDecode(String hexStr) {
        if (hexStr == null || "".equals(hexStr)) {
            return null;
        }
        try {
            char[] cs = hexStr.toCharArray();
            return Hex.decodeHex(cs);
        }
        catch (DecoderException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String escapeMetaCharacters(String inputString) {
        String[] metaCharacters = new String[]{"\\", "\""};
        String outputString = inputString;
        int i = 0;
        while (i < metaCharacters.length) {
            if (inputString.contains(metaCharacters[i])) {
                inputString = outputString = inputString.replace(metaCharacters[i], "\\" + metaCharacters[i]);
            }
            ++i;
        }
        return outputString;
    }

    public static String calcSHA1(File file, boolean notNeedFormatLine) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        FileInputStream fis = new FileInputStream(file);
        int n = 0;
        byte[] buffer = new byte[128];
        String s = "";
        while (n != -1) {
            n = ((InputStream)fis).read(buffer);
            if (n <= 0) continue;
            s = new String(buffer, 0, n);
            if (!notNeedFormatLine) {
                s = SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_WINDOWS ? s.replaceAll("\n", "") : s.replaceAll("\n", "\r");
            }
            digest.update(s.getBytes());
        }
        ((InputStream)fis).close();
        return new HexBinaryAdapter().marshal(digest.digest()).toLowerCase();
    }

    public static String extractBoardLibHash(String msg) {
        msg = msg.replaceAll("\r", "\n").replaceAll("\n\n", "\r").replaceAll("\n", "\r");
        String[] stringArray = msg.split("\r");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith("'") && line.endsWith(":::sha1_file_end'")) {
                return line.split(":::")[0].substring(1);
            }
            ++n2;
        }
        return "NoneExtract";
    }

    public static void printSuccessMsg() {
        System.out.println("========> done!");
    }

    public static String convertStrToAscii(String str) throws UnsupportedEncodingException {
        byte[] ascii = str.getBytes(StandardCharsets.UTF_8);
        String hex = "[";
        byte[] byArray = ascii;
        int n = ascii.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hex = String.valueOf(hex) + "0x" + String.format("%02x", b) + ",";
            ++n2;
        }
        hex = String.valueOf(hex) + "]";
        return hex;
    }

    public static void main(String[] args) {
        System.out.println(Esp32Util.detectStaticFile("F:\\11.py"));
        try {
            System.out.println("mpu9250.py::" + Esp32Util.calcSHA1(new File("F:\\codes\\mixly\\mixly_git\\mixly\\mixly\\esp32Build\\lib\\mpu9250.py"), true));
            System.out.println("ESP32.py::" + Esp32Util.calcSHA1(new File("F:\\codes\\mixly\\mixly_git\\mixly\\mixly\\esp32Build\\lib\\ESP32.py"), true));
            System.out.println("mixly.py::" + Esp32Util.calcSHA1(new File("F:\\codes\\mixly\\mixly_git\\mixly\\mixly\\esp32Build\\mixly.py"), true));
            System.out.println("11.py:" + Esp32Util.calcSHA1(new File("F:\\11.py"), true));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

