/*
 * Decompiled with CFR 0.152.
 */
package org.mixly.esp32;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Queue;
import org.mixly.esp32.Esp32Util;
import org.mixly.esp32.ReadWriteUart;

public class Esp32Uploader {
    private Queue<String> queue;
    private String board;
    private ReadWriteUart readWriteUart;
    private static String libpath = "esp32Build/lib";
    private static String thirdpartyLibpath = "esp32Build/lib/thirdparty";
    private static String staticpath = "esp32Build/static";

    public Esp32Uploader(String board, Queue<String> queue, ReadWriteUart readWriteUart) {
        this.queue = queue;
        this.board = board;
        this.readWriteUart = readWriteUart;
    }

    public boolean runProgram(String destfile) throws InterruptedException {
        boolean ok;
        System.out.println("run program...");
        destfile = destfile.replaceAll("\\\\", "/");
        this.readWriteUart.setRunProgram(true);
        if (this.board.equals("microbit")) {
            String aline = destfile.startsWith("./") ? String.format("exec(open('%s').read(),globals())", destfile.substring(2)) : String.format("exec(open('%s').read(),globals())", destfile);
            int i = 0;
            while (i < aline.length()) {
                String subString = aline.substring(i, i + 1);
                this.putMsgToQueue(String.format("uitouart:::%s", subString));
                Thread.sleep(1L);
                ++i;
            }
            ok = this.putMsgToQueue("exec_:::\r");
        } else {
            ok = this.putMsgToQueue(String.format("exec_:::exec(open('%s').read(),globals())\r\n", destfile));
        }
        Thread.sleep(10L);
        this.readWriteUart.setRunProgram(false);
        this.readWriteUart.setRunProgramMsg("");
        return ok;
    }

    public boolean setMain(String destfile) throws InterruptedException {
        String subString;
        System.out.println("set main.py...");
        destfile = destfile.replaceAll("\\\\", "/");
        this.readWriteUart.setSetMain(true);
        if (this.board.equals("microbit")) {
            String aline = "myfile=open('main.py','w')\r";
            int i = 0;
            while (i < aline.length()) {
                String subString2 = aline.substring(i, i + 1);
                this.putMsgToQueue(String.format("ctrltouart:::%s", subString2));
                Thread.sleep(1L);
                ++i;
            }
        } else {
            this.putMsgToQueue("ctrltouart:::myfile=open('main.py','w')\r\n");
        }
        boolean ok = this.readWriteUart.waitingResp("setMainMsg", 1000, "open main.py failed!");
        if (!ok) {
            return false;
        }
        this.readWriteUart.setSetMainMsg("");
        if (this.board.equals("microbit")) {
            String aline = destfile.startsWith("./") ? String.format("exec(open('%s').read(),globals())", destfile.substring(2)) : String.format("exec(open('%s').read(),globals())", destfile);
            int i = 0;
            while (i < aline.length()) {
                subString = aline.substring(i, i + 1);
                this.putMsgToQueue(String.format("ctrltouart:::%s", subString));
                Thread.sleep(1L);
                ++i;
            }
        } else {
            this.putMsgToQueue(String.format("ctrltouart:::myfile.write(\"exec(open('%s').read(),globals())\")\r\n", destfile));
        }
        ok = this.readWriteUart.waitingResp("setMainMsg", 3000, "write main.py failed!");
        if (!ok) {
            return false;
        }
        this.readWriteUart.setSetMainMsg("");
        if (this.board.equals("microbit")) {
            String aline = "myfile.close()\r";
            int i = 0;
            while (i < aline.length()) {
                subString = aline.substring(i, i + 1);
                this.putMsgToQueue(String.format("ctrltouart:::%s", subString));
                Thread.sleep(1L);
                ++i;
            }
        } else {
            this.putMsgToQueue("ctrltouart:::myfile.close()\r\n");
        }
        ok = this.readWriteUart.waitingResp("setMainMsg", 1000, "close main.py failed!");
        this.readWriteUart.setSetMain(false);
        this.readWriteUart.setSetMainMsg("");
        if (ok) {
            Esp32Util.printSuccessMsg();
        }
        Thread.sleep(10L);
        return ok;
    }

    public boolean writeFile(String destfile, boolean isBinary) throws InterruptedException, IOException {
        String subString;
        FileInputStream fileHandler;
        String aline;
        boolean ok;
        String afile;
        block24: {
            destfile = destfile.replaceAll("\\\\", "/");
            this.readWriteUart.setWriteFile(true);
            if (destfile.indexOf("/") >= 0) {
                String[] destfileParts = destfile.split("/");
                afile = destfileParts[destfileParts.length - 1];
            } else {
                afile = destfile;
            }
            System.out.println(String.format("write file %s...", afile));
            ok = false;
            int i = 0;
            while (i < 3) {
                this.putMsgToQueue("kill_:::byte:::03");
                ok = this.readWriteUart.waitingResp("writeFileMsg", 2000, "Warning:Serial has no response! Now retry...");
                if (ok) break;
                this.readWriteUart.setWriteFileMsg("");
                this.readWriteUart.setWriteFile(true);
                Thread.sleep(500L);
                ++i;
            }
            if (!ok) {
                System.out.println("Error:Serial has no response after retry! Now exit.");
                return false;
            }
            this.readWriteUart.setWriteFileMsg("");
            if (this.board.equals("microbit")) {
                aline = String.format("myfile=open(%s,'wb')\r", afile);
                i = 0;
                while (i < aline.length()) {
                    String subString2 = aline.substring(i, i + 1);
                    this.putMsgToQueue(String.format("ctrltouart:::%s", subString2));
                    Thread.sleep(1L);
                    ++i;
                }
            } else {
                this.putMsgToQueue(String.format("ctrltouart:::myfile=open('%s','wb')\r\n", afile));
            }
            ok = this.readWriteUart.waitingResp("writeFileMsg", 3000, String.format("open file %s failed!", afile));
            if (!ok) {
                this.putMsgToQueue("kill_:::byte:::03");
                return false;
            }
            fileHandler = new FileInputStream(destfile);
            do {
                int len;
                byte[] buffer;
                if (this.board.equals("microbit")) {
                    buffer = new byte[64];
                    len = fileHandler.read(buffer);
                } else {
                    buffer = new byte[128];
                    len = fileHandler.read(buffer);
                }
                if (len == -1) break block24;
                if (this.board.equals("microbit")) {
                    this.readWriteUart.setWriteFileMsg("");
                    aline = "";
                    try {
                        aline = new String(buffer, 0, len);
                        aline = aline.replaceAll("\r\n", "\r").replaceAll("\n", "\r");
                        aline = String.format("myfile.write(%s)\r", aline);
                    }
                    catch (Exception e) {
                        aline = String.format("myfile.write(%s)\r", aline);
                    }
                    int i2 = 0;
                    while (i2 < aline.length()) {
                        subString = aline.substring(i2, i2 + 1);
                        this.putMsgToQueue(String.format("ctrltouart:::%s", subString));
                        Thread.sleep(1L);
                        ++i2;
                    }
                    continue;
                }
                aline = "";
                try {
                    if (!isBinary) {
                        aline = new String(buffer, 0, len);
                        aline = Esp32Util.convertStrToAscii(aline);
                    } else {
                        aline = Esp32Util.byteArrayToHexStr(Arrays.copyOfRange(buffer, 0, len));
                    }
                    aline = String.format("ctrltouart:::myfile.write(bytes(%s))\r\n", aline);
                    this.readWriteUart.setWriteFileMsg("");
                    this.putMsgToQueue(aline);
                }
                catch (Exception e) {
                    this.readWriteUart.setWriteFileMsg("");
                    this.putMsgToQueue(String.format("ctrltouart:::myfile.write(%s)\r\n", aline));
                }
            } while (ok = this.readWriteUart.waitingResp("writeFileMsg", 15000, String.format("write file %s content failed", afile)));
            this.putMsgToQueue("kill_:::byte:::03");
            fileHandler.close();
            return false;
        }
        fileHandler.close();
        if (this.board.equals("microbit")) {
            aline = "myfile.close()\r";
            int i = 0;
            while (i < aline.length()) {
                subString = aline.substring(i, i + 1);
                this.putMsgToQueue(String.format("ctrltouart:::%s", subString));
                Thread.sleep(1L);
                ++i;
            }
        } else {
            this.putMsgToQueue("ctrltouart:::myfile.close()\r\n");
        }
        ok = this.readWriteUart.waitingResp("writeFileMsg", 3000, String.format("close file %s failed", afile));
        if (!ok) {
            this.putMsgToQueue("kill_:::byte:::03");
        }
        this.readWriteUart.setWriteFile(false);
        this.readWriteUart.setWriteFileMsg("");
        if (ok) {
            Esp32Util.printSuccessMsg();
        }
        return ok;
    }

    public int checkSha1(File localFile, String boardFileName) {
        boolean isSameSha1 = false;
        String boardLibFileHash = "None";
        try {
            this.readWriteUart.setSha1File(true);
            this.readWriteUart.setSha1FileMsg("");
            String localLibFileHash = Esp32Util.calcSHA1(localFile, true);
            this.putMsgToQueue(String.format("ctrltouart:::import mixly_tool;mixly_tool.sha1_file(\"%s\")\r\n", boardFileName));
            boolean ok = this.readWriteUart.waitingResp("sha1FileMsg", 1500, String.format("sha1 file %s failed", boardFileName));
            boardLibFileHash = Esp32Util.extractBoardLibHash(this.readWriteUart.getRecvMsg("sha1FileMsg"));
            if (!ok) {
                throw new Exception("sha1 file failed");
            }
            isSameSha1 = localLibFileHash.equals(boardLibFileHash);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.readWriteUart.setSha1File(false);
        this.readWriteUart.setSha1FileMsg("");
        if (isSameSha1) {
            return 1;
        }
        if (!isSameSha1) {
            if (boardLibFileHash.equals("None")) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    public boolean writeStaticFile(File destfile) throws InterruptedException, IOException {
        boolean ok = false;
        if (!new File(staticpath).isDirectory()) {
            System.out.println("Error:espBuild/static is not exist!");
            return false;
        }
        HashSet<String> maybeStaticFiles = Esp32Util.detectStaticFile(destfile.toString());
        File[] fileArray = new File(staticpath).listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File sf = fileArray[n2];
            String sfName = sf.getName();
            if (sf.isFile() && maybeStaticFiles.contains(sfName) && !(ok = this.writeFile(sf.getAbsolutePath(), true))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean writeAndReloadFile(File libfile) throws InterruptedException, IOException {
        boolean ok = false;
        ok = this.writeFile(libfile.toString(), false);
        if (!ok) {
            return false;
        }
        ok = this.reloadFile(libfile);
        return ok;
    }

    public boolean reloadFile(File libfile) throws InterruptedException {
        boolean ok = false;
        String libfileName = libfile.getName();
        this.readWriteUart.setWriteFile(true);
        this.readWriteUart.setWriteFileMsg("");
        this.putMsgToQueue(String.format("ctrltouart:::import mixly_tool;mixly_tool.reload(%s)\r\n", libfileName.split("\\.")[0]));
        System.out.println(String.format("reload module %s...", libfileName));
        ok = this.readWriteUart.waitingResp("writeFileMsg", 1500, String.format("warning:reload module %s failed!", libfileName));
        if (ok) {
            Esp32Util.printSuccessMsg();
        }
        this.readWriteUart.setWriteFile(false);
        this.readWriteUart.setWriteFileMsg("");
        Thread.sleep(10L);
        return ok;
    }

    public boolean writeLibFile(String destfile) throws InterruptedException, IOException {
        if (!new File(libpath).isDirectory()) {
            System.out.println("Error:espBuild/lib is not exist!");
            return false;
        }
        if (!new File(thirdpartyLibpath).isDirectory()) {
            System.out.println("Error:espBuild/lib/thirdparty is not exist!");
            return false;
        }
        HashSet<String> modules = Esp32Util.detectPyModule(destfile);
        boolean hasMixlyToolInBoard = false;
        boolean localExistMixlyTool = new File(libpath, "mixly_tool.py").isFile();
        boolean ok = false;
        if (localExistMixlyTool) {
            this.readWriteUart.setWriteFile(true);
            this.readWriteUart.setWriteFileMsg("");
            this.putMsgToQueue(String.format("ctrltouart:::import mixly_tool\r\n", new Object[0]));
            ok = this.readWriteUart.waitingResp("writeFileMsg", 500, "");
            this.readWriteUart.setWriteFile(false);
            this.readWriteUart.setWriteFileMsg("");
            String mixlyFilePath = String.valueOf(libpath) + "/mixly_tool.py";
            String mixlyFileName = "mixly_tool.py";
            File mixlyFile = new File(mixlyFilePath);
            if (!ok || this.checkSha1(mixlyFile, mixlyFileName) != 1) {
                ok = this.writeAndReloadFile(mixlyFile);
                if (!ok) {
                    return false;
                }
                ok = this.writeStaticFile(mixlyFile);
                if (!ok) {
                    return false;
                }
                Thread.sleep(10L);
            } else {
                System.out.println(String.format("NOTICE: %s is the same in board, now skip it!", mixlyFileName));
            }
            hasMixlyToolInBoard = true;
        }
        ArrayList<File> libFileList = new ArrayList<File>(Arrays.asList(new File(libpath).listFiles()));
        libFileList.addAll(Arrays.asList(new File(thirdpartyLibpath).listFiles()));
        HashSet<String> alreadyUploadFiles = new HashSet<String>();
        for (File libfile : libFileList) {
            String libfileName = libfile.getName();
            if (alreadyUploadFiles.contains(libfileName)) continue;
            alreadyUploadFiles.add(libfileName);
            if (!libfile.isFile() || !libfileName.endsWith(".py") || !modules.contains(libfileName.substring(0, libfileName.lastIndexOf(".")))) continue;
            int isSameSha1 = 0;
            if (hasMixlyToolInBoard) {
                isSameSha1 = this.checkSha1(libfile, libfileName);
            }
            if (!hasMixlyToolInBoard || isSameSha1 != 1) {
                ok = this.writeAndReloadFile(libfile);
                if (!ok) {
                    return false;
                }
                ok = this.writeStaticFile(libfile);
                if (!ok) {
                    return false;
                }
                Thread.sleep(10L);
                continue;
            }
            System.out.println(String.format("NOTICE: %s is the same in board, now skip it!", libfileName));
        }
        return true;
    }

    public boolean run(String destfile) throws InterruptedException, IOException {
        boolean ok = this.writeFile(destfile, false);
        if (!ok) {
            return ok;
        }
        ok = this.writeStaticFile(new File(destfile));
        if (!ok) {
            return false;
        }
        ok = this.writeLibFile(destfile);
        if (!ok) {
            return ok;
        }
        String destfileName = new File(destfile).getName();
        ok = this.setMain(destfileName);
        if (!ok) {
            return false;
        }
        ok = this.runProgram(destfileName);
        return ok;
    }

    public boolean putMsgToQueue(String msg) {
        return this.queue.offer(msg);
    }
}

