/*
 * Decompiled with CFR 0.152.
 */
package org.mixly;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import org.mixly.Browser_new;
import org.mixly.util.LanguageProvider;
import org.mixly.view.DataReceiverPanel;

public class SerialPortDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField textField;
    private static JCheckBox chckbxNewCheckBox;
    public static JTextArea textArea;
    static SerialPort serialPortCom;
    static String com;
    private static JComboBox comboBox;
    private static DataReceiverPanel panel_huatu;
    private CardLayout card = new CardLayout(0, 0);
    private JTextField textField_1;
    private JTextField textField_2;
    private static final String HEAD = "mixly";
    private static StringBuffer strBuffer;
    private static boolean isSetNum;

    static {
        com = "";
        panel_huatu = new DataReceiverPanel(1);
        strBuffer = new StringBuffer("mixly\r\n");
        isSetNum = false;
    }

    public static void main(String[] args) {
        try {
            SerialPortDialog dialog = new SerialPortDialog();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SerialPortDialog() {
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                panel_huatu.begin();
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                panel_huatu.clear();
                strBuffer = new StringBuffer("mixly\r\n");
                isSetNum = false;
                SerialPortDialog.this.card.first(SerialPortDialog.this.getContentPane());
                Browser_new.setUploadDisable(false);
                Browser_new.setHardWareTestDisable(false);
                if (serialPortCom != null && serialPortCom.isOpened()) {
                    try {
                        serialPortCom.closePort();
                        serialPortCom = null;
                    }
                    catch (SerialPortException serialPortException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                panel_huatu.setAlive(false);
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
        this.setTitle("\u4e32\u53e3\u76d1\u89c6\u5668");
        this.setBounds(100, 100, 600, 400);
        this.getContentPane().setLayout(this.card);
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "name_39102077189140");
        panel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        panel.add((Component)scrollPane, "Center");
        textArea = new JTextArea();
        scrollPane.setViewportView(textArea);
        JPanel panel_1 = new JPanel();
        panel.add((Component)panel_1, "North");
        panel_1.setLayout(new BorderLayout(0, 0));
        this.textField = new JTextField();
        panel_1.add(this.textField);
        this.textField.setColumns(10);
        JButton button = new JButton(LanguageProvider.getLocalString("send"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                String str = SerialPortDialog.this.textField.getText();
                SerialPortDialog.serialWriteData(str);
                SerialPortDialog.this.textField.setText("");
            }
        });
        panel_1.add((Component)button, "East");
        JPanel buttonPane = new JPanel();
        panel.add((Component)buttonPane, "South");
        buttonPane.setLayout(new BorderLayout(0, 0));
        chckbxNewCheckBox = new JCheckBox(LanguageProvider.getLocalString("auto_scroll"));
        chckbxNewCheckBox.setSelected(true);
        buttonPane.add((Component)chckbxNewCheckBox, "West");
        JButton button_1 = new JButton(LanguageProvider.getLocalString("clear"));
        button_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                textArea.setText("");
            }
        });
        JPanel panel_12 = new JPanel();
        buttonPane.add((Component)panel_12, "Center");
        JLabel lblNewLabel = new JLabel(LanguageProvider.getLocalString("baud_rate"));
        panel_12.add(lblNewLabel);
        comboBox = new JComboBox();
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && SerialPortDialog.this.isVisible()) {
                    SerialPortDialog.resetSerialBaudRate();
                }
            }
        });
        comboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"110", "300", "600", "1200", "2400", "4800", "9600", "19200", "28800", "38400", "43000", "56000", "57600", "115200", "128000", "256000"}));
        comboBox.setSelectedItem("9600");
        panel_12.add(comboBox);
        JButton btnNewButton_1 = new JButton(LanguageProvider.getLocalString("btn_huitu"));
        btnNewButton_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                SerialPortDialog.this.card.next(SerialPortDialog.this.getContentPane());
            }
        });
        panel_12.add(btnNewButton_1);
        buttonPane.add((Component)button_1, "East");
        panel = new JPanel();
        this.getContentPane().add((Component)panel, "name_39409381508270");
        panel.setLayout(new BorderLayout(0, 0));
        panel.add((Component)panel_huatu, "Center");
        panel_1 = new JPanel();
        panel.add((Component)panel_1, "North");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_1.add(panel_2);
        JLabel lblNewLabel_1 = new JLabel(LanguageProvider.getLocalString("txt_max"));
        panel_2.add(lblNewLabel_1);
        this.textField_1 = new JTextField();
        this.textField_1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                SerialPortDialog.this.setMaxAndMin();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
            }
        });
        this.textField_1.setText("1024");
        panel_2.add(this.textField_1);
        this.textField_1.setColumns(10);
        JLabel lblNewLabel_2 = new JLabel(LanguageProvider.getLocalString("txt_min"));
        panel_2.add(lblNewLabel_2);
        this.textField_2 = new JTextField();
        this.textField_2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                SerialPortDialog.this.setMaxAndMin();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
            }
        });
        this.textField_2.setText("0");
        panel_2.add(this.textField_2);
        this.textField_2.setColumns(10);
        JButton btnNewButton = new JButton(LanguageProvider.getLocalString("btn_txt_mode"));
        btnNewButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SerialPortDialog.this.card.previous(SerialPortDialog.this.getContentPane());
            }
        });
        panel_1.add((Component)btnNewButton, "East");
    }

    protected void setMaxAndMin() {
        if (this.textField_1 != null && this.textField_2 != null) {
            String max = this.textField_1.getText();
            String min = this.textField_2.getText();
            try {
                int ma = Integer.parseInt(max);
                int mi = Integer.parseInt(min);
                panel_huatu.setMaxAndMin(ma, mi);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void resetSerial() {
        String name = com;
        try {
            serialPortCom = new SerialPort(name);
            if (!serialPortCom.isOpened()) {
                serialPortCom.openPort();
            }
            if (Browser_new.getCurrentBoard().contains(Browser_new.MICROBIT_JS) || Browser_new.getCurrentBoard().contains(Browser_new.MICROBIT_PY) || Browser_new.getCurrentBoard().contains(Browser_new.MICROPYTHON_ESP32)) {
                comboBox.setSelectedItem("115200");
            } else {
                comboBox.setSelectedItem("9600");
            }
            SerialPortDialog.resetSerialBaudRate();
            int mask = 25;
            serialPortCom.setEventsMask(mask);
            serialPortCom.addEventListener(new SerialPortReader());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void resetSerialBaudRate() {
        try {
            int baudRate = Integer.parseInt(comboBox.getSelectedItem().toString());
            serialPortCom.setParams(baudRate, 8, 1, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void serialWriteData(String data) {
        if (serialPortCom.isOpened()) {
            try {
                serialPortCom.writeString(data);
            }
            catch (SerialPortException e) {
                e.printStackTrace();
            }
        }
    }

    private static void transferToGraph(String msg) {
        try {
            strBuffer.append(msg);
            String str = strBuffer.toString();
            int lastIndex = str.lastIndexOf("\r\n");
            if (str.contains("\r\n")) {
                String[] s = str.split("(\r\n)+");
                int new_length = str.endsWith("\r\n") ? s.length : s.length - 1;
                int i = 0;
                while (i < new_length) {
                    String tmp = s[i].trim();
                    if (!tmp.startsWith(HEAD)) {
                        ArrayList<Float> value = new ArrayList<Float>();
                        String[] valueStr = tmp.split("[,\uff0c;\uff1b]+");
                        int num = valueStr.length;
                        int k = 0;
                        while (k < num) {
                            float f = 0.0f;
                            f = Float.parseFloat(valueStr[k].trim());
                            value.add(Float.valueOf(f));
                            ++k;
                        }
                        if (!isSetNum) {
                            panel_huatu.setNum(num);
                            isSetNum = true;
                        }
                        panel_huatu.addValue(value);
                    }
                    ++i;
                }
                strBuffer = new StringBuffer(strBuffer.substring(lastIndex + 2));
            }
        }
        catch (Exception e) {
            strBuffer = new StringBuffer(HEAD);
        }
    }

    private static void updateTextArea(String msg) {
        textArea.append(msg);
        if (chckbxNewCheckBox.isSelected()) {
            int length = textArea.getText().length();
            textArea.setCaretPosition(length);
        }
    }

    static class SerialPortReader
    implements SerialPortEventListener {
        SerialPortReader() {
        }

        @Override
        public void serialEvent(SerialPortEvent event) {
            if (event.isRXCHAR() && event.getEventValue() > 0) {
                try {
                    String msg = serialPortCom.readString();
                    SerialPortDialog.updateTextArea(msg);
                    SerialPortDialog.transferToGraph(msg);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

