/*
 * Decompiled with CFR 0.152.
 */
package org.mixly;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import org.mixly.Browser_new;
import org.mixly.SerialPortDialog;
import org.mixly.util.FileUtil;
import org.mixly.util.MyMethod;
import org.mixly.util.SystemUtils;
import org.mixly.util.WinRegistryUtil;

public class Main
extends Application {
    private Scene scene;
    private Browser_new browser;
    private boolean stageIconified;
    private String autoSetLanguage = MyMethod.getProp("setting/config.properties", "autoSetLanguage");
    private static String clickedFile = null;

    public static void main(String[] args) {
        if (args.length != 0) {
            clickedFile = args[0];
        }
        Main.launch(args);
    }

    @Override
    public void start(Stage stage) {
        MyMethod.createSomeFolder();
        MyMethod.deletePreferences();
        MyMethod.setCustom();
        MyMethod.setCompanyLanguage();
        if (this.autoSetLanguage != null && this.autoSetLanguage.equals("true")) {
            MyMethod.setLanguage();
        }
        stage.setTitle(Browser_new.getMyTitle());
        StackPane root = new StackPane();
        this.browser = new Browser_new(stage);
        if (clickedFile != null) {
            Browser_new.xmlFileName = clickedFile;
        }
        root.getChildren().add(this.browser);
        this.scene = new Scene(root, 1150.0, 650.0);
        stage.setMaximized(true);
        stage.iconifiedProperty().addListener((observable, oldValue, newValue) -> {
            this.stageIconified = newValue;
        });
        stage.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (this.stageIconified && newValue.booleanValue()) {
                stage.setIconified(false);
            }
        });
        stage.setScene(this.scene);
        stage.getIcons().add(new Image("logo.png"));
        stage.show();
        stage.setOnCloseRequest(new EventHandler(){

            public void handle(Event event) {
                if (!Browser_new.isXmlSaved()) {
                    event.consume();
                    Browser_new.unSaveWarningDialog.setYesOrNo(false);
                    Browser_new.unSaveWarningDialog.setLocationRelativeTo(null);
                    Browser_new.unSaveWarningDialog.setVisible(true);
                    Browser_new.unSaveWarningDialog.toFront();
                    new Thread(){

                        @Override
                        public void run() {
                            while (Browser_new.unSaveWarningDialog.isVisible()) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (Browser_new.unSaveWarningDialog.isYesOrNo()) {
                                Platform.exit();
                            }
                        }
                    }.start();
                }
            }
        });
        new Thread(){

            @Override
            public void run() {
                if (SystemUtils.IS_OS_WINDOWS) {
                    String programKey = "Mixly.mix";
                    String extensionKey = "Software\\Classes\\.mix";
                    String cwd = SystemUtils.CWD;
                    String regKey = "Software\\Classes\\" + programKey;
                    String iconKey = String.valueOf(regKey) + "\\DefaultIcon";
                    String openKey = String.valueOf(regKey) + "\\shell\\open\\command";
                    try {
                        WinRegistryUtil.createKey(-2147483647, regKey);
                        WinRegistryUtil.createKey(-2147483647, iconKey);
                        WinRegistryUtil.writeStringValue(-2147483647, iconKey, "", String.valueOf(cwd) + "\\setting\\mixly.ico");
                        WinRegistryUtil.createKey(-2147483647, openKey);
                        WinRegistryUtil.writeStringValue(-2147483647, openKey, "", String.valueOf(cwd) + "\\Mixly.exe %1");
                        WinRegistryUtil.createKey(-2147483647, extensionKey);
                        WinRegistryUtil.writeStringValue(-2147483647, extensionKey, "", programKey);
                        programKey = "Mixly.mil";
                        extensionKey = "Software\\Classes\\.mil";
                        regKey = "Software\\Classes\\" + programKey;
                        iconKey = String.valueOf(regKey) + "\\DefaultIcon";
                        openKey = String.valueOf(regKey) + "\\shell\\open\\command";
                        WinRegistryUtil.createKey(-2147483647, regKey);
                        WinRegistryUtil.createKey(-2147483647, iconKey);
                        WinRegistryUtil.writeStringValue(-2147483647, iconKey, "", String.valueOf(cwd) + "\\setting\\mixlib.ico");
                        WinRegistryUtil.createKey(-2147483647, openKey);
                        WinRegistryUtil.writeStringValue(-2147483647, openKey, "", String.valueOf(cwd) + "\\Mixly.exe %1");
                        WinRegistryUtil.createKey(-2147483647, extensionKey);
                        WinRegistryUtil.writeStringValue(-2147483647, extensionKey, "", programKey);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                String userdir = System.getProperty("user.home");
                if (userdir != null) {
                    File source = new File("microbitBuild/.pxt");
                    File dest = new File(userdir, ".pxt");
                    dest.delete();
                    FileUtil.copyFolderTo(source, dest);
                }
            }
        }.start();
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        this.browser.setIsalive(false);
        if (SerialPortDialog.serialPortCom != null && SerialPortDialog.serialPortCom.isOpened()) {
            SerialPortDialog.serialPortCom.closePort();
            SerialPortDialog.serialPortCom = null;
        }
        if (SystemUtils.IS_OS_MAC) {
            System.exit(0);
        } else {
            try {
                Browser_new.portDialog.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Browser_new.libmanagerDialog.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Browser_new.unSaveWarningDialog.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.exit(0);
    }
}

