/*
 * Decompiled with CFR 0.152.
 */
package org.mixly;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.mixly.Browser_new;
import org.mixly.util.LanguageProvider;
import org.mixly.util.MyMethod;

public class LibManagerDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField textField;
    private JList list;
    private DefaultListModel<String> listModel = new DefaultListModel();
    private List<String> listdata;
    private String myblockPath = "";
    private String companyPath = "";
    String a_new_name = LanguageProvider.getLocalString("input_new_name");

    public static void main(String[] args) {
        try {
            LibManagerDialog dialog = new LibManagerDialog();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LibManagerDialog() {
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
                LibManagerDialog.this.updataDialog();
            }
        });
        this.setTitle(LanguageProvider.getLocalString("lib_manager"));
        this.setBounds(100, 100, 500, 400);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPane = new JPanel();
        this.getContentPane().add((Component)buttonPane, "South");
        this.textField = new JTextField(this.a_new_name);
        this.textField.setToolTipText(this.a_new_name);
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (LibManagerDialog.this.textField.getText().isEmpty()) {
                    LibManagerDialog.this.textField.setText(LibManagerDialog.this.a_new_name);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (LibManagerDialog.this.textField.getText().equals(LibManagerDialog.this.a_new_name)) {
                    LibManagerDialog.this.textField.setText("");
                }
            }
        });
        buttonPane.setLayout(new FlowLayout(1, 5, 5));
        buttonPane.add(this.textField);
        this.textField.setColumns(15);
        JButton renameButton = new JButton(LanguageProvider.getLocalString("rename"));
        renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        renameButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LibManagerDialog.this.list.getSelectedValue() != null && !LibManagerDialog.this.textField.getText().equals("") && !LibManagerDialog.this.textField.getText().equals(LibManagerDialog.this.a_new_name)) {
                    String fullpath = LibManagerDialog.this.list.getSelectedValue().toString();
                    String oldname = fullpath.substring(fullpath.lastIndexOf(System.getProperty("file.separator")) + 1, fullpath.length());
                    if (fullpath.contains("company" + System.getProperty("file.separator"))) {
                        if (MyMethod.renameFile(LibManagerDialog.this.companyPath, oldname, String.valueOf(LibManagerDialog.this.textField.getText()) + ".xml") == 2) {
                            LibManagerDialog.this.updatalist();
                        }
                    } else if (MyMethod.renameFile(LibManagerDialog.this.myblockPath, oldname, String.valueOf(LibManagerDialog.this.textField.getText()) + ".xml") == 2) {
                        LibManagerDialog.this.updatalist();
                    }
                }
            }
        });
        renameButton.setActionCommand("OK");
        buttonPane.add(renameButton);
        this.getRootPane().setDefaultButton(renameButton);
        JButton deleteButton = new JButton(LanguageProvider.getLocalString("delete"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        deleteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (LibManagerDialog.this.list.getSelectedValue() != null) {
                    String name = LibManagerDialog.this.list.getSelectedValue().toString();
                    File xmlFile = new File(name);
                    final String result = MyMethod.readXml(xmlFile);
                    String folder = xmlFile.getParent();
                    if (folder.endsWith("company")) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    this.deleteAllLib(result);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }).start();
                    }
                    MyMethod.deleteFile(name);
                    LibManagerDialog.this.updatalist();
                }
            }

            private void deleteAllLib(String result) {
                Pattern p1 = Pattern.compile("block=\"(.*?)\"");
                Pattern p2 = Pattern.compile("generator=\"(.*?)\"");
                Pattern p3 = Pattern.compile("lib=\"(.*?)\"");
                Pattern p4 = Pattern.compile("hardware=\"(.*?)\"");
                Pattern p5 = Pattern.compile("media=\"(.*?)\"");
                Pattern p6 = Pattern.compile("language=\"(.*?)\"");
                Pattern p7 = Pattern.compile("pin=\"(.*?)\"");
                Matcher m1 = p1.matcher(result);
                Matcher m2 = p2.matcher(result);
                Matcher m3 = p3.matcher(result);
                Matcher m4 = p4.matcher(result);
                Matcher m5 = p5.matcher(result);
                Matcher m6 = p6.matcher(result);
                Matcher m7 = p7.matcher(result);
                String str_block = null;
                String str_generator = null;
                String str_lib = null;
                String str_hardware = null;
                String str_media = null;
                String str_lang = null;
                String str_pin = null;
                if (m1.find()) {
                    str_block = m1.group(1);
                }
                if (m2.find()) {
                    str_generator = m2.group(1);
                }
                if (m3.find()) {
                    str_lib = m3.group(1);
                }
                if (m4.find()) {
                    str_hardware = m4.group(1);
                }
                if (m5.find()) {
                    str_media = m5.group(1);
                }
                if (m6.find()) {
                    str_lang = m6.group(1);
                }
                if (m7.find()) {
                    str_pin = m7.group(1);
                }
                if (str_lib != null) {
                    str_lib.equals("");
                }
                if (str_hardware != null && !str_hardware.equals("hardware/arduino") && !str_hardware.equals("./hardware/arduino") && !str_hardware.equals("") && str_hardware.startsWith("hardware")) {
                    MyMethod.deleteDirectory(String.valueOf(Browser_new.arduinoPath) + str_hardware);
                }
                if (str_media != null && !str_media.equals("") && str_media.startsWith("media")) {
                    MyMethod.deleteDirectory("blockly/" + str_media);
                }
                if (str_lang != null && !str_lang.equals("") && str_lang.startsWith("language")) {
                    MyMethod.deleteDirectory("blockly/msg/js/company/" + str_lang);
                    MyMethod.setCompanyLanguage();
                }
                if (str_block != null && !str_block.equals("") && str_block.startsWith("block")) {
                    MyMethod.deleteFile("blockly/blocks/company" + str_block.substring(str_block.lastIndexOf("/")));
                }
                if (str_generator != null && !str_generator.equals("") && str_generator.startsWith("generator")) {
                    MyMethod.deleteFile("blockly/generators/arduino/company" + str_generator.substring(str_generator.lastIndexOf("/")));
                }
                if (str_pin != null && !str_pin.equals("") && str_pin.startsWith("companypin")) {
                    MyMethod.deleteDirectory("blockly/apps/mixly/" + str_pin);
                    MyMethod.setCompanyPin();
                }
            }
        });
        deleteButton.setActionCommand("Cancel");
        buttonPane.add(deleteButton);
        JButton openlibButton = new JButton(LanguageProvider.getLocalString("open_directory"));
        openlibButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (LibManagerDialog.this.list.getSelectedValue() != null) {
                        String fullpath = LibManagerDialog.this.list.getSelectedValue().toString();
                        if (fullpath.contains("company" + System.getProperty("file.separator"))) {
                            Runtime.getRuntime().exec("explorer " + LibManagerDialog.this.companyPath);
                        } else {
                            Runtime.getRuntime().exec("explorer " + LibManagerDialog.this.myblockPath);
                        }
                    } else if (LibManagerDialog.this.listdata != null && LibManagerDialog.this.listdata.size() > 0 && ((String)LibManagerDialog.this.listdata.get(0)).contains("company" + System.getProperty("file.separator"))) {
                        Runtime.getRuntime().exec("explorer " + LibManagerDialog.this.companyPath);
                    } else {
                        Runtime.getRuntime().exec("explorer " + LibManagerDialog.this.myblockPath);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        buttonPane.add(openlibButton);
        JScrollPane scrollPane = new JScrollPane();
        this.getContentPane().add((Component)scrollPane, "Center");
        this.listdata = MyMethod.getXmlMilList(this.myblockPath);
        this.listdata.addAll(MyMethod.getXmlMilList(this.companyPath));
        if (this.listdata != null && this.listdata.size() > 0) {
            int i = 0;
            while (i < this.listdata.size()) {
                String fullpath = this.listdata.get(i);
                this.listModel.addElement(fullpath);
                ++i;
            }
        }
        this.list = new JList<String>(this.listModel);
        this.list.setSelectionMode(0);
        scrollPane.setViewportView(this.list);
    }

    private void updatalist() {
        this.updataDialog();
        MyMethod.setCustom();
        Browser_new.refreshWeb();
    }

    private void updataDialog() {
        String otherBoard = "";
        if (Browser_new.isNotArduinoForCurrentBoard()) {
            otherBoard = Browser_new.getCurrentBoard();
        }
        this.myblockPath = "mylib" + System.getProperty("file.separator") + otherBoard;
        this.companyPath = "company" + System.getProperty("file.separator") + otherBoard;
        this.listdata = MyMethod.getXmlMilList(this.myblockPath);
        this.listdata.addAll(MyMethod.getXmlMilList(this.companyPath));
        this.listModel.clear();
        if (this.listdata != null && this.listdata.size() > 0) {
            int i = 0;
            while (i < this.listdata.size()) {
                String fullpath = this.listdata.get(i);
                this.listModel.addElement(fullpath);
                ++i;
            }
        }
        if (this.list != null) {
            this.list.updateUI();
        }
    }
}

