/*
 * Decompiled with CFR 0.152.
 */
package org.mixly;

import java.util.ArrayList;
import java.util.List;
import javafx.animation.AnimationTimer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import org.mixly.Browser_new;
import org.mixly.SerialPortDialog;

public class HardWareTestDialog2 {
    final Stage stage = new Stage(StageStyle.UTILITY);
    private String msg = "\u59dd\uff45\u6e6a\u6d93\u5a41\u7d36\u7ead\ue0ff\u6b22\u5a34\u5b2d\u762f\u7ecb\u5b2a\u7c2d\u951b\u5c83\ue1ec\u7ecb\u5d85\u6097...";
    Canvas canvas;
    private GraphicsContext gc;
    private double width = 500.0;
    private double height = 400.0;
    private double minWidth = 500.0;
    private double maxWidth = 1000.0;
    private int digitalNum;
    private int analogNum;
    private static int[] digitalArray = null;
    private static int[] analogArray = null;
    private List<ArrayList<Integer>> analogValues = new ArrayList<ArrayList<Integer>>();
    private int points = 0;
    private double xDelta = 20.0;
    private String com = "";
    private SerialPort serialPortCom;
    private StringBuffer strBuffer = new StringBuffer("");
    double leftpadding = 5.0;
    double rightpadding = 40.0;
    private Color[] myColors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.ORANGE, Color.MAGENTA, Color.CYAN, Color.PINK, Color.YELLOW, Color.AQUAMARINE, Color.BROWN, Color.DARKGREY, Color.DEEPPINK, Color.DARKGOLDENROD, Color.SKYBLUE, Color.INDIGO, Color.GREENYELLOW};

    public HardWareTestDialog2(Stage stg, String title, int digitalNum, final int analogNum, String com) {
        this.initData(digitalNum, analogNum, com);
        this.stage.initModality(Modality.APPLICATION_MODAL);
        this.stage.initOwner(stg);
        this.stage.setTitle(title);
        this.stage.setMinWidth(this.width + 18.0);
        this.stage.setMinHeight(this.height + 40.0);
        Group root = new Group();
        this.canvas = new Canvas(this.width, this.height);
        this.gc = this.canvas.getGraphicsContext2D();
        root.getChildren().add(this.canvas);
        Scene scene = new Scene(root, this.minWidth, this.height);
        this.stage.setScene(scene);
        this.stage.show();
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add(new KeyFrame(Duration.millis(100.0), new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                int i = 0;
                while (i < analogNum) {
                    analogArray[i] = (int)(Math.random() * 1024.0);
                    ++i;
                }
                HardWareTestDialog2.this.addValues(analogArray);
            }
        }, new KeyValue[0]));
        timeline.setCycleCount(-1);
        final AnimationTimer timer = new AnimationTimer(){

            @Override
            public void handle(long now) {
                HardWareTestDialog2.this.drawShapes(HardWareTestDialog2.this.gc);
            }
        };
        timer.start();
        this.stage.setOnCloseRequest(new EventHandler(){

            public void handle(Event event) {
                timer.stop();
                Browser_new.cmdIsKilled = true;
                HardWareTestDialog2.this.strBuffer = new StringBuffer("");
                if (HardWareTestDialog2.this.serialPortCom != null && HardWareTestDialog2.this.serialPortCom.isOpened()) {
                    try {
                        HardWareTestDialog2.this.serialPortCom.closePort();
                        SerialPortDialog.serialPortCom = null;
                    }
                    catch (SerialPortException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void initData(int digitalNum, int analogNum, String com) {
        this.digitalNum = digitalNum;
        this.analogNum = analogNum;
        this.com = com;
        digitalArray = new int[digitalNum];
        analogArray = new int[analogNum];
        int max = Math.max(digitalNum, analogNum);
        double width = 40 + max * 30 + 15;
        this.width = width < this.minWidth ? this.minWidth : (width > this.maxWidth ? this.maxWidth : width);
        int i = 0;
        while (i < this.analogNum) {
            this.analogValues.add(new ArrayList());
            ++i;
        }
        this.points = (int)((this.width - 40.0 - 15.0) / this.xDelta + 1.0);
    }

    private void drawShapes(GraphicsContext gc) {
        double w = this.stage.getWidth() - 18.0;
        double h = this.stage.getHeight() - 40.0;
        this.canvas.setWidth(w);
        this.canvas.setHeight(h);
        gc.setFill(Color.WHITE);
        gc.clearRect(0.0, 0.0, w, h);
        gc.fillRect(0.0, 0.0, w, h);
        gc.setFill(Color.RED);
        gc.fillText(this.msg, 5.0, 15.0);
        gc.setFill(Color.BLACK);
        gc.setStroke(Color.GREEN);
        gc.setLineWidth(1.0);
        gc.strokeLine(0.0 + this.leftpadding, 80.0, w - this.rightpadding, 80.0);
        gc.setStroke(Color.BLACK);
        gc.strokeLine(0.0 + this.leftpadding, h - 50.0, w - this.rightpadding, h - 50.0);
        gc.setLineWidth(0.1);
        gc.fillText("0", w - this.rightpadding + 3.0, h - 50.0 + 5.0);
        double deltaY = (h - 50.0 - 150.0) / 4.0;
        int i = 0;
        while (i < 4) {
            gc.strokeLine(0.0 + this.leftpadding, h - 50.0 - deltaY * (double)(i + 1), w - this.rightpadding, h - 50.0 - deltaY * (double)(i + 1));
            gc.fillText("" + 256 * (i + 1), w - this.rightpadding + 3.0, h - 50.0 - deltaY * (double)(i + 1) + 5.0);
            ++i;
        }
        gc.setStroke(Color.GREEN);
        gc.setFill(Color.GREEN);
        i = 0;
        while (i < this.digitalNum) {
            gc.setFill(Color.GREEN);
            gc.fillText("" + i, this.leftpadding + 5.0 + (double)(i * 30), 95.0);
            int data = digitalArray[i];
            if (data == 1) {
                gc.setFill(Color.GREEN);
            } else {
                gc.setFill(Color.LIGHTGREY);
            }
            gc.fillOval(this.leftpadding + 5.0 + (double)(i * 30) - 5.0, 50.0, 20.0, 20.0);
            ++i;
        }
        i = 0;
        while (i < this.analogNum) {
            gc.setStroke(this.myColors[i % this.myColors.length]);
            gc.setFill(this.myColors[i % this.myColors.length]);
            gc.setLineWidth(1.0);
            gc.fillText("A" + i, this.leftpadding + 5.0 + (double)(i * 30), h - 30.0);
            gc.fillRect(this.leftpadding + 5.0 + (double)(i * 30), h - 27.0, 15.0, 6.0);
            this.xDelta = (w - 5.0 - 40.0) / (double)(this.points - 1);
            if (this.analogValues != null && this.analogValues.size() > 0 && this.analogValues.get(i) != null) {
                int length = this.analogValues.get(i).size();
                int j = 0;
                while (j < length - 1) {
                    double x1 = this.xDelta * (double)(this.points - length + j) + this.leftpadding;
                    double y1 = this.analogValues.get(i).get(j).intValue();
                    double x2 = this.xDelta * (double)(this.points - length + j + 1) + this.leftpadding;
                    double y2 = this.analogValues.get(i).get(j + 1).intValue();
                    y1 = h - 50.0 - y1 / 1024.0 * (h - 150.0 - 50.0);
                    y2 = h - 50.0 - y2 / 1024.0 * (h - 150.0 - 50.0);
                    gc.strokeLine(x1, y1, x2, y2);
                    ++j;
                }
            }
            ++i;
        }
        gc.setStroke(Color.BLACK);
    }

    public void hide() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                HardWareTestDialog2.this.stage.hide();
            }
        });
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void resetSerial() {
        String name = this.com;
        try {
            this.serialPortCom = new SerialPort(name);
            if (!this.serialPortCom.isOpened()) {
                this.serialPortCom.openPort();
            }
            this.serialPortCom.setParams(9600, 8, 1, 0);
            int mask = 25;
            this.serialPortCom.setEventsMask(mask);
            this.serialPortCom.addEventListener(new SerialPortReader());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void transfer(String msg) {
        try {
            this.strBuffer.append(msg);
            String str = this.strBuffer.toString();
            int lastIndex = str.lastIndexOf("\r\n");
            if (str.contains("\r\n")) {
                String[] s = str.split("(\r\n)+");
                int new_length = str.endsWith("\r\n") ? s.length : s.length - 1;
                int i = 0;
                while (i < new_length) {
                    float f;
                    int k;
                    int num;
                    String[] valueStr;
                    String tmp = s[i].trim();
                    if (tmp.startsWith("digital")) {
                        valueStr = tmp.substring(7).split(" ");
                        num = valueStr.length;
                        k = 0;
                        while (k < num && k < digitalArray.length) {
                            f = 0.0f;
                            f = Float.parseFloat(valueStr[k].trim());
                            HardWareTestDialog2.digitalArray[k] = (int)f;
                            ++k;
                        }
                    } else if (tmp.startsWith("analog")) {
                        valueStr = tmp.substring(6).split(" ");
                        num = valueStr.length;
                        k = 0;
                        while (k < num && k < analogArray.length) {
                            f = 0.0f;
                            f = Float.parseFloat(valueStr[k].trim());
                            HardWareTestDialog2.analogArray[k] = (int)f;
                            ++k;
                        }
                        this.addValues(analogArray);
                    }
                    ++i;
                }
                this.strBuffer = new StringBuffer(this.strBuffer.substring(lastIndex + 2));
            }
        }
        catch (Exception e) {
            this.strBuffer = new StringBuffer("");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addValues(int[] analogArray) {
        if (analogArray == null) {
            return;
        }
        i = 0;
        ** GOTO lbl12
        {
            this.analogValues.get(i).remove(0);
            do {
                if (this.analogValues.get(i).size() >= this.points) continue block0;
                this.analogValues.get(i).add(analogArray[i]);
                ++i;
lbl12:
                // 2 sources

            } while (i < this.analogNum);
        }
    }

    private void printData() {
        int i = 0;
        while (i < this.analogValues.size()) {
            System.out.print(String.valueOf(i) + "-" + this.analogValues.get(i).size() + " ");
            System.out.println(this.analogValues.get(i).toString());
            ++i;
        }
    }

    class SerialPortReader
    implements SerialPortEventListener {
        SerialPortReader() {
        }

        @Override
        public void serialEvent(SerialPortEvent event) {
            if (event.isRXCHAR() && event.getEventValue() > 0) {
                try {
                    String msg = HardWareTestDialog2.this.serialPortCom.readString();
                    HardWareTestDialog2.this.transfer(msg);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

