/*
 * Decompiled with CFR 0.152.
 */
package org.mixly;

import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import org.mixly.Browser_new;
import org.mixly.SerialPortDialog;

public class HardWareTestDialog {
    final Stage stage = new Stage(StageStyle.UTILITY);
    private String msg = "\u59dd\uff45\u6e6a\u6d93\u5a41\u7d36\u7ead\ue0ff\u6b22\u5a34\u5b2d\u762f\u7ecb\u5b2a\u7c2d\u951b\u5c83\ue1ec\u7ecb\u5d85\u6097...";
    private GraphicsContext gc;
    private double width = 500.0;
    private double height = 400.0;
    private double minWidth = 500.0;
    private double maxWidth = 1000.0;
    private int digitalNum;
    private int analogNum;
    private static int[] digitalArray = null;
    private static int[] analogArray = null;
    private static String com = "";
    private static SerialPort serialPortCom;
    private static StringBuffer strBuffer;

    static {
        strBuffer = new StringBuffer("");
    }

    public HardWareTestDialog(Stage stg, String title, int digitalNum, int analogNum, String com) {
        this.initData(digitalNum, analogNum, com);
        this.stage.initModality(Modality.APPLICATION_MODAL);
        this.stage.initOwner(stg);
        this.stage.setResizable(false);
        this.stage.setTitle(title);
        this.stage.setOnCloseRequest(new EventHandler(){

            public void handle(Event event) {
                Browser_new.cmdIsKilled = true;
                strBuffer = new StringBuffer("");
                if (serialPortCom != null && serialPortCom.isOpened()) {
                    try {
                        serialPortCom.closePort();
                        SerialPortDialog.serialPortCom = null;
                    }
                    catch (SerialPortException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        Group root = new Group();
        Canvas canvas = new Canvas(this.width, this.height);
        root.getChildren().add(canvas);
        this.gc = canvas.getGraphicsContext2D();
        Scene scene = new Scene(root);
        this.stage.setScene(scene);
        this.stage.show();
    }

    private void initData(int digitalNum, int analogNum, String com) {
        this.digitalNum = digitalNum;
        this.analogNum = analogNum;
        HardWareTestDialog.com = com;
        digitalArray = new int[digitalNum];
        analogArray = new int[analogNum];
        int max = Math.max(digitalNum, analogNum);
        double width = 40 + max * 30 + 15;
        this.width = width < this.minWidth ? this.minWidth : (width > this.maxWidth ? this.maxWidth : width);
    }

    public void begin() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (HardWareTestDialog.this.stage.isShowing()) {
                    HardWareTestDialog.this.drawShapes(HardWareTestDialog.this.gc);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    private void drawShapes(GraphicsContext gc) {
        int data;
        gc.setFill(Color.WHITE);
        gc.fillRect(0.0, 0.0, this.width, this.height);
        gc.setFill(Color.RED);
        gc.fillText(this.msg, 5.0, 15.0);
        gc.setFill(Color.BLACK);
        double leftpadding = 5.0;
        double rightpadding = 40.0;
        gc.setStroke(Color.GREEN);
        gc.setLineWidth(1.0);
        gc.strokeLine(0.0 + leftpadding, 100.0, this.width - rightpadding, 100.0);
        gc.setStroke(Color.BLUE);
        gc.strokeLine(0.0 + leftpadding, 350.0, this.width - rightpadding, 350.0);
        gc.setStroke(Color.BLACK);
        gc.setLineWidth(0.1);
        gc.fillText("0", this.width - rightpadding + 3.0, 355.0);
        int i = 0;
        while (i < 4) {
            gc.strokeLine(0.0 + leftpadding, 350 - 40 * (i + 1), this.width - rightpadding, 350 - 40 * (i + 1));
            gc.fillText("" + 256 * (i + 1), this.width - rightpadding + 3.0, 350 - 40 * (i + 1) + 5);
            ++i;
        }
        gc.setStroke(Color.GREEN);
        gc.setFill(Color.GREEN);
        i = 0;
        while (i < this.digitalNum) {
            gc.setFill(Color.GREEN);
            gc.fillText("" + i, leftpadding + 5.0 + (double)(i * 30), 115.0);
            data = digitalArray[i];
            if (data == 1) {
                gc.setFill(Color.GREEN);
            } else {
                gc.setFill(Color.LIGHTGREY);
            }
            gc.fillOval(leftpadding + 5.0 + (double)(i * 30) - 5.0, 70.0, 20.0, 20.0);
            ++i;
        }
        gc.setStroke(Color.BLUE);
        gc.setFill(Color.BLUE);
        i = 0;
        while (i < this.analogNum) {
            gc.fillText("A" + i, leftpadding + 5.0 + (double)(i * 30), 365.0);
            data = analogArray[i];
            int tmp = (int)((double)data / 1024.0 * 160.0);
            gc.fillRect(leftpadding + 5.0 + (double)(i * 30), 350 - tmp, 10.0, tmp);
            ++i;
        }
        gc.setStroke(Color.BLACK);
    }

    public void hide() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                HardWareTestDialog.this.stage.hide();
            }
        });
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void resetSerial() {
        String name = com;
        try {
            serialPortCom = new SerialPort(name);
            if (!serialPortCom.isOpened()) {
                serialPortCom.openPort();
            }
            serialPortCom.setParams(9600, 8, 1, 0);
            int mask = 25;
            serialPortCom.setEventsMask(mask);
            serialPortCom.addEventListener(new SerialPortReader());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void transfer(String msg) {
        block8: {
            try {
                strBuffer.append(msg);
                String str = strBuffer.toString();
                int lastIndex = str.lastIndexOf("\r\n");
                if (!str.contains("\r\n")) break block8;
                String[] s = str.split("(\r\n)+");
                int new_length = str.endsWith("\r\n") ? s.length : s.length - 1;
                int i = 0;
                while (i < new_length) {
                    float f;
                    int k;
                    int num;
                    String[] valueStr;
                    String tmp = s[i].trim();
                    if (tmp.startsWith("digital")) {
                        valueStr = tmp.substring(7).split(" ");
                        num = valueStr.length;
                        k = 0;
                        while (k < num && k < digitalArray.length) {
                            f = 0.0f;
                            f = Float.parseFloat(valueStr[k].trim());
                            HardWareTestDialog.digitalArray[k] = (int)f;
                            ++k;
                        }
                    } else if (tmp.startsWith("analog")) {
                        valueStr = tmp.substring(6).split(" ");
                        num = valueStr.length;
                        k = 0;
                        while (k < num && k < analogArray.length) {
                            f = 0.0f;
                            f = Float.parseFloat(valueStr[k].trim());
                            HardWareTestDialog.analogArray[k] = (int)f;
                            ++k;
                        }
                    }
                    ++i;
                }
                strBuffer = new StringBuffer(strBuffer.substring(lastIndex + 2));
            }
            catch (Exception e) {
                strBuffer = new StringBuffer("");
            }
        }
    }

    static class SerialPortReader
    implements SerialPortEventListener {
        SerialPortReader() {
        }

        @Override
        public void serialEvent(SerialPortEvent event) {
            if (event.isRXCHAR() && event.getEventValue() > 0) {
                try {
                    String msg = serialPortCom.readString();
                    HardWareTestDialog.transfer(msg);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

