/*
 * Decompiled with CFR 0.152.
 */
package org.mixly;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortList;
import netscape.javascript.JSObject;
import org.apache.batik.transcoder.TranscoderException;
import org.mixly.HardWareTestDialog2;
import org.mixly.JSFuncs;
import org.mixly.LibManagerDialog;
import org.mixly.SerialPortDialog;
import org.mixly.StateDialog;
import org.mixly.UnSaveWarningDialog;
import org.mixly.UserAgreementDialog;
import org.mixly.esp32.Esp32Uploader;
import org.mixly.esp32.ReadWriteUart;
import org.mixly.util.Coder;
import org.mixly.util.DiskUtil;
import org.mixly.util.FileUtil;
import org.mixly.util.HardWareUtil;
import org.mixly.util.HttpUtil;
import org.mixly.util.LanguageProvider;
import org.mixly.util.MyCom;
import org.mixly.util.MyMethod;
import org.mixly.util.SvgPngConverterUtil;
import org.mixly.util.SystemUtils;
import org.mixly.util.WebUtils;
import processing.app.ArduinoHelper;

public class Browser_new
extends Region {
    static SerialPort serialPortCom;
    private static double progressSize;
    private static boolean shouldSaveConfig;
    private boolean isalive = true;
    private static boolean compileSuccess;
    private static boolean uploadSuccess;
    public static String xmlFileName;
    private static String imgFileName;
    private static Boolean cleared;
    public static SerialPortDialog portDialog;
    public static LibManagerDialog libmanagerDialog;
    public static UnSaveWarningDialog unSaveWarningDialog;
    public static UserAgreementDialog userAgreementDialog;
    private StateDialog sd;
    private HardWareTestDialog2 hardwareDialog;
    private static double fontSize;
    private static String curCom;
    private static ArrayList<String> otherBoardList;
    static String[] pre;
    static String[] cur;
    private static boolean isPreNotArduinoStatus;
    public static boolean isFirstTimeLoad;
    private static boolean isOpenBoard;
    private static boolean isFromSelectBoard;
    private static String changedBoardXml;
    public static boolean cmdIsKilled;
    static Process process;
    public static String MIXLY_URL;
    public static String MICROBIT_JS;
    public static String MICROBIT_PY;
    public static String MIXPY;
    public static String MICROPYTHON_ESP32;
    public static String MICROBIT_PY_HEX_PATH;
    public ReadWriteUart readWriteUart = null;
    public Queue<String> readWriteQueue = new LinkedList<String>();
    public Esp32Uploader esp32Uploader = null;
    private SplitPane sp = new SplitPane();
    private StackPane sp1 = new StackPane();
    private StackPane sp2 = new StackPane();
    private VBox below = new VBox();
    private HBox toolBar;
    static Button btn_hardware_test;
    static Button clear;
    static Button save1;
    static Button save2;
    static Button load;
    static Button exportlib;
    static Button importlib;
    static Button managerlib;
    static Button saveBlocksImgBtn;
    static Button openSerialPort;
    static final Slider slider;
    static Button compile;
    static Button upload;
    static ComboBox boardsComboBox;
    static ComboBox<String> comboBox;
    static final ProgressIndicator progress;
    static final ProgressIndicator progress2;
    static final TextArea output_text;
    static final WebView browser;
    static final WebEngine webEngine;
    private static int sumCmd;
    private static String arduinoWebPath;
    public static String arduinoPath;
    private static String projectPath;
    private static String releasePath;
    private static String arduino_complie;
    private static String arduino_save;
    private static String arduino_upload;
    private static String arduino_builder;
    private static String microbit_js_cmd;
    private static String micropython_esp32_burn_cmd;
    private static String micropython_esp32_upload_cmd;
    private static String serialPort;
    public static String config;
    private Stage stage;
    private static String version;
    private static PrintStream defaultOut;
    private static PrintStream defaultErr;
    static LinkedBlockingQueue<Text> textQueue;
    static AtomicInteger textAreaRunnableState;
    static Runnable textAreaRunnable;

    static {
        progressSize = 20.0;
        shouldSaveConfig = true;
        compileSuccess = true;
        uploadSuccess = true;
        xmlFileName = null;
        imgFileName = null;
        cleared = false;
        portDialog = new SerialPortDialog();
        libmanagerDialog = new LibManagerDialog();
        unSaveWarningDialog = new UnSaveWarningDialog();
        userAgreementDialog = new UserAgreementDialog();
        fontSize = 13.0;
        curCom = null;
        otherBoardList = new ArrayList();
        pre = null;
        cur = null;
        isPreNotArduinoStatus = false;
        isFirstTimeLoad = true;
        isOpenBoard = false;
        isFromSelectBoard = false;
        changedBoardXml = "";
        cmdIsKilled = false;
        MIXLY_URL = "http://go.mixly.org:8081/api/receiver";
        MICROBIT_JS = "microbit[js]";
        MICROBIT_PY = "microbit[py]";
        MIXPY = "mixpy";
        MICROPYTHON_ESP32 = "MicroPython[ESP32]";
        MICROBIT_PY_HEX_PATH = "microbitBuild/built/binary_py.hex";
        btn_hardware_test = new Button();
        clear = new Button(LanguageProvider.getLocalString("new"));
        save1 = new Button(LanguageProvider.getLocalString("save"));
        save2 = new Button(LanguageProvider.getLocalString("save_as"));
        load = new Button(LanguageProvider.getLocalString("open"));
        exportlib = new Button(LanguageProvider.getLocalString("export"));
        importlib = new Button(LanguageProvider.getLocalString("import"));
        managerlib = new Button(LanguageProvider.getLocalString("manager"));
        saveBlocksImgBtn = new Button(LanguageProvider.getLocalString("saveBlocksImg"));
        openSerialPort = new Button(LanguageProvider.getLocalString("port_monitor"));
        slider = new Slider();
        compile = new Button(LanguageProvider.getLocalString("compile"));
        upload = new Button(LanguageProvider.getLocalString("upload"));
        boardsComboBox = new ComboBox();
        comboBox = new ComboBox();
        progress = new ProgressIndicator();
        progress2 = new ProgressIndicator();
        output_text = new TextArea();
        browser = new WebView();
        webEngine = browser.getEngine();
        sumCmd = 1;
        config = "setting/config.properties";
        version = "";
        textQueue = new LinkedBlockingQueue();
        textAreaRunnableState = new AtomicInteger();
        textAreaRunnable = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    Browser_new.updateTextArea0();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        };
    }

    public void setIsalive(boolean isalive) {
        this.isalive = isalive;
    }

    private void setButtonDisable(final Boolean state) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                clear.setDisable(state);
                save1.setDisable(state);
                save2.setDisable(state);
                load.setDisable(state);
                exportlib.setDisable(state);
                importlib.setDisable(state);
                managerlib.setDisable(state);
                saveBlocksImgBtn.setDisable(state);
                openSerialPort.setDisable(state);
                compile.setDisable(state);
                upload.setDisable(state);
                boardsComboBox.setDisable(state);
                comboBox.setDisable(state);
                btn_hardware_test.setDisable(state);
            }
        });
    }

    public static void setUploadDisable(Boolean state) {
        upload.setDisable(state);
    }

    public static void setHardWareTestDisable(Boolean state) {
        btn_hardware_test.setDisable(state);
    }

    public static void openMixlyFile(File xmlFile) {
        String result = Browser_new.translateQuote(MyMethod.readXml(xmlFile), false);
        String boardName = MyMethod.readBoardNameFromXml(xmlFile);
        if (xmlFile.getAbsolutePath().endsWith("mil")) {
            result = result.substring(17);
        }
        if (result != null) {
            try {
                String tmp = result;
                try {
                    isOpenBoard = true;
                    changedBoardXml = tmp;
                    if (!Browser_new.getCurrentBoard().equals(boardName) && (Browser_new.isNotArduino(boardName) || isPreNotArduinoStatus)) {
                        boardsComboBox.setValue(boardName);
                    } else {
                        String boardWebName;
                        if (Browser_new.isNotArduinoForCurrentBoard()) {
                            boardWebName = String.valueOf(MyMethod.getProp(config, "otherBoardsPrefix").trim()) + boardName + ".html";
                            boardWebName = Browser_new.makeBoardViewPath(boardWebName, xmlFileName, false);
                        } else {
                            boardWebName = arduinoWebPath.substring(arduinoWebPath.lastIndexOf("/") + 1);
                            boardWebName = Browser_new.makeBoardViewPath(boardWebName, xmlFileName, true);
                        }
                        webEngine.executeScript("window.location.href = '" + boardWebName + "';" + "Blockly.mainWorkspace.clear();");
                        if (boardName != null && !boardName.equals("") && !boardName.equals("mylib")) {
                            boardsComboBox.setValue(boardName);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Browser_new(final Stage stage) {
        this.stage = stage;
        Browser_new.init();
        this.initToolBar();
        this.setToolTips();
        this.setStyle();
        if (!new File(System.getProperty("user.home"), ".Mixly").exists()) {
            new File(System.getProperty("user.home"), ".Mixly").mkdir();
        }
        browser.setContextMenuEnabled(false);
        String configBoard = MyMethod.getProp(config, "currentBoard").trim();
        webEngine.load(Browser_new.makeBoardIndexPath(configBoard));
        this.below.getChildren().addAll((Node[])new Node[]{this.toolBar, output_text});
        this.sp1.getChildren().addAll((Node[])new Node[]{browser});
        this.sp2.getChildren().addAll((Node[])new Node[]{this.below});
        this.sp.setOrientation(Orientation.VERTICAL);
        this.sp.getItems().addAll((Node[])new Node[]{this.sp1, this.sp2});
        this.sp.setDividerPositions(0.82);
        this.getChildren().add(this.sp);
        final JSFuncs jsi = new JSFuncs();
        webEngine.getLoadWorker().stateProperty().addListener(new ChangeListener<Worker.State>(){

            @Override
            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    JSObject win = (JSObject)webEngine.executeScript("window");
                    win.setMember("JSFuncs", jsi);
                    try {
                        if (!cleared.booleanValue()) {
                            try {
                                if (xmlFileName == null) {
                                    webEngine.executeScript("clear_blocks_from_storage();");
                                }
                                webEngine.executeScript("Blockly.mainWorkspace.clear();renderContent();");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            cleared = true;
                        }
                        if (!Browser_new.isNotArduinoForCurrentBoard()) {
                            Browser_new.this.setInterruptByBoard(boardsComboBox.getSelectionModel().getSelectedItem().toString());
                        }
                        if (isOpenBoard) {
                            isOpenBoard = false;
                            webEngine.executeScript("var xml = Blockly.Xml.textToDom(\"" + changedBoardXml + "\");");
                            webEngine.executeScript("Blockly.mainWorkspace.clear();");
                            webEngine.executeScript("Blockly.Xml.domToWorkspace(Blockly.mainWorkspace, xml);");
                            webEngine.executeScript("renderContent();");
                            if (xmlFileName != null) {
                                stage.setTitle(String.valueOf(Browser_new.getMyTitle()) + "(" + xmlFileName + ")");
                            }
                        } else if (isFromSelectBoard || isFirstTimeLoad && xmlFileName == null) {
                            xmlFileName = null;
                            stage.setTitle(Browser_new.getMyTitle());
                        }
                        if (xmlFileName != null && isFirstTimeLoad) {
                            stage.setTitle(String.valueOf(Browser_new.getMyTitle()) + "(" + xmlFileName + ")");
                            Browser_new.openMixlyFile(new File(xmlFileName));
                        }
                        isFromSelectBoard = false;
                        isFirstTimeLoad = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    String analytics = WebUtils.getAnalytics();
                    if (analytics != null && !analytics.isEmpty()) {
                        try {
                            webEngine.executeScript(analytics);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    String lang = (String)webEngine.executeScript("Code.getLang();");
                    MyMethod.changeSettingProperties(config, "language", lang);
                    Browser_new.this.changeUILanguage(lang);
                }
            }
        });
    }

    public void changeUILanguage(String lang) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                clear.setText(LanguageProvider.getLocalString("new"));
                save1.setText(LanguageProvider.getLocalString("save"));
                save2.setText(LanguageProvider.getLocalString("save_as"));
                load.setText(LanguageProvider.getLocalString("open"));
                exportlib.setText(LanguageProvider.getLocalString("export"));
                importlib.setText(LanguageProvider.getLocalString("import"));
                managerlib.setText(LanguageProvider.getLocalString("manager"));
                saveBlocksImgBtn.setText(LanguageProvider.getLocalString("saveBlocksImg"));
                openSerialPort.setText(LanguageProvider.getLocalString("port_monitor"));
                if (Browser_new.getCurrentBoard().equals(MIXPY)) {
                    compile.setText(LanguageProvider.getLocalString("runpy"));
                    upload.setText(LanguageProvider.getLocalString("killpy"));
                    Browser_new.setHardWareTestDisable(true);
                } else if (Browser_new.getCurrentBoard().equals(MICROPYTHON_ESP32)) {
                    compile.setText(LanguageProvider.getLocalString("burnFirmware"));
                    upload.setText(LanguageProvider.getLocalString("upload"));
                    Browser_new.setHardWareTestDisable(true);
                } else {
                    compile.setText(LanguageProvider.getLocalString("compile"));
                    upload.setText(LanguageProvider.getLocalString("upload"));
                    Browser_new.setHardWareTestDisable(false);
                }
                Browser_new.this.setToolTips();
                libmanagerDialog = new LibManagerDialog();
                portDialog = new SerialPortDialog();
                unSaveWarningDialog = new UnSaveWarningDialog();
            }
        });
    }

    private void setToolTips() {
        slider.setTooltip(new Tooltip(LanguageProvider.getLocalString("sliderTooltip")));
        btn_hardware_test.setTooltip(new Tooltip(LanguageProvider.getLocalString("hardwaraTestTooltip")));
    }

    private void setStyle() {
        progress.setVisible(false);
        progress.setStyle("-fx-accent: red;");
        progress.setPrefSize(progressSize, progressSize);
        progress2.setVisible(false);
        progress2.setStyle("-fx-accent: red;");
        progress2.setPrefSize(progressSize, progressSize);
        clear.setFont(new Font(fontSize));
        save1.setFont(new Font(fontSize));
        save2.setFont(new Font(fontSize));
        load.setFont(new Font(fontSize));
        importlib.setFont(new Font(fontSize));
        exportlib.setFont(new Font(fontSize));
        managerlib.setFont(new Font(fontSize));
        saveBlocksImgBtn.setFont(new Font(fontSize));
        compile.setFont(new Font(fontSize));
        upload.setFont(new Font(fontSize));
        openSerialPort.setFont(new Font(fontSize));
        double minwidth = 55.0;
        clear.setMinWidth(minwidth);
        save1.setMinWidth(minwidth);
        save2.setMinWidth(minwidth);
        load.setMinWidth(minwidth);
        importlib.setMinWidth(minwidth);
        exportlib.setMinWidth(minwidth);
        managerlib.setMinWidth(minwidth);
        saveBlocksImgBtn.setMinWidth(minwidth);
        compile.setMinWidth(minwidth);
        upload.setMinWidth(minwidth);
        openSerialPort.setMinWidth(minwidth);
        clear.setPadding(new Insets(8.0, 5.0, 8.0, 5.0));
        save1.setPadding(new Insets(8.0, 5.0, 8.0, 5.0));
        save2.setPadding(new Insets(8.0, 5.0, 8.0, 5.0));
        load.setPadding(new Insets(8.0, 5.0, 8.0, 5.0));
        importlib.setPadding(new Insets(8.0, 5.0, 8.0, 5.0));
        exportlib.setPadding(new Insets(8.0, 5.0, 8.0, 5.0));
        managerlib.setPadding(new Insets(8.0, 5.0, 8.0, 5.0));
        saveBlocksImgBtn.setPadding(new Insets(8.0, 5.0, 8.0, 5.0));
        compile.setPadding(new Insets(8.0, 5.0, 8.0, 5.0));
        upload.setPadding(new Insets(8.0, 5.0, 8.0, 5.0));
        openSerialPort.setPadding(new Insets(8.0, 5.0, 8.0, 5.0));
        final Background bg = new Background(new BackgroundFill(Color.rgb(153, 153, 153, 1.0), new CornerRadii(0.0), null));
        final Background bg_dark_gray = new Background(new BackgroundFill(Color.rgb(100, 100, 100, 1.0), new CornerRadii(0.0), null));
        Background bg_gray = new Background(new BackgroundFill(Color.rgb(200, 200, 200, 1.0), new CornerRadii(6.0), null));
        this.toolBar.setPadding(new Insets(0.0));
        this.toolBar.setBackground(bg);
        clear.setBackground(bg);
        save1.setBackground(bg);
        save2.setBackground(bg);
        load.setBackground(bg);
        exportlib.setBackground(bg);
        importlib.setBackground(bg);
        managerlib.setBackground(bg);
        saveBlocksImgBtn.setBackground(bg);
        compile.setBackground(bg);
        upload.setBackground(bg);
        openSerialPort.setBackground(bg);
        boardsComboBox.setBackground(bg_gray);
        comboBox.setBackground(bg_gray);
        clear.setTextFill(Color.WHITE);
        save1.setTextFill(Color.WHITE);
        save2.setTextFill(Color.WHITE);
        load.setTextFill(Color.WHITE);
        importlib.setTextFill(Color.WHITE);
        exportlib.setTextFill(Color.WHITE);
        managerlib.setTextFill(Color.WHITE);
        saveBlocksImgBtn.setTextFill(Color.WHITE);
        compile.setTextFill(Color.WHITE);
        upload.setTextFill(Color.WHITE);
        openSerialPort.setTextFill(Color.WHITE);
        Image image = new Image("hardware.png", 23.0, 23.0, false, false);
        ImageView imageview = new ImageView(image);
        btn_hardware_test.setGraphic(imageview);
        btn_hardware_test.setBackground(bg);
        btn_hardware_test.setPadding(new Insets(4.0, 5.0, 4.0, 5.0));
        final DropShadow shadow = new DropShadow();
        clear.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                clear.setBackground(bg_dark_gray);
            }
        });
        save1.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                save1.setBackground(bg_dark_gray);
            }
        });
        save2.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                save2.setBackground(bg_dark_gray);
            }
        });
        load.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                load.setBackground(bg_dark_gray);
            }
        });
        exportlib.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                exportlib.setBackground(bg_dark_gray);
            }
        });
        importlib.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                importlib.setBackground(bg_dark_gray);
            }
        });
        managerlib.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                managerlib.setBackground(bg_dark_gray);
            }
        });
        saveBlocksImgBtn.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                saveBlocksImgBtn.setBackground(bg_dark_gray);
            }
        });
        compile.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                compile.setBackground(bg_dark_gray);
            }
        });
        upload.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                upload.setBackground(bg_dark_gray);
            }
        });
        openSerialPort.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                openSerialPort.setBackground(bg_dark_gray);
            }
        });
        btn_hardware_test.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                btn_hardware_test.setBackground(bg_dark_gray);
            }
        });
        boardsComboBox.addEventHandler(MouseEvent.MOUSE_ENTERED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                boardsComboBox.setEffect(shadow);
            }
        });
        comboBox.addEventHandler(MouseEvent.MOUSE_ENTERED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                comboBox.setEffect(shadow);
            }
        });
        clear.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                clear.setBackground(bg);
            }
        });
        save1.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                save1.setBackground(bg);
            }
        });
        save2.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                save2.setBackground(bg);
            }
        });
        load.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                load.setBackground(bg);
            }
        });
        exportlib.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                exportlib.setBackground(bg);
            }
        });
        importlib.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                importlib.setBackground(bg);
            }
        });
        managerlib.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                managerlib.setBackground(bg);
            }
        });
        saveBlocksImgBtn.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                saveBlocksImgBtn.setBackground(bg);
            }
        });
        compile.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                compile.setBackground(bg);
            }
        });
        upload.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                upload.setBackground(bg);
            }
        });
        openSerialPort.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                openSerialPort.setBackground(bg);
            }
        });
        btn_hardware_test.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                btn_hardware_test.setBackground(bg);
            }
        });
        boardsComboBox.addEventHandler(MouseEvent.MOUSE_EXITED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                boardsComboBox.setEffect(null);
            }
        });
        comboBox.addEventHandler(MouseEvent.MOUSE_EXITED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                comboBox.setEffect(null);
            }
        });
    }

    private void initToolBar() {
        this.toolBar = new HBox();
        this.toolBar.setAlignment(Pos.CENTER);
        this.toolBar.getChildren().add(clear);
        this.toolBar.getChildren().add(this.createSpacer(1.0));
        this.toolBar.getChildren().add(load);
        this.toolBar.getChildren().add(this.createSpacer(1.0));
        this.toolBar.getChildren().add(save1);
        this.toolBar.getChildren().add(this.createSpacer(1.0));
        this.toolBar.getChildren().add(save2);
        this.toolBar.getChildren().add(this.createSpacer(1.0));
        this.toolBar.getChildren().add(exportlib);
        this.toolBar.getChildren().add(this.createSpacer(1.0));
        this.toolBar.getChildren().add(importlib);
        this.toolBar.getChildren().add(this.createSpacer(1.0));
        this.toolBar.getChildren().add(managerlib);
        this.toolBar.getChildren().add(this.createSpacer(1.0));
        slider.setMin(50.0);
        slider.setMax(150.0);
        slider.setValue(100.0);
        slider.setPrefWidth(80.0);
        slider.setOrientation(Orientation.HORIZONTAL);
        this.toolBar.getChildren().add(this.createSpacer2());
        this.toolBar.getChildren().add(progress);
        this.toolBar.getChildren().add(this.createSpacer3(5.0));
        this.toolBar.getChildren().add(this.createSpacer(1.0));
        this.toolBar.getChildren().add(compile);
        this.toolBar.getChildren().add(this.createSpacer(1.0));
        this.toolBar.getChildren().add(this.createSpacer3(5.0));
        this.toolBar.getChildren().add(progress2);
        this.toolBar.getChildren().add(this.createSpacer3(5.0));
        this.toolBar.getChildren().add(this.createSpacer(1.0));
        this.toolBar.getChildren().add(upload);
        this.toolBar.getChildren().add(this.createSpacer(1.0));
        List<String> boardList = null;
        arduinoPath = MyMethod.getProp(config, "arduinoPath");
        if (arduinoPath.contains(".app")) {
            String tmp = String.valueOf(arduinoPath.substring(0, arduinoPath.indexOf(".app") + 4)) + "/Contents/Java/";
            boardList = MyMethod.getBoardsList(String.valueOf(tmp) + "hardware/");
        } else {
            boardList = MyMethod.getBoardsList(String.valueOf(arduinoPath) + "hardware/");
        }
        ArrayList<String> arduinoBoardList = ArduinoHelper.rebuildBoardList();
        boardsComboBox.getItems().addAll(arduinoBoardList);
        otherBoardList = Browser_new.getNotArduinoBoardList();
        boardsComboBox.getItems().addAll(otherBoardList);
        boardsComboBox.setPrefWidth(200.0);
        String currentBoard = MyMethod.getProp(config, "currentBoard").trim();
        if (currentBoard == null || currentBoard.equals("") || !boardsComboBox.getItems().contains(currentBoard)) {
            boardsComboBox.getSelectionModel().selectFirst();
        } else {
            boardsComboBox.setValue(currentBoard);
        }
        isPreNotArduinoStatus = Browser_new.isNotArduinoForCurrentBoard();
        boardsComboBox.setOnAction((EventHandler<ActionEvent>)new EventHandler<Event>(){

            @Override
            public void handle(Event arg0) {
                try {
                    Browser_new.this.saveCurrentBoard();
                    String board = boardsComboBox.getSelectionModel().getSelectedItem().toString();
                    String boardWebName = arduinoWebPath.substring(arduinoWebPath.lastIndexOf("/") + 1);
                    if (Browser_new.isNotArduinoForCurrentBoard()) {
                        boardWebName = String.valueOf(MyMethod.getProp(config, "otherBoardsPrefix").trim()) + board + ".html";
                        if (isOpenBoard) {
                            boardWebName = Browser_new.makeBoardViewPath(boardWebName, xmlFileName, false);
                        }
                        webEngine.executeScript("window.location.href = '" + boardWebName + "';" + "Blockly.mainWorkspace.clear();");
                        isPreNotArduinoStatus = true;
                    } else {
                        if (isPreNotArduinoStatus) {
                            if (isOpenBoard) {
                                boardWebName = Browser_new.makeBoardViewPath(boardWebName, xmlFileName, true);
                            }
                            webEngine.executeScript("window.location.href = '" + boardWebName + "';" + "Blockly.mainWorkspace.clear();");
                        }
                        isPreNotArduinoStatus = false;
                        Browser_new.this.setInterruptByBoard(board);
                    }
                    if ((board.equals(MICROBIT_JS) || board.equals(MICROBIT_PY)) && !MyMethod.compareStrArray(pre, cur = SerialPortList.getPortNames())) {
                        Browser_new.setCom(cur);
                        pre = cur;
                    }
                    if (board.equals(MIXPY)) {
                        btn_hardware_test.setDisable(true);
                        compile.setText(LanguageProvider.getLocalString("runpy"));
                        upload.setText(LanguageProvider.getLocalString("killpy"));
                    } else {
                        btn_hardware_test.setDisable(false);
                        compile.setText(LanguageProvider.getLocalString("compile"));
                        upload.setText(LanguageProvider.getLocalString("upload"));
                    }
                    isFromSelectBoard = true;
                    try {
                        serialPortCom.closePort();
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.toolBar.getChildren().add(this.createSpacer3(10.0));
        this.toolBar.getChildren().add(boardsComboBox);
        this.toolBar.getChildren().add(this.createSpacer3(10.0));
        this.toolBar.getChildren().add(comboBox);
        cur = SerialPortList.getPortNames();
        if (!MyMethod.compareStrArray(pre, cur)) {
            Browser_new.setCom(cur);
            pre = cur;
        }
        this.toolBar.getChildren().add(this.createSpacer3(10.0));
        this.toolBar.getChildren().add(this.createSpacer(1.0));
        this.toolBar.getChildren().add(openSerialPort);
        this.toolBar.getChildren().add(this.createSpacer(1.0));
        this.toolBar.getChildren().add(btn_hardware_test);
        this.toolBar.getChildren().add(slider);
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (Browser_new.this.isalive) {
                    if (!((Browser_new.getCurrentBoard().equals(MICROBIT_JS) || Browser_new.getCurrentBoard().equals(MICROBIT_PY)) && SystemUtils.IS_OS_MAC || MyMethod.compareStrArray(pre, cur = MyCom.getSerialNames()))) {
                        Browser_new.setCom(cur);
                        pre = cur;
                    }
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
        slider.valueProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> ov, Number old_val, Number new_val) {
                float value = new_val.floatValue();
                browser.setZoom(value / 100.0f);
            }
        });
        openSerialPort.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                String titile;
                try {
                    if (serialPortCom != null && serialPortCom.isOpened()) {
                        serialPortCom.closePort();
                    }
                }
                catch (SerialPortException e) {
                    e.printStackTrace();
                }
                if ((titile = ((String)comboBox.getValue()).toString()) != null && !titile.equals("")) {
                    portDialog.setTitle(titile);
                    SerialPortDialog.textArea.setText("");
                    SerialPortDialog.com = titile;
                    portDialog.setLocationRelativeTo(null);
                    portDialog.setVisible(true);
                    portDialog.toFront();
                    if (!Browser_new.getCurrentBoard().equals(MIXPY)) {
                        Browser_new.setUploadDisable(true);
                    }
                    Browser_new.setHardWareTestDisable(true);
                    if (SerialPortDialog.serialPortCom != null && SerialPortDialog.serialPortCom.isOpened()) {
                        try {
                            SerialPortDialog.serialPortCom.closePort();
                        }
                        catch (SerialPortException e) {
                            e.printStackTrace();
                        }
                        SerialPortDialog.serialPortCom = null;
                    }
                    SerialPortDialog.resetSerial();
                } else {
                    Browser_new.updateTextArea(LanguageProvider.getLocalString("noPortAvailable"));
                }
            }
        });
        compile.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                if (Browser_new.getCurrentBoard().equals(MIXPY)) {
                    webEngine.executeScript("pyengine.run();");
                    return;
                }
                if (Browser_new.getCurrentBoard().equals(MICROPYTHON_ESP32)) {
                    Browser_new.this.sd = new StateDialog(Browser_new.this.stage, LanguageProvider.getLocalString("burning"));
                } else {
                    Browser_new.this.sd = new StateDialog(Browser_new.this.stage, LanguageProvider.getLocalString("msg_compiling"));
                }
                cmdIsKilled = false;
                Browser_new.this.doCompile();
            }
        });
        upload.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                String currBoard = Browser_new.getCurrentBoard();
                if (currBoard.equals(MIXPY)) {
                    webEngine.executeScript("pyengine.kill();");
                    return;
                }
                if (!currBoard.equals(MICROBIT_JS) && !currBoard.equals(MICROBIT_PY) && !currBoard.equals(MIXPY) && ((String)comboBox.getValue()).trim().equals("")) {
                    Browser_new.updateTextArea(LanguageProvider.getLocalString("noPortAvailable"));
                    return;
                }
                if (!currBoard.equals(MICROPYTHON_ESP32)) {
                    Browser_new.this.sd = new StateDialog(Browser_new.this.stage, LanguageProvider.getLocalString("msg_uploading"));
                    cmdIsKilled = false;
                }
                Browser_new.this.doUpLoad();
            }
        });
        clear.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                if (Browser_new.isXmlSaved()) {
                    webEngine.executeScript("Blockly.mainWorkspace.clear();renderContent();");
                    xmlFileName = null;
                    Browser_new.this.stage.setTitle(Browser_new.getMyTitle());
                } else {
                    unSaveWarningDialog.setYesOrNo(false);
                    unSaveWarningDialog.setLocationRelativeTo(null);
                    unSaveWarningDialog.setVisible(true);
                    unSaveWarningDialog.toFront();
                    new Thread(){

                        @Override
                        public void run() {
                            while (unSaveWarningDialog.isVisible()) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (unSaveWarningDialog.isYesOrNo()) {
                                Platform.runLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        webEngine.executeScript("Blockly.mainWorkspace.clear();renderContent();");
                                        xmlFileName = null;
                                        Browser_new.this.stage.setTitle(Browser_new.getMyTitle());
                                    }
                                });
                            }
                        }
                    }.start();
                }
            }
        });
        save1.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                String currentBoard = boardsComboBox.getSelectionModel().getSelectedItem().toString();
                String xml = (String)webEngine.executeScript("goog.string.quote(Blockly.Xml.domToText(Blockly.Xml.workspaceToDom(Blockly.mainWorkspace)))");
                String version = MyMethod.getProp(config, "version");
                xml = xml.replaceFirst("<xml", "<xml version=\\\\\"" + version + "\\\\\" board=\\\\\"" + currentBoard + "\\\\\"");
                xml = xml.substring(1, xml.length() - 1);
                if (xmlFileName == null) {
                    FileChooser fd = new FileChooser();
                    fd.setInitialFileName("mixly.mix");
                    fd.setTitle(LanguageProvider.getLocalString("saveAsMixFile"));
                    if (xmlFileName != null) {
                        File defaultPath = new File(xmlFileName).getParentFile().getAbsoluteFile();
                        fd.setInitialDirectory(defaultPath);
                    }
                    fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("Mixly File", "*.mix"));
                    File xmlFile = fd.showSaveDialog(Browser_new.this.stage);
                    if (xmlFile != null) {
                        String filePath = xmlFile.getAbsolutePath();
                        if (!filePath.endsWith(".mix") && !filePath.endsWith(".MIX")) {
                            filePath = String.valueOf(filePath) + ".mix";
                        }
                        MyMethod.saveXML(xml, filePath);
                        xmlFileName = filePath;
                        Browser_new.this.stage.setTitle(String.valueOf(Browser_new.getMyTitle()) + "(" + xmlFileName + ")");
                    }
                } else {
                    MyMethod.saveXML(xml, xmlFileName);
                }
            }
        });
        save2.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                String currentBoard = boardsComboBox.getSelectionModel().getSelectedItem().toString();
                String xml = (String)webEngine.executeScript("goog.string.quote(Blockly.Xml.domToText(Blockly.Xml.workspaceToDom(Blockly.mainWorkspace)))");
                String version = MyMethod.getProp(config, "version");
                xml = xml.replaceFirst("<xml", "<xml version=\\\\\"" + version + "\\\\\" board=\\\\\"" + currentBoard + "\\\\\"");
                xml = xml.substring(1, xml.length() - 1);
                FileChooser fd = new FileChooser();
                fd.setInitialFileName("mixly.mix");
                fd.setTitle(LanguageProvider.getLocalString("saveAsMixFile"));
                if (xmlFileName != null) {
                    File defaultPath = new File(xmlFileName).getParentFile().getAbsoluteFile();
                    fd.setInitialDirectory(defaultPath);
                }
                fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("Mixly File", "*.mix"));
                if (Browser_new.isNotArduinoForCurrentBoard()) {
                    String currBoard = Browser_new.getCurrentBoard();
                    if (currBoard.equals(MICROBIT_JS)) {
                        fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("TypeScript File", "*.ts"));
                    } else if (currBoard.equals(MICROBIT_PY) || currBoard.equals(MIXPY) || currBoard.equals(MICROPYTHON_ESP32)) {
                        fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("Python File", "*.py"));
                    }
                } else {
                    fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("Arduino File", "*.ino"));
                }
                File xmlFile = fd.showSaveDialog(Browser_new.this.stage);
                if (xmlFile != null) {
                    String filePath = xmlFile.getAbsolutePath();
                    if (filePath.endsWith(".ino") || filePath.endsWith(".INO")) {
                        String ino = (String)webEngine.executeScript("Blockly.Arduino.workspaceToCode()");
                        MyMethod.saveINO(ino, filePath);
                    } else if (filePath.endsWith(".ts")) {
                        String ts = (String)webEngine.executeScript("Blockly.JavaScript.workspaceToCode()");
                        MyMethod.saveINO(ts, filePath);
                    } else if (filePath.endsWith(".py")) {
                        String py = (String)webEngine.executeScript("Blockly.Python.workspaceToCode()");
                        MyMethod.saveINO(py, filePath);
                    } else {
                        if (!filePath.endsWith(".mix") && !filePath.endsWith(".MIX")) {
                            filePath = String.valueOf(filePath) + ".mix";
                        }
                        MyMethod.saveXML(xml, filePath);
                        xmlFileName = filePath;
                        Browser_new.this.stage.setTitle(String.valueOf(Browser_new.getMyTitle()) + "(" + xmlFileName + ")");
                    }
                }
            }
        });
        load.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                File defaultPath;
                FileChooser fd = new FileChooser();
                fd.setTitle(LanguageProvider.getLocalString("openFile"));
                if (xmlFileName != null) {
                    defaultPath = new File(xmlFileName).getParentFile().getAbsoluteFile();
                    fd.setInitialDirectory(defaultPath);
                } else {
                    defaultPath = new File("sample");
                    if (!defaultPath.exists() && !defaultPath.isDirectory()) {
                        defaultPath.mkdir();
                    }
                    fd.setInitialDirectory(defaultPath);
                }
                fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("xml/mix File", "*.xml", "*.mix"));
                File xmlFile = fd.showOpenDialog(Browser_new.this.stage);
                if (xmlFile != null) {
                    xmlFileName = xmlFile.getAbsolutePath();
                    Browser_new.this.stage.setTitle(String.valueOf(Browser_new.getMyTitle()) + "(" + xmlFileName + ")");
                    Browser_new.openMixlyFile(xmlFile);
                }
            }
        });
        exportlib.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                String xml = (String)webEngine.executeScript("goog.string.quote(Blockly.Xml.domToText(Blockly.Xml.workspaceToDom(Blockly.mainWorkspace)))");
                xml = xml.substring(1, xml.length() - 1);
                xml = Browser_new.translateQuote(xml, true);
                xml = xml.replaceAll("'", "\\\\'").replaceFirst("<xml", "<xml board=\"mylib\"");
                FileChooser fd = new FileChooser();
                fd.setInitialFileName(LanguageProvider.getLocalString("libraryName"));
                fd.setTitle(LanguageProvider.getLocalString("exportLibrary"));
                if (xmlFileName != null) {
                    File defaultPath = new File(xmlFileName).getParentFile().getAbsoluteFile();
                    fd.setInitialDirectory(defaultPath);
                }
                fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("mil Lib File", "*.mil"));
                final File xmlFile = fd.showSaveDialog(Browser_new.this.stage);
                if (xmlFile != null) {
                    final String name = xmlFile.getName();
                    String filePath = xmlFile.getAbsolutePath();
                    if (!filePath.endsWith(".mil") && !filePath.endsWith(".MIL")) {
                        filePath = String.valueOf(filePath) + ".mil";
                    }
                    final String tmpXml = xml;
                    final String tmpFilePath = filePath;
                    new Thread(){

                        @Override
                        public void run() {
                            String reg = "<block type=\"factory_include\"( x=\"\\d*\" y=\"\\d*\")?><field name=\"INCLUDE\">(.+?)</field";
                            Pattern p = Pattern.compile(reg);
                            Matcher m = p.matcher(tmpXml);
                            HashSet<String> include_set = new HashSet<String>();
                            String config_zhushi = "";
                            while (m.find()) {
                                String find = m.group(2);
                                include_set.add(find);
                                config_zhushi = String.valueOf(config_zhushi) + find + ";";
                            }
                            config_zhushi = "<!-- lib=\"" + config_zhushi + "\" -->";
                            Iterator iterator = include_set.iterator();
                            String desc = null;
                            while (iterator.hasNext()) {
                                String lib = String.valueOf((String)iterator.next()) + ".h";
                                desc = String.valueOf(xmlFile.getParent()) + "\\" + name.substring(0, name.length() - 4);
                                File f = new File(desc);
                                if (!f.exists()) {
                                    f.mkdir();
                                }
                                FileUtil.searchAndExport(lib, desc);
                            }
                            String tmpPath = desc == null ? tmpFilePath : String.valueOf(desc) + "\\" + name;
                            MyMethod.saveXML(String.valueOf(config_zhushi) + "\n" + tmpXml, tmpPath);
                            Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("exportSuccessfully")) + (desc == null ? tmpFilePath : desc));
                        }
                    }.start();
                }
            }
        });
        importlib.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                FileChooser fd = new FileChooser();
                fd.setTitle(LanguageProvider.getLocalString("importLibrary"));
                if (xmlFileName != null) {
                    File defaultPath = new File(xmlFileName).getParentFile().getAbsoluteFile();
                    fd.setInitialDirectory(defaultPath);
                }
                fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("xml/mil File", "*.xml", "*.mil"));
                File xmlFile = fd.showOpenDialog(Browser_new.this.stage);
                if (xmlFile != null) {
                    String result = MyMethod.readXml(xmlFile);
                    if (result.contains("board=\"mylib\"")) {
                        String oldPath = xmlFile.getAbsolutePath();
                        String newPath = "mylib/" + oldPath.substring(oldPath.lastIndexOf(System.getProperty("file.separator")) + 1);
                        if (Browser_new.isNotArduinoForCurrentBoard()) {
                            String otherBoardLibPath = "mylib/" + Browser_new.getCurrentBoard();
                            if (!new File(otherBoardLibPath).isDirectory()) {
                                FileUtil.createEmptyFolder(otherBoardLibPath);
                            }
                            newPath = String.valueOf(otherBoardLibPath) + "/" + oldPath.substring(oldPath.lastIndexOf(System.getProperty("file.separator")) + 1);
                        }
                        Pattern p3 = Pattern.compile("lib=\"(.*?)\"");
                        Matcher m3 = p3.matcher(result);
                        String str_lib = null;
                        if (m3.find()) {
                            str_lib = m3.group(1);
                        }
                        if (str_lib != null && !str_lib.equals("")) {
                            String[] lib_list = str_lib.split(";");
                            int i = 0;
                            while (i < lib_list.length) {
                                if (new File(String.valueOf(arduinoPath) + "libraries/" + lib_list[i]).exists()) {
                                    String file = String.valueOf(arduinoPath) + "libraries/" + lib_list[i];
                                    Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("tip")) + file + LanguageProvider.getLocalString("alreadyCovered"));
                                }
                                FileUtil.copyFolderTo(new File(String.valueOf(xmlFile.getParent()) + "/" + lib_list[i]), new File(String.valueOf(arduinoPath) + "libraries/" + lib_list[i]));
                                ++i;
                            }
                        }
                        if (MyMethod.saveXML(result, newPath)) {
                            MyMethod.setCustom();
                            webEngine.reload();
                            Browser_new.updateTextArea(LanguageProvider.getLocalString("importCustomLibrarySuccessfully"));
                        } else {
                            Browser_new.updateTextArea(LanguageProvider.getLocalString("importCustomLibraryFailed"));
                        }
                    } else if (result.contains("type=\"company\"")) {
                        String oldPath = xmlFile.getAbsolutePath();
                        String newPath = "company/" + oldPath.substring(oldPath.lastIndexOf(System.getProperty("file.separator")) + 1);
                        Pattern p1 = Pattern.compile("block=\"(.*?)\"");
                        Pattern p2 = Pattern.compile("generator=\"(.*?)\"");
                        Pattern p3 = Pattern.compile("lib=\"(.*?)\"");
                        Pattern p4 = Pattern.compile("hardware=\"(.*?)\"");
                        Pattern p5 = Pattern.compile("media=\"(.*?)\"");
                        Pattern p6 = Pattern.compile("language=\"(.*?)\"");
                        Pattern p7 = Pattern.compile("pin=\"(.*?)\"");
                        Matcher m1 = p1.matcher(result);
                        Matcher m2 = p2.matcher(result);
                        Matcher m3 = p3.matcher(result);
                        Matcher m4 = p4.matcher(result);
                        Matcher m5 = p5.matcher(result);
                        Matcher m6 = p6.matcher(result);
                        Matcher m7 = p7.matcher(result);
                        String str_block = null;
                        String str_generator = null;
                        String str_lib = null;
                        String str_hardware = null;
                        String str_media = null;
                        String str_lang = null;
                        String str_pin = null;
                        if (m1.find()) {
                            str_block = m1.group(1);
                        }
                        if (m2.find()) {
                            str_generator = m2.group(1);
                        }
                        if (m3.find()) {
                            str_lib = m3.group(1);
                        }
                        if (m4.find()) {
                            str_hardware = m4.group(1);
                        }
                        if (m5.find()) {
                            str_media = m5.group(1);
                        }
                        if (m6.find()) {
                            str_lang = m6.group(1);
                        }
                        if (m7.find()) {
                            str_pin = m7.group(1);
                        }
                        if (str_lib != null && !str_lib.equals("")) {
                            String[] lib_list = str_lib.split(";");
                            int i = 0;
                            while (i < lib_list.length) {
                                if (new File(String.valueOf(arduinoPath) + "libraries/" + lib_list[i]).exists()) {
                                    String file = String.valueOf(arduinoPath) + "libraries/" + lib_list[i];
                                    Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("tip")) + file + LanguageProvider.getLocalString("alreadyCovered"));
                                }
                                if (arduinoPath.contains(".app")) {
                                    String tmp = String.valueOf(arduinoPath.substring(0, arduinoPath.indexOf(".app") + 4)) + "/Contents/Java/";
                                    FileUtil.copyFolderTo(new File(String.valueOf(xmlFile.getParent()) + "/" + lib_list[i]), new File(String.valueOf(tmp) + "libraries/" + lib_list[i]));
                                } else {
                                    FileUtil.copyFolderTo(new File(String.valueOf(xmlFile.getParent()) + "/" + lib_list[i]), new File(String.valueOf(arduinoPath) + "libraries/" + lib_list[i]));
                                }
                                ++i;
                            }
                        }
                        if (str_hardware != null && !str_hardware.equals("") && str_hardware.startsWith("hardware")) {
                            if (arduinoPath.contains(".app")) {
                                String tmp = String.valueOf(arduinoPath.substring(0, arduinoPath.indexOf(".app") + 4)) + "/Contents/Java/";
                                FileUtil.copyFolderTo(new File(String.valueOf(xmlFile.getParent()) + "/" + str_hardware), new File(String.valueOf(tmp) + str_hardware));
                            } else {
                                FileUtil.copyFolderTo(new File(String.valueOf(xmlFile.getParent()) + "/" + str_hardware), new File(String.valueOf(arduinoPath) + str_hardware));
                            }
                            boardsComboBox.getItems().clear();
                            List<String> boardList = null;
                            if (arduinoPath.contains(".app")) {
                                String tmp = String.valueOf(arduinoPath.substring(0, arduinoPath.indexOf(".app") + 4)) + "/Contents/Java/";
                                boardList = MyMethod.getBoardsList(String.valueOf(tmp) + "hardware/");
                            } else {
                                boardList = MyMethod.getBoardsList(String.valueOf(arduinoPath) + "hardware/");
                            }
                            int i = 0;
                            while (i < boardList.size()) {
                                boardsComboBox.getItems().addAll(MyMethod.getBoards(boardList.get(i)));
                                ++i;
                            }
                            String currentBoard = MyMethod.getProp(config, "currentBoard").trim();
                            if (currentBoard == null || currentBoard.equals("") || !boardsComboBox.getItems().contains(currentBoard)) {
                                boardsComboBox.getSelectionModel().selectFirst();
                            } else {
                                boardsComboBox.setValue(currentBoard);
                            }
                        }
                        if (str_media != null && !str_media.equals("") && str_media.startsWith("media")) {
                            FileUtil.copyFolderTo(new File(String.valueOf(xmlFile.getParent()) + "/" + str_media), new File("blockly/" + str_media));
                        }
                        if (str_lang != null && !str_lang.equals("") && str_lang.startsWith("language")) {
                            FileUtil.copyFolderTo(new File(String.valueOf(xmlFile.getParent()) + "/" + str_lang), new File("blockly/msg/js/company/" + str_lang));
                            MyMethod.setCompanyLanguage();
                        }
                        if (str_block != null && !str_block.equals("") && str_block.startsWith("block")) {
                            String fixBlock = MyMethod.readFile(new File(xmlFile.getParent(), str_block)).replace("appendTitle", "appendField");
                            MyMethod.writeFile(fixBlock, "blockly/blocks/company/" + str_block.split("/")[1]);
                        }
                        if (str_generator != null && !str_generator.equals("") && str_generator.startsWith("generator")) {
                            String fixGenerator = MyMethod.readFile(new File(xmlFile.getParent(), str_generator)).replace("getTitleValue", "getFieldValue");
                            MyMethod.writeFile(fixGenerator, "blockly/generators/arduino/company/" + str_generator.split("/")[1]);
                        }
                        if (str_pin != null && !str_pin.equals("") && str_pin.startsWith("companypin")) {
                            FileUtil.copyFolderTo(new File(String.valueOf(xmlFile.getParent()) + "/" + str_pin), new File("blockly/apps/mixly/" + str_pin));
                            MyMethod.setCompanyPin();
                        }
                        if (MyMethod.saveXML(MyMethod.readFile(xmlFile), newPath)) {
                            MyMethod.setCustom();
                            webEngine.reload();
                            Browser_new.updateTextArea(LanguageProvider.getLocalString("importCustomLibrarySuccessfully"));
                        } else {
                            Browser_new.updateTextArea(LanguageProvider.getLocalString("importCustomLibraryFailed"));
                        }
                    } else {
                        Browser_new.updateTextArea(LanguageProvider.getLocalString("notALibraryFile"));
                    }
                }
            }
        });
        managerlib.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                libmanagerDialog.setLocationRelativeTo(null);
                libmanagerDialog.setVisible(true);
                libmanagerDialog.toFront();
            }
        });
        saveBlocksImgBtn.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                String base64Str = (String)webEngine.executeScript("saveBlocksImg();");
                System.out.println(base64Str);
                String initialFileName = "mixly_blocks.png";
                FileChooser fd = new FileChooser();
                if (imgFileName != null) {
                    File defaultPath = new File(imgFileName).getParentFile().getAbsoluteFile();
                    fd.setInitialDirectory(defaultPath);
                    initialFileName = imgFileName;
                }
                fd.setInitialFileName(initialFileName);
                fd.setTitle(LanguageProvider.getLocalString("saveBlocksImg"));
                fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("png", "*.png"));
                File chooseImgFile = fd.showSaveDialog(Browser_new.this.stage);
                if (chooseImgFile != null) {
                    String filePath = chooseImgFile.getAbsolutePath();
                    if (!filePath.endsWith(".png")) {
                        filePath = String.valueOf(filePath) + ".png";
                    }
                    try {
                        SvgPngConverterUtil.convertToPng(base64Str, filePath);
                    }
                    catch (IOException | TranscoderException e) {
                        e.printStackTrace();
                    }
                    imgFileName = filePath;
                    Browser_new.this.stage.setTitle(String.valueOf(Browser_new.getMyTitle()) + "(" + imgFileName + ")");
                }
            }
        });
        btn_hardware_test.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                if (((String)comboBox.getValue()).trim().equals("")) {
                    Browser_new.updateTextArea(LanguageProvider.getLocalString("noPortAvailable"));
                    return;
                }
                int analogNum = HardWareUtil.getNumOfAnalogPin(webEngine);
                int digitalNum = HardWareUtil.getNumOfDigitalPin(webEngine) - analogNum;
                String code = HardWareUtil.getHardWareTestCode(digitalNum, analogNum);
                MyMethod.saveYuanma(code, "testArduino/testArduino.ino");
                String board = boardsComboBox.getSelectionModel().getSelectedItem().toString();
                String com = ((String)comboBox.getSelectionModel().getSelectedItem()).toString();
                Browser_new.this.hardwareDialog = new HardWareTestDialog2(Browser_new.this.stage, String.valueOf(LanguageProvider.getLocalString("hardwaraTestTooltip")) + "(" + com + ")\uff1a" + board, digitalNum, analogNum, com);
                Browser_new.this.hardwareDialog.setMsg(LanguageProvider.getLocalString("uploadingHardwareTestProgram"));
                Browser_new.this.doUpLoadForHardWareTest();
            }
        });
        browser.setOnDragOver((EventHandler<? super DragEvent>)new EventHandler<DragEvent>(){

            @Override
            public void handle(DragEvent event) {
                Dragboard db = event.getDragboard();
                if (db.hasFiles()) {
                    event.acceptTransferModes(TransferMode.COPY);
                } else {
                    event.consume();
                }
            }
        });
        browser.setOnDragDropped((EventHandler<? super DragEvent>)new EventHandler<DragEvent>(){

            @Override
            public void handle(DragEvent event) {
                Dragboard db = event.getDragboard();
                boolean success = false;
                if (db.hasFiles()) {
                    success = true;
                    for (File file : db.getFiles()) {
                        if (file.getAbsolutePath().toLowerCase().indexOf("xml") <= -1 && file.getAbsolutePath().toLowerCase().indexOf("mil") <= -1 && file.getAbsolutePath().toLowerCase().indexOf("mix") <= -1) continue;
                        xmlFileName = file.getAbsolutePath();
                        Browser_new.this.stage.setTitle(String.valueOf(Browser_new.getMyTitle()) + "(" + xmlFileName + ")");
                        Browser_new.openMixlyFile(file);
                    }
                }
                event.setDropCompleted(success);
                event.consume();
            }
        });
    }

    private void doCompile() {
        try {
            String workspaceToCode = "Blockly.Arduino.workspaceToCode()";
            String currBoard = Browser_new.getCurrentBoard();
            if (currBoard.equals(MICROBIT_JS)) {
                workspaceToCode = "Blockly.JavaScript.workspaceToCode()";
            } else if (currBoard.equals(MICROBIT_PY)) {
                workspaceToCode = "Blockly.Python.workspaceToCode()";
                String hex = (String)webEngine.executeScript("doDownload()");
                MyMethod.writeFile(hex, "microbitBuild/built/binary_py.hex");
            } else if (currBoard.equals(MIXPY)) {
                workspaceToCode = "Blockly.Python.workspaceToCode()";
            } else if (currBoard.equals(MICROPYTHON_ESP32)) {
                workspaceToCode = "Blockly.Python.workspaceToCode()";
            }
            String yuanma = (String)webEngine.executeScript(workspaceToCode);
            if (((Boolean)webEngine.executeScript("document.getElementById('tab_arduino').className == 'tabon'")).booleanValue()) {
                yuanma = (String)webEngine.executeScript("editor.getValue();");
            }
            MyMethod.saveYuanma(yuanma);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    block12: {
                        Browser_new.setProgressBar(true, 1);
                        Browser_new.this.setButtonDisable(true);
                        try {
                            try {
                                compileSuccess = true;
                                Browser_new.compile();
                                if (cmdIsKilled) {
                                    if (Browser_new.getCurrentBoard().equals(MICROPYTHON_ESP32)) {
                                        Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("burnFirmware")) + LanguageProvider.getLocalString("canceled") + "\n");
                                    } else {
                                        Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("compile")) + LanguageProvider.getLocalString("canceled") + "\n");
                                    }
                                    break block12;
                                }
                                if (compileSuccess) {
                                    if (Browser_new.getCurrentBoard().equals(MICROPYTHON_ESP32)) {
                                        Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("burnSucc")) + "\n");
                                    } else {
                                        Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("compile_success")) + "\n");
                                    }
                                    break block12;
                                }
                                if (Browser_new.getCurrentBoard().equals(MICROPYTHON_ESP32)) {
                                    Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("burnFailed")) + "\n");
                                    break block12;
                                }
                                Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("compile_failed")) + "\n");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                Browser_new.setProgressBar(false, 1);
                                Browser_new.this.setButtonDisable(false);
                                Browser_new.this.sd.hide();
                            }
                        }
                        finally {
                            Browser_new.setProgressBar(false, 1);
                            Browser_new.this.setButtonDisable(false);
                            Browser_new.this.sd.hide();
                        }
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doUpLoad() {
        try {
            String workspaceToCode = "Blockly.Arduino.workspaceToCode()";
            String currBoard = Browser_new.getCurrentBoard();
            if (!MyMethod.getProp(config, "userAgreement").equals("0")) {
                String xml = (String)webEngine.executeScript("goog.string.quote(Blockly.Xml.domToText(Blockly.Xml.workspaceToDom(Blockly.mainWorkspace)))");
                String version = MyMethod.getProp(config, "version");
                xml = xml.replaceFirst("<xml", "<xml version=\\\\\"" + version + "\\\\\" board=\\\\\"" + currBoard + "\\\\\"");
                xml = xml.substring(1, xml.length() - 1);
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
                String now = df.format(new Date());
                InetAddress address = InetAddress.getLocalHost();
                String s = UUID.randomUUID().toString();
                s = String.valueOf(s.substring(0, 8)) + s.substring(9, 13) + s.substring(14, 18) + s.substring(19, 23) + s.substring(24);
                final String postkey = String.valueOf(now) + "__" + address.getHostAddress() + "__" + address.getHostName() + "__" + s;
                final String postvalue = xml;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HttpUtil.sendGet(MIXLY_URL, "key=" + URLEncoder.encode(postkey, "utf-8") + "&" + "value=" + URLEncoder.encode(postvalue, "utf-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
            if (currBoard.equals(MICROBIT_JS)) {
                workspaceToCode = "Blockly.JavaScript.workspaceToCode()";
            } else if (currBoard.equals(MICROBIT_PY)) {
                workspaceToCode = "Blockly.Python.workspaceToCode()";
                String hex = (String)webEngine.executeScript("doDownload()");
                MyMethod.writeFile(hex, MICROBIT_PY_HEX_PATH);
            } else if (currBoard.equals(MIXPY)) {
                workspaceToCode = "Blockly.Python.workspaceToCode()";
            } else if (currBoard.equals(MICROPYTHON_ESP32)) {
                workspaceToCode = "Blockly.Python.workspaceToCode()";
            }
            String yuanma = (String)webEngine.executeScript(workspaceToCode);
            if (((Boolean)webEngine.executeScript("document.getElementById('tab_arduino').className == 'tabon'")).booleanValue()) {
                yuanma = (String)webEngine.executeScript("editor.getValue();");
            }
            MyMethod.saveYuanma(yuanma);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    block20: {
                        try {
                            if (serialPortCom != null && serialPortCom.isOpened()) {
                                serialPortCom.closePort();
                            }
                        }
                        catch (SerialPortException e) {
                            e.printStackTrace();
                        }
                        if (Browser_new.getCurrentBoard().equals(MICROPYTHON_ESP32)) {
                            Browser_new.redirectSystemOut();
                            try {
                                Browser_new.clearTextArea();
                                serialPort = ((String)comboBox.getSelectionModel().getSelectedItem()).toString();
                                serialPortCom = new SerialPort(serialPort);
                                serialPortCom.openPort();
                                if (Browser_new.this.readWriteUart == null) {
                                    Browser_new.this.readWriteUart = new ReadWriteUart("esp32", serialPortCom, Browser_new.this.readWriteQueue);
                                    Browser_new.this.readWriteUart.setDaemon(true);
                                    Browser_new.this.readWriteUart.start();
                                } else {
                                    Browser_new.this.readWriteUart.setSerialPort(serialPortCom);
                                }
                                if (!Browser_new.this.readWriteUart.resetSerial(115200)) {
                                    System.out.println("Error:Serial reset failed!");
                                    return;
                                }
                                if (Browser_new.this.esp32Uploader == null) {
                                    Browser_new.this.esp32Uploader = new Esp32Uploader("esp32", Browser_new.this.readWriteQueue, Browser_new.this.readWriteUart);
                                }
                                Browser_new.this.esp32Uploader.run("esp32Build/mixly.py");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            Browser_new.recoverSystemOut();
                            return;
                        }
                        Browser_new.setProgressBar(true, 2);
                        Browser_new.this.setButtonDisable(true);
                        try {
                            try {
                                uploadSuccess = true;
                                Browser_new.upload();
                                if (cmdIsKilled) {
                                    Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("upload")) + LanguageProvider.getLocalString("canceled") + "\n");
                                    break block20;
                                }
                                if (uploadSuccess) {
                                    Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("upload_success")) + "\n");
                                    if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_LINUX) {
                                        serialPortCom = new SerialPort(serialPort);
                                        try {
                                            serialPortCom.openPort();
                                        }
                                        catch (SerialPortException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    break block20;
                                }
                                Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("upload_failed")) + "\n");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                Browser_new.setProgressBar(false, 2);
                                Browser_new.this.setButtonDisable(false);
                                Browser_new.this.sd.hide();
                            }
                        }
                        finally {
                            Browser_new.setProgressBar(false, 2);
                            Browser_new.this.setButtonDisable(false);
                            Browser_new.this.sd.hide();
                        }
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doUpLoadForHardWareTest() {
        cmdIsKilled = false;
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    block10: {
                        try {
                            if (serialPortCom != null && serialPortCom.isOpened()) {
                                serialPortCom.closePort();
                            }
                        }
                        catch (SerialPortException e) {
                            e.printStackTrace();
                        }
                        Browser_new.setProgressBar(true, 2);
                        Browser_new.this.setButtonDisable(true);
                        try {
                            try {
                                uploadSuccess = true;
                                Browser_new.upload();
                                if (cmdIsKilled) {
                                    Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("upload")) + LanguageProvider.getLocalString("canceled") + "\n");
                                    break block10;
                                }
                                if (uploadSuccess) {
                                    Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("upload_success")) + "\n");
                                    Browser_new.this.hardwareDialog.setMsg(LanguageProvider.getLocalString("uploadHardwareTestProgramSuccessfully"));
                                    Browser_new.this.hardwareDialog.resetSerial();
                                    break block10;
                                }
                                Browser_new.updateTextArea(String.valueOf(LanguageProvider.getLocalString("upload_failed")) + "\n");
                                Browser_new.this.hardwareDialog.setMsg(LanguageProvider.getLocalString("uploadHardwareTestProgramFailed"));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                Browser_new.setProgressBar(false, 2);
                                Browser_new.this.setButtonDisable(false);
                            }
                        }
                        finally {
                            Browser_new.setProgressBar(false, 2);
                            Browser_new.this.setButtonDisable(false);
                        }
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void layoutChildren() {
        double w = this.getWidth();
        double h = this.getHeight();
        double toolHeight = this.toolBar.getHeight();
        double div = this.sp.getDividerPositions()[0] * h;
        this.layoutInArea(this.sp, 0.0, 0.0, w, h, 0.0, HPos.CENTER, VPos.CENTER);
        output_text.setPrefHeight(h - div - toolHeight);
    }

    private Button createSpacer(double w) {
        Button spacer = new Button();
        spacer.setPrefWidth(w);
        spacer.setPadding(new Insets(8.0, 0.0, 8.0, 0.0));
        Background bg = new Background(new BackgroundFill(Color.rgb(255, 255, 255, 0.6), null, null));
        spacer.setBackground(bg);
        return spacer;
    }

    private Node createSpacer2() {
        Region spacer = new Region();
        HBox.setHgrow(spacer, Priority.ALWAYS);
        return spacer;
    }

    private Node createSpacer3(double w) {
        Region spacer = new Region();
        spacer.setPrefWidth(w);
        return spacer;
    }

    private static void init() {
        String curDir = new File("").getAbsolutePath();
        arduinoPath = MyMethod.getProp(config, "arduinoPath");
        arduino_save = MyMethod.getProp(config, "arduino_save");
        arduino_builder = MyMethod.getProp(config, "arduino_builder");
        if (SystemUtils.IS_OS_WINDOWS) {
            arduino_complie = String.valueOf(MyMethod.getProp(config, "arduino_complie")) + " --verify \"" + curDir + "/testArduino/testArduino.ino\"";
            arduino_upload = String.valueOf(MyMethod.getProp(config, "arduino_upload")) + " \"" + curDir + "/testArduino/testArduino.ino\"";
            arduino_builder = Browser_new.replacePathVariables(arduino_builder, arduinoPath, curDir, true);
            microbit_js_cmd = MyMethod.getProp(config, "win_microbit_js_cmd");
            micropython_esp32_burn_cmd = MyMethod.getProp(config, "win_esp32_burn_cmd");
            micropython_esp32_upload_cmd = MyMethod.getProp(config, "win_esp32_upload_cmd");
        } else {
            arduino_complie = String.valueOf(MyMethod.getProp(config, "arduino_complie")) + " --verify " + curDir + "/testArduino/testArduino.ino";
            arduino_upload = String.valueOf(MyMethod.getProp(config, "arduino_upload")) + " " + curDir + "/testArduino/testArduino.ino";
            arduino_builder = Browser_new.replacePathVariables(arduino_builder, arduinoPath, curDir, false);
            microbit_js_cmd = MyMethod.getProp(config, "mac_microbit_js_cmd");
            micropython_esp32_burn_cmd = MyMethod.getProp(config, "mac_esp32_burn_cmd");
            micropython_esp32_upload_cmd = MyMethod.getProp(config, "mac_esp32_upload_cmd");
        }
        projectPath = "testArduino";
        serialPort = "COM0";
        releasePath = String.valueOf(projectPath) + "/Release/";
        arduinoWebPath = String.valueOf(MyMethod.getProp(config, "webPath")) + "?lang=" + MyMethod.getProp(config, "language");
        if (!arduinoWebPath.startsWith("http://") && !arduinoWebPath.startsWith("file:///")) {
            File directory = new File("");
            arduinoWebPath = "file:///" + directory.getAbsolutePath() + "/" + arduinoWebPath;
        }
        defaultOut = System.out;
        defaultErr = System.err;
        ArduinoHelper.init(arduinoPath);
    }

    private static String replacePathVariables(String src, String arduinoPath, String mixlyPath, boolean withQuote) {
        if (src == null || src.isEmpty()) {
            return src;
        }
        arduinoPath = String.valueOf(Matcher.quoteReplacement(FileUtil.trimTrailingSlash(arduinoPath))) + "$1";
        mixlyPath = String.valueOf(Matcher.quoteReplacement(FileUtil.trimTrailingSlash(mixlyPath))) + "$1";
        if (withQuote) {
            arduinoPath = "\"" + arduinoPath + "\"";
            mixlyPath = "\"" + mixlyPath + "\"";
        }
        return src.replaceAll("\\{\\$\\{arduinoPath\\}([^\\}]*)\\}", arduinoPath).replaceAll("\\{\\$\\{mixlyPath\\}([^\\}]*)\\}", mixlyPath);
    }

    private static void upload() {
        try {
            serialPort = ((String)comboBox.getSelectionModel().getSelectedItem()).toString();
            if (serialPort != null && !serialPort.equals("")) {
                curCom = serialPort;
            }
            String boardName = boardsComboBox.getSelectionModel().getSelectedItem().toString();
            String boardId = ArduinoHelper.getBoardId(boardName);
            String boardCpu = ArduinoHelper.getBoardCpu(boardName);
            Browser_new.clearTextArea();
            if (Browser_new.getCurrentBoard().equals(MICROBIT_JS)) {
                Browser_new.redirectSystemOut();
                String cmd = String.format(microbit_js_cmd, "deploy");
                Browser_new.execcmd(cmd);
                Browser_new.recoverSystemOut();
                return;
            }
            if (Browser_new.getCurrentBoard().equals(MICROBIT_PY)) {
                Browser_new.redirectSystemOut();
                File[] microbitDiskFdArr = DiskUtil.getRemovableDiskFdList();
                if (microbitDiskFdArr.length == 0) {
                    System.out.println("cannot find any drives to deploy to");
                    uploadSuccess = false;
                }
                int i = 0;
                while (i < microbitDiskFdArr.length) {
                    System.out.println(String.format("Uploading: copy %s to %s", MICROBIT_PY_HEX_PATH, microbitDiskFdArr[i].toString()));
                    FileUtil.copyFileTo(MICROBIT_PY_HEX_PATH, microbitDiskFdArr[i].toString());
                    ++i;
                }
                Browser_new.recoverSystemOut();
                return;
            }
            if (Browser_new.getCurrentBoard().equals(MIXPY)) {
                return;
            }
            if (Browser_new.getCurrentBoard().equals(MICROPYTHON_ESP32)) {
                Browser_new.redirectSystemOut();
                try {
                    if (serialPortCom != null && serialPortCom.isOpened()) {
                        serialPortCom.closePort();
                    }
                }
                catch (SerialPortException e) {
                    e.printStackTrace();
                }
                String port = ((String)comboBox.getSelectionModel().getSelectedItem()).toString();
                String cmd = String.format(micropython_esp32_upload_cmd, port, "esp32Build/mixly.py");
                Browser_new.execcmd(cmd);
                Browser_new.recoverSystemOut();
                return;
            }
            if (ArduinoHelper.isInitialized()) {
                String cmd;
                Browser_new.redirectSystemOut();
                if (boardId == null || boardCpu == null) {
                    System.out.println(String.format("Error:%s is not in the known board list.", boardName));
                    System.out.println("Please select a new board in the board list.");
                    uploadSuccess = false;
                    return;
                }
                if (shouldSaveConfig) {
                    cmd = arduino_save.replace("{board}", boardId).replace("{cpu}", boardCpu);
                    ArduinoHelper.run(cmd);
                    shouldSaveConfig = false;
                }
                cmd = arduino_upload.replace("{board}", boardId).replace("{cpu}", boardCpu).replace("{port}", serialPort);
                uploadSuccess = ArduinoHelper.run(cmd);
                Browser_new.recoverSystemOut();
                return;
            }
            String cmd_upload = String.valueOf(arduinoPath) + arduino_upload.replace("{board}", boardId).replace("{cpu}", boardCpu).replace("{port}", serialPort);
            String cmd_save = String.valueOf(arduinoPath) + arduino_save.replace("{board}", boardId).replace("{cpu}", boardCpu);
            if (shouldSaveConfig) {
                Browser_new.execcmd(cmd_save);
                shouldSaveConfig = false;
            }
            Browser_new.execcmd(cmd_upload);
        }
        catch (Exception e) {
            e.printStackTrace();
            uploadSuccess = false;
        }
    }

    private static void compile() {
        String cmd_compile;
        String boardName = boardsComboBox.getSelectionModel().getSelectedItem().toString();
        String boardId = ArduinoHelper.getBoardId(boardName);
        String boardCpu = ArduinoHelper.getBoardCpu(boardName);
        Browser_new.clearTextArea();
        if (Browser_new.getCurrentBoard().equals(MICROBIT_JS)) {
            Browser_new.redirectSystemOut();
            String cmd = String.format(microbit_js_cmd, "build");
            Browser_new.execcmd(cmd);
            Browser_new.recoverSystemOut();
            return;
        }
        if (Browser_new.getCurrentBoard().equals(MICROBIT_PY)) {
            Browser_new.redirectSystemOut();
            System.out.println(String.format("The path of compiled hex file: %s", new File(MICROBIT_PY_HEX_PATH).getAbsolutePath()));
            Browser_new.recoverSystemOut();
            return;
        }
        if (Browser_new.getCurrentBoard().equals(MIXPY)) {
            return;
        }
        if (Browser_new.getCurrentBoard().equals(MICROPYTHON_ESP32)) {
            Browser_new.redirectSystemOut();
            if (serialPortCom != null && serialPortCom.isOpened()) {
                try {
                    serialPortCom.closePort();
                }
                catch (SerialPortException e) {
                    e.printStackTrace();
                }
            }
            String port = ((String)comboBox.getSelectionModel().getSelectedItem()).toString();
            String cmd = String.format(micropython_esp32_burn_cmd, port);
            Browser_new.execcmd(cmd);
            Browser_new.recoverSystemOut();
            return;
        }
        if (ArduinoHelper.isInitialized()) {
            String cmd;
            Browser_new.redirectSystemOut();
            if (boardId == null || boardCpu == null) {
                System.out.println(String.format("Error:%s is not in the known board list.", boardName));
                System.out.println("Please select a new board in the board list.");
                compileSuccess = false;
                return;
            }
            if (shouldSaveConfig) {
                cmd = arduino_save.replace("{board}", boardId).replace("{cpu}", boardCpu);
                ArduinoHelper.run(cmd);
                shouldSaveConfig = false;
            }
            cmd = arduino_complie.replace("{board}", boardId).replace("{cpu}", boardCpu);
            compileSuccess = ArduinoHelper.run(cmd);
            Browser_new.recoverSystemOut();
            return;
        }
        if (arduino_builder != null) {
            cmd_compile = arduino_builder.replace("{board}", boardId).replace("{cpu}", boardId);
            FileUtil.createEmptyFolder("mixlyBuild");
        } else {
            cmd_compile = String.valueOf(arduinoPath) + arduino_complie.replace("{board}", boardId).replace("{cpu}", boardId);
        }
        String cmd_save = String.valueOf(arduinoPath) + arduino_save.replace("{board}", boardId).replace("{cpu}", boardId);
        if (shouldSaveConfig) {
            Browser_new.execcmd(cmd_save);
            shouldSaveConfig = false;
        }
        Browser_new.execcmd(cmd_compile);
    }

    public static void execcmd(String cmd) {
        Browser_new.updateTextArea(cmd);
        try {
            process = Runtime.getRuntime().exec(cmd);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            OutputStream stdOutput = process.getOutputStream();
            String line = null;
            while (!cmdIsKilled && (line = stdInput.readLine()) != null) {
                if (line.contains("error ") || line.contains("Error ") || line.contains("ERROR ") || line.contains("error:") || line.contains("Error:") || line.contains("ERROR:") || line.contains("error=") || line.contains("\u51fa\u9519") || line.contains("timeout communicating with programmer") || line.contains("can't") || line.contains("not in sync") || line.contains("cannot find any drives to deploy to") || line.contains("Traceback")) {
                    compileSuccess = false;
                    uploadSuccess = false;
                }
                if (line.contains("SUCCESS") || line.contains("hexsize")) {
                    compileSuccess = true;
                }
                if (line.contains("SUCCESS") || line.contains("wrote hex file to")) {
                    uploadSuccess = true;
                }
                Browser_new.updateTextArea(line);
                if (!line.contains("avrdude")) continue;
                stdOutput.flush();
                stdOutput.close();
                break;
            }
            while (!cmdIsKilled && (line = stdError.readLine()) != null) {
                if (line.contains("error ") || line.contains("Error ") || line.contains("ERROR ") || line.contains("error:") || line.contains("Error:") || line.contains("ERROR:") || line.contains("error=") || line.contains("\u51fa\u9519") || line.contains("timeout communicating with programmer") || line.contains("can't") || line.contains("not in sync")) {
                    compileSuccess = false;
                    uploadSuccess = false;
                }
                if (line.contains("SUCCESS") || line.contains("hexsize")) {
                    compileSuccess = true;
                }
                if (line.contains("SUCCESS") || line.contains("wrote hex file to")) {
                    uploadSuccess = true;
                }
                Browser_new.updateTextArea(line);
            }
            if (cmdIsKilled) {
                process.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static synchronized void updateTextArea0() {
        int count = textQueue.size();
        int len = 0;
        ArrayList<Text> texts = new ArrayList<Text>(count);
        int i = 0;
        while (i < count) {
            Text text = textQueue.poll();
            if (text == null) break;
            len += text.value.length();
            texts.add(text);
            ++i;
        }
        final StringBuilder sb = new StringBuilder(len + count * 2);
        for (Text text : texts) {
            sb.append(text.value);
            if (!text.newLine) continue;
            sb.append(System.lineSeparator());
        }
        if (sb == null || sb.length() == 0) {
            return;
        }
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                output_text.appendText(sb.toString());
            }
        });
    }

    public static void updateTextArea(String s) {
        Browser_new.updateTextArea(s, true);
    }

    public static void updateTextArea(String s, boolean newLine) {
        Text text = new Text();
        text.value = Coder.getChineseString(s);
        text.newLine = newLine;
        textQueue.offer(text);
        if (textAreaRunnableState.compareAndSet(0, 1)) {
            Thread t = new Thread(textAreaRunnable);
            t.setDaemon(true);
            t.start();
        }
    }

    private static void clearTextArea() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                output_text.setText("");
            }
        });
    }

    private static void setProgressBar(final boolean visible, final int k) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (k == 1) {
                    progress.setVisible(visible);
                } else if (k == 2) {
                    progress2.setVisible(visible);
                }
            }
        });
    }

    private static void setCom(final String[] s) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                comboBox.getItems().clear();
                comboBox.setValue("");
                if (s != null && s.length > 0) {
                    comboBox.getItems().addAll((String[])s);
                    if (curCom != null && !curCom.equals("") && Browser_new.arrayContain(cur, curCom)) {
                        comboBox.setValue(curCom);
                    } else {
                        comboBox.getSelectionModel().selectFirst();
                        comboBox.setValue(s[0]);
                    }
                }
            }
        });
    }

    private static boolean arrayContain(String[] array, String value) {
        if (array != null && array.length > 0) {
            int i = 0;
            while (i < array.length) {
                if (array[i].equals(value)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void saveCurrentBoard() {
        shouldSaveConfig = true;
        String str = boardsComboBox.getSelectionModel().getSelectedItem().toString();
        MyMethod.changeCurrentBoard(config, "currentBoard", str);
    }

    private void setInterruptByBoard(String board) {
        String str = "";
        String board_new = board.replaceAll("\\[.*\\]", "");
        str = webEngine.executeScript("profile[\"" + board_new + "\"]").toString().equals("undefined") ? String.valueOf(str) + "profile[\"default\"] = profile[\"arduino_standard\"];" : String.valueOf(str) + "profile[\"default\"] = profile[\"" + board_new + "\"];";
        MyMethod.saveDigitalPinToInterrupt(str);
        webEngine.executeScript(str);
        webEngine.executeScript("renderContent();");
    }

    public static String getMyTitle() {
        String version = MyMethod.getProp(config, "version");
        return "Mixly " + version;
    }

    public static void refreshWeb() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                webEngine.reload();
            }
        });
    }

    public static boolean isXmlSaved() {
        String xml;
        block4: {
            try {
                xml = (String)webEngine.executeScript("goog.string.quote(Blockly.Xml.domToText(Blockly.Xml.workspaceToDom(Blockly.mainWorkspace)))");
                xml = xml.substring(1, xml.length() - 1);
                xml = xml.replaceFirst("<xml(.*?)>", "<xml>");
                if (xmlFileName != null && !xmlFileName.equals("")) break block4;
                return xml.equals("<xml></xml>");
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        String save_xml = MyMethod.readXml(new File(xmlFileName)).toString().replaceFirst("<xml(.*?)>", "<xml>");
        if (save_xml.contains("type=\"")) {
            save_xml = Browser_new.translateQuote(save_xml, false).replaceAll(" id=\\\\\".*?\\\\\"", "").replaceAll(" xmlns=\\\\\"\\\\\"", "");
            xml = xml.replaceAll(" id=\\\\\".*?\\\\\"", "").replaceAll(" xmlns=\\\\\"\\\\\"", "");
        }
        return xml.equals(save_xml);
    }

    public static void redirectSystemOut() {
        OutputStream toTextAreaStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                String s = new String(new byte[]{(byte)b});
                Browser_new.updateTextArea(s, false);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                String s = new String(b, off, len);
                Browser_new.updateTextArea(s, false);
            }
        };
        System.setOut(new PrintStream(toTextAreaStream));
        System.setErr(new PrintStream(toTextAreaStream));
    }

    public static void recoverSystemOut() {
        System.setOut(defaultOut);
        System.setErr(defaultErr);
    }

    private static String translateQuote(String str, boolean trimEscaped) {
        StringBuilder xml = new StringBuilder("");
        boolean hasCompleteAngleBracket = true;
        int lenStr = str.length();
        int i = 0;
        while (i < lenStr) {
            if (str.charAt(i) == '<') {
                hasCompleteAngleBracket = false;
            } else if (str.charAt(i) == '>') {
                hasCompleteAngleBracket = true;
            }
            if (trimEscaped && !hasCompleteAngleBracket && i + 1 < lenStr && str.charAt(i) == '\\' && str.charAt(i + 1) == '\"') {
                ++i;
            }
            if (!trimEscaped && !hasCompleteAngleBracket && i > 0 && str.charAt(i - 1) != '\\' && str.charAt(i) == '\"') {
                xml.append('\\');
            }
            xml.append(str.charAt(i));
            ++i;
        }
        return xml.toString();
    }

    public static String getCurrentBoard() {
        return boardsComboBox.getSelectionModel().getSelectedItem().toString();
    }

    public static boolean isNotArduinoForCurrentBoard() {
        return Browser_new.isOtherBoardsContainSomeBoard(Browser_new.getCurrentBoard());
    }

    public static boolean isNotArduino(String board) {
        return Browser_new.isOtherBoardsContainSomeBoard(board);
    }

    public static boolean isOtherBoardsContainSomeBoard(String board) {
        return otherBoardList.contains(board);
    }

    public static String makeBoardIndexPath(String board) {
        String webPathDir = arduinoWebPath.substring(0, arduinoWebPath.lastIndexOf("/") + 1);
        if (!Browser_new.isNotArduino(board)) {
            if (xmlFileName != null) {
                String viewWebName = Browser_new.makeBoardViewPath(arduinoWebPath.replace(webPathDir, ""), xmlFileName, true);
                return String.valueOf(webPathDir) + viewWebName;
            }
            return arduinoWebPath;
        }
        String otherBoardWebPath = String.valueOf(webPathDir) + MyMethod.getProp(config, "otherBoardsPrefix").trim() + board + ".html";
        if (xmlFileName != null) {
            String viewWebName = Browser_new.makeBoardViewPath(otherBoardWebPath.replace(webPathDir, ""), xmlFileName, true);
            return String.valueOf(webPathDir) + viewWebName;
        }
        return otherBoardWebPath;
    }

    public static Set<String> matchBlockType(String f, boolean isXmlFile) {
        HashSet<String> blockSet = new HashSet<String>();
        String fcontent = MyMethod.readFile(new File(f));
        Pattern pattern = isXmlFile ? Pattern.compile("<block *+type=\\\\\"(.*?)\\\\\"") : Pattern.compile("<block *+type=\"(.*?)\"");
        Matcher m = pattern.matcher(fcontent);
        while (m.find()) {
            blockSet.add(m.group(1));
        }
        return blockSet;
    }

    public static String makeBoardViewPath(String normalViewWebPath, String xmlFile, boolean isArduino) {
        boolean isNormalView;
        String webPathDir = arduinoWebPath.substring(0, arduinoWebPath.lastIndexOf("/") + 1).replaceFirst("file:///", "");
        String absoluteBoardWebPath = String.valueOf(webPathDir) + normalViewWebPath.replaceAll("\\?lang=.*?$", "");
        Set<String> allBlockTypeSet = Browser_new.matchBlockType(absoluteBoardWebPath, false);
        Set<String> tmpOpenedFileBlockTypeSet = Browser_new.matchBlockType(xmlFile, true);
        HashSet<String> openedFileBlockTypeSet = new HashSet<String>();
        for (String block : tmpOpenedFileBlockTypeSet) {
            if (block.startsWith("variables_") || block.startsWith("procedures_")) continue;
            openedFileBlockTypeSet.add(block);
        }
        allBlockTypeSet.retainAll(openedFileBlockTypeSet);
        boolean bl = isNormalView = allBlockTypeSet.size() == openedFileBlockTypeSet.size();
        if (isNormalView) {
            return normalViewWebPath;
        }
        if (isArduino) {
            return "index.html";
        }
        return "index_advance_board_" + normalViewWebPath.substring(MyMethod.getProp(config, "otherBoardsPrefix").length());
    }

    public static ArrayList<String> getNotArduinoBoardList() {
        ArrayList<String> notArduinoBoardList = new ArrayList<String>();
        String isSupportOtherBoards = MyMethod.getProp(config, "isSupportOtherBoards").trim();
        String otherBoardsPrefix = MyMethod.getProp(config, "otherBoardsPrefix").trim();
        if (isSupportOtherBoards.equals("true")) {
            File[] dirFile;
            String indexPath = MyMethod.getProp(config, "webPath");
            String blocksPath = indexPath.substring(0, indexPath.lastIndexOf("/")).replaceFirst("file://", "");
            File[] fileArray = dirFile = new File(blocksPath).listFiles();
            int n = dirFile.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile() && f.getName().startsWith(otherBoardsPrefix)) {
                    String fileName = f.getName().substring(0, f.getName().lastIndexOf("."));
                    notArduinoBoardList.add(fileName.split(otherBoardsPrefix)[1]);
                }
                ++n2;
            }
            boardsComboBox.getItems().addAll(otherBoardList);
        }
        return notArduinoBoardList;
    }

    static class Text {
        public String value;
        public boolean newLine;

        Text() {
        }
    }
}

