/*
 * Decompiled with CFR 0.152.
 */
package org.mixly;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import org.mixly.LibManagerDialog;
import org.mixly.SerialPortDialog;
import org.mixly.util.FileUtil;
import org.mixly.util.LanguageProvider;
import org.mixly.util.MyCom;
import org.mixly.util.MyMethod;

public class Browser
extends Region {
    private static boolean shouldSaveConfig = true;
    private boolean isalive = true;
    private static boolean compileSuccess = true;
    private static boolean uploadSuccess = true;
    private static String xmlFileName = null;
    private static Boolean cleared = false;
    public static SerialPortDialog portDialog = new SerialPortDialog();
    public static LibManagerDialog libmanagerDialog = new LibManagerDialog();
    private static double fontSize = 13.0;
    private SplitPane sp = new SplitPane();
    private StackPane sp1 = new StackPane();
    private StackPane sp2 = new StackPane();
    private VBox below = new VBox();
    private HBox toolBar;
    static Button clear = new Button(LanguageProvider.getLocalString("new"));
    static Button save1 = new Button(LanguageProvider.getLocalString("save"));
    static Button save2 = new Button(LanguageProvider.getLocalString("save_as"));
    static Button load = new Button(LanguageProvider.getLocalString("open"));
    static Button exportlib = new Button(LanguageProvider.getLocalString("export"));
    static Button importlib = new Button(LanguageProvider.getLocalString("import"));
    static Button managerlib = new Button(LanguageProvider.getLocalString("manager"));
    static Button openSerialPort = new Button(LanguageProvider.getLocalString("port_monitor"));
    static final Slider slider = new Slider();
    static Button compile = new Button(LanguageProvider.getLocalString("compile"));
    static Button upload = new Button(LanguageProvider.getLocalString("upload"));
    static ComboBox boardsComboBox = new ComboBox();
    static ComboBox comboBox = new ComboBox();
    static final ProgressBar progress = new ProgressBar();
    static final TextArea output_text = new TextArea();
    static final WebView browser = new WebView();
    static final WebEngine webEngine = browser.getEngine();
    private static int sumCmd = 1;
    private static String webPath;
    private static String arduinoPath;
    private static String projectPath;
    private static String releasePath;
    private static String arduino_complie;
    private static String arduino_save;
    private static String arduino_upload;
    private static String serialPort;
    public static String cofig;
    private Stage stage;
    private static String version;

    static {
        cofig = "setting/config.properties";
        version = "";
    }

    public void setIsalive(boolean isalive) {
        this.isalive = isalive;
    }

    public Browser(Stage stage) {
        this.stage = stage;
        Browser.init();
        this.initToolBar();
        this.setToolTips();
        this.setStyle();
        browser.setContextMenuEnabled(false);
        webEngine.load(webPath);
        this.below.getChildren().addAll((Node[])new Node[]{this.toolBar, output_text});
        this.sp1.getChildren().addAll((Node[])new Node[]{browser});
        this.sp2.getChildren().addAll((Node[])new Node[]{this.below});
        this.sp.setOrientation(Orientation.VERTICAL);
        this.sp.getItems().addAll((Node[])new Node[]{this.sp1, this.sp2});
        this.sp.setDividerPositions(0.82);
        this.getChildren().add(this.sp);
        webEngine.getLoadWorker().stateProperty().addListener(new ChangeListener<Worker.State>(){

            @Override
            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    try {
                        if (!cleared.booleanValue()) {
                            webEngine.executeScript("Blockly.mainWorkspace.clear();renderContent();");
                            cleared = true;
                            Browser.this.setInterruptByBoard(boardsComboBox.getSelectionModel().getSelectedItem().toString());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void setToolTips() {
        slider.setTooltip(new Tooltip("\u93b7\u6827\u59e9\u7f02\u2542\u6581\u9423\u5c84\u6f70"));
    }

    private void setStyle() {
        clear.setFont(new Font(fontSize));
        save1.setFont(new Font(fontSize));
        save2.setFont(new Font(fontSize));
        load.setFont(new Font(fontSize));
        importlib.setFont(new Font(fontSize));
        exportlib.setFont(new Font(fontSize));
        managerlib.setFont(new Font(fontSize));
        compile.setFont(new Font(fontSize));
        upload.setFont(new Font(fontSize));
        openSerialPort.setFont(new Font(fontSize));
        Background bg = new Background(new BackgroundFill(Color.rgb(153, 153, 153, 1.0), new CornerRadii(6.0), null));
        Background bg_gray = new Background(new BackgroundFill(Color.rgb(200, 200, 200, 1.0), new CornerRadii(6.0), null));
        clear.setBackground(bg);
        save1.setBackground(bg);
        save2.setBackground(bg);
        load.setBackground(bg);
        exportlib.setBackground(bg);
        importlib.setBackground(bg);
        managerlib.setBackground(bg);
        compile.setBackground(bg);
        upload.setBackground(bg);
        openSerialPort.setBackground(bg);
        boardsComboBox.setBackground(bg_gray);
        comboBox.setBackground(bg_gray);
        clear.setMinWidth(55.0);
        save1.setMinWidth(55.0);
        save2.setMinWidth(55.0);
        load.setMinWidth(55.0);
        importlib.setMinWidth(55.0);
        exportlib.setMinWidth(55.0);
        managerlib.setMinWidth(55.0);
        compile.setMinWidth(55.0);
        upload.setMinWidth(55.0);
        openSerialPort.setMinWidth(55.0);
        clear.setTextFill(Color.WHITE);
        save1.setTextFill(Color.WHITE);
        save2.setTextFill(Color.WHITE);
        load.setTextFill(Color.WHITE);
        importlib.setTextFill(Color.WHITE);
        exportlib.setTextFill(Color.WHITE);
        managerlib.setTextFill(Color.WHITE);
        compile.setTextFill(Color.WHITE);
        upload.setTextFill(Color.WHITE);
        openSerialPort.setTextFill(Color.WHITE);
        final DropShadow shadow = new DropShadow();
        clear.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                clear.setEffect(shadow);
            }
        });
        save1.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                save1.setEffect(shadow);
            }
        });
        save2.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                save2.setEffect(shadow);
            }
        });
        load.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                load.setEffect(shadow);
            }
        });
        exportlib.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                exportlib.setEffect(shadow);
            }
        });
        importlib.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                importlib.setEffect(shadow);
            }
        });
        managerlib.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                managerlib.setEffect(shadow);
            }
        });
        compile.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                compile.setEffect(shadow);
            }
        });
        upload.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                upload.setEffect(shadow);
            }
        });
        openSerialPort.addEventHandler(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                openSerialPort.setEffect(shadow);
            }
        });
        boardsComboBox.addEventHandler(MouseEvent.MOUSE_ENTERED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                boardsComboBox.setEffect(shadow);
            }
        });
        comboBox.addEventHandler(MouseEvent.MOUSE_ENTERED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                comboBox.setEffect(shadow);
            }
        });
        clear.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                clear.setEffect(null);
            }
        });
        save1.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                save1.setEffect(null);
            }
        });
        save2.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                save2.setEffect(null);
            }
        });
        load.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                load.setEffect(null);
            }
        });
        exportlib.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                exportlib.setEffect(null);
            }
        });
        importlib.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                importlib.setEffect(null);
            }
        });
        managerlib.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                managerlib.setEffect(null);
            }
        });
        compile.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                compile.setEffect(null);
            }
        });
        upload.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                upload.setEffect(null);
            }
        });
        openSerialPort.addEventHandler(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                openSerialPort.setEffect(null);
            }
        });
        boardsComboBox.addEventHandler(MouseEvent.MOUSE_EXITED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                boardsComboBox.setEffect(null);
            }
        });
        comboBox.addEventHandler(MouseEvent.MOUSE_EXITED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                comboBox.setEffect(null);
            }
        });
    }

    private void initToolBar() {
        this.toolBar = new HBox();
        this.toolBar.setAlignment(Pos.BASELINE_RIGHT);
        this.toolBar.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.toolBar.getChildren().add(clear);
        this.toolBar.getChildren().add(this.createSpacer(10.0));
        this.toolBar.getChildren().add(load);
        this.toolBar.getChildren().add(this.createSpacer(10.0));
        this.toolBar.getChildren().add(save1);
        this.toolBar.getChildren().add(this.createSpacer(10.0));
        this.toolBar.getChildren().add(save2);
        this.toolBar.getChildren().add(this.createSpacer(10.0));
        this.toolBar.getChildren().add(exportlib);
        this.toolBar.getChildren().add(this.createSpacer(10.0));
        this.toolBar.getChildren().add(importlib);
        this.toolBar.getChildren().add(this.createSpacer(10.0));
        this.toolBar.getChildren().add(managerlib);
        slider.setMin(50.0);
        slider.setMax(150.0);
        slider.setValue(100.0);
        slider.setMaxWidth(100.0);
        slider.setOrientation(Orientation.HORIZONTAL);
        this.toolBar.getChildren().add(this.createSpacer2());
        this.toolBar.getChildren().add(progress);
        progress.setVisible(false);
        progress.setPrefWidth(100.0);
        this.toolBar.getChildren().add(this.createSpacer2());
        this.toolBar.getChildren().add(compile);
        this.toolBar.getChildren().add(this.createSpacer(10.0));
        this.toolBar.getChildren().add(upload);
        this.toolBar.getChildren().add(this.createSpacer(10.0));
        List<String> boardList = MyMethod.getBoardsList(String.valueOf(arduinoPath) + "hardware/");
        int i = 0;
        while (i < boardList.size()) {
            boardsComboBox.getItems().addAll(MyMethod.getBoards(boardList.get(i)));
            ++i;
        }
        boardsComboBox.setPrefWidth(200.0);
        String currentBoard = MyMethod.getProp(cofig, "currentBoard").trim();
        if (currentBoard == null || currentBoard.equals("")) {
            boardsComboBox.getSelectionModel().selectFirst();
        } else {
            boardsComboBox.setValue(currentBoard);
        }
        boardsComboBox.setOnAction((EventHandler<ActionEvent>)new EventHandler<Event>(){

            @Override
            public void handle(Event arg0) {
                Browser.this.saveCurrentBoard();
                String board = boardsComboBox.getSelectionModel().getSelectedItem().toString();
                Browser.this.setInterruptByBoard(board);
            }
        });
        this.toolBar.getChildren().add(boardsComboBox);
        this.toolBar.getChildren().add(this.createSpacer(10.0));
        this.toolBar.getChildren().add(comboBox);
        this.toolBar.getChildren().add(this.createSpacer(10.0));
        this.toolBar.getChildren().add(openSerialPort);
        new Thread(new Runnable(){

            @Override
            public void run() {
                String[] pre = null;
                String[] cur = null;
                while (Browser.this.isalive) {
                    cur = MyCom.getSerialNames();
                    if (!MyMethod.compareStrArray(pre, cur)) {
                        Browser.setCom(cur);
                        pre = cur;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
        slider.valueProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> ov, Number old_val, Number new_val) {
                float value = new_val.floatValue();
                browser.setZoom(value / 100.0f);
            }
        });
        openSerialPort.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                try {
                    String titile = comboBox.getSelectionModel().getSelectedItem().toString();
                    if (titile != null && !titile.equals("")) {
                        portDialog.setTitle(titile);
                        if (!titile.equals(SerialPortDialog.com)) {
                            SerialPortDialog.textArea.setText("");
                        }
                        SerialPortDialog.com = titile;
                        portDialog.setLocationRelativeTo(null);
                        portDialog.setVisible(true);
                        portDialog.toFront();
                        if (SerialPortDialog.serialPortCom != null && SerialPortDialog.serialPortCom.isOpened()) {
                            SerialPortDialog.serialPortCom.closePort();
                            SerialPortDialog.serialPortCom = null;
                        }
                        SerialPortDialog.resetSerial();
                    } else {
                        Browser.updateTextArea("\u93c3\u72b2\u5f72\u9422\u3124\u8986\u9359\ufffd");
                    }
                }
                catch (Exception e) {
                    Browser.updateTextArea("\u93c3\u72b2\u5f72\u9422\u3124\u8986\u9359\ufffd");
                }
            }
        });
        compile.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                Browser.this.doCompile();
            }
        });
        upload.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                Browser.this.doUpLoad();
            }
        });
        clear.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                webEngine.executeScript("Blockly.mainWorkspace.clear();renderContent();");
                xmlFileName = null;
                Browser.this.stage.setTitle(Browser.getMyTitle());
            }
        });
        save1.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                String currentBoard = boardsComboBox.getSelectionModel().getSelectedItem().toString();
                String xml = (String)webEngine.executeScript("Blockly.Xml.domToText(Blockly.Xml.workspaceToDom(Blockly.mainWorkspace))");
                xml = xml.replaceFirst("<xml", "<xml board=\"" + currentBoard + "\"");
                if (xmlFileName == null) {
                    FileChooser fd = new FileChooser();
                    fd.setInitialFileName("arduino.xml");
                    fd.setTitle("\u6dc7\u6fc6\u74e8\u6d93\u7c12ml\u93c2\u56e6\u6b22");
                    if (xmlFileName != null) {
                        File defaultPath = new File(xmlFileName).getParentFile().getAbsoluteFile();
                        fd.setInitialDirectory(defaultPath);
                    }
                    fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("XML\u93c2\u56e6\u6b22", "*.xml"));
                    File xmlFile = fd.showSaveDialog(null);
                    if (xmlFile != null) {
                        String filePath = xmlFile.getAbsolutePath();
                        if (!filePath.endsWith(".xml") && !filePath.endsWith(".XML")) {
                            filePath = String.valueOf(filePath) + ".xml";
                        }
                        MyMethod.saveXML(xml, filePath);
                        xmlFileName = filePath;
                        Browser.this.stage.setTitle(String.valueOf(Browser.getMyTitle()) + "(" + xmlFileName + ")");
                    }
                } else {
                    MyMethod.saveXML(xml, xmlFileName);
                }
            }
        });
        save2.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                String currentBoard = boardsComboBox.getSelectionModel().getSelectedItem().toString();
                String xml = (String)webEngine.executeScript("Blockly.Xml.domToText(Blockly.Xml.workspaceToDom(Blockly.mainWorkspace))");
                xml = xml.replaceFirst("<xml", "<xml board=\"" + currentBoard + "\"");
                FileChooser fd = new FileChooser();
                fd.setInitialFileName("arduino.xml");
                fd.setTitle("\u9359\ufe40\u74e8\u6d93\u7c12ml\u93c2\u56e6\u6b22");
                if (xmlFileName != null) {
                    File defaultPath = new File(xmlFileName).getParentFile().getAbsoluteFile();
                    fd.setInitialDirectory(defaultPath);
                }
                fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("XML\u93c2\u56e6\u6b22", "*.xml"));
                File xmlFile = fd.showSaveDialog(null);
                if (xmlFile != null) {
                    String filePath = xmlFile.getAbsolutePath();
                    if (!filePath.endsWith(".xml") && !filePath.endsWith(".XML")) {
                        filePath = String.valueOf(filePath) + ".xml";
                    }
                    MyMethod.saveXML(xml, filePath);
                    xmlFileName = filePath;
                    Browser.this.stage.setTitle(String.valueOf(Browser.getMyTitle()) + "(" + xmlFileName + ")");
                }
            }
        });
        load.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                File defaultPath;
                FileChooser fd = new FileChooser();
                fd.setTitle("\u93b5\u64b3\u7d11xml\u93c2\u56e6\u6b22");
                if (xmlFileName != null) {
                    defaultPath = new File(xmlFileName).getParentFile().getAbsoluteFile();
                    fd.setInitialDirectory(defaultPath);
                } else {
                    defaultPath = new File("sample");
                    if (!defaultPath.exists() && !defaultPath.isDirectory()) {
                        defaultPath.mkdir();
                    }
                    fd.setInitialDirectory(defaultPath);
                }
                fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("XML\u93c2\u56e6\u6b22", "*.xml"));
                File xmlFile = fd.showOpenDialog(null);
                if (xmlFile != null) {
                    String result = MyMethod.readXml(xmlFile);
                    String boardName = MyMethod.readBoardNameFromXml(xmlFile);
                    if (result != null) {
                        try {
                            result = result.replaceAll("\"", "\\\\\"");
                            webEngine.executeScript("var xml = Blockly.Xml.textToDom(\"" + result + "\");" + "Blockly.mainWorkspace.clear();" + "Blockly.Xml.domToWorkspace(Blockly.mainWorkspace, xml);renderContent();");
                            if (boardName != null && !boardName.equals("") && !boardName.equals("mylib")) {
                                boardsComboBox.setValue(boardName);
                            }
                            xmlFileName = xmlFile.getAbsolutePath();
                            Browser.this.stage.setTitle(String.valueOf(Browser.getMyTitle()) + "(" + xmlFileName + ")");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        exportlib.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                String xml = (String)webEngine.executeScript("Blockly.Xml.domToText(Blockly.Xml.workspaceToDom(Blockly.mainWorkspace))");
                xml = xml.replaceFirst("<xml", "<xml board=\"mylib\"");
                FileChooser fd = new FileChooser();
                fd.setInitialFileName("\u6434\u64b3\u6095\u7ec9\ufffd.xml");
                fd.setTitle("\u7035\u714e\u56ad\u6434\u64b4\u6783\u6d60\ufffd");
                if (xmlFileName != null) {
                    File defaultPath = new File(xmlFileName).getParentFile().getAbsoluteFile();
                    fd.setInitialDirectory(defaultPath);
                }
                fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("XML\u93c2\u56e6\u6b22", "*.xml"));
                File xmlFile = fd.showSaveDialog(null);
                if (xmlFile != null) {
                    String filePath = xmlFile.getAbsolutePath();
                    if (!filePath.endsWith(".xml") && !filePath.endsWith(".XML")) {
                        filePath = String.valueOf(filePath) + ".xml";
                    }
                    MyMethod.saveXML(xml, filePath);
                }
            }
        });
        importlib.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                FileChooser fd = new FileChooser();
                fd.setTitle("\u7035\u714e\u53c6\u6434\u64b4\u6783\u6d60\ufffd");
                if (xmlFileName != null) {
                    File defaultPath = new File(xmlFileName).getParentFile().getAbsoluteFile();
                    fd.setInitialDirectory(defaultPath);
                }
                fd.getExtensionFilters().add(new FileChooser.ExtensionFilter("XML\u93c2\u56e6\u6b22", "*.xml"));
                File xmlFile = fd.showOpenDialog(null);
                if (xmlFile != null) {
                    String result = MyMethod.readXml(xmlFile);
                    if (result.contains("mylib")) {
                        String oldPath = xmlFile.getAbsolutePath();
                        String newPath = "mylib/" + oldPath.substring(oldPath.lastIndexOf(System.getProperty("file.separator")) + 1);
                        if (MyMethod.saveXML(result, newPath)) {
                            MyMethod.setCustom();
                            webEngine.reload();
                            Browser.updateTextArea("\u7035\u714e\u53c6\u9477\ue044\u757e\u6d94\u590a\u7c31\u93b4\u612c\u59db\u951b\ufffd");
                        } else {
                            Browser.updateTextArea("\u7035\u714e\u53c6\u9477\ue044\u757e\u6d94\u590a\u7c31\u6fb6\u8fab\u89e6\u951b\ufffd");
                        }
                    } else if (result.contains("type=\"company\"")) {
                        String oldPath = xmlFile.getAbsolutePath();
                        String newPath = "company/" + oldPath.substring(oldPath.lastIndexOf(System.getProperty("file.separator")) + 1);
                        Pattern p1 = Pattern.compile("block=\"(.*?)\"");
                        Pattern p2 = Pattern.compile("generator=\"(.*?)\"");
                        Pattern p3 = Pattern.compile("lib=\"(.*?)\"");
                        Matcher m1 = p1.matcher(result);
                        Matcher m2 = p2.matcher(result);
                        Matcher m3 = p3.matcher(result);
                        String str_block = null;
                        String str_generator = null;
                        String str_lib = null;
                        if (m1.find()) {
                            str_block = m1.group(1);
                        }
                        if (m2.find()) {
                            str_generator = m2.group(1);
                        }
                        if (m3.find()) {
                            str_lib = m3.group(1);
                        }
                        if (str_lib != null && !str_lib.equals("")) {
                            FileUtil.copyFolderTo(new File(String.valueOf(xmlFile.getParent()) + "/" + str_lib), new File(String.valueOf(arduinoPath) + "libraries/" + str_lib));
                        }
                        if (str_block != null && !str_block.equals("")) {
                            FileUtil.copyFileTo(String.valueOf(xmlFile.getParent()) + "/" + str_block, "blockly/blocks/company");
                        }
                        if (str_generator != null && !str_generator.equals("")) {
                            FileUtil.copyFileTo(String.valueOf(xmlFile.getParent()) + "/" + str_generator, "blockly/generators/arduino/company");
                        }
                        if (MyMethod.saveXML(result, newPath)) {
                            MyMethod.setCustom();
                            webEngine.reload();
                            Browser.updateTextArea("\u7035\u714e\u53c6\u934f\ue100\u5f83\u6434\u64b4\u579a\u9354\u71c2\u7d12");
                        } else {
                            Browser.updateTextArea("\u7035\u714e\u53c6\u934f\ue100\u5f83\u6434\u64b3\u3051\u7490\u30ef\u7d12");
                        }
                    } else {
                        Browser.updateTextArea("\u93ae\u3126\u588d\u95ab\u590b\u5ae8\u9428\u52ec\u6783\u6d60\u6735\u7b09\u93c4\ue219\u7af4\u6d93\ue044\u7c31\u93c2\u56e6\u6b22");
                    }
                }
            }
        });
        managerlib.setOnMouseClicked(new EventHandler(){

            public void handle(Event arg0) {
                libmanagerDialog.setLocationRelativeTo(null);
                libmanagerDialog.setVisible(true);
                libmanagerDialog.toFront();
            }
        });
    }

    private void doCompile() {
        try {
            String yuanma = (String)webEngine.executeScript("Blockly.Arduino.workspaceToCode()");
            if (((Boolean)webEngine.executeScript("document.getElementById('tab_arduino').className == 'tabon'")).booleanValue()) {
                yuanma = (String)webEngine.executeScript("document.getElementById('content_arduino').value");
            }
            MyMethod.saveYuanma(yuanma);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Browser.setProgressBar(true);
                    Browser.setProgeresBarNum(0.0);
                    compileSuccess = true;
                    Browser.compile();
                    if (compileSuccess) {
                        Browser.updateTextArea(String.valueOf(LanguageProvider.getLocalString("compile_success")) + "\n");
                    } else {
                        Browser.updateTextArea(String.valueOf(LanguageProvider.getLocalString("compile_failed")) + "\n");
                    }
                    Browser.setProgeresBarNum(1.0);
                    Browser.setProgressBar(false);
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doUpLoad() {
        try {
            String yuanma = (String)webEngine.executeScript("Blockly.Arduino.workspaceToCode()");
            if (((Boolean)webEngine.executeScript("document.getElementById('tab_arduino').className == 'tabon'")).booleanValue()) {
                yuanma = (String)webEngine.executeScript("document.getElementById('content_arduino').value");
            }
            MyMethod.saveYuanma(yuanma);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Browser.setProgressBar(true);
                    Browser.setProgeresBarNum(0.0);
                    uploadSuccess = true;
                    Browser.upload();
                    if (uploadSuccess) {
                        Browser.updateTextArea(String.valueOf(LanguageProvider.getLocalString("upload_success")) + "\n");
                    } else {
                        Browser.updateTextArea(String.valueOf(LanguageProvider.getLocalString("upload_failed")) + "\n");
                    }
                    Browser.setProgeresBarNum(1.0);
                    Browser.setProgressBar(false);
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void layoutChildren() {
        double w = this.getWidth();
        double h = this.getHeight();
        double toolHeight = this.toolBar.getHeight();
        double div = this.sp.getDividerPositions()[0] * h;
        this.layoutInArea(this.sp, 0.0, 0.0, w, h, 0.0, HPos.CENTER, VPos.CENTER);
        output_text.setPrefHeight(h - div - toolHeight);
    }

    private Node createSpacer(double w) {
        Region spacer = new Region();
        spacer.setPrefWidth(w);
        return spacer;
    }

    private Node createSpacer2() {
        Region spacer = new Region();
        HBox.setHgrow(spacer, Priority.ALWAYS);
        return spacer;
    }

    private static void init() {
        arduinoPath = MyMethod.getProp(cofig, "arduinoPath");
        arduino_complie = MyMethod.getProp(cofig, "arduino_complie");
        arduino_save = MyMethod.getProp(cofig, "arduino_save");
        arduino_upload = MyMethod.getProp(cofig, "arduino_upload");
        projectPath = "testArduino";
        serialPort = "COM0";
        releasePath = String.valueOf(projectPath) + "/Release/";
        webPath = String.valueOf(MyMethod.getProp(cofig, "webPath")) + "?lang=" + MyMethod.getProp(cofig, "language");
        if (!webPath.startsWith("http://") && !webPath.startsWith("file:///")) {
            File directory = new File("");
            webPath = "file:///" + directory.getAbsolutePath() + "/" + webPath;
        }
    }

    private static void upload() {
        try {
            serialPort = comboBox.getSelectionModel().getSelectedItem().toString();
            String tmp = boardsComboBox.getSelectionModel().getSelectedItem().toString();
            String cpu = "";
            String tmp2 = tmp;
            if (tmp.contains("[")) {
                tmp2 = tmp.substring(0, tmp.indexOf("["));
                cpu = ":cpu=" + tmp.substring(tmp.indexOf("[") + 1, tmp.length() - 1);
            }
            String board = null;
            String tmpBoardPath = MyMethod.boardName_Path.get(tmp);
            String tmpPreStr = String.valueOf(tmpBoardPath.substring(tmpBoardPath.indexOf("hardware") + 9, tmpBoardPath.lastIndexOf(System.getProperty("file.separator"))).replaceAll("\\\\", ":")) + ":";
            board = String.valueOf(tmpPreStr) + MyMethod.getCompileKeyByBoards(tmpBoardPath, tmp2);
            String cmd_upload = String.valueOf(arduinoPath) + arduino_upload.replace("{board}", board).replace("{cpu}", cpu).replace("{port}", serialPort);
            Browser.clearTextArea();
            String cmd_save = String.valueOf(arduinoPath) + arduino_save.replace("{board}", board).replace("{cpu}", cpu);
            if (shouldSaveConfig) {
                Browser.execcmd(cmd_save);
                shouldSaveConfig = false;
            }
            Browser.execcmd(cmd_upload);
        }
        catch (Exception e) {
            uploadSuccess = false;
        }
    }

    private static void compile() {
        String tmp = boardsComboBox.getSelectionModel().getSelectedItem().toString();
        String cpu = "";
        String tmp2 = tmp;
        if (tmp.contains("[")) {
            tmp2 = tmp.substring(0, tmp.indexOf("["));
            cpu = ":cpu=" + tmp.substring(tmp.indexOf("[") + 1, tmp.length() - 1);
        }
        String board = null;
        String tmpBoardPath = MyMethod.boardName_Path.get(tmp);
        String tmpPreStr = String.valueOf(tmpBoardPath.substring(tmpBoardPath.indexOf("hardware") + 9, tmpBoardPath.lastIndexOf(System.getProperty("file.separator"))).replaceAll("\\\\", ":")) + ":";
        board = String.valueOf(tmpPreStr) + MyMethod.getCompileKeyByBoards(tmpBoardPath, tmp2);
        String cmd_compile = String.valueOf(arduinoPath) + arduino_complie.replace("{board}", board).replace("{cpu}", cpu);
        Browser.clearTextArea();
        String cmd_save = String.valueOf(arduinoPath) + arduino_save.replace("{board}", board).replace("{cpu}", cpu);
        if (shouldSaveConfig) {
            Browser.execcmd(cmd_save);
            shouldSaveConfig = false;
        }
        Browser.execcmd(cmd_compile);
    }

    public static void execcmd(String cmd) {
        Browser.updateTextArea(cmd);
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            OutputStream stdOutput = process.getOutputStream();
            String line = null;
            while ((line = stdInput.readLine()) != null) {
                if (line.contains("error") || line.contains("\u9351\u6d2a\u654a") || line.contains("timeout communicating with programmer")) {
                    compileSuccess = false;
                    uploadSuccess = false;
                }
                Browser.updateTextArea(line);
                if (progress.getProgress() < 1.0) {
                    Browser.setProgeresBarNum(progress.getProgress() + 0.01);
                }
                if (!line.contains("avrdude")) continue;
                stdOutput.flush();
                stdOutput.close();
                break;
            }
            while ((line = stdError.readLine()) != null) {
                if (line.contains("error") || line.contains("\u9351\u6d2a\u654a") || line.contains("timeout communicating with programmer")) {
                    compileSuccess = false;
                    uploadSuccess = false;
                }
                Browser.updateTextArea(line);
                if (!(progress.getProgress() < 1.0)) continue;
                Browser.setProgeresBarNum(progress.getProgress() + 0.01);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void updateTextArea(final String s) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                output_text.appendText(String.valueOf(s) + "\n");
            }
        });
    }

    private static void clearTextArea() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                output_text.setText("");
            }
        });
    }

    private static void setProgressBar(final boolean visible) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                progress.setVisible(visible);
            }
        });
    }

    private static void setProgeresBarNum(double p) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private static void setCom(final String[] s) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                comboBox.getItems().clear();
                comboBox.getItems().addAll(s);
                if (comboBox.getSelectionModel().getSelectedItem() == null) {
                    comboBox.getSelectionModel().selectFirst();
                }
            }
        });
    }

    private void saveCurrentBoard() {
        shouldSaveConfig = true;
        String str = boardsComboBox.getSelectionModel().getSelectedItem().toString();
        MyMethod.changeCurrentBoard(cofig, "currentBoard", str);
    }

    private void setInterruptByBoard(String board) {
        String str = "";
        if (board.startsWith("Arduino Yun") || board.startsWith("Arduino Leonardo") || board.startsWith("Arduino Micro") || board.startsWith("Arduino/Genuino Micro") || board.startsWith("Arduino Esplora") || board.startsWith("LilyPad Arduino USB")) {
            str = "function digitalPinToInterrupt(p) {return ((p) == 0 ? 2 : ((p) == 1 ? 3 : ((p) == 2 ? 1 : ((p) == 3 ? 0 : ((p) == 7 ? 4 : 'NOT_AN_INTERRUPT')))));}";
            str = String.valueOf(str) + "\nprofile[\"default\"] = profile[\"arduino_leonardo\"];";
        } else if (board.startsWith("Arduino Robot Control") || board.startsWith("Arduino Robot Motor")) {
            str = "function digitalPinToInterrupt(p) {return ((p) == 0 ? 2 : ((p) == 1 ? 3 : ((p) == 2 ? 1 : ((p) == 3 ? 0 : ((p) == 7 ? 4 : 'NOT_AN_INTERRUPT')))));}";
            str = String.valueOf(str) + "\nprofile[\"default\"] = profile[\"arduino_robot\"];";
        } else if (board.startsWith("Arduino Mega") || board.startsWith("Arduino/Genuino Mega")) {
            str = "function digitalPinToInterrupt(p) {return ((p) == 2 ? 0 : ((p) == 3 ? 1 : ((p) >= 18 && (p) <= 21 ? 23 - (p) : 'NOT_AN_INTERRUPT')));}";
            str = String.valueOf(str) + "\nprofile[\"default\"] = profile[\"arduino_mega\"];";
        } else if (board.startsWith("Arduino Ethernet")) {
            str = "function digitalPinToInterrupt(p) {return 'NOT_AN_INTERRUPT';}";
            str = String.valueOf(str) + "\nprofile[\"default\"] = profile[\"arduino_ethernet\"];";
        } else if (board.startsWith("Arduino Gemma")) {
            str = "function digitalPinToInterrupt(p) {return 'NOT_AN_INTERRUPT';}";
            str = String.valueOf(str) + "\nprofile[\"default\"] = profile[\"arduino_gemma\"];";
        } else if (board.startsWith("Arduino Uno") || board.startsWith("Arduino/Genuino Uno") || board.startsWith("Arduino Duemilanove or Diecimila") || board.startsWith("LilyPad Arduino[") || board.startsWith("Arduino NG or older")) {
            str = "function digitalPinToInterrupt(p) {return ((p) == 2 ? 0 : ((p) == 3 ? 1 : 'NOT_AN_INTERRUPT'));}";
            str = String.valueOf(str) + "\nprofile[\"default\"] = profile[\"arduino_standard\"];";
        } else if (board.startsWith("Arduino Nano") || board.startsWith("Arduino Mini") || board.startsWith("Arduino Fio") || board.startsWith("Arduino BT") || board.startsWith("Arduino Pro or Pro Mini")) {
            str = "function digitalPinToInterrupt(p) {return ((p) == 2 ? 0 : ((p) == 3 ? 1 : 'NOT_AN_INTERRUPT'));}";
            str = String.valueOf(str) + "\nprofile[\"default\"] = profile[\"arduino_eightanaloginputs\"];";
        } else if (board.startsWith("Generic") || board.startsWith("Adafruit") || board.startsWith("NodeMCU") || board.startsWith("Olimex") || board.startsWith("SparkFun") || board.startsWith("SweetPea")) {
            str = "function digitalPinToInterrupt(p) {return (((p) < 16)?p:'NOT_AN_INTERRUPT');}";
            str = String.valueOf(str) + "\nprofile[\"default\"] = profile[\"arduino_esp8266\"];";
        } else {
            str = "function digitalPinToInterrupt(p) {return ((p) == 2 ? 0 : ((p) == 3 ? 1 : 'NOT_AN_INTERRUPT'));}";
            str = String.valueOf(str) + "\nprofile[\"default\"] = profile[\"arduino_standard\"];";
        }
        MyMethod.saveDigitalPinToInterrupt(str);
        webEngine.executeScript(str);
        webEngine.executeScript("renderContent();");
    }

    public static String getMyTitle() {
        String version = MyMethod.getProp(cofig, "version");
        return "Mixly " + version;
    }

    public static void refreshWeb() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                webEngine.reload();
            }
        });
    }
}

