/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.event.MouseInputAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.Overlay;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.util.resources.ResourceManager;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class ThumbnailDialog
extends JDialog {
    protected static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.ThumbnailDialog";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.ThumbnailDialog", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected JSVGCanvas svgCanvas;
    protected JGVTComponent svgThumbnailCanvas;
    protected boolean documentChanged;
    protected AreaOfInterestOverlay overlay;
    protected AreaOfInterestListener aoiListener;
    protected boolean interactionEnabled = true;

    public ThumbnailDialog(Frame frame, JSVGCanvas jSVGCanvas) {
        super(frame, resources.getString("Dialog.title"));
        this.addWindowListener(new ThumbnailListener());
        this.svgCanvas = jSVGCanvas;
        jSVGCanvas.addGVTTreeRendererListener((GVTTreeRendererListener)new ThumbnailGVTListener());
        jSVGCanvas.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)new ThumbnailDocumentListener());
        jSVGCanvas.addComponentListener((ComponentListener)new ThumbnailCanvasComponentListener());
        this.svgThumbnailCanvas = new JGVTComponent();
        this.overlay = new AreaOfInterestOverlay();
        this.svgThumbnailCanvas.getOverlays().add(this.overlay);
        this.svgThumbnailCanvas.setPreferredSize(new Dimension(150, 150));
        this.svgThumbnailCanvas.addComponentListener((ComponentListener)new ThumbnailComponentListener());
        this.aoiListener = new AreaOfInterestListener();
        this.svgThumbnailCanvas.addMouseListener((MouseListener)this.aoiListener);
        this.svgThumbnailCanvas.addMouseMotionListener((MouseMotionListener)this.aoiListener);
        this.getContentPane().add((Component)this.svgThumbnailCanvas, "Center");
    }

    public void setInteractionEnabled(boolean bl) {
        if (bl == this.interactionEnabled) {
            return;
        }
        this.interactionEnabled = bl;
        if (bl) {
            this.svgThumbnailCanvas.addMouseListener((MouseListener)this.aoiListener);
            this.svgThumbnailCanvas.addMouseMotionListener((MouseMotionListener)this.aoiListener);
        } else {
            this.svgThumbnailCanvas.removeMouseListener((MouseListener)this.aoiListener);
            this.svgThumbnailCanvas.removeMouseMotionListener((MouseMotionListener)this.aoiListener);
        }
    }

    public boolean getInteractionEnabled() {
        return this.interactionEnabled;
    }

    protected void updateThumbnailGraphicsNode() {
        this.svgThumbnailCanvas.setGraphicsNode(this.svgCanvas.getGraphicsNode());
        this.updateThumbnailRenderingTransform();
    }

    protected CanvasGraphicsNode getCanvasGraphicsNode(GraphicsNode graphicsNode) {
        if (!(graphicsNode instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
        List list = compositeGraphicsNode.getChildren();
        if (list.size() == 0) {
            return null;
        }
        graphicsNode = (GraphicsNode)compositeGraphicsNode.getChildren().get(0);
        if (!(graphicsNode instanceof CanvasGraphicsNode)) {
            return null;
        }
        return (CanvasGraphicsNode)graphicsNode;
    }

    protected void updateThumbnailRenderingTransform() {
        SVGDocument sVGDocument = this.svgCanvas.getSVGDocument();
        if (sVGDocument != null) {
            AffineTransform affineTransform;
            AffineTransform affineTransform2;
            Object object;
            SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
            Dimension dimension = this.svgThumbnailCanvas.getSize();
            String string = sVGSVGElement.getAttributeNS(null, "viewBox");
            if (string.length() != 0) {
                object = sVGSVGElement.getAttributeNS(null, "preserveAspectRatio");
                affineTransform2 = ViewBox.getPreserveAspectRatioTransform((Element)sVGSVGElement, string, (String)object, (float)dimension.width, (float)dimension.height, null);
            } else {
                object = this.svgCanvas.getSVGDocumentSize();
                double d = (double)dimension.width / ((Dimension2D)object).getWidth();
                double d2 = (double)dimension.height / ((Dimension2D)object).getHeight();
                double d3 = Math.min(d, d2);
                affineTransform2 = AffineTransform.getScaleInstance(d3, d3);
            }
            object = this.svgCanvas.getGraphicsNode();
            CanvasGraphicsNode canvasGraphicsNode = this.getCanvasGraphicsNode((GraphicsNode)object);
            if (canvasGraphicsNode != null && (affineTransform = canvasGraphicsNode.getViewingTransform()) != null && !affineTransform.isIdentity()) {
                try {
                    AffineTransform affineTransform3 = affineTransform.createInverse();
                    affineTransform2.concatenate(affineTransform3);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            this.svgThumbnailCanvas.setRenderingTransform(affineTransform2);
            this.overlay.synchronizeAreaOfInterest();
        }
    }

    protected class AreaOfInterestOverlay
    implements Overlay {
        protected Shape s;
        protected AffineTransform at;
        protected AffineTransform paintingTransform = new AffineTransform();

        protected AreaOfInterestOverlay() {
        }

        public boolean contains(int n, int n2) {
            return this.s != null ? this.s.contains(n, n2) : false;
        }

        public AffineTransform getOverlayTransform() {
            return this.at;
        }

        public void setPaintingTransform(AffineTransform affineTransform) {
            this.paintingTransform = affineTransform;
        }

        public AffineTransform getPaintingTransform() {
            return this.paintingTransform;
        }

        public void synchronizeAreaOfInterest() {
            this.paintingTransform = new AffineTransform();
            Dimension dimension = ThumbnailDialog.this.svgCanvas.getSize();
            this.s = new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height);
            try {
                this.at = ThumbnailDialog.this.svgCanvas.getRenderingTransform().createInverse();
                this.at.preConcatenate(ThumbnailDialog.this.svgThumbnailCanvas.getRenderingTransform());
                this.s = this.at.createTransformedShape(this.s);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                dimension = ThumbnailDialog.this.svgThumbnailCanvas.getSize();
                this.s = new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height);
            }
        }

        public void paint(Graphics graphics) {
            if (this.s != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.transform(this.paintingTransform);
                graphics2D.setColor(new Color(255, 255, 255, 128));
                graphics2D.fill(this.s);
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(new BasicStroke());
                graphics2D.draw(this.s);
            }
        }
    }

    protected class ThumbnailCanvasComponentListener
    extends ComponentAdapter {
        protected ThumbnailCanvasComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            ThumbnailDialog.this.updateThumbnailRenderingTransform();
        }
    }

    protected class ThumbnailComponentListener
    extends ComponentAdapter {
        protected ThumbnailComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            ThumbnailDialog.this.updateThumbnailRenderingTransform();
        }
    }

    protected class ThumbnailListener
    extends WindowAdapter {
        protected ThumbnailListener() {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            ThumbnailDialog.this.updateThumbnailGraphicsNode();
        }
    }

    protected class ThumbnailGVTListener
    extends GVTTreeRendererAdapter {
        protected ThumbnailGVTListener() {
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
            if (ThumbnailDialog.this.documentChanged) {
                ThumbnailDialog.this.updateThumbnailGraphicsNode();
                ThumbnailDialog.this.documentChanged = false;
            } else {
                ThumbnailDialog.this.overlay.synchronizeAreaOfInterest();
                ThumbnailDialog.this.svgThumbnailCanvas.repaint();
            }
        }

        public void gvtRenderingCancelled(GVTTreeRendererEvent gVTTreeRendererEvent) {
            if (ThumbnailDialog.this.documentChanged) {
                ThumbnailDialog.this.svgThumbnailCanvas.setGraphicsNode(null);
                ThumbnailDialog.this.svgThumbnailCanvas.setRenderingTransform(new AffineTransform());
            }
        }

        public void gvtRenderingFailed(GVTTreeRendererEvent gVTTreeRendererEvent) {
            if (ThumbnailDialog.this.documentChanged) {
                ThumbnailDialog.this.svgThumbnailCanvas.setGraphicsNode(null);
                ThumbnailDialog.this.svgThumbnailCanvas.setRenderingTransform(new AffineTransform());
            }
        }
    }

    protected class AreaOfInterestListener
    extends MouseInputAdapter {
        protected int sx;
        protected int sy;
        protected boolean in;

        protected AreaOfInterestListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.sx = mouseEvent.getX();
            this.sy = mouseEvent.getY();
            this.in = ThumbnailDialog.this.overlay.contains(this.sx, this.sy);
            ThumbnailDialog.this.overlay.setPaintingTransform(new AffineTransform());
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.in) {
                int n = mouseEvent.getX() - this.sx;
                int n2 = mouseEvent.getY() - this.sy;
                ThumbnailDialog.this.overlay.setPaintingTransform(AffineTransform.getTranslateInstance(n, n2));
                ThumbnailDialog.this.svgThumbnailCanvas.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.in) {
                this.in = false;
                int n = mouseEvent.getX() - this.sx;
                int n2 = mouseEvent.getY() - this.sy;
                AffineTransform affineTransform = ThumbnailDialog.this.overlay.getOverlayTransform();
                Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
                Point2D.Float float_2 = new Point2D.Float(n, n2);
                try {
                    affineTransform.inverseTransform(float_, float_);
                    affineTransform.inverseTransform(float_2, float_2);
                    double d = ((Point2D)float_).getX() - ((Point2D)float_2).getX();
                    double d2 = ((Point2D)float_).getY() - ((Point2D)float_2).getY();
                    affineTransform = ThumbnailDialog.this.svgCanvas.getRenderingTransform();
                    affineTransform.preConcatenate(AffineTransform.getTranslateInstance(d, d2));
                    ThumbnailDialog.this.svgCanvas.setRenderingTransform(affineTransform);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
        }
    }

    protected class ThumbnailDocumentListener
    extends SVGDocumentLoaderAdapter {
        protected ThumbnailDocumentListener() {
        }

        public void documentLoadingStarted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            ThumbnailDialog.this.documentChanged = true;
        }
    }
}

