/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.utils.network;

import cc.arduino.net.CustomProxySelector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Observable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.utils.IOUtils;
import processing.app.PreferencesData;

public class FileDownloader
extends Observable {
    private Status status;
    private long initialSize;
    private Long downloadSize = null;
    private long downloaded;
    private final URL downloadUrl;
    private final File outputFile;
    private InputStream stream = null;
    private Exception error;
    private String userAgent;

    public FileDownloader(URL url, File file) {
        this.downloadUrl = url;
        this.outputFile = file;
        this.downloaded = 0L;
        this.initialSize = 0L;
        this.userAgent = "ArduinoIDE/1.8.6 Java/" + System.getProperty("java.version");
    }

    public long getInitialSize() {
        return this.initialSize;
    }

    public Long getDownloadSize() {
        return this.downloadSize;
    }

    public void setDownloadSize(Long downloadSize) {
        this.downloadSize = downloadSize;
        this.setChanged();
        this.notifyObservers();
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    private void setDownloaded(long downloaded) {
        this.downloaded = downloaded;
        this.setChanged();
        this.notifyObservers();
    }

    public float getProgress() {
        if (this.downloadSize == null) {
            return 0.0f;
        }
        if (this.downloadSize == 0L) {
            return 100.0f;
        }
        return (float)this.downloaded / (float)this.downloadSize.longValue() * 100.0f;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
        this.setChanged();
        this.notifyObservers();
    }

    public void download() throws InterruptedException {
        if ("file".equals(this.downloadUrl.getProtocol())) {
            this.saveLocalFile();
        } else {
            this.downloadFile();
        }
    }

    private void saveLocalFile() {
        try {
            Files.write(this.outputFile.toPath(), Files.readAllBytes(Paths.get(this.downloadUrl.getPath(), new String[0])), new OpenOption[0]);
            this.setStatus(Status.COMPLETE);
        }
        catch (Exception e) {
            this.setStatus(Status.ERROR);
            this.setError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile() throws InterruptedException {
        block30: {
            RandomAccessFile file = null;
            try {
                file = new RandomAccessFile(this.outputFile, "rw");
                this.initialSize = file.length();
                file.seek(this.initialSize);
                this.setStatus(Status.CONNECTING);
                Proxy proxy = new CustomProxySelector(PreferencesData.getMap()).getProxyFor(this.downloadUrl.toURI());
                if ("true".equals(System.getProperty("DEBUG"))) {
                    System.err.println("Using proxy " + proxy);
                }
                HttpURLConnection connection = (HttpURLConnection)this.downloadUrl.openConnection(proxy);
                connection.setRequestProperty("User-agent", this.userAgent);
                if (this.downloadUrl.getUserInfo() != null) {
                    String auth = "Basic " + new String(new Base64().encode(this.downloadUrl.getUserInfo().getBytes()));
                    connection.setRequestProperty("Authorization", auth);
                }
                connection.setRequestProperty("Range", "bytes=" + this.initialSize + "-");
                connection.setConnectTimeout(5000);
                this.setDownloaded(0L);
                connection.connect();
                int resp = connection.getResponseCode();
                if (resp == 301 || resp == 302) {
                    URL newUrl = new URL(connection.getHeaderField("Location"));
                    proxy = new CustomProxySelector(PreferencesData.getMap()).getProxyFor(newUrl.toURI());
                    connection = (HttpURLConnection)newUrl.openConnection(proxy);
                    connection.setRequestProperty("User-agent", this.userAgent);
                    if (this.downloadUrl.getUserInfo() != null) {
                        String auth = "Basic " + new String(new Base64().encode(this.downloadUrl.getUserInfo().getBytes()));
                        connection.setRequestProperty("Authorization", auth);
                    }
                    connection.setRequestProperty("Range", "bytes=" + this.initialSize + "-");
                    connection.setConnectTimeout(5000);
                    connection.connect();
                    resp = connection.getResponseCode();
                }
                if (resp < 200 || resp >= 300) {
                    throw new IOException("Received invalid http status code from server: " + resp);
                }
                long len = connection.getContentLength();
                if (len >= 0L) {
                    this.setDownloadSize(len);
                }
                this.setStatus(Status.DOWNLOADING);
                FileDownloader fileDownloader = this;
                synchronized (fileDownloader) {
                    this.stream = connection.getInputStream();
                }
                byte[] buffer = new byte[10240];
                while (this.status == Status.DOWNLOADING) {
                    int read = this.stream.read(buffer);
                    if (read == -1) break;
                    file.write(buffer, 0, read);
                    this.setDownloaded(this.getDownloaded() + (long)read);
                    if (!Thread.interrupted()) continue;
                    file.close();
                    throw new InterruptedException();
                }
                if (this.getDownloadSize() != null && this.getDownloaded() < this.getDownloadSize()) {
                    throw new Exception("Incomplete download");
                }
                this.setStatus(Status.COMPLETE);
            }
            catch (InterruptedException e) {
                this.setStatus(Status.CANCELLED);
                throw e;
            }
            catch (SocketTimeoutException e) {
                this.setStatus(Status.CONNECTION_TIMEOUT_ERROR);
                this.setError(e);
                IOUtils.closeQuietly(file);
                FileDownloader fileDownloader = this;
                synchronized (fileDownloader) {
                    IOUtils.closeQuietly(this.stream);
                    break block30;
                }
            }
            catch (Exception e) {
                try {
                    this.setStatus(Status.ERROR);
                    this.setError(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(file);
                    FileDownloader fileDownloader = this;
                    synchronized (fileDownloader) {
                        IOUtils.closeQuietly(this.stream);
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly(file);
                FileDownloader fileDownloader = this;
                synchronized (fileDownloader) {
                    IOUtils.closeQuietly(this.stream);
                    break block30;
                }
            }
            IOUtils.closeQuietly(file);
            FileDownloader fileDownloader = this;
            synchronized (fileDownloader) {
                IOUtils.closeQuietly(this.stream);
            }
        }
    }

    private void setError(Exception e) {
        this.error = e;
    }

    public Exception getError() {
        return this.error;
    }

    public boolean isCompleted() {
        return this.status == Status.COMPLETE;
    }

    public static enum Status {
        CONNECTING,
        CONNECTION_TIMEOUT_ERROR,
        DOWNLOADING,
        COMPLETE,
        CANCELLED,
        ERROR;

    }
}

