/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.uploaders;

import cc.arduino.CompilerUtils;
import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Uploader;
import cc.arduino.packages.ssh.NoInteractionUserInfo;
import cc.arduino.packages.ssh.SCP;
import cc.arduino.packages.ssh.SSH;
import cc.arduino.packages.ssh.SSHConfigFileSetup;
import cc.arduino.packages.ssh.SSHPwdSetup;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.debug.RunnerException;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.PreferencesMapException;
import processing.app.helpers.StringReplacer;
import processing.app.helpers.StringUtils;

public class SSHUploader
extends Uploader {
    private static final List<String> FILES_NOT_TO_COPY = Arrays.asList(".DS_Store", ".Trash", "Thumbs.db", "__MACOSX");
    private final BoardPort port;

    public SSHUploader(BoardPort port) {
        this.port = port;
    }

    @Override
    public boolean requiresAuthorization() {
        return true;
    }

    @Override
    public String getAuthorizationKey() {
        return "runtime.pwd." + this.port.getAddress();
    }

    @Override
    public boolean uploadUsingPreferences(File sourcePath, String buildPath, String className, boolean usingProgrammer, List<String> warningsAccumulator) throws RunnerException, PreferencesMapException {
        String tool;
        if (usingProgrammer) {
            throw new RunnerException(I18n.tr("Network upload using programmer not supported"));
        }
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        PreferencesMap prefs = PreferencesData.getMap();
        PreferencesMap boardPreferences = BaseNoGui.getBoardPreferences();
        if (boardPreferences != null) {
            prefs.putAll(boardPreferences);
        }
        if ((tool = prefs.getOrExcept("upload.tool")).contains(":")) {
            String[] split = tool.split(":", 2);
            targetPlatform = BaseNoGui.getCurrentTargetPlatformFromPackage(split[0]);
            tool = split[1];
        }
        prefs.putAll(targetPlatform.getTool(tool));
        boolean coreMissesRemoteUploadTool = targetPlatform.getTool(String.valueOf(tool) + "_remote").isEmpty();
        if (coreMissesRemoteUploadTool) {
            prefs.put("upload.pattern", "/usr/bin/run-avrdude /tmp/sketch.hex");
        } else {
            prefs.putAll(targetPlatform.getTool(String.valueOf(tool) + "_remote"));
        }
        prefs.put("build.path", buildPath);
        prefs.put("build.project_name", className);
        Session session = null;
        SCP scp = null;
        try {
            JSch jSch = new JSch();
            SSHConfigFileSetup sshClientSetupChain = new SSHConfigFileSetup(new SSHPwdSetup());
            session = sshClientSetupChain.setup(this.port, jSch);
            session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
            session.setUserInfo(new NoInteractionUserInfo(PreferencesData.get("runtime.pwd." + this.port.getAddress())));
            session.connect(30000);
            scp = new SCP(session);
            SSH ssh = new SSH(session);
            File mergedSketch = new File(buildPath, String.valueOf(className) + ".with_bootloader.hex");
            File sketchToCopy = !coreMissesRemoteUploadTool && mergedSketch.exists() ? mergedSketch : new CompilerUtils().findCompiledSketch(prefs);
            this.scpFiles(scp, ssh, sourcePath, sketchToCopy, warningsAccumulator);
            if (coreMissesRemoteUploadTool) {
                ssh.execSyncCommand("merge-sketch-with-bootloader.lua /tmp/sketch.hex", System.out, System.err);
            }
            boolean bl = this.runUploadTool(ssh, prefs);
            return bl;
        }
        catch (JSchException e) {
            String message = e.getMessage();
            if (message.contains("Auth cancel") || message.contains("Auth fail") || message.contains("authentication fail")) {
                return false;
            }
            if (e.getMessage().contains("Connection refused")) {
                throw new RunnerException(I18n.format(I18n.tr("Unable to connect to {0}"), this.port.getAddress()));
            }
            throw new RunnerException(e);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
        finally {
            if (scp != null) {
                scp.close();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    private boolean runUploadTool(SSH ssh, PreferencesMap prefs) throws Exception {
        ssh.execSyncCommand("kill-bridge");
        if (this.verbose) {
            prefs.put("upload.verbose", prefs.getOrExcept("upload.params.verbose"));
        } else {
            prefs.put("upload.verbose", prefs.getOrExcept("upload.params.quiet"));
        }
        String pattern = prefs.getOrExcept("upload.pattern");
        String command = StringUtils.join(StringReplacer.formatAndSplit(pattern, prefs, true), " ");
        if (this.verbose) {
            System.out.println(command);
        }
        return ssh.execSyncCommand(command, System.out, System.err);
    }

    private void scpFiles(SCP scp, SSH ssh, File sourcePath, File sketch, List<String> warningsAccumulator) throws JSchException, IOException {
        String uploadedSketchFileName = sketch.getName().endsWith("hex") ? "sketch.hex" : "sketch.bin";
        try {
            scp.open();
            scp.startFolder("tmp");
            scp.sendFile(sketch, uploadedSketchFileName);
            scp.endFolder();
            if (this.canUploadWWWFiles(sourcePath, ssh, warningsAccumulator)) {
                scp.startFolder("www");
                scp.startFolder("sd");
                scp.startFolder(sourcePath.getName());
                this.recursiveSCP(new File(sourcePath, "www"), scp);
                scp.endFolder();
                scp.endFolder();
                scp.endFolder();
            }
        }
        finally {
            scp.close();
        }
    }

    private boolean canUploadWWWFiles(File sourcePath, SSH ssh, List<String> warningsAccumulator) throws IOException, JSchException {
        File www = new File(sourcePath, "www");
        if (!www.exists() || !www.isDirectory()) {
            return false;
        }
        if (!www.canExecute()) {
            warningsAccumulator.add(I18n.format(I18n.tr("Problem accessing files in folder \"{0}\""), www));
            return false;
        }
        if (!ssh.execSyncCommand("special-storage-available")) {
            warningsAccumulator.add(I18n.tr("Problem accessing board folder /www/sd"));
            return false;
        }
        return true;
    }

    private void recursiveSCP(File from, SCP scp) throws IOException {
        File[] files = from.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!StringUtils.stringContainsOneOf(file.getName(), FILES_NOT_TO_COPY)) {
                if (file.isDirectory() && file.canExecute()) {
                    scp.startFolder(file.getName());
                    this.recursiveSCP(file, scp);
                    scp.endFolder();
                } else if (file.isFile() && file.canRead()) {
                    scp.sendFile(file);
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean burnBootloader() throws RunnerException {
        throw new RunnerException("Can't burn bootloader via SSH");
    }
}

