/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.os.windows;

import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import processing.app.PreferencesData;

public class Win32KnownFolders {
    public static File getLocalAppDataFolder() {
        try {
            return new File(Shell32Util.getKnownFolderPath(KnownFolders.FOLDERID_LocalAppData));
        }
        catch (Throwable throwable) {
            return new File(Shell32Util.getFolderPath(28));
        }
    }

    public static File getRoamingAppDataFolder() {
        try {
            return new File(Shell32Util.getKnownFolderPath(KnownFolders.FOLDERID_RoamingAppData));
        }
        catch (Throwable throwable) {
            return new File(Shell32Util.getFolderPath(26));
        }
    }

    public static File getDocumentsFolder() {
        try {
            return new File(Shell32Util.getKnownFolderPath(KnownFolders.FOLDERID_Documents));
        }
        catch (Throwable throwable) {
            return new File(Shell32Util.getFolderPath(5));
        }
    }

    public static File getLocalCacheFolder() throws FileNotFoundException {
        if (!PreferencesData.getBoolean("runtime.is-windows-store-app")) {
            throw new FileNotFoundException();
        }
        String localAppData = Shell32Util.getKnownFolderPath(KnownFolders.FOLDERID_LocalAppData);
        String appId = PreferencesData.get("runtime.windows-store-app.id");
        return Paths.get(localAppData, "Packages", appId, "LocalCache").toFile();
    }
}

