/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.contributions.DownloadableContribution;
import processing.app.Platform;

public abstract class HostDependentDownloadableContribution
extends DownloadableContribution {
    public abstract String getHost();

    @Override
    public String toString() {
        return String.valueOf(this.getHost()) + " " + super.toString();
    }

    public boolean isCompatible(Platform platform) {
        String osName = platform.getOsName();
        assert (osName != null);
        String osArch = platform.getOsArch();
        assert (osArch != null);
        String host = this.getHost();
        if (osName.contains("Linux")) {
            if (osArch.equals("arm")) {
                return host.matches("arm.*-linux-gnueabihf");
            }
            if (osArch.contains("amd64")) {
                return host.matches("x86_64-.*linux-gnu");
            }
            return host.matches("i[3456]86-.*linux-gnu");
        }
        if (osName.contains("Windows")) {
            return host.matches("i[3456]86-.*mingw32") || host.matches("i[3456]86-.*cygwin");
        }
        if (osName.contains("Mac")) {
            if (osArch.contains("x86_64")) {
                return host.matches("x86_64-apple-darwin.*") || host.matches("i[3456]86-apple-darwin.*");
            }
            return host.matches("i[3456]86-apple-darwin.*");
        }
        if (osName.contains("FreeBSD")) {
            if (osArch.contains("arm")) {
                return host.matches("arm.*-freebsd[0-9]*");
            }
            return host.matches(String.valueOf(osArch) + "-freebsd[0-9]*");
        }
        return false;
    }
}

