/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.contributions.packages.ContributedBoard;
import cc.arduino.contributions.packages.ContributedHelp;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributedTool;
import cc.arduino.contributions.packages.ContributedToolReference;
import java.util.List;

public abstract class ContributedPackage {
    private boolean trusted;

    public abstract String getName();

    public abstract String getMaintainer();

    public abstract String getWebsiteURL();

    public abstract String getEmail();

    public abstract List<ContributedPlatform> getPlatforms();

    public abstract List<ContributedTool> getTools();

    public abstract ContributedHelp getHelp();

    public ContributedPlatform findPlatform(String architecture, String version) {
        if (architecture == null || version == null) {
            return null;
        }
        for (ContributedPlatform platform : this.getPlatforms()) {
            if (!platform.getArchitecture().equals(architecture) || !version.equals(platform.getParsedVersion())) continue;
            return platform;
        }
        return null;
    }

    public ContributedTool findTool(String name, String version) {
        if (this.getTools() == null) {
            return null;
        }
        for (ContributedTool tool : this.getTools()) {
            if (!tool.getName().equals(name) || !tool.getVersion().equals(version)) continue;
            return tool;
        }
        return null;
    }

    public ContributedTool findResolvedTool(String toolName, String version) {
        for (ContributedPlatform platform : this.getPlatforms()) {
            for (ContributedTool tool : platform.getResolvedTools()) {
                if (!toolName.equals(tool.getName()) || !version.equals(tool.getVersion())) continue;
                return tool;
            }
        }
        return null;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public String toString() {
        String res = "Package name      : " + this.getName() + "\n";
        res = String.valueOf(res) + "        maintaner : " + this.getMaintainer() + " (" + this.getEmail() + ")\n";
        if (this.getPlatforms() != null) {
            for (ContributedPlatform plat : this.getPlatforms()) {
                res = String.valueOf(res) + "\n        Plaform   : name         : " + plat.getName();
                if (plat.isInstalled()) {
                    res = String.valueOf(res) + "\n                    " + plat;
                }
                res = String.valueOf(res) + "\n                    category     : " + plat.getCategory();
                res = String.valueOf(res) + "\n                    architecture : " + plat.getArchitecture() + " " + plat.getParsedVersion() + "\n";
                if (plat.getToolsDependencies() != null) {
                    for (ContributedToolReference t : plat.getToolsDependencies()) {
                        res = String.valueOf(res) + "                    tool dep     : " + t.getName() + " " + t.getVersion() + "\n";
                    }
                }
                if (plat.getBoards() == null) continue;
                for (ContributedBoard board : plat.getBoards()) {
                    res = String.valueOf(res) + "                    board        : " + board.getName() + "\n";
                }
            }
        }
        if (this.getTools() != null) {
            for (ContributedTool tool : this.getTools()) {
                res = String.valueOf(res) + tool + "\n";
            }
        }
        return res;
    }
}

