/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries;

import cc.arduino.Constants;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.EmptyLibrariesIndex;
import cc.arduino.contributions.libraries.LibrariesIndex;
import cc.arduino.contributions.libraries.filters.LibraryInstalledInsideCore;
import cc.arduino.contributions.libraries.filters.TypePredicate;
import cc.arduino.contributions.packages.ContributedPlatform;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.mrbean.MrBeanModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.utils.IOUtils;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.helpers.FileUtils;
import processing.app.helpers.filefilters.OnlyDirs;
import processing.app.packages.LegacyUserLibrary;
import processing.app.packages.LibraryList;
import processing.app.packages.UserLibrary;

public class LibrariesIndexer {
    private LibrariesIndex index;
    private final LibraryList installedLibraries = new LibraryList();
    private final LibraryList installedLibrariesWithDuplicates = new LibraryList();
    private List<File> librariesFolders;
    private final File indexFile;
    private final File stagingFolder;
    private File sketchbookLibrariesFolder;
    private final List<String> badLibNotified = new ArrayList<String>();

    public LibrariesIndexer(File preferencesFolder) {
        this.indexFile = new File(preferencesFolder, "library_index.json");
        this.stagingFolder = new File(new File(preferencesFolder, "staging"), "libraries");
    }

    public void parseIndex() throws IOException {
        if (!this.indexFile.exists()) {
            this.index = new EmptyLibrariesIndex();
        } else {
            this.parseIndex(this.indexFile);
        }
    }

    private void parseIndex(File file) throws IOException {
        FileInputStream indexIn = null;
        try {
            indexIn = new FileInputStream(file);
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule(new MrBeanModule());
            mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            mapper.configure(DeserializationFeature.EAGER_DESERIALIZER_FETCH, true);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.index = mapper.readValue((InputStream)indexIn, LibrariesIndex.class);
            this.index.getLibraries().stream().filter(library -> library.getCategory() == null || "".equals(library.getCategory()) || !Constants.LIBRARY_CATEGORIES.contains(library.getCategory())).forEach(library -> library.setCategory("Uncategorized"));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(indexIn);
            throw throwable;
        }
        IOUtils.closeQuietly(indexIn);
    }

    public void setLibrariesFolders(List<File> _librariesFolders) {
        this.librariesFolders = _librariesFolders;
        this.rescanLibraries();
    }

    public void rescanLibraries() {
        this.installedLibraries.clear();
        this.installedLibrariesWithDuplicates.clear();
        if (this.index.getLibraries() == null) {
            return;
        }
        for (ContributedLibrary lib : this.index.getLibraries()) {
            lib.setInstalled(false);
        }
        for (File folder : this.librariesFolders) {
            this.scanInstalledLibraries(folder, folder.equals(this.sketchbookLibrariesFolder));
        }
        this.installedLibraries.stream().filter(new TypePredicate("Contributed")).filter(new LibraryInstalledInsideCore()).forEach(userLibrary -> {
            ContributedPlatform platform = BaseNoGui.indexer.getPlatformByFolder(userLibrary.getInstalledFolder());
            userLibrary.setTypes(Collections.singletonList(platform.getCategory()));
        });
    }

    private void scanInstalledLibraries(File folder, boolean isSketchbook) {
        File[] list = folder.listFiles(OnlyDirs.ONLY_DIRS);
        if (list == null) {
            return;
        }
        File[] fileArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File subfolder = fileArray[n2];
            if (!BaseNoGui.isSanitaryName(subfolder.getName())) {
                if (!this.badLibNotified.contains(subfolder.getName())) {
                    this.badLibNotified.add(subfolder.getName());
                    String mess = I18n.format(I18n.tr("The library \"{0}\" cannot be used.\nLibrary names must contain only basic letters and numbers.\n(ASCII only and no spaces, and it cannot start with a number)"), subfolder.getName());
                    BaseNoGui.showMessage(I18n.tr("Ignoring bad library name"), mess);
                }
            } else {
                try {
                    this.scanLibrary(subfolder, isSketchbook);
                }
                catch (IOException e) {
                    System.out.println(I18n.format(I18n.tr("Invalid library found in {0}: {1}"), subfolder, e.getMessage()));
                }
            }
            ++n2;
        }
    }

    private void scanLibrary(File folder, boolean isSketchbook) throws IOException {
        boolean readOnly = !FileUtils.isSubDirectory(this.sketchbookLibrariesFolder, folder);
        File check = new File(folder, "library.properties");
        if (!check.exists() || !check.isFile()) {
            LegacyUserLibrary lib = LegacyUserLibrary.create(folder);
            lib.setReadOnly(readOnly);
            String[] headers = BaseNoGui.headerListFromIncludePath(lib.getSrcFolder());
            if (headers.length == 0) {
                throw new IOException(lib.getSrcFolder().getAbsolutePath());
            }
            this.installedLibraries.addOrReplace(lib);
            if (isSketchbook) {
                this.installedLibrariesWithDuplicates.add(lib);
            } else {
                this.installedLibrariesWithDuplicates.addOrReplace(lib);
            }
            return;
        }
        UserLibrary lib = UserLibrary.create(folder);
        lib.setReadOnly(readOnly);
        String[] headers = BaseNoGui.headerListFromIncludePath(lib.getSrcFolder());
        if (headers.length == 0) {
            throw new IOException(lib.getSrcFolder().getAbsolutePath());
        }
        this.installedLibraries.addOrReplaceArchAware(lib);
        if (isSketchbook) {
            this.installedLibrariesWithDuplicates.add(lib);
        } else {
            this.installedLibrariesWithDuplicates.addOrReplaceArchAware(lib);
        }
        ContributedLibrary foundLib = this.index.find(lib.getName(), lib.getParsedVersion());
        if (foundLib != null) {
            foundLib.setInstalled(true);
            foundLib.setInstalledFolder(folder);
            foundLib.setReadOnly(readOnly);
            lib.setTypes(foundLib.getTypes());
        }
        if (lib.isReadOnly() && lib.getTypes() == null && !lib.getDeclaredTypes().isEmpty()) {
            lib.setTypes(lib.getDeclaredTypes());
        }
        if (lib.getTypes() == null) {
            lib.setTypes(Collections.singletonList("Contributed"));
        }
    }

    public LibrariesIndex getIndex() {
        return this.index;
    }

    public LibraryList getInstalledLibraries() {
        return new LibraryList(this.installedLibraries);
    }

    public LibraryList getInstalledLibrariesWithDuplicates() {
        return this.installedLibrariesWithDuplicates;
    }

    public File getStagingFolder() {
        return this.stagingFolder;
    }

    public void setSketchbookLibrariesFolder(File folder) {
        this.sketchbookLibrariesFolder = folder;
    }

    public File getSketchbookLibrariesFolder() {
        return this.sketchbookLibrariesFolder;
    }

    public File getIndexFile() {
        return this.indexFile;
    }
}

