/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.libraries.ContributedLibraryReference;
import java.util.Comparator;
import java.util.List;
import processing.app.I18n;

public abstract class ContributedLibrary
extends DownloadableContribution {
    public static final Comparator<ContributedLibrary> CASE_INSENSITIVE_ORDER = (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());

    public abstract String getName();

    public abstract String getMaintainer();

    public abstract String getAuthor();

    public abstract String getWebsite();

    public abstract String getCategory();

    public abstract void setCategory(String var1);

    public abstract String getLicense();

    public abstract String getParagraph();

    public abstract String getSentence();

    public abstract List<String> getArchitectures();

    public abstract List<String> getTypes();

    public abstract List<ContributedLibraryReference> getRequires();

    public boolean supportsArchitecture(String reqArch) {
        return this.getArchitectures().contains(reqArch) || this.getArchitectures().contains("*");
    }

    public boolean supportsArchitecture(List<String> reqArchs) {
        if (reqArchs.contains("*")) {
            return true;
        }
        for (String reqArch : reqArchs) {
            if (!this.supportsArchitecture(reqArch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return I18n.format(I18n.tr("Version {0}"), this.getParsedVersion());
    }

    public String info() {
        String res = "";
        res = String.valueOf(res) + "  ContributedLibrary : " + this.getName() + "\n";
        res = String.valueOf(res) + "              author : " + this.getAuthor() + "\n";
        res = String.valueOf(res) + "          maintainer : " + this.getMaintainer() + "\n";
        res = String.valueOf(res) + "             version : " + this.getParsedVersion() + "\n";
        res = String.valueOf(res) + "             website : " + this.getUrl() + "\n";
        res = String.valueOf(res) + "            category : " + this.getCategory() + "\n";
        res = String.valueOf(res) + "             license : " + this.getLicense() + "\n";
        res = String.valueOf(res) + "             descrip : " + this.getSentence() + "\n";
        if (this.getParagraph() != null && !this.getParagraph().isEmpty()) {
            res = String.valueOf(res) + "                       " + this.getParagraph() + "\n";
        }
        res = String.valueOf(res) + "       architectures : ";
        if (this.getArchitectures() != null) {
            for (String a : this.getArchitectures()) {
                res = String.valueOf(res) + a + ",";
            }
        }
        res = String.valueOf(res) + "\n";
        res = String.valueOf(res) + "            requires :\n";
        if (this.getRequires() != null) {
            for (ContributedLibraryReference r : this.getRequires()) {
                res = String.valueOf(res) + "                       " + r;
            }
        }
        res = String.valueOf(res) + "\n";
        res = String.valueOf(res) + super.toString();
        return res;
    }

    public boolean equals(Object obj) {
        boolean nameEquals;
        boolean versionEquals;
        if (!(obj instanceof ContributedLibrary)) {
            return false;
        }
        ContributedLibrary other = (ContributedLibrary)obj;
        String thisVersion = this.getParsedVersion();
        String otherVersion = other.getParsedVersion();
        boolean bl = versionEquals = thisVersion != null && otherVersion != null && thisVersion.equals(otherVersion);
        if (thisVersion == null && otherVersion == null) {
            versionEquals = true;
        }
        String thisName = this.getName();
        String otherName = other.getName();
        boolean bl2 = nameEquals = thisName == null || otherName == null || thisName.equals(otherName);
        return versionEquals && nameEquals;
    }
}

