/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.text.StyleContext;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesHelper;
import processing.app.helpers.PreferencesMap;

public class Theme {
    static PreferencesMap defaults;
    static PreferencesMap table;

    protected static void init() {
        try {
            table.load(new File(BaseNoGui.getContentFile((String)"lib"), "theme/theme.txt"));
        }
        catch (Exception te) {
            Base.showError(null, I18n.tr((String)"Could not read color theme settings.\nYou'll need to reinstall Arduino."), te);
        }
        Theme.setColor("run.window.bgcolor", SystemColor.control);
        defaults = new PreferencesMap((Map)table);
    }

    public static String get(String attribute) {
        return (String)table.get((Object)attribute);
    }

    public static String getDefault(String attribute) {
        return (String)defaults.get((Object)attribute);
    }

    public static void set(String attribute, String value) {
        table.put((Object)attribute, (Object)value);
    }

    public static boolean getBoolean(String attribute) {
        return table.getBoolean(attribute);
    }

    public static void setBoolean(String attribute, boolean value) {
        table.putBoolean(attribute, value);
    }

    public static int getInteger(String attribute) {
        return Integer.parseInt(Theme.get(attribute));
    }

    public static void setInteger(String key, int value) {
        Theme.set(key, String.valueOf(value));
    }

    public static int getScale() {
        try {
            int scale = PreferencesData.getInteger((String)"gui.scale", (int)-1);
            if (scale != -1) {
                return scale;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return BaseNoGui.getPlatform().getSystemDPI() * 100 / 96;
    }

    public static int scale(int size) {
        return size * Theme.getScale() / 100;
    }

    public static Dimension scale(Dimension dim) {
        return new Dimension(Theme.scale(dim.width), Theme.scale(dim.height));
    }

    public static Font scale(Font font) {
        float size = Theme.scale(font.getSize());
        Font scaled = font.deriveFont(size);
        return scaled;
    }

    public static Rectangle scale(Rectangle rect) {
        Rectangle res = new Rectangle(rect);
        res.x = Theme.scale(res.x);
        res.y = Theme.scale(res.y);
        res.width = Theme.scale(res.width);
        res.height = Theme.scale(res.height);
        return res;
    }

    public static Color getColorCycleColor(String name, int i) {
        int cycleSize = Theme.getInteger(name + ".size");
        name = String.format("%s.%02d", name, i % cycleSize);
        return PreferencesHelper.parseColor((String)Theme.get(name));
    }

    public static void setColorCycleColor(String name, int i, Color color) {
        name = String.format("%s.%02d", name, i);
        PreferencesHelper.putColor((PreferencesMap)table, (String)name, (Color)color);
        int cycleSize = Theme.getInteger(name + ".size");
        Theme.setInteger(name + ".size", i + 1 > cycleSize ? i + 1 : cycleSize);
    }

    public static Color getColor(String name) {
        return PreferencesHelper.parseColor((String)Theme.get(name));
    }

    public static void setColor(String attr, Color color) {
        PreferencesHelper.putColor((PreferencesMap)table, (String)attr, (Color)color);
    }

    public static Font getFont(String attr) {
        Font font = PreferencesHelper.getFont((PreferencesMap)table, (String)attr);
        if (font == null) {
            String value = Theme.getDefault(attr);
            Theme.set(attr, value);
            font = PreferencesHelper.getFont((PreferencesMap)table, (String)attr);
        }
        return font.deriveFont((float)Theme.scale(font.getSize()));
    }

    public static final Font getDefaultFont() {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        Font font = null;
        if (OSUtils.isMacOS()) {
            font = sc.getFont("Menlo", 0, 12);
            if (!"Menlo".equals(font.getFamily()) && !"Monaco".equals((font = sc.getFont("Monaco", 0, 12)).getFamily())) {
                font = sc.getFont("Monospaced", 0, 13);
            }
        } else {
            font = sc.getFont("Consolas", 0, 13);
            if (!"Consolas".equals(font.getFamily())) {
                font = sc.getFont("Monospaced", 0, 13);
            }
        }
        return font;
    }

    public static Map<String, Object> getStyledFont(String what, Font font) {
        String[] split = Theme.get("editor." + what + ".style").split(",");
        Color color = PreferencesHelper.parseColor((String)split[0]);
        String style = split[1];
        boolean bold = style.contains("bold");
        boolean italic = style.contains("italic");
        boolean underlined = style.contains("underlined");
        Font styledFont = new Font(font.getFamily(), (bold ? 1 : 0) | (italic ? 2 : 0), font.getSize());
        if (underlined) {
            Hashtable<TextAttribute, Integer> attr = new Hashtable<TextAttribute, Integer>();
            attr.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            styledFont = styledFont.deriveFont(attr);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("color", color);
        result.put("font", styledFont);
        return result;
    }

    public static Image getLibImage(String filename, Component who, int width, int height) {
        File libFolder = BaseNoGui.getContentFile((String)"lib");
        Image image = null;
        File vectorFile = new File(libFolder, filename + ".svg");
        if (vectorFile.exists()) {
            try {
                image = Theme.imageFromSVG(vectorFile.toURI().toURL(), width, height);
            }
            catch (Exception e) {
                System.err.println("Failed to load " + vectorFile.getAbsolutePath() + ": " + e.getMessage());
            }
        }
        if (image == null) {
            File bitmapFile = new File(libFolder, filename + ".png");
            File bitmap2xFile = new File(libFolder, filename + "@2x.png");
            File imageFile = Theme.getScale() > 125 && bitmap2xFile.exists() || !bitmapFile.exists() ? bitmap2xFile : bitmapFile;
            Toolkit tk = Toolkit.getDefaultToolkit();
            image = tk.getImage(imageFile.getAbsolutePath());
        }
        MediaTracker tracker = new MediaTracker(who);
        try {
            tracker.addImage(image, 0);
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (image.getWidth(null) != width || image.getHeight(null) != height) {
            image = image.getScaledInstance(width, height, 4);
            try {
                tracker.addImage(image, 1);
                tracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return image;
    }

    public static Image getThemeImage(String name, Component who, int width, int height) {
        return Theme.getLibImage("theme/" + name, who, width, height);
    }

    private static Image imageFromSVG(URL url, int width, int height) throws TranscoderException {
        PNGTranscoder t = new PNGTranscoder();
        t.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)new Float(width));
        t.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)new Float(height));
        TranscoderInput input = new TranscoderInput(url.toString());
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
        t.transcode(input, output);
        byte[] imgData = ostream.toByteArray();
        return Toolkit.getDefaultToolkit().createImage(imgData);
    }

    public static Graphics2D setupGraphics2D(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        if (PreferencesData.getBoolean((String)"editor.antialias")) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return g;
    }

    static {
        table = new PreferencesMap();
    }
}

