/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Theme;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMap;

public class EditorLineStatus
extends JComponent {
    int start = -1;
    int stop;
    Image resize;
    private static final int RESIZE_IMAGE_SIZE = Theme.scale(20);
    Color foreground;
    Color background = Theme.getColor("linestatus.bgcolor");
    Color messageForeground;
    Font font = Theme.getFont("linestatus.font");
    int height;
    String text = "";
    String name = "";
    String serialport = "";
    String serialnumber = "";

    public EditorLineStatus() {
        this.foreground = Theme.getColor("linestatus.color");
        this.height = Theme.getInteger("linestatus.height");
        if (OSUtils.isMacOS()) {
            this.resize = Theme.getThemeImage("resize", this, RESIZE_IMAGE_SIZE, RESIZE_IMAGE_SIZE);
        }
    }

    public void set(int newStart, int newStop) {
        if (newStart == this.start && newStop == this.stop) {
            return;
        }
        this.start = newStart;
        this.stop = newStop;
        this.text = this.start == this.stop ? String.valueOf(this.start + 1) : this.start + 1 + " - " + (this.stop + 1);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D g = Theme.setupGraphics2D(graphics);
        if (this.name.isEmpty() && this.serialport.isEmpty()) {
            PreferencesMap boardPreferences = BaseNoGui.getBoardPreferences();
            if (boardPreferences != null) {
                this.setBoardName((String)boardPreferences.get((Object)"name"));
            } else {
                this.setBoardName("-");
            }
            this.setSerialPort(PreferencesData.get((String)"serial.port"));
        }
        g.setColor(this.background);
        Dimension size = this.getSize();
        g.fillRect(0, 0, size.width, size.height);
        g.setFont(this.font);
        g.setColor(this.foreground);
        int baseline = (size.height + g.getFontMetrics().getAscent()) / 2;
        g.drawString(this.text, Theme.scale(6), baseline);
        g.setColor(this.messageForeground);
        String tmp = I18n.format((String)I18n.tr((String)"{0} on {1}"), (Object[])new Object[]{this.name, this.serialport});
        Rectangle2D bounds = g.getFontMetrics().getStringBounds(tmp, null);
        g.drawString(tmp, size.width - (int)bounds.getWidth() - RESIZE_IMAGE_SIZE, baseline);
        if (OSUtils.isMacOS()) {
            g.drawImage(this.resize, size.width - RESIZE_IMAGE_SIZE, 0, this);
        }
    }

    public void setBoardName(String name) {
        this.name = name;
    }

    public void setSerialPort(String serialport) {
        this.serialport = serialport;
    }

    public void setSerialNumber(String serialnumber) {
        this.serialnumber = serialnumber;
    }

    @Override
    public Dimension getPreferredSize() {
        return Theme.scale(new Dimension(300, this.height));
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return Theme.scale(new Dimension(3000, this.height));
    }
}

